import { IAlarm } from '@aws-cdk/aws-cloudwatch';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
export interface DiscoveryProps {
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * The queue to post package updated messages to
     */
    readonly queue: IQueue;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
/**
 * This discovery function periodically scans the CouchDB replica of npmjs.com
 * to discover newly published packages that are relevant for indexing in the
 * Construct Hub, then notifies the ingestion function about those.
 */
export declare class Discovery extends Construct {
    /**
     * The S3 bucket in which the discovery function stages npm packages.
     */
    readonly bucket: IBucket;
    /**
     * Alarms if the discovery function does not complete successfully.
     */
    readonly alarmErrors: IAlarm;
    /**
     * Alarms if the discovery function does not run as expected.
     */
    readonly alarmNoInvocations: IAlarm;
    constructor(scope: Construct, id: string, props: DiscoveryProps);
}
