"use strict";
/*
 * IMPORTANT: This file is used both by bundled lambda functions and by
 * constructs. This means it should not directly or transitively import anything
 * not part of the package's `dependencies`, such as the `aws-sdk`.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.STAGED_KEY_PREFIX = exports.FAILED_KEY_PREFIX = exports.CATALOG_KEY = exports.assemblyKeySuffix = exports.ASSEMBLY_KEY_SUFFIX = exports.METADATA_KEY_SUFFIX = exports.PACKAGE_KEY_SUFFIX = exports.STORAGE_KEY_PREFIX = void 0;
/**
 * Key prefix for the package data storage.
 */
exports.STORAGE_KEY_PREFIX = 'data/';
/**
 * Key suffix for storing npm package bundles.
 */
exports.PACKAGE_KEY_SUFFIX = '/package.tgz';
/**
 * Key suffix for storing npm package metadata.
 */
exports.METADATA_KEY_SUFFIX = '/metadata.json';
/**
 * The key suffix for (TypeScript) assembly files
 */
exports.ASSEMBLY_KEY_SUFFIX = '/assembly.json';
/**
 * The key suffix for assemblies in the provided language. This should NOT be
 * used for the TypeScript/JavaScript assembly however.
 */
function assemblyKeySuffix(lang) {
    return `/assembly-${lang}.json`;
}
exports.assemblyKeySuffix = assemblyKeySuffix;
/**
 * The key for the catalog document.
 */
exports.CATALOG_KEY = 'catalog.json';
/**
 * Key prefix used by the built-in discovery function to store failed records.
 */
exports.FAILED_KEY_PREFIX = 'failed/';
/**
 * Key prefix used by the built-in discovery function to stage tarballs.
 */
exports.STAGED_KEY_PREFIX = 'staged/';
//# sourceMappingURL=data:application/json;base64,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