import { IAlarm } from '@aws-cdk/aws-cloudwatch';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { Bucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
export interface TransliteratorProps {
    /**
     * The bucket in which to source assemblies to transliterate.
     */
    readonly bucket: Bucket;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
/**
 * Transliterates jsii assemblies to various other languages.
 */
export declare class Transliterator extends Construct {
    /**
     * Alarms if the dead-letter-queue associated with the transliteration process
     * is not empty, meaning some packages failed transliteration and require
     * operator attention.
     */
    readonly alarmDeadLetterQueueNotEmpty: IAlarm;
    constructor(scope: Construct, id: string, props: TransliteratorProps);
}
