# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['bootloader',
 'bootloader.humantrainer',
 'bootloader.humantrainer.constant',
 'bootloader.humantrainer.model',
 'bootloader.humantrainer.utils']

package_data = \
{'': ['*']}

install_requires = \
['perseus-core-library>=1.18.21,<2.0.0']

setup_kwargs = {
    'name': 'bootloader-uassets-validator',
    'version': '0.0.1',
    'description': 'Human Trainer asset file names validator',
    'long_description': '# Unreal Engine Assets Validator Library\n\nCommand-line Interface (CLI) responsible for validating Unreal Engine asset files.\n\nA [`uasset` file](https://docs.unrealengine.com/5.1/en-US/assets-and-content-packs-in-unreal-engine/) is an asset file used by Unreal Editor. It contains an asset, such as a level, material, animation, sound, or particle system, used in an Unreal Engine game.  Any piece of content in an Unreal Engine project is an asset.\n\n## Overview\n\nAs you develop projects in Unreal Engine (UE), the list of Assets in your Content Browser will expand.  This runs the risk of creating redundant variations of assets you\'re experimenting with, or introducing ambiguity with overly similar names.  For example, it is possible for you to have a folder named "Soldier" with a Blueprint, a texture, and a model that all have the name "Soldier" in them, but no clear way to tell which is which in a simple list.\n\nFor large projects, Epic Games recommends you establish a [common naming convention](https://docs.unrealengine.com/5.1/en-US/recommended-asset-naming-conventions-in-unreal-engine-projects/) for individual Assets early in development.  This will make it easier for you and your team to locate files and prevent potential conflicts or ambiguity.\n\n```text\n[AssetTypePrefix]_[AssetName]_[Descriptor]_[OptionalVariantLetterOrNumber]\n```\n\n- `AssetTypePrefix` identifies the type of Asset, refer to the table below for details.\n- `AssetName` is the Asset\'s name.\n- `Descriptor` provides additional context for the Asset, to help identify how it is used. For example, whether a texture is a normal map or an opacity map.\n- `OptionalVariantLetterOrNumber` is optionally used to differentiate between multiple versions or variations of an asset.\n\nConsider using this naming convention for your own project\'s Assets, as it will provide multiple ways for your team to locate an Asset when searching the Content Browser.\n\n## Recommended Asset Prefixes\n\nThis list is not exhaustive, as new features can require new Asset types.  If you are using an Asset type not listed, use the existing list as a guideline for your naming convention for that Asset.\n\n| ASSET                                                                                                                         | PREFIX  |\n|-------------------------------------------------------------------------------------------------------------------------------|---------|\n| **General**                                                                                                                   |\n| [High Dynamic Range Image (HDRI)](https://docs.unrealengine.com/5.1/en-US/hdri-backdrop-visualization-tool-in-unreal-engine/) | `HDR_`  |\n| [Material](https://docs.unrealengine.com/5.1/en-US/unreal-engine-materials/)                                                  | `M_`    |\n| [Material Instance](https://docs.unrealengine.com/5.1/en-US/instanced-materials-in-unreal-engine/)                            | `MI_`   |\n| [Physics Asset](https://docs.unrealengine.com/5.1/en-US/physics-asset-editor-in-unreal-engine/)                               | `PHYS_` |\n| [Physics Material](https://docs.unrealengine.com/5.1/en-US/physical-materials-in-unreal-engine/)                              | `PM_`   |\n| [Post Process Material](https://docs.unrealengine.com/5.1/en-US/post-process-materials-in-unreal-engine/)                     | `PPM_`  |\n| [Skeletal Mesh](https://docs.unrealengine.com/5.1/en-US/skeletal-meshes/)                                                     | `SK_`   |\n| [Static Mesh](https://docs.unrealengine.com/5.1/en-US/static-meshes/)                                                         | `SM_`   |\n| [Texture](https://docs.unrealengine.com/5.1/en-US/textures-in-unreal-engine/)                                                 | `T_`    |\n| [OCIO Profile](https://docs.unrealengine.com/5.1/en-US/color-management-with-opencolorio-in-unreal-engine/)                   | `OCIO_` |\n| **[Blueprints](https://docs.unrealengine.com/5.1/en-US/blueprints-visual-scripting-in-unreal-engine/)**                       | \n| Actor Component                                                                                                               | `AC_`   |\n| Animation Blueprint                                                                                                           | `ABP_`  |\n| Blueprint Interface                                                                                                           | `BI_`   |\n| Blueprint                                                                                                                     | `BP_`   |\n| Curve Table                                                                                                                   | `CT_`   |\n| Data Table                                                                                                                    | `DT_`   |\n| Enum                                                                                                                          | `E_`    |\n| Structure                                                                                                                     | `F_`    |\n| Widget Blueprint                                                                                                              | `WBP_`  |\n| **[Particle Effects](https://docs.unrealengine.com/5.1/en-US/creating-visual-effects-in-niagara-for-unreal-engine/)**         |\n| Particle System (Cascade)                                                                                                     | `PS_`   |\n| Niagara Emitter                                                                                                               | `FXE_`  |\n| Niagara System                                                                                                                | `FXS_`  |\n| Niagara Function                                                                                                              | `FXF_`  |\n| **[Skeletal Mesh Animations](https://docs.unrealengine.com/5.1/en-US/skeletal-mesh-animation-system-in-unreal-engine/)**      |\n| Rig                                                                                                                           | `Rig_`  |\n| Skeleton                                                                                                                      | `SKEL_` |\n| Montages                                                                                                                      | `AM_`   |\n| Animation Sequence                                                                                                            | `AS_`   |\n| Blend Space                                                                                                                   | `BS_`   |\n| **[In-Camera VFX](https://docs.unrealengine.com/5.1/en-US/in-camera-vfx-in-unreal-engine/)**                                  |\n| NDisplay Configuration                                                                                                        | `NDC_`  |\n| **[Animation](https://docs.unrealengine.com/5.1/en-US/cinematics-and-movie-making-in-unreal-engine/)**                        |\n| Level Sequence                                                                                                                | `LS_`   |\n| Sequencer Edits                                                                                                               | `EDIT_` |\n| **[Media](https://docs.unrealengine.com/5.1/en-US/media-framework-in-unreal-engine/)**                                        |\n| Media Source                                                                                                                  | `MS_`   |\n| Media Output                                                                                                                  | `MO_`   |\n| Media Player                                                                                                                  | `MP_`   | \n| Media Profile                                                                                                                 | `MPR_`  |\n| **Other**                                                                                                                     |\n| [Level Snapshots](https://docs.unrealengine.com/5.1/en-US/level-snapshots-in-unreal-engine/)                                  | `SNAP_` |\n| [Remote Control Preset](https://docs.unrealengine.com/5.1/en-US/remote-control-for-unreal-engine/)                            | `RCP_`  |\n\n## Installation\n\n```shell\npoetry install\npoetry shell\n```\n\n## Execution\n\n```shell\n./validate.py --path ~/path/to/human/trainer/assets/root/folder\n```\n\n## Distribution\n\n```shell\npoetry shell\npoetry publish --build --username $PYPI_USERNAME --password $PYPI_PASSWORD\n```',
    'author': 'Daniel CAUNE',
    'author_email': 'daniel.caune@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Bootloader-Studio/draft-tool-asset-validator',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
