import { CodePipeline, CodePipelineProps, ShellStepProps } from "aws-cdk-lib/pipelines";
import { Construct } from "constructs";
/**
 * Properties to configure the PDKPipeline.
 *
 * Note: Due to limitations with JSII and generic support it should be noted that
 * the synth, synthShellStepPartialProps.input and
 * synthShellStepPartialProps.primaryOutputDirectory properties will be ignored
 * if passed in to this construct.
 *
 * synthShellStepPartialProps.commands is marked as a required field, however
 * if you pass in [] the default commands of this construct will be retained.
 */
export interface PDKPipelineProps extends CodePipelineProps {
    /**
     * Enables a build job to trigger on PR merges to the defaultBranchName. This
     * will automatically build the codebase and add an Approval to the PR on
     * successful build.
     *
     * @default true
     */
    readonly prBuildChecker?: boolean;
    /**
     * Name of the CodeCommit repository to create.
     */
    readonly repositoryName: string;
    /**
     * Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.
     */
    readonly primarySynthDirectory: string;
    /**
     * PDKPipeline by default assumes a NX Monorepo structure for it's codebase and
     * uses sane defaults for the install and run commands. To override these defaults
     * and/or provide additional inputs, specify env settings, etc you can provide
     * a partial ShellStepProps.
     */
    readonly synthShellStepPartialProps?: ShellStepProps;
    /**
     * Branch to trigger the pipeline execution.
     *
     * @default mainline
     */
    readonly defaultBranchName?: string;
}
/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo
 * codebase. In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
export declare class PDKPipeline extends CodePipeline {
    private readonly codeRepository;
    constructor(scope: Construct, id: string, props: PDKPipelineProps);
}
