# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['sqlalchemy_declarative_extensions',
 'sqlalchemy_declarative_extensions.alembic',
 'sqlalchemy_declarative_extensions.grant',
 'sqlalchemy_declarative_extensions.grant.postgresql',
 'sqlalchemy_declarative_extensions.role',
 'sqlalchemy_declarative_extensions.row',
 'sqlalchemy_declarative_extensions.schema']

package_data = \
{'': ['*']}

install_requires = \
['sqlalchemy>=1.3']

extras_require = \
{':python_version < "3.11"': ['typing_extensions>=4.0']}

setup_kwargs = {
    'name': 'sqlalchemy-declarative-extensions',
    'version': '0.1.0',
    'description': 'Library to declare additional kinds of objects not natively supported by SqlAlchemy/Alembic.',
    'long_description': '# SqlAlchemy Declarative Extensions\n\n[![Actions Status](https://github.com/dancardin/sqlalchemy-declarative-extensions/workflows/test/badge.svg)](https://github.com/dancardin/sqlalchemy-declarative-extensions/actions) [![Coverage Status](https://coveralls.io/repos/github/DanCardin/sqlalchemy-declarative-extensions/badge.svg?branch=main)](https://coveralls.io/github/DanCardin/sqlalchemy-declarative-extensions?branch=main) [![Documentation Status](https://readthedocs.org/projects/sqlalchemy-declarative-extensions/badge/?version=latest)](https://sqlalchemy-declarative-extensions.readthedocs.io/en/latest/?badge=latest)\n\nSee the full documentation [here](https://readthedocs.org/projects/sqlalchemy-declarative-extensions).\n\nAdds extensions to SqlAlchemy (and/or Alembic) which allows declaratively\nstating the existence of additional kinds of objects about your database\nnot natively supported by SqlAlchemy/Alembic.\n\nThis includes:\n\n- Schemas\n- Roles\n- Privileges\n- Rows (i.e. data)\n\nThe primary function(s) of this library include:\n\n- Registering onto the SqlAlchemy event system such that `metadata.create_all`\n  creates these objects.\n- (Optionally) Registers into Alembic such that `alembic revision --autogenerate`\n  automatically creates/updates/deletes declared objects.\n\n## Example Usage\n\n```python\nfrom sqlalchemy import Column, types\nfrom sqlalchemy.orm import as_declarative\nfrom sqlalchemy_declarative_extensions import (\n    declarative_database, Schemas, Roles, Role, Grants, Grant, Rows, Row\n)\n\n@declarative_database\n@as_declarative\nclass Base:\n    schemas = Schemas().are("example")\n    roles = Roles(ignore_unspecified=True).are(\n        PGRole("read", login=False),\n        PGRole(\n            "app",\n            in_roles=[\'read\']\n        ),\n    )\n    grants = Grants().are(\n        Grant("read").grant("select").default().on_tables_in_schema("public", \'example\'),\n        Grant("app").grant("insert", "update", "delete").default().on_tables_in_schema("public"),\n    )\n    rows = Rows().are(\n        Row(\'foo\', id=1),\n    )\n\n\nclass Foo(Base):\n    __tablename__ = \'foo\'\n\n    id = Column(types.Integer(), primary_key=True)\n```\n\nNote, there is also support for declaring objects directly through the `MetaData` for\nusers not using sqlalchemy\'s declarative API.\n\n## Database support\n\nIn principle, this library **can** absolutely support any database supported by SqlAlchemy,\nand capable of being introspected enough to support detection of different kinds of objects.\n\nIn reality, the implementations are going to be purely driven by actual usage. The\ncurrent maintainer(s) primarily use PostgreSQL and as such individual features for\nother databases will either suffer or lack implementation.\n\nAs much as possible, objects will be defined in a database-agnostic way, and the comparison\ninfrastructure should be the sole difference. However databases engines are not the same, and\ncertain kinds of objects, like GRANTs, are inherently database engine specific, and there\'s\nnot much common ground between a PostgreSQL grant and a MySQL one. As such, they will\ninclude database specific objects.\n\n## Alembic-utils\n\nCurrently, the set of supported declarative objects is essentially non-overlapping with\n[Alembic-utils](https://github.com/olirice/alembic_utils). However in principle, there\'s\nno reason that objects supported by this library couldn\'t begin to overlap (views, functions,\ntriggers); and one might begin to question when to use which library.\n\nFirst, it\'s likely that this library can/should grow handlers for objects already supported by\nalembic-utils. In particular, it\'s likely that any future support in this library for something\nlike a view could easily accept an `alembic_utils.pg_view.PGView` definition and handle it directly.\nThe two libraries are likely fairly complementary in that way, although it\'s important to note\nsome of the differences.\n\nAlembic utils:\n\n- Is more directly tied to Alembic and specifically provides functionality for autogenerating\n  DDL for alembic, as the name might imply. It does **not** register into sqlalchemy\'s event\n  system.\n- Requires one to explicitly find/include the objects one wants to track with alembic.\n- It provides direct translation of individual entities (like a single, specific `PGGrantTable`).\n- In most cases, it appears to define a very "literal" interface (for example, `PGView` accepts\n  the whole view definition as a raw literal string), rather than an abstracted one.\n\nBy contrast, this library:\n\n- SqlAlchemy is the main dependency and registration point. The primary function of the library\n  is to register into sqlalchemy\'s event system to ensure that a `metadata.create_all` performs\n  the requisite statements to ensure the state of the database matches the declaration.\n\n  This library does **not** require alembic, but it does (optionally) perform a similar function\n  by way of enabling autogeneration support for non-native objects.\n\n- Perhaps a technical detail, but this library registers the declaratively stated objects directly\n  on the metadata/declarative-base. This allows the library to automatically know the intended\n  state of the world, rather than needing to discover objects.\n- The intended purpose of the supported objects is to declare what the state of the world **should**\n  look like. Therefore the function of this library includes the (optional) **removal** of objects\n  detected to exist which are not declared (much like alembic does for tables). Whereas alembic-utils\n  only operates on objects you create entities for.\n- As much as possible, this library provides more abstracted interfaces for defining objects.\n  This is particularly important for objects like roles/grants where not every operation is a create\n  or delete (in contrast to something like a view).\n',
    'author': 'Dan Cardin',
    'author_email': 'ddcardin@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/dancardin/sqlalchemy-declarative-extensions',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
