# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mux_python.api_client import ApiClient
from mux_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PlaybackRestrictionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_playback_restriction(self, create_playback_restriction_request, **kwargs):  # noqa: E501
        """Create a Playback Restriction  # noqa: E501

        Create a new Playback Restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_playback_restriction(create_playback_restriction_request, async_req=True)
        >>> result = thread.get()

        :param create_playback_restriction_request: (required)
        :type create_playback_restriction_request: CreatePlaybackRestrictionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PlaybackRestrictionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_playback_restriction_with_http_info(create_playback_restriction_request, **kwargs)  # noqa: E501

    def create_playback_restriction_with_http_info(self, create_playback_restriction_request, **kwargs):  # noqa: E501
        """Create a Playback Restriction  # noqa: E501

        Create a new Playback Restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_playback_restriction_with_http_info(create_playback_restriction_request, async_req=True)
        >>> result = thread.get()

        :param create_playback_restriction_request: (required)
        :type create_playback_restriction_request: CreatePlaybackRestrictionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PlaybackRestrictionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_playback_restriction_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_playback_restriction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_playback_restriction_request' is set
        if self.api_client.client_side_validation and ('create_playback_restriction_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_playback_restriction_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_playback_restriction_request` when calling `create_playback_restriction`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_playback_restriction_request' in local_var_params:
            body_params = local_var_params['create_playback_restriction_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "PlaybackRestrictionResponse",
        }

        return self.api_client.call_api(
            '/video/v1/playback-restrictions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_playback_restriction(self, playback_restriction_id, **kwargs):  # noqa: E501
        """Delete a Playback Restriction  # noqa: E501

        Deletes a single Playback Restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_playback_restriction(playback_restriction_id, async_req=True)
        >>> result = thread.get()

        :param playback_restriction_id: ID of the Playback Restriction. (required)
        :type playback_restriction_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_playback_restriction_with_http_info(playback_restriction_id, **kwargs)  # noqa: E501

    def delete_playback_restriction_with_http_info(self, playback_restriction_id, **kwargs):  # noqa: E501
        """Delete a Playback Restriction  # noqa: E501

        Deletes a single Playback Restriction.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_playback_restriction_with_http_info(playback_restriction_id, async_req=True)
        >>> result = thread.get()

        :param playback_restriction_id: ID of the Playback Restriction. (required)
        :type playback_restriction_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'playback_restriction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_playback_restriction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'playback_restriction_id' is set
        if self.api_client.client_side_validation and ('playback_restriction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_restriction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_restriction_id` when calling `delete_playback_restriction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'playback_restriction_id' in local_var_params:
            path_params['PLAYBACK_RESTRICTION_ID'] = local_var_params['playback_restriction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/playback-restrictions/{PLAYBACK_RESTRICTION_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_playback_restriction(self, playback_restriction_id, **kwargs):  # noqa: E501
        """Retrieve a Playback Restriction  # noqa: E501

        Retrieves a Playback Restriction associated with the unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_playback_restriction(playback_restriction_id, async_req=True)
        >>> result = thread.get()

        :param playback_restriction_id: ID of the Playback Restriction. (required)
        :type playback_restriction_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PlaybackRestrictionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_playback_restriction_with_http_info(playback_restriction_id, **kwargs)  # noqa: E501

    def get_playback_restriction_with_http_info(self, playback_restriction_id, **kwargs):  # noqa: E501
        """Retrieve a Playback Restriction  # noqa: E501

        Retrieves a Playback Restriction associated with the unique identifier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_playback_restriction_with_http_info(playback_restriction_id, async_req=True)
        >>> result = thread.get()

        :param playback_restriction_id: ID of the Playback Restriction. (required)
        :type playback_restriction_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PlaybackRestrictionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'playback_restriction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_playback_restriction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'playback_restriction_id' is set
        if self.api_client.client_side_validation and ('playback_restriction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_restriction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_restriction_id` when calling `get_playback_restriction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'playback_restriction_id' in local_var_params:
            path_params['PLAYBACK_RESTRICTION_ID'] = local_var_params['playback_restriction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "PlaybackRestrictionResponse",
        }

        return self.api_client.call_api(
            '/video/v1/playback-restrictions/{PLAYBACK_RESTRICTION_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_playback_restrictions(self, **kwargs):  # noqa: E501
        """List Playback Restrictions  # noqa: E501

        Returns a list of all Playback Restrictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_playback_restrictions(async_req=True)
        >>> result = thread.get()

        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param limit: Number of items to include in the response
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListPlaybackRestrictionsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_playback_restrictions_with_http_info(**kwargs)  # noqa: E501

    def list_playback_restrictions_with_http_info(self, **kwargs):  # noqa: E501
        """List Playback Restrictions  # noqa: E501

        Returns a list of all Playback Restrictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_playback_restrictions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param limit: Number of items to include in the response
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListPlaybackRestrictionsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'page',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_playback_restrictions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListPlaybackRestrictionsResponse",
        }

        return self.api_client.call_api(
            '/video/v1/playback-restrictions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_referrer_domain_restriction(self, playback_restriction_id, update_referrer_domain_restriction_request, **kwargs):  # noqa: E501
        """Update the Referrer Playback Restriction  # noqa: E501

        Allows you to modify the list of domains or change how Mux validates playback requests without the `Referer` HTTP header. The Referrer restriction fully replaces the old list with this new list of domains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_referrer_domain_restriction(playback_restriction_id, update_referrer_domain_restriction_request, async_req=True)
        >>> result = thread.get()

        :param playback_restriction_id: ID of the Playback Restriction. (required)
        :type playback_restriction_id: str
        :param update_referrer_domain_restriction_request: (required)
        :type update_referrer_domain_restriction_request: UpdateReferrerDomainRestrictionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PlaybackRestrictionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_referrer_domain_restriction_with_http_info(playback_restriction_id, update_referrer_domain_restriction_request, **kwargs)  # noqa: E501

    def update_referrer_domain_restriction_with_http_info(self, playback_restriction_id, update_referrer_domain_restriction_request, **kwargs):  # noqa: E501
        """Update the Referrer Playback Restriction  # noqa: E501

        Allows you to modify the list of domains or change how Mux validates playback requests without the `Referer` HTTP header. The Referrer restriction fully replaces the old list with this new list of domains.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_referrer_domain_restriction_with_http_info(playback_restriction_id, update_referrer_domain_restriction_request, async_req=True)
        >>> result = thread.get()

        :param playback_restriction_id: ID of the Playback Restriction. (required)
        :type playback_restriction_id: str
        :param update_referrer_domain_restriction_request: (required)
        :type update_referrer_domain_restriction_request: UpdateReferrerDomainRestrictionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PlaybackRestrictionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'playback_restriction_id',
            'update_referrer_domain_restriction_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_referrer_domain_restriction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'playback_restriction_id' is set
        if self.api_client.client_side_validation and ('playback_restriction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_restriction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_restriction_id` when calling `update_referrer_domain_restriction`")  # noqa: E501
        # verify the required parameter 'update_referrer_domain_restriction_request' is set
        if self.api_client.client_side_validation and ('update_referrer_domain_restriction_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_referrer_domain_restriction_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_referrer_domain_restriction_request` when calling `update_referrer_domain_restriction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'playback_restriction_id' in local_var_params:
            path_params['PLAYBACK_RESTRICTION_ID'] = local_var_params['playback_restriction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_referrer_domain_restriction_request' in local_var_params:
            body_params = local_var_params['update_referrer_domain_restriction_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "PlaybackRestrictionResponse",
        }

        return self.api_client.call_api(
            '/video/v1/playback-restrictions/{PLAYBACK_RESTRICTION_ID}/referrer', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
