/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.BarcodeClassifications;
import com.aspose.barcode.EncodeTypes;
import com.aspose.barcode.SymbologyEncodeType;
import com.aspose.python.barcode.internal.dq.cm;
import com.aspose.python.barcode.internal.dq.cr;
import com.aspose.python.barcode.internal.ed.h;

@cm
public class BaseEncodeType {
    private short a;
    private String b;
    private final BarcodeClassifications c;

    protected BaseEncodeType(short typeIndex, String typeName, BarcodeClassifications classification) {
        this.a = typeIndex;
        this.b = typeName;
        this.c = classification;
    }

    @Deprecated
    protected BaseEncodeType(short typeIndex, String typeName, int classification) {
        this(typeIndex, typeName, BarcodeClassifications.values()[classification]);
    }

    private BaseEncodeType() {
        this.c = BarcodeClassifications.NONE;
    }

    public short getTypeIndex() {
        return this.a;
    }

    public String getTypeName() {
        return this.b;
    }

    public BarcodeClassifications getClassification() {
        return this.c;
    }

    public String toString() {
        return this.b;
    }

    public String getString() {
        return cr.a(h.d(), "Index:{0}; Name:{1}", this.a, this.b);
    }

    public static String getString(BaseEncodeType instance) {
        if (instance != null) {
            return instance.getString();
        }
        return cr.a;
    }

    public static boolean tryParse(String parsingType, BaseEncodeType[] result) {
        if (EncodeTypes.parse(parsingType, result)) {
            return true;
        }
        boolean bl2 = EncodeTypes.tryParse(parsingType, result);
        return bl2;
    }

    public static boolean tryParse(String parsingType, SymbologyEncodeType[] result) {
        BaseEncodeType baseEncodeType = null;
        BaseEncodeType[] baseEncodeTypeArray = new BaseEncodeType[]{baseEncodeType};
        boolean bl2 = EncodeTypes.tryParse(parsingType, baseEncodeTypeArray);
        baseEncodeType = baseEncodeTypeArray[0];
        result[0] = (SymbologyEncodeType)baseEncodeType;
        return bl2;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BaseEncodeType)) {
            return false;
        }
        BaseEncodeType baseEncodeType = (BaseEncodeType)other;
        return this.getTypeIndex() == baseEncodeType.getTypeIndex() && cr.e(this.getTypeName(), baseEncodeType.getTypeName());
    }

    public int hashCode() {
        return this.getTypeIndex() ^ 0x25 ^ this.getTypeName().hashCode();
    }

    public static BaseEncodeType parse(String stringEncodeType) {
        if (stringEncodeType == null || stringEncodeType.length() < 1) {
            throw new BarCodeException("Encode type cannot be empty");
        }
        BaseEncodeType baseEncodeType = null;
        BaseEncodeType[] baseEncodeTypeArray = new BaseEncodeType[]{baseEncodeType};
        EncodeTypes.parse(stringEncodeType, baseEncodeTypeArray);
        baseEncodeType = baseEncodeTypeArray[0];
        return baseEncodeType;
    }
}

