# Generated by Django 3.0.9 on 2020-12-11 09:25

import datetime
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.contrib.taggit
import modelcluster.fields
import uuid
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.images.blocks
import wagtail.search.index
import wagtail.snippets.blocks
import wagtailsvg.blocks
import webunity.cms.forms.abstract
import webunity.cms.pages._mixins


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('taggit', '0003_taggeditem_add_unique_index'),
        ('wagtailimages', '0022_uploadedimage'),
        ('wagtaildocs', '0010_document_file_hash'),
        ('wagtailsvg', '0002_svg_edit_code'),
        ('wagtailcore', '0059_apply_collection_ordering'),
    ]

    operations = [
        migrations.CreateModel(
            name='Form',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translation_key', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('help_text', models.CharField(blank=True, default='', max_length=100, verbose_name='Nom du formulaire')),
                ('text', wagtail.core.fields.RichTextField(blank=True, default='', verbose_name='Texte avant le formulaire')),
                ('text_align', models.CharField(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], default='left', help_text='Permet de changer le theme', max_length=100)),
                ('inline', models.BooleanField(default=False)),
                ('button_text', models.CharField(blank=True, default='Submit', max_length=250, verbose_name='Bouton text')),
                ('button_theme', models.CharField(blank=True, choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], default='primary-full', max_length=250, verbose_name='Bouton theme')),
                ('redirection_url', models.CharField(blank=True, default='', max_length=250, verbose_name='Url de redirection')),
                ('animation', models.BooleanField(default=False)),
                ('actions', wagtail.core.fields.StreamField([('email', wagtail.core.blocks.StructBlock([('email_receiver', wagtail.core.blocks.CharBlock(required=False))]))], blank=True)),
                ('locale', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='wagtailcore.Locale')),
                ('redirection_page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailcore.Page', verbose_name='Page de redirection après un formulaire validé')),
            ],
            options={
                'abstract': False,
                'unique_together': {('translation_key', 'locale')},
            },
        ),
        migrations.CreateModel(
            name='Gallery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('help_text', models.CharField(blank=True, default='', max_length=100)),
                ('medias', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=(wagtail.search.index.Indexed, models.Model),
        ),
        migrations.CreateModel(
            name='GenericPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('theme', models.CharField(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], default='space', help_text='Permet de changer le theme du header et du footer', max_length=100)),
                ('breadcrumb', models.BooleanField(default=True, help_text='Ajoute la page dans le sitemap et génère un schéma Breadcrumb', verbose_name='Public pour Google')),
                ('schemas', wagtail.core.fields.StreamField([('how_to', wagtail.core.blocks.StructBlock([('name', wagtail.core.blocks.CharBlock(required=True)), ('description', wagtail.core.blocks.CharBlock(required=True)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=True)), ('total_time', wagtail.core.blocks.CharBlock(required=True)), ('tool', wagtail.core.blocks.CharBlock(required=True)), ('supply', wagtail.core.blocks.CharBlock(required=True)), ('step', wagtail.core.blocks.StreamBlock([('step', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=True)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('name', wagtail.core.blocks.CharBlock(required=True)), ('url', wagtail.core.blocks.URLBlock(required=False))]))]))])), ('faq_page', wagtail.core.blocks.StructBlock([('questions', wagtail.core.blocks.StreamBlock([('questions', wagtail.core.blocks.StructBlock([('question', wagtail.core.blocks.CharBlock(required=True)), ('answer', wagtail.core.blocks.CharBlock(required=True))]))]))]))], blank=True)),
                ('keywords', models.CharField(blank=True, default='', max_length=100)),
                ('body', wagtail.core.fields.StreamField([('svg', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('svg', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))])), ('image', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))])), ('text', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('align', wagtail.core.blocks.ChoiceBlock(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], required=False)), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))]))])), ('cards', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('theme_reverse', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('theme_content', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('carousel', wagtail.core.blocks.BooleanBlock(required=False)), ('cards', wagtail.core.blocks.StreamBlock([('custom', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))])), ('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(label='Button link', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Button Page', required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, label='Button nouvel onglet', required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], label='Button type', required=False))])), ('icon', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))], label='Icon')), ('media', wagtail.core.blocks.StreamBlock([('svg', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))], max_num=1, required=False))])), ('person', wagtail.core.blocks.StructBlock([('person', wagtail.snippets.blocks.SnippetChooserBlock('cms.Person', required=True))])), ('review', wagtail.core.blocks.StructBlock([('score', wagtail.core.blocks.IntegerBlock()), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))])), ('media', wagtail.core.blocks.StreamBlock([('svg', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))], max_num=1, required=False))])), ('stream', wagtail.core.blocks.StructBlock([('streams', wagtail.core.blocks.StreamBlock([('svg', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))])), ('icon_text', wagtail.core.blocks.StructBlock([('icon', wagtail.snippets.blocks.SnippetChooserBlock('cms.IconSnippet', required=True)), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))]))]))], required=False))]))], min_num=1))])), ('component_text', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('titles', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))], label='Titres')), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))], label='Description')), ('reverse', wagtail.core.blocks.BooleanBlock(help_text="Permet de d'intervertir le component et la zone de texte", required=False)), ('section', wagtail.core.blocks.BooleanBlock(help_text='Permet de sectionner la zone de texte', required=False)), ('animation', wagtail.core.blocks.BooleanBlock(help_text='Animation', required=False)), ('align', wagtail.core.blocks.ChoiceBlock(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], required=False)), ('component', wagtail.core.blocks.StreamBlock([('svg', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('embed', wagtail.core.blocks.StructBlock([('link', wagtail.core.blocks.URLBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('form', wagtail.core.blocks.StructBlock([('form', wagtail.snippets.blocks.SnippetChooserBlock('cms.Form', required=True))])), ('gallery_slider', wagtail.core.blocks.StructBlock([('gallery', wagtail.snippets.blocks.SnippetChooserBlock('cms.Gallery', required=True))]))], max_num=1, required=False)), ('buttons', wagtail.core.blocks.StreamBlock([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(label='Button link', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Button Page', required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, label='Button nouvel onglet', required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], label='Button type', required=False))]))], max_num=2, required=False))])), ('grid_info', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('infos', wagtail.core.blocks.StreamBlock([('svg_info', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False)), ('title', wagtail.core.blocks.CharBlock()), ('text_hover', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))]))])), ('image_info', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False)), ('title', wagtail.core.blocks.CharBlock()), ('text_hover', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))]))]))], min_num=1))])), ('medias_line', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('medias', wagtail.core.blocks.StreamBlock([('svg_label', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('label', wagtail.core.blocks.CharBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False))])), ('image_label', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('label', wagtail.core.blocks.CharBlock(required=False)), ('page', wagtail.core.blocks.PageChooserBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(required=False))]))], min_num=1))])), ('timeline', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('animation', wagtail.core.blocks.BooleanBlock(help_text='Animation', required=False)), ('items', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))])), ('custom', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False)), ('icon', wagtail.snippets.blocks.SnippetChooserBlock('cms.IconSnippet', required=True)), ('buttons', wagtail.core.blocks.StreamBlock([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(label='Button link', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Button Page', required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, label='Button nouvel onglet', required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], label='Button type', required=False))]))], max_num=3, required=False))]))], min_num=1))])), ('buttons', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('align', wagtail.core.blocks.ChoiceBlock(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], required=False)), ('buttons', wagtail.core.blocks.StreamBlock([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(label='Button link', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Button Page', required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, label='Button nouvel onglet', required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], label='Button type', required=False))]))]))])), ('calendly', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('link', wagtail.core.blocks.URLBlock(required=False))])), ('articles', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('articles', wagtail.core.blocks.StreamBlock([('article', wagtail.core.blocks.PageChooserBlock(page_type=['cms.BlogPage'], required=False))], min_num=1))])), ('embed', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('animation', wagtail.core.blocks.BooleanBlock(help_text='Animation', required=False)), ('embed', wagtail.core.blocks.StructBlock([('link', wagtail.core.blocks.URLBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))]))])), ('table', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('rows', wagtail.core.blocks.StreamBlock([('cells', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))])), ('svg', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False))]))], min_num=1))], min_num=1))])), ('accordion', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('items', wagtail.core.blocks.StreamBlock([('classic', wagtail.core.blocks.StructBlock([('head', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))], label='Head')), ('content', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))], label='Head'))]))], min_num=1))])), ('numbers', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('items', wagtail.core.blocks.StreamBlock([('classic', wagtail.core.blocks.StructBlock([('number', wagtail.core.blocks.IntegerBlock(required=True)), ('unit', wagtail.core.blocks.CharBlock(help_text='unité de mesure', required=False)), ('content', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))], label='Content'))]))], min_num=1))])), ('form', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('theme_reverse', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('theme_content', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('form', wagtail.core.blocks.StructBlock([('form', wagtail.snippets.blocks.SnippetChooserBlock('cms.Form', required=True))]))])), ('gallery', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('gallery', wagtail.core.blocks.StructBlock([('gallery', wagtail.snippets.blocks.SnippetChooserBlock('cms.Gallery', required=True))]))])), ('gallery_slider', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('gallery', wagtail.core.blocks.StructBlock([('gallery', wagtail.snippets.blocks.SnippetChooserBlock('cms.Gallery', required=True))]))])), ('stream_content', wagtail.core.blocks.StructBlock([('bg_desktop', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_mobile', wagtail.core.blocks.StreamBlock([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], max_num=5, required=False)), ('bg_layer', wagtail.core.blocks.BooleanBlock(default=False, required=False)), ('theme', wagtail.core.blocks.ChoiceBlock(choices=[('space', 'Primary'), ('space-inverse', 'Primary Inverse'), ('light', 'Secondary')], required=False)), ('animation', wagtail.core.blocks.BooleanBlock(help_text='Animation', required=False)), ('align', wagtail.core.blocks.ChoiceBlock(choices=[(None, 'Unset'), ('left', 'Left'), ('center', 'Center'), ('right', 'Right'), ('justify', 'Justify')], required=False)), ('content', wagtail.core.blocks.StreamBlock([('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))])), ('buttons', wagtail.core.blocks.StreamBlock([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(label='Button link', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Button Page', required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, label='Button nouvel onglet', required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], label='Button type', required=False))]))])), ('form', wagtail.core.blocks.StructBlock([('form', wagtail.snippets.blocks.SnippetChooserBlock('cms.Form', required=True))]))], required=False))]))], blank=True)),
                ('feed_image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='SEO - Image')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translation_key', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('help_text', models.CharField(blank=True, default='', max_length=100)),
                ('title', models.CharField(max_length=100)),
                ('locale', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='wagtailcore.Locale')),
            ],
            options={
                'abstract': False,
                'unique_together': {('translation_key', 'locale')},
            },
        ),
        migrations.CreateModel(
            name='BlogIndexPage',
            fields=[
                ('genericpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.GenericPage')),
                ('bg_desktop', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], blank=True)),
                ('bg_mobile', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], blank=True)),
                ('heading', wagtail.core.fields.RichTextField(blank=True, default='')),
                ('summary_text', wagtail.core.fields.RichTextField(blank=True, default='', help_text="Text qui apparait en haut du sommaire d'un article")),
                ('related_articles_text', wagtail.core.fields.RichTextField(blank=True, default='', help_text='Text qui apparait en haut des articles en lien')),
                ('button_view_all_articles', models.CharField(blank=True, default='', max_length=100)),
                ('social_share_text', wagtail.core.fields.RichTextField(blank=True, default='', help_text='Text qui apparait sur un block Social Share')),
            ],
            options={
                'abstract': False,
            },
            bases=(webunity.cms.pages._mixins.TagMixin, webunity.cms.forms.abstract.FormMixin, 'cms.genericpage', models.Model),
        ),
        migrations.CreateModel(
            name='BlogPage',
            fields=[
                ('genericpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.GenericPage')),
                ('cover', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], blank=True)),
                ('bg_desktop', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], blank=True)),
                ('bg_mobile', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock()), ('svg', wagtailsvg.blocks.SvgChooserBlock())], blank=True)),
                ('date', models.DateTimeField(default=datetime.date.today, verbose_name='Date publication + tri')),
                ('date_updated', models.DateTimeField(blank=True, default=None, null=True, verbose_name='Date mise à jour')),
                ('intro', models.CharField(blank=True, default='', help_text="Texte d'introduction qui s'affiche sur un block article de présentation", max_length=500)),
                ('intro_page', wagtail.core.fields.RichTextField(blank=True, default='', help_text="Texte qui s'affiche sur un la page de l'article")),
                ('h1', models.CharField(blank=True, default='', max_length=200, verbose_name='Titre intro')),
                ('related_blogs', wagtail.core.fields.StreamField([('article', wagtail.core.blocks.PageChooserBlock(page_type=['cms.BlogPage'], required=False))], blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=(webunity.cms.forms.abstract.FormMixin, 'cms.genericpage', models.Model),
        ),
        migrations.CreateModel(
            name='ContentPage',
            fields=[
                ('genericpage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cms.GenericPage')),
            ],
            options={
                'abstract': False,
            },
            bases=(webunity.cms.forms.abstract.FormMixin, 'cms.genericpage', models.Model),
        ),
        migrations.CreateModel(
            name='WebspaceSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('facebook', models.URLField(blank=True, help_text='Facebook page URL')),
                ('instagram', models.URLField(blank=True, help_text='Instagram page URL')),
                ('linkedin', models.URLField(blank=True, help_text='Linkedin page URL')),
                ('twitter', models.URLField(blank=True, help_text='Twitter page URL')),
                ('pinterest', models.URLField(blank=True, help_text='Pinterest page URL')),
                ('youtube', models.URLField(blank=True, help_text='Youtube page URL')),
                ('brand_name', models.CharField(blank=True, default='', max_length=100)),
                ('brand_short_name', models.CharField(blank=True, default='', max_length=100)),
                ('brand_description', models.TextField(blank=True, default='')),
                ('primary_color_uks', models.CharField(blank=True, default='', max_length=20)),
                ('primary_bg_color', models.CharField(blank=True, default='', max_length=20)),
                ('primary_inverse_color_uks', models.CharField(blank=True, default='', max_length=20)),
                ('primary_inverse_bg_color', models.CharField(blank=True, default='', max_length=20)),
                ('secondary_color_uks', models.CharField(blank=True, default='', max_length=20)),
                ('secondary_bg_color', models.CharField(blank=True, default='', max_length=20)),
                ('secondary_inverse_color_uks', models.CharField(blank=True, default='', max_length=20)),
                ('secondary_inverse_bg_color', models.CharField(blank=True, default='', max_length=20)),
                ('logo_header_primary', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock(label='Image - ratio 200x55')), ('svg', wagtailsvg.blocks.SvgChooserBlock(label='Svg - ratio 200x55'))], blank=True)),
                ('logo_header_secondary', wagtail.core.fields.StreamField([('image', wagtail.images.blocks.ImageChooserBlock(label='Image - ratio 200x55')), ('svg', wagtailsvg.blocks.SvgChooserBlock(label='Svg - ratio 200x55'))], blank=True)),
                ('ga_code', models.CharField(blank=True, default='', help_text='Google Analytics - Code de suivis', max_length=100)),
                ('vat_id', models.CharField(blank=True, default='', max_length=100)),
                ('legal_name', models.CharField(blank=True, default='', max_length=100)),
                ('founding_date', models.DateField(blank=True, default=None, null=True)),
                ('contact_phone', models.CharField(blank=True, default='', max_length=100)),
                ('contact_email', models.CharField(blank=True, default='', max_length=100)),
                ('area_served', models.CharField(blank=True, default='', max_length=100)),
                ('location_street_address', models.CharField(blank=True, default='', max_length=100)),
                ('location_address_locality', models.CharField(blank=True, default='', max_length=100)),
                ('location_postal_code', models.CharField(blank=True, default='', max_length=100)),
                ('location_address_country', models.CharField(blank=True, default='', max_length=100)),
                ('founding_location', models.CharField(blank=True, default='', max_length=100)),
                ('favicon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Favicon')),
                ('logo_schema', models.ForeignKey(blank=True, help_text='Logo pour les Schemas Google', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Logo Entreprise')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.Site')),
            ],
            options={
                'verbose_name': 'Base',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Navigation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translation_key', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('help_text', models.CharField(blank=True, default='', max_length=100)),
                ('footer', wagtail.core.fields.StreamField([('menu', wagtail.snippets.blocks.SnippetChooserBlock('cms.Menu', required=False)), ('stream_card', wagtail.core.blocks.StructBlock([('streams', wagtail.core.blocks.StreamBlock([('svg', wagtail.core.blocks.StructBlock([('file', wagtailsvg.blocks.SvgChooserBlock(required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('image', wagtail.core.blocks.StructBlock([('file', wagtail.images.blocks.ImageChooserBlock(label='Image 500x500', required=False)), ('size', wagtail.core.blocks.ChoiceBlock(choices=[('xs', 'XS'), ('s', 'S'), ('m', 'M'), ('l', 'L'), ('x', 'X'), ('xl', 'XL'), ('full', 'Full')], required=False))])), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))])), ('icon_text', wagtail.core.blocks.StructBlock([('icon', wagtail.snippets.blocks.SnippetChooserBlock('cms.IconSnippet', required=True)), ('text', wagtail.core.blocks.StructBlock([('value', wagtail.core.blocks.RichTextBlock(features=['h1', 'h2', 'h3', 'h4', 'bold', 'italic', 'link', 'ol', 'ul', 'hr', 'code-block', 'blockquote', 'strikethrough', 'mark', 'shadow', 'read-more'], label='Text', required=False))]))]))], required=False))]))], blank=True, verbose_name='Footer items')),
                ('header_menus', wagtail.core.fields.StreamField([('menu', wagtail.snippets.blocks.SnippetChooserBlock('cms.Menu', required=False)), ('link', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(label='Button link', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Button Page', required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, label='Button nouvel onglet', required=False))]))], blank=True, verbose_name='Header items')),
                ('header_buttons', wagtail.core.fields.StreamField([('button', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(required=False)), ('link', wagtail.core.blocks.URLBlock(label='Button link', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Button Page', required=False)), ('open_new_tab', wagtail.core.blocks.BooleanBlock(default=False, label='Button nouvel onglet', required=False)), ('type', wagtail.core.blocks.ChoiceBlock(choices=[('primary-light', 'Primary Light'), ('primary-full', 'Primary Full'), ('secondary-light', 'Secondary Light'), ('secondary-full', 'Secondary Full'), ('tertiary-light', 'Tertiary Light'), ('tertiary-full', 'Tertiary Full')], label='Button type', required=False))]))], blank=True, verbose_name='Header button')),
                ('locale', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='wagtailcore.Locale')),
            ],
            options={
                'abstract': False,
                'unique_together': {('translation_key', 'locale')},
            },
        ),
        migrations.CreateModel(
            name='IconSnippet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=255)),
                ('light', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailsvg.Svg', verbose_name='Theme Secondary')),
                ('space', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailsvg.Svg', verbose_name='Theme Primary')),
            ],
            options={
                'verbose_name': 'Icon',
                'abstract': False,
            },
            bases=(wagtail.search.index.Indexed, models.Model),
        ),
        migrations.AddField(
            model_name='genericpage',
            name='navigation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cms.Navigation', verbose_name='Navigation'),
        ),
        migrations.CreateModel(
            name='Founders',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(blank=True, default='', max_length=100)),
                ('gender', models.CharField(blank=True, choices=[('Male', 'Male'), ('Female', 'Female')], default='', max_length=100)),
                ('same_as', models.URLField(blank=True)),
                ('nationality', models.CharField(blank=True, default='', max_length=100)),
                ('settings', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='founders', to='cms.WebspaceSettings')),
            ],
            options={
                'verbose_name': 'Founder',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FormSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('form_data', models.TextField()),
                ('submit_time', models.DateTimeField(auto_now_add=True, verbose_name='submit time')),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions_form', to='cms.Form')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions_page', to='wagtailcore.Page')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FormField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('clean_name', models.CharField(blank=True, default='', help_text='Safe name of the form field, the label converted to ascii_snake_case', max_length=255, verbose_name='name')),
                ('label', models.CharField(help_text='The label of the form field', max_length=255, verbose_name='label')),
                ('field_type', models.CharField(choices=[('singleline', 'Single line text'), ('multiline', 'Multi-line text'), ('email', 'Email'), ('number', 'Number'), ('url', 'URL'), ('checkbox', 'Checkbox'), ('checkboxes', 'Checkboxes'), ('dropdown', 'Drop down'), ('multiselect', 'Multiple select'), ('radio', 'Radio buttons'), ('date', 'Date'), ('datetime', 'Date/time'), ('hidden', 'Hidden field')], max_length=16, verbose_name='field type')),
                ('required', models.BooleanField(default=True, verbose_name='required')),
                ('choices', models.TextField(blank=True, help_text='Comma separated list of choices. Only applicable in checkboxes, radio and dropdown.', verbose_name='choices')),
                ('default_value', models.CharField(blank=True, help_text='Default value. Comma separated values supported for checkboxes.', max_length=255, verbose_name='default value')),
                ('help_text', models.CharField(blank=True, max_length=255, verbose_name='help text')),
                ('placeholder', models.CharField(blank=True, max_length=255, verbose_name='Placeholder')),
                ('form', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='form_fields', to='cms.Form')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DocumentPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.Page')),
                ('document', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtaildocs.Document')),
            ],
            options={
                'abstract': False,
            },
            bases=('wagtailcore.page',),
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translation_key', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('help_text', models.CharField(blank=True, default='', max_length=100)),
                ('first_name', models.CharField(blank=True, default='', max_length=200)),
                ('last_name', models.CharField(blank=True, default='', max_length=200)),
                ('title', models.CharField(blank=True, default='', help_text='Titre', max_length=200)),
                ('description', wagtail.core.fields.RichTextField(blank=True, default='', help_text='Bio')),
                ('email_contact', models.CharField(blank=True, default='', max_length=200)),
                ('facebook', models.URLField(blank=True, help_text='Facebook page URL')),
                ('instagram', models.URLField(blank=True, help_text='Instagram page URL')),
                ('linkedin', models.URLField(blank=True, help_text='Linkedin page URL')),
                ('twitter', models.URLField(blank=True, help_text='Twitter page URL')),
                ('pinterest', models.URLField(blank=True, help_text='Pinterest page URL')),
                ('youtube', models.URLField(blank=True, help_text='Youtube page URL')),
                ('calendly', models.URLField(blank=True, help_text='Calendly URL')),
                ('image_miniature', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Image Miniature')),
                ('image_presentation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.Image', verbose_name='Image Presentation')),
                ('locale', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='wagtailcore.Locale')),
            ],
            options={
                'abstract': False,
                'unique_together': {('translation_key', 'locale')},
            },
        ),
        migrations.CreateModel(
            name='MenuItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translation_key', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('link_title', models.CharField(blank=True, max_length=50, null=True)),
                ('link_url', models.CharField(blank=True, max_length=500)),
                ('open_in_new_tab', models.BooleanField(blank=True, default=False)),
                ('link_page', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtailcore.Page')),
                ('locale', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='wagtailcore.Locale')),
                ('menu', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='menu_items', to='cms.Menu')),
            ],
            options={
                'abstract': False,
                'unique_together': {('translation_key', 'locale')},
            },
        ),
        migrations.CreateModel(
            name='BlogPageTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cms_blogpagetag_items', to='taggit.Tag')),
                ('content_object', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_items', to='cms.BlogPage')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='blogpage',
            name='author',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cms.Person'),
        ),
        migrations.AddField(
            model_name='blogpage',
            name='tags',
            field=modelcluster.contrib.taggit.ClusterTaggableManager(blank=True, help_text='A comma-separated list of tags.', through='cms.BlogPageTag', to='taggit.Tag', verbose_name='Tags'),
        ),
    ]
