"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codecommit_1 = require("aws-cdk-lib/aws-codecommit");
const pipelines_1 = require("aws-cdk-lib/pipelines");
const sonar_code_scanner_1 = require("./code_scanner/sonar-code-scanner");
__exportStar(require("./code_scanner/sonar-code-scanner"), exports);
const DEFAULT_BRANCH_NAME = "mainline";
/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo
 * codebase. In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
class PDKPipeline extends pipelines_1.CodePipeline {
    constructor(scope, id, props) {
        const codeRepository = new aws_codecommit_1.Repository(scope, "CodeRepository", {
            repositoryName: props.repositoryName,
        });
        // TODO: Implement prBuildChecker
        // ignore input and primaryOutputDirectory
        const { input, primaryOutputDirectory, commands, ...synthShellStepPartialProps } = props.synthShellStepPartialProps || {};
        const codePipelineProps = {
            ...props,
            synth: new pipelines_1.ShellStep("Synth", {
                input: pipelines_1.CodePipelineSource.codeCommit(codeRepository, props.defaultBranchName || DEFAULT_BRANCH_NAME),
                installCommands: ["yarn install --frozen-lockfile"],
                commands: commands && commands.length > 0
                    ? commands
                    : ["npx nx run-many --target=build --all"],
                primaryOutputDirectory: props.primarySynthDirectory,
                ...(synthShellStepPartialProps || {}),
            }),
        };
        super(scope, id, codePipelineProps);
        this.codeRepository = codeRepository;
        this.sonarCodeScannerConfig = props.sonarCodeScannerConfig;
        new aws_cdk_lib_1.CfnOutput(scope, "CodeRepositoryGRCUrl", {
            exportName: "CodeRepositoryGRCUrl",
            value: this.codeRepository.repositoryCloneUrlGrc,
        });
    }
    buildPipeline() {
        var _b;
        super.buildPipeline();
        this.sonarCodeScannerConfig &&
            new sonar_code_scanner_1.SonarCodeScanner(this, "SonarCodeScanner", {
                artifactBucketArn: this.pipeline.artifactBucket.bucketArn,
                artifactBucketKeyArn: (_b = this.pipeline.artifactBucket.encryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
                synthBuildArn: this.synthProject.projectArn,
                ...this.sonarCodeScannerConfig,
            });
    }
}
exports.PDKPipeline = PDKPipeline;
_a = JSII_RTTI_SYMBOL_1;
PDKPipeline[_a] = { fqn: "aws-prototyping-sdk.pdk_pipeline.PDKPipeline", version: "0.0.41" };
//# sourceMappingURL=data:application/json;base64,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