# Django settings for example project.
import os
import sys

from .core import PROJECT_DIR, gettext


# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(__file__))

DEBUG = False
DEBUG_TOOLBAR = False
DEV = False

ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS

DATABASES = {
    "default": {
        # Add 'postgresql_psycopg2', 'mysql', 'sqlite3' or 'oracle'.
        "ENGINE": "django.db.backends.sqlite3",
        # Or path to database file if using sqlite3.
        "NAME": PROJECT_DIR(os.path.join("..", "..", "db", "example.db")),
        # The following settings are not used with sqlite3:
        "USER": "",
        "PASSWORD": "",
        # Empty for localhost through domain sockets or '127.0.0.1' for
        # localhost through TCP.
        "HOST": "",
        # Set to empty string for default.
        "PORT": "",
    }
}

# Hosts/domain names that are valid for this site; required if DEBUG is False
# See https://docs.djangoproject.com/en/1.5/ref/settings/#allowed-hosts
ALLOWED_HOSTS = ["*"]

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# In a Windows environment this must be set to your system time zone.
TIME_ZONE = "America/Chicago"

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = "en"

LANGUAGES = (
    ("en", gettext("English")),  # Main language!
    ("hy", gettext("Armenian")),
    ("nl", gettext("Dutch")),
    ("ru", gettext("Russian")),
    ("de", gettext("German")),
)

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale.
USE_L10N = True

# If you set this to False, Django will not use timezone-aware datetimes.
USE_TZ = True

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/var/www/example.com/media/"
MEDIA_ROOT = PROJECT_DIR(os.path.join("..", "..", "media"))

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://example.com/media/", "http://media.example.com/"
MEDIA_URL = "/media/"

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/var/www/example.com/static/"
STATIC_ROOT = PROJECT_DIR(os.path.join("..", "..", "static"))

# URL prefix for static files.
# Example: "http://example.com/static/", "http://static.example.com/"
STATIC_URL = "/static/"

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    # PROJECT_DIR(os.path.join('..', '..', 'media', 'static')),
)

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = (
    "django.contrib.staticfiles.finders.FileSystemFinder",
    "django.contrib.staticfiles.finders.AppDirectoriesFinder",
    # 'django.contrib.staticfiles.finders.DefaultStorageFinder',
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = "97818c*w97Zi8a-m^1coRRrmurMI6+q5_kyn*)s@(*_Pk6q423"

try:
    from .local_settings import DEBUG_TEMPLATE
except Exception as err:
    DEBUG_TEMPLATE = False

try:
    from .local_settings import USE_CACHED_TEMPLATE_LOADERS
except Exception as err:
    USE_CACHED_TEMPLATE_LOADERS = False

if USE_CACHED_TEMPLATE_LOADERS:

    _TEMPLATE_LOADERS = [
        (
            "django.template.loaders.cached.Loader",
            (
                "django.template.loaders.filesystem.Loader",
                "django.template.loaders.app_directories.Loader",
                # 'django.template.loaders.eggs.Loader',
            ),
        ),
    ]
else:

    _TEMPLATE_LOADERS = [
        "django.template.loaders.filesystem.Loader",
        "django.template.loaders.app_directories.Loader",
        # 'django.template.loaders.eggs.Loader',
    ]


TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        # 'APP_DIRS': True,
        "DIRS": [PROJECT_DIR(os.path.join("..", "templates"))],
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
                # "context_processors.testing",  # Testing
            ],
            "loaders": _TEMPLATE_LOADERS,
            "debug": DEBUG_TEMPLATE,
        },
    },
]


MIDDLEWARE = (
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.locale.LocaleMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    # Uncomment the next line for simple clickjacking protection:
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',
)

ROOT_URLCONF = "urls"

# Python dotted path to the WSGI application used by Django's runserver.
WSGI_APPLICATION = "wsgi.application"

# FIXTURE_DIRS = (
#   PROJECT_DIR(os.path.join('..', 'fixtures'))
# )

INSTALLED_APPS = [
    # Django core and contrib apps
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.sites",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "django.contrib.admin",
    "django.contrib.sitemaps",
    "django.contrib.humanize",
    # Third party apps
    "rest_framework",  # REST framework
    # REST schema
    "drf_spectacular",
    "drf_spectacular_sidecar",
    # This app
    "rest_framework_tricks",
    # Other project specific apps
    "assets",  # Static files
    "books",  # Test app
]

# *********************************************************************
# *********************** django-rest-framework ***********************
# *********************************************************************

REST_FRAMEWORK = {
    "DEFAULT_AUTHENTICATION_CLASSES": (
        "rest_framework.authentication.BasicAuthentication",
        "rest_framework.authentication.SessionAuthentication",
    ),
    "DEFAULT_PAGINATION_CLASS": "rest_framework.pagination.PageNumberPagination",
    "PAGE_SIZE": 100,
    "ORDERING_PARAM": "ordering",
    "DEFAULT_SCHEMA_CLASS": "drf_spectacular.openapi.AutoSchema",
}


# *********************************************************************
# *********************** django-spectacular **************************
# *********************************************************************

SPECTACULAR_SETTINGS = {
    "TITLE": "django-rest-framework-tricks example API",
    "DESCRIPTION": "django-rest-framework-tricks example API documentation.",
    "VERSION": "",
    "SWAGGER_UI_DIST": "SIDECAR",
    "SWAGGER_UI_FAVICON_HREF": "SIDECAR",
    "REDOC_DIST": "SIDECAR",
    # "SCHEMA_PATH_PREFIX_TRIM": True,
    # "SCHEMA_PATH_PREFIX": "",
    "SERVE_INCLUDE_SCHEMA": False,
    "AUTHENTICATION_WHITELIST": [
        "rest_framework.authentication.BasicAuthentication",
        "rest_framework.authentication.SessionAuthentication",
    ],
    "CONTACT": {
        "email": "admin@localhost",
    },
}

LOGIN_URL = "/en/accounts/login/"
LOGIN_ERROR_URL = "/en/accounts/login/"
LOGOUT_URL = "/en/accounts/logout/"
LOGIN_REDIRECT_URL = "/en/"

# A sample logging configuration. The only tangible logging
# performed by this configuration is to send an email to
# the site admins on every HTTP 500 error when DEBUG=False.
# See http://docs.djangoproject.com/en/dev/topics/logging for
# more details on how to customize your logging configuration.
LOGGING = {
    "version": 1,
    "disable_existing_loggers": False,
    "filters": {
        "require_debug_false": {"()": "django.utils.log.RequireDebugFalse"}
    },
    "root": {
        "level": "INFO",
        "handlers": ["all_log"],
    },
    "formatters": {
        "verbose": {
            "format": "\n%(levelname)s %(asctime)s [%(pathname)s:%(lineno)s] "
            "%(message)s"
        },
        "simple": {"format": "\n%(levelname)s %(message)s"},
    },
    "handlers": {
        "mail_admins": {
            "level": "ERROR",
            "filters": ["require_debug_false"],
            "class": "django.utils.log.AdminEmailHandler",
        },
        "console": {
            "level": "DEBUG",
            "class": "logging.StreamHandler",
            "formatter": "verbose",
        },
        "all_log": {
            "level": "DEBUG",
            "class": "logging.handlers.RotatingFileHandler",
            "filename": PROJECT_DIR("../../logs/all.log"),
            "maxBytes": 1048576,
            "backupCount": 99,
            "formatter": "verbose",
        },
        "django_log": {
            "level": "DEBUG",
            "class": "logging.handlers.RotatingFileHandler",
            "filename": PROJECT_DIR("../../logs/django.log"),
            "maxBytes": 1048576,
            "backupCount": 99,
            "formatter": "verbose",
        },
        "django_request_log": {
            "level": "DEBUG",
            "class": "logging.handlers.RotatingFileHandler",
            "filename": PROJECT_DIR("../../logs/django_request.log"),
            "maxBytes": 1048576,
            "backupCount": 99,
            "formatter": "verbose",
        },
        "debug_toolbar_force_log": {
            "level": "DEBUG",
            "class": "logging.handlers.RotatingFileHandler",
            "filename": PROJECT_DIR("../../logs/debug_toolbar_force.log"),
            "maxBytes": 1048576,
            "backupCount": 99,
            "formatter": "verbose",
        },
    },
    "loggers": {
        "django.request": {
            "handlers": ["django_request_log"],
            "level": "INFO",
            "propagate": True,
        },
        "django": {
            "handlers": ["django_log"],
            "level": "ERROR",
            "propagate": False,
        },
        "books": {
            "handlers": ["console", "debug_toolbar_force_log"],
            "level": "DEBUG",
            "propagate": True,
        },
    },
}

# Do not put any settings below this line
try:
    from .local_settings import *
except ImportError:
    pass

if DEBUG and DEBUG_TOOLBAR:
    try:
        # Make sure the django-debug-toolbar is installed
        import debug_toolbar

        # debug_toolbar
        MIDDLEWARE += (
            "debug_toolbar.middleware.DebugToolbarMiddleware",
            "debug_toolbar_force.middleware.ForceDebugToolbarMiddleware",
        )

        INSTALLED_APPS += ("debug_toolbar",)

        DEBUG_TOOLBAR_CONFIG = {
            "INTERCEPT_REDIRECTS": False,
        }

        DEBUG_TOOLBAR_PANELS = (
            # Defaults
            "debug_toolbar.panels.versions.VersionsPanel",
            "debug_toolbar.panels.timer.TimerPanel",
            "debug_toolbar.panels.settings.SettingsPanel",
            "debug_toolbar.panels.headers.HeadersPanel",
            "debug_toolbar.panels.request.RequestPanel",
            "debug_toolbar.panels.sql.SQLPanel",
            "debug_toolbar.panels.staticfiles.StaticFilesPanel",
            "debug_toolbar.panels.templates.TemplatesPanel",
            "debug_toolbar.panels.cache.CachePanel",
            "debug_toolbar.panels.signals.SignalsPanel",
            "debug_toolbar.panels.logging.LoggingPanel",
            "debug_toolbar.panels.redirects.RedirectsPanel",
        )

    except ImportError:
        pass

# Make the `django-rest-framework-tricks` package available without
# installation or development.
if DEV:
    app_source_path = os.environ.get(
        "DJANGO_REST_FRAMEWORK_TRICKS_SOURCE_PATH", "src"
    )
    # sys.path.insert(0, os.path.abspath('src'))
    sys.path.insert(0, os.path.abspath(app_source_path))
