import CoreServices
from PyObjCTools.TestSupport import TestCase


class TestFP(TestCase):
    def assert_not_wrapped(self, name):
        self.assertTrue(
            not hasattr(CoreServices, name), "%r exposed in bindings" % (name,)
        )

    def test_not_wrapped(self):
        self.assert_not_wrapped("HUGE_VAL")
        self.assert_not_wrapped("INFINITY")
        self.assert_not_wrapped("NAN")
        self.assert_not_wrapped("DECIMAL_DIG")
        self.assert_not_wrapped("cos")
        self.assert_not_wrapped("sin")
        self.assert_not_wrapped("tan")
        self.assert_not_wrapped("acos")
        self.assert_not_wrapped("asin")
        self.assert_not_wrapped("atan")
        self.assert_not_wrapped("atan2")
        self.assert_not_wrapped("cosh")
        self.assert_not_wrapped("sinh")
        self.assert_not_wrapped("tanh")
        self.assert_not_wrapped("acosh")
        self.assert_not_wrapped("asinh")
        self.assert_not_wrapped("atanh")
        self.assert_not_wrapped("exp")
        self.assert_not_wrapped("expm1")
        self.assert_not_wrapped("exp2")
        self.assert_not_wrapped("frexp")
        self.assert_not_wrapped("ldexp")
        self.assert_not_wrapped("log")
        self.assert_not_wrapped("log2")
        self.assert_not_wrapped("log1p")
        self.assert_not_wrapped("log10")
        self.assert_not_wrapped("logb")
        self.assert_not_wrapped("double  modfl")
        self.assert_not_wrapped("modf")
        self.assert_not_wrapped("modff")
        self.assert_not_wrapped("scalb")
        self.assert_not_wrapped("fabs")
        self.assert_not_wrapped("hypot")
        self.assert_not_wrapped("pow")
        self.assert_not_wrapped("sqrt")
        self.assert_not_wrapped("erf")
        self.assert_not_wrapped("erfc")
        self.assert_not_wrapped("gamma")
        self.assert_not_wrapped("lgamma")
        self.assert_not_wrapped("ceil")
        self.assert_not_wrapped("floor")
        self.assert_not_wrapped("rint")
        self.assert_not_wrapped("nearbyint")
        self.assert_not_wrapped("rinttol")
        self.assert_not_wrapped("round")
        self.assert_not_wrapped("roundtol")
        self.assert_not_wrapped("trunc")
        self.assert_not_wrapped("fmod")
        self.assert_not_wrapped("remainder")
        self.assert_not_wrapped("remquo")
        self.assert_not_wrapped("copysign")
        self.assert_not_wrapped("nan(const")
        self.assert_not_wrapped("nanf")
        self.assert_not_wrapped("double  nanl")
        self.assert_not_wrapped("nextafterd")
        self.assert_not_wrapped("nextafterf")
        self.assert_not_wrapped("double  nextafterl")
        self.assert_not_wrapped("__fpclassifyd")
        self.assert_not_wrapped("__fpclassifyf")
        self.assert_not_wrapped("__fpclassify")
        self.assert_not_wrapped("__isnormald")
        self.assert_not_wrapped("__isnormalf")
        self.assert_not_wrapped("__isnormal")
        self.assert_not_wrapped("__isfinited")
        self.assert_not_wrapped("__isfinitef")
        self.assert_not_wrapped("__isfinite")
        self.assert_not_wrapped("__isnand")
        self.assert_not_wrapped("__isnanf")
        self.assert_not_wrapped("__isnan")
        self.assert_not_wrapped("__signbitd")
        self.assert_not_wrapped("__signbitf")
        self.assert_not_wrapped("__signbit")
        self.assert_not_wrapped("__inf")
        self.assert_not_wrapped("fpclassify")
        self.assert_not_wrapped("isnormal")
        self.assert_not_wrapped("isfinite")
        self.assert_not_wrapped("isnan")
        self.assert_not_wrapped("signbit")
        self.assert_not_wrapped("fdim")
        self.assert_not_wrapped("fmax")
        self.assert_not_wrapped("fmin")
        self.assert_not_wrapped("pi")
        self.assert_not_wrapped("compound")
        self.assert_not_wrapped("annuity")
        self.assert_not_wrapped("randomx")
        self.assert_not_wrapped("GREATERTHAN                   ")
        self.assert_not_wrapped("LESSTHAN                     ")
        self.assert_not_wrapped("EQUALTO                     ")
        self.assert_not_wrapped("UNORDERED                  ")
        self.assert_not_wrapped("relation")
        self.assert_not_wrapped("SIGDIGLEN")
        self.assert_not_wrapped("DECSTROUTLEN")
        self.assert_not_wrapped("FLOATDECIMAL")
        self.assert_not_wrapped("FIXEDDECIMAL")
        self.assert_not_wrapped("decimal")
        self.assert_not_wrapped("decform")
        self.assert_not_wrapped("num2dec")
        self.assert_not_wrapped("dec2num")
        self.assert_not_wrapped("dec2str")
        self.assert_not_wrapped("str2dec")
        self.assert_not_wrapped("dec2f")
        self.assert_not_wrapped("dec2s")
        self.assert_not_wrapped("dec2l")
        self.assert_not_wrapped("cosl")
        self.assert_not_wrapped("sinl")
        self.assert_not_wrapped("tanl")
        self.assert_not_wrapped("acosl")
        self.assert_not_wrapped("asinl")
        self.assert_not_wrapped("atanl")
        self.assert_not_wrapped("atan2l")
        self.assert_not_wrapped("coshl")
        self.assert_not_wrapped("sinhl")
        self.assert_not_wrapped("tanhl")
        self.assert_not_wrapped("acoshl")
        self.assert_not_wrapped("asinhl")
        self.assert_not_wrapped("atanhl")
        self.assert_not_wrapped("expl")
        self.assert_not_wrapped("expm1l")
        self.assert_not_wrapped("exp2l")
        self.assert_not_wrapped("frexpl")
        self.assert_not_wrapped("ldexpl")
        self.assert_not_wrapped("logl")
        self.assert_not_wrapped("log1pl")
        self.assert_not_wrapped("log10l")
        self.assert_not_wrapped("log2l")
        self.assert_not_wrapped("logbl")
        self.assert_not_wrapped("scalbl")
        self.assert_not_wrapped("fabsl")
        self.assert_not_wrapped("hypotl")
        self.assert_not_wrapped("powl")
        self.assert_not_wrapped("sqrtl")
        self.assert_not_wrapped("erfl(")
        self.assert_not_wrapped("erfcl")
        self.assert_not_wrapped("gammal")
        self.assert_not_wrapped("lgammal")
        self.assert_not_wrapped("ceill")
        self.assert_not_wrapped("floorl")
        self.assert_not_wrapped("rintl")
        self.assert_not_wrapped("nearbyintl")
        self.assert_not_wrapped("rinttoll")
        self.assert_not_wrapped("roundl")
        self.assert_not_wrapped("roundtoll")
        self.assert_not_wrapped("truncl")
        self.assert_not_wrapped("remainderl")
        self.assert_not_wrapped("remquol")
        self.assert_not_wrapped("copysignl")
        self.assert_not_wrapped("fdiml")
        self.assert_not_wrapped("fmaxl")
        self.assert_not_wrapped("fminl")
        self.assert_not_wrapped("relationl")
        self.assert_not_wrapped("num2decl")
        self.assert_not_wrapped("dec2numl")
        self.assert_not_wrapped("x80tod")
        self.assert_not_wrapped("dtox80")
        self.assert_not_wrapped("__inline_x80told")
        self.assert_not_wrapped("__inline_ldtox80")
        self.assert_not_wrapped("ldtox80")
