"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const package_stats_1 = require("./backend/package-stats");
const constants_1 = require("./backend/shared/constants");
const repository_1 = require("./codeartifact/repository");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, id);
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = new s3.Bucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const codeArtifact = new repository_1.Repository(this, 'CodeArtifact', {
            description: 'Proxy to npmjs.com for ConstructHub',
            domainName: (_b = props.codeArtifactDomain) === null || _b === void 0 ? void 0 : _b.name,
            domainExists: props.codeArtifactDomain != null,
            upstreams: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.upstreams,
        });
        const { vpc, vpcEndpoints, vpcSubnets } = this.createVpc(props, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_d = props.denyList) !== null && _d !== void 0 ? _d : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        // disable fetching package stats by default if a different package
        // source is configured
        const fetchPackageStats = (_e = props.fetchPackageStats) !== null && _e !== void 0 ? _e : (props.packageSources ? false : true);
        let packageStats;
        const statsKey = 'stats.json';
        if (fetchPackageStats) {
            packageStats = new package_stats_1.PackageStats(this, 'Stats', {
                bucket: packageData,
                monitoring,
                logRetention: props.logRetention,
                objectKey: statsKey,
            });
        }
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder);
        const packageTagsSerialized = (_g = (_f = props.packageTags) === null || _f === void 0 ? void 0 : _f.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _g !== void 0 ? _g : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_h = props.allowedLicenses) !== null && _h !== void 0 ? _h : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.mit(),
            ],
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_j = props.packageSources) !== null && _j !== void 0 ? _j : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
            packageStats,
        });
        new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            featuredPackages: props.featuredPackages,
            packageStats,
            featureFlags: props.featureFlags,
        });
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(props, codeArtifact) {
        if (props.isolateSensitiveTasks === false) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const vpc = new ec2.Vpc(this, 'Lambda-VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 0,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: true },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE, reserved: true },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED },
            ],
        });
        const vpcSubnets = { subnetType: ec2.SubnetType.ISOLATED };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
            }),
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                `${codeArtifact.s3BucketArn}/*`,
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.2.58" };
//# sourceMappingURL=data:application/json;base64,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