# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['automated_logging',
 'automated_logging.admin',
 'automated_logging.helpers',
 'automated_logging.migrations',
 'automated_logging.signals',
 'automated_logging.tests']

package_data = \
{'': ['*'], 'automated_logging': ['templates/dal/admin/*']}

install_requires = \
['django-ipware>=3.0.0,<4.0.0',
 'django-picklefield>=3.0.1,<4.0.0',
 'django>=2.2,<4.0',
 'marshmallow>=3.6.1,<4.0.0']

setup_kwargs = {
    'name': 'django-automated-logging',
    'version': '6.0.6',
    'description': 'Django Database Based Automated Logging - finally solved and done in a proper way.',
    'long_description': '# Django Database Based Automated Logging\n\n![https://pypi.python.org/pypi?name=django-automated-logging](https://img.shields.io/pypi/v/django-automated-logging.svg)\n![https://pypi.python.org/pypi?name=django-automated-logging](https://img.shields.io/pypi/l/django-automated-logging.svg)\n![https://pypi.python.org/pypi?name=django-automated-logging](https://img.shields.io/pypi/status/django-automated-logging.svg)\n![https://pypi.python.org/pypi?name=django-automated-logging](https://img.shields.io/pypi/pyversions/django-automated-logging.svg)\n![https://travis-ci.org/indietyp/django-automated-logging](https://travis-ci.org/indietyp/django-automated-logging.svg?branch=master)\n![https://coveralls.io/github/indietyp/django-automated-logging?branch=master](https://coveralls.io/repos/github/indietyp/django-automated-logging/badge.svg?branch=master)\n![https://www.codacy.com/app/bilalmahmoud/django-automated-logging?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=indietyp/django-automated-logging&amp;utm_campaign=Badge_Grade](https://api.codacy.com/project/badge/Grade/96fdb764fc34486399802b2f8267efcc)\n![https://paypal.me/indietyp/5](https://img.shields.io/badge/Support%20the%20Project-PayPal-green.svg)\n\n**Notice:** Most of this will be moved into a wiki.\n\n## What is Django-Automated-Logging (DAL)?\n\nTL;DR: DAL is a package to **automatically** track changes in your project, ranging\nfrom simple logging messages, to model changes or requests done by users.\n\nYou can decide what you want to do and how.\nDAL allows fine-grained customization and filtering with various methods.\n\n### Introduction\n\nDjango Fully Automated Logging - **finally** solved and done properly.\n\nHow to install?\n`pip install django-automated-logging` or `poetry add django-automated-logging`\n\n### What is the purpose?\nThe goal of DAL is to provide an easy, accessible and DRY way to log the inner working of you applications.\nUltimately giving you the chance to easily see what is happening without excessive manual print/logging statements.\n\nThe application uses minimal requirements and is performant.\n\n### How does it work?\nThe application facilitates the built-in logging mechanic\nby providing a custom handler, that just needs to be added to the `LOGGING` configuration.\n\nDAL uses native Django signals to know what is happening behind the scenes without injecting custom code.\n\n### Minimal Setup\n\nYou can also configure DAL to only log to a file and not to a database.\nYou just need to enable DAL and not include the custom logging handler.\n\n## Detailed Information\n\n### Features\n\n1. Easy Setup\n2. Extensible\n3. Feature-Rich\n4. Completely Automated\n5. Built-In Database Logger\n6. No custom code needs to be inserted into your codebase\n7. Can capture logging messages unrelated to the package itself\n8. Only does what it needs to do, no extra bells and whistles.\n\n### Setup\n\nInitial Configuration is via your projects `settings.py`\n\n1. `INSTALLED_APPS` append: `\'automated_logging\'`\n2. `MIDDLEWARE` append: `\'automated_logging.middleware.AutomatedLoggingMiddleware\'`\n3. `LOGGING` section `handlers` add:\n    ```python\n       \'db\': {\n           \'level\': \'INFO\',\n           \'class\': \'automated_logging.handlers.DatabaseHandler\',\n       {\n    ```\n4. `LOGGING` section `loggers` add: (only required if database logging desired)\n    ```python\n       \'automated_logging\': {\n           \'level\': \'INFO\',\n           \'handlers\': [\'db\'],\n           \'propagate\': True,\n       },\n       \'django\': {\n           \'level\': \'INFO\',\n           \'handlers\': [\'db\'],\n           \'propagate\': True,\n       },\n    ```\n5. execute: `python manage.py migrate automated_logging`\n\n`LOGGING` configuration details are just recommendations.\n\n### Configuration\n\nFurther configuration can be done via the variable `AUTOMATED_LOGGING`. The defaults are:\n\n```python\nAUTOMATED_LOGGING = {\n    "globals": {\n        "exclude": {\n            "applications": [\n                "plain:contenttypes",\n                "plain:admin",\n                "plain:basehttp",\n                "glob:session*",\n                "plain:migrations",\n            ]\n        }\n    },\n    "model": {\n        "detailed_message": True,\n        "exclude": {"applications": [], "fields": [], "models": [], "unknown": False},\n        "loglevel": 20,\n        "mask": [],\n        "max_age": None,\n        "performance": False,\n        "snapshot": False,\n        "user_mirror": False,\n    },\n    "modules": ["request", "unspecified", "model"],\n    "request": {\n        "data": {\n            "content_types": ["application/json"],\n            "enabled": [],\n            "ignore": [],\n            "mask": ["password"],\n            "query": False,\n        },\n        "exclude": {\n            "applications": [],\n            "methods": ["GET"],\n            "status": [200],\n            "unknown": False,\n        },\n        "ip": True,\n        "loglevel": 20,\n        "max_age": None,\n    },\n    "unspecified": {\n        "exclude": {"applications": [], "files": [], "unknown": False},\n        "loglevel": 20,\n        "max_age": None,\n    },\n}\n```\n\nYou can always inspect the current default configuration by doing:\n\n```python\nfrom pprint import pprint\nfrom automated_logging.settings import default\nfrom automated_logging.helpers import namedtuple2dict\n\npprint(namedtuple2dict(default))\n```\n\n**Recommendation:** include the `globals` application defaults as those modules can be particularly verbose or be duplicates.\n\nThere are *three* different independent modules available `request` (for request logging), `unspecified` (for general logging messages), and `models` (for model changes).\nThey can be enabled and disabled by including them in the `modules` configuration.\n\nThe `loglevel` setting indicates the severity for the logging messages sent from the module.\n`INFO (20)` or `DEBUG (10)` is the right call for most cases.\n\n*New in 6.x.x:* Saving can be batched via the `batch` setting for the handler.\n\n*New in 6.x.x:* Saving can be threaded by `thread: True` for the handler settings. **This is highly experimental**\n\n*New in 6.x.x:* every field in `exclude` can be either be a `glob` (prefixing the string with `gl:`), a `regex` (prefixing the string with `re:`) or plain (prefixing the string with `pl:`). The default is `glob`.\n\n### Decorators\n\nYou can explicitly exclude or include views/models, by using the new decorators.\n\n```python\nfrom automated_logging.decorators import include_view, include_model, exclude_view, exclude_model\n\n@include_view(methods=None)\n@exclude_view(methods=[])\ndef view(request):\n    pass\n\n@include_model(operations=None, fields=None)\n@exclude_model(operations=[], fields=[])\nclass ExampleModel:\n    pass\n```\n\n`include` *always* takes precedence over `exclude`, if you use multiple `include` or `exclude` instead of overwriting they will *update/extend* the previous definition.\n\n`operations` can be either `create`, `modify`, `delete`. `fields` is a list model specific fields to be included/excluded.\n`methods` is a list methods to be included/excluded.\n\n### Class-Based Configuration\n\nClass-Based Configuration is done over a specific meta class `LoggingIgnore`. Decorators take precedence over class-based configuration, but class-based configuration takes precedence over AUTOMATED_LOGGING configuration.\n\n```python\nclass ExampleModel:\n    class LoggingIgnore:\n        complete = False\n        fields = []\n        operations = []\n```\n\nas described above `operations` and `fields` work the same way. `complete = True` means that a model is excluded no matter what.\n\n## Changelog\n\n### Version 6.0.0\n- **Added:** ``batch`` settings to the handler\n- **Added:** decorators\n- **Added:** class-based configuration\n- **Added:** request and response bodies can now be saved\n- **Added:** regex, glob matching for settings\n- **Updated:** settings\n- **Updated:** models\n- **Updated:** to current django version (2.2, 3.0, 3.1)\n- **Updated:** DAL no longer stores internal information directly, but now has a custom _meta object injected.\n- **Updated:** project now uses black for formatting\n- **Updated:** internals were completely rewritten for greater maintainability and speed.\n- **Fixed:** https://github.com/indietyp/django-automated-logging/issues/1\n- **Fixed:** https://github.com/indietyp/django-automated-logging/issues/2\n- **Moved:** `max_age` is now part of the `settings.py` configuration.\n\n### Version 5.0.0\n- **Added:** ``maxage`` handler setting to automatically remove database entries after a certain amount of time.\n- **Added:** query string in requests can now be enabled/disabled (are now disabled by default)\n- **Fixed:** Value and URI could be longer than 255 characters. DAL would throw an exception. This is fixed.\n\n\n## Roadmap\n\n### Version 6.1.x\n- [ ] archive options\n- [ ] decorators greater flexibility\n- [ ] wiki -> documentation\n- [ ] make django-ipware optional via extras\n- [ ] and more!\n\n### Version 7.x.x\n- [ ] implementation of a git like versioning interface\n\n### Version 8.x.x\n- [ ] temporary world domination',
    'author': 'Bilal Mahmoud',
    'author_email': 'bilalmahmoud@posteo.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/indietyp/django-automated-logging',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4',
}


setup(**setup_kwargs)
