# pymetrics-soft-skills-sdk
### This is pymetrics's public API. The API can be used to get information on candidates as part of a job application workflow, or for employee career pathing and development.
The typical use case for this is to support an externally initiated assessment for a candidate job application.
This is often done \"inline\" with the candidate's application, or asynchronously after the candidate submits their application.
This data can then be used for career pathing and employee development in subsequent stages.

The expected sequence of API calls is:
* `Generate OAuth Token` with the OAuth Client ID and Secret you've been provided
* `Get Assessment Configurations` to determine which configured assessment templates are available
* `Create Assessment Order` for a selected Assessment and candidate job application
* `Get Assessment Order` to receive the recommendation results and reports, once they are available

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.2.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

### pip install


```sh
pip install pymetrics_soft_skills_sdk
```

Then import the package:
```python
import pymetrics_soft_skills_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pymetrics_soft_skills_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pymetrics_soft_skills_sdk
from pymetrics_soft_skills_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = pymetrics_soft_skills_sdk.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with pymetrics_soft_skills_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pymetrics_soft_skills_sdk.DefaultApi(api_client)
    authorization = 'authorization_example' # str | Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}` (optional)
x_api_key = 'x_api_key_example' # str | Mandatory API Key that pymetrics will provide (optional)
order_request = pymetrics_soft_skills_sdk.OrderRequest() # OrderRequest | Candidate, assessment, and job application details (optional)

    try:
        # Create Assessment Order
        api_response = api_instance.mercury_create_order_v2(authorization=authorization, x_api_key=x_api_key, order_request=order_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->mercury_create_order_v2: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**mercury_create_order_v2**](docs/DefaultApi.md#mercury_create_order_v2) | **POST** /mercury/v2/orders | Create Assessment Order
*DefaultApi* | [**mercury_get_config_v2**](docs/DefaultApi.md#mercury_get_config_v2) | **GET** /mercury/v2/assessments | Get Assessment Configurations
*DefaultApi* | [**mercury_list_orders_v2**](docs/DefaultApi.md#mercury_list_orders_v2) | **GET** /mercury/v2/orders | List Assessment Orders
*DefaultApi* | [**mercury_o_auth_v2**](docs/DefaultApi.md#mercury_o_auth_v2) | **POST** /mercury/v2/oauth/token | Generate OAuth Token
*DefaultApi* | [**mercury_retrieve_factor_content**](docs/DefaultApi.md#mercury_retrieve_factor_content) | **GET** /mercury/v2/factorContent/{uuid} | Get Factor Content
*DefaultApi* | [**mercury_retrieve_order_v2**](docs/DefaultApi.md#mercury_retrieve_order_v2) | **GET** /mercury/v2/orders/{uuid} | Get Assessment Order


## Documentation For Models

 - [AssessmentType](docs/AssessmentType.md)
 - [AtsType](docs/AtsType.md)
 - [Configuration](docs/Configuration.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ListOrdersRequest](docs/ListOrdersRequest.md)
 - [ListOrdersResponse](docs/ListOrdersResponse.md)
 - [MercuryAssessment](docs/MercuryAssessment.md)
 - [MercuryAssessmentOrder](docs/MercuryAssessmentOrder.md)
 - [MercuryCandidate](docs/MercuryCandidate.md)
 - [MercuryDevelopmentReportContent](docs/MercuryDevelopmentReportContent.md)
 - [MercuryFactorContent](docs/MercuryFactorContent.md)
 - [MercuryModelDirection](docs/MercuryModelDirection.md)
 - [MercuryOrderFactorContent](docs/MercuryOrderFactorContent.md)
 - [MercuryOrderMetadata](docs/MercuryOrderMetadata.md)
 - [MercuryReport](docs/MercuryReport.md)
 - [MercuryResult](docs/MercuryResult.md)
 - [MercuryRetrieveFactorContentRequest](docs/MercuryRetrieveFactorContentRequest.md)
 - [OAuthRequest](docs/OAuthRequest.md)
 - [OAuthResponse](docs/OAuthResponse.md)
 - [OrderCreateResponse](docs/OrderCreateResponse.md)
 - [OrderRequest](docs/OrderRequest.md)
 - [PontemOrderStatuses](docs/PontemOrderStatuses.md)
 - [PontemReportTypes](docs/PontemReportTypes.md)


## Author
Michelle Tsai <min.tsai@pymetrics.com>




