# coding: utf-8

"""
    pymetrics API

    ### This is pymetrics's public API. The API can be used to get information on candidates as part of a job application workflow, or for employee career pathing and development. The typical use case for this is to support an externally initiated assessment for a candidate job application. This is often done \"inline\" with the candidate's application, or asynchronously after the candidate submits their application. This data can then be used for career pathing and employee development in subsequent stages.  The expected sequence of API calls is: * `Generate OAuth Token` with the OAuth Client ID and Secret you've been provided * `Get Assessment Configurations` to determine which configured assessment templates are available * `Create Assessment Order` for a selected Assessment and candidate job application * `Get Assessment Order` to receive the recommendation results and reports, once they are available  # noqa: E501

    The version of the OpenAPI document: 2.2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def mercury_create_order_v2(self, **kwargs):  # noqa: E501
        """Create Assessment Order  # noqa: E501

        Creates an assessment order for a candidate. This represents the transaction for a candidate's job application.  This is an idempotent operation, and may return an existing assessment order. The following inputs constitute the uniqueness criteria: * `candidate.email` * `assessment_id` * `application_id`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_create_order_v2(async_req=True)
        >>> result = thread.get()

        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param order_request: Candidate, assessment, and job application details
        :type order_request: OrderRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OrderCreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.mercury_create_order_v2_with_http_info(**kwargs)  # noqa: E501

    def mercury_create_order_v2_with_http_info(self, **kwargs):  # noqa: E501
        """Create Assessment Order  # noqa: E501

        Creates an assessment order for a candidate. This represents the transaction for a candidate's job application.  This is an idempotent operation, and may return an existing assessment order. The following inputs constitute the uniqueness criteria: * `candidate.email` * `assessment_id` * `application_id`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_create_order_v2_with_http_info(async_req=True)
        >>> result = thread.get()

        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param order_request: Candidate, assessment, and job application details
        :type order_request: OrderRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrderCreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'authorization',
            'x_api_key',
            'order_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mercury_create_order_v2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501
        if 'x_api_key' in local_var_params:
            header_params['X-Api-Key'] = local_var_params['x_api_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_request' in local_var_params:
            body_params = local_var_params['order_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "OrderCreateResponse",
            201: "OrderCreateResponse",
            400: "ErrorResponse",
            401: "ErrorResponse",
            500: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/mercury/v2/orders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def mercury_get_config_v2(self, **kwargs):  # noqa: E501
        """Get Assessment Configurations  # noqa: E501

        Lists the assessment templates that are currently registered for your integration. These are configured outside of the API, and represent the different candidate experiences for each role pymetrics is being leveraged for.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_get_config_v2(async_req=True)
        >>> result = thread.get()

        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Configuration
        """
        kwargs['_return_http_data_only'] = True
        return self.mercury_get_config_v2_with_http_info(**kwargs)  # noqa: E501

    def mercury_get_config_v2_with_http_info(self, **kwargs):  # noqa: E501
        """Get Assessment Configurations  # noqa: E501

        Lists the assessment templates that are currently registered for your integration. These are configured outside of the API, and represent the different candidate experiences for each role pymetrics is being leveraged for.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_get_config_v2_with_http_info(async_req=True)
        >>> result = thread.get()

        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Configuration, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'authorization',
            'x_api_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mercury_get_config_v2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501
        if 'x_api_key' in local_var_params:
            header_params['X-Api-Key'] = local_var_params['x_api_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "Configuration",
            401: "ErrorResponse",
            500: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/mercury/v2/assessments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def mercury_list_orders_v2(self, **kwargs):  # noqa: E501
        """List Assessment Orders  # noqa: E501

        Get a list of Assessment Orders by either job application ID and/or candidate ID. At least one of the IDs must be provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_list_orders_v2(async_req=True)
        >>> result = thread.get()

        :param job_application_id: Job application ID by which to optionally filter on
        :type job_application_id: str
        :param candidate_id: Candidate ID by which to optionally filter on
        :type candidate_id: str
        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListOrdersResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.mercury_list_orders_v2_with_http_info(**kwargs)  # noqa: E501

    def mercury_list_orders_v2_with_http_info(self, **kwargs):  # noqa: E501
        """List Assessment Orders  # noqa: E501

        Get a list of Assessment Orders by either job application ID and/or candidate ID. At least one of the IDs must be provided.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_list_orders_v2_with_http_info(async_req=True)
        >>> result = thread.get()

        :param job_application_id: Job application ID by which to optionally filter on
        :type job_application_id: str
        :param candidate_id: Candidate ID by which to optionally filter on
        :type candidate_id: str
        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListOrdersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_application_id',
            'candidate_id',
            'authorization',
            'x_api_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mercury_list_orders_v2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'job_application_id' in local_var_params and local_var_params['job_application_id'] is not None:  # noqa: E501
            query_params.append(('job_application_id', local_var_params['job_application_id']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501

        header_params = {}
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501
        if 'x_api_key' in local_var_params:
            header_params['X-Api-Key'] = local_var_params['x_api_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "ListOrdersResponse",
            400: "ErrorResponse",
            500: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/mercury/v2/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def mercury_o_auth_v2(self, **kwargs):  # noqa: E501
        """Generate OAuth Token  # noqa: E501

        The response's bearer token must be used in the `Authorization` header for any other API request. Tokens are valid for only a period of time.  All requests, with the exception of this one, also require an API Key to be supplied in the `X-Api-Key` request header. pymetrics will supply this along with the OAuth Client ID and Secret.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_o_auth_v2(async_req=True)
        >>> result = thread.get()

        :param o_auth_request: OAuth2 Client Credentials
        :type o_auth_request: OAuthRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OAuthResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.mercury_o_auth_v2_with_http_info(**kwargs)  # noqa: E501

    def mercury_o_auth_v2_with_http_info(self, **kwargs):  # noqa: E501
        """Generate OAuth Token  # noqa: E501

        The response's bearer token must be used in the `Authorization` header for any other API request. Tokens are valid for only a period of time.  All requests, with the exception of this one, also require an API Key to be supplied in the `X-Api-Key` request header. pymetrics will supply this along with the OAuth Client ID and Secret.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_o_auth_v2_with_http_info(async_req=True)
        >>> result = thread.get()

        :param o_auth_request: OAuth2 Client Credentials
        :type o_auth_request: OAuthRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OAuthResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'o_auth_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mercury_o_auth_v2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'o_auth_request' in local_var_params:
            body_params = local_var_params['o_auth_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            201: "OAuthResponse",
            400: "ErrorResponse",
            401: "ErrorResponse",
            500: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/mercury/v2/oauth/token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def mercury_retrieve_factor_content(self, uuid, **kwargs):  # noqa: E501
        """Get Factor Content  # noqa: E501

        Gets the factor content for an assessment order by its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_retrieve_factor_content(uuid, async_req=True)
        >>> result = thread.get()

        :param uuid: The Order ID value from creating the order. (required)
        :type uuid: str
        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MercuryOrderFactorContent
        """
        kwargs['_return_http_data_only'] = True
        return self.mercury_retrieve_factor_content_with_http_info(uuid, **kwargs)  # noqa: E501

    def mercury_retrieve_factor_content_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get Factor Content  # noqa: E501

        Gets the factor content for an assessment order by its ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_retrieve_factor_content_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param uuid: The Order ID value from creating the order. (required)
        :type uuid: str
        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MercuryOrderFactorContent, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'uuid',
            'authorization',
            'x_api_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mercury_retrieve_factor_content" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uuid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uuid` when calling `mercury_retrieve_factor_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501
        if 'x_api_key' in local_var_params:
            header_params['X-Api-Key'] = local_var_params['x_api_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "MercuryOrderFactorContent",
            400: "ErrorResponse",
            404: "ErrorResponse",
            500: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/mercury/v2/factorContent/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def mercury_retrieve_order_v2(self, uuid, **kwargs):  # noqa: E501
        """Get Assessment Order  # noqa: E501

        Get an existing order by ID. It will move from `Completed` to `Fulfilled` if the order has results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_retrieve_order_v2(uuid, async_req=True)
        >>> result = thread.get()

        :param uuid: The Order ID value from creating the order. The create operation is idempotent, based on candidate.email, assessment_id, and application_id (required)
        :type uuid: str
        :param report: Set to true to optionally force a report to be generated if one does not exist
        :type report: bool
        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MercuryAssessmentOrder
        """
        kwargs['_return_http_data_only'] = True
        return self.mercury_retrieve_order_v2_with_http_info(uuid, **kwargs)  # noqa: E501

    def mercury_retrieve_order_v2_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get Assessment Order  # noqa: E501

        Get an existing order by ID. It will move from `Completed` to `Fulfilled` if the order has results.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mercury_retrieve_order_v2_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param uuid: The Order ID value from creating the order. The create operation is idempotent, based on candidate.email, assessment_id, and application_id (required)
        :type uuid: str
        :param report: Set to true to optionally force a report to be generated if one does not exist
        :type report: bool
        :param authorization: Standard Bearer token request, from `Generate OAuth Token`. Formatted `Bearer {token}`
        :type authorization: str
        :param x_api_key: Mandatory API Key that pymetrics will provide
        :type x_api_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MercuryAssessmentOrder, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'uuid',
            'report',
            'authorization',
            'x_api_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mercury_retrieve_order_v2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'uuid' is set
        if self.api_client.client_side_validation and ('uuid' not in local_var_params or  # noqa: E501
                                                        local_var_params['uuid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `uuid` when calling `mercury_retrieve_order_v2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in local_var_params:
            path_params['uuid'] = local_var_params['uuid']  # noqa: E501

        query_params = []
        if 'report' in local_var_params and local_var_params['report'] is not None:  # noqa: E501
            query_params.append(('report', local_var_params['report']))  # noqa: E501

        header_params = {}
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501
        if 'x_api_key' in local_var_params:
            header_params['X-Api-Key'] = local_var_params['x_api_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "MercuryAssessmentOrder",
            404: "ErrorResponse",
            500: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/mercury/v2/orders/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
