import typing

import httplib2  # type: ignore
import typing_extensions

import googleapiclient.discovery
import googleapiclient.http  # type: ignore

from .schemas import *

class DomainsRDAPResource(googleapiclient.discovery.Resource):
    class AutnumResource(googleapiclient.discovery.Resource):
        def get(
            self, *, autnumId: str, **kwargs: typing.Any
        ) -> RdapResponseHttpRequest: ...
    class EntityResource(googleapiclient.discovery.Resource):
        def get(
            self, *, entityId: str, **kwargs: typing.Any
        ) -> RdapResponseHttpRequest: ...
    class IpResource(googleapiclient.discovery.Resource):
        def get(
            self, *, ipId: str, ipId1: str, **kwargs: typing.Any
        ) -> RdapResponseHttpRequest: ...
    class DomainResource(googleapiclient.discovery.Resource):
        def get(
            self, *, domainName: str, **kwargs: typing.Any
        ) -> HttpBodyHttpRequest: ...
    class NameserverResource(googleapiclient.discovery.Resource):
        def get(
            self, *, nameserverId: str, **kwargs: typing.Any
        ) -> RdapResponseHttpRequest: ...
    class V1Resource(googleapiclient.discovery.Resource):
        def getNameservers(self, **kwargs: typing.Any) -> RdapResponseHttpRequest: ...
        def getIp(self, **kwargs: typing.Any) -> HttpBodyHttpRequest: ...
        def getHelp(self, **kwargs: typing.Any) -> HttpBodyHttpRequest: ...
        def getDomains(self, **kwargs: typing.Any) -> RdapResponseHttpRequest: ...
        def getEntities(self, **kwargs: typing.Any) -> RdapResponseHttpRequest: ...
    def autnum(self) -> AutnumResource: ...
    def entity(self) -> EntityResource: ...
    def ip(self) -> IpResource: ...
    def domain(self) -> DomainResource: ...
    def nameserver(self) -> NameserverResource: ...
    def v1(self) -> V1Resource: ...

class HttpBodyHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> HttpBody: ...

class RdapResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> RdapResponse: ...
