"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbFargateServices = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const route53 = require("@aws-cdk/aws-route53");
const targets = require("@aws-cdk/aws-route53-targets");
const cdk = require("@aws-cdk/core");
const cdknag = require("./cdknag");
const main_1 = require("./main");
/**
 * @stability stable
 */
class AlbFargateServices extends main_1.BaseFargateServices {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, props);
        // create the access log bucket
        const accessLogBucket = new cdknag.AccessLogDeliveryBucket(this, 'AccessLogBucket').bucket;
        if (this.hasExternalLoadBalancer) {
            this.externalAlb = new elbv2.ApplicationLoadBalancer(this, 'ExternalAlb', {
                vpc: this.vpc,
                internetFacing: true,
            });
            this.externalAlb.logAccessLogs(accessLogBucket, `${id}-extalblog`);
        }
        if (this.hasInternalLoadBalancer) {
            this.internalAlb = new elbv2.ApplicationLoadBalancer(this, 'InternalAlb', {
                vpc: this.vpc,
                internetFacing: false,
            });
            this.internalAlb.logAccessLogs(accessLogBucket, `${id}-intalblog`);
        }
        props.tasks.forEach((t, index) => {
            var _b, _c, _d, _e, _f, _g, _h, _j, _k;
            const defaultContainerName = (_b = t.task.defaultContainer) === null || _b === void 0 ? void 0 : _b.containerName;
            // default scaling policy
            const scaling = this.service[index].autoScaleTaskCount({ maxCapacity: (_d = (_c = t.scalingPolicy) === null || _c === void 0 ? void 0 : _c.maxCapacity) !== null && _d !== void 0 ? _d : 10 });
            scaling.scaleOnCpuUtilization('CpuScaling', {
                targetUtilizationPercent: (_f = (_e = t.scalingPolicy) === null || _e === void 0 ? void 0 : _e.targetCpuUtilization) !== null && _f !== void 0 ? _f : 50,
            });
            if (t.accessibility != main_1.LoadBalancerAccessibility.INTERNAL_ONLY) {
                const exttg = new elbv2.ApplicationTargetGroup(this, `${defaultContainerName}ExtTG`, {
                    protocol: elbv2.ApplicationProtocol.HTTP,
                    vpc: this.vpc,
                });
                // listener for the external ALB
                new elbv2.ApplicationListener(this, `ExtAlbListener${t.listenerPort}`, {
                    loadBalancer: this.externalAlb,
                    open: true,
                    port: t.listenerPort,
                    protocol: elbv2.ApplicationProtocol.HTTP,
                    defaultTargetGroups: [exttg],
                });
                scaling.scaleOnRequestCount('RequestScaling', {
                    requestsPerTarget: (_h = (_g = t.scalingPolicy) === null || _g === void 0 ? void 0 : _g.requestPerTarget) !== null && _h !== void 0 ? _h : 1000,
                    targetGroup: exttg,
                });
                exttg.addTarget(this.service[index]);
            }
            if (t.accessibility != main_1.LoadBalancerAccessibility.EXTERNAL_ONLY) {
                const inttg = new elbv2.ApplicationTargetGroup(this, `${defaultContainerName}IntTG`, {
                    protocol: elbv2.ApplicationProtocol.HTTP,
                    vpc: this.vpc,
                });
                // listener for the internal ALB
                new elbv2.ApplicationListener(this, `IntAlbListener${t.listenerPort}`, {
                    loadBalancer: this.internalAlb,
                    open: true,
                    port: t.listenerPort,
                    protocol: elbv2.ApplicationProtocol.HTTP,
                    defaultTargetGroups: [inttg],
                });
                // extra scaling policy
                scaling.scaleOnRequestCount('RequestScaling2', {
                    requestsPerTarget: (_k = (_j = t.scalingPolicy) === null || _j === void 0 ? void 0 : _j.requestPerTarget) !== null && _k !== void 0 ? _k : 1000,
                    targetGroup: inttg,
                });
                inttg.addTarget(this.service[index]);
            }
        });
        // Route53
        const externalAlbRecordName = (_c = (_b = props.route53Ops) === null || _b === void 0 ? void 0 : _b.externalElbRecordName) !== null && _c !== void 0 ? _c : 'external';
        const internalAlbRecordName = (_e = (_d = props.route53Ops) === null || _d === void 0 ? void 0 : _d.internalElbRecordName) !== null && _e !== void 0 ? _e : 'internal';
        const zone = new route53.PrivateHostedZone(this, 'HostedZone', {
            zoneName: this.zoneName,
            vpc: this.vpc,
        });
        if (this.hasInternalLoadBalancer) {
            new route53.ARecord(this, 'InternalAlbAlias', {
                zone,
                recordName: internalAlbRecordName,
                target: route53.RecordTarget.fromAlias(new targets.LoadBalancerTarget(this.internalAlb)),
            });
        }
        if (this.hasExternalLoadBalancer) {
            new route53.ARecord(this, 'ExternalAlbAlias', {
                zone,
                recordName: externalAlbRecordName,
                target: route53.RecordTarget.fromAlias(new targets.LoadBalancerTarget(this.externalAlb)),
            });
        }
        if (this.hasExternalLoadBalancer) {
            new cdk.CfnOutput(this, 'ExternalEndpoint', { value: `http://${this.externalAlb.loadBalancerDnsName}` });
            new cdk.CfnOutput(this, 'ExternalEndpointPrivate', { value: `http://${externalAlbRecordName}.${this.zoneName}` });
        }
        if (this.hasInternalLoadBalancer) {
            new cdk.CfnOutput(this, 'InternalEndpoint', { value: `http://${this.internalAlb.loadBalancerDnsName}` });
            new cdk.CfnOutput(this, 'InternalEndpointPrivate', { value: `http://${internalAlbRecordName}.${this.zoneName}` });
        }
        // ensure the dependency
        const cp = this.node.tryFindChild('Cluster');
        this.service.forEach(s => {
            s.node.addDependency(cp);
        });
        // add solution ID for the stack
        if (!cdk.Stack.of(this).templateOptions.description) {
            cdk.Stack.of(this).templateOptions.description = '(SO8030) - AWS CDK stack with serverless-container-constructs';
        }
        /**
         * suppress the cdk-nag rules
         */
        if (this.externalAlb) {
            let sg;
            sg = this.externalAlb.node.tryFindChild('SecurityGroup');
            cdknag.Suppress.securityGroup(sg, [
                {
                    id: 'AwsSolutions-EC23',
                    reason: 'public ALB requires 0.0.0.0/0 inbound access',
                },
            ]);
        }
        if (this.internalAlb) {
            let sg;
            sg = this.internalAlb.node.tryFindChild('SecurityGroup');
            cdknag.Suppress.securityGroup(sg, [
                {
                    id: 'AwsSolutions-EC23',
                    reason: 'internal ALB requires 0.0.0.0/0 inbound access',
                },
            ]);
        }
        props.tasks.forEach(t => {
            var _b, _c;
            let cfnPolicy = (_b = t.task.executionRole) === null || _b === void 0 ? void 0 : _b.node.tryFindChild('DefaultPolicy');
            cdknag.Suppress.iamPolicy(cfnPolicy, [
                {
                    id: 'AwsSolutions-IAM5',
                    reason: 'ecr:GetAuthorizationToken requires wildcard resource',
                },
            ]);
            cfnPolicy = (_c = t.task.taskRole) === null || _c === void 0 ? void 0 : _c.node.tryFindChild('DefaultPolicy');
            cdknag.Suppress.iamPolicy(cfnPolicy, [
                {
                    id: 'AwsSolutions-IAM5',
                    reason: 'task role with ECS exec support requires wildcard resource for ssmmessages. see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html',
                },
            ]);
        });
    }
}
exports.AlbFargateServices = AlbFargateServices;
_a = JSII_RTTI_SYMBOL_1;
AlbFargateServices[_a] = { fqn: "serverless-container-constructs.AlbFargateServices", version: "0.1.12" };
//# sourceMappingURL=data:application/json;base64,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