# Generated by Django 4.0 on 2021-12-15 06:20

import django.contrib.postgres.fields
import django.contrib.postgres.indexes
import django.contrib.postgres.search
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import urlid_graph.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Entity',
            fields=[
                ('uuid', models.UUIDField(primary_key=True, serialize=False)),
                ('base_url', models.TextField()),
                ('name', models.TextField()),
                ('version', models.TextField()),
            ],
            managers=[
                ('brasilio', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='ObjectRepository',
            fields=[
                ('uuid', models.UUIDField(primary_key=True, serialize=False)),
                ('search_data', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('entity', models.ForeignKey(db_constraint=False, db_index=False, on_delete=django.db.models.deletion.DO_NOTHING, to='urlid_graph.entity')),
            ],
            bases=(urlid_graph.models.ObjectMixin, models.Model),
        ),
        migrations.CreateModel(
            name='ElementConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('config_type', models.PositiveSmallIntegerField(choices=[(1, 'entity'), (2, 'relationship'), (3, 'property'), (4, 'stats')])),
                ('name', models.TextField()),
                ('parent_type', models.PositiveSmallIntegerField(choices=[(1, 'entity'), (2, 'relationship')], null=True)),
                ('parent_name', models.TextField(null=True)),
                ('label', models.TextField()),
                ('data', models.JSONField()),
            ],
            options={
                'unique_together': {('config_type', 'name', 'parent_type', 'parent_name')},
            },
        ),
        migrations.CreateModel(
            name='EntityConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='EntityPropertyConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='RelationshipConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='RelPropertyConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='StatsConfig',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('urlid_graph.elementconfig',),
        ),
        migrations.CreateModel(
            name='SavedGraph',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('edges', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), size=None)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.user')),
            ],
            options={
                'unique_together': {('user', 'name')},
            },
        ),
        migrations.AddIndex(
            model_name='objectrepository',
            index=django.contrib.postgres.indexes.GinIndex(fields=['search_data'], name='urlid_graph_search__f39787_gin'),
        ),
        migrations.AlterUniqueTogether(
            name='objectrepository',
            unique_together={('entity', 'uuid')},
        ),
    ]
