# coding: utf-8

"""
    CMS Contribution API

    The CMS Contribution API allows access and modification of Lumapps contents.   # noqa: E501

    OpenAPI spec version: 0.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

from .base_block import BaseBlock  # noqa: F401,E501


class BlockEventMetadata(BaseBlock):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "event_id": "str",
        "starts_at": "datetime",
        "ends_at": "datetime",
        "location": "str",
        "external_url": "str",
        "external_url_label": "EventLinkLabel",
        "attendees": "list[UserReference]",
        "attendees_count": "int",
        "is_user_registered": "bool",
        "add_to_google_calendar_url": "str",
        "add_to_outlook_calendar_url": "str",
        "organizers": "list[UserReference]",
        "title": "str",
        "intro": "str",
    }
    if hasattr(BaseBlock, "swagger_types"):
        swagger_types.update(BaseBlock.swagger_types)

    attribute_map = {
        "event_id": "eventId",
        "starts_at": "startsAt",
        "ends_at": "endsAt",
        "location": "location",
        "external_url": "externalUrl",
        "external_url_label": "externalUrlLabel",
        "attendees": "attendees",
        "attendees_count": "attendeesCount",
        "is_user_registered": "isUserRegistered",
        "add_to_google_calendar_url": "addToGoogleCalendarUrl",
        "add_to_outlook_calendar_url": "addToOutlookCalendarUrl",
        "organizers": "organizers",
        "title": "title",
        "intro": "intro",
    }
    if hasattr(BaseBlock, "attribute_map"):
        attribute_map.update(BaseBlock.attribute_map)

    def __init__(
        self,
        event_id=None,
        starts_at=None,
        ends_at=None,
        location=None,
        external_url=None,
        external_url_label=None,
        attendees=None,
        attendees_count=None,
        is_user_registered=None,
        add_to_google_calendar_url=None,
        add_to_outlook_calendar_url=None,
        organizers=None,
        title=None,
        intro=None,
        *args,
        **kwargs
    ):  # noqa: E501
        """BlockEventMetadata - a model defined in Swagger"""  # noqa: E501
        self._event_id = None
        self._starts_at = None
        self._ends_at = None
        self._location = None
        self._external_url = None
        self._external_url_label = None
        self._attendees = None
        self._attendees_count = None
        self._is_user_registered = None
        self._add_to_google_calendar_url = None
        self._add_to_outlook_calendar_url = None
        self._organizers = None
        self._title = None
        self._intro = None
        self.discriminator = None
        if event_id is not None:
            self.event_id = event_id
        self.starts_at = starts_at
        self.ends_at = ends_at
        if location is not None:
            self.location = location
        if external_url is not None:
            self.external_url = external_url
        if external_url_label is not None:
            self.external_url_label = external_url_label
        if attendees is not None:
            self.attendees = attendees
        if attendees_count is not None:
            self.attendees_count = attendees_count
        self.is_user_registered = is_user_registered
        self.add_to_google_calendar_url = add_to_google_calendar_url
        self.add_to_outlook_calendar_url = add_to_outlook_calendar_url
        self.organizers = organizers
        self.title = title
        if intro is not None:
            self.intro = intro
        BaseBlock.__init__(self, *args, **kwargs)

    @property
    def event_id(self):
        """Gets the event_id of this BlockEventMetadata.  # noqa: E501

        The event's id.  # noqa: E501

        :return: The event_id of this BlockEventMetadata.  # noqa: E501
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """Sets the event_id of this BlockEventMetadata.

        The event's id.  # noqa: E501

        :param event_id: The event_id of this BlockEventMetadata.  # noqa: E501
        :type: str
        """

        self._event_id = event_id

    @property
    def starts_at(self):
        """Gets the starts_at of this BlockEventMetadata.  # noqa: E501

        The event's start date and time  # noqa: E501

        :return: The starts_at of this BlockEventMetadata.  # noqa: E501
        :rtype: datetime
        """
        return self._starts_at

    @starts_at.setter
    def starts_at(self, starts_at):
        """Sets the starts_at of this BlockEventMetadata.

        The event's start date and time  # noqa: E501

        :param starts_at: The starts_at of this BlockEventMetadata.  # noqa: E501
        :type: datetime
        """
        if starts_at is None:
            raise ValueError(
                "Invalid value for `starts_at`, must not be `None`"
            )  # noqa: E501

        self._starts_at = starts_at

    @property
    def ends_at(self):
        """Gets the ends_at of this BlockEventMetadata.  # noqa: E501

        The event's end date and time  # noqa: E501

        :return: The ends_at of this BlockEventMetadata.  # noqa: E501
        :rtype: datetime
        """
        return self._ends_at

    @ends_at.setter
    def ends_at(self, ends_at):
        """Sets the ends_at of this BlockEventMetadata.

        The event's end date and time  # noqa: E501

        :param ends_at: The ends_at of this BlockEventMetadata.  # noqa: E501
        :type: datetime
        """
        if ends_at is None:
            raise ValueError(
                "Invalid value for `ends_at`, must not be `None`"
            )  # noqa: E501

        self._ends_at = ends_at

    @property
    def location(self):
        """Gets the location of this BlockEventMetadata.  # noqa: E501

        The event's location, e.g. Yellow Meeting Room. Not to be confused with a localization. Not translatable either.   # noqa: E501

        :return: The location of this BlockEventMetadata.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this BlockEventMetadata.

        The event's location, e.g. Yellow Meeting Room. Not to be confused with a localization. Not translatable either.   # noqa: E501

        :param location: The location of this BlockEventMetadata.  # noqa: E501
        :type: str
        """

        self._location = location

    @property
    def external_url(self):
        """Gets the external_url of this BlockEventMetadata.  # noqa: E501

        The url used to access an online event  # noqa: E501

        :return: The external_url of this BlockEventMetadata.  # noqa: E501
        :rtype: str
        """
        return self._external_url

    @external_url.setter
    def external_url(self, external_url):
        """Sets the external_url of this BlockEventMetadata.

        The url used to access an online event  # noqa: E501

        :param external_url: The external_url of this BlockEventMetadata.  # noqa: E501
        :type: str
        """

        self._external_url = external_url

    @property
    def external_url_label(self):
        """Gets the external_url_label of this BlockEventMetadata.  # noqa: E501


        :return: The external_url_label of this BlockEventMetadata.  # noqa: E501
        :rtype: EventLinkLabel
        """
        return self._external_url_label

    @external_url_label.setter
    def external_url_label(self, external_url_label):
        """Sets the external_url_label of this BlockEventMetadata.


        :param external_url_label: The external_url_label of this BlockEventMetadata.  # noqa: E501
        :type: EventLinkLabel
        """

        self._external_url_label = external_url_label

    @property
    def attendees(self):
        """Gets the attendees of this BlockEventMetadata.  # noqa: E501

        Four attendees of the event (ordered by emails)  # noqa: E501

        :return: The attendees of this BlockEventMetadata.  # noqa: E501
        :rtype: list[UserReference]
        """
        return self._attendees

    @attendees.setter
    def attendees(self, attendees):
        """Sets the attendees of this BlockEventMetadata.

        Four attendees of the event (ordered by emails)  # noqa: E501

        :param attendees: The attendees of this BlockEventMetadata.  # noqa: E501
        :type: list[UserReference]
        """

        self._attendees = attendees

    @property
    def attendees_count(self):
        """Gets the attendees_count of this BlockEventMetadata.  # noqa: E501

        The total number of attendees  # noqa: E501

        :return: The attendees_count of this BlockEventMetadata.  # noqa: E501
        :rtype: int
        """
        return self._attendees_count

    @attendees_count.setter
    def attendees_count(self, attendees_count):
        """Sets the attendees_count of this BlockEventMetadata.

        The total number of attendees  # noqa: E501

        :param attendees_count: The attendees_count of this BlockEventMetadata.  # noqa: E501
        :type: int
        """

        self._attendees_count = attendees_count

    @property
    def is_user_registered(self):
        """Gets the is_user_registered of this BlockEventMetadata.  # noqa: E501

        Whether the current user is registered for the event.  # noqa: E501

        :return: The is_user_registered of this BlockEventMetadata.  # noqa: E501
        :rtype: bool
        """
        return self._is_user_registered

    @is_user_registered.setter
    def is_user_registered(self, is_user_registered):
        """Sets the is_user_registered of this BlockEventMetadata.

        Whether the current user is registered for the event.  # noqa: E501

        :param is_user_registered: The is_user_registered of this BlockEventMetadata.  # noqa: E501
        :type: bool
        """
        if is_user_registered is None:
            raise ValueError(
                "Invalid value for `is_user_registered`, must not be `None`"
            )  # noqa: E501

        self._is_user_registered = is_user_registered

    @property
    def add_to_google_calendar_url(self):
        """Gets the add_to_google_calendar_url of this BlockEventMetadata.  # noqa: E501

        An \"Add to my calendar\" URL for Google Calendar  # noqa: E501

        :return: The add_to_google_calendar_url of this BlockEventMetadata.  # noqa: E501
        :rtype: str
        """
        return self._add_to_google_calendar_url

    @add_to_google_calendar_url.setter
    def add_to_google_calendar_url(self, add_to_google_calendar_url):
        """Sets the add_to_google_calendar_url of this BlockEventMetadata.

        An \"Add to my calendar\" URL for Google Calendar  # noqa: E501

        :param add_to_google_calendar_url: The add_to_google_calendar_url of this BlockEventMetadata.  # noqa: E501
        :type: str
        """
        if add_to_google_calendar_url is None:
            raise ValueError(
                "Invalid value for `add_to_google_calendar_url`, must not be `None`"
            )  # noqa: E501

        self._add_to_google_calendar_url = add_to_google_calendar_url

    @property
    def add_to_outlook_calendar_url(self):
        """Gets the add_to_outlook_calendar_url of this BlockEventMetadata.  # noqa: E501

        An \"Add to my calendar\" URL for outlook Calendar  # noqa: E501

        :return: The add_to_outlook_calendar_url of this BlockEventMetadata.  # noqa: E501
        :rtype: str
        """
        return self._add_to_outlook_calendar_url

    @add_to_outlook_calendar_url.setter
    def add_to_outlook_calendar_url(self, add_to_outlook_calendar_url):
        """Sets the add_to_outlook_calendar_url of this BlockEventMetadata.

        An \"Add to my calendar\" URL for outlook Calendar  # noqa: E501

        :param add_to_outlook_calendar_url: The add_to_outlook_calendar_url of this BlockEventMetadata.  # noqa: E501
        :type: str
        """
        if add_to_outlook_calendar_url is None:
            raise ValueError(
                "Invalid value for `add_to_outlook_calendar_url`, must not be `None`"
            )  # noqa: E501

        self._add_to_outlook_calendar_url = add_to_outlook_calendar_url

    @property
    def organizers(self):
        """Gets the organizers of this BlockEventMetadata.  # noqa: E501

        The organizers of the event.  # noqa: E501

        :return: The organizers of this BlockEventMetadata.  # noqa: E501
        :rtype: list[UserReference]
        """
        return self._organizers

    @organizers.setter
    def organizers(self, organizers):
        """Sets the organizers of this BlockEventMetadata.

        The organizers of the event.  # noqa: E501

        :param organizers: The organizers of this BlockEventMetadata.  # noqa: E501
        :type: list[UserReference]
        """
        if organizers is None:
            raise ValueError(
                "Invalid value for `organizers`, must not be `None`"
            )  # noqa: E501

        self._organizers = organizers

    @property
    def title(self):
        """Gets the title of this BlockEventMetadata.  # noqa: E501

        The title of the event.  # noqa: E501

        :return: The title of this BlockEventMetadata.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this BlockEventMetadata.

        The title of the event.  # noqa: E501

        :param title: The title of this BlockEventMetadata.  # noqa: E501
        :type: str
        """
        if title is None:
            raise ValueError(
                "Invalid value for `title`, must not be `None`"
            )  # noqa: E501

        self._title = title

    @property
    def intro(self):
        """Gets the intro of this BlockEventMetadata.  # noqa: E501

        The event introduction.  # noqa: E501

        :return: The intro of this BlockEventMetadata.  # noqa: E501
        :rtype: str
        """
        return self._intro

    @intro.setter
    def intro(self, intro):
        """Sets the intro of this BlockEventMetadata.

        The event introduction.  # noqa: E501

        :param intro: The intro of this BlockEventMetadata.  # noqa: E501
        :type: str
        """

        self._intro = intro

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(BlockEventMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlockEventMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
