# coding: utf-8

"""
    CMS Contribution API

    The CMS Contribution API allows access and modification of Lumapps contents.   # noqa: E501

    OpenAPI spec version: 0.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

from .base_block import BaseBlock  # noqa: F401,E501


class BlockPost(BaseBlock):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        "post_id": "str",
        "post_type": "str",
        "community": "CommunityInfo",
        "site": "SiteReference",
        "author": "UserReference",
        "reports": "BlockInappropriate",
        "shares": "list[PostShare]",
        "share_count": "int",
        "event_starts_at": "datetime",
        "event_ends_at": "datetime",
        "is_answered": "bool",
        "title": "str",
        "content": "str",
        "visible_lines": "int",
        "can_share": "bool",
        "can_edit": "bool",
        "can_move": "bool",
        "can_delete": "bool",
        "user_mentions": "list[UserReference]",
        "links": "list[AttachedLink]",
        "tags": "BlockTagReferenceList",
        "files": "list[MediaPreview]",
        "images": "list[MediaPreview]",
        "reactions": "BlockReactions",
        "votes": "BlockVotes",
        "idea_status": "IdeaStatus",
        "article_preview": "ArticlePreview",
        "play_video_preview": "PlayVideoPreview",
        "order": "list[str]",
        "version": "int",
    }
    if hasattr(BaseBlock, "swagger_types"):
        swagger_types.update(BaseBlock.swagger_types)

    attribute_map = {
        "post_id": "postId",
        "post_type": "postType",
        "community": "community",
        "site": "site",
        "author": "author",
        "reports": "reports",
        "shares": "shares",
        "share_count": "shareCount",
        "event_starts_at": "eventStartsAt",
        "event_ends_at": "eventEndsAt",
        "is_answered": "isAnswered",
        "title": "title",
        "content": "content",
        "visible_lines": "visibleLines",
        "can_share": "canShare",
        "can_edit": "canEdit",
        "can_move": "canMove",
        "can_delete": "canDelete",
        "user_mentions": "userMentions",
        "links": "links",
        "tags": "tags",
        "files": "files",
        "images": "images",
        "reactions": "reactions",
        "votes": "votes",
        "idea_status": "ideaStatus",
        "article_preview": "articlePreview",
        "play_video_preview": "playVideoPreview",
        "order": "order",
        "version": "version",
    }
    if hasattr(BaseBlock, "attribute_map"):
        attribute_map.update(BaseBlock.attribute_map)

    def __init__(
        self,
        post_id=None,
        post_type=None,
        community=None,
        site=None,
        author=None,
        reports=None,
        shares=None,
        share_count=None,
        event_starts_at=None,
        event_ends_at=None,
        is_answered=None,
        title=None,
        content=None,
        visible_lines=10,
        can_share=None,
        can_edit=None,
        can_move=None,
        can_delete=None,
        user_mentions=None,
        links=None,
        tags=None,
        files=None,
        images=None,
        reactions=None,
        votes=None,
        idea_status=None,
        article_preview=None,
        play_video_preview=None,
        order=None,
        version=0,
        *args,
        **kwargs
    ):  # noqa: E501
        """BlockPost - a model defined in Swagger"""  # noqa: E501
        self._post_id = None
        self._post_type = None
        self._community = None
        self._site = None
        self._author = None
        self._reports = None
        self._shares = None
        self._share_count = None
        self._event_starts_at = None
        self._event_ends_at = None
        self._is_answered = None
        self._title = None
        self._content = None
        self._visible_lines = None
        self._can_share = None
        self._can_edit = None
        self._can_move = None
        self._can_delete = None
        self._user_mentions = None
        self._links = None
        self._tags = None
        self._files = None
        self._images = None
        self._reactions = None
        self._votes = None
        self._idea_status = None
        self._article_preview = None
        self._play_video_preview = None
        self._order = None
        self._version = None
        self.discriminator = None
        self.post_id = post_id
        self.post_type = post_type
        self.community = community
        self.site = site
        self.author = author
        if reports is not None:
            self.reports = reports
        self.shares = shares
        self.share_count = share_count
        if event_starts_at is not None:
            self.event_starts_at = event_starts_at
        if event_ends_at is not None:
            self.event_ends_at = event_ends_at
        if is_answered is not None:
            self.is_answered = is_answered
        if title is not None:
            self.title = title
        if content is not None:
            self.content = content
        self.visible_lines = visible_lines
        self.can_share = can_share
        self.can_edit = can_edit
        self.can_move = can_move
        self.can_delete = can_delete
        if user_mentions is not None:
            self.user_mentions = user_mentions
        if links is not None:
            self.links = links
        if tags is not None:
            self.tags = tags
        if files is not None:
            self.files = files
        if images is not None:
            self.images = images
        if reactions is not None:
            self.reactions = reactions
        if votes is not None:
            self.votes = votes
        if idea_status is not None:
            self.idea_status = idea_status
        if article_preview is not None:
            self.article_preview = article_preview
        if play_video_preview is not None:
            self.play_video_preview = play_video_preview
        if order is not None:
            self.order = order
        self.version = version
        BaseBlock.__init__(self, *args, **kwargs)

    @property
    def post_id(self):
        """Gets the post_id of this BlockPost.  # noqa: E501

        The post's id.  # noqa: E501

        :return: The post_id of this BlockPost.  # noqa: E501
        :rtype: str
        """
        return self._post_id

    @post_id.setter
    def post_id(self, post_id):
        """Sets the post_id of this BlockPost.

        The post's id.  # noqa: E501

        :param post_id: The post_id of this BlockPost.  # noqa: E501
        :type: str
        """
        if post_id is None:
            raise ValueError(
                "Invalid value for `post_id`, must not be `None`"
            )  # noqa: E501

        self._post_id = post_id

    @property
    def post_type(self):
        """Gets the post_type of this BlockPost.  # noqa: E501

        The post's type.  # noqa: E501

        :return: The post_type of this BlockPost.  # noqa: E501
        :rtype: str
        """
        return self._post_type

    @post_type.setter
    def post_type(self, post_type):
        """Sets the post_type of this BlockPost.

        The post's type.  # noqa: E501

        :param post_type: The post_type of this BlockPost.  # noqa: E501
        :type: str
        """
        if post_type is None:
            raise ValueError(
                "Invalid value for `post_type`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["DEFAULT", "EVENT", "IDEA", "QUESTION"]  # noqa: E501
        if post_type not in allowed_values:
            raise ValueError(
                "Invalid value for `post_type` ({0}), must be one of {1}".format(  # noqa: E501
                    post_type, allowed_values
                )
            )

        self._post_type = post_type

    @property
    def community(self):
        """Gets the community of this BlockPost.  # noqa: E501


        :return: The community of this BlockPost.  # noqa: E501
        :rtype: CommunityInfo
        """
        return self._community

    @community.setter
    def community(self, community):
        """Sets the community of this BlockPost.


        :param community: The community of this BlockPost.  # noqa: E501
        :type: CommunityInfo
        """
        if community is None:
            raise ValueError(
                "Invalid value for `community`, must not be `None`"
            )  # noqa: E501

        self._community = community

    @property
    def site(self):
        """Gets the site of this BlockPost.  # noqa: E501


        :return: The site of this BlockPost.  # noqa: E501
        :rtype: SiteReference
        """
        return self._site

    @site.setter
    def site(self, site):
        """Sets the site of this BlockPost.


        :param site: The site of this BlockPost.  # noqa: E501
        :type: SiteReference
        """
        if site is None:
            raise ValueError(
                "Invalid value for `site`, must not be `None`"
            )  # noqa: E501

        self._site = site

    @property
    def author(self):
        """Gets the author of this BlockPost.  # noqa: E501


        :return: The author of this BlockPost.  # noqa: E501
        :rtype: UserReference
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this BlockPost.


        :param author: The author of this BlockPost.  # noqa: E501
        :type: UserReference
        """
        if author is None:
            raise ValueError(
                "Invalid value for `author`, must not be `None`"
            )  # noqa: E501

        self._author = author

    @property
    def reports(self):
        """Gets the reports of this BlockPost.  # noqa: E501


        :return: The reports of this BlockPost.  # noqa: E501
        :rtype: BlockInappropriate
        """
        return self._reports

    @reports.setter
    def reports(self, reports):
        """Sets the reports of this BlockPost.


        :param reports: The reports of this BlockPost.  # noqa: E501
        :type: BlockInappropriate
        """

        self._reports = reports

    @property
    def shares(self):
        """Gets the shares of this BlockPost.  # noqa: E501


        :return: The shares of this BlockPost.  # noqa: E501
        :rtype: list[PostShare]
        """
        return self._shares

    @shares.setter
    def shares(self, shares):
        """Sets the shares of this BlockPost.


        :param shares: The shares of this BlockPost.  # noqa: E501
        :type: list[PostShare]
        """
        if shares is None:
            raise ValueError(
                "Invalid value for `shares`, must not be `None`"
            )  # noqa: E501

        self._shares = shares

    @property
    def share_count(self):
        """Gets the share_count of this BlockPost.  # noqa: E501

        The number of communities where the post is shared, regardless of user permissions.  # noqa: E501

        :return: The share_count of this BlockPost.  # noqa: E501
        :rtype: int
        """
        return self._share_count

    @share_count.setter
    def share_count(self, share_count):
        """Sets the share_count of this BlockPost.

        The number of communities where the post is shared, regardless of user permissions.  # noqa: E501

        :param share_count: The share_count of this BlockPost.  # noqa: E501
        :type: int
        """
        if share_count is None:
            raise ValueError(
                "Invalid value for `share_count`, must not be `None`"
            )  # noqa: E501

        self._share_count = share_count

    @property
    def event_starts_at(self):
        """Gets the event_starts_at of this BlockPost.  # noqa: E501

        The event start date and time.  # noqa: E501

        :return: The event_starts_at of this BlockPost.  # noqa: E501
        :rtype: datetime
        """
        return self._event_starts_at

    @event_starts_at.setter
    def event_starts_at(self, event_starts_at):
        """Sets the event_starts_at of this BlockPost.

        The event start date and time.  # noqa: E501

        :param event_starts_at: The event_starts_at of this BlockPost.  # noqa: E501
        :type: datetime
        """

        self._event_starts_at = event_starts_at

    @property
    def event_ends_at(self):
        """Gets the event_ends_at of this BlockPost.  # noqa: E501

        The event end date and time.  # noqa: E501

        :return: The event_ends_at of this BlockPost.  # noqa: E501
        :rtype: datetime
        """
        return self._event_ends_at

    @event_ends_at.setter
    def event_ends_at(self, event_ends_at):
        """Sets the event_ends_at of this BlockPost.

        The event end date and time.  # noqa: E501

        :param event_ends_at: The event_ends_at of this BlockPost.  # noqa: E501
        :type: datetime
        """

        self._event_ends_at = event_ends_at

    @property
    def is_answered(self):
        """Gets the is_answered of this BlockPost.  # noqa: E501

        Whether the question asked in the post is answered.  # noqa: E501

        :return: The is_answered of this BlockPost.  # noqa: E501
        :rtype: bool
        """
        return self._is_answered

    @is_answered.setter
    def is_answered(self, is_answered):
        """Sets the is_answered of this BlockPost.

        Whether the question asked in the post is answered.  # noqa: E501

        :param is_answered: The is_answered of this BlockPost.  # noqa: E501
        :type: bool
        """

        self._is_answered = is_answered

    @property
    def title(self):
        """Gets the title of this BlockPost.  # noqa: E501

        The post's title.  # noqa: E501

        :return: The title of this BlockPost.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this BlockPost.

        The post's title.  # noqa: E501

        :param title: The title of this BlockPost.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def content(self):
        """Gets the content of this BlockPost.  # noqa: E501

        The post's content, in markdown or DITA format.  # noqa: E501

        :return: The content of this BlockPost.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this BlockPost.

        The post's content, in markdown or DITA format.  # noqa: E501

        :param content: The content of this BlockPost.  # noqa: E501
        :type: str
        """

        self._content = content

    @property
    def visible_lines(self):
        """Gets the visible_lines of this BlockPost.  # noqa: E501

        The number of lines of the post's content that are visible  # noqa: E501

        :return: The visible_lines of this BlockPost.  # noqa: E501
        :rtype: int
        """
        return self._visible_lines

    @visible_lines.setter
    def visible_lines(self, visible_lines):
        """Sets the visible_lines of this BlockPost.

        The number of lines of the post's content that are visible  # noqa: E501

        :param visible_lines: The visible_lines of this BlockPost.  # noqa: E501
        :type: int
        """
        if visible_lines is None:
            raise ValueError(
                "Invalid value for `visible_lines`, must not be `None`"
            )  # noqa: E501

        self._visible_lines = visible_lines

    @property
    def can_share(self):
        """Gets the can_share of this BlockPost.  # noqa: E501

        Whether the user is allowed to share the post to other communities.  # noqa: E501

        :return: The can_share of this BlockPost.  # noqa: E501
        :rtype: bool
        """
        return self._can_share

    @can_share.setter
    def can_share(self, can_share):
        """Sets the can_share of this BlockPost.

        Whether the user is allowed to share the post to other communities.  # noqa: E501

        :param can_share: The can_share of this BlockPost.  # noqa: E501
        :type: bool
        """
        if can_share is None:
            raise ValueError(
                "Invalid value for `can_share`, must not be `None`"
            )  # noqa: E501

        self._can_share = can_share

    @property
    def can_edit(self):
        """Gets the can_edit of this BlockPost.  # noqa: E501

        Whether the user is allowed to edit the post.  # noqa: E501

        :return: The can_edit of this BlockPost.  # noqa: E501
        :rtype: bool
        """
        return self._can_edit

    @can_edit.setter
    def can_edit(self, can_edit):
        """Sets the can_edit of this BlockPost.

        Whether the user is allowed to edit the post.  # noqa: E501

        :param can_edit: The can_edit of this BlockPost.  # noqa: E501
        :type: bool
        """
        if can_edit is None:
            raise ValueError(
                "Invalid value for `can_edit`, must not be `None`"
            )  # noqa: E501

        self._can_edit = can_edit

    @property
    def can_move(self):
        """Gets the can_move of this BlockPost.  # noqa: E501

        Whether the user is allowed to move the post to a different community.  # noqa: E501

        :return: The can_move of this BlockPost.  # noqa: E501
        :rtype: bool
        """
        return self._can_move

    @can_move.setter
    def can_move(self, can_move):
        """Sets the can_move of this BlockPost.

        Whether the user is allowed to move the post to a different community.  # noqa: E501

        :param can_move: The can_move of this BlockPost.  # noqa: E501
        :type: bool
        """
        if can_move is None:
            raise ValueError(
                "Invalid value for `can_move`, must not be `None`"
            )  # noqa: E501

        self._can_move = can_move

    @property
    def can_delete(self):
        """Gets the can_delete of this BlockPost.  # noqa: E501

        Whether the user is allowed to delete the post.  # noqa: E501

        :return: The can_delete of this BlockPost.  # noqa: E501
        :rtype: bool
        """
        return self._can_delete

    @can_delete.setter
    def can_delete(self, can_delete):
        """Sets the can_delete of this BlockPost.

        Whether the user is allowed to delete the post.  # noqa: E501

        :param can_delete: The can_delete of this BlockPost.  # noqa: E501
        :type: bool
        """
        if can_delete is None:
            raise ValueError(
                "Invalid value for `can_delete`, must not be `None`"
            )  # noqa: E501

        self._can_delete = can_delete

    @property
    def user_mentions(self):
        """Gets the user_mentions of this BlockPost.  # noqa: E501

        The users mentioned in the post.  # noqa: E501

        :return: The user_mentions of this BlockPost.  # noqa: E501
        :rtype: list[UserReference]
        """
        return self._user_mentions

    @user_mentions.setter
    def user_mentions(self, user_mentions):
        """Sets the user_mentions of this BlockPost.

        The users mentioned in the post.  # noqa: E501

        :param user_mentions: The user_mentions of this BlockPost.  # noqa: E501
        :type: list[UserReference]
        """

        self._user_mentions = user_mentions

    @property
    def links(self):
        """Gets the links of this BlockPost.  # noqa: E501

        The links attached to the post.  # noqa: E501

        :return: The links of this BlockPost.  # noqa: E501
        :rtype: list[AttachedLink]
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this BlockPost.

        The links attached to the post.  # noqa: E501

        :param links: The links of this BlockPost.  # noqa: E501
        :type: list[AttachedLink]
        """

        self._links = links

    @property
    def tags(self):
        """Gets the tags of this BlockPost.  # noqa: E501


        :return: The tags of this BlockPost.  # noqa: E501
        :rtype: BlockTagReferenceList
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this BlockPost.


        :param tags: The tags of this BlockPost.  # noqa: E501
        :type: BlockTagReferenceList
        """

        self._tags = tags

    @property
    def files(self):
        """Gets the files of this BlockPost.  # noqa: E501

        The files attached to the post.  # noqa: E501

        :return: The files of this BlockPost.  # noqa: E501
        :rtype: list[MediaPreview]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this BlockPost.

        The files attached to the post.  # noqa: E501

        :param files: The files of this BlockPost.  # noqa: E501
        :type: list[MediaPreview]
        """

        self._files = files

    @property
    def images(self):
        """Gets the images of this BlockPost.  # noqa: E501

        The images attached to the post.  # noqa: E501

        :return: The images of this BlockPost.  # noqa: E501
        :rtype: list[MediaPreview]
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this BlockPost.

        The images attached to the post.  # noqa: E501

        :param images: The images of this BlockPost.  # noqa: E501
        :type: list[MediaPreview]
        """

        self._images = images

    @property
    def reactions(self):
        """Gets the reactions of this BlockPost.  # noqa: E501


        :return: The reactions of this BlockPost.  # noqa: E501
        :rtype: BlockReactions
        """
        return self._reactions

    @reactions.setter
    def reactions(self, reactions):
        """Sets the reactions of this BlockPost.


        :param reactions: The reactions of this BlockPost.  # noqa: E501
        :type: BlockReactions
        """

        self._reactions = reactions

    @property
    def votes(self):
        """Gets the votes of this BlockPost.  # noqa: E501


        :return: The votes of this BlockPost.  # noqa: E501
        :rtype: BlockVotes
        """
        return self._votes

    @votes.setter
    def votes(self, votes):
        """Sets the votes of this BlockPost.


        :param votes: The votes of this BlockPost.  # noqa: E501
        :type: BlockVotes
        """

        self._votes = votes

    @property
    def idea_status(self):
        """Gets the idea_status of this BlockPost.  # noqa: E501


        :return: The idea_status of this BlockPost.  # noqa: E501
        :rtype: IdeaStatus
        """
        return self._idea_status

    @idea_status.setter
    def idea_status(self, idea_status):
        """Sets the idea_status of this BlockPost.


        :param idea_status: The idea_status of this BlockPost.  # noqa: E501
        :type: IdeaStatus
        """

        self._idea_status = idea_status

    @property
    def article_preview(self):
        """Gets the article_preview of this BlockPost.  # noqa: E501


        :return: The article_preview of this BlockPost.  # noqa: E501
        :rtype: ArticlePreview
        """
        return self._article_preview

    @article_preview.setter
    def article_preview(self, article_preview):
        """Sets the article_preview of this BlockPost.


        :param article_preview: The article_preview of this BlockPost.  # noqa: E501
        :type: ArticlePreview
        """

        self._article_preview = article_preview

    @property
    def play_video_preview(self):
        """Gets the play_video_preview of this BlockPost.  # noqa: E501


        :return: The play_video_preview of this BlockPost.  # noqa: E501
        :rtype: PlayVideoPreview
        """
        return self._play_video_preview

    @play_video_preview.setter
    def play_video_preview(self, play_video_preview):
        """Sets the play_video_preview of this BlockPost.


        :param play_video_preview: The play_video_preview of this BlockPost.  # noqa: E501
        :type: PlayVideoPreview
        """

        self._play_video_preview = play_video_preview

    @property
    def order(self):
        """Gets the order of this BlockPost.  # noqa: E501

        The display order of the properties.  # noqa: E501

        :return: The order of this BlockPost.  # noqa: E501
        :rtype: list[str]
        """
        return self._order

    @order.setter
    def order(self, order):
        """Sets the order of this BlockPost.

        The display order of the properties.  # noqa: E501

        :param order: The order of this BlockPost.  # noqa: E501
        :type: list[str]
        """

        self._order = order

    @property
    def version(self):
        """Gets the version of this BlockPost.  # noqa: E501

        The post version, incremented after each edition.  # noqa: E501

        :return: The version of this BlockPost.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this BlockPost.

        The post version, incremented after each edition.  # noqa: E501

        :param version: The version of this BlockPost.  # noqa: E501
        :type: int
        """
        if version is None:
            raise ValueError(
                "Invalid value for `version`, must not be `None`"
            )  # noqa: E501

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(BlockPost, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlockPost):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
