# Generated by Django 3.2.6 on 2021-08-15 00:27

import django.db.models.deletion
from django.db import migrations, models

import xauth.accounts.abstract_models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                ("last_login", models.DateTimeField(blank=True, null=True, verbose_name="last login")),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                ("email", models.EmailField(db_index=True, max_length=150, unique=True)),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.Group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.Permission",
                        verbose_name="user permissions",
                    ),
                ),
                ("is_verified", models.BooleanField(default=xauth.accounts.abstract_models.default_is_verified)),
            ],
            options={
                "abstract": False,
                "swappable": "AUTH_USER_MODEL",
            },
        ),
        migrations.CreateModel(
            name="SecurityQuestion",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("question", models.CharField(max_length=255, unique=True)),
                ("added_on", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Security",
            fields=[
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="security",
                        serialize=False,
                        to="accounts.user",
                    ),
                ),
                ("security_question_answer", models.CharField(max_length=150, null=True)),
                ("temporary_password", models.CharField(max_length=128, null=True)),
                ("verification_code", models.CharField(max_length=128, null=True)),
                ("temporary_password_generation_time", models.DateTimeField(blank=True, null=True)),
                ("verification_code_generation_time", models.DateTimeField(blank=True, null=True)),
                ("account_deactivation_time", models.DateTimeField(blank=True, null=True)),
                (
                    "security_question",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="accounts.securityquestion",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("user", "security_question")},
            },
        ),
    ]
