"""
    SatNOGS DB

    SatNOGS DB is a transmitter suggestions and crowd-sourcing app.  # noqa: E501

    The version of the OpenAPI document: 1
    Contact: dev@satnogs.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from satnogsdbapiclient.api_client import ApiClient, Endpoint
from satnogsdbapiclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from satnogsdbapiclient.model.inline_response200 import InlineResponse200
from satnogsdbapiclient.model.inline_response2001 import InlineResponse2001


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_artifact(
            self,
            **kwargs
        ):
            """create_artifact  # noqa: E501

            Creates artifact  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_artifact(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                artifact_file (file_type, none_type): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_artifact = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/artifacts/',
                'operation_id': 'create_artifact',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'artifact_file',
                ],
                'required': [],
                'nullable': [
                    'artifact_file',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'artifact_file':
                        (file_type, none_type,),
                },
                'attribute_map': {
                    'artifact_file': 'artifact_file',
                },
                'location_map': {
                    'artifact_file': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client,
            callable=__create_artifact
        )

        def __create_demod_data(
            self,
            **kwargs
        ):
            """create_demod_data  # noqa: E501

            SatNOGS DB Telemetry API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_demod_data(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                app_source (str): [optional]
                observer (str): [optional]
                timestamp (datetime, none_type): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_demod_data = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/telemetry/',
                'operation_id': 'create_demod_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_source',
                    'observer',
                    'timestamp',
                ],
                'required': [],
                'nullable': [
                    'timestamp',
                ],
                'enum': [
                    'app_source',
                ],
                'validation': [
                    'observer',
                ]
            },
            root_map={
                'validations': {
                    ('observer',): {
                        'max_length': 60,
                    },
                },
                'allowed_values': {
                    ('app_source',): {

                        "MANUAL": "manual",
                        "NETWORK": "network",
                        "SIDS": "sids"
                    },
                },
                'openapi_types': {
                    'app_source':
                        (str,),
                    'observer':
                        (str,),
                    'timestamp':
                        (datetime, none_type,),
                },
                'attribute_map': {
                    'app_source': 'app_source',
                    'observer': 'observer',
                    'timestamp': 'timestamp',
                },
                'location_map': {
                    'app_source': 'form',
                    'observer': 'form',
                    'timestamp': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [
                    'application/x-www-form-urlencoded'
                ]
            },
            api_client=api_client,
            callable=__create_demod_data
        )

        def __list_artifacts(
            self,
            **kwargs
        ):
            """list_artifacts  # noqa: E501

            SatNOGS DB Artifact API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_artifacts(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page (int): A page number within the paginated result set.. [optional]
                network_obs_id (str): network_obs_id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse200
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_artifacts = Endpoint(
            settings={
                'response_type': (InlineResponse200,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/artifacts/',
                'operation_id': 'list_artifacts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'network_obs_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'network_obs_id':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'network_obs_id': 'network_obs_id',
                },
                'location_map': {
                    'page': 'query',
                    'network_obs_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_artifacts
        )

        def __list_demod_datas(
            self,
            **kwargs
        ):
            """list_demod_datas  # noqa: E501

            SatNOGS DB Telemetry API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_demod_datas(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page (int): A page number within the paginated result set.. [optional]
                satellite (str): satellite. [optional]
                app_source (str): app_source. [optional]
                observer (str): observer. [optional]
                transmitter (str): transmitter. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InlineResponse2001
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_demod_datas = Endpoint(
            settings={
                'response_type': (InlineResponse2001,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/telemetry/',
                'operation_id': 'list_demod_datas',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'satellite',
                    'app_source',
                    'observer',
                    'transmitter',
                    'start',
                    'end',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'app_source',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('app_source',): {

                        "MANUAL": "manual",
                        "NETWORK": "network",
                        "SIDS": "sids"
                    },
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'satellite':
                        (str,),
                    'app_source':
                        (str,),
                    'observer':
                        (str,),
                    'transmitter':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                },
                'attribute_map': {
                    'page': 'page',
                    'satellite': 'satellite',
                    'app_source': 'app_source',
                    'observer': 'observer',
                    'transmitter': 'transmitter',
                    'start': 'start',
                    'end': 'end',
                },
                'location_map': {
                    'page': 'query',
                    'satellite': 'query',
                    'app_source': 'query',
                    'observer': 'query',
                    'transmitter': 'query',
                    'start': 'query',
                    'end': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_demod_datas
        )

        def __list_latest_tle_sets(
            self,
            **kwargs
        ):
            """list_latest_tle_sets  # noqa: E501

            SatNOGS DB Tle API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_latest_tle_sets(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                norad_cat_id (str): norad_cat_id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [object]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_latest_tle_sets = Endpoint(
            settings={
                'response_type': ([object],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/tle/',
                'operation_id': 'list_latest_tle_sets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'norad_cat_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'norad_cat_id':
                        (str,),
                },
                'attribute_map': {
                    'norad_cat_id': 'norad_cat_id',
                },
                'location_map': {
                    'norad_cat_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_latest_tle_sets
        )

        def __list_modes(
            self,
            **kwargs
        ):
            """list_modes  # noqa: E501

            SatNOGS DB Mode API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_modes(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [object]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_modes = Endpoint(
            settings={
                'response_type': ([object],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/modes/',
                'operation_id': 'list_modes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_modes
        )

        def __list_satellites(
            self,
            **kwargs
        ):
            """list_satellites  # noqa: E501

            SatNOGS DB Satellite API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_satellites(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                norad_cat_id (str): norad_cat_id. [optional]
                status (str): status. [optional]
                in_orbit (str): In orbit. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [object]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_satellites = Endpoint(
            settings={
                'response_type': ([object],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/satellites/',
                'operation_id': 'list_satellites',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'norad_cat_id',
                    'status',
                    'in_orbit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "ALIVE": "alive",
                        "DEAD": "dead",
                        "FUTURE": "future",
                        "RE-ENTERED": "re-entered"
                    },
                },
                'openapi_types': {
                    'norad_cat_id':
                        (str,),
                    'status':
                        (str,),
                    'in_orbit':
                        (str,),
                },
                'attribute_map': {
                    'norad_cat_id': 'norad_cat_id',
                    'status': 'status',
                    'in_orbit': 'in_orbit',
                },
                'location_map': {
                    'norad_cat_id': 'query',
                    'status': 'query',
                    'in_orbit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_satellites
        )

        def __list_transmitters(
            self,
            **kwargs
        ):
            """list_transmitters  # noqa: E501

            SatNOGS DB Transmitter API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_transmitters(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                uuid (str): uuid. [optional]
                mode (str): mode. [optional]
                uplink_mode (str): uplink_mode. [optional]
                type (str): type. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                alive (str): Alive. [optional]
                status (str): status. [optional]
                service (str): service. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [object]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_transmitters = Endpoint(
            settings={
                'response_type': ([object],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/transmitters/',
                'operation_id': 'list_transmitters',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'uuid',
                    'mode',
                    'uplink_mode',
                    'type',
                    'satellite__norad_cat_id',
                    'alive',
                    'status',
                    'service',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'type',
                    'status',
                    'service',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('status',): {

                        "ACTIVE": "active",
                        "INACTIVE": "inactive",
                        "INVALID": "invalid"
                    },
                    ('service',): {

                        "AERONAUTICAL": "Aeronautical",
                        "AMATEUR": "Amateur",
                        "BROADCASTING": "Broadcasting",
                        "EARTH_EXPLORATION": "Earth Exploration",
                        "FIXED": "Fixed",
                        "INTER-SATELLITE": "Inter-satellite",
                        "MARITIME": "Maritime",
                        "METEOROLOGICAL": "Meteorological",
                        "MOBILE": "Mobile",
                        "RADIOLOCATION": "Radiolocation",
                        "RADIONAVIGATIONAL": "Radionavigational",
                        "SPACE_OPERATION": "Space Operation",
                        "SPACE_RESEARCH": "Space Research",
                        "STANDARD_FREQUENCY_AND_TIME_SIGNAL": "Standard Frequency and Time Signal",
                        "UNKNOWN": "Unknown"
                    },
                },
                'openapi_types': {
                    'uuid':
                        (str,),
                    'mode':
                        (str,),
                    'uplink_mode':
                        (str,),
                    'type':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'alive':
                        (str,),
                    'status':
                        (str,),
                    'service':
                        (str,),
                },
                'attribute_map': {
                    'uuid': 'uuid',
                    'mode': 'mode',
                    'uplink_mode': 'uplink_mode',
                    'type': 'type',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'alive': 'alive',
                    'status': 'status',
                    'service': 'service',
                },
                'location_map': {
                    'uuid': 'query',
                    'mode': 'query',
                    'uplink_mode': 'query',
                    'type': 'query',
                    'satellite__norad_cat_id': 'query',
                    'alive': 'query',
                    'status': 'query',
                    'service': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_transmitters
        )

        def __retrieve_artifact(
            self,
            id,
            **kwargs
        ):
            """retrieve_artifact  # noqa: E501

            SatNOGS DB Artifact API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_artifact(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this artifact.

            Keyword Args:
                network_obs_id (str): network_obs_id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.retrieve_artifact = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/artifacts/{id}/',
                'operation_id': 'retrieve_artifact',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'network_obs_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'network_obs_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'network_obs_id': 'network_obs_id',
                },
                'location_map': {
                    'id': 'path',
                    'network_obs_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_artifact
        )

        def __retrieve_demod_data(
            self,
            id,
            **kwargs
        ):
            """retrieve_demod_data  # noqa: E501

            SatNOGS DB Telemetry API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_demod_data(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this demod data.

            Keyword Args:
                satellite (str): satellite. [optional]
                app_source (str): app_source. [optional]
                observer (str): observer. [optional]
                transmitter (str): transmitter. [optional]
                start (str): start. [optional]
                end (str): end. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.retrieve_demod_data = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/telemetry/{id}/',
                'operation_id': 'retrieve_demod_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'satellite',
                    'app_source',
                    'observer',
                    'transmitter',
                    'start',
                    'end',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'app_source',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('app_source',): {

                        "MANUAL": "manual",
                        "NETWORK": "network",
                        "SIDS": "sids"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'satellite':
                        (str,),
                    'app_source':
                        (str,),
                    'observer':
                        (str,),
                    'transmitter':
                        (str,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'satellite': 'satellite',
                    'app_source': 'app_source',
                    'observer': 'observer',
                    'transmitter': 'transmitter',
                    'start': 'start',
                    'end': 'end',
                },
                'location_map': {
                    'id': 'path',
                    'satellite': 'query',
                    'app_source': 'query',
                    'observer': 'query',
                    'transmitter': 'query',
                    'start': 'query',
                    'end': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_demod_data
        )

        def __retrieve_latest_tle_set(
            self,
            id,
            **kwargs
        ):
            """retrieve_latest_tle_set  # noqa: E501

            SatNOGS DB Tle API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_latest_tle_set(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this latest tle set.

            Keyword Args:
                norad_cat_id (str): norad_cat_id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.retrieve_latest_tle_set = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/tle/{id}/',
                'operation_id': 'retrieve_latest_tle_set',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'norad_cat_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'norad_cat_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'norad_cat_id': 'norad_cat_id',
                },
                'location_map': {
                    'id': 'path',
                    'norad_cat_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_latest_tle_set
        )

        def __retrieve_mode(
            self,
            id,
            **kwargs
        ):
            """retrieve_mode  # noqa: E501

            SatNOGS DB Mode API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_mode(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): A unique integer value identifying this mode.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.retrieve_mode = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/modes/{id}/',
                'operation_id': 'retrieve_mode',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_mode
        )

        def __retrieve_satellite(
            self,
            norad_cat_id,
            **kwargs
        ):
            """retrieve_satellite  # noqa: E501

            SatNOGS DB Satellite API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_satellite(norad_cat_id, async_req=True)
            >>> result = thread.get()

            Args:
                norad_cat_id (str):

            Keyword Args:
                norad_cat_id2 (str): norad_cat_id. [optional]
                status (str): status. [optional]
                in_orbit (str): In orbit. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['norad_cat_id'] = \
                norad_cat_id
            return self.call_with_http_info(**kwargs)

        self.retrieve_satellite = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/satellites/{norad_cat_id}/',
                'operation_id': 'retrieve_satellite',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'norad_cat_id',
                    'norad_cat_id2',
                    'status',
                    'in_orbit',
                ],
                'required': [
                    'norad_cat_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "ALIVE": "alive",
                        "DEAD": "dead",
                        "FUTURE": "future",
                        "RE-ENTERED": "re-entered"
                    },
                },
                'openapi_types': {
                    'norad_cat_id':
                        (str,),
                    'norad_cat_id2':
                        (str,),
                    'status':
                        (str,),
                    'in_orbit':
                        (str,),
                },
                'attribute_map': {
                    'norad_cat_id': 'norad_cat_id',
                    'norad_cat_id2': 'norad_cat_id',
                    'status': 'status',
                    'in_orbit': 'in_orbit',
                },
                'location_map': {
                    'norad_cat_id': 'path',
                    'norad_cat_id2': 'query',
                    'status': 'query',
                    'in_orbit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_satellite
        )

        def __retrieve_transmitter(
            self,
            uuid,
            **kwargs
        ):
            """retrieve_transmitter  # noqa: E501

            SatNOGS DB Transmitter API view class  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.retrieve_transmitter(uuid, async_req=True)
            >>> result = thread.get()

            Args:
                uuid (str):

            Keyword Args:
                uuid2 (str): uuid. [optional]
                mode (str): mode. [optional]
                uplink_mode (str): uplink_mode. [optional]
                type (str): type. [optional]
                satellite__norad_cat_id (str): satellite__norad_cat_id. [optional]
                alive (str): Alive. [optional]
                status (str): status. [optional]
                service (str): service. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                object
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['uuid'] = \
                uuid
            return self.call_with_http_info(**kwargs)

        self.retrieve_transmitter = Endpoint(
            settings={
                'response_type': (object,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/api/transmitters/{uuid}/',
                'operation_id': 'retrieve_transmitter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'uuid',
                    'uuid2',
                    'mode',
                    'uplink_mode',
                    'type',
                    'satellite__norad_cat_id',
                    'alive',
                    'status',
                    'service',
                ],
                'required': [
                    'uuid',
                ],
                'nullable': [
                ],
                'enum': [
                    'type',
                    'status',
                    'service',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('type',): {

                        "TRANSMITTER": "Transmitter",
                        "TRANSCEIVER": "Transceiver",
                        "TRANSPONDER": "Transponder"
                    },
                    ('status',): {

                        "ACTIVE": "active",
                        "INACTIVE": "inactive",
                        "INVALID": "invalid"
                    },
                    ('service',): {

                        "AERONAUTICAL": "Aeronautical",
                        "AMATEUR": "Amateur",
                        "BROADCASTING": "Broadcasting",
                        "EARTH_EXPLORATION": "Earth Exploration",
                        "FIXED": "Fixed",
                        "INTER-SATELLITE": "Inter-satellite",
                        "MARITIME": "Maritime",
                        "METEOROLOGICAL": "Meteorological",
                        "MOBILE": "Mobile",
                        "RADIOLOCATION": "Radiolocation",
                        "RADIONAVIGATIONAL": "Radionavigational",
                        "SPACE_OPERATION": "Space Operation",
                        "SPACE_RESEARCH": "Space Research",
                        "STANDARD_FREQUENCY_AND_TIME_SIGNAL": "Standard Frequency and Time Signal",
                        "UNKNOWN": "Unknown"
                    },
                },
                'openapi_types': {
                    'uuid':
                        (str,),
                    'uuid2':
                        (str,),
                    'mode':
                        (str,),
                    'uplink_mode':
                        (str,),
                    'type':
                        (str,),
                    'satellite__norad_cat_id':
                        (str,),
                    'alive':
                        (str,),
                    'status':
                        (str,),
                    'service':
                        (str,),
                },
                'attribute_map': {
                    'uuid': 'uuid',
                    'uuid2': 'uuid',
                    'mode': 'mode',
                    'uplink_mode': 'uplink_mode',
                    'type': 'type',
                    'satellite__norad_cat_id': 'satellite__norad_cat_id',
                    'alive': 'alive',
                    'status': 'status',
                    'service': 'service',
                },
                'location_map': {
                    'uuid': 'path',
                    'uuid2': 'query',
                    'mode': 'query',
                    'uplink_mode': 'query',
                    'type': 'query',
                    'satellite__norad_cat_id': 'query',
                    'alive': 'query',
                    'status': 'query',
                    'service': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/ld+json',
                    'text/html'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__retrieve_transmitter
        )
