from enum import Enum


class ReleaseCategory(Enum):
    ALBUM = 'Album'
    ANTHOLOGY = 'Anthology'
    BOOTLEG = 'Bootleg'
    CDM = 'CDM'
    COMPILATION = 'Compilation'
    CONCERT_RECORDING = 'Concert Recording'
    DEMO = 'Demo'
    EP = 'EP'
    VIDEO_GAME_MUSIC = 'Video Game Music'
    INTERVIEW = 'Interview'
    LIVE_ALBUM = 'Live Album'
    MIX = 'Mix'
    MIXTAPE = 'Mixtape'
    REMIX = 'Remix'
    SINGLE = 'Single'
    SOUNDTRACK = 'Soundtrack'
    UNKNOWN = 'Unknown'


class ReleaseSource(Enum):
    CD = 'CD'
    VINYL = 'Vinyl'
    WEB = 'Web'
    UNKNOWN = 'Unknown'


class ViolationType(Enum):
    ARTIST_WHITESPACE = 'artist-whitespace'
    RELEASE_ARTIST_WHITESPACE = 'release-artist-whitespace'
    DATE_WHITESPACE = 'date-whitespace'
    RELEASE_TITLE_WHITESPACE = 'release-title-whitespace'
    TRACK_TITLE_WHITESPACE = 'track-title-whitespace'
    GENRE_WHITESPACE = 'genre-whitespace'
    DATE_INCONSISTENT = 'date-inconsistent'
    ARTIST_BLANK = 'artist'
    TRACK_TITLE_BLANK = 'track-title'
    RELEASE_ARTIST_INCONSISTENT = 'release-artist'
    RELEASE_ARTIST_SPELLING = 'release-artist-spelling'
    RELEASE_ARTIST_NOT_FOUND = 'release-artist-not-found'
    RELEASE_TITLE_INCONSISTENT = 'release-title-inconsistent'
    RELEASE_TITLE_CATEGORY = 'release-title-category'
    RELEASE_TITLE_SOURCE = 'release-title-source'
    RELEASE_TITLE_SPELLING = 'release-title-spelling'
    DATE_INCORRECT = 'date-incorrect'
    BAD_GENRES = 'bad-genres'
    INCORRECT_TRACK_TITLE = 'incorrect-track-title'
    TRACK_ARTIST_SPELLING = 'track-artist-spelling'
    MISSING_TRACKS = 'missing-tracks'
    TOTAL_TRACKS_INCONSISTENT = 'total-tracks'
    MISSING_DISCS = 'missing-discs'
    TOTAL_DISCS_INCONSISTENT = 'total-discs'
    TAG_TYPES_INCONSISTENT = 'tag-types'
    CODECS_INCONSISTENT = 'codecs'
    CBR_INCONSISTENT = 'cbr'
    FILENAME = 'filename'
    FOLDER_NAME = 'folder-name'
    ARTIST_LOOKUP = 'artist-lookup'
    UNREADABLE = 'unreadable'
    COMMENT_SUBSTRING = 'comment-substring'

upgrade_message = "The application is expired. Please upgrade to the newest version."