/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.resource.Handler;
import org.restlet.resource.Resource;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finder
extends Restlet {
    private volatile Class<?> targetClass;

    public static Finder createFinder(Class<?> targetClass, Class<? extends Finder> finderClass, Context context, Logger logger) {
        Finder result;
        block8: {
            result = null;
            if (Resource.class.isAssignableFrom(targetClass) || ServerResource.class.isAssignableFrom(targetClass)) {
                if (finderClass != null) {
                    try {
                        Constructor<? extends Finder> constructor = finderClass.getConstructor(Context.class, Class.class);
                        if (constructor != null) {
                            result = constructor.newInstance(context, targetClass);
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        if (logger != null) {
                            logger.log(Level.WARNING, "Exception while instantiating the finder.", e);
                        }
                        break block8;
                    }
                }
                result = new Finder(context, targetClass);
            } else if (logger != null) {
                logger.log(Level.WARNING, "Cannot create a Finder for the given target class, since it is neither a subclass of Resource nor a subclass of ServerResource.");
            }
        }
        return result;
    }

    public Finder() {
        this(null);
    }

    public Finder(Context context) {
        super(context);
        this.targetClass = null;
    }

    public Finder(Context context, Class<?> targetClass) {
        super(context);
        this.targetClass = targetClass;
    }

    private boolean allow(Method method, Handler target) {
        boolean result = false;
        if (target != null) {
            if (method.equals(Method.GET)) {
                result = target.allowGet();
            } else if (method.equals(Method.POST)) {
                result = target.allowPost();
            } else if (method.equals(Method.PUT)) {
                result = target.allowPut();
            } else if (method.equals(Method.DELETE)) {
                result = target.allowDelete();
            } else if (method.equals(Method.HEAD)) {
                result = target.allowHead();
            } else if (method.equals(Method.OPTIONS)) {
                result = target.allowOptions();
            } else {
                java.lang.reflect.Method allowMethod = this.getAllowMethod(method, target);
                if (allowMethod != null) {
                    result = (Boolean)this.invoke(target, allowMethod, new Object[0]);
                }
            }
        }
        return result;
    }

    public ServerResource create(Class<? extends ServerResource> targetClass, Request request, Response response) {
        ServerResource result = null;
        if (targetClass != null) {
            try {
                result = targetClass.newInstance();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Exception while instantiating the target server resource.", e);
            }
        }
        return result;
    }

    public ServerResource create(Request request, Response response) {
        ServerResource result = null;
        if (this.getTargetClass() != null && ServerResource.class.isAssignableFrom(this.getTargetClass())) {
            result = this.create(this.getTargetClass(), request, response);
        }
        return result;
    }

    @Deprecated
    protected Handler createTarget(Class<? extends Handler> targetClass, Request request, Response response) {
        Handler result = null;
        if (targetClass != null) {
            try {
                try {
                    Constructor<? extends Handler> constructor = targetClass.getConstructor(Context.class, Request.class, Response.class);
                    result = constructor.newInstance(this.getContext(), request, response);
                }
                catch (NoSuchMethodException nsme) {
                    Constructor<? extends Handler> constructor = targetClass.getConstructor(new Class[0]);
                    if (constructor != null) {
                        result = constructor.newInstance(new Object[0]);
                        result.init(this.getContext(), request, response);
                    }
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                this.getLogger().log(Level.WARNING, "Exception while instantiating the target handler.", e);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Exception while instantiating the target handler.", e);
            }
        }
        return result;
    }

    @Deprecated
    protected Handler createTarget(Request request, Response response) {
        Handler result = null;
        if (this.getTargetClass() != null && Handler.class.isAssignableFrom(this.getTargetClass())) {
            result = this.createTarget(this.getTargetClass(), request, response);
        }
        return result;
    }

    public ServerResource find(Request request, Response response) {
        return this.create(request, response);
    }

    @Deprecated
    public Handler findTarget(Request request, Response response) {
        return this.createTarget(request, response);
    }

    private java.lang.reflect.Method getAllowMethod(Method method, Handler target) {
        return this.getMethod("allow", method, target, new Class[0]);
    }

    private java.lang.reflect.Method getHandleMethod(Handler target, Method method) {
        return this.getMethod("handle", method, target, new Class[0]);
    }

    private java.lang.reflect.Method getMethod(String prefix, Method method, Object target, Class<?> ... classes) {
        java.lang.reflect.Method result = null;
        StringBuilder sb = new StringBuilder();
        String methodName = method.getName().toLowerCase();
        if (methodName != null && methodName.length() > 0) {
            sb.append(prefix);
            sb.append(Character.toUpperCase(methodName.charAt(0)));
            sb.append(methodName.substring(1));
        }
        try {
            result = target.getClass().getMethod(sb.toString(), classes);
        }
        catch (SecurityException e) {
            this.getLogger().log(Level.WARNING, "Couldn't access the " + prefix + " method for \"" + method + "\"", e);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.INFO, "Couldn't find the " + prefix + " method for \"" + method + "\"", e);
        }
        return result;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.isStarted()) {
            Handler targetHandler = this.findTarget(request, response);
            if (targetHandler != null) {
                if (response.getStatus().equals(Status.SUCCESS_OK)) {
                    Method method = request.getMethod();
                    if (method == null) {
                        response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
                    } else if (!this.allow(method, targetHandler)) {
                        response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                        targetHandler.updateAllowedMethods();
                    } else if (method.equals(Method.GET)) {
                        targetHandler.handleGet();
                    } else if (method.equals(Method.HEAD)) {
                        targetHandler.handleHead();
                    } else if (method.equals(Method.POST)) {
                        targetHandler.handlePost();
                    } else if (method.equals(Method.PUT)) {
                        targetHandler.handlePut();
                    } else if (method.equals(Method.DELETE)) {
                        targetHandler.handleDelete();
                    } else if (method.equals(Method.OPTIONS)) {
                        targetHandler.handleOptions();
                    } else {
                        java.lang.reflect.Method handleMethod = this.getHandleMethod(targetHandler, method);
                        if (handleMethod != null) {
                            this.invoke(targetHandler, handleMethod, new Object[0]);
                        } else {
                            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                        }
                    }
                }
            } else {
                ServerResource targetResource = this.find(request, response);
                if (targetResource == null) {
                    this.getLogger().warning("No target resource was defined for this finder: " + this.toString());
                    response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                } else {
                    targetResource.init(this.getContext(), request, response);
                    if (response == null || response.getStatus().isSuccess()) {
                        targetResource.handle();
                    }
                    targetResource.release();
                }
            }
        }
    }

    private Object invoke(Object target, java.lang.reflect.Method method, Object ... args) {
        Object result = null;
        if (method != null) {
            try {
                result = method.invoke(target, args);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Couldn't invoke the handle method for \"" + method + "\"", e);
            }
        }
        return result;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }
}

