/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.cortex;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import fr.gael.cortex.AbstractCortexModelResolver;
import fr.gael.cortex.CortexModel;
import fr.gael.cortex.ModelLoadEvent;
import fr.gael.cortex.ModelRemovedListener;
import fr.gael.cortex.ModelWasLoadedListener;
import fr.gael.cortex.ModelWillLoadListener;
import fr.gael.cortex.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCortexModelResolver
extends AbstractCortexModelResolver {
    private static Log logger = LogFactory.getLog(DefaultCortexModelResolver.class);
    private boolean useSystemContext = true;
    private ArrayList<ResolverContext> context = new ArrayList();
    private OntModel masterModel;
    private List<ModelWillLoadListener> willLoadListeners = new ArrayList<ModelWillLoadListener>();
    private List<ModelWasLoadedListener> wasLoadedListeners = new ArrayList<ModelWasLoadedListener>();
    private List<ModelRemovedListener> removedListeners = new ArrayList<ModelRemovedListener>();

    @Override
    public OntModel getModel() {
        if (this.masterModel == null) {
            if (this.isUseSystemContext()) {
                OntModel default_model = null;
                try {
                    default_model = this.loadDefaultOntModel();
                }
                catch (IOException e) {
                    default_model = null;
                }
                this.masterModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)default_model);
            } else {
                this.masterModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            }
            for (ResolverContext rc : this.context) {
                OntModel sub_model = rc.getContextModel();
                this.fireModelWillLoadEvent(this, sub_model);
                this.masterModel.addSubModel((Model)sub_model);
                this.fireModelWasLoadedEvent(this, sub_model);
            }
        }
        return this.masterModel;
    }

    public static OntModel getModelFromPath(String path) {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        URL owl_url = null;
        if (path.endsWith(".jar")) {
            URL[] url_array = new URL[]{PathClassLoader.getUrlOf(path)};
            PathClassLoader cl = new PathClassLoader(url_array, null);
            owl_url = cl.getResource(CortexModel.ONT_INDEX_FILENAME);
        } else if (!path.endsWith(CortexModel.ONT_INDEX_FILENAME)) {
            File file = new File(path, CortexModel.ONT_INDEX_FILENAME);
            owl_url = PathClassLoader.getUrlOf(file.getPath());
        } else {
            owl_url = PathClassLoader.getUrlOf(path);
        }
        model.read(owl_url.toExternalForm());
        return model;
    }

    public void addModel(OntModel model) {
        if (!this.exist(model)) {
            this.fireModelWillLoadEvent(this, model);
            this.getModel().addSubModel((Model)model);
            this.fireModelWasLoadedEvent(this, model);
            ResolverContext rc = new ResolverContext();
            rc.setContextModel(model);
            this.context.add(rc);
        }
    }

    public void removeModel(OntModel model) {
        this.getModel().removeSubModel((Model)model);
        this.fireModelRemovedEvent(this, model);
        ResolverContext rc = this.getSubContext(model);
        if (rc != null) {
            this.context.remove(rc);
        }
    }

    public void addClassPathForModel(OntModel model, String classpath) {
        ResolverContext rc = null;
        if (!this.exist(model)) {
            this.addModel(model);
        }
        rc = this.getSubContext(model);
        rc.addClasspath(classpath);
    }

    private ResolverContext getSubContext(OntModel model) {
        for (ResolverContext rc : this.context) {
            if (!rc.getContextModel().equals(model)) continue;
            return rc;
        }
        return null;
    }

    public boolean exist(OntModel model) {
        return this.getModel().listSubModels(false).toList().contains(model);
    }

    @Override
    public String resolveResourceUri(String uri) {
        ClassLoader cl;
        URL url = null;
        logger.debug((Object)("Trying to resolve URI \"" + uri + "\"."));
        for (ResolverContext rc : this.context) {
            ClassLoader cl2 = rc.getClassLoader();
            url = cl2.getResource(uri);
            logger.debug((Object)("Found at \"" + (url == null ? "nul" : url.toExternalForm()) + "\"."));
            if (url == null) continue;
            return url.toExternalForm();
        }
        if (this.isUseSystemContext() && (url = ClassLoader.getSystemResource(uri)) == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            url = cl.getResource(uri);
        }
        return url == null ? null : url.toExternalForm();
    }

    public boolean isUseSystemContext() {
        return this.useSystemContext;
    }

    public void setUseSystemContext(boolean useSystemContext) {
        if (useSystemContext != this.isUseSystemContext()) {
            this.useSystemContext = useSystemContext;
            this.masterModel = null;
            this.masterModel = this.getModel();
        }
    }

    private OntModel loadDefaultOntModel() throws IOException {
        OntModel model = ModelFactory.createOntologyModel();
        Enumeration<URL> ont_urls = ClassLoader.getSystemResources(CortexModel.ONT_INDEX_FILENAME);
        while (ont_urls.hasMoreElements()) {
            URL ont_url = ont_urls.nextElement();
            OntModel sub_model = DefaultCortexModelResolver.getModelFromPath(ont_url.toString());
            this.fireModelWillLoadEvent(this, sub_model);
            model.add((Model)sub_model);
            this.fireModelWasLoadedEvent(this, sub_model);
        }
        return model;
    }

    public void addModelWillLoadListener(ModelWillLoadListener listener) {
        this.willLoadListeners.add(listener);
    }

    public void removeModelWillLoadListener(ModelWillLoadListener listener) {
        this.willLoadListeners.remove(listener);
    }

    public void addModelWasLoadedListener(ModelWasLoadedListener listener) {
        this.wasLoadedListeners.add(listener);
    }

    public void removeModelWasLoadedListener(ModelWasLoadedListener listener) {
        this.wasLoadedListeners.remove(listener);
    }

    public void addModelRemovedListener(ModelRemovedListener listener) {
        this.removedListeners.add(listener);
    }

    public void removeModelRemovedListener(ModelRemovedListener listener) {
        this.removedListeners.remove(listener);
    }

    private void fireModelWillLoadEvent(Object source, OntModel model) {
        ModelLoadEvent event = new ModelLoadEvent(source, model);
        for (ModelWillLoadListener listener : this.willLoadListeners) {
            listener.modelWillLoad(event);
        }
    }

    private void fireModelWasLoadedEvent(Object source, OntModel model) {
        ModelLoadEvent event = new ModelLoadEvent(source, model);
        for (ModelWasLoadedListener listener : this.wasLoadedListeners) {
            listener.modelWasLoaded(event);
        }
    }

    private void fireModelRemovedEvent(Object source, OntModel model) {
        ModelLoadEvent event = new ModelLoadEvent(source, model);
        for (ModelRemovedListener listener : this.removedListeners) {
            listener.modelRemoved(event);
        }
    }

    public static void main(String[] args) {
        String ontology_path = args[0];
        String classpath = args[1];
        String system_uri_to_resolve = args[2];
        String local_uri_to_resolve = args[3];
        OntModel model = DefaultCortexModelResolver.getModelFromPath(ontology_path);
        DefaultCortexModelResolver cmr = new DefaultCortexModelResolver();
        cmr.addModel(model);
        cmr.addClassPathForModel(model, classpath);
        cmr.setUseSystemContext(false);
        String url = cmr.resolveResourceUri(system_uri_to_resolve);
        System.out.println("Resolved URL (in system) is \"" + url + "\" (useSystemContext=" + cmr.isUseSystemContext() + ").");
        cmr.setUseSystemContext(true);
        url = cmr.resolveResourceUri(system_uri_to_resolve);
        System.out.println("Resolved URL (in system) is \"" + url + "\" (useSystemContext=" + cmr.isUseSystemContext() + ").");
        cmr.setUseSystemContext(false);
        url = cmr.resolveResourceUri(local_uri_to_resolve);
        System.out.println("Resolved URL (in local context) is \"" + url + "\" (useSystemContext=" + cmr.isUseSystemContext() + ").");
        cmr.setUseSystemContext(true);
        url = cmr.resolveResourceUri(local_uri_to_resolve);
        System.out.println("Resolved URL (in local context) is \"" + url + "\" (useSystemContext=" + cmr.isUseSystemContext() + ").");
    }

    private class ResolverContext {
        private PathClassLoader classLoader;
        private OntModel model;

        private ResolverContext() {
        }

        public void setContextModel(OntModel model) {
            this.model = model;
        }

        public OntModel getContextModel() {
            return this.model;
        }

        public void addClasspath(String path) {
            if (this.classLoader == null) {
                URL url = PathClassLoader.getUrlOf(path);
                URL[] url_array = new URL[]{url};
                this.classLoader = new PathClassLoader(url_array, null);
                return;
            }
            this.classLoader.addPath(path);
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

