/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.streams;

import fr.gael.streams.CachedFile;
import fr.gael.streams.RandomAccessInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheUtils {
    private static Logger LOGGER;
    private static Cache cache;
    public static long MAX_SIZE;
    public static final String CACHED_SIZE = "CACHE_SIZE";
    private static final Map<String, RandomAccessInputStream> openedStreams;

    private CacheUtils() {
    }

    private static Element createElementFromPath(Path path) {
        String fileName = path.getFileName().toString();
        fileName = fileName.substring(0, fileName.indexOf(".dat"));
        try {
            BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            Element element = new Element((Serializable)((Object)fileName), (Serializable)new CachedFile(fileName, attributes.size(), attributes.lastAccessTime().toMillis()));
            return element;
        }
        catch (IOException e) {
            LOGGER.error("Cannot initialize properly the file " + fileName + " in cache", (Throwable)e);
            return null;
        }
    }

    public static void putInCache(String fileName) {
        if (CacheUtils.isCacheAvailable()) {
            Element element = new Element((Serializable)((Object)fileName), (Serializable)new CachedFile(fileName));
            if (cache.get((Serializable)((Object)fileName)) == null) {
                LOGGER.debug("Adding file to cache " + fileName);
                cache.put(element);
            }
        }
    }

    private static boolean isCacheAvailable() {
        return cache != null;
    }

    public static CachedFile getFromCache(String fileName) {
        if (CacheUtils.isCacheAvailable()) {
            Element e = cache.get((Serializable)((Object)fileName));
            if (e == null) {
                return null;
            }
            return (CachedFile)e.getObjectValue();
        }
        return null;
    }

    public static void updateInCache(String fileName, CachedFile file) {
        if (CacheUtils.isCacheAvailable()) {
            Element element = new Element((Serializable)((Object)fileName), (Serializable)file);
            if (file.getUpdatedSize() != 0L) {
                CacheUtils.updateTotalSize(file.getUpdatedSize());
                file.setUpdatedSize(0L);
            }
            cache.put(element);
        }
    }

    public static String getCompleteFileName(String fileName) {
        Objects.requireNonNull(fileName);
        String firstDir = fileName.substring(0, 1).toLowerCase();
        String secDir = fileName.substring(1, 2).toLowerCase();
        String name = RandomAccessInputStream.TMP_DIR + "/" + firstDir + "/" + secDir;
        if (name.endsWith("/")) {
            return name + fileName + ".dat";
        }
        return name + "/" + fileName + ".dat";
    }

    public static long getTotalSize() {
        Element element = cache.get((Serializable)((Object)CACHED_SIZE));
        if (element != null) {
            return (Long)element.getObjectValue();
        }
        return 0L;
    }

    public static void updateTotalSize(long size) {
        cache.put(new Element((Serializable)((Object)CACHED_SIZE), (Serializable)Long.valueOf(CacheUtils.getTotalSize() + size)));
    }

    public static void registerOpenedStream(RandomAccessInputStream stream) {
        openedStreams.put(stream.getKeyLock(), stream);
    }

    public static void deregisterOpenedStream(String key) {
        openedStreams.remove(key);
    }

    public static void deregisterAndCloseOpenedStream(String key) {
        RandomAccessInputStream stream = openedStreams.get(key);
        if (stream != null) {
            try {
                LOGGER.info("Closing stream {}", (Object)key);
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error("An I/O error while closing stream", (Throwable)e);
            }
            openedStreams.remove(key);
        }
    }

    static {
        block12: {
            LOGGER = LogManager.getLogger(CacheUtils.class);
            MAX_SIZE = Long.getLong("fr.gael.streams.disk_cache.size", 10000000000L);
            openedStreams = new HashMap<String, RandomAccessInputStream>();
            try {
                InputStream is;
                URL configLocation = ClassLoader.getSystemResource("temporary_files_ehcache.xml");
                if (configLocation == null) {
                    configLocation = Thread.currentThread().getContextClassLoader().getResource("temporary_files_ehcache.xml");
                }
                if ((is = configLocation.openStream()) != null) {
                    try {
                        cache = CacheManager.newInstance((InputStream)is).getCache("TemporaryFilesCache");
                    }
                    catch (NoSuchMethodError e) {
                        LOGGER.debug("EHCache 2.10.x not supported, trying with 2.5.x calls.");
                        try {
                            Configuration conf = ConfigurationFactory.parseConfiguration((InputStream)is);
                            DiskStoreConfiguration dsc = new DiskStoreConfiguration();
                            dsc.setPath(RandomAccessInputStream.TMP_DIR);
                            conf.addDiskStore(dsc);
                            cache = new CacheManager(conf).getCache("TemporaryFilesCache");
                        }
                        catch (Throwable ex) {
                            LOGGER.error("Cannot initialize cache.", (Throwable)e);
                            throw ex;
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.error("Cannot initialize Cache.", e);
                        throw e;
                    }
                    long maxBytesLocalDisk = cache.getCacheConfiguration().getMaxBytesLocalDisk();
                    MAX_SIZE = maxBytesLocalDisk > 0L ? maxBytesLocalDisk : MAX_SIZE;
                    LOGGER.info("Initializing cache with size of " + MAX_SIZE + " bytes in " + RandomAccessInputStream.TMP_DIR);
                    try {
                        is.close();
                    }
                    catch (IOException dsc) {
                        // empty catch block
                    }
                    File cacheDir = new File(RandomAccessInputStream.TMP_DIR);
                    final ArrayList elements = new ArrayList();
                    final long[] totalSize = new long[1];
                    Files.walkFileTree(cacheDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            if (exc instanceof AccessDeniedException) {
                                return FileVisitResult.CONTINUE;
                            }
                            return super.visitFileFailed(file, exc);
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Element element;
                            if (file.toString().endsWith(".dat") && (element = CacheUtils.createElementFromPath(file)) != null) {
                                totalSize[0] = totalSize[0] + ((CachedFile)element.getObjectValue()).getSize();
                                elements.add(element);
                            }
                            return super.visitFile(file, attrs);
                        }
                    });
                    if (!elements.isEmpty()) {
                        LOGGER.info("Initialize cache with existing files (" + elements.size() + ")");
                        cache.putAll(elements);
                        cache.put(new Element((Serializable)((Object)CACHED_SIZE), (Serializable)Long.valueOf(totalSize[0])));
                        LOGGER.info("Cache current size is {} bytes", (Object)totalSize[0]);
                    }
                    break block12;
                }
                cache = null;
            }
            catch (IOException e) {
                cache = null;
            }
        }
    }
}

