/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.streams;

import java.io.Serializable;

public class CachedFile
implements Serializable,
Comparable<CachedFile> {
    private static final long serialVersionUID = -687716532365297251L;
    private String fileName;
    private boolean lock;
    private Long size;
    private long updatedSize;
    private Long lastAccess;

    public CachedFile(String fileName, long size, long lastAccess) {
        this.fileName = fileName;
        this.size = size;
        this.lastAccess = lastAccess;
    }

    public CachedFile(String fileName) {
        this(fileName, 0L, System.currentTimeMillis());
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void lock() {
        this.lock = true;
    }

    public void unlock() {
        this.lock = false;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.updatedSize = size - this.size;
        this.size = size;
    }

    public Long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public long getUpdatedSize() {
        return this.updatedSize;
    }

    public void setUpdatedSize(long updatedSize) {
        this.updatedSize = updatedSize;
    }

    @Override
    public int compareTo(CachedFile o) {
        return this.lastAccess.compareTo(o.getLastAccess());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedFile other = (CachedFile)obj;
        return !(this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName));
    }
}

