/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.streams;

import fr.gael.streams.CacheUtils;
import fr.gael.streams.CachedFile;
import fr.gael.streams.ObservableInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RandomAccessInputStream
extends ObservableInputStream {
    protected InputStream origin;
    protected long originCursor;
    private long bufferCursor;
    protected File fileCache;
    private String keyLock;
    protected static final int CHUNK = 0x200000;
    public static final String BUFFER_SUFFIX = ".dat";
    public static final String TMP_DIR = System.getProperty("fr.gael.streams.tmpdir", System.getProperty("java.io.tmpdir"));
    private static final int MAX_WAIT = Integer.getInteger("fr.gael.streams.lock.waiting", 900);
    private static final int LOOP_INTERVAL = 3;
    private static Logger LOGGER = LogManager.getLogger(RandomAccessInputStream.class);
    private static final String REG_EXP_BEG_URL_QUERY = "^(http|https)://[^/]+/v[^/]+/[^/]+/[^/]+/";
    private static final String REG_EXP_END_URL_QUERY = "\\?temp_url_sig=[^&]+&temp_url_expires=\\d+";
    private boolean cache_active;
    private Function<Void, InputStream> constructor;
    private boolean isXmlFile;

    public RandomAccessInputStream(Function<Void, InputStream> constructor, String fileName) throws IOException {
        fileName = this.cleanFileName(fileName);
        String name = fileName.toLowerCase();
        if (name.endsWith(".xml") || name.endsWith(".safe") || name.endsWith(".xsl") || name.endsWith(".xsd")) {
            this.isXmlFile = true;
        }
        LOGGER.debug("RAIS : " + fileName);
        this.cache_active = !Boolean.getBoolean("fr.gael.streams.cache.inactive");
        this.keyLock = DigestUtils.md5Hex((String)fileName);
        if (this.cache_active) {
            String file_cache = this.createCacheFile(this.keyLock);
            LOGGER.debug("Creating " + file_cache + " from path " + fileName);
        }
        this.constructor = constructor;
    }

    private String cleanFileName(String fileName) {
        Objects.requireNonNull(fileName);
        fileName = fileName.replaceAll(REG_EXP_BEG_URL_QUERY, "");
        fileName = fileName.replaceAll(REG_EXP_END_URL_QUERY, "");
        fileName = fileName.replace("/.value", "");
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createCacheFile(String fileName) throws IOException {
        String string = BUFFER_SUFFIX;
        synchronized (BUFFER_SUFFIX) {
            String completeFileName = CacheUtils.getCompleteFileName(fileName);
            this.fileCache = new File(completeFileName);
            String directories = completeFileName.replace(this.fileCache.toPath().getFileName().toString(), "");
            Files.createDirectories(Paths.get(directories, new String[0]), new FileAttribute[0]);
            if (this.fileCache.createNewFile()) {
                CacheUtils.putInCache(fileName);
            }
            CacheUtils.registerOpenedStream(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.fileCache.getPath();
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.cache_active) {
            int read = this.getOrigin().read();
            if (read != -1) {
                ++this.originCursor;
            }
            return read;
        }
        try (RandomAccessFile buffer = new RandomAccessFile(this.fileCache, "rw");){
            buffer.seek(this.bufferCursor);
            int read = this.readFromBuffer(buffer);
            if (read != -1) {
                int n = read;
                return n;
            }
            this.readFromOrigin(buffer, this.originCursor + 1L);
            buffer.seek(this.bufferCursor);
            int n = this.readFromBuffer(buffer);
            return n;
        }
    }

    private int readFromBuffer(RandomAccessFile buffer) throws IOException {
        this.waitForLock();
        int read = buffer.read();
        if (read != -1) {
            ++this.bufferCursor;
            this.updateLastAccess();
        }
        return read;
    }

    private int readFromBuffer(RandomAccessFile buffer, byte[] b, int off, int len) throws IOException {
        this.waitForLock();
        int read = buffer.read(b, off, len);
        this.bufferCursor += (long)read;
        this.updateLastAccess();
        return read;
    }

    protected int readFromBuffer(RandomAccessFile buffer, long n, byte[] b, int off, int len) throws IOException {
        buffer.seek(n);
        int read = buffer.read(b, off, len);
        this.updateLastAccess();
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.cache_active) {
            int read = this.getOrigin().read(b, off, len);
            if (read != -1) {
                this.originCursor += (long)read;
            }
            RandomAccessInputStream.informObservers(String.format("%d|0", read));
            return read;
        }
        try (RandomAccessFile buffer = new RandomAccessFile(this.fileCache, "rw");){
            buffer.seek(this.bufferCursor);
            long readFromOrigin = 0L;
            long bufferLength = buffer.length();
            if (bufferLength - this.bufferCursor < (long)len) {
                readFromOrigin = this.readFromOrigin(buffer, (long)len - (bufferLength - this.bufferCursor));
                buffer.seek(this.bufferCursor);
            }
            int readFromBuffer = this.readFromBuffer(buffer, b, off, len);
            RandomAccessInputStream.informObservers(String.format("%d|%d", readFromOrigin, readFromBuffer));
            int n = readFromBuffer;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int seekAndRead(long n, byte[] b, int off, int len) throws IOException {
        try (RandomAccessFile buffer = new RandomAccessFile(this.fileCache, "rw");){
            long readFromOrigin = 0L;
            if (n + (long)len > buffer.length()) {
                RandomAccessInputStream randomAccessInputStream = this;
                synchronized (randomAccessInputStream) {
                    readFromOrigin = this.readFromOrigin(buffer, n + (long)len - this.originCursor);
                }
            }
            int readFromBuffer = this.readFromBuffer(buffer, n, b, off, len);
            RandomAccessInputStream.informObservers(String.format("%d|%d", readFromOrigin, readFromBuffer));
            int n2 = readFromBuffer;
            return n2;
        }
    }

    private long skipBytes(long n) throws IOException {
        int numRead;
        byte[] skipBuf = new byte[8192];
        for (long num = n; num > 0L; num -= (long)numRead) {
            numRead = this.getOrigin().read(skipBuf, 0, num > (long)skipBuf.length ? skipBuf.length : (int)num);
            if (numRead == -1) {
                n -= num;
                break;
            }
            this.originCursor += (long)numRead;
        }
        return n;
    }

    public void seek(long n) throws IOException {
        if (!this.cache_active) {
            if (this.originCursor == n) {
                return;
            }
            if (this.originCursor > n) {
                if (this.origin != null) {
                    this.origin.close();
                }
                this.origin = this.constructor.apply(null);
                this.originCursor = 0L;
            }
            this.skipBytes(n - this.originCursor);
            return;
        }
        try (RandomAccessFile buffer = new RandomAccessFile(this.fileCache, "rw");){
            long bufferLength = buffer.length();
            if (n > bufferLength) {
                this.readFromOrigin(buffer, n - this.originCursor);
            }
            buffer.seek(n);
            this.bufferCursor = n;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.seek(this.bufferCursor + n);
        return n;
    }

    protected long readFromOrigin(RandomAccessFile buffer, long bytesToRead) throws IOException {
        this.waitForLock();
        this.lockBuffer();
        try {
            int read;
            long totalRead = 0L;
            long bufferLength = buffer.length();
            if (this.originCursor < bufferLength) {
                if (this.isXmlFile) {
                    this.getOrigin().skip(bufferLength - this.originCursor + 1L);
                } else {
                    this.getOrigin().skip(bufferLength - this.originCursor);
                }
                this.originCursor = bufferLength;
            }
            long cachedSize = 0L;
            while (totalRead < bytesToRead && (read = this.readOneChunk(buffer, 0x200000)) != -1) {
                totalRead += (long)read;
                if ((cachedSize += (long)read) < 100000000L) continue;
                this.updateFileInCache(buffer.length());
                cachedSize = 0L;
            }
            this.unlockBuffer(buffer.length());
            return totalRead;
        }
        catch (Exception e) {
            this.unlockBuffer();
            throw e;
        }
    }

    private int readOneChunk(RandomAccessFile buffer, int chunkSize) throws IOException {
        int offset;
        int read;
        byte[] b = new byte[chunkSize];
        for (offset = 0; offset < chunkSize; offset += read) {
            read = this.getOrigin().read(b, offset, chunkSize - offset);
            if (read != -1) continue;
            if (offset != 0) break;
            return -1;
        }
        buffer.seek(buffer.length());
        if (offset > chunkSize) {
            buffer.write(b, 0, chunkSize);
        } else {
            buffer.write(b, 0, offset);
        }
        this.originCursor += (long)offset;
        return offset;
    }

    private void updateLastAccess() {
        CachedFile f = CacheUtils.getFromCache(this.keyLock);
        if (f != null) {
            f.setLastAccess(System.currentTimeMillis());
            CacheUtils.updateInCache(this.keyLock, f);
        }
    }

    public void updateLastAccess(Long lastAccess) {
        CachedFile f = CacheUtils.getFromCache(this.keyLock);
        if (f != null) {
            f.setLastAccess(lastAccess);
            CacheUtils.updateInCache(this.keyLock, f);
        }
    }

    protected void lockBuffer() {
        CachedFile f = CacheUtils.getFromCache(this.keyLock);
        if (f != null) {
            f.lock();
            f.setLastAccess(System.currentTimeMillis());
            CacheUtils.updateInCache(this.keyLock, f);
        }
    }

    protected void unlockBuffer() {
        CachedFile f = CacheUtils.getFromCache(this.keyLock);
        if (f != null) {
            f.unlock();
            f.setLastAccess(System.currentTimeMillis());
            CacheUtils.updateInCache(this.keyLock, f);
        }
    }

    protected void unlockBuffer(long bufferLength) {
        CachedFile f = CacheUtils.getFromCache(this.keyLock);
        if (f != null) {
            f.unlock();
            f.setSize(bufferLength);
            f.setLastAccess(System.currentTimeMillis());
            CacheUtils.updateInCache(this.keyLock, f);
        }
    }

    protected void updateFileInCache(long bufferLength) {
        CachedFile f = CacheUtils.getFromCache(this.keyLock);
        if (f != null) {
            f.setSize(bufferLength);
            f.setLastAccess(System.currentTimeMillis());
            CacheUtils.updateInCache(this.keyLock, f);
        }
    }

    private boolean isBufferLocked() {
        CachedFile f = CacheUtils.getFromCache(this.keyLock);
        if (f != null) {
            return f.isLock();
        }
        return false;
    }

    protected void waitForLock() throws IOException {
        boolean locked = this.isBufferLocked();
        int current = 0;
        if (locked) {
            while (locked) {
                try {
                    LOGGER.debug(Thread.currentThread() + " waiting for " + this.keyLock);
                    Thread.sleep(42L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn(String.format("Lock '%s' interrupted by user call.", this.keyLock));
                    this.unlockBuffer();
                    break;
                }
                if ((current += 3) >= MAX_WAIT) {
                    LOGGER.warn("Potential deadlock detected. Releasing lock '" + this.keyLock + "'.");
                    this.unlockBuffer();
                    break;
                }
                locked = this.isBufferLocked();
            }
            this.fileCache = new File(this.fileCache.getAbsolutePath());
            LOGGER.debug("refresh buffer");
        }
    }

    private InputStream getOrigin() throws IOException {
        if (this.origin != null) {
            return this.origin;
        }
        this.origin = this.constructor.apply(null);
        if (this.origin == null) {
            throw new IOException("Unable to get stream");
        }
        this.originCursor = 0L;
        return this.origin;
    }

    public String getKeyLock() {
        return this.keyLock;
    }

    @Override
    public void close() throws IOException {
        this.unlockBuffer();
        if (this.origin != null) {
            this.origin.close();
        }
        CacheUtils.deregisterOpenedStream(this.keyLock);
    }

    public void releaseOrigin() throws IOException {
        this.unlockBuffer();
        if (this.origin != null) {
            this.origin.close();
            this.origin = null;
        }
    }
}

