/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbNodesChangeEvent;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.Namespace;
import org.apache.log4j.Logger;

public class DrbDefaultMutableNode
extends DrbNodeImpl {
    protected DrbNode referenceNode;
    protected String name;
    protected String namespaceURI;
    protected DrbNode parent;
    protected DrbAttributeList attributes;
    protected Value value;
    protected int index;
    protected DrbDefaultNodeList children;
    protected DrbNode previousSibling;
    protected DrbNode nextSibling;
    protected Object userObject;
    protected String rootPath = "";
    private Namespace namespaceBindings;
    private static Logger logger = Logger.getLogger(DrbDefaultMutableNode.class);

    private DrbDefaultMutableNode(DrbNode reference_node) {
        this(reference_node.getName());
        this.namespaceURI = reference_node.getNamespaceURI();
        this.referenceNode = reference_node;
    }

    public DrbDefaultMutableNode(String name) {
        this.name = name;
        this.index = 0;
    }

    public DrbDefaultMutableNode(String name, DrbNode parent, int index, DrbNode previous_sibling, DrbNode next_sibling) {
        this.name = name;
        this.index = index;
        this.parent = parent;
        this.previousSibling = previous_sibling;
        this.nextSibling = next_sibling;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getXPathName() {
        if (this.parent == null) {
            return this.rootPath + "/" + super.getXPathName();
        }
        return super.getXPathName();
    }

    @Override
    public void rename(String name) throws NullPointerException, UnsupportedOperationException {
        if (name == null) {
            throw new NullPointerException("DrbDefaultMutableNode.rename() : The reference to the new name is null.");
        }
        this.name = name;
        this.nodesChanged(new DrbNodesChangeEvent(this));
    }

    public void setContent(DrbSequence sequence) {
    }

    @Override
    public DrbNode getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public void setNamespaceURI(String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        if (namespace_uri == null) {
            throw new NullPointerException("DrbDefaultMutableNode.setNamespaceURI() : The reference to the nameapce URI is null.");
        }
        this.namespaceURI = namespace_uri;
        this.nodesChanged(new DrbNodesChangeEvent(this));
    }

    @Override
    public Namespace getNamespaceBindings() {
        return this.namespaceBindings;
    }

    @Override
    public void setNamespaceBindings(Namespace namespaces) {
        this.namespaceBindings = namespaces != null ? namespaces.cloneNamespace() : null;
    }

    @Override
    public int getValueType() {
        if (this.referenceNode != null) {
            return this.referenceNode.getValueType();
        }
        if (this.value != null) {
            return this.value.getType();
        }
        return -1;
    }

    @Override
    public Value getValue() {
        if (this.referenceNode != null) {
            return this.referenceNode.getValue();
        }
        return this.value;
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        if (value == null) {
            throw new NullPointerException("DrbDefaultMutableNode.setValue() : The reference to the value to assign is null.");
        }
        this.value = value;
        this.nodesChanged(new DrbNodesChangeEvent(this));
        return value;
    }

    @Override
    public DrbAttributeList getAttributes() {
        if (this.referenceNode != null) {
            return this.referenceNode.getAttributes();
        }
        return this.attributes;
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        if (attributes == null) {
            throw new NullPointerException("DrbDefaultMutableNode.setAttributes() : The reference to the attributes is null.");
        }
        this.attributes = attributes;
        this.nodesChanged(new DrbNodesChangeEvent(this));
    }

    @Override
    public DrbNode getParent() {
        return this.parent;
    }

    public void setParent(DrbNode parent) {
        this.parent = parent;
    }

    @Override
    public DrbNodeList getChildren() {
        if (this.referenceNode == null) {
            return this.children;
        }
        return this.referenceNode.getChildren();
    }

    public void setChildren(DrbNodeList children) {
        if (this.referenceNode != null) {
            throw new UnsupportedOperationException("Children cannot be changed.");
        }
        this.children = (DrbDefaultNodeList)children;
    }

    private DrbDefaultMutableNode duplicateTree(DrbNode in_node) {
        if (in_node == null) {
            logger.error("DrbDefaultMutableNode.duplicateTree() : Invalid parameter.");
            return null;
        }
        String name = in_node.getName();
        if (name == null) {
            logger.error("DrbDefaultMutableNode.duplicateTree() : Input node has no name.");
            return null;
        }
        DrbDefaultMutableNode outNode = new DrbDefaultMutableNode(name);
        try {
            DrbNodeList nodeList;
            Value outValue;
            DrbAttributeList attrib = in_node.getAttributes();
            if (attrib != null) {
                outNode.setAttributes(attrib);
            }
            outNode.setIndex(in_node.getIndex());
            String namespaceURI = in_node.getNamespaceURI();
            if (namespaceURI != null) {
                outNode.setNamespaceURI(namespaceURI);
            }
            if ((outValue = in_node.getValue()) != null) {
                outNode.setValue(outValue);
            }
            if ((nodeList = in_node.getChildren()) != null) {
                int nodeCount = nodeList.getLength();
                for (int inode = 0; inode < nodeCount; ++inode) {
                    DrbDefaultMutableNode childNode = this.duplicateTree(nodeList.item(inode));
                    if (childNode == null) continue;
                    outNode.appendChild(childNode);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return outNode;
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        DrbDefaultMutableNode newNode;
        if (node == null) {
            throw new NullPointerException("DrbDefaultMutableNode.appendChild() : The reference to the node to append is null.");
        }
        if (this.referenceNode != null) {
            return this.referenceNode.appendChild(node);
        }
        if (!(node instanceof DrbDefaultMutableNode)) {
            newNode = this.duplicateTree(node);
            if (newNode == null) {
                throw new UnsupportedOperationException("DrbDefaultMutableNode.appendChild() :Cannot duplicate input tree.");
            }
        } else {
            newNode = (DrbDefaultMutableNode)node;
        }
        if (this.children == null) {
            this.children = new DrbDefaultNodeList();
        }
        if (newNode.referenceNode != null) {
            this.children.add(newNode.referenceNode);
        } else {
            this.children.add(newNode);
        }
        newNode.setParent(this);
        int nodeIndex = this.children.getLength() - 1;
        newNode.setIndex(nodeIndex);
        if (nodeIndex > 0) {
            newNode.setPreviousSibling(this.children.item(nodeIndex - 1));
        } else {
            newNode.setPreviousSibling(null);
        }
        newNode.setNextSibling(null);
        if (this.children.getLength() > 1 && this.children.item(this.children.getLength() - 2) instanceof DrbDefaultMutableNode) {
            ((DrbDefaultMutableNode)this.children.item(this.children.getLength() - 2)).setNextSibling(newNode);
        }
        DrbDefaultNodeList nodeList = new DrbDefaultNodeList();
        if (newNode.referenceNode != null) {
            nodeList.add(newNode.referenceNode);
        } else {
            nodeList.add(newNode);
        }
        this.nodesInserted(new DrbNodesChangeEvent(this, nodeList));
        return this.children.item(this.children.getLength() - 1);
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        DrbDefaultMutableNode newNode;
        if (node == null) {
            throw new NullPointerException("DrbDefaultMutableNode.insertChild() : The reference to the node to append is null.");
        }
        if (this.referenceNode != null) {
            return this.referenceNode.insertChild(node, index);
        }
        if (index < 0 || this.children == null && index != 0 || this.children != null && index > this.children.size()) {
            throw new IndexOutOfBoundsException("DrbDefaultMutableNode.insertChild() : Invalid requested index (children count=" + (this.children != null ? this.children.size() : 0) + ", index=" + index);
        }
        if (!(node instanceof DrbDefaultMutableNode)) {
            newNode = this.duplicateTree(node);
            if (newNode == null) {
                throw new UnsupportedOperationException("DrbDefaultMutableNode.insertChild() :Cannot duplicate input tree.");
            }
        } else {
            newNode = (DrbDefaultMutableNode)node;
        }
        if (this.children == null) {
            this.children = new DrbDefaultNodeList();
        }
        try {
            this.children.add(index, newNode);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("DrbDefaultMutableNode.insertChild() : " + e + "\nThe index had however already been checked !?");
        }
        newNode.setParent(this);
        newNode.setIndex(index);
        if (index > 0) {
            newNode.setPreviousSibling(this.children.item(index - 1));
            ((DrbDefaultMutableNode)this.children.item(index - 1)).setNextSibling(newNode);
        } else {
            newNode.setPreviousSibling(null);
        }
        if (index < this.children.size() - 2) {
            newNode.setNextSibling(this.children.item(index + 1));
            ((DrbDefaultMutableNode)this.children.item(index + 1)).setPreviousSibling(newNode);
        } else {
            newNode.setNextSibling(null);
        }
        for (int ichild = index + 1; ichild < this.children.size(); ++ichild) {
            DrbDefaultMutableNode nextSibling = (DrbDefaultMutableNode)this.children.get(ichild);
            if (nextSibling != null) {
                nextSibling.setIndex(ichild);
                continue;
            }
            logger.error("DrbDefaultMutableNode.insertChild() : Warning : Cannot set index of the next sibling #" + ichild);
        }
        DrbDefaultNodeList nodeList = new DrbDefaultNodeList();
        nodeList.add(newNode);
        this.nodesInserted(new DrbNodesChangeEvent(this, nodeList));
        return newNode;
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        DrbDefaultMutableNode removedChild;
        if (this.referenceNode != null) {
            this.referenceNode.removeChild(index);
            return;
        }
        try {
            if (this.children == null) {
                throw new IndexOutOfBoundsException("DrbDefaultMutableNode.removeChild() : No child to removed (index = " + index + ").");
            }
            removedChild = (DrbDefaultMutableNode)this.children.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new UnsupportedOperationException("DrbDefaultMutableNode.removeChild() : " + e);
        }
        DrbDefaultMutableNode previousSibling = (DrbDefaultMutableNode)removedChild.getPreviousSibling();
        DrbDefaultMutableNode nextSibling = (DrbDefaultMutableNode)removedChild.getNextSibling();
        if (previousSibling != null) {
            previousSibling.setNextSibling(nextSibling);
        }
        if (nextSibling != null) {
            nextSibling.setPreviousSibling(previousSibling);
        }
        for (DrbDefaultMutableNode child = nextSibling; child != null; child = (DrbDefaultMutableNode)child.getNextSibling()) {
            child.setIndex(child.getIndex() - 1);
        }
        DrbDefaultNodeList nodeList = new DrbDefaultNodeList();
        nodeList.add(removedChild);
        this.nodesRemoved(new DrbNodesChangeEvent(this, nodeList));
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (node == null) {
            throw new NullPointerException("DrbDefaultMutableNode.replaceChild() : Reference to the node is null.");
        }
        if (this.referenceNode != null) {
            return this.referenceNode.replaceChild(index, node);
        }
        DrbDefaultMutableNode replacingNode = null;
        try {
            this.removeChild(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("DrbDefaultMutableNode.replaceChild() : " + e + "\n   Unable to remove node because the index is outside range.");
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("DrbDefaultMutableNode.replaceChild() : " + e + "\n   This exception should never be thrown !!!\n   The children list may be inconsistent.");
        }
        try {
            replacingNode = (DrbDefaultMutableNode)this.insertChild(node, index);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("DrbDefaultMutableNode.replaceChild() : " + e + "\n   Unable to insert a null child.\n   This exception should never be thrown !!!");
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("DrbDefaultMutableNode.replaceChild() : " + e + "\n   Unable to insert the child at the position #" + index + ".\n   This exception should never be thrown !!!");
        }
        catch (UnsupportedOperationException e) {
            throw new IndexOutOfBoundsException("DrbDefaultMutableNode.replaceChild() : " + e + "\n   Unable to insert the child for unknown reason.\n   This exception should never be thrown !!!");
        }
        DrbDefaultNodeList nodeList = new DrbDefaultNodeList();
        nodeList.add(replacingNode);
        this.structureChanged(new DrbNodesChangeEvent(this, nodeList));
        return replacingNode;
    }

    @Override
    public DrbNode appendReference(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        return this.appendChild(new DrbDefaultMutableNode(node));
    }

    @Override
    public DrbNode getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(DrbNode previous_sibling) {
        this.previousSibling = previous_sibling;
    }

    @Override
    public DrbNode getNextSibling() {
        return this.nextSibling;
    }

    public void setNextSibling(DrbNode next_sibling) {
        this.nextSibling = next_sibling;
    }

    public boolean isSame(DrbNode node) {
        return node == this;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setUserObject(Object user_object) {
        this.userObject = user_object;
    }

    public void setRootPath(String root_path) {
        if (root_path == null) {
            this.rootPath = "";
        } else {
            if (root_path.endsWith("/")) {
                root_path = root_path.substring(0, root_path.length() - 1);
            }
            this.rootPath = root_path;
        }
    }

    @Override
    public boolean hasImpl(Class api) {
        if (api == null) {
            return false;
        }
        if (api.isInstance(this.getUserObject())) {
            return true;
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        if (api == null) {
            return null;
        }
        if (api.isInstance(this.getUserObject())) {
            return this.getUserObject();
        }
        return super.getImpl(api);
    }

    @Override
    public String toString() {
        String outputString = "<" + this.getName() + ">\n";
        if (this.getValue() != null) {
            outputString = outputString + "   " + this.getValue() + "\n";
        }
        if (this.children != null) {
            for (int ichild = 0; ichild < this.children.getLength(); ++ichild) {
                outputString = outputString + this.children.item(ichild);
            }
        }
        outputString = outputString + "</" + this.getName() + ">\n";
        return outputString;
    }

    public static void main(String[] args) {
        DrbDefaultMutableNode root = new DrbDefaultMutableNode("root");
        DrbDefaultMutableNode child_1 = null;
        DrbDefaultMutableNode child_2 = null;
        root.appendChild(new DrbDefaultMutableNode("toto"));
        child_1 = new DrbDefaultMutableNode("multi");
        root.appendChild(child_1);
        child_2 = new DrbDefaultMutableNode("multi");
        root.appendChild(child_2);
        root.appendChild(new DrbDefaultMutableNode("tutu"));
        XmlFactory.writeXML(root, System.out);
        System.out.println("root.getPath=" + root.getPath());
        System.out.println("child_1.getPath=" + child_1.getPath());
        System.out.println("child_1.getPreviousSibling=" + child_1.getPreviousSibling().getPath());
        System.out.println("child_1.getNextSibling=" + child_1.getNextSibling().getPath());
        System.out.println("child_2.getPath=" + child_2.getPath());
        System.out.println("child_2.getPreviousSibling=" + child_2.getPreviousSibling().getPath());
        System.out.println("child_2.getNextSibling=" + child_2.getNextSibling().getPath());
    }
}

