/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb;

import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbFactoryResolver;
import fr.gael.drb.impl.URLNode;
import fr.gael.drb.impl.file.FileFactory;
import fr.gael.drb.impl.spi.DrbNodeSpi;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.StaticException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public abstract class DrbFactory {
    private static Logger logger = Logger.getLogger(DrbFactory.class);
    public static final String DRB_IDENTIFIER = "drb";
    public static final int MAJOR_VERSION = 2;
    public static final int MINIMAL_MINOR_VERSION = 3;
    private static Hashtable<String, DrbFactoryImpl> factoryHash = new Hashtable();

    public static String getImplementationVersion() {
        return DrbFactory.class.getPackage().getImplementationVersion();
    }

    public static DrbNode open(String xquery) {
        try {
            Query query = new Query(xquery);
            DrbNode dot = DrbFactory.openURI(".");
            DrbSequence sequence = query.evaluate(dot);
            if (sequence != null && sequence.getLength() > 0 && sequence.getItem(0) != null && sequence.getItem(0).getItemType() == 1) {
                return (DrbNode)sequence.getItem(0);
            }
            DrbNode node = DrbFactory.openURI(xquery);
            if (node != null) {
                return node;
            }
        }
        catch (DynamicException e1) {
            return DrbFactory.openURI(xquery);
        }
        catch (StaticException e2) {
            return DrbFactory.openURI(xquery);
        }
        catch (Exception e3) {
            logger.warn("Cannot parse or evaluate the XQuery \"" + xquery + "\"");
            logger.warn(e3.getMessage());
            e3.printStackTrace();
            return null;
        }
        return null;
    }

    public static DrbNode openAs(String uri, String format) {
        DrbNode base_node = DrbFactory.openURI(uri);
        if (base_node == null) {
            return null;
        }
        DrbFactoryImpl impl = factoryHash.get(format);
        if (impl == null) {
            impl = DrbFactoryResolver.resolveImpl(format);
        }
        if (impl == null) {
            try {
                Object obj = Class.forName(format).newInstance();
                if (!(obj instanceof DrbFactoryImpl)) {
                    return null;
                }
                impl = (DrbFactoryImpl)obj;
            }
            catch (Exception e) {
                return null;
            }
        }
        return impl.open(base_node);
    }

    public static DrbNode openURI(String uri) {
        return DrbFactory.openURI(uri, true);
    }

    public static DrbNode openURI(String uri_string, boolean spi_envelope) {
        DrbNode base_node = null;
        if (logger.isDebugEnabled()) {
            logger.debug("DrbFactory.openURI(" + uri_string + ")");
        }
        try {
            base_node = new FileFactory().open(uri_string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("URI(" + uri_string + ") opened as a file.");
        if (base_node == null) {
            try {
                URL url = new URL(uri_string);
                logger.debug("DrbFactory.openURI(" + uri_string + "): protocol=" + url.getProtocol() + " path=" + url.getPath());
                DrbFactoryImpl factory = DrbFactoryResolver.resolveImpl(url.getProtocol());
                base_node = factory == null ? new URLNode(url) : factory.open(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (spi_envelope && base_node != null && !(base_node instanceof DrbNodeSpi)) {
            base_node = new DrbNodeSpi(base_node);
        }
        return base_node;
    }

    public static DrbNodeList open(DrbNode node) {
        if (node == null) {
            return null;
        }
        DrbNodeList subImplChildren = null;
        DrbFactoryImpl impl = DrbFactoryResolver.resolveImpl(node);
        if (logger.isDebugEnabled()) {
            logger.debug("Sub-implementation factory = \"" + (impl != null ? impl.getName() : null) + "\"");
        }
        if (impl == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No sub-implementation for node \"" + node.getName() + "\" (no matching factory found).");
            }
            return null;
        }
        DrbNode subimpl_child = impl.open(node);
        if (logger.isDebugEnabled()) {
            if (subimpl_child != null) {
                logger.debug("Sub-implementation \"" + impl.getName() + "\" of node \"" + node.getName() + "\" found a child node \"" + subimpl_child.getName() + "\".");
            } else {
                logger.debug("Sub-implementation \"" + impl.getName() + "\" of node \"" + node.getName() + "\" did not found any child node.");
            }
        }
        if (("jar".equals(impl.getIdentifier()) || "zip".equals(impl.getIdentifier()) || "tar".equals(impl.getIdentifier())) && subimpl_child != null) {
            subImplChildren = subimpl_child.getChildren();
        }
        if (subImplChildren == null && subimpl_child != null) {
            subImplChildren = new DrbDefaultNodeList();
            ((DrbDefaultNodeList)subImplChildren).add(subimpl_child);
        }
        if (logger.isDebugEnabled()) {
            if (subImplChildren != null) {
                logger.debug("Sub-implementation of node \"" + node.getName() + "\" resolved (children count = " + subImplChildren.getLength() + ")");
            } else {
                logger.debug("No sub-implementation for node \"" + node.getName() + "\" (matching factory found but resulted in no child).");
            }
        }
        return subImplChildren;
    }

    public static synchronized void registerImplementation(DrbFactoryImpl factory, String format) {
        factoryHash.put(format, factory);
    }

    public static void main(String[] args) {
        int iarg;
        boolean argument_error = false;
        boolean display_usage = false;
        for (iarg = 0; iarg < args.length; ++iarg) {
            if (!args[iarg].equals("-help") && !args[iarg].equals("--help") && !args[iarg].equals("-h")) continue;
            System.out.println("Usage: java fr.gael.drb.DrbFactory [OPTIONS]\n\n[--help | -h]: prints out the present usage\n\n[--version]: prints out the current implementation version.");
            return;
        }
        for (iarg = 0; iarg < args.length; ++iarg) {
            if (!args[iarg].equals("-v") && !args[iarg].equals("--version")) continue;
            System.out.println(DrbFactory.class.getPackage().getImplementationTitle() + " - " + DrbFactory.getImplementationVersion() + " (" + DrbFactory.class.getPackage().getImplementationVendor() + ")");
            return;
        }
        for (iarg = 0; iarg < args.length; ++iarg) {
            display_usage = true;
            argument_error = true;
            logger.warn("Unsupported argument \"" + args[iarg] + "\" (skipped).");
        }
        if (display_usage) {
            logger.warn("Use --help option to display proper usage.");
        }
        if (argument_error) {
            logger.fatal("Error while processing command line parameters.");
            Runtime.getRuntime().exit(1);
        }
    }
}

