/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.file;

import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.file.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.log4j.Logger;

public final class FileFactory
implements DrbFactoryImpl {
    private static Logger logger = Logger.getLogger(FileFactory.class);

    @Override
    public final String getIdentifier() {
        return "file";
    }

    @Override
    public final String getName() {
        return "Local file system";
    }

    @Override
    public final DrbNode open(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URI local = new java.io.File(".").toURI();
            URI uri = local.resolve(url.toString());
            java.io.File file = uri.isOpaque() ? new java.io.File(URLDecoder.decode(uri.getSchemeSpecificPart(), "UTF-8")) : new java.io.File(uri);
            if (!file.exists()) {
                logger.info("FileFactory.openURL(" + url + ") : file '" + file.getPath() + "' does not exist.");
                return null;
            }
            return new File(file);
        }
        catch (IllegalArgumentException e1) {
            logger.info("FileFactory.openURL(" + url + ") : " + e1);
            return null;
        }
        catch (UnsupportedEncodingException e2) {
            logger.info("FileFactory.openURL(" + url + ") : " + e2);
            return null;
        }
    }

    public final DrbNode open(String file_path) {
        if (file_path == null) {
            return null;
        }
        java.io.File file = new java.io.File(file_path);
        if (!file.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("File path " + file_path + " is not an abstract path name or file does not exist.(probing file path as a URI)...");
            }
            try {
                file = new java.io.File(new URI(file_path));
                if (!file.exists()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("File path " + file_path + " is not a URI or file does not exist (aborting).");
                    }
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("File path " + file_path + " follows a URI and corresponding file has been found.");
                }
            }
            catch (URISyntaxException exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug("File path " + file_path + " has not a URI syntax (aborting).", exception);
                }
                return null;
            }
        }
        return new File(file);
    }

    @Override
    public final DrbNode open(DrbNode base_node) {
        return null;
    }

    @Override
    public final DrbNode open(URL uri, DrbNode base_node) {
        return this.open(uri);
    }

    public final DrbNode open(java.io.File file) {
        if (file == null) {
            return null;
        }
        return new File(file);
    }
}

