/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.sds.AbstractBlock;
import fr.gael.drb.impl.sds.Descriptor;
import fr.gael.drb.value.Value;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

class FixedSimpleBlock
extends AbstractBlock {
    private static Logger logger = Logger.getLogger(FixedSimpleBlock.class);
    private int indexValue = -1;
    protected Value value = null;
    protected DrbNode parent;

    protected FixedSimpleBlock(Descriptor descriptor, int[] key) {
        super(descriptor, key);
    }

    @Override
    public int getIndex() {
        if (this.indexValue < 0) {
            this.indexValue = super.getIndex();
        }
        return this.indexValue;
    }

    @Override
    public final DrbNode getParent() {
        if (this.parent == null) {
            this.parent = super.getParent();
        }
        return this.parent;
    }

    @Override
    public final DrbNodeList getChildren() {
        return null;
    }

    @Override
    public final boolean hasChild() {
        return false;
    }

    @Override
    public final int getChildrenCount() {
        return 0;
    }

    @Override
    public final DrbNode getFirstChild() {
        return null;
    }

    @Override
    public final DrbNode getLastChild() {
        return null;
    }

    @Override
    public final DrbNode getChildAt(int index) {
        return null;
    }

    @Override
    public final DrbNode getNamedChild(String name, int occurrence) {
        return null;
    }

    @Override
    public boolean hasImpl(Class api) {
        if (api == InputStream.class) {
            return true;
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        if (api == InputStream.class) {
            Value value = this.getValue();
            if (value == null) {
                return null;
            }
            switch (value.getType()) {
                case 7: {
                    return new ByteArrayInputStream(value.toString().getBytes());
                }
            }
            return null;
        }
        return super.getImpl(api);
    }

    @Override
    public Value getValue() {
        if (this.descriptor != null && this.descriptor.getValueType() == -1) {
            return null;
        }
        if (this.value == null) {
            this.value = this.descriptor.getValue(this.key);
        }
        return this.value;
    }

    @Override
    public int getValueType() {
        return this.descriptor.getValueType();
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        this.value = super.setValue(value);
        return this.value;
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException("SimpleBlock.insertChild(): This operation is not supported ");
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("SimpleBlock.appendChild(): This operation is not supported ");
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("SimpleBlock.replaceChild(): This operation is not supported ");
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("SimpleBlock.removeChild(): This operation is not supported.");
    }
}

