/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.DrbItem;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import org.w3c.dom.Node;

class XmlItem
implements DrbItem {
    public static final int ELEMENT_ITEM = 1;
    public static final int TEXT_ITEM = 3;
    public static final int COMMENT_ITEM = 4;
    public static final int PROCESSING_INSTRUCTION_ITEM = 5;
    public static final int NOTATION_ITEM = 6;
    public static final int ENTITY_ITEM = 7;
    public static final int DOCUMENT_TYPE_ITEM = 8;
    private Node node;

    XmlItem(Node node) {
        this.node = node;
    }

    @Override
    public java.lang.String getName() {
        return this.node.getLocalName();
    }

    @Override
    public void rename(java.lang.String name) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot rename an XML item");
    }

    @Override
    public int getItemType() {
        switch (this.node.getNodeType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 3;
            }
            case 8: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 12: {
                return 6;
            }
            case 10: {
                return 8;
            }
            case 6: {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public java.lang.String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public void setNamespaceURI(java.lang.String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot rename an XML item");
    }

    @Override
    public Value getValue() {
        java.lang.String text = this.node.getNodeValue();
        if (text == null) {
            return null;
        }
        return new String(text);
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        if (value == null) {
            throw new NullPointerException("The value shall not be null.");
        }
        this.node.setNodeValue(value.toString());
        return value.convertTo(7);
    }

    public java.lang.String toString() {
        return "@" + this.getName() + "=" + this.getValue();
    }
}

