/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.QName;
import fr.gael.drb.query.SequenceType;
import fr.gael.drb.query.Variable;

abstract class AbstractVariable
implements Variable {
    private QName name = null;
    private SequenceType sequenceType = new SequenceType();

    AbstractVariable(AbstractVariable variable) {
        this.name = variable.name;
        this.sequenceType = variable.sequenceType;
    }

    AbstractVariable(QName name) {
        if (name == null) {
            throw new NullPointerException("A variable cannot be instanciated without name.");
        }
        this.name = new QName(name);
    }

    AbstractVariable(QName name, SequenceType sequence_type) {
        if (name == null) {
            throw new NullPointerException("A variable cannot be instanciated without name.");
        }
        this.name = new QName(name);
        this.sequenceType = sequence_type;
    }

    @Override
    public QName getQName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    protected void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Cannot replace name with a null reference.");
        }
        this.name = new QName(name);
    }

    protected SequenceType getSequenceType() {
        return this.sequenceType;
    }

    @Override
    public String getSequenceTypeName() {
        if (this.sequenceType != null) {
            return this.sequenceType.getName();
        }
        return null;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    public String toString() {
        if (this.sequenceType != null) {
            return this.name.getName() + this.sequenceType;
        }
        return this.name.getName();
    }

    @Override
    public abstract Object clone();
}

