/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.ConstructorExpression;
import fr.gael.drb.query.ConstructorNode;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import org.apache.log4j.Logger;

class ComputedElementConstructorExpression
extends ConstructorExpression {
    private static Logger logger = Logger.getLogger(ComputedElementConstructorExpression.class);
    private Expression name_expression;

    public ComputedElementConstructorExpression(Token token, java.lang.String name) {
        super("Computed Element constructor", token);
        this.name = new QName(name);
        this.name_expression = null;
    }

    public ComputedElementConstructorExpression(Token token, Expression name_expression) {
        super("Computed Element constructor", token);
        this.name_expression = name_expression;
        this.name = null;
    }

    @Override
    public DrbSequence evaluate(DynamicContext outer_context) {
        DynamicContext context = new DynamicContext(outer_context);
        ConstructorNode node = null;
        QName name = this.processNodeName(context);
        node = new ConstructorNode(name.getLocalName());
        this.setNodeURI(context, node, name);
        this.processContent(context, node);
        node.setNamespaceBindings(this.declaredNamespaces);
        return new DrbDefaultSequence(node);
    }

    private QName processNodeName(DynamicContext context) {
        if (this.name != null) {
            return this.name;
        }
        if (this.name_expression == null) {
            throw new DynamicException(this, "The name or the name expression of the element constructor cannot be null");
        }
        DrbSequence sequence = this.name_expression.evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the name expression");
        }
        ValueArray array = sequence.atomize();
        if (array.length() != 1) {
            throw new TypeException(this, "XPTY0004 - The sequence length of the name expression must be one");
        }
        Value value = array.getElement(0);
        if (!(value instanceof String)) {
            throw new TypeException(this, "XPTY0004 - Result of the evaluation of the name expression must be a singleton containing either a String or a QName");
        }
        return new QName(value.toString());
    }

    @Override
    protected java.lang.String getAdjacentTextNodeSeparator() {
        return "";
    }
}

