/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbFactory;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.xml.XmlFactory;
import fr.gael.drb.impl.xml.XmlWriter;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DataResult;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Function;
import fr.gael.drb.query.LiteralResult;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.StaticContext;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Arithmetic;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.ByteArray;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.DateTime;
import fr.gael.drb.value.Decimal;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.DoubleArray;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.IntArray;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.Logic;
import fr.gael.drb.value.LongArray;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.ShortArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdElement;
import fr.gael.drb.xsd.XsdFactory;
import fr.gael.drb.xsd.XsdNode;
import fr.gael.drb.xsd.XsdNodeImpl;
import fr.gael.drb.xsd.XsdSimpleType;
import fr.gael.drb.xsd.XsdType;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;

class FunctionCallExpression
extends AbstractExpression {
    private Logger logger = Logger.getLogger(FunctionCallExpression.class);
    private QName functionName;
    private Vector<Expression> parameters = new Vector();
    private final int MATH_FUNCTION_ABS = 1;
    private final int MATH_FUNCTION_SQRT = 2;
    private final int MATH_FUNCTION_POWER = 3;
    private final int MATH_FUNCTION_LOG = 4;
    private final int MATH_FUNCTION_RANDOM = 5;
    private final int MATH_FUNCTION_SIN = 6;
    private final int MATH_FUNCTION_COS = 7;
    private final int MATH_FUNCTION_TAN = 8;
    private final int MATH_FUNCTION_ASIN = 9;
    private final int MATH_FUNCTION_ACOS = 10;
    private final int MATH_FUNCTION_ATAN = 11;
    private final int MATH_FUNCTION_ATAN2 = 12;
    private final int MATH_FUNCTION_EXP = 13;
    XmlSchema defaultSchema = null;
    private static boolean isZeroLengthMatchingWarningPrinted = false;
    private static int BEFORE = 0;
    private static int AFTER = 1;

    public FunctionCallExpression(Token token, String name) {
        super("Function call", token);
        this.functionName = new QName(name);
    }

    public FunctionCallExpression(Token token, QName name) {
        super("Function call", token);
        this.functionName = new QName(name.getName(), name.getNamespaceURI());
    }

    public void addParameter(Expression expression) {
        this.parameters.add(expression);
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        if ("http://www.w3.org/2005/xpath-functions".equals(this.functionName.getNamespaceURI())) {
            if (this.functionName.getLocalName().equals("count")) {
                return this.count(context);
            }
            if (this.functionName.getLocalName().equals("position")) {
                return this.position(context);
            }
            if (this.functionName.getLocalName().equals("last")) {
                return this.last(context);
            }
            if (this.functionName.getLocalName().equals("name")) {
                return this.name(context);
            }
            if (this.functionName.getLocalName().equals("namespace-uri")) {
                return this.namespaceURI(context);
            }
            if (this.functionName.getLocalName().equals("node-name")) {
                return this.nodeName(context);
            }
            if (this.functionName.getLocalName().equals("data")) {
                return this.data(context);
            }
            if (this.functionName.getLocalName().equals("true")) {
                return this.trueBoolean(context);
            }
            if (this.functionName.getLocalName().equals("false")) {
                return this.falseBoolean(context);
            }
            if (this.functionName.getLocalName().equals("not")) {
                return this.not(context);
            }
            if (this.functionName.getLocalName().equals("avg")) {
                return this.avg(context);
            }
            if (this.functionName.getLocalName().equals("sum")) {
                return this.sum(context);
            }
            if (this.functionName.getLocalName().equals("min")) {
                return this.min(context);
            }
            if (this.functionName.getLocalName().equals("max")) {
                return this.max(context);
            }
            if (this.functionName.getLocalName().equals("ceiling")) {
                return this.ceiling(context);
            }
            if (this.functionName.getLocalName().equals("floor")) {
                return this.floor(context);
            }
            if (this.functionName.getLocalName().equals("round")) {
                return this.round(context);
            }
            if (this.functionName.getLocalName().equals("doc")) {
                return this.doc(context);
            }
            if (this.functionName.getLocalName().equals("empty")) {
                return this.empty(context);
            }
            if (this.functionName.getLocalName().equals("exists")) {
                return this.exists(context);
            }
            if (this.functionName.getLocalName().equals("concat")) {
                return this.concat(context);
            }
            if (this.functionName.getLocalName().equals("substring")) {
                return this.substring(context);
            }
            if (this.functionName.getLocalName().equals("compare")) {
                return this.compare(context);
            }
            if (this.functionName.getLocalName().equals("substring-before")) {
                return this.substringBeforeOrAfter(context, BEFORE);
            }
            if (this.functionName.getLocalName().equals("substring-after")) {
                return this.substringBeforeOrAfter(context, AFTER);
            }
            if (this.functionName.getLocalName().equals("string-length")) {
                return this.stringLength(context);
            }
            if (this.functionName.getLocalName().equals("string-join")) {
                return this.stringJoin(context);
            }
            if (this.functionName.getLocalName().equals("matches")) {
                return this.matches(context);
            }
            if (this.functionName.getLocalName().equals("tokenize")) {
                return this.tokenize(context);
            }
            if (this.functionName.getLocalName().equals("replace")) {
                return this.replace(context);
            }
            if (this.functionName.getLocalName().equals("current-dateTime")) {
                return this.currentDateTime(context);
            }
            if (this.functionName.getLocalName().equals("error")) {
                return this.error(context);
            }
            if (this.functionName.getLocalName().equals("trace")) {
                return this.trace(context);
            }
            if (this.functionName.getLocalName().equals("abs")) {
                return this.mathFunction(context, 1);
            }
            if (this.functionName.getLocalName().equals("index")) {
                this.logger.warn("Built-in function index() is deprecated and should be replaced by the drb:index(). This deprecation has been performed to seggregate the standard function from the ones provided by the DRB API. The arity and functionality remain however, unchanged.");
            } else {
                if (this.functionName.getLocalName().equals("evaluate-uri")) {
                    this.logger.warn("Built-in function evaluate-uri() is deprecated and should be replaced by the drb:evaluate-uri(). This deprecation has been performed to seggregate the standard function from the ones provided by the DRB API. The arity and functionality remain however, unchanged.");
                    return this.evaluateURI(context);
                }
                if (this.functionName.getLocalName().equals("evaluate-string")) {
                    this.logger.warn("Built-in function evaluate-string() is deprecated and should be replaced by the drb:evaluate-string(). This deprecation has been performed to seggregate the standard function from the ones provided by the DRB API. The arity and functionality remain however, unchanged.");
                    return this.evaluateString(context);
                }
                if (this.functionName.getLocalName().equals("deep-invalid")) {
                    this.logger.warn("Built-in function deep-invalid() is deprecated and should be replaced by the drb:deep-invalid(). This deprecation has been performed to seggregate the standard function from the ones provided by the DRB API. The arity and functionality remain however, unchanged.");
                    return this.deepInvalid(context);
                }
            }
        } else {
            if ("http://www.w3.org/2001/XMLSchema".equals(this.functionName.getNamespaceURI())) {
                return this.atomicTypeConstructor(context);
            }
            if ("http://www.gael.fr/drb".equals(this.functionName.getNamespaceURI())) {
                if (this.functionName.getLocalName().equals("evaluate-string")) {
                    return this.evaluateString(context);
                }
                if (this.functionName.getLocalName().matches("xml-string")) {
                    return this.xmlString(context);
                }
                if (this.functionName.getLocalName().equals("deep-invalid")) {
                    return this.deepInvalid(context);
                }
                if (this.functionName.getLocalName().equals("import-doc")) {
                    return this.importDoc(context);
                }
                if (this.functionName.getLocalName().equals("evaluate-uri")) {
                    return this.evaluateURI(context);
                }
                if (this.functionName.getLocalName().matches("xml-doc")) {
                    return this.xmlDoc(context);
                }
                if (this.functionName.getLocalName().matches("insertInto")) {
                    return this.insertInto(context);
                }
                if (this.functionName.getLocalName().equals("index")) {
                    return this.index(context);
                }
                if (this.functionName.getLocalName().equals("path")) {
                    return this.path(context);
                }
                if (this.functionName.getLocalName().equals("Iso8601DateFormatter")) {
                    return this.iso8601DateFormatter(context);
                }
            } else if ("http://exslt.org/math".equals(this.functionName.getNamespaceURI())) {
                if (this.functionName.getLocalName().equals("abs")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_ABS);
                }
                if (this.functionName.getLocalName().equals("sqrt")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_SQRT);
                }
                if (this.functionName.getLocalName().equals("power")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_POWER);
                }
                if (this.functionName.getLocalName().equals("log")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_LOG);
                }
                if (this.functionName.getLocalName().equals("random")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_RANDOM);
                }
                if (this.functionName.getLocalName().equals("sin")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_SIN);
                }
                if (this.functionName.getLocalName().equals("cos")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_COS);
                }
                if (this.functionName.getLocalName().equals("tan")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_TAN);
                }
                if (this.functionName.getLocalName().equals("asin")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_ASIN);
                }
                if (this.functionName.getLocalName().equals("acos")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_ACOS);
                }
                if (this.functionName.getLocalName().equals("atan")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_ATAN);
                }
                if (this.functionName.getLocalName().equals("atan2")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_ATAN2);
                }
                if (this.functionName.getLocalName().equals("exp")) {
                    return this.mathFunction(context, this.MATH_FUNCTION_EXP);
                }
            } else {
                if (this.functionName.getName().matches("esa:utc-to-mjd")) {
                    return this.utcToMjd(context);
                }
                if (this.functionName.getName().matches("gael:utc-to-mjd")) {
                    this.logger.warn("Built-in function gael:utc-to-mjd() is deprecated and should be replaced by the esa:utc-to-mjd().");
                    return this.utcToMjd(context);
                }
            }
        }
        Function function = context.getInScopeFunction(this.functionName);
        if (function != null) {
            Vector<DrbSequence> values = new Vector<DrbSequence>();
            for (Expression param_expr : this.parameters) {
                values.add(param_expr.evaluate(context));
            }
            return function.evaluate(context, values);
        }
        if (this.functionName.getNamespaceURI() != null && this.functionName.getNamespaceURI().startsWith("java:")) {
            return this.javaFunction(context);
        }
        throw new DynamicException(this, "XP0017 - Function call " + this.functionName.getName() + "() does not match the name and arity of any built-in function");
    }

    private DrbSequence javaFunction(DynamicContext context) {
        String nsuri = this.functionName.getNamespaceURI();
        String className = nsuri.replace("java:", "");
        String methodName = this.functionName.getLocalName();
        try {
            Class<?> java_class = Class.forName(className);
            Method[] java_methods = java_class.getMethods();
            Method match_method = null;
            int match_count = 0;
            for (Method method : java_methods) {
                if (!method.getName().equals(methodName)) continue;
                Class<?>[] param_types = method.getParameterTypes();
                if (!method.isVarArgs() && param_types.length != this.parameters.size()) continue;
                ++match_count;
                match_method = method;
            }
            if (match_count > 1) {
                this.logger.warn("Found " + match_count + " java functions matching " + this.functionName);
            }
            if (match_method != null) {
                return this.javaFunction(context, match_method);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DynamicException(this, "XP0017 - Function call " + this.functionName.getName() + "() does not match any java class");
        }
        throw new DynamicException(this, "XP0017 - Function call " + this.functionName.getName() + "() does not match the name and arity of any method in class " + className);
    }

    private DrbSequence javaFunction(DynamicContext context, Method method) {
        Class<?>[] arg_classes = method.getParameterTypes();
        Object[] args = new Object[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            Expression expr = this.parameters.get(i);
            if (expr == null) {
                throw new DynamicException(this, this.functionName + "(): error while evaluating the parameter " + (i + 1));
            }
            DrbSequence param_sequence = expr.evaluate(context);
            if (param_sequence == null || param_sequence.getLength() > 1) {
                throw new DynamicException(this, this.functionName + "(): error while evaluating the parameter " + (i + 1));
            }
            if (param_sequence.getLength() == 0) continue;
            Value value = param_sequence.getItem(0).getValue();
            args[i] = Value.class.isAssignableFrom(arg_classes[i]) ? value : FunctionCallExpression.toJava(value);
        }
        try {
            DrbItem value = FunctionCallExpression.fromJava(method.invoke(null, args));
            if (value == null) {
                return new DrbDefaultSequence();
            }
            return new DrbDefaultSequence(value);
        }
        catch (IllegalAccessException e) {
            throw new DynamicException(this, this.functionName + "(): " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new DynamicException(this, this.functionName + "(): " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw new DynamicException(this, this.functionName + "(): " + e.getMessage());
        }
    }

    private static DrbItem fromJava(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DrbItem) {
            return (DrbItem)obj;
        }
        if (obj instanceof java.lang.Integer) {
            return new Int(((Number)obj).intValue());
        }
        if (obj instanceof Float) {
            return new fr.gael.drb.value.Float(((Number)obj).floatValue());
        }
        if (obj instanceof java.lang.Double) {
            return new Double(((Number)obj).doubleValue());
        }
        if (obj instanceof String) {
            return new fr.gael.drb.value.String(obj.toString());
        }
        if (obj instanceof java.lang.Boolean) {
            return new Boolean((java.lang.Boolean)obj);
        }
        if (obj instanceof Value) {
            return (Value)obj;
        }
        if (obj instanceof java.lang.Short) {
            return new Short(((Number)obj).shortValue());
        }
        if (obj instanceof Byte) {
            return new fr.gael.drb.value.Byte(((Number)obj).byteValue());
        }
        if (obj instanceof Long) {
            return new fr.gael.drb.value.Long(((Number)obj).longValue());
        }
        if (obj instanceof BigInteger) {
            return new Integer((BigInteger)obj);
        }
        if (obj instanceof BigDecimal) {
            return new Decimal(obj.toString());
        }
        if (obj instanceof Date) {
            return new DateTime(obj.toString());
        }
        if (obj instanceof int[]) {
            return new IntArray((int[])obj);
        }
        if (obj instanceof float[]) {
            return new FloatArray((float[])obj);
        }
        if (obj instanceof double[]) {
            return new DoubleArray((double[])obj);
        }
        if (obj instanceof short[]) {
            return new ShortArray((short[])obj);
        }
        if (obj instanceof byte[]) {
            return new ByteArray((byte[])obj);
        }
        if (obj instanceof long[]) {
            return new LongArray((long[])obj);
        }
        throw new UnsupportedOperationException("Unsupported value class  " + obj.getClass().getName());
    }

    private static Object toJava(Value value) {
        if (value == null) {
            return null;
        }
        if (value.getType() == 10) {
            ValueArray array = (ValueArray)value;
            switch (array.getArrayType()) {
                case 3: 
                case 14: {
                    return ((AbstractNumericArray)array).intValues();
                }
                case 6: {
                    return ((AbstractNumericArray)array).doubleValues();
                }
                case 5: {
                    return ((AbstractNumericArray)array).floatValues();
                }
                case 0: {
                    return ((AbstractNumericArray)array).booleanValues();
                }
                case 4: 
                case 15: {
                    return ((AbstractNumericArray)array).longValues();
                }
                case 2: 
                case 13: {
                    return ((AbstractNumericArray)array).shortValues();
                }
                case 1: 
                case 12: {
                    return ((AbstractNumericArray)array).byteValues();
                }
            }
        } else {
            switch (value.getType()) {
                case 3: 
                case 13: {
                    return new java.lang.Integer(((Numeric)value).intValue());
                }
                case 6: {
                    return new java.lang.Double(((Numeric)value).doubleValue());
                }
                case 5: {
                    return new Float(((Numeric)value).floatValue());
                }
                case 0: {
                    return new java.lang.Boolean(((Logic)((Object)value)).booleanValue());
                }
                case 7: {
                    return new String(value.toString());
                }
                case 4: 
                case 14: {
                    return new Long(((Numeric)value).longValue());
                }
                case 2: 
                case 12: {
                    return new java.lang.Short(((Numeric)value).shortValue());
                }
                case 1: {
                    return new Byte(((Numeric)value).byteValue());
                }
                case 15: 
                case 27: {
                    return new BigInteger(value.toString());
                }
                case 26: {
                    return new BigDecimal(value.toString());
                }
                case 24: {
                    return new Timestamp(((DateTime)value).getTime());
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported value type " + value.getType());
    }

    private DrbSequence compare(DynamicContext context) {
        Expression second_string_expr;
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, this.functionName + "() requires two parameters");
        }
        Expression first_string_expr = this.parameters.get(0);
        if (first_string_expr == null) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the first string parameter");
        }
        DrbSequence first_string_sequence = first_string_expr.evaluate(context);
        if (first_string_sequence == null || first_string_sequence.getLength() > 1) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the first string parameter");
        }
        DrbItem first_string_item = first_string_sequence.getItem(0);
        if (first_string_item == null) {
            return new DrbDefaultSequence();
        }
        Value first_string_value = first_string_item.getValue();
        if (first_string_value == null) {
            return new DrbDefaultSequence();
        }
        if (first_string_value.getType() != 7) {
            throw new TypeException(this, this.functionName + "(): the first parameter is not a string");
        }
        String first_string = first_string_value.toString();
        if (first_string == null) {
            first_string = "";
        }
        if ((second_string_expr = this.parameters.get(1)) == null) {
            throw new DynamicException(this, this.functionName + "() operation requires a string in second parameter");
        }
        DrbSequence second_string_sequence = second_string_expr.evaluate(context);
        if (second_string_sequence == null) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the second parameter");
        }
        if (second_string_sequence.getLength() > 1) {
            throw new DynamicException(this, this.functionName + "(): the second parameter cannot contains more than 1 item");
        }
        DrbItem second_string_item = second_string_sequence.getItem(0);
        if (second_string_item == null) {
            return new DrbDefaultSequence();
        }
        Value second_string_value = second_string_item.getValue();
        if (second_string_value == null) {
            return new DrbDefaultSequence();
        }
        if (second_string_value.getType() != 7) {
            throw new TypeException(this, this.functionName + "(): the second parameter is not a string");
        }
        String second_string = second_string_value.toString();
        if (second_string == null) {
            second_string = "";
        }
        return new DrbDefaultSequence(new Int(first_string.compareTo(second_string)));
    }

    private DrbSequence replace(DynamicContext context) {
        Expression replacement_string_expr;
        Expression pattern_string_expr;
        Value source_string_value;
        if (this.parameters.size() != 3) {
            throw new DynamicException(this, this.functionName + "() requires three parameters");
        }
        Expression source_string_expr = this.parameters.get(0);
        if (source_string_expr == null) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the source string parameter");
        }
        DrbSequence source_string_sequence = source_string_expr.evaluate(context);
        if (source_string_sequence == null || source_string_sequence.getLength() > 1) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the source string parameter");
        }
        String source_string = "";
        DrbItem source_string_item = source_string_sequence.getItem(0);
        if (source_string_item != null && (source_string_value = source_string_item.getValue()) != null) {
            if (source_string_value.getType() != 7) {
                throw new TypeException(this, this.functionName + "(): the first parameter is not a string");
            }
            source_string = source_string_value.toString();
        }
        if ((pattern_string_expr = this.parameters.get(1)) == null) {
            throw new DynamicException(this, this.functionName + "() operation requires a source string as \"pattern\" parameter");
        }
        DrbSequence pattern_string_sequence = pattern_string_expr.evaluate(context);
        if (pattern_string_sequence == null || pattern_string_sequence.getLength() != 1) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the \"pattern\" parameter");
        }
        DrbItem pattern_string_item = pattern_string_sequence.getItem(0);
        Value pattern_string_value = pattern_string_item.getValue();
        if (pattern_string_value == null || pattern_string_value.getType() != 7) {
            throw new TypeException(this, this.functionName + "(): \"pattern\" parameter is not an xs:string");
        }
        String pattern_string = pattern_string_value.toString();
        if ("".matches(pattern_string)) {
            DynamicException dynamic_exception = new DynamicException(this, this.functionName + "(): \"pattern\" parameter equal to \"" + pattern_string + "\" matches the zero-length string");
            if (!context.isBackwardCompatibilityMode()) {
                throw dynamic_exception;
            }
            this.logger.error("Dynamic Exception: " + dynamic_exception.getMessage());
            if (!isZeroLengthMatchingWarningPrinted) {
                this.logger.warn("Previous pattern error did not interrupt the evaluation because the backward compatibility mode has been set. This compatibility may be disrupted in any future version so users are strongly invited to update their XQuery scripts to comply the W3C recommendation c.f. http://www.w3.org/TR/2007/REC-xquery-20070123 (This message will not be repeated in this session).");
                isZeroLengthMatchingWarningPrinted = true;
            }
        }
        if ((replacement_string_expr = this.parameters.get(2)) == null) {
            throw new DynamicException(this, this.functionName + "() operation requires a \"replacement\" string as third parameter");
        }
        DrbSequence replacement_string_sequence = replacement_string_expr.evaluate(context);
        if (replacement_string_sequence == null || replacement_string_sequence.getLength() != 1) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the \"replacement\" parameter");
        }
        DrbItem replacement_string_item = replacement_string_sequence.getItem(0);
        Value replacement_string_value = replacement_string_item.getValue();
        if (replacement_string_value == null || replacement_string_value.getType() != 7) {
            throw new TypeException(this, this.functionName + "(): \"pattern\" parameter is not an xs:string");
        }
        String replacement_string = replacement_string_value.toString();
        return new DrbDefaultSequence(new fr.gael.drb.value.String(source_string.replaceAll(pattern_string, replacement_string)));
    }

    private DrbSequence substring(DynamicContext context) {
        Expression source_string_expr = this.parameters.get(0);
        if (source_string_expr == null) {
            throw new DynamicException(this, this.functionName + "() operation requires a source string as first parameter");
        }
        DrbSequence source_string_sequence = source_string_expr.evaluate(context);
        if (source_string_sequence == null || source_string_sequence.getLength() > 1) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the \"source\" string parameter");
        }
        DrbItem source_string_item = source_string_sequence.getItem(0);
        if (source_string_item == null) {
            return new DrbDefaultSequence();
        }
        Value source_string_value = source_string_item.getValue();
        if (source_string_value == null) {
            return new DrbDefaultSequence();
        }
        if (source_string_value.getType() != 7) {
            throw new TypeException(this, this.functionName + "(): the first \"source\" parameter is not a string");
        }
        String source_string = source_string_value.toString();
        if (source_string == null) {
            return new DrbDefaultSequence();
        }
        Expression starting_loc_expr = this.parameters.get(1);
        if (starting_loc_expr == null) {
            throw new DynamicException(this, this.functionName + "() operation requires the \"substring starting location\" as second parameter");
        }
        DrbSequence starting_loc_sequence = starting_loc_expr.evaluate(context);
        if (starting_loc_sequence == null || starting_loc_sequence.getLength() != 1) {
            throw new DynamicException(this, this.functionName + "(): error while evaluating the start location parameter");
        }
        DrbItem starting_loc_item = starting_loc_sequence.getItem(0);
        if (starting_loc_item == null) {
            throw new DynamicException(this, this.functionName + "() : Error while evaluating the start location parameter");
        }
        Value starting_loc_value = starting_loc_item.getValue();
        if (!(starting_loc_value instanceof Numeric)) {
            throw new DynamicException(this, "The second parameter of the function " + this.functionName + "() is not a numeric value");
        }
        Numeric starting_loc_numeric = (Numeric)starting_loc_value;
        double starting_loc = Math.floor(starting_loc_numeric.doubleValue() - 0.5);
        int begin_index = (int)Math.max(0.0, Math.min(starting_loc, (double)source_string.length()));
        int end_index = source_string.length();
        double end_loc = java.lang.Double.POSITIVE_INFINITY;
        if (this.parameters.size() >= 3) {
            Expression length_expr = this.parameters.get(2);
            if (length_expr == null) {
                throw new DynamicException(this, this.functionName + "() operation Cannot get the third parameter");
            }
            DrbSequence length_sequence = length_expr.evaluate(context);
            if (length_sequence == null || length_sequence.getLength() != 1) {
                throw new DynamicException(this, this.functionName + "() : Error while evaluating the length parameter");
            }
            DrbItem length_item = length_sequence.getItem(0);
            Value length_value = length_item.getValue();
            if (!(length_value instanceof Numeric)) {
                throw new DynamicException(this, this.functionName + "() : The length parameter (#3) shall be a numerical value");
            }
            Numeric length_numeric = (Numeric)length_value;
            double length = Math.floor(length_numeric.doubleValue() + 0.5);
            end_loc = Math.min((double)source_string.length(), starting_loc + length);
            end_index = java.lang.Double.isNaN(end_loc) ? begin_index : Math.max((int)end_loc, begin_index);
        }
        return new DrbDefaultSequence(new fr.gael.drb.value.String(source_string.substring(begin_index, end_index)));
    }

    private DrbSequence substringBeforeOrAfter(DynamicContext context, int direction) {
        Value search_string_value;
        Expression search_string_expr;
        Value source_string_value;
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, this.functionName + "() operation requires two parameters");
        }
        Expression source_string_expr = this.parameters.get(0);
        if (source_string_expr == null) {
            throw new DynamicException(this, this.functionName + "() operation requires a source string as first parameter");
        }
        DrbSequence source_string_sequence = source_string_expr.evaluate(context);
        if (source_string_sequence == null || source_string_sequence.getLength() > 1) {
            throw new DynamicException(this, this.functionName + "() : Error while evaluating the source string parameter");
        }
        DrbItem source_string_item = source_string_sequence.getItem(0);
        String source_string = "";
        if (source_string_item != null && (source_string_value = source_string_item.getValue()) != null) {
            if (source_string_value.getType() != 7) {
                throw new TypeException(this, this.functionName + "() : The first parameter is not a string");
            }
            source_string = source_string_value.toString();
        }
        if ((search_string_expr = this.parameters.get(1)) == null) {
            throw new DynamicException(this, this.functionName + "() operation requires the substring starting location as second parameter");
        }
        DrbSequence starting_loc_sequence = search_string_expr.evaluate(context);
        if (starting_loc_sequence == null || starting_loc_sequence.getLength() > 1) {
            throw new DynamicException(this, this.functionName + "() : Error while evaluating the start location parameter");
        }
        String search_string = "";
        DrbItem search_string_item = starting_loc_sequence.getItem(0);
        if (search_string_item != null && (search_string_value = search_string_item.getValue()) != null) {
            if (search_string_value.getType() != 7) {
                throw new TypeException(this, this.functionName + "() : The first parameter is not a string");
            }
            search_string = search_string_value.toString();
        }
        if (search_string == null || search_string.length() == 0) {
            return new DrbDefaultSequence(new fr.gael.drb.value.String(source_string));
        }
        int match_index = source_string.indexOf(search_string);
        if (match_index == -1) {
            return new DrbDefaultSequence(new fr.gael.drb.value.String(""));
        }
        String output_string = direction == BEFORE ? source_string.substring(0, match_index) : source_string.substring(match_index + search_string.length(), source_string.length());
        return new DrbDefaultSequence(new fr.gael.drb.value.String(output_string));
    }

    private DrbSequence count(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, "XP0017 - fn:count() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the parameter of count() function");
        }
        return new DrbDefaultSequence(new Int(sequence.getLength()));
    }

    private DrbSequence position(DynamicContext context) {
        if (this.parameters.size() != 0) {
            throw new DynamicException(this, "XP0017 - fn:position() has no parameter");
        }
        int position = context.focus.getContextPosition();
        return new DrbDefaultSequence(new Integer(position));
    }

    private DrbSequence last(DynamicContext context) {
        if (this.parameters.size() != 0) {
            throw new DynamicException(this, "XP0017 - fn:last() has no parameter");
        }
        int last = context.focus.getContextSize();
        return new DrbDefaultSequence(new Integer(last));
    }

    private DrbSequence trueBoolean(DynamicContext context) {
        if (this.parameters.size() != 0) {
            throw new DynamicException(this, this.functionName + "() has no parameter");
        }
        return LiteralResult.TRUE;
    }

    private DrbSequence falseBoolean(DynamicContext context) {
        if (this.parameters.size() != 0) {
            throw new DynamicException(this, this.functionName + "() has no parameter");
        }
        return LiteralResult.FALSE;
    }

    private DrbSequence not(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() has one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the parameter of not() function");
        }
        boolean ebv = Query.getEffectiveBooleanValue(sequence);
        if (ebv) {
            return LiteralResult.FALSE;
        }
        return LiteralResult.TRUE;
    }

    private DrbSequence index(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, "XP0017 - index() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence.getLength() != 1 || sequence.getItem(0).getItemType() != 1) {
            throw new DynamicException(this, "index() can only be applied on a node");
        }
        return new DrbDefaultSequence(new Integer(((DrbNode)sequence.getItem(0)).getIndex()));
    }

    private DrbSequence nodeName(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, this.functionName + "() : error while evaluating the parameter");
        }
        if (sequence.getLength() <= 0) {
            return LiteralResult.EMPTY_STRING;
        }
        DrbItem item = sequence.getItem(0);
        if (item == null) {
            throw new DynamicException(this, this.functionName + "(): the first item of the parameter sequence is null");
        }
        if (item.getItemType() == 3) {
            throw new DynamicException(this, this.functionName + "() requires a well-defined input node");
        }
        String name = item.getName();
        if (name == null) {
            return LiteralResult.EMPTY_STRING;
        }
        return new DrbDefaultSequence(new fr.gael.drb.value.String(name));
    }

    private DrbSequence xmlString(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, "XP0017 - " + this.functionName + "() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, this.functionName + "() : error while evaluating the parameter");
        }
        ByteArrayOutputStream output_stream = new ByteArrayOutputStream();
        PrintStream print_stream = new PrintStream(output_stream);
        for (int iitem = 0; iitem < sequence.getLength(); ++iitem) {
            DrbItem item = sequence.getItem(iitem);
            if (item == null) {
                throw new DynamicException(this, this.functionName + "(): the item #" + (iitem + 1) + " of the parameter sequence is null");
            }
            if (item.getItemType() != 1) {
                throw new DynamicException(this, this.functionName + "() cannot be applied for the item #" + (iitem + 1) + " that is not a node");
            }
            if (iitem != 0) {
                print_stream.print(" ");
            }
            XmlWriter.writeXML((DrbNode)item, print_stream, new XmlWriter.Context(context.getNamespace(), context.getDefaultElementNamespaceURI()), false);
        }
        String output_string = "" + output_stream.toString();
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        output_sequence.add(new fr.gael.drb.value.String(output_string));
        return output_sequence;
    }

    private DrbSequence data(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, "XP0017 - fn:data() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence.getLength() <= 1) {
            return sequence.atomize();
        }
        return new DataResult(sequence);
    }

    private DrbSequence exists(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, "XP0017 - fn:exists() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, this.functionName + "() : error while evaluating the parameter");
        }
        if (sequence.getLength() > 0) {
            return LiteralResult.TRUE;
        }
        return LiteralResult.FALSE;
    }

    private DrbSequence empty(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, "XP0017 - fn:empty() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, this.functionName + "() : error while evaluating the parameter");
        }
        if (sequence.getLength() == 0) {
            return LiteralResult.TRUE;
        }
        return LiteralResult.FALSE;
    }

    private DrbSequence name(DynamicContext context) {
        if (this.parameters.size() < 0 || this.parameters.size() > 1) {
            throw new DynamicException(this, "XP0017 - fn:name() requires zero or one parameter");
        }
        if (this.parameters.size() == 0) {
            if (context.focus.getContextItem() == null || context.focus.getContextItem().getItemType() == 3) {
                throw new DynamicException(this, "FONC0001 - fn:name() requires a well-defined context node");
            }
            String name = context.focus.getContextItem().getName();
            if (name == null) {
                return LiteralResult.EMPTY_STRING;
            }
            return new DrbDefaultSequence(new fr.gael.drb.value.String(name));
        }
        return this.nodeName(context);
    }

    private DrbSequence namespaceURI(DynamicContext context) {
        if (this.parameters.size() < 0 || this.parameters.size() > 1) {
            throw new DynamicException(this, "XP0017 - fn:namespace-uri() requires zero or one parameter");
        }
        DrbItem item = null;
        if (this.parameters.size() == 0) {
            item = context.focus.getContextItem();
        } else {
            DrbSequence sequence = this.parameters.get(0).evaluate(context);
            if (sequence == null) {
                throw new DynamicException(this, "fn:namespace-uri() : error while evaluating the parameter");
            }
            if (sequence.getLength() <= 0) {
                return LiteralResult.EMPTY_STRING;
            }
            item = sequence.getItem(0);
        }
        if (item == null || item.getItemType() == 3) {
            throw new DynamicException(this, "fn:namespace-uri() requires a well-defined input node");
        }
        String uri = item.getNamespaceURI();
        if (uri == null) {
            return LiteralResult.EMPTY_STRING;
        }
        return new DrbDefaultSequence(new fr.gael.drb.value.String(uri));
    }

    private DrbSequence atomicTypeConstructor(DynamicContext context) {
        Value output_value;
        if (this.defaultSchema == null) {
            this.defaultSchema = XmlSchema.getDefaultSchema();
        }
        XsdType[] default_types = this.defaultSchema.getGlobalTypes();
        int atomic_type_id = -2;
        for (int itype = 0; itype < default_types.length; ++itype) {
            XsdSimpleType simple_type = default_types[itype].getDatatype();
            if (simple_type == null || !simple_type.getName().equals(this.functionName.getLocalName())) continue;
            atomic_type_id = simple_type.getTypeId();
            break;
        }
        if (atomic_type_id == -2) {
            throw new DynamicException(this, "No constructor defined for \"" + this.functionName + "\"");
        }
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, "XP0017 - " + this.functionName + " requires one and only one parameter");
        }
        Expression parameter_expr = this.parameters.get(0);
        if (parameter_expr == null) {
            throw new DynamicException(this, "Parameter is null");
        }
        DrbSequence parameter_sequence = parameter_expr.evaluate(context);
        if (parameter_sequence == null) {
            throw new DynamicException(this, "Evaluation of parameter is null");
        }
        if ((parameter_sequence = parameter_sequence.atomize()).getLength() == 0) {
            return new DrbDefaultSequence();
        }
        if (parameter_sequence.getLength() > 1) {
            throw new DynamicException(this, "Parameter is not an atomic value");
        }
        Value parameter_value = (Value)parameter_sequence.getItem(0);
        if (parameter_value == null) {
            throw new DynamicException(this, "Cannot extract the value of the parameter");
        }
        try {
            output_value = parameter_value.convertTo(atomic_type_id);
            if (this.functionName.getLocalName().equals("token")) {
                output_value = new fr.gael.drb.value.String(output_value.toString());
            }
        }
        catch (Exception e) {
            throw new DynamicException(this, "Cannot convert parameter, evaluated as " + parameter_value + ", to " + this.functionName + " type");
        }
        return new DrbDefaultSequence(output_value);
    }

    private DrbSequence matches(DynamicContext context) {
        Expression pattern_string_expr;
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, "XP0017 - fn:matches() requires to parameters");
        }
        Expression source_string_expr = this.parameters.get(0);
        if (source_string_expr == null) {
            throw new DynamicException(this, "fn:matches() operation requires a source string as first parameter");
        }
        DrbSequence source_string_sequence = source_string_expr.evaluate(context);
        if (source_string_sequence == null) {
            throw new DynamicException(this, "fn:matches() : error while evaluating the first parameter");
        }
        if ((source_string_sequence = source_string_sequence.atomize()).getLength() > 1) {
            throw new DynamicException(this, "fn:matches() : first parameter is a sequence of " + source_string_sequence.getLength() + " item(s)");
        }
        Value source_string_value = null;
        if (source_string_sequence.getLength() == 1) {
            DrbItem source_item = source_string_sequence.getItem(0);
            source_string_value = source_item.getValue();
        }
        String source_string = "";
        if (source_string_value != null) {
            if (source_string_value.getType() != 7) {
                throw new TypeException(this, "fn:matches() : first parameter is not a xs:string");
            }
            source_string = source_string_value.toString();
        }
        if ((pattern_string_expr = this.parameters.get(1)) == null) {
            throw new DynamicException(this, "fn:matches() operation requires a source string as pattern parameter");
        }
        DrbSequence pattern_string_sequence = pattern_string_expr.evaluate(context);
        if (pattern_string_sequence == null) {
            throw new DynamicException(this, "fn:matches() : error while evaluating the pattern parameter");
        }
        if ((pattern_string_sequence = pattern_string_sequence.atomize()).getLength() != 1) {
            throw new DynamicException(this, "fn:matches() : 'pattern' parameter is a sequence of " + pattern_string_sequence.getLength() + " item(s)");
        }
        DrbItem pattern_item = pattern_string_sequence.getItem(0);
        Value pattern_string_value = pattern_item.getValue();
        if (pattern_string_value.getType() != 7) {
            throw new TypeException(this, "fn:matches() : pattern parameter is not an xs:string");
        }
        String pattern_string = pattern_string_value.toString();
        if (pattern_string == null) {
            pattern_string = "";
        }
        return new DrbDefaultSequence(new Boolean(source_string.matches(pattern_string)));
    }

    private DrbSequence tokenize(DynamicContext context) {
        Expression pattern_string_expr;
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, "XP0017 - fn:tokenize() requires two parameters");
        }
        Expression source_string_expr = this.parameters.get(0);
        if (source_string_expr == null) {
            throw new DynamicException(this, "fn:tokenize() operation requires a source string as first parameter");
        }
        DrbSequence source_string_sequence = source_string_expr.evaluate(context);
        if (source_string_sequence == null) {
            throw new DynamicException(this, "fn:tokenize() : error while evaluating the first parameter");
        }
        if (source_string_sequence.getLength() < 1) {
            return new DrbDefaultSequence();
        }
        if (source_string_sequence.getLength() > 1) {
            throw new DynamicException(this, "fn:tokenize() : first parameter is a sequence of " + source_string_sequence.getLength() + " items");
        }
        DrbItem source_item = source_string_sequence.getItem(0);
        Value source_string_value = source_item.getValue();
        if (source_string_value == null) {
            return new DrbDefaultSequence();
        }
        if (source_string_value.getType() != 7) {
            throw new TypeException(this, "fn:tokenize() : first parameter is not a xs:string");
        }
        String source_string = source_string_value.toString();
        if (source_string == null) {
            source_string = "";
        }
        if ((pattern_string_expr = this.parameters.get(1)) == null) {
            throw new DynamicException(this, "fn:tokenize() operation requires a source string as pattern parameter");
        }
        DrbSequence pattern_string_sequence = pattern_string_expr.evaluate(context);
        if (pattern_string_sequence == null) {
            throw new DynamicException(this, "fn:tokenize() : error while evaluating the pattern parameter");
        }
        DrbItem pattern_item = pattern_string_sequence.getItem(0);
        if (pattern_item.getItemType() != 3) {
            throw new DynamicException(this, "fn:tokenize() : pattern parameter is not an atomic value");
        }
        Value pattern_string_value = pattern_item.getValue();
        if (pattern_string_value.getType() != 7) {
            throw new TypeException(this, "fn:tokenize() : pattern parameter is not an xs:string");
        }
        String pattern_string = pattern_string_value.toString();
        if (pattern_string == null) {
            pattern_string = "";
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        StringTokenizer string_tokenizer = new StringTokenizer(source_string, pattern_string);
        while (string_tokenizer.hasMoreTokens()) {
            output_sequence.add(new fr.gael.drb.value.String(string_tokenizer.nextToken()));
        }
        return output_sequence;
    }

    private DrbSequence stringLength(DynamicContext context) {
        if (this.parameters.size() > 1) {
            throw new DynamicException(this, "XPDY0002 - fn:string-length() requires one parameter");
        }
        DrbSequence source_string_sequence = null;
        if (this.parameters.size() == 0) {
            DrbItem context_item = context.focus.getContextItem();
            if (context_item == null) {
                throw new DynamicException(this, "fn:string-length() with no argument requires a context item");
            }
            source_string_sequence = new DrbDefaultSequence(context_item);
        } else {
            Expression source_string_expr = this.parameters.get(0);
            if (source_string_expr == null) {
                throw new DynamicException(this, "fn:string-length() requires a string value as parameter");
            }
            source_string_sequence = source_string_expr.evaluate(context);
        }
        if (source_string_sequence == null) {
            throw new DynamicException(this, "fn:string-length() : error while evaluating the first parameter");
        }
        if (source_string_sequence.getLength() > 1) {
            throw new DynamicException(this, "fn:string-length() : first parameter is a sequence of " + source_string_sequence.getLength() + " items");
        }
        if (source_string_sequence.getLength() == 0) {
            return new DrbDefaultSequence(new Int(0));
        }
        DrbItem source_item = source_string_sequence.getItem(0);
        Value source_string_value = source_item.getValue();
        String source_string = "";
        if (source_string_value != null) {
            if (source_string_value.getType() != 7) {
                throw new TypeException(this, "fn:string-length() : first parameter is not a xs:string");
            }
            source_string = source_string_value.toString();
        }
        return new DrbDefaultSequence(new Int(source_string.length()));
    }

    private DrbSequence stringJoin(DynamicContext context) {
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, "XPST0017 - fn:string-join() requires two parameters");
        }
        DrbSequence source_string_sequence = null;
        Expression source_string_expr = this.parameters.get(0);
        if (source_string_expr == null) {
            throw new DynamicException(this, "fn:string-join() requires a string value as parameter");
        }
        source_string_sequence = source_string_expr.evaluate(context);
        if (source_string_sequence == null) {
            throw new DynamicException(this, "fn:string-join() : error while evaluating the first parameter");
        }
        source_string_sequence = source_string_sequence.atomize();
        Expression separator_expr = this.parameters.get(1);
        if (separator_expr == null) {
            throw new DynamicException(this, "fn:string-join() requires a string value as parameter");
        }
        DrbSequence separator_sequence = separator_expr.evaluate(context);
        if (separator_sequence == null || separator_sequence.getLength() != 1) {
            throw new DynamicException(this, "fn:string-join() : Unexpected error while evaluating separator.");
        }
        Value separator_value = separator_sequence.getItem(0).getValue();
        if (separator_value == null) {
            throw new DynamicException(this, "fn:string-join() : Invalid separator. The second argumentmust be a single string value");
        }
        String separator = separator_value.toString();
        if (separator.length() == 0) {
            separator = null;
        }
        if (source_string_sequence.getLength() == 0) {
            return new DrbDefaultSequence(new fr.gael.drb.value.String(""));
        }
        StringBuffer strbuf = new StringBuffer(source_string_sequence.getLength() * 10);
        for (int i = 0; i < source_string_sequence.getLength(); ++i) {
            Value source_value = source_string_sequence.getItem(i).getValue();
            if (source_value == null) {
                throw new DynamicException(this, "fn:string-join() : the item " + i + " has no string value");
            }
            String source_string = source_value.toString();
            if (separator != null && i != 0) {
                strbuf.append(separator);
            }
            strbuf.append(source_string);
        }
        return new DrbDefaultSequence(new fr.gael.drb.value.String(strbuf.toString()));
    }

    private DrbSequence deepInvalid(DynamicContext context) {
        XsdNode xsd_node;
        if (this.parameters.size() < 1) {
            throw new DynamicException(this, "XP0017 - drb:deep-invalid() requires at least one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence.getLength() != 1) {
            throw new DynamicException(this, "drb:deep-invalid() : the parameter matches several items");
        }
        DrbItem item = sequence.getItem(0);
        if (item.getItemType() != 1) {
            throw new DynamicException(this, "drb:deep-invalid() : the parameter is not a node");
        }
        DrbNode input_node = (DrbNode)item;
        if (this.parameters.size() >= 2) {
            while (input_node instanceof XsdNodeImpl) {
                input_node = ((XsdNodeImpl)input_node).getBase();
            }
            sequence = this.parameters.get(1).evaluate(context);
            if (sequence.getLength() != 1) {
                throw new DynamicException(this, "drb:deep-invalid() : the schema parameter matches several items");
            }
            item = sequence.getItem(0);
            if (item.getItemType() != 1) {
                throw new DynamicException(this, "drb:deep-invalid() : the schema is not a node");
            }
            DrbNode schema_root = ((DrbNode)item).getFirstChild();
            XsdFactory xsd_factory = new XsdFactory();
            XmlSchema xml_schema = xsd_factory.open(((DrbNode)item).getParent(), schema_root);
            if (xml_schema == null) {
                throw new DynamicException(this, "drb:deep-invalid() : unable to open the schema: \"" + xml_schema + "\"");
            }
            XsdElement root_element = xml_schema.getDefaultRootElement();
            if (root_element == null) {
                throw new DynamicException(this, "drb:deep-invalid() : the schema  \"" + xml_schema + "\" has no root element");
            }
            XsdType root_type = root_element.getType();
            xsd_node = XsdNodeImpl.getInstance(input_node, root_type);
        } else if (input_node instanceof XsdNode) {
            xsd_node = (XsdNode)input_node;
        } else {
            throw new DynamicException(this, "drb:deep-invalid() : unable to retreive a validating schema");
        }
        return this.getInvalidNodes(xsd_node);
    }

    private DrbSequence concat(DynamicContext context) {
        StringBuffer output_buf = new StringBuffer(this.parameters.size() * 10);
        for (int iparam = 0; iparam < this.parameters.size(); ++iparam) {
            Expression source_string_expr = this.parameters.get(iparam);
            if (source_string_expr == null) {
                throw new DynamicException(this, this.functionName + "() : cannot extract expression of parameter #" + (iparam + 1));
            }
            DrbSequence source_string_sequence = source_string_expr.evaluate(context);
            if (source_string_sequence != null) {
                source_string_sequence = source_string_sequence.atomize();
            }
            if (source_string_sequence == null) {
                throw new DynamicException(this, this.functionName + "() : error while evaluating the expression of parameter #" + (iparam + 1));
            }
            if (source_string_sequence.getLength() == 0) continue;
            if (source_string_sequence.getLength() != 1 || source_string_sequence.getItem(0) == null) {
                throw new DynamicException(this, this.functionName + "() : the evaluation of parameter #" + (iparam + 1) + " does not result to a single value");
            }
            Value source_string_value = (Value)source_string_sequence.getItem(0);
            String source_string = source_string_value.toString();
            if (source_string == null) {
                throw new DynamicException(this, this.functionName + "() : cannot extract string from parameter #" + (iparam + 1));
            }
            output_buf.append(source_string);
        }
        return new DrbDefaultSequence(new fr.gael.drb.value.String(output_buf.toString()));
    }

    private DrbNodeList getInvalidNodes(XsdNode node) {
        DrbDefaultNodeList invalid_nodes = new DrbDefaultNodeList();
        if (node.isValid() != null) {
            invalid_nodes.add(node);
        }
        for (XsdNode child = (XsdNode)node.getFirstChild(); child != null; child = (XsdNode)child.getNextSibling()) {
            DrbNodeList invalid_child_nodes = this.getInvalidNodes(child);
            for (int ichild = 0; ichild < invalid_child_nodes.getLength(); ++ichild) {
                invalid_nodes.add(invalid_child_nodes.item(ichild));
            }
        }
        return invalid_nodes;
    }

    private DrbSequence mathFunction(DynamicContext context, int function_type) {
        DrbSequence sequence = null;
        Value value = null;
        Numeric first_value = null;
        Numeric second_value = null;
        int parameter_number = 0;
        double first_param = 0.0;
        double second_param = 0.0;
        if (this.parameters.size() > 0) {
            sequence = this.parameters.get(0).evaluate(context);
            if (sequence != null) {
                sequence = sequence.atomize();
            }
            if (sequence == null || sequence.getLength() > 1) {
                throw new DynamicException(this, "Error while evaluating the first parameter of the math function " + this.functionName);
            }
            if (sequence.getLength() < 1) {
                return new DrbDefaultSequence();
            }
            value = sequence.getItem(0).getValue();
            if (!(value instanceof Numeric)) {
                throw new DynamicException(this, "The first parameter of the math function " + this.functionName + " is not a numerical value");
            }
            first_value = (Numeric)value;
            first_param = first_value.doubleValue();
            ++parameter_number;
        }
        if (this.parameters.size() > 1) {
            sequence = this.parameters.get(1).evaluate(context);
            if (sequence != null) {
                sequence = sequence.atomize();
            }
            if (sequence == null || sequence.getLength() <= 0) {
                throw new DynamicException(this, "Error while evaluating the second parameter of the math function " + this.functionName);
            }
            value = sequence.getItem(0).getValue();
            if (!(value instanceof Numeric)) {
                throw new DynamicException(this, "The second parameter of the math function " + this.functionName + " is not a numerical value");
            }
            second_value = (Numeric)value;
            second_param = second_value.doubleValue();
            ++parameter_number;
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        switch (function_type) {
            case 1: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.abs(first_param)));
                return output_sequence;
            }
            case 2: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.sqrt(first_param)));
                return output_sequence;
            }
            case 3: {
                if (parameter_number != 2) {
                    throw new DynamicException(this, this.functionName + ": requires two parameter");
                }
                output_sequence.add(new Double(Math.pow(first_param, second_param)));
                return output_sequence;
            }
            case 4: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.log(first_param)));
                return output_sequence;
            }
            case 5: {
                if (parameter_number != 0) {
                    throw new DynamicException(this, this.functionName + ": has no parameter");
                }
                output_sequence.add(new Double(Math.random()));
                return output_sequence;
            }
            case 6: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.sin(first_param)));
                return output_sequence;
            }
            case 7: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.cos(first_param)));
                return output_sequence;
            }
            case 8: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.tan(first_param)));
                return output_sequence;
            }
            case 9: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.asin(first_param)));
                return output_sequence;
            }
            case 10: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.acos(first_param)));
                return output_sequence;
            }
            case 11: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.atan(first_param)));
                return output_sequence;
            }
            case 12: {
                if (parameter_number != 2) {
                    throw new DynamicException(this, this.functionName + ": requires two parameters");
                }
                output_sequence.add(new Double(Math.atan2(first_param, second_param)));
                return output_sequence;
            }
            case 13: {
                if (parameter_number != 1) {
                    throw new DynamicException(this, this.functionName + ": requires one parameter");
                }
                output_sequence.add(new Double(Math.exp(first_param)));
                return output_sequence;
            }
        }
        throw new DynamicException(this, this.functionName + ": not supported");
    }

    private DrbSequence currentDateTime(DynamicContext context) {
        if (this.parameters.size() != 0) {
            throw new DynamicException(this, this.functionName + "() has no parameter");
        }
        return new DrbDefaultSequence(context.currentDateTime);
    }

    private DrbSequence min(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "()");
        }
        if (sequence.getLength() < 1) {
            return new DrbDefaultSequence();
        }
        Value min_value = (Value)sequence.getItem(0);
        if (min_value == null) {
            throw new DynamicException(this, "Error while extracting first value in " + this.functionName + "() function.");
        }
        if (min_value.getType() == 10) {
            if (((ValueArray)(min_value = ((ValueArray)min_value).getElement(0))).length() > 0) {
                min_value = ((ValueArray)min_value).getElement(0);
            } else {
                throw new DynamicException(this, "Error while extracting first array alenemnt in " + this.functionName + "() function.");
            }
        }
        for (int ivalue = 0; ivalue < sequence.getLength(); ++ivalue) {
            Value element = (Value)sequence.getItem(ivalue);
            if (element == null) {
                throw new DynamicException(this, "Error while processing element #" + (ivalue + 1) + " of " + this.functionName + "()");
            }
            try {
                if (element.getType() == 10) {
                    for (int iitem = 0; iitem < ((ValueArray)element).length(); ++iitem) {
                        Value array_item = ((ValueArray)element).getElement(iitem);
                        if (array_item == null) {
                            throw new DynamicException(this, "Error while processing array element #" + (iitem + 1) + " of " + this.functionName + "()");
                        }
                        if (((Comparison)((Object)array_item)).compareTo(min_value) >= 0) continue;
                        min_value = array_item;
                    }
                    continue;
                }
                if (((Comparison)((Object)element)).compareTo(min_value) >= 0) continue;
                min_value = element;
                continue;
            }
            catch (ClassCastException e) {
                throw new DynamicException(this, "Error while casting an element of the parameter sequence of " + this.functionName + "()");
            }
        }
        return new DrbDefaultSequence(min_value);
    }

    private DrbSequence max(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "()");
        }
        if (sequence.getLength() < 1) {
            return new DrbDefaultSequence();
        }
        Value max_value = (Value)sequence.getItem(0);
        if (max_value == null) {
            throw new DynamicException(this, "Error while extracting first value in " + this.functionName + "() function.");
        }
        if (max_value.getType() == 10) {
            if (((ValueArray)max_value).length() > 0) {
                max_value = ((ValueArray)max_value).getElement(0);
            } else {
                throw new DynamicException(this, "Error while extracting first array alenemnt in " + this.functionName + "() function.");
            }
        }
        for (int ivalue = 0; ivalue < sequence.getLength(); ++ivalue) {
            Value element = (Value)sequence.getItem(ivalue);
            if (element == null) {
                throw new DynamicException(this, "Error while processing element #" + (ivalue + 1) + " of " + this.functionName + "()");
            }
            try {
                if (element.getType() == 10) {
                    for (int iitem = 0; iitem < ((ValueArray)element).length(); ++iitem) {
                        Value array_item = ((ValueArray)element).getElement(iitem);
                        if (array_item == null) {
                            throw new DynamicException(this, "Error while processing array element #" + (iitem + 1) + " of " + this.functionName + "()");
                        }
                        if (((Comparison)((Object)array_item)).compareTo(max_value) <= 0) continue;
                        max_value = array_item;
                    }
                    continue;
                }
                if (((Comparison)((Object)element)).compareTo(max_value) <= 0) continue;
                max_value = element;
                continue;
            }
            catch (ClassCastException e) {
                throw new DynamicException(this, "Error while casting an element of the parameter sequence of " + this.functionName + "()");
            }
        }
        return new DrbDefaultSequence(max_value);
    }

    private DrbSequence avg(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "()");
        }
        int count = 0;
        Arithmetic avg = null;
        for (int ivalue = 0; ivalue < sequence.getLength(); ++ivalue) {
            Value element = (Value)sequence.getItem(ivalue);
            if (element == null) {
                throw new DynamicException(this, "Error while processing element #" + (ivalue + 1) + " of " + this.functionName + "()");
            }
            int type = element.getType();
            try {
                if (element.getType() == 10) {
                    for (int iitem = 0; iitem < ((ValueArray)element).length(); ++iitem) {
                        Value array_item = ((ValueArray)element).getElement(iitem);
                        if (array_item == null) {
                            throw new DynamicException(this, "Error while processing array element #" + (iitem + 1) + " of " + this.functionName + "()");
                        }
                        avg = avg == null ? (Arithmetic)((Object)array_item) : (Arithmetic)((Object)avg.add(array_item));
                        ++count;
                    }
                    continue;
                }
                if (type >= 1 && type <= 4) {
                    element = element.convertTo(6);
                }
                avg = avg == null ? (Arithmetic)((Object)element) : (Arithmetic)((Object)avg.add(element));
                ++count;
                continue;
            }
            catch (ClassCastException e) {
                throw new DynamicException(this, "Error while casting an element of the parameter sequence of " + this.functionName + "()");
            }
        }
        if (avg != null && count > 0) {
            return new DrbDefaultSequence(avg.divide(new Int(count)));
        }
        return new DrbDefaultSequence();
    }

    private DrbSequence sum(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "()");
        }
        int count = 0;
        Arithmetic sum = new Integer(0);
        for (int ivalue = 0; ivalue < sequence.getLength(); ++ivalue) {
            Value element = (Value)sequence.getItem(ivalue);
            if (element == null) {
                throw new DynamicException(this, "Error while processing element #" + (ivalue + 1) + " of " + this.functionName + "()");
            }
            if (element instanceof fr.gael.drb.value.String) {
                element = element.convertTo(6);
            }
            try {
                int type = element.getType();
                if (type == 10) {
                    for (int iitem = 0; iitem < ((ValueArray)element).length(); ++iitem) {
                        Value array_item = ((ValueArray)element).getElement(iitem);
                        if (array_item == null) {
                            throw new DynamicException(this, "Error while processing array element #" + (iitem + 1) + " of " + this.functionName + "()");
                        }
                        sum = count == 0 ? (Arithmetic)((Object)array_item) : (Arithmetic)((Object)sum.add(array_item));
                        ++count;
                    }
                    continue;
                }
                if (count == 0) {
                    sum = (Arithmetic)((Object)element);
                } else {
                    if (type >= 1 && type < 4) {
                        element = element.convertTo(4);
                    }
                    sum = (Arithmetic)((Object)sum.add(element));
                }
                ++count;
                continue;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                throw new DynamicException(this, "Error while casting an element of the parameter sequence of " + this.functionName + "()");
            }
        }
        return new DrbDefaultSequence((DrbItem)((Object)sum));
    }

    private DrbSequence ceiling(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one parameter");
        }
        DrbSequence sequence = null;
        Value value = null;
        Numeric num = null;
        sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() > 1) {
            throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "() function");
        }
        if (sequence.getLength() < 1) {
            return new DrbDefaultSequence();
        }
        value = sequence.getItem(0).getValue();
        if (!(value instanceof Numeric)) {
            throw new DynamicException(this, "The parameter of " + this.functionName + "() is not a numerical value");
        }
        num = (Numeric)value;
        Value ceil = null;
        switch (num.getType()) {
            case 5: {
                ceil = new fr.gael.drb.value.Float((float)Math.ceil(num.doubleValue()));
                break;
            }
            case 6: {
                ceil = new Double(Math.ceil(num.doubleValue()));
                break;
            }
            case 26: {
                ceil = new Decimal(Math.ceil(num.doubleValue()));
                break;
            }
            default: {
                ceil = value.convertTo(27);
            }
        }
        return new DrbDefaultSequence(ceil);
    }

    private DrbSequence floor(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one parameter");
        }
        DrbSequence sequence = null;
        Value value = null;
        Numeric num = null;
        sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() > 1) {
            throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "() function");
        }
        if (sequence.getLength() < 1) {
            return new DrbDefaultSequence();
        }
        value = sequence.getItem(0).getValue();
        if (!(value instanceof Numeric)) {
            throw new DynamicException(this, "The parameter of " + this.functionName + "() is not a numerical value");
        }
        num = (Numeric)value;
        Value floor = null;
        switch (num.getType()) {
            case 5: {
                floor = new fr.gael.drb.value.Float((float)Math.floor(num.doubleValue()));
                break;
            }
            case 6: {
                floor = new Double(Math.floor(num.doubleValue()));
                break;
            }
            case 26: {
                floor = new Decimal(Math.floor(num.doubleValue()));
                break;
            }
            default: {
                floor = value.convertTo(27);
            }
        }
        return new DrbDefaultSequence(floor);
    }

    private DrbSequence round(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one parameter");
        }
        DrbSequence sequence = null;
        Value value = null;
        Numeric num = null;
        sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() > 1) {
            throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "() function");
        }
        if (sequence.getLength() < 1) {
            return new DrbDefaultSequence();
        }
        value = sequence.getItem(0).getValue();
        if (!(value instanceof Numeric)) {
            throw new DynamicException(this, "The parameter of " + this.functionName + "() is not a numerical value");
        }
        num = (Numeric)value;
        Value round = null;
        switch (num.getType()) {
            case 5: {
                round = new fr.gael.drb.value.Float(Math.round(num.doubleValue()));
                break;
            }
            case 6: {
                round = new Double(Math.round(num.doubleValue()));
                break;
            }
            case 26: {
                round = new Decimal(Math.round(num.doubleValue()));
                break;
            }
            default: {
                round = value.convertTo(27);
            }
        }
        return new DrbDefaultSequence(round);
    }

    private DrbSequence utcToMjd(DynamicContext context) {
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, this.functionName + "() requires two parameters");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() > 1) {
            throw new DynamicException(this, "Error while evaluating the UTC date parameter of " + this.functionName + "()");
        }
        if (sequence.getLength() == 0) {
            return new DrbDefaultSequence();
        }
        DrbItem item = sequence.getItem(0);
        if (!(item instanceof DateTime)) {
            throw new DynamicException(this, "The first parameter of the function " + this.functionName + "() is not a time value");
        }
        DateTime utc = (DateTime)item;
        sequence = this.parameters.get(1).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() != 1) {
            throw new DynamicException(this, "Error while evaluating the DUT1 parameter of " + this.functionName + "()");
        }
        item = sequence.getItem(0);
        if (!(item instanceof Numeric)) {
            throw new DynamicException(this, "The first parameter of the math function " + this.functionName + " is not a numerical value");
        }
        double dut1 = ((Numeric)item).doubleValue();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Timestamp(utc.getTime()));
        double year = calendar.get(1);
        double month = calendar.get(2);
        double mday = calendar.get(5);
        double hours = calendar.get(11);
        double minutes = calendar.get(12);
        double seconds = calendar.get(13);
        double mseconds = (double)calendar.get(14) + dut1 * 1000.0;
        double nseconds = (double)utc.getNanos() + dut1 * 1.0E9;
        double day = calendar.get(6);
        day += ((hours * 3600.0 + minutes * 60.0 + seconds) * 1000.0 + mseconds + (nseconds - 1000000.0 * mseconds) * 0.001) / 8.64E7;
        hours = hours + minutes / 60.0 + seconds / 3600.0 + mseconds / 3600000.0 + nseconds / 3.6E12;
        double GGG = 1.0;
        if (year < 1582.0) {
            GGG = 0.0;
        }
        if (year <= 1582.0 && month < 10.0) {
            GGG = 0.0;
        }
        if (year <= 1582.0 && month == 10.0 && mday < 5.0) {
            GGG = 0.0;
        }
        double JD = -1.0 * Math.floor(7.0 * (Math.floor((month + 9.0) / 12.0) + year) / 4.0);
        double S = 1.0;
        if (month - 9.0 < 0.0) {
            S = -1.0;
        }
        double A = Math.abs(month - 9.0);
        double J1 = Math.floor(year + S * Math.floor(A / 7.0));
        J1 = -1.0 * Math.floor((Math.floor(J1 / 100.0) + 1.0) * 3.0 / 4.0);
        JD = JD + Math.floor(275.0 * month / 9.0) + mday + GGG * J1;
        JD = JD + 1721027.0 + 2.0 * GGG + 367.0 * year - 0.5;
        double jd = JD += hours / 24.0;
        return new DrbDefaultSequence(new Double(jd));
    }

    private DrbSequence importDoc(DynamicContext context) {
        Expression format_string_expr;
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, "XP0017 - drb:import-doc() requires two parameters");
        }
        Expression source_string_expr = this.parameters.get(0);
        if (source_string_expr == null) {
            throw new DynamicException(this, "drb:import-doc() operation requires a source string as first parameter");
        }
        DrbSequence source_string_sequence = source_string_expr.evaluate(context);
        if (source_string_sequence == null) {
            throw new DynamicException(this, "drb:import-doc() : error while evaluating the first parameter");
        }
        if (source_string_sequence.getLength() != 1) {
            throw new DynamicException(this, "drb:import-doc() : first parameter is a sequence of " + source_string_sequence.getLength() + " item(s)");
        }
        DrbItem source_item = source_string_sequence.getItem(0);
        if (source_item.getItemType() != 3) {
            throw new DynamicException(this, "drb:import-doc() : first parameter is not an atomic value");
        }
        Value source_string_value = source_item.getValue();
        if (source_string_value == null) {
            return new DrbDefaultSequence();
        }
        if (source_string_value.getType() != 7) {
            throw new TypeException(this, "drb:import-doc() : first parameter is not a xs:string");
        }
        String source_string = source_string_value.toString();
        if (source_string == null) {
            source_string = "";
        }
        if ((format_string_expr = this.parameters.get(1)) == null) {
            throw new DynamicException(this, "drb:import-doc() operation requires an input format as parameter");
        }
        DrbSequence format_string_sequence = format_string_expr.evaluate(context);
        if (format_string_sequence == null) {
            throw new DynamicException(this, "drb:import-doc() : error while evaluating the format parameter");
        }
        DrbItem format_item = format_string_sequence.getItem(0);
        Value format_string_value = format_item.getValue();
        if (format_string_value == null) {
            throw new DynamicException(this, "drb:import-doc() : format parameter has no value");
        }
        if (format_string_value.getType() != 7) {
            throw new TypeException(this, "drb:import-doc() : format parameter is not an xs:string");
        }
        String format_string = format_string_value.toString();
        if (format_string == null) {
            format_string = "";
        }
        return new DrbDefaultSequence(DrbFactory.openAs(source_string, format_string));
    }

    private DrbSequence doc(DynamicContext context) {
        DrbNode node;
        fr.gael.drb.value.String value;
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence != null && sequence.getLength() == 0) {
            return new DrbDefaultSequence();
        }
        if (sequence == null || sequence.getLength() != 1 || sequence.getItem(0) == null) {
            throw new DynamicException(this, "Error while evaluating the URL parameter of " + this.functionName + "()");
        }
        fr.gael.drb.value.String uri = value = (fr.gael.drb.value.String)((Value)sequence.getItem(0)).convertTo(7);
        String input_uri = value.toString();
        if (context.getBaseURI() != null) {
            try {
                URI local = new URI(context.getBaseURI());
                input_uri = local.resolve(input_uri).toString();
            }
            catch (Exception exception) {
                throw new DynamicException(this, "FODC0005: Invalid URI reference \"" + input_uri + "\"");
            }
        }
        if ((node = DrbFactory.openURI(input_uri)) != null) {
            return new DrbDefaultSequence(node);
        }
        throw new DynamicException(this, "FODC0005: No mapping for the URI reference \"" + uri + "\"");
    }

    private DrbSequence xmlDoc(DynamicContext context) {
        fr.gael.drb.value.String value;
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence != null && sequence.getLength() == 0) {
            return new DrbDefaultSequence();
        }
        if (sequence == null || sequence.getLength() != 1 || sequence.getItem(0) == null) {
            throw new DynamicException(this, "Error while evaluating the URL parameter of " + this.functionName + "()");
        }
        fr.gael.drb.value.String uri = value = (fr.gael.drb.value.String)((Value)sequence.getItem(0)).convertTo(7);
        String input_uri = value.toString();
        if (context.getBaseURI() != null) {
            try {
                URI local = new URI(context.getBaseURI());
                input_uri = local.resolve(input_uri).toString();
            }
            catch (Exception exception) {
                throw new DynamicException(this, "FODC0005: Invalid URI reference \"" + input_uri + "\" Base URI = \"" + context.getBaseURI() + "\"");
            }
        }
        DrbNode node = DrbFactory.openURI(input_uri);
        if ((node = new XmlFactory().open(node)) != null) {
            node = node.getParent();
        }
        if (node != null) {
            return new DrbDefaultSequence(node);
        }
        throw new DynamicException(this, "FODC0005: No mapping for the URI reference \"" + uri + "\"");
    }

    private DrbSequence evaluateURI(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() != 1 || sequence.getItem(0) == null) {
            throw new DynamicException(this, "Error while evaluating the URI parameter of " + this.functionName + "()");
        }
        fr.gael.drb.value.String value = (fr.gael.drb.value.String)((Value)sequence.getItem(0)).convertTo(7);
        URL url = null;
        try {
            URL context_url = new URL(new URL("file:"), ((DrbNode)context.focus.getContextItem()).getPath() + "/");
            url = new URL(context_url, value.toString());
        }
        catch (MalformedURLException exception) {
            throw new DynamicException(this, this.functionName + "(): cannot convert parameter to a valid URL");
        }
        InputStream stream = null;
        Query query = null;
        DrbSequence output_sequence = new DrbDefaultSequence();
        try {
            stream = url.openStream();
            query = new Query(stream, (StaticContext)context);
            output_sequence = query.evaluate(context.focus.getContextItem());
        }
        catch (Exception exception) {
            throw new DynamicException(this, this.functionName + "(): " + exception);
        }
        return output_sequence;
    }

    private DrbSequence evaluateString(DynamicContext context) {
        if (this.parameters.size() != 1) {
            throw new DynamicException(this, this.functionName + "() requires one and only one parameter");
        }
        DrbSequence sequence = this.parameters.get(0).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() != 1 || sequence.getItem(0) == null) {
            throw new DynamicException(this, "Error while evaluating the URI parameter of " + this.functionName + "()");
        }
        fr.gael.drb.value.String value = (fr.gael.drb.value.String)((Value)sequence.getItem(0)).convertTo(7);
        Query query = null;
        DrbSequence output_sequence = new DrbDefaultSequence();
        try {
            query = new Query(value.toString(), (StaticContext)context);
            output_sequence = query.evaluate(context.focus.getContextItem());
        }
        catch (Exception exception) {
            throw new DynamicException(this, this.functionName + "(): " + exception);
        }
        return output_sequence;
    }

    private DrbSequence error(DynamicContext context) {
        String message = "";
        if (this.parameters.size() > 0) {
            DrbSequence sequence = this.parameters.get(0).evaluate(context);
            if (sequence != null) {
                sequence = sequence.atomize();
            }
            if (sequence == null || sequence.getLength() != 1 || sequence.getItem(0) == null) {
                throw new DynamicException(this, "Error while evaluating the parameter of " + this.functionName + "()");
            }
            fr.gael.drb.value.String value = (fr.gael.drb.value.String)((Value)sequence.getItem(0)).convertTo(7);
            message = value.toString();
        }
        throw new DynamicException(this, message);
    }

    private DrbSequence trace(DynamicContext context) {
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, this.functionName + "(): expects to and only two parameters");
        }
        DrbSequence sequence = this.parameters.get(1).evaluate(context);
        if (sequence != null) {
            sequence = sequence.atomize();
        }
        if (sequence == null || sequence.getLength() != 1 || sequence.getItem(0) == null) {
            throw new DynamicException(this, "Error while evaluating the label parameter of " + this.functionName + "()");
        }
        fr.gael.drb.value.String value = (fr.gael.drb.value.String)((Value)sequence.getItem(0)).convertTo(7);
        this.logger.debug(value.toString());
        return this.parameters.get(0).evaluate(context);
    }

    private DrbSequence insertInto(DynamicContext context) {
        if (this.parameters.size() != 2) {
            throw new DynamicException(this, "XP0017 - drb:insertInto() requires two parameters");
        }
        Expression target_expr = this.parameters.get(0);
        if (target_expr == null) {
            throw new DynamicException(this, "drb:insertInto() operation requires a target node as first parameter");
        }
        DrbSequence target_sequence = target_expr.evaluate(context);
        if (target_sequence == null) {
            throw new DynamicException(this, "drb:insertInto() : error while evaluating the first parameter");
        }
        if (target_sequence.getLength() != 1) {
            throw new DynamicException(this, "drb:insertInto() : first parameter must be a single element node or a single document node. Found a sequence of " + target_sequence.getLength() + " item(s)");
        }
        DrbItem target_item = target_sequence.getItem(0);
        if (target_item.getItemType() != 1) {
            throw new DynamicException(this, "drb:insertInto() : first parameter is not a single element node or a single document node");
        }
        DrbNode target_node = (DrbNode)target_item;
        Expression content_expr = this.parameters.get(1);
        if (content_expr == null) {
            throw new DynamicException(this, "drb:insertInto() operation requires a content parameter");
        }
        DrbSequence content_sequence = content_expr.evaluate(context);
        if (content_sequence == null) {
            throw new DynamicException(this, "drb:insertInto() : error while evaluating the content parameter");
        }
        for (int ichild = 0; ichild < content_sequence.getLength(); ++ichild) {
            DrbItem content_item = content_sequence.getItem(ichild);
            if (!(content_item instanceof DrbNode)) continue;
            target_node.appendChild((DrbNode)content_item);
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        return output_sequence;
    }

    private DrbSequence path(DynamicContext context) {
        Expression target_expr = this.parameters.get(0);
        if (target_expr == null) {
            throw new DynamicException(this, "drb:path() operation requires a node as first parameter.");
        }
        DrbSequence target_sequence = target_expr.evaluate(context);
        if (target_sequence == null) {
            throw new DynamicException(this, "drb:path() : error while evaluating the first parameter");
        }
        if (target_sequence.getLength() != 1) {
            throw new DynamicException(this, "drb:path() : first parameter must be a single element node or a single document node. Found a sequence of " + target_sequence.getLength() + " item(s)");
        }
        DrbItem element = target_sequence.getItem(0);
        if (element.getItemType() != 1) {
            throw new DynamicException(this, "drb:path() : first parameter is not a single element node or a single document node");
        }
        fr.gael.drb.value.String path = new fr.gael.drb.value.String(((DrbNode)element).getPath());
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        output_sequence.addItem(path);
        return output_sequence;
    }

    private DrbSequence iso8601DateFormatter(DynamicContext context) {
        String date;
        if (this.parameters.size() != 2 && this.parameters.size() != 3) {
            throw new DynamicException(this, this.functionName + "(date, input_format, output_format) requires two parameter");
        }
        Expression iso_date_exp = this.parameters.get(0);
        if (iso_date_exp == null) {
            throw new DynamicException(this, this.functionName + "() operation requires a string as first parameter.");
        }
        DrbSequence iso_date_sequence = iso_date_exp.evaluate(context);
        if (iso_date_sequence == null) {
            throw new DynamicException(this, this.functionName + "() : error while evaluating the first parameter");
        }
        if (iso_date_sequence.getLength() != 1) {
            throw new DynamicException(this, this.functionName + "() : first parameter must be a single element string Found a sequence of " + iso_date_sequence.getLength() + " item(s)");
        }
        DrbItem iso_date_item = iso_date_sequence.getItem(0);
        if (iso_date_item.getItemType() != 3) {
            throw new DynamicException(this, this.functionName + "() : first parameter is not a single element node or a single document node");
        }
        String iso_date = iso_date_item.toString();
        Expression input_format_exp = this.parameters.get(1);
        if (input_format_exp == null) {
            throw new DynamicException(this, this.functionName + "() operation requires a string as second parameter.");
        }
        DrbSequence input_format_sequence = input_format_exp.evaluate(context);
        if (input_format_sequence == null) {
            throw new DynamicException(this, this.functionName + "() : error while evaluating the second parameter");
        }
        if (input_format_sequence.getLength() != 1) {
            throw new DynamicException(this, this.functionName + "() : second parameter must be a single element string Found a sequence of " + input_format_sequence.getLength() + " item(s)");
        }
        DrbItem input_format_item = input_format_sequence.getItem(0);
        if (input_format_item.getItemType() != 3) {
            throw new DynamicException(this, this.functionName + "() : second parameter is not a single element node or a single document node");
        }
        String input_format = input_format_item.toString();
        String output_format = null;
        if (this.parameters.size() > 2) {
            Expression output_format_exp = this.parameters.get(2);
            DrbSequence output_format_sequence = output_format_exp.evaluate(context);
            if (output_format_sequence == null) {
                throw new DynamicException(this, this.functionName + "() : error while evaluating the third parameter");
            }
            if (output_format_sequence.getLength() != 1) {
                throw new DynamicException(this, this.functionName + "() : third parameter must be a single element string Found a sequence of " + output_format_sequence.getLength() + " item(s)");
            }
            DrbItem output_format_item = output_format_sequence.getItem(0);
            if (output_format_item.getItemType() != 3) {
                throw new DynamicException(this, this.functionName + "() : second parameter is not a single element node or a single document node");
            }
            output_format = output_format_item.toString();
        } else {
            output_format = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        SimpleDateFormat odf = new SimpleDateFormat(output_format);
        try {
            long time = this.toMilliseconds(this.checkMonth(iso_date), input_format);
            date = odf.format(new Date(time));
        }
        catch (ParseException e) {
            throw new DynamicException(this, this.functionName + "() : " + e.getMessage());
        }
        DrbDefaultSequence output_sequence = new DrbDefaultSequence();
        output_sequence.addItem(new fr.gael.drb.value.String(date));
        return output_sequence;
    }

    private String checkMonth(String date) {
        String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        String[] iso_months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        String modified_date = date;
        for (int index = 0; index < months.length; ++index) {
            int pos = date.indexOf(months[index]);
            if (pos == -1) continue;
            modified_date = date.substring(0, pos) + iso_months[index] + date.substring(pos + months[index].length());
            break;
        }
        return modified_date;
    }

    private long toMilliseconds(String date, String format) throws ParseException {
        long time;
        if (!format.matches(".*\\.S{4,}('Z')?")) {
            SimpleDateFormat df = new SimpleDateFormat(format, Locale.US);
            long time2 = df.parse(date).getTime();
            return time2;
        }
        String micro = "0000";
        if (date.contains(".")) {
            micro = date.replaceAll(".*\\.(\\d*)Z?", "$1");
        }
        String modified_date = date.replaceAll("(.*)(\\.\\d*)?Z?", "$1");
        String modified_format = format.replaceAll("(.*)\\.S+('Z')?", "$1");
        if (modified_date == null || modified_format == null || "".equals(modified_date) || "".equals(modified_format)) {
            throw new ParseException(this.functionName + "() : Cannot parse date \"" + date + "\" with format \"" + format + "\"", 0);
        }
        long milli = 0L;
        if (!"".equals(micro)) {
            if (micro.length() > 6) {
                micro = micro.substring(0, 5);
            }
            milli = (long)(Float.parseFloat("0." + micro) * 1000.0f);
        }
        SimpleDateFormat df = new SimpleDateFormat(modified_format, Locale.US);
        try {
            time = df.parse(modified_date).getTime() + milli;
        }
        catch (ParseException e) {
            throw new ParseException(this.functionName + "() : Cannot parse date \"" + modified_date + "\" with format \"" + modified_format + "\" at " + e.getErrorOffset(), e.getErrorOffset());
        }
        return time;
    }

    public String toString() {
        String output = this.functionName + "(";
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i != 0) {
                output = output + ", ";
            }
            output = output + this.parameters.get(i);
        }
        output = output + ")";
        return output;
    }
}

