/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.TokenElement;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.log4j.Logger;

public class GrammarContext
extends StyleContext {
    private Logger logger = Logger.getLogger(GrammarContext.class);
    private TokenElement[] tokens = null;
    private Hashtable hashTokens = null;
    public Color commentColor = new Color(0, 115, 0);
    public Font defaultFont = new Font("Monospaced", 0, 14);

    public GrammarContext() {
        this.initialize();
    }

    public void setDefaultFontSize(float font_size) {
        this.defaultFont = this.defaultFont.deriveFont(font_size);
        Style root = this.getStyle("default");
        for (TokenElement current_token : this.tokens) {
            Style parent = this.getStyle(current_token.getCategory());
            if (parent == null) {
                parent = this.addStyle(current_token.getCategory(), root);
            }
            Style current_style = this.addStyle(null, parent);
            current_token.setFont(current_token.getFont().deriveFont(font_size));
            current_style.addAttribute(TokenElement.TOKEN_ATTRIBUTE, current_token);
            current_token.setStyle(current_style);
            StyleConstants.setFontFamily(current_style, current_token.getFont().getFamily());
            StyleConstants.setFontSize(current_style, current_token.getFont().getSize());
            StyleConstants.setBold(current_style, current_token.getFont().isBold());
            StyleConstants.setItalic(current_style, current_token.getFont().isItalic());
            StyleConstants.setForeground(current_style, current_token.getColor());
        }
        this.rehash();
    }

    private void initialize() {
        Color darkBlue = new Color(0, 0, 139);
        Color darkGreen = new Color(0, 115, 0);
        Color darkRed = new Color(139, 0, 0);
        this.tokens = new TokenElement[]{new TokenElement("\"xquery\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"version\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"module\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"declare\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"namespace\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"default\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"element\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"function\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"collation\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"xmlspace\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"preserve\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"strip\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"base-uri\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"variable\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"external\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"as\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"union\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"except\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"intersect\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"or\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"and\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"div\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"mod\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"in\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"return\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"then\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"else\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"to\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"where\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"for\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"let\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"if\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"at\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("\"@\"", this.defaultFont.deriveFont(1), darkBlue), new TokenElement("<StringLiteral>", Color.blue), new TokenElement("<AposAttContentChar>", Color.blue), new TokenElement("<QuotAttContentChar>", Color.blue), new TokenElement("<ElementContentChar>", Color.blue), new TokenElement("<Digits>", Color.blue), new TokenElement("<Digit>", Color.blue), new TokenElement("<IntegerLiteral>", Color.blue), new TokenElement("\"e\"", Color.blue), new TokenElement("\"E\"", Color.blue), new TokenElement("\":)\"", darkGreen), new TokenElement("\"(:\"", darkGreen), new TokenElement("\":)\"", darkGreen), new TokenElement("\"--}\"", darkGreen), new TokenElement("\"{--\"", darkGreen), new TokenElement("\"--}\"", darkGreen), new TokenElement("<Variable>", darkRed), new TokenElement("<EndTag>", darkRed), new TokenElement("<StartTagOpen>", darkRed), new TokenElement("\"/>\"", darkRed), new TokenElement("\">\"", darkRed), new TokenElement("\"<\"", darkRed), new TokenElement("<NCName>", darkRed), new TokenElement("<NCNameChar>", darkRed), new TokenElement("<Nmstart>", darkRed), new TokenElement("<URIPrefix>", darkRed), new TokenElement("<QName>", Color.black), new TokenElement("\"?\"", Color.black), new TokenElement("\"|\"", Color.black), new TokenElement("\"}\"", Color.black), new TokenElement("\"\\\"\"", Color.black), new TokenElement("\"\\'\"", Color.black), new TokenElement("\"=\"", Color.black), new TokenElement("\"\\\"\"", Color.black), new TokenElement("\"\\'\"", Color.black), new TokenElement("\"{\"", Color.black), new TokenElement("\"*\"", Color.black), new TokenElement("<Slash>", Color.black), new TokenElement("\"!=\"", Color.black), new TokenElement("\"<=\"", Color.black), new TokenElement("\">=\"", Color.black), new TokenElement("\":=\"", Color.black), new TokenElement("\">\"", Color.black), new TokenElement("\"-\"", Color.black), new TokenElement("\"+\"", Color.black), new TokenElement("\"(\"", Color.black), new TokenElement("\"[\"", Color.black), new TokenElement("\")\"", Color.black), new TokenElement("\"]\"", Color.black), new TokenElement("\",\"", Color.black), new TokenElement("\":\"", Color.black), new TokenElement("\";\"", Color.black), new TokenElement("\".\"", Color.black), new TokenElement("\"..\"", Color.black), new TokenElement("<Char>", Color.black), new TokenElement("<Letter>", Color.black), new TokenElement("<BaseChar>", Color.black), new TokenElement("<BaseCharSpec>", Color.black), new TokenElement("<Ideographic>", Color.black), new TokenElement("<CombiningChar>", Color.black), new TokenElement("<Extender>", Color.black)};
        Style root = this.getStyle("default");
        for (TokenElement current_token : this.tokens) {
            Style parent = this.getStyle(current_token.getCategory());
            if (parent == null) {
                parent = this.addStyle(current_token.getCategory(), root);
            }
            Style current_style = this.addStyle(null, parent);
            current_style.addAttribute(TokenElement.TOKEN_ATTRIBUTE, current_token);
            current_token.setStyle(current_style);
            StyleConstants.setFontFamily(current_style, current_token.getFont().getFamily());
            StyleConstants.setFontSize(current_style, current_token.getFont().getSize());
            StyleConstants.setBold(current_style, current_token.getFont().isBold());
            StyleConstants.setItalic(current_style, current_token.getFont().isItalic());
            StyleConstants.setForeground(current_style, current_token.getColor());
        }
        this.rehash();
    }

    private void rehash() {
        if (this.tokens == null) {
            return;
        }
        int n = this.tokens.length;
        if (n <= 0) {
            return;
        }
        this.hashTokens = new Hashtable();
        for (int i = 0; i < n; ++i) {
            TokenElement current_token = this.tokens[i];
            this.hashTokens.put(new Integer(current_token.hashCode()), current_token);
        }
    }

    private TokenElement getTokenElement(int code) {
        Integer hash_code = new Integer(code);
        if (this.hashTokens.containsKey(hash_code)) {
            return (TokenElement)this.hashTokens.get(hash_code);
        }
        return null;
    }

    public Color getForeground(int code) {
        TokenElement current_token = this.getTokenElement(code);
        if (current_token != null) {
            return current_token.getColor();
        }
        return Color.black;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Font getFont(int code) {
        TokenElement current_token = this.getTokenElement(code);
        if (current_token != null) {
            return current_token.getFont();
        }
        return this.getDefaultFont();
    }

    public Style getStyleForScanValue(int code) {
        TokenElement current_token = this.getTokenElement(code);
        if (current_token != null) {
            return current_token.getStyle();
        }
        return null;
    }
}

