/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.LiteralExpression;
import fr.gael.drb.query.LiteralResult;
import fr.gael.drb.query.Query;
import fr.gael.drb.query.RangeExpression;
import fr.gael.drb.query.SequenceExpression;
import fr.gael.drb.query.Token;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

class PredicatsListExpression
extends AbstractExpression {
    private static Logger logger = Logger.getLogger(PredicatsListExpression.class);
    List<Expression> predicates = new ArrayList<Expression>();

    public PredicatsListExpression(String name, Token token) {
        super(name, token);
    }

    public void addPredicate(Expression expression) {
        if (expression == null) {
            throw new DynamicException(this, "Cannot add null step predicate");
        }
        this.predicates.add(expression);
    }

    public boolean isEmpty() {
        return this.predicates.isEmpty();
    }

    public boolean accepts(DynamicContext context) {
        for (int iqual = 0; iqual < this.predicates.size(); ++iqual) {
            Expression predicate = this.predicates.get(iqual);
            if (predicate instanceof RangeExpression) {
                RangeExpression range_predicate = (RangeExpression)predicate;
                if (this.checkRangeExpression(context, range_predicate)) continue;
                return false;
            }
            if (predicate instanceof SequenceExpression) {
                boolean this_predicat_ok = false;
                SequenceExpression sequence_predicate = (SequenceExpression)predicate;
                int i = -1;
                Iterator it = sequence_predicate.iterator();
                while (it.hasNext()) {
                    ++i;
                    Expression expr = (Expression)it.next();
                    if (expr instanceof RangeExpression) {
                        if (!this.checkRangeExpression(context, (RangeExpression)expr)) continue;
                        this_predicat_ok = true;
                        break;
                    }
                    DrbSequence result = expr.evaluate(context);
                    if (result.getLength() == 0) continue;
                    if (result.getLength() > 1) {
                        throw new DynamicException(this, "Sequence inside predicats should contain only numeric value");
                    }
                    DrbItem item = result.getItem(0);
                    if (i == 0 && item.getItemType() == 1) {
                        this_predicat_ok = true;
                        break;
                    }
                    if (item.getItemType() != 3) {
                        throw new DynamicException(this, "Sequence inside predicats should contain only numeric value");
                    }
                    Value value = (Value)item;
                    if (value instanceof Numeric) {
                        if (!value.equals(new Int(context.focus.getContextPosition()))) continue;
                        this_predicat_ok = true;
                        break;
                    }
                    throw new DynamicException(this, "Sequence inside predicats should contain only numeric value");
                }
                if (this_predicat_ok) continue;
                return false;
            }
            DrbSequence predicate_result = predicate.evaluate(context);
            if (predicate_result == null) {
                throw new DynamicException(this, "Error while applying predicate (context: " + context + ")");
            }
            if (predicate_result.getLength() == 0) {
                if (Query.getEffectiveBooleanValue(predicate_result)) continue;
                return false;
            }
            DrbItem predicate_item = predicate_result.getItem(0);
            if (predicate_item != null && predicate_item.getItemType() == 1) {
                if (Query.getEffectiveBooleanValue(predicate_result)) continue;
                return false;
            }
            if (predicate_result.getLength() == 1) {
                Value value;
                predicate_item = predicate_result.getItem(0);
                if (predicate_item == null || !(predicate_item.getItemType() == 3 ? ((value = (Value)predicate_item) instanceof Numeric ? ((Numeric)value).intValue() != context.focus.getContextPosition() : !Query.getEffectiveBooleanValue(predicate_result)) : !Query.getEffectiveBooleanValue(predicate_result))) continue;
                return false;
            }
            boolean this_predicat_ok = false;
            for (int i = 0; i < predicate_result.getLength(); ++i) {
                DrbItem item = predicate_result.getItem(i);
                if (item.getItemType() != 3) {
                    throw new DynamicException(this, "Sequence inside predicats should contain only numeric value");
                }
                Value value = (Value)item;
                if (value instanceof Numeric) {
                    if (!value.equals(new Int(context.focus.getContextPosition()))) continue;
                    this_predicat_ok = true;
                    break;
                }
                throw new DynamicException(this, "Sequence inside predicats should contain only numeric value");
            }
            if (this_predicat_ok) continue;
            return false;
        }
        return true;
    }

    @Override
    public final DrbSequence evaluate(DynamicContext context) {
        if (this.accepts(context)) {
            return LiteralResult.TRUE;
        }
        return LiteralResult.FALSE;
    }

    public boolean getEvaluationLimit(DynamicContext context, int[] positions) {
        Integer min_position = 1;
        Integer max_position = Integer.MAX_VALUE;
        Integer current_min = 1;
        Integer current_max = Integer.MAX_VALUE;
        for (int iqual = 0; iqual < this.predicates.size(); ++iqual) {
            Expression predicate = this.predicates.get(iqual);
            if (predicate instanceof RangeExpression) {
                RangeExpression range_predicate = (RangeExpression)predicate;
                current_min = range_predicate.getMinimumValue(context).intValue();
                current_max = range_predicate.getMaximumValue(context).intValue();
            } else {
                Value value;
                DrbItem item;
                DrbSequence sequence;
                if (!(predicate instanceof LiteralExpression) || (sequence = predicate.evaluate(context)).getLength() != 1 || (item = sequence.getItem(0)).getItemType() != 3 || !((value = (Value)item) instanceof Numeric)) continue;
                current_max = current_min = Integer.valueOf(((Numeric)value).intValue());
            }
            if (current_min > max_position || min_position > current_max) {
                return false;
            }
            if (min_position >= current_min && max_position <= current_max) continue;
            if (current_min >= min_position && current_max <= max_position) {
                min_position = current_min;
                max_position = current_max;
                continue;
            }
            if (current_min >= min_position && current_max >= max_position) {
                min_position = current_min;
                continue;
            }
            if (current_min > min_position || current_max > max_position) continue;
            max_position = current_max;
        }
        positions[0] = min_position;
        positions[1] = max_position;
        return true;
    }

    private boolean checkRangeExpression(DynamicContext context, RangeExpression expr) {
        if (context == null || expr == null) {
            return false;
        }
        int min_position = expr.isMinimumConstant() ? (int)expr.getMinimumValue() : expr.getMinimumValue(context).intValue();
        int max_position = expr.isMaximumConstant() ? (int)expr.getMaximumValue() : expr.getMaximumValue(context).intValue();
        return context.focus.getContextPosition() >= min_position && context.focus.getContextPosition() <= max_position;
    }

    @Override
    public boolean isConstant() {
        boolean bool = true;
        Iterator<Expression> it = this.predicates.iterator();
        while (it.hasNext()) {
            bool = bool && it.next().isConstant();
        }
        return bool;
    }

    public String toString() {
        String s = "";
        Iterator<Expression> i = this.predicates.iterator();
        while (i.hasNext()) {
            s = s + "[" + i.next() + "]";
        }
        return s;
    }
}

