/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class ByteArray
extends AbstractNumericArray
implements ValueFormat {
    static final int PRIORITY = 1;
    private byte[] value;

    public ByteArray(byte[] src) {
        if (src != null) {
            this.value = new byte[src.length];
            System.arraycopy(src, 0, this.value, 0, src.length);
        } else {
            this.value = new byte[0];
        }
    }

    public ByteArray(int size) {
        this.value = new byte[size];
    }

    public final byte[] getData() {
        return this.value;
    }

    @Override
    public byte[] byteValues() {
        byte[] v = new byte[this.value.length];
        System.arraycopy(this.value, 0, v, 0, v.length);
        return v;
    }

    @Override
    public java.lang.String getFormattedString(int length) {
        StringBuffer strbuf = new StringBuffer(length);
        for (int i = 0; i < this.length(); ++i) {
            strbuf.append(Byte.getFormattedString(1, this.value[i], true));
        }
        return strbuf.toString();
    }

    @Override
    public byte[] getFormattedBuffer() {
        return this.value;
    }

    @Override
    public final int getType() {
        return 10;
    }

    @Override
    public final int getPriority() {
        return 1;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        throw new ClassCastException();
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        if (v == null) {
            this.value = new byte[0];
        } else {
            NumericArray b = (NumericArray)v;
            this.value = new byte[b.length()];
            for (int i = 0; i < this.length(); ++i) {
                this.value[i] = b.byteValue(i);
            }
        }
    }

    @Override
    public final int getArrayType() {
        return 1;
    }

    @Override
    public final Value getElement(int index) {
        return new Byte(this.value[index]);
    }

    @Override
    public final void assign(int index, Value element) {
        element = element.convertTo(9);
        this.value[index] = ((Numeric)element).byteValue();
    }

    @Override
    public final int length() {
        return this.value.length;
    }

    @Override
    public final boolean booleanValue(int index) {
        return this.value[index] != 0;
    }

    @Override
    public final byte byteValue(int index) {
        return this.value[index];
    }

    @Override
    public final int intValue(int index) {
        return this.value[index];
    }

    @Override
    public final long longValue(int index) {
        return this.value[index];
    }

    @Override
    public final short shortValue(int index) {
        return this.value[index];
    }

    @Override
    public final float floatValue(int index) {
        return this.value[index];
    }

    @Override
    public final double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public final void assign(int index, boolean value) {
        this.value[index] = (byte)(value ? 1 : 0);
    }

    @Override
    public final void assign(int index, byte value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, int value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, short value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, long value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, float value) {
        this.value[index] = (byte)value;
    }

    @Override
    public final void assign(int index, double value) {
        this.value[index] = (byte)value;
    }

    public java.lang.String toString() {
        StringBuffer strbuf = new StringBuffer(this.value.length * 3);
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                strbuf.append(" ");
            }
            strbuf.append(this.value[i]);
        }
        return strbuf.toString();
    }
}

