/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Byte;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class UnsignedByte
extends AbstractNumeric
implements ValueFormat {
    static final int PRIORITY = 1;
    byte value;

    public UnsignedByte(byte v) {
        this.value = v;
    }

    public UnsignedByte(int v) {
        this.value = (byte)(v & 0xFF);
    }

    public UnsignedByte(byte[] val) {
        this.value = val[0];
    }

    public UnsignedByte(byte[] val, int off) {
        this.value = val[off];
    }

    public String toString() {
        return java.lang.Short.toString((short)(this.value & 0xFF));
    }

    @Override
    public String getFormattedString(int length) {
        return Byte.getFormattedString(length, this.value, false);
    }

    @Override
    public byte[] getFormattedBuffer() {
        return Byte.getFormattedBuffer(this.value);
    }

    @Override
    public final int getType() {
        return 12;
    }

    @Override
    public final int getPriority() {
        return 1;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 9: 
            case 12: {
                return this;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Numeric vub = (Numeric)v.convertTo(9);
        this.value = vub.byteValue();
    }

    @Override
    public Value unaryMinus() {
        return new Byte((int)(-this.value));
    }

    @Override
    public final Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short sum = (short)(this.shortValue() + num.shortValue());
        if (sum < 128) {
            return new Byte((byte)sum);
        }
        if (sum < 256) {
            return new UnsignedByte((byte)sum);
        }
        return new Short(sum);
    }

    @Override
    public final Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short dif = (short)(this.shortValue() - num.shortValue());
        if (dif < -128 || dif > 255) {
            return new Short(dif);
        }
        if (dif < 128) {
            return new Byte((byte)dif);
        }
        return new UnsignedByte((byte)dif);
    }

    @Override
    public final Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short prod = (short)(this.shortValue() * num.shortValue());
        if (prod < -128 || prod > 255) {
            return new Short(prod);
        }
        if (prod < 128) {
            return new Byte((byte)prod);
        }
        return new UnsignedByte((byte)prod);
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short div = (short)(this.shortValue() / num.shortValue());
        if (div < -128 || div > 255) {
            return new Short(div);
        }
        if (div < 128) {
            return new Byte((byte)div);
        }
        return new UnsignedByte((byte)div);
    }

    @Override
    public final Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        short mod = (short)(this.shortValue() % num.shortValue());
        if (mod < -128 || mod > 255) {
            return new Short(mod);
        }
        if (mod < 128) {
            return new Byte((byte)mod);
        }
        return new UnsignedByte((byte)mod);
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            x = x.convertTo(9);
            return this.shortValue() - ((Numeric)x).shortValue();
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public final byte byteValue() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value & 0xFF;
    }

    @Override
    public final long longValue() {
        return (long)this.value & 0xFFL;
    }

    @Override
    public final short shortValue() {
        return (short)(this.value & 0xFF);
    }

    @Override
    public final float floatValue() {
        return this.shortValue();
    }

    @Override
    public final double doubleValue() {
        return this.shortValue();
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? (byte)1 : 0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = (byte)(value & 0xFF);
    }

    @Override
    public final void assign(short value) {
        this.value = (byte)(value & 0xFF);
    }

    @Override
    public final void assign(long value) {
        this.value = (byte)(value & 0xFFL);
    }

    @Override
    public final void assign(float value) {
        this.value = (byte)value;
    }

    @Override
    public final void assign(double value) {
        this.value = (byte)value;
    }

    public static void main(String[] args) {
        UnsignedByte ub = new UnsignedByte(82);
        UnsignedByte ub2 = new UnsignedByte(3);
        System.out.println(ub.multiply(ub2));
        System.out.println("23 compareTo 130 = " + new UnsignedByte(23).compareTo(new UnsignedByte(130)));
        System.out.println("23 compareTo 47 = " + new UnsignedByte(23).compareTo(new UnsignedByte(47)));
        System.out.println("137 compareTo 155 = " + new UnsignedByte(137).compareTo(new UnsignedByte(155)));
        System.out.println("   0 = [" + new UnsignedByte(0) + "]");
        System.out.println(" 127 = [" + new UnsignedByte(127) + "]");
        System.out.println(" 128 = [" + new UnsignedByte(128) + "]");
        System.out.println(" 255 = [" + new UnsignedByte(255) + "]");
        System.out.println(" 256 = [" + new UnsignedByte(256) + "]");
        System.out.println("  -1 = [" + new UnsignedByte(-1) + "]");
        System.out.println("-127 = [" + new UnsignedByte(-127) + "]");
        System.out.println("-128 = [" + new UnsignedByte(-128) + "]");
        System.out.println("getFormattedString :    0 = [" + new UnsignedByte(0).getFormattedString(1) + "]");
        System.out.println("getFormattedString :  127 = [" + new UnsignedByte(127).getFormattedString(1) + "]");
        System.out.println("getFormattedString :  128 = [" + new UnsignedByte(128).getFormattedString(1) + "]");
        System.out.println("getFormattedString :  255 = [" + new UnsignedByte(255).getFormattedString(1) + "]");
        System.out.println("getFormattedString :  256 = [" + new UnsignedByte(256).getFormattedString(1) + "]");
        System.out.println("getFormattedString :   -1 = [" + new UnsignedByte(-1).getFormattedString(1) + "]");
        System.out.println("getFormattedString : -127 = [" + new UnsignedByte(-127).getFormattedString(1) + "]");
        System.out.println("getFormattedString : -128 = [" + new UnsignedByte(-128).getFormattedString(1) + "]");
    }
}

