/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Int;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.UnsignedIntArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.text.DecimalFormat;

public class UnsignedInt
extends AbstractNumeric
implements ValueFormat {
    public static final int PRIORITY = 3;
    protected int value;

    public UnsignedInt(int v) {
        this.value = v;
    }

    public String toString() {
        return java.lang.Long.toString((long)this.value & 0xFFFFFFFFL);
    }

    public static String toString(int v) {
        return java.lang.Long.toString((long)v & 0xFFFFFFFFL);
    }

    @Override
    public String getFormattedString(int length) {
        return new String(new DecimalFormat("+0000000000;-0000000000").format((long)this.value & 0xFFFFFFFFL));
    }

    @Override
    public byte[] getFormattedBuffer() {
        byte[] buffer = new byte[]{(byte)(this.value >>> 24), (byte)(this.value >>> 16), (byte)(this.value >>> 8), (byte)this.value};
        return buffer;
    }

    @Override
    public final int getType() {
        return 14;
    }

    @Override
    public final int getPriority() {
        return 3;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 9: 
            case 14: {
                return this;
            }
            case 10: {
                UnsignedIntArray uintArray = new UnsignedIntArray(1);
                uintArray.assign(0, this.intValue());
                return uintArray;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Numeric vi = (Numeric)v.convertTo(9);
        this.value = vi.intValue();
    }

    @Override
    public Value unaryMinus() {
        return new Int(-this.value);
    }

    @Override
    public final Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long sum = num.longValue() + this.longValue();
        if (sum < Integer.MIN_VALUE || sum > 0xFFFFFFFFL) {
            return new Long(sum);
        }
        if (sum < 0x80000000L) {
            return new Int((int)sum);
        }
        return new UnsignedInt((int)sum);
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long dif = this.longValue() - num.longValue();
        if (dif < Integer.MIN_VALUE || dif > 0xFFFFFFFFL) {
            return new Long(dif);
        }
        if (dif < 0x80000000L) {
            return new Int((int)dif);
        }
        return new UnsignedInt((int)dif);
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long prod = this.longValue() * num.longValue();
        if (prod < Integer.MIN_VALUE || prod > 0xFFFFFFFFL) {
            return new Long(prod);
        }
        if (prod < 0x80000000L) {
            return new Int((int)prod);
        }
        return new UnsignedInt((int)prod);
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long div = this.longValue() / num.longValue();
        if (div < Integer.MIN_VALUE || div > 0xFFFFFFFFL) {
            return new Long(div);
        }
        if (div < 0x80000000L) {
            return new Int((int)div);
        }
        return new UnsignedInt((int)div);
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        long mod = this.longValue() % num.longValue();
        if (mod < Integer.MIN_VALUE || mod > 0xFFFFFFFFL) {
            return new Long(mod);
        }
        if (mod < 0x80000000L) {
            return new Int((int)mod);
        }
        return new UnsignedInt((int)mod);
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            long cmp = this.longValue() - ((Numeric)x).longValue();
            if (cmp < 0L) {
                return -1;
            }
            if (cmp > 0L) {
                return 1;
            }
            return 0;
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public final byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public final short shortValue() {
        return (short)(this.value & 0xFFFF);
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    @Override
    public final float floatValue() {
        return this.longValue();
    }

    @Override
    public final double doubleValue() {
        return this.longValue();
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? 1 : 0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value & 0xFF;
    }

    @Override
    public final void assign(short value) {
        this.value = value & 0xFFFF;
    }

    @Override
    public final void assign(int value) {
        this.value = value;
    }

    @Override
    public final void assign(long value) {
        this.value = (int)(value & 0xFFFFFFFFL);
    }

    @Override
    public final void assign(float value) {
        this.value = (int)value;
    }

    @Override
    public final void assign(double value) {
        this.value = (int)value;
    }

    public static void main(String[] args) {
        System.out.println(java.lang.Long.toBinaryString(0x80000000L));
        System.out.println(java.lang.Long.toBinaryString(Integer.MIN_VALUE));
        UnsignedInt uint = new UnsignedInt(-1);
        System.out.println(uint + " / " + uint.byteValue());
        uint.assign(4123456789L);
        System.out.println(uint + " / " + uint.longValue());
        uint = new UnsignedInt(((Numeric)uint.sub(new Int(2000000000))).intValue());
        System.out.println(uint);
        uint.assign((short)-1);
        System.out.println("(short)-1 : " + uint);
        uint.assign((byte)-1);
        System.out.println("(byte)-1 : " + uint);
        System.out.println(0xFFFFFFFFL);
    }
}

