/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.NumericArray;
import fr.gael.drb.value.Short;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedShort;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;

public class UnsignedShortArray
extends AbstractNumericArray
implements ValueFormat {
    static final int PRIORITY = 2;
    private short[] value;

    public UnsignedShortArray(short[] v) {
        this.value = new short[v.length];
        System.arraycopy(v, 0, this.value, 0, v.length);
    }

    private UnsignedShortArray(short[] v, boolean shallowCopy) {
        if (shallowCopy) {
            this.value = new short[v.length];
            System.arraycopy(v, 0, this.value, 0, v.length);
        } else {
            this.value = v;
        }
    }

    public UnsignedShortArray(int size) {
        this.value = new short[size];
    }

    public static UnsignedShortArray wrap(short[] v) {
        return new UnsignedShortArray(v, true);
    }

    public final short[] getData() {
        return this.value;
    }

    @Override
    public short[] shortValues() {
        short[] v = new short[this.value.length];
        System.arraycopy(this.value, 0, v, 0, v.length);
        return v;
    }

    @Override
    public java.lang.String getFormattedString(int length) {
        java.lang.String str = "";
        for (int i = 0; i < this.length(); ++i) {
            str = str + Short.getFormattedString(2, this.value[i], false);
        }
        return str;
    }

    @Override
    public final byte[] getFormattedBuffer() {
        byte[] buffer = new byte[2 * this.length()];
        for (int i = 0; i < this.length(); ++i) {
            buffer[2 * i + 0] = (byte)(this.value[i] >> 8);
            buffer[2 * i + 1] = (byte)this.value[i];
        }
        return buffer;
    }

    @Override
    public final int getType() {
        return 10;
    }

    @Override
    public final int getPriority() {
        return 2;
    }

    @Override
    public final Value convertTo(int type) throws ClassCastException {
        if (type == 10) {
            return this;
        }
        if (type == 7) {
            return new String(this.toString());
        }
        throw new ClassCastException();
    }

    @Override
    public final void assign(Value v) throws ClassCastException {
        NumericArray b = (NumericArray)v;
        this.value = new short[b.length()];
        for (int i = 0; i < this.length(); ++i) {
            this.value[i] = b.shortValue(i);
        }
    }

    @Override
    public final int getArrayType() {
        return 13;
    }

    @Override
    public final Value getElement(int index) {
        return new UnsignedShort(this.value[index]);
    }

    @Override
    public final void assign(int index, Value element) {
        element = element.convertTo(9);
        this.value[index] = ((Numeric)element).shortValue();
    }

    @Override
    public final int length() {
        return this.value.length;
    }

    @Override
    public final boolean booleanValue(int index) {
        return this.value[index] != 0;
    }

    @Override
    public final byte byteValue(int index) {
        return (byte)this.value[index];
    }

    @Override
    public final int intValue(int index) {
        return this.value[index] & 0xFFFF;
    }

    @Override
    public final long longValue(int index) {
        return (long)this.value[index] & 0xFFFFL;
    }

    @Override
    public final short shortValue(int index) {
        return this.value[index];
    }

    @Override
    public final float floatValue(int index) {
        return this.value[index] & 0xFFFF;
    }

    @Override
    public final double doubleValue(int index) {
        return this.value[index] & 0xFFFF;
    }

    @Override
    public final void assign(int index, boolean value) {
        this.value[index] = (short)(value ? 1 : 0);
    }

    @Override
    public final void assign(int index, byte value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, int value) {
        this.value[index] = (short)value;
    }

    @Override
    public final void assign(int index, short value) {
        this.value[index] = value;
    }

    @Override
    public final void assign(int index, long value) {
        this.value[index] = (short)value;
    }

    @Override
    public final void assign(int index, float value) {
        this.value[index] = (short)value;
    }

    @Override
    public final void assign(int index, double value) {
        this.value[index] = (short)value;
    }

    public java.lang.String toString() {
        StringBuffer strbuf = new StringBuffer(this.value.length * 3);
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                strbuf.append(" ");
            }
            strbuf.append(this.value[i] & 0xFFFF);
        }
        return strbuf.toString();
    }

    public static void main(java.lang.String[] args) {
        UnsignedShortArray array = new UnsignedShortArray(new short[]{-1, -1, -1});
        System.out.println(array.toString());
    }
}

