import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::DataSync::Agent`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html
 * @external
 */
export interface CfnAgentProps {
    /**
     * `AWS::DataSync::Agent.ActivationKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-activationkey
     * @external
     */
    readonly activationKey: string;
    /**
     * `AWS::DataSync::Agent.AgentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-agentname
     * @external
     */
    readonly agentName?: string;
    /**
     * `AWS::DataSync::Agent.SecurityGroupArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-securitygrouparns
     * @external
     */
    readonly securityGroupArns?: string[];
    /**
     * `AWS::DataSync::Agent.SubnetArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-subnetarns
     * @external
     */
    readonly subnetArns?: string[];
    /**
     * `AWS::DataSync::Agent.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DataSync::Agent.VpcEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-vpcendpointid
     * @external
     */
    readonly vpcEndpointId?: string;
}
/**
 * A CloudFormation `AWS::DataSync::Agent`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html
 * @external
 * @cloudformationResource AWS::DataSync::Agent
 */
export declare class CfnAgent extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::Agent";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAgent;
    /**
     * @external
     * @cloudformationAttribute AgentArn
     */
    readonly attrAgentArn: string;
    /**
     * @external
     * @cloudformationAttribute EndpointType
     */
    readonly attrEndpointType: string;
    /**
     * `AWS::DataSync::Agent.ActivationKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-activationkey
     * @external
     */
    activationKey: string;
    /**
     * `AWS::DataSync::Agent.AgentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-agentname
     * @external
     */
    agentName: string | undefined;
    /**
     * `AWS::DataSync::Agent.SecurityGroupArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-securitygrouparns
     * @external
     */
    securityGroupArns: string[] | undefined;
    /**
     * `AWS::DataSync::Agent.SubnetArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-subnetarns
     * @external
     */
    subnetArns: string[] | undefined;
    /**
     * `AWS::DataSync::Agent.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DataSync::Agent.VpcEndpointId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-vpcendpointid
     * @external
     */
    vpcEndpointId: string | undefined;
    /**
     * Create a new `AWS::DataSync::Agent`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAgentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DataSync::LocationEFS`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html
 * @external
 */
export interface CfnLocationEFSProps {
    /**
     * `AWS::DataSync::LocationEFS.Ec2Config`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-ec2config
     * @external
     */
    readonly ec2Config: CfnLocationEFS.Ec2ConfigProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationEFS.EfsFilesystemArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-efsfilesystemarn
     * @external
     */
    readonly efsFilesystemArn: string;
    /**
     * `AWS::DataSync::LocationEFS.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-subdirectory
     * @external
     */
    readonly subdirectory?: string;
    /**
     * `AWS::DataSync::LocationEFS.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataSync::LocationEFS`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationEFS
 */
export declare class CfnLocationEFS extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationEFS";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocationEFS;
    /**
     * @external
     * @cloudformationAttribute LocationArn
     */
    readonly attrLocationArn: string;
    /**
     * @external
     * @cloudformationAttribute LocationUri
     */
    readonly attrLocationUri: string;
    /**
     * `AWS::DataSync::LocationEFS.Ec2Config`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-ec2config
     * @external
     */
    ec2Config: CfnLocationEFS.Ec2ConfigProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationEFS.EfsFilesystemArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-efsfilesystemarn
     * @external
     */
    efsFilesystemArn: string;
    /**
     * `AWS::DataSync::LocationEFS.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-subdirectory
     * @external
     */
    subdirectory: string | undefined;
    /**
     * `AWS::DataSync::LocationEFS.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html#cfn-datasync-locationefs-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataSync::LocationEFS`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocationEFSProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataSync::LocationEFS`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationefs.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationEFS
 */
export declare namespace CfnLocationEFS {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationefs-ec2config.html
     * @external
     */
    interface Ec2ConfigProperty {
        /**
         * `CfnLocationEFS.Ec2ConfigProperty.SecurityGroupArns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationefs-ec2config.html#cfn-datasync-locationefs-ec2config-securitygrouparns
         * @external
         */
        readonly securityGroupArns: string[];
        /**
         * `CfnLocationEFS.Ec2ConfigProperty.SubnetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationefs-ec2config.html#cfn-datasync-locationefs-ec2config-subnetarn
         * @external
         */
        readonly subnetArn: string;
    }
}
/**
 * Properties for defining a `AWS::DataSync::LocationFSxWindows`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html
 * @external
 */
export interface CfnLocationFSxWindowsProps {
    /**
     * `AWS::DataSync::LocationFSxWindows.FsxFilesystemArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-fsxfilesystemarn
     * @external
     */
    readonly fsxFilesystemArn: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-password
     * @external
     */
    readonly password: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.SecurityGroupArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-securitygrouparns
     * @external
     */
    readonly securityGroupArns: string[];
    /**
     * `AWS::DataSync::LocationFSxWindows.User`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-user
     * @external
     */
    readonly user: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-domain
     * @external
     */
    readonly domain?: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-subdirectory
     * @external
     */
    readonly subdirectory?: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataSync::LocationFSxWindows`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationFSxWindows
 */
export declare class CfnLocationFSxWindows extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationFSxWindows";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocationFSxWindows;
    /**
     * @external
     * @cloudformationAttribute LocationArn
     */
    readonly attrLocationArn: string;
    /**
     * @external
     * @cloudformationAttribute LocationUri
     */
    readonly attrLocationUri: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.FsxFilesystemArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-fsxfilesystemarn
     * @external
     */
    fsxFilesystemArn: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-password
     * @external
     */
    password: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.SecurityGroupArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-securitygrouparns
     * @external
     */
    securityGroupArns: string[];
    /**
     * `AWS::DataSync::LocationFSxWindows.User`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-user
     * @external
     */
    user: string;
    /**
     * `AWS::DataSync::LocationFSxWindows.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-domain
     * @external
     */
    domain: string | undefined;
    /**
     * `AWS::DataSync::LocationFSxWindows.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-subdirectory
     * @external
     */
    subdirectory: string | undefined;
    /**
     * `AWS::DataSync::LocationFSxWindows.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationfsxwindows.html#cfn-datasync-locationfsxwindows-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataSync::LocationFSxWindows`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocationFSxWindowsProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DataSync::LocationNFS`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html
 * @external
 */
export interface CfnLocationNFSProps {
    /**
     * `AWS::DataSync::LocationNFS.OnPremConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-onpremconfig
     * @external
     */
    readonly onPremConfig: CfnLocationNFS.OnPremConfigProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationNFS.ServerHostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-serverhostname
     * @external
     */
    readonly serverHostname: string;
    /**
     * `AWS::DataSync::LocationNFS.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-subdirectory
     * @external
     */
    readonly subdirectory: string;
    /**
     * `AWS::DataSync::LocationNFS.MountOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-mountoptions
     * @external
     */
    readonly mountOptions?: CfnLocationNFS.MountOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationNFS.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataSync::LocationNFS`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationNFS
 */
export declare class CfnLocationNFS extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationNFS";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocationNFS;
    /**
     * @external
     * @cloudformationAttribute LocationArn
     */
    readonly attrLocationArn: string;
    /**
     * @external
     * @cloudformationAttribute LocationUri
     */
    readonly attrLocationUri: string;
    /**
     * `AWS::DataSync::LocationNFS.OnPremConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-onpremconfig
     * @external
     */
    onPremConfig: CfnLocationNFS.OnPremConfigProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationNFS.ServerHostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-serverhostname
     * @external
     */
    serverHostname: string;
    /**
     * `AWS::DataSync::LocationNFS.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-subdirectory
     * @external
     */
    subdirectory: string;
    /**
     * `AWS::DataSync::LocationNFS.MountOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-mountoptions
     * @external
     */
    mountOptions: CfnLocationNFS.MountOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DataSync::LocationNFS.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html#cfn-datasync-locationnfs-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataSync::LocationNFS`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocationNFSProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataSync::LocationNFS`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationNFS
 */
export declare namespace CfnLocationNFS {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationnfs-mountoptions.html
     * @external
     */
    interface MountOptionsProperty {
        /**
         * `CfnLocationNFS.MountOptionsProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationnfs-mountoptions.html#cfn-datasync-locationnfs-mountoptions-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::DataSync::LocationNFS`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationnfs.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationNFS
 */
export declare namespace CfnLocationNFS {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationnfs-onpremconfig.html
     * @external
     */
    interface OnPremConfigProperty {
        /**
         * `CfnLocationNFS.OnPremConfigProperty.AgentArns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationnfs-onpremconfig.html#cfn-datasync-locationnfs-onpremconfig-agentarns
         * @external
         */
        readonly agentArns: string[];
    }
}
/**
 * Properties for defining a `AWS::DataSync::LocationObjectStorage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html
 * @external
 */
export interface CfnLocationObjectStorageProps {
    /**
     * `AWS::DataSync::LocationObjectStorage.AgentArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-agentarns
     * @external
     */
    readonly agentArns: string[];
    /**
     * `AWS::DataSync::LocationObjectStorage.BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-bucketname
     * @external
     */
    readonly bucketName: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.ServerHostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverhostname
     * @external
     */
    readonly serverHostname: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.AccessKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-accesskey
     * @external
     */
    readonly accessKey?: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.SecretKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-secretkey
     * @external
     */
    readonly secretKey?: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.ServerPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverport
     * @external
     */
    readonly serverPort?: number;
    /**
     * `AWS::DataSync::LocationObjectStorage.ServerProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverprotocol
     * @external
     */
    readonly serverProtocol?: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-subdirectory
     * @external
     */
    readonly subdirectory?: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataSync::LocationObjectStorage`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationObjectStorage
 */
export declare class CfnLocationObjectStorage extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationObjectStorage";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocationObjectStorage;
    /**
     * @external
     * @cloudformationAttribute LocationArn
     */
    readonly attrLocationArn: string;
    /**
     * @external
     * @cloudformationAttribute LocationUri
     */
    readonly attrLocationUri: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.AgentArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-agentarns
     * @external
     */
    agentArns: string[];
    /**
     * `AWS::DataSync::LocationObjectStorage.BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-bucketname
     * @external
     */
    bucketName: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.ServerHostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverhostname
     * @external
     */
    serverHostname: string;
    /**
     * `AWS::DataSync::LocationObjectStorage.AccessKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-accesskey
     * @external
     */
    accessKey: string | undefined;
    /**
     * `AWS::DataSync::LocationObjectStorage.SecretKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-secretkey
     * @external
     */
    secretKey: string | undefined;
    /**
     * `AWS::DataSync::LocationObjectStorage.ServerPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverport
     * @external
     */
    serverPort: number | undefined;
    /**
     * `AWS::DataSync::LocationObjectStorage.ServerProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverprotocol
     * @external
     */
    serverProtocol: string | undefined;
    /**
     * `AWS::DataSync::LocationObjectStorage.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-subdirectory
     * @external
     */
    subdirectory: string | undefined;
    /**
     * `AWS::DataSync::LocationObjectStorage.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataSync::LocationObjectStorage`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocationObjectStorageProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DataSync::LocationS3`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html
 * @external
 */
export interface CfnLocationS3Props {
    /**
     * `AWS::DataSync::LocationS3.S3BucketArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-s3bucketarn
     * @external
     */
    readonly s3BucketArn: string;
    /**
     * `AWS::DataSync::LocationS3.S3Config`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-s3config
     * @external
     */
    readonly s3Config: CfnLocationS3.S3ConfigProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationS3.S3StorageClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-s3storageclass
     * @external
     */
    readonly s3StorageClass?: string;
    /**
     * `AWS::DataSync::LocationS3.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-subdirectory
     * @external
     */
    readonly subdirectory?: string;
    /**
     * `AWS::DataSync::LocationS3.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataSync::LocationS3`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationS3
 */
export declare class CfnLocationS3 extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationS3";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocationS3;
    /**
     * @external
     * @cloudformationAttribute LocationArn
     */
    readonly attrLocationArn: string;
    /**
     * @external
     * @cloudformationAttribute LocationUri
     */
    readonly attrLocationUri: string;
    /**
     * `AWS::DataSync::LocationS3.S3BucketArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-s3bucketarn
     * @external
     */
    s3BucketArn: string;
    /**
     * `AWS::DataSync::LocationS3.S3Config`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-s3config
     * @external
     */
    s3Config: CfnLocationS3.S3ConfigProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationS3.S3StorageClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-s3storageclass
     * @external
     */
    s3StorageClass: string | undefined;
    /**
     * `AWS::DataSync::LocationS3.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-subdirectory
     * @external
     */
    subdirectory: string | undefined;
    /**
     * `AWS::DataSync::LocationS3.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html#cfn-datasync-locations3-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataSync::LocationS3`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocationS3Props);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataSync::LocationS3`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locations3.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationS3
 */
export declare namespace CfnLocationS3 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locations3-s3config.html
     * @external
     */
    interface S3ConfigProperty {
        /**
         * `CfnLocationS3.S3ConfigProperty.BucketAccessRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locations3-s3config.html#cfn-datasync-locations3-s3config-bucketaccessrolearn
         * @external
         */
        readonly bucketAccessRoleArn: string;
    }
}
/**
 * Properties for defining a `AWS::DataSync::LocationSMB`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html
 * @external
 */
export interface CfnLocationSMBProps {
    /**
     * `AWS::DataSync::LocationSMB.AgentArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-agentarns
     * @external
     */
    readonly agentArns: string[];
    /**
     * `AWS::DataSync::LocationSMB.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-password
     * @external
     */
    readonly password: string;
    /**
     * `AWS::DataSync::LocationSMB.ServerHostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-serverhostname
     * @external
     */
    readonly serverHostname: string;
    /**
     * `AWS::DataSync::LocationSMB.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-subdirectory
     * @external
     */
    readonly subdirectory: string;
    /**
     * `AWS::DataSync::LocationSMB.User`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-user
     * @external
     */
    readonly user: string;
    /**
     * `AWS::DataSync::LocationSMB.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-domain
     * @external
     */
    readonly domain?: string;
    /**
     * `AWS::DataSync::LocationSMB.MountOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-mountoptions
     * @external
     */
    readonly mountOptions?: CfnLocationSMB.MountOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::LocationSMB.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataSync::LocationSMB`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationSMB
 */
export declare class CfnLocationSMB extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::LocationSMB";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLocationSMB;
    /**
     * @external
     * @cloudformationAttribute LocationArn
     */
    readonly attrLocationArn: string;
    /**
     * @external
     * @cloudformationAttribute LocationUri
     */
    readonly attrLocationUri: string;
    /**
     * `AWS::DataSync::LocationSMB.AgentArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-agentarns
     * @external
     */
    agentArns: string[];
    /**
     * `AWS::DataSync::LocationSMB.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-password
     * @external
     */
    password: string;
    /**
     * `AWS::DataSync::LocationSMB.ServerHostname`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-serverhostname
     * @external
     */
    serverHostname: string;
    /**
     * `AWS::DataSync::LocationSMB.Subdirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-subdirectory
     * @external
     */
    subdirectory: string;
    /**
     * `AWS::DataSync::LocationSMB.User`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-user
     * @external
     */
    user: string;
    /**
     * `AWS::DataSync::LocationSMB.Domain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-domain
     * @external
     */
    domain: string | undefined;
    /**
     * `AWS::DataSync::LocationSMB.MountOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-mountoptions
     * @external
     */
    mountOptions: CfnLocationSMB.MountOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DataSync::LocationSMB.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataSync::LocationSMB`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLocationSMBProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataSync::LocationSMB`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html
 * @external
 * @cloudformationResource AWS::DataSync::LocationSMB
 */
export declare namespace CfnLocationSMB {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationsmb-mountoptions.html
     * @external
     */
    interface MountOptionsProperty {
        /**
         * `CfnLocationSMB.MountOptionsProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationsmb-mountoptions.html#cfn-datasync-locationsmb-mountoptions-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `AWS::DataSync::Task`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html
 * @external
 */
export interface CfnTaskProps {
    /**
     * `AWS::DataSync::Task.DestinationLocationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-destinationlocationarn
     * @external
     */
    readonly destinationLocationArn: string;
    /**
     * `AWS::DataSync::Task.SourceLocationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-sourcelocationarn
     * @external
     */
    readonly sourceLocationArn: string;
    /**
     * `AWS::DataSync::Task.CloudWatchLogGroupArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-cloudwatchloggrouparn
     * @external
     */
    readonly cloudWatchLogGroupArn?: string;
    /**
     * `AWS::DataSync::Task.Excludes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes
     * @external
     */
    readonly excludes?: Array<CfnTask.FilterRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataSync::Task.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::DataSync::Task.Options`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options
     * @external
     */
    readonly options?: CfnTask.OptionsProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::Task.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule
     * @external
     */
    readonly schedule?: CfnTask.TaskScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::DataSync::Task.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataSync::Task`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html
 * @external
 * @cloudformationResource AWS::DataSync::Task
 */
export declare class CfnTask extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataSync::Task";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTask;
    /**
     * @external
     * @cloudformationAttribute DestinationNetworkInterfaceArns
     */
    readonly attrDestinationNetworkInterfaceArns: string[];
    /**
     * @external
     * @cloudformationAttribute ErrorCode
     */
    readonly attrErrorCode: string;
    /**
     * @external
     * @cloudformationAttribute ErrorDetail
     */
    readonly attrErrorDetail: string;
    /**
     * @external
     * @cloudformationAttribute SourceNetworkInterfaceArns
     */
    readonly attrSourceNetworkInterfaceArns: string[];
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * @external
     * @cloudformationAttribute TaskArn
     */
    readonly attrTaskArn: string;
    /**
     * `AWS::DataSync::Task.DestinationLocationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-destinationlocationarn
     * @external
     */
    destinationLocationArn: string;
    /**
     * `AWS::DataSync::Task.SourceLocationArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-sourcelocationarn
     * @external
     */
    sourceLocationArn: string;
    /**
     * `AWS::DataSync::Task.CloudWatchLogGroupArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-cloudwatchloggrouparn
     * @external
     */
    cloudWatchLogGroupArn: string | undefined;
    /**
     * `AWS::DataSync::Task.Excludes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes
     * @external
     */
    excludes: Array<CfnTask.FilterRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DataSync::Task.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::DataSync::Task.Options`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options
     * @external
     */
    options: CfnTask.OptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DataSync::Task.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule
     * @external
     */
    schedule: CfnTask.TaskScheduleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DataSync::Task.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataSync::Task`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTaskProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataSync::Task`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html
 * @external
 * @cloudformationResource AWS::DataSync::Task
 */
export declare namespace CfnTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html
     * @external
     */
    interface FilterRuleProperty {
        /**
         * `CfnTask.FilterRuleProperty.FilterType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html#cfn-datasync-task-filterrule-filtertype
         * @external
         */
        readonly filterType?: string;
        /**
         * `CfnTask.FilterRuleProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html#cfn-datasync-task-filterrule-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::DataSync::Task`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html
 * @external
 * @cloudformationResource AWS::DataSync::Task
 */
export declare namespace CfnTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html
     * @external
     */
    interface OptionsProperty {
        /**
         * `CfnTask.OptionsProperty.Atime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-atime
         * @external
         */
        readonly atime?: string;
        /**
         * `CfnTask.OptionsProperty.BytesPerSecond`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-bytespersecond
         * @external
         */
        readonly bytesPerSecond?: number;
        /**
         * `CfnTask.OptionsProperty.Gid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-gid
         * @external
         */
        readonly gid?: string;
        /**
         * `CfnTask.OptionsProperty.LogLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-loglevel
         * @external
         */
        readonly logLevel?: string;
        /**
         * `CfnTask.OptionsProperty.Mtime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-mtime
         * @external
         */
        readonly mtime?: string;
        /**
         * `CfnTask.OptionsProperty.OverwriteMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-overwritemode
         * @external
         */
        readonly overwriteMode?: string;
        /**
         * `CfnTask.OptionsProperty.PosixPermissions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-posixpermissions
         * @external
         */
        readonly posixPermissions?: string;
        /**
         * `CfnTask.OptionsProperty.PreserveDeletedFiles`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-preservedeletedfiles
         * @external
         */
        readonly preserveDeletedFiles?: string;
        /**
         * `CfnTask.OptionsProperty.PreserveDevices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-preservedevices
         * @external
         */
        readonly preserveDevices?: string;
        /**
         * `CfnTask.OptionsProperty.TaskQueueing`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-taskqueueing
         * @external
         */
        readonly taskQueueing?: string;
        /**
         * `CfnTask.OptionsProperty.TransferMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-transfermode
         * @external
         */
        readonly transferMode?: string;
        /**
         * `CfnTask.OptionsProperty.Uid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-uid
         * @external
         */
        readonly uid?: string;
        /**
         * `CfnTask.OptionsProperty.VerifyMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-verifymode
         * @external
         */
        readonly verifyMode?: string;
    }
}
/**
 * A CloudFormation `AWS::DataSync::Task`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html
 * @external
 * @cloudformationResource AWS::DataSync::Task
 */
export declare namespace CfnTask {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html
     * @external
     */
    interface TaskScheduleProperty {
        /**
         * `CfnTask.TaskScheduleProperty.ScheduleExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html#cfn-datasync-task-taskschedule-scheduleexpression
         * @external
         */
        readonly scheduleExpression: string;
    }
}
