
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	0e50106f          	j	800018f0 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	7640106f          	j	80001800 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00008297          	auipc	t0,0x8
800000b0:	c9428293          	addi	t0,t0,-876 # 80007d40 <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00008397          	auipc	t2,0x8
800000c8:	01438393          	addi	t2,t2,20 # 800080d8 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	79c0106f          	j	8000188c <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00007297          	auipc	t0,0x7
8000010c:	95c28293          	addi	t0,t0,-1700 # 80006a64 <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00008317          	auipc	t1,0x8
80000128:	fb430313          	addi	t1,t1,-76 # 800080d8 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00008297          	auipc	t0,0x8
80000150:	f8c28293          	addi	t0,t0,-116 # 800080d8 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00008397          	auipc	t2,0x8
80000190:	b3038393          	addi	t2,t2,-1232 # 80007cbc <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00008297          	auipc	t0,0x8
80000240:	e9c28293          	addi	t0,t0,-356 # 800080d8 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	fd010113          	addi	sp,sp,-48
800002c4:	02912223          	sw	s1,36(sp)
800002c8:	01612823          	sw	s6,16(sp)
800002cc:	02112623          	sw	ra,44(sp)
800002d0:	02812423          	sw	s0,40(sp)
800002d4:	03212023          	sw	s2,32(sp)
800002d8:	01312e23          	sw	s3,28(sp)
800002dc:	01412c23          	sw	s4,24(sp)
800002e0:	01512a23          	sw	s5,20(sp)
800002e4:	01712623          	sw	s7,12(sp)
800002e8:	01812423          	sw	s8,8(sp)
800002ec:	01912223          	sw	s9,4(sp)
800002f0:	00050b13          	mv	s6,a0
800002f4:	00058493          	mv	s1,a1
800002f8:	38069c63          	bnez	a3,80000690 <__udivdi3+0x3d0>
800002fc:	00060413          	mv	s0,a2
80000300:	00050993          	mv	s3,a0
80000304:	00007917          	auipc	s2,0x7
80000308:	8e090913          	addi	s2,s2,-1824 # 80006be4 <__devconfig_end>
8000030c:	12c5f863          	bgeu	a1,a2,8000043c <__udivdi3+0x17c>
80000310:	000107b7          	lui	a5,0x10
80000314:	00058a93          	mv	s5,a1
80000318:	10f67863          	bgeu	a2,a5,80000428 <__udivdi3+0x168>
8000031c:	0ff00693          	li	a3,255
80000320:	00c6b6b3          	sltu	a3,a3,a2
80000324:	00369693          	slli	a3,a3,0x3
80000328:	00d657b3          	srl	a5,a2,a3
8000032c:	00f90933          	add	s2,s2,a5
80000330:	00094703          	lbu	a4,0(s2)
80000334:	00d706b3          	add	a3,a4,a3
80000338:	02000713          	li	a4,32
8000033c:	40d70733          	sub	a4,a4,a3
80000340:	00070c63          	beqz	a4,80000358 <__udivdi3+0x98>
80000344:	00e494b3          	sll	s1,s1,a4
80000348:	00db56b3          	srl	a3,s6,a3
8000034c:	00e61433          	sll	s0,a2,a4
80000350:	0096eab3          	or	s5,a3,s1
80000354:	00eb19b3          	sll	s3,s6,a4
80000358:	01045b13          	srli	s6,s0,0x10
8000035c:	000b0593          	mv	a1,s6
80000360:	000a8513          	mv	a0,s5
80000364:	634000ef          	jal	ra,80000998 <__umodsi3>
80000368:	00050913          	mv	s2,a0
8000036c:	000b0593          	mv	a1,s6
80000370:	01041b93          	slli	s7,s0,0x10
80000374:	000a8513          	mv	a0,s5
80000378:	5d8000ef          	jal	ra,80000950 <__udivsi3>
8000037c:	010bdb93          	srli	s7,s7,0x10
80000380:	00050493          	mv	s1,a0
80000384:	00050593          	mv	a1,a0
80000388:	000b8513          	mv	a0,s7
8000038c:	508000ef          	jal	ra,80000894 <__mulsi3>
80000390:	01091913          	slli	s2,s2,0x10
80000394:	0109d713          	srli	a4,s3,0x10
80000398:	00e96733          	or	a4,s2,a4
8000039c:	00048a13          	mv	s4,s1
800003a0:	00a77e63          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003a4:	00870733          	add	a4,a4,s0
800003a8:	fff48a13          	addi	s4,s1,-1
800003ac:	00876863          	bltu	a4,s0,800003bc <__udivdi3+0xfc>
800003b0:	00a77663          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003b4:	ffe48a13          	addi	s4,s1,-2
800003b8:	00870733          	add	a4,a4,s0
800003bc:	40a704b3          	sub	s1,a4,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	5d0000ef          	jal	ra,80000998 <__umodsi3>
800003cc:	00050913          	mv	s2,a0
800003d0:	000b0593          	mv	a1,s6
800003d4:	00048513          	mv	a0,s1
800003d8:	578000ef          	jal	ra,80000950 <__udivsi3>
800003dc:	01099993          	slli	s3,s3,0x10
800003e0:	00050493          	mv	s1,a0
800003e4:	00050593          	mv	a1,a0
800003e8:	01091913          	slli	s2,s2,0x10
800003ec:	000b8513          	mv	a0,s7
800003f0:	0109d993          	srli	s3,s3,0x10
800003f4:	4a0000ef          	jal	ra,80000894 <__mulsi3>
800003f8:	013969b3          	or	s3,s2,s3
800003fc:	00048613          	mv	a2,s1
80000400:	00a9fc63          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000404:	013409b3          	add	s3,s0,s3
80000408:	fff48613          	addi	a2,s1,-1
8000040c:	0089e663          	bltu	s3,s0,80000418 <__udivdi3+0x158>
80000410:	00a9f463          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000414:	ffe48613          	addi	a2,s1,-2
80000418:	010a1793          	slli	a5,s4,0x10
8000041c:	00c7e7b3          	or	a5,a5,a2
80000420:	00000a13          	li	s4,0
80000424:	1300006f          	j	80000554 <__udivdi3+0x294>
80000428:	010007b7          	lui	a5,0x1000
8000042c:	01000693          	li	a3,16
80000430:	eef66ce3          	bltu	a2,a5,80000328 <__udivdi3+0x68>
80000434:	01800693          	li	a3,24
80000438:	ef1ff06f          	j	80000328 <__udivdi3+0x68>
8000043c:	00068a13          	mv	s4,a3
80000440:	00061a63          	bnez	a2,80000454 <__udivdi3+0x194>
80000444:	00000593          	li	a1,0
80000448:	00100513          	li	a0,1
8000044c:	504000ef          	jal	ra,80000950 <__udivsi3>
80000450:	00050413          	mv	s0,a0
80000454:	000107b7          	lui	a5,0x10
80000458:	12f47c63          	bgeu	s0,a5,80000590 <__udivdi3+0x2d0>
8000045c:	0ff00793          	li	a5,255
80000460:	0087f463          	bgeu	a5,s0,80000468 <__udivdi3+0x1a8>
80000464:	00800a13          	li	s4,8
80000468:	014457b3          	srl	a5,s0,s4
8000046c:	00f90933          	add	s2,s2,a5
80000470:	00094683          	lbu	a3,0(s2)
80000474:	02000613          	li	a2,32
80000478:	014686b3          	add	a3,a3,s4
8000047c:	40d60633          	sub	a2,a2,a3
80000480:	12061263          	bnez	a2,800005a4 <__udivdi3+0x2e4>
80000484:	408484b3          	sub	s1,s1,s0
80000488:	00100a13          	li	s4,1
8000048c:	01045b13          	srli	s6,s0,0x10
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	500000ef          	jal	ra,80000998 <__umodsi3>
8000049c:	00050913          	mv	s2,a0
800004a0:	000b0593          	mv	a1,s6
800004a4:	00048513          	mv	a0,s1
800004a8:	01041b93          	slli	s7,s0,0x10
800004ac:	4a4000ef          	jal	ra,80000950 <__udivsi3>
800004b0:	010bdb93          	srli	s7,s7,0x10
800004b4:	00050493          	mv	s1,a0
800004b8:	00050593          	mv	a1,a0
800004bc:	000b8513          	mv	a0,s7
800004c0:	3d4000ef          	jal	ra,80000894 <__mulsi3>
800004c4:	01091913          	slli	s2,s2,0x10
800004c8:	0109d713          	srli	a4,s3,0x10
800004cc:	00e96733          	or	a4,s2,a4
800004d0:	00048a93          	mv	s5,s1
800004d4:	00a77e63          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004d8:	00870733          	add	a4,a4,s0
800004dc:	fff48a93          	addi	s5,s1,-1
800004e0:	00876863          	bltu	a4,s0,800004f0 <__udivdi3+0x230>
800004e4:	00a77663          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004e8:	ffe48a93          	addi	s5,s1,-2
800004ec:	00870733          	add	a4,a4,s0
800004f0:	40a704b3          	sub	s1,a4,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	49c000ef          	jal	ra,80000998 <__umodsi3>
80000500:	00050913          	mv	s2,a0
80000504:	000b0593          	mv	a1,s6
80000508:	00048513          	mv	a0,s1
8000050c:	444000ef          	jal	ra,80000950 <__udivsi3>
80000510:	01099993          	slli	s3,s3,0x10
80000514:	00050493          	mv	s1,a0
80000518:	00050593          	mv	a1,a0
8000051c:	01091913          	slli	s2,s2,0x10
80000520:	000b8513          	mv	a0,s7
80000524:	0109d993          	srli	s3,s3,0x10
80000528:	36c000ef          	jal	ra,80000894 <__mulsi3>
8000052c:	013969b3          	or	s3,s2,s3
80000530:	00048613          	mv	a2,s1
80000534:	00a9fc63          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000538:	013409b3          	add	s3,s0,s3
8000053c:	fff48613          	addi	a2,s1,-1
80000540:	0089e663          	bltu	s3,s0,8000054c <__udivdi3+0x28c>
80000544:	00a9f463          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000548:	ffe48613          	addi	a2,s1,-2
8000054c:	010a9793          	slli	a5,s5,0x10
80000550:	00c7e7b3          	or	a5,a5,a2
80000554:	00078513          	mv	a0,a5
80000558:	000a0593          	mv	a1,s4
8000055c:	02c12083          	lw	ra,44(sp)
80000560:	02812403          	lw	s0,40(sp)
80000564:	02412483          	lw	s1,36(sp)
80000568:	02012903          	lw	s2,32(sp)
8000056c:	01c12983          	lw	s3,28(sp)
80000570:	01812a03          	lw	s4,24(sp)
80000574:	01412a83          	lw	s5,20(sp)
80000578:	01012b03          	lw	s6,16(sp)
8000057c:	00c12b83          	lw	s7,12(sp)
80000580:	00812c03          	lw	s8,8(sp)
80000584:	00412c83          	lw	s9,4(sp)
80000588:	03010113          	addi	sp,sp,48
8000058c:	00008067          	ret
80000590:	010007b7          	lui	a5,0x1000
80000594:	01000a13          	li	s4,16
80000598:	ecf468e3          	bltu	s0,a5,80000468 <__udivdi3+0x1a8>
8000059c:	01800a13          	li	s4,24
800005a0:	ec9ff06f          	j	80000468 <__udivdi3+0x1a8>
800005a4:	00c41433          	sll	s0,s0,a2
800005a8:	00d4da33          	srl	s4,s1,a3
800005ac:	00cb19b3          	sll	s3,s6,a2
800005b0:	00db56b3          	srl	a3,s6,a3
800005b4:	01045b13          	srli	s6,s0,0x10
800005b8:	00c494b3          	sll	s1,s1,a2
800005bc:	000b0593          	mv	a1,s6
800005c0:	000a0513          	mv	a0,s4
800005c4:	0096eab3          	or	s5,a3,s1
800005c8:	3d0000ef          	jal	ra,80000998 <__umodsi3>
800005cc:	00050913          	mv	s2,a0
800005d0:	000b0593          	mv	a1,s6
800005d4:	000a0513          	mv	a0,s4
800005d8:	01041b93          	slli	s7,s0,0x10
800005dc:	374000ef          	jal	ra,80000950 <__udivsi3>
800005e0:	010bdb93          	srli	s7,s7,0x10
800005e4:	00050493          	mv	s1,a0
800005e8:	00050593          	mv	a1,a0
800005ec:	000b8513          	mv	a0,s7
800005f0:	2a4000ef          	jal	ra,80000894 <__mulsi3>
800005f4:	01091913          	slli	s2,s2,0x10
800005f8:	010ad713          	srli	a4,s5,0x10
800005fc:	00e96733          	or	a4,s2,a4
80000600:	00048a13          	mv	s4,s1
80000604:	00a77e63          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000608:	00870733          	add	a4,a4,s0
8000060c:	fff48a13          	addi	s4,s1,-1
80000610:	00876863          	bltu	a4,s0,80000620 <__udivdi3+0x360>
80000614:	00a77663          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000618:	ffe48a13          	addi	s4,s1,-2
8000061c:	00870733          	add	a4,a4,s0
80000620:	40a704b3          	sub	s1,a4,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	36c000ef          	jal	ra,80000998 <__umodsi3>
80000630:	00050913          	mv	s2,a0
80000634:	000b0593          	mv	a1,s6
80000638:	00048513          	mv	a0,s1
8000063c:	314000ef          	jal	ra,80000950 <__udivsi3>
80000640:	00050493          	mv	s1,a0
80000644:	00050593          	mv	a1,a0
80000648:	000b8513          	mv	a0,s7
8000064c:	248000ef          	jal	ra,80000894 <__mulsi3>
80000650:	010a9693          	slli	a3,s5,0x10
80000654:	01091913          	slli	s2,s2,0x10
80000658:	0106d693          	srli	a3,a3,0x10
8000065c:	00d967b3          	or	a5,s2,a3
80000660:	00048713          	mv	a4,s1
80000664:	00a7fe63          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000668:	008787b3          	add	a5,a5,s0
8000066c:	fff48713          	addi	a4,s1,-1
80000670:	0087e863          	bltu	a5,s0,80000680 <__udivdi3+0x3c0>
80000674:	00a7f663          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000678:	ffe48713          	addi	a4,s1,-2
8000067c:	008787b3          	add	a5,a5,s0
80000680:	010a1a13          	slli	s4,s4,0x10
80000684:	40a784b3          	sub	s1,a5,a0
80000688:	00ea6a33          	or	s4,s4,a4
8000068c:	e01ff06f          	j	8000048c <__udivdi3+0x1cc>
80000690:	1ed5ec63          	bltu	a1,a3,80000888 <__udivdi3+0x5c8>
80000694:	000107b7          	lui	a5,0x10
80000698:	04f6f463          	bgeu	a3,a5,800006e0 <__udivdi3+0x420>
8000069c:	0ff00593          	li	a1,255
800006a0:	00d5b533          	sltu	a0,a1,a3
800006a4:	00351513          	slli	a0,a0,0x3
800006a8:	00a6d733          	srl	a4,a3,a0
800006ac:	00006797          	auipc	a5,0x6
800006b0:	53878793          	addi	a5,a5,1336 # 80006be4 <__devconfig_end>
800006b4:	00e787b3          	add	a5,a5,a4
800006b8:	0007c583          	lbu	a1,0(a5)
800006bc:	02000a13          	li	s4,32
800006c0:	00a585b3          	add	a1,a1,a0
800006c4:	40ba0a33          	sub	s4,s4,a1
800006c8:	020a1663          	bnez	s4,800006f4 <__udivdi3+0x434>
800006cc:	00100793          	li	a5,1
800006d0:	e896e2e3          	bltu	a3,s1,80000554 <__udivdi3+0x294>
800006d4:	00cb3633          	sltu	a2,s6,a2
800006d8:	00164793          	xori	a5,a2,1
800006dc:	e79ff06f          	j	80000554 <__udivdi3+0x294>
800006e0:	010007b7          	lui	a5,0x1000
800006e4:	01000513          	li	a0,16
800006e8:	fcf6e0e3          	bltu	a3,a5,800006a8 <__udivdi3+0x3e8>
800006ec:	01800513          	li	a0,24
800006f0:	fb9ff06f          	j	800006a8 <__udivdi3+0x3e8>
800006f4:	00b65ab3          	srl	s5,a2,a1
800006f8:	014696b3          	sll	a3,a3,s4
800006fc:	00daeab3          	or	s5,s5,a3
80000700:	00b4d933          	srl	s2,s1,a1
80000704:	014497b3          	sll	a5,s1,s4
80000708:	00bb55b3          	srl	a1,s6,a1
8000070c:	010adb93          	srli	s7,s5,0x10
80000710:	00f5e4b3          	or	s1,a1,a5
80000714:	00090513          	mv	a0,s2
80000718:	000b8593          	mv	a1,s7
8000071c:	014619b3          	sll	s3,a2,s4
80000720:	278000ef          	jal	ra,80000998 <__umodsi3>
80000724:	00050413          	mv	s0,a0
80000728:	000b8593          	mv	a1,s7
8000072c:	00090513          	mv	a0,s2
80000730:	010a9c13          	slli	s8,s5,0x10
80000734:	21c000ef          	jal	ra,80000950 <__udivsi3>
80000738:	010c5c13          	srli	s8,s8,0x10
8000073c:	00050913          	mv	s2,a0
80000740:	00050593          	mv	a1,a0
80000744:	000c0513          	mv	a0,s8
80000748:	14c000ef          	jal	ra,80000894 <__mulsi3>
8000074c:	01041413          	slli	s0,s0,0x10
80000750:	0104d713          	srli	a4,s1,0x10
80000754:	00e46733          	or	a4,s0,a4
80000758:	00090c93          	mv	s9,s2
8000075c:	00a77e63          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000760:	01570733          	add	a4,a4,s5
80000764:	fff90c93          	addi	s9,s2,-1
80000768:	01576863          	bltu	a4,s5,80000778 <__udivdi3+0x4b8>
8000076c:	00a77663          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000770:	ffe90c93          	addi	s9,s2,-2
80000774:	01570733          	add	a4,a4,s5
80000778:	40a70933          	sub	s2,a4,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	214000ef          	jal	ra,80000998 <__umodsi3>
80000788:	00050413          	mv	s0,a0
8000078c:	000b8593          	mv	a1,s7
80000790:	00090513          	mv	a0,s2
80000794:	1bc000ef          	jal	ra,80000950 <__udivsi3>
80000798:	00050913          	mv	s2,a0
8000079c:	00050593          	mv	a1,a0
800007a0:	000c0513          	mv	a0,s8
800007a4:	0f0000ef          	jal	ra,80000894 <__mulsi3>
800007a8:	01049793          	slli	a5,s1,0x10
800007ac:	01041413          	slli	s0,s0,0x10
800007b0:	0107d793          	srli	a5,a5,0x10
800007b4:	00f46733          	or	a4,s0,a5
800007b8:	00090613          	mv	a2,s2
800007bc:	00a77e63          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007c0:	01570733          	add	a4,a4,s5
800007c4:	fff90613          	addi	a2,s2,-1
800007c8:	01576863          	bltu	a4,s5,800007d8 <__udivdi3+0x518>
800007cc:	00a77663          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007d0:	ffe90613          	addi	a2,s2,-2
800007d4:	01570733          	add	a4,a4,s5
800007d8:	010c9793          	slli	a5,s9,0x10
800007dc:	00010e37          	lui	t3,0x10
800007e0:	00c7e7b3          	or	a5,a5,a2
800007e4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007e8:	0107f333          	and	t1,a5,a6
800007ec:	0109f833          	and	a6,s3,a6
800007f0:	40a70733          	sub	a4,a4,a0
800007f4:	0107de93          	srli	t4,a5,0x10
800007f8:	0109d993          	srli	s3,s3,0x10
800007fc:	00030513          	mv	a0,t1
80000800:	00080593          	mv	a1,a6
80000804:	090000ef          	jal	ra,80000894 <__mulsi3>
80000808:	00050893          	mv	a7,a0
8000080c:	00098593          	mv	a1,s3
80000810:	00030513          	mv	a0,t1
80000814:	080000ef          	jal	ra,80000894 <__mulsi3>
80000818:	00050313          	mv	t1,a0
8000081c:	00080593          	mv	a1,a6
80000820:	000e8513          	mv	a0,t4
80000824:	070000ef          	jal	ra,80000894 <__mulsi3>
80000828:	00050813          	mv	a6,a0
8000082c:	00098593          	mv	a1,s3
80000830:	000e8513          	mv	a0,t4
80000834:	060000ef          	jal	ra,80000894 <__mulsi3>
80000838:	0108d693          	srli	a3,a7,0x10
8000083c:	01030333          	add	t1,t1,a6
80000840:	006686b3          	add	a3,a3,t1
80000844:	0106f463          	bgeu	a3,a6,8000084c <__udivdi3+0x58c>
80000848:	01c50533          	add	a0,a0,t3
8000084c:	0106d613          	srli	a2,a3,0x10
80000850:	00a60533          	add	a0,a2,a0
80000854:	02a76663          	bltu	a4,a0,80000880 <__udivdi3+0x5c0>
80000858:	bca714e3          	bne	a4,a0,80000420 <__udivdi3+0x160>
8000085c:	00010737          	lui	a4,0x10
80000860:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000864:	00e6f6b3          	and	a3,a3,a4
80000868:	01069693          	slli	a3,a3,0x10
8000086c:	00e8f8b3          	and	a7,a7,a4
80000870:	014b1633          	sll	a2,s6,s4
80000874:	011686b3          	add	a3,a3,a7
80000878:	00000a13          	li	s4,0
8000087c:	ccd67ce3          	bgeu	a2,a3,80000554 <__udivdi3+0x294>
80000880:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000884:	b9dff06f          	j	80000420 <__udivdi3+0x160>
80000888:	00000a13          	li	s4,0
8000088c:	00000793          	li	a5,0
80000890:	cc5ff06f          	j	80000554 <__udivdi3+0x294>

80000894 <__mulsi3>:
80000894:	00050613          	mv	a2,a0
80000898:	00000513          	li	a0,0
8000089c:	0015f693          	andi	a3,a1,1
800008a0:	00068463          	beqz	a3,800008a8 <__mulsi3+0x14>
800008a4:	00c50533          	add	a0,a0,a2
800008a8:	0015d593          	srli	a1,a1,0x1
800008ac:	00161613          	slli	a2,a2,0x1
800008b0:	fe0596e3          	bnez	a1,8000089c <__mulsi3+0x8>
800008b4:	00008067          	ret

800008b8 <__muldi3>:
800008b8:	ff010113          	addi	sp,sp,-16
800008bc:	00068313          	mv	t1,a3
800008c0:	00112623          	sw	ra,12(sp)
800008c4:	00050e13          	mv	t3,a0
800008c8:	00050893          	mv	a7,a0
800008cc:	00060693          	mv	a3,a2
800008d0:	00000713          	li	a4,0
800008d4:	00000793          	li	a5,0
800008d8:	00000813          	li	a6,0
800008dc:	0016f513          	andi	a0,a3,1
800008e0:	00171e93          	slli	t4,a4,0x1
800008e4:	00050c63          	beqz	a0,800008fc <__muldi3+0x44>
800008e8:	01088533          	add	a0,a7,a6
800008ec:	01053833          	sltu	a6,a0,a6
800008f0:	00e787b3          	add	a5,a5,a4
800008f4:	00f807b3          	add	a5,a6,a5
800008f8:	00050813          	mv	a6,a0
800008fc:	01f8d713          	srli	a4,a7,0x1f
80000900:	0016d693          	srli	a3,a3,0x1
80000904:	00eee733          	or	a4,t4,a4
80000908:	00189893          	slli	a7,a7,0x1
8000090c:	fc0698e3          	bnez	a3,800008dc <__muldi3+0x24>
80000910:	00058863          	beqz	a1,80000920 <__muldi3+0x68>
80000914:	00060513          	mv	a0,a2
80000918:	f7dff0ef          	jal	ra,80000894 <__mulsi3>
8000091c:	00a787b3          	add	a5,a5,a0
80000920:	00030a63          	beqz	t1,80000934 <__muldi3+0x7c>
80000924:	000e0513          	mv	a0,t3
80000928:	00030593          	mv	a1,t1
8000092c:	f69ff0ef          	jal	ra,80000894 <__mulsi3>
80000930:	00f507b3          	add	a5,a0,a5
80000934:	00c12083          	lw	ra,12(sp)
80000938:	00080513          	mv	a0,a6
8000093c:	00078593          	mv	a1,a5
80000940:	01010113          	addi	sp,sp,16
80000944:	00008067          	ret

80000948 <__divsi3>:
80000948:	06054063          	bltz	a0,800009a8 <__umodsi3+0x10>
8000094c:	0605c663          	bltz	a1,800009b8 <__umodsi3+0x20>

80000950 <__udivsi3>:
80000950:	00058613          	mv	a2,a1
80000954:	00050593          	mv	a1,a0
80000958:	fff00513          	li	a0,-1
8000095c:	02060c63          	beqz	a2,80000994 <__udivsi3+0x44>
80000960:	00100693          	li	a3,1
80000964:	00b67a63          	bgeu	a2,a1,80000978 <__udivsi3+0x28>
80000968:	00c05863          	blez	a2,80000978 <__udivsi3+0x28>
8000096c:	00161613          	slli	a2,a2,0x1
80000970:	00169693          	slli	a3,a3,0x1
80000974:	feb66ae3          	bltu	a2,a1,80000968 <__udivsi3+0x18>
80000978:	00000513          	li	a0,0
8000097c:	00c5e663          	bltu	a1,a2,80000988 <__udivsi3+0x38>
80000980:	40c585b3          	sub	a1,a1,a2
80000984:	00d56533          	or	a0,a0,a3
80000988:	0016d693          	srli	a3,a3,0x1
8000098c:	00165613          	srli	a2,a2,0x1
80000990:	fe0696e3          	bnez	a3,8000097c <__udivsi3+0x2c>
80000994:	00008067          	ret

80000998 <__umodsi3>:
80000998:	00008293          	mv	t0,ra
8000099c:	fb5ff0ef          	jal	ra,80000950 <__udivsi3>
800009a0:	00058513          	mv	a0,a1
800009a4:	00028067          	jr	t0
800009a8:	40a00533          	neg	a0,a0
800009ac:	0005d863          	bgez	a1,800009bc <__umodsi3+0x24>
800009b0:	40b005b3          	neg	a1,a1
800009b4:	f9dff06f          	j	80000950 <__udivsi3>
800009b8:	40b005b3          	neg	a1,a1
800009bc:	00008293          	mv	t0,ra
800009c0:	f91ff0ef          	jal	ra,80000950 <__udivsi3>
800009c4:	40a00533          	neg	a0,a0
800009c8:	00028067          	jr	t0

800009cc <__modsi3>:
800009cc:	00008293          	mv	t0,ra
800009d0:	0005ca63          	bltz	a1,800009e4 <__modsi3+0x18>
800009d4:	00054c63          	bltz	a0,800009ec <__modsi3+0x20>
800009d8:	f79ff0ef          	jal	ra,80000950 <__udivsi3>
800009dc:	00058513          	mv	a0,a1
800009e0:	00028067          	jr	t0
800009e4:	40b005b3          	neg	a1,a1
800009e8:	fe0558e3          	bgez	a0,800009d8 <__modsi3+0xc>
800009ec:	40a00533          	neg	a0,a0
800009f0:	f61ff0ef          	jal	ra,80000950 <__udivsi3>
800009f4:	40b00533          	neg	a0,a1
800009f8:	00028067          	jr	t0

800009fc <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009fc:	00008067          	ret

80000a00 <test_main>:
			 ztest_unit_test(test_fifo_get_fail),
			 ztest_unit_test(test_fifo_loop),
			 ztest_unit_test(test_fifo_cancel_wait),
			 ztest_unit_test(test_fifo_is_empty_thread),
			 ztest_unit_test(test_fifo_is_empty_isr));
	ztest_run_test_suite(fifo_api);
80000a00:	800085b7          	lui	a1,0x80008
80000a04:	80007537          	lui	a0,0x80007
80000a08:	bf458593          	addi	a1,a1,-1036 # 80007bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bf5>
80000a0c:	d9c50513          	addi	a0,a0,-612 # 80006d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d9d>
80000a10:	6300206f          	j	80003040 <z_ztest_run_test_suite>

80000a14 <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000a14:	fd010113          	addi	sp,sp,-48
80000a18:	00112e23          	sw	ra,28(sp)
80000a1c:	00812c23          	sw	s0,24(sp)
80000a20:	03012423          	sw	a6,40(sp)
80000a24:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000a28:	04051863          	bnez	a0,80000a78 <z_zassert.constprop.0+0x64>
80000a2c:	00068613          	mv	a2,a3
80000a30:	00058713          	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a34:	800076b7          	lui	a3,0x80007
80000a38:	800075b7          	lui	a1,0x80007
80000a3c:	80007537          	lui	a0,0x80007
80000a40:	da868693          	addi	a3,a3,-600 # 80006da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006da9>
80000a44:	00078413          	mv	s0,a5
80000a48:	e4c58593          	addi	a1,a1,-436 # 80006e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e4d>
		va_start(vargs, msg);
80000a4c:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a50:	e8050513          	addi	a0,a0,-384 # 80006e80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e81>
		va_start(vargs, msg);
80000a54:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a58:	62d010ef          	jal	ra,80002884 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000a5c:	00c12583          	lw	a1,12(sp)
80000a60:	00040513          	mv	a0,s0
80000a64:	5f1010ef          	jal	ra,80002854 <vprintk>
		printk("\n");
80000a68:	80007537          	lui	a0,0x80007
80000a6c:	33450513          	addi	a0,a0,820 # 80007334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007335>
80000a70:	615010ef          	jal	ra,80002884 <printk>
		va_end(vargs);
		ztest_test_fail();
80000a74:	59c020ef          	jal	ra,80003010 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000a78:	01c12083          	lw	ra,28(sp)
80000a7c:	01812403          	lw	s0,24(sp)
80000a80:	03010113          	addi	sp,sp,48
80000a84:	00008067          	ret

80000a88 <tfifo_thread_thread>:
	k_sleep(50);
	k_fifo_cancel_wait((struct k_fifo *)p1);
}

static void tfifo_thread_thread(struct k_fifo *pfifo)
{
80000a88:	fd010113          	addi	sp,sp,-48
80000a8c:	02912223          	sw	s1,36(sp)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_OBJECT_RELEASE, k_object_release, void *, object)

K_SYSCALL_DECLARE1(K_SYSCALL_K_OBJECT_ALLOC, k_object_alloc, void *, enum k_objects, otype)

K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000a90:	00050713          	mv	a4,a0
80000a94:	00050493          	mv	s1,a0
80000a98:	800016b7          	lui	a3,0x80001
80000a9c:	800085b7          	lui	a1,0x80008
80000aa0:	80008537          	lui	a0,0x80008
80000aa4:	00000893          	li	a7,0
80000aa8:	00000813          	li	a6,0
80000aac:	00000793          	li	a5,0
80000ab0:	b7068693          	addi	a3,a3,-1168 # 80000b70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b71>
80000ab4:	20000613          	li	a2,512
80000ab8:	11058593          	addi	a1,a1,272 # 80008110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008111>
80000abc:	00012223          	sw	zero,4(sp)
80000ac0:	00012023          	sw	zero,0(sp)
80000ac4:	d9050513          	addi	a0,a0,-624 # 80007d90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d91>
80000ac8:	02112623          	sw	ra,44(sp)
80000acc:	02812423          	sw	s0,40(sp)
80000ad0:	03212023          	sw	s2,32(sp)
80000ad4:	01312e23          	sw	s3,28(sp)
80000ad8:	779040ef          	jal	ra,80005a50 <z_impl_k_thread_create>
80000adc:	00050913          	mv	s2,a0

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)

K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000ae0:	351050ef          	jal	ra,80006630 <z_impl_k_uptime_get_32>

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_ALLOC_APPEND, k_queue_alloc_append, s32_t, struct k_queue *, queue, void *, data)

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_ALLOC_PREPEND, k_queue_alloc_prepend, s32_t, struct k_queue *, queue, void *, data)

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80000ae4:	1f400593          	li	a1,500
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000ae8:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80000aec:	00048513          	mv	a0,s1
80000af0:	7d1020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80000af4:	00050993          	mv	s3,a0
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000af8:	339050ef          	jal	ra,80006630 <z_impl_k_uptime_get_32>
	k_tid_t tid = k_thread_create(&thread, tstack, STACK_SIZE,
				      t_cancel_wait_entry, pfifo, NULL, NULL,
				      K_PRIO_PREEMPT(0), 0, 0);
	u32_t start_t = k_uptime_get_32();
	void *ret = k_fifo_get(pfifo, 500);
	u32_t dur = k_uptime_get_32() - start_t;
80000afc:	40850433          	sub	s0,a0,s0
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000b00:	00090513          	mv	a0,s2
80000b04:	0f0050ef          	jal	ra,80005bf4 <z_impl_k_thread_abort>
	 * that the test runner below will try to create another
	 * thread in the same stack space, then 1st thread returns
	 * from the call, leading to crash.
	 */
	k_thread_abort(tid);
	zassert_is_null(ret,
80000b08:	80007937          	lui	s2,0x80007
80000b0c:	800074b7          	lui	s1,0x80007
80000b10:	800077b7          	lui	a5,0x80007
80000b14:	800075b7          	lui	a1,0x80007
80000b18:	da890713          	addi	a4,s2,-600 # 80006da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006da9>
80000b1c:	e4c48613          	addi	a2,s1,-436 # 80006e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e4d>
80000b20:	0019b513          	seqz	a0,s3
80000b24:	dbc78793          	addi	a5,a5,-580 # 80006dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dbd>
80000b28:	02b00693          	li	a3,43
80000b2c:	dec58593          	addi	a1,a1,-532 # 80006dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ded>
80000b30:	ee5ff0ef          	jal	ra,80000a14 <z_zassert.constprop.0>
	/* 80 includes generous fuzz factor as k_sleep() will add an extra
	 * tick for non-tickless systems, and we may cross another tick
	 * boundary while doing this. We just want to ensure we didn't
	 * hit the timeout anyway.
	 */
	zassert_true(dur < 80,
80000b34:	05043513          	sltiu	a0,s0,80
		     "k_fifo_get didn't get cancelled in expected timeframe");
}
80000b38:	02812403          	lw	s0,40(sp)
80000b3c:	02c12083          	lw	ra,44(sp)
80000b40:	01c12983          	lw	s3,28(sp)
	zassert_true(dur < 80,
80000b44:	da890713          	addi	a4,s2,-600
80000b48:	e4c48613          	addi	a2,s1,-436
}
80000b4c:	02012903          	lw	s2,32(sp)
80000b50:	02412483          	lw	s1,36(sp)
	zassert_true(dur < 80,
80000b54:	800077b7          	lui	a5,0x80007
80000b58:	800075b7          	lui	a1,0x80007
80000b5c:	e0078793          	addi	a5,a5,-512 # 80006e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e01>
80000b60:	03200693          	li	a3,50
80000b64:	e3858593          	addi	a1,a1,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
}
80000b68:	03010113          	addi	sp,sp,48
	zassert_true(dur < 80,
80000b6c:	ea9ff06f          	j	80000a14 <z_zassert.constprop.0>

80000b70 <t_cancel_wait_entry>:
{
80000b70:	ff010113          	addi	sp,sp,-16
80000b74:	00812423          	sw	s0,8(sp)
80000b78:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000b7c:	03200513          	li	a0,50
80000b80:	00112623          	sw	ra,12(sp)
80000b84:	618040ef          	jal	ra,8000519c <z_impl_k_sleep>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_CANCEL_WAIT, k_queue_cancel_wait, struct k_queue *, queue)
80000b88:	00040513          	mv	a0,s0
}
80000b8c:	00812403          	lw	s0,8(sp)
80000b90:	00c12083          	lw	ra,12(sp)
80000b94:	01010113          	addi	sp,sp,16
80000b98:	4950206f          	j	8000382c <z_impl_k_queue_cancel_wait>

80000b9c <test_fifo_cancel_wait>:
 * @details This routine causes first thread pending on fifo (if any),
 * to return from k_fifo_get() with NULL value (as if timeout expired).
 * @see k_fifo_init(),k_fifo_get(), k_fifo_cancel_wait()
 */
void test_fifo_cancel_wait(void)
{
80000b9c:	ff010113          	addi	sp,sp,-16
80000ba0:	00812423          	sw	s0,8(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80000ba4:	80008437          	lui	s0,0x80008
80000ba8:	d7c40513          	addi	a0,s0,-644 # 80007d7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d7d>
80000bac:	00112623          	sw	ra,12(sp)
80000bb0:	461020ef          	jal	ra,80003810 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo_c);
	tfifo_thread_thread(&fifo_c);
80000bb4:	d7c40513          	addi	a0,s0,-644
80000bb8:	ed1ff0ef          	jal	ra,80000a88 <tfifo_thread_thread>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_thread(&kfifo_c);
}
80000bbc:	00812403          	lw	s0,8(sp)
80000bc0:	00c12083          	lw	ra,12(sp)
	tfifo_thread_thread(&kfifo_c);
80000bc4:	80008537          	lui	a0,0x80008
80000bc8:	d0850513          	addi	a0,a0,-760 # 80007d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d09>
}
80000bcc:	01010113          	addi	sp,sp,16
	tfifo_thread_thread(&kfifo_c);
80000bd0:	eb9ff06f          	j	80000a88 <tfifo_thread_thread>

80000bd4 <z_zassert.constprop.5>:
static inline void z_zassert(int cond,
80000bd4:	fd010113          	addi	sp,sp,-48
80000bd8:	00112e23          	sw	ra,28(sp)
80000bdc:	03012423          	sw	a6,40(sp)
80000be0:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
80000be4:	04051663          	bnez	a0,80000c30 <z_zassert.constprop.5+0x5c>
80000be8:	00068613          	mv	a2,a3
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000bec:	80007537          	lui	a0,0x80007
80000bf0:	00070693          	mv	a3,a4
80000bf4:	00058713          	mv	a4,a1
80000bf8:	800075b7          	lui	a1,0x80007
		va_start(vargs, msg);
80000bfc:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000c00:	03858593          	addi	a1,a1,56 # 80007038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007039>
80000c04:	e8050513          	addi	a0,a0,-384 # 80006e80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e81>
		va_start(vargs, msg);
80000c08:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000c0c:	479010ef          	jal	ra,80002884 <printk>
		vprintk(msg, vargs);
80000c10:	00c12583          	lw	a1,12(sp)
80000c14:	80007537          	lui	a0,0x80007
80000c18:	23450513          	addi	a0,a0,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80000c1c:	439010ef          	jal	ra,80002854 <vprintk>
		printk("\n");
80000c20:	80007537          	lui	a0,0x80007
80000c24:	33450513          	addi	a0,a0,820 # 80007334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007335>
80000c28:	45d010ef          	jal	ra,80002884 <printk>
		ztest_test_fail();
80000c2c:	3e4020ef          	jal	ra,80003010 <ztest_test_fail>
}
80000c30:	01c12083          	lw	ra,28(sp)
80000c34:	03010113          	addi	sp,sp,48
80000c38:	00008067          	ret

80000c3c <tfifo_get>:
	sys_slist_append(&slist, (sys_snode_t *)&(data_sl[1].snode));
	k_fifo_put_slist(pfifo, &slist);
}

static void tfifo_get(struct k_fifo *pfifo)
{
80000c3c:	fe010113          	addi	sp,sp,-32
80000c40:	00812c23          	sw	s0,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80000c44:	00000593          	li	a1,0

	/*get fifo data from "fifo_put"*/
	for (int i = 0; i < LIST_LEN; i++) {
		/**TESTPOINT: fifo get*/
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data[i], NULL);
80000c48:	80008437          	lui	s0,0x80008
{
80000c4c:	00112e23          	sw	ra,28(sp)
80000c50:	00912a23          	sw	s1,20(sp)
80000c54:	01212823          	sw	s2,16(sp)
80000c58:	01312623          	sw	s3,12(sp)
80000c5c:	01412423          	sw	s4,8(sp)
80000c60:	01512223          	sw	s5,4(sp)
80000c64:	00050a13          	mv	s4,a0
		zassert_equal(rx_data, (void *)&data[i], NULL);
80000c68:	e0040413          	addi	s0,s0,-512 # 80007e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e01>
80000c6c:	655020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80000c70:	80007937          	lui	s2,0x80007
80000c74:	800079b7          	lui	s3,0x80007
80000c78:	800074b7          	lui	s1,0x80007
80000c7c:	80007ab7          	lui	s5,0x80007
80000c80:	40850533          	sub	a0,a0,s0
80000c84:	23498793          	addi	a5,s3,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80000c88:	ea890713          	addi	a4,s2,-344 # 80006ea8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea9>
80000c8c:	03848613          	addi	a2,s1,56 # 80007038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007039>
80000c90:	03600693          	li	a3,54
80000c94:	f7ca8593          	addi	a1,s5,-132 # 80006f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f7d>
80000c98:	00153513          	seqz	a0,a0
80000c9c:	f39ff0ef          	jal	ra,80000bd4 <z_zassert.constprop.5>
80000ca0:	00000593          	li	a1,0
80000ca4:	000a0513          	mv	a0,s4
80000ca8:	619020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80000cac:	00840413          	addi	s0,s0,8
80000cb0:	40850533          	sub	a0,a0,s0
80000cb4:	23498793          	addi	a5,s3,564
80000cb8:	ea890713          	addi	a4,s2,-344
80000cbc:	03848613          	addi	a2,s1,56
80000cc0:	03600693          	li	a3,54
80000cc4:	f7ca8593          	addi	a1,s5,-132
80000cc8:	00153513          	seqz	a0,a0
80000ccc:	f09ff0ef          	jal	ra,80000bd4 <z_zassert.constprop.5>
80000cd0:	00000593          	li	a1,0
80000cd4:	000a0513          	mv	a0,s4
	}
	/*get fifo data from "fifo_put_list"*/
	for (int i = 0; i < LIST_LEN; i++) {
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data_l[i], NULL);
80000cd8:	80008437          	lui	s0,0x80008
80000cdc:	5e5020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80000ce0:	e1040413          	addi	s0,s0,-496 # 80007e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e11>
80000ce4:	80007ab7          	lui	s5,0x80007
80000ce8:	40850533          	sub	a0,a0,s0
80000cec:	23498793          	addi	a5,s3,564
80000cf0:	ea890713          	addi	a4,s2,-344
80000cf4:	03848613          	addi	a2,s1,56
80000cf8:	03b00693          	li	a3,59
80000cfc:	fa4a8593          	addi	a1,s5,-92 # 80006fa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fa5>
80000d00:	00153513          	seqz	a0,a0
80000d04:	ed1ff0ef          	jal	ra,80000bd4 <z_zassert.constprop.5>
80000d08:	00000593          	li	a1,0
80000d0c:	000a0513          	mv	a0,s4
80000d10:	5b1020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80000d14:	00840413          	addi	s0,s0,8
80000d18:	40850533          	sub	a0,a0,s0
80000d1c:	23498793          	addi	a5,s3,564
80000d20:	ea890713          	addi	a4,s2,-344
80000d24:	03848613          	addi	a2,s1,56
80000d28:	03b00693          	li	a3,59
80000d2c:	fa4a8593          	addi	a1,s5,-92
80000d30:	00153513          	seqz	a0,a0
80000d34:	ea1ff0ef          	jal	ra,80000bd4 <z_zassert.constprop.5>
80000d38:	00000593          	li	a1,0
80000d3c:	000a0513          	mv	a0,s4
	}
	/*get fifo data from "fifo_put_slist"*/
	for (int i = 0; i < LIST_LEN; i++) {
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000d40:	80008437          	lui	s0,0x80008
80000d44:	57d020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80000d48:	e2040413          	addi	s0,s0,-480 # 80007e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e21>
80000d4c:	80007ab7          	lui	s5,0x80007
80000d50:	40850533          	sub	a0,a0,s0
80000d54:	23498793          	addi	a5,s3,564
80000d58:	ea890713          	addi	a4,s2,-344
80000d5c:	03848613          	addi	a2,s1,56
80000d60:	04000693          	li	a3,64
80000d64:	fcca8593          	addi	a1,s5,-52 # 80006fcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fcd>
80000d68:	00153513          	seqz	a0,a0
80000d6c:	e69ff0ef          	jal	ra,80000bd4 <z_zassert.constprop.5>
80000d70:	00000593          	li	a1,0
80000d74:	000a0513          	mv	a0,s4
80000d78:	549020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80000d7c:	00840413          	addi	s0,s0,8
80000d80:	40850533          	sub	a0,a0,s0
	}
}
80000d84:	01812403          	lw	s0,24(sp)
80000d88:	01c12083          	lw	ra,28(sp)
80000d8c:	00812a03          	lw	s4,8(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000d90:	23498793          	addi	a5,s3,564
80000d94:	ea890713          	addi	a4,s2,-344
}
80000d98:	00c12983          	lw	s3,12(sp)
80000d9c:	01012903          	lw	s2,16(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000da0:	03848613          	addi	a2,s1,56
80000da4:	fcca8593          	addi	a1,s5,-52
}
80000da8:	01412483          	lw	s1,20(sp)
80000dac:	00412a83          	lw	s5,4(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000db0:	04000693          	li	a3,64
80000db4:	00153513          	seqz	a0,a0
}
80000db8:	02010113          	addi	sp,sp,32
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000dbc:	e19ff06f          	j	80000bd4 <z_zassert.constprop.5>

80000dc0 <tIsr_entry_get>:
	tfifo_put((struct k_fifo *)p);
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
}

static void tIsr_entry_get(void *p)
{
80000dc0:	ff010113          	addi	sp,sp,-16
80000dc4:	00812423          	sw	s0,8(sp)
80000dc8:	00112623          	sw	ra,12(sp)
80000dcc:	00050413          	mv	s0,a0
	tfifo_get((struct k_fifo *)p);
80000dd0:	e6dff0ef          	jal	ra,80000c3c <tfifo_get>
 *
 * @return a boolean, true if it's empty, false otherwise
 */
static inline bool sys_sflist_is_empty(sys_sflist_t *list);

Z_GENLIST_IS_EMPTY(sflist)
80000dd4:	00042503          	lw	a0,0(s0)
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
}
80000dd8:	00812403          	lw	s0,8(sp)
80000ddc:	00c12083          	lw	ra,12(sp)
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000de0:	800077b7          	lui	a5,0x80007
80000de4:	80007737          	lui	a4,0x80007
80000de8:	80007637          	lui	a2,0x80007
80000dec:	800075b7          	lui	a1,0x80007
80000df0:	23478793          	addi	a5,a5,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80000df4:	ec470713          	addi	a4,a4,-316 # 80006ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec5>
80000df8:	04e00693          	li	a3,78
80000dfc:	03860613          	addi	a2,a2,56 # 80007038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007039>
80000e00:	f0058593          	addi	a1,a1,-256 # 80006f00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f01>
80000e04:	00153513          	seqz	a0,a0
}
80000e08:	01010113          	addi	sp,sp,16
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000e0c:	dc9ff06f          	j	80000bd4 <z_zassert.constprop.5>

80000e10 <tThread_entry>:

static void tThread_entry(void *p1, void *p2, void *p3)
{
80000e10:	ff010113          	addi	sp,sp,-16
80000e14:	00112623          	sw	ra,12(sp)
	tfifo_get((struct k_fifo *)p1);
80000e18:	e25ff0ef          	jal	ra,80000c3c <tfifo_get>
	k_sem_give(&end_sema);
}
80000e1c:	00c12083          	lw	ra,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000e20:	80008537          	lui	a0,0x80008
80000e24:	e3050513          	addi	a0,a0,-464 # 80007e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e31>
80000e28:	01010113          	addi	sp,sp,16
80000e2c:	6840406f          	j	800054b0 <z_impl_k_sem_give>

80000e30 <tfifo_thread_isr>:
	k_sem_take(&end_sema, K_FOREVER);
	k_thread_abort(tid);
}

static void tfifo_thread_isr(struct k_fifo *pfifo)
{
80000e30:	ff010113          	addi	sp,sp,-16
80000e34:	00812423          	sw	s0,8(sp)
80000e38:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000e3c:	80008537          	lui	a0,0x80008
80000e40:	00100613          	li	a2,1
80000e44:	00000593          	li	a1,0
80000e48:	e3050513          	addi	a0,a0,-464 # 80007e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e31>
80000e4c:	00112623          	sw	ra,12(sp)
80000e50:	598040ef          	jal	ra,800053e8 <z_impl_k_sem_init>
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: isr-thread data passing via fifo*/
	irq_offload(tIsr_entry_put, pfifo);
80000e54:	80001537          	lui	a0,0x80001
80000e58:	00040593          	mv	a1,s0
80000e5c:	f0450513          	addi	a0,a0,-252 # 80000f04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000f05>
80000e60:	255000ef          	jal	ra,800018b4 <irq_offload>
	tfifo_get(pfifo);
80000e64:	00040513          	mv	a0,s0
}
80000e68:	00812403          	lw	s0,8(sp)
80000e6c:	00c12083          	lw	ra,12(sp)
80000e70:	01010113          	addi	sp,sp,16
	tfifo_get(pfifo);
80000e74:	dc9ff06f          	j	80000c3c <tfifo_get>

80000e78 <tfifo_put>:
{
80000e78:	fe010113          	addi	sp,sp,-32
		k_fifo_put(pfifo, (void *)&data[i]);
80000e7c:	800085b7          	lui	a1,0x80008
{
80000e80:	00912a23          	sw	s1,20(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
80000e84:	e0058493          	addi	s1,a1,-512 # 80007e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e01>
80000e88:	e0058593          	addi	a1,a1,-512
{
80000e8c:	00112e23          	sw	ra,28(sp)
80000e90:	00812c23          	sw	s0,24(sp)
80000e94:	00050413          	mv	s0,a0
		k_fifo_put(pfifo, (void *)&data[i]);
80000e98:	245020ef          	jal	ra,800038dc <k_queue_append>
80000e9c:	00848593          	addi	a1,s1,8
80000ea0:	00040513          	mv	a0,s0
80000ea4:	239020ef          	jal	ra,800038dc <k_queue_append>
	head->snode.next = (sys_snode_t *)tail;
80000ea8:	800085b7          	lui	a1,0x80008
80000eac:	e1058793          	addi	a5,a1,-496 # 80007e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e11>
80000eb0:	00878613          	addi	a2,a5,8
80000eb4:	00c7a023          	sw	a2,0(a5)
	k_fifo_put_list(pfifo, (u32_t *)head, (u32_t *)tail);
80000eb8:	00040513          	mv	a0,s0
	tail->snode.next = NULL;
80000ebc:	0007a423          	sw	zero,8(a5)
	k_fifo_put_list(pfifo, (u32_t *)head, (u32_t *)tail);
80000ec0:	e1058593          	addi	a1,a1,-496
80000ec4:	229020ef          	jal	ra,800038ec <k_queue_append_list>
	parent->next = child;
}

static inline void z_slist_head_set(sys_slist_t *list, sys_snode_t *node)
{
	list->head = node;
80000ec8:	800087b7          	lui	a5,0x80008
80000ecc:	e2078793          	addi	a5,a5,-480 # 80007e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e21>
	parent->next = child;
80000ed0:	00878713          	addi	a4,a5,8
	k_fifo_put_slist(pfifo, &slist);
80000ed4:	00810593          	addi	a1,sp,8
80000ed8:	00040513          	mv	a0,s0
80000edc:	0007a423          	sw	zero,8(a5)
80000ee0:	00e7a023          	sw	a4,0(a5)
	list->head = node;
80000ee4:	00f12423          	sw	a5,8(sp)
}

static inline void z_slist_tail_set(sys_slist_t *list, sys_snode_t *node)
{
	list->tail = node;
80000ee8:	00e12623          	sw	a4,12(sp)
80000eec:	349020ef          	jal	ra,80003a34 <k_queue_merge_slist>
}
80000ef0:	01c12083          	lw	ra,28(sp)
80000ef4:	01812403          	lw	s0,24(sp)
80000ef8:	01412483          	lw	s1,20(sp)
80000efc:	02010113          	addi	sp,sp,32
80000f00:	00008067          	ret

80000f04 <tIsr_entry_put>:
{
80000f04:	ff010113          	addi	sp,sp,-16
80000f08:	00812423          	sw	s0,8(sp)
80000f0c:	00112623          	sw	ra,12(sp)
80000f10:	00050413          	mv	s0,a0
	tfifo_put((struct k_fifo *)p);
80000f14:	f65ff0ef          	jal	ra,80000e78 <tfifo_put>
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000f18:	00042503          	lw	a0,0(s0)
}
80000f1c:	00812403          	lw	s0,8(sp)
80000f20:	00c12083          	lw	ra,12(sp)
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000f24:	800077b7          	lui	a5,0x80007
80000f28:	80007737          	lui	a4,0x80007
80000f2c:	80007637          	lui	a2,0x80007
80000f30:	800075b7          	lui	a1,0x80007
80000f34:	23478793          	addi	a5,a5,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80000f38:	eb470713          	addi	a4,a4,-332 # 80006eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb5>
80000f3c:	04800693          	li	a3,72
80000f40:	03860613          	addi	a2,a2,56 # 80007038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007039>
80000f44:	f3058593          	addi	a1,a1,-208 # 80006f30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f31>
80000f48:	00a03533          	snez	a0,a0
}
80000f4c:	01010113          	addi	sp,sp,16
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000f50:	c85ff06f          	j	80000bd4 <z_zassert.constprop.5>

80000f54 <tfifo_is_empty>:
	tfifo_put(pfifo);
	irq_offload(tIsr_entry_get, pfifo);
}

static void tfifo_is_empty(void *p)
{
80000f54:	fe010113          	addi	sp,sp,-32
80000f58:	01412423          	sw	s4,8(sp)
	struct k_fifo *pfifo = (struct k_fifo *)p;

	tfifo_put(&fifo);
80000f5c:	80008a37          	lui	s4,0x80008
{
80000f60:	01312623          	sw	s3,12(sp)
80000f64:	00050993          	mv	s3,a0
	tfifo_put(&fifo);
80000f68:	e40a0513          	addi	a0,s4,-448 # 80007e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e41>
{
80000f6c:	00112e23          	sw	ra,28(sp)
80000f70:	00812c23          	sw	s0,24(sp)
80000f74:	00912a23          	sw	s1,20(sp)
80000f78:	01212823          	sw	s2,16(sp)
	tfifo_put(&fifo);
80000f7c:	efdff0ef          	jal	ra,80000e78 <tfifo_put>
	/**TESTPOINT: return false when data available*/
	zassert_false(k_fifo_is_empty(pfifo), NULL);
80000f80:	0009a503          	lw	a0,0(s3)
80000f84:	800074b7          	lui	s1,0x80007
80000f88:	80007937          	lui	s2,0x80007
80000f8c:	80007437          	lui	s0,0x80007
80000f90:	800075b7          	lui	a1,0x80007
80000f94:	23490793          	addi	a5,s2,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80000f98:	ed448713          	addi	a4,s1,-300 # 80006ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed5>
80000f9c:	03840613          	addi	a2,s0,56 # 80007038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007039>
80000fa0:	07900693          	li	a3,121
80000fa4:	ff858593          	addi	a1,a1,-8 # 80006ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ff9>
80000fa8:	00a03533          	snez	a0,a0
80000fac:	c29ff0ef          	jal	ra,80000bd4 <z_zassert.constprop.5>

	tfifo_get(&fifo);
80000fb0:	e40a0513          	addi	a0,s4,-448
80000fb4:	c89ff0ef          	jal	ra,80000c3c <tfifo_get>
80000fb8:	0009a503          	lw	a0,0(s3)
	/**TESTPOINT: return true with data unavailable*/
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000fbc:	03840613          	addi	a2,s0,56
}
80000fc0:	01812403          	lw	s0,24(sp)
80000fc4:	01c12083          	lw	ra,28(sp)
80000fc8:	00c12983          	lw	s3,12(sp)
80000fcc:	00812a03          	lw	s4,8(sp)
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000fd0:	23490793          	addi	a5,s2,564
80000fd4:	ed448713          	addi	a4,s1,-300
}
80000fd8:	01012903          	lw	s2,16(sp)
80000fdc:	01412483          	lw	s1,20(sp)
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000fe0:	800075b7          	lui	a1,0x80007
80000fe4:	07d00693          	li	a3,125
80000fe8:	01858593          	addi	a1,a1,24 # 80007018 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007019>
80000fec:	00153513          	seqz	a0,a0
}
80000ff0:	02010113          	addi	sp,sp,32
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000ff4:	be1ff06f          	j	80000bd4 <z_zassert.constprop.5>

80000ff8 <tfifo_thread_thread>:
{
80000ff8:	fe010113          	addi	sp,sp,-32
80000ffc:	00812c23          	sw	s0,24(sp)
80001000:	80008437          	lui	s0,0x80008
80001004:	00912a23          	sw	s1,20(sp)
80001008:	00100613          	li	a2,1
8000100c:	00050493          	mv	s1,a0
80001010:	00000593          	li	a1,0
80001014:	e3040513          	addi	a0,s0,-464 # 80007e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e31>
80001018:	00112e23          	sw	ra,28(sp)
8000101c:	01212823          	sw	s2,16(sp)
80001020:	3c8040ef          	jal	ra,800053e8 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001024:	800016b7          	lui	a3,0x80001
80001028:	800085b7          	lui	a1,0x80008
8000102c:	80008537          	lui	a0,0x80008
80001030:	00048713          	mv	a4,s1
80001034:	00000893          	li	a7,0
80001038:	00000813          	li	a6,0
8000103c:	00000793          	li	a5,0
80001040:	e1068693          	addi	a3,a3,-496 # 80000e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000e11>
80001044:	20000613          	li	a2,512
80001048:	31058593          	addi	a1,a1,784 # 80008310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008311>
8000104c:	00012223          	sw	zero,4(sp)
80001050:	00012023          	sw	zero,0(sp)
80001054:	e5450513          	addi	a0,a0,-428 # 80007e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e55>
80001058:	1f9040ef          	jal	ra,80005a50 <z_impl_k_thread_create>
8000105c:	00050913          	mv	s2,a0
	tfifo_put(pfifo);
80001060:	00048513          	mv	a0,s1
80001064:	e15ff0ef          	jal	ra,80000e78 <tfifo_put>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001068:	e3040513          	addi	a0,s0,-464
8000106c:	fff00593          	li	a1,-1
80001070:	524040ef          	jal	ra,80005594 <z_impl_k_sem_take>
}
80001074:	01812403          	lw	s0,24(sp)
80001078:	01c12083          	lw	ra,28(sp)
8000107c:	01412483          	lw	s1,20(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001080:	00090513          	mv	a0,s2
80001084:	01012903          	lw	s2,16(sp)
80001088:	02010113          	addi	sp,sp,32
8000108c:	3690406f          	j	80005bf4 <z_impl_k_thread_abort>

80001090 <tfifo_isr_thread>:
{
80001090:	ff010113          	addi	sp,sp,-16
80001094:	00812423          	sw	s0,8(sp)
80001098:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
8000109c:	80008537          	lui	a0,0x80008
800010a0:	00000593          	li	a1,0
800010a4:	00100613          	li	a2,1
800010a8:	e3050513          	addi	a0,a0,-464 # 80007e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e31>
800010ac:	00112623          	sw	ra,12(sp)
800010b0:	338040ef          	jal	ra,800053e8 <z_impl_k_sem_init>
	tfifo_put(pfifo);
800010b4:	00040513          	mv	a0,s0
800010b8:	dc1ff0ef          	jal	ra,80000e78 <tfifo_put>
	irq_offload(tIsr_entry_get, pfifo);
800010bc:	00040593          	mv	a1,s0
}
800010c0:	00812403          	lw	s0,8(sp)
800010c4:	00c12083          	lw	ra,12(sp)
	irq_offload(tIsr_entry_get, pfifo);
800010c8:	80001537          	lui	a0,0x80001
800010cc:	dc050513          	addi	a0,a0,-576 # 80000dc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000dc1>
}
800010d0:	01010113          	addi	sp,sp,16
	irq_offload(tIsr_entry_get, pfifo);
800010d4:	7e00006f          	j	800018b4 <irq_offload>

800010d8 <test_fifo_thread2thread>:
/**
 * @brief Test thread to thread data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get(), k_fifo_put_list()
 */
void test_fifo_thread2thread(void)
{
800010d8:	ff010113          	addi	sp,sp,-16
800010dc:	00812423          	sw	s0,8(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
800010e0:	80008437          	lui	s0,0x80008
800010e4:	e4040513          	addi	a0,s0,-448 # 80007e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e41>
800010e8:	00112623          	sw	ra,12(sp)
800010ec:	724020ef          	jal	ra,80003810 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo);
	tfifo_thread_thread(&fifo);
800010f0:	e4040513          	addi	a0,s0,-448
800010f4:	f05ff0ef          	jal	ra,80000ff8 <tfifo_thread_thread>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_thread(&kfifo);
}
800010f8:	00812403          	lw	s0,8(sp)
800010fc:	00c12083          	lw	ra,12(sp)
	tfifo_thread_thread(&kfifo);
80001100:	80008537          	lui	a0,0x80008
80001104:	d1c50513          	addi	a0,a0,-740 # 80007d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d1d>
}
80001108:	01010113          	addi	sp,sp,16
	tfifo_thread_thread(&kfifo);
8000110c:	eedff06f          	j	80000ff8 <tfifo_thread_thread>

80001110 <test_fifo_thread2isr>:
/**
 * @brief Test isr to thread data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_thread2isr(void)
{
80001110:	ff010113          	addi	sp,sp,-16
80001114:	00812423          	sw	s0,8(sp)
80001118:	80008437          	lui	s0,0x80008
8000111c:	e4040513          	addi	a0,s0,-448 # 80007e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e41>
80001120:	00112623          	sw	ra,12(sp)
80001124:	6ec020ef          	jal	ra,80003810 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo);
	tfifo_thread_isr(&fifo);
80001128:	e4040513          	addi	a0,s0,-448
8000112c:	d05ff0ef          	jal	ra,80000e30 <tfifo_thread_isr>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_isr(&kfifo);
}
80001130:	00812403          	lw	s0,8(sp)
80001134:	00c12083          	lw	ra,12(sp)
	tfifo_thread_isr(&kfifo);
80001138:	80008537          	lui	a0,0x80008
8000113c:	d1c50513          	addi	a0,a0,-740 # 80007d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d1d>
}
80001140:	01010113          	addi	sp,sp,16
	tfifo_thread_isr(&kfifo);
80001144:	cedff06f          	j	80000e30 <tfifo_thread_isr>

80001148 <test_fifo_isr2thread>:
/**
 * @brief Test thread to isr data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_isr2thread(void)
{
80001148:	ff010113          	addi	sp,sp,-16
8000114c:	00812423          	sw	s0,8(sp)
80001150:	80008437          	lui	s0,0x80008
80001154:	e4040513          	addi	a0,s0,-448 # 80007e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e41>
80001158:	00112623          	sw	ra,12(sp)
8000115c:	6b4020ef          	jal	ra,80003810 <z_impl_k_queue_init>
	/**TESTPOINT: test k_fifo_init fifo*/
	k_fifo_init(&fifo);
	tfifo_isr_thread(&fifo);
80001160:	e4040513          	addi	a0,s0,-448
80001164:	f2dff0ef          	jal	ra,80001090 <tfifo_isr_thread>

	/**TESTPOINT: test K_FIFO_DEFINE fifo*/
	tfifo_isr_thread(&kfifo);
}
80001168:	00812403          	lw	s0,8(sp)
8000116c:	00c12083          	lw	ra,12(sp)
	tfifo_isr_thread(&kfifo);
80001170:	80008537          	lui	a0,0x80008
80001174:	d1c50513          	addi	a0,a0,-740 # 80007d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d1d>
}
80001178:	01010113          	addi	sp,sp,16
	tfifo_isr_thread(&kfifo);
8000117c:	f15ff06f          	j	80001090 <tfifo_isr_thread>

80001180 <test_fifo_is_empty_thread>:
/**
 * @brief Test empty fifo
 * @see k_fifo_init(), k_fifo_is_empty(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_is_empty_thread(void)
{
80001180:	ff010113          	addi	sp,sp,-16
80001184:	00812423          	sw	s0,8(sp)
80001188:	80008437          	lui	s0,0x80008
8000118c:	e4040513          	addi	a0,s0,-448 # 80007e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e41>
80001190:	00112623          	sw	ra,12(sp)
80001194:	00912223          	sw	s1,4(sp)
80001198:	678020ef          	jal	ra,80003810 <z_impl_k_queue_init>
8000119c:	e4040493          	addi	s1,s0,-448
800011a0:	0004a503          	lw	a0,0(s1)
	k_fifo_init(&fifo);
	/**TESTPOINT: k_fifo_is_empty after init*/
	zassert_true(k_fifo_is_empty(&fifo), NULL);
800011a4:	800077b7          	lui	a5,0x80007
800011a8:	80007737          	lui	a4,0x80007
800011ac:	80007637          	lui	a2,0x80007
800011b0:	800075b7          	lui	a1,0x80007
800011b4:	00153513          	seqz	a0,a0
800011b8:	23478793          	addi	a5,a5,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
800011bc:	ee470713          	addi	a4,a4,-284 # 80006ee4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ee5>
800011c0:	0b700693          	li	a3,183
800011c4:	03860613          	addi	a2,a2,56 # 80007038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007039>
800011c8:	f5c58593          	addi	a1,a1,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800011cc:	a09ff0ef          	jal	ra,80000bd4 <z_zassert.constprop.5>

	/**TESTPONT: check fifo is empty from thread*/
	tfifo_is_empty(&fifo);
800011d0:	e4040513          	addi	a0,s0,-448
}
800011d4:	00812403          	lw	s0,8(sp)
800011d8:	00c12083          	lw	ra,12(sp)
800011dc:	00412483          	lw	s1,4(sp)
800011e0:	01010113          	addi	sp,sp,16
	tfifo_is_empty(&fifo);
800011e4:	d71ff06f          	j	80000f54 <tfifo_is_empty>

800011e8 <test_fifo_is_empty_isr>:
/**
 * @brief Test empty fifo in interrupt context
 * @see k_fifo_init(), fifo_is_empty(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_is_empty_isr(void)
{
800011e8:	ff010113          	addi	sp,sp,-16
800011ec:	00812423          	sw	s0,8(sp)
800011f0:	80008437          	lui	s0,0x80008
800011f4:	e4040513          	addi	a0,s0,-448 # 80007e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e41>
800011f8:	00112623          	sw	ra,12(sp)
800011fc:	614020ef          	jal	ra,80003810 <z_impl_k_queue_init>
	k_fifo_init(&fifo);
	/**TESTPOINT: check fifo is empty from isr*/
	irq_offload(tfifo_is_empty, &fifo);
80001200:	e4040593          	addi	a1,s0,-448
}
80001204:	00812403          	lw	s0,8(sp)
80001208:	00c12083          	lw	ra,12(sp)
	irq_offload(tfifo_is_empty, &fifo);
8000120c:	80001537          	lui	a0,0x80001
80001210:	f5450513          	addi	a0,a0,-172 # 80000f54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000f55>
}
80001214:	01010113          	addi	sp,sp,16
	irq_offload(tfifo_is_empty, &fifo);
80001218:	69c0006f          	j	800018b4 <irq_offload>

8000121c <z_zassert.constprop.0>:
static inline void z_zassert(int cond,
8000121c:	fd010113          	addi	sp,sp,-48
80001220:	00112e23          	sw	ra,28(sp)
80001224:	03012423          	sw	a6,40(sp)
80001228:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
8000122c:	04051863          	bnez	a0,8000127c <z_zassert.constprop.0+0x60>
80001230:	00068613          	mv	a2,a3
80001234:	00058713          	mv	a4,a1
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80001238:	800076b7          	lui	a3,0x80007
8000123c:	800075b7          	lui	a1,0x80007
80001240:	80007537          	lui	a0,0x80007
		va_start(vargs, msg);
80001244:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80001248:	07068693          	addi	a3,a3,112 # 80007070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007071>
8000124c:	0d858593          	addi	a1,a1,216 # 800070d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070d9>
80001250:	e8050513          	addi	a0,a0,-384 # 80006e80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e81>
		va_start(vargs, msg);
80001254:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80001258:	62c010ef          	jal	ra,80002884 <printk>
		vprintk(msg, vargs);
8000125c:	00c12583          	lw	a1,12(sp)
80001260:	80007537          	lui	a0,0x80007
80001264:	23450513          	addi	a0,a0,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80001268:	5ec010ef          	jal	ra,80002854 <vprintk>
		printk("\n");
8000126c:	80007537          	lui	a0,0x80007
80001270:	33450513          	addi	a0,a0,820 # 80007334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007335>
80001274:	610010ef          	jal	ra,80002884 <printk>
		ztest_test_fail();
80001278:	599010ef          	jal	ra,80003010 <ztest_test_fail>
}
8000127c:	01c12083          	lw	ra,28(sp)
80001280:	03010113          	addi	sp,sp,48
80001284:	00008067          	ret

80001288 <test_fifo_get_fail>:
 * @details test zephyr fifo_get when no data to read,
 * it should returns NULL.
 * @see k_fifo_init(), k_fifo_get()
 */
void test_fifo_get_fail(void *p1, void *p2, void *p3)
{
80001288:	fd010113          	addi	sp,sp,-48
8000128c:	00c10513          	addi	a0,sp,12
80001290:	02112623          	sw	ra,44(sp)
80001294:	02812423          	sw	s0,40(sp)
80001298:	02912223          	sw	s1,36(sp)
8000129c:	03212023          	sw	s2,32(sp)
800012a0:	570020ef          	jal	ra,80003810 <z_impl_k_queue_init>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
800012a4:	00000593          	li	a1,0
800012a8:	00c10513          	addi	a0,sp,12
800012ac:	015020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
	struct k_fifo fifo;

	k_fifo_init(&fifo);
	/**TESTPOINT: fifo get returns NULL*/
	zassert_is_null(k_fifo_get(&fifo, K_NO_WAIT), NULL);
800012b0:	800074b7          	lui	s1,0x80007
800012b4:	80007937          	lui	s2,0x80007
800012b8:	80007437          	lui	s0,0x80007
800012bc:	800075b7          	lui	a1,0x80007
800012c0:	23490793          	addi	a5,s2,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
800012c4:	07048713          	addi	a4,s1,112 # 80007070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007071>
800012c8:	0d840613          	addi	a2,s0,216 # 800070d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070d9>
800012cc:	01c00693          	li	a3,28
800012d0:	08458593          	addi	a1,a1,132 # 80007084 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007085>
800012d4:	00153513          	seqz	a0,a0
800012d8:	f45ff0ef          	jal	ra,8000121c <z_zassert.constprop.0>
800012dc:	06400593          	li	a1,100
800012e0:	00c10513          	addi	a0,sp,12
800012e4:	7dc020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
	zassert_is_null(k_fifo_get(&fifo, TIMEOUT), NULL);
800012e8:	800075b7          	lui	a1,0x80007
800012ec:	23490793          	addi	a5,s2,564
800012f0:	07048713          	addi	a4,s1,112
800012f4:	0d840613          	addi	a2,s0,216
800012f8:	01d00693          	li	a3,29
800012fc:	0b058593          	addi	a1,a1,176 # 800070b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070b1>
80001300:	00153513          	seqz	a0,a0
80001304:	f19ff0ef          	jal	ra,8000121c <z_zassert.constprop.0>
}
80001308:	02c12083          	lw	ra,44(sp)
8000130c:	02812403          	lw	s0,40(sp)
80001310:	02412483          	lw	s1,36(sp)
80001314:	02012903          	lw	s2,32(sp)
80001318:	03010113          	addi	sp,sp,48
8000131c:	00008067          	ret

80001320 <tfifo_put>:
static K_THREAD_STACK_DEFINE(tstack, STACK_SIZE);
static struct k_thread tdata;
static struct k_sem end_sema;

static void tfifo_put(struct k_fifo *pfifo)
{
80001320:	ff010113          	addi	sp,sp,-16
	/**TESTPOINT: fifo put*/
	for (int i = 0; i < LIST_LEN; i++) {
		k_fifo_put(pfifo, (void *)&data[i]);
80001324:	800085b7          	lui	a1,0x80008
{
80001328:	00912223          	sw	s1,4(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
8000132c:	ec458493          	addi	s1,a1,-316 # 80007ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ec5>
80001330:	ec458593          	addi	a1,a1,-316
{
80001334:	00112623          	sw	ra,12(sp)
80001338:	00812423          	sw	s0,8(sp)
8000133c:	00050413          	mv	s0,a0
		k_fifo_put(pfifo, (void *)&data[i]);
80001340:	59c020ef          	jal	ra,800038dc <k_queue_append>
80001344:	00848593          	addi	a1,s1,8
80001348:	00040513          	mv	a0,s0
8000134c:	590020ef          	jal	ra,800038dc <k_queue_append>
80001350:	01048593          	addi	a1,s1,16
80001354:	00040513          	mv	a0,s0
80001358:	584020ef          	jal	ra,800038dc <k_queue_append>
8000135c:	00040513          	mv	a0,s0
	}
}
80001360:	00812403          	lw	s0,8(sp)
80001364:	00c12083          	lw	ra,12(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
80001368:	01848593          	addi	a1,s1,24
}
8000136c:	00412483          	lw	s1,4(sp)
80001370:	01010113          	addi	sp,sp,16
		k_fifo_put(pfifo, (void *)&data[i]);
80001374:	5680206f          	j	800038dc <k_queue_append>

80001378 <z_zassert.constprop.1>:
static inline void z_zassert(int cond,
80001378:	fd010113          	addi	sp,sp,-48
8000137c:	00112e23          	sw	ra,28(sp)
80001380:	03012423          	sw	a6,40(sp)
80001384:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
80001388:	04051a63          	bnez	a0,800013dc <z_zassert.constprop.1+0x64>
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000138c:	80007737          	lui	a4,0x80007
80001390:	800076b7          	lui	a3,0x80007
80001394:	800075b7          	lui	a1,0x80007
80001398:	80007537          	lui	a0,0x80007
		va_start(vargs, msg);
8000139c:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800013a0:	f7c70713          	addi	a4,a4,-132 # 80006f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f7d>
800013a4:	10c68693          	addi	a3,a3,268 # 8000710c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000710d>
800013a8:	02300613          	li	a2,35
800013ac:	1ac58593          	addi	a1,a1,428 # 800071ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071ad>
800013b0:	e8050513          	addi	a0,a0,-384 # 80006e80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e81>
		va_start(vargs, msg);
800013b4:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800013b8:	4cc010ef          	jal	ra,80002884 <printk>
		vprintk(msg, vargs);
800013bc:	00c12583          	lw	a1,12(sp)
800013c0:	80007537          	lui	a0,0x80007
800013c4:	23450513          	addi	a0,a0,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
800013c8:	48c010ef          	jal	ra,80002854 <vprintk>
		printk("\n");
800013cc:	80007537          	lui	a0,0x80007
800013d0:	33450513          	addi	a0,a0,820 # 80007334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007335>
800013d4:	4b0010ef          	jal	ra,80002884 <printk>
		ztest_test_fail();
800013d8:	439010ef          	jal	ra,80003010 <ztest_test_fail>
}
800013dc:	01c12083          	lw	ra,28(sp)
800013e0:	03010113          	addi	sp,sp,48
800013e4:	00008067          	ret

800013e8 <tfifo_get>:

static void tfifo_get(struct k_fifo *pfifo)
{
800013e8:	fe010113          	addi	sp,sp,-32
800013ec:	00812c23          	sw	s0,24(sp)
800013f0:	80008437          	lui	s0,0x80008
800013f4:	ec440413          	addi	s0,s0,-316 # 80007ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ec5>
800013f8:	00912a23          	sw	s1,20(sp)
800013fc:	01212823          	sw	s2,16(sp)
80001400:	01312623          	sw	s3,12(sp)
80001404:	01412423          	sw	s4,8(sp)
80001408:	01512223          	sw	s5,4(sp)
8000140c:	01612023          	sw	s6,0(sp)
80001410:	00112e23          	sw	ra,28(sp)
80001414:	00050b13          	mv	s6,a0
80001418:	02040493          	addi	s1,s0,32

	/*get fifo data from "fifo_put"*/
	for (int i = 0; i < LIST_LEN; i++) {
		/**TESTPOINT: fifo get*/
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data[i], NULL);
8000141c:	80007a37          	lui	s4,0x80007
80001420:	80007ab7          	lui	s5,0x80007
80001424:	800079b7          	lui	s3,0x80007
80001428:	80007937          	lui	s2,0x80007
8000142c:	00000593          	li	a1,0
80001430:	000b0513          	mv	a0,s6
80001434:	68c020ef          	jal	ra,80003ac0 <z_impl_k_queue_get>
80001438:	40850533          	sub	a0,a0,s0
8000143c:	234a8793          	addi	a5,s5,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80001440:	10ca0713          	addi	a4,s4,268 # 8000710c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000710d>
80001444:	02300693          	li	a3,35
80001448:	1ac98613          	addi	a2,s3,428 # 800071ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071ad>
8000144c:	f7c90593          	addi	a1,s2,-132 # 80006f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f7d>
80001450:	00153513          	seqz	a0,a0
80001454:	00840413          	addi	s0,s0,8
80001458:	f21ff0ef          	jal	ra,80001378 <z_zassert.constprop.1>
	for (int i = 0; i < LIST_LEN; i++) {
8000145c:	fc9418e3          	bne	s0,s1,8000142c <tfifo_get+0x44>
	}
}
80001460:	01c12083          	lw	ra,28(sp)
80001464:	01812403          	lw	s0,24(sp)
80001468:	01412483          	lw	s1,20(sp)
8000146c:	01012903          	lw	s2,16(sp)
80001470:	00c12983          	lw	s3,12(sp)
80001474:	00812a03          	lw	s4,8(sp)
80001478:	00412a83          	lw	s5,4(sp)
8000147c:	00012b03          	lw	s6,0(sp)
80001480:	02010113          	addi	sp,sp,32
80001484:	00008067          	ret

80001488 <tIsr_entry>:

/*entry of contexts*/
static void tIsr_entry(void *p)
{
80001488:	ff010113          	addi	sp,sp,-16
8000148c:	00812423          	sw	s0,8(sp)
80001490:	00050413          	mv	s0,a0
	TC_PRINT("isr fifo get\n");
80001494:	80007537          	lui	a0,0x80007
80001498:	11850513          	addi	a0,a0,280 # 80007118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007119>
{
8000149c:	00112623          	sw	ra,12(sp)
	TC_PRINT("isr fifo get\n");
800014a0:	3e4010ef          	jal	ra,80002884 <printk>
	tfifo_get((struct k_fifo *)p);
800014a4:	00040513          	mv	a0,s0
800014a8:	f41ff0ef          	jal	ra,800013e8 <tfifo_get>
	TC_PRINT("isr fifo put ---> ");
800014ac:	80007537          	lui	a0,0x80007
800014b0:	12850513          	addi	a0,a0,296 # 80007128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007129>
800014b4:	3d0010ef          	jal	ra,80002884 <printk>
	tfifo_put((struct k_fifo *)p);
800014b8:	00040513          	mv	a0,s0
}
800014bc:	00812403          	lw	s0,8(sp)
800014c0:	00c12083          	lw	ra,12(sp)
800014c4:	01010113          	addi	sp,sp,16
	tfifo_put((struct k_fifo *)p);
800014c8:	e59ff06f          	j	80001320 <tfifo_put>

800014cc <tThread_entry>:

static void tThread_entry(void *p1, void *p2, void *p3)
{
800014cc:	ff010113          	addi	sp,sp,-16
800014d0:	00912223          	sw	s1,4(sp)
800014d4:	00050493          	mv	s1,a0
	TC_PRINT("thread fifo get\n");
800014d8:	80007537          	lui	a0,0x80007
800014dc:	13c50513          	addi	a0,a0,316 # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
{
800014e0:	00112623          	sw	ra,12(sp)
800014e4:	00812423          	sw	s0,8(sp)
	TC_PRINT("thread fifo get\n");
800014e8:	39c010ef          	jal	ra,80002884 <printk>
	tfifo_get((struct k_fifo *)p1);
800014ec:	00048513          	mv	a0,s1
800014f0:	ef9ff0ef          	jal	ra,800013e8 <tfifo_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800014f4:	80008437          	lui	s0,0x80008
800014f8:	ee440513          	addi	a0,s0,-284 # 80007ee4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ee5>
800014fc:	7b5030ef          	jal	ra,800054b0 <z_impl_k_sem_give>
	k_sem_give(&end_sema);
	TC_PRINT("thread fifo put ---> ");
80001500:	80007537          	lui	a0,0x80007
80001504:	15050513          	addi	a0,a0,336 # 80007150 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007151>
80001508:	37c010ef          	jal	ra,80002884 <printk>
	tfifo_put((struct k_fifo *)p1);
8000150c:	00048513          	mv	a0,s1
80001510:	e11ff0ef          	jal	ra,80001320 <tfifo_put>
80001514:	ee440513          	addi	a0,s0,-284
	k_sem_give(&end_sema);
}
80001518:	00812403          	lw	s0,8(sp)
8000151c:	00c12083          	lw	ra,12(sp)
80001520:	00412483          	lw	s1,4(sp)
80001524:	01010113          	addi	sp,sp,16
80001528:	7890306f          	j	800054b0 <z_impl_k_sem_give>

8000152c <test_fifo_loop>:
 *   -# fifo data pass correctly and stably across contexts
 *
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_loop(void)
{
8000152c:	fc010113          	addi	sp,sp,-64
80001530:	02812c23          	sw	s0,56(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80001534:	80008437          	lui	s0,0x80008
80001538:	ef440513          	addi	a0,s0,-268 # 80007ef4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef5>
8000153c:	02912a23          	sw	s1,52(sp)
80001540:	03212823          	sw	s2,48(sp)
80001544:	03412423          	sw	s4,40(sp)
80001548:	03512223          	sw	s5,36(sp)
8000154c:	03612023          	sw	s6,32(sp)
80001550:	01712e23          	sw	s7,28(sp)
80001554:	01812c23          	sw	s8,24(sp)
80001558:	01912a23          	sw	s9,20(sp)
8000155c:	01a12823          	sw	s10,16(sp)
80001560:	02112e23          	sw	ra,60(sp)
80001564:	03312623          	sw	s3,44(sp)
	k_fifo_init(&fifo);
	for (int i = 0; i < LOOPS; i++) {
80001568:	00000493          	li	s1,0
8000156c:	2a4020ef          	jal	ra,80003810 <z_impl_k_queue_init>
		TC_PRINT("* Pass data by fifo in loop %d\n", i);
80001570:	80007d37          	lui	s10,0x80007
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001574:	80008937          	lui	s2,0x80008
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001578:	80008c37          	lui	s8,0x80008
8000157c:	80008bb7          	lui	s7,0x80008
80001580:	80001cb7          	lui	s9,0x80001
	TC_PRINT("main fifo put ---> ");
80001584:	80007b37          	lui	s6,0x80007
	irq_offload(tIsr_entry, pfifo);
80001588:	80001ab7          	lui	s5,0x80001
	TC_PRINT("main fifo get\n");
8000158c:	80007a37          	lui	s4,0x80007
		TC_PRINT("* Pass data by fifo in loop %d\n", i);
80001590:	00048593          	mv	a1,s1
80001594:	168d0513          	addi	a0,s10,360 # 80007168 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007169>
80001598:	2ec010ef          	jal	ra,80002884 <printk>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
8000159c:	00100613          	li	a2,1
800015a0:	00000593          	li	a1,0
800015a4:	ee490513          	addi	a0,s2,-284 # 80007ee4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ee5>
800015a8:	641030ef          	jal	ra,800053e8 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800015ac:	00000793          	li	a5,0
800015b0:	00000893          	li	a7,0
800015b4:	00000813          	li	a6,0
800015b8:	ef440713          	addi	a4,s0,-268
800015bc:	4ccc8693          	addi	a3,s9,1228 # 800014cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800014cd>
800015c0:	20000613          	li	a2,512
800015c4:	510c0593          	addi	a1,s8,1296 # 80008510 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008511>
800015c8:	00012223          	sw	zero,4(sp)
800015cc:	00012023          	sw	zero,0(sp)
800015d0:	f08b8513          	addi	a0,s7,-248 # 80007f08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f09>
800015d4:	47c040ef          	jal	ra,80005a50 <z_impl_k_thread_create>
800015d8:	00050993          	mv	s3,a0
	TC_PRINT("main fifo put ---> ");
800015dc:	188b0513          	addi	a0,s6,392 # 80007188 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007189>
800015e0:	2a4010ef          	jal	ra,80002884 <printk>
	tfifo_put(pfifo);
800015e4:	ef440513          	addi	a0,s0,-268
800015e8:	d39ff0ef          	jal	ra,80001320 <tfifo_put>
	irq_offload(tIsr_entry, pfifo);
800015ec:	ef440593          	addi	a1,s0,-268
800015f0:	488a8513          	addi	a0,s5,1160 # 80001488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001489>
800015f4:	2c0000ef          	jal	ra,800018b4 <irq_offload>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800015f8:	fff00593          	li	a1,-1
800015fc:	ee490513          	addi	a0,s2,-284
80001600:	795030ef          	jal	ra,80005594 <z_impl_k_sem_take>
80001604:	fff00593          	li	a1,-1
80001608:	ee490513          	addi	a0,s2,-284
8000160c:	789030ef          	jal	ra,80005594 <z_impl_k_sem_take>
	TC_PRINT("main fifo get\n");
80001610:	19ca0513          	addi	a0,s4,412 # 8000719c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000719d>
80001614:	270010ef          	jal	ra,80002884 <printk>
	tfifo_get(pfifo);
80001618:	ef440513          	addi	a0,s0,-268
8000161c:	dcdff0ef          	jal	ra,800013e8 <tfifo_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001620:	00098513          	mv	a0,s3
80001624:	5d0040ef          	jal	ra,80005bf4 <z_impl_k_thread_abort>
	TC_PRINT("\n");
80001628:	80007537          	lui	a0,0x80007
8000162c:	33450513          	addi	a0,a0,820 # 80007334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007335>
80001630:	254010ef          	jal	ra,80002884 <printk>
	for (int i = 0; i < LOOPS; i++) {
80001634:	00148493          	addi	s1,s1,1
80001638:	02000793          	li	a5,32
8000163c:	f4f49ae3          	bne	s1,a5,80001590 <test_fifo_loop+0x64>
		tfifo_read_write(&fifo);
	}
}
80001640:	03c12083          	lw	ra,60(sp)
80001644:	03812403          	lw	s0,56(sp)
80001648:	03412483          	lw	s1,52(sp)
8000164c:	03012903          	lw	s2,48(sp)
80001650:	02c12983          	lw	s3,44(sp)
80001654:	02812a03          	lw	s4,40(sp)
80001658:	02412a83          	lw	s5,36(sp)
8000165c:	02012b03          	lw	s6,32(sp)
80001660:	01c12b83          	lw	s7,28(sp)
80001664:	01812c03          	lw	s8,24(sp)
80001668:	01412c83          	lw	s9,20(sp)
8000166c:	01012d03          	lw	s10,16(sp)
80001670:	04010113          	addi	sp,sp,64
80001674:	00008067          	ret

80001678 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80001678:	ff010113          	addi	sp,sp,-16
8000167c:	00112623          	sw	ra,12(sp)
80001680:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80001684:	00600793          	li	a5,6
80001688:	02f50463          	beq	a0,a5,800016b0 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
8000168c:	0f0040ef          	jal	ra,8000577c <k_is_in_isr>
80001690:	02050463          	beqz	a0,800016b8 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80001694:	0e8040ef          	jal	ra,8000577c <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80001698:	04051663          	bnez	a0,800016e4 <z_SysFatalErrorHandler+0x6c>
8000169c:	800075b7          	lui	a1,0x80007
800016a0:	49058593          	addi	a1,a1,1168 # 80007490 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007491>
800016a4:	80007537          	lui	a0,0x80007
800016a8:	4a450513          	addi	a0,a0,1188 # 800074a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074a5>
800016ac:	1d8010ef          	jal	ra,80002884 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
800016b0:	244010ef          	jal	ra,800028f4 <k_cpu_idle>
800016b4:	ffdff06f          	j	800016b0 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
800016b8:	0d4040ef          	jal	ra,8000578c <z_is_thread_essential>
800016bc:	fc051ce3          	bnez	a0,80001694 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
800016c0:	80008437          	lui	s0,0x80008
800016c4:	0d840413          	addi	s0,s0,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
800016c8:	00842583          	lw	a1,8(s0)
800016cc:	80007537          	lui	a0,0x80007
800016d0:	4c450513          	addi	a0,a0,1220 # 800074c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074c5>
800016d4:	1b0010ef          	jal	ra,80002884 <printk>
800016d8:	00842503          	lw	a0,8(s0)
800016dc:	518040ef          	jal	ra,80005bf4 <z_impl_k_thread_abort>
800016e0:	fd1ff06f          	j	800016b0 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
800016e4:	800075b7          	lui	a1,0x80007
800016e8:	48c58593          	addi	a1,a1,1164 # 8000748c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000748d>
800016ec:	fb9ff06f          	j	800016a4 <z_SysFatalErrorHandler+0x2c>

800016f0 <z_NanoFatalErrorHandler>:
{
800016f0:	fb010113          	addi	sp,sp,-80
800016f4:	04812423          	sw	s0,72(sp)
800016f8:	04912223          	sw	s1,68(sp)
800016fc:	04112623          	sw	ra,76(sp)
	switch (reason) {
80001700:	00600793          	li	a5,6
{
80001704:	00050493          	mv	s1,a0
80001708:	00058413          	mv	s0,a1
	switch (reason) {
8000170c:	0ea7e063          	bltu	a5,a0,800017ec <z_NanoFatalErrorHandler+0xfc>
80001710:	80007737          	lui	a4,0x80007
80001714:	00251793          	slli	a5,a0,0x2
80001718:	1e070713          	addi	a4,a4,480 # 800071e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071e1>
8000171c:	00e787b3          	add	a5,a5,a4
80001720:	0007a783          	lw	a5,0(a5)
80001724:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80001728:	80007537          	lui	a0,0x80007
8000172c:	31050513          	addi	a0,a0,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
		printk("***** Kernel OOPS! *****\n");
80001730:	154010ef          	jal	ra,80002884 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001734:	4a9030ef          	jal	ra,800053dc <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80001738:	04442783          	lw	a5,68(s0)
8000173c:	01042883          	lw	a7,16(s0)
80001740:	00c42803          	lw	a6,12(s0)
80001744:	02f12823          	sw	a5,48(sp)
80001748:	04042783          	lw	a5,64(s0)
8000174c:	00442703          	lw	a4,4(s0)
80001750:	00042683          	lw	a3,0(s0)
80001754:	02f12623          	sw	a5,44(sp)
80001758:	03c42783          	lw	a5,60(s0)
8000175c:	04842603          	lw	a2,72(s0)
80001760:	00050593          	mv	a1,a0
80001764:	02f12423          	sw	a5,40(sp)
80001768:	03842783          	lw	a5,56(s0)
8000176c:	80007537          	lui	a0,0x80007
80001770:	39450513          	addi	a0,a0,916 # 80007394 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007395>
80001774:	02f12223          	sw	a5,36(sp)
80001778:	03442783          	lw	a5,52(s0)
8000177c:	02f12023          	sw	a5,32(sp)
80001780:	03042783          	lw	a5,48(s0)
80001784:	00f12e23          	sw	a5,28(sp)
80001788:	02c42783          	lw	a5,44(s0)
8000178c:	00f12c23          	sw	a5,24(sp)
80001790:	02842783          	lw	a5,40(s0)
80001794:	00f12a23          	sw	a5,20(sp)
80001798:	02442783          	lw	a5,36(s0)
8000179c:	00f12823          	sw	a5,16(sp)
800017a0:	02042783          	lw	a5,32(s0)
800017a4:	00f12623          	sw	a5,12(sp)
800017a8:	01c42783          	lw	a5,28(s0)
800017ac:	00f12423          	sw	a5,8(sp)
800017b0:	01842783          	lw	a5,24(s0)
800017b4:	00f12223          	sw	a5,4(sp)
800017b8:	01442783          	lw	a5,20(s0)
800017bc:	00f12023          	sw	a5,0(sp)
800017c0:	00842783          	lw	a5,8(s0)
800017c4:	0c0010ef          	jal	ra,80002884 <printk>
	z_SysFatalErrorHandler(reason, esf);
800017c8:	00040593          	mv	a1,s0
800017cc:	00048513          	mv	a0,s1
800017d0:	ea9ff0ef          	jal	ra,80001678 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
800017d4:	80007537          	lui	a0,0x80007
800017d8:	33850513          	addi	a0,a0,824 # 80007338 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007339>
800017dc:	f55ff06f          	j	80001730 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
800017e0:	80007537          	lui	a0,0x80007
800017e4:	35450513          	addi	a0,a0,852 # 80007354 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007355>
800017e8:	f49ff06f          	j	80001730 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
800017ec:	80007537          	lui	a0,0x80007
800017f0:	00048593          	mv	a1,s1
800017f4:	37050513          	addi	a0,a0,880 # 80007370 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007371>
800017f8:	08c010ef          	jal	ra,80002884 <printk>
		break;
800017fc:	f39ff06f          	j	80001734 <z_NanoFatalErrorHandler+0x44>

80001800 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80001800:	ff010113          	addi	sp,sp,-16
80001804:	00812423          	sw	s0,8(sp)
80001808:	00112623          	sw	ra,12(sp)
8000180c:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001810:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80001814:	00161613          	slli	a2,a2,0x1
80001818:	00165613          	srli	a2,a2,0x1
	switch (cause) {
8000181c:	00500793          	li	a5,5
80001820:	02c7e863          	bltu	a5,a2,80001850 <_Fault+0x50>
80001824:	80007737          	lui	a4,0x80007
80001828:	00261793          	slli	a5,a2,0x2
8000182c:	1fc70713          	addi	a4,a4,508 # 800071fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071fd>
80001830:	00f707b3          	add	a5,a4,a5
80001834:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001838:	80007537          	lui	a0,0x80007
8000183c:	21c50513          	addi	a0,a0,540 # 8000721c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000721d>
80001840:	044010ef          	jal	ra,80002884 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80001844:	00040593          	mv	a1,s0
80001848:	00000513          	li	a0,0
8000184c:	ea5ff0ef          	jal	ra,800016f0 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001850:	800075b7          	lui	a1,0x80007
80001854:	21458593          	addi	a1,a1,532 # 80007214 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007215>
80001858:	fe1ff06f          	j	80001838 <_Fault+0x38>

8000185c <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
8000185c:	ff010113          	addi	sp,sp,-16
80001860:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001864:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001868:	80007537          	lui	a0,0x80007
	mcause &= SOC_MCAUSE_EXP_MASK;
8000186c:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001870:	0015d593          	srli	a1,a1,0x1
80001874:	4ec50513          	addi	a0,a0,1260 # 800074ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074ed>
80001878:	00c010ef          	jal	ra,80002884 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
8000187c:	800075b7          	lui	a1,0x80007
80001880:	23858593          	addi	a1,a1,568 # 80007238 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007239>
80001884:	00400513          	li	a0,4
80001888:	e69ff0ef          	jal	ra,800016f0 <z_NanoFatalErrorHandler>

8000188c <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
8000188c:	800087b7          	lui	a5,0x80008
80001890:	d4078793          	addi	a5,a5,-704 # 80007d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d41>
80001894:	0007a703          	lw	a4,0(a5)
80001898:	00070c63          	beqz	a4,800018b0 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
8000189c:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
800018a0:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
800018a4:	800087b7          	lui	a5,0x80008
800018a8:	d447a503          	lw	a0,-700(a5) # 80007d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d45>
800018ac:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
800018b0:	00008067          	ret

800018b4 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
800018b4:	00800793          	li	a5,8
800018b8:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
800018bc:	80008737          	lui	a4,0x80008
800018c0:	d4a72023          	sw	a0,-704(a4) # 80007d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d41>
	offload_param = parameter;
800018c4:	80008737          	lui	a4,0x80008
800018c8:	d4b72223          	sw	a1,-700(a4) # 80007d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d45>

	__asm__ volatile ("ecall");
800018cc:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
800018d0:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
800018d4:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
800018d8:	00008067          	ret

800018dc <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
800018dc:	ff010113          	addi	sp,sp,-16
800018e0:	00112623          	sw	ra,12(sp)
	z_bss_zero();
800018e4:	311010ef          	jal	ra,800033f4 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
800018e8:	02c010ef          	jal	ra,80002914 <soc_interrupt_init>
#endif
	z_cstart();
800018ec:	375010ef          	jal	ra,80003460 <z_cstart>

800018f0 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
800018f0:	00007117          	auipc	sp,0x7
800018f4:	62010113          	addi	sp,sp,1568 # 80008f10 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
800018f8:	000012b7          	lui	t0,0x1
800018fc:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80001900:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80001904:	fd9ff0ef          	jal	ra,800018dc <_PrepC>

80001908 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80001908:	1110006f          	j	80002218 <z_thread_entry>

8000190c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
8000190c:	fd010113          	addi	sp,sp,-48
80001910:	02812423          	sw	s0,40(sp)
80001914:	02912223          	sw	s1,36(sp)
80001918:	03212023          	sw	s2,32(sp)
8000191c:	01312e23          	sw	s3,28(sp)
80001920:	01412c23          	sw	s4,24(sp)
80001924:	01512a23          	sw	s5,20(sp)
80001928:	01612823          	sw	s6,16(sp)
8000192c:	01712623          	sw	s7,12(sp)
80001930:	00078b13          	mv	s6,a5
80001934:	02112623          	sw	ra,44(sp)
80001938:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
8000193c:	00f00793          	li	a5,15
{
80001940:	00050493          	mv	s1,a0
80001944:	00058413          	mv	s0,a1
80001948:	00060993          	mv	s3,a2
8000194c:	00068a13          	mv	s4,a3
80001950:	00070b93          	mv	s7,a4
80001954:	00080a93          	mv	s5,a6
80001958:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
8000195c:	08f89a63          	bne	a7,a5,800019f0 <z_new_thread+0xe4>
80001960:	800037b7          	lui	a5,0x80003
80001964:	3bc78793          	addi	a5,a5,956 # 800033bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800033bd>
80001968:	08f69a63          	bne	a3,a5,800019fc <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
8000196c:	03012683          	lw	a3,48(sp)
80001970:	00090593          	mv	a1,s2
80001974:	00048513          	mv	a0,s1
80001978:	00400613          	li	a2,4
8000197c:	6d5030ef          	jal	ra,80005850 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80001980:	fb098593          	addi	a1,s3,-80
80001984:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001988:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
8000198c:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001990:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80001994:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001998:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
8000199c:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800019a0:	800027b7          	lui	a5,0x80002

	thread->callee_saved.sp = (u32_t)stack_init;
}
800019a4:	02c12083          	lw	ra,44(sp)
800019a8:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800019ac:	90878793          	addi	a5,a5,-1784 # 80001908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001909>
	stack_init->a0 = (u32_t)thread_func;
800019b0:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
800019b4:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
800019b8:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
800019bc:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800019c0:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
800019c4:	02b4a423          	sw	a1,40(s1)
}
800019c8:	02012903          	lw	s2,32(sp)
800019cc:	02412483          	lw	s1,36(sp)
800019d0:	01c12983          	lw	s3,28(sp)
800019d4:	01812a03          	lw	s4,24(sp)
800019d8:	01412a83          	lw	s5,20(sp)
800019dc:	01012b03          	lw	s6,16(sp)
800019e0:	00c12b83          	lw	s7,12(sp)
800019e4:	00812c03          	lw	s8,8(sp)
800019e8:	03010113          	addi	sp,sp,48
800019ec:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800019f0:	01088693          	addi	a3,a7,16
800019f4:	01e00793          	li	a5,30
800019f8:	f6d7fae3          	bgeu	a5,a3,8000196c <z_new_thread+0x60>
800019fc:	80007c37          	lui	s8,0x80007
80001a00:	800075b7          	lui	a1,0x80007
80001a04:	80007537          	lui	a0,0x80007
80001a08:	514c0613          	addi	a2,s8,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80001a0c:	01800693          	li	a3,24
80001a10:	53458593          	addi	a1,a1,1332 # 80007534 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007535>
80001a14:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80001a18:	66d000ef          	jal	ra,80002884 <printk>
80001a1c:	80007537          	lui	a0,0x80007
80001a20:	00090593          	mv	a1,s2
80001a24:	ff000693          	li	a3,-16
80001a28:	00e00613          	li	a2,14
80001a2c:	5e050513          	addi	a0,a0,1504 # 800075e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075e1>
80001a30:	655000ef          	jal	ra,80002884 <printk>
80001a34:	01800593          	li	a1,24
80001a38:	514c0513          	addi	a0,s8,1300
80001a3c:	685000ef          	jal	ra,800028c0 <assert_post_action>
80001a40:	f2dff06f          	j	8000196c <z_new_thread+0x60>

80001a44 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001a44:	00159793          	slli	a5,a1,0x1
80001a48:	00b787b3          	add	a5,a5,a1
80001a4c:	00279713          	slli	a4,a5,0x2
80001a50:	00c52783          	lw	a5,12(a0)
80001a54:	00e787b3          	add	a5,a5,a4
80001a58:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001a5c:	00b75463          	bge	a4,a1,80001a64 <get_bit_ptr+0x20>
80001a60:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001a64:	41f65713          	srai	a4,a2,0x1f
80001a68:	01f77713          	andi	a4,a4,31
80001a6c:	00c70733          	add	a4,a4,a2
80001a70:	40575713          	srai	a4,a4,0x5
80001a74:	00271713          	slli	a4,a4,0x2
80001a78:	00e787b3          	add	a5,a5,a4
80001a7c:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
80001a80:	01f67513          	andi	a0,a2,31
80001a84:	00008067          	ret

80001a88 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001a88:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001a8c:	00c10693          	addi	a3,sp,12
{
80001a90:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001a94:	fb1ff0ef          	jal	ra,80001a44 <get_bit_ptr>

	*word |= (1<<bit);
80001a98:	00c12703          	lw	a4,12(sp)
80001a9c:	00100793          	li	a5,1
80001aa0:	00a79533          	sll	a0,a5,a0
80001aa4:	00072783          	lw	a5,0(a4)
}
80001aa8:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001aac:	00a7e7b3          	or	a5,a5,a0
80001ab0:	00f72023          	sw	a5,0(a4)
}
80001ab4:	02010113          	addi	sp,sp,32
80001ab8:	00008067          	ret

80001abc <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001abc:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001ac0:	00c10693          	addi	a3,sp,12
{
80001ac4:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001ac8:	f7dff0ef          	jal	ra,80001a44 <get_bit_ptr>

	*word &= ~(1<<bit);
80001acc:	00c12703          	lw	a4,12(sp)
80001ad0:	00100793          	li	a5,1
80001ad4:	00a79533          	sll	a0,a5,a0
80001ad8:	00072783          	lw	a5,0(a4)
}
80001adc:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80001ae0:	fff54513          	not	a0,a0
80001ae4:	00a7f533          	and	a0,a5,a0
80001ae8:	00a72023          	sw	a0,0(a4)
}
80001aec:	02010113          	addi	sp,sp,32
80001af0:	00008067          	ret

80001af4 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001af4:	fe010113          	addi	sp,sp,-32
80001af8:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001afc:	00452483          	lw	s1,4(a0)
{
80001b00:	00812c23          	sw	s0,24(sp)
80001b04:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001b08:	00855503          	lhu	a0,8(a0)
80001b0c:	00048593          	mv	a1,s1
{
80001b10:	01212823          	sw	s2,16(sp)
80001b14:	01312623          	sw	s3,12(sp)
80001b18:	01412423          	sw	s4,8(sp)
80001b1c:	01512223          	sw	s5,4(sp)
80001b20:	01612023          	sw	s6,0(sp)
80001b24:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001b28:	d6dfe0ef          	jal	ra,80000894 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001b2c:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001b30:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80001b34:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001b38:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001b3c:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
80001b40:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001b44:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80001b48:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80001b4c:	03594c63          	blt	s2,s5,80001b84 <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001b50:	00000493          	li	s1,0
80001b54:	00845783          	lhu	a5,8(s0)
80001b58:	08f4cc63          	blt	s1,a5,80001bf0 <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001b5c:	01c12083          	lw	ra,28(sp)
80001b60:	01812403          	lw	s0,24(sp)
80001b64:	01412483          	lw	s1,20(sp)
80001b68:	01012903          	lw	s2,16(sp)
80001b6c:	00c12983          	lw	s3,12(sp)
80001b70:	00812a03          	lw	s4,8(sp)
80001b74:	00412a83          	lw	s5,4(sp)
80001b78:	00012b03          	lw	s6,0(sp)
80001b7c:	02010113          	addi	sp,sp,32
80001b80:	00008067          	ret
		int nblocks = buflen / sz;
80001b84:	00048593          	mv	a1,s1
80001b88:	000a0513          	mv	a0,s4
80001b8c:	dc5fe0ef          	jal	ra,80000950 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80001b90:	00191713          	slli	a4,s2,0x1
80001b94:	01270733          	add	a4,a4,s2
80001b98:	00271793          	slli	a5,a4,0x2
80001b9c:	00c42703          	lw	a4,12(s0)
80001ba0:	00f70733          	add	a4,a4,a5
80001ba4:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001ba8:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001bac:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
80001bb0:	00ab4e63          	blt	s6,a0,80001bcc <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
80001bb4:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
80001bb8:	0024d493          	srli	s1,s1,0x2
80001bbc:	00348493          	addi	s1,s1,3
80001bc0:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
80001bc4:	00190913          	addi	s2,s2,1
80001bc8:	f85ff06f          	j	80001b4c <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
80001bcc:	01f50513          	addi	a0,a0,31
80001bd0:	41f55793          	srai	a5,a0,0x1f
80001bd4:	01f7f793          	andi	a5,a5,31
80001bd8:	00a787b3          	add	a5,a5,a0
80001bdc:	4057d793          	srai	a5,a5,0x5
80001be0:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80001be4:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001be8:	00f989b3          	add	s3,s3,a5
80001bec:	fcdff06f          	j	80001bb8 <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
80001bf0:	00442583          	lw	a1,4(s0)
80001bf4:	00048513          	mv	a0,s1
80001bf8:	c9dfe0ef          	jal	ra,80000894 <__mulsi3>
80001bfc:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001c00:	00048613          	mv	a2,s1
80001c04:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001c08:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
80001c0c:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001c10:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001c14:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001c18:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
80001c1c:	0087a703          	lw	a4,8(a5)
80001c20:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
80001c24:	0087a703          	lw	a4,8(a5)
80001c28:	00a72023          	sw	a0,0(a4)
	list->tail = node;
80001c2c:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001c30:	00040513          	mv	a0,s0
80001c34:	e55ff0ef          	jal	ra,80001a88 <set_free_bit>
80001c38:	f1dff06f          	j	80001b54 <z_sys_mem_pool_base_init+0x60>

80001c3c <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001c3c:	fa010113          	addi	sp,sp,-96
80001c40:	04812c23          	sw	s0,88(sp)
80001c44:	05512223          	sw	s5,68(sp)
80001c48:	04112e23          	sw	ra,92(sp)
80001c4c:	04912a23          	sw	s1,84(sp)
80001c50:	05212823          	sw	s2,80(sp)
80001c54:	05312623          	sw	s3,76(sp)
80001c58:	05412423          	sw	s4,72(sp)
80001c5c:	05612023          	sw	s6,64(sp)
80001c60:	03712e23          	sw	s7,60(sp)
80001c64:	03812c23          	sw	s8,56(sp)
80001c68:	03912a23          	sw	s9,52(sp)
80001c6c:	03a12823          	sw	s10,48(sp)
80001c70:	03b12623          	sw	s11,44(sp)
80001c74:	06010413          	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001c78:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001c7c:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001c80:	002e1793          	slli	a5,t3,0x2
80001c84:	00f78793          	addi	a5,a5,15
80001c88:	7f07f793          	andi	a5,a5,2032
80001c8c:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001c90:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001c94:	00010a93          	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001c98:	000a8313          	mv	t1,s5
80001c9c:	00378793          	addi	a5,a5,3
80001ca0:	ffc7f793          	andi	a5,a5,-4
80001ca4:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80001ca8:	fff88b13          	addi	s6,a7,-1
80001cac:	03c8d463          	bge	a7,t3,80001cd4 <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
80001cb0:	00088c63          	beqz	a7,80001cc8 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001cb4:	ffc32803          	lw	a6,-4(t1)
80001cb8:	00285813          	srli	a6,a6,0x2
80001cbc:	00380813          	addi	a6,a6,3
80001cc0:	ffc87813          	andi	a6,a6,-4
80001cc4:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
80001cc8:	00430313          	addi	t1,t1,4
80001ccc:	ffc32803          	lw	a6,-4(t1)
80001cd0:	04b87a63          	bgeu	a6,a1,80001d24 <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80001cd4:	fff00593          	li	a1,-1
80001cd8:	04bb1a63          	bne	s6,a1,80001d2c <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
80001cdc:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
80001ce0:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80001ce4:	fa040113          	addi	sp,s0,-96
80001ce8:	05c12083          	lw	ra,92(sp)
80001cec:	05812403          	lw	s0,88(sp)
80001cf0:	05412483          	lw	s1,84(sp)
80001cf4:	05012903          	lw	s2,80(sp)
80001cf8:	04c12983          	lw	s3,76(sp)
80001cfc:	04812a03          	lw	s4,72(sp)
80001d00:	04412a83          	lw	s5,68(sp)
80001d04:	04012b03          	lw	s6,64(sp)
80001d08:	03c12b83          	lw	s7,60(sp)
80001d0c:	03812c03          	lw	s8,56(sp)
80001d10:	03412c83          	lw	s9,52(sp)
80001d14:	03012d03          	lw	s10,48(sp)
80001d18:	02c12d83          	lw	s11,44(sp)
80001d1c:	06010113          	addi	sp,sp,96
80001d20:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
80001d24:	00188893          	addi	a7,a7,1
80001d28:	f81ff06f          	j	80001ca8 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001d2c:	01054583          	lbu	a1,16(a0)
		return 0;
80001d30:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001d34:	0015f593          	andi	a1,a1,1
80001d38:	00058863          	beqz	a1,80001d48 <z_sys_mem_pool_block_alloc+0x10c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d3c:	00800913          	li	s2,8
80001d40:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80001d44:	00897913          	andi	s2,s2,8
80001d48:	fae42a23          	sw	a4,-76(s0)
80001d4c:	001b1713          	slli	a4,s6,0x1
80001d50:	fad42c23          	sw	a3,-72(s0)
80001d54:	01670733          	add	a4,a4,s6
80001d58:	00c52683          	lw	a3,12(a0)
80001d5c:	00271713          	slli	a4,a4,0x2
80001d60:	00470713          	addi	a4,a4,4
80001d64:	00e68733          	add	a4,a3,a4
80001d68:	fac42e23          	sw	a2,-68(s0)
80001d6c:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80001d70:	000b0a13          	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
80001d74:	fff00693          	li	a3,-1
	return list->head == list;
80001d78:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001d7c:	19370663          	beq	a4,s3,80001f08 <z_sys_mem_pool_block_alloc+0x2cc>
		data = block_alloc(p, i, lsizes[i]);
80001d80:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
80001d84:	0049a683          	lw	a3,4(s3)
80001d88:	00ea8cb3          	add	s9,s5,a4
80001d8c:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001d90:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d94:	00800d13          	li	s10,8
80001d98:	00e6a023          	sw	a4,0(a3)
	node->next->prev = node->prev;
80001d9c:	00d72223          	sw	a3,4(a4)
	node->next = NULL;
80001da0:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001da4:	0009a223          	sw	zero,4(s3)
80001da8:	0004a503          	lw	a0,0(s1)
80001dac:	40a98533          	sub	a0,s3,a0
80001db0:	b99fe0ef          	jal	ra,80000948 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
80001db4:	00050613          	mv	a2,a0
80001db8:	000a0593          	mv	a1,s4
80001dbc:	00048513          	mv	a0,s1
80001dc0:	cfdff0ef          	jal	ra,80001abc <clear_free_bit>
		if (data != NULL) {
80001dc4:	001a0a13          	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
80001dc8:	fffa0693          	addi	a3,s4,-1
80001dcc:	0566ca63          	blt	a3,s6,80001e20 <z_sys_mem_pool_block_alloc+0x1e4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001dd0:	0104c703          	lbu	a4,16(s1)
80001dd4:	00177713          	andi	a4,a4,1
80001dd8:	00070463          	beqz	a4,80001de0 <z_sys_mem_pool_block_alloc+0x1a4>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ddc:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80001de0:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
80001de4:	ff400513          	li	a0,-12
	*data_p = data;
80001de8:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80001dec:	ee098ce3          	beqz	s3,80001ce4 <z_sys_mem_pool_block_alloc+0xa8>
	*level_p = alloc_l;
80001df0:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001df4:	0004a503          	lw	a0,0(s1)
	*level_p = alloc_l;
80001df8:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001dfc:	002b1793          	slli	a5,s6,0x2
80001e00:	00fa8ab3          	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001e04:	000aa583          	lw	a1,0(s5)
80001e08:	40a98533          	sub	a0,s3,a0
80001e0c:	b3dfe0ef          	jal	ra,80000948 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001e10:	fb842783          	lw	a5,-72(s0)
80001e14:	00a7a023          	sw	a0,0(a5)
	return 0;
80001e18:	00000513          	li	a0,0
80001e1c:	ec9ff06f          	j	80001ce4 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001e20:	0004a503          	lw	a0,0(s1)
80001e24:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
80001e28:	00100b93          	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001e2c:	40a98533          	sub	a0,s3,a0
80001e30:	b19fe0ef          	jal	ra,80000948 <__divsi3>
80001e34:	001a1893          	slli	a7,s4,0x1
80001e38:	014888b3          	add	a7,a7,s4
		int lbn = 4*bn + i;
80001e3c:	00251d93          	slli	s11,a0,0x2
80001e40:	00289893          	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
80001e44:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
80001e48:	000b8593          	mv	a1,s7
80001e4c:	fb142623          	sw	a7,-84(s0)
80001e50:	00068513          	mv	a0,a3
80001e54:	fad42823          	sw	a3,-80(s0)
80001e58:	a3dfe0ef          	jal	ra,80000894 <__mulsi3>
80001e5c:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
80001e60:	01bb8633          	add	a2,s7,s11
80001e64:	000a0593          	mv	a1,s4
80001e68:	00048513          	mv	a0,s1
80001e6c:	c1dff0ef          	jal	ra,80001a88 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001e70:	fb042683          	lw	a3,-80(s0)
80001e74:	0004a603          	lw	a2,0(s1)
	return p->n_max * p->max_sz;
80001e78:	0044a583          	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001e7c:	fff68693          	addi	a3,a3,-1
	return p->n_max * p->max_sz;
80001e80:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001e84:	00dc06b3          	add	a3,s8,a3
80001e88:	40c686b3          	sub	a3,a3,a2
80001e8c:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
80001e90:	a05fe0ef          	jal	ra,80000894 <__mulsi3>
		if (block_fits(p, block2, lsz)) {
80001e94:	fb042683          	lw	a3,-80(s0)
80001e98:	fac42883          	lw	a7,-84(s0)
80001e9c:	02a6f463          	bgeu	a3,a0,80001ec4 <z_sys_mem_pool_block_alloc+0x288>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001ea0:	00c4a683          	lw	a3,12(s1)
80001ea4:	011686b3          	add	a3,a3,a7
80001ea8:	00468613          	addi	a2,a3,4
	node->next = list;
80001eac:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
80001eb0:	0086a603          	lw	a2,8(a3)
80001eb4:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
80001eb8:	0086a603          	lw	a2,8(a3)
80001ebc:	01862023          	sw	s8,0(a2)
	list->tail = node;
80001ec0:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
80001ec4:	001b8b93          	addi	s7,s7,1
80001ec8:	00400793          	li	a5,4
80001ecc:	f6fb9ce3          	bne	s7,a5,80001e44 <z_sys_mem_pool_block_alloc+0x208>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001ed0:	0104c683          	lbu	a3,16(s1)
80001ed4:	0016f693          	andi	a3,a3,1
80001ed8:	00069a63          	bnez	a3,80001eec <z_sys_mem_pool_block_alloc+0x2b0>
		return 0;
80001edc:	00000913          	li	s2,0
80001ee0:	001a0a13          	addi	s4,s4,1
80001ee4:	004c8c93          	addi	s9,s9,4
80001ee8:	ee1ff06f          	j	80001dc8 <z_sys_mem_pool_block_alloc+0x18c>
80001eec:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001ef0:	0104c683          	lbu	a3,16(s1)
80001ef4:	0016f693          	andi	a3,a3,1
80001ef8:	fe0682e3          	beqz	a3,80001edc <z_sys_mem_pool_block_alloc+0x2a0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001efc:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
80001f00:	00897913          	andi	s2,s2,8
80001f04:	fddff06f          	j	80001ee0 <z_sys_mem_pool_block_alloc+0x2a4>
	for (i = alloc_l; i >= 0; i--) {
80001f08:	fffa0a13          	addi	s4,s4,-1
80001f0c:	ff498713          	addi	a4,s3,-12
80001f10:	e6da14e3          	bne	s4,a3,80001d78 <z_sys_mem_pool_block_alloc+0x13c>
80001f14:	00000993          	li	s3,0
80001f18:	eb9ff06f          	j	80001dd0 <z_sys_mem_pool_block_alloc+0x194>

80001f1c <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001f1c:	fa010113          	addi	sp,sp,-96
80001f20:	04812c23          	sw	s0,88(sp)
80001f24:	05412423          	sw	s4,72(sp)
80001f28:	03912a23          	sw	s9,52(sp)
80001f2c:	04112e23          	sw	ra,92(sp)
80001f30:	04912a23          	sw	s1,84(sp)
80001f34:	05212823          	sw	s2,80(sp)
80001f38:	05312623          	sw	s3,76(sp)
80001f3c:	05512223          	sw	s5,68(sp)
80001f40:	05612023          	sw	s6,64(sp)
80001f44:	03712e23          	sw	s7,60(sp)
80001f48:	03812c23          	sw	s8,56(sp)
80001f4c:	03a12823          	sw	s10,48(sp)
80001f50:	03b12623          	sw	s11,44(sp)
80001f54:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001f58:	00a54703          	lbu	a4,10(a0)
{
80001f5c:	00050c93          	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001f60:	00271713          	slli	a4,a4,0x2
80001f64:	00f70713          	addi	a4,a4,15
80001f68:	7f077713          	andi	a4,a4,2032
80001f6c:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
80001f70:	00452703          	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001f74:	00010a13          	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001f78:	000a0693          	mv	a3,s4
80001f7c:	00370713          	addi	a4,a4,3
80001f80:	ffc77713          	andi	a4,a4,-4
80001f84:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80001f88:	00100513          	li	a0,1
80001f8c:	00468693          	addi	a3,a3,4
80001f90:	0ca5f063          	bgeu	a1,a0,80002050 <z_sys_mem_pool_block_free+0x134>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001f94:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001f98:	00058913          	mv	s2,a1
80001f9c:	00060993          	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001fa0:	00177713          	andi	a4,a4,1
		return 0;
80001fa4:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001fa8:	00070863          	beqz	a4,80001fb8 <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001fac:	00800493          	li	s1,8
80001fb0:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80001fb4:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80001fb8:	80007b37          	lui	s6,0x80007
	while (level >= 0) {
80001fbc:	0a095863          	bgez	s2,8000206c <z_sys_mem_pool_block_free+0x150>
	__ASSERT(0, "out of levels");
80001fc0:	800074b7          	lui	s1,0x80007
80001fc4:	800075b7          	lui	a1,0x80007
80001fc8:	80007537          	lui	a0,0x80007
80001fcc:	61448613          	addi	a2,s1,1556 # 80007614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007615>
80001fd0:	0c000693          	li	a3,192
80001fd4:	67c58593          	addi	a1,a1,1660 # 8000767c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000767d>
80001fd8:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80001fdc:	0a9000ef          	jal	ra,80002884 <printk>
80001fe0:	80007537          	lui	a0,0x80007
80001fe4:	64850513          	addi	a0,a0,1608 # 80007648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007649>
80001fe8:	09d000ef          	jal	ra,80002884 <printk>
80001fec:	61448513          	addi	a0,s1,1556
80001ff0:	0c000593          	li	a1,192
80001ff4:	0cd000ef          	jal	ra,800028c0 <assert_post_action>
	return -1;
80001ff8:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001ffc:	010cc783          	lbu	a5,16(s9)
80002000:	0017f793          	andi	a5,a5,1
80002004:	00078663          	beqz	a5,80002010 <z_sys_mem_pool_block_free+0xf4>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80002008:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000200c:	3004a4f3          	csrrs	s1,mstatus,s1
}
80002010:	fa040113          	addi	sp,s0,-96
80002014:	05c12083          	lw	ra,92(sp)
80002018:	05812403          	lw	s0,88(sp)
8000201c:	05412483          	lw	s1,84(sp)
80002020:	05012903          	lw	s2,80(sp)
80002024:	04c12983          	lw	s3,76(sp)
80002028:	04812a03          	lw	s4,72(sp)
8000202c:	04412a83          	lw	s5,68(sp)
80002030:	04012b03          	lw	s6,64(sp)
80002034:	03c12b83          	lw	s7,60(sp)
80002038:	03812c03          	lw	s8,56(sp)
8000203c:	03412c83          	lw	s9,52(sp)
80002040:	03012d03          	lw	s10,48(sp)
80002044:	02c12d83          	lw	s11,44(sp)
80002048:	06010113          	addi	sp,sp,96
8000204c:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80002050:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80002054:	00150513          	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80002058:	00275713          	srli	a4,a4,0x2
8000205c:	00370713          	addi	a4,a4,3
80002060:	ffc77713          	andi	a4,a4,-4
80002064:	00e6a023          	sw	a4,0(a3)
80002068:	f25ff06f          	j	80001f8c <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
8000206c:	00291713          	slli	a4,s2,0x2
80002070:	00ea0733          	add	a4,s4,a4
80002074:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80002078:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
8000207c:	00098513          	mv	a0,s3
80002080:	000a8593          	mv	a1,s5
80002084:	811fe0ef          	jal	ra,80000894 <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80002088:	fffa8b93          	addi	s7,s5,-1
8000208c:	01750d33          	add	s10,a0,s7
80002090:	00ac0c33          	add	s8,s8,a0
	return p->n_max * p->max_sz;
80002094:	004ca583          	lw	a1,4(s9)
80002098:	008cd503          	lhu	a0,8(s9)
8000209c:	ff8fe0ef          	jal	ra,80000894 <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
800020a0:	02ad6c63          	bltu	s10,a0,800020d8 <z_sys_mem_pool_block_free+0x1bc>
800020a4:	800077b7          	lui	a5,0x80007
800020a8:	62878593          	addi	a1,a5,1576 # 80007628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007629>
800020ac:	800077b7          	lui	a5,0x80007
800020b0:	5c078513          	addi	a0,a5,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800020b4:	0a400693          	li	a3,164
800020b8:	614b0613          	addi	a2,s6,1556 # 80007614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007615>
800020bc:	7c8000ef          	jal	ra,80002884 <printk>
800020c0:	800077b7          	lui	a5,0x80007
800020c4:	64478513          	addi	a0,a5,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
800020c8:	7bc000ef          	jal	ra,80002884 <printk>
800020cc:	0a400593          	li	a1,164
800020d0:	614b0513          	addi	a0,s6,1556
800020d4:	7ec000ef          	jal	ra,800028c0 <assert_post_action>
		set_free_bit(p, level, bn);
800020d8:	00098613          	mv	a2,s3
800020dc:	00090593          	mv	a1,s2
800020e0:	000c8513          	mv	a0,s9
800020e4:	9a5ff0ef          	jal	ra,80001a88 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
800020e8:	00191713          	slli	a4,s2,0x1
800020ec:	01270733          	add	a4,a4,s2
800020f0:	00271693          	slli	a3,a4,0x2
800020f4:	00cca703          	lw	a4,12(s9)
800020f8:	00d70733          	add	a4,a4,a3
800020fc:	00470693          	addi	a3,a4,4
	node->next = list;
80002100:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
80002104:	00872683          	lw	a3,8(a4)
80002108:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
8000210c:	00872683          	lw	a3,8(a4)
80002110:	0186a023          	sw	s8,0(a3)
	list->tail = node;
80002114:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80002118:	010cc703          	lbu	a4,16(s9)
8000211c:	00177713          	andi	a4,a4,1
80002120:	0c071c63          	bnez	a4,800021f8 <z_sys_mem_pool_block_free+0x2dc>
		return 0;
80002124:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80002128:	ec090ae3          	beqz	s2,80001ffc <z_sys_mem_pool_block_free+0xe0>
	int bit = get_bit_ptr(p, level, bn, &word);
8000212c:	fbc40693          	addi	a3,s0,-68
80002130:	00098613          	mv	a2,s3
80002134:	00090593          	mv	a1,s2
80002138:	000c8513          	mv	a0,s9
8000213c:	909ff0ef          	jal	ra,80001a44 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80002140:	fbc42683          	lw	a3,-68(s0)
80002144:	41f55713          	srai	a4,a0,0x1f
80002148:	00377713          	andi	a4,a4,3
8000214c:	00a70733          	add	a4,a4,a0
80002150:	0006a503          	lw	a0,0(a3)
80002154:	ffc77713          	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80002158:	00f00793          	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
8000215c:	00e55733          	srl	a4,a0,a4
80002160:	00f77713          	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80002164:	e8f71ce3          	bne	a4,a5,80001ffc <z_sys_mem_pool_block_free+0xe0>
		for (i = 0; i < 4; i++) {
80002168:	00000d13          	li	s10,0
			int b = (bn & ~3) + i;
8000216c:	ffc9fd93          	andi	s11,s3,-4
80002170:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
80002174:	00060513          	mv	a0,a2
80002178:	000a8593          	mv	a1,s5
8000217c:	fac42423          	sw	a2,-88(s0)
80002180:	f14fe0ef          	jal	ra,80000894 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80002184:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80002188:	00050c13          	mv	s8,a0
	return p->n_max * p->max_sz;
8000218c:	004ca583          	lw	a1,4(s9)
80002190:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80002194:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80002198:	efcfe0ef          	jal	ra,80000894 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
8000219c:	fac42703          	lw	a4,-84(s0)
800021a0:	fa842603          	lw	a2,-88(s0)
800021a4:	02a77863          	bgeu	a4,a0,800021d4 <z_sys_mem_pool_block_free+0x2b8>
				clear_free_bit(p, level, b);
800021a8:	00090593          	mv	a1,s2
800021ac:	000c8513          	mv	a0,s9
800021b0:	90dff0ef          	jal	ra,80001abc <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
800021b4:	000ca703          	lw	a4,0(s9)
800021b8:	01870c33          	add	s8,a4,s8
	node->prev->next = node->next;
800021bc:	004c2603          	lw	a2,4(s8)
800021c0:	000c2703          	lw	a4,0(s8)
800021c4:	00e62023          	sw	a4,0(a2)
	node->next->prev = node->prev;
800021c8:	00c72223          	sw	a2,4(a4)
	node->next = NULL;
800021cc:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
800021d0:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
800021d4:	001d0d13          	addi	s10,s10,1
800021d8:	00400793          	li	a5,4
800021dc:	f8fd1ae3          	bne	s10,a5,80002170 <z_sys_mem_pool_block_free+0x254>
		bn = bn / 4;
800021e0:	41f9d613          	srai	a2,s3,0x1f
800021e4:	00367613          	andi	a2,a2,3
800021e8:	013609b3          	add	s3,a2,s3
		level = level - 1;
800021ec:	fff90913          	addi	s2,s2,-1
		bn = bn / 4;
800021f0:	4029d993          	srai	s3,s3,0x2
800021f4:	dc9ff06f          	j	80001fbc <z_sys_mem_pool_block_free+0xa0>
800021f8:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800021fc:	010cc703          	lbu	a4,16(s9)
80002200:	00177713          	andi	a4,a4,1
80002204:	f20700e3          	beqz	a4,80002124 <z_sys_mem_pool_block_free+0x208>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002208:	00800793          	li	a5,8
8000220c:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
80002210:	0084f493          	andi	s1,s1,8
80002214:	f15ff06f          	j	80002128 <z_sys_mem_pool_block_free+0x20c>

80002218 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80002218:	ff010113          	addi	sp,sp,-16
8000221c:	00050793          	mv	a5,a0
80002220:	00058513          	mv	a0,a1
80002224:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80002228:	00068613          	mv	a2,a3
{
8000222c:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80002230:	000780e7          	jalr	a5
80002234:	1a8030ef          	jal	ra,800053dc <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002238:	1bd030ef          	jal	ra,80005bf4 <z_impl_k_thread_abort>

8000223c <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
8000223c:	00000513          	li	a0,0
80002240:	00008067          	ret

80002244 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80002244:	ff010113          	addi	sp,sp,-16
80002248:	00812423          	sw	s0,8(sp)
8000224c:	00050413          	mv	s0,a0
	out('E', ctx);
80002250:	04500513          	li	a0,69
{
80002254:	00112623          	sw	ra,12(sp)
80002258:	00912223          	sw	s1,4(sp)
8000225c:	00058493          	mv	s1,a1
	out('E', ctx);
80002260:	000400e7          	jalr	s0
	out('R', ctx);
80002264:	00048593          	mv	a1,s1
80002268:	05200513          	li	a0,82
8000226c:	000400e7          	jalr	s0
	out('R', ctx);
80002270:	00040313          	mv	t1,s0
}
80002274:	00812403          	lw	s0,8(sp)
80002278:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
8000227c:	00048593          	mv	a1,s1
}
80002280:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80002284:	05200513          	li	a0,82
}
80002288:	01010113          	addi	sp,sp,16
	out('R', ctx);
8000228c:	00030067          	jr	t1

80002290 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80002290:	0005a783          	lw	a5,0(a1)
80002294:	00178793          	addi	a5,a5,1
80002298:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
8000229c:	800087b7          	lui	a5,0x80008
800022a0:	ca87a303          	lw	t1,-856(a5) # 80007ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ca9>
800022a4:	00030067          	jr	t1

800022a8 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
800022a8:	fc010113          	addi	sp,sp,-64
800022ac:	02812c23          	sw	s0,56(sp)
800022b0:	03312623          	sw	s3,44(sp)
800022b4:	03412423          	sw	s4,40(sp)
800022b8:	03612023          	sw	s6,32(sp)
800022bc:	01a12823          	sw	s10,16(sp)
800022c0:	02112e23          	sw	ra,60(sp)
800022c4:	02912a23          	sw	s1,52(sp)
800022c8:	03212823          	sw	s2,48(sp)
800022cc:	03512223          	sw	s5,36(sp)
800022d0:	01712e23          	sw	s7,28(sp)
800022d4:	01812c23          	sw	s8,24(sp)
800022d8:	01912a23          	sw	s9,20(sp)
800022dc:	01b12623          	sw	s11,12(sp)
800022e0:	00050993          	mv	s3,a0
800022e4:	00058a13          	mv	s4,a1
800022e8:	00060d13          	mv	s10,a2
800022ec:	00068b13          	mv	s6,a3
800022f0:	00100413          	li	s0,1
800022f4:	00e05463          	blez	a4,800022fc <_printk_dec_ulong+0x54>
800022f8:	00070413          	mv	s0,a4
800022fc:	00100793          	li	a5,1
80002300:	02000c93          	li	s9,32
80002304:	00fb1463          	bne	s6,a5,8000230c <_printk_dec_ulong+0x64>
80002308:	03000c93          	li	s9,48
8000230c:	3b9ad4b7          	lui	s1,0x3b9ad
80002310:	00100913          	li	s2,1
80002314:	00a00a93          	li	s5,10
80002318:	00000c13          	li	s8,0
8000231c:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80002320:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80002324:	00148b93          	addi	s7,s1,1
80002328:	000c1463          	bnez	s8,80002330 <_printk_dec_ulong+0x88>
8000232c:	0ba4f263          	bgeu	s1,s10,800023d0 <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80002330:	000b8593          	mv	a1,s7
80002334:	000d0513          	mv	a0,s10
80002338:	e18fe0ef          	jal	ra,80000950 <__udivsi3>
8000233c:	000a0593          	mv	a1,s4
80002340:	03050513          	addi	a0,a0,48
80002344:	000980e7          	jalr	s3
			digits++;
80002348:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
8000234c:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80002350:	000b8593          	mv	a1,s7
80002354:	000d0513          	mv	a0,s10
80002358:	e40fe0ef          	jal	ra,80000998 <__umodsi3>
8000235c:	00050d13          	mv	s10,a0
		pos /= 10;
80002360:	00a00593          	li	a1,10
80002364:	00048513          	mv	a0,s1
80002368:	de8fe0ef          	jal	ra,80000950 <__udivsi3>
		remaining--;
8000236c:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
80002370:	00100793          	li	a5,1
		pos /= 10;
80002374:	00050493          	mv	s1,a0
	while (pos >= 9) {
80002378:	fafa96e3          	bne	s5,a5,80002324 <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
8000237c:	000a0593          	mv	a1,s4
80002380:	030d0513          	addi	a0,s10,48
80002384:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80002388:	00300793          	li	a5,3
		remaining = min_width - digits;
8000238c:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80002390:	06fb0663          	beq	s6,a5,800023fc <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80002394:	03c12083          	lw	ra,60(sp)
80002398:	03812403          	lw	s0,56(sp)
8000239c:	03412483          	lw	s1,52(sp)
800023a0:	03012903          	lw	s2,48(sp)
800023a4:	02c12983          	lw	s3,44(sp)
800023a8:	02812a03          	lw	s4,40(sp)
800023ac:	02412a83          	lw	s5,36(sp)
800023b0:	02012b03          	lw	s6,32(sp)
800023b4:	01c12b83          	lw	s7,28(sp)
800023b8:	01812c03          	lw	s8,24(sp)
800023bc:	01412c83          	lw	s9,20(sp)
800023c0:	01012d03          	lw	s10,16(sp)
800023c4:	00c12d83          	lw	s11,12(sp)
800023c8:	04010113          	addi	sp,sp,64
800023cc:	00008067          	ret
		} else if (remaining <= min_width
800023d0:	f95440e3          	blt	s0,s5,80002350 <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
800023d4:	f76deee3          	bltu	s11,s6,80002350 <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
800023d8:	000a0593          	mv	a1,s4
800023dc:	000c8513          	mv	a0,s9
800023e0:	000980e7          	jalr	s3
			digits++;
800023e4:	00190913          	addi	s2,s2,1
800023e8:	f69ff06f          	j	80002350 <_printk_dec_ulong+0xa8>
			out(' ', ctx);
800023ec:	000a0593          	mv	a1,s4
800023f0:	02000513          	li	a0,32
800023f4:	000980e7          	jalr	s3
800023f8:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
800023fc:	fe8048e3          	bgtz	s0,800023ec <_printk_dec_ulong+0x144>
80002400:	f95ff06f          	j	80002394 <_printk_dec_ulong+0xec>

80002404 <__printk_hook_install>:
	_char_out = fn;
80002404:	800087b7          	lui	a5,0x80008
80002408:	caa7a423          	sw	a0,-856(a5) # 80007ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ca9>
}
8000240c:	00008067          	ret

80002410 <z_vprintk>:
{
80002410:	fb010113          	addi	sp,sp,-80
80002414:	04812423          	sw	s0,72(sp)
80002418:	04912223          	sw	s1,68(sp)
8000241c:	05212023          	sw	s2,64(sp)
80002420:	03312e23          	sw	s3,60(sp)
80002424:	03412c23          	sw	s4,56(sp)
80002428:	03512a23          	sw	s5,52(sp)
8000242c:	03912223          	sw	s9,36(sp)
80002430:	03a12023          	sw	s10,32(sp)
80002434:	01b12e23          	sw	s11,28(sp)
80002438:	04112623          	sw	ra,76(sp)
8000243c:	03612823          	sw	s6,48(sp)
80002440:	03712623          	sw	s7,44(sp)
80002444:	03812423          	sw	s8,40(sp)
80002448:	00050413          	mv	s0,a0
8000244c:	00058493          	mv	s1,a1
80002450:	00060a93          	mv	s5,a2
80002454:	00068d13          	mv	s10,a3
	int long_ctr = 0;
80002458:	00000a13          	li	s4,0
	int min_width = -1;
8000245c:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80002460:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80002464:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
80002468:	80000db7          	lui	s11,0x80000
	while (*fmt) {
8000246c:	000ac503          	lbu	a0,0(s5)
80002470:	04051063          	bnez	a0,800024b0 <z_vprintk+0xa0>
}
80002474:	04c12083          	lw	ra,76(sp)
80002478:	04812403          	lw	s0,72(sp)
8000247c:	04412483          	lw	s1,68(sp)
80002480:	04012903          	lw	s2,64(sp)
80002484:	03c12983          	lw	s3,60(sp)
80002488:	03812a03          	lw	s4,56(sp)
8000248c:	03412a83          	lw	s5,52(sp)
80002490:	03012b03          	lw	s6,48(sp)
80002494:	02c12b83          	lw	s7,44(sp)
80002498:	02812c03          	lw	s8,40(sp)
8000249c:	02412c83          	lw	s9,36(sp)
800024a0:	02012d03          	lw	s10,32(sp)
800024a4:	01c12d83          	lw	s11,28(sp)
800024a8:	05010113          	addi	sp,sp,80
800024ac:	00008067          	ret
		if (!might_format) {
800024b0:	000c9e63          	bnez	s9,800024cc <z_vprintk+0xbc>
			if (*fmt != '%') {
800024b4:	02500693          	li	a3,37
800024b8:	36d50c63          	beq	a0,a3,80002830 <z_vprintk+0x420>
				out((int)*fmt, ctx);
800024bc:	00048593          	mv	a1,s1
800024c0:	000400e7          	jalr	s0
		++fmt;
800024c4:	001a8a93          	addi	s5,s5,1
800024c8:	fa5ff06f          	j	8000246c <z_vprintk+0x5c>
			switch (*fmt) {
800024cc:	06400693          	li	a3,100
800024d0:	12d50063          	beq	a0,a3,800025f0 <z_vprintk+0x1e0>
800024d4:	06a6e263          	bltu	a3,a0,80002538 <z_vprintk+0x128>
800024d8:	03900693          	li	a3,57
800024dc:	02a6ea63          	bltu	a3,a0,80002510 <z_vprintk+0x100>
800024e0:	03100693          	li	a3,49
800024e4:	0ed57463          	bgeu	a0,a3,800025cc <z_vprintk+0x1bc>
800024e8:	02d00693          	li	a3,45
800024ec:	34d50c63          	beq	a0,a3,80002844 <z_vprintk+0x434>
800024f0:	03000793          	li	a5,48
800024f4:	0cf50063          	beq	a0,a5,800025b4 <z_vprintk+0x1a4>
800024f8:	02500713          	li	a4,37
800024fc:	02e51263          	bne	a0,a4,80002520 <z_vprintk+0x110>
				out((int)'%', ctx);
80002500:	00048593          	mv	a1,s1
80002504:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80002508:	000400e7          	jalr	s0
				break;
8000250c:	1600006f          	j	8000266c <z_vprintk+0x25c>
80002510:	05800693          	li	a3,88
80002514:	1cd50063          	beq	a0,a3,800026d4 <z_vprintk+0x2c4>
80002518:	06300713          	li	a4,99
8000251c:	30e50063          	beq	a0,a4,8000281c <z_vprintk+0x40c>
				out((int)'%', ctx);
80002520:	00048593          	mv	a1,s1
80002524:	02500513          	li	a0,37
80002528:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
8000252c:	00048593          	mv	a1,s1
80002530:	000ac503          	lbu	a0,0(s5)
80002534:	fd5ff06f          	j	80002508 <z_vprintk+0xf8>
80002538:	07000693          	li	a3,112
8000253c:	16d50c63          	beq	a0,a3,800026b4 <z_vprintk+0x2a4>
80002540:	02a6e063          	bltu	a3,a0,80002560 <z_vprintk+0x150>
80002544:	06900693          	li	a3,105
80002548:	0ad50463          	beq	a0,a3,800025f0 <z_vprintk+0x1e0>
8000254c:	06c00693          	li	a3,108
80002550:	08d50c63          	beq	a0,a3,800025e8 <z_vprintk+0x1d8>
80002554:	06800693          	li	a3,104
80002558:	f6d506e3          	beq	a0,a3,800024c4 <z_vprintk+0xb4>
8000255c:	fc5ff06f          	j	80002520 <z_vprintk+0x110>
80002560:	07500693          	li	a3,117
80002564:	10d50863          	beq	a0,a3,80002674 <z_vprintk+0x264>
80002568:	02a6ee63          	bltu	a3,a0,800025a4 <z_vprintk+0x194>
8000256c:	07300713          	li	a4,115
80002570:	fae518e3          	bne	a0,a4,80002520 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80002574:	000d2c03          	lw	s8,0(s10)
80002578:	004d0b13          	addi	s6,s10,4
8000257c:	000c0b93          	mv	s7,s8
				while (*s)
80002580:	000bc503          	lbu	a0,0(s7)
80002584:	26051a63          	bnez	a0,800027f8 <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
80002588:	00300793          	li	a5,3
8000258c:	00f99863          	bne	s3,a5,8000259c <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80002590:	418b8bb3          	sub	s7,s7,s8
80002594:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80002598:	27704863          	bgtz	s7,80002808 <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
8000259c:	000b0d13          	mv	s10,s6
800025a0:	0cc0006f          	j	8000266c <z_vprintk+0x25c>
800025a4:	07800693          	li	a3,120
800025a8:	12d50663          	beq	a0,a3,800026d4 <z_vprintk+0x2c4>
800025ac:	07a00693          	li	a3,122
800025b0:	fa9ff06f          	j	80002558 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
800025b4:	00095e63          	bgez	s2,800025d0 <z_vprintk+0x1c0>
800025b8:	28098a63          	beqz	s3,8000284c <z_vprintk+0x43c>
					min_width = *fmt - '0';
800025bc:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
800025c0:	f00992e3          	bnez	s3,800024c4 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
800025c4:	00200993          	li	s3,2
800025c8:	efdff06f          	j	800024c4 <z_vprintk+0xb4>
				if (min_width < 0) {
800025cc:	fe0948e3          	bltz	s2,800025bc <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
800025d0:	00291693          	slli	a3,s2,0x2
800025d4:	01268933          	add	s2,a3,s2
800025d8:	00191913          	slli	s2,s2,0x1
800025dc:	fd090913          	addi	s2,s2,-48
800025e0:	01250933          	add	s2,a0,s2
800025e4:	fddff06f          	j	800025c0 <z_vprintk+0x1b0>
				long_ctr++;
800025e8:	001a0a13          	addi	s4,s4,1
800025ec:	ed9ff06f          	j	800024c4 <z_vprintk+0xb4>
				if (long_ctr == 0) {
800025f0:	040a1263          	bnez	s4,80002634 <z_vprintk+0x224>
					long ld = va_arg(ap, long);
800025f4:	000d2603          	lw	a2,0(s10)
800025f8:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
800025fc:	02065063          	bgez	a2,8000261c <z_vprintk+0x20c>
					out((int)'-', ctx);
80002600:	00048593          	mv	a1,s1
80002604:	02d00513          	li	a0,45
80002608:	00c12023          	sw	a2,0(sp)
8000260c:	000400e7          	jalr	s0
					d = -d;
80002610:	00012603          	lw	a2,0(sp)
					min_width--;
80002614:	fff90913          	addi	s2,s2,-1
					d = -d;
80002618:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
8000261c:	00090713          	mv	a4,s2
80002620:	00098693          	mv	a3,s3
80002624:	00048593          	mv	a1,s1
80002628:	00040513          	mv	a0,s0
8000262c:	c7dff0ef          	jal	ra,800022a8 <_printk_dec_ulong>
				break;
80002630:	03c0006f          	j	8000266c <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80002634:	00100713          	li	a4,1
80002638:	faea0ee3          	beq	s4,a4,800025f4 <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
8000263c:	007d0793          	addi	a5,s10,7
80002640:	ff87f713          	andi	a4,a5,-8
80002644:	00072603          	lw	a2,0(a4)
80002648:	00472683          	lw	a3,4(a4)
8000264c:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80002650:	01b60733          	add	a4,a2,s11
80002654:	00c73733          	sltu	a4,a4,a2
80002658:	00d70733          	add	a4,a4,a3
8000265c:	fa0700e3          	beqz	a4,800025fc <z_vprintk+0x1ec>
						print_err(out, ctx);
80002660:	00048593          	mv	a1,s1
80002664:	00040513          	mv	a0,s0
80002668:	bddff0ef          	jal	ra,80002244 <print_err>
			might_format = 0;
8000266c:	00000c93          	li	s9,0
80002670:	e55ff06f          	j	800024c4 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80002674:	000a1863          	bnez	s4,80002684 <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
80002678:	000d2603          	lw	a2,0(s10)
8000267c:	004d0d13          	addi	s10,s10,4
80002680:	f9dff06f          	j	8000261c <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
80002684:	00100713          	li	a4,1
80002688:	feea08e3          	beq	s4,a4,80002678 <z_vprintk+0x268>
					unsigned long long llu =
8000268c:	007d0793          	addi	a5,s10,7
80002690:	ff87f713          	andi	a4,a5,-8
80002694:	00870d13          	addi	s10,a4,8
80002698:	00072603          	lw	a2,0(a4)
8000269c:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
800026a0:	fc0710e3          	bnez	a4,80002660 <z_vprintk+0x250>
800026a4:	800007b7          	lui	a5,0x80000
800026a8:	fff7c793          	not	a5,a5
800026ac:	f6c7f8e3          	bgeu	a5,a2,8000261c <z_vprintk+0x20c>
800026b0:	fb1ff06f          	j	80002660 <z_vprintk+0x250>
				  out('0', ctx);
800026b4:	00048593          	mv	a1,s1
800026b8:	03000513          	li	a0,48
800026bc:	000400e7          	jalr	s0
				  out('x', ctx);
800026c0:	00048593          	mv	a1,s1
800026c4:	07800513          	li	a0,120
800026c8:	000400e7          	jalr	s0
				  min_width = 8;
800026cc:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
800026d0:	00100993          	li	s3,1
				if (long_ctr < 2) {
800026d4:	00100693          	li	a3,1
800026d8:	0b46c263          	blt	a3,s4,8000277c <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
800026dc:	000d2783          	lw	a5,0(s10)
800026e0:	00012423          	sw	zero,8(sp)
800026e4:	004d0d13          	addi	s10,s10,4
800026e8:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
800026ec:	01000c13          	li	s8,16
	int digits = 0;
800026f0:	00000b93          	li	s7,0
	int found_largest_digit = 0;
800026f4:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800026f8:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800026fc:	00412503          	lw	a0,4(sp)
80002700:	00812583          	lw	a1,8(sp)
80002704:	fff88b13          	addi	s6,a7,-1
80002708:	002b1613          	slli	a2,s6,0x2
8000270c:	01112623          	sw	a7,12(sp)
80002710:	b79fd0ef          	jal	ra,80000288 <__lshrdi3>
80002714:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002718:	08051863          	bnez	a0,800027a8 <z_vprintk+0x398>
8000271c:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80002720:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002724:	00079863          	bnez	a5,80002734 <z_vprintk+0x324>
80002728:	00c12883          	lw	a7,12(sp)
8000272c:	00100793          	li	a5,1
80002730:	08f89663          	bne	a7,a5,800027bc <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
80002734:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80002738:	01851513          	slli	a0,a0,0x18
8000273c:	00048593          	mv	a1,s1
80002740:	41855513          	srai	a0,a0,0x18
80002744:	000400e7          	jalr	s0
			digits++;
80002748:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
8000274c:	040b1863          	bnez	s6,8000279c <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
80002750:	00300693          	li	a3,3
			might_format = 0;
80002754:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80002758:	d6d996e3          	bne	s3,a3,800024c4 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
8000275c:	00191713          	slli	a4,s2,0x1
80002760:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80002764:	f17054e3          	blez	s7,8000266c <z_vprintk+0x25c>
			out(' ', ctx);
80002768:	00048593          	mv	a1,s1
8000276c:	02000513          	li	a0,32
80002770:	000400e7          	jalr	s0
80002774:	fffb8b93          	addi	s7,s7,-1
80002778:	fedff06f          	j	80002764 <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
8000277c:	007d0793          	addi	a5,s10,7
80002780:	ff87f693          	andi	a3,a5,-8
80002784:	0006a783          	lw	a5,0(a3)
80002788:	00868d13          	addi	s10,a3,8
8000278c:	00f12223          	sw	a5,4(sp)
80002790:	0046a783          	lw	a5,4(a3)
80002794:	00f12423          	sw	a5,8(sp)
80002798:	f55ff06f          	j	800026ec <z_vprintk+0x2dc>
			found_largest_digit = 1;
8000279c:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800027a0:	000b0893          	mv	a7,s6
800027a4:	f59ff06f          	j	800026fc <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
800027a8:	00900793          	li	a5,9
800027ac:	05700693          	li	a3,87
800027b0:	f8a7e2e3          	bltu	a5,a0,80002734 <z_vprintk+0x324>
800027b4:	03000693          	li	a3,48
800027b8:	f7dff06f          	j	80002734 <z_vprintk+0x324>
		if (remaining-- <= min_width) {
800027bc:	fffc0793          	addi	a5,s8,-1
800027c0:	00f12623          	sw	a5,12(sp)
800027c4:	01894c63          	blt	s2,s8,800027dc <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
800027c8:	00100793          	li	a5,1
800027cc:	00f99c63          	bne	s3,a5,800027e4 <z_vprintk+0x3d4>
				out('0', ctx);
800027d0:	00048593          	mv	a1,s1
800027d4:	03000513          	li	a0,48
				out(' ', ctx);
800027d8:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
800027dc:	00c12c03          	lw	s8,12(sp)
800027e0:	fc1ff06f          	j	800027a0 <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
800027e4:	00200793          	li	a5,2
800027e8:	fef99ae3          	bne	s3,a5,800027dc <z_vprintk+0x3cc>
				out(' ', ctx);
800027ec:	00048593          	mv	a1,s1
800027f0:	02000513          	li	a0,32
800027f4:	fe5ff06f          	j	800027d8 <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
800027f8:	00048593          	mv	a1,s1
800027fc:	001b8b93          	addi	s7,s7,1
80002800:	000400e7          	jalr	s0
80002804:	d7dff06f          	j	80002580 <z_vprintk+0x170>
						out(' ', ctx);
80002808:	00048593          	mv	a1,s1
8000280c:	02000513          	li	a0,32
80002810:	000400e7          	jalr	s0
80002814:	fffb8b93          	addi	s7,s7,-1
80002818:	d81ff06f          	j	80002598 <z_vprintk+0x188>
				out(c, ctx);
8000281c:	000d2503          	lw	a0,0(s10)
80002820:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80002824:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80002828:	000400e7          	jalr	s0
				break;
8000282c:	d71ff06f          	j	8000259c <z_vprintk+0x18c>
				long_ctr = 0;
80002830:	00000a13          	li	s4,0
				min_width = -1;
80002834:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80002838:	00000993          	li	s3,0
				might_format = 1;
8000283c:	00100c93          	li	s9,1
80002840:	c85ff06f          	j	800024c4 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80002844:	00300993          	li	s3,3
80002848:	c7dff06f          	j	800024c4 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
8000284c:	00100993          	li	s3,1
80002850:	c75ff06f          	j	800024c4 <z_vprintk+0xb4>

80002854 <vprintk>:
{
80002854:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80002858:	00050613          	mv	a2,a0
8000285c:	80002537          	lui	a0,0x80002
80002860:	00058693          	mv	a3,a1
80002864:	29050513          	addi	a0,a0,656 # 80002290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002291>
80002868:	00c10593          	addi	a1,sp,12
{
8000286c:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80002870:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80002874:	b9dff0ef          	jal	ra,80002410 <z_vprintk>
}
80002878:	01c12083          	lw	ra,28(sp)
8000287c:	02010113          	addi	sp,sp,32
80002880:	00008067          	ret

80002884 <printk>:
{
80002884:	fc010113          	addi	sp,sp,-64
80002888:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
8000288c:	02410593          	addi	a1,sp,36
{
80002890:	00112e23          	sw	ra,28(sp)
80002894:	02c12423          	sw	a2,40(sp)
80002898:	02d12623          	sw	a3,44(sp)
8000289c:	02e12823          	sw	a4,48(sp)
800028a0:	02f12a23          	sw	a5,52(sp)
800028a4:	03012c23          	sw	a6,56(sp)
800028a8:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
800028ac:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
800028b0:	fa5ff0ef          	jal	ra,80002854 <vprintk>
}
800028b4:	01c12083          	lw	ra,28(sp)
800028b8:	04010113          	addi	sp,sp,64
800028bc:	00008067          	ret

800028c0 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800028c0:	800075b7          	lui	a1,0x80007
800028c4:	80007537          	lui	a0,0x80007
{
800028c8:	ff010113          	addi	sp,sp,-16
  k_panic();
800028cc:	65858593          	addi	a1,a1,1624 # 80007658 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007659>
800028d0:	66c50513          	addi	a0,a0,1644 # 8000766c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000766d>
800028d4:	01e00613          	li	a2,30
{
800028d8:	00112623          	sw	ra,12(sp)
  k_panic();
800028dc:	fa9ff0ef          	jal	ra,80002884 <printk>
800028e0:	800075b7          	lui	a1,0x80007
800028e4:	23858593          	addi	a1,a1,568 # 80007238 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007239>
800028e8:	00600513          	li	a0,6
800028ec:	e05fe0ef          	jal	ra,800016f0 <z_NanoFatalErrorHandler>

800028f0 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800028f0:	00008067          	ret

800028f4 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
800028f4:	00800793          	li	a5,8
800028f8:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800028fc:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80002900:	00008067          	ret

80002904 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80002904:	00100793          	li	a5,1
80002908:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
8000290c:	30452573          	csrrs	a0,mie,a0
}
80002910:	00008067          	ret

80002914 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002914:	00800793          	li	a5,8
80002918:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
8000291c:	30405073          	csrwi	mie,0
80002920:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80002924:	00008067          	ret

80002928 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002928:	ff010113          	addi	sp,sp,-16
8000292c:	00812423          	sw	s0,8(sp)
80002930:	00912223          	sw	s1,4(sp)
80002934:	80008437          	lui	s0,0x80008
80002938:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
8000293c:	00a00793          	li	a5,10
{
80002940:	00050493          	mv	s1,a0
80002944:	d4840413          	addi	s0,s0,-696 # 80007d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d49>
	if ('\n' == c) {
80002948:	00f51c63          	bne	a0,a5,80002960 <console_out+0x38>
8000294c:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80002950:	00d00593          	li	a1,13
80002954:	00452783          	lw	a5,4(a0)
80002958:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
8000295c:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80002960:	00042503          	lw	a0,0(s0)
80002964:	0ff4f593          	andi	a1,s1,255
80002968:	00452783          	lw	a5,4(a0)
8000296c:	0047a783          	lw	a5,4(a5)
80002970:	000780e7          	jalr	a5

	return c;
}
80002974:	00c12083          	lw	ra,12(sp)
80002978:	00812403          	lw	s0,8(sp)
8000297c:	00048513          	mv	a0,s1
80002980:	00412483          	lw	s1,4(sp)
80002984:	01010113          	addi	sp,sp,16
80002988:	00008067          	ret

8000298c <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
8000298c:	ff010113          	addi	sp,sp,-16
80002990:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80002994:	80003437          	lui	s0,0x80003
80002998:	92840513          	addi	a0,s0,-1752 # 80002928 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002929>
{
8000299c:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
800029a0:	5d8000ef          	jal	ra,80002f78 <__stdout_hook_install>
	__printk_hook_install(console_out);
800029a4:	92840513          	addi	a0,s0,-1752
}
800029a8:	00812403          	lw	s0,8(sp)
800029ac:	00c12083          	lw	ra,12(sp)
800029b0:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
800029b4:	a51ff06f          	j	80002404 <__printk_hook_install>

800029b8 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
800029b8:	80007537          	lui	a0,0x80007
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
800029bc:	ff010113          	addi	sp,sp,-16
800029c0:	67850513          	addi	a0,a0,1656 # 80007678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007679>
800029c4:	00112623          	sw	ra,12(sp)
800029c8:	159000ef          	jal	ra,80003320 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
800029cc:	800087b7          	lui	a5,0x80008
800029d0:	d4a7a423          	sw	a0,-696(a5) # 80007d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d49>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
800029d4:	fb9ff0ef          	jal	ra,8000298c <uart_console_hook_install>

	return 0;
}
800029d8:	00c12083          	lw	ra,12(sp)
800029dc:	00000513          	li	a0,0
800029e0:	01010113          	addi	sp,sp,16
800029e4:	00008067          	ret

800029e8 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
800029e8:	f01007b7          	lui	a5,0xf0100
800029ec:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
800029f0:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800029f4:	f447a583          	lw	a1,-188(a5)
800029f8:	fee59ae3          	bne	a1,a4,800029ec <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800029fc:	00008067          	ret

80002a00 <timer_isr>:

static void timer_isr(void *arg)
{
80002a00:	fe010113          	addi	sp,sp,-32
80002a04:	00812c23          	sw	s0,24(sp)
80002a08:	00112e23          	sw	ra,28(sp)
80002a0c:	00912a23          	sw	s1,20(sp)
80002a10:	01212823          	sw	s2,16(sp)
80002a14:	01312623          	sw	s3,12(sp)
80002a18:	01412423          	sw	s4,8(sp)
80002a1c:	01512223          	sw	s5,4(sp)
80002a20:	00800413          	li	s0,8
80002a24:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002a28:	80008937          	lui	s2,0x80008
80002a2c:	d4c90513          	addi	a0,s2,-692 # 80007d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d4d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002a30:	00847413          	andi	s0,s0,8
80002a34:	639020ef          	jal	ra,8000586c <z_spin_lock_valid>
80002a38:	02051e63          	bnez	a0,80002a74 <timer_isr+0x74>
80002a3c:	800074b7          	lui	s1,0x80007
80002a40:	800075b7          	lui	a1,0x80007
80002a44:	80007537          	lui	a0,0x80007
80002a48:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80002a4c:	04e00693          	li	a3,78
80002a50:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80002a54:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80002a58:	e2dff0ef          	jal	ra,80002884 <printk>
80002a5c:	80007537          	lui	a0,0x80007
80002a60:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80002a64:	e21ff0ef          	jal	ra,80002884 <printk>
80002a68:	04e00593          	li	a1,78
80002a6c:	68c48513          	addi	a0,s1,1676
80002a70:	e51ff0ef          	jal	ra,800028c0 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80002a74:	d4c90513          	addi	a0,s2,-692
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002a78:	800084b7          	lui	s1,0x80008
80002a7c:	649020ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
80002a80:	d3048493          	addi	s1,s1,-720 # 80007d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d31>
	u64_t now = mtime();
80002a84:	f65ff0ef          	jal	ra,800029e8 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002a88:	0004a983          	lw	s3,0(s1)
80002a8c:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80002a90:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002a94:	41350533          	sub	a0,a0,s3
80002a98:	00a7b7b3          	sltu	a5,a5,a0
80002a9c:	415585b3          	sub	a1,a1,s5
80002aa0:	0001d637          	lui	a2,0x1d
80002aa4:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002aa8:	00000693          	li	a3,0
80002aac:	40f585b3          	sub	a1,a1,a5
80002ab0:	811fd0ef          	jal	ra,800002c0 <__udivdi3>
80002ab4:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80002ab8:	0001d5b7          	lui	a1,0x1d
80002abc:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002ac0:	000a0513          	mv	a0,s4
80002ac4:	dd1fd0ef          	jal	ra,80000894 <__mulsi3>
80002ac8:	013509b3          	add	s3,a0,s3
80002acc:	00a9b533          	sltu	a0,s3,a0
80002ad0:	01550533          	add	a0,a0,s5
80002ad4:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ad8:	d4c90513          	addi	a0,s2,-692
80002adc:	0134a023          	sw	s3,0(s1)
80002ae0:	5b5020ef          	jal	ra,80005894 <z_spin_unlock_valid>
80002ae4:	02051e63          	bnez	a0,80002b20 <timer_isr+0x120>
80002ae8:	800074b7          	lui	s1,0x80007
80002aec:	800075b7          	lui	a1,0x80007
80002af0:	80007537          	lui	a0,0x80007
80002af4:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80002af8:	06100693          	li	a3,97
80002afc:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80002b00:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80002b04:	d81ff0ef          	jal	ra,80002884 <printk>
80002b08:	80007537          	lui	a0,0x80007
80002b0c:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80002b10:	d75ff0ef          	jal	ra,80002884 <printk>
80002b14:	06100593          	li	a1,97
80002b18:	68c48513          	addi	a0,s1,1676
80002b1c:	da5ff0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b20:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002b24:	01812403          	lw	s0,24(sp)
80002b28:	01c12083          	lw	ra,28(sp)
80002b2c:	01412483          	lw	s1,20(sp)
80002b30:	01012903          	lw	s2,16(sp)
80002b34:	00c12983          	lw	s3,12(sp)
80002b38:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002b3c:	000a0513          	mv	a0,s4
}
80002b40:	00812a03          	lw	s4,8(sp)
80002b44:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002b48:	7700306f          	j	800062b8 <z_clock_announce>

80002b4c <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002b4c:	ff010113          	addi	sp,sp,-16
80002b50:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002b54:	e95ff0ef          	jal	ra,800029e8 <mtime>
80002b58:	0001d7b7          	lui	a5,0x1d
80002b5c:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80002b60:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002b64:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80002b68:	fff00693          	li	a3,-1
80002b6c:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002b70:	00a7b533          	sltu	a0,a5,a0
80002b74:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80002b78:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002b7c:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80002b80:	00700513          	li	a0,7
80002b84:	d81ff0ef          	jal	ra,80002904 <z_arch_irq_enable>
	return 0;
}
80002b88:	00c12083          	lw	ra,12(sp)
80002b8c:	00000513          	li	a0,0
80002b90:	01010113          	addi	sp,sp,16
80002b94:	00008067          	ret

80002b98 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002b98:	1a059263          	bnez	a1,80002d3c <z_clock_set_timeout+0x1a4>
{
80002b9c:	fe010113          	addi	sp,sp,-32
80002ba0:	00112e23          	sw	ra,28(sp)
80002ba4:	00812c23          	sw	s0,24(sp)
80002ba8:	00912a23          	sw	s1,20(sp)
80002bac:	01212823          	sw	s2,16(sp)
80002bb0:	01312623          	sw	s3,12(sp)
80002bb4:	01412423          	sw	s4,8(sp)
80002bb8:	01512223          	sw	s5,4(sp)
80002bbc:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80002bc0:	fff00793          	li	a5,-1
80002bc4:	00f51663          	bne	a0,a5,80002bd0 <z_clock_set_timeout+0x38>
80002bc8:	00009537          	lui	a0,0x9
80002bcc:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80002bd0:	000097b7          	lui	a5,0x9
80002bd4:	fff50413          	addi	s0,a0,-1
80002bd8:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80002bdc:	1487da63          	bge	a5,s0,80002d30 <z_clock_set_timeout+0x198>
80002be0:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002be4:	00800913          	li	s2,8
80002be8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002bec:	80008ab7          	lui	s5,0x80008
80002bf0:	d4ca8513          	addi	a0,s5,-692 # 80007d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d4d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002bf4:	00897913          	andi	s2,s2,8
80002bf8:	475020ef          	jal	ra,8000586c <z_spin_lock_valid>
80002bfc:	02051e63          	bnez	a0,80002c38 <z_clock_set_timeout+0xa0>
80002c00:	800074b7          	lui	s1,0x80007
80002c04:	800075b7          	lui	a1,0x80007
80002c08:	80007537          	lui	a0,0x80007
80002c0c:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80002c10:	04e00693          	li	a3,78
80002c14:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80002c18:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80002c1c:	c69ff0ef          	jal	ra,80002884 <printk>
80002c20:	80007537          	lui	a0,0x80007
80002c24:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80002c28:	c5dff0ef          	jal	ra,80002884 <printk>
80002c2c:	04e00593          	li	a1,78
80002c30:	68c48513          	addi	a0,s1,1676
80002c34:	c8dff0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002c38:	d4ca8513          	addi	a0,s5,-692
80002c3c:	489020ef          	jal	ra,800058c4 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002c40:	da9ff0ef          	jal	ra,800029e8 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002c44:	800087b7          	lui	a5,0x80008
80002c48:	d3078793          	addi	a5,a5,-720 # 80007d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d31>
	u32_t cyc = ticks * CYC_PER_TICK;
80002c4c:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002c50:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80002c54:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80002c58:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002c5c:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002c60:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002c64:	c31fd0ef          	jal	ra,80000894 <__mulsi3>
80002c68:	4bf48793          	addi	a5,s1,1215
80002c6c:	413787b3          	sub	a5,a5,s3
80002c70:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002c74:	4c048593          	addi	a1,s1,1216
80002c78:	00aa0533          	add	a0,s4,a0
80002c7c:	cd5fd0ef          	jal	ra,80000950 <__udivsi3>
80002c80:	4c048593          	addi	a1,s1,1216
80002c84:	c11fd0ef          	jal	ra,80000894 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002c88:	41498a33          	sub	s4,s3,s4
80002c8c:	00aa0a33          	add	s4,s4,a0
80002c90:	3e700793          	li	a5,999
80002c94:	0147c663          	blt	a5,s4,80002ca0 <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
80002c98:	4c048493          	addi	s1,s1,1216
80002c9c:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
80002ca0:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002ca4:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80002ca8:	fff00713          	li	a4,-1
80002cac:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002cb0:	00a9b533          	sltu	a0,s3,a0
80002cb4:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
80002cb8:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80002cbc:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002cc0:	d4ca8513          	addi	a0,s5,-692
80002cc4:	3d1020ef          	jal	ra,80005894 <z_spin_unlock_valid>
80002cc8:	02051e63          	bnez	a0,80002d04 <z_clock_set_timeout+0x16c>
80002ccc:	80007437          	lui	s0,0x80007
80002cd0:	800075b7          	lui	a1,0x80007
80002cd4:	80007537          	lui	a0,0x80007
80002cd8:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80002cdc:	06100693          	li	a3,97
80002ce0:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80002ce4:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80002ce8:	b9dff0ef          	jal	ra,80002884 <printk>
80002cec:	80007537          	lui	a0,0x80007
80002cf0:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80002cf4:	b91ff0ef          	jal	ra,80002884 <printk>
80002cf8:	06100593          	li	a1,97
80002cfc:	68c40513          	addi	a0,s0,1676
80002d00:	bc1ff0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d04:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80002d08:	01c12083          	lw	ra,28(sp)
80002d0c:	01812403          	lw	s0,24(sp)
80002d10:	01412483          	lw	s1,20(sp)
80002d14:	01012903          	lw	s2,16(sp)
80002d18:	00c12983          	lw	s3,12(sp)
80002d1c:	00812a03          	lw	s4,8(sp)
80002d20:	00412a83          	lw	s5,4(sp)
80002d24:	00012b03          	lw	s6,0(sp)
80002d28:	02010113          	addi	sp,sp,32
80002d2c:	00008067          	ret
80002d30:	ea045ae3          	bgez	s0,80002be4 <z_clock_set_timeout+0x4c>
80002d34:	00000413          	li	s0,0
80002d38:	eadff06f          	j	80002be4 <z_clock_set_timeout+0x4c>
80002d3c:	00008067          	ret

80002d40 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002d40:	ff010113          	addi	sp,sp,-16
80002d44:	00812423          	sw	s0,8(sp)
80002d48:	00112623          	sw	ra,12(sp)
80002d4c:	00912223          	sw	s1,4(sp)
80002d50:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d54:	00800413          	li	s0,8
80002d58:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d5c:	800084b7          	lui	s1,0x80008
80002d60:	d4c48513          	addi	a0,s1,-692 # 80007d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d4d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002d64:	00847413          	andi	s0,s0,8
80002d68:	305020ef          	jal	ra,8000586c <z_spin_lock_valid>
80002d6c:	02051e63          	bnez	a0,80002da8 <z_clock_elapsed+0x68>
80002d70:	80007937          	lui	s2,0x80007
80002d74:	800075b7          	lui	a1,0x80007
80002d78:	80007537          	lui	a0,0x80007
80002d7c:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80002d80:	04e00693          	li	a3,78
80002d84:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80002d88:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80002d8c:	af9ff0ef          	jal	ra,80002884 <printk>
80002d90:	80007537          	lui	a0,0x80007
80002d94:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80002d98:	aedff0ef          	jal	ra,80002884 <printk>
80002d9c:	04e00593          	li	a1,78
80002da0:	68c90513          	addi	a0,s2,1676
80002da4:	b1dff0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002da8:	d4c48513          	addi	a0,s1,-692
80002dac:	319020ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002db0:	c39ff0ef          	jal	ra,800029e8 <mtime>
80002db4:	800087b7          	lui	a5,0x80008
80002db8:	d307a783          	lw	a5,-720(a5) # 80007d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d31>
80002dbc:	0001d5b7          	lui	a1,0x1d
80002dc0:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002dc4:	40f50533          	sub	a0,a0,a5
80002dc8:	b89fd0ef          	jal	ra,80000950 <__udivsi3>
80002dcc:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002dd0:	d4c48513          	addi	a0,s1,-692
80002dd4:	2c1020ef          	jal	ra,80005894 <z_spin_unlock_valid>
80002dd8:	02051e63          	bnez	a0,80002e14 <z_clock_elapsed+0xd4>
80002ddc:	800074b7          	lui	s1,0x80007
80002de0:	800075b7          	lui	a1,0x80007
80002de4:	80007537          	lui	a0,0x80007
80002de8:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80002dec:	06100693          	li	a3,97
80002df0:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80002df4:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80002df8:	a8dff0ef          	jal	ra,80002884 <printk>
80002dfc:	80007537          	lui	a0,0x80007
80002e00:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80002e04:	a81ff0ef          	jal	ra,80002884 <printk>
80002e08:	06100593          	li	a1,97
80002e0c:	68c48513          	addi	a0,s1,1676
80002e10:	ab1ff0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002e14:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002e18:	00c12083          	lw	ra,12(sp)
80002e1c:	00812403          	lw	s0,8(sp)
80002e20:	00090513          	mv	a0,s2
80002e24:	00412483          	lw	s1,4(sp)
80002e28:	00012903          	lw	s2,0(sp)
80002e2c:	01010113          	addi	sp,sp,16
80002e30:	00008067          	ret

80002e34 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002e34:	00054783          	lbu	a5,0(a0)
80002e38:	0005c703          	lbu	a4,0(a1)
80002e3c:	00e79463          	bne	a5,a4,80002e44 <strcmp+0x10>
80002e40:	00079663          	bnez	a5,80002e4c <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002e44:	40e78533          	sub	a0,a5,a4
80002e48:	00008067          	ret
		s1++;
80002e4c:	00150513          	addi	a0,a0,1
		s2++;
80002e50:	00158593          	addi	a1,a1,1
80002e54:	fe1ff06f          	j	80002e34 <strcmp>

80002e58 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80002e58:	00b547b3          	xor	a5,a0,a1
80002e5c:	0037f793          	andi	a5,a5,3
80002e60:	04078c63          	beqz	a5,80002eb8 <memcpy+0x60>
	unsigned char *d_byte = (unsigned char *)d;
80002e64:	00050793          	mv	a5,a0
80002e68:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80002e6c:	06e61663          	bne	a2,a4,80002ed8 <memcpy+0x80>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80002e70:	00008067          	ret
			if (n == 0) {
80002e74:	fe060ee3          	beqz	a2,80002e70 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80002e78:	00158593          	addi	a1,a1,1
80002e7c:	fff5c703          	lbu	a4,-1(a1)
80002e80:	00178793          	addi	a5,a5,1
			n--;
80002e84:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80002e88:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80002e8c:	0037f713          	andi	a4,a5,3
80002e90:	fe0712e3          	bnez	a4,80002e74 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
80002e94:	00300693          	li	a3,3
80002e98:	40e60833          	sub	a6,a2,a4
80002e9c:	0306e263          	bltu	a3,a6,80002ec0 <memcpy+0x68>
80002ea0:	00265713          	srli	a4,a2,0x2
80002ea4:	00271693          	slli	a3,a4,0x2
80002ea8:	40d60633          	sub	a2,a2,a3
80002eac:	00d787b3          	add	a5,a5,a3
80002eb0:	00d585b3          	add	a1,a1,a3
80002eb4:	fb5ff06f          	j	80002e68 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
80002eb8:	00050793          	mv	a5,a0
80002ebc:	fd1ff06f          	j	80002e8c <memcpy+0x34>
			*(d_word++) = *(s_word++);
80002ec0:	00e588b3          	add	a7,a1,a4
80002ec4:	0008a883          	lw	a7,0(a7)
80002ec8:	00e78833          	add	a6,a5,a4
80002ecc:	00470713          	addi	a4,a4,4
80002ed0:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80002ed4:	fc5ff06f          	j	80002e98 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
80002ed8:	00e58833          	add	a6,a1,a4
80002edc:	00084803          	lbu	a6,0(a6)
80002ee0:	00e786b3          	add	a3,a5,a4
80002ee4:	00170713          	addi	a4,a4,1
80002ee8:	01068023          	sb	a6,0(a3)
		n--;
80002eec:	f81ff06f          	j	80002e6c <memcpy+0x14>

80002ef0 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002ef0:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002ef4:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80002ef8:	0037f713          	andi	a4,a5,3
80002efc:	04071463          	bnez	a4,80002f44 <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002f00:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002f04:	00859713          	slli	a4,a1,0x8
80002f08:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002f0c:	01059713          	slli	a4,a1,0x10
80002f10:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002f14:	00c78333          	add	t1,a5,a2
80002f18:	00078713          	mv	a4,a5
80002f1c:	00300813          	li	a6,3
80002f20:	40e308b3          	sub	a7,t1,a4
80002f24:	03186a63          	bltu	a6,a7,80002f58 <memset+0x68>
80002f28:	00265713          	srli	a4,a2,0x2
80002f2c:	00271593          	slli	a1,a4,0x2
80002f30:	00b787b3          	add	a5,a5,a1
80002f34:	40b60633          	sub	a2,a2,a1
80002f38:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002f3c:	02c79463          	bne	a5,a2,80002f64 <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002f40:	00008067          	ret
		if (n == 0) {
80002f44:	fe060ee3          	beqz	a2,80002f40 <memset+0x50>
		*(d_byte++) = c_byte;
80002f48:	00178793          	addi	a5,a5,1
80002f4c:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002f50:	fff60613          	addi	a2,a2,-1
80002f54:	fa5ff06f          	j	80002ef8 <memset+0x8>
		*(d_word++) = c_word;
80002f58:	00470713          	addi	a4,a4,4
80002f5c:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80002f60:	fc1ff06f          	j	80002f20 <memset+0x30>
		*(d_byte++) = c_byte;
80002f64:	00178793          	addi	a5,a5,1
80002f68:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002f6c:	fd1ff06f          	j	80002f3c <memset+0x4c>

80002f70 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80002f70:	fff00513          	li	a0,-1
80002f74:	00008067          	ret

80002f78 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002f78:	800087b7          	lui	a5,0x80008
80002f7c:	caa7a623          	sw	a0,-852(a5) # 80007cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cad>
}
80002f80:	00008067          	ret

80002f84 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002f84:	fe010113          	addi	sp,sp,-32
80002f88:	00812c23          	sw	s0,24(sp)
	test->setup();
80002f8c:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80002f90:	80008437          	lui	s0,0x80008
{
80002f94:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002f98:	cb040413          	addi	s0,s0,-848 # 80007cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cb1>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002f9c:	800084b7          	lui	s1,0x80008
{
80002fa0:	00112e23          	sw	ra,28(sp)
80002fa4:	01212823          	sw	s2,16(sp)
80002fa8:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002fac:	d5048493          	addi	s1,s1,-688 # 80007d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d51>
80002fb0:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002fb4:	00042023          	sw	zero,0(s0)
{
80002fb8:	00050913          	mv	s2,a0
	test_result = 1;
80002fbc:	0134a023          	sw	s3,0(s1)
	test->setup();
80002fc0:	000780e7          	jalr	a5
	test->test();
80002fc4:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002fc8:	01342023          	sw	s3,0(s0)
	test->test();
80002fcc:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002fd0:	00200793          	li	a5,2
80002fd4:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002fd8:	00c92783          	lw	a5,12(s2)
80002fdc:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002fe0:	00300793          	li	a5,3
80002fe4:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002fe8:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002fec:	0004a023          	sw	zero,0(s1)
}
80002ff0:	01c12083          	lw	ra,28(sp)
80002ff4:	01412483          	lw	s1,20(sp)
80002ff8:	01012903          	lw	s2,16(sp)
80002ffc:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80003000:	80008537          	lui	a0,0x80008
80003004:	f7850513          	addi	a0,a0,-136 # 80007f78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f79>
80003008:	02010113          	addi	sp,sp,32
8000300c:	4a40206f          	j	800054b0 <z_impl_k_sem_give>

80003010 <ztest_test_fail>:
80003010:	80008537          	lui	a0,0x80008
{
80003014:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80003018:	800087b7          	lui	a5,0x80008
8000301c:	fff00713          	li	a4,-1
80003020:	f7850513          	addi	a0,a0,-136 # 80007f78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f79>
{
80003024:	00112623          	sw	ra,12(sp)
	test_result = -1;
80003028:	d4e7a823          	sw	a4,-688(a5) # 80007d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d51>
8000302c:	484020ef          	jal	ra,800054b0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80003030:	3ac020ef          	jal	ra,800053dc <z_impl_k_current_get>
}
80003034:	00c12083          	lw	ra,12(sp)
80003038:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000303c:	3b90206f          	j	80005bf4 <z_impl_k_thread_abort>

80003040 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80003040:	fa010113          	addi	sp,sp,-96
80003044:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80003048:	800084b7          	lui	s1,0x80008
8000304c:	d544a783          	lw	a5,-684(s1) # 80007d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d55>
{
80003050:	04112e23          	sw	ra,92(sp)
80003054:	04812c23          	sw	s0,88(sp)
80003058:	05212823          	sw	s2,80(sp)
8000305c:	05312623          	sw	s3,76(sp)
80003060:	05412423          	sw	s4,72(sp)
80003064:	05512223          	sw	s5,68(sp)
80003068:	05612023          	sw	s6,64(sp)
8000306c:	03712e23          	sw	s7,60(sp)
80003070:	03812c23          	sw	s8,56(sp)
80003074:	03912a23          	sw	s9,52(sp)
80003078:	03a12823          	sw	s10,48(sp)
8000307c:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
80003080:	0807c463          	bltz	a5,80003108 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80003084:	80008437          	lui	s0,0x80008
80003088:	00100613          	li	a2,1
8000308c:	00050993          	mv	s3,a0
80003090:	00058c13          	mv	s8,a1
80003094:	f7840513          	addi	a0,s0,-136 # 80007f78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f79>
80003098:	00000593          	li	a1,0
8000309c:	34c020ef          	jal	ra,800053e8 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800030a0:	80007537          	lui	a0,0x80007
800030a4:	00098593          	mv	a1,s3
800030a8:	74850513          	addi	a0,a0,1864 # 80007748 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007749>
800030ac:	fd8ff0ef          	jal	ra,80002884 <printk>
	PRINT_LINE;
800030b0:	80007937          	lui	s2,0x80007
800030b4:	76090513          	addi	a0,s2,1888 # 80007760 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007761>
		Z_TC_END_RESULT(ret, test->name);
800030b8:	80007ab7          	lui	s5,0x80007
	PRINT_LINE;
800030bc:	fc8ff0ef          	jal	ra,80002884 <printk>
800030c0:	d5448493          	addi	s1,s1,-684
	int fail = 0;
800030c4:	00000a13          	li	s4,0
800030c8:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800030cc:	80008cb7          	lui	s9,0x80008
800030d0:	80008b37          	lui	s6,0x80008
800030d4:	80003d37          	lui	s10,0x80003
	if (test_result == -1) {
800030d8:	80008db7          	lui	s11,0x80008
800030dc:	80007bb7          	lui	s7,0x80007
		Z_TC_END_RESULT(ret, test->name);
800030e0:	700a8a93          	addi	s5,s5,1792 # 80007700 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007701>
	while (suite->test) {
800030e4:	004c2783          	lw	a5,4(s8)
800030e8:	04079e63          	bnez	a5,80003144 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
800030ec:	00098593          	mv	a1,s3
	if (fail) {
800030f0:	100a0663          	beqz	s4,800031fc <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
800030f4:	80007537          	lui	a0,0x80007
800030f8:	7d050513          	addi	a0,a0,2000 # 800077d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077d1>
800030fc:	f88ff0ef          	jal	ra,80002884 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80003100:	00100793          	li	a5,1
80003104:	00f4a023          	sw	a5,0(s1)
}
80003108:	05c12083          	lw	ra,92(sp)
8000310c:	05812403          	lw	s0,88(sp)
80003110:	05412483          	lw	s1,84(sp)
80003114:	05012903          	lw	s2,80(sp)
80003118:	04c12983          	lw	s3,76(sp)
8000311c:	04812a03          	lw	s4,72(sp)
80003120:	04412a83          	lw	s5,68(sp)
80003124:	04012b03          	lw	s6,64(sp)
80003128:	03c12b83          	lw	s7,60(sp)
8000312c:	03812c03          	lw	s8,56(sp)
80003130:	03412c83          	lw	s9,52(sp)
80003134:	03012d03          	lw	s10,48(sp)
80003138:	02c12d83          	lw	s11,44(sp)
8000313c:	06010113          	addi	sp,sp,96
80003140:	00008067          	ret
	TC_START(test->name);
80003144:	000c2583          	lw	a1,0(s8)
80003148:	800077b7          	lui	a5,0x80007
8000314c:	7a878513          	addi	a0,a5,1960 # 800077a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077a9>
80003150:	f34ff0ef          	jal	ra,80002884 <printk>
80003154:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80003158:	010c2783          	lw	a5,16(s8)
8000315c:	000c0713          	mv	a4,s8
80003160:	40000613          	li	a2,1024
80003164:	0087e793          	ori	a5,a5,8
80003168:	fff00893          	li	a7,-1
8000316c:	00000813          	li	a6,0
80003170:	f84d0693          	addi	a3,s10,-124 # 80002f84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002f85>
80003174:	00f12023          	sw	a5,0(sp)
80003178:	710c8593          	addi	a1,s9,1808 # 80008710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008711>
8000317c:	00000793          	li	a5,0
80003180:	f88b0513          	addi	a0,s6,-120 # 80007f88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f89>
80003184:	0cd020ef          	jal	ra,80005a50 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80003188:	01c12783          	lw	a5,28(sp)
8000318c:	fff00593          	li	a1,-1
80003190:	f7878513          	addi	a0,a5,-136
80003194:	400020ef          	jal	ra,80005594 <z_impl_k_sem_take>
	if (test_result == -1) {
80003198:	d50d8793          	addi	a5,s11,-688 # 80007d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d51>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000319c:	f88b0513          	addi	a0,s6,-120
800031a0:	0007a403          	lw	s0,0(a5)
800031a4:	251020ef          	jal	ra,80005bf4 <z_impl_k_thread_abort>
	if (test_result == -2) {
800031a8:	800087b7          	lui	a5,0x80008
800031ac:	d5078793          	addi	a5,a5,-688 # 80007d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d51>
800031b0:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
800031b4:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
800031b8:	ffe00793          	li	a5,-2
	if (test_result == -1) {
800031bc:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800031c0:	000c2603          	lw	a2,0(s8)
800031c4:	02f71463          	bne	a4,a5,800031ec <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800031c8:	800075b7          	lui	a1,0x80007
800031cc:	7bc58593          	addi	a1,a1,1980 # 800077bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077bd>
		Z_TC_END_RESULT(ret, test->name);
800031d0:	7c4b8513          	addi	a0,s7,1988 # 800077c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077c5>
800031d4:	eb0ff0ef          	jal	ra,80002884 <printk>
800031d8:	76090513          	addi	a0,s2,1888
800031dc:	ea8ff0ef          	jal	ra,80002884 <printk>
		fail += run_test(suite);
800031e0:	008a0a33          	add	s4,s4,s0
		suite++;
800031e4:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
800031e8:	efdff06f          	j	800030e4 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
800031ec:	00241793          	slli	a5,s0,0x2
800031f0:	00fa87b3          	add	a5,s5,a5
800031f4:	0007a583          	lw	a1,0(a5)
800031f8:	fd9ff06f          	j	800031d0 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
800031fc:	80007537          	lui	a0,0x80007
80003200:	7e850513          	addi	a0,a0,2024 # 800077e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077e9>
80003204:	e80ff0ef          	jal	ra,80002884 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80003208:	0004a783          	lw	a5,0(s1)
8000320c:	00f037b3          	snez	a5,a5
80003210:	ef5ff06f          	j	80003104 <z_ztest_run_test_suite+0xc4>

80003214 <end_report>:

void end_report(void)
{
	if (test_status) {
80003214:	800087b7          	lui	a5,0x80008
80003218:	d547a783          	lw	a5,-684(a5) # 80007d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d55>
{
8000321c:	ff010113          	addi	sp,sp,-16
80003220:	00812423          	sw	s0,8(sp)
80003224:	80007537          	lui	a0,0x80007
80003228:	00112623          	sw	ra,12(sp)
8000322c:	80007437          	lui	s0,0x80007
		TC_END_REPORT(TC_FAIL);
80003230:	76050513          	addi	a0,a0,1888 # 80007760 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007761>
	if (test_status) {
80003234:	02078263          	beqz	a5,80003258 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80003238:	e4cff0ef          	jal	ra,80002884 <printk>
8000323c:	800075b7          	lui	a1,0x80007
80003240:	70c58593          	addi	a1,a1,1804 # 8000770c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000770d>
	} else {
		TC_END_REPORT(TC_PASS);
80003244:	71440513          	addi	a0,s0,1812 # 80007714 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007715>
	}
}
80003248:	00812403          	lw	s0,8(sp)
8000324c:	00c12083          	lw	ra,12(sp)
80003250:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80003254:	e30ff06f          	j	80002884 <printk>
80003258:	e2cff0ef          	jal	ra,80002884 <printk>
8000325c:	800075b7          	lui	a1,0x80007
80003260:	72c58593          	addi	a1,a1,1836 # 8000772c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000772d>
80003264:	fe1ff06f          	j	80003244 <end_report+0x30>

80003268 <main>:

	return test_status;
}
#else
void main(void)
{
80003268:	ff010113          	addi	sp,sp,-16
8000326c:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80003270:	f90fd0ef          	jal	ra,80000a00 <test_main>
	end_report();
}
80003274:	00c12083          	lw	ra,12(sp)
80003278:	01010113          	addi	sp,sp,16
	end_report();
8000327c:	f99ff06f          	j	80003214 <end_report>

80003280 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80003280:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80003284:	00012623          	sw	zero,12(sp)
    i++;
80003288:	00c12783          	lw	a5,12(sp)
8000328c:	00178793          	addi	a5,a5,1
80003290:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80003294:	f00107b7          	lui	a5,0xf0010
80003298:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
8000329c:	01010113          	addi	sp,sp,16
800032a0:	00008067          	ret

800032a4 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800032a4:	fff00513          	li	a0,-1
800032a8:	00008067          	ret

800032ac <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
800032ac:	00000513          	li	a0,0
800032b0:	00008067          	ret

800032b4 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800032b4:	00251713          	slli	a4,a0,0x2
800032b8:	800087b7          	lui	a5,0x80008
800032bc:	00150513          	addi	a0,a0,1
800032c0:	81878793          	addi	a5,a5,-2024 # 80007818 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007819>
800032c4:	00251513          	slli	a0,a0,0x2
{
800032c8:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800032cc:	00e78733          	add	a4,a5,a4
800032d0:	00a787b3          	add	a5,a5,a0
{
800032d4:	00812423          	sw	s0,8(sp)
800032d8:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800032dc:	00072403          	lw	s0,0(a4)
800032e0:	0007a483          	lw	s1,0(a5)
{
800032e4:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800032e8:	00946c63          	bltu	s0,s1,80003300 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800032ec:	00c12083          	lw	ra,12(sp)
800032f0:	00812403          	lw	s0,8(sp)
800032f4:	00412483          	lw	s1,4(sp)
800032f8:	01010113          	addi	sp,sp,16
800032fc:	00008067          	ret
		retval = device_conf->init(info);
80003300:	00042783          	lw	a5,0(s0)
80003304:	00040513          	mv	a0,s0
80003308:	0047a783          	lw	a5,4(a5)
8000330c:	000780e7          	jalr	a5
		if (retval != 0) {
80003310:	00050463          	beqz	a0,80003318 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80003314:	00042223          	sw	zero,4(s0)
								info++) {
80003318:	00c40413          	addi	s0,s0,12
8000331c:	fcdff06f          	j	800032e8 <z_sys_device_do_config_level+0x34>

80003320 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80003320:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80003324:	800087b7          	lui	a5,0x80008
{
80003328:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
8000332c:	800084b7          	lui	s1,0x80008
{
80003330:	00812423          	sw	s0,8(sp)
80003334:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80003338:	cc478413          	addi	s0,a5,-828 # 80007cc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cc5>
{
8000333c:	01212023          	sw	s2,0(sp)
80003340:	cc478793          	addi	a5,a5,-828
80003344:	cf448493          	addi	s1,s1,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003348:	00941c63          	bne	s0,s1,80003360 <z_impl_device_get_binding+0x40>
8000334c:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80003350:	00078413          	mv	s0,a5
80003354:	02941463          	bne	s0,s1,8000337c <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80003358:	00000413          	li	s0,0
8000335c:	0440006f          	j	800033a0 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80003360:	00442703          	lw	a4,4(s0)
80003364:	00070863          	beqz	a4,80003374 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80003368:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
8000336c:	00072703          	lw	a4,0(a4)
80003370:	02a70863          	beq	a4,a0,800033a0 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003374:	00c40413          	addi	s0,s0,12
80003378:	fd1ff06f          	j	80003348 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
8000337c:	00442783          	lw	a5,4(s0)
80003380:	00079663          	bnez	a5,8000338c <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003384:	00c40413          	addi	s0,s0,12
80003388:	fcdff06f          	j	80003354 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
8000338c:	00042783          	lw	a5,0(s0)
80003390:	00090513          	mv	a0,s2
80003394:	0007a583          	lw	a1,0(a5)
80003398:	a9dff0ef          	jal	ra,80002e34 <strcmp>
8000339c:	fe0514e3          	bnez	a0,80003384 <z_impl_device_get_binding+0x64>
}
800033a0:	00040513          	mv	a0,s0
800033a4:	00c12083          	lw	ra,12(sp)
800033a8:	00812403          	lw	s0,8(sp)
800033ac:	00412483          	lw	s1,4(sp)
800033b0:	00012903          	lw	s2,0(sp)
800033b4:	01010113          	addi	sp,sp,16
800033b8:	00008067          	ret

800033bc <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
800033bc:	ff010113          	addi	sp,sp,-16
800033c0:	00812423          	sw	s0,8(sp)
800033c4:	00912223          	sw	s1,4(sp)
800033c8:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033cc:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800033d0:	00200493          	li	s1,2
800033d4:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
800033d8:	501020ef          	jal	ra,800060d8 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800033dc:	00a4c463          	blt	s1,a0,800033e4 <idle+0x28>
800033e0:	00100513          	li	a0,1
800033e4:	00100593          	li	a1,1
800033e8:	5cd020ef          	jal	ra,800061b4 <z_set_timeout_expiry>
	k_cpu_idle();
800033ec:	d08ff0ef          	jal	ra,800028f4 <k_cpu_idle>
800033f0:	fe5ff06f          	j	800033d4 <idle+0x18>

800033f4 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
800033f4:	80008537          	lui	a0,0x80008
800033f8:	800087b7          	lui	a5,0x80008
800033fc:	d3050613          	addi	a2,a0,-720 # 80007d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d31>
80003400:	10478793          	addi	a5,a5,260 # 80008104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008105>
80003404:	40c78633          	sub	a2,a5,a2
80003408:	00000593          	li	a1,0
8000340c:	d3050513          	addi	a0,a0,-720
80003410:	ae1ff06f          	j	80002ef0 <memset>

80003414 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80003414:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80003418:	00200513          	li	a0,2
{
8000341c:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80003420:	e95ff0ef          	jal	ra,800032b4 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80003424:	80008537          	lui	a0,0x80008
80003428:	82c50513          	addi	a0,a0,-2004 # 8000782c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000782d>
8000342c:	c58ff0ef          	jal	ra,80002884 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80003430:	00300513          	li	a0,3
80003434:	e81ff0ef          	jal	ra,800032b4 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80003438:	70c020ef          	jal	ra,80005b44 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
8000343c:	e2dff0ef          	jal	ra,80003268 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80003440:	800087b7          	lui	a5,0x80008
80003444:	06878793          	addi	a5,a5,104 # 80008068 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008069>
80003448:	00c7c703          	lbu	a4,12(a5)
8000344c:	ffe77713          	andi	a4,a4,-2
80003450:	00e78623          	sb	a4,12(a5)
}
80003454:	00c12083          	lw	ra,12(sp)
80003458:	01010113          	addi	sp,sp,16
8000345c:	00008067          	ret

80003460 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80003460:	f6010113          	addi	sp,sp,-160
80003464:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80003468:	800097b7          	lui	a5,0x80009
8000346c:	80008437          	lui	s0,0x80008
80003470:	09312623          	sw	s3,140(sp)
80003474:	71078793          	addi	a5,a5,1808 # 80009710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009711>
80003478:	0d840993          	addi	s3,s0,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
8000347c:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80003480:	01010793          	addi	a5,sp,16
80003484:	07000613          	li	a2,112
80003488:	00000593          	li	a1,0
8000348c:	00078513          	mv	a0,a5
{
80003490:	08112e23          	sw	ra,156(sp)
80003494:	08912a23          	sw	s1,148(sp)
80003498:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
8000349c:	a55ff0ef          	jal	ra,80002ef0 <memset>
800034a0:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800034a4:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800034a8:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
800034ac:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800034b0:	e05ff0ef          	jal	ra,800032b4 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
800034b4:	00100513          	li	a0,1
800034b8:	dfdff0ef          	jal	ra,800032b4 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
800034bc:	10100793          	li	a5,257
800034c0:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800034c4:	2c1010ef          	jal	ra,80004f84 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800034c8:	800087b7          	lui	a5,0x80008
800034cc:	87078793          	addi	a5,a5,-1936 # 80007870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007871>
	_kernel.ready_q.cache = _main_thread;
800034d0:	80008937          	lui	s2,0x80008
	z_setup_new_thread(_main_thread, _main_stack,
800034d4:	00f12223          	sw	a5,4(sp)
800034d8:	800036b7          	lui	a3,0x80003
800034dc:	00100793          	li	a5,1
800034e0:	800095b7          	lui	a1,0x80009
	_kernel.ready_q.cache = _main_thread;
800034e4:	06890493          	addi	s1,s2,104 # 80008068 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008069>
	z_setup_new_thread(_main_thread, _main_stack,
800034e8:	00f12023          	sw	a5,0(sp)
800034ec:	00000713          	li	a4,0
800034f0:	00000793          	li	a5,0
800034f4:	00000893          	li	a7,0
800034f8:	00000813          	li	a6,0
800034fc:	41468693          	addi	a3,a3,1044 # 80003414 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003415>
80003500:	20000613          	li	a2,512
80003504:	b1058593          	addi	a1,a1,-1264 # 80008b10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008b11>
80003508:	06890513          	addi	a0,s2,104
	_kernel.ready_q.cache = _main_thread;
8000350c:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80003510:	290020ef          	jal	ra,800057a0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003514:	00d4c783          	lbu	a5,13(s1)
80003518:	0d840413          	addi	s0,s0,216
8000351c:	ffb7f713          	andi	a4,a5,-5
80003520:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003524:	01b7f793          	andi	a5,a5,27
80003528:	00079a63          	bnez	a5,8000353c <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
8000352c:	0184a783          	lw	a5,24(s1)
80003530:	00079663          	bnez	a5,8000353c <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80003534:	06890513          	addi	a0,s2,104
80003538:	02c010ef          	jal	ra,80004564 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
8000353c:	800087b7          	lui	a5,0x80008
80003540:	87878793          	addi	a5,a5,-1928 # 80007878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007879>
80003544:	00f12223          	sw	a5,4(sp)
80003548:	80008537          	lui	a0,0x80008
8000354c:	00100793          	li	a5,1
80003550:	800036b7          	lui	a3,0x80003
80003554:	800095b7          	lui	a1,0x80009
80003558:	ff850493          	addi	s1,a0,-8 # 80007ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff9>
8000355c:	00f12023          	sw	a5,0(sp)
80003560:	00f00893          	li	a7,15
80003564:	00000813          	li	a6,0
80003568:	00000793          	li	a5,0
8000356c:	00000713          	li	a4,0
80003570:	3bc68693          	addi	a3,a3,956 # 800033bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800033bd>
80003574:	20000613          	li	a2,512
80003578:	d1058593          	addi	a1,a1,-752 # 80008d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d11>
8000357c:	ff850513          	addi	a0,a0,-8
80003580:	220020ef          	jal	ra,800057a0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003584:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80003588:	00942623          	sw	s1,12(s0)
8000358c:	00800513          	li	a0,8
80003590:	ffb7f793          	andi	a5,a5,-5
80003594:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80003598:	800087b7          	lui	a5,0x80008
8000359c:	0f078793          	addi	a5,a5,240 # 800080f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080f1>
800035a0:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800035a4:	00f42e23          	sw	a5,28(s0)
800035a8:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800035ac:	00857513          	andi	a0,a0,8
800035b0:	c89fc0ef          	jal	ra,80000238 <__swap>

800035b4 <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800035b4:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
800035b8:	fe010113          	addi	sp,sp,-32
800035bc:	00812c23          	sw	s0,24(sp)
800035c0:	00112e23          	sw	ra,28(sp)
800035c4:	01f7f793          	andi	a5,a5,31
800035c8:	00050413          	mv	s0,a0
800035cc:	00079c63          	bnez	a5,800035e4 <prepare_thread_to_run+0x30>
	if (z_is_thread_ready(thread)) {
800035d0:	01852783          	lw	a5,24(a0)
800035d4:	00079863          	bnez	a5,800035e4 <prepare_thread_to_run+0x30>
800035d8:	00b12623          	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
800035dc:	789000ef          	jal	ra,80004564 <z_add_thread_to_ready_q>
800035e0:	00c12583          	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
800035e4:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
800035e8:	00b42a23          	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
800035ec:	01c12083          	lw	ra,28(sp)
800035f0:	01812403          	lw	s0,24(sp)
800035f4:	02010113          	addi	sp,sp,32
800035f8:	00008067          	ret

800035fc <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
800035fc:	fe010113          	addi	sp,sp,-32
80003600:	00812c23          	sw	s0,24(sp)
80003604:	00912a23          	sw	s1,20(sp)
80003608:	01212823          	sw	s2,16(sp)
8000360c:	01312623          	sw	s3,12(sp)
80003610:	01412423          	sw	s4,8(sp)
80003614:	01612023          	sw	s6,0(sp)
80003618:	00112e23          	sw	ra,28(sp)
8000361c:	01512223          	sw	s5,4(sp)
80003620:	00050413          	mv	s0,a0
80003624:	00058993          	mv	s3,a1
80003628:	00060a13          	mv	s4,a2
8000362c:	00068b13          	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003630:	00850913          	addi	s2,a0,8
80003634:	00800493          	li	s1,8
80003638:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000363c:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80003640:	0084f493          	andi	s1,s1,8
80003644:	228020ef          	jal	ra,8000586c <z_spin_lock_valid>
80003648:	02051e63          	bnez	a0,80003684 <queue_insert+0x88>
8000364c:	80007ab7          	lui	s5,0x80007
80003650:	800075b7          	lui	a1,0x80007
80003654:	80007537          	lui	a0,0x80007
80003658:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
8000365c:	04e00693          	li	a3,78
80003660:	68ca8613          	addi	a2,s5,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003664:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003668:	a1cff0ef          	jal	ra,80002884 <printk>
8000366c:	80007537          	lui	a0,0x80007
80003670:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80003674:	a10ff0ef          	jal	ra,80002884 <printk>
80003678:	04e00593          	li	a1,78
8000367c:	68ca8513          	addi	a0,s5,1676
80003680:	a40ff0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003684:	00090513          	mv	a0,s2
80003688:	23c020ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
8000368c:	00c40513          	addi	a0,s0,12
80003690:	6d4010ef          	jal	ra,80004d64 <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
80003694:	02050063          	beqz	a0,800036b4 <queue_insert+0xb8>
		prepare_thread_to_run(first_pending_thread, data);
80003698:	000a0593          	mv	a1,s4
8000369c:	f19ff0ef          	jal	ra,800035b4 <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
800036a0:	00090513          	mv	a0,s2
800036a4:	00048593          	mv	a1,s1
800036a8:	071000ef          	jal	ra,80003f18 <z_reschedule>
	return 0;
800036ac:	00000513          	li	a0,0
800036b0:	0600006f          	j	80003710 <queue_insert+0x114>
	if (alloc) {
800036b4:	0a0b0e63          	beqz	s6,80003770 <queue_insert+0x174>
		anode = z_thread_malloc(sizeof(*anode));
800036b8:	00800513          	li	a0,8
800036bc:	384030ef          	jal	ra,80006a40 <z_thread_malloc>
		if (anode == NULL) {
800036c0:	06051c63          	bnez	a0,80003738 <queue_insert+0x13c>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036c4:	00090513          	mv	a0,s2
800036c8:	1cc020ef          	jal	ra,80005894 <z_spin_unlock_valid>
800036cc:	02051e63          	bnez	a0,80003708 <queue_insert+0x10c>
800036d0:	80007437          	lui	s0,0x80007
800036d4:	800075b7          	lui	a1,0x80007
800036d8:	80007537          	lui	a0,0x80007
800036dc:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
800036e0:	06100693          	li	a3,97
800036e4:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
800036e8:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800036ec:	998ff0ef          	jal	ra,80002884 <printk>
800036f0:	80007537          	lui	a0,0x80007
800036f4:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800036f8:	98cff0ef          	jal	ra,80002884 <printk>
800036fc:	06100593          	li	a1,97
80003700:	68c40513          	addi	a0,s0,1676
80003704:	9bcff0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003708:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
8000370c:	ff400513          	li	a0,-12
}
80003710:	01c12083          	lw	ra,28(sp)
80003714:	01812403          	lw	s0,24(sp)
80003718:	01412483          	lw	s1,20(sp)
8000371c:	01012903          	lw	s2,16(sp)
80003720:	00c12983          	lw	s3,12(sp)
80003724:	00812a03          	lw	s4,8(sp)
80003728:	00412a83          	lw	s5,4(sp)
8000372c:	00012b03          	lw	s6,0(sp)
80003730:	02010113          	addi	sp,sp,32
80003734:	00008067          	ret
	node->next_and_flags = flags;
80003738:	00100793          	li	a5,1
		anode->data = data;
8000373c:	01452223          	sw	s4,4(a0)
80003740:	00f52023          	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
80003744:	00052783          	lw	a5,0(a0)
80003748:	0037f793          	andi	a5,a5,3
8000374c:	02099863          	bnez	s3,8000377c <queue_insert+0x180>
	parent->next_and_flags = cur_flags | (unative_t)child;
80003750:	00042703          	lw	a4,0(s0)
80003754:	00f767b3          	or	a5,a4,a5
80003758:	00f52023          	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
8000375c:	00442783          	lw	a5,4(s0)
	list->head = node;
80003760:	00a42023          	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
80003764:	f2079ee3          	bnez	a5,800036a0 <queue_insert+0xa4>
	list->tail = node;
80003768:	00a42223          	sw	a0,4(s0)
8000376c:	f35ff06f          	j	800036a0 <queue_insert+0xa4>
	node->next_and_flags = flags;
80003770:	000a2023          	sw	zero,0(s4)
80003774:	000a0513          	mv	a0,s4
80003778:	fcdff06f          	j	80003744 <queue_insert+0x148>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
8000377c:	0009a703          	lw	a4,0(s3)
80003780:	ffc77713          	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
80003784:	02071863          	bnez	a4,800037b4 <queue_insert+0x1b8>
Z_GENLIST_APPEND(sflist, sfnode)
80003788:	00442703          	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
8000378c:	00f52023          	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80003790:	00071863          	bnez	a4,800037a0 <queue_insert+0x1a4>
	list->tail = node;
80003794:	00a42223          	sw	a0,4(s0)
	list->head = node;
80003798:	00a42023          	sw	a0,0(s0)
8000379c:	f05ff06f          	j	800036a0 <queue_insert+0xa4>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
800037a0:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
800037a4:	0037f793          	andi	a5,a5,3
800037a8:	00f567b3          	or	a5,a0,a5
800037ac:	00f72023          	sw	a5,0(a4)
800037b0:	fb9ff06f          	j	80003768 <queue_insert+0x16c>
800037b4:	00e7e7b3          	or	a5,a5,a4
800037b8:	00f52023          	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
800037bc:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
800037c0:	0037f793          	andi	a5,a5,3
800037c4:	00f56533          	or	a0,a0,a5
800037c8:	00a9a023          	sw	a0,0(s3)
800037cc:	ed5ff06f          	j	800036a0 <queue_insert+0xa4>

800037d0 <z_queue_node_peek>:
{
800037d0:	ff010113          	addi	sp,sp,-16
800037d4:	00812423          	sw	s0,8(sp)
800037d8:	00112623          	sw	ra,12(sp)
800037dc:	00050413          	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
800037e0:	00050e63          	beqz	a0,800037fc <z_queue_node_peek+0x2c>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
800037e4:	00052783          	lw	a5,0(a0)
800037e8:	0037f793          	andi	a5,a5,3
800037ec:	00078863          	beqz	a5,800037fc <z_queue_node_peek+0x2c>
		ret = anode->data;
800037f0:	00452403          	lw	s0,4(a0)
		if (needs_free) {
800037f4:	00058463          	beqz	a1,800037fc <z_queue_node_peek+0x2c>
			k_free(anode);
800037f8:	238030ef          	jal	ra,80006a30 <k_free>
}
800037fc:	00040513          	mv	a0,s0
80003800:	00c12083          	lw	ra,12(sp)
80003804:	00812403          	lw	s0,8(sp)
80003808:	01010113          	addi	sp,sp,16
8000380c:	00008067          	ret

80003810 <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80003810:	00c50793          	addi	a5,a0,12
	list->head = NULL;
80003814:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
80003818:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
8000381c:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
80003820:	00f52623          	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
80003824:	00f52823          	sw	a5,16(a0)
}
80003828:	00008067          	ret

8000382c <z_impl_k_queue_cancel_wait>:
{
8000382c:	fe010113          	addi	sp,sp,-32
80003830:	00812c23          	sw	s0,24(sp)
80003834:	00912a23          	sw	s1,20(sp)
80003838:	01212823          	sw	s2,16(sp)
8000383c:	00112e23          	sw	ra,28(sp)
80003840:	01312623          	sw	s3,12(sp)
80003844:	00050913          	mv	s2,a0
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003848:	00850493          	addi	s1,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000384c:	00800413          	li	s0,8
80003850:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003854:	00048513          	mv	a0,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80003858:	00847413          	andi	s0,s0,8
8000385c:	010020ef          	jal	ra,8000586c <z_spin_lock_valid>
80003860:	02051e63          	bnez	a0,8000389c <z_impl_k_queue_cancel_wait+0x70>
80003864:	800079b7          	lui	s3,0x80007
80003868:	800075b7          	lui	a1,0x80007
8000386c:	80007537          	lui	a0,0x80007
80003870:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80003874:	04e00693          	li	a3,78
80003878:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
8000387c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003880:	804ff0ef          	jal	ra,80002884 <printk>
80003884:	80007537          	lui	a0,0x80007
80003888:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
8000388c:	ff9fe0ef          	jal	ra,80002884 <printk>
80003890:	04e00593          	li	a1,78
80003894:	68c98513          	addi	a0,s3,1676
80003898:	828ff0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
8000389c:	00048513          	mv	a0,s1
800038a0:	024020ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
800038a4:	00c90513          	addi	a0,s2,12
800038a8:	4bc010ef          	jal	ra,80004d64 <z_unpend_first_thread>
	if (first_pending_thread != NULL) {
800038ac:	00050663          	beqz	a0,800038b8 <z_impl_k_queue_cancel_wait+0x8c>
		prepare_thread_to_run(first_pending_thread, NULL);
800038b0:	00000593          	li	a1,0
800038b4:	d01ff0ef          	jal	ra,800035b4 <prepare_thread_to_run>
	z_reschedule(&queue->lock, key);
800038b8:	00040593          	mv	a1,s0
}
800038bc:	01812403          	lw	s0,24(sp)
800038c0:	01c12083          	lw	ra,28(sp)
800038c4:	01012903          	lw	s2,16(sp)
800038c8:	00c12983          	lw	s3,12(sp)
	z_reschedule(&queue->lock, key);
800038cc:	00048513          	mv	a0,s1
}
800038d0:	01412483          	lw	s1,20(sp)
800038d4:	02010113          	addi	sp,sp,32
	z_reschedule(&queue->lock, key);
800038d8:	6400006f          	j	80003f18 <z_reschedule>

800038dc <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
800038dc:	00058613          	mv	a2,a1
800038e0:	00452583          	lw	a1,4(a0)
800038e4:	00000693          	li	a3,0
800038e8:	d15ff06f          	j	800035fc <queue_insert>

800038ec <k_queue_append_list>:
					   (void *)data);
}
#endif

void k_queue_append_list(struct k_queue *queue, void *head, void *tail)
{
800038ec:	fe010113          	addi	sp,sp,-32
800038f0:	00812c23          	sw	s0,24(sp)
800038f4:	01212823          	sw	s2,16(sp)
800038f8:	01412423          	sw	s4,8(sp)
800038fc:	00112e23          	sw	ra,28(sp)
80003900:	00912a23          	sw	s1,20(sp)
80003904:	01312623          	sw	s3,12(sp)
80003908:	01512223          	sw	s5,4(sp)
8000390c:	00050913          	mv	s2,a0
80003910:	00058413          	mv	s0,a1
80003914:	00060a13          	mv	s4,a2
	__ASSERT(head && tail, "invalid head or tail");
80003918:	00058463          	beqz	a1,80003920 <k_queue_append_list+0x34>
8000391c:	02061e63          	bnez	a2,80003958 <k_queue_append_list+0x6c>
80003920:	800084b7          	lui	s1,0x80008
80003924:	800085b7          	lui	a1,0x80008
80003928:	80007537          	lui	a0,0x80007
8000392c:	89458593          	addi	a1,a1,-1900 # 80007894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007895>
80003930:	0ed00693          	li	a3,237
80003934:	88048613          	addi	a2,s1,-1920 # 80007880 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007881>
80003938:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000393c:	f49fe0ef          	jal	ra,80002884 <printk>
80003940:	80008537          	lui	a0,0x80008
80003944:	8a450513          	addi	a0,a0,-1884 # 800078a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078a5>
80003948:	f3dfe0ef          	jal	ra,80002884 <printk>
8000394c:	0ed00593          	li	a1,237
80003950:	88048513          	addi	a0,s1,-1920
80003954:	f6dfe0ef          	jal	ra,800028c0 <assert_post_action>

	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003958:	00890993          	addi	s3,s2,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000395c:	00800493          	li	s1,8
80003960:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003964:	00098513          	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
80003968:	0084f493          	andi	s1,s1,8
8000396c:	701010ef          	jal	ra,8000586c <z_spin_lock_valid>
80003970:	02051e63          	bnez	a0,800039ac <k_queue_append_list+0xc0>
80003974:	80007ab7          	lui	s5,0x80007
80003978:	800075b7          	lui	a1,0x80007
8000397c:	80007537          	lui	a0,0x80007
80003980:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80003984:	04e00693          	li	a3,78
80003988:	68ca8613          	addi	a2,s5,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
8000398c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003990:	ef5fe0ef          	jal	ra,80002884 <printk>
80003994:	80007537          	lui	a0,0x80007
80003998:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
8000399c:	ee9fe0ef          	jal	ra,80002884 <printk>
800039a0:	04e00593          	li	a1,78
800039a4:	68ca8513          	addi	a0,s5,1676
800039a8:	f19fe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
800039ac:	00098513          	mv	a0,s3
800039b0:	715010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *thread = NULL;

	if (head != NULL) {
800039b4:	04040063          	beqz	s0,800039f4 <k_queue_append_list+0x108>
		thread = z_unpend_first_thread(&queue->wait_q);
800039b8:	00c90a93          	addi	s5,s2,12
800039bc:	000a8513          	mv	a0,s5
800039c0:	3a4010ef          	jal	ra,80004d64 <z_unpend_first_thread>
	}

	while ((head != NULL) && (thread != NULL)) {
800039c4:	00051c63          	bnez	a0,800039dc <k_queue_append_list+0xf0>
Z_GENLIST_APPEND_LIST(sflist, sfnode)
800039c8:	00492703          	lw	a4,4(s2)
800039cc:	04071a63          	bnez	a4,80003a20 <k_queue_append_list+0x134>
	list->head = node;
800039d0:	00892023          	sw	s0,0(s2)
	list->tail = node;
800039d4:	01492223          	sw	s4,4(s2)
800039d8:	01c0006f          	j	800039f4 <k_queue_append_list+0x108>
		prepare_thread_to_run(thread, head);
800039dc:	00040593          	mv	a1,s0
800039e0:	bd5ff0ef          	jal	ra,800035b4 <prepare_thread_to_run>
		head = *(void **)head;
800039e4:	00042403          	lw	s0,0(s0)
		thread = z_unpend_first_thread(&queue->wait_q);
800039e8:	000a8513          	mv	a0,s5
800039ec:	378010ef          	jal	ra,80004d64 <z_unpend_first_thread>
	while ((head != NULL) && (thread != NULL)) {
800039f0:	fc041ae3          	bnez	s0,800039c4 <k_queue_append_list+0xd8>
	sys_sflist_append_list(&queue->data_q, head, tail);
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* !CONFIG_POLL */

	z_reschedule(&queue->lock, key);
}
800039f4:	01812403          	lw	s0,24(sp)
800039f8:	01c12083          	lw	ra,28(sp)
800039fc:	01012903          	lw	s2,16(sp)
80003a00:	00812a03          	lw	s4,8(sp)
80003a04:	00412a83          	lw	s5,4(sp)
	z_reschedule(&queue->lock, key);
80003a08:	00048593          	mv	a1,s1
80003a0c:	00098513          	mv	a0,s3
}
80003a10:	01412483          	lw	s1,20(sp)
80003a14:	00c12983          	lw	s3,12(sp)
80003a18:	02010113          	addi	sp,sp,32
	z_reschedule(&queue->lock, key);
80003a1c:	4fc0006f          	j	80003f18 <z_reschedule>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80003a20:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80003a24:	0037f793          	andi	a5,a5,3
80003a28:	00f46433          	or	s0,s0,a5
80003a2c:	00872023          	sw	s0,0(a4)
80003a30:	fa5ff06f          	j	800039d4 <k_queue_append_list+0xe8>

80003a34 <k_queue_merge_slist>:

void k_queue_merge_slist(struct k_queue *queue, sys_slist_t *list)
{
	__ASSERT(!sys_slist_is_empty(list), "list must not be empty");
80003a34:	0005a783          	lw	a5,0(a1)
{
80003a38:	ff010113          	addi	sp,sp,-16
80003a3c:	00812423          	sw	s0,8(sp)
80003a40:	01212023          	sw	s2,0(sp)
80003a44:	00112623          	sw	ra,12(sp)
80003a48:	00912223          	sw	s1,4(sp)
80003a4c:	00050913          	mv	s2,a0
80003a50:	00058413          	mv	s0,a1
	__ASSERT(!sys_slist_is_empty(list), "list must not be empty");
80003a54:	02079e63          	bnez	a5,80003a90 <k_queue_merge_slist+0x5c>
80003a58:	800084b7          	lui	s1,0x80008
80003a5c:	800085b7          	lui	a1,0x80008
80003a60:	80007537          	lui	a0,0x80007
80003a64:	8bc58593          	addi	a1,a1,-1860 # 800078bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078bd>
80003a68:	10b00693          	li	a3,267
80003a6c:	88048613          	addi	a2,s1,-1920 # 80007880 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007881>
80003a70:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003a74:	e11fe0ef          	jal	ra,80002884 <printk>
80003a78:	80008537          	lui	a0,0x80008
80003a7c:	8d850513          	addi	a0,a0,-1832 # 800078d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078d9>
80003a80:	e05fe0ef          	jal	ra,80002884 <printk>
80003a84:	10b00593          	li	a1,267
80003a88:	88048513          	addi	a0,s1,-1920
80003a8c:	e35fe0ef          	jal	ra,800028c0 <assert_post_action>
	 * - list->tail->next = NULL.
	 * - sflist implementation only differs from slist by stuffing
	 *   flag bytes in the lower order bits of the data pointer
	 * - source list is really an slist and not an sflist with flags set
	 */
	k_queue_append_list(queue, list->head, list->tail);
80003a90:	00442603          	lw	a2,4(s0)
80003a94:	00042583          	lw	a1,0(s0)
80003a98:	00090513          	mv	a0,s2
80003a9c:	e51ff0ef          	jal	ra,800038ec <k_queue_append_list>
	sys_slist_init(list);
}
80003aa0:	00c12083          	lw	ra,12(sp)
	list->head = NULL;
80003aa4:	00042023          	sw	zero,0(s0)
	list->tail = NULL;
80003aa8:	00042223          	sw	zero,4(s0)
80003aac:	00812403          	lw	s0,8(sp)
80003ab0:	00412483          	lw	s1,4(sp)
80003ab4:	00012903          	lw	s2,0(sp)
80003ab8:	01010113          	addi	sp,sp,16
80003abc:	00008067          	ret

80003ac0 <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
80003ac0:	fe010113          	addi	sp,sp,-32
80003ac4:	00812c23          	sw	s0,24(sp)
80003ac8:	00912a23          	sw	s1,20(sp)
80003acc:	01212823          	sw	s2,16(sp)
80003ad0:	01312623          	sw	s3,12(sp)
80003ad4:	00112e23          	sw	ra,28(sp)
80003ad8:	01412423          	sw	s4,8(sp)
80003adc:	00050493          	mv	s1,a0
80003ae0:	00058993          	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003ae4:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ae8:	00800413          	li	s0,8
80003aec:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003af0:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80003af4:	00847413          	andi	s0,s0,8
80003af8:	575010ef          	jal	ra,8000586c <z_spin_lock_valid>
80003afc:	02051e63          	bnez	a0,80003b38 <z_impl_k_queue_get+0x78>
80003b00:	80007a37          	lui	s4,0x80007
80003b04:	800075b7          	lui	a1,0x80007
80003b08:	80007537          	lui	a0,0x80007
80003b0c:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80003b10:	04e00693          	li	a3,78
80003b14:	68ca0613          	addi	a2,s4,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003b18:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003b1c:	d69fe0ef          	jal	ra,80002884 <printk>
80003b20:	80007537          	lui	a0,0x80007
80003b24:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80003b28:	d5dfe0ef          	jal	ra,80002884 <printk>
80003b2c:	04e00593          	li	a1,78
80003b30:	68ca0513          	addi	a0,s4,1676
80003b34:	d8dfe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b38:	00090513          	mv	a0,s2
80003b3c:	589010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
80003b40:	0004a503          	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
80003b44:	08050a63          	beqz	a0,80003bd8 <z_impl_k_queue_get+0x118>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80003b48:	00052783          	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80003b4c:	0044a703          	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80003b50:	ffc7f793          	andi	a5,a5,-4
	list->head = node;
80003b54:	00f4a023          	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80003b58:	00e51463          	bne	a0,a4,80003b60 <z_impl_k_queue_get+0xa0>
	list->tail = node;
80003b5c:	00f4a223          	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
80003b60:	00100593          	li	a1,1
80003b64:	c6dff0ef          	jal	ra,800037d0 <z_queue_node_peek>
80003b68:	00050493          	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b6c:	00090513          	mv	a0,s2
80003b70:	525010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80003b74:	02051e63          	bnez	a0,80003bb0 <z_impl_k_queue_get+0xf0>
80003b78:	80007937          	lui	s2,0x80007
80003b7c:	800075b7          	lui	a1,0x80007
80003b80:	80007537          	lui	a0,0x80007
80003b84:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80003b88:	06100693          	li	a3,97
80003b8c:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003b90:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003b94:	cf1fe0ef          	jal	ra,80002884 <printk>
80003b98:	80007537          	lui	a0,0x80007
80003b9c:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80003ba0:	ce5fe0ef          	jal	ra,80002884 <printk>
80003ba4:	06100593          	li	a1,97
80003ba8:	68c90513          	addi	a0,s2,1676
80003bac:	d15fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003bb0:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
80003bb4:	01c12083          	lw	ra,28(sp)
80003bb8:	01812403          	lw	s0,24(sp)
80003bbc:	00048513          	mv	a0,s1
80003bc0:	01012903          	lw	s2,16(sp)
80003bc4:	01412483          	lw	s1,20(sp)
80003bc8:	00c12983          	lw	s3,12(sp)
80003bcc:	00812a03          	lw	s4,8(sp)
80003bd0:	02010113          	addi	sp,sp,32
80003bd4:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80003bd8:	04099a63          	bnez	s3,80003c2c <z_impl_k_queue_get+0x16c>
80003bdc:	00090513          	mv	a0,s2
80003be0:	4b5010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80003be4:	02051e63          	bnez	a0,80003c20 <z_impl_k_queue_get+0x160>
80003be8:	800074b7          	lui	s1,0x80007
80003bec:	800075b7          	lui	a1,0x80007
80003bf0:	80007537          	lui	a0,0x80007
80003bf4:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80003bf8:	06100693          	li	a3,97
80003bfc:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003c00:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003c04:	c81fe0ef          	jal	ra,80002884 <printk>
80003c08:	80007537          	lui	a0,0x80007
80003c0c:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80003c10:	c75fe0ef          	jal	ra,80002884 <printk>
80003c14:	06100593          	li	a1,97
80003c18:	68c48513          	addi	a0,s1,1676
80003c1c:	ca5fe0ef          	jal	ra,800028c0 <assert_post_action>
80003c20:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80003c24:	00000493          	li	s1,0
80003c28:	f8dff06f          	j	80003bb4 <z_impl_k_queue_get+0xf4>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80003c2c:	00c48613          	addi	a2,s1,12
80003c30:	00098693          	mv	a3,s3
80003c34:	00040593          	mv	a1,s0
80003c38:	00090513          	mv	a0,s2
80003c3c:	0a0010ef          	jal	ra,80004cdc <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
80003c40:	00000493          	li	s1,0
80003c44:	f60518e3          	bnez	a0,80003bb4 <z_impl_k_queue_get+0xf4>
80003c48:	800087b7          	lui	a5,0x80008
80003c4c:	0e07a783          	lw	a5,224(a5) # 800080e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e1>
80003c50:	0147a483          	lw	s1,20(a5)
80003c54:	f61ff06f          	j	80003bb4 <z_impl_k_queue_get+0xf4>

80003c58 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003c58:	00d54783          	lbu	a5,13(a0)
80003c5c:	01f7f793          	andi	a5,a5,31
80003c60:	00079863          	bnez	a5,80003c70 <z_is_thread_ready+0x18>
80003c64:	01852503          	lw	a0,24(a0)
80003c68:	00153513          	seqz	a0,a0
80003c6c:	00008067          	ret
80003c70:	00000513          	li	a0,0
}
80003c74:	00008067          	ret

80003c78 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80003c78:	ff010113          	addi	sp,sp,-16
80003c7c:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80003c80:	8c0ff0ef          	jal	ra,80002d40 <z_clock_elapsed>
80003c84:	800087b7          	lui	a5,0x80008
80003c88:	d607a783          	lw	a5,-672(a5) # 80007d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d61>

	z_set_timeout_expiry(slice_time, false);
}
80003c8c:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80003c90:	80008737          	lui	a4,0x80008
80003c94:	00a78533          	add	a0,a5,a0
80003c98:	0ea72423          	sw	a0,232(a4) # 800080e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e9>
	z_set_timeout_expiry(slice_time, false);
80003c9c:	00000593          	li	a1,0
80003ca0:	00078513          	mv	a0,a5
}
80003ca4:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80003ca8:	50c0206f          	j	800061b4 <z_set_timeout_expiry>

80003cac <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80003cac:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80003cb0:	ff010113          	addi	sp,sp,-16
80003cb4:	00812423          	sw	s0,8(sp)
80003cb8:	00112623          	sw	ra,12(sp)
80003cbc:	00912223          	sw	s1,4(sp)
80003cc0:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80003cc4:	02079863          	bnez	a5,80003cf4 <pended_on.isra.15+0x48>
80003cc8:	800084b7          	lui	s1,0x80008
80003ccc:	800085b7          	lui	a1,0x80008
80003cd0:	80007537          	lui	a0,0x80007
80003cd4:	98c58593          	addi	a1,a1,-1652 # 8000798c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000798d>
80003cd8:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003cdc:	18300693          	li	a3,387
80003ce0:	97848613          	addi	a2,s1,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
80003ce4:	ba1fe0ef          	jal	ra,80002884 <printk>
80003ce8:	18300593          	li	a1,387
80003cec:	97848513          	addi	a0,s1,-1672
80003cf0:	bd1fe0ef          	jal	ra,800028c0 <assert_post_action>

	return thread->base.pended_on;
}
80003cf4:	00042503          	lw	a0,0(s0)
80003cf8:	00c12083          	lw	ra,12(sp)
80003cfc:	00812403          	lw	s0,8(sp)
80003d00:	00412483          	lw	s1,4(sp)
80003d04:	01010113          	addi	sp,sp,16
80003d08:	00008067          	ret

80003d0c <k_sched_time_slice_set>:
{
80003d0c:	fe010113          	addi	sp,sp,-32
80003d10:	00812c23          	sw	s0,24(sp)
80003d14:	01312623          	sw	s3,12(sp)
80003d18:	01412423          	sw	s4,8(sp)
80003d1c:	00112e23          	sw	ra,28(sp)
80003d20:	00912a23          	sw	s1,20(sp)
80003d24:	01212823          	sw	s2,16(sp)
80003d28:	00050a13          	mv	s4,a0
80003d2c:	00058993          	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d30:	00800413          	li	s0,8
80003d34:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d38:	800084b7          	lui	s1,0x80008
80003d3c:	d5848513          	addi	a0,s1,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d40:	00847413          	andi	s0,s0,8
80003d44:	329010ef          	jal	ra,8000586c <z_spin_lock_valid>
80003d48:	02051e63          	bnez	a0,80003d84 <k_sched_time_slice_set+0x78>
80003d4c:	80007937          	lui	s2,0x80007
80003d50:	800075b7          	lui	a1,0x80007
80003d54:	80007537          	lui	a0,0x80007
80003d58:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80003d5c:	04e00693          	li	a3,78
80003d60:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003d64:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003d68:	b1dfe0ef          	jal	ra,80002884 <printk>
80003d6c:	80007537          	lui	a0,0x80007
80003d70:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80003d74:	b11fe0ef          	jal	ra,80002884 <printk>
80003d78:	04e00593          	li	a1,78
80003d7c:	68c90513          	addi	a0,s2,1676
80003d80:	b41fe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d84:	d5848513          	addi	a0,s1,-680
80003d88:	33d010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80003d8c:	800087b7          	lui	a5,0x80008
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80003d90:	00a00593          	li	a1,10
80003d94:	009a0513          	addi	a0,s4,9
80003d98:	0e07a423          	sw	zero,232(a5) # 800080e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e9>
80003d9c:	badfc0ef          	jal	ra,80000948 <__divsi3>
		slice_max_prio = prio;
80003da0:	800087b7          	lui	a5,0x80008
		slice_time = z_ms_to_ticks(slice);
80003da4:	80008937          	lui	s2,0x80008
80003da8:	d6a92023          	sw	a0,-672(s2) # 80007d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d61>
		slice_max_prio = prio;
80003dac:	d537ae23          	sw	s3,-676(a5) # 80007d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d5d>
		reset_time_slice();
80003db0:	ec9ff0ef          	jal	ra,80003c78 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003db4:	d5848513          	addi	a0,s1,-680
80003db8:	2dd010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80003dbc:	02051e63          	bnez	a0,80003df8 <k_sched_time_slice_set+0xec>
80003dc0:	800074b7          	lui	s1,0x80007
80003dc4:	800075b7          	lui	a1,0x80007
80003dc8:	80007537          	lui	a0,0x80007
80003dcc:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80003dd0:	06100693          	li	a3,97
80003dd4:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003dd8:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003ddc:	aa9fe0ef          	jal	ra,80002884 <printk>
80003de0:	80007537          	lui	a0,0x80007
80003de4:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80003de8:	a9dfe0ef          	jal	ra,80002884 <printk>
80003dec:	06100593          	li	a1,97
80003df0:	68c48513          	addi	a0,s1,1676
80003df4:	acdfe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003df8:	30042473          	csrrs	s0,mstatus,s0
}
80003dfc:	01c12083          	lw	ra,28(sp)
80003e00:	01812403          	lw	s0,24(sp)
80003e04:	01412483          	lw	s1,20(sp)
80003e08:	01012903          	lw	s2,16(sp)
80003e0c:	00c12983          	lw	s3,12(sp)
80003e10:	00812a03          	lw	s4,8(sp)
80003e14:	02010113          	addi	sp,sp,32
80003e18:	00008067          	ret

80003e1c <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80003e1c:	fe010113          	addi	sp,sp,-32
80003e20:	00812c23          	sw	s0,24(sp)
80003e24:	01212823          	sw	s2,16(sp)
80003e28:	00112e23          	sw	ra,28(sp)
80003e2c:	00912a23          	sw	s1,20(sp)
80003e30:	01312623          	sw	s3,12(sp)
80003e34:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e38:	00800413          	li	s0,8
80003e3c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e40:	800084b7          	lui	s1,0x80008
80003e44:	d5848513          	addi	a0,s1,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e48:	00847413          	andi	s0,s0,8
80003e4c:	221010ef          	jal	ra,8000586c <z_spin_lock_valid>
80003e50:	02051e63          	bnez	a0,80003e8c <z_unpend_thread_no_timeout+0x70>
80003e54:	800079b7          	lui	s3,0x80007
80003e58:	800075b7          	lui	a1,0x80007
80003e5c:	80007537          	lui	a0,0x80007
80003e60:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80003e64:	04e00693          	li	a3,78
80003e68:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003e6c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003e70:	a15fe0ef          	jal	ra,80002884 <printk>
80003e74:	80007537          	lui	a0,0x80007
80003e78:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80003e7c:	a09fe0ef          	jal	ra,80002884 <printk>
80003e80:	04e00593          	li	a1,78
80003e84:	68c98513          	addi	a0,s3,1676
80003e88:	a39fe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003e8c:	d5848513          	addi	a0,s1,-680
80003e90:	235010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003e94:	00890513          	addi	a0,s2,8
80003e98:	e15ff0ef          	jal	ra,80003cac <pended_on.isra.15>
80003e9c:	00090593          	mv	a1,s2
80003ea0:	2f0000ef          	jal	ra,80004190 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003ea4:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ea8:	d5848513          	addi	a0,s1,-680
80003eac:	ffd7f793          	andi	a5,a5,-3
80003eb0:	00f906a3          	sb	a5,13(s2)
80003eb4:	1e1010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80003eb8:	02051e63          	bnez	a0,80003ef4 <z_unpend_thread_no_timeout+0xd8>
80003ebc:	800074b7          	lui	s1,0x80007
80003ec0:	800075b7          	lui	a1,0x80007
80003ec4:	80007537          	lui	a0,0x80007
80003ec8:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80003ecc:	06100693          	li	a3,97
80003ed0:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003ed4:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003ed8:	9adfe0ef          	jal	ra,80002884 <printk>
80003edc:	80007537          	lui	a0,0x80007
80003ee0:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80003ee4:	9a1fe0ef          	jal	ra,80002884 <printk>
80003ee8:	06100593          	li	a1,97
80003eec:	68c48513          	addi	a0,s1,1676
80003ef0:	9d1fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ef4:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003ef8:	01c12083          	lw	ra,28(sp)
80003efc:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003f00:	00092423          	sw	zero,8(s2)
}
80003f04:	01412483          	lw	s1,20(sp)
80003f08:	01012903          	lw	s2,16(sp)
80003f0c:	00c12983          	lw	s3,12(sp)
80003f10:	02010113          	addi	sp,sp,32
80003f14:	00008067          	ret

80003f18 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80003f18:	800087b7          	lui	a5,0x80008
80003f1c:	0d87a783          	lw	a5,216(a5) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
{
80003f20:	ff010113          	addi	sp,sp,-16
80003f24:	00812423          	sw	s0,8(sp)
80003f28:	00112623          	sw	ra,12(sp)
80003f2c:	00912223          	sw	s1,4(sp)
80003f30:	00058413          	mv	s0,a1
	if (resched()) {
80003f34:	04079e63          	bnez	a5,80003f90 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f38:	15d010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80003f3c:	02051e63          	bnez	a0,80003f78 <z_reschedule+0x60>
80003f40:	800074b7          	lui	s1,0x80007
80003f44:	800075b7          	lui	a1,0x80007
80003f48:	80007537          	lui	a0,0x80007
80003f4c:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80003f50:	07800693          	li	a3,120
80003f54:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003f58:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003f5c:	929fe0ef          	jal	ra,80002884 <printk>
80003f60:	80007537          	lui	a0,0x80007
80003f64:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80003f68:	91dfe0ef          	jal	ra,80002884 <printk>
80003f6c:	07800593          	li	a1,120
80003f70:	68c48513          	addi	a0,s1,1676
80003f74:	94dfe0ef          	jal	ra,800028c0 <assert_post_action>
80003f78:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80003f7c:	00812403          	lw	s0,8(sp)
80003f80:	00c12083          	lw	ra,12(sp)
80003f84:	00412483          	lw	s1,4(sp)
80003f88:	01010113          	addi	sp,sp,16
80003f8c:	aacfc06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f90:	105010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80003f94:	02051e63          	bnez	a0,80003fd0 <z_reschedule+0xb8>
80003f98:	800074b7          	lui	s1,0x80007
80003f9c:	800075b7          	lui	a1,0x80007
80003fa0:	80007537          	lui	a0,0x80007
80003fa4:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80003fa8:	06100693          	li	a3,97
80003fac:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80003fb0:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80003fb4:	8d1fe0ef          	jal	ra,80002884 <printk>
80003fb8:	80007537          	lui	a0,0x80007
80003fbc:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80003fc0:	8c5fe0ef          	jal	ra,80002884 <printk>
80003fc4:	06100593          	li	a1,97
80003fc8:	68c48513          	addi	a0,s1,1676
80003fcc:	8f5fe0ef          	jal	ra,800028c0 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003fd0:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003fd4:	30042473          	csrrs	s0,mstatus,s0
80003fd8:	00c12083          	lw	ra,12(sp)
80003fdc:	00812403          	lw	s0,8(sp)
80003fe0:	00412483          	lw	s1,4(sp)
80003fe4:	01010113          	addi	sp,sp,16
80003fe8:	00008067          	ret

80003fec <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003fec:	80008737          	lui	a4,0x80008
80003ff0:	0d872703          	lw	a4,216(a4) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
80003ff4:	00071463          	bnez	a4,80003ffc <z_reschedule_irqlock+0x10>
80003ff8:	a40fc06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003ffc:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004000:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80004004:	00008067          	ret

80004008 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004008:	00800513          	li	a0,8
8000400c:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80004010:	00857513          	andi	a0,a0,8
80004014:	fd9ff06f          	j	80003fec <z_reschedule_irqlock>

80004018 <k_sched_lock>:

void k_sched_lock(void)
{
80004018:	fe010113          	addi	sp,sp,-32
8000401c:	00812c23          	sw	s0,24(sp)
80004020:	00112e23          	sw	ra,28(sp)
80004024:	00912a23          	sw	s1,20(sp)
80004028:	01212823          	sw	s2,16(sp)
8000402c:	01312623          	sw	s3,12(sp)
80004030:	00800413          	li	s0,8
80004034:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004038:	800084b7          	lui	s1,0x80008
8000403c:	d5848513          	addi	a0,s1,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004040:	00847413          	andi	s0,s0,8
80004044:	029010ef          	jal	ra,8000586c <z_spin_lock_valid>
80004048:	02051e63          	bnez	a0,80004084 <k_sched_lock+0x6c>
8000404c:	80007937          	lui	s2,0x80007
80004050:	800075b7          	lui	a1,0x80007
80004054:	80007537          	lui	a0,0x80007
80004058:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
8000405c:	04e00693          	li	a3,78
80004060:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004064:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004068:	81dfe0ef          	jal	ra,80002884 <printk>
8000406c:	80007537          	lui	a0,0x80007
80004070:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80004074:	811fe0ef          	jal	ra,80002884 <printk>
80004078:	04e00593          	li	a1,78
8000407c:	68c90513          	addi	a0,s2,1676
80004080:	841fe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80004084:	d5848513          	addi	a0,s1,-680
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80004088:	80008937          	lui	s2,0x80008
8000408c:	039010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
80004090:	0d892783          	lw	a5,216(s2) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
80004094:	0d890913          	addi	s2,s2,216
80004098:	02078e63          	beqz	a5,800040d4 <k_sched_lock+0xbc>
8000409c:	800089b7          	lui	s3,0x80008
800040a0:	800085b7          	lui	a1,0x80008
800040a4:	80007537          	lui	a0,0x80007
800040a8:	91058593          	addi	a1,a1,-1776 # 80007910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007911>
800040ac:	10000693          	li	a3,256
800040b0:	8f498613          	addi	a2,s3,-1804 # 800078f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f5>
800040b4:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800040b8:	fccfe0ef          	jal	ra,80002884 <printk>
800040bc:	80007537          	lui	a0,0x80007
800040c0:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
800040c4:	fc0fe0ef          	jal	ra,80002884 <printk>
800040c8:	10000593          	li	a1,256
800040cc:	8f498513          	addi	a0,s3,-1804
800040d0:	ff0fe0ef          	jal	ra,800028c0 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
800040d4:	00892783          	lw	a5,8(s2)
800040d8:	00f7c703          	lbu	a4,15(a5)
800040dc:	00100793          	li	a5,1
800040e0:	02f71e63          	bne	a4,a5,8000411c <k_sched_lock+0x104>
800040e4:	800089b7          	lui	s3,0x80008
800040e8:	800085b7          	lui	a1,0x80008
800040ec:	80007537          	lui	a0,0x80007
800040f0:	92858593          	addi	a1,a1,-1752 # 80007928 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007929>
800040f4:	10100693          	li	a3,257
800040f8:	8f498613          	addi	a2,s3,-1804 # 800078f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f5>
800040fc:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004100:	f84fe0ef          	jal	ra,80002884 <printk>
80004104:	80007537          	lui	a0,0x80007
80004108:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
8000410c:	f78fe0ef          	jal	ra,80002884 <printk>
80004110:	10100593          	li	a1,257
80004114:	8f498513          	addi	a0,s3,-1804
80004118:	fa8fe0ef          	jal	ra,800028c0 <assert_post_action>

	--_current->base.sched_locked;
8000411c:	00892703          	lw	a4,8(s2)
80004120:	00f74783          	lbu	a5,15(a4)
80004124:	fff78793          	addi	a5,a5,-1
80004128:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000412c:	d5848513          	addi	a0,s1,-680
80004130:	764010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80004134:	02051e63          	bnez	a0,80004170 <k_sched_lock+0x158>
80004138:	800074b7          	lui	s1,0x80007
8000413c:	800075b7          	lui	a1,0x80007
80004140:	80007537          	lui	a0,0x80007
80004144:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80004148:	06100693          	li	a3,97
8000414c:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004150:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004154:	f30fe0ef          	jal	ra,80002884 <printk>
80004158:	80007537          	lui	a0,0x80007
8000415c:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80004160:	f24fe0ef          	jal	ra,80002884 <printk>
80004164:	06100593          	li	a1,97
80004168:	68c48513          	addi	a0,s1,1676
8000416c:	f54fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004170:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80004174:	01c12083          	lw	ra,28(sp)
80004178:	01812403          	lw	s0,24(sp)
8000417c:	01412483          	lw	s1,20(sp)
80004180:	01012903          	lw	s2,16(sp)
80004184:	00c12983          	lw	s3,12(sp)
80004188:	02010113          	addi	sp,sp,32
8000418c:	00008067          	ret

80004190 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80004190:	800087b7          	lui	a5,0x80008
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80004194:	cc07a783          	lw	a5,-832(a5) # 80007cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cc1>
{
80004198:	ff010113          	addi	sp,sp,-16
8000419c:	00812423          	sw	s0,8(sp)
800041a0:	00112623          	sw	ra,12(sp)
800041a4:	00912223          	sw	s1,4(sp)
800041a8:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800041ac:	02f59863          	bne	a1,a5,800041dc <z_priq_dumb_remove+0x4c>
800041b0:	800084b7          	lui	s1,0x80008
800041b4:	800085b7          	lui	a1,0x80008
800041b8:	80007537          	lui	a0,0x80007
800041bc:	a1058593          	addi	a1,a1,-1520 # 80007a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a11>
800041c0:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800041c4:	28c00693          	li	a3,652
800041c8:	97848613          	addi	a2,s1,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
800041cc:	eb8fe0ef          	jal	ra,80002884 <printk>
800041d0:	28c00593          	li	a1,652
800041d4:	97848513          	addi	a0,s1,-1672
800041d8:	ee8fe0ef          	jal	ra,800028c0 <assert_post_action>
	node->prev->next = node->next;
800041dc:	00442703          	lw	a4,4(s0)
800041e0:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
800041e4:	00c12083          	lw	ra,12(sp)
800041e8:	00412483          	lw	s1,4(sp)
800041ec:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800041f0:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800041f4:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
800041f8:	00042223          	sw	zero,4(s0)
800041fc:	00812403          	lw	s0,8(sp)
80004200:	01010113          	addi	sp,sp,16
80004204:	00008067          	ret

80004208 <z_unpend_thread>:
{
80004208:	fe010113          	addi	sp,sp,-32
8000420c:	00812c23          	sw	s0,24(sp)
80004210:	00912a23          	sw	s1,20(sp)
80004214:	00112e23          	sw	ra,28(sp)
80004218:	01212823          	sw	s2,16(sp)
8000421c:	01312623          	sw	s3,12(sp)
80004220:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004224:	00800493          	li	s1,8
80004228:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000422c:	80008937          	lui	s2,0x80008
80004230:	d5890513          	addi	a0,s2,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004234:	0084f493          	andi	s1,s1,8
80004238:	634010ef          	jal	ra,8000586c <z_spin_lock_valid>
8000423c:	02051e63          	bnez	a0,80004278 <z_unpend_thread+0x70>
80004240:	800079b7          	lui	s3,0x80007
80004244:	800075b7          	lui	a1,0x80007
80004248:	80007537          	lui	a0,0x80007
8000424c:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80004250:	04e00693          	li	a3,78
80004254:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004258:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000425c:	e28fe0ef          	jal	ra,80002884 <printk>
80004260:	80007537          	lui	a0,0x80007
80004264:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80004268:	e1cfe0ef          	jal	ra,80002884 <printk>
8000426c:	04e00593          	li	a1,78
80004270:	68c98513          	addi	a0,s3,1676
80004274:	e4cfe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80004278:	d5890513          	addi	a0,s2,-680
8000427c:	648010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004280:	00840513          	addi	a0,s0,8
80004284:	a29ff0ef          	jal	ra,80003cac <pended_on.isra.15>
80004288:	00040593          	mv	a1,s0
8000428c:	f05ff0ef          	jal	ra,80004190 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004290:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004294:	d5890513          	addi	a0,s2,-680
80004298:	ffd7f793          	andi	a5,a5,-3
8000429c:	00f406a3          	sb	a5,13(s0)
800042a0:	5f4010ef          	jal	ra,80005894 <z_spin_unlock_valid>
800042a4:	02051e63          	bnez	a0,800042e0 <z_unpend_thread+0xd8>
800042a8:	80007937          	lui	s2,0x80007
800042ac:	800075b7          	lui	a1,0x80007
800042b0:	80007537          	lui	a0,0x80007
800042b4:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
800042b8:	06100693          	li	a3,97
800042bc:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
800042c0:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800042c4:	dc0fe0ef          	jal	ra,80002884 <printk>
800042c8:	80007537          	lui	a0,0x80007
800042cc:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800042d0:	db4fe0ef          	jal	ra,80002884 <printk>
800042d4:	06100593          	li	a1,97
800042d8:	68c90513          	addi	a0,s2,1676
800042dc:	de4fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042e0:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800042e4:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800042e8:	01840513          	addi	a0,s0,24
}
800042ec:	01812403          	lw	s0,24(sp)
800042f0:	01c12083          	lw	ra,28(sp)
800042f4:	01412483          	lw	s1,20(sp)
800042f8:	01012903          	lw	s2,16(sp)
800042fc:	00c12983          	lw	s3,12(sp)
80004300:	02010113          	addi	sp,sp,32
80004304:	4dd0106f          	j	80005fe0 <z_abort_timeout>

80004308 <z_priq_dumb_best>:
	return list->head == list;
80004308:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000430c:	00f51463          	bne	a0,a5,80004314 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80004310:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80004314:	00078513          	mv	a0,a5
80004318:	00008067          	ret

8000431c <update_cache>:
{
8000431c:	ff010113          	addi	sp,sp,-16
80004320:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80004324:	80008437          	lui	s0,0x80008
{
80004328:	01212023          	sw	s2,0(sp)
8000432c:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80004330:	0d840513          	addi	a0,s0,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
80004334:	02450513          	addi	a0,a0,36
{
80004338:	00912223          	sw	s1,4(sp)
8000433c:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80004340:	fc9ff0ef          	jal	ra,80004308 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80004344:	0d840413          	addi	s0,s0,216
80004348:	00050493          	mv	s1,a0
8000434c:	00051463          	bnez	a0,80004354 <update_cache+0x38>
80004350:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
80004354:	06091e63          	bnez	s2,800043d0 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80004358:	00842783          	lw	a5,8(s0)
8000435c:	02079e63          	bnez	a5,80004398 <update_cache+0x7c>
80004360:	80008937          	lui	s2,0x80008
80004364:	800085b7          	lui	a1,0x80008
80004368:	80007537          	lui	a0,0x80007
8000436c:	9a458593          	addi	a1,a1,-1628 # 800079a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079a5>
80004370:	07f00693          	li	a3,127
80004374:	97890613          	addi	a2,s2,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
80004378:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000437c:	d08fe0ef          	jal	ra,80002884 <printk>
80004380:	80007537          	lui	a0,0x80007
80004384:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
80004388:	cfcfe0ef          	jal	ra,80002884 <printk>
8000438c:	07f00593          	li	a1,127
80004390:	97890513          	addi	a0,s2,-1672
80004394:	d2cfe0ef          	jal	ra,800028c0 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80004398:	00842783          	lw	a5,8(s0)
8000439c:	00d7c703          	lbu	a4,13(a5)
800043a0:	01f77713          	andi	a4,a4,31
800043a4:	02071663          	bnez	a4,800043d0 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
800043a8:	00e7d683          	lhu	a3,14(a5)
800043ac:	07f00713          	li	a4,127
800043b0:	02d77063          	bgeu	a4,a3,800043d0 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
800043b4:	02f42023          	sw	a5,32(s0)
}
800043b8:	00c12083          	lw	ra,12(sp)
800043bc:	00812403          	lw	s0,8(sp)
800043c0:	00412483          	lw	s1,4(sp)
800043c4:	00012903          	lw	s2,0(sp)
800043c8:	01010113          	addi	sp,sp,16
800043cc:	00008067          	ret
		if (th != _current) {
800043d0:	00842783          	lw	a5,8(s0)
800043d4:	00978463          	beq	a5,s1,800043dc <update_cache+0xc0>
			reset_time_slice();
800043d8:	8a1ff0ef          	jal	ra,80003c78 <reset_time_slice>
		_kernel.ready_q.cache = th;
800043dc:	02942023          	sw	s1,32(s0)
}
800043e0:	fd9ff06f          	j	800043b8 <update_cache+0x9c>

800043e4 <k_sched_unlock>:
{
800043e4:	fe010113          	addi	sp,sp,-32
800043e8:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800043ec:	80008937          	lui	s2,0x80008
800043f0:	0d890793          	addi	a5,s2,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
800043f4:	0087a783          	lw	a5,8(a5)
{
800043f8:	00112e23          	sw	ra,28(sp)
800043fc:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80004400:	00f7c783          	lbu	a5,15(a5)
{
80004404:	00912a23          	sw	s1,20(sp)
80004408:	01312623          	sw	s3,12(sp)
8000440c:	0d890913          	addi	s2,s2,216
	__ASSERT(_current->base.sched_locked != 0, "");
80004410:	02079e63          	bnez	a5,8000444c <k_sched_unlock+0x68>
80004414:	80008437          	lui	s0,0x80008
80004418:	800085b7          	lui	a1,0x80008
8000441c:	80007537          	lui	a0,0x80007
80004420:	95058593          	addi	a1,a1,-1712 # 80007950 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007951>
80004424:	22100693          	li	a3,545
80004428:	97840613          	addi	a2,s0,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
8000442c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004430:	c54fe0ef          	jal	ra,80002884 <printk>
80004434:	80007537          	lui	a0,0x80007
80004438:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
8000443c:	c48fe0ef          	jal	ra,80002884 <printk>
80004440:	22100593          	li	a1,545
80004444:	97840513          	addi	a0,s0,-1672
80004448:	c78fe0ef          	jal	ra,800028c0 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
8000444c:	00092783          	lw	a5,0(s2)
80004450:	02078e63          	beqz	a5,8000448c <k_sched_unlock+0xa8>
80004454:	80008437          	lui	s0,0x80008
80004458:	800085b7          	lui	a1,0x80008
8000445c:	80007537          	lui	a0,0x80007
80004460:	91058593          	addi	a1,a1,-1776 # 80007910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007911>
80004464:	22200693          	li	a3,546
80004468:	97840613          	addi	a2,s0,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
8000446c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004470:	c14fe0ef          	jal	ra,80002884 <printk>
80004474:	80007537          	lui	a0,0x80007
80004478:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
8000447c:	c08fe0ef          	jal	ra,80002884 <printk>
80004480:	22200593          	li	a1,546
80004484:	97840513          	addi	a0,s0,-1672
80004488:	c38fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000448c:	00800413          	li	s0,8
80004490:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004494:	800084b7          	lui	s1,0x80008
80004498:	d5848513          	addi	a0,s1,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
8000449c:	00847413          	andi	s0,s0,8
800044a0:	3cc010ef          	jal	ra,8000586c <z_spin_lock_valid>
800044a4:	02051e63          	bnez	a0,800044e0 <k_sched_unlock+0xfc>
800044a8:	800079b7          	lui	s3,0x80007
800044ac:	800075b7          	lui	a1,0x80007
800044b0:	80007537          	lui	a0,0x80007
800044b4:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
800044b8:	04e00693          	li	a3,78
800044bc:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
800044c0:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800044c4:	bc0fe0ef          	jal	ra,80002884 <printk>
800044c8:	80007537          	lui	a0,0x80007
800044cc:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
800044d0:	bb4fe0ef          	jal	ra,80002884 <printk>
800044d4:	04e00593          	li	a1,78
800044d8:	68c98513          	addi	a0,s3,1676
800044dc:	be4fe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
800044e0:	d5848513          	addi	a0,s1,-680
800044e4:	3e0010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
800044e8:	00892703          	lw	a4,8(s2)
		update_cache(1);
800044ec:	00100513          	li	a0,1
		++_current->base.sched_locked;
800044f0:	00f74783          	lbu	a5,15(a4)
800044f4:	00178793          	addi	a5,a5,1
800044f8:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
800044fc:	e21ff0ef          	jal	ra,8000431c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004500:	d5848513          	addi	a0,s1,-680
80004504:	390010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80004508:	02051e63          	bnez	a0,80004544 <k_sched_unlock+0x160>
8000450c:	800074b7          	lui	s1,0x80007
80004510:	800075b7          	lui	a1,0x80007
80004514:	80007537          	lui	a0,0x80007
80004518:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
8000451c:	06100693          	li	a3,97
80004520:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004524:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004528:	b5cfe0ef          	jal	ra,80002884 <printk>
8000452c:	80007537          	lui	a0,0x80007
80004530:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80004534:	b50fe0ef          	jal	ra,80002884 <printk>
80004538:	06100593          	li	a1,97
8000453c:	68c48513          	addi	a0,s1,1676
80004540:	b80fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004544:	30042473          	csrrs	s0,mstatus,s0
}
80004548:	01812403          	lw	s0,24(sp)
8000454c:	01c12083          	lw	ra,28(sp)
80004550:	01412483          	lw	s1,20(sp)
80004554:	01012903          	lw	s2,16(sp)
80004558:	00c12983          	lw	s3,12(sp)
8000455c:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80004560:	aa9ff06f          	j	80004008 <z_reschedule_unlocked>

80004564 <z_add_thread_to_ready_q>:
{
80004564:	fe010113          	addi	sp,sp,-32
80004568:	00812c23          	sw	s0,24(sp)
8000456c:	00912a23          	sw	s1,20(sp)
80004570:	00112e23          	sw	ra,28(sp)
80004574:	01212823          	sw	s2,16(sp)
80004578:	01312623          	sw	s3,12(sp)
8000457c:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004580:	00800493          	li	s1,8
80004584:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004588:	80008937          	lui	s2,0x80008
8000458c:	d5890513          	addi	a0,s2,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004590:	0084f493          	andi	s1,s1,8
80004594:	2d8010ef          	jal	ra,8000586c <z_spin_lock_valid>
80004598:	02051e63          	bnez	a0,800045d4 <z_add_thread_to_ready_q+0x70>
8000459c:	800079b7          	lui	s3,0x80007
800045a0:	800075b7          	lui	a1,0x80007
800045a4:	80007537          	lui	a0,0x80007
800045a8:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
800045ac:	04e00693          	li	a3,78
800045b0:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
800045b4:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800045b8:	accfe0ef          	jal	ra,80002884 <printk>
800045bc:	80007537          	lui	a0,0x80007
800045c0:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
800045c4:	ac0fe0ef          	jal	ra,80002884 <printk>
800045c8:	04e00593          	li	a1,78
800045cc:	68c98513          	addi	a0,s3,1676
800045d0:	af0fe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
800045d4:	d5890513          	addi	a0,s2,-680
800045d8:	2ec010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	return thread == _idle_thread;
800045dc:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
800045e0:	cc07a783          	lw	a5,-832(a5) # 80007cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cc1>
800045e4:	02f41863          	bne	s0,a5,80004614 <z_add_thread_to_ready_q+0xb0>
800045e8:	800089b7          	lui	s3,0x80008
800045ec:	800085b7          	lui	a1,0x80008
800045f0:	80007537          	lui	a0,0x80007
800045f4:	a1058593          	addi	a1,a1,-1520 # 80007a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a11>
800045f8:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800045fc:	27600693          	li	a3,630
80004600:	97898613          	addi	a2,s3,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
80004604:	a80fe0ef          	jal	ra,80002884 <printk>
80004608:	27600593          	li	a1,630
8000460c:	97898513          	addi	a0,s3,-1672
80004610:	ab0fe0ef          	jal	ra,800028c0 <assert_post_action>
	return list->head == list;
80004614:	80008737          	lui	a4,0x80008
80004618:	0d870693          	addi	a3,a4,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
8000461c:	0246a783          	lw	a5,36(a3)
80004620:	0286a603          	lw	a2,40(a3)
80004624:	800086b7          	lui	a3,0x80008
80004628:	0fc68693          	addi	a3,a3,252 # 800080fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080fd>
8000462c:	0d870713          	addi	a4,a4,216
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004630:	0ad78663          	beq	a5,a3,800046dc <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004634:	0a078463          	beqz	a5,800046dc <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80004638:	00e40583          	lb	a1,14(s0)
8000463c:	00e78503          	lb	a0,14(a5)
80004640:	08a5d863          	bge	a1,a0,800046d0 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80004644:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004648:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
8000464c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004650:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004654:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80004658:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
8000465c:	00000513          	li	a0,0
80004660:	0407e793          	ori	a5,a5,64
80004664:	00f406a3          	sb	a5,13(s0)
80004668:	cb5ff0ef          	jal	ra,8000431c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000466c:	d5890513          	addi	a0,s2,-680
80004670:	224010ef          	jal	ra,80005894 <z_spin_unlock_valid>
80004674:	02051e63          	bnez	a0,800046b0 <z_add_thread_to_ready_q+0x14c>
80004678:	80007437          	lui	s0,0x80007
8000467c:	800075b7          	lui	a1,0x80007
80004680:	80007537          	lui	a0,0x80007
80004684:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80004688:	06100693          	li	a3,97
8000468c:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004690:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004694:	9f0fe0ef          	jal	ra,80002884 <printk>
80004698:	80007537          	lui	a0,0x80007
8000469c:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800046a0:	9e4fe0ef          	jal	ra,80002884 <printk>
800046a4:	06100593          	li	a1,97
800046a8:	68c40513          	addi	a0,s0,1676
800046ac:	a14fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800046b0:	3004a4f3          	csrrs	s1,mstatus,s1
}
800046b4:	01c12083          	lw	ra,28(sp)
800046b8:	01812403          	lw	s0,24(sp)
800046bc:	01412483          	lw	s1,20(sp)
800046c0:	01012903          	lw	s2,16(sp)
800046c4:	00c12983          	lw	s3,12(sp)
800046c8:	02010113          	addi	sp,sp,32
800046cc:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
800046d0:	00f60663          	beq	a2,a5,800046dc <z_add_thread_to_ready_q+0x178>
800046d4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800046d8:	f60792e3          	bnez	a5,8000463c <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
800046dc:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
800046e0:	02872783          	lw	a5,40(a4)
	node->next = list;
800046e4:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
800046e8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800046ec:	02872423          	sw	s0,40(a4)
800046f0:	f69ff06f          	j	80004658 <z_add_thread_to_ready_q+0xf4>

800046f4 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
800046f4:	ff052783          	lw	a5,-16(a0)
{
800046f8:	fe010113          	addi	sp,sp,-32
800046fc:	00812c23          	sw	s0,24(sp)
80004700:	01312623          	sw	s3,12(sp)
80004704:	00112e23          	sw	ra,28(sp)
80004708:	00912a23          	sw	s1,20(sp)
8000470c:	01212823          	sw	s2,16(sp)
80004710:	01412423          	sw	s4,8(sp)
80004714:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80004718:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
8000471c:	0c078463          	beqz	a5,800047e4 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004720:	00800493          	li	s1,8
80004724:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004728:	80008937          	lui	s2,0x80008
8000472c:	d5890513          	addi	a0,s2,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004730:	0084f493          	andi	s1,s1,8
80004734:	138010ef          	jal	ra,8000586c <z_spin_lock_valid>
80004738:	02051e63          	bnez	a0,80004774 <z_thread_timeout+0x80>
8000473c:	80007a37          	lui	s4,0x80007
80004740:	800075b7          	lui	a1,0x80007
80004744:	80007537          	lui	a0,0x80007
80004748:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
8000474c:	04e00693          	li	a3,78
80004750:	68ca0613          	addi	a2,s4,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004754:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004758:	92cfe0ef          	jal	ra,80002884 <printk>
8000475c:	80007537          	lui	a0,0x80007
80004760:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80004764:	920fe0ef          	jal	ra,80002884 <printk>
80004768:	04e00593          	li	a1,78
8000476c:	68ca0513          	addi	a0,s4,1676
80004770:	950fe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80004774:	d5890513          	addi	a0,s2,-680
80004778:	14c010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000477c:	ff040513          	addi	a0,s0,-16
80004780:	d2cff0ef          	jal	ra,80003cac <pended_on.isra.15>
80004784:	00098593          	mv	a1,s3
80004788:	a09ff0ef          	jal	ra,80004190 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000478c:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004790:	d5890513          	addi	a0,s2,-680
80004794:	ffd7f793          	andi	a5,a5,-3
80004798:	fef40aa3          	sb	a5,-11(s0)
8000479c:	0f8010ef          	jal	ra,80005894 <z_spin_unlock_valid>
800047a0:	02051e63          	bnez	a0,800047dc <z_thread_timeout+0xe8>
800047a4:	80007937          	lui	s2,0x80007
800047a8:	800075b7          	lui	a1,0x80007
800047ac:	80007537          	lui	a0,0x80007
800047b0:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
800047b4:	06100693          	li	a3,97
800047b8:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
800047bc:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800047c0:	8c4fe0ef          	jal	ra,80002884 <printk>
800047c4:	80007537          	lui	a0,0x80007
800047c8:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800047cc:	8b8fe0ef          	jal	ra,80002884 <printk>
800047d0:	06100593          	li	a1,97
800047d4:	68c90513          	addi	a0,s2,1676
800047d8:	8e8fe0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800047dc:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800047e0:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800047e4:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
800047e8:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800047ec:	feb7f793          	andi	a5,a5,-21
800047f0:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
800047f4:	c64ff0ef          	jal	ra,80003c58 <z_is_thread_ready>
800047f8:	02050463          	beqz	a0,80004820 <z_thread_timeout+0x12c>
}
800047fc:	01812403          	lw	s0,24(sp)
80004800:	01c12083          	lw	ra,28(sp)
80004804:	01412483          	lw	s1,20(sp)
80004808:	01012903          	lw	s2,16(sp)
8000480c:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80004810:	00098513          	mv	a0,s3
80004814:	00c12983          	lw	s3,12(sp)
80004818:	02010113          	addi	sp,sp,32
8000481c:	d49ff06f          	j	80004564 <z_add_thread_to_ready_q>
80004820:	01c12083          	lw	ra,28(sp)
80004824:	01812403          	lw	s0,24(sp)
80004828:	01412483          	lw	s1,20(sp)
8000482c:	01012903          	lw	s2,16(sp)
80004830:	00c12983          	lw	s3,12(sp)
80004834:	00812a03          	lw	s4,8(sp)
80004838:	02010113          	addi	sp,sp,32
8000483c:	00008067          	ret

80004840 <z_move_thread_to_end_of_prio_q>:
{
80004840:	fe010113          	addi	sp,sp,-32
80004844:	00812c23          	sw	s0,24(sp)
80004848:	01212823          	sw	s2,16(sp)
8000484c:	00112e23          	sw	ra,28(sp)
80004850:	00912a23          	sw	s1,20(sp)
80004854:	01312623          	sw	s3,12(sp)
80004858:	01412423          	sw	s4,8(sp)
8000485c:	01512223          	sw	s5,4(sp)
80004860:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004864:	00800913          	li	s2,8
80004868:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000486c:	800089b7          	lui	s3,0x80008
80004870:	d5898513          	addi	a0,s3,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004874:	00897913          	andi	s2,s2,8
80004878:	7f5000ef          	jal	ra,8000586c <z_spin_lock_valid>
8000487c:	02051e63          	bnez	a0,800048b8 <z_move_thread_to_end_of_prio_q+0x78>
80004880:	800074b7          	lui	s1,0x80007
80004884:	800075b7          	lui	a1,0x80007
80004888:	80007537          	lui	a0,0x80007
8000488c:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80004890:	04e00693          	li	a3,78
80004894:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004898:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000489c:	fe9fd0ef          	jal	ra,80002884 <printk>
800048a0:	80007537          	lui	a0,0x80007
800048a4:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
800048a8:	fddfd0ef          	jal	ra,80002884 <printk>
800048ac:	04e00593          	li	a1,78
800048b0:	68c48513          	addi	a0,s1,1676
800048b4:	80cfe0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
800048b8:	d5898513          	addi	a0,s3,-680
800048bc:	008010ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800048c0:	800084b7          	lui	s1,0x80008
800048c4:	0d848513          	addi	a0,s1,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
800048c8:	00040593          	mv	a1,s0
800048cc:	02450513          	addi	a0,a0,36
800048d0:	8c1ff0ef          	jal	ra,80004190 <z_priq_dumb_remove>
	return thread == _idle_thread;
800048d4:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
800048d8:	cc07a783          	lw	a5,-832(a5) # 80007cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cc1>
800048dc:	80008a37          	lui	s4,0x80008
800048e0:	0d848493          	addi	s1,s1,216
800048e4:	0fca0a13          	addi	s4,s4,252 # 800080fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080fd>
800048e8:	02f41863          	bne	s0,a5,80004918 <z_move_thread_to_end_of_prio_q+0xd8>
800048ec:	80008ab7          	lui	s5,0x80008
800048f0:	800085b7          	lui	a1,0x80008
800048f4:	80007537          	lui	a0,0x80007
800048f8:	a1058593          	addi	a1,a1,-1520 # 80007a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a11>
800048fc:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004900:	27600693          	li	a3,630
80004904:	978a8613          	addi	a2,s5,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
80004908:	f7dfd0ef          	jal	ra,80002884 <printk>
8000490c:	27600593          	li	a1,630
80004910:	978a8513          	addi	a0,s5,-1672
80004914:	fadfd0ef          	jal	ra,800028c0 <assert_post_action>
	return list->head == list;
80004918:	0244a783          	lw	a5,36(s1)
8000491c:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004920:	0b478e63          	beq	a5,s4,800049dc <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004924:	0a078c63          	beqz	a5,800049dc <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80004928:	00e40683          	lb	a3,14(s0)
8000492c:	00e78603          	lb	a2,14(a5)
80004930:	0ac6d063          	bge	a3,a2,800049d0 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80004934:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004938:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
8000493c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004940:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004944:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80004948:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
8000494c:	0084a503          	lw	a0,8(s1)
80004950:	0407e793          	ori	a5,a5,64
80004954:	40850533          	sub	a0,a0,s0
80004958:	00153513          	seqz	a0,a0
8000495c:	00f406a3          	sb	a5,13(s0)
80004960:	9bdff0ef          	jal	ra,8000431c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004964:	d5898513          	addi	a0,s3,-680
80004968:	72d000ef          	jal	ra,80005894 <z_spin_unlock_valid>
8000496c:	02051e63          	bnez	a0,800049a8 <z_move_thread_to_end_of_prio_q+0x168>
80004970:	80007437          	lui	s0,0x80007
80004974:	800075b7          	lui	a1,0x80007
80004978:	80007537          	lui	a0,0x80007
8000497c:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80004980:	06100693          	li	a3,97
80004984:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004988:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000498c:	ef9fd0ef          	jal	ra,80002884 <printk>
80004990:	80007537          	lui	a0,0x80007
80004994:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80004998:	eedfd0ef          	jal	ra,80002884 <printk>
8000499c:	06100593          	li	a1,97
800049a0:	68c40513          	addi	a0,s0,1676
800049a4:	f1dfd0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049a8:	30092973          	csrrs	s2,mstatus,s2
}
800049ac:	01c12083          	lw	ra,28(sp)
800049b0:	01812403          	lw	s0,24(sp)
800049b4:	01412483          	lw	s1,20(sp)
800049b8:	01012903          	lw	s2,16(sp)
800049bc:	00c12983          	lw	s3,12(sp)
800049c0:	00812a03          	lw	s4,8(sp)
800049c4:	00412a83          	lw	s5,4(sp)
800049c8:	02010113          	addi	sp,sp,32
800049cc:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
800049d0:	00e78663          	beq	a5,a4,800049dc <z_move_thread_to_end_of_prio_q+0x19c>
800049d4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800049d8:	f4079ae3          	bnez	a5,8000492c <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
800049dc:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
800049e0:	0284a783          	lw	a5,40(s1)
	node->next = list;
800049e4:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800049e8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800049ec:	0284a423          	sw	s0,40(s1)
800049f0:	f59ff06f          	j	80004948 <z_move_thread_to_end_of_prio_q+0x108>

800049f4 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
800049f4:	800087b7          	lui	a5,0x80008
800049f8:	d607a783          	lw	a5,-672(a5) # 80007d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d61>
800049fc:	06078663          	beqz	a5,80004a68 <z_time_slice+0x74>
80004a00:	800087b7          	lui	a5,0x80008
80004a04:	0d878793          	addi	a5,a5,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
80004a08:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80004a0c:	07f00693          	li	a3,127
80004a10:	00e75603          	lhu	a2,14(a4)
80004a14:	04c6ea63          	bltu	a3,a2,80004a68 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80004a18:	800086b7          	lui	a3,0x80008
80004a1c:	00e70603          	lb	a2,14(a4)
80004a20:	d5c6a683          	lw	a3,-676(a3) # 80007d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d5d>
80004a24:	04d64263          	blt	a2,a3,80004a68 <z_time_slice+0x74>
	return thread == _idle_thread;
80004a28:	800086b7          	lui	a3,0x80008
		&& !is_idle(t)
80004a2c:	cc06a683          	lw	a3,-832(a3) # 80007cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cc1>
80004a30:	02d70c63          	beq	a4,a3,80004a68 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80004a34:	01872683          	lw	a3,24(a4)
80004a38:	02069863          	bnez	a3,80004a68 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80004a3c:	0107a683          	lw	a3,16(a5)
80004a40:	02d54063          	blt	a0,a3,80004a60 <z_time_slice+0x6c>
{
80004a44:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80004a48:	00070513          	mv	a0,a4
{
80004a4c:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80004a50:	df1ff0ef          	jal	ra,80004840 <z_move_thread_to_end_of_prio_q>
}
80004a54:	00c12083          	lw	ra,12(sp)
80004a58:	01010113          	addi	sp,sp,16
			reset_time_slice();
80004a5c:	a1cff06f          	j	80003c78 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80004a60:	40a686b3          	sub	a3,a3,a0
80004a64:	00d7a823          	sw	a3,16(a5)
80004a68:	00008067          	ret

80004a6c <z_remove_thread_from_ready_q>:
{
80004a6c:	fe010113          	addi	sp,sp,-32
80004a70:	00812c23          	sw	s0,24(sp)
80004a74:	01312623          	sw	s3,12(sp)
80004a78:	00112e23          	sw	ra,28(sp)
80004a7c:	00912a23          	sw	s1,20(sp)
80004a80:	01212823          	sw	s2,16(sp)
80004a84:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004a88:	00800413          	li	s0,8
80004a8c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004a90:	800084b7          	lui	s1,0x80008
80004a94:	d5848513          	addi	a0,s1,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004a98:	00847413          	andi	s0,s0,8
80004a9c:	5d1000ef          	jal	ra,8000586c <z_spin_lock_valid>
80004aa0:	02051e63          	bnez	a0,80004adc <z_remove_thread_from_ready_q+0x70>
80004aa4:	80007937          	lui	s2,0x80007
80004aa8:	800075b7          	lui	a1,0x80007
80004aac:	80007537          	lui	a0,0x80007
80004ab0:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80004ab4:	04e00693          	li	a3,78
80004ab8:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004abc:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004ac0:	dc5fd0ef          	jal	ra,80002884 <printk>
80004ac4:	80007537          	lui	a0,0x80007
80004ac8:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80004acc:	db9fd0ef          	jal	ra,80002884 <printk>
80004ad0:	04e00593          	li	a1,78
80004ad4:	68c90513          	addi	a0,s2,1676
80004ad8:	de9fd0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80004adc:	d5848513          	addi	a0,s1,-680
80004ae0:	5e5000ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80004ae4:	00d9c783          	lbu	a5,13(s3)
80004ae8:	80008937          	lui	s2,0x80008
80004aec:	0d890913          	addi	s2,s2,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
80004af0:	0407f793          	andi	a5,a5,64
80004af4:	00078e63          	beqz	a5,80004b10 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80004af8:	00098593          	mv	a1,s3
80004afc:	02490513          	addi	a0,s2,36
80004b00:	e90ff0ef          	jal	ra,80004190 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80004b04:	00d9c783          	lbu	a5,13(s3)
80004b08:	fbf7f793          	andi	a5,a5,-65
80004b0c:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80004b10:	00892503          	lw	a0,8(s2)
80004b14:	41350533          	sub	a0,a0,s3
80004b18:	00153513          	seqz	a0,a0
80004b1c:	801ff0ef          	jal	ra,8000431c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004b20:	d5848513          	addi	a0,s1,-680
80004b24:	571000ef          	jal	ra,80005894 <z_spin_unlock_valid>
80004b28:	02051e63          	bnez	a0,80004b64 <z_remove_thread_from_ready_q+0xf8>
80004b2c:	800074b7          	lui	s1,0x80007
80004b30:	800075b7          	lui	a1,0x80007
80004b34:	80007537          	lui	a0,0x80007
80004b38:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80004b3c:	06100693          	li	a3,97
80004b40:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004b44:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004b48:	d3dfd0ef          	jal	ra,80002884 <printk>
80004b4c:	80007537          	lui	a0,0x80007
80004b50:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80004b54:	d31fd0ef          	jal	ra,80002884 <printk>
80004b58:	06100593          	li	a1,97
80004b5c:	68c48513          	addi	a0,s1,1676
80004b60:	d61fd0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004b64:	30042473          	csrrs	s0,mstatus,s0
}
80004b68:	01c12083          	lw	ra,28(sp)
80004b6c:	01812403          	lw	s0,24(sp)
80004b70:	01412483          	lw	s1,20(sp)
80004b74:	01012903          	lw	s2,16(sp)
80004b78:	00c12983          	lw	s3,12(sp)
80004b7c:	02010113          	addi	sp,sp,32
80004b80:	00008067          	ret

80004b84 <pend>:
{
80004b84:	fe010113          	addi	sp,sp,-32
80004b88:	00812c23          	sw	s0,24(sp)
80004b8c:	00912a23          	sw	s1,20(sp)
80004b90:	00050413          	mv	s0,a0
80004b94:	01212823          	sw	s2,16(sp)
80004b98:	00112e23          	sw	ra,28(sp)
80004b9c:	01312623          	sw	s3,12(sp)
80004ba0:	00058493          	mv	s1,a1
80004ba4:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80004ba8:	ec5ff0ef          	jal	ra,80004a6c <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80004bac:	00d44783          	lbu	a5,13(s0)
80004bb0:	0027e793          	ori	a5,a5,2
80004bb4:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80004bb8:	06048663          	beqz	s1,80004c24 <pend+0xa0>
	return thread == _idle_thread;
80004bbc:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
80004bc0:	cc07a783          	lw	a5,-832(a5) # 80007cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cc1>
		thread->base.pended_on = wait_q;
80004bc4:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80004bc8:	02f41863          	bne	s0,a5,80004bf8 <pend+0x74>
80004bcc:	800089b7          	lui	s3,0x80008
80004bd0:	800085b7          	lui	a1,0x80008
80004bd4:	80007537          	lui	a0,0x80007
80004bd8:	a1058593          	addi	a1,a1,-1520 # 80007a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a11>
80004bdc:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004be0:	27600693          	li	a3,630
80004be4:	97898613          	addi	a2,s3,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
80004be8:	c9dfd0ef          	jal	ra,80002884 <printk>
80004bec:	27600593          	li	a1,630
80004bf0:	97898513          	addi	a0,s3,-1672
80004bf4:	ccdfd0ef          	jal	ra,800028c0 <assert_post_action>
	return list->head == list;
80004bf8:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004bfc:	06f48c63          	beq	s1,a5,80004c74 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004c00:	06078a63          	beqz	a5,80004c74 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80004c04:	00e40703          	lb	a4,14(s0)
80004c08:	00e78683          	lb	a3,14(a5)
80004c0c:	04d75c63          	bge	a4,a3,80004c64 <pend+0xe0>
	node->prev = successor->prev;
80004c10:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004c14:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004c18:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004c1c:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004c20:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80004c24:	fff00793          	li	a5,-1
80004c28:	06f90463          	beq	s2,a5,80004c90 <pend+0x10c>
80004c2c:	00a00593          	li	a1,10
80004c30:	00990513          	addi	a0,s2,9
80004c34:	d15fb0ef          	jal	ra,80000948 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004c38:	00150613          	addi	a2,a0,1
80004c3c:	01840513          	addi	a0,s0,24
}
80004c40:	01812403          	lw	s0,24(sp)
80004c44:	01c12083          	lw	ra,28(sp)
80004c48:	01412483          	lw	s1,20(sp)
80004c4c:	01012903          	lw	s2,16(sp)
80004c50:	00c12983          	lw	s3,12(sp)
80004c54:	800045b7          	lui	a1,0x80004
80004c58:	6f458593          	addi	a1,a1,1780 # 800046f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046f5>
80004c5c:	02010113          	addi	sp,sp,32
80004c60:	1540106f          	j	80005db4 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80004c64:	0044a683          	lw	a3,4(s1)
80004c68:	00d78663          	beq	a5,a3,80004c74 <pend+0xf0>
80004c6c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004c70:	f8079ce3          	bnez	a5,80004c08 <pend+0x84>
	node->prev = list->tail;
80004c74:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004c78:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004c7c:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004c80:	0044a783          	lw	a5,4(s1)
80004c84:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004c88:	0084a223          	sw	s0,4(s1)
80004c8c:	f99ff06f          	j	80004c24 <pend+0xa0>
}
80004c90:	01c12083          	lw	ra,28(sp)
80004c94:	01812403          	lw	s0,24(sp)
80004c98:	01412483          	lw	s1,20(sp)
80004c9c:	01012903          	lw	s2,16(sp)
80004ca0:	00c12983          	lw	s3,12(sp)
80004ca4:	02010113          	addi	sp,sp,32
80004ca8:	00008067          	ret

80004cac <z_pend_curr_irqlock>:
{
80004cac:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004cb0:	800087b7          	lui	a5,0x80008
{
80004cb4:	00812423          	sw	s0,8(sp)
80004cb8:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004cbc:	0e07a503          	lw	a0,224(a5) # 800080e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e1>
{
80004cc0:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004cc4:	ec1ff0ef          	jal	ra,80004b84 <pend>
80004cc8:	00040513          	mv	a0,s0
}
80004ccc:	00812403          	lw	s0,8(sp)
80004cd0:	00c12083          	lw	ra,12(sp)
80004cd4:	01010113          	addi	sp,sp,16
80004cd8:	d60fb06f          	j	80000238 <__swap>

80004cdc <z_pend_curr>:
{
80004cdc:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004ce0:	800087b7          	lui	a5,0x80008
{
80004ce4:	00812423          	sw	s0,8(sp)
80004ce8:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004cec:	0e07a503          	lw	a0,224(a5) # 800080e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e1>
{
80004cf0:	00912223          	sw	s1,4(sp)
80004cf4:	00058493          	mv	s1,a1
80004cf8:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80004cfc:	00068613          	mv	a2,a3
{
80004d00:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004d04:	e81ff0ef          	jal	ra,80004b84 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d08:	00040513          	mv	a0,s0
80004d0c:	389000ef          	jal	ra,80005894 <z_spin_unlock_valid>
80004d10:	02051e63          	bnez	a0,80004d4c <z_pend_curr+0x70>
80004d14:	80007437          	lui	s0,0x80007
80004d18:	800075b7          	lui	a1,0x80007
80004d1c:	80007537          	lui	a0,0x80007
80004d20:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80004d24:	07800693          	li	a3,120
80004d28:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004d2c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004d30:	b55fd0ef          	jal	ra,80002884 <printk>
80004d34:	80007537          	lui	a0,0x80007
80004d38:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80004d3c:	b49fd0ef          	jal	ra,80002884 <printk>
80004d40:	07800593          	li	a1,120
80004d44:	68c40513          	addi	a0,s0,1676
80004d48:	b79fd0ef          	jal	ra,800028c0 <assert_post_action>
}
80004d4c:	00812403          	lw	s0,8(sp)
80004d50:	00c12083          	lw	ra,12(sp)
80004d54:	00048513          	mv	a0,s1
80004d58:	00412483          	lw	s1,4(sp)
80004d5c:	01010113          	addi	sp,sp,16
80004d60:	cd8fb06f          	j	80000238 <__swap>

80004d64 <z_unpend_first_thread>:
{
80004d64:	fe010113          	addi	sp,sp,-32
80004d68:	01212823          	sw	s2,16(sp)
80004d6c:	01312623          	sw	s3,12(sp)
80004d70:	00112e23          	sw	ra,28(sp)
80004d74:	00812c23          	sw	s0,24(sp)
80004d78:	00912a23          	sw	s1,20(sp)
80004d7c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004d80:	00800913          	li	s2,8
80004d84:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004d88:	800084b7          	lui	s1,0x80008
80004d8c:	d5848513          	addi	a0,s1,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80004d90:	00897913          	andi	s2,s2,8
80004d94:	2d9000ef          	jal	ra,8000586c <z_spin_lock_valid>
80004d98:	02051e63          	bnez	a0,80004dd4 <z_unpend_first_thread+0x70>
80004d9c:	80007437          	lui	s0,0x80007
80004da0:	800075b7          	lui	a1,0x80007
80004da4:	80007537          	lui	a0,0x80007
80004da8:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80004dac:	04e00693          	li	a3,78
80004db0:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004db4:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004db8:	acdfd0ef          	jal	ra,80002884 <printk>
80004dbc:	80007537          	lui	a0,0x80007
80004dc0:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80004dc4:	ac1fd0ef          	jal	ra,80002884 <printk>
80004dc8:	04e00593          	li	a1,78
80004dcc:	68c40513          	addi	a0,s0,1676
80004dd0:	af1fd0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80004dd4:	d5848513          	addi	a0,s1,-680
80004dd8:	2ed000ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80004ddc:	00098513          	mv	a0,s3
80004de0:	d28ff0ef          	jal	ra,80004308 <z_priq_dumb_best>
80004de4:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004de8:	d5848513          	addi	a0,s1,-680
80004dec:	2a9000ef          	jal	ra,80005894 <z_spin_unlock_valid>
80004df0:	02051e63          	bnez	a0,80004e2c <z_unpend_first_thread+0xc8>
80004df4:	800079b7          	lui	s3,0x80007
80004df8:	800075b7          	lui	a1,0x80007
80004dfc:	80007537          	lui	a0,0x80007
80004e00:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80004e04:	06100693          	li	a3,97
80004e08:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004e0c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004e10:	a75fd0ef          	jal	ra,80002884 <printk>
80004e14:	80007537          	lui	a0,0x80007
80004e18:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80004e1c:	a69fd0ef          	jal	ra,80002884 <printk>
80004e20:	06100593          	li	a1,97
80004e24:	68c98513          	addi	a0,s3,1676
80004e28:	a99fd0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004e2c:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004e30:	0c040663          	beqz	s0,80004efc <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e34:	00800913          	li	s2,8
80004e38:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e3c:	d5848513          	addi	a0,s1,-680
	key = (mstatus & SOC_MSTATUS_IEN);
80004e40:	00897913          	andi	s2,s2,8
80004e44:	229000ef          	jal	ra,8000586c <z_spin_lock_valid>
80004e48:	02051e63          	bnez	a0,80004e84 <z_unpend_first_thread+0x120>
80004e4c:	800079b7          	lui	s3,0x80007
80004e50:	800075b7          	lui	a1,0x80007
80004e54:	80007537          	lui	a0,0x80007
80004e58:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80004e5c:	04e00693          	li	a3,78
80004e60:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004e64:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004e68:	a1dfd0ef          	jal	ra,80002884 <printk>
80004e6c:	80007537          	lui	a0,0x80007
80004e70:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80004e74:	a11fd0ef          	jal	ra,80002884 <printk>
80004e78:	04e00593          	li	a1,78
80004e7c:	68c98513          	addi	a0,s3,1676
80004e80:	a41fd0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80004e84:	d5848513          	addi	a0,s1,-680
80004e88:	23d000ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004e8c:	00840513          	addi	a0,s0,8
80004e90:	e1dfe0ef          	jal	ra,80003cac <pended_on.isra.15>
80004e94:	00040593          	mv	a1,s0
80004e98:	af8ff0ef          	jal	ra,80004190 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004e9c:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ea0:	d5848513          	addi	a0,s1,-680
80004ea4:	ffd7f793          	andi	a5,a5,-3
80004ea8:	00f406a3          	sb	a5,13(s0)
80004eac:	1e9000ef          	jal	ra,80005894 <z_spin_unlock_valid>
80004eb0:	02051e63          	bnez	a0,80004eec <z_unpend_first_thread+0x188>
80004eb4:	800074b7          	lui	s1,0x80007
80004eb8:	800075b7          	lui	a1,0x80007
80004ebc:	80007537          	lui	a0,0x80007
80004ec0:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80004ec4:	06100693          	li	a3,97
80004ec8:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80004ecc:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004ed0:	9b5fd0ef          	jal	ra,80002884 <printk>
80004ed4:	80007537          	lui	a0,0x80007
80004ed8:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80004edc:	9a9fd0ef          	jal	ra,80002884 <printk>
80004ee0:	06100593          	li	a1,97
80004ee4:	68c48513          	addi	a0,s1,1676
80004ee8:	9d9fd0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004eec:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80004ef0:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80004ef4:	01840513          	addi	a0,s0,24
80004ef8:	0e8010ef          	jal	ra,80005fe0 <z_abort_timeout>
}
80004efc:	00040513          	mv	a0,s0
80004f00:	01c12083          	lw	ra,28(sp)
80004f04:	01812403          	lw	s0,24(sp)
80004f08:	01412483          	lw	s1,20(sp)
80004f0c:	01012903          	lw	s2,16(sp)
80004f10:	00c12983          	lw	s3,12(sp)
80004f14:	02010113          	addi	sp,sp,32
80004f18:	00008067          	ret

80004f1c <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80004f1c:	ff010113          	addi	sp,sp,-16
80004f20:	00912223          	sw	s1,4(sp)
80004f24:	01212023          	sw	s2,0(sp)
80004f28:	00112623          	sw	ra,12(sp)
80004f2c:	00812423          	sw	s0,8(sp)
80004f30:	00050913          	mv	s2,a0
	int need_sched = 0;
80004f34:	00000493          	li	s1,0
	return list->head == list;
80004f38:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004f3c:	00890463          	beq	s2,s0,80004f44 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80004f40:	02041063          	bnez	s0,80004f60 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80004f44:	00c12083          	lw	ra,12(sp)
80004f48:	00812403          	lw	s0,8(sp)
80004f4c:	00048513          	mv	a0,s1
80004f50:	00012903          	lw	s2,0(sp)
80004f54:	00412483          	lw	s1,4(sp)
80004f58:	01010113          	addi	sp,sp,16
80004f5c:	00008067          	ret
		z_unpend_thread(th);
80004f60:	00040513          	mv	a0,s0
80004f64:	aa4ff0ef          	jal	ra,80004208 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80004f68:	00040513          	mv	a0,s0
80004f6c:	cedfe0ef          	jal	ra,80003c58 <z_is_thread_ready>
		need_sched = 1;
80004f70:	00100493          	li	s1,1
80004f74:	fc0502e3          	beqz	a0,80004f38 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80004f78:	00040513          	mv	a0,s0
80004f7c:	de8ff0ef          	jal	ra,80004564 <z_add_thread_to_ready_q>
80004f80:	fb9ff06f          	j	80004f38 <z_unpend_all+0x1c>

80004f84 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80004f84:	800087b7          	lui	a5,0x80008
80004f88:	0d878793          	addi	a5,a5,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
80004f8c:	02478713          	addi	a4,a5,36
80004f90:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004f94:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004f98:	00000593          	li	a1,0
80004f9c:	00000513          	li	a0,0
80004fa0:	d6dfe06f          	j	80003d0c <k_sched_time_slice_set>

80004fa4 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80004fa4:	fe010113          	addi	sp,sp,-32
80004fa8:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80004fac:	80008437          	lui	s0,0x80008
80004fb0:	0d842783          	lw	a5,216(s0) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
{
80004fb4:	00112e23          	sw	ra,28(sp)
80004fb8:	00912a23          	sw	s1,20(sp)
80004fbc:	01212823          	sw	s2,16(sp)
80004fc0:	01312623          	sw	s3,12(sp)
80004fc4:	01412423          	sw	s4,8(sp)
80004fc8:	01512223          	sw	s5,4(sp)
80004fcc:	0d840413          	addi	s0,s0,216
	__ASSERT(!z_is_in_isr(), "");
80004fd0:	02078e63          	beqz	a5,8000500c <z_impl_k_yield+0x68>
80004fd4:	800084b7          	lui	s1,0x80008
80004fd8:	800085b7          	lui	a1,0x80008
80004fdc:	80007537          	lui	a0,0x80007
80004fe0:	91058593          	addi	a1,a1,-1776 # 80007910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007911>
80004fe4:	37e00693          	li	a3,894
80004fe8:	97848613          	addi	a2,s1,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
80004fec:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80004ff0:	895fd0ef          	jal	ra,80002884 <printk>
80004ff4:	80007537          	lui	a0,0x80007
80004ff8:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
80004ffc:	889fd0ef          	jal	ra,80002884 <printk>
80005000:	37e00593          	li	a1,894
80005004:	97848513          	addi	a0,s1,-1672
80005008:	8b9fd0ef          	jal	ra,800028c0 <assert_post_action>
	return thread == _idle_thread;
8000500c:	800087b7          	lui	a5,0x80008

	if (!is_idle(_current)) {
80005010:	00842683          	lw	a3,8(s0)
80005014:	cc07a703          	lw	a4,-832(a5) # 80007cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cc1>
80005018:	00078a13          	mv	s4,a5
8000501c:	12e68663          	beq	a3,a4,80005148 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005020:	00800913          	li	s2,8
80005024:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005028:	800089b7          	lui	s3,0x80008
8000502c:	d5898513          	addi	a0,s3,-680 # 80007d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80005030:	00897913          	andi	s2,s2,8
80005034:	039000ef          	jal	ra,8000586c <z_spin_lock_valid>
80005038:	02051e63          	bnez	a0,80005074 <z_impl_k_yield+0xd0>
8000503c:	800074b7          	lui	s1,0x80007
80005040:	800075b7          	lui	a1,0x80007
80005044:	80007537          	lui	a0,0x80007
80005048:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
8000504c:	04e00693          	li	a3,78
80005050:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005054:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005058:	82dfd0ef          	jal	ra,80002884 <printk>
8000505c:	80007537          	lui	a0,0x80007
80005060:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80005064:	821fd0ef          	jal	ra,80002884 <printk>
80005068:	04e00593          	li	a1,78
8000506c:	68c48513          	addi	a0,s1,1676
80005070:	851fd0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80005074:	d5898513          	addi	a0,s3,-680
80005078:	04d000ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
8000507c:	00842583          	lw	a1,8(s0)
80005080:	02440513          	addi	a0,s0,36
80005084:	90cff0ef          	jal	ra,80004190 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80005088:	cc0a2783          	lw	a5,-832(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
8000508c:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
80005090:	80008a37          	lui	s4,0x80008
80005094:	0fca0a13          	addi	s4,s4,252 # 800080fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080fd>
	__ASSERT_NO_MSG(!is_idle(thread));
80005098:	02f49863          	bne	s1,a5,800050c8 <z_impl_k_yield+0x124>
8000509c:	80008ab7          	lui	s5,0x80008
800050a0:	800085b7          	lui	a1,0x80008
800050a4:	80007537          	lui	a0,0x80007
800050a8:	a1058593          	addi	a1,a1,-1520 # 80007a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a11>
800050ac:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800050b0:	27600693          	li	a3,630
800050b4:	978a8613          	addi	a2,s5,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
800050b8:	fccfd0ef          	jal	ra,80002884 <printk>
800050bc:	27600593          	li	a1,630
800050c0:	978a8513          	addi	a0,s5,-1672
800050c4:	ffcfd0ef          	jal	ra,800028c0 <assert_post_action>
	return list->head == list;
800050c8:	02442783          	lw	a5,36(s0)
800050cc:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800050d0:	0b478a63          	beq	a5,s4,80005184 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800050d4:	0a078863          	beqz	a5,80005184 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
800050d8:	00e48683          	lb	a3,14(s1)
800050dc:	00e78603          	lb	a2,14(a5)
800050e0:	08c6dc63          	bge	a3,a2,80005178 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
800050e4:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800050e8:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
800050ec:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
800050f0:	00972023          	sw	s1,0(a4)
	successor->prev = node;
800050f4:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
800050f8:	00100513          	li	a0,1
800050fc:	a20ff0ef          	jal	ra,8000431c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005100:	d5898513          	addi	a0,s3,-680
80005104:	790000ef          	jal	ra,80005894 <z_spin_unlock_valid>
80005108:	02051e63          	bnez	a0,80005144 <z_impl_k_yield+0x1a0>
8000510c:	80007437          	lui	s0,0x80007
80005110:	800075b7          	lui	a1,0x80007
80005114:	80007537          	lui	a0,0x80007
80005118:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
8000511c:	06100693          	li	a3,97
80005120:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005124:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005128:	f5cfd0ef          	jal	ra,80002884 <printk>
8000512c:	80007537          	lui	a0,0x80007
80005130:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80005134:	f50fd0ef          	jal	ra,80002884 <printk>
80005138:	06100593          	li	a1,97
8000513c:	68c40513          	addi	a0,s0,1676
80005140:	f80fd0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005144:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005148:	00800513          	li	a0,8
8000514c:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
80005150:	01812403          	lw	s0,24(sp)
80005154:	01c12083          	lw	ra,28(sp)
80005158:	01412483          	lw	s1,20(sp)
8000515c:	01012903          	lw	s2,16(sp)
80005160:	00c12983          	lw	s3,12(sp)
80005164:	00812a03          	lw	s4,8(sp)
80005168:	00412a83          	lw	s5,4(sp)
8000516c:	00857513          	andi	a0,a0,8
80005170:	02010113          	addi	sp,sp,32
80005174:	8c4fb06f          	j	80000238 <__swap>
	return (node == list->tail) ? NULL : node->next;
80005178:	00e78663          	beq	a5,a4,80005184 <z_impl_k_yield+0x1e0>
8000517c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80005180:	f4079ee3          	bnez	a5,800050dc <z_impl_k_yield+0x138>
	node->prev = list->tail;
80005184:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80005188:	02842783          	lw	a5,40(s0)
	node->next = list;
8000518c:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80005190:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80005194:	02942423          	sw	s1,40(s0)
80005198:	f61ff06f          	j	800050f8 <z_impl_k_yield+0x154>

8000519c <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
8000519c:	fd010113          	addi	sp,sp,-48
800051a0:	02812423          	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
800051a4:	80008437          	lui	s0,0x80008
800051a8:	0d842783          	lw	a5,216(s0) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
{
800051ac:	02912223          	sw	s1,36(sp)
800051b0:	02112623          	sw	ra,44(sp)
800051b4:	03212023          	sw	s2,32(sp)
800051b8:	01312e23          	sw	s3,28(sp)
800051bc:	01412c23          	sw	s4,24(sp)
800051c0:	00050493          	mv	s1,a0
800051c4:	0d840413          	addi	s0,s0,216
	__ASSERT(!z_is_in_isr(), "");
800051c8:	02078e63          	beqz	a5,80005204 <z_impl_k_sleep+0x68>
800051cc:	80008937          	lui	s2,0x80008
800051d0:	800085b7          	lui	a1,0x80008
800051d4:	80007537          	lui	a0,0x80007
800051d8:	91058593          	addi	a1,a1,-1776 # 80007910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007911>
800051dc:	39900693          	li	a3,921
800051e0:	97890613          	addi	a2,s2,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
800051e4:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800051e8:	e9cfd0ef          	jal	ra,80002884 <printk>
800051ec:	80007537          	lui	a0,0x80007
800051f0:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
800051f4:	e90fd0ef          	jal	ra,80002884 <printk>
800051f8:	39900593          	li	a1,921
800051fc:	97890513          	addi	a0,s2,-1672
80005200:	ec0fd0ef          	jal	ra,800028c0 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80005204:	fff00793          	li	a5,-1
80005208:	1af49463          	bne	s1,a5,800053b0 <z_impl_k_sleep+0x214>
8000520c:	80008937          	lui	s2,0x80008
80005210:	800085b7          	lui	a1,0x80008
80005214:	80007537          	lui	a0,0x80007
80005218:	9c458593          	addi	a1,a1,-1596 # 800079c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079c5>
8000521c:	39a00693          	li	a3,922
80005220:	97890613          	addi	a2,s2,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
80005224:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005228:	e5cfd0ef          	jal	ra,80002884 <printk>
8000522c:	80007537          	lui	a0,0x80007
80005230:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
80005234:	e50fd0ef          	jal	ra,80002884 <printk>
80005238:	39a00593          	li	a1,922
8000523c:	97890513          	addi	a0,s2,-1672
80005240:	e80fd0ef          	jal	ra,800028c0 <assert_post_action>
80005244:	00a00593          	li	a1,10
80005248:	00948513          	addi	a0,s1,9
8000524c:	efcfb0ef          	jal	ra,80000948 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80005250:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80005254:	3c4010ef          	jal	ra,80006618 <z_tick_get_32>
80005258:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
8000525c:	00012623          	sw	zero,12(sp)
80005260:	00800493          	li	s1,8
80005264:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005268:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
8000526c:	0084f493          	andi	s1,s1,8
80005270:	5fc000ef          	jal	ra,8000586c <z_spin_lock_valid>
80005274:	02051e63          	bnez	a0,800052b0 <z_impl_k_sleep+0x114>
80005278:	80007a37          	lui	s4,0x80007
8000527c:	800075b7          	lui	a1,0x80007
80005280:	80007537          	lui	a0,0x80007
80005284:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80005288:	04e00693          	li	a3,78
8000528c:	68ca0613          	addi	a2,s4,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005290:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005294:	df0fd0ef          	jal	ra,80002884 <printk>
80005298:	80007537          	lui	a0,0x80007
8000529c:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
800052a0:	de4fd0ef          	jal	ra,80002884 <printk>
800052a4:	04e00593          	li	a1,78
800052a8:	68ca0513          	addi	a0,s4,1676
800052ac:	e14fd0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
800052b0:	00c10513          	addi	a0,sp,12
800052b4:	610000ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
800052b8:	00842503          	lw	a0,8(s0)
800052bc:	fb0ff0ef          	jal	ra,80004a6c <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800052c0:	00842503          	lw	a0,8(s0)
800052c4:	800045b7          	lui	a1,0x80004
800052c8:	00098613          	mv	a2,s3
800052cc:	01850513          	addi	a0,a0,24
800052d0:	6f458593          	addi	a1,a1,1780 # 800046f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046f5>
800052d4:	2e1000ef          	jal	ra,80005db4 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
800052d8:	00842703          	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800052dc:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
800052e0:	00d74783          	lbu	a5,13(a4)
800052e4:	0107e793          	ori	a5,a5,16
800052e8:	00f706a3          	sb	a5,13(a4)
800052ec:	5a8000ef          	jal	ra,80005894 <z_spin_unlock_valid>
800052f0:	02051e63          	bnez	a0,8000532c <z_impl_k_sleep+0x190>
800052f4:	800079b7          	lui	s3,0x80007
800052f8:	800075b7          	lui	a1,0x80007
800052fc:	80007537          	lui	a0,0x80007
80005300:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80005304:	07800693          	li	a3,120
80005308:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
8000530c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005310:	d74fd0ef          	jal	ra,80002884 <printk>
80005314:	80007537          	lui	a0,0x80007
80005318:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
8000531c:	d68fd0ef          	jal	ra,80002884 <printk>
80005320:	07800593          	li	a1,120
80005324:	68c98513          	addi	a0,s3,1676
80005328:	d98fd0ef          	jal	ra,800028c0 <assert_post_action>
8000532c:	00048513          	mv	a0,s1
80005330:	f09fa0ef          	jal	ra,80000238 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80005334:	00842783          	lw	a5,8(s0)
80005338:	00d7c783          	lbu	a5,13(a5)
8000533c:	0107f793          	andi	a5,a5,16
80005340:	02078e63          	beqz	a5,8000537c <z_impl_k_sleep+0x1e0>
80005344:	80008437          	lui	s0,0x80008
80005348:	800085b7          	lui	a1,0x80008
8000534c:	80007537          	lui	a0,0x80007
80005350:	9d858593          	addi	a1,a1,-1576 # 800079d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079d9>
80005354:	3b700693          	li	a3,951
80005358:	97840613          	addi	a2,s0,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
8000535c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005360:	d24fd0ef          	jal	ra,80002884 <printk>
80005364:	80007537          	lui	a0,0x80007
80005368:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
8000536c:	d18fd0ef          	jal	ra,80002884 <printk>
80005370:	3b700593          	li	a1,951
80005374:	97840513          	addi	a0,s0,-1672
80005378:	d48fd0ef          	jal	ra,800028c0 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
8000537c:	29c010ef          	jal	ra,80006618 <z_tick_get_32>
80005380:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80005384:	00000493          	li	s1,0
	if (ticks > 0) {
80005388:	02a05863          	blez	a0,800053b8 <z_impl_k_sleep+0x21c>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000538c:	3e800613          	li	a2,1000
80005390:	00000693          	li	a3,0
80005394:	41f55593          	srai	a1,a0,0x1f
80005398:	d20fb0ef          	jal	ra,800008b8 <__muldi3>
8000539c:	06400613          	li	a2,100
800053a0:	00000693          	li	a3,0
800053a4:	f1dfa0ef          	jal	ra,800002c0 <__udivdi3>
800053a8:	00050493          	mv	s1,a0
		return __ticks_to_ms(ticks);
800053ac:	00c0006f          	j	800053b8 <z_impl_k_sleep+0x21c>
	if (duration == 0) {
800053b0:	e8049ae3          	bnez	s1,80005244 <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800053b4:	bf1ff0ef          	jal	ra,80004fa4 <z_impl_k_yield>
}
800053b8:	02c12083          	lw	ra,44(sp)
800053bc:	02812403          	lw	s0,40(sp)
800053c0:	00048513          	mv	a0,s1
800053c4:	02012903          	lw	s2,32(sp)
800053c8:	02412483          	lw	s1,36(sp)
800053cc:	01c12983          	lw	s3,28(sp)
800053d0:	01812a03          	lw	s4,24(sp)
800053d4:	03010113          	addi	sp,sp,48
800053d8:	00008067          	ret

800053dc <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800053dc:	800087b7          	lui	a5,0x80008
800053e0:	0e07a503          	lw	a0,224(a5) # 800080e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e1>
800053e4:	00008067          	ret

800053e8 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800053e8:	fe010113          	addi	sp,sp,-32
800053ec:	00812c23          	sw	s0,24(sp)
800053f0:	00912a23          	sw	s1,20(sp)
800053f4:	01212823          	sw	s2,16(sp)
800053f8:	00112e23          	sw	ra,28(sp)
800053fc:	01312623          	sw	s3,12(sp)
80005400:	00050413          	mv	s0,a0
80005404:	00058913          	mv	s2,a1
80005408:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
8000540c:	02061e63          	bnez	a2,80005448 <z_impl_k_sem_init+0x60>
80005410:	800089b7          	lui	s3,0x80008
80005414:	800085b7          	lui	a1,0x80008
80005418:	80007537          	lui	a0,0x80007
8000541c:	a3458593          	addi	a1,a1,-1484 # 80007a34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a35>
80005420:	04600693          	li	a3,70
80005424:	a2498613          	addi	a2,s3,-1500 # 80007a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a25>
80005428:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000542c:	c58fd0ef          	jal	ra,80002884 <printk>
80005430:	80008537          	lui	a0,0x80008
80005434:	a4050513          	addi	a0,a0,-1472 # 80007a40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a41>
80005438:	c4cfd0ef          	jal	ra,80002884 <printk>
8000543c:	04600593          	li	a1,70
80005440:	a2498513          	addi	a0,s3,-1500
80005444:	c7cfd0ef          	jal	ra,800028c0 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80005448:	0324fe63          	bgeu	s1,s2,80005484 <z_impl_k_sem_init+0x9c>
8000544c:	800089b7          	lui	s3,0x80008
80005450:	800085b7          	lui	a1,0x80008
80005454:	80007537          	lui	a0,0x80007
80005458:	a5858593          	addi	a1,a1,-1448 # 80007a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a59>
8000545c:	04700693          	li	a3,71
80005460:	a2498613          	addi	a2,s3,-1500 # 80007a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a25>
80005464:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005468:	c1cfd0ef          	jal	ra,80002884 <printk>
8000546c:	80008537          	lui	a0,0x80008
80005470:	a7050513          	addi	a0,a0,-1424 # 80007a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a71>
80005474:	c10fd0ef          	jal	ra,80002884 <printk>
80005478:	04700593          	li	a1,71
8000547c:	a2498513          	addi	a0,s3,-1500
80005480:	c40fd0ef          	jal	ra,800028c0 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80005484:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80005488:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
8000548c:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80005490:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80005494:	01c12083          	lw	ra,28(sp)
80005498:	01812403          	lw	s0,24(sp)
8000549c:	01412483          	lw	s1,20(sp)
800054a0:	01012903          	lw	s2,16(sp)
800054a4:	00c12983          	lw	s3,12(sp)
800054a8:	02010113          	addi	sp,sp,32
800054ac:	00008067          	ret

800054b0 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800054b0:	fe010113          	addi	sp,sp,-32
800054b4:	00912a23          	sw	s1,20(sp)
800054b8:	01312623          	sw	s3,12(sp)
800054bc:	00112e23          	sw	ra,28(sp)
800054c0:	00812c23          	sw	s0,24(sp)
800054c4:	01212823          	sw	s2,16(sp)
800054c8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800054cc:	00800493          	li	s1,8
800054d0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800054d4:	80008437          	lui	s0,0x80008
800054d8:	d6440513          	addi	a0,s0,-668 # 80007d64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d65>
	key = (mstatus & SOC_MSTATUS_IEN);
800054dc:	0084f493          	andi	s1,s1,8
800054e0:	38c000ef          	jal	ra,8000586c <z_spin_lock_valid>
800054e4:	02051e63          	bnez	a0,80005520 <z_impl_k_sem_give+0x70>
800054e8:	80007937          	lui	s2,0x80007
800054ec:	800075b7          	lui	a1,0x80007
800054f0:	80007537          	lui	a0,0x80007
800054f4:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
800054f8:	04e00693          	li	a3,78
800054fc:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005500:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005504:	b80fd0ef          	jal	ra,80002884 <printk>
80005508:	80007537          	lui	a0,0x80007
8000550c:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80005510:	b74fd0ef          	jal	ra,80002884 <printk>
80005514:	04e00593          	li	a1,78
80005518:	68c90513          	addi	a0,s2,1676
8000551c:	ba4fd0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80005520:	d6440513          	addi	a0,s0,-668
80005524:	3a0000ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80005528:	00098513          	mv	a0,s3
8000552c:	839ff0ef          	jal	ra,80004d64 <z_unpend_first_thread>
80005530:	00050913          	mv	s2,a0
	if (thread != NULL) {
80005534:	04050263          	beqz	a0,80005578 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005538:	00d54783          	lbu	a5,13(a0)
8000553c:	01f7f793          	andi	a5,a5,31
80005540:	00079863          	bnez	a5,80005550 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80005544:	01852783          	lw	a5,24(a0)
80005548:	00079463          	bnez	a5,80005550 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
8000554c:	818ff0ef          	jal	ra,80004564 <z_add_thread_to_ready_q>
80005550:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80005554:	d6440513          	addi	a0,s0,-668
}
80005558:	01812403          	lw	s0,24(sp)
8000555c:	01c12083          	lw	ra,28(sp)
80005560:	01012903          	lw	s2,16(sp)
80005564:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80005568:	00048593          	mv	a1,s1
}
8000556c:	01412483          	lw	s1,20(sp)
80005570:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80005574:	9a5fe06f          	j	80003f18 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80005578:	0089a703          	lw	a4,8(s3)
8000557c:	00c9a783          	lw	a5,12(s3)
80005580:	40e787b3          	sub	a5,a5,a4
80005584:	00f037b3          	snez	a5,a5
80005588:	00e787b3          	add	a5,a5,a4
8000558c:	00f9a423          	sw	a5,8(s3)
80005590:	fc5ff06f          	j	80005554 <z_impl_k_sem_give+0xa4>

80005594 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80005594:	800087b7          	lui	a5,0x80008
80005598:	0d87a783          	lw	a5,216(a5) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
{
8000559c:	fe010113          	addi	sp,sp,-32
800055a0:	01212823          	sw	s2,16(sp)
800055a4:	01312623          	sw	s3,12(sp)
800055a8:	00112e23          	sw	ra,28(sp)
800055ac:	00812c23          	sw	s0,24(sp)
800055b0:	00912a23          	sw	s1,20(sp)
800055b4:	01412423          	sw	s4,8(sp)
800055b8:	00050913          	mv	s2,a0
800055bc:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800055c0:	04078063          	beqz	a5,80005600 <z_impl_k_sem_take+0x6c>
800055c4:	02058e63          	beqz	a1,80005600 <z_impl_k_sem_take+0x6c>
800055c8:	80008437          	lui	s0,0x80008
800055cc:	800085b7          	lui	a1,0x80008
800055d0:	80007537          	lui	a0,0x80007
800055d4:	a9858593          	addi	a1,a1,-1384 # 80007a98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a99>
800055d8:	08c00693          	li	a3,140
800055dc:	a2440613          	addi	a2,s0,-1500 # 80007a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a25>
800055e0:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800055e4:	aa0fd0ef          	jal	ra,80002884 <printk>
800055e8:	80007537          	lui	a0,0x80007
800055ec:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
800055f0:	a94fd0ef          	jal	ra,80002884 <printk>
800055f4:	08c00593          	li	a1,140
800055f8:	a2440513          	addi	a0,s0,-1500
800055fc:	ac4fd0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005600:	00800413          	li	s0,8
80005604:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005608:	800084b7          	lui	s1,0x80008
8000560c:	d6448513          	addi	a0,s1,-668 # 80007d64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d65>
	key = (mstatus & SOC_MSTATUS_IEN);
80005610:	00847413          	andi	s0,s0,8
80005614:	258000ef          	jal	ra,8000586c <z_spin_lock_valid>
80005618:	02051e63          	bnez	a0,80005654 <z_impl_k_sem_take+0xc0>
8000561c:	80007a37          	lui	s4,0x80007
80005620:	800075b7          	lui	a1,0x80007
80005624:	80007537          	lui	a0,0x80007
80005628:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
8000562c:	04e00693          	li	a3,78
80005630:	68ca0613          	addi	a2,s4,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005634:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005638:	a4cfd0ef          	jal	ra,80002884 <printk>
8000563c:	80007537          	lui	a0,0x80007
80005640:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80005644:	a40fd0ef          	jal	ra,80002884 <printk>
80005648:	04e00593          	li	a1,78
8000564c:	68ca0513          	addi	a0,s4,1676
80005650:	a70fd0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80005654:	d6448513          	addi	a0,s1,-668
80005658:	26c000ef          	jal	ra,800058c4 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
8000565c:	00892783          	lw	a5,8(s2)
80005660:	06078c63          	beqz	a5,800056d8 <z_impl_k_sem_take+0x144>
		sem->count--;
80005664:	fff78793          	addi	a5,a5,-1
80005668:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000566c:	d6448513          	addi	a0,s1,-668
80005670:	224000ef          	jal	ra,80005894 <z_spin_unlock_valid>
80005674:	02051e63          	bnez	a0,800056b0 <z_impl_k_sem_take+0x11c>
80005678:	800074b7          	lui	s1,0x80007
8000567c:	800075b7          	lui	a1,0x80007
80005680:	80007537          	lui	a0,0x80007
80005684:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80005688:	06100693          	li	a3,97
8000568c:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005690:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005694:	9f0fd0ef          	jal	ra,80002884 <printk>
80005698:	80007537          	lui	a0,0x80007
8000569c:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800056a0:	9e4fd0ef          	jal	ra,80002884 <printk>
800056a4:	06100593          	li	a1,97
800056a8:	68c48513          	addi	a0,s1,1676
800056ac:	a14fd0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800056b0:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800056b4:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800056b8:	01c12083          	lw	ra,28(sp)
800056bc:	01812403          	lw	s0,24(sp)
800056c0:	01412483          	lw	s1,20(sp)
800056c4:	01012903          	lw	s2,16(sp)
800056c8:	00c12983          	lw	s3,12(sp)
800056cc:	00812a03          	lw	s4,8(sp)
800056d0:	02010113          	addi	sp,sp,32
800056d4:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800056d8:	04099a63          	bnez	s3,8000572c <z_impl_k_sem_take+0x198>
800056dc:	d6448513          	addi	a0,s1,-668
800056e0:	1b4000ef          	jal	ra,80005894 <z_spin_unlock_valid>
800056e4:	02051e63          	bnez	a0,80005720 <z_impl_k_sem_take+0x18c>
800056e8:	800074b7          	lui	s1,0x80007
800056ec:	800075b7          	lui	a1,0x80007
800056f0:	80007537          	lui	a0,0x80007
800056f4:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
800056f8:	06100693          	li	a3,97
800056fc:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005700:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005704:	980fd0ef          	jal	ra,80002884 <printk>
80005708:	80007537          	lui	a0,0x80007
8000570c:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80005710:	974fd0ef          	jal	ra,80002884 <printk>
80005714:	06100593          	li	a1,97
80005718:	68c48513          	addi	a0,s1,1676
8000571c:	9a4fd0ef          	jal	ra,800028c0 <assert_post_action>
80005720:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80005724:	ff000513          	li	a0,-16
80005728:	f91ff06f          	j	800056b8 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000572c:	00040593          	mv	a1,s0
}
80005730:	01812403          	lw	s0,24(sp)
80005734:	01c12083          	lw	ra,28(sp)
80005738:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000573c:	00098693          	mv	a3,s3
80005740:	00090613          	mv	a2,s2
}
80005744:	00c12983          	lw	s3,12(sp)
80005748:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000574c:	d6448513          	addi	a0,s1,-668
}
80005750:	01412483          	lw	s1,20(sp)
80005754:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005758:	d84ff06f          	j	80004cdc <z_pend_curr>

8000575c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000575c:	00d54783          	lbu	a5,13(a0)
80005760:	01f7f793          	andi	a5,a5,31
80005764:	00079863          	bnez	a5,80005774 <z_is_thread_ready+0x18>
80005768:	01852503          	lw	a0,24(a0)
8000576c:	00153513          	seqz	a0,a0
80005770:	00008067          	ret
80005774:	00000513          	li	a0,0
}
80005778:	00008067          	ret

8000577c <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
8000577c:	800087b7          	lui	a5,0x80008
80005780:	0d87a503          	lw	a0,216(a5) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
}
80005784:	00a03533          	snez	a0,a0
80005788:	00008067          	ret

8000578c <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
8000578c:	800087b7          	lui	a5,0x80008
80005790:	0e07a783          	lw	a5,224(a5) # 800080e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e1>
80005794:	00c7c503          	lbu	a0,12(a5)
}
80005798:	00157513          	andi	a0,a0,1
8000579c:	00008067          	ret

800057a0 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800057a0:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800057a4:	02012303          	lw	t1,32(sp)
{
800057a8:	00812c23          	sw	s0,24(sp)
800057ac:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800057b0:	00612023          	sw	t1,0(sp)
{
800057b4:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800057b8:	954fc0ef          	jal	ra,8000190c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
800057bc:	800087b7          	lui	a5,0x80008
800057c0:	0e07a783          	lw	a5,224(a5) # 800080e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e1>
	sys_trace_thread_create(new_thread);
}
800057c4:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
800057c8:	0687a783          	lw	a5,104(a5)
800057cc:	06f42423          	sw	a5,104(s0)
}
800057d0:	01812403          	lw	s0,24(sp)
800057d4:	02010113          	addi	sp,sp,32
800057d8:	00008067          	ret

800057dc <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
800057dc:	06052783          	lw	a5,96(a0)
{
800057e0:	ff010113          	addi	sp,sp,-16
800057e4:	00812423          	sw	s0,8(sp)
800057e8:	00112623          	sw	ra,12(sp)
800057ec:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
800057f0:	00078463          	beqz	a5,800057f8 <z_thread_single_abort+0x1c>
		thread->fn_abort();
800057f4:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
800057f8:	00040513          	mv	a0,s0
800057fc:	f61ff0ef          	jal	ra,8000575c <z_is_thread_ready>
80005800:	02050463          	beqz	a0,80005828 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80005804:	00040513          	mv	a0,s0
80005808:	a64ff0ef          	jal	ra,80004a6c <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
8000580c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80005810:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80005814:	0087e793          	ori	a5,a5,8
80005818:	00f406a3          	sb	a5,13(s0)
}
8000581c:	00812403          	lw	s0,8(sp)
80005820:	01010113          	addi	sp,sp,16
80005824:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80005828:	00d44783          	lbu	a5,13(s0)
8000582c:	0027f793          	andi	a5,a5,2
80005830:	00078663          	beqz	a5,8000583c <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80005834:	00040513          	mv	a0,s0
80005838:	de4fe0ef          	jal	ra,80003e1c <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
8000583c:	01842783          	lw	a5,24(s0)
80005840:	fc0786e3          	beqz	a5,8000580c <z_thread_single_abort+0x30>
	return z_abort_timeout(&thread->base.timeout);
80005844:	01840513          	addi	a0,s0,24
80005848:	798000ef          	jal	ra,80005fe0 <z_abort_timeout>
8000584c:	fc1ff06f          	j	8000580c <z_thread_single_abort+0x30>

80005850 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80005850:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80005854:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80005858:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
8000585c:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80005860:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80005864:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80005868:	00008067          	ret

8000586c <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
8000586c:	00052503          	lw	a0,0(a0)
80005870:	00050e63          	beqz	a0,8000588c <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80005874:	800087b7          	lui	a5,0x80008
80005878:	0ec7c783          	lbu	a5,236(a5) # 800080ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080ed>
8000587c:	00357513          	andi	a0,a0,3
80005880:	40f50533          	sub	a0,a0,a5
80005884:	00a03533          	snez	a0,a0
80005888:	00008067          	ret
			return false;
		}
	}
	return true;
8000588c:	00100513          	li	a0,1
}
80005890:	00008067          	ret

80005894 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80005894:	800087b7          	lui	a5,0x80008
80005898:	0d878793          	addi	a5,a5,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
8000589c:	0147c703          	lbu	a4,20(a5)
800058a0:	0087a783          	lw	a5,8(a5)
800058a4:	00e7e7b3          	or	a5,a5,a4
800058a8:	00052703          	lw	a4,0(a0)
800058ac:	00f71863          	bne	a4,a5,800058bc <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
800058b0:	00052023          	sw	zero,0(a0)
	return true;
800058b4:	00100513          	li	a0,1
800058b8:	00008067          	ret
		return false;
800058bc:	00000513          	li	a0,0
}
800058c0:	00008067          	ret

800058c4 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
800058c4:	800087b7          	lui	a5,0x80008
800058c8:	0d878793          	addi	a5,a5,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
800058cc:	0147c703          	lbu	a4,20(a5)
800058d0:	0087a783          	lw	a5,8(a5)
800058d4:	00e7e7b3          	or	a5,a5,a4
800058d8:	00f52023          	sw	a5,0(a0)
}
800058dc:	00008067          	ret

800058e0 <z_impl_k_thread_start>:
{
800058e0:	fe010113          	addi	sp,sp,-32
800058e4:	00812c23          	sw	s0,24(sp)
800058e8:	01212823          	sw	s2,16(sp)
800058ec:	00112e23          	sw	ra,28(sp)
800058f0:	00912a23          	sw	s1,20(sp)
800058f4:	01312623          	sw	s3,12(sp)
800058f8:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800058fc:	00800413          	li	s0,8
80005900:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005904:	800084b7          	lui	s1,0x80008
80005908:	d6848513          	addi	a0,s1,-664 # 80007d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d69>
	key = (mstatus & SOC_MSTATUS_IEN);
8000590c:	00847413          	andi	s0,s0,8
80005910:	f5dff0ef          	jal	ra,8000586c <z_spin_lock_valid>
80005914:	02051e63          	bnez	a0,80005950 <z_impl_k_thread_start+0x70>
80005918:	800079b7          	lui	s3,0x80007
8000591c:	800075b7          	lui	a1,0x80007
80005920:	80007537          	lui	a0,0x80007
80005924:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80005928:	04e00693          	li	a3,78
8000592c:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005930:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005934:	f51fc0ef          	jal	ra,80002884 <printk>
80005938:	80007537          	lui	a0,0x80007
8000593c:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80005940:	f45fc0ef          	jal	ra,80002884 <printk>
80005944:	04e00593          	li	a1,78
80005948:	68c98513          	addi	a0,s3,1676
8000594c:	f75fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80005950:	d6848513          	addi	a0,s1,-664
80005954:	f71ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80005958:	00d94783          	lbu	a5,13(s2)
8000595c:	0047f713          	andi	a4,a5,4
80005960:	06071463          	bnez	a4,800059c8 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005964:	d6848513          	addi	a0,s1,-664
80005968:	f2dff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
8000596c:	02051e63          	bnez	a0,800059a8 <z_impl_k_thread_start+0xc8>
80005970:	800074b7          	lui	s1,0x80007
80005974:	800075b7          	lui	a1,0x80007
80005978:	80007537          	lui	a0,0x80007
8000597c:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80005980:	06100693          	li	a3,97
80005984:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005988:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000598c:	ef9fc0ef          	jal	ra,80002884 <printk>
80005990:	80007537          	lui	a0,0x80007
80005994:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80005998:	eedfc0ef          	jal	ra,80002884 <printk>
8000599c:	06100593          	li	a1,97
800059a0:	68c48513          	addi	a0,s1,1676
800059a4:	f1dfc0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800059a8:	30042473          	csrrs	s0,mstatus,s0
}
800059ac:	01c12083          	lw	ra,28(sp)
800059b0:	01812403          	lw	s0,24(sp)
800059b4:	01412483          	lw	s1,20(sp)
800059b8:	01012903          	lw	s2,16(sp)
800059bc:	00c12983          	lw	s3,12(sp)
800059c0:	02010113          	addi	sp,sp,32
800059c4:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
800059c8:	ffb7f793          	andi	a5,a5,-5
800059cc:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
800059d0:	00090513          	mv	a0,s2
800059d4:	d89ff0ef          	jal	ra,8000575c <z_is_thread_ready>
800059d8:	00050663          	beqz	a0,800059e4 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
800059dc:	00090513          	mv	a0,s2
800059e0:	b85fe0ef          	jal	ra,80004564 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
800059e4:	00040593          	mv	a1,s0
}
800059e8:	01812403          	lw	s0,24(sp)
800059ec:	01c12083          	lw	ra,28(sp)
800059f0:	01012903          	lw	s2,16(sp)
800059f4:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
800059f8:	d6848513          	addi	a0,s1,-664
}
800059fc:	01412483          	lw	s1,20(sp)
80005a00:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80005a04:	d14fe06f          	j	80003f18 <z_reschedule>

80005a08 <schedule_new_thread>:
	if (delay == 0) {
80005a08:	00059463          	bnez	a1,80005a10 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80005a0c:	ed5ff06f          	j	800058e0 <z_impl_k_thread_start>
{
80005a10:	ff010113          	addi	sp,sp,-16
80005a14:	00812423          	sw	s0,8(sp)
80005a18:	00050413          	mv	s0,a0
80005a1c:	00058513          	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005a20:	00950513          	addi	a0,a0,9
80005a24:	00a00593          	li	a1,10
80005a28:	00112623          	sw	ra,12(sp)
80005a2c:	f1dfa0ef          	jal	ra,80000948 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80005a30:	00150613          	addi	a2,a0,1
80005a34:	01840513          	addi	a0,s0,24
}
80005a38:	00812403          	lw	s0,8(sp)
80005a3c:	00c12083          	lw	ra,12(sp)
80005a40:	800045b7          	lui	a1,0x80004
80005a44:	6f458593          	addi	a1,a1,1780 # 800046f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046f5>
80005a48:	01010113          	addi	sp,sp,16
80005a4c:	3680006f          	j	80005db4 <z_add_timeout>

80005a50 <z_impl_k_thread_create>:
{
80005a50:	fc010113          	addi	sp,sp,-64
80005a54:	03512223          	sw	s5,36(sp)
80005a58:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80005a5c:	800086b7          	lui	a3,0x80008
80005a60:	0d86a683          	lw	a3,216(a3) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
{
80005a64:	02812c23          	sw	s0,56(sp)
80005a68:	02912a23          	sw	s1,52(sp)
80005a6c:	03312623          	sw	s3,44(sp)
80005a70:	03412423          	sw	s4,40(sp)
80005a74:	02112e23          	sw	ra,60(sp)
80005a78:	03212823          	sw	s2,48(sp)
80005a7c:	00050413          	mv	s0,a0
80005a80:	00058993          	mv	s3,a1
80005a84:	00060a13          	mv	s4,a2
80005a88:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80005a8c:	04068e63          	beqz	a3,80005ae8 <z_impl_k_thread_create+0x98>
80005a90:	80008937          	lui	s2,0x80008
80005a94:	800085b7          	lui	a1,0x80008
80005a98:	80007537          	lui	a0,0x80007
80005a9c:	1b200693          	li	a3,434
80005aa0:	acc90613          	addi	a2,s2,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80005aa4:	91058593          	addi	a1,a1,-1776 # 80007910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007911>
80005aa8:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005aac:	01112e23          	sw	a7,28(sp)
80005ab0:	01012c23          	sw	a6,24(sp)
80005ab4:	00f12a23          	sw	a5,20(sp)
80005ab8:	00e12823          	sw	a4,16(sp)
80005abc:	dc9fc0ef          	jal	ra,80002884 <printk>
80005ac0:	80008537          	lui	a0,0x80008
80005ac4:	ae050513          	addi	a0,a0,-1312 # 80007ae0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ae1>
80005ac8:	dbdfc0ef          	jal	ra,80002884 <printk>
80005acc:	1b200593          	li	a1,434
80005ad0:	acc90513          	addi	a0,s2,-1332
80005ad4:	dedfc0ef          	jal	ra,800028c0 <assert_post_action>
80005ad8:	01c12883          	lw	a7,28(sp)
80005adc:	01812803          	lw	a6,24(sp)
80005ae0:	01412783          	lw	a5,20(sp)
80005ae4:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005ae8:	04012683          	lw	a3,64(sp)
80005aec:	00012223          	sw	zero,4(sp)
80005af0:	000a0613          	mv	a2,s4
80005af4:	00d12023          	sw	a3,0(sp)
80005af8:	00098593          	mv	a1,s3
80005afc:	000a8693          	mv	a3,s5
80005b00:	00040513          	mv	a0,s0
80005b04:	c9dff0ef          	jal	ra,800057a0 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80005b08:	fff00793          	li	a5,-1
80005b0c:	00f48863          	beq	s1,a5,80005b1c <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80005b10:	00048593          	mv	a1,s1
80005b14:	00040513          	mv	a0,s0
80005b18:	ef1ff0ef          	jal	ra,80005a08 <schedule_new_thread>
}
80005b1c:	00040513          	mv	a0,s0
80005b20:	03c12083          	lw	ra,60(sp)
80005b24:	03812403          	lw	s0,56(sp)
80005b28:	03412483          	lw	s1,52(sp)
80005b2c:	03012903          	lw	s2,48(sp)
80005b30:	02c12983          	lw	s3,44(sp)
80005b34:	02812a03          	lw	s4,40(sp)
80005b38:	02412a83          	lw	s5,36(sp)
80005b3c:	04010113          	addi	sp,sp,64
80005b40:	00008067          	ret

80005b44 <z_init_static_threads>:
{
80005b44:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80005b48:	800087b7          	lui	a5,0x80008
{
80005b4c:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005b50:	80008937          	lui	s2,0x80008
{
80005b54:	00812c23          	sw	s0,24(sp)
80005b58:	00912a23          	sw	s1,20(sp)
80005b5c:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005b60:	cf478413          	addi	s0,a5,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
80005b64:	cf478493          	addi	s1,a5,-780
80005b68:	cf490913          	addi	s2,s2,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
80005b6c:	03246663          	bltu	s0,s2,80005b98 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80005b70:	00048413          	mv	s0,s1
	k_sched_lock();
80005b74:	ca4fe0ef          	jal	ra,80004018 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80005b78:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80005b7c:	07246063          	bltu	s0,s2,80005bdc <z_init_static_threads+0x98>
}
80005b80:	01812403          	lw	s0,24(sp)
80005b84:	01c12083          	lw	ra,28(sp)
80005b88:	01412483          	lw	s1,20(sp)
80005b8c:	01012903          	lw	s2,16(sp)
80005b90:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80005b94:	851fe06f          	j	800043e4 <k_sched_unlock>
		z_setup_new_thread(
80005b98:	02c42783          	lw	a5,44(s0)
80005b9c:	00f12223          	sw	a5,4(sp)
80005ba0:	02042783          	lw	a5,32(s0)
80005ba4:	00f12023          	sw	a5,0(sp)
80005ba8:	01442783          	lw	a5,20(s0)
80005bac:	01c42883          	lw	a7,28(s0)
80005bb0:	01842803          	lw	a6,24(s0)
80005bb4:	01042703          	lw	a4,16(s0)
80005bb8:	00c42683          	lw	a3,12(s0)
80005bbc:	00842603          	lw	a2,8(s0)
80005bc0:	00442583          	lw	a1,4(s0)
80005bc4:	00042503          	lw	a0,0(s0)
80005bc8:	bd9ff0ef          	jal	ra,800057a0 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80005bcc:	00042783          	lw	a5,0(s0)
80005bd0:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80005bd4:	03040413          	addi	s0,s0,48
80005bd8:	f95ff06f          	j	80005b6c <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80005bdc:	02442583          	lw	a1,36(s0)
80005be0:	00958663          	beq	a1,s1,80005bec <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80005be4:	00042503          	lw	a0,0(s0)
80005be8:	e21ff0ef          	jal	ra,80005a08 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80005bec:	03040413          	addi	s0,s0,48
80005bf0:	f8dff06f          	j	80005b7c <z_init_static_threads+0x38>

80005bf4 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80005bf4:	fe010113          	addi	sp,sp,-32
80005bf8:	00812c23          	sw	s0,24(sp)
80005bfc:	00912a23          	sw	s1,20(sp)
80005c00:	00112e23          	sw	ra,28(sp)
80005c04:	01212823          	sw	s2,16(sp)
80005c08:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80005c0c:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005c10:	00800413          	li	s0,8
80005c14:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005c18:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80005c1c:	00847413          	andi	s0,s0,8
80005c20:	c4dff0ef          	jal	ra,8000586c <z_spin_lock_valid>
80005c24:	02051e63          	bnez	a0,80005c60 <z_impl_k_thread_abort+0x6c>
80005c28:	80007937          	lui	s2,0x80007
80005c2c:	800075b7          	lui	a1,0x80007
80005c30:	80007537          	lui	a0,0x80007
80005c34:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80005c38:	04e00693          	li	a3,78
80005c3c:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005c40:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005c44:	c41fc0ef          	jal	ra,80002884 <printk>
80005c48:	80007537          	lui	a0,0x80007
80005c4c:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80005c50:	c35fc0ef          	jal	ra,80002884 <printk>
80005c54:	04e00593          	li	a1,78
80005c58:	68c90513          	addi	a0,s2,1676
80005c5c:	c65fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80005c60:	00c10513          	addi	a0,sp,12
80005c64:	c61ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80005c68:	00c4c783          	lbu	a5,12(s1)
80005c6c:	0017f793          	andi	a5,a5,1
80005c70:	02078e63          	beqz	a5,80005cac <z_impl_k_thread_abort+0xb8>
80005c74:	80008937          	lui	s2,0x80008
80005c78:	800085b7          	lui	a1,0x80008
80005c7c:	80007537          	lui	a0,0x80007
80005c80:	b2058593          	addi	a1,a1,-1248 # 80007b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b21>
80005c84:	02900693          	li	a3,41
80005c88:	b0890613          	addi	a2,s2,-1272 # 80007b08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b09>
80005c8c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005c90:	bf5fc0ef          	jal	ra,80002884 <printk>
80005c94:	80008537          	lui	a0,0x80008
80005c98:	b5450513          	addi	a0,a0,-1196 # 80007b54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b55>
80005c9c:	be9fc0ef          	jal	ra,80002884 <printk>
80005ca0:	02900593          	li	a1,41
80005ca4:	b0890513          	addi	a0,s2,-1272
80005ca8:	c19fc0ef          	jal	ra,800028c0 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80005cac:	00048513          	mv	a0,s1
80005cb0:	b2dff0ef          	jal	ra,800057dc <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80005cb4:	00040593          	mv	a1,s0
80005cb8:	00c10513          	addi	a0,sp,12
80005cbc:	a5cfe0ef          	jal	ra,80003f18 <z_reschedule>
}
80005cc0:	01c12083          	lw	ra,28(sp)
80005cc4:	01812403          	lw	s0,24(sp)
80005cc8:	01412483          	lw	s1,20(sp)
80005ccc:	01012903          	lw	s2,16(sp)
80005cd0:	02010113          	addi	sp,sp,32
80005cd4:	00008067          	ret

80005cd8 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80005cd8:	800087b7          	lui	a5,0x80008
80005cdc:	d6c7a783          	lw	a5,-660(a5) # 80007d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d6d>
80005ce0:	00079463          	bnez	a5,80005ce8 <elapsed+0x10>
80005ce4:	85cfd06f          	j	80002d40 <z_clock_elapsed>
}
80005ce8:	00000513          	li	a0,0
80005cec:	00008067          	ret

80005cf0 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80005cf0:	00052783          	lw	a5,0(a0)
80005cf4:	02050263          	beqz	a0,80005d18 <remove_timeout+0x28>
80005cf8:	80008737          	lui	a4,0x80008
	return (node == list->tail) ? NULL : node->next;
80005cfc:	cb872703          	lw	a4,-840(a4) # 80007cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cb9>
80005d00:	00e50c63          	beq	a0,a4,80005d18 <remove_timeout+0x28>
	if (next(t) != NULL) {
80005d04:	00078a63          	beqz	a5,80005d18 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80005d08:	0087a703          	lw	a4,8(a5)
80005d0c:	00852683          	lw	a3,8(a0)
80005d10:	00d70733          	add	a4,a4,a3
80005d14:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80005d18:	00452703          	lw	a4,4(a0)
80005d1c:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80005d20:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80005d24:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80005d28:	00052223          	sw	zero,4(a0)
}
80005d2c:	00008067          	ret

80005d30 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80005d30:	800087b7          	lui	a5,0x80008
80005d34:	d787c783          	lbu	a5,-648(a5) # 80007d78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d79>
{
80005d38:	ff010113          	addi	sp,sp,-16
80005d3c:	00112623          	sw	ra,12(sp)
80005d40:	00812423          	sw	s0,8(sp)
80005d44:	00912223          	sw	s1,4(sp)
80005d48:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80005d4c:	00079663          	bnez	a5,80005d58 <next_timeout+0x28>
80005d50:	80000537          	lui	a0,0x80000
80005d54:	fff54513          	not	a0,a0
	return list->head == list;
80005d58:	800087b7          	lui	a5,0x80008
80005d5c:	cb478793          	addi	a5,a5,-844 # 80007cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cb5>
80005d60:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005d64:	02f40463          	beq	s0,a5,80005d8c <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80005d68:	02040263          	beqz	s0,80005d8c <next_timeout+0x5c>
80005d6c:	00842483          	lw	s1,8(s0)
80005d70:	f69ff0ef          	jal	ra,80005cd8 <elapsed>
80005d74:	40a484b3          	sub	s1,s1,a0
80005d78:	00000513          	li	a0,0
80005d7c:	0004c863          	bltz	s1,80005d8c <next_timeout+0x5c>
80005d80:	00842403          	lw	s0,8(s0)
80005d84:	f55ff0ef          	jal	ra,80005cd8 <elapsed>
80005d88:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80005d8c:	800087b7          	lui	a5,0x80008
80005d90:	0e87a783          	lw	a5,232(a5) # 800080e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e9>
80005d94:	00078663          	beqz	a5,80005da0 <next_timeout+0x70>
80005d98:	00a7d463          	bge	a5,a0,80005da0 <next_timeout+0x70>
80005d9c:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80005da0:	00c12083          	lw	ra,12(sp)
80005da4:	00812403          	lw	s0,8(sp)
80005da8:	00412483          	lw	s1,4(sp)
80005dac:	01010113          	addi	sp,sp,16
80005db0:	00008067          	ret

80005db4 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005db4:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80005db8:	fd010113          	addi	sp,sp,-48
80005dbc:	02812423          	sw	s0,40(sp)
80005dc0:	02912223          	sw	s1,36(sp)
80005dc4:	01312e23          	sw	s3,28(sp)
80005dc8:	02112623          	sw	ra,44(sp)
80005dcc:	03212023          	sw	s2,32(sp)
80005dd0:	01412c23          	sw	s4,24(sp)
80005dd4:	01512a23          	sw	s5,20(sp)
80005dd8:	01612823          	sw	s6,16(sp)
80005ddc:	01712623          	sw	s7,12(sp)
80005de0:	01812423          	sw	s8,8(sp)
80005de4:	00050413          	mv	s0,a0
80005de8:	00058993          	mv	s3,a1
80005dec:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005df0:	02078e63          	beqz	a5,80005e2c <z_add_timeout+0x78>
80005df4:	80008937          	lui	s2,0x80008
80005df8:	800085b7          	lui	a1,0x80008
80005dfc:	80007537          	lui	a0,0x80007
80005e00:	b8458593          	addi	a1,a1,-1148 # 80007b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b85>
80005e04:	04d00693          	li	a3,77
80005e08:	b7090613          	addi	a2,s2,-1168 # 80007b70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b71>
80005e0c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005e10:	a75fc0ef          	jal	ra,80002884 <printk>
80005e14:	80007537          	lui	a0,0x80007
80005e18:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
80005e1c:	a69fc0ef          	jal	ra,80002884 <printk>
80005e20:	04d00593          	li	a1,77
80005e24:	b7090513          	addi	a0,s2,-1168
80005e28:	a99fc0ef          	jal	ra,800028c0 <assert_post_action>
	to->fn = fn;
80005e2c:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80005e30:	00904463          	bgtz	s1,80005e38 <z_add_timeout+0x84>
80005e34:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005e38:	00800993          	li	s3,8
80005e3c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005e40:	80008a37          	lui	s4,0x80008
80005e44:	d70a0513          	addi	a0,s4,-656 # 80007d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80005e48:	0089f993          	andi	s3,s3,8
80005e4c:	a21ff0ef          	jal	ra,8000586c <z_spin_lock_valid>
80005e50:	02051e63          	bnez	a0,80005e8c <z_add_timeout+0xd8>
80005e54:	80007937          	lui	s2,0x80007
80005e58:	800075b7          	lui	a1,0x80007
80005e5c:	80007537          	lui	a0,0x80007
80005e60:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80005e64:	04e00693          	li	a3,78
80005e68:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005e6c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005e70:	a15fc0ef          	jal	ra,80002884 <printk>
80005e74:	80007537          	lui	a0,0x80007
80005e78:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80005e7c:	a09fc0ef          	jal	ra,80002884 <printk>
80005e80:	04e00593          	li	a1,78
80005e84:	68c90513          	addi	a0,s2,1676
80005e88:	a39fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80005e8c:	d70a0513          	addi	a0,s4,-656
80005e90:	a35ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80005e94:	e45ff0ef          	jal	ra,80005cd8 <elapsed>
80005e98:	00950533          	add	a0,a0,s1
	return list->head == list;
80005e9c:	800084b7          	lui	s1,0x80008
80005ea0:	cb44a903          	lw	s2,-844(s1) # 80007cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cb5>
80005ea4:	00a42423          	sw	a0,8(s0)
80005ea8:	cb448493          	addi	s1,s1,-844
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005eac:	00990c63          	beq	s2,s1,80005ec4 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80005eb0:	80008ab7          	lui	s5,0x80008
80005eb4:	80008b37          	lui	s6,0x80008
80005eb8:	80007bb7          	lui	s7,0x80007
80005ebc:	80007c37          	lui	s8,0x80007
		for (t = first(); t != NULL; t = next(t)) {
80005ec0:	02091063          	bnez	s2,80005ee0 <z_add_timeout+0x12c>
	node->prev = list->tail;
80005ec4:	0044a783          	lw	a5,4(s1)
	node->next = list;
80005ec8:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80005ecc:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80005ed0:	0044a783          	lw	a5,4(s1)
80005ed4:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80005ed8:	0084a223          	sw	s0,4(s1)
80005edc:	05c0006f          	j	80005f38 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80005ee0:	00892783          	lw	a5,8(s2)
80005ee4:	0207d663          	bgez	a5,80005f10 <z_add_timeout+0x15c>
80005ee8:	ba4b0593          	addi	a1,s6,-1116 # 80007ba4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ba5>
80005eec:	05600693          	li	a3,86
80005ef0:	b70a8613          	addi	a2,s5,-1168 # 80007b70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b71>
80005ef4:	5c0b8513          	addi	a0,s7,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005ef8:	98dfc0ef          	jal	ra,80002884 <printk>
80005efc:	644c0513          	addi	a0,s8,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
80005f00:	985fc0ef          	jal	ra,80002884 <printk>
80005f04:	05600593          	li	a1,86
80005f08:	b70a8513          	addi	a0,s5,-1168
80005f0c:	9b5fc0ef          	jal	ra,800028c0 <assert_post_action>

			if (t->dticks > to->dticks) {
80005f10:	00892703          	lw	a4,8(s2)
80005f14:	00842783          	lw	a5,8(s0)
80005f18:	0ae7d863          	bge	a5,a4,80005fc8 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80005f1c:	40f707b3          	sub	a5,a4,a5
80005f20:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80005f24:	00492783          	lw	a5,4(s2)
	node->next = successor;
80005f28:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80005f2c:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80005f30:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80005f34:	00892223          	sw	s0,4(s2)
	return list->head == list;
80005f38:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005f3c:	00978a63          	beq	a5,s1,80005f50 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80005f40:	00f41863          	bne	s0,a5,80005f50 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80005f44:	dedff0ef          	jal	ra,80005d30 <next_timeout>
80005f48:	00000593          	li	a1,0
80005f4c:	c4dfc0ef          	jal	ra,80002b98 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005f50:	d70a0513          	addi	a0,s4,-656
80005f54:	941ff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
80005f58:	02051e63          	bnez	a0,80005f94 <z_add_timeout+0x1e0>
80005f5c:	80007437          	lui	s0,0x80007
80005f60:	800075b7          	lui	a1,0x80007
80005f64:	80007537          	lui	a0,0x80007
80005f68:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80005f6c:	06100693          	li	a3,97
80005f70:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80005f74:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80005f78:	90dfc0ef          	jal	ra,80002884 <printk>
80005f7c:	80007537          	lui	a0,0x80007
80005f80:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80005f84:	901fc0ef          	jal	ra,80002884 <printk>
80005f88:	06100593          	li	a1,97
80005f8c:	68c40513          	addi	a0,s0,1676
80005f90:	931fc0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005f94:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80005f98:	02c12083          	lw	ra,44(sp)
80005f9c:	02812403          	lw	s0,40(sp)
80005fa0:	02412483          	lw	s1,36(sp)
80005fa4:	02012903          	lw	s2,32(sp)
80005fa8:	01c12983          	lw	s3,28(sp)
80005fac:	01812a03          	lw	s4,24(sp)
80005fb0:	01412a83          	lw	s5,20(sp)
80005fb4:	01012b03          	lw	s6,16(sp)
80005fb8:	00c12b83          	lw	s7,12(sp)
80005fbc:	00812c03          	lw	s8,8(sp)
80005fc0:	03010113          	addi	sp,sp,48
80005fc4:	00008067          	ret
			to->dticks -= t->dticks;
80005fc8:	40e787b3          	sub	a5,a5,a4
80005fcc:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80005fd0:	0044a783          	lw	a5,4(s1)
80005fd4:	ef2788e3          	beq	a5,s2,80005ec4 <z_add_timeout+0x110>
80005fd8:	00092903          	lw	s2,0(s2)
80005fdc:	ee5ff06f          	j	80005ec0 <z_add_timeout+0x10c>

80005fe0 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80005fe0:	fe010113          	addi	sp,sp,-32
80005fe4:	00812c23          	sw	s0,24(sp)
80005fe8:	01312623          	sw	s3,12(sp)
80005fec:	00112e23          	sw	ra,28(sp)
80005ff0:	00912a23          	sw	s1,20(sp)
80005ff4:	01212823          	sw	s2,16(sp)
80005ff8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005ffc:	00800413          	li	s0,8
80006000:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006004:	800084b7          	lui	s1,0x80008
80006008:	d7048513          	addi	a0,s1,-656 # 80007d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d71>
	key = (mstatus & SOC_MSTATUS_IEN);
8000600c:	00847413          	andi	s0,s0,8
80006010:	85dff0ef          	jal	ra,8000586c <z_spin_lock_valid>
80006014:	02051e63          	bnez	a0,80006050 <z_abort_timeout+0x70>
80006018:	80007937          	lui	s2,0x80007
8000601c:	800075b7          	lui	a1,0x80007
80006020:	80007537          	lui	a0,0x80007
80006024:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80006028:	04e00693          	li	a3,78
8000602c:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006030:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006034:	851fc0ef          	jal	ra,80002884 <printk>
80006038:	80007537          	lui	a0,0x80007
8000603c:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80006040:	845fc0ef          	jal	ra,80002884 <printk>
80006044:	04e00593          	li	a1,78
80006048:	68c90513          	addi	a0,s2,1676
8000604c:	875fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80006050:	d7048513          	addi	a0,s1,-656
80006054:	871ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80006058:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
8000605c:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80006060:	00078863          	beqz	a5,80006070 <z_abort_timeout+0x90>
			remove_timeout(to);
80006064:	00098513          	mv	a0,s3
80006068:	c89ff0ef          	jal	ra,80005cf0 <remove_timeout>
			ret = 0;
8000606c:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006070:	d7048513          	addi	a0,s1,-656
80006074:	821ff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
80006078:	02051e63          	bnez	a0,800060b4 <z_abort_timeout+0xd4>
8000607c:	800074b7          	lui	s1,0x80007
80006080:	800075b7          	lui	a1,0x80007
80006084:	80007537          	lui	a0,0x80007
80006088:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
8000608c:	06100693          	li	a3,97
80006090:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006094:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006098:	fecfc0ef          	jal	ra,80002884 <printk>
8000609c:	80007537          	lui	a0,0x80007
800060a0:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800060a4:	fe0fc0ef          	jal	ra,80002884 <printk>
800060a8:	06100593          	li	a1,97
800060ac:	68c48513          	addi	a0,s1,1676
800060b0:	811fc0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800060b4:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
800060b8:	01c12083          	lw	ra,28(sp)
800060bc:	01812403          	lw	s0,24(sp)
800060c0:	00090513          	mv	a0,s2
800060c4:	01412483          	lw	s1,20(sp)
800060c8:	01012903          	lw	s2,16(sp)
800060cc:	00c12983          	lw	s3,12(sp)
800060d0:	02010113          	addi	sp,sp,32
800060d4:	00008067          	ret

800060d8 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
800060d8:	ff010113          	addi	sp,sp,-16
800060dc:	00812423          	sw	s0,8(sp)
800060e0:	00112623          	sw	ra,12(sp)
800060e4:	00912223          	sw	s1,4(sp)
800060e8:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800060ec:	00800413          	li	s0,8
800060f0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800060f4:	800084b7          	lui	s1,0x80008
800060f8:	d7048513          	addi	a0,s1,-656 # 80007d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d71>
	key = (mstatus & SOC_MSTATUS_IEN);
800060fc:	00847413          	andi	s0,s0,8
80006100:	f6cff0ef          	jal	ra,8000586c <z_spin_lock_valid>
80006104:	02051e63          	bnez	a0,80006140 <z_get_next_timeout_expiry+0x68>
80006108:	80007937          	lui	s2,0x80007
8000610c:	800075b7          	lui	a1,0x80007
80006110:	80007537          	lui	a0,0x80007
80006114:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80006118:	04e00693          	li	a3,78
8000611c:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006120:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006124:	f60fc0ef          	jal	ra,80002884 <printk>
80006128:	80007537          	lui	a0,0x80007
8000612c:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80006130:	f54fc0ef          	jal	ra,80002884 <printk>
80006134:	04e00593          	li	a1,78
80006138:	68c90513          	addi	a0,s2,1676
8000613c:	f84fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80006140:	d7048513          	addi	a0,s1,-656
80006144:	f80ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80006148:	be9ff0ef          	jal	ra,80005d30 <next_timeout>
8000614c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006150:	d7048513          	addi	a0,s1,-656
80006154:	f40ff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
80006158:	02051e63          	bnez	a0,80006194 <z_get_next_timeout_expiry+0xbc>
8000615c:	800074b7          	lui	s1,0x80007
80006160:	800075b7          	lui	a1,0x80007
80006164:	80007537          	lui	a0,0x80007
80006168:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
8000616c:	06100693          	li	a3,97
80006170:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006174:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006178:	f0cfc0ef          	jal	ra,80002884 <printk>
8000617c:	80007537          	lui	a0,0x80007
80006180:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80006184:	f00fc0ef          	jal	ra,80002884 <printk>
80006188:	06100593          	li	a1,97
8000618c:	68c48513          	addi	a0,s1,1676
80006190:	f30fc0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006194:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80006198:	00c12083          	lw	ra,12(sp)
8000619c:	00812403          	lw	s0,8(sp)
800061a0:	00090513          	mv	a0,s2
800061a4:	00412483          	lw	s1,4(sp)
800061a8:	00012903          	lw	s2,0(sp)
800061ac:	01010113          	addi	sp,sp,16
800061b0:	00008067          	ret

800061b4 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
800061b4:	fe010113          	addi	sp,sp,-32
800061b8:	00812c23          	sw	s0,24(sp)
800061bc:	01212823          	sw	s2,16(sp)
800061c0:	01412423          	sw	s4,8(sp)
800061c4:	00112e23          	sw	ra,28(sp)
800061c8:	00912a23          	sw	s1,20(sp)
800061cc:	01312623          	sw	s3,12(sp)
800061d0:	00050913          	mv	s2,a0
800061d4:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800061d8:	00800413          	li	s0,8
800061dc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800061e0:	800084b7          	lui	s1,0x80008
800061e4:	d7048513          	addi	a0,s1,-656 # 80007d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d71>
	key = (mstatus & SOC_MSTATUS_IEN);
800061e8:	00847413          	andi	s0,s0,8
800061ec:	e80ff0ef          	jal	ra,8000586c <z_spin_lock_valid>
800061f0:	02051e63          	bnez	a0,8000622c <z_set_timeout_expiry+0x78>
800061f4:	800079b7          	lui	s3,0x80007
800061f8:	800075b7          	lui	a1,0x80007
800061fc:	80007537          	lui	a0,0x80007
80006200:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80006204:	04e00693          	li	a3,78
80006208:	68c98613          	addi	a2,s3,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
8000620c:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006210:	e74fc0ef          	jal	ra,80002884 <printk>
80006214:	80007537          	lui	a0,0x80007
80006218:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
8000621c:	e68fc0ef          	jal	ra,80002884 <printk>
80006220:	04e00593          	li	a1,78
80006224:	68c98513          	addi	a0,s3,1676
80006228:	e98fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
8000622c:	d7048513          	addi	a0,s1,-656
80006230:	e94ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80006234:	afdff0ef          	jal	ra,80005d30 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80006238:	00a95c63          	bge	s2,a0,80006250 <z_set_timeout_expiry+0x9c>
8000623c:	00100793          	li	a5,1
80006240:	00a7d863          	bge	a5,a0,80006250 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80006244:	000a0593          	mv	a1,s4
80006248:	00090513          	mv	a0,s2
8000624c:	94dfc0ef          	jal	ra,80002b98 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006250:	d7048513          	addi	a0,s1,-656
80006254:	e40ff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
80006258:	02051e63          	bnez	a0,80006294 <z_set_timeout_expiry+0xe0>
8000625c:	800074b7          	lui	s1,0x80007
80006260:	800075b7          	lui	a1,0x80007
80006264:	80007537          	lui	a0,0x80007
80006268:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
8000626c:	06100693          	li	a3,97
80006270:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006274:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006278:	e0cfc0ef          	jal	ra,80002884 <printk>
8000627c:	80007537          	lui	a0,0x80007
80006280:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80006284:	e00fc0ef          	jal	ra,80002884 <printk>
80006288:	06100593          	li	a1,97
8000628c:	68c48513          	addi	a0,s1,1676
80006290:	e30fc0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006294:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80006298:	01c12083          	lw	ra,28(sp)
8000629c:	01812403          	lw	s0,24(sp)
800062a0:	01412483          	lw	s1,20(sp)
800062a4:	01012903          	lw	s2,16(sp)
800062a8:	00c12983          	lw	s3,12(sp)
800062ac:	00812a03          	lw	s4,8(sp)
800062b0:	02010113          	addi	sp,sp,32
800062b4:	00008067          	ret

800062b8 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
800062b8:	fd010113          	addi	sp,sp,-48
800062bc:	02812423          	sw	s0,40(sp)
800062c0:	01412c23          	sw	s4,24(sp)
800062c4:	02112623          	sw	ra,44(sp)
800062c8:	02912223          	sw	s1,36(sp)
800062cc:	03212023          	sw	s2,32(sp)
800062d0:	01312e23          	sw	s3,28(sp)
800062d4:	01512a23          	sw	s5,20(sp)
800062d8:	01612823          	sw	s6,16(sp)
800062dc:	01712623          	sw	s7,12(sp)
800062e0:	01812423          	sw	s8,8(sp)
800062e4:	01912223          	sw	s9,4(sp)
800062e8:	01a12023          	sw	s10,0(sp)
800062ec:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800062f0:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
800062f4:	f00fe0ef          	jal	ra,800049f4 <z_time_slice>
800062f8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800062fc:	80008937          	lui	s2,0x80008
80006300:	d7090513          	addi	a0,s2,-656 # 80007d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80006304:	00847413          	andi	s0,s0,8
80006308:	d64ff0ef          	jal	ra,8000586c <z_spin_lock_valid>
8000630c:	02051e63          	bnez	a0,80006348 <z_clock_announce+0x90>
80006310:	800074b7          	lui	s1,0x80007
80006314:	800075b7          	lui	a1,0x80007
80006318:	80007537          	lui	a0,0x80007
8000631c:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
80006320:	04e00693          	li	a3,78
80006324:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006328:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000632c:	d58fc0ef          	jal	ra,80002884 <printk>
80006330:	80007537          	lui	a0,0x80007
80006334:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80006338:	d4cfc0ef          	jal	ra,80002884 <printk>
8000633c:	04e00593          	li	a1,78
80006340:	68c48513          	addi	a0,s1,1676
80006344:	d7cfc0ef          	jal	ra,800028c0 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80006348:	800089b7          	lui	s3,0x80008
	z_spin_lock_set_owner(l);
8000634c:	d7090513          	addi	a0,s2,-656
80006350:	d74ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
80006354:	800084b7          	lui	s1,0x80008
80006358:	d749a623          	sw	s4,-660(s3) # 80007d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d6d>
	return list->head == list;
8000635c:	80008a37          	lui	s4,0x80008
80006360:	d6c98993          	addi	s3,s3,-660
80006364:	cb4a0a13          	addi	s4,s4,-844 # 80007cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cb5>
80006368:	d3848493          	addi	s1,s1,-712 # 80007d38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d39>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000636c:	80007ab7          	lui	s5,0x80007
80006370:	80007bb7          	lui	s7,0x80007
80006374:	80007b37          	lui	s6,0x80007
80006378:	80007c37          	lui	s8,0x80007
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000637c:	80007cb7          	lui	s9,0x80007
80006380:	000a2d03          	lw	s10,0(s4)
80006384:	0009a783          	lw	a5,0(s3)
80006388:	0004a683          	lw	a3,0(s1)
8000638c:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80006390:	014d0c63          	beq	s10,s4,800063a8 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80006394:	000d0a63          	beqz	s10,800063a8 <z_clock_announce+0xf0>
80006398:	008d2703          	lw	a4,8(s10)
8000639c:	0ae7dc63          	bge	a5,a4,80006454 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
800063a0:	40f70733          	sub	a4,a4,a5
800063a4:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
800063a8:	00d786b3          	add	a3,a5,a3
800063ac:	41f7d713          	srai	a4,a5,0x1f
800063b0:	00a70733          	add	a4,a4,a0
800063b4:	00f6b7b3          	sltu	a5,a3,a5
800063b8:	00e787b3          	add	a5,a5,a4
800063bc:	00d4a023          	sw	a3,0(s1)
800063c0:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
800063c4:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
800063c8:	969ff0ef          	jal	ra,80005d30 <next_timeout>
800063cc:	00000593          	li	a1,0
800063d0:	fc8fc0ef          	jal	ra,80002b98 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800063d4:	d7090513          	addi	a0,s2,-656
800063d8:	cbcff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
800063dc:	02051e63          	bnez	a0,80006418 <z_clock_announce+0x160>
800063e0:	800074b7          	lui	s1,0x80007
800063e4:	800075b7          	lui	a1,0x80007
800063e8:	80007537          	lui	a0,0x80007
800063ec:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
800063f0:	06100693          	li	a3,97
800063f4:	68c48613          	addi	a2,s1,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
800063f8:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800063fc:	c88fc0ef          	jal	ra,80002884 <printk>
80006400:	80007537          	lui	a0,0x80007
80006404:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
80006408:	c7cfc0ef          	jal	ra,80002884 <printk>
8000640c:	06100593          	li	a1,97
80006410:	68c48513          	addi	a0,s1,1676
80006414:	cacfc0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006418:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
8000641c:	02c12083          	lw	ra,44(sp)
80006420:	02812403          	lw	s0,40(sp)
80006424:	02412483          	lw	s1,36(sp)
80006428:	02012903          	lw	s2,32(sp)
8000642c:	01c12983          	lw	s3,28(sp)
80006430:	01812a03          	lw	s4,24(sp)
80006434:	01412a83          	lw	s5,20(sp)
80006438:	01012b03          	lw	s6,16(sp)
8000643c:	00c12b83          	lw	s7,12(sp)
80006440:	00812c03          	lw	s8,8(sp)
80006444:	00412c83          	lw	s9,4(sp)
80006448:	00012d03          	lw	s10,0(sp)
8000644c:	03010113          	addi	sp,sp,48
80006450:	00008067          	ret
		curr_tick += dt;
80006454:	00d706b3          	add	a3,a4,a3
80006458:	41f75593          	srai	a1,a4,0x1f
8000645c:	00a585b3          	add	a1,a1,a0
80006460:	00e6b633          	sltu	a2,a3,a4
80006464:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80006468:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
8000646c:	000d0513          	mv	a0,s10
		t->dticks = 0;
80006470:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80006474:	00d4a023          	sw	a3,0(s1)
80006478:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
8000647c:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80006480:	871ff0ef          	jal	ra,80005cf0 <remove_timeout>
80006484:	d7090513          	addi	a0,s2,-656
80006488:	c0cff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
8000648c:	02051663          	bnez	a0,800064b8 <z_clock_announce+0x200>
80006490:	6d4b8593          	addi	a1,s7,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80006494:	06100693          	li	a3,97
80006498:	68ca8613          	addi	a2,s5,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
8000649c:	5c0b0513          	addi	a0,s6,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800064a0:	be4fc0ef          	jal	ra,80002884 <printk>
800064a4:	6ecc0513          	addi	a0,s8,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800064a8:	bdcfc0ef          	jal	ra,80002884 <printk>
800064ac:	06100593          	li	a1,97
800064b0:	68ca8513          	addi	a0,s5,1676
800064b4:	c0cfc0ef          	jal	ra,800028c0 <assert_post_action>
800064b8:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
800064bc:	00cd2783          	lw	a5,12(s10)
800064c0:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
800064c4:	00800413          	li	s0,8
800064c8:	000780e7          	jalr	a5
800064cc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800064d0:	d7090513          	addi	a0,s2,-656
	key = (mstatus & SOC_MSTATUS_IEN);
800064d4:	00847413          	andi	s0,s0,8
800064d8:	b94ff0ef          	jal	ra,8000586c <z_spin_lock_valid>
800064dc:	02051863          	bnez	a0,8000650c <z_clock_announce+0x254>
800064e0:	6a4c8593          	addi	a1,s9,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
800064e4:	04e00693          	li	a3,78
800064e8:	68ca8613          	addi	a2,s5,1676
800064ec:	5c0b0513          	addi	a0,s6,1472
800064f0:	b94fc0ef          	jal	ra,80002884 <printk>
800064f4:	80007537          	lui	a0,0x80007
800064f8:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
800064fc:	b88fc0ef          	jal	ra,80002884 <printk>
80006500:	04e00593          	li	a1,78
80006504:	68ca8513          	addi	a0,s5,1676
80006508:	bb8fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
8000650c:	d7090513          	addi	a0,s2,-656
80006510:	bb4ff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	return k;
80006514:	e6dff06f          	j	80006380 <z_clock_announce+0xc8>

80006518 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80006518:	fe010113          	addi	sp,sp,-32
8000651c:	00912a23          	sw	s1,20(sp)
80006520:	00112e23          	sw	ra,28(sp)
80006524:	00812c23          	sw	s0,24(sp)
80006528:	01212823          	sw	s2,16(sp)
8000652c:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006530:	00800493          	li	s1,8
80006534:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006538:	80008937          	lui	s2,0x80008
8000653c:	d7090513          	addi	a0,s2,-656 # 80007d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80006540:	0084f493          	andi	s1,s1,8
80006544:	b28ff0ef          	jal	ra,8000586c <z_spin_lock_valid>
80006548:	02051e63          	bnez	a0,80006584 <z_tick_get+0x6c>
8000654c:	80007437          	lui	s0,0x80007
80006550:	800075b7          	lui	a1,0x80007
80006554:	80007537          	lui	a0,0x80007
80006558:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
8000655c:	04e00693          	li	a3,78
80006560:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006564:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006568:	b1cfc0ef          	jal	ra,80002884 <printk>
8000656c:	80007537          	lui	a0,0x80007
80006570:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80006574:	b10fc0ef          	jal	ra,80002884 <printk>
80006578:	04e00593          	li	a1,78
8000657c:	68c40513          	addi	a0,s0,1676
80006580:	b40fc0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80006584:	d7090513          	addi	a0,s2,-656
80006588:	b3cff0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
8000658c:	fb4fc0ef          	jal	ra,80002d40 <z_clock_elapsed>
80006590:	800087b7          	lui	a5,0x80008
80006594:	d3878793          	addi	a5,a5,-712 # 80007d38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d39>
80006598:	0007a983          	lw	s3,0(a5)
8000659c:	0047a403          	lw	s0,4(a5)
800065a0:	013509b3          	add	s3,a0,s3
800065a4:	00a9b533          	sltu	a0,s3,a0
800065a8:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800065ac:	d7090513          	addi	a0,s2,-656
800065b0:	ae4ff0ef          	jal	ra,80005894 <z_spin_unlock_valid>
800065b4:	02051e63          	bnez	a0,800065f0 <z_tick_get+0xd8>
800065b8:	80007937          	lui	s2,0x80007
800065bc:	800075b7          	lui	a1,0x80007
800065c0:	80007537          	lui	a0,0x80007
800065c4:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
800065c8:	06100693          	li	a3,97
800065cc:	68c90613          	addi	a2,s2,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
800065d0:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
800065d4:	ab0fc0ef          	jal	ra,80002884 <printk>
800065d8:	80007537          	lui	a0,0x80007
800065dc:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800065e0:	aa4fc0ef          	jal	ra,80002884 <printk>
800065e4:	06100593          	li	a1,97
800065e8:	68c90513          	addi	a0,s2,1676
800065ec:	ad4fc0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800065f0:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
800065f4:	00040593          	mv	a1,s0
800065f8:	01c12083          	lw	ra,28(sp)
800065fc:	01812403          	lw	s0,24(sp)
80006600:	00098513          	mv	a0,s3
80006604:	01412483          	lw	s1,20(sp)
80006608:	01012903          	lw	s2,16(sp)
8000660c:	00c12983          	lw	s3,12(sp)
80006610:	02010113          	addi	sp,sp,32
80006614:	00008067          	ret

80006618 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80006618:	ff010113          	addi	sp,sp,-16
8000661c:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80006620:	ef9ff0ef          	jal	ra,80006518 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80006624:	00c12083          	lw	ra,12(sp)
80006628:	01010113          	addi	sp,sp,16
8000662c:	00008067          	ret

80006630 <z_impl_k_uptime_get_32>:

u32_t z_impl_k_uptime_get_32(void)
{
80006630:	ff010113          	addi	sp,sp,-16
80006634:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get_32());
80006638:	fe1ff0ef          	jal	ra,80006618 <z_tick_get_32>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000663c:	3e800613          	li	a2,1000
80006640:	00000693          	li	a3,0
80006644:	00000593          	li	a1,0
80006648:	a70fa0ef          	jal	ra,800008b8 <__muldi3>
8000664c:	06400613          	li	a2,100
80006650:	00000693          	li	a3,0
80006654:	c6df90ef          	jal	ra,800002c0 <__udivdi3>
}
80006658:	00c12083          	lw	ra,12(sp)
8000665c:	01010113          	addi	sp,sp,16
80006660:	00008067          	ret

80006664 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80006664:	ff010113          	addi	sp,sp,-16
80006668:	00812423          	sw	s0,8(sp)
8000666c:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80006670:	80008437          	lui	s0,0x80008
80006674:	800084b7          	lui	s1,0x80008
{
80006678:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000667c:	cf440413          	addi	s0,s0,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
80006680:	cf448493          	addi	s1,s1,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
80006684:	00946e63          	bltu	s0,s1,800066a0 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80006688:	00c12083          	lw	ra,12(sp)
8000668c:	00812403          	lw	s0,8(sp)
80006690:	00412483          	lw	s1,4(sp)
80006694:	00000513          	li	a0,0
80006698:	01010113          	addi	sp,sp,16
8000669c:	00008067          	ret
800066a0:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
800066a4:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
800066a8:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
800066ac:	00f42c23          	sw	a5,24(s0)
800066b0:	c44fb0ef          	jal	ra,80001af4 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800066b4:	01c40413          	addi	s0,s0,28
800066b8:	fcdff06f          	j	80006684 <init_static_pools+0x20>

800066bc <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800066bc:	800087b7          	lui	a5,0x80008
800066c0:	0d87a783          	lw	a5,216(a5) # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
{
800066c4:	fb010113          	addi	sp,sp,-80
800066c8:	04812423          	sw	s0,72(sp)
800066cc:	04912223          	sw	s1,68(sp)
800066d0:	03312e23          	sw	s3,60(sp)
800066d4:	03612823          	sw	s6,48(sp)
800066d8:	04112623          	sw	ra,76(sp)
800066dc:	05212023          	sw	s2,64(sp)
800066e0:	03412c23          	sw	s4,56(sp)
800066e4:	03512a23          	sw	s5,52(sp)
800066e8:	03712623          	sw	s7,44(sp)
800066ec:	03812423          	sw	s8,40(sp)
800066f0:	03912223          	sw	s9,36(sp)
800066f4:	03a12023          	sw	s10,32(sp)
800066f8:	01b12e23          	sw	s11,28(sp)
800066fc:	00050993          	mv	s3,a0
80006700:	00058493          	mv	s1,a1
80006704:	00060b13          	mv	s6,a2
80006708:	00068413          	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
8000670c:	16078263          	beqz	a5,80006870 <k_mem_pool_alloc+0x1b4>
80006710:	12069463          	bnez	a3,80006838 <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
80006714:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80006718:	80008537          	lui	a0,0x80008
8000671c:	cf450513          	addi	a0,a0,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
80006720:	40a98533          	sub	a0,s3,a0
80006724:	b6db75b7          	lui	a1,0xb6db7
80006728:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
8000672c:	40255513          	srai	a0,a0,0x2
80006730:	964fa0ef          	jal	ra,80000894 <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80006734:	fffffa37          	lui	s4,0xfffff
		block->id.block = block_num;
80006738:	00001ab7          	lui	s5,0x1
		block->id.pool = pool_id(p);
8000673c:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80006740:	ff500b93          	li	s7,-11
			ret = -ENOMEM;
80006744:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80006748:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
8000674c:	fffa8a93          	addi	s5,s5,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006750:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80006754:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80006758:	00048713          	mv	a4,s1
8000675c:	00c10693          	addi	a3,sp,12
80006760:	00810613          	addi	a2,sp,8
80006764:	000b0593          	mv	a1,s6
80006768:	00098513          	mv	a0,s3
8000676c:	cd0fb0ef          	jal	ra,80001c3c <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80006770:	03751263          	bne	a0,s7,80006794 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80006774:	00048713          	mv	a4,s1
80006778:	00c10693          	addi	a3,sp,12
8000677c:	00810613          	addi	a2,sp,8
80006780:	000b0593          	mv	a1,s6
80006784:	00098513          	mv	a0,s3
80006788:	cb4fb0ef          	jal	ra,80001c3c <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
8000678c:	01751463          	bne	a0,s7,80006794 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
80006790:	ff400513          	li	a0,-12
		block->id.level = level_num;
80006794:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80006798:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
8000679c:	00f7f793          	andi	a5,a5,15
800067a0:	00879713          	slli	a4,a5,0x8
800067a4:	0044a783          	lw	a5,4(s1)
800067a8:	0147f7b3          	and	a5,a5,s4
800067ac:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
800067b0:	00c12703          	lw	a4,12(sp)
800067b4:	0157f7b3          	and	a5,a5,s5
800067b8:	00c71713          	slli	a4,a4,0xc
800067bc:	00e7e7b3          	or	a5,a5,a4
800067c0:	00f4a223          	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
800067c4:	02050c63          	beqz	a0,800067fc <k_mem_pool_alloc+0x140>
800067c8:	02040a63          	beqz	s0,800067fc <k_mem_pool_alloc+0x140>
800067cc:	03951863          	bne	a0,s9,800067fc <k_mem_pool_alloc+0x140>
800067d0:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
800067d4:	00040613          	mv	a2,s0
800067d8:	000d8593          	mv	a1,s11
800067dc:	00857513          	andi	a0,a0,8
800067e0:	cccfe0ef          	jal	ra,80004cac <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
800067e4:	fff00793          	li	a5,-1
800067e8:	f6f408e3          	beq	s0,a5,80006758 <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
800067ec:	d2dff0ef          	jal	ra,80006518 <z_tick_get>
800067f0:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
800067f4:	f60452e3          	bgez	s0,80006758 <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
800067f8:	ff500513          	li	a0,-11
}
800067fc:	04c12083          	lw	ra,76(sp)
80006800:	04812403          	lw	s0,72(sp)
80006804:	04412483          	lw	s1,68(sp)
80006808:	04012903          	lw	s2,64(sp)
8000680c:	03c12983          	lw	s3,60(sp)
80006810:	03812a03          	lw	s4,56(sp)
80006814:	03412a83          	lw	s5,52(sp)
80006818:	03012b03          	lw	s6,48(sp)
8000681c:	02c12b83          	lw	s7,44(sp)
80006820:	02812c03          	lw	s8,40(sp)
80006824:	02412c83          	lw	s9,36(sp)
80006828:	02012d03          	lw	s10,32(sp)
8000682c:	01c12d83          	lw	s11,28(sp)
80006830:	05010113          	addi	sp,sp,80
80006834:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006838:	80008937          	lui	s2,0x80008
8000683c:	800085b7          	lui	a1,0x80008
80006840:	80007537          	lui	a0,0x80007
80006844:	bc858593          	addi	a1,a1,-1080 # 80007bc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bc9>
80006848:	03900693          	li	a3,57
8000684c:	bb490613          	addi	a2,s2,-1100 # 80007bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bb5>
80006850:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006854:	830fc0ef          	jal	ra,80002884 <printk>
80006858:	80007537          	lui	a0,0x80007
8000685c:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
80006860:	824fc0ef          	jal	ra,80002884 <printk>
80006864:	03900593          	li	a1,57
80006868:	bb490513          	addi	a0,s2,-1100
8000686c:	854fc0ef          	jal	ra,800028c0 <assert_post_action>
	if (timeout > 0) {
80006870:	ea8052e3          	blez	s0,80006714 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80006874:	ca5ff0ef          	jal	ra,80006518 <z_tick_get>
80006878:	00050913          	mv	s2,a0
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
8000687c:	00a00593          	li	a1,10
80006880:	00940513          	addi	a0,s0,9
80006884:	8c4fa0ef          	jal	ra,80000948 <__divsi3>
80006888:	01250933          	add	s2,a0,s2
8000688c:	e8dff06f          	j	80006718 <k_mem_pool_alloc+0x5c>

80006890 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006890:	00054783          	lbu	a5,0(a0)
{
80006894:	fe010113          	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006898:	00052603          	lw	a2,0(a0)
{
8000689c:	00812c23          	sw	s0,24(sp)
800068a0:	00379413          	slli	s0,a5,0x3
800068a4:	01212823          	sw	s2,16(sp)
800068a8:	40f40433          	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800068ac:	80008937          	lui	s2,0x80008
800068b0:	00241413          	slli	s0,s0,0x2
800068b4:	00865593          	srli	a1,a2,0x8
800068b8:	cf490513          	addi	a0,s2,-780 # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
800068bc:	00c65613          	srli	a2,a2,0xc
800068c0:	00f5f593          	andi	a1,a1,15
800068c4:	00850533          	add	a0,a0,s0
{
800068c8:	00112e23          	sw	ra,28(sp)
800068cc:	00912a23          	sw	s1,20(sp)
800068d0:	01312623          	sw	s3,12(sp)
800068d4:	01412423          	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800068d8:	e44fb0ef          	jal	ra,80001f1c <z_sys_mem_pool_block_free>
800068dc:	00800593          	li	a1,8
800068e0:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800068e4:	800084b7          	lui	s1,0x80008
800068e8:	d7448513          	addi	a0,s1,-652 # 80007d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d75>
	key = (mstatus & SOC_MSTATUS_IEN);
800068ec:	0085f993          	andi	s3,a1,8
800068f0:	f7dfe0ef          	jal	ra,8000586c <z_spin_lock_valid>
800068f4:	cf490913          	addi	s2,s2,-780
800068f8:	02051e63          	bnez	a0,80006934 <k_mem_pool_free_id+0xa4>
800068fc:	80007a37          	lui	s4,0x80007
80006900:	800075b7          	lui	a1,0x80007
80006904:	80007537          	lui	a0,0x80007
80006908:	6a458593          	addi	a1,a1,1700 # 800076a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a5>
8000690c:	04e00693          	li	a3,78
80006910:	68ca0613          	addi	a2,s4,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006914:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
80006918:	f6dfb0ef          	jal	ra,80002884 <printk>
8000691c:	80007537          	lui	a0,0x80007
80006920:	6bc50513          	addi	a0,a0,1724 # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
80006924:	f61fb0ef          	jal	ra,80002884 <printk>
80006928:	04e00593          	li	a1,78
8000692c:	68ca0513          	addi	a0,s4,1676
80006930:	f91fb0ef          	jal	ra,800028c0 <assert_post_action>
	z_spin_lock_set_owner(l);
80006934:	d7448513          	addi	a0,s1,-652
80006938:	f8dfe0ef          	jal	ra,800058c4 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
8000693c:	01440513          	addi	a0,s0,20
80006940:	00a90533          	add	a0,s2,a0
80006944:	dd8fe0ef          	jal	ra,80004f1c <z_unpend_all>

	if (need_sched != 0) {
80006948:	02050663          	beqz	a0,80006974 <k_mem_pool_free_id+0xe4>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
8000694c:	01812403          	lw	s0,24(sp)
80006950:	01c12083          	lw	ra,28(sp)
80006954:	01012903          	lw	s2,16(sp)
80006958:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
8000695c:	00098593          	mv	a1,s3
80006960:	d7448513          	addi	a0,s1,-652
}
80006964:	00c12983          	lw	s3,12(sp)
80006968:	01412483          	lw	s1,20(sp)
8000696c:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80006970:	da8fd06f          	j	80003f18 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006974:	d7448513          	addi	a0,s1,-652
80006978:	f1dfe0ef          	jal	ra,80005894 <z_spin_unlock_valid>
8000697c:	02051e63          	bnez	a0,800069b8 <k_mem_pool_free_id+0x128>
80006980:	80007437          	lui	s0,0x80007
80006984:	800075b7          	lui	a1,0x80007
80006988:	80007537          	lui	a0,0x80007
8000698c:	6d458593          	addi	a1,a1,1748 # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
80006990:	06100693          	li	a3,97
80006994:	68c40613          	addi	a2,s0,1676 # 8000768c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000768d>
80006998:	5c050513          	addi	a0,a0,1472 # 800075c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c1>
8000699c:	ee9fb0ef          	jal	ra,80002884 <printk>
800069a0:	80007537          	lui	a0,0x80007
800069a4:	6ec50513          	addi	a0,a0,1772 # 800076ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ed>
800069a8:	eddfb0ef          	jal	ra,80002884 <printk>
800069ac:	06100593          	li	a1,97
800069b0:	68c40513          	addi	a0,s0,1676
800069b4:	f0dfb0ef          	jal	ra,800028c0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800069b8:	3009a5f3          	csrrs	a1,mstatus,s3
}
800069bc:	01c12083          	lw	ra,28(sp)
800069c0:	01812403          	lw	s0,24(sp)
800069c4:	01412483          	lw	s1,20(sp)
800069c8:	01012903          	lw	s2,16(sp)
800069cc:	00c12983          	lw	s3,12(sp)
800069d0:	00812a03          	lw	s4,8(sp)
800069d4:	02010113          	addi	sp,sp,32
800069d8:	00008067          	ret

800069dc <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
800069dc:	00458613          	addi	a2,a1,4
800069e0:	00b67e63          	bgeu	a2,a1,800069fc <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
800069e4:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
800069e8:	00008067          	ret
		return NULL;
800069ec:	00000513          	li	a0,0
}
800069f0:	01c12083          	lw	ra,28(sp)
800069f4:	02010113          	addi	sp,sp,32
800069f8:	00008067          	ret
{
800069fc:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006a00:	00000693          	li	a3,0
80006a04:	00810593          	addi	a1,sp,8
{
80006a08:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006a0c:	cb1ff0ef          	jal	ra,800066bc <k_mem_pool_alloc>
80006a10:	fc051ee3          	bnez	a0,800069ec <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80006a14:	00812503          	lw	a0,8(sp)
80006a18:	00400613          	li	a2,4
80006a1c:	00c10593          	addi	a1,sp,12
80006a20:	c38fc0ef          	jal	ra,80002e58 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80006a24:	00812503          	lw	a0,8(sp)
80006a28:	00450513          	addi	a0,a0,4
80006a2c:	fc5ff06f          	j	800069f0 <k_mem_pool_malloc+0x14>

80006a30 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80006a30:	00050663          	beqz	a0,80006a3c <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80006a34:	ffc50513          	addi	a0,a0,-4
80006a38:	e59ff06f          	j	80006890 <k_mem_pool_free_id>
	}
}
80006a3c:	00008067          	ret

80006a40 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80006a40:	800087b7          	lui	a5,0x80008
80006a44:	0e07a783          	lw	a5,224(a5) # 800080e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080e1>
{
80006a48:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
80006a4c:	0687a503          	lw	a0,104(a5)
80006a50:	00050463          	beqz	a0,80006a58 <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80006a54:	f89ff06f          	j	800069dc <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
80006a58:	00000513          	li	a0,0
80006a5c:	00008067          	ret

80006a60 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80006a60:	00008067          	ret
