
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	1890006f          	j	80000994 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1be000ef          	jal	ra,80000204 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e121                	bnez	a0,8000008e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	12e08093          	addi	ra,ra,302 # 80000198 <no_reschedule>
	tail _Fault
80000072:	3880106f          	j	800013fa <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
8000007c:	00006297          	auipc	t0,0x6
80000080:	48c28293          	addi	t0,t0,1164 # 80006508 <_offload_routine>
	lw t1, 0x00(t0)
80000084:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
80000088:	00031363          	bnez	t1,8000008e <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000008c:	a041                	j	8000010c <reschedule>

8000008e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000008e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000092:	00007397          	auipc	t2,0x7
80000096:	80e38393          	addi	t2,t2,-2034 # 800068a0 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000009a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000009e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000a0:	c016                	sw	t0,0(sp)

800000a2 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000a2:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000a6:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000a8:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000ac:	00030863          	beqz	t1,800000bc <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000b0:	00000097          	auipc	ra,0x0
800000b4:	03808093          	addi	ra,ra,56 # 800000e8 <on_thread_stack>
	tail z_irq_do_offload
800000b8:	3a80106f          	j	80001460 <z_irq_do_offload>

800000bc <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000bc:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000c0:	800002b7          	lui	t0,0x80000
800000c4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000c8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000cc:	128000ef          	jal	ra,800001f4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000d0:	00005297          	auipc	t0,0x5
800000d4:	15c28293          	addi	t0,t0,348 # 8000522c <_sw_isr_table>
	slli a0, a0, 3
800000d8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000da:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000dc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000e0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000e4:	000300e7          	jalr	t1

800000e8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000e8:	00006317          	auipc	t1,0x6
800000ec:	7b830313          	addi	t1,t1,1976 # 800068a0 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000f0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000f4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000f6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000fa:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000fc:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000100:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000104:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000108:	087e0863          	beq	t3,t2,80000198 <no_reschedule>

8000010c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000010c:	00006297          	auipc	t0,0x6
80000110:	79428293          	addi	t0,t0,1940 # 800068a0 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000114:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000118:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000011c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000120:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000124:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000128:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000012c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000130:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000134:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000138:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000013c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000140:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000144:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000148:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000014c:	00006397          	auipc	t2,0x6
80000150:	33838393          	addi	t2,t2,824 # 80006484 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000154:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000158:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000015c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000160:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000164:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000168:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000016c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000170:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000174:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000178:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000017c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000180:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000184:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000188:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000018c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000190:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000194:	05832d83          	lw	s11,88(t1)

80000198 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000198:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000019a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000019e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001a0:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001a4:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001a6:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001a8:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001aa:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001ac:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ae:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001b0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001b2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001b4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001b6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001b8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001ba:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001bc:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001be:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001c0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001c2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001c4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001c6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001c8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ca:	30200073          	mret
	...

800001d0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001d0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001d4:	00006297          	auipc	t0,0x6
800001d8:	6cc28293          	addi	t0,t0,1740 # 800068a0 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001dc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001e0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001e4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001e6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001ea:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001f4:	4305                	li	t1,1
	sll t0, t1, a0
800001f6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001fa:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001fe:	00008067          	ret
	...

80000204 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
80000204:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000208:	80000337          	lui	t1,0x80000
	and t0, t0, t1
8000020c:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000210:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000214:	00028363          	beqz	t0,8000021a <not_interrupt>
	addi a0, a0, 1
80000218:	0505                	addi	a0,a0,1

8000021a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000021a:	00008067          	ret

Disassembly of section text:

80000220 <__lshrdi3>:
80000220:	02060063          	beqz	a2,80000240 <__lshrdi3+0x20>
80000224:	02000793          	li	a5,32
80000228:	40c787b3          	sub	a5,a5,a2
8000022c:	00f04c63          	bgtz	a5,80000244 <__lshrdi3+0x24>
80000230:	fe060513          	addi	a0,a2,-32
80000234:	00000713          	li	a4,0
80000238:	00a5d533          	srl	a0,a1,a0
8000023c:	00070593          	mv	a1,a4
80000240:	00008067          	ret
80000244:	00c5d733          	srl	a4,a1,a2
80000248:	00c55533          	srl	a0,a0,a2
8000024c:	00f595b3          	sll	a1,a1,a5
80000250:	00b56533          	or	a0,a0,a1
80000254:	fe9ff06f          	j	8000023c <__lshrdi3+0x1c>

80000258 <__udivdi3>:
80000258:	fd010113          	addi	sp,sp,-48
8000025c:	02912223          	sw	s1,36(sp)
80000260:	01612823          	sw	s6,16(sp)
80000264:	02112623          	sw	ra,44(sp)
80000268:	02812423          	sw	s0,40(sp)
8000026c:	03212023          	sw	s2,32(sp)
80000270:	01312e23          	sw	s3,28(sp)
80000274:	01412c23          	sw	s4,24(sp)
80000278:	01512a23          	sw	s5,20(sp)
8000027c:	01712623          	sw	s7,12(sp)
80000280:	01812423          	sw	s8,8(sp)
80000284:	01912223          	sw	s9,4(sp)
80000288:	00050b13          	mv	s6,a0
8000028c:	00058493          	mv	s1,a1
80000290:	38069c63          	bnez	a3,80000628 <__udivdi3+0x3d0>
80000294:	00060413          	mv	s0,a2
80000298:	00050993          	mv	s3,a0
8000029c:	00005917          	auipc	s2,0x5
800002a0:	11090913          	addi	s2,s2,272 # 800053ac <__devconfig_end>
800002a4:	12c5f863          	bgeu	a1,a2,800003d4 <__udivdi3+0x17c>
800002a8:	000107b7          	lui	a5,0x10
800002ac:	00058a93          	mv	s5,a1
800002b0:	10f67863          	bgeu	a2,a5,800003c0 <__udivdi3+0x168>
800002b4:	0ff00693          	li	a3,255
800002b8:	00c6b6b3          	sltu	a3,a3,a2
800002bc:	00369693          	slli	a3,a3,0x3
800002c0:	00d657b3          	srl	a5,a2,a3
800002c4:	00f90933          	add	s2,s2,a5
800002c8:	00094703          	lbu	a4,0(s2)
800002cc:	00d706b3          	add	a3,a4,a3
800002d0:	02000713          	li	a4,32
800002d4:	40d70733          	sub	a4,a4,a3
800002d8:	00070c63          	beqz	a4,800002f0 <__udivdi3+0x98>
800002dc:	00e494b3          	sll	s1,s1,a4
800002e0:	00db56b3          	srl	a3,s6,a3
800002e4:	00e61433          	sll	s0,a2,a4
800002e8:	0096eab3          	or	s5,a3,s1
800002ec:	00eb19b3          	sll	s3,s6,a4
800002f0:	01045b13          	srli	s6,s0,0x10
800002f4:	000b0593          	mv	a1,s6
800002f8:	000a8513          	mv	a0,s5
800002fc:	634000ef          	jal	ra,80000930 <__umodsi3>
80000300:	00050913          	mv	s2,a0
80000304:	000b0593          	mv	a1,s6
80000308:	01041b93          	slli	s7,s0,0x10
8000030c:	000a8513          	mv	a0,s5
80000310:	5d8000ef          	jal	ra,800008e8 <__udivsi3>
80000314:	010bdb93          	srli	s7,s7,0x10
80000318:	00050493          	mv	s1,a0
8000031c:	00050593          	mv	a1,a0
80000320:	000b8513          	mv	a0,s7
80000324:	508000ef          	jal	ra,8000082c <__mulsi3>
80000328:	01091913          	slli	s2,s2,0x10
8000032c:	0109d713          	srli	a4,s3,0x10
80000330:	00e96733          	or	a4,s2,a4
80000334:	00048a13          	mv	s4,s1
80000338:	00a77e63          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000033c:	00870733          	add	a4,a4,s0
80000340:	fff48a13          	addi	s4,s1,-1
80000344:	00876863          	bltu	a4,s0,80000354 <__udivdi3+0xfc>
80000348:	00a77663          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000034c:	ffe48a13          	addi	s4,s1,-2
80000350:	00870733          	add	a4,a4,s0
80000354:	40a704b3          	sub	s1,a4,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	5d0000ef          	jal	ra,80000930 <__umodsi3>
80000364:	00050913          	mv	s2,a0
80000368:	000b0593          	mv	a1,s6
8000036c:	00048513          	mv	a0,s1
80000370:	578000ef          	jal	ra,800008e8 <__udivsi3>
80000374:	01099993          	slli	s3,s3,0x10
80000378:	00050493          	mv	s1,a0
8000037c:	00050593          	mv	a1,a0
80000380:	01091913          	slli	s2,s2,0x10
80000384:	000b8513          	mv	a0,s7
80000388:	0109d993          	srli	s3,s3,0x10
8000038c:	4a0000ef          	jal	ra,8000082c <__mulsi3>
80000390:	013969b3          	or	s3,s2,s3
80000394:	00048613          	mv	a2,s1
80000398:	00a9fc63          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
8000039c:	013409b3          	add	s3,s0,s3
800003a0:	fff48613          	addi	a2,s1,-1
800003a4:	0089e663          	bltu	s3,s0,800003b0 <__udivdi3+0x158>
800003a8:	00a9f463          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
800003ac:	ffe48613          	addi	a2,s1,-2
800003b0:	010a1793          	slli	a5,s4,0x10
800003b4:	00c7e7b3          	or	a5,a5,a2
800003b8:	00000a13          	li	s4,0
800003bc:	1300006f          	j	800004ec <__udivdi3+0x294>
800003c0:	010007b7          	lui	a5,0x1000
800003c4:	01000693          	li	a3,16
800003c8:	eef66ce3          	bltu	a2,a5,800002c0 <__udivdi3+0x68>
800003cc:	01800693          	li	a3,24
800003d0:	ef1ff06f          	j	800002c0 <__udivdi3+0x68>
800003d4:	00068a13          	mv	s4,a3
800003d8:	00061a63          	bnez	a2,800003ec <__udivdi3+0x194>
800003dc:	00000593          	li	a1,0
800003e0:	00100513          	li	a0,1
800003e4:	504000ef          	jal	ra,800008e8 <__udivsi3>
800003e8:	00050413          	mv	s0,a0
800003ec:	000107b7          	lui	a5,0x10
800003f0:	12f47c63          	bgeu	s0,a5,80000528 <__udivdi3+0x2d0>
800003f4:	0ff00793          	li	a5,255
800003f8:	0087f463          	bgeu	a5,s0,80000400 <__udivdi3+0x1a8>
800003fc:	00800a13          	li	s4,8
80000400:	014457b3          	srl	a5,s0,s4
80000404:	00f90933          	add	s2,s2,a5
80000408:	00094683          	lbu	a3,0(s2)
8000040c:	02000613          	li	a2,32
80000410:	014686b3          	add	a3,a3,s4
80000414:	40d60633          	sub	a2,a2,a3
80000418:	12061263          	bnez	a2,8000053c <__udivdi3+0x2e4>
8000041c:	408484b3          	sub	s1,s1,s0
80000420:	00100a13          	li	s4,1
80000424:	01045b13          	srli	s6,s0,0x10
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	500000ef          	jal	ra,80000930 <__umodsi3>
80000434:	00050913          	mv	s2,a0
80000438:	000b0593          	mv	a1,s6
8000043c:	00048513          	mv	a0,s1
80000440:	01041b93          	slli	s7,s0,0x10
80000444:	4a4000ef          	jal	ra,800008e8 <__udivsi3>
80000448:	010bdb93          	srli	s7,s7,0x10
8000044c:	00050493          	mv	s1,a0
80000450:	00050593          	mv	a1,a0
80000454:	000b8513          	mv	a0,s7
80000458:	3d4000ef          	jal	ra,8000082c <__mulsi3>
8000045c:	01091913          	slli	s2,s2,0x10
80000460:	0109d713          	srli	a4,s3,0x10
80000464:	00e96733          	or	a4,s2,a4
80000468:	00048a93          	mv	s5,s1
8000046c:	00a77e63          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000470:	00870733          	add	a4,a4,s0
80000474:	fff48a93          	addi	s5,s1,-1
80000478:	00876863          	bltu	a4,s0,80000488 <__udivdi3+0x230>
8000047c:	00a77663          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000480:	ffe48a93          	addi	s5,s1,-2
80000484:	00870733          	add	a4,a4,s0
80000488:	40a704b3          	sub	s1,a4,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	49c000ef          	jal	ra,80000930 <__umodsi3>
80000498:	00050913          	mv	s2,a0
8000049c:	000b0593          	mv	a1,s6
800004a0:	00048513          	mv	a0,s1
800004a4:	444000ef          	jal	ra,800008e8 <__udivsi3>
800004a8:	01099993          	slli	s3,s3,0x10
800004ac:	00050493          	mv	s1,a0
800004b0:	00050593          	mv	a1,a0
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	000b8513          	mv	a0,s7
800004bc:	0109d993          	srli	s3,s3,0x10
800004c0:	36c000ef          	jal	ra,8000082c <__mulsi3>
800004c4:	013969b3          	or	s3,s2,s3
800004c8:	00048613          	mv	a2,s1
800004cc:	00a9fc63          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004d0:	013409b3          	add	s3,s0,s3
800004d4:	fff48613          	addi	a2,s1,-1
800004d8:	0089e663          	bltu	s3,s0,800004e4 <__udivdi3+0x28c>
800004dc:	00a9f463          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004e0:	ffe48613          	addi	a2,s1,-2
800004e4:	010a9793          	slli	a5,s5,0x10
800004e8:	00c7e7b3          	or	a5,a5,a2
800004ec:	00078513          	mv	a0,a5
800004f0:	000a0593          	mv	a1,s4
800004f4:	02c12083          	lw	ra,44(sp)
800004f8:	02812403          	lw	s0,40(sp)
800004fc:	02412483          	lw	s1,36(sp)
80000500:	02012903          	lw	s2,32(sp)
80000504:	01c12983          	lw	s3,28(sp)
80000508:	01812a03          	lw	s4,24(sp)
8000050c:	01412a83          	lw	s5,20(sp)
80000510:	01012b03          	lw	s6,16(sp)
80000514:	00c12b83          	lw	s7,12(sp)
80000518:	00812c03          	lw	s8,8(sp)
8000051c:	00412c83          	lw	s9,4(sp)
80000520:	03010113          	addi	sp,sp,48
80000524:	00008067          	ret
80000528:	010007b7          	lui	a5,0x1000
8000052c:	01000a13          	li	s4,16
80000530:	ecf468e3          	bltu	s0,a5,80000400 <__udivdi3+0x1a8>
80000534:	01800a13          	li	s4,24
80000538:	ec9ff06f          	j	80000400 <__udivdi3+0x1a8>
8000053c:	00c41433          	sll	s0,s0,a2
80000540:	00d4da33          	srl	s4,s1,a3
80000544:	00cb19b3          	sll	s3,s6,a2
80000548:	00db56b3          	srl	a3,s6,a3
8000054c:	01045b13          	srli	s6,s0,0x10
80000550:	00c494b3          	sll	s1,s1,a2
80000554:	000b0593          	mv	a1,s6
80000558:	000a0513          	mv	a0,s4
8000055c:	0096eab3          	or	s5,a3,s1
80000560:	3d0000ef          	jal	ra,80000930 <__umodsi3>
80000564:	00050913          	mv	s2,a0
80000568:	000b0593          	mv	a1,s6
8000056c:	000a0513          	mv	a0,s4
80000570:	01041b93          	slli	s7,s0,0x10
80000574:	374000ef          	jal	ra,800008e8 <__udivsi3>
80000578:	010bdb93          	srli	s7,s7,0x10
8000057c:	00050493          	mv	s1,a0
80000580:	00050593          	mv	a1,a0
80000584:	000b8513          	mv	a0,s7
80000588:	2a4000ef          	jal	ra,8000082c <__mulsi3>
8000058c:	01091913          	slli	s2,s2,0x10
80000590:	010ad713          	srli	a4,s5,0x10
80000594:	00e96733          	or	a4,s2,a4
80000598:	00048a13          	mv	s4,s1
8000059c:	00a77e63          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005a0:	00870733          	add	a4,a4,s0
800005a4:	fff48a13          	addi	s4,s1,-1
800005a8:	00876863          	bltu	a4,s0,800005b8 <__udivdi3+0x360>
800005ac:	00a77663          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005b0:	ffe48a13          	addi	s4,s1,-2
800005b4:	00870733          	add	a4,a4,s0
800005b8:	40a704b3          	sub	s1,a4,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	36c000ef          	jal	ra,80000930 <__umodsi3>
800005c8:	00050913          	mv	s2,a0
800005cc:	000b0593          	mv	a1,s6
800005d0:	00048513          	mv	a0,s1
800005d4:	314000ef          	jal	ra,800008e8 <__udivsi3>
800005d8:	00050493          	mv	s1,a0
800005dc:	00050593          	mv	a1,a0
800005e0:	000b8513          	mv	a0,s7
800005e4:	248000ef          	jal	ra,8000082c <__mulsi3>
800005e8:	010a9693          	slli	a3,s5,0x10
800005ec:	01091913          	slli	s2,s2,0x10
800005f0:	0106d693          	srli	a3,a3,0x10
800005f4:	00d967b3          	or	a5,s2,a3
800005f8:	00048713          	mv	a4,s1
800005fc:	00a7fe63          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000600:	008787b3          	add	a5,a5,s0
80000604:	fff48713          	addi	a4,s1,-1
80000608:	0087e863          	bltu	a5,s0,80000618 <__udivdi3+0x3c0>
8000060c:	00a7f663          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000610:	ffe48713          	addi	a4,s1,-2
80000614:	008787b3          	add	a5,a5,s0
80000618:	010a1a13          	slli	s4,s4,0x10
8000061c:	40a784b3          	sub	s1,a5,a0
80000620:	00ea6a33          	or	s4,s4,a4
80000624:	e01ff06f          	j	80000424 <__udivdi3+0x1cc>
80000628:	1ed5ec63          	bltu	a1,a3,80000820 <__udivdi3+0x5c8>
8000062c:	000107b7          	lui	a5,0x10
80000630:	04f6f463          	bgeu	a3,a5,80000678 <__udivdi3+0x420>
80000634:	0ff00593          	li	a1,255
80000638:	00d5b533          	sltu	a0,a1,a3
8000063c:	00351513          	slli	a0,a0,0x3
80000640:	00a6d733          	srl	a4,a3,a0
80000644:	00005797          	auipc	a5,0x5
80000648:	d6878793          	addi	a5,a5,-664 # 800053ac <__devconfig_end>
8000064c:	00e787b3          	add	a5,a5,a4
80000650:	0007c583          	lbu	a1,0(a5)
80000654:	02000a13          	li	s4,32
80000658:	00a585b3          	add	a1,a1,a0
8000065c:	40ba0a33          	sub	s4,s4,a1
80000660:	020a1663          	bnez	s4,8000068c <__udivdi3+0x434>
80000664:	00100793          	li	a5,1
80000668:	e896e2e3          	bltu	a3,s1,800004ec <__udivdi3+0x294>
8000066c:	00cb3633          	sltu	a2,s6,a2
80000670:	00164793          	xori	a5,a2,1
80000674:	e79ff06f          	j	800004ec <__udivdi3+0x294>
80000678:	010007b7          	lui	a5,0x1000
8000067c:	01000513          	li	a0,16
80000680:	fcf6e0e3          	bltu	a3,a5,80000640 <__udivdi3+0x3e8>
80000684:	01800513          	li	a0,24
80000688:	fb9ff06f          	j	80000640 <__udivdi3+0x3e8>
8000068c:	00b65ab3          	srl	s5,a2,a1
80000690:	014696b3          	sll	a3,a3,s4
80000694:	00daeab3          	or	s5,s5,a3
80000698:	00b4d933          	srl	s2,s1,a1
8000069c:	014497b3          	sll	a5,s1,s4
800006a0:	00bb55b3          	srl	a1,s6,a1
800006a4:	010adb93          	srli	s7,s5,0x10
800006a8:	00f5e4b3          	or	s1,a1,a5
800006ac:	00090513          	mv	a0,s2
800006b0:	000b8593          	mv	a1,s7
800006b4:	014619b3          	sll	s3,a2,s4
800006b8:	278000ef          	jal	ra,80000930 <__umodsi3>
800006bc:	00050413          	mv	s0,a0
800006c0:	000b8593          	mv	a1,s7
800006c4:	00090513          	mv	a0,s2
800006c8:	010a9c13          	slli	s8,s5,0x10
800006cc:	21c000ef          	jal	ra,800008e8 <__udivsi3>
800006d0:	010c5c13          	srli	s8,s8,0x10
800006d4:	00050913          	mv	s2,a0
800006d8:	00050593          	mv	a1,a0
800006dc:	000c0513          	mv	a0,s8
800006e0:	14c000ef          	jal	ra,8000082c <__mulsi3>
800006e4:	01041413          	slli	s0,s0,0x10
800006e8:	0104d713          	srli	a4,s1,0x10
800006ec:	00e46733          	or	a4,s0,a4
800006f0:	00090c93          	mv	s9,s2
800006f4:	00a77e63          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
800006f8:	01570733          	add	a4,a4,s5
800006fc:	fff90c93          	addi	s9,s2,-1
80000700:	01576863          	bltu	a4,s5,80000710 <__udivdi3+0x4b8>
80000704:	00a77663          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
80000708:	ffe90c93          	addi	s9,s2,-2
8000070c:	01570733          	add	a4,a4,s5
80000710:	40a70933          	sub	s2,a4,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	214000ef          	jal	ra,80000930 <__umodsi3>
80000720:	00050413          	mv	s0,a0
80000724:	000b8593          	mv	a1,s7
80000728:	00090513          	mv	a0,s2
8000072c:	1bc000ef          	jal	ra,800008e8 <__udivsi3>
80000730:	00050913          	mv	s2,a0
80000734:	00050593          	mv	a1,a0
80000738:	000c0513          	mv	a0,s8
8000073c:	0f0000ef          	jal	ra,8000082c <__mulsi3>
80000740:	01049793          	slli	a5,s1,0x10
80000744:	01041413          	slli	s0,s0,0x10
80000748:	0107d793          	srli	a5,a5,0x10
8000074c:	00f46733          	or	a4,s0,a5
80000750:	00090613          	mv	a2,s2
80000754:	00a77e63          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000758:	01570733          	add	a4,a4,s5
8000075c:	fff90613          	addi	a2,s2,-1
80000760:	01576863          	bltu	a4,s5,80000770 <__udivdi3+0x518>
80000764:	00a77663          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000768:	ffe90613          	addi	a2,s2,-2
8000076c:	01570733          	add	a4,a4,s5
80000770:	010c9793          	slli	a5,s9,0x10
80000774:	00010e37          	lui	t3,0x10
80000778:	00c7e7b3          	or	a5,a5,a2
8000077c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000780:	0107f333          	and	t1,a5,a6
80000784:	0109f833          	and	a6,s3,a6
80000788:	40a70733          	sub	a4,a4,a0
8000078c:	0107de93          	srli	t4,a5,0x10
80000790:	0109d993          	srli	s3,s3,0x10
80000794:	00030513          	mv	a0,t1
80000798:	00080593          	mv	a1,a6
8000079c:	090000ef          	jal	ra,8000082c <__mulsi3>
800007a0:	00050893          	mv	a7,a0
800007a4:	00098593          	mv	a1,s3
800007a8:	00030513          	mv	a0,t1
800007ac:	080000ef          	jal	ra,8000082c <__mulsi3>
800007b0:	00050313          	mv	t1,a0
800007b4:	00080593          	mv	a1,a6
800007b8:	000e8513          	mv	a0,t4
800007bc:	070000ef          	jal	ra,8000082c <__mulsi3>
800007c0:	00050813          	mv	a6,a0
800007c4:	00098593          	mv	a1,s3
800007c8:	000e8513          	mv	a0,t4
800007cc:	060000ef          	jal	ra,8000082c <__mulsi3>
800007d0:	0108d693          	srli	a3,a7,0x10
800007d4:	01030333          	add	t1,t1,a6
800007d8:	006686b3          	add	a3,a3,t1
800007dc:	0106f463          	bgeu	a3,a6,800007e4 <__udivdi3+0x58c>
800007e0:	01c50533          	add	a0,a0,t3
800007e4:	0106d613          	srli	a2,a3,0x10
800007e8:	00a60533          	add	a0,a2,a0
800007ec:	02a76663          	bltu	a4,a0,80000818 <__udivdi3+0x5c0>
800007f0:	bca714e3          	bne	a4,a0,800003b8 <__udivdi3+0x160>
800007f4:	00010737          	lui	a4,0x10
800007f8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007fc:	00e6f6b3          	and	a3,a3,a4
80000800:	01069693          	slli	a3,a3,0x10
80000804:	00e8f8b3          	and	a7,a7,a4
80000808:	014b1633          	sll	a2,s6,s4
8000080c:	011686b3          	add	a3,a3,a7
80000810:	00000a13          	li	s4,0
80000814:	ccd67ce3          	bgeu	a2,a3,800004ec <__udivdi3+0x294>
80000818:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000081c:	b9dff06f          	j	800003b8 <__udivdi3+0x160>
80000820:	00000a13          	li	s4,0
80000824:	00000793          	li	a5,0
80000828:	cc5ff06f          	j	800004ec <__udivdi3+0x294>

8000082c <__mulsi3>:
8000082c:	00050613          	mv	a2,a0
80000830:	00000513          	li	a0,0
80000834:	0015f693          	andi	a3,a1,1
80000838:	00068463          	beqz	a3,80000840 <__mulsi3+0x14>
8000083c:	00c50533          	add	a0,a0,a2
80000840:	0015d593          	srli	a1,a1,0x1
80000844:	00161613          	slli	a2,a2,0x1
80000848:	fe0596e3          	bnez	a1,80000834 <__mulsi3+0x8>
8000084c:	00008067          	ret

80000850 <__muldi3>:
80000850:	ff010113          	addi	sp,sp,-16
80000854:	00068313          	mv	t1,a3
80000858:	00112623          	sw	ra,12(sp)
8000085c:	00050e13          	mv	t3,a0
80000860:	00050893          	mv	a7,a0
80000864:	00060693          	mv	a3,a2
80000868:	00000713          	li	a4,0
8000086c:	00000793          	li	a5,0
80000870:	00000813          	li	a6,0
80000874:	0016f513          	andi	a0,a3,1
80000878:	00171e93          	slli	t4,a4,0x1
8000087c:	00050c63          	beqz	a0,80000894 <__muldi3+0x44>
80000880:	01088533          	add	a0,a7,a6
80000884:	01053833          	sltu	a6,a0,a6
80000888:	00e787b3          	add	a5,a5,a4
8000088c:	00f807b3          	add	a5,a6,a5
80000890:	00050813          	mv	a6,a0
80000894:	01f8d713          	srli	a4,a7,0x1f
80000898:	0016d693          	srli	a3,a3,0x1
8000089c:	00eee733          	or	a4,t4,a4
800008a0:	00189893          	slli	a7,a7,0x1
800008a4:	fc0698e3          	bnez	a3,80000874 <__muldi3+0x24>
800008a8:	00058863          	beqz	a1,800008b8 <__muldi3+0x68>
800008ac:	00060513          	mv	a0,a2
800008b0:	f7dff0ef          	jal	ra,8000082c <__mulsi3>
800008b4:	00a787b3          	add	a5,a5,a0
800008b8:	00030a63          	beqz	t1,800008cc <__muldi3+0x7c>
800008bc:	000e0513          	mv	a0,t3
800008c0:	00030593          	mv	a1,t1
800008c4:	f69ff0ef          	jal	ra,8000082c <__mulsi3>
800008c8:	00f507b3          	add	a5,a0,a5
800008cc:	00c12083          	lw	ra,12(sp)
800008d0:	00080513          	mv	a0,a6
800008d4:	00078593          	mv	a1,a5
800008d8:	01010113          	addi	sp,sp,16
800008dc:	00008067          	ret

800008e0 <__divsi3>:
800008e0:	06054063          	bltz	a0,80000940 <__umodsi3+0x10>
800008e4:	0605c663          	bltz	a1,80000950 <__umodsi3+0x20>

800008e8 <__udivsi3>:
800008e8:	00058613          	mv	a2,a1
800008ec:	00050593          	mv	a1,a0
800008f0:	fff00513          	li	a0,-1
800008f4:	02060c63          	beqz	a2,8000092c <__udivsi3+0x44>
800008f8:	00100693          	li	a3,1
800008fc:	00b67a63          	bgeu	a2,a1,80000910 <__udivsi3+0x28>
80000900:	00c05863          	blez	a2,80000910 <__udivsi3+0x28>
80000904:	00161613          	slli	a2,a2,0x1
80000908:	00169693          	slli	a3,a3,0x1
8000090c:	feb66ae3          	bltu	a2,a1,80000900 <__udivsi3+0x18>
80000910:	00000513          	li	a0,0
80000914:	00c5e663          	bltu	a1,a2,80000920 <__udivsi3+0x38>
80000918:	40c585b3          	sub	a1,a1,a2
8000091c:	00d56533          	or	a0,a0,a3
80000920:	0016d693          	srli	a3,a3,0x1
80000924:	00165613          	srli	a2,a2,0x1
80000928:	fe0696e3          	bnez	a3,80000914 <__udivsi3+0x2c>
8000092c:	00008067          	ret

80000930 <__umodsi3>:
80000930:	00008293          	mv	t0,ra
80000934:	fb5ff0ef          	jal	ra,800008e8 <__udivsi3>
80000938:	00058513          	mv	a0,a1
8000093c:	00028067          	jr	t0
80000940:	40a00533          	neg	a0,a0
80000944:	0005d863          	bgez	a1,80000954 <__umodsi3+0x24>
80000948:	40b005b3          	neg	a1,a1
8000094c:	f9dff06f          	j	800008e8 <__udivsi3>
80000950:	40b005b3          	neg	a1,a1
80000954:	00008293          	mv	t0,ra
80000958:	f91ff0ef          	jal	ra,800008e8 <__udivsi3>
8000095c:	40a00533          	neg	a0,a0
80000960:	00028067          	jr	t0

80000964 <__modsi3>:
80000964:	00008293          	mv	t0,ra
80000968:	0005ca63          	bltz	a1,8000097c <__modsi3+0x18>
8000096c:	00054c63          	bltz	a0,80000984 <__modsi3+0x20>
80000970:	f79ff0ef          	jal	ra,800008e8 <__udivsi3>
80000974:	00058513          	mv	a0,a1
80000978:	00028067          	jr	t0
8000097c:	40b005b3          	neg	a1,a1
80000980:	fe0558e3          	bgez	a0,80000970 <__modsi3+0xc>
80000984:	40a00533          	neg	a0,a0
80000988:	f61ff0ef          	jal	ra,800008e8 <__udivsi3>
8000098c:	40b00533          	neg	a0,a1
80000990:	00028067          	jr	t0

80000994 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000994:	00007117          	auipc	sp,0x7
80000998:	d3c10113          	addi	sp,sp,-708 # 800076d0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
8000099c:	000012b7          	lui	t0,0x1
800009a0:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
800009a4:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
800009a6:	2fd000ef          	jal	ra,800014a2 <_PrepC>
	...

800009ac <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
800009ac:	1420106f          	j	80001aee <z_thread_entry>
	...

800009b2 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009b2:	8082                	ret

800009b4 <test_main>:
			 ztest_unit_test(test_fifo_get_fail),
			 ztest_unit_test(test_fifo_loop),
			 ztest_unit_test(test_fifo_cancel_wait),
			 ztest_unit_test(test_fifo_is_empty_thread),
			 ztest_unit_test(test_fifo_is_empty_isr));
	ztest_run_test_suite(fifo_api);
800009b4:	800065b7          	lui	a1,0x80006
800009b8:	80005537          	lui	a0,0x80005
800009bc:	3bc58593          	addi	a1,a1,956 # 800063bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063bd>
800009c0:	56450513          	addi	a0,a0,1380 # 80005564 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005565>
800009c4:	3350106f          	j	800024f8 <z_ztest_run_test_suite>

800009c8 <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
800009c8:	7179                	addi	sp,sp,-48
800009ca:	ce06                	sw	ra,28(sp)
800009cc:	cc22                	sw	s0,24(sp)
800009ce:	d442                	sw	a6,40(sp)
800009d0:	d646                	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
800009d2:	e121                	bnez	a0,80000a12 <z_zassert.constprop.0+0x4a>
800009d4:	8636                	mv	a2,a3
800009d6:	872e                	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009d8:	800056b7          	lui	a3,0x80005
800009dc:	800055b7          	lui	a1,0x80005
800009e0:	80005537          	lui	a0,0x80005
800009e4:	57068693          	addi	a3,a3,1392 # 80005570 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005571>
800009e8:	843e                	mv	s0,a5
800009ea:	61458593          	addi	a1,a1,1556 # 80005614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005615>
		va_start(vargs, msg);
800009ee:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009f0:	64850513          	addi	a0,a0,1608 # 80005648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005649>
		va_start(vargs, msg);
800009f4:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009f6:	544010ef          	jal	ra,80001f3a <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
800009fa:	45b2                	lw	a1,12(sp)
800009fc:	8522                	mv	a0,s0
800009fe:	520010ef          	jal	ra,80001f1e <vprintk>
		printk("\n");
80000a02:	80006537          	lui	a0,0x80006
80000a06:	afc50513          	addi	a0,a0,-1284 # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
80000a0a:	530010ef          	jal	ra,80001f3a <printk>
		va_end(vargs);
		ztest_test_fail();
80000a0e:	2c5010ef          	jal	ra,800024d2 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000a12:	40f2                	lw	ra,28(sp)
80000a14:	4462                	lw	s0,24(sp)
80000a16:	6145                	addi	sp,sp,48
80000a18:	8082                	ret

80000a1a <tfifo_thread_thread>:
	k_sleep(50);
	k_fifo_cancel_wait((struct k_fifo *)p1);
}

static void tfifo_thread_thread(struct k_fifo *pfifo)
{
80000a1a:	7179                	addi	sp,sp,-48
80000a1c:	d226                	sw	s1,36(sp)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_OBJECT_RELEASE, k_object_release, void *, object)

K_SYSCALL_DECLARE1(K_SYSCALL_K_OBJECT_ALLOC, k_object_alloc, void *, enum k_objects, otype)

K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000a1e:	872a                	mv	a4,a0
80000a20:	84aa                	mv	s1,a0
80000a22:	800016b7          	lui	a3,0x80001
80000a26:	800075b7          	lui	a1,0x80007
80000a2a:	80006537          	lui	a0,0x80006
80000a2e:	4881                	li	a7,0
80000a30:	4801                	li	a6,0
80000a32:	4781                	li	a5,0
80000a34:	ace68693          	addi	a3,a3,-1330 # 80000ace <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000acf>
80000a38:	20000613          	li	a2,512
80000a3c:	8d058593          	addi	a1,a1,-1840 # 800068d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d1>
80000a40:	c202                	sw	zero,4(sp)
80000a42:	c002                	sw	zero,0(sp)
80000a44:	55850513          	addi	a0,a0,1368 # 80006558 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006559>
80000a48:	d606                	sw	ra,44(sp)
80000a4a:	d422                	sw	s0,40(sp)
80000a4c:	d04a                	sw	s2,32(sp)
80000a4e:	ce4e                	sw	s3,28(sp)
80000a50:	381030ef          	jal	ra,800045d0 <z_impl_k_thread_create>
80000a54:	892a                	mv	s2,a0

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)

K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000a56:	4d6040ef          	jal	ra,80004f2c <z_impl_k_uptime_get_32>

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_ALLOC_APPEND, k_queue_alloc_append, s32_t, struct k_queue *, queue, void *, data)

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_ALLOC_PREPEND, k_queue_alloc_prepend, s32_t, struct k_queue *, queue, void *, data)

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80000a5a:	1f400593          	li	a1,500
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000a5e:	842a                	mv	s0,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80000a60:	8526                	mv	a0,s1
80000a62:	206020ef          	jal	ra,80002c68 <z_impl_k_queue_get>
80000a66:	89aa                	mv	s3,a0
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000a68:	4c4040ef          	jal	ra,80004f2c <z_impl_k_uptime_get_32>
	k_tid_t tid = k_thread_create(&thread, tstack, STACK_SIZE,
				      t_cancel_wait_entry, pfifo, NULL, NULL,
				      K_PRIO_PREEMPT(0), 0, 0);
	u32_t start_t = k_uptime_get_32();
	void *ret = k_fifo_get(pfifo, 500);
	u32_t dur = k_uptime_get_32() - start_t;
80000a6c:	40850433          	sub	s0,a0,s0
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000a70:	854a                	mv	a0,s2
80000a72:	477030ef          	jal	ra,800046e8 <z_impl_k_thread_abort>
	 * that the test runner below will try to create another
	 * thread in the same stack space, then 1st thread returns
	 * from the call, leading to crash.
	 */
	k_thread_abort(tid);
	zassert_is_null(ret,
80000a76:	80005937          	lui	s2,0x80005
80000a7a:	800054b7          	lui	s1,0x80005
80000a7e:	800057b7          	lui	a5,0x80005
80000a82:	800055b7          	lui	a1,0x80005
80000a86:	57090713          	addi	a4,s2,1392 # 80005570 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005571>
80000a8a:	61448613          	addi	a2,s1,1556 # 80005614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005615>
80000a8e:	0019b513          	seqz	a0,s3
80000a92:	58478793          	addi	a5,a5,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80000a96:	02b00693          	li	a3,43
80000a9a:	5b458593          	addi	a1,a1,1460 # 800055b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055b5>
80000a9e:	372d                	jal	800009c8 <z_zassert.constprop.0>
	/* 80 includes generous fuzz factor as k_sleep() will add an extra
	 * tick for non-tickless systems, and we may cross another tick
	 * boundary while doing this. We just want to ensure we didn't
	 * hit the timeout anyway.
	 */
	zassert_true(dur < 80,
80000aa0:	05043513          	sltiu	a0,s0,80
		     "k_fifo_get didn't get cancelled in expected timeframe");
}
80000aa4:	5422                	lw	s0,40(sp)
80000aa6:	50b2                	lw	ra,44(sp)
80000aa8:	49f2                	lw	s3,28(sp)
	zassert_true(dur < 80,
80000aaa:	57090713          	addi	a4,s2,1392
80000aae:	61448613          	addi	a2,s1,1556
}
80000ab2:	5902                	lw	s2,32(sp)
80000ab4:	5492                	lw	s1,36(sp)
	zassert_true(dur < 80,
80000ab6:	800057b7          	lui	a5,0x80005
80000aba:	800055b7          	lui	a1,0x80005
80000abe:	5c878793          	addi	a5,a5,1480 # 800055c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055c9>
80000ac2:	03200693          	li	a3,50
80000ac6:	60058593          	addi	a1,a1,1536 # 80005600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005601>
}
80000aca:	6145                	addi	sp,sp,48
	zassert_true(dur < 80,
80000acc:	bdf5                	j	800009c8 <z_zassert.constprop.0>

80000ace <t_cancel_wait_entry>:
{
80000ace:	1141                	addi	sp,sp,-16
80000ad0:	c422                	sw	s0,8(sp)
80000ad2:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000ad4:	03200513          	li	a0,50
80000ad8:	c606                	sw	ra,12(sp)
80000ada:	424030ef          	jal	ra,80003efe <z_impl_k_sleep>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_CANCEL_WAIT, k_queue_cancel_wait, struct k_queue *, queue)
80000ade:	8522                	mv	a0,s0
}
80000ae0:	4422                	lw	s0,8(sp)
80000ae2:	40b2                	lw	ra,12(sp)
80000ae4:	0141                	addi	sp,sp,16
80000ae6:	7a30106f          	j	80002a88 <z_impl_k_queue_cancel_wait>

80000aea <test_fifo_cancel_wait>:
 * @details This routine causes first thread pending on fifo (if any),
 * to return from k_fifo_get() with NULL value (as if timeout expired).
 * @see k_fifo_init(),k_fifo_get(), k_fifo_cancel_wait()
 */
void test_fifo_cancel_wait(void)
{
80000aea:	1141                	addi	sp,sp,-16
80000aec:	c422                	sw	s0,8(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80000aee:	80006437          	lui	s0,0x80006
80000af2:	54440513          	addi	a0,s0,1348 # 80006544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006545>
80000af6:	c606                	sw	ra,12(sp)
80000af8:	77b010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo_c);
	tfifo_thread_thread(&fifo_c);
80000afc:	54440513          	addi	a0,s0,1348
80000b00:	3f29                	jal	80000a1a <tfifo_thread_thread>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_thread(&kfifo_c);
}
80000b02:	4422                	lw	s0,8(sp)
80000b04:	40b2                	lw	ra,12(sp)
	tfifo_thread_thread(&kfifo_c);
80000b06:	80006537          	lui	a0,0x80006
80000b0a:	4d050513          	addi	a0,a0,1232 # 800064d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d1>
}
80000b0e:	0141                	addi	sp,sp,16
	tfifo_thread_thread(&kfifo_c);
80000b10:	b729                	j	80000a1a <tfifo_thread_thread>

80000b12 <z_zassert.constprop.5>:
static inline void z_zassert(int cond,
80000b12:	7179                	addi	sp,sp,-48
80000b14:	ce06                	sw	ra,28(sp)
80000b16:	d442                	sw	a6,40(sp)
80000b18:	d646                	sw	a7,44(sp)
	if (!(cond)) {
80000b1a:	ed1d                	bnez	a0,80000b58 <z_zassert.constprop.5+0x46>
80000b1c:	8636                	mv	a2,a3
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000b1e:	80005537          	lui	a0,0x80005
80000b22:	86ba                	mv	a3,a4
80000b24:	872e                	mv	a4,a1
80000b26:	800065b7          	lui	a1,0x80006
		va_start(vargs, msg);
80000b2a:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000b2c:	80058593          	addi	a1,a1,-2048 # 80005800 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005801>
80000b30:	64850513          	addi	a0,a0,1608 # 80005648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005649>
		va_start(vargs, msg);
80000b34:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000b36:	404010ef          	jal	ra,80001f3a <printk>
		vprintk(msg, vargs);
80000b3a:	45b2                	lw	a1,12(sp)
80000b3c:	80006537          	lui	a0,0x80006
80000b40:	9fc50513          	addi	a0,a0,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80000b44:	3da010ef          	jal	ra,80001f1e <vprintk>
		printk("\n");
80000b48:	80006537          	lui	a0,0x80006
80000b4c:	afc50513          	addi	a0,a0,-1284 # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
80000b50:	3ea010ef          	jal	ra,80001f3a <printk>
		ztest_test_fail();
80000b54:	17f010ef          	jal	ra,800024d2 <ztest_test_fail>
}
80000b58:	40f2                	lw	ra,28(sp)
80000b5a:	6145                	addi	sp,sp,48
80000b5c:	8082                	ret

80000b5e <tfifo_get>:
	sys_slist_append(&slist, (sys_snode_t *)&(data_sl[1].snode));
	k_fifo_put_slist(pfifo, &slist);
}

static void tfifo_get(struct k_fifo *pfifo)
{
80000b5e:	1101                	addi	sp,sp,-32
80000b60:	cc22                	sw	s0,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80000b62:	4581                	li	a1,0

	/*get fifo data from "fifo_put"*/
	for (int i = 0; i < LIST_LEN; i++) {
		/**TESTPOINT: fifo get*/
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data[i], NULL);
80000b64:	80006437          	lui	s0,0x80006
{
80000b68:	ce06                	sw	ra,28(sp)
80000b6a:	ca26                	sw	s1,20(sp)
80000b6c:	c84a                	sw	s2,16(sp)
80000b6e:	c64e                	sw	s3,12(sp)
80000b70:	c452                	sw	s4,8(sp)
80000b72:	c256                	sw	s5,4(sp)
80000b74:	8a2a                	mv	s4,a0
		zassert_equal(rx_data, (void *)&data[i], NULL);
80000b76:	5c840413          	addi	s0,s0,1480 # 800065c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c9>
80000b7a:	0ee020ef          	jal	ra,80002c68 <z_impl_k_queue_get>
80000b7e:	80005937          	lui	s2,0x80005
80000b82:	800069b7          	lui	s3,0x80006
80000b86:	800064b7          	lui	s1,0x80006
80000b8a:	80005ab7          	lui	s5,0x80005
80000b8e:	8d01                	sub	a0,a0,s0
80000b90:	9fc98793          	addi	a5,s3,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80000b94:	67090713          	addi	a4,s2,1648 # 80005670 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005671>
80000b98:	80048613          	addi	a2,s1,-2048 # 80005800 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005801>
80000b9c:	03600693          	li	a3,54
80000ba0:	744a8593          	addi	a1,s5,1860 # 80005744 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005745>
80000ba4:	00153513          	seqz	a0,a0
80000ba8:	37ad                	jal	80000b12 <z_zassert.constprop.5>
80000baa:	4581                	li	a1,0
80000bac:	8552                	mv	a0,s4
80000bae:	0ba020ef          	jal	ra,80002c68 <z_impl_k_queue_get>
80000bb2:	0421                	addi	s0,s0,8
80000bb4:	8d01                	sub	a0,a0,s0
80000bb6:	9fc98793          	addi	a5,s3,-1540
80000bba:	67090713          	addi	a4,s2,1648
80000bbe:	80048613          	addi	a2,s1,-2048
80000bc2:	03600693          	li	a3,54
80000bc6:	744a8593          	addi	a1,s5,1860
80000bca:	00153513          	seqz	a0,a0
80000bce:	3791                	jal	80000b12 <z_zassert.constprop.5>
80000bd0:	4581                	li	a1,0
80000bd2:	8552                	mv	a0,s4
	}
	/*get fifo data from "fifo_put_list"*/
	for (int i = 0; i < LIST_LEN; i++) {
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data_l[i], NULL);
80000bd4:	80006437          	lui	s0,0x80006
80000bd8:	090020ef          	jal	ra,80002c68 <z_impl_k_queue_get>
80000bdc:	5d840413          	addi	s0,s0,1496 # 800065d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d9>
80000be0:	80005ab7          	lui	s5,0x80005
80000be4:	8d01                	sub	a0,a0,s0
80000be6:	9fc98793          	addi	a5,s3,-1540
80000bea:	67090713          	addi	a4,s2,1648
80000bee:	80048613          	addi	a2,s1,-2048
80000bf2:	03b00693          	li	a3,59
80000bf6:	76ca8593          	addi	a1,s5,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
80000bfa:	00153513          	seqz	a0,a0
80000bfe:	3f11                	jal	80000b12 <z_zassert.constprop.5>
80000c00:	4581                	li	a1,0
80000c02:	8552                	mv	a0,s4
80000c04:	064020ef          	jal	ra,80002c68 <z_impl_k_queue_get>
80000c08:	0421                	addi	s0,s0,8
80000c0a:	8d01                	sub	a0,a0,s0
80000c0c:	9fc98793          	addi	a5,s3,-1540
80000c10:	67090713          	addi	a4,s2,1648
80000c14:	80048613          	addi	a2,s1,-2048
80000c18:	03b00693          	li	a3,59
80000c1c:	76ca8593          	addi	a1,s5,1900
80000c20:	00153513          	seqz	a0,a0
80000c24:	35fd                	jal	80000b12 <z_zassert.constprop.5>
80000c26:	4581                	li	a1,0
80000c28:	8552                	mv	a0,s4
	}
	/*get fifo data from "fifo_put_slist"*/
	for (int i = 0; i < LIST_LEN; i++) {
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000c2a:	80006437          	lui	s0,0x80006
80000c2e:	03a020ef          	jal	ra,80002c68 <z_impl_k_queue_get>
80000c32:	5e840413          	addi	s0,s0,1512 # 800065e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e9>
80000c36:	80005ab7          	lui	s5,0x80005
80000c3a:	8d01                	sub	a0,a0,s0
80000c3c:	9fc98793          	addi	a5,s3,-1540
80000c40:	67090713          	addi	a4,s2,1648
80000c44:	80048613          	addi	a2,s1,-2048
80000c48:	04000693          	li	a3,64
80000c4c:	794a8593          	addi	a1,s5,1940 # 80005794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005795>
80000c50:	00153513          	seqz	a0,a0
80000c54:	3d7d                	jal	80000b12 <z_zassert.constprop.5>
80000c56:	4581                	li	a1,0
80000c58:	8552                	mv	a0,s4
80000c5a:	00e020ef          	jal	ra,80002c68 <z_impl_k_queue_get>
80000c5e:	0421                	addi	s0,s0,8
80000c60:	8d01                	sub	a0,a0,s0
	}
}
80000c62:	4462                	lw	s0,24(sp)
80000c64:	40f2                	lw	ra,28(sp)
80000c66:	4a22                	lw	s4,8(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000c68:	9fc98793          	addi	a5,s3,-1540
80000c6c:	67090713          	addi	a4,s2,1648
}
80000c70:	49b2                	lw	s3,12(sp)
80000c72:	4942                	lw	s2,16(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000c74:	80048613          	addi	a2,s1,-2048
80000c78:	794a8593          	addi	a1,s5,1940
}
80000c7c:	44d2                	lw	s1,20(sp)
80000c7e:	4a92                	lw	s5,4(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000c80:	04000693          	li	a3,64
80000c84:	00153513          	seqz	a0,a0
}
80000c88:	6105                	addi	sp,sp,32
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000c8a:	b561                	j	80000b12 <z_zassert.constprop.5>

80000c8c <tIsr_entry_get>:
	tfifo_put((struct k_fifo *)p);
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
}

static void tIsr_entry_get(void *p)
{
80000c8c:	1141                	addi	sp,sp,-16
80000c8e:	c422                	sw	s0,8(sp)
80000c90:	c606                	sw	ra,12(sp)
80000c92:	842a                	mv	s0,a0
	tfifo_get((struct k_fifo *)p);
80000c94:	35e9                	jal	80000b5e <tfifo_get>
 *
 * @return a boolean, true if it's empty, false otherwise
 */
static inline bool sys_sflist_is_empty(sys_sflist_t *list);

Z_GENLIST_IS_EMPTY(sflist)
80000c96:	4008                	lw	a0,0(s0)
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
}
80000c98:	4422                	lw	s0,8(sp)
80000c9a:	40b2                	lw	ra,12(sp)
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000c9c:	800067b7          	lui	a5,0x80006
80000ca0:	80005737          	lui	a4,0x80005
80000ca4:	80006637          	lui	a2,0x80006
80000ca8:	800055b7          	lui	a1,0x80005
80000cac:	9fc78793          	addi	a5,a5,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80000cb0:	68c70713          	addi	a4,a4,1676 # 8000568c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000568d>
80000cb4:	04e00693          	li	a3,78
80000cb8:	80060613          	addi	a2,a2,-2048 # 80005800 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005801>
80000cbc:	6c858593          	addi	a1,a1,1736 # 800056c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056c9>
80000cc0:	00153513          	seqz	a0,a0
}
80000cc4:	0141                	addi	sp,sp,16
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000cc6:	b5b1                	j	80000b12 <z_zassert.constprop.5>

80000cc8 <tThread_entry>:

static void tThread_entry(void *p1, void *p2, void *p3)
{
80000cc8:	1141                	addi	sp,sp,-16
80000cca:	c606                	sw	ra,12(sp)
	tfifo_get((struct k_fifo *)p1);
80000ccc:	3d49                	jal	80000b5e <tfifo_get>
	k_sem_give(&end_sema);
}
80000cce:	40b2                	lw	ra,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000cd0:	80006537          	lui	a0,0x80006
80000cd4:	5f850513          	addi	a0,a0,1528 # 800065f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f9>
80000cd8:	0141                	addi	sp,sp,16
80000cda:	4b40306f          	j	8000418e <z_impl_k_sem_give>

80000cde <tfifo_thread_isr>:
	k_sem_take(&end_sema, K_FOREVER);
	k_thread_abort(tid);
}

static void tfifo_thread_isr(struct k_fifo *pfifo)
{
80000cde:	1141                	addi	sp,sp,-16
80000ce0:	c422                	sw	s0,8(sp)
80000ce2:	842a                	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000ce4:	80006537          	lui	a0,0x80006
80000ce8:	4605                	li	a2,1
80000cea:	4581                	li	a1,0
80000cec:	5f850513          	addi	a0,a0,1528 # 800065f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f9>
80000cf0:	c606                	sw	ra,12(sp)
80000cf2:	3fc030ef          	jal	ra,800040ee <z_impl_k_sem_init>
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: isr-thread data passing via fifo*/
	irq_offload(tIsr_entry_put, pfifo);
80000cf6:	80001537          	lui	a0,0x80001
80000cfa:	85a2                	mv	a1,s0
80000cfc:	d7650513          	addi	a0,a0,-650 # 80000d76 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000d77>
80000d00:	780000ef          	jal	ra,80001480 <irq_offload>
	tfifo_get(pfifo);
80000d04:	8522                	mv	a0,s0
}
80000d06:	4422                	lw	s0,8(sp)
80000d08:	40b2                	lw	ra,12(sp)
80000d0a:	0141                	addi	sp,sp,16
	tfifo_get(pfifo);
80000d0c:	bd89                	j	80000b5e <tfifo_get>

80000d0e <tfifo_put>:
{
80000d0e:	1101                	addi	sp,sp,-32
		k_fifo_put(pfifo, (void *)&data[i]);
80000d10:	800065b7          	lui	a1,0x80006
{
80000d14:	ca26                	sw	s1,20(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
80000d16:	5c858493          	addi	s1,a1,1480 # 800065c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c9>
80000d1a:	5c858593          	addi	a1,a1,1480
{
80000d1e:	ce06                	sw	ra,28(sp)
80000d20:	cc22                	sw	s0,24(sp)
80000d22:	842a                	mv	s0,a0
		k_fifo_put(pfifo, (void *)&data[i]);
80000d24:	5e5010ef          	jal	ra,80002b08 <k_queue_append>
80000d28:	00848593          	addi	a1,s1,8
80000d2c:	8522                	mv	a0,s0
80000d2e:	5db010ef          	jal	ra,80002b08 <k_queue_append>
	head->snode.next = (sys_snode_t *)tail;
80000d32:	800065b7          	lui	a1,0x80006
80000d36:	5d858793          	addi	a5,a1,1496 # 800065d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d9>
80000d3a:	00878613          	addi	a2,a5,8
80000d3e:	c390                	sw	a2,0(a5)
	k_fifo_put_list(pfifo, (u32_t *)head, (u32_t *)tail);
80000d40:	8522                	mv	a0,s0
	tail->snode.next = NULL;
80000d42:	0007a423          	sw	zero,8(a5)
	k_fifo_put_list(pfifo, (u32_t *)head, (u32_t *)tail);
80000d46:	5d858593          	addi	a1,a1,1496
80000d4a:	5c7010ef          	jal	ra,80002b10 <k_queue_append_list>
	parent->next = child;
}

static inline void z_slist_head_set(sys_slist_t *list, sys_snode_t *node)
{
	list->head = node;
80000d4e:	800067b7          	lui	a5,0x80006
80000d52:	5e878793          	addi	a5,a5,1512 # 800065e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e9>
	parent->next = child;
80000d56:	00878713          	addi	a4,a5,8
	k_fifo_put_slist(pfifo, &slist);
80000d5a:	002c                	addi	a1,sp,8
80000d5c:	8522                	mv	a0,s0
80000d5e:	0007a423          	sw	zero,8(a5)
80000d62:	c398                	sw	a4,0(a5)
	list->head = node;
80000d64:	c43e                	sw	a5,8(sp)
}

static inline void z_slist_tail_set(sys_slist_t *list, sys_snode_t *node)
{
	list->tail = node;
80000d66:	c63a                	sw	a4,12(sp)
80000d68:	69b010ef          	jal	ra,80002c02 <k_queue_merge_slist>
}
80000d6c:	40f2                	lw	ra,28(sp)
80000d6e:	4462                	lw	s0,24(sp)
80000d70:	44d2                	lw	s1,20(sp)
80000d72:	6105                	addi	sp,sp,32
80000d74:	8082                	ret

80000d76 <tIsr_entry_put>:
{
80000d76:	1141                	addi	sp,sp,-16
80000d78:	c422                	sw	s0,8(sp)
80000d7a:	c606                	sw	ra,12(sp)
80000d7c:	842a                	mv	s0,a0
	tfifo_put((struct k_fifo *)p);
80000d7e:	3f41                	jal	80000d0e <tfifo_put>
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000d80:	4008                	lw	a0,0(s0)
}
80000d82:	4422                	lw	s0,8(sp)
80000d84:	40b2                	lw	ra,12(sp)
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000d86:	800067b7          	lui	a5,0x80006
80000d8a:	80005737          	lui	a4,0x80005
80000d8e:	80006637          	lui	a2,0x80006
80000d92:	800055b7          	lui	a1,0x80005
80000d96:	9fc78793          	addi	a5,a5,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80000d9a:	67c70713          	addi	a4,a4,1660 # 8000567c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000567d>
80000d9e:	04800693          	li	a3,72
80000da2:	80060613          	addi	a2,a2,-2048 # 80005800 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005801>
80000da6:	6f858593          	addi	a1,a1,1784 # 800056f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f9>
80000daa:	00a03533          	snez	a0,a0
}
80000dae:	0141                	addi	sp,sp,16
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000db0:	b38d                	j	80000b12 <z_zassert.constprop.5>

80000db2 <tfifo_is_empty>:
	tfifo_put(pfifo);
	irq_offload(tIsr_entry_get, pfifo);
}

static void tfifo_is_empty(void *p)
{
80000db2:	1101                	addi	sp,sp,-32
80000db4:	c452                	sw	s4,8(sp)
	struct k_fifo *pfifo = (struct k_fifo *)p;

	tfifo_put(&fifo);
80000db6:	80006a37          	lui	s4,0x80006
{
80000dba:	c64e                	sw	s3,12(sp)
80000dbc:	89aa                	mv	s3,a0
	tfifo_put(&fifo);
80000dbe:	608a0513          	addi	a0,s4,1544 # 80006608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006609>
{
80000dc2:	ce06                	sw	ra,28(sp)
80000dc4:	cc22                	sw	s0,24(sp)
80000dc6:	ca26                	sw	s1,20(sp)
80000dc8:	c84a                	sw	s2,16(sp)
	tfifo_put(&fifo);
80000dca:	3791                	jal	80000d0e <tfifo_put>
	/**TESTPOINT: return false when data available*/
	zassert_false(k_fifo_is_empty(pfifo), NULL);
80000dcc:	0009a503          	lw	a0,0(s3)
80000dd0:	800054b7          	lui	s1,0x80005
80000dd4:	80006937          	lui	s2,0x80006
80000dd8:	80006437          	lui	s0,0x80006
80000ddc:	800055b7          	lui	a1,0x80005
80000de0:	9fc90793          	addi	a5,s2,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80000de4:	69c48713          	addi	a4,s1,1692 # 8000569c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000569d>
80000de8:	80040613          	addi	a2,s0,-2048 # 80005800 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005801>
80000dec:	07900693          	li	a3,121
80000df0:	7c058593          	addi	a1,a1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
80000df4:	00a03533          	snez	a0,a0
80000df8:	3b29                	jal	80000b12 <z_zassert.constprop.5>

	tfifo_get(&fifo);
80000dfa:	608a0513          	addi	a0,s4,1544
80000dfe:	3385                	jal	80000b5e <tfifo_get>
80000e00:	0009a503          	lw	a0,0(s3)
	/**TESTPOINT: return true with data unavailable*/
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000e04:	80040613          	addi	a2,s0,-2048
}
80000e08:	4462                	lw	s0,24(sp)
80000e0a:	40f2                	lw	ra,28(sp)
80000e0c:	49b2                	lw	s3,12(sp)
80000e0e:	4a22                	lw	s4,8(sp)
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000e10:	9fc90793          	addi	a5,s2,-1540
80000e14:	69c48713          	addi	a4,s1,1692
}
80000e18:	4942                	lw	s2,16(sp)
80000e1a:	44d2                	lw	s1,20(sp)
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000e1c:	800055b7          	lui	a1,0x80005
80000e20:	07d00693          	li	a3,125
80000e24:	7e058593          	addi	a1,a1,2016 # 800057e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e1>
80000e28:	00153513          	seqz	a0,a0
}
80000e2c:	6105                	addi	sp,sp,32
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000e2e:	b1d5                	j	80000b12 <z_zassert.constprop.5>

80000e30 <tfifo_thread_thread>:
{
80000e30:	1101                	addi	sp,sp,-32
80000e32:	cc22                	sw	s0,24(sp)
80000e34:	80006437          	lui	s0,0x80006
80000e38:	ca26                	sw	s1,20(sp)
80000e3a:	4605                	li	a2,1
80000e3c:	84aa                	mv	s1,a0
80000e3e:	4581                	li	a1,0
80000e40:	5f840513          	addi	a0,s0,1528 # 800065f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f9>
80000e44:	ce06                	sw	ra,28(sp)
80000e46:	c84a                	sw	s2,16(sp)
80000e48:	2a6030ef          	jal	ra,800040ee <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000e4c:	800016b7          	lui	a3,0x80001
80000e50:	800075b7          	lui	a1,0x80007
80000e54:	80006537          	lui	a0,0x80006
80000e58:	8726                	mv	a4,s1
80000e5a:	4881                	li	a7,0
80000e5c:	4801                	li	a6,0
80000e5e:	4781                	li	a5,0
80000e60:	cc868693          	addi	a3,a3,-824 # 80000cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000cc9>
80000e64:	20000613          	li	a2,512
80000e68:	ad058593          	addi	a1,a1,-1328 # 80006ad0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ad1>
80000e6c:	c202                	sw	zero,4(sp)
80000e6e:	c002                	sw	zero,0(sp)
80000e70:	61c50513          	addi	a0,a0,1564 # 8000661c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000661d>
80000e74:	75c030ef          	jal	ra,800045d0 <z_impl_k_thread_create>
80000e78:	892a                	mv	s2,a0
	tfifo_put(pfifo);
80000e7a:	8526                	mv	a0,s1
80000e7c:	3d49                	jal	80000d0e <tfifo_put>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000e7e:	5f840513          	addi	a0,s0,1528
80000e82:	55fd                	li	a1,-1
80000e84:	3b4030ef          	jal	ra,80004238 <z_impl_k_sem_take>
}
80000e88:	4462                	lw	s0,24(sp)
80000e8a:	40f2                	lw	ra,28(sp)
80000e8c:	44d2                	lw	s1,20(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000e8e:	854a                	mv	a0,s2
80000e90:	4942                	lw	s2,16(sp)
80000e92:	6105                	addi	sp,sp,32
80000e94:	0550306f          	j	800046e8 <z_impl_k_thread_abort>

80000e98 <tfifo_isr_thread>:
{
80000e98:	1141                	addi	sp,sp,-16
80000e9a:	c422                	sw	s0,8(sp)
80000e9c:	842a                	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000e9e:	80006537          	lui	a0,0x80006
80000ea2:	4581                	li	a1,0
80000ea4:	4605                	li	a2,1
80000ea6:	5f850513          	addi	a0,a0,1528 # 800065f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f9>
80000eaa:	c606                	sw	ra,12(sp)
80000eac:	242030ef          	jal	ra,800040ee <z_impl_k_sem_init>
	tfifo_put(pfifo);
80000eb0:	8522                	mv	a0,s0
80000eb2:	3db1                	jal	80000d0e <tfifo_put>
	irq_offload(tIsr_entry_get, pfifo);
80000eb4:	85a2                	mv	a1,s0
}
80000eb6:	4422                	lw	s0,8(sp)
80000eb8:	40b2                	lw	ra,12(sp)
	irq_offload(tIsr_entry_get, pfifo);
80000eba:	80001537          	lui	a0,0x80001
80000ebe:	c8c50513          	addi	a0,a0,-884 # 80000c8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000c8d>
}
80000ec2:	0141                	addi	sp,sp,16
	irq_offload(tIsr_entry_get, pfifo);
80000ec4:	ab75                	j	80001480 <irq_offload>

80000ec6 <test_fifo_thread2thread>:
/**
 * @brief Test thread to thread data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get(), k_fifo_put_list()
 */
void test_fifo_thread2thread(void)
{
80000ec6:	1141                	addi	sp,sp,-16
80000ec8:	c422                	sw	s0,8(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80000eca:	80006437          	lui	s0,0x80006
80000ece:	60840513          	addi	a0,s0,1544 # 80006608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006609>
80000ed2:	c606                	sw	ra,12(sp)
80000ed4:	39f010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo);
	tfifo_thread_thread(&fifo);
80000ed8:	60840513          	addi	a0,s0,1544
80000edc:	3f91                	jal	80000e30 <tfifo_thread_thread>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_thread(&kfifo);
}
80000ede:	4422                	lw	s0,8(sp)
80000ee0:	40b2                	lw	ra,12(sp)
	tfifo_thread_thread(&kfifo);
80000ee2:	80006537          	lui	a0,0x80006
80000ee6:	4e450513          	addi	a0,a0,1252 # 800064e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064e5>
}
80000eea:	0141                	addi	sp,sp,16
	tfifo_thread_thread(&kfifo);
80000eec:	b791                	j	80000e30 <tfifo_thread_thread>

80000eee <test_fifo_thread2isr>:
/**
 * @brief Test isr to thread data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_thread2isr(void)
{
80000eee:	1141                	addi	sp,sp,-16
80000ef0:	c422                	sw	s0,8(sp)
80000ef2:	80006437          	lui	s0,0x80006
80000ef6:	60840513          	addi	a0,s0,1544 # 80006608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006609>
80000efa:	c606                	sw	ra,12(sp)
80000efc:	377010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo);
	tfifo_thread_isr(&fifo);
80000f00:	60840513          	addi	a0,s0,1544
80000f04:	3be9                	jal	80000cde <tfifo_thread_isr>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_isr(&kfifo);
}
80000f06:	4422                	lw	s0,8(sp)
80000f08:	40b2                	lw	ra,12(sp)
	tfifo_thread_isr(&kfifo);
80000f0a:	80006537          	lui	a0,0x80006
80000f0e:	4e450513          	addi	a0,a0,1252 # 800064e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064e5>
}
80000f12:	0141                	addi	sp,sp,16
	tfifo_thread_isr(&kfifo);
80000f14:	b3e9                	j	80000cde <tfifo_thread_isr>

80000f16 <test_fifo_isr2thread>:
/**
 * @brief Test thread to isr data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_isr2thread(void)
{
80000f16:	1141                	addi	sp,sp,-16
80000f18:	c422                	sw	s0,8(sp)
80000f1a:	80006437          	lui	s0,0x80006
80000f1e:	60840513          	addi	a0,s0,1544 # 80006608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006609>
80000f22:	c606                	sw	ra,12(sp)
80000f24:	34f010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
	/**TESTPOINT: test k_fifo_init fifo*/
	k_fifo_init(&fifo);
	tfifo_isr_thread(&fifo);
80000f28:	60840513          	addi	a0,s0,1544
80000f2c:	37b5                	jal	80000e98 <tfifo_isr_thread>

	/**TESTPOINT: test K_FIFO_DEFINE fifo*/
	tfifo_isr_thread(&kfifo);
}
80000f2e:	4422                	lw	s0,8(sp)
80000f30:	40b2                	lw	ra,12(sp)
	tfifo_isr_thread(&kfifo);
80000f32:	80006537          	lui	a0,0x80006
80000f36:	4e450513          	addi	a0,a0,1252 # 800064e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064e5>
}
80000f3a:	0141                	addi	sp,sp,16
	tfifo_isr_thread(&kfifo);
80000f3c:	bfb1                	j	80000e98 <tfifo_isr_thread>

80000f3e <test_fifo_is_empty_thread>:
/**
 * @brief Test empty fifo
 * @see k_fifo_init(), k_fifo_is_empty(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_is_empty_thread(void)
{
80000f3e:	1141                	addi	sp,sp,-16
80000f40:	c422                	sw	s0,8(sp)
80000f42:	80006437          	lui	s0,0x80006
80000f46:	60840513          	addi	a0,s0,1544 # 80006608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006609>
80000f4a:	c606                	sw	ra,12(sp)
80000f4c:	c226                	sw	s1,4(sp)
80000f4e:	325010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
80000f52:	60840493          	addi	s1,s0,1544
80000f56:	4088                	lw	a0,0(s1)
	k_fifo_init(&fifo);
	/**TESTPOINT: k_fifo_is_empty after init*/
	zassert_true(k_fifo_is_empty(&fifo), NULL);
80000f58:	800067b7          	lui	a5,0x80006
80000f5c:	80005737          	lui	a4,0x80005
80000f60:	80006637          	lui	a2,0x80006
80000f64:	800055b7          	lui	a1,0x80005
80000f68:	00153513          	seqz	a0,a0
80000f6c:	9fc78793          	addi	a5,a5,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80000f70:	6ac70713          	addi	a4,a4,1708 # 800056ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056ad>
80000f74:	0b700693          	li	a3,183
80000f78:	80060613          	addi	a2,a2,-2048 # 80005800 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005801>
80000f7c:	72458593          	addi	a1,a1,1828 # 80005724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005725>
80000f80:	3e49                	jal	80000b12 <z_zassert.constprop.5>

	/**TESTPONT: check fifo is empty from thread*/
	tfifo_is_empty(&fifo);
80000f82:	60840513          	addi	a0,s0,1544
}
80000f86:	4422                	lw	s0,8(sp)
80000f88:	40b2                	lw	ra,12(sp)
80000f8a:	4492                	lw	s1,4(sp)
80000f8c:	0141                	addi	sp,sp,16
	tfifo_is_empty(&fifo);
80000f8e:	b515                	j	80000db2 <tfifo_is_empty>

80000f90 <test_fifo_is_empty_isr>:
/**
 * @brief Test empty fifo in interrupt context
 * @see k_fifo_init(), fifo_is_empty(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_is_empty_isr(void)
{
80000f90:	1141                	addi	sp,sp,-16
80000f92:	c422                	sw	s0,8(sp)
80000f94:	80006437          	lui	s0,0x80006
80000f98:	60840513          	addi	a0,s0,1544 # 80006608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006609>
80000f9c:	c606                	sw	ra,12(sp)
80000f9e:	2d5010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
	k_fifo_init(&fifo);
	/**TESTPOINT: check fifo is empty from isr*/
	irq_offload(tfifo_is_empty, &fifo);
80000fa2:	60840593          	addi	a1,s0,1544
}
80000fa6:	4422                	lw	s0,8(sp)
80000fa8:	40b2                	lw	ra,12(sp)
	irq_offload(tfifo_is_empty, &fifo);
80000faa:	80001537          	lui	a0,0x80001
80000fae:	db250513          	addi	a0,a0,-590 # 80000db2 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000db3>
}
80000fb2:	0141                	addi	sp,sp,16
	irq_offload(tfifo_is_empty, &fifo);
80000fb4:	a1f1                	j	80001480 <irq_offload>

80000fb6 <z_zassert.constprop.0>:
static inline void z_zassert(int cond,
80000fb6:	7179                	addi	sp,sp,-48
80000fb8:	ce06                	sw	ra,28(sp)
80000fba:	d442                	sw	a6,40(sp)
80000fbc:	d646                	sw	a7,44(sp)
	if (!(cond)) {
80000fbe:	e131                	bnez	a0,80001002 <z_zassert.constprop.0+0x4c>
80000fc0:	8636                	mv	a2,a3
80000fc2:	872e                	mv	a4,a1
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000fc4:	800066b7          	lui	a3,0x80006
80000fc8:	800065b7          	lui	a1,0x80006
80000fcc:	80005537          	lui	a0,0x80005
		va_start(vargs, msg);
80000fd0:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000fd2:	83868693          	addi	a3,a3,-1992 # 80005838 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005839>
80000fd6:	8a058593          	addi	a1,a1,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
80000fda:	64850513          	addi	a0,a0,1608 # 80005648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005649>
		va_start(vargs, msg);
80000fde:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000fe0:	75b000ef          	jal	ra,80001f3a <printk>
		vprintk(msg, vargs);
80000fe4:	45b2                	lw	a1,12(sp)
80000fe6:	80006537          	lui	a0,0x80006
80000fea:	9fc50513          	addi	a0,a0,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80000fee:	731000ef          	jal	ra,80001f1e <vprintk>
		printk("\n");
80000ff2:	80006537          	lui	a0,0x80006
80000ff6:	afc50513          	addi	a0,a0,-1284 # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
80000ffa:	741000ef          	jal	ra,80001f3a <printk>
		ztest_test_fail();
80000ffe:	4d4010ef          	jal	ra,800024d2 <ztest_test_fail>
}
80001002:	40f2                	lw	ra,28(sp)
80001004:	6145                	addi	sp,sp,48
80001006:	8082                	ret

80001008 <test_fifo_get_fail>:
 * @details test zephyr fifo_get when no data to read,
 * it should returns NULL.
 * @see k_fifo_init(), k_fifo_get()
 */
void test_fifo_get_fail(void *p1, void *p2, void *p3)
{
80001008:	7179                	addi	sp,sp,-48
8000100a:	0068                	addi	a0,sp,12
8000100c:	d606                	sw	ra,44(sp)
8000100e:	d422                	sw	s0,40(sp)
80001010:	d226                	sw	s1,36(sp)
80001012:	d04a                	sw	s2,32(sp)
80001014:	25f010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80001018:	4581                	li	a1,0
8000101a:	0068                	addi	a0,sp,12
8000101c:	44d010ef          	jal	ra,80002c68 <z_impl_k_queue_get>
	struct k_fifo fifo;

	k_fifo_init(&fifo);
	/**TESTPOINT: fifo get returns NULL*/
	zassert_is_null(k_fifo_get(&fifo, K_NO_WAIT), NULL);
80001020:	800064b7          	lui	s1,0x80006
80001024:	80006937          	lui	s2,0x80006
80001028:	80006437          	lui	s0,0x80006
8000102c:	800065b7          	lui	a1,0x80006
80001030:	9fc90793          	addi	a5,s2,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80001034:	83848713          	addi	a4,s1,-1992 # 80005838 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005839>
80001038:	8a040613          	addi	a2,s0,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
8000103c:	46f1                	li	a3,28
8000103e:	84c58593          	addi	a1,a1,-1972 # 8000584c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000584d>
80001042:	00153513          	seqz	a0,a0
80001046:	3f85                	jal	80000fb6 <z_zassert.constprop.0>
80001048:	06400593          	li	a1,100
8000104c:	0068                	addi	a0,sp,12
8000104e:	41b010ef          	jal	ra,80002c68 <z_impl_k_queue_get>
	zassert_is_null(k_fifo_get(&fifo, TIMEOUT), NULL);
80001052:	800065b7          	lui	a1,0x80006
80001056:	9fc90793          	addi	a5,s2,-1540
8000105a:	83848713          	addi	a4,s1,-1992
8000105e:	8a040613          	addi	a2,s0,-1888
80001062:	46f5                	li	a3,29
80001064:	87858593          	addi	a1,a1,-1928 # 80005878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005879>
80001068:	00153513          	seqz	a0,a0
8000106c:	37a9                	jal	80000fb6 <z_zassert.constprop.0>
}
8000106e:	50b2                	lw	ra,44(sp)
80001070:	5422                	lw	s0,40(sp)
80001072:	5492                	lw	s1,36(sp)
80001074:	5902                	lw	s2,32(sp)
80001076:	6145                	addi	sp,sp,48
80001078:	8082                	ret

8000107a <tfifo_put>:
static K_THREAD_STACK_DEFINE(tstack, STACK_SIZE);
static struct k_thread tdata;
static struct k_sem end_sema;

static void tfifo_put(struct k_fifo *pfifo)
{
8000107a:	1141                	addi	sp,sp,-16
	/**TESTPOINT: fifo put*/
	for (int i = 0; i < LIST_LEN; i++) {
		k_fifo_put(pfifo, (void *)&data[i]);
8000107c:	800065b7          	lui	a1,0x80006
{
80001080:	c226                	sw	s1,4(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
80001082:	68c58493          	addi	s1,a1,1676 # 8000668c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000668d>
80001086:	68c58593          	addi	a1,a1,1676
{
8000108a:	c606                	sw	ra,12(sp)
8000108c:	c422                	sw	s0,8(sp)
8000108e:	842a                	mv	s0,a0
		k_fifo_put(pfifo, (void *)&data[i]);
80001090:	279010ef          	jal	ra,80002b08 <k_queue_append>
80001094:	00848593          	addi	a1,s1,8
80001098:	8522                	mv	a0,s0
8000109a:	26f010ef          	jal	ra,80002b08 <k_queue_append>
8000109e:	01048593          	addi	a1,s1,16
800010a2:	8522                	mv	a0,s0
800010a4:	265010ef          	jal	ra,80002b08 <k_queue_append>
800010a8:	8522                	mv	a0,s0
	}
}
800010aa:	4422                	lw	s0,8(sp)
800010ac:	40b2                	lw	ra,12(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
800010ae:	01848593          	addi	a1,s1,24
}
800010b2:	4492                	lw	s1,4(sp)
800010b4:	0141                	addi	sp,sp,16
		k_fifo_put(pfifo, (void *)&data[i]);
800010b6:	2530106f          	j	80002b08 <k_queue_append>

800010ba <z_zassert.constprop.1>:
static inline void z_zassert(int cond,
800010ba:	7179                	addi	sp,sp,-48
800010bc:	ce06                	sw	ra,28(sp)
800010be:	d442                	sw	a6,40(sp)
800010c0:	d646                	sw	a7,44(sp)
	if (!(cond)) {
800010c2:	e531                	bnez	a0,8000110e <z_zassert.constprop.1+0x54>
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800010c4:	80005737          	lui	a4,0x80005
800010c8:	800066b7          	lui	a3,0x80006
800010cc:	800065b7          	lui	a1,0x80006
800010d0:	80005537          	lui	a0,0x80005
		va_start(vargs, msg);
800010d4:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800010d6:	74470713          	addi	a4,a4,1860 # 80005744 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005745>
800010da:	8d468693          	addi	a3,a3,-1836 # 800058d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058d5>
800010de:	02300613          	li	a2,35
800010e2:	97458593          	addi	a1,a1,-1676 # 80005974 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005975>
800010e6:	64850513          	addi	a0,a0,1608 # 80005648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005649>
		va_start(vargs, msg);
800010ea:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800010ec:	64f000ef          	jal	ra,80001f3a <printk>
		vprintk(msg, vargs);
800010f0:	45b2                	lw	a1,12(sp)
800010f2:	80006537          	lui	a0,0x80006
800010f6:	9fc50513          	addi	a0,a0,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
800010fa:	625000ef          	jal	ra,80001f1e <vprintk>
		printk("\n");
800010fe:	80006537          	lui	a0,0x80006
80001102:	afc50513          	addi	a0,a0,-1284 # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
80001106:	635000ef          	jal	ra,80001f3a <printk>
		ztest_test_fail();
8000110a:	3c8010ef          	jal	ra,800024d2 <ztest_test_fail>
}
8000110e:	40f2                	lw	ra,28(sp)
80001110:	6145                	addi	sp,sp,48
80001112:	8082                	ret

80001114 <tfifo_get>:

static void tfifo_get(struct k_fifo *pfifo)
{
80001114:	1101                	addi	sp,sp,-32
80001116:	cc22                	sw	s0,24(sp)
80001118:	80006437          	lui	s0,0x80006
8000111c:	68c40413          	addi	s0,s0,1676 # 8000668c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000668d>
80001120:	ca26                	sw	s1,20(sp)
80001122:	c84a                	sw	s2,16(sp)
80001124:	c64e                	sw	s3,12(sp)
80001126:	c452                	sw	s4,8(sp)
80001128:	c256                	sw	s5,4(sp)
8000112a:	c05a                	sw	s6,0(sp)
8000112c:	ce06                	sw	ra,28(sp)
8000112e:	8b2a                	mv	s6,a0
80001130:	02040493          	addi	s1,s0,32

	/*get fifo data from "fifo_put"*/
	for (int i = 0; i < LIST_LEN; i++) {
		/**TESTPOINT: fifo get*/
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data[i], NULL);
80001134:	80006a37          	lui	s4,0x80006
80001138:	80006ab7          	lui	s5,0x80006
8000113c:	800069b7          	lui	s3,0x80006
80001140:	80005937          	lui	s2,0x80005
80001144:	4581                	li	a1,0
80001146:	855a                	mv	a0,s6
80001148:	321010ef          	jal	ra,80002c68 <z_impl_k_queue_get>
8000114c:	8d01                	sub	a0,a0,s0
8000114e:	9fca8793          	addi	a5,s5,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
80001152:	8d4a0713          	addi	a4,s4,-1836 # 800058d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058d5>
80001156:	02300693          	li	a3,35
8000115a:	97498613          	addi	a2,s3,-1676 # 80005974 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005975>
8000115e:	74490593          	addi	a1,s2,1860 # 80005744 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005745>
80001162:	00153513          	seqz	a0,a0
80001166:	0421                	addi	s0,s0,8
80001168:	3f89                	jal	800010ba <z_zassert.constprop.1>
	for (int i = 0; i < LIST_LEN; i++) {
8000116a:	fc941de3          	bne	s0,s1,80001144 <tfifo_get+0x30>
	}
}
8000116e:	40f2                	lw	ra,28(sp)
80001170:	4462                	lw	s0,24(sp)
80001172:	44d2                	lw	s1,20(sp)
80001174:	4942                	lw	s2,16(sp)
80001176:	49b2                	lw	s3,12(sp)
80001178:	4a22                	lw	s4,8(sp)
8000117a:	4a92                	lw	s5,4(sp)
8000117c:	4b02                	lw	s6,0(sp)
8000117e:	6105                	addi	sp,sp,32
80001180:	8082                	ret

80001182 <tIsr_entry>:

/*entry of contexts*/
static void tIsr_entry(void *p)
{
80001182:	1141                	addi	sp,sp,-16
80001184:	c422                	sw	s0,8(sp)
80001186:	842a                	mv	s0,a0
	TC_PRINT("isr fifo get\n");
80001188:	80006537          	lui	a0,0x80006
8000118c:	8e050513          	addi	a0,a0,-1824 # 800058e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058e1>
{
80001190:	c606                	sw	ra,12(sp)
	TC_PRINT("isr fifo get\n");
80001192:	5a9000ef          	jal	ra,80001f3a <printk>
	tfifo_get((struct k_fifo *)p);
80001196:	8522                	mv	a0,s0
80001198:	3fb5                	jal	80001114 <tfifo_get>
	TC_PRINT("isr fifo put ---> ");
8000119a:	80006537          	lui	a0,0x80006
8000119e:	8f050513          	addi	a0,a0,-1808 # 800058f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f1>
800011a2:	599000ef          	jal	ra,80001f3a <printk>
	tfifo_put((struct k_fifo *)p);
800011a6:	8522                	mv	a0,s0
}
800011a8:	4422                	lw	s0,8(sp)
800011aa:	40b2                	lw	ra,12(sp)
800011ac:	0141                	addi	sp,sp,16
	tfifo_put((struct k_fifo *)p);
800011ae:	b5f1                	j	8000107a <tfifo_put>

800011b0 <tThread_entry>:

static void tThread_entry(void *p1, void *p2, void *p3)
{
800011b0:	1141                	addi	sp,sp,-16
800011b2:	c226                	sw	s1,4(sp)
800011b4:	84aa                	mv	s1,a0
	TC_PRINT("thread fifo get\n");
800011b6:	80006537          	lui	a0,0x80006
800011ba:	90450513          	addi	a0,a0,-1788 # 80005904 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005905>
{
800011be:	c606                	sw	ra,12(sp)
800011c0:	c422                	sw	s0,8(sp)
	TC_PRINT("thread fifo get\n");
800011c2:	579000ef          	jal	ra,80001f3a <printk>
	tfifo_get((struct k_fifo *)p1);
800011c6:	8526                	mv	a0,s1
800011c8:	37b1                	jal	80001114 <tfifo_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800011ca:	80006437          	lui	s0,0x80006
800011ce:	6ac40513          	addi	a0,s0,1708 # 800066ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066ad>
800011d2:	7bd020ef          	jal	ra,8000418e <z_impl_k_sem_give>
	k_sem_give(&end_sema);
	TC_PRINT("thread fifo put ---> ");
800011d6:	80006537          	lui	a0,0x80006
800011da:	91850513          	addi	a0,a0,-1768 # 80005918 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005919>
800011de:	55d000ef          	jal	ra,80001f3a <printk>
	tfifo_put((struct k_fifo *)p1);
800011e2:	8526                	mv	a0,s1
800011e4:	3d59                	jal	8000107a <tfifo_put>
800011e6:	6ac40513          	addi	a0,s0,1708
	k_sem_give(&end_sema);
}
800011ea:	4422                	lw	s0,8(sp)
800011ec:	40b2                	lw	ra,12(sp)
800011ee:	4492                	lw	s1,4(sp)
800011f0:	0141                	addi	sp,sp,16
800011f2:	79d0206f          	j	8000418e <z_impl_k_sem_give>

800011f6 <test_fifo_loop>:
 *   -# fifo data pass correctly and stably across contexts
 *
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_loop(void)
{
800011f6:	7139                	addi	sp,sp,-64
800011f8:	dc22                	sw	s0,56(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
800011fa:	80006437          	lui	s0,0x80006
800011fe:	6bc40513          	addi	a0,s0,1724 # 800066bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066bd>
80001202:	da26                	sw	s1,52(sp)
80001204:	d84a                	sw	s2,48(sp)
80001206:	d452                	sw	s4,40(sp)
80001208:	d256                	sw	s5,36(sp)
8000120a:	d05a                	sw	s6,32(sp)
8000120c:	ce5e                	sw	s7,28(sp)
8000120e:	cc62                	sw	s8,24(sp)
80001210:	ca66                	sw	s9,20(sp)
80001212:	c86a                	sw	s10,16(sp)
80001214:	de06                	sw	ra,60(sp)
80001216:	d64e                	sw	s3,44(sp)
	k_fifo_init(&fifo);
	for (int i = 0; i < LOOPS; i++) {
80001218:	4481                	li	s1,0
8000121a:	059010ef          	jal	ra,80002a72 <z_impl_k_queue_init>
		TC_PRINT("* Pass data by fifo in loop %d\n", i);
8000121e:	80006d37          	lui	s10,0x80006
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001222:	80006937          	lui	s2,0x80006
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001226:	80007c37          	lui	s8,0x80007
8000122a:	80006bb7          	lui	s7,0x80006
8000122e:	80001cb7          	lui	s9,0x80001
	TC_PRINT("main fifo put ---> ");
80001232:	80006b37          	lui	s6,0x80006
	irq_offload(tIsr_entry, pfifo);
80001236:	80001ab7          	lui	s5,0x80001
	TC_PRINT("main fifo get\n");
8000123a:	80006a37          	lui	s4,0x80006
		TC_PRINT("* Pass data by fifo in loop %d\n", i);
8000123e:	85a6                	mv	a1,s1
80001240:	930d0513          	addi	a0,s10,-1744 # 80005930 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005931>
80001244:	4f7000ef          	jal	ra,80001f3a <printk>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001248:	4605                	li	a2,1
8000124a:	4581                	li	a1,0
8000124c:	6ac90513          	addi	a0,s2,1708 # 800066ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066ad>
80001250:	69f020ef          	jal	ra,800040ee <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001254:	4781                	li	a5,0
80001256:	4881                	li	a7,0
80001258:	4801                	li	a6,0
8000125a:	6bc40713          	addi	a4,s0,1724
8000125e:	1b0c8693          	addi	a3,s9,432 # 800011b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800011b1>
80001262:	20000613          	li	a2,512
80001266:	cd0c0593          	addi	a1,s8,-816 # 80006cd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd1>
8000126a:	c202                	sw	zero,4(sp)
8000126c:	c002                	sw	zero,0(sp)
8000126e:	6d0b8513          	addi	a0,s7,1744 # 800066d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d1>
80001272:	35e030ef          	jal	ra,800045d0 <z_impl_k_thread_create>
80001276:	89aa                	mv	s3,a0
	TC_PRINT("main fifo put ---> ");
80001278:	950b0513          	addi	a0,s6,-1712 # 80005950 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005951>
8000127c:	4bf000ef          	jal	ra,80001f3a <printk>
	tfifo_put(pfifo);
80001280:	6bc40513          	addi	a0,s0,1724
80001284:	3bdd                	jal	8000107a <tfifo_put>
	irq_offload(tIsr_entry, pfifo);
80001286:	6bc40593          	addi	a1,s0,1724
8000128a:	182a8513          	addi	a0,s5,386 # 80001182 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001183>
8000128e:	2acd                	jal	80001480 <irq_offload>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001290:	55fd                	li	a1,-1
80001292:	6ac90513          	addi	a0,s2,1708
80001296:	7a3020ef          	jal	ra,80004238 <z_impl_k_sem_take>
8000129a:	55fd                	li	a1,-1
8000129c:	6ac90513          	addi	a0,s2,1708
800012a0:	799020ef          	jal	ra,80004238 <z_impl_k_sem_take>
	TC_PRINT("main fifo get\n");
800012a4:	964a0513          	addi	a0,s4,-1692 # 80005964 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005965>
800012a8:	493000ef          	jal	ra,80001f3a <printk>
	tfifo_get(pfifo);
800012ac:	6bc40513          	addi	a0,s0,1724
800012b0:	3595                	jal	80001114 <tfifo_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800012b2:	854e                	mv	a0,s3
800012b4:	434030ef          	jal	ra,800046e8 <z_impl_k_thread_abort>
	TC_PRINT("\n");
800012b8:	80006537          	lui	a0,0x80006
800012bc:	afc50513          	addi	a0,a0,-1284 # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
800012c0:	47b000ef          	jal	ra,80001f3a <printk>
	for (int i = 0; i < LOOPS; i++) {
800012c4:	0485                	addi	s1,s1,1
800012c6:	02000793          	li	a5,32
800012ca:	f6f49ae3          	bne	s1,a5,8000123e <test_fifo_loop+0x48>
		tfifo_read_write(&fifo);
	}
}
800012ce:	50f2                	lw	ra,60(sp)
800012d0:	5462                	lw	s0,56(sp)
800012d2:	54d2                	lw	s1,52(sp)
800012d4:	5942                	lw	s2,48(sp)
800012d6:	59b2                	lw	s3,44(sp)
800012d8:	5a22                	lw	s4,40(sp)
800012da:	5a92                	lw	s5,36(sp)
800012dc:	5b02                	lw	s6,32(sp)
800012de:	4bf2                	lw	s7,28(sp)
800012e0:	4c62                	lw	s8,24(sp)
800012e2:	4cd2                	lw	s9,20(sp)
800012e4:	4d42                	lw	s10,16(sp)
800012e6:	6121                	addi	sp,sp,64
800012e8:	8082                	ret

800012ea <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
800012ea:	1141                	addi	sp,sp,-16
800012ec:	c606                	sw	ra,12(sp)
800012ee:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
800012f0:	4799                	li	a5,6
800012f2:	02f50263          	beq	a0,a5,80001316 <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
800012f6:	0c8030ef          	jal	ra,800043be <k_is_in_isr>
800012fa:	c10d                	beqz	a0,8000131c <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
800012fc:	0c2030ef          	jal	ra,800043be <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80001300:	e121                	bnez	a0,80001340 <z_SysFatalErrorHandler+0x56>
80001302:	800065b7          	lui	a1,0x80006
80001306:	c5858593          	addi	a1,a1,-936 # 80005c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c59>
8000130a:	80006537          	lui	a0,0x80006
8000130e:	c6c50513          	addi	a0,a0,-916 # 80005c6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c6d>
80001312:	429000ef          	jal	ra,80001f3a <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80001316:	46b000ef          	jal	ra,80001f80 <k_cpu_idle>
8000131a:	bff5                	j	80001316 <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
8000131c:	0b0030ef          	jal	ra,800043cc <z_is_thread_essential>
80001320:	fd71                	bnez	a0,800012fc <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80001322:	80007437          	lui	s0,0x80007
80001326:	8a040413          	addi	s0,s0,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
8000132a:	440c                	lw	a1,8(s0)
8000132c:	80006537          	lui	a0,0x80006
80001330:	c8c50513          	addi	a0,a0,-884 # 80005c8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c8d>
80001334:	407000ef          	jal	ra,80001f3a <printk>
80001338:	4408                	lw	a0,8(s0)
8000133a:	3ae030ef          	jal	ra,800046e8 <z_impl_k_thread_abort>
8000133e:	bfe1                	j	80001316 <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
80001340:	800065b7          	lui	a1,0x80006
80001344:	c5458593          	addi	a1,a1,-940 # 80005c54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c55>
80001348:	b7c9                	j	8000130a <z_SysFatalErrorHandler+0x20>

8000134a <z_NanoFatalErrorHandler>:
{
8000134a:	715d                	addi	sp,sp,-80
8000134c:	c4a2                	sw	s0,72(sp)
8000134e:	c2a6                	sw	s1,68(sp)
80001350:	c686                	sw	ra,76(sp)
	switch (reason) {
80001352:	4799                	li	a5,6
{
80001354:	84aa                	mv	s1,a0
80001356:	842e                	mv	s0,a1
	switch (reason) {
80001358:	08a7e963          	bltu	a5,a0,800013ea <z_NanoFatalErrorHandler+0xa0>
8000135c:	80006737          	lui	a4,0x80006
80001360:	00251793          	slli	a5,a0,0x2
80001364:	9a870713          	addi	a4,a4,-1624 # 800059a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059a9>
80001368:	97ba                	add	a5,a5,a4
8000136a:	439c                	lw	a5,0(a5)
8000136c:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
8000136e:	80006537          	lui	a0,0x80006
80001372:	ad850513          	addi	a0,a0,-1320 # 80005ad8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ad9>
		printk("***** Kernel OOPS! *****\n");
80001376:	3c5000ef          	jal	ra,80001f3a <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000137a:	56b020ef          	jal	ra,800040e4 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
8000137e:	407c                	lw	a5,68(s0)
80001380:	01042883          	lw	a7,16(s0)
80001384:	00c42803          	lw	a6,12(s0)
80001388:	d83e                	sw	a5,48(sp)
8000138a:	403c                	lw	a5,64(s0)
8000138c:	4058                	lw	a4,4(s0)
8000138e:	4014                	lw	a3,0(s0)
80001390:	d63e                	sw	a5,44(sp)
80001392:	5c5c                	lw	a5,60(s0)
80001394:	4430                	lw	a2,72(s0)
80001396:	85aa                	mv	a1,a0
80001398:	d43e                	sw	a5,40(sp)
8000139a:	5c1c                	lw	a5,56(s0)
8000139c:	80006537          	lui	a0,0x80006
800013a0:	b5c50513          	addi	a0,a0,-1188 # 80005b5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b5d>
800013a4:	d23e                	sw	a5,36(sp)
800013a6:	585c                	lw	a5,52(s0)
800013a8:	d03e                	sw	a5,32(sp)
800013aa:	581c                	lw	a5,48(s0)
800013ac:	ce3e                	sw	a5,28(sp)
800013ae:	545c                	lw	a5,44(s0)
800013b0:	cc3e                	sw	a5,24(sp)
800013b2:	541c                	lw	a5,40(s0)
800013b4:	ca3e                	sw	a5,20(sp)
800013b6:	505c                	lw	a5,36(s0)
800013b8:	c83e                	sw	a5,16(sp)
800013ba:	501c                	lw	a5,32(s0)
800013bc:	c63e                	sw	a5,12(sp)
800013be:	4c5c                	lw	a5,28(s0)
800013c0:	c43e                	sw	a5,8(sp)
800013c2:	4c1c                	lw	a5,24(s0)
800013c4:	c23e                	sw	a5,4(sp)
800013c6:	485c                	lw	a5,20(s0)
800013c8:	c03e                	sw	a5,0(sp)
800013ca:	441c                	lw	a5,8(s0)
800013cc:	36f000ef          	jal	ra,80001f3a <printk>
	z_SysFatalErrorHandler(reason, esf);
800013d0:	85a2                	mv	a1,s0
800013d2:	8526                	mv	a0,s1
800013d4:	3f19                	jal	800012ea <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
800013d6:	80006537          	lui	a0,0x80006
800013da:	b0050513          	addi	a0,a0,-1280 # 80005b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b01>
800013de:	bf61                	j	80001376 <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
800013e0:	80006537          	lui	a0,0x80006
800013e4:	b1c50513          	addi	a0,a0,-1252 # 80005b1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b1d>
800013e8:	b779                	j	80001376 <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
800013ea:	80006537          	lui	a0,0x80006
800013ee:	85a6                	mv	a1,s1
800013f0:	b3850513          	addi	a0,a0,-1224 # 80005b38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b39>
800013f4:	347000ef          	jal	ra,80001f3a <printk>
		break;
800013f8:	b749                	j	8000137a <z_NanoFatalErrorHandler+0x30>

800013fa <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
800013fa:	1141                	addi	sp,sp,-16
800013fc:	c422                	sw	s0,8(sp)
800013fe:	c606                	sw	ra,12(sp)
80001400:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001402:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80001406:	0606                	slli	a2,a2,0x1
80001408:	8205                	srli	a2,a2,0x1
	switch (cause) {
8000140a:	4795                	li	a5,5
8000140c:	02c7e363          	bltu	a5,a2,80001432 <_Fault+0x38>
80001410:	80006737          	lui	a4,0x80006
80001414:	00261793          	slli	a5,a2,0x2
80001418:	9c470713          	addi	a4,a4,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
8000141c:	97ba                	add	a5,a5,a4
8000141e:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001420:	80006537          	lui	a0,0x80006
80001424:	9e450513          	addi	a0,a0,-1564 # 800059e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059e5>
80001428:	313000ef          	jal	ra,80001f3a <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
8000142c:	85a2                	mv	a1,s0
8000142e:	4501                	li	a0,0
80001430:	3f29                	jal	8000134a <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001432:	800065b7          	lui	a1,0x80006
80001436:	9dc58593          	addi	a1,a1,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
8000143a:	b7dd                	j	80001420 <_Fault+0x26>

8000143c <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
8000143c:	1141                	addi	sp,sp,-16
8000143e:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001440:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001444:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80001448:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
8000144a:	8185                	srli	a1,a1,0x1
8000144c:	cb450513          	addi	a0,a0,-844 # 80005cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb5>
80001450:	2eb000ef          	jal	ra,80001f3a <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80001454:	800065b7          	lui	a1,0x80006
80001458:	a0058593          	addi	a1,a1,-1536 # 80005a00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a01>
8000145c:	4511                	li	a0,4
8000145e:	35f5                	jal	8000134a <z_NanoFatalErrorHandler>

80001460 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80001460:	800067b7          	lui	a5,0x80006
80001464:	50878793          	addi	a5,a5,1288 # 80006508 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006509>
80001468:	4398                	lw	a4,0(a5)
8000146a:	cb11                	beqz	a4,8000147e <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
8000146c:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80001470:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80001474:	800067b7          	lui	a5,0x80006
80001478:	50c7a503          	lw	a0,1292(a5) # 8000650c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000650d>
8000147c:	8302                	jr	t1
}
8000147e:	8082                	ret

80001480 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80001480:	47a1                	li	a5,8
80001482:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
80001486:	80006737          	lui	a4,0x80006
8000148a:	50a72423          	sw	a0,1288(a4) # 80006508 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006509>
	offload_param = parameter;
8000148e:	80006737          	lui	a4,0x80006
80001492:	50b72623          	sw	a1,1292(a4) # 8000650c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000650d>

	__asm__ volatile ("ecall");
80001496:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
8000149a:	8ba1                	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
8000149c:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
800014a0:	8082                	ret

800014a2 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
800014a2:	1141                	addi	sp,sp,-16
800014a4:	c606                	sw	ra,12(sp)
	z_bss_zero();
800014a6:	2e2010ef          	jal	ra,80002788 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
800014aa:	2ef000ef          	jal	ra,80001f98 <soc_interrupt_init>
#endif
	z_cstart();
800014ae:	32e010ef          	jal	ra,800027dc <z_cstart>

800014b2 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
800014b2:	7179                	addi	sp,sp,-48
800014b4:	d422                	sw	s0,40(sp)
800014b6:	d226                	sw	s1,36(sp)
800014b8:	d04a                	sw	s2,32(sp)
800014ba:	ce4e                	sw	s3,28(sp)
800014bc:	cc52                	sw	s4,24(sp)
800014be:	ca56                	sw	s5,20(sp)
800014c0:	c85a                	sw	s6,16(sp)
800014c2:	c65e                	sw	s7,12(sp)
800014c4:	8b3e                	mv	s6,a5
800014c6:	d606                	sw	ra,44(sp)
800014c8:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800014ca:	47bd                	li	a5,15
{
800014cc:	84aa                	mv	s1,a0
800014ce:	842e                	mv	s0,a1
800014d0:	89b2                	mv	s3,a2
800014d2:	8a36                	mv	s4,a3
800014d4:	8bba                	mv	s7,a4
800014d6:	8ac2                	mv	s5,a6
800014d8:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800014da:	06f89463          	bne	a7,a5,80001542 <z_new_thread+0x90>
800014de:	800027b7          	lui	a5,0x80002
800014e2:	76278793          	addi	a5,a5,1890 # 80002762 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002763>
800014e6:	06f69363          	bne	a3,a5,8000154c <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
800014ea:	56c2                	lw	a3,48(sp)
800014ec:	85ca                	mv	a1,s2
800014ee:	8526                	mv	a0,s1
800014f0:	4611                	li	a2,4
800014f2:	759020ef          	jal	ra,8000444a <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
800014f6:	fb098593          	addi	a1,s3,-80
800014fa:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800014fc:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
800014fe:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001502:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80001506:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001508:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
8000150c:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
8000150e:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80001512:	50b2                	lw	ra,44(sp)
80001514:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001516:	9ac78793          	addi	a5,a5,-1620 # 800009ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009ad>
	stack_init->a0 = (u32_t)thread_func;
8000151a:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
8000151e:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80001522:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80001526:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
8000152a:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
8000152c:	d48c                	sw	a1,40(s1)
}
8000152e:	5902                	lw	s2,32(sp)
80001530:	5492                	lw	s1,36(sp)
80001532:	49f2                	lw	s3,28(sp)
80001534:	4a62                	lw	s4,24(sp)
80001536:	4ad2                	lw	s5,20(sp)
80001538:	4b42                	lw	s6,16(sp)
8000153a:	4bb2                	lw	s7,12(sp)
8000153c:	4c22                	lw	s8,8(sp)
8000153e:	6145                	addi	sp,sp,48
80001540:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001542:	01088693          	addi	a3,a7,16
80001546:	47f9                	li	a5,30
80001548:	fad7f1e3          	bgeu	a5,a3,800014ea <z_new_thread+0x38>
8000154c:	80006c37          	lui	s8,0x80006
80001550:	800065b7          	lui	a1,0x80006
80001554:	80006537          	lui	a0,0x80006
80001558:	cdcc0613          	addi	a2,s8,-804 # 80005cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cdd>
8000155c:	46e1                	li	a3,24
8000155e:	cfc58593          	addi	a1,a1,-772 # 80005cfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cfd>
80001562:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80001566:	1d5000ef          	jal	ra,80001f3a <printk>
8000156a:	80006537          	lui	a0,0x80006
8000156e:	85ca                	mv	a1,s2
80001570:	56c1                	li	a3,-16
80001572:	4639                	li	a2,14
80001574:	da850513          	addi	a0,a0,-600 # 80005da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da9>
80001578:	1c3000ef          	jal	ra,80001f3a <printk>
8000157c:	45e1                	li	a1,24
8000157e:	cdcc0513          	addi	a0,s8,-804
80001582:	1d7000ef          	jal	ra,80001f58 <assert_post_action>
80001586:	b795                	j	800014ea <z_new_thread+0x38>

80001588 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001588:	00159793          	slli	a5,a1,0x1
8000158c:	97ae                	add	a5,a5,a1
8000158e:	00279713          	slli	a4,a5,0x2
80001592:	455c                	lw	a5,12(a0)
80001594:	97ba                	add	a5,a5,a4
80001596:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
8000159a:	00b75363          	bge	a4,a1,800015a0 <get_bit_ptr+0x18>
8000159e:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
800015a0:	41f65713          	srai	a4,a2,0x1f
800015a4:	8b7d                	andi	a4,a4,31
800015a6:	9732                	add	a4,a4,a2
800015a8:	8715                	srai	a4,a4,0x5
800015aa:	070a                	slli	a4,a4,0x2
800015ac:	97ba                	add	a5,a5,a4
800015ae:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
800015b0:	01f67513          	andi	a0,a2,31
800015b4:	8082                	ret

800015b6 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800015b6:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800015b8:	0074                	addi	a3,sp,12
{
800015ba:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800015bc:	37f1                	jal	80001588 <get_bit_ptr>

	*word |= (1<<bit);
800015be:	4732                	lw	a4,12(sp)
800015c0:	4785                	li	a5,1
800015c2:	00a79533          	sll	a0,a5,a0
800015c6:	431c                	lw	a5,0(a4)
}
800015c8:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
800015ca:	8fc9                	or	a5,a5,a0
800015cc:	c31c                	sw	a5,0(a4)
}
800015ce:	6105                	addi	sp,sp,32
800015d0:	8082                	ret

800015d2 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800015d2:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800015d4:	0074                	addi	a3,sp,12
{
800015d6:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800015d8:	3f45                	jal	80001588 <get_bit_ptr>

	*word &= ~(1<<bit);
800015da:	4732                	lw	a4,12(sp)
800015dc:	4785                	li	a5,1
800015de:	00a79533          	sll	a0,a5,a0
800015e2:	431c                	lw	a5,0(a4)
}
800015e4:	40f2                	lw	ra,28(sp)
	*word &= ~(1<<bit);
800015e6:	fff54513          	not	a0,a0
800015ea:	8d7d                	and	a0,a0,a5
800015ec:	c308                	sw	a0,0(a4)
}
800015ee:	6105                	addi	sp,sp,32
800015f0:	8082                	ret

800015f2 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
800015f2:	1101                	addi	sp,sp,-32
800015f4:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800015f6:	4144                	lw	s1,4(a0)
{
800015f8:	cc22                	sw	s0,24(sp)
800015fa:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800015fc:	00855503          	lhu	a0,8(a0)
80001600:	85a6                	mv	a1,s1
{
80001602:	c84a                	sw	s2,16(sp)
80001604:	c64e                	sw	s3,12(sp)
80001606:	c452                	sw	s4,8(sp)
80001608:	c256                	sw	s5,4(sp)
8000160a:	c05a                	sw	s6,0(sp)
8000160c:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000160e:	a1eff0ef          	jal	ra,8000082c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001612:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001616:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
8000161a:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000161c:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
8000161e:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
80001620:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001624:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80001626:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80001628:	03594163          	blt	s2,s5,8000164a <z_sys_mem_pool_base_init+0x58>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
8000162c:	4481                	li	s1,0
8000162e:	00845783          	lhu	a5,8(s0)
80001632:	04f4cf63          	blt	s1,a5,80001690 <z_sys_mem_pool_base_init+0x9e>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001636:	40f2                	lw	ra,28(sp)
80001638:	4462                	lw	s0,24(sp)
8000163a:	44d2                	lw	s1,20(sp)
8000163c:	4942                	lw	s2,16(sp)
8000163e:	49b2                	lw	s3,12(sp)
80001640:	4a22                	lw	s4,8(sp)
80001642:	4a92                	lw	s5,4(sp)
80001644:	4b02                	lw	s6,0(sp)
80001646:	6105                	addi	sp,sp,32
80001648:	8082                	ret
		int nblocks = buflen / sz;
8000164a:	85a6                	mv	a1,s1
8000164c:	8552                	mv	a0,s4
8000164e:	a9aff0ef          	jal	ra,800008e8 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80001652:	00191713          	slli	a4,s2,0x1
80001656:	974a                	add	a4,a4,s2
80001658:	00271793          	slli	a5,a4,0x2
8000165c:	4458                	lw	a4,12(s0)
8000165e:	973e                	add	a4,a4,a5
80001660:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001664:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001666:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
80001668:	00ab4963          	blt	s6,a0,8000167a <z_sys_mem_pool_base_init+0x88>
			p->max_inline_level = i;
8000166c:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
80001670:	8089                	srli	s1,s1,0x2
80001672:	048d                	addi	s1,s1,3
80001674:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
80001676:	0905                	addi	s2,s2,1
80001678:	bf45                	j	80001628 <z_sys_mem_pool_base_init+0x36>
			bits += (nblocks + 31)/32;
8000167a:	057d                	addi	a0,a0,31
8000167c:	41f55793          	srai	a5,a0,0x1f
80001680:	8bfd                	andi	a5,a5,31
80001682:	97aa                	add	a5,a5,a0
80001684:	8795                	srai	a5,a5,0x5
80001686:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80001688:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
8000168c:	99be                	add	s3,s3,a5
8000168e:	b7cd                	j	80001670 <z_sys_mem_pool_base_init+0x7e>
	return (u8_t *)p->buf + lsz * block;
80001690:	404c                	lw	a1,4(s0)
80001692:	8526                	mv	a0,s1
80001694:	998ff0ef          	jal	ra,8000082c <__mulsi3>
80001698:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
8000169a:	8626                	mv	a2,s1
8000169c:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
8000169e:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
800016a0:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
800016a2:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
800016a4:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
800016a8:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
800016aa:	4798                	lw	a4,8(a5)
800016ac:	c158                	sw	a4,4(a0)

	list->tail->next = node;
800016ae:	4798                	lw	a4,8(a5)
800016b0:	c308                	sw	a0,0(a4)
	list->tail = node;
800016b2:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
800016b4:	8522                	mv	a0,s0
800016b6:	3701                	jal	800015b6 <set_free_bit>
800016b8:	bf9d                	j	8000162e <z_sys_mem_pool_base_init+0x3c>

800016ba <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
800016ba:	711d                	addi	sp,sp,-96
800016bc:	cca2                	sw	s0,88(sp)
800016be:	c2d6                	sw	s5,68(sp)
800016c0:	ce86                	sw	ra,92(sp)
800016c2:	caa6                	sw	s1,84(sp)
800016c4:	c8ca                	sw	s2,80(sp)
800016c6:	c6ce                	sw	s3,76(sp)
800016c8:	c4d2                	sw	s4,72(sp)
800016ca:	c0da                	sw	s6,64(sp)
800016cc:	de5e                	sw	s7,60(sp)
800016ce:	dc62                	sw	s8,56(sp)
800016d0:	da66                	sw	s9,52(sp)
800016d2:	d86a                	sw	s10,48(sp)
800016d4:	d66e                	sw	s11,44(sp)
800016d6:	1080                	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800016d8:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
800016dc:	4881                	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800016de:	002e1793          	slli	a5,t3,0x2
800016e2:	07bd                	addi	a5,a5,15
800016e4:	7f07f793          	andi	a5,a5,2032
800016e8:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
800016ec:	415c                	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800016ee:	8a8a                	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800016f0:	8356                	mv	t1,s5
800016f2:	078d                	addi	a5,a5,3
800016f4:	9bf1                	andi	a5,a5,-4
800016f6:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
800016fa:	fff88b13          	addi	s6,a7,-1
800016fe:	03c8d263          	bge	a7,t3,80001722 <z_sys_mem_pool_block_alloc+0x68>
		if (i > 0) {
80001702:	00088b63          	beqz	a7,80001718 <z_sys_mem_pool_block_alloc+0x5e>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001706:	ffc32803          	lw	a6,-4(t1) # 7ffffffc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x7ffffffd>
8000170a:	00285813          	srli	a6,a6,0x2
8000170e:	080d                	addi	a6,a6,3
80001710:	ffc87813          	andi	a6,a6,-4
80001714:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
80001718:	0311                	addi	t1,t1,4
8000171a:	ffc32803          	lw	a6,-4(t1)
8000171e:	02b87963          	bgeu	a6,a1,80001750 <z_sys_mem_pool_block_alloc+0x96>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80001722:	55fd                	li	a1,-1
80001724:	02bb1863          	bne	s6,a1,80001754 <z_sys_mem_pool_block_alloc+0x9a>
		*data_p = NULL;
80001728:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
8000172c:	5551                	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
8000172e:	fa040113          	addi	sp,s0,-96
80001732:	40f6                	lw	ra,92(sp)
80001734:	4466                	lw	s0,88(sp)
80001736:	44d6                	lw	s1,84(sp)
80001738:	4946                	lw	s2,80(sp)
8000173a:	49b6                	lw	s3,76(sp)
8000173c:	4a26                	lw	s4,72(sp)
8000173e:	4a96                	lw	s5,68(sp)
80001740:	4b06                	lw	s6,64(sp)
80001742:	5bf2                	lw	s7,60(sp)
80001744:	5c62                	lw	s8,56(sp)
80001746:	5cd2                	lw	s9,52(sp)
80001748:	5d42                	lw	s10,48(sp)
8000174a:	5db2                	lw	s11,44(sp)
8000174c:	6125                	addi	sp,sp,96
8000174e:	8082                	ret
	for (i = 0; i < p->n_levels; i++) {
80001750:	0885                	addi	a7,a7,1
80001752:	b765                	j	800016fa <z_sys_mem_pool_block_alloc+0x40>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001754:	01054583          	lbu	a1,16(a0)
		return 0;
80001758:	4901                	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000175a:	8985                	andi	a1,a1,1
8000175c:	c591                	beqz	a1,80001768 <z_sys_mem_pool_block_alloc+0xae>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000175e:	4921                	li	s2,8
80001760:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80001764:	00897913          	andi	s2,s2,8
80001768:	fae42a23          	sw	a4,-76(s0)
8000176c:	001b1713          	slli	a4,s6,0x1
80001770:	fad42c23          	sw	a3,-72(s0)
80001774:	975a                	add	a4,a4,s6
80001776:	4554                	lw	a3,12(a0)
80001778:	070a                	slli	a4,a4,0x2
8000177a:	0711                	addi	a4,a4,4
8000177c:	9736                	add	a4,a4,a3
8000177e:	fac42e23          	sw	a2,-68(s0)
80001782:	84aa                	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80001784:	8a5a                	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
80001786:	56fd                	li	a3,-1
	return list->head == list;
80001788:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
8000178c:	13370863          	beq	a4,s3,800018bc <z_sys_mem_pool_block_alloc+0x202>
		data = block_alloc(p, i, lsizes[i]);
80001790:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
80001794:	0049a683          	lw	a3,4(s3)
80001798:	00ea8cb3          	add	s9,s5,a4
8000179c:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800017a0:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800017a4:	4d21                	li	s10,8
800017a6:	c298                	sw	a4,0(a3)
	node->next->prev = node->prev;
800017a8:	c354                	sw	a3,4(a4)
	node->next = NULL;
800017aa:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
800017ae:	0009a223          	sw	zero,4(s3)
800017b2:	4088                	lw	a0,0(s1)
800017b4:	40a98533          	sub	a0,s3,a0
800017b8:	928ff0ef          	jal	ra,800008e0 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
800017bc:	862a                	mv	a2,a0
800017be:	85d2                	mv	a1,s4
800017c0:	8526                	mv	a0,s1
800017c2:	3d01                	jal	800015d2 <clear_free_bit>
		if (data != NULL) {
800017c4:	0a05                	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
800017c6:	fffa0693          	addi	a3,s4,-1
800017ca:	0566c263          	blt	a3,s6,8000180e <z_sys_mem_pool_block_alloc+0x154>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800017ce:	0104c703          	lbu	a4,16(s1)
800017d2:	8b05                	andi	a4,a4,1
800017d4:	c319                	beqz	a4,800017da <z_sys_mem_pool_block_alloc+0x120>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800017d6:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
800017da:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
800017de:	5551                	li	a0,-12
	*data_p = data;
800017e0:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
800017e4:	f40985e3          	beqz	s3,8000172e <z_sys_mem_pool_block_alloc+0x74>
	*level_p = alloc_l;
800017e8:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800017ec:	4088                	lw	a0,0(s1)
	*level_p = alloc_l;
800017ee:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
800017f2:	002b1793          	slli	a5,s6,0x2
800017f6:	9abe                	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800017f8:	000aa583          	lw	a1,0(s5)
800017fc:	40a98533          	sub	a0,s3,a0
80001800:	8e0ff0ef          	jal	ra,800008e0 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001804:	fb842783          	lw	a5,-72(s0)
80001808:	c388                	sw	a0,0(a5)
	return 0;
8000180a:	4501                	li	a0,0
8000180c:	b70d                	j	8000172e <z_sys_mem_pool_block_alloc+0x74>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000180e:	4088                	lw	a0,0(s1)
80001810:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
80001814:	4b85                	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001816:	40a98533          	sub	a0,s3,a0
8000181a:	8c6ff0ef          	jal	ra,800008e0 <__divsi3>
8000181e:	001a1893          	slli	a7,s4,0x1
80001822:	98d2                	add	a7,a7,s4
		int lbn = 4*bn + i;
80001824:	00251d93          	slli	s11,a0,0x2
80001828:	088a                	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
8000182a:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
8000182e:	85de                	mv	a1,s7
80001830:	fb142623          	sw	a7,-84(s0)
80001834:	8536                	mv	a0,a3
80001836:	fad42823          	sw	a3,-80(s0)
8000183a:	ff3fe0ef          	jal	ra,8000082c <__mulsi3>
8000183e:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
80001842:	01bb8633          	add	a2,s7,s11
80001846:	85d2                	mv	a1,s4
80001848:	8526                	mv	a0,s1
8000184a:	33b5                	jal	800015b6 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000184c:	fb042683          	lw	a3,-80(s0)
80001850:	4090                	lw	a2,0(s1)
	return p->n_max * p->max_sz;
80001852:	40cc                	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001854:	16fd                	addi	a3,a3,-1
	return p->n_max * p->max_sz;
80001856:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000185a:	96e2                	add	a3,a3,s8
8000185c:	8e91                	sub	a3,a3,a2
8000185e:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
80001862:	fcbfe0ef          	jal	ra,8000082c <__mulsi3>
		if (block_fits(p, block2, lsz)) {
80001866:	fb042683          	lw	a3,-80(s0)
8000186a:	fac42883          	lw	a7,-84(s0)
8000186e:	02a6f063          	bgeu	a3,a0,8000188e <z_sys_mem_pool_block_alloc+0x1d4>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001872:	44d4                	lw	a3,12(s1)
80001874:	96c6                	add	a3,a3,a7
80001876:	00468613          	addi	a2,a3,4
	node->next = list;
8000187a:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
8000187e:	4690                	lw	a2,8(a3)
80001880:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
80001884:	4690                	lw	a2,8(a3)
80001886:	01862023          	sw	s8,0(a2)
	list->tail = node;
8000188a:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
8000188e:	0b85                	addi	s7,s7,1
80001890:	4791                	li	a5,4
80001892:	f8fb9ce3          	bne	s7,a5,8000182a <z_sys_mem_pool_block_alloc+0x170>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001896:	0104c683          	lbu	a3,16(s1)
8000189a:	8a85                	andi	a3,a3,1
8000189c:	e689                	bnez	a3,800018a6 <z_sys_mem_pool_block_alloc+0x1ec>
		return 0;
8000189e:	4901                	li	s2,0
800018a0:	0a05                	addi	s4,s4,1
800018a2:	0c91                	addi	s9,s9,4
800018a4:	b70d                	j	800017c6 <z_sys_mem_pool_block_alloc+0x10c>
800018a6:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800018aa:	0104c683          	lbu	a3,16(s1)
800018ae:	8a85                	andi	a3,a3,1
800018b0:	d6fd                	beqz	a3,8000189e <z_sys_mem_pool_block_alloc+0x1e4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800018b2:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
800018b6:	00897913          	andi	s2,s2,8
800018ba:	b7dd                	j	800018a0 <z_sys_mem_pool_block_alloc+0x1e6>
	for (i = alloc_l; i >= 0; i--) {
800018bc:	1a7d                	addi	s4,s4,-1
800018be:	ff498713          	addi	a4,s3,-12
800018c2:	ecda13e3          	bne	s4,a3,80001788 <z_sys_mem_pool_block_alloc+0xce>
800018c6:	4981                	li	s3,0
800018c8:	b719                	j	800017ce <z_sys_mem_pool_block_alloc+0x114>

800018ca <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
800018ca:	711d                	addi	sp,sp,-96
800018cc:	cca2                	sw	s0,88(sp)
800018ce:	c4d2                	sw	s4,72(sp)
800018d0:	da66                	sw	s9,52(sp)
800018d2:	ce86                	sw	ra,92(sp)
800018d4:	caa6                	sw	s1,84(sp)
800018d6:	c8ca                	sw	s2,80(sp)
800018d8:	c6ce                	sw	s3,76(sp)
800018da:	c2d6                	sw	s5,68(sp)
800018dc:	c0da                	sw	s6,64(sp)
800018de:	de5e                	sw	s7,60(sp)
800018e0:	dc62                	sw	s8,56(sp)
800018e2:	d86a                	sw	s10,48(sp)
800018e4:	d66e                	sw	s11,44(sp)
800018e6:	1080                	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800018e8:	00a54703          	lbu	a4,10(a0)
{
800018ec:	8caa                	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800018ee:	070a                	slli	a4,a4,0x2
800018f0:	073d                	addi	a4,a4,15
800018f2:	7f077713          	andi	a4,a4,2032
800018f6:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
800018fa:	4158                	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800018fc:	8a0a                	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800018fe:	86d2                	mv	a3,s4
80001900:	070d                	addi	a4,a4,3
80001902:	9b71                	andi	a4,a4,-4
80001904:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80001908:	4505                	li	a0,1
8000190a:	0691                	addi	a3,a3,4
8000190c:	08a5f363          	bgeu	a1,a0,80001992 <z_sys_mem_pool_block_free+0xc8>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001910:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001914:	892e                	mv	s2,a1
80001916:	89b2                	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001918:	8b05                	andi	a4,a4,1
		return 0;
8000191a:	4481                	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000191c:	c709                	beqz	a4,80001926 <z_sys_mem_pool_block_free+0x5c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000191e:	44a1                	li	s1,8
80001920:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80001924:	88a1                	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80001926:	80006b37          	lui	s6,0x80006
	while (level >= 0) {
8000192a:	06095c63          	bgez	s2,800019a2 <z_sys_mem_pool_block_free+0xd8>
	__ASSERT(0, "out of levels");
8000192e:	800064b7          	lui	s1,0x80006
80001932:	800065b7          	lui	a1,0x80006
80001936:	80006537          	lui	a0,0x80006
8000193a:	ddc48613          	addi	a2,s1,-548 # 80005ddc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ddd>
8000193e:	0c000693          	li	a3,192
80001942:	e4458593          	addi	a1,a1,-444 # 80005e44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e45>
80001946:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000194a:	2bc5                	jal	80001f3a <printk>
8000194c:	80006537          	lui	a0,0x80006
80001950:	e1050513          	addi	a0,a0,-496 # 80005e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e11>
80001954:	23dd                	jal	80001f3a <printk>
80001956:	ddc48513          	addi	a0,s1,-548
8000195a:	0c000593          	li	a1,192
8000195e:	2bed                	jal	80001f58 <assert_post_action>
	return -1;
80001960:	54fd                	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001962:	010cc783          	lbu	a5,16(s9)
80001966:	8b85                	andi	a5,a5,1
80001968:	c781                	beqz	a5,80001970 <z_sys_mem_pool_block_free+0xa6>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
8000196a:	88a1                	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000196c:	3004a4f3          	csrrs	s1,mstatus,s1
}
80001970:	fa040113          	addi	sp,s0,-96
80001974:	40f6                	lw	ra,92(sp)
80001976:	4466                	lw	s0,88(sp)
80001978:	44d6                	lw	s1,84(sp)
8000197a:	4946                	lw	s2,80(sp)
8000197c:	49b6                	lw	s3,76(sp)
8000197e:	4a26                	lw	s4,72(sp)
80001980:	4a96                	lw	s5,68(sp)
80001982:	4b06                	lw	s6,64(sp)
80001984:	5bf2                	lw	s7,60(sp)
80001986:	5c62                	lw	s8,56(sp)
80001988:	5cd2                	lw	s9,52(sp)
8000198a:	5d42                	lw	s10,48(sp)
8000198c:	5db2                	lw	s11,44(sp)
8000198e:	6125                	addi	sp,sp,96
80001990:	8082                	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001992:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80001996:	0505                	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001998:	8309                	srli	a4,a4,0x2
8000199a:	070d                	addi	a4,a4,3
8000199c:	9b71                	andi	a4,a4,-4
8000199e:	c298                	sw	a4,0(a3)
800019a0:	b7ad                	j	8000190a <z_sys_mem_pool_block_free+0x40>
		int i, lsz = lsizes[level];
800019a2:	00291713          	slli	a4,s2,0x2
800019a6:	9752                	add	a4,a4,s4
800019a8:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
800019ac:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
800019b0:	854e                	mv	a0,s3
800019b2:	85d6                	mv	a1,s5
800019b4:	e79fe0ef          	jal	ra,8000082c <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800019b8:	fffa8b93          	addi	s7,s5,-1
800019bc:	01750d33          	add	s10,a0,s7
800019c0:	9c2a                	add	s8,s8,a0
	return p->n_max * p->max_sz;
800019c2:	004ca583          	lw	a1,4(s9)
800019c6:	008cd503          	lhu	a0,8(s9)
800019ca:	e63fe0ef          	jal	ra,8000082c <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
800019ce:	02ad6963          	bltu	s10,a0,80001a00 <z_sys_mem_pool_block_free+0x136>
800019d2:	800067b7          	lui	a5,0x80006
800019d6:	df078593          	addi	a1,a5,-528 # 80005df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005df1>
800019da:	800067b7          	lui	a5,0x80006
800019de:	d8878513          	addi	a0,a5,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800019e2:	0a400693          	li	a3,164
800019e6:	ddcb0613          	addi	a2,s6,-548 # 80005ddc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ddd>
800019ea:	2b81                	jal	80001f3a <printk>
800019ec:	800067b7          	lui	a5,0x80006
800019f0:	e0c78513          	addi	a0,a5,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
800019f4:	2399                	jal	80001f3a <printk>
800019f6:	0a400593          	li	a1,164
800019fa:	ddcb0513          	addi	a0,s6,-548
800019fe:	2ba9                	jal	80001f58 <assert_post_action>
		set_free_bit(p, level, bn);
80001a00:	864e                	mv	a2,s3
80001a02:	85ca                	mv	a1,s2
80001a04:	8566                	mv	a0,s9
80001a06:	3e45                	jal	800015b6 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80001a08:	00191713          	slli	a4,s2,0x1
80001a0c:	974a                	add	a4,a4,s2
80001a0e:	00271693          	slli	a3,a4,0x2
80001a12:	00cca703          	lw	a4,12(s9)
80001a16:	9736                	add	a4,a4,a3
80001a18:	00470693          	addi	a3,a4,4
	node->next = list;
80001a1c:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
80001a20:	4714                	lw	a3,8(a4)
80001a22:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
80001a26:	4714                	lw	a3,8(a4)
80001a28:	0186a023          	sw	s8,0(a3)
	list->tail = node;
80001a2c:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001a30:	010cc703          	lbu	a4,16(s9)
80001a34:	8b05                	andi	a4,a4,1
80001a36:	e34d                	bnez	a4,80001ad8 <z_sys_mem_pool_block_free+0x20e>
		return 0;
80001a38:	4481                	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001a3a:	f20904e3          	beqz	s2,80001962 <z_sys_mem_pool_block_free+0x98>
	int bit = get_bit_ptr(p, level, bn, &word);
80001a3e:	fbc40693          	addi	a3,s0,-68
80001a42:	864e                	mv	a2,s3
80001a44:	85ca                	mv	a1,s2
80001a46:	8566                	mv	a0,s9
80001a48:	3681                	jal	80001588 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80001a4a:	fbc42683          	lw	a3,-68(s0)
80001a4e:	41f55713          	srai	a4,a0,0x1f
80001a52:	8b0d                	andi	a4,a4,3
80001a54:	972a                	add	a4,a4,a0
80001a56:	4288                	lw	a0,0(a3)
80001a58:	9b71                	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001a5a:	47bd                	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
80001a5c:	00e55733          	srl	a4,a0,a4
80001a60:	8b3d                	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001a62:	f0f710e3          	bne	a4,a5,80001962 <z_sys_mem_pool_block_free+0x98>
		for (i = 0; i < 4; i++) {
80001a66:	4d01                	li	s10,0
			int b = (bn & ~3) + i;
80001a68:	ffc9fd93          	andi	s11,s3,-4
80001a6c:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
80001a70:	8532                	mv	a0,a2
80001a72:	85d6                	mv	a1,s5
80001a74:	fac42423          	sw	a2,-88(s0)
80001a78:	db5fe0ef          	jal	ra,8000082c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001a7c:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80001a80:	8c2a                	mv	s8,a0
	return p->n_max * p->max_sz;
80001a82:	004ca583          	lw	a1,4(s9)
80001a86:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001a8a:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001a8e:	d9ffe0ef          	jal	ra,8000082c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001a92:	fac42703          	lw	a4,-84(s0)
80001a96:	fa842603          	lw	a2,-88(s0)
80001a9a:	02a77363          	bgeu	a4,a0,80001ac0 <z_sys_mem_pool_block_free+0x1f6>
				clear_free_bit(p, level, b);
80001a9e:	85ca                	mv	a1,s2
80001aa0:	8566                	mv	a0,s9
80001aa2:	b31ff0ef          	jal	ra,800015d2 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001aa6:	000ca703          	lw	a4,0(s9)
80001aaa:	9c3a                	add	s8,s8,a4
	node->prev->next = node->next;
80001aac:	004c2603          	lw	a2,4(s8)
80001ab0:	000c2703          	lw	a4,0(s8)
80001ab4:	c218                	sw	a4,0(a2)
	node->next->prev = node->prev;
80001ab6:	c350                	sw	a2,4(a4)
	node->next = NULL;
80001ab8:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001abc:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001ac0:	0d05                	addi	s10,s10,1
80001ac2:	4791                	li	a5,4
80001ac4:	fafd14e3          	bne	s10,a5,80001a6c <z_sys_mem_pool_block_free+0x1a2>
		bn = bn / 4;
80001ac8:	41f9d613          	srai	a2,s3,0x1f
80001acc:	8a0d                	andi	a2,a2,3
80001ace:	99b2                	add	s3,s3,a2
		level = level - 1;
80001ad0:	197d                	addi	s2,s2,-1
		bn = bn / 4;
80001ad2:	4029d993          	srai	s3,s3,0x2
80001ad6:	bd91                	j	8000192a <z_sys_mem_pool_block_free+0x60>
80001ad8:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001adc:	010cc703          	lbu	a4,16(s9)
80001ae0:	8b05                	andi	a4,a4,1
80001ae2:	db39                	beqz	a4,80001a38 <z_sys_mem_pool_block_free+0x16e>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001ae4:	47a1                	li	a5,8
80001ae6:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
80001aea:	88a1                	andi	s1,s1,8
80001aec:	b7b9                	j	80001a3a <z_sys_mem_pool_block_free+0x170>

80001aee <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001aee:	1141                	addi	sp,sp,-16
80001af0:	87aa                	mv	a5,a0
80001af2:	852e                	mv	a0,a1
80001af4:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
80001af6:	8636                	mv	a2,a3
{
80001af8:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
80001afa:	9782                	jalr	a5
80001afc:	5e8020ef          	jal	ra,800040e4 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001b00:	3e9020ef          	jal	ra,800046e8 <z_impl_k_thread_abort>

80001b04 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001b04:	4501                	li	a0,0
80001b06:	8082                	ret

80001b08 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001b08:	1141                	addi	sp,sp,-16
80001b0a:	c422                	sw	s0,8(sp)
80001b0c:	842a                	mv	s0,a0
	out('E', ctx);
80001b0e:	04500513          	li	a0,69
{
80001b12:	c606                	sw	ra,12(sp)
80001b14:	c226                	sw	s1,4(sp)
80001b16:	84ae                	mv	s1,a1
	out('E', ctx);
80001b18:	9402                	jalr	s0
	out('R', ctx);
80001b1a:	85a6                	mv	a1,s1
80001b1c:	05200513          	li	a0,82
80001b20:	9402                	jalr	s0
	out('R', ctx);
80001b22:	8322                	mv	t1,s0
}
80001b24:	4422                	lw	s0,8(sp)
80001b26:	40b2                	lw	ra,12(sp)
	out('R', ctx);
80001b28:	85a6                	mv	a1,s1
}
80001b2a:	4492                	lw	s1,4(sp)
	out('R', ctx);
80001b2c:	05200513          	li	a0,82
}
80001b30:	0141                	addi	sp,sp,16
	out('R', ctx);
80001b32:	8302                	jr	t1

80001b34 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001b34:	419c                	lw	a5,0(a1)
80001b36:	0785                	addi	a5,a5,1
80001b38:	c19c                	sw	a5,0(a1)
	return _char_out(c);
80001b3a:	800067b7          	lui	a5,0x80006
80001b3e:	4707a303          	lw	t1,1136(a5) # 80006470 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006471>
80001b42:	8302                	jr	t1

80001b44 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001b44:	7139                	addi	sp,sp,-64
80001b46:	dc22                	sw	s0,56(sp)
80001b48:	d64e                	sw	s3,44(sp)
80001b4a:	d452                	sw	s4,40(sp)
80001b4c:	d05a                	sw	s6,32(sp)
80001b4e:	c86a                	sw	s10,16(sp)
80001b50:	de06                	sw	ra,60(sp)
80001b52:	da26                	sw	s1,52(sp)
80001b54:	d84a                	sw	s2,48(sp)
80001b56:	d256                	sw	s5,36(sp)
80001b58:	ce5e                	sw	s7,28(sp)
80001b5a:	cc62                	sw	s8,24(sp)
80001b5c:	ca66                	sw	s9,20(sp)
80001b5e:	c66e                	sw	s11,12(sp)
80001b60:	89aa                	mv	s3,a0
80001b62:	8a2e                	mv	s4,a1
80001b64:	8d32                	mv	s10,a2
80001b66:	8b36                	mv	s6,a3
80001b68:	4405                	li	s0,1
80001b6a:	00e05363          	blez	a4,80001b70 <_printk_dec_ulong+0x2c>
80001b6e:	843a                	mv	s0,a4
80001b70:	4785                	li	a5,1
80001b72:	02000c93          	li	s9,32
80001b76:	00fb1463          	bne	s6,a5,80001b7e <_printk_dec_ulong+0x3a>
80001b7a:	03000c93          	li	s9,48
80001b7e:	3b9ad4b7          	lui	s1,0x3b9ad
80001b82:	4905                	li	s2,1
80001b84:	4aa9                	li	s5,10
80001b86:	4c01                	li	s8,0
80001b88:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001b8c:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001b8e:	00148b93          	addi	s7,s1,1
80001b92:	000c1463          	bnez	s8,80001b9a <_printk_dec_ulong+0x56>
80001b96:	07a4f263          	bgeu	s1,s10,80001bfa <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001b9a:	85de                	mv	a1,s7
80001b9c:	856a                	mv	a0,s10
80001b9e:	d4bfe0ef          	jal	ra,800008e8 <__udivsi3>
80001ba2:	85d2                	mv	a1,s4
80001ba4:	03050513          	addi	a0,a0,48
80001ba8:	9982                	jalr	s3
			digits++;
80001baa:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
80001bac:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001bae:	85de                	mv	a1,s7
80001bb0:	856a                	mv	a0,s10
80001bb2:	d7ffe0ef          	jal	ra,80000930 <__umodsi3>
80001bb6:	8d2a                	mv	s10,a0
		pos /= 10;
80001bb8:	45a9                	li	a1,10
80001bba:	8526                	mv	a0,s1
80001bbc:	d2dfe0ef          	jal	ra,800008e8 <__udivsi3>
		remaining--;
80001bc0:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
80001bc2:	4785                	li	a5,1
		pos /= 10;
80001bc4:	84aa                	mv	s1,a0
	while (pos >= 9) {
80001bc6:	fcfa94e3          	bne	s5,a5,80001b8e <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
80001bca:	85d2                	mv	a1,s4
80001bcc:	030d0513          	addi	a0,s10,48
80001bd0:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001bd2:	478d                	li	a5,3
		remaining = min_width - digits;
80001bd4:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001bd8:	02fb0f63          	beq	s6,a5,80001c16 <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001bdc:	50f2                	lw	ra,60(sp)
80001bde:	5462                	lw	s0,56(sp)
80001be0:	54d2                	lw	s1,52(sp)
80001be2:	5942                	lw	s2,48(sp)
80001be4:	59b2                	lw	s3,44(sp)
80001be6:	5a22                	lw	s4,40(sp)
80001be8:	5a92                	lw	s5,36(sp)
80001bea:	5b02                	lw	s6,32(sp)
80001bec:	4bf2                	lw	s7,28(sp)
80001bee:	4c62                	lw	s8,24(sp)
80001bf0:	4cd2                	lw	s9,20(sp)
80001bf2:	4d42                	lw	s10,16(sp)
80001bf4:	4db2                	lw	s11,12(sp)
80001bf6:	6121                	addi	sp,sp,64
80001bf8:	8082                	ret
		} else if (remaining <= min_width
80001bfa:	fb544ae3          	blt	s0,s5,80001bae <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
80001bfe:	fb6de8e3          	bltu	s11,s6,80001bae <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001c02:	85d2                	mv	a1,s4
80001c04:	8566                	mv	a0,s9
80001c06:	9982                	jalr	s3
			digits++;
80001c08:	0905                	addi	s2,s2,1
80001c0a:	b755                	j	80001bae <_printk_dec_ulong+0x6a>
			out(' ', ctx);
80001c0c:	85d2                	mv	a1,s4
80001c0e:	02000513          	li	a0,32
80001c12:	9982                	jalr	s3
80001c14:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
80001c16:	fe804be3          	bgtz	s0,80001c0c <_printk_dec_ulong+0xc8>
80001c1a:	b7c9                	j	80001bdc <_printk_dec_ulong+0x98>

80001c1c <__printk_hook_install>:
	_char_out = fn;
80001c1c:	800067b7          	lui	a5,0x80006
80001c20:	46a7a823          	sw	a0,1136(a5) # 80006470 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006471>
}
80001c24:	8082                	ret

80001c26 <z_vprintk>:
{
80001c26:	715d                	addi	sp,sp,-80
80001c28:	c4a2                	sw	s0,72(sp)
80001c2a:	c2a6                	sw	s1,68(sp)
80001c2c:	c0ca                	sw	s2,64(sp)
80001c2e:	de4e                	sw	s3,60(sp)
80001c30:	dc52                	sw	s4,56(sp)
80001c32:	da56                	sw	s5,52(sp)
80001c34:	d266                	sw	s9,36(sp)
80001c36:	d06a                	sw	s10,32(sp)
80001c38:	ce6e                	sw	s11,28(sp)
80001c3a:	c686                	sw	ra,76(sp)
80001c3c:	d85a                	sw	s6,48(sp)
80001c3e:	d65e                	sw	s7,44(sp)
80001c40:	d462                	sw	s8,40(sp)
80001c42:	842a                	mv	s0,a0
80001c44:	84ae                	mv	s1,a1
80001c46:	8ab2                	mv	s5,a2
80001c48:	8d36                	mv	s10,a3
	int long_ctr = 0;
80001c4a:	4a01                	li	s4,0
	int min_width = -1;
80001c4c:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001c4e:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001c50:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
80001c52:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001c56:	000ac503          	lbu	a0,0(s5)
80001c5a:	e105                	bnez	a0,80001c7a <z_vprintk+0x54>
}
80001c5c:	40b6                	lw	ra,76(sp)
80001c5e:	4426                	lw	s0,72(sp)
80001c60:	4496                	lw	s1,68(sp)
80001c62:	4906                	lw	s2,64(sp)
80001c64:	59f2                	lw	s3,60(sp)
80001c66:	5a62                	lw	s4,56(sp)
80001c68:	5ad2                	lw	s5,52(sp)
80001c6a:	5b42                	lw	s6,48(sp)
80001c6c:	5bb2                	lw	s7,44(sp)
80001c6e:	5c22                	lw	s8,40(sp)
80001c70:	5c92                	lw	s9,36(sp)
80001c72:	5d02                	lw	s10,32(sp)
80001c74:	4df2                	lw	s11,28(sp)
80001c76:	6161                	addi	sp,sp,80
80001c78:	8082                	ret
		if (!might_format) {
80001c7a:	000c9a63          	bnez	s9,80001c8e <z_vprintk+0x68>
			if (*fmt != '%') {
80001c7e:	02500693          	li	a3,37
80001c82:	28d50563          	beq	a0,a3,80001f0c <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
80001c86:	85a6                	mv	a1,s1
80001c88:	9402                	jalr	s0
		++fmt;
80001c8a:	0a85                	addi	s5,s5,1
80001c8c:	b7e9                	j	80001c56 <z_vprintk+0x30>
			switch (*fmt) {
80001c8e:	06400693          	li	a3,100
80001c92:	0ed50b63          	beq	a0,a3,80001d88 <z_vprintk+0x162>
80001c96:	04a6eb63          	bltu	a3,a0,80001cec <z_vprintk+0xc6>
80001c9a:	03900693          	li	a3,57
80001c9e:	02a6e763          	bltu	a3,a0,80001ccc <z_vprintk+0xa6>
80001ca2:	03100693          	li	a3,49
80001ca6:	0cd57563          	bgeu	a0,a3,80001d70 <z_vprintk+0x14a>
80001caa:	02d00693          	li	a3,45
80001cae:	26d50463          	beq	a0,a3,80001f16 <z_vprintk+0x2f0>
80001cb2:	03000793          	li	a5,48
80001cb6:	0af50363          	beq	a0,a5,80001d5c <z_vprintk+0x136>
80001cba:	02500713          	li	a4,37
80001cbe:	00e51f63          	bne	a0,a4,80001cdc <z_vprintk+0xb6>
				out((int)'%', ctx);
80001cc2:	85a6                	mv	a1,s1
80001cc4:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001cc8:	9402                	jalr	s0
				break;
80001cca:	aa09                	j	80001ddc <z_vprintk+0x1b6>
80001ccc:	05800693          	li	a3,88
80001cd0:	14d50b63          	beq	a0,a3,80001e26 <z_vprintk+0x200>
80001cd4:	06300713          	li	a4,99
80001cd8:	22e50363          	beq	a0,a4,80001efe <z_vprintk+0x2d8>
				out((int)'%', ctx);
80001cdc:	85a6                	mv	a1,s1
80001cde:	02500513          	li	a0,37
80001ce2:	9402                	jalr	s0
				out((int)*fmt, ctx);
80001ce4:	85a6                	mv	a1,s1
80001ce6:	000ac503          	lbu	a0,0(s5)
80001cea:	bff9                	j	80001cc8 <z_vprintk+0xa2>
80001cec:	07000693          	li	a3,112
80001cf0:	12d50163          	beq	a0,a3,80001e12 <z_vprintk+0x1ec>
80001cf4:	00a6ef63          	bltu	a3,a0,80001d12 <z_vprintk+0xec>
80001cf8:	06900693          	li	a3,105
80001cfc:	08d50663          	beq	a0,a3,80001d88 <z_vprintk+0x162>
80001d00:	06c00693          	li	a3,108
80001d04:	08d50063          	beq	a0,a3,80001d84 <z_vprintk+0x15e>
80001d08:	06800693          	li	a3,104
80001d0c:	f6d50fe3          	beq	a0,a3,80001c8a <z_vprintk+0x64>
80001d10:	b7f1                	j	80001cdc <z_vprintk+0xb6>
80001d12:	07500693          	li	a3,117
80001d16:	0cd50563          	beq	a0,a3,80001de0 <z_vprintk+0x1ba>
80001d1a:	02a6ea63          	bltu	a3,a0,80001d4e <z_vprintk+0x128>
80001d1e:	07300713          	li	a4,115
80001d22:	fae51de3          	bne	a0,a4,80001cdc <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
80001d26:	000d2c03          	lw	s8,0(s10)
80001d2a:	004d0b13          	addi	s6,s10,4
80001d2e:	8be2                	mv	s7,s8
				while (*s)
80001d30:	000bc503          	lbu	a0,0(s7)
80001d34:	1a051b63          	bnez	a0,80001eea <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
80001d38:	478d                	li	a5,3
80001d3a:	00f99863          	bne	s3,a5,80001d4a <z_vprintk+0x124>
					int remaining = min_width - (s - start);
80001d3e:	418b8bb3          	sub	s7,s7,s8
80001d42:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001d46:	1b704663          	bgtz	s7,80001ef2 <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
80001d4a:	8d5a                	mv	s10,s6
80001d4c:	a841                	j	80001ddc <z_vprintk+0x1b6>
80001d4e:	07800693          	li	a3,120
80001d52:	0cd50a63          	beq	a0,a3,80001e26 <z_vprintk+0x200>
80001d56:	07a00693          	li	a3,122
80001d5a:	bf4d                	j	80001d0c <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
80001d5c:	00095c63          	bgez	s2,80001d74 <z_vprintk+0x14e>
80001d60:	1a098d63          	beqz	s3,80001f1a <z_vprintk+0x2f4>
					min_width = *fmt - '0';
80001d64:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001d68:	f20991e3          	bnez	s3,80001c8a <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
80001d6c:	4989                	li	s3,2
80001d6e:	bf31                	j	80001c8a <z_vprintk+0x64>
				if (min_width < 0) {
80001d70:	fe094ae3          	bltz	s2,80001d64 <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
80001d74:	00291693          	slli	a3,s2,0x2
80001d78:	9936                	add	s2,s2,a3
80001d7a:	0906                	slli	s2,s2,0x1
80001d7c:	fd090913          	addi	s2,s2,-48
80001d80:	992a                	add	s2,s2,a0
80001d82:	b7dd                	j	80001d68 <z_vprintk+0x142>
				long_ctr++;
80001d84:	0a05                	addi	s4,s4,1
80001d86:	b711                	j	80001c8a <z_vprintk+0x64>
				if (long_ctr == 0) {
80001d88:	020a1663          	bnez	s4,80001db4 <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
80001d8c:	000d2603          	lw	a2,0(s10)
80001d90:	0d11                	addi	s10,s10,4
				if (d < 0) {
80001d92:	00065b63          	bgez	a2,80001da8 <z_vprintk+0x182>
					out((int)'-', ctx);
80001d96:	85a6                	mv	a1,s1
80001d98:	02d00513          	li	a0,45
80001d9c:	c032                	sw	a2,0(sp)
80001d9e:	9402                	jalr	s0
					d = -d;
80001da0:	4602                	lw	a2,0(sp)
					min_width--;
80001da2:	197d                	addi	s2,s2,-1
					d = -d;
80001da4:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001da8:	874a                	mv	a4,s2
80001daa:	86ce                	mv	a3,s3
80001dac:	85a6                	mv	a1,s1
80001dae:	8522                	mv	a0,s0
80001db0:	3b51                	jal	80001b44 <_printk_dec_ulong>
				break;
80001db2:	a02d                	j	80001ddc <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
80001db4:	4705                	li	a4,1
80001db6:	fcea0be3          	beq	s4,a4,80001d8c <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
80001dba:	007d0793          	addi	a5,s10,7
80001dbe:	ff87f713          	andi	a4,a5,-8
80001dc2:	4310                	lw	a2,0(a4)
80001dc4:	4354                	lw	a3,4(a4)
80001dc6:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001dca:	01b60733          	add	a4,a2,s11
80001dce:	00c73733          	sltu	a4,a4,a2
80001dd2:	9736                	add	a4,a4,a3
80001dd4:	df5d                	beqz	a4,80001d92 <z_vprintk+0x16c>
						print_err(out, ctx);
80001dd6:	85a6                	mv	a1,s1
80001dd8:	8522                	mv	a0,s0
80001dda:	333d                	jal	80001b08 <print_err>
			might_format = 0;
80001ddc:	4c81                	li	s9,0
80001dde:	b575                	j	80001c8a <z_vprintk+0x64>
				if (long_ctr == 0) {
80001de0:	000a1663          	bnez	s4,80001dec <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
80001de4:	000d2603          	lw	a2,0(s10)
80001de8:	0d11                	addi	s10,s10,4
80001dea:	bf7d                	j	80001da8 <z_vprintk+0x182>
				} else if (long_ctr == 1) {
80001dec:	4705                	li	a4,1
80001dee:	feea0be3          	beq	s4,a4,80001de4 <z_vprintk+0x1be>
					unsigned long long llu =
80001df2:	007d0793          	addi	a5,s10,7
80001df6:	ff87f713          	andi	a4,a5,-8
80001dfa:	00870d13          	addi	s10,a4,8
80001dfe:	4310                	lw	a2,0(a4)
80001e00:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001e02:	fb71                	bnez	a4,80001dd6 <z_vprintk+0x1b0>
80001e04:	800007b7          	lui	a5,0x80000
80001e08:	fff7c793          	not	a5,a5
80001e0c:	f8c7fee3          	bgeu	a5,a2,80001da8 <z_vprintk+0x182>
80001e10:	b7d9                	j	80001dd6 <z_vprintk+0x1b0>
				  out('0', ctx);
80001e12:	85a6                	mv	a1,s1
80001e14:	03000513          	li	a0,48
80001e18:	9402                	jalr	s0
				  out('x', ctx);
80001e1a:	85a6                	mv	a1,s1
80001e1c:	07800513          	li	a0,120
80001e20:	9402                	jalr	s0
				  min_width = 8;
80001e22:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001e24:	4985                	li	s3,1
				if (long_ctr < 2) {
80001e26:	4685                	li	a3,1
80001e28:	0746c663          	blt	a3,s4,80001e94 <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
80001e2c:	000d2783          	lw	a5,0(s10)
80001e30:	c402                	sw	zero,8(sp)
80001e32:	0d11                	addi	s10,s10,4
80001e34:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001e36:	4c41                	li	s8,16
	int digits = 0;
80001e38:	4b81                	li	s7,0
	int found_largest_digit = 0;
80001e3a:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001e3c:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001e3e:	4512                	lw	a0,4(sp)
80001e40:	45a2                	lw	a1,8(sp)
80001e42:	fff88b13          	addi	s6,a7,-1
80001e46:	002b1613          	slli	a2,s6,0x2
80001e4a:	c646                	sw	a7,12(sp)
80001e4c:	bd4fe0ef          	jal	ra,80000220 <__lshrdi3>
80001e50:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001e52:	ed39                	bnez	a0,80001eb0 <z_vprintk+0x28a>
80001e54:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001e56:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001e5a:	e789                	bnez	a5,80001e64 <z_vprintk+0x23e>
80001e5c:	48b2                	lw	a7,12(sp)
80001e5e:	4785                	li	a5,1
80001e60:	06f89063          	bne	a7,a5,80001ec0 <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
80001e64:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
80001e66:	0562                	slli	a0,a0,0x18
80001e68:	85a6                	mv	a1,s1
80001e6a:	8561                	srai	a0,a0,0x18
80001e6c:	9402                	jalr	s0
			digits++;
80001e6e:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
80001e70:	020b1d63          	bnez	s6,80001eaa <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
80001e74:	468d                	li	a3,3
			might_format = 0;
80001e76:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001e78:	e0d999e3          	bne	s3,a3,80001c8a <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
80001e7c:	00191713          	slli	a4,s2,0x1
80001e80:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001e84:	f5705ce3          	blez	s7,80001ddc <z_vprintk+0x1b6>
			out(' ', ctx);
80001e88:	85a6                	mv	a1,s1
80001e8a:	02000513          	li	a0,32
80001e8e:	9402                	jalr	s0
80001e90:	1bfd                	addi	s7,s7,-1
80001e92:	bfcd                	j	80001e84 <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
80001e94:	007d0793          	addi	a5,s10,7
80001e98:	ff87f693          	andi	a3,a5,-8
80001e9c:	429c                	lw	a5,0(a3)
80001e9e:	00868d13          	addi	s10,a3,8
80001ea2:	c23e                	sw	a5,4(sp)
80001ea4:	42dc                	lw	a5,4(a3)
80001ea6:	c43e                	sw	a5,8(sp)
80001ea8:	b779                	j	80001e36 <z_vprintk+0x210>
			found_largest_digit = 1;
80001eaa:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001eac:	88da                	mv	a7,s6
80001eae:	bf41                	j	80001e3e <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
80001eb0:	47a5                	li	a5,9
80001eb2:	05700693          	li	a3,87
80001eb6:	faa7e7e3          	bltu	a5,a0,80001e64 <z_vprintk+0x23e>
80001eba:	03000693          	li	a3,48
80001ebe:	b75d                	j	80001e64 <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
80001ec0:	fffc0793          	addi	a5,s8,-1
80001ec4:	c63e                	sw	a5,12(sp)
80001ec6:	01894963          	blt	s2,s8,80001ed8 <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
80001eca:	4785                	li	a5,1
80001ecc:	00f99863          	bne	s3,a5,80001edc <z_vprintk+0x2b6>
				out('0', ctx);
80001ed0:	85a6                	mv	a1,s1
80001ed2:	03000513          	li	a0,48
				out(' ', ctx);
80001ed6:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
80001ed8:	4c32                	lw	s8,12(sp)
80001eda:	bfc9                	j	80001eac <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
80001edc:	4789                	li	a5,2
80001ede:	fef99de3          	bne	s3,a5,80001ed8 <z_vprintk+0x2b2>
				out(' ', ctx);
80001ee2:	85a6                	mv	a1,s1
80001ee4:	02000513          	li	a0,32
80001ee8:	b7fd                	j	80001ed6 <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
80001eea:	85a6                	mv	a1,s1
80001eec:	0b85                	addi	s7,s7,1
80001eee:	9402                	jalr	s0
80001ef0:	b581                	j	80001d30 <z_vprintk+0x10a>
						out(' ', ctx);
80001ef2:	85a6                	mv	a1,s1
80001ef4:	02000513          	li	a0,32
80001ef8:	9402                	jalr	s0
80001efa:	1bfd                	addi	s7,s7,-1
80001efc:	b5a9                	j	80001d46 <z_vprintk+0x120>
				out(c, ctx);
80001efe:	000d2503          	lw	a0,0(s10)
80001f02:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
80001f04:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001f08:	9402                	jalr	s0
				break;
80001f0a:	b581                	j	80001d4a <z_vprintk+0x124>
				long_ctr = 0;
80001f0c:	4a01                	li	s4,0
				min_width = -1;
80001f0e:	597d                	li	s2,-1
				padding = PAD_NONE;
80001f10:	4981                	li	s3,0
				might_format = 1;
80001f12:	4c85                	li	s9,1
80001f14:	bb9d                	j	80001c8a <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
80001f16:	498d                	li	s3,3
80001f18:	bb8d                	j	80001c8a <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
80001f1a:	4985                	li	s3,1
80001f1c:	b3bd                	j	80001c8a <z_vprintk+0x64>

80001f1e <vprintk>:
{
80001f1e:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001f20:	862a                	mv	a2,a0
80001f22:	80002537          	lui	a0,0x80002
80001f26:	86ae                	mv	a3,a1
80001f28:	b3450513          	addi	a0,a0,-1228 # 80001b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001b35>
80001f2c:	006c                	addi	a1,sp,12
{
80001f2e:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001f30:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001f32:	39d5                	jal	80001c26 <z_vprintk>
}
80001f34:	40f2                	lw	ra,28(sp)
80001f36:	6105                	addi	sp,sp,32
80001f38:	8082                	ret

80001f3a <printk>:
{
80001f3a:	7139                	addi	sp,sp,-64
80001f3c:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
80001f3e:	104c                	addi	a1,sp,36
{
80001f40:	ce06                	sw	ra,28(sp)
80001f42:	d432                	sw	a2,40(sp)
80001f44:	d636                	sw	a3,44(sp)
80001f46:	d83a                	sw	a4,48(sp)
80001f48:	da3e                	sw	a5,52(sp)
80001f4a:	dc42                	sw	a6,56(sp)
80001f4c:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
80001f4e:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
80001f50:	37f9                	jal	80001f1e <vprintk>
}
80001f52:	40f2                	lw	ra,28(sp)
80001f54:	6121                	addi	sp,sp,64
80001f56:	8082                	ret

80001f58 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001f58:	800065b7          	lui	a1,0x80006
80001f5c:	80006537          	lui	a0,0x80006
{
80001f60:	1141                	addi	sp,sp,-16
  k_panic();
80001f62:	e2058593          	addi	a1,a1,-480 # 80005e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e21>
80001f66:	e3450513          	addi	a0,a0,-460 # 80005e34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e35>
80001f6a:	4679                	li	a2,30
{
80001f6c:	c606                	sw	ra,12(sp)
  k_panic();
80001f6e:	37f1                	jal	80001f3a <printk>
80001f70:	800065b7          	lui	a1,0x80006
80001f74:	a0058593          	addi	a1,a1,-1536 # 80005a00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a01>
80001f78:	4519                	li	a0,6
80001f7a:	bd0ff0ef          	jal	ra,8000134a <z_NanoFatalErrorHandler>

80001f7e <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001f7e:	8082                	ret

80001f80 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001f80:	47a1                	li	a5,8
80001f82:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001f86:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001f8a:	8082                	ret

80001f8c <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001f8c:	4785                	li	a5,1
80001f8e:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001f92:	30452573          	csrrs	a0,mie,a0
}
80001f96:	8082                	ret

80001f98 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001f98:	47a1                	li	a5,8
80001f9a:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001f9e:	30405073          	csrwi	mie,0
80001fa2:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001fa6:	8082                	ret

80001fa8 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001fa8:	1141                	addi	sp,sp,-16
80001faa:	c422                	sw	s0,8(sp)
80001fac:	c226                	sw	s1,4(sp)
80001fae:	80006437          	lui	s0,0x80006
80001fb2:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001fb4:	47a9                	li	a5,10
{
80001fb6:	84aa                	mv	s1,a0
80001fb8:	51040413          	addi	s0,s0,1296 # 80006510 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006511>
	if ('\n' == c) {
80001fbc:	00f51763          	bne	a0,a5,80001fca <console_out+0x22>
80001fc0:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001fc2:	45b5                	li	a1,13
80001fc4:	415c                	lw	a5,4(a0)
80001fc6:	43dc                	lw	a5,4(a5)
80001fc8:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001fca:	4008                	lw	a0,0(s0)
80001fcc:	0ff4f593          	andi	a1,s1,255
80001fd0:	415c                	lw	a5,4(a0)
80001fd2:	43dc                	lw	a5,4(a5)
80001fd4:	9782                	jalr	a5

	return c;
}
80001fd6:	40b2                	lw	ra,12(sp)
80001fd8:	4422                	lw	s0,8(sp)
80001fda:	8526                	mv	a0,s1
80001fdc:	4492                	lw	s1,4(sp)
80001fde:	0141                	addi	sp,sp,16
80001fe0:	8082                	ret

80001fe2 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001fe2:	1141                	addi	sp,sp,-16
80001fe4:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001fe6:	80002437          	lui	s0,0x80002
80001fea:	fa840513          	addi	a0,s0,-88 # 80001fa8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001fa9>
{
80001fee:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001ff0:	29a5                	jal	80002468 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001ff2:	fa840513          	addi	a0,s0,-88
}
80001ff6:	4422                	lw	s0,8(sp)
80001ff8:	40b2                	lw	ra,12(sp)
80001ffa:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
80001ffc:	b105                	j	80001c1c <__printk_hook_install>

80001ffe <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001ffe:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80002002:	1141                	addi	sp,sp,-16
80002004:	e4050513          	addi	a0,a0,-448 # 80005e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e41>
80002008:	c606                	sw	ra,12(sp)
8000200a:	6f8000ef          	jal	ra,80002702 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
8000200e:	800067b7          	lui	a5,0x80006
80002012:	50a7a823          	sw	a0,1296(a5) # 80006510 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006511>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80002016:	37f1                	jal	80001fe2 <uart_console_hook_install>

	return 0;
}
80002018:	40b2                	lw	ra,12(sp)
8000201a:	4501                	li	a0,0
8000201c:	0141                	addi	sp,sp,16
8000201e:	8082                	ret

80002020 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80002020:	f01007b7          	lui	a5,0xf0100
80002024:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80002028:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
8000202c:	f447a583          	lw	a1,-188(a5)
80002030:	fee59ae3          	bne	a1,a4,80002024 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80002034:	8082                	ret

80002036 <timer_isr>:

static void timer_isr(void *arg)
{
80002036:	1101                	addi	sp,sp,-32
80002038:	cc22                	sw	s0,24(sp)
8000203a:	ce06                	sw	ra,28(sp)
8000203c:	ca26                	sw	s1,20(sp)
8000203e:	c84a                	sw	s2,16(sp)
80002040:	c64e                	sw	s3,12(sp)
80002042:	c452                	sw	s4,8(sp)
80002044:	c256                	sw	s5,4(sp)
80002046:	4421                	li	s0,8
80002048:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000204c:	80006937          	lui	s2,0x80006
80002050:	51490513          	addi	a0,s2,1300 # 80006514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006515>
	key = (mstatus & SOC_MSTATUS_IEN);
80002054:	8821                	andi	s0,s0,8
80002056:	40e020ef          	jal	ra,80004464 <z_spin_lock_valid>
8000205a:	e915                	bnez	a0,8000208e <timer_isr+0x58>
8000205c:	800064b7          	lui	s1,0x80006
80002060:	800065b7          	lui	a1,0x80006
80002064:	80006537          	lui	a0,0x80006
80002068:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
8000206c:	04e00693          	li	a3,78
80002070:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002074:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002078:	35c9                	jal	80001f3a <printk>
8000207a:	80006537          	lui	a0,0x80006
8000207e:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80002082:	3d65                	jal	80001f3a <printk>
80002084:	04e00593          	li	a1,78
80002088:	e5448513          	addi	a0,s1,-428
8000208c:	35f1                	jal	80001f58 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
8000208e:	51490513          	addi	a0,s2,1300
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002092:	800064b7          	lui	s1,0x80006
80002096:	40a020ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
8000209a:	4f848493          	addi	s1,s1,1272 # 800064f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f9>
	u64_t now = mtime();
8000209e:	3749                	jal	80002020 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800020a0:	0004a983          	lw	s3,0(s1)
800020a4:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
800020a8:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800020aa:	41350533          	sub	a0,a0,s3
800020ae:	00a7b7b3          	sltu	a5,a5,a0
800020b2:	415585b3          	sub	a1,a1,s5
800020b6:	6675                	lui	a2,0x1d
800020b8:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800020bc:	4681                	li	a3,0
800020be:	8d9d                	sub	a1,a1,a5
800020c0:	998fe0ef          	jal	ra,80000258 <__udivdi3>
800020c4:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
800020c6:	65f5                	lui	a1,0x1d
800020c8:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800020cc:	8552                	mv	a0,s4
800020ce:	f5efe0ef          	jal	ra,8000082c <__mulsi3>
800020d2:	99aa                	add	s3,s3,a0
800020d4:	00a9b533          	sltu	a0,s3,a0
800020d8:	9556                	add	a0,a0,s5
800020da:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800020dc:	51490513          	addi	a0,s2,1300
800020e0:	0134a023          	sw	s3,0(s1)
800020e4:	39a020ef          	jal	ra,8000447e <z_spin_unlock_valid>
800020e8:	e915                	bnez	a0,8000211c <timer_isr+0xe6>
800020ea:	800064b7          	lui	s1,0x80006
800020ee:	800065b7          	lui	a1,0x80006
800020f2:	80006537          	lui	a0,0x80006
800020f6:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800020fa:	06100693          	li	a3,97
800020fe:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002102:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002106:	3d15                	jal	80001f3a <printk>
80002108:	80006537          	lui	a0,0x80006
8000210c:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80002110:	352d                	jal	80001f3a <printk>
80002112:	06100593          	li	a1,97
80002116:	e5448513          	addi	a0,s1,-428
8000211a:	3d3d                	jal	80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000211c:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002120:	4462                	lw	s0,24(sp)
80002122:	40f2                	lw	ra,28(sp)
80002124:	44d2                	lw	s1,20(sp)
80002126:	4942                	lw	s2,16(sp)
80002128:	49b2                	lw	s3,12(sp)
8000212a:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
8000212c:	8552                	mv	a0,s4
}
8000212e:	4a22                	lw	s4,8(sp)
80002130:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002132:	3270206f          	j	80004c58 <z_clock_announce>

80002136 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002136:	1141                	addi	sp,sp,-16
80002138:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000213a:	35dd                	jal	80002020 <mtime>
8000213c:	67f5                	lui	a5,0x1d
8000213e:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80002142:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002146:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
80002148:	56fd                	li	a3,-1
8000214a:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000214e:	00a7b533          	sltu	a0,a5,a0
80002152:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
80002154:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002158:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
8000215c:	451d                	li	a0,7
8000215e:	353d                	jal	80001f8c <z_arch_irq_enable>
	return 0;
}
80002160:	40b2                	lw	ra,12(sp)
80002162:	4501                	li	a0,0
80002164:	0141                	addi	sp,sp,16
80002166:	8082                	ret

80002168 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002168:	14059563          	bnez	a1,800022b2 <z_clock_set_timeout+0x14a>
{
8000216c:	1101                	addi	sp,sp,-32
8000216e:	ce06                	sw	ra,28(sp)
80002170:	cc22                	sw	s0,24(sp)
80002172:	ca26                	sw	s1,20(sp)
80002174:	c84a                	sw	s2,16(sp)
80002176:	c64e                	sw	s3,12(sp)
80002178:	c452                	sw	s4,8(sp)
8000217a:	c256                	sw	s5,4(sp)
8000217c:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
8000217e:	57fd                	li	a5,-1
80002180:	00f51563          	bne	a0,a5,8000218a <z_clock_set_timeout+0x22>
80002184:	6525                	lui	a0,0x9
80002186:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
8000218a:	67a5                	lui	a5,0x9
8000218c:	fff50413          	addi	s0,a0,-1
80002190:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80002194:	1087db63          	bge	a5,s0,800022aa <z_clock_set_timeout+0x142>
80002198:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000219a:	4921                	li	s2,8
8000219c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800021a0:	80006ab7          	lui	s5,0x80006
800021a4:	514a8513          	addi	a0,s5,1300 # 80006514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006515>
	key = (mstatus & SOC_MSTATUS_IEN);
800021a8:	00897913          	andi	s2,s2,8
800021ac:	2b8020ef          	jal	ra,80004464 <z_spin_lock_valid>
800021b0:	e915                	bnez	a0,800021e4 <z_clock_set_timeout+0x7c>
800021b2:	800064b7          	lui	s1,0x80006
800021b6:	800065b7          	lui	a1,0x80006
800021ba:	80006537          	lui	a0,0x80006
800021be:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800021c2:	04e00693          	li	a3,78
800021c6:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800021ca:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800021ce:	33b5                	jal	80001f3a <printk>
800021d0:	80006537          	lui	a0,0x80006
800021d4:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800021d8:	338d                	jal	80001f3a <printk>
800021da:	04e00593          	li	a1,78
800021de:	e5448513          	addi	a0,s1,-428
800021e2:	3b9d                	jal	80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800021e4:	514a8513          	addi	a0,s5,1300
800021e8:	2b8020ef          	jal	ra,800044a0 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
800021ec:	3d15                	jal	80002020 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
800021ee:	800067b7          	lui	a5,0x80006
800021f2:	4f878793          	addi	a5,a5,1272 # 800064f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f9>
	u32_t cyc = ticks * CYC_PER_TICK;
800021f6:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
800021f8:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
800021fc:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
800021fe:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002202:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002204:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002208:	e24fe0ef          	jal	ra,8000082c <__mulsi3>
8000220c:	4bf48793          	addi	a5,s1,1215
80002210:	413787b3          	sub	a5,a5,s3
80002214:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002216:	4c048593          	addi	a1,s1,1216
8000221a:	9552                	add	a0,a0,s4
8000221c:	eccfe0ef          	jal	ra,800008e8 <__udivsi3>
80002220:	4c048593          	addi	a1,s1,1216
80002224:	e08fe0ef          	jal	ra,8000082c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002228:	41498a33          	sub	s4,s3,s4
8000222c:	9a2a                	add	s4,s4,a0
8000222e:	3e700793          	li	a5,999
80002232:	0147c563          	blt	a5,s4,8000223c <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
80002236:	4c048493          	addi	s1,s1,1216
8000223a:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
8000223c:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002240:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
80002242:	577d                	li	a4,-1
80002244:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002248:	00a9b533          	sltu	a0,s3,a0
8000224c:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
8000224e:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80002252:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002256:	514a8513          	addi	a0,s5,1300
8000225a:	224020ef          	jal	ra,8000447e <z_spin_unlock_valid>
8000225e:	e915                	bnez	a0,80002292 <z_clock_set_timeout+0x12a>
80002260:	80006437          	lui	s0,0x80006
80002264:	800065b7          	lui	a1,0x80006
80002268:	80006537          	lui	a0,0x80006
8000226c:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80002270:	06100693          	li	a3,97
80002274:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002278:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000227c:	397d                	jal	80001f3a <printk>
8000227e:	80006537          	lui	a0,0x80006
80002282:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80002286:	3955                	jal	80001f3a <printk>
80002288:	06100593          	li	a1,97
8000228c:	e5440513          	addi	a0,s0,-428
80002290:	31e1                	jal	80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002292:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80002296:	40f2                	lw	ra,28(sp)
80002298:	4462                	lw	s0,24(sp)
8000229a:	44d2                	lw	s1,20(sp)
8000229c:	4942                	lw	s2,16(sp)
8000229e:	49b2                	lw	s3,12(sp)
800022a0:	4a22                	lw	s4,8(sp)
800022a2:	4a92                	lw	s5,4(sp)
800022a4:	4b02                	lw	s6,0(sp)
800022a6:	6105                	addi	sp,sp,32
800022a8:	8082                	ret
800022aa:	ee0458e3          	bgez	s0,8000219a <z_clock_set_timeout+0x32>
800022ae:	4401                	li	s0,0
800022b0:	b5ed                	j	8000219a <z_clock_set_timeout+0x32>
800022b2:	8082                	ret

800022b4 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
800022b4:	1141                	addi	sp,sp,-16
800022b6:	c422                	sw	s0,8(sp)
800022b8:	c606                	sw	ra,12(sp)
800022ba:	c226                	sw	s1,4(sp)
800022bc:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800022be:	4421                	li	s0,8
800022c0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800022c4:	800064b7          	lui	s1,0x80006
800022c8:	51448513          	addi	a0,s1,1300 # 80006514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006515>
	key = (mstatus & SOC_MSTATUS_IEN);
800022cc:	8821                	andi	s0,s0,8
800022ce:	196020ef          	jal	ra,80004464 <z_spin_lock_valid>
800022d2:	ed0d                	bnez	a0,8000230c <z_clock_elapsed+0x58>
800022d4:	80006937          	lui	s2,0x80006
800022d8:	800065b7          	lui	a1,0x80006
800022dc:	80006537          	lui	a0,0x80006
800022e0:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800022e4:	04e00693          	li	a3,78
800022e8:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800022ec:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800022f0:	c4bff0ef          	jal	ra,80001f3a <printk>
800022f4:	80006537          	lui	a0,0x80006
800022f8:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800022fc:	c3fff0ef          	jal	ra,80001f3a <printk>
80002300:	04e00593          	li	a1,78
80002304:	e5490513          	addi	a0,s2,-428
80002308:	c51ff0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
8000230c:	51448513          	addi	a0,s1,1300
80002310:	190020ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002314:	3331                	jal	80002020 <mtime>
80002316:	800067b7          	lui	a5,0x80006
8000231a:	4f87a783          	lw	a5,1272(a5) # 800064f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f9>
8000231e:	65f5                	lui	a1,0x1d
80002320:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002324:	8d1d                	sub	a0,a0,a5
80002326:	dc2fe0ef          	jal	ra,800008e8 <__udivsi3>
8000232a:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000232c:	51448513          	addi	a0,s1,1300
80002330:	14e020ef          	jal	ra,8000447e <z_spin_unlock_valid>
80002334:	ed0d                	bnez	a0,8000236e <z_clock_elapsed+0xba>
80002336:	800064b7          	lui	s1,0x80006
8000233a:	800065b7          	lui	a1,0x80006
8000233e:	80006537          	lui	a0,0x80006
80002342:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80002346:	06100693          	li	a3,97
8000234a:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
8000234e:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002352:	be9ff0ef          	jal	ra,80001f3a <printk>
80002356:	80006537          	lui	a0,0x80006
8000235a:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
8000235e:	bddff0ef          	jal	ra,80001f3a <printk>
80002362:	06100593          	li	a1,97
80002366:	e5448513          	addi	a0,s1,-428
8000236a:	befff0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000236e:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002372:	40b2                	lw	ra,12(sp)
80002374:	4422                	lw	s0,8(sp)
80002376:	854a                	mv	a0,s2
80002378:	4492                	lw	s1,4(sp)
8000237a:	4902                	lw	s2,0(sp)
8000237c:	0141                	addi	sp,sp,16
8000237e:	8082                	ret

80002380 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002380:	00054783          	lbu	a5,0(a0)
80002384:	0005c703          	lbu	a4,0(a1)
80002388:	00e79363          	bne	a5,a4,8000238e <strcmp+0xe>
8000238c:	e781                	bnez	a5,80002394 <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
8000238e:	40e78533          	sub	a0,a5,a4
80002392:	8082                	ret
		s1++;
80002394:	0505                	addi	a0,a0,1
		s2++;
80002396:	0585                	addi	a1,a1,1
80002398:	b7e5                	j	80002380 <strcmp>

8000239a <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
8000239a:	00b547b3          	xor	a5,a0,a1
8000239e:	8b8d                	andi	a5,a5,3
800023a0:	cf95                	beqz	a5,800023dc <memcpy+0x42>
	unsigned char *d_byte = (unsigned char *)d;
800023a2:	87aa                	mv	a5,a0
800023a4:	4701                	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
800023a6:	04e61763          	bne	a2,a4,800023f4 <memcpy+0x5a>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
800023aa:	8082                	ret
			if (n == 0) {
800023ac:	de7d                	beqz	a2,800023aa <memcpy+0x10>
			*(d_byte++) = *(s_byte++);
800023ae:	0585                	addi	a1,a1,1
800023b0:	fff5c703          	lbu	a4,-1(a1)
800023b4:	0785                	addi	a5,a5,1
			n--;
800023b6:	167d                	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
800023b8:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
800023bc:	0037f713          	andi	a4,a5,3
800023c0:	f775                	bnez	a4,800023ac <memcpy+0x12>
		while (n >= sizeof(unsigned int)) {
800023c2:	468d                	li	a3,3
800023c4:	40e60833          	sub	a6,a2,a4
800023c8:	0106ec63          	bltu	a3,a6,800023e0 <memcpy+0x46>
800023cc:	00265713          	srli	a4,a2,0x2
800023d0:	00271693          	slli	a3,a4,0x2
800023d4:	8e15                	sub	a2,a2,a3
800023d6:	97b6                	add	a5,a5,a3
800023d8:	95b6                	add	a1,a1,a3
800023da:	b7e9                	j	800023a4 <memcpy+0xa>
	unsigned char *d_byte = (unsigned char *)d;
800023dc:	87aa                	mv	a5,a0
800023de:	bff9                	j	800023bc <memcpy+0x22>
			*(d_word++) = *(s_word++);
800023e0:	00e588b3          	add	a7,a1,a4
800023e4:	0008a883          	lw	a7,0(a7)
800023e8:	00e78833          	add	a6,a5,a4
800023ec:	0711                	addi	a4,a4,4
800023ee:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
800023f2:	bfc9                	j	800023c4 <memcpy+0x2a>
		*(d_byte++) = *(s_byte++);
800023f4:	00e58833          	add	a6,a1,a4
800023f8:	00084803          	lbu	a6,0(a6)
800023fc:	00e786b3          	add	a3,a5,a4
80002400:	0705                	addi	a4,a4,1
80002402:	01068023          	sb	a6,0(a3)
		n--;
80002406:	b745                	j	800023a6 <memcpy+0xc>

80002408 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002408:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
8000240c:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
8000240e:	0037f713          	andi	a4,a5,3
80002412:	eb1d                	bnez	a4,80002448 <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002414:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002418:	00859713          	slli	a4,a1,0x8
8000241c:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
8000241e:	01059713          	slli	a4,a1,0x10
80002422:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
80002424:	00c78333          	add	t1,a5,a2
80002428:	873e                	mv	a4,a5
8000242a:	480d                	li	a6,3
8000242c:	40e308b3          	sub	a7,t1,a4
80002430:	03186263          	bltu	a6,a7,80002454 <memset+0x4c>
80002434:	00265713          	srli	a4,a2,0x2
80002438:	00271593          	slli	a1,a4,0x2
8000243c:	97ae                	add	a5,a5,a1
8000243e:	8e0d                	sub	a2,a2,a1
80002440:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002442:	00c79d63          	bne	a5,a2,8000245c <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002446:	8082                	ret
		if (n == 0) {
80002448:	de7d                	beqz	a2,80002446 <memset+0x3e>
		*(d_byte++) = c_byte;
8000244a:	0785                	addi	a5,a5,1
8000244c:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002450:	167d                	addi	a2,a2,-1
80002452:	bf75                	j	8000240e <memset+0x6>
		*(d_word++) = c_word;
80002454:	0711                	addi	a4,a4,4
80002456:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
8000245a:	bfc9                	j	8000242c <memset+0x24>
		*(d_byte++) = c_byte;
8000245c:	0785                	addi	a5,a5,1
8000245e:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002462:	b7c5                	j	80002442 <memset+0x3a>

80002464 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80002464:	557d                	li	a0,-1
80002466:	8082                	ret

80002468 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002468:	800067b7          	lui	a5,0x80006
8000246c:	46a7aa23          	sw	a0,1140(a5) # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
}
80002470:	8082                	ret

80002472 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002472:	1101                	addi	sp,sp,-32
80002474:	cc22                	sw	s0,24(sp)
	test->setup();
80002476:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80002478:	80006437          	lui	s0,0x80006
{
8000247c:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
8000247e:	47840413          	addi	s0,s0,1144 # 80006478 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006479>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002482:	800064b7          	lui	s1,0x80006
{
80002486:	ce06                	sw	ra,28(sp)
80002488:	c84a                	sw	s2,16(sp)
8000248a:	c64e                	sw	s3,12(sp)
	test_result = 1;
8000248c:	51848493          	addi	s1,s1,1304 # 80006518 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006519>
80002490:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
80002492:	00042023          	sw	zero,0(s0)
{
80002496:	892a                	mv	s2,a0
	test_result = 1;
80002498:	0134a023          	sw	s3,0(s1)
	test->setup();
8000249c:	9782                	jalr	a5
	test->test();
8000249e:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
800024a2:	01342023          	sw	s3,0(s0)
	test->test();
800024a6:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
800024a8:	4789                	li	a5,2
800024aa:	c01c                	sw	a5,0(s0)
	test->teardown();
800024ac:	00c92783          	lw	a5,12(s2)
800024b0:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
800024b2:	478d                	li	a5,3
800024b4:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
800024b6:	4462                	lw	s0,24(sp)
	test_result = 0;
800024b8:	0004a023          	sw	zero,0(s1)
}
800024bc:	40f2                	lw	ra,28(sp)
800024be:	44d2                	lw	s1,20(sp)
800024c0:	4942                	lw	s2,16(sp)
800024c2:	49b2                	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800024c4:	80006537          	lui	a0,0x80006
800024c8:	74050513          	addi	a0,a0,1856 # 80006740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006741>
800024cc:	6105                	addi	sp,sp,32
800024ce:	4c10106f          	j	8000418e <z_impl_k_sem_give>

800024d2 <ztest_test_fail>:
800024d2:	80006537          	lui	a0,0x80006
{
800024d6:	1141                	addi	sp,sp,-16
	test_result = -1;
800024d8:	800067b7          	lui	a5,0x80006
800024dc:	577d                	li	a4,-1
800024de:	74050513          	addi	a0,a0,1856 # 80006740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006741>
{
800024e2:	c606                	sw	ra,12(sp)
	test_result = -1;
800024e4:	50e7ac23          	sw	a4,1304(a5) # 80006518 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006519>
800024e8:	4a7010ef          	jal	ra,8000418e <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800024ec:	3f9010ef          	jal	ra,800040e4 <z_impl_k_current_get>
}
800024f0:	40b2                	lw	ra,12(sp)
800024f2:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800024f4:	1f40206f          	j	800046e8 <z_impl_k_thread_abort>

800024f8 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
800024f8:	711d                	addi	sp,sp,-96
800024fa:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
800024fc:	800064b7          	lui	s1,0x80006
80002500:	51c4a783          	lw	a5,1308(s1) # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
{
80002504:	ce86                	sw	ra,92(sp)
80002506:	cca2                	sw	s0,88(sp)
80002508:	c8ca                	sw	s2,80(sp)
8000250a:	c6ce                	sw	s3,76(sp)
8000250c:	c4d2                	sw	s4,72(sp)
8000250e:	c2d6                	sw	s5,68(sp)
80002510:	c0da                	sw	s6,64(sp)
80002512:	de5e                	sw	s7,60(sp)
80002514:	dc62                	sw	s8,56(sp)
80002516:	da66                	sw	s9,52(sp)
80002518:	d86a                	sw	s10,48(sp)
8000251a:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
8000251c:	0607c963          	bltz	a5,8000258e <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002520:	80006437          	lui	s0,0x80006
80002524:	4605                	li	a2,1
80002526:	89aa                	mv	s3,a0
80002528:	8c2e                	mv	s8,a1
8000252a:	74040513          	addi	a0,s0,1856 # 80006740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006741>
8000252e:	4581                	li	a1,0
80002530:	3bf010ef          	jal	ra,800040ee <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80002534:	80006537          	lui	a0,0x80006
80002538:	85ce                	mv	a1,s3
8000253a:	f1050513          	addi	a0,a0,-240 # 80005f10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f11>
8000253e:	9fdff0ef          	jal	ra,80001f3a <printk>
	PRINT_LINE;
80002542:	80006937          	lui	s2,0x80006
80002546:	f2890513          	addi	a0,s2,-216 # 80005f28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f29>
		Z_TC_END_RESULT(ret, test->name);
8000254a:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
8000254e:	9edff0ef          	jal	ra,80001f3a <printk>
80002552:	51c48493          	addi	s1,s1,1308
	int fail = 0;
80002556:	4a01                	li	s4,0
80002558:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
8000255a:	80007cb7          	lui	s9,0x80007
8000255e:	80006b37          	lui	s6,0x80006
80002562:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80002566:	80006db7          	lui	s11,0x80006
8000256a:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
8000256e:	ec8a8a93          	addi	s5,s5,-312 # 80005ec8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ec9>
	while (suite->test) {
80002572:	004c2783          	lw	a5,4(s8)
80002576:	eb9d                	bnez	a5,800025ac <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002578:	85ce                	mv	a1,s3
	if (fail) {
8000257a:	0c0a0363          	beqz	s4,80002640 <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
8000257e:	80006537          	lui	a0,0x80006
80002582:	f9850513          	addi	a0,a0,-104 # 80005f98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f99>
80002586:	9b5ff0ef          	jal	ra,80001f3a <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
8000258a:	4785                	li	a5,1
8000258c:	c09c                	sw	a5,0(s1)
}
8000258e:	40f6                	lw	ra,92(sp)
80002590:	4466                	lw	s0,88(sp)
80002592:	44d6                	lw	s1,84(sp)
80002594:	4946                	lw	s2,80(sp)
80002596:	49b6                	lw	s3,76(sp)
80002598:	4a26                	lw	s4,72(sp)
8000259a:	4a96                	lw	s5,68(sp)
8000259c:	4b06                	lw	s6,64(sp)
8000259e:	5bf2                	lw	s7,60(sp)
800025a0:	5c62                	lw	s8,56(sp)
800025a2:	5cd2                	lw	s9,52(sp)
800025a4:	5d42                	lw	s10,48(sp)
800025a6:	5db2                	lw	s11,44(sp)
800025a8:	6125                	addi	sp,sp,96
800025aa:	8082                	ret
	TC_START(test->name);
800025ac:	000c2583          	lw	a1,0(s8)
800025b0:	800067b7          	lui	a5,0x80006
800025b4:	f7078513          	addi	a0,a5,-144 # 80005f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f71>
800025b8:	983ff0ef          	jal	ra,80001f3a <printk>
800025bc:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
800025be:	010c2783          	lw	a5,16(s8)
800025c2:	8762                	mv	a4,s8
800025c4:	40000613          	li	a2,1024
800025c8:	0087e793          	ori	a5,a5,8
800025cc:	58fd                	li	a7,-1
800025ce:	4801                	li	a6,0
800025d0:	472d0693          	addi	a3,s10,1138 # 80002472 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002473>
800025d4:	c03e                	sw	a5,0(sp)
800025d6:	ed0c8593          	addi	a1,s9,-304 # 80006ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed1>
800025da:	4781                	li	a5,0
800025dc:	750b0513          	addi	a0,s6,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
800025e0:	7f1010ef          	jal	ra,800045d0 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800025e4:	47f2                	lw	a5,28(sp)
800025e6:	55fd                	li	a1,-1
800025e8:	74078513          	addi	a0,a5,1856
800025ec:	44d010ef          	jal	ra,80004238 <z_impl_k_sem_take>
	if (test_result == -1) {
800025f0:	518d8793          	addi	a5,s11,1304 # 80006518 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006519>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800025f4:	750b0513          	addi	a0,s6,1872
800025f8:	4380                	lw	s0,0(a5)
800025fa:	0ee020ef          	jal	ra,800046e8 <z_impl_k_thread_abort>
	if (test_result == -2) {
800025fe:	800067b7          	lui	a5,0x80006
80002602:	51878793          	addi	a5,a5,1304 # 80006518 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006519>
80002606:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
80002608:	0405                	addi	s0,s0,1
	if (test_result == -2) {
8000260a:	57f9                	li	a5,-2
	if (test_result == -1) {
8000260c:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80002610:	000c2603          	lw	a2,0(s8)
80002614:	02f71163          	bne	a4,a5,80002636 <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002618:	800065b7          	lui	a1,0x80006
8000261c:	f8458593          	addi	a1,a1,-124 # 80005f84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f85>
		Z_TC_END_RESULT(ret, test->name);
80002620:	f8cb8513          	addi	a0,s7,-116 # 80005f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f8d>
80002624:	917ff0ef          	jal	ra,80001f3a <printk>
80002628:	f2890513          	addi	a0,s2,-216
8000262c:	90fff0ef          	jal	ra,80001f3a <printk>
		fail += run_test(suite);
80002630:	9a22                	add	s4,s4,s0
		suite++;
80002632:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002634:	bf3d                	j	80002572 <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
80002636:	00241793          	slli	a5,s0,0x2
8000263a:	97d6                	add	a5,a5,s5
8000263c:	438c                	lw	a1,0(a5)
8000263e:	b7cd                	j	80002620 <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
80002640:	80006537          	lui	a0,0x80006
80002644:	fb050513          	addi	a0,a0,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80002648:	8f3ff0ef          	jal	ra,80001f3a <printk>
	test_status = (test_status || fail) ? 1 : 0;
8000264c:	409c                	lw	a5,0(s1)
8000264e:	00f037b3          	snez	a5,a5
80002652:	bf2d                	j	8000258c <z_ztest_run_test_suite+0x94>

80002654 <end_report>:

void end_report(void)
{
	if (test_status) {
80002654:	800067b7          	lui	a5,0x80006
80002658:	51c7a783          	lw	a5,1308(a5) # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
{
8000265c:	1141                	addi	sp,sp,-16
8000265e:	c422                	sw	s0,8(sp)
80002660:	80006537          	lui	a0,0x80006
80002664:	c606                	sw	ra,12(sp)
80002666:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
8000266a:	f2850513          	addi	a0,a0,-216 # 80005f28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f29>
	if (test_status) {
8000266e:	cf91                	beqz	a5,8000268a <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
80002670:	8cbff0ef          	jal	ra,80001f3a <printk>
80002674:	800065b7          	lui	a1,0x80006
80002678:	ed458593          	addi	a1,a1,-300 # 80005ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ed5>
	} else {
		TC_END_REPORT(TC_PASS);
8000267c:	edc40513          	addi	a0,s0,-292 # 80005edc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005edd>
	}
}
80002680:	4422                	lw	s0,8(sp)
80002682:	40b2                	lw	ra,12(sp)
80002684:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002686:	8b5ff06f          	j	80001f3a <printk>
8000268a:	8b1ff0ef          	jal	ra,80001f3a <printk>
8000268e:	800065b7          	lui	a1,0x80006
80002692:	ef458593          	addi	a1,a1,-268 # 80005ef4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef5>
80002696:	b7dd                	j	8000267c <end_report+0x28>

80002698 <main>:

	return test_status;
}
#else
void main(void)
{
80002698:	1141                	addi	sp,sp,-16
8000269a:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
8000269c:	b18fe0ef          	jal	ra,800009b4 <test_main>
	end_report();
}
800026a0:	40b2                	lw	ra,12(sp)
800026a2:	0141                	addi	sp,sp,16
	end_report();
800026a4:	bf45                	j	80002654 <end_report>

800026a6 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
800026a6:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
800026a8:	c602                	sw	zero,12(sp)
    i++;
800026aa:	47b2                	lw	a5,12(sp)
800026ac:	0785                	addi	a5,a5,1
800026ae:	c63e                	sw	a5,12(sp)
    uart[0] = c;
800026b0:	f00107b7          	lui	a5,0xf0010
800026b4:	c38c                	sw	a1,0(a5)
}
800026b6:	0141                	addi	sp,sp,16
800026b8:	8082                	ret

800026ba <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800026ba:	557d                	li	a0,-1
800026bc:	8082                	ret

800026be <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
800026be:	4501                	li	a0,0
800026c0:	8082                	ret

800026c2 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800026c2:	00251713          	slli	a4,a0,0x2
800026c6:	800067b7          	lui	a5,0x80006
800026ca:	0505                	addi	a0,a0,1
800026cc:	fe078793          	addi	a5,a5,-32 # 80005fe0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fe1>
800026d0:	050a                	slli	a0,a0,0x2
{
800026d2:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800026d4:	973e                	add	a4,a4,a5
800026d6:	97aa                	add	a5,a5,a0
{
800026d8:	c422                	sw	s0,8(sp)
800026da:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800026dc:	4300                	lw	s0,0(a4)
800026de:	4384                	lw	s1,0(a5)
{
800026e0:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800026e2:	00946763          	bltu	s0,s1,800026f0 <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800026e6:	40b2                	lw	ra,12(sp)
800026e8:	4422                	lw	s0,8(sp)
800026ea:	4492                	lw	s1,4(sp)
800026ec:	0141                	addi	sp,sp,16
800026ee:	8082                	ret
		retval = device_conf->init(info);
800026f0:	401c                	lw	a5,0(s0)
800026f2:	8522                	mv	a0,s0
800026f4:	43dc                	lw	a5,4(a5)
800026f6:	9782                	jalr	a5
		if (retval != 0) {
800026f8:	c119                	beqz	a0,800026fe <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
800026fa:	00042223          	sw	zero,4(s0)
								info++) {
800026fe:	0431                	addi	s0,s0,12
80002700:	b7cd                	j	800026e2 <z_sys_device_do_config_level+0x20>

80002702 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002702:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002704:	800067b7          	lui	a5,0x80006
{
80002708:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
8000270a:	800064b7          	lui	s1,0x80006
{
8000270e:	c422                	sw	s0,8(sp)
80002710:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002712:	48c78413          	addi	s0,a5,1164 # 8000648c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000648d>
{
80002716:	c04a                	sw	s2,0(sp)
80002718:	48c78793          	addi	a5,a5,1164
8000271c:	4bc48493          	addi	s1,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002720:	00941863          	bne	s0,s1,80002730 <z_impl_device_get_binding+0x2e>
80002724:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002726:	843e                	mv	s0,a5
80002728:	00941c63          	bne	s0,s1,80002740 <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
8000272c:	4401                	li	s0,0
8000272e:	a01d                	j	80002754 <z_impl_device_get_binding+0x52>
		if ((info->driver_api != NULL) &&
80002730:	4058                	lw	a4,4(s0)
80002732:	c709                	beqz	a4,8000273c <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
80002734:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002736:	4318                	lw	a4,0(a4)
80002738:	00a70e63          	beq	a4,a0,80002754 <z_impl_device_get_binding+0x52>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000273c:	0431                	addi	s0,s0,12
8000273e:	b7cd                	j	80002720 <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
80002740:	405c                	lw	a5,4(s0)
80002742:	e399                	bnez	a5,80002748 <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002744:	0431                	addi	s0,s0,12
80002746:	b7cd                	j	80002728 <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
80002748:	401c                	lw	a5,0(s0)
8000274a:	854a                	mv	a0,s2
8000274c:	438c                	lw	a1,0(a5)
8000274e:	c33ff0ef          	jal	ra,80002380 <strcmp>
80002752:	f96d                	bnez	a0,80002744 <z_impl_device_get_binding+0x42>
}
80002754:	8522                	mv	a0,s0
80002756:	40b2                	lw	ra,12(sp)
80002758:	4422                	lw	s0,8(sp)
8000275a:	4492                	lw	s1,4(sp)
8000275c:	4902                	lw	s2,0(sp)
8000275e:	0141                	addi	sp,sp,16
80002760:	8082                	ret

80002762 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002762:	1141                	addi	sp,sp,-16
80002764:	c422                	sw	s0,8(sp)
80002766:	c226                	sw	s1,4(sp)
80002768:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000276a:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
8000276c:	4489                	li	s1,2
8000276e:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80002772:	358020ef          	jal	ra,80004aca <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002776:	00a4c363          	blt	s1,a0,8000277c <idle+0x1a>
8000277a:	4505                	li	a0,1
8000277c:	4585                	li	a1,1
8000277e:	406020ef          	jal	ra,80004b84 <z_set_timeout_expiry>
	k_cpu_idle();
80002782:	ffeff0ef          	jal	ra,80001f80 <k_cpu_idle>
80002786:	b7e5                	j	8000276e <idle+0xc>

80002788 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002788:	80006537          	lui	a0,0x80006
8000278c:	800077b7          	lui	a5,0x80007
80002790:	4f850613          	addi	a2,a0,1272 # 800064f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f9>
80002794:	8cc78793          	addi	a5,a5,-1844 # 800068cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068cd>
80002798:	40c78633          	sub	a2,a5,a2
8000279c:	4581                	li	a1,0
8000279e:	4f850513          	addi	a0,a0,1272
800027a2:	c67ff06f          	j	80002408 <memset>

800027a6 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
800027a6:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800027a8:	4509                	li	a0,2
{
800027aa:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800027ac:	3f19                	jal	800026c2 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
800027ae:	80006537          	lui	a0,0x80006
800027b2:	ff450513          	addi	a0,a0,-12 # 80005ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff5>
800027b6:	f84ff0ef          	jal	ra,80001f3a <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
800027ba:	450d                	li	a0,3
800027bc:	3719                	jal	800026c2 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
800027be:	6b3010ef          	jal	ra,80004670 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
800027c2:	3dd9                	jal	80002698 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
800027c4:	800077b7          	lui	a5,0x80007
800027c8:	83078793          	addi	a5,a5,-2000 # 80006830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006831>
800027cc:	00c7c703          	lbu	a4,12(a5)
800027d0:	9b79                	andi	a4,a4,-2
800027d2:	00e78623          	sb	a4,12(a5)
}
800027d6:	40b2                	lw	ra,12(sp)
800027d8:	0141                	addi	sp,sp,16
800027da:	8082                	ret

800027dc <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
800027dc:	7135                	addi	sp,sp,-160
800027de:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
800027e0:	800087b7          	lui	a5,0x80008
800027e4:	80007437          	lui	s0,0x80007
800027e8:	c74e                	sw	s3,140(sp)
800027ea:	ed078793          	addi	a5,a5,-304 # 80007ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ed1>
800027ee:	8a040993          	addi	s3,s0,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
800027f2:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800027f6:	081c                	addi	a5,sp,16
800027f8:	07000613          	li	a2,112
800027fc:	4581                	li	a1,0
800027fe:	853e                	mv	a0,a5
{
80002800:	cf06                	sw	ra,156(sp)
80002802:	cb26                	sw	s1,148(sp)
80002804:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002806:	c03ff0ef          	jal	ra,80002408 <memset>
8000280a:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
8000280c:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002810:	4501                	li	a0,0
	struct k_thread dummy_thread = {
80002812:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002816:	3575                	jal	800026c2 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002818:	4505                	li	a0,1
8000281a:	3565                	jal	800026c2 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
8000281c:	10100793          	li	a5,257
80002820:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002824:	524010ef          	jal	ra,80003d48 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002828:	800067b7          	lui	a5,0x80006
8000282c:	03878793          	addi	a5,a5,56 # 80006038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006039>
	_kernel.ready_q.cache = _main_thread;
80002830:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
80002834:	c23e                	sw	a5,4(sp)
80002836:	800026b7          	lui	a3,0x80002
8000283a:	4785                	li	a5,1
8000283c:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002840:	83090493          	addi	s1,s2,-2000 # 80006830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006831>
	z_setup_new_thread(_main_thread, _main_stack,
80002844:	c03e                	sw	a5,0(sp)
80002846:	4701                	li	a4,0
80002848:	4781                	li	a5,0
8000284a:	4881                	li	a7,0
8000284c:	4801                	li	a6,0
8000284e:	7a668693          	addi	a3,a3,1958 # 800027a6 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800027a7>
80002852:	20000613          	li	a2,512
80002856:	2d058593          	addi	a1,a1,720 # 800072d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d1>
8000285a:	83090513          	addi	a0,s2,-2000
	_kernel.ready_q.cache = _main_thread;
8000285e:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002862:	37b010ef          	jal	ra,800043dc <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002866:	00d4c783          	lbu	a5,13(s1)
8000286a:	8a040413          	addi	s0,s0,-1888
8000286e:	ffb7f713          	andi	a4,a5,-5
80002872:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002876:	8bed                	andi	a5,a5,27
80002878:	e799                	bnez	a5,80002886 <z_cstart+0xaa>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
8000287a:	4c9c                	lw	a5,24(s1)
8000287c:	e789                	bnez	a5,80002886 <z_cstart+0xaa>
		z_add_thread_to_ready_q(thread);
8000287e:	83090513          	addi	a0,s2,-2000
80002882:	4a3000ef          	jal	ra,80003524 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002886:	800067b7          	lui	a5,0x80006
8000288a:	04078793          	addi	a5,a5,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
8000288e:	c23e                	sw	a5,4(sp)
80002890:	80006537          	lui	a0,0x80006
80002894:	4785                	li	a5,1
80002896:	800026b7          	lui	a3,0x80002
8000289a:	800075b7          	lui	a1,0x80007
8000289e:	7c050493          	addi	s1,a0,1984 # 800067c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c1>
800028a2:	c03e                	sw	a5,0(sp)
800028a4:	48bd                	li	a7,15
800028a6:	4801                	li	a6,0
800028a8:	4781                	li	a5,0
800028aa:	4701                	li	a4,0
800028ac:	76268693          	addi	a3,a3,1890 # 80002762 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002763>
800028b0:	20000613          	li	a2,512
800028b4:	4d058593          	addi	a1,a1,1232 # 800074d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074d1>
800028b8:	7c050513          	addi	a0,a0,1984
800028bc:	321010ef          	jal	ra,800043dc <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800028c0:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800028c4:	c444                	sw	s1,12(s0)
800028c6:	4521                	li	a0,8
800028c8:	9bed                	andi	a5,a5,-5
800028ca:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800028ce:	800077b7          	lui	a5,0x80007
800028d2:	8b878793          	addi	a5,a5,-1864 # 800068b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068b9>
800028d6:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800028d8:	cc5c                	sw	a5,28(s0)
800028da:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800028de:	8921                	andi	a0,a0,8
800028e0:	8f1fd0ef          	jal	ra,800001d0 <__swap>

800028e4 <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800028e4:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
800028e8:	1101                	addi	sp,sp,-32
800028ea:	cc22                	sw	s0,24(sp)
800028ec:	ce06                	sw	ra,28(sp)
800028ee:	8bfd                	andi	a5,a5,31
800028f0:	842a                	mv	s0,a0
800028f2:	e799                	bnez	a5,80002900 <prepare_thread_to_run+0x1c>
	if (z_is_thread_ready(thread)) {
800028f4:	4d1c                	lw	a5,24(a0)
800028f6:	e789                	bnez	a5,80002900 <prepare_thread_to_run+0x1c>
800028f8:	c62e                	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
800028fa:	42b000ef          	jal	ra,80003524 <z_add_thread_to_ready_q>
800028fe:	45b2                	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80002900:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
80002904:	c84c                	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
80002906:	40f2                	lw	ra,28(sp)
80002908:	4462                	lw	s0,24(sp)
8000290a:	6105                	addi	sp,sp,32
8000290c:	8082                	ret

8000290e <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
8000290e:	1101                	addi	sp,sp,-32
80002910:	cc22                	sw	s0,24(sp)
80002912:	ca26                	sw	s1,20(sp)
80002914:	c84a                	sw	s2,16(sp)
80002916:	c64e                	sw	s3,12(sp)
80002918:	c452                	sw	s4,8(sp)
8000291a:	c05a                	sw	s6,0(sp)
8000291c:	ce06                	sw	ra,28(sp)
8000291e:	c256                	sw	s5,4(sp)
80002920:	842a                	mv	s0,a0
80002922:	89ae                	mv	s3,a1
80002924:	8a32                	mv	s4,a2
80002926:	8b36                	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002928:	00850913          	addi	s2,a0,8
8000292c:	44a1                	li	s1,8
8000292e:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002932:	854a                	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002934:	88a1                	andi	s1,s1,8
80002936:	32f010ef          	jal	ra,80004464 <z_spin_lock_valid>
8000293a:	ed0d                	bnez	a0,80002974 <queue_insert+0x66>
8000293c:	80006ab7          	lui	s5,0x80006
80002940:	800065b7          	lui	a1,0x80006
80002944:	80006537          	lui	a0,0x80006
80002948:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
8000294c:	04e00693          	li	a3,78
80002950:	e54a8613          	addi	a2,s5,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002954:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002958:	de2ff0ef          	jal	ra,80001f3a <printk>
8000295c:	80006537          	lui	a0,0x80006
80002960:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80002964:	dd6ff0ef          	jal	ra,80001f3a <printk>
80002968:	04e00593          	li	a1,78
8000296c:	e54a8513          	addi	a0,s5,-428
80002970:	de8ff0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80002974:	854a                	mv	a0,s2
80002976:	32b010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
8000297a:	00c40513          	addi	a0,s0,12
8000297e:	208010ef          	jal	ra,80003b86 <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
80002982:	c901                	beqz	a0,80002992 <queue_insert+0x84>
		prepare_thread_to_run(first_pending_thread, data);
80002984:	85d2                	mv	a1,s4
80002986:	3fb9                	jal	800028e4 <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
80002988:	854a                	mv	a0,s2
8000298a:	85a6                	mv	a1,s1
8000298c:	25b1                	jal	80002fd8 <z_reschedule>
	return 0;
8000298e:	4501                	li	a0,0
80002990:	a891                	j	800029e4 <queue_insert+0xd6>
	if (alloc) {
80002992:	080b0363          	beqz	s6,80002a18 <queue_insert+0x10a>
		anode = z_thread_malloc(sizeof(*anode));
80002996:	4521                	li	a0,8
80002998:	07b020ef          	jal	ra,80005212 <z_thread_malloc>
		if (anode == NULL) {
8000299c:	ed31                	bnez	a0,800029f8 <queue_insert+0xea>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000299e:	854a                	mv	a0,s2
800029a0:	2df010ef          	jal	ra,8000447e <z_spin_unlock_valid>
800029a4:	ed0d                	bnez	a0,800029de <queue_insert+0xd0>
800029a6:	80006437          	lui	s0,0x80006
800029aa:	800065b7          	lui	a1,0x80006
800029ae:	80006537          	lui	a0,0x80006
800029b2:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800029b6:	06100693          	li	a3,97
800029ba:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800029be:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800029c2:	d78ff0ef          	jal	ra,80001f3a <printk>
800029c6:	80006537          	lui	a0,0x80006
800029ca:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
800029ce:	d6cff0ef          	jal	ra,80001f3a <printk>
800029d2:	06100593          	li	a1,97
800029d6:	e5440513          	addi	a0,s0,-428
800029da:	d7eff0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800029de:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
800029e2:	5551                	li	a0,-12
}
800029e4:	40f2                	lw	ra,28(sp)
800029e6:	4462                	lw	s0,24(sp)
800029e8:	44d2                	lw	s1,20(sp)
800029ea:	4942                	lw	s2,16(sp)
800029ec:	49b2                	lw	s3,12(sp)
800029ee:	4a22                	lw	s4,8(sp)
800029f0:	4a92                	lw	s5,4(sp)
800029f2:	4b02                	lw	s6,0(sp)
800029f4:	6105                	addi	sp,sp,32
800029f6:	8082                	ret
	node->next_and_flags = flags;
800029f8:	4785                	li	a5,1
		anode->data = data;
800029fa:	01452223          	sw	s4,4(a0)
800029fe:	c11c                	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
80002a00:	411c                	lw	a5,0(a0)
80002a02:	8b8d                	andi	a5,a5,3
80002a04:	00099e63          	bnez	s3,80002a20 <queue_insert+0x112>
	parent->next_and_flags = cur_flags | (unative_t)child;
80002a08:	4018                	lw	a4,0(s0)
80002a0a:	8fd9                	or	a5,a5,a4
80002a0c:	c11c                	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002a0e:	405c                	lw	a5,4(s0)
	list->head = node;
80002a10:	c008                	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002a12:	fbbd                	bnez	a5,80002988 <queue_insert+0x7a>
	list->tail = node;
80002a14:	c048                	sw	a0,4(s0)
80002a16:	bf8d                	j	80002988 <queue_insert+0x7a>
	node->next_and_flags = flags;
80002a18:	000a2023          	sw	zero,0(s4)
80002a1c:	8552                	mv	a0,s4
80002a1e:	b7cd                	j	80002a00 <queue_insert+0xf2>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002a20:	0009a703          	lw	a4,0(s3)
80002a24:	9b71                	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
80002a26:	ef01                	bnez	a4,80002a3e <queue_insert+0x130>
Z_GENLIST_APPEND(sflist, sfnode)
80002a28:	4058                	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002a2a:	c11c                	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80002a2c:	e701                	bnez	a4,80002a34 <queue_insert+0x126>
	list->tail = node;
80002a2e:	c048                	sw	a0,4(s0)
	list->head = node;
80002a30:	c008                	sw	a0,0(s0)
80002a32:	bf99                	j	80002988 <queue_insert+0x7a>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002a34:	431c                	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002a36:	8b8d                	andi	a5,a5,3
80002a38:	8fc9                	or	a5,a5,a0
80002a3a:	c31c                	sw	a5,0(a4)
80002a3c:	bfe1                	j	80002a14 <queue_insert+0x106>
80002a3e:	8fd9                	or	a5,a5,a4
80002a40:	c11c                	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002a42:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002a46:	8b8d                	andi	a5,a5,3
80002a48:	8d5d                	or	a0,a0,a5
80002a4a:	00a9a023          	sw	a0,0(s3)
80002a4e:	bf2d                	j	80002988 <queue_insert+0x7a>

80002a50 <z_queue_node_peek>:
{
80002a50:	1141                	addi	sp,sp,-16
80002a52:	c422                	sw	s0,8(sp)
80002a54:	c606                	sw	ra,12(sp)
80002a56:	842a                	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
80002a58:	c901                	beqz	a0,80002a68 <z_queue_node_peek+0x18>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002a5a:	411c                	lw	a5,0(a0)
80002a5c:	8b8d                	andi	a5,a5,3
80002a5e:	c789                	beqz	a5,80002a68 <z_queue_node_peek+0x18>
		ret = anode->data;
80002a60:	4140                	lw	s0,4(a0)
		if (needs_free) {
80002a62:	c199                	beqz	a1,80002a68 <z_queue_node_peek+0x18>
			k_free(anode);
80002a64:	7a4020ef          	jal	ra,80005208 <k_free>
}
80002a68:	8522                	mv	a0,s0
80002a6a:	40b2                	lw	ra,12(sp)
80002a6c:	4422                	lw	s0,8(sp)
80002a6e:	0141                	addi	sp,sp,16
80002a70:	8082                	ret

80002a72 <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80002a72:	00c50793          	addi	a5,a0,12
	list->head = NULL;
80002a76:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
80002a7a:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
80002a7e:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
80002a82:	c55c                	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
80002a84:	c91c                	sw	a5,16(a0)
}
80002a86:	8082                	ret

80002a88 <z_impl_k_queue_cancel_wait>:
{
80002a88:	1101                	addi	sp,sp,-32
80002a8a:	cc22                	sw	s0,24(sp)
80002a8c:	ca26                	sw	s1,20(sp)
80002a8e:	c84a                	sw	s2,16(sp)
80002a90:	ce06                	sw	ra,28(sp)
80002a92:	c64e                	sw	s3,12(sp)
80002a94:	892a                	mv	s2,a0
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002a96:	00850493          	addi	s1,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002a9a:	4421                	li	s0,8
80002a9c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002aa0:	8526                	mv	a0,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80002aa2:	8821                	andi	s0,s0,8
80002aa4:	1c1010ef          	jal	ra,80004464 <z_spin_lock_valid>
80002aa8:	ed0d                	bnez	a0,80002ae2 <z_impl_k_queue_cancel_wait+0x5a>
80002aaa:	800069b7          	lui	s3,0x80006
80002aae:	800065b7          	lui	a1,0x80006
80002ab2:	80006537          	lui	a0,0x80006
80002ab6:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80002aba:	04e00693          	li	a3,78
80002abe:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002ac2:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002ac6:	c74ff0ef          	jal	ra,80001f3a <printk>
80002aca:	80006537          	lui	a0,0x80006
80002ace:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80002ad2:	c68ff0ef          	jal	ra,80001f3a <printk>
80002ad6:	04e00593          	li	a1,78
80002ada:	e5498513          	addi	a0,s3,-428
80002ade:	c7aff0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80002ae2:	8526                	mv	a0,s1
80002ae4:	1bd010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
80002ae8:	00c90513          	addi	a0,s2,12
80002aec:	09a010ef          	jal	ra,80003b86 <z_unpend_first_thread>
	if (first_pending_thread != NULL) {
80002af0:	c119                	beqz	a0,80002af6 <z_impl_k_queue_cancel_wait+0x6e>
		prepare_thread_to_run(first_pending_thread, NULL);
80002af2:	4581                	li	a1,0
80002af4:	3bc5                	jal	800028e4 <prepare_thread_to_run>
	z_reschedule(&queue->lock, key);
80002af6:	85a2                	mv	a1,s0
}
80002af8:	4462                	lw	s0,24(sp)
80002afa:	40f2                	lw	ra,28(sp)
80002afc:	4942                	lw	s2,16(sp)
80002afe:	49b2                	lw	s3,12(sp)
	z_reschedule(&queue->lock, key);
80002b00:	8526                	mv	a0,s1
}
80002b02:	44d2                	lw	s1,20(sp)
80002b04:	6105                	addi	sp,sp,32
	z_reschedule(&queue->lock, key);
80002b06:	a9c9                	j	80002fd8 <z_reschedule>

80002b08 <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
80002b08:	862e                	mv	a2,a1
80002b0a:	414c                	lw	a1,4(a0)
80002b0c:	4681                	li	a3,0
80002b0e:	b501                	j	8000290e <queue_insert>

80002b10 <k_queue_append_list>:
					   (void *)data);
}
#endif

void k_queue_append_list(struct k_queue *queue, void *head, void *tail)
{
80002b10:	1101                	addi	sp,sp,-32
80002b12:	cc22                	sw	s0,24(sp)
80002b14:	c84a                	sw	s2,16(sp)
80002b16:	c452                	sw	s4,8(sp)
80002b18:	ce06                	sw	ra,28(sp)
80002b1a:	ca26                	sw	s1,20(sp)
80002b1c:	c64e                	sw	s3,12(sp)
80002b1e:	c256                	sw	s5,4(sp)
80002b20:	892a                	mv	s2,a0
80002b22:	842e                	mv	s0,a1
80002b24:	8a32                	mv	s4,a2
	__ASSERT(head && tail, "invalid head or tail");
80002b26:	c191                	beqz	a1,80002b2a <k_queue_append_list+0x1a>
80002b28:	ee0d                	bnez	a2,80002b62 <k_queue_append_list+0x52>
80002b2a:	800064b7          	lui	s1,0x80006
80002b2e:	800065b7          	lui	a1,0x80006
80002b32:	80006537          	lui	a0,0x80006
80002b36:	05c58593          	addi	a1,a1,92 # 8000605c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000605d>
80002b3a:	0ed00693          	li	a3,237
80002b3e:	04848613          	addi	a2,s1,72 # 80006048 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006049>
80002b42:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002b46:	bf4ff0ef          	jal	ra,80001f3a <printk>
80002b4a:	80006537          	lui	a0,0x80006
80002b4e:	06c50513          	addi	a0,a0,108 # 8000606c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000606d>
80002b52:	be8ff0ef          	jal	ra,80001f3a <printk>
80002b56:	0ed00593          	li	a1,237
80002b5a:	04848513          	addi	a0,s1,72
80002b5e:	bfaff0ef          	jal	ra,80001f58 <assert_post_action>

	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002b62:	00890993          	addi	s3,s2,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002b66:	44a1                	li	s1,8
80002b68:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002b6c:	854e                	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
80002b6e:	88a1                	andi	s1,s1,8
80002b70:	0f5010ef          	jal	ra,80004464 <z_spin_lock_valid>
80002b74:	ed0d                	bnez	a0,80002bae <k_queue_append_list+0x9e>
80002b76:	80006ab7          	lui	s5,0x80006
80002b7a:	800065b7          	lui	a1,0x80006
80002b7e:	80006537          	lui	a0,0x80006
80002b82:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80002b86:	04e00693          	li	a3,78
80002b8a:	e54a8613          	addi	a2,s5,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002b8e:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002b92:	ba8ff0ef          	jal	ra,80001f3a <printk>
80002b96:	80006537          	lui	a0,0x80006
80002b9a:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80002b9e:	b9cff0ef          	jal	ra,80001f3a <printk>
80002ba2:	04e00593          	li	a1,78
80002ba6:	e54a8513          	addi	a0,s5,-428
80002baa:	baeff0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80002bae:	854e                	mv	a0,s3
80002bb0:	0f1010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *thread = NULL;

	if (head != NULL) {
80002bb4:	c41d                	beqz	s0,80002be2 <k_queue_append_list+0xd2>
		thread = z_unpend_first_thread(&queue->wait_q);
80002bb6:	00c90a93          	addi	s5,s2,12
80002bba:	8556                	mv	a0,s5
80002bbc:	7cb000ef          	jal	ra,80003b86 <z_unpend_first_thread>
	}

	while ((head != NULL) && (thread != NULL)) {
80002bc0:	e909                	bnez	a0,80002bd2 <k_queue_append_list+0xc2>
Z_GENLIST_APPEND_LIST(sflist, sfnode)
80002bc2:	00492703          	lw	a4,4(s2)
80002bc6:	eb0d                	bnez	a4,80002bf8 <k_queue_append_list+0xe8>
	list->head = node;
80002bc8:	00892023          	sw	s0,0(s2)
	list->tail = node;
80002bcc:	01492223          	sw	s4,4(s2)
80002bd0:	a809                	j	80002be2 <k_queue_append_list+0xd2>
		prepare_thread_to_run(thread, head);
80002bd2:	85a2                	mv	a1,s0
80002bd4:	d11ff0ef          	jal	ra,800028e4 <prepare_thread_to_run>
		head = *(void **)head;
80002bd8:	4000                	lw	s0,0(s0)
		thread = z_unpend_first_thread(&queue->wait_q);
80002bda:	8556                	mv	a0,s5
80002bdc:	7ab000ef          	jal	ra,80003b86 <z_unpend_first_thread>
	while ((head != NULL) && (thread != NULL)) {
80002be0:	f065                	bnez	s0,80002bc0 <k_queue_append_list+0xb0>
	sys_sflist_append_list(&queue->data_q, head, tail);
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* !CONFIG_POLL */

	z_reschedule(&queue->lock, key);
}
80002be2:	4462                	lw	s0,24(sp)
80002be4:	40f2                	lw	ra,28(sp)
80002be6:	4942                	lw	s2,16(sp)
80002be8:	4a22                	lw	s4,8(sp)
80002bea:	4a92                	lw	s5,4(sp)
	z_reschedule(&queue->lock, key);
80002bec:	85a6                	mv	a1,s1
80002bee:	854e                	mv	a0,s3
}
80002bf0:	44d2                	lw	s1,20(sp)
80002bf2:	49b2                	lw	s3,12(sp)
80002bf4:	6105                	addi	sp,sp,32
	z_reschedule(&queue->lock, key);
80002bf6:	a6cd                	j	80002fd8 <z_reschedule>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002bf8:	431c                	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002bfa:	8b8d                	andi	a5,a5,3
80002bfc:	8c5d                	or	s0,s0,a5
80002bfe:	c300                	sw	s0,0(a4)
80002c00:	b7f1                	j	80002bcc <k_queue_append_list+0xbc>

80002c02 <k_queue_merge_slist>:

void k_queue_merge_slist(struct k_queue *queue, sys_slist_t *list)
{
	__ASSERT(!sys_slist_is_empty(list), "list must not be empty");
80002c02:	419c                	lw	a5,0(a1)
{
80002c04:	1141                	addi	sp,sp,-16
80002c06:	c422                	sw	s0,8(sp)
80002c08:	c04a                	sw	s2,0(sp)
80002c0a:	c606                	sw	ra,12(sp)
80002c0c:	c226                	sw	s1,4(sp)
80002c0e:	892a                	mv	s2,a0
80002c10:	842e                	mv	s0,a1
	__ASSERT(!sys_slist_is_empty(list), "list must not be empty");
80002c12:	ef8d                	bnez	a5,80002c4c <k_queue_merge_slist+0x4a>
80002c14:	800064b7          	lui	s1,0x80006
80002c18:	800065b7          	lui	a1,0x80006
80002c1c:	80006537          	lui	a0,0x80006
80002c20:	08458593          	addi	a1,a1,132 # 80006084 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006085>
80002c24:	10b00693          	li	a3,267
80002c28:	04848613          	addi	a2,s1,72 # 80006048 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006049>
80002c2c:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002c30:	b0aff0ef          	jal	ra,80001f3a <printk>
80002c34:	80006537          	lui	a0,0x80006
80002c38:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80002c3c:	afeff0ef          	jal	ra,80001f3a <printk>
80002c40:	10b00593          	li	a1,267
80002c44:	04848513          	addi	a0,s1,72
80002c48:	b10ff0ef          	jal	ra,80001f58 <assert_post_action>
	 * - list->tail->next = NULL.
	 * - sflist implementation only differs from slist by stuffing
	 *   flag bytes in the lower order bits of the data pointer
	 * - source list is really an slist and not an sflist with flags set
	 */
	k_queue_append_list(queue, list->head, list->tail);
80002c4c:	4050                	lw	a2,4(s0)
80002c4e:	400c                	lw	a1,0(s0)
80002c50:	854a                	mv	a0,s2
80002c52:	3d7d                	jal	80002b10 <k_queue_append_list>
	sys_slist_init(list);
}
80002c54:	40b2                	lw	ra,12(sp)
	list->head = NULL;
80002c56:	00042023          	sw	zero,0(s0)
	list->tail = NULL;
80002c5a:	00042223          	sw	zero,4(s0)
80002c5e:	4422                	lw	s0,8(sp)
80002c60:	4492                	lw	s1,4(sp)
80002c62:	4902                	lw	s2,0(sp)
80002c64:	0141                	addi	sp,sp,16
80002c66:	8082                	ret

80002c68 <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
80002c68:	1101                	addi	sp,sp,-32
80002c6a:	cc22                	sw	s0,24(sp)
80002c6c:	ca26                	sw	s1,20(sp)
80002c6e:	c84a                	sw	s2,16(sp)
80002c70:	c64e                	sw	s3,12(sp)
80002c72:	ce06                	sw	ra,28(sp)
80002c74:	c452                	sw	s4,8(sp)
80002c76:	84aa                	mv	s1,a0
80002c78:	89ae                	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002c7a:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002c7e:	4421                	li	s0,8
80002c80:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c84:	854a                	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002c86:	8821                	andi	s0,s0,8
80002c88:	7dc010ef          	jal	ra,80004464 <z_spin_lock_valid>
80002c8c:	ed0d                	bnez	a0,80002cc6 <z_impl_k_queue_get+0x5e>
80002c8e:	80006a37          	lui	s4,0x80006
80002c92:	800065b7          	lui	a1,0x80006
80002c96:	80006537          	lui	a0,0x80006
80002c9a:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80002c9e:	04e00693          	li	a3,78
80002ca2:	e54a0613          	addi	a2,s4,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002ca6:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002caa:	a90ff0ef          	jal	ra,80001f3a <printk>
80002cae:	80006537          	lui	a0,0x80006
80002cb2:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80002cb6:	a84ff0ef          	jal	ra,80001f3a <printk>
80002cba:	04e00593          	li	a1,78
80002cbe:	e54a0513          	addi	a0,s4,-428
80002cc2:	a96ff0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80002cc6:	854a                	mv	a0,s2
80002cc8:	7d8010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
80002ccc:	4088                	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
80002cce:	c53d                	beqz	a0,80002d3c <z_impl_k_queue_get+0xd4>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002cd0:	411c                	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80002cd2:	40d8                	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002cd4:	9bf1                	andi	a5,a5,-4
	list->head = node;
80002cd6:	c09c                	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80002cd8:	00e51363          	bne	a0,a4,80002cde <z_impl_k_queue_get+0x76>
	list->tail = node;
80002cdc:	c0dc                	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
80002cde:	4585                	li	a1,1
80002ce0:	d71ff0ef          	jal	ra,80002a50 <z_queue_node_peek>
80002ce4:	84aa                	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ce6:	854a                	mv	a0,s2
80002ce8:	796010ef          	jal	ra,8000447e <z_spin_unlock_valid>
80002cec:	ed0d                	bnez	a0,80002d26 <z_impl_k_queue_get+0xbe>
80002cee:	80006937          	lui	s2,0x80006
80002cf2:	800065b7          	lui	a1,0x80006
80002cf6:	80006537          	lui	a0,0x80006
80002cfa:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80002cfe:	06100693          	li	a3,97
80002d02:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002d06:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002d0a:	a30ff0ef          	jal	ra,80001f3a <printk>
80002d0e:	80006537          	lui	a0,0x80006
80002d12:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80002d16:	a24ff0ef          	jal	ra,80001f3a <printk>
80002d1a:	06100593          	li	a1,97
80002d1e:	e5490513          	addi	a0,s2,-428
80002d22:	a36ff0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d26:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
80002d2a:	40f2                	lw	ra,28(sp)
80002d2c:	4462                	lw	s0,24(sp)
80002d2e:	8526                	mv	a0,s1
80002d30:	4942                	lw	s2,16(sp)
80002d32:	44d2                	lw	s1,20(sp)
80002d34:	49b2                	lw	s3,12(sp)
80002d36:	4a22                	lw	s4,8(sp)
80002d38:	6105                	addi	sp,sp,32
80002d3a:	8082                	ret
	if (timeout == K_NO_WAIT) {
80002d3c:	04099663          	bnez	s3,80002d88 <z_impl_k_queue_get+0x120>
80002d40:	854a                	mv	a0,s2
80002d42:	73c010ef          	jal	ra,8000447e <z_spin_unlock_valid>
80002d46:	ed0d                	bnez	a0,80002d80 <z_impl_k_queue_get+0x118>
80002d48:	800064b7          	lui	s1,0x80006
80002d4c:	800065b7          	lui	a1,0x80006
80002d50:	80006537          	lui	a0,0x80006
80002d54:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80002d58:	06100693          	li	a3,97
80002d5c:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002d60:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002d64:	9d6ff0ef          	jal	ra,80001f3a <printk>
80002d68:	80006537          	lui	a0,0x80006
80002d6c:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80002d70:	9caff0ef          	jal	ra,80001f3a <printk>
80002d74:	06100593          	li	a1,97
80002d78:	e5448513          	addi	a0,s1,-428
80002d7c:	9dcff0ef          	jal	ra,80001f58 <assert_post_action>
80002d80:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80002d84:	4481                	li	s1,0
80002d86:	b755                	j	80002d2a <z_impl_k_queue_get+0xc2>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80002d88:	00c48613          	addi	a2,s1,12
80002d8c:	86ce                	mv	a3,s3
80002d8e:	85a2                	mv	a1,s0
80002d90:	854a                	mv	a0,s2
80002d92:	58b000ef          	jal	ra,80003b1c <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
80002d96:	4481                	li	s1,0
80002d98:	f949                	bnez	a0,80002d2a <z_impl_k_queue_get+0xc2>
80002d9a:	800077b7          	lui	a5,0x80007
80002d9e:	8a87a783          	lw	a5,-1880(a5) # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80002da2:	4bc4                	lw	s1,20(a5)
80002da4:	b759                	j	80002d2a <z_impl_k_queue_get+0xc2>

80002da6 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002da6:	00d54783          	lbu	a5,13(a0)
80002daa:	8bfd                	andi	a5,a5,31
80002dac:	e789                	bnez	a5,80002db6 <z_is_thread_ready+0x10>
80002dae:	4d08                	lw	a0,24(a0)
80002db0:	00153513          	seqz	a0,a0
80002db4:	8082                	ret
80002db6:	4501                	li	a0,0
}
80002db8:	8082                	ret

80002dba <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002dba:	1141                	addi	sp,sp,-16
80002dbc:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002dbe:	cf6ff0ef          	jal	ra,800022b4 <z_clock_elapsed>
80002dc2:	800067b7          	lui	a5,0x80006
80002dc6:	5287a783          	lw	a5,1320(a5) # 80006528 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006529>

	z_set_timeout_expiry(slice_time, false);
}
80002dca:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002dcc:	80007737          	lui	a4,0x80007
80002dd0:	953e                	add	a0,a0,a5
80002dd2:	8aa72823          	sw	a0,-1872(a4) # 800068b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068b1>
	z_set_timeout_expiry(slice_time, false);
80002dd6:	4581                	li	a1,0
80002dd8:	853e                	mv	a0,a5
}
80002dda:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002ddc:	5a90106f          	j	80004b84 <z_set_timeout_expiry>

80002de0 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002de0:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002de2:	1141                	addi	sp,sp,-16
80002de4:	c422                	sw	s0,8(sp)
80002de6:	c606                	sw	ra,12(sp)
80002de8:	c226                	sw	s1,4(sp)
80002dea:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002dec:	e79d                	bnez	a5,80002e1a <pended_on.isra.15+0x3a>
80002dee:	800064b7          	lui	s1,0x80006
80002df2:	800065b7          	lui	a1,0x80006
80002df6:	80006537          	lui	a0,0x80006
80002dfa:	15458593          	addi	a1,a1,340 # 80006154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006155>
80002dfe:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002e02:	18300693          	li	a3,387
80002e06:	14048613          	addi	a2,s1,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80002e0a:	930ff0ef          	jal	ra,80001f3a <printk>
80002e0e:	18300593          	li	a1,387
80002e12:	14048513          	addi	a0,s1,320
80002e16:	942ff0ef          	jal	ra,80001f58 <assert_post_action>

	return thread->base.pended_on;
}
80002e1a:	4008                	lw	a0,0(s0)
80002e1c:	40b2                	lw	ra,12(sp)
80002e1e:	4422                	lw	s0,8(sp)
80002e20:	4492                	lw	s1,4(sp)
80002e22:	0141                	addi	sp,sp,16
80002e24:	8082                	ret

80002e26 <k_sched_time_slice_set>:
{
80002e26:	1101                	addi	sp,sp,-32
80002e28:	cc22                	sw	s0,24(sp)
80002e2a:	c64e                	sw	s3,12(sp)
80002e2c:	c452                	sw	s4,8(sp)
80002e2e:	ce06                	sw	ra,28(sp)
80002e30:	ca26                	sw	s1,20(sp)
80002e32:	c84a                	sw	s2,16(sp)
80002e34:	8a2a                	mv	s4,a0
80002e36:	89ae                	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002e38:	4421                	li	s0,8
80002e3a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e3e:	800064b7          	lui	s1,0x80006
80002e42:	52048513          	addi	a0,s1,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80002e46:	8821                	andi	s0,s0,8
80002e48:	61c010ef          	jal	ra,80004464 <z_spin_lock_valid>
80002e4c:	ed0d                	bnez	a0,80002e86 <k_sched_time_slice_set+0x60>
80002e4e:	80006937          	lui	s2,0x80006
80002e52:	800065b7          	lui	a1,0x80006
80002e56:	80006537          	lui	a0,0x80006
80002e5a:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80002e5e:	04e00693          	li	a3,78
80002e62:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002e66:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002e6a:	8d0ff0ef          	jal	ra,80001f3a <printk>
80002e6e:	80006537          	lui	a0,0x80006
80002e72:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80002e76:	8c4ff0ef          	jal	ra,80001f3a <printk>
80002e7a:	04e00593          	li	a1,78
80002e7e:	e5490513          	addi	a0,s2,-428
80002e82:	8d6ff0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80002e86:	52048513          	addi	a0,s1,1312
80002e8a:	616010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002e8e:	800077b7          	lui	a5,0x80007
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002e92:	45a9                	li	a1,10
80002e94:	009a0513          	addi	a0,s4,9
80002e98:	8a07a823          	sw	zero,-1872(a5) # 800068b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068b1>
80002e9c:	a45fd0ef          	jal	ra,800008e0 <__divsi3>
		slice_max_prio = prio;
80002ea0:	800067b7          	lui	a5,0x80006
		slice_time = z_ms_to_ticks(slice);
80002ea4:	80006937          	lui	s2,0x80006
80002ea8:	52a92423          	sw	a0,1320(s2) # 80006528 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006529>
		slice_max_prio = prio;
80002eac:	5337a223          	sw	s3,1316(a5) # 80006524 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006525>
		reset_time_slice();
80002eb0:	3729                	jal	80002dba <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002eb2:	52048513          	addi	a0,s1,1312
80002eb6:	5c8010ef          	jal	ra,8000447e <z_spin_unlock_valid>
80002eba:	ed0d                	bnez	a0,80002ef4 <k_sched_time_slice_set+0xce>
80002ebc:	800064b7          	lui	s1,0x80006
80002ec0:	800065b7          	lui	a1,0x80006
80002ec4:	80006537          	lui	a0,0x80006
80002ec8:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80002ecc:	06100693          	li	a3,97
80002ed0:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002ed4:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002ed8:	862ff0ef          	jal	ra,80001f3a <printk>
80002edc:	80006537          	lui	a0,0x80006
80002ee0:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80002ee4:	856ff0ef          	jal	ra,80001f3a <printk>
80002ee8:	06100593          	li	a1,97
80002eec:	e5448513          	addi	a0,s1,-428
80002ef0:	868ff0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ef4:	30042473          	csrrs	s0,mstatus,s0
}
80002ef8:	40f2                	lw	ra,28(sp)
80002efa:	4462                	lw	s0,24(sp)
80002efc:	44d2                	lw	s1,20(sp)
80002efe:	4942                	lw	s2,16(sp)
80002f00:	49b2                	lw	s3,12(sp)
80002f02:	4a22                	lw	s4,8(sp)
80002f04:	6105                	addi	sp,sp,32
80002f06:	8082                	ret

80002f08 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002f08:	1101                	addi	sp,sp,-32
80002f0a:	cc22                	sw	s0,24(sp)
80002f0c:	c84a                	sw	s2,16(sp)
80002f0e:	ce06                	sw	ra,28(sp)
80002f10:	ca26                	sw	s1,20(sp)
80002f12:	c64e                	sw	s3,12(sp)
80002f14:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f16:	4421                	li	s0,8
80002f18:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f1c:	800064b7          	lui	s1,0x80006
80002f20:	52048513          	addi	a0,s1,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f24:	8821                	andi	s0,s0,8
80002f26:	53e010ef          	jal	ra,80004464 <z_spin_lock_valid>
80002f2a:	ed0d                	bnez	a0,80002f64 <z_unpend_thread_no_timeout+0x5c>
80002f2c:	800069b7          	lui	s3,0x80006
80002f30:	800065b7          	lui	a1,0x80006
80002f34:	80006537          	lui	a0,0x80006
80002f38:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80002f3c:	04e00693          	li	a3,78
80002f40:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002f44:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002f48:	ff3fe0ef          	jal	ra,80001f3a <printk>
80002f4c:	80006537          	lui	a0,0x80006
80002f50:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80002f54:	fe7fe0ef          	jal	ra,80001f3a <printk>
80002f58:	04e00593          	li	a1,78
80002f5c:	e5498513          	addi	a0,s3,-428
80002f60:	ff9fe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80002f64:	52048513          	addi	a0,s1,1312
80002f68:	538010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002f6c:	00890513          	addi	a0,s2,8
80002f70:	3d85                	jal	80002de0 <pended_on.isra.15>
80002f72:	85ca                	mv	a1,s2
80002f74:	2451                	jal	800031f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002f76:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002f7a:	52048513          	addi	a0,s1,1312
80002f7e:	9bf5                	andi	a5,a5,-3
80002f80:	00f906a3          	sb	a5,13(s2)
80002f84:	4fa010ef          	jal	ra,8000447e <z_spin_unlock_valid>
80002f88:	ed0d                	bnez	a0,80002fc2 <z_unpend_thread_no_timeout+0xba>
80002f8a:	800064b7          	lui	s1,0x80006
80002f8e:	800065b7          	lui	a1,0x80006
80002f92:	80006537          	lui	a0,0x80006
80002f96:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80002f9a:	06100693          	li	a3,97
80002f9e:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002fa2:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80002fa6:	f95fe0ef          	jal	ra,80001f3a <printk>
80002faa:	80006537          	lui	a0,0x80006
80002fae:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80002fb2:	f89fe0ef          	jal	ra,80001f3a <printk>
80002fb6:	06100593          	li	a1,97
80002fba:	e5448513          	addi	a0,s1,-428
80002fbe:	f9bfe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002fc2:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80002fc6:	40f2                	lw	ra,28(sp)
80002fc8:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80002fca:	00092423          	sw	zero,8(s2)
}
80002fce:	44d2                	lw	s1,20(sp)
80002fd0:	4942                	lw	s2,16(sp)
80002fd2:	49b2                	lw	s3,12(sp)
80002fd4:	6105                	addi	sp,sp,32
80002fd6:	8082                	ret

80002fd8 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80002fd8:	800077b7          	lui	a5,0x80007
80002fdc:	8a07a783          	lw	a5,-1888(a5) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
{
80002fe0:	1141                	addi	sp,sp,-16
80002fe2:	c422                	sw	s0,8(sp)
80002fe4:	c606                	sw	ra,12(sp)
80002fe6:	c226                	sw	s1,4(sp)
80002fe8:	842e                	mv	s0,a1
	if (resched()) {
80002fea:	e7b9                	bnez	a5,80003038 <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002fec:	492010ef          	jal	ra,8000447e <z_spin_unlock_valid>
80002ff0:	ed0d                	bnez	a0,8000302a <z_reschedule+0x52>
80002ff2:	800064b7          	lui	s1,0x80006
80002ff6:	800065b7          	lui	a1,0x80006
80002ffa:	80006537          	lui	a0,0x80006
80002ffe:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003002:	07800693          	li	a3,120
80003006:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
8000300a:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000300e:	f2dfe0ef          	jal	ra,80001f3a <printk>
80003012:	80006537          	lui	a0,0x80006
80003016:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
8000301a:	f21fe0ef          	jal	ra,80001f3a <printk>
8000301e:	07800593          	li	a1,120
80003022:	e5448513          	addi	a0,s1,-428
80003026:	f33fe0ef          	jal	ra,80001f58 <assert_post_action>
8000302a:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
8000302c:	4422                	lw	s0,8(sp)
8000302e:	40b2                	lw	ra,12(sp)
80003030:	4492                	lw	s1,4(sp)
80003032:	0141                	addi	sp,sp,16
80003034:	99cfd06f          	j	800001d0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003038:	446010ef          	jal	ra,8000447e <z_spin_unlock_valid>
8000303c:	ed0d                	bnez	a0,80003076 <z_reschedule+0x9e>
8000303e:	800064b7          	lui	s1,0x80006
80003042:	800065b7          	lui	a1,0x80006
80003046:	80006537          	lui	a0,0x80006
8000304a:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
8000304e:	06100693          	li	a3,97
80003052:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003056:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000305a:	ee1fe0ef          	jal	ra,80001f3a <printk>
8000305e:	80006537          	lui	a0,0x80006
80003062:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003066:	ed5fe0ef          	jal	ra,80001f3a <printk>
8000306a:	06100593          	li	a1,97
8000306e:	e5448513          	addi	a0,s1,-428
80003072:	ee7fe0ef          	jal	ra,80001f58 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003076:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003078:	30042473          	csrrs	s0,mstatus,s0
8000307c:	40b2                	lw	ra,12(sp)
8000307e:	4422                	lw	s0,8(sp)
80003080:	4492                	lw	s1,4(sp)
80003082:	0141                	addi	sp,sp,16
80003084:	8082                	ret

80003086 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003086:	80007737          	lui	a4,0x80007
8000308a:	8a072703          	lw	a4,-1888(a4) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
8000308e:	e319                	bnez	a4,80003094 <z_reschedule_irqlock+0xe>
80003090:	940fd06f          	j	800001d0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003094:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003098:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
8000309c:	8082                	ret

8000309e <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000309e:	4521                	li	a0,8
800030a0:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
800030a4:	8921                	andi	a0,a0,8
800030a6:	b7c5                	j	80003086 <z_reschedule_irqlock>

800030a8 <k_sched_lock>:

void k_sched_lock(void)
{
800030a8:	1101                	addi	sp,sp,-32
800030aa:	cc22                	sw	s0,24(sp)
800030ac:	ce06                	sw	ra,28(sp)
800030ae:	ca26                	sw	s1,20(sp)
800030b0:	c84a                	sw	s2,16(sp)
800030b2:	c64e                	sw	s3,12(sp)
800030b4:	4421                	li	s0,8
800030b6:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800030ba:	800064b7          	lui	s1,0x80006
800030be:	52048513          	addi	a0,s1,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
800030c2:	8821                	andi	s0,s0,8
800030c4:	3a0010ef          	jal	ra,80004464 <z_spin_lock_valid>
800030c8:	ed0d                	bnez	a0,80003102 <k_sched_lock+0x5a>
800030ca:	80006937          	lui	s2,0x80006
800030ce:	800065b7          	lui	a1,0x80006
800030d2:	80006537          	lui	a0,0x80006
800030d6:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800030da:	04e00693          	li	a3,78
800030de:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800030e2:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800030e6:	e55fe0ef          	jal	ra,80001f3a <printk>
800030ea:	80006537          	lui	a0,0x80006
800030ee:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800030f2:	e49fe0ef          	jal	ra,80001f3a <printk>
800030f6:	04e00593          	li	a1,78
800030fa:	e5490513          	addi	a0,s2,-428
800030fe:	e5bfe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80003102:	52048513          	addi	a0,s1,1312
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80003106:	80007937          	lui	s2,0x80007
8000310a:	396010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
8000310e:	8a092783          	lw	a5,-1888(s2) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
80003112:	8a090913          	addi	s2,s2,-1888
80003116:	cf8d                	beqz	a5,80003150 <k_sched_lock+0xa8>
80003118:	800069b7          	lui	s3,0x80006
8000311c:	800065b7          	lui	a1,0x80006
80003120:	80006537          	lui	a0,0x80006
80003124:	0d858593          	addi	a1,a1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
80003128:	10000693          	li	a3,256
8000312c:	0bc98613          	addi	a2,s3,188 # 800060bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060bd>
80003130:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003134:	e07fe0ef          	jal	ra,80001f3a <printk>
80003138:	80006537          	lui	a0,0x80006
8000313c:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80003140:	dfbfe0ef          	jal	ra,80001f3a <printk>
80003144:	10000593          	li	a1,256
80003148:	0bc98513          	addi	a0,s3,188
8000314c:	e0dfe0ef          	jal	ra,80001f58 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80003150:	00892783          	lw	a5,8(s2)
80003154:	00f7c703          	lbu	a4,15(a5)
80003158:	4785                	li	a5,1
8000315a:	02f71e63          	bne	a4,a5,80003196 <k_sched_lock+0xee>
8000315e:	800069b7          	lui	s3,0x80006
80003162:	800065b7          	lui	a1,0x80006
80003166:	80006537          	lui	a0,0x80006
8000316a:	0f058593          	addi	a1,a1,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
8000316e:	10100693          	li	a3,257
80003172:	0bc98613          	addi	a2,s3,188 # 800060bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060bd>
80003176:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000317a:	dc1fe0ef          	jal	ra,80001f3a <printk>
8000317e:	80006537          	lui	a0,0x80006
80003182:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80003186:	db5fe0ef          	jal	ra,80001f3a <printk>
8000318a:	10100593          	li	a1,257
8000318e:	0bc98513          	addi	a0,s3,188
80003192:	dc7fe0ef          	jal	ra,80001f58 <assert_post_action>

	--_current->base.sched_locked;
80003196:	00892703          	lw	a4,8(s2)
8000319a:	00f74783          	lbu	a5,15(a4)
8000319e:	17fd                	addi	a5,a5,-1
800031a0:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800031a4:	52048513          	addi	a0,s1,1312
800031a8:	2d6010ef          	jal	ra,8000447e <z_spin_unlock_valid>
800031ac:	ed0d                	bnez	a0,800031e6 <k_sched_lock+0x13e>
800031ae:	800064b7          	lui	s1,0x80006
800031b2:	800065b7          	lui	a1,0x80006
800031b6:	80006537          	lui	a0,0x80006
800031ba:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800031be:	06100693          	li	a3,97
800031c2:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800031c6:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800031ca:	d71fe0ef          	jal	ra,80001f3a <printk>
800031ce:	80006537          	lui	a0,0x80006
800031d2:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
800031d6:	d65fe0ef          	jal	ra,80001f3a <printk>
800031da:	06100593          	li	a1,97
800031de:	e5448513          	addi	a0,s1,-428
800031e2:	d77fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800031e6:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800031ea:	40f2                	lw	ra,28(sp)
800031ec:	4462                	lw	s0,24(sp)
800031ee:	44d2                	lw	s1,20(sp)
800031f0:	4942                	lw	s2,16(sp)
800031f2:	49b2                	lw	s3,12(sp)
800031f4:	6105                	addi	sp,sp,32
800031f6:	8082                	ret

800031f8 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800031f8:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800031fc:	4887a783          	lw	a5,1160(a5) # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
{
80003200:	1141                	addi	sp,sp,-16
80003202:	c422                	sw	s0,8(sp)
80003204:	c606                	sw	ra,12(sp)
80003206:	c226                	sw	s1,4(sp)
80003208:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
8000320a:	02f59863          	bne	a1,a5,8000323a <z_priq_dumb_remove+0x42>
8000320e:	800064b7          	lui	s1,0x80006
80003212:	800065b7          	lui	a1,0x80006
80003216:	80006537          	lui	a0,0x80006
8000321a:	1d858593          	addi	a1,a1,472 # 800061d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d9>
8000321e:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003222:	28c00693          	li	a3,652
80003226:	14048613          	addi	a2,s1,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
8000322a:	d11fe0ef          	jal	ra,80001f3a <printk>
8000322e:	28c00593          	li	a1,652
80003232:	14048513          	addi	a0,s1,320
80003236:	d23fe0ef          	jal	ra,80001f58 <assert_post_action>
	node->prev->next = node->next;
8000323a:	4058                	lw	a4,4(s0)
8000323c:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
8000323e:	40b2                	lw	ra,12(sp)
80003240:	4492                	lw	s1,4(sp)
80003242:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80003244:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80003246:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
8000324a:	00042223          	sw	zero,4(s0)
8000324e:	4422                	lw	s0,8(sp)
80003250:	0141                	addi	sp,sp,16
80003252:	8082                	ret

80003254 <z_unpend_thread>:
{
80003254:	1101                	addi	sp,sp,-32
80003256:	cc22                	sw	s0,24(sp)
80003258:	ca26                	sw	s1,20(sp)
8000325a:	ce06                	sw	ra,28(sp)
8000325c:	c84a                	sw	s2,16(sp)
8000325e:	c64e                	sw	s3,12(sp)
80003260:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003262:	44a1                	li	s1,8
80003264:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003268:	80006937          	lui	s2,0x80006
8000326c:	52090513          	addi	a0,s2,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003270:	88a1                	andi	s1,s1,8
80003272:	1f2010ef          	jal	ra,80004464 <z_spin_lock_valid>
80003276:	ed0d                	bnez	a0,800032b0 <z_unpend_thread+0x5c>
80003278:	800069b7          	lui	s3,0x80006
8000327c:	800065b7          	lui	a1,0x80006
80003280:	80006537          	lui	a0,0x80006
80003284:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80003288:	04e00693          	li	a3,78
8000328c:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003290:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003294:	ca7fe0ef          	jal	ra,80001f3a <printk>
80003298:	80006537          	lui	a0,0x80006
8000329c:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800032a0:	c9bfe0ef          	jal	ra,80001f3a <printk>
800032a4:	04e00593          	li	a1,78
800032a8:	e5498513          	addi	a0,s3,-428
800032ac:	cadfe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800032b0:	52090513          	addi	a0,s2,1312
800032b4:	1ec010ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800032b8:	00840513          	addi	a0,s0,8
800032bc:	b25ff0ef          	jal	ra,80002de0 <pended_on.isra.15>
800032c0:	85a2                	mv	a1,s0
800032c2:	3f1d                	jal	800031f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800032c4:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800032c8:	52090513          	addi	a0,s2,1312
800032cc:	9bf5                	andi	a5,a5,-3
800032ce:	00f406a3          	sb	a5,13(s0)
800032d2:	1ac010ef          	jal	ra,8000447e <z_spin_unlock_valid>
800032d6:	ed0d                	bnez	a0,80003310 <z_unpend_thread+0xbc>
800032d8:	80006937          	lui	s2,0x80006
800032dc:	800065b7          	lui	a1,0x80006
800032e0:	80006537          	lui	a0,0x80006
800032e4:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800032e8:	06100693          	li	a3,97
800032ec:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800032f0:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800032f4:	c47fe0ef          	jal	ra,80001f3a <printk>
800032f8:	80006537          	lui	a0,0x80006
800032fc:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003300:	c3bfe0ef          	jal	ra,80001f3a <printk>
80003304:	06100593          	li	a1,97
80003308:	e5490513          	addi	a0,s2,-428
8000330c:	c4dfe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003310:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003314:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003318:	01840513          	addi	a0,s0,24
}
8000331c:	4462                	lw	s0,24(sp)
8000331e:	40f2                	lw	ra,28(sp)
80003320:	44d2                	lw	s1,20(sp)
80003322:	4942                	lw	s2,16(sp)
80003324:	49b2                	lw	s3,12(sp)
80003326:	6105                	addi	sp,sp,32
80003328:	6d80106f          	j	80004a00 <z_abort_timeout>

8000332c <z_priq_dumb_best>:
	return list->head == list;
8000332c:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000332e:	00f51363          	bne	a0,a5,80003334 <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003332:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80003334:	853e                	mv	a0,a5
80003336:	8082                	ret

80003338 <update_cache>:
{
80003338:	1141                	addi	sp,sp,-16
8000333a:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
8000333c:	80007437          	lui	s0,0x80007
{
80003340:	c04a                	sw	s2,0(sp)
80003342:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003344:	8a040513          	addi	a0,s0,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
80003348:	02450513          	addi	a0,a0,36
{
8000334c:	c226                	sw	s1,4(sp)
8000334e:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003350:	3ff1                	jal	8000332c <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80003352:	8a040413          	addi	s0,s0,-1888
80003356:	84aa                	mv	s1,a0
80003358:	e111                	bnez	a0,8000335c <update_cache+0x24>
8000335a:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
8000335c:	06091263          	bnez	s2,800033c0 <update_cache+0x88>
	__ASSERT(_current != NULL, "");
80003360:	441c                	lw	a5,8(s0)
80003362:	ef8d                	bnez	a5,8000339c <update_cache+0x64>
80003364:	80006937          	lui	s2,0x80006
80003368:	800065b7          	lui	a1,0x80006
8000336c:	80006537          	lui	a0,0x80006
80003370:	16c58593          	addi	a1,a1,364 # 8000616c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000616d>
80003374:	07f00693          	li	a3,127
80003378:	14090613          	addi	a2,s2,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
8000337c:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003380:	bbbfe0ef          	jal	ra,80001f3a <printk>
80003384:	80006537          	lui	a0,0x80006
80003388:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
8000338c:	baffe0ef          	jal	ra,80001f3a <printk>
80003390:	07f00593          	li	a1,127
80003394:	14090513          	addi	a0,s2,320
80003398:	bc1fe0ef          	jal	ra,80001f58 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
8000339c:	441c                	lw	a5,8(s0)
8000339e:	00d7c703          	lbu	a4,13(a5)
800033a2:	8b7d                	andi	a4,a4,31
800033a4:	ef11                	bnez	a4,800033c0 <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
800033a6:	00e7d683          	lhu	a3,14(a5)
800033aa:	07f00713          	li	a4,127
800033ae:	00d77963          	bgeu	a4,a3,800033c0 <update_cache+0x88>
		_kernel.ready_q.cache = _current;
800033b2:	d01c                	sw	a5,32(s0)
}
800033b4:	40b2                	lw	ra,12(sp)
800033b6:	4422                	lw	s0,8(sp)
800033b8:	4492                	lw	s1,4(sp)
800033ba:	4902                	lw	s2,0(sp)
800033bc:	0141                	addi	sp,sp,16
800033be:	8082                	ret
		if (th != _current) {
800033c0:	441c                	lw	a5,8(s0)
800033c2:	00978463          	beq	a5,s1,800033ca <update_cache+0x92>
			reset_time_slice();
800033c6:	9f5ff0ef          	jal	ra,80002dba <reset_time_slice>
		_kernel.ready_q.cache = th;
800033ca:	d004                	sw	s1,32(s0)
}
800033cc:	b7e5                	j	800033b4 <update_cache+0x7c>

800033ce <k_sched_unlock>:
{
800033ce:	1101                	addi	sp,sp,-32
800033d0:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800033d2:	80007937          	lui	s2,0x80007
800033d6:	8a090793          	addi	a5,s2,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
800033da:	479c                	lw	a5,8(a5)
{
800033dc:	ce06                	sw	ra,28(sp)
800033de:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800033e0:	00f7c783          	lbu	a5,15(a5)
{
800033e4:	ca26                	sw	s1,20(sp)
800033e6:	c64e                	sw	s3,12(sp)
800033e8:	8a090913          	addi	s2,s2,-1888
	__ASSERT(_current->base.sched_locked != 0, "");
800033ec:	ef8d                	bnez	a5,80003426 <k_sched_unlock+0x58>
800033ee:	80006437          	lui	s0,0x80006
800033f2:	800065b7          	lui	a1,0x80006
800033f6:	80006537          	lui	a0,0x80006
800033fa:	11858593          	addi	a1,a1,280 # 80006118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006119>
800033fe:	22100693          	li	a3,545
80003402:	14040613          	addi	a2,s0,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003406:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000340a:	b31fe0ef          	jal	ra,80001f3a <printk>
8000340e:	80006537          	lui	a0,0x80006
80003412:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80003416:	b25fe0ef          	jal	ra,80001f3a <printk>
8000341a:	22100593          	li	a1,545
8000341e:	14040513          	addi	a0,s0,320
80003422:	b37fe0ef          	jal	ra,80001f58 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80003426:	00092783          	lw	a5,0(s2)
8000342a:	cf8d                	beqz	a5,80003464 <k_sched_unlock+0x96>
8000342c:	80006437          	lui	s0,0x80006
80003430:	800065b7          	lui	a1,0x80006
80003434:	80006537          	lui	a0,0x80006
80003438:	0d858593          	addi	a1,a1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
8000343c:	22200693          	li	a3,546
80003440:	14040613          	addi	a2,s0,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003444:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003448:	af3fe0ef          	jal	ra,80001f3a <printk>
8000344c:	80006537          	lui	a0,0x80006
80003450:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80003454:	ae7fe0ef          	jal	ra,80001f3a <printk>
80003458:	22200593          	li	a1,546
8000345c:	14040513          	addi	a0,s0,320
80003460:	af9fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003464:	4421                	li	s0,8
80003466:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000346a:	800064b7          	lui	s1,0x80006
8000346e:	52048513          	addi	a0,s1,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003472:	8821                	andi	s0,s0,8
80003474:	7f1000ef          	jal	ra,80004464 <z_spin_lock_valid>
80003478:	ed0d                	bnez	a0,800034b2 <k_sched_unlock+0xe4>
8000347a:	800069b7          	lui	s3,0x80006
8000347e:	800065b7          	lui	a1,0x80006
80003482:	80006537          	lui	a0,0x80006
80003486:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
8000348a:	04e00693          	li	a3,78
8000348e:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003492:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003496:	aa5fe0ef          	jal	ra,80001f3a <printk>
8000349a:	80006537          	lui	a0,0x80006
8000349e:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800034a2:	a99fe0ef          	jal	ra,80001f3a <printk>
800034a6:	04e00593          	li	a1,78
800034aa:	e5498513          	addi	a0,s3,-428
800034ae:	aabfe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800034b2:	52048513          	addi	a0,s1,1312
800034b6:	7eb000ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
800034ba:	00892703          	lw	a4,8(s2)
		update_cache(1);
800034be:	4505                	li	a0,1
		++_current->base.sched_locked;
800034c0:	00f74783          	lbu	a5,15(a4)
800034c4:	0785                	addi	a5,a5,1
800034c6:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
800034ca:	e6fff0ef          	jal	ra,80003338 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800034ce:	52048513          	addi	a0,s1,1312
800034d2:	7ad000ef          	jal	ra,8000447e <z_spin_unlock_valid>
800034d6:	ed0d                	bnez	a0,80003510 <k_sched_unlock+0x142>
800034d8:	800064b7          	lui	s1,0x80006
800034dc:	800065b7          	lui	a1,0x80006
800034e0:	80006537          	lui	a0,0x80006
800034e4:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800034e8:	06100693          	li	a3,97
800034ec:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800034f0:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800034f4:	a47fe0ef          	jal	ra,80001f3a <printk>
800034f8:	80006537          	lui	a0,0x80006
800034fc:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003500:	a3bfe0ef          	jal	ra,80001f3a <printk>
80003504:	06100593          	li	a1,97
80003508:	e5448513          	addi	a0,s1,-428
8000350c:	a4dfe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003510:	30042473          	csrrs	s0,mstatus,s0
}
80003514:	4462                	lw	s0,24(sp)
80003516:	40f2                	lw	ra,28(sp)
80003518:	44d2                	lw	s1,20(sp)
8000351a:	4942                	lw	s2,16(sp)
8000351c:	49b2                	lw	s3,12(sp)
8000351e:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
80003520:	b7fff06f          	j	8000309e <z_reschedule_unlocked>

80003524 <z_add_thread_to_ready_q>:
{
80003524:	1101                	addi	sp,sp,-32
80003526:	cc22                	sw	s0,24(sp)
80003528:	ca26                	sw	s1,20(sp)
8000352a:	ce06                	sw	ra,28(sp)
8000352c:	c84a                	sw	s2,16(sp)
8000352e:	c64e                	sw	s3,12(sp)
80003530:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003532:	44a1                	li	s1,8
80003534:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003538:	80006937          	lui	s2,0x80006
8000353c:	52090513          	addi	a0,s2,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003540:	88a1                	andi	s1,s1,8
80003542:	723000ef          	jal	ra,80004464 <z_spin_lock_valid>
80003546:	ed0d                	bnez	a0,80003580 <z_add_thread_to_ready_q+0x5c>
80003548:	800069b7          	lui	s3,0x80006
8000354c:	800065b7          	lui	a1,0x80006
80003550:	80006537          	lui	a0,0x80006
80003554:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80003558:	04e00693          	li	a3,78
8000355c:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003560:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003564:	9d7fe0ef          	jal	ra,80001f3a <printk>
80003568:	80006537          	lui	a0,0x80006
8000356c:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80003570:	9cbfe0ef          	jal	ra,80001f3a <printk>
80003574:	04e00593          	li	a1,78
80003578:	e5498513          	addi	a0,s3,-428
8000357c:	9ddfe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80003580:	52090513          	addi	a0,s2,1312
80003584:	71d000ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003588:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
8000358c:	4887a783          	lw	a5,1160(a5) # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
80003590:	02f41863          	bne	s0,a5,800035c0 <z_add_thread_to_ready_q+0x9c>
80003594:	800069b7          	lui	s3,0x80006
80003598:	800065b7          	lui	a1,0x80006
8000359c:	80006537          	lui	a0,0x80006
800035a0:	1d858593          	addi	a1,a1,472 # 800061d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d9>
800035a4:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800035a8:	27600693          	li	a3,630
800035ac:	14098613          	addi	a2,s3,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
800035b0:	98bfe0ef          	jal	ra,80001f3a <printk>
800035b4:	27600593          	li	a1,630
800035b8:	14098513          	addi	a0,s3,320
800035bc:	99dfe0ef          	jal	ra,80001f58 <assert_post_action>
	return list->head == list;
800035c0:	80007737          	lui	a4,0x80007
800035c4:	8a070693          	addi	a3,a4,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
800035c8:	52dc                	lw	a5,36(a3)
800035ca:	5690                	lw	a2,40(a3)
800035cc:	800076b7          	lui	a3,0x80007
800035d0:	8c468693          	addi	a3,a3,-1852 # 800068c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c5>
800035d4:	8a070713          	addi	a4,a4,-1888
	return sys_dlist_is_empty(list) ? NULL : list->head;
800035d8:	08d78563          	beq	a5,a3,80003662 <z_add_thread_to_ready_q+0x13e>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800035dc:	c3d9                	beqz	a5,80003662 <z_add_thread_to_ready_q+0x13e>
	if (t1->base.prio < t2->base.prio) {
800035de:	00e40583          	lb	a1,14(s0)
800035e2:	00e78503          	lb	a0,14(a5)
800035e6:	06a5da63          	bge	a1,a0,8000365a <z_add_thread_to_ready_q+0x136>
	node->prev = successor->prev;
800035ea:	43d8                	lw	a4,4(a5)
	node->next = successor;
800035ec:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
800035ee:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
800035f0:	c300                	sw	s0,0(a4)
	successor->prev = node;
800035f2:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
800035f4:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
800035f8:	4501                	li	a0,0
800035fa:	0407e793          	ori	a5,a5,64
800035fe:	00f406a3          	sb	a5,13(s0)
80003602:	d37ff0ef          	jal	ra,80003338 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003606:	52090513          	addi	a0,s2,1312
8000360a:	675000ef          	jal	ra,8000447e <z_spin_unlock_valid>
8000360e:	ed0d                	bnez	a0,80003648 <z_add_thread_to_ready_q+0x124>
80003610:	80006437          	lui	s0,0x80006
80003614:	800065b7          	lui	a1,0x80006
80003618:	80006537          	lui	a0,0x80006
8000361c:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003620:	06100693          	li	a3,97
80003624:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003628:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000362c:	90ffe0ef          	jal	ra,80001f3a <printk>
80003630:	80006537          	lui	a0,0x80006
80003634:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003638:	903fe0ef          	jal	ra,80001f3a <printk>
8000363c:	06100593          	li	a1,97
80003640:	e5440513          	addi	a0,s0,-428
80003644:	915fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003648:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000364c:	40f2                	lw	ra,28(sp)
8000364e:	4462                	lw	s0,24(sp)
80003650:	44d2                	lw	s1,20(sp)
80003652:	4942                	lw	s2,16(sp)
80003654:	49b2                	lw	s3,12(sp)
80003656:	6105                	addi	sp,sp,32
80003658:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
8000365a:	00f60463          	beq	a2,a5,80003662 <z_add_thread_to_ready_q+0x13e>
8000365e:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003660:	f3c9                	bnez	a5,800035e2 <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
80003662:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80003664:	571c                	lw	a5,40(a4)
	node->next = list;
80003666:	c014                	sw	a3,0(s0)
	list->tail->next = node;
80003668:	c380                	sw	s0,0(a5)
	list->tail = node;
8000366a:	d700                	sw	s0,40(a4)
8000366c:	b761                	j	800035f4 <z_add_thread_to_ready_q+0xd0>

8000366e <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
8000366e:	ff052783          	lw	a5,-16(a0)
{
80003672:	1101                	addi	sp,sp,-32
80003674:	cc22                	sw	s0,24(sp)
80003676:	c64e                	sw	s3,12(sp)
80003678:	ce06                	sw	ra,28(sp)
8000367a:	ca26                	sw	s1,20(sp)
8000367c:	c84a                	sw	s2,16(sp)
8000367e:	c452                	sw	s4,8(sp)
80003680:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003682:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003686:	cfcd                	beqz	a5,80003740 <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003688:	44a1                	li	s1,8
8000368a:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000368e:	80006937          	lui	s2,0x80006
80003692:	52090513          	addi	a0,s2,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003696:	88a1                	andi	s1,s1,8
80003698:	5cd000ef          	jal	ra,80004464 <z_spin_lock_valid>
8000369c:	ed0d                	bnez	a0,800036d6 <z_thread_timeout+0x68>
8000369e:	80006a37          	lui	s4,0x80006
800036a2:	800065b7          	lui	a1,0x80006
800036a6:	80006537          	lui	a0,0x80006
800036aa:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800036ae:	04e00693          	li	a3,78
800036b2:	e54a0613          	addi	a2,s4,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800036b6:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800036ba:	881fe0ef          	jal	ra,80001f3a <printk>
800036be:	80006537          	lui	a0,0x80006
800036c2:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800036c6:	875fe0ef          	jal	ra,80001f3a <printk>
800036ca:	04e00593          	li	a1,78
800036ce:	e54a0513          	addi	a0,s4,-428
800036d2:	887fe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800036d6:	52090513          	addi	a0,s2,1312
800036da:	5c7000ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800036de:	ff040513          	addi	a0,s0,-16
800036e2:	efeff0ef          	jal	ra,80002de0 <pended_on.isra.15>
800036e6:	85ce                	mv	a1,s3
800036e8:	b11ff0ef          	jal	ra,800031f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800036ec:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036f0:	52090513          	addi	a0,s2,1312
800036f4:	9bf5                	andi	a5,a5,-3
800036f6:	fef40aa3          	sb	a5,-11(s0)
800036fa:	585000ef          	jal	ra,8000447e <z_spin_unlock_valid>
800036fe:	ed0d                	bnez	a0,80003738 <z_thread_timeout+0xca>
80003700:	80006937          	lui	s2,0x80006
80003704:	800065b7          	lui	a1,0x80006
80003708:	80006537          	lui	a0,0x80006
8000370c:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003710:	06100693          	li	a3,97
80003714:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003718:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000371c:	81ffe0ef          	jal	ra,80001f3a <printk>
80003720:	80006537          	lui	a0,0x80006
80003724:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003728:	813fe0ef          	jal	ra,80001f3a <printk>
8000372c:	06100593          	li	a1,97
80003730:	e5490513          	addi	a0,s2,-428
80003734:	825fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003738:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000373c:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003740:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003744:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003746:	9bad                	andi	a5,a5,-21
80003748:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
8000374c:	e5aff0ef          	jal	ra,80002da6 <z_is_thread_ready>
80003750:	c919                	beqz	a0,80003766 <z_thread_timeout+0xf8>
}
80003752:	4462                	lw	s0,24(sp)
80003754:	40f2                	lw	ra,28(sp)
80003756:	44d2                	lw	s1,20(sp)
80003758:	4942                	lw	s2,16(sp)
8000375a:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
8000375c:	854e                	mv	a0,s3
8000375e:	49b2                	lw	s3,12(sp)
80003760:	6105                	addi	sp,sp,32
80003762:	dc3ff06f          	j	80003524 <z_add_thread_to_ready_q>
80003766:	40f2                	lw	ra,28(sp)
80003768:	4462                	lw	s0,24(sp)
8000376a:	44d2                	lw	s1,20(sp)
8000376c:	4942                	lw	s2,16(sp)
8000376e:	49b2                	lw	s3,12(sp)
80003770:	4a22                	lw	s4,8(sp)
80003772:	6105                	addi	sp,sp,32
80003774:	8082                	ret

80003776 <z_move_thread_to_end_of_prio_q>:
{
80003776:	1101                	addi	sp,sp,-32
80003778:	cc22                	sw	s0,24(sp)
8000377a:	c84a                	sw	s2,16(sp)
8000377c:	ce06                	sw	ra,28(sp)
8000377e:	ca26                	sw	s1,20(sp)
80003780:	c64e                	sw	s3,12(sp)
80003782:	c452                	sw	s4,8(sp)
80003784:	c256                	sw	s5,4(sp)
80003786:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003788:	4921                	li	s2,8
8000378a:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000378e:	800069b7          	lui	s3,0x80006
80003792:	52098513          	addi	a0,s3,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003796:	00897913          	andi	s2,s2,8
8000379a:	4cb000ef          	jal	ra,80004464 <z_spin_lock_valid>
8000379e:	ed0d                	bnez	a0,800037d8 <z_move_thread_to_end_of_prio_q+0x62>
800037a0:	800064b7          	lui	s1,0x80006
800037a4:	800065b7          	lui	a1,0x80006
800037a8:	80006537          	lui	a0,0x80006
800037ac:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800037b0:	04e00693          	li	a3,78
800037b4:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800037b8:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800037bc:	f7efe0ef          	jal	ra,80001f3a <printk>
800037c0:	80006537          	lui	a0,0x80006
800037c4:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800037c8:	f72fe0ef          	jal	ra,80001f3a <printk>
800037cc:	04e00593          	li	a1,78
800037d0:	e5448513          	addi	a0,s1,-428
800037d4:	f84fe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800037d8:	52098513          	addi	a0,s3,1312
800037dc:	4c5000ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800037e0:	800074b7          	lui	s1,0x80007
800037e4:	8a048513          	addi	a0,s1,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
800037e8:	85a2                	mv	a1,s0
800037ea:	02450513          	addi	a0,a0,36
800037ee:	a0bff0ef          	jal	ra,800031f8 <z_priq_dumb_remove>
	return thread == _idle_thread;
800037f2:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
800037f6:	4887a783          	lw	a5,1160(a5) # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
800037fa:	80007a37          	lui	s4,0x80007
800037fe:	8a048493          	addi	s1,s1,-1888
80003802:	8c4a0a13          	addi	s4,s4,-1852 # 800068c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c5>
80003806:	02f41863          	bne	s0,a5,80003836 <z_move_thread_to_end_of_prio_q+0xc0>
8000380a:	80006ab7          	lui	s5,0x80006
8000380e:	800065b7          	lui	a1,0x80006
80003812:	80006537          	lui	a0,0x80006
80003816:	1d858593          	addi	a1,a1,472 # 800061d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d9>
8000381a:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000381e:	27600693          	li	a3,630
80003822:	140a8613          	addi	a2,s5,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003826:	f14fe0ef          	jal	ra,80001f3a <printk>
8000382a:	27600593          	li	a1,630
8000382e:	140a8513          	addi	a0,s5,320
80003832:	f26fe0ef          	jal	ra,80001f58 <assert_post_action>
	return list->head == list;
80003836:	50dc                	lw	a5,36(s1)
80003838:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000383a:	09478a63          	beq	a5,s4,800038ce <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000383e:	cbc1                	beqz	a5,800038ce <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
80003840:	00e40683          	lb	a3,14(s0)
80003844:	00e78603          	lb	a2,14(a5)
80003848:	06c6df63          	bge	a3,a2,800038c6 <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
8000384c:	43d8                	lw	a4,4(a5)
	node->next = successor;
8000384e:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80003850:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80003852:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003854:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003856:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
8000385a:	4488                	lw	a0,8(s1)
8000385c:	0407e793          	ori	a5,a5,64
80003860:	8d01                	sub	a0,a0,s0
80003862:	00153513          	seqz	a0,a0
80003866:	00f406a3          	sb	a5,13(s0)
8000386a:	acfff0ef          	jal	ra,80003338 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000386e:	52098513          	addi	a0,s3,1312
80003872:	40d000ef          	jal	ra,8000447e <z_spin_unlock_valid>
80003876:	ed0d                	bnez	a0,800038b0 <z_move_thread_to_end_of_prio_q+0x13a>
80003878:	80006437          	lui	s0,0x80006
8000387c:	800065b7          	lui	a1,0x80006
80003880:	80006537          	lui	a0,0x80006
80003884:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003888:	06100693          	li	a3,97
8000388c:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003890:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003894:	ea6fe0ef          	jal	ra,80001f3a <printk>
80003898:	80006537          	lui	a0,0x80006
8000389c:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
800038a0:	e9afe0ef          	jal	ra,80001f3a <printk>
800038a4:	06100593          	li	a1,97
800038a8:	e5440513          	addi	a0,s0,-428
800038ac:	eacfe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800038b0:	30092973          	csrrs	s2,mstatus,s2
}
800038b4:	40f2                	lw	ra,28(sp)
800038b6:	4462                	lw	s0,24(sp)
800038b8:	44d2                	lw	s1,20(sp)
800038ba:	4942                	lw	s2,16(sp)
800038bc:	49b2                	lw	s3,12(sp)
800038be:	4a22                	lw	s4,8(sp)
800038c0:	4a92                	lw	s5,4(sp)
800038c2:	6105                	addi	sp,sp,32
800038c4:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
800038c6:	00e78463          	beq	a5,a4,800038ce <z_move_thread_to_end_of_prio_q+0x158>
800038ca:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800038cc:	ffa5                	bnez	a5,80003844 <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
800038ce:	c058                	sw	a4,4(s0)
	list->tail->next = node;
800038d0:	549c                	lw	a5,40(s1)
	node->next = list;
800038d2:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800038d6:	c380                	sw	s0,0(a5)
	list->tail = node;
800038d8:	d480                	sw	s0,40(s1)
800038da:	bfb5                	j	80003856 <z_move_thread_to_end_of_prio_q+0xe0>

800038dc <z_time_slice>:
	if (slice_time && sliceable(_current)) {
800038dc:	800067b7          	lui	a5,0x80006
800038e0:	5287a783          	lw	a5,1320(a5) # 80006528 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006529>
800038e4:	cbb1                	beqz	a5,80003938 <z_time_slice+0x5c>
800038e6:	800077b7          	lui	a5,0x80007
800038ea:	8a078793          	addi	a5,a5,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
800038ee:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
800038f0:	07f00693          	li	a3,127
800038f4:	00e75603          	lhu	a2,14(a4)
800038f8:	04c6e063          	bltu	a3,a2,80003938 <z_time_slice+0x5c>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
800038fc:	800066b7          	lui	a3,0x80006
80003900:	00e70603          	lb	a2,14(a4)
80003904:	5246a683          	lw	a3,1316(a3) # 80006524 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006525>
80003908:	02d64863          	blt	a2,a3,80003938 <z_time_slice+0x5c>
	return thread == _idle_thread;
8000390c:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
80003910:	4886a683          	lw	a3,1160(a3) # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
80003914:	02d70263          	beq	a4,a3,80003938 <z_time_slice+0x5c>
		&& !z_is_thread_timeout_active(t);
80003918:	4f14                	lw	a3,24(a4)
8000391a:	ee99                	bnez	a3,80003938 <z_time_slice+0x5c>
		if (ticks >= _current_cpu->slice_ticks) {
8000391c:	4b94                	lw	a3,16(a5)
8000391e:	00d54b63          	blt	a0,a3,80003934 <z_time_slice+0x58>
{
80003922:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003924:	853a                	mv	a0,a4
{
80003926:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003928:	e4fff0ef          	jal	ra,80003776 <z_move_thread_to_end_of_prio_q>
}
8000392c:	40b2                	lw	ra,12(sp)
8000392e:	0141                	addi	sp,sp,16
			reset_time_slice();
80003930:	c8aff06f          	j	80002dba <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003934:	8e89                	sub	a3,a3,a0
80003936:	cb94                	sw	a3,16(a5)
80003938:	8082                	ret

8000393a <z_remove_thread_from_ready_q>:
{
8000393a:	1101                	addi	sp,sp,-32
8000393c:	cc22                	sw	s0,24(sp)
8000393e:	c64e                	sw	s3,12(sp)
80003940:	ce06                	sw	ra,28(sp)
80003942:	ca26                	sw	s1,20(sp)
80003944:	c84a                	sw	s2,16(sp)
80003946:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003948:	4421                	li	s0,8
8000394a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000394e:	800064b7          	lui	s1,0x80006
80003952:	52048513          	addi	a0,s1,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003956:	8821                	andi	s0,s0,8
80003958:	30d000ef          	jal	ra,80004464 <z_spin_lock_valid>
8000395c:	ed0d                	bnez	a0,80003996 <z_remove_thread_from_ready_q+0x5c>
8000395e:	80006937          	lui	s2,0x80006
80003962:	800065b7          	lui	a1,0x80006
80003966:	80006537          	lui	a0,0x80006
8000396a:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
8000396e:	04e00693          	li	a3,78
80003972:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003976:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000397a:	dc0fe0ef          	jal	ra,80001f3a <printk>
8000397e:	80006537          	lui	a0,0x80006
80003982:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80003986:	db4fe0ef          	jal	ra,80001f3a <printk>
8000398a:	04e00593          	li	a1,78
8000398e:	e5490513          	addi	a0,s2,-428
80003992:	dc6fe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80003996:	52048513          	addi	a0,s1,1312
8000399a:	307000ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
8000399e:	00d9c783          	lbu	a5,13(s3)
800039a2:	80007937          	lui	s2,0x80007
800039a6:	8a090913          	addi	s2,s2,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
800039aa:	0407f793          	andi	a5,a5,64
800039ae:	cf81                	beqz	a5,800039c6 <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
800039b0:	85ce                	mv	a1,s3
800039b2:	02490513          	addi	a0,s2,36
800039b6:	843ff0ef          	jal	ra,800031f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
800039ba:	00d9c783          	lbu	a5,13(s3)
800039be:	fbf7f793          	andi	a5,a5,-65
800039c2:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
800039c6:	00892503          	lw	a0,8(s2)
800039ca:	41350533          	sub	a0,a0,s3
800039ce:	00153513          	seqz	a0,a0
800039d2:	967ff0ef          	jal	ra,80003338 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800039d6:	52048513          	addi	a0,s1,1312
800039da:	2a5000ef          	jal	ra,8000447e <z_spin_unlock_valid>
800039de:	ed0d                	bnez	a0,80003a18 <z_remove_thread_from_ready_q+0xde>
800039e0:	800064b7          	lui	s1,0x80006
800039e4:	800065b7          	lui	a1,0x80006
800039e8:	80006537          	lui	a0,0x80006
800039ec:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800039f0:	06100693          	li	a3,97
800039f4:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800039f8:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800039fc:	d3efe0ef          	jal	ra,80001f3a <printk>
80003a00:	80006537          	lui	a0,0x80006
80003a04:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003a08:	d32fe0ef          	jal	ra,80001f3a <printk>
80003a0c:	06100593          	li	a1,97
80003a10:	e5448513          	addi	a0,s1,-428
80003a14:	d44fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003a18:	30042473          	csrrs	s0,mstatus,s0
}
80003a1c:	40f2                	lw	ra,28(sp)
80003a1e:	4462                	lw	s0,24(sp)
80003a20:	44d2                	lw	s1,20(sp)
80003a22:	4942                	lw	s2,16(sp)
80003a24:	49b2                	lw	s3,12(sp)
80003a26:	6105                	addi	sp,sp,32
80003a28:	8082                	ret

80003a2a <pend>:
{
80003a2a:	1101                	addi	sp,sp,-32
80003a2c:	cc22                	sw	s0,24(sp)
80003a2e:	ca26                	sw	s1,20(sp)
80003a30:	842a                	mv	s0,a0
80003a32:	c84a                	sw	s2,16(sp)
80003a34:	ce06                	sw	ra,28(sp)
80003a36:	c64e                	sw	s3,12(sp)
80003a38:	84ae                	mv	s1,a1
80003a3a:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003a3c:	effff0ef          	jal	ra,8000393a <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003a40:	00d44783          	lbu	a5,13(s0)
80003a44:	0027e793          	ori	a5,a5,2
80003a48:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003a4c:	cca9                	beqz	s1,80003aa6 <pend+0x7c>
	return thread == _idle_thread;
80003a4e:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003a52:	4887a783          	lw	a5,1160(a5) # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
		thread->base.pended_on = wait_q;
80003a56:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003a58:	02f41863          	bne	s0,a5,80003a88 <pend+0x5e>
80003a5c:	800069b7          	lui	s3,0x80006
80003a60:	800065b7          	lui	a1,0x80006
80003a64:	80006537          	lui	a0,0x80006
80003a68:	1d858593          	addi	a1,a1,472 # 800061d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d9>
80003a6c:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003a70:	27600693          	li	a3,630
80003a74:	14098613          	addi	a2,s3,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003a78:	cc2fe0ef          	jal	ra,80001f3a <printk>
80003a7c:	27600593          	li	a1,630
80003a80:	14098513          	addi	a0,s3,320
80003a84:	cd4fe0ef          	jal	ra,80001f58 <assert_post_action>
	return list->head == list;
80003a88:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003a8a:	04f48b63          	beq	s1,a5,80003ae0 <pend+0xb6>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003a8e:	cba9                	beqz	a5,80003ae0 <pend+0xb6>
	if (t1->base.prio < t2->base.prio) {
80003a90:	00e40703          	lb	a4,14(s0)
80003a94:	00e78683          	lb	a3,14(a5)
80003a98:	02d75f63          	bge	a4,a3,80003ad6 <pend+0xac>
	node->prev = successor->prev;
80003a9c:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003a9e:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80003aa0:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80003aa2:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003aa4:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003aa6:	57fd                	li	a5,-1
80003aa8:	04f90363          	beq	s2,a5,80003aee <pend+0xc4>
80003aac:	45a9                	li	a1,10
80003aae:	00990513          	addi	a0,s2,9
80003ab2:	e2ffc0ef          	jal	ra,800008e0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003ab6:	00150613          	addi	a2,a0,1
80003aba:	01840513          	addi	a0,s0,24
}
80003abe:	4462                	lw	s0,24(sp)
80003ac0:	40f2                	lw	ra,28(sp)
80003ac2:	44d2                	lw	s1,20(sp)
80003ac4:	4942                	lw	s2,16(sp)
80003ac6:	49b2                	lw	s3,12(sp)
80003ac8:	800035b7          	lui	a1,0x80003
80003acc:	66e58593          	addi	a1,a1,1646 # 8000366e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000366f>
80003ad0:	6105                	addi	sp,sp,32
80003ad2:	5670006f          	j	80004838 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003ad6:	40d4                	lw	a3,4(s1)
80003ad8:	00d78463          	beq	a5,a3,80003ae0 <pend+0xb6>
80003adc:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ade:	fbdd                	bnez	a5,80003a94 <pend+0x6a>
	node->prev = list->tail;
80003ae0:	40dc                	lw	a5,4(s1)
	node->next = list;
80003ae2:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003ae4:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003ae6:	40dc                	lw	a5,4(s1)
80003ae8:	c380                	sw	s0,0(a5)
	list->tail = node;
80003aea:	c0c0                	sw	s0,4(s1)
80003aec:	bf6d                	j	80003aa6 <pend+0x7c>
}
80003aee:	40f2                	lw	ra,28(sp)
80003af0:	4462                	lw	s0,24(sp)
80003af2:	44d2                	lw	s1,20(sp)
80003af4:	4942                	lw	s2,16(sp)
80003af6:	49b2                	lw	s3,12(sp)
80003af8:	6105                	addi	sp,sp,32
80003afa:	8082                	ret

80003afc <z_pend_curr_irqlock>:
{
80003afc:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003afe:	800077b7          	lui	a5,0x80007
{
80003b02:	c422                	sw	s0,8(sp)
80003b04:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80003b06:	8a87a503          	lw	a0,-1880(a5) # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
{
80003b0a:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003b0c:	f1fff0ef          	jal	ra,80003a2a <pend>
80003b10:	8522                	mv	a0,s0
}
80003b12:	4422                	lw	s0,8(sp)
80003b14:	40b2                	lw	ra,12(sp)
80003b16:	0141                	addi	sp,sp,16
80003b18:	eb8fc06f          	j	800001d0 <__swap>

80003b1c <z_pend_curr>:
{
80003b1c:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003b1e:	800077b7          	lui	a5,0x80007
{
80003b22:	c422                	sw	s0,8(sp)
80003b24:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80003b26:	8a87a503          	lw	a0,-1880(a5) # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
{
80003b2a:	c226                	sw	s1,4(sp)
80003b2c:	84ae                	mv	s1,a1
80003b2e:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
80003b30:	8636                	mv	a2,a3
{
80003b32:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003b34:	ef7ff0ef          	jal	ra,80003a2a <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b38:	8522                	mv	a0,s0
80003b3a:	145000ef          	jal	ra,8000447e <z_spin_unlock_valid>
80003b3e:	ed0d                	bnez	a0,80003b78 <z_pend_curr+0x5c>
80003b40:	80006437          	lui	s0,0x80006
80003b44:	800065b7          	lui	a1,0x80006
80003b48:	80006537          	lui	a0,0x80006
80003b4c:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003b50:	07800693          	li	a3,120
80003b54:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003b58:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003b5c:	bdefe0ef          	jal	ra,80001f3a <printk>
80003b60:	80006537          	lui	a0,0x80006
80003b64:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003b68:	bd2fe0ef          	jal	ra,80001f3a <printk>
80003b6c:	07800593          	li	a1,120
80003b70:	e5440513          	addi	a0,s0,-428
80003b74:	be4fe0ef          	jal	ra,80001f58 <assert_post_action>
}
80003b78:	4422                	lw	s0,8(sp)
80003b7a:	40b2                	lw	ra,12(sp)
80003b7c:	8526                	mv	a0,s1
80003b7e:	4492                	lw	s1,4(sp)
80003b80:	0141                	addi	sp,sp,16
80003b82:	e4efc06f          	j	800001d0 <__swap>

80003b86 <z_unpend_first_thread>:
{
80003b86:	1101                	addi	sp,sp,-32
80003b88:	c84a                	sw	s2,16(sp)
80003b8a:	c64e                	sw	s3,12(sp)
80003b8c:	ce06                	sw	ra,28(sp)
80003b8e:	cc22                	sw	s0,24(sp)
80003b90:	ca26                	sw	s1,20(sp)
80003b92:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003b94:	4921                	li	s2,8
80003b96:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003b9a:	800064b7          	lui	s1,0x80006
80003b9e:	52048513          	addi	a0,s1,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003ba2:	00897913          	andi	s2,s2,8
80003ba6:	0bf000ef          	jal	ra,80004464 <z_spin_lock_valid>
80003baa:	ed0d                	bnez	a0,80003be4 <z_unpend_first_thread+0x5e>
80003bac:	80006437          	lui	s0,0x80006
80003bb0:	800065b7          	lui	a1,0x80006
80003bb4:	80006537          	lui	a0,0x80006
80003bb8:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80003bbc:	04e00693          	li	a3,78
80003bc0:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003bc4:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003bc8:	b72fe0ef          	jal	ra,80001f3a <printk>
80003bcc:	80006537          	lui	a0,0x80006
80003bd0:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80003bd4:	b66fe0ef          	jal	ra,80001f3a <printk>
80003bd8:	04e00593          	li	a1,78
80003bdc:	e5440513          	addi	a0,s0,-428
80003be0:	b78fe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80003be4:	52048513          	addi	a0,s1,1312
80003be8:	0b9000ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003bec:	854e                	mv	a0,s3
80003bee:	f3eff0ef          	jal	ra,8000332c <z_priq_dumb_best>
80003bf2:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003bf4:	52048513          	addi	a0,s1,1312
80003bf8:	087000ef          	jal	ra,8000447e <z_spin_unlock_valid>
80003bfc:	ed0d                	bnez	a0,80003c36 <z_unpend_first_thread+0xb0>
80003bfe:	800069b7          	lui	s3,0x80006
80003c02:	800065b7          	lui	a1,0x80006
80003c06:	80006537          	lui	a0,0x80006
80003c0a:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003c0e:	06100693          	li	a3,97
80003c12:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003c16:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003c1a:	b20fe0ef          	jal	ra,80001f3a <printk>
80003c1e:	80006537          	lui	a0,0x80006
80003c22:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003c26:	b14fe0ef          	jal	ra,80001f3a <printk>
80003c2a:	06100593          	li	a1,97
80003c2e:	e5498513          	addi	a0,s3,-428
80003c32:	b26fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c36:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003c3a:	c061                	beqz	s0,80003cfa <z_unpend_first_thread+0x174>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c3c:	4921                	li	s2,8
80003c3e:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c42:	52048513          	addi	a0,s1,1312
	key = (mstatus & SOC_MSTATUS_IEN);
80003c46:	00897913          	andi	s2,s2,8
80003c4a:	01b000ef          	jal	ra,80004464 <z_spin_lock_valid>
80003c4e:	ed0d                	bnez	a0,80003c88 <z_unpend_first_thread+0x102>
80003c50:	800069b7          	lui	s3,0x80006
80003c54:	800065b7          	lui	a1,0x80006
80003c58:	80006537          	lui	a0,0x80006
80003c5c:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80003c60:	04e00693          	li	a3,78
80003c64:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003c68:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003c6c:	acefe0ef          	jal	ra,80001f3a <printk>
80003c70:	80006537          	lui	a0,0x80006
80003c74:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80003c78:	ac2fe0ef          	jal	ra,80001f3a <printk>
80003c7c:	04e00593          	li	a1,78
80003c80:	e5498513          	addi	a0,s3,-428
80003c84:	ad4fe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c88:	52048513          	addi	a0,s1,1312
80003c8c:	015000ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003c90:	00840513          	addi	a0,s0,8
80003c94:	94cff0ef          	jal	ra,80002de0 <pended_on.isra.15>
80003c98:	85a2                	mv	a1,s0
80003c9a:	d5eff0ef          	jal	ra,800031f8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003c9e:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ca2:	52048513          	addi	a0,s1,1312
80003ca6:	9bf5                	andi	a5,a5,-3
80003ca8:	00f406a3          	sb	a5,13(s0)
80003cac:	7d2000ef          	jal	ra,8000447e <z_spin_unlock_valid>
80003cb0:	ed0d                	bnez	a0,80003cea <z_unpend_first_thread+0x164>
80003cb2:	800064b7          	lui	s1,0x80006
80003cb6:	800065b7          	lui	a1,0x80006
80003cba:	80006537          	lui	a0,0x80006
80003cbe:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003cc2:	06100693          	li	a3,97
80003cc6:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003cca:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003cce:	a6cfe0ef          	jal	ra,80001f3a <printk>
80003cd2:	80006537          	lui	a0,0x80006
80003cd6:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003cda:	a60fe0ef          	jal	ra,80001f3a <printk>
80003cde:	06100593          	li	a1,97
80003ce2:	e5448513          	addi	a0,s1,-428
80003ce6:	a72fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003cea:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003cee:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80003cf2:	01840513          	addi	a0,s0,24
80003cf6:	50b000ef          	jal	ra,80004a00 <z_abort_timeout>
}
80003cfa:	8522                	mv	a0,s0
80003cfc:	40f2                	lw	ra,28(sp)
80003cfe:	4462                	lw	s0,24(sp)
80003d00:	44d2                	lw	s1,20(sp)
80003d02:	4942                	lw	s2,16(sp)
80003d04:	49b2                	lw	s3,12(sp)
80003d06:	6105                	addi	sp,sp,32
80003d08:	8082                	ret

80003d0a <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80003d0a:	1141                	addi	sp,sp,-16
80003d0c:	c226                	sw	s1,4(sp)
80003d0e:	c04a                	sw	s2,0(sp)
80003d10:	c606                	sw	ra,12(sp)
80003d12:	c422                	sw	s0,8(sp)
80003d14:	892a                	mv	s2,a0
	int need_sched = 0;
80003d16:	4481                	li	s1,0
	return list->head == list;
80003d18:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003d1c:	00890363          	beq	s2,s0,80003d22 <z_unpend_all+0x18>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80003d20:	e801                	bnez	s0,80003d30 <z_unpend_all+0x26>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80003d22:	40b2                	lw	ra,12(sp)
80003d24:	4422                	lw	s0,8(sp)
80003d26:	8526                	mv	a0,s1
80003d28:	4902                	lw	s2,0(sp)
80003d2a:	4492                	lw	s1,4(sp)
80003d2c:	0141                	addi	sp,sp,16
80003d2e:	8082                	ret
		z_unpend_thread(th);
80003d30:	8522                	mv	a0,s0
80003d32:	d22ff0ef          	jal	ra,80003254 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80003d36:	8522                	mv	a0,s0
80003d38:	86eff0ef          	jal	ra,80002da6 <z_is_thread_ready>
		need_sched = 1;
80003d3c:	4485                	li	s1,1
80003d3e:	dd69                	beqz	a0,80003d18 <z_unpend_all+0xe>
		z_add_thread_to_ready_q(thread);
80003d40:	8522                	mv	a0,s0
80003d42:	fe2ff0ef          	jal	ra,80003524 <z_add_thread_to_ready_q>
80003d46:	bfc9                	j	80003d18 <z_unpend_all+0xe>

80003d48 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003d48:	800077b7          	lui	a5,0x80007
80003d4c:	8a078793          	addi	a5,a5,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
80003d50:	02478713          	addi	a4,a5,36
80003d54:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003d56:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003d58:	4581                	li	a1,0
80003d5a:	4501                	li	a0,0
80003d5c:	8caff06f          	j	80002e26 <k_sched_time_slice_set>

80003d60 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80003d60:	1101                	addi	sp,sp,-32
80003d62:	cc22                	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80003d64:	80007437          	lui	s0,0x80007
80003d68:	8a042783          	lw	a5,-1888(s0) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
{
80003d6c:	ce06                	sw	ra,28(sp)
80003d6e:	ca26                	sw	s1,20(sp)
80003d70:	c84a                	sw	s2,16(sp)
80003d72:	c64e                	sw	s3,12(sp)
80003d74:	c452                	sw	s4,8(sp)
80003d76:	c256                	sw	s5,4(sp)
80003d78:	8a040413          	addi	s0,s0,-1888
	__ASSERT(!z_is_in_isr(), "");
80003d7c:	cf8d                	beqz	a5,80003db6 <z_impl_k_yield+0x56>
80003d7e:	800064b7          	lui	s1,0x80006
80003d82:	800065b7          	lui	a1,0x80006
80003d86:	80006537          	lui	a0,0x80006
80003d8a:	0d858593          	addi	a1,a1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
80003d8e:	37e00693          	li	a3,894
80003d92:	14048613          	addi	a2,s1,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003d96:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003d9a:	9a0fe0ef          	jal	ra,80001f3a <printk>
80003d9e:	80006537          	lui	a0,0x80006
80003da2:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80003da6:	994fe0ef          	jal	ra,80001f3a <printk>
80003daa:	37e00593          	li	a1,894
80003dae:	14048513          	addi	a0,s1,320
80003db2:	9a6fe0ef          	jal	ra,80001f58 <assert_post_action>
	return thread == _idle_thread;
80003db6:	800067b7          	lui	a5,0x80006

	if (!is_idle(_current)) {
80003dba:	4414                	lw	a3,8(s0)
80003dbc:	4887a703          	lw	a4,1160(a5) # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
80003dc0:	8a3e                	mv	s4,a5
80003dc2:	10e68563          	beq	a3,a4,80003ecc <z_impl_k_yield+0x16c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003dc6:	4921                	li	s2,8
80003dc8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003dcc:	800069b7          	lui	s3,0x80006
80003dd0:	52098513          	addi	a0,s3,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
	key = (mstatus & SOC_MSTATUS_IEN);
80003dd4:	00897913          	andi	s2,s2,8
80003dd8:	2571                	jal	80004464 <z_spin_lock_valid>
80003dda:	ed0d                	bnez	a0,80003e14 <z_impl_k_yield+0xb4>
80003ddc:	800064b7          	lui	s1,0x80006
80003de0:	800065b7          	lui	a1,0x80006
80003de4:	80006537          	lui	a0,0x80006
80003de8:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80003dec:	04e00693          	li	a3,78
80003df0:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003df4:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003df8:	942fe0ef          	jal	ra,80001f3a <printk>
80003dfc:	80006537          	lui	a0,0x80006
80003e00:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80003e04:	936fe0ef          	jal	ra,80001f3a <printk>
80003e08:	04e00593          	li	a1,78
80003e0c:	e5448513          	addi	a0,s1,-428
80003e10:	948fe0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80003e14:	52098513          	addi	a0,s3,1312
80003e18:	2561                	jal	800044a0 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80003e1a:	440c                	lw	a1,8(s0)
80003e1c:	02440513          	addi	a0,s0,36
80003e20:	bd8ff0ef          	jal	ra,800031f8 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80003e24:	488a2783          	lw	a5,1160(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80003e28:	4404                	lw	s1,8(s0)
	return thread == _idle_thread;
80003e2a:	80007a37          	lui	s4,0x80007
80003e2e:	8c4a0a13          	addi	s4,s4,-1852 # 800068c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c5>
	__ASSERT_NO_MSG(!is_idle(thread));
80003e32:	02f49863          	bne	s1,a5,80003e62 <z_impl_k_yield+0x102>
80003e36:	80006ab7          	lui	s5,0x80006
80003e3a:	800065b7          	lui	a1,0x80006
80003e3e:	80006537          	lui	a0,0x80006
80003e42:	1d858593          	addi	a1,a1,472 # 800061d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d9>
80003e46:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003e4a:	27600693          	li	a3,630
80003e4e:	140a8613          	addi	a2,s5,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003e52:	8e8fe0ef          	jal	ra,80001f3a <printk>
80003e56:	27600593          	li	a1,630
80003e5a:	140a8513          	addi	a0,s5,320
80003e5e:	8fafe0ef          	jal	ra,80001f58 <assert_post_action>
	return list->head == list;
80003e62:	505c                	lw	a5,36(s0)
80003e64:	5418                	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e66:	09478563          	beq	a5,s4,80003ef0 <z_impl_k_yield+0x190>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003e6a:	c3d9                	beqz	a5,80003ef0 <z_impl_k_yield+0x190>
	if (t1->base.prio < t2->base.prio) {
80003e6c:	00e48683          	lb	a3,14(s1)
80003e70:	00e78603          	lb	a2,14(a5)
80003e74:	06c6da63          	bge	a3,a2,80003ee8 <z_impl_k_yield+0x188>
	node->prev = successor->prev;
80003e78:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003e7a:	c09c                	sw	a5,0(s1)
	node->prev = successor->prev;
80003e7c:	c0d8                	sw	a4,4(s1)
	successor->prev->next = node;
80003e7e:	c304                	sw	s1,0(a4)
	successor->prev = node;
80003e80:	c3c4                	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80003e82:	4505                	li	a0,1
80003e84:	cb4ff0ef          	jal	ra,80003338 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003e88:	52098513          	addi	a0,s3,1312
80003e8c:	2bcd                	jal	8000447e <z_spin_unlock_valid>
80003e8e:	ed0d                	bnez	a0,80003ec8 <z_impl_k_yield+0x168>
80003e90:	80006437          	lui	s0,0x80006
80003e94:	800065b7          	lui	a1,0x80006
80003e98:	80006537          	lui	a0,0x80006
80003e9c:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80003ea0:	06100693          	li	a3,97
80003ea4:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003ea8:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003eac:	88efe0ef          	jal	ra,80001f3a <printk>
80003eb0:	80006537          	lui	a0,0x80006
80003eb4:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80003eb8:	882fe0ef          	jal	ra,80001f3a <printk>
80003ebc:	06100593          	li	a1,97
80003ec0:	e5440513          	addi	a0,s0,-428
80003ec4:	894fe0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ec8:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ecc:	4521                	li	a0,8
80003ece:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
80003ed2:	4462                	lw	s0,24(sp)
80003ed4:	40f2                	lw	ra,28(sp)
80003ed6:	44d2                	lw	s1,20(sp)
80003ed8:	4942                	lw	s2,16(sp)
80003eda:	49b2                	lw	s3,12(sp)
80003edc:	4a22                	lw	s4,8(sp)
80003ede:	4a92                	lw	s5,4(sp)
80003ee0:	8921                	andi	a0,a0,8
80003ee2:	6105                	addi	sp,sp,32
80003ee4:	aecfc06f          	j	800001d0 <__swap>
	return (node == list->tail) ? NULL : node->next;
80003ee8:	00e78463          	beq	a5,a4,80003ef0 <z_impl_k_yield+0x190>
80003eec:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003eee:	f3c9                	bnez	a5,80003e70 <z_impl_k_yield+0x110>
	node->prev = list->tail;
80003ef0:	c0d8                	sw	a4,4(s1)
	list->tail->next = node;
80003ef2:	541c                	lw	a5,40(s0)
	node->next = list;
80003ef4:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80003ef8:	c384                	sw	s1,0(a5)
	list->tail = node;
80003efa:	d404                	sw	s1,40(s0)
80003efc:	b759                	j	80003e82 <z_impl_k_yield+0x122>

80003efe <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
80003efe:	7179                	addi	sp,sp,-48
80003f00:	d422                	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80003f02:	80007437          	lui	s0,0x80007
80003f06:	8a042783          	lw	a5,-1888(s0) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
{
80003f0a:	d226                	sw	s1,36(sp)
80003f0c:	d606                	sw	ra,44(sp)
80003f0e:	d04a                	sw	s2,32(sp)
80003f10:	ce4e                	sw	s3,28(sp)
80003f12:	cc52                	sw	s4,24(sp)
80003f14:	84aa                	mv	s1,a0
80003f16:	8a040413          	addi	s0,s0,-1888
	__ASSERT(!z_is_in_isr(), "");
80003f1a:	cf8d                	beqz	a5,80003f54 <z_impl_k_sleep+0x56>
80003f1c:	80006937          	lui	s2,0x80006
80003f20:	800065b7          	lui	a1,0x80006
80003f24:	80006537          	lui	a0,0x80006
80003f28:	0d858593          	addi	a1,a1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
80003f2c:	39900693          	li	a3,921
80003f30:	14090613          	addi	a2,s2,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003f34:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003f38:	802fe0ef          	jal	ra,80001f3a <printk>
80003f3c:	80006537          	lui	a0,0x80006
80003f40:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80003f44:	ff7fd0ef          	jal	ra,80001f3a <printk>
80003f48:	39900593          	li	a1,921
80003f4c:	14090513          	addi	a0,s2,320
80003f50:	808fe0ef          	jal	ra,80001f58 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80003f54:	57fd                	li	a5,-1
80003f56:	16f49a63          	bne	s1,a5,800040ca <z_impl_k_sleep+0x1cc>
80003f5a:	80006937          	lui	s2,0x80006
80003f5e:	800065b7          	lui	a1,0x80006
80003f62:	80006537          	lui	a0,0x80006
80003f66:	18c58593          	addi	a1,a1,396 # 8000618c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000618d>
80003f6a:	39a00693          	li	a3,922
80003f6e:	14090613          	addi	a2,s2,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80003f72:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003f76:	fc5fd0ef          	jal	ra,80001f3a <printk>
80003f7a:	80006537          	lui	a0,0x80006
80003f7e:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80003f82:	fb9fd0ef          	jal	ra,80001f3a <printk>
80003f86:	39a00593          	li	a1,922
80003f8a:	14090513          	addi	a0,s2,320
80003f8e:	fcbfd0ef          	jal	ra,80001f58 <assert_post_action>
80003f92:	45a9                	li	a1,10
80003f94:	00948513          	addi	a0,s1,9
80003f98:	949fc0ef          	jal	ra,800008e0 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80003f9c:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80003fa0:	77f000ef          	jal	ra,80004f1e <z_tick_get_32>
80003fa4:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
80003fa8:	c602                	sw	zero,12(sp)
80003faa:	44a1                	li	s1,8
80003fac:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003fb0:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003fb2:	88a1                	andi	s1,s1,8
80003fb4:	2945                	jal	80004464 <z_spin_lock_valid>
80003fb6:	ed0d                	bnez	a0,80003ff0 <z_impl_k_sleep+0xf2>
80003fb8:	80006a37          	lui	s4,0x80006
80003fbc:	800065b7          	lui	a1,0x80006
80003fc0:	80006537          	lui	a0,0x80006
80003fc4:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80003fc8:	04e00693          	li	a3,78
80003fcc:	e54a0613          	addi	a2,s4,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80003fd0:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80003fd4:	f67fd0ef          	jal	ra,80001f3a <printk>
80003fd8:	80006537          	lui	a0,0x80006
80003fdc:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80003fe0:	f5bfd0ef          	jal	ra,80001f3a <printk>
80003fe4:	04e00593          	li	a1,78
80003fe8:	e54a0513          	addi	a0,s4,-428
80003fec:	f6dfd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80003ff0:	0068                	addi	a0,sp,12
80003ff2:	217d                	jal	800044a0 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
80003ff4:	4408                	lw	a0,8(s0)
80003ff6:	945ff0ef          	jal	ra,8000393a <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003ffa:	4408                	lw	a0,8(s0)
80003ffc:	800035b7          	lui	a1,0x80003
80004000:	864e                	mv	a2,s3
80004002:	0561                	addi	a0,a0,24
80004004:	66e58593          	addi	a1,a1,1646 # 8000366e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000366f>
80004008:	031000ef          	jal	ra,80004838 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
8000400c:	4418                	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000400e:	0068                	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
80004010:	00d74783          	lbu	a5,13(a4)
80004014:	0107e793          	ori	a5,a5,16
80004018:	00f706a3          	sb	a5,13(a4)
8000401c:	218d                	jal	8000447e <z_spin_unlock_valid>
8000401e:	ed0d                	bnez	a0,80004058 <z_impl_k_sleep+0x15a>
80004020:	800069b7          	lui	s3,0x80006
80004024:	800065b7          	lui	a1,0x80006
80004028:	80006537          	lui	a0,0x80006
8000402c:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004030:	07800693          	li	a3,120
80004034:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004038:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000403c:	efffd0ef          	jal	ra,80001f3a <printk>
80004040:	80006537          	lui	a0,0x80006
80004044:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004048:	ef3fd0ef          	jal	ra,80001f3a <printk>
8000404c:	07800593          	li	a1,120
80004050:	e5498513          	addi	a0,s3,-428
80004054:	f05fd0ef          	jal	ra,80001f58 <assert_post_action>
80004058:	8526                	mv	a0,s1
8000405a:	976fc0ef          	jal	ra,800001d0 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
8000405e:	441c                	lw	a5,8(s0)
80004060:	00d7c783          	lbu	a5,13(a5)
80004064:	8bc1                	andi	a5,a5,16
80004066:	cf8d                	beqz	a5,800040a0 <z_impl_k_sleep+0x1a2>
80004068:	80006437          	lui	s0,0x80006
8000406c:	800065b7          	lui	a1,0x80006
80004070:	80006537          	lui	a0,0x80006
80004074:	1a058593          	addi	a1,a1,416 # 800061a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061a1>
80004078:	3b700693          	li	a3,951
8000407c:	14040613          	addi	a2,s0,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
80004080:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004084:	eb7fd0ef          	jal	ra,80001f3a <printk>
80004088:	80006537          	lui	a0,0x80006
8000408c:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80004090:	eabfd0ef          	jal	ra,80001f3a <printk>
80004094:	3b700593          	li	a1,951
80004098:	14040513          	addi	a0,s0,320
8000409c:	ebdfd0ef          	jal	ra,80001f58 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
800040a0:	67f000ef          	jal	ra,80004f1e <z_tick_get_32>
800040a4:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
800040a8:	4481                	li	s1,0
	if (ticks > 0) {
800040aa:	02a05463          	blez	a0,800040d2 <z_impl_k_sleep+0x1d4>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800040ae:	3e800613          	li	a2,1000
800040b2:	4681                	li	a3,0
800040b4:	41f55593          	srai	a1,a0,0x1f
800040b8:	f98fc0ef          	jal	ra,80000850 <__muldi3>
800040bc:	06400613          	li	a2,100
800040c0:	4681                	li	a3,0
800040c2:	996fc0ef          	jal	ra,80000258 <__udivdi3>
800040c6:	84aa                	mv	s1,a0
		return __ticks_to_ms(ticks);
800040c8:	a029                	j	800040d2 <z_impl_k_sleep+0x1d4>
	if (duration == 0) {
800040ca:	ec0494e3          	bnez	s1,80003f92 <z_impl_k_sleep+0x94>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800040ce:	c93ff0ef          	jal	ra,80003d60 <z_impl_k_yield>
}
800040d2:	50b2                	lw	ra,44(sp)
800040d4:	5422                	lw	s0,40(sp)
800040d6:	8526                	mv	a0,s1
800040d8:	5902                	lw	s2,32(sp)
800040da:	5492                	lw	s1,36(sp)
800040dc:	49f2                	lw	s3,28(sp)
800040de:	4a62                	lw	s4,24(sp)
800040e0:	6145                	addi	sp,sp,48
800040e2:	8082                	ret

800040e4 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800040e4:	800077b7          	lui	a5,0x80007
800040e8:	8a87a503          	lw	a0,-1880(a5) # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800040ec:	8082                	ret

800040ee <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800040ee:	1101                	addi	sp,sp,-32
800040f0:	cc22                	sw	s0,24(sp)
800040f2:	ca26                	sw	s1,20(sp)
800040f4:	c84a                	sw	s2,16(sp)
800040f6:	ce06                	sw	ra,28(sp)
800040f8:	c64e                	sw	s3,12(sp)
800040fa:	842a                	mv	s0,a0
800040fc:	892e                	mv	s2,a1
800040fe:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80004100:	ee0d                	bnez	a2,8000413a <z_impl_k_sem_init+0x4c>
80004102:	800069b7          	lui	s3,0x80006
80004106:	800065b7          	lui	a1,0x80006
8000410a:	80006537          	lui	a0,0x80006
8000410e:	1fc58593          	addi	a1,a1,508 # 800061fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061fd>
80004112:	04600693          	li	a3,70
80004116:	1ec98613          	addi	a2,s3,492 # 800061ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061ed>
8000411a:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000411e:	e1dfd0ef          	jal	ra,80001f3a <printk>
80004122:	80006537          	lui	a0,0x80006
80004126:	20850513          	addi	a0,a0,520 # 80006208 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006209>
8000412a:	e11fd0ef          	jal	ra,80001f3a <printk>
8000412e:	04600593          	li	a1,70
80004132:	1ec98513          	addi	a0,s3,492
80004136:	e23fd0ef          	jal	ra,80001f58 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
8000413a:	0324fe63          	bgeu	s1,s2,80004176 <z_impl_k_sem_init+0x88>
8000413e:	800069b7          	lui	s3,0x80006
80004142:	800065b7          	lui	a1,0x80006
80004146:	80006537          	lui	a0,0x80006
8000414a:	22058593          	addi	a1,a1,544 # 80006220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006221>
8000414e:	04700693          	li	a3,71
80004152:	1ec98613          	addi	a2,s3,492 # 800061ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061ed>
80004156:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000415a:	de1fd0ef          	jal	ra,80001f3a <printk>
8000415e:	80006537          	lui	a0,0x80006
80004162:	23850513          	addi	a0,a0,568 # 80006238 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006239>
80004166:	dd5fd0ef          	jal	ra,80001f3a <printk>
8000416a:	04700593          	li	a1,71
8000416e:	1ec98513          	addi	a0,s3,492
80004172:	de7fd0ef          	jal	ra,80001f58 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80004176:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
8000417a:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
8000417c:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
8000417e:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80004180:	40f2                	lw	ra,28(sp)
80004182:	4462                	lw	s0,24(sp)
80004184:	44d2                	lw	s1,20(sp)
80004186:	4942                	lw	s2,16(sp)
80004188:	49b2                	lw	s3,12(sp)
8000418a:	6105                	addi	sp,sp,32
8000418c:	8082                	ret

8000418e <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
8000418e:	1101                	addi	sp,sp,-32
80004190:	ca26                	sw	s1,20(sp)
80004192:	c64e                	sw	s3,12(sp)
80004194:	ce06                	sw	ra,28(sp)
80004196:	cc22                	sw	s0,24(sp)
80004198:	c84a                	sw	s2,16(sp)
8000419a:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000419c:	44a1                	li	s1,8
8000419e:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800041a2:	80006437          	lui	s0,0x80006
800041a6:	52c40513          	addi	a0,s0,1324 # 8000652c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000652d>
	key = (mstatus & SOC_MSTATUS_IEN);
800041aa:	88a1                	andi	s1,s1,8
800041ac:	2c65                	jal	80004464 <z_spin_lock_valid>
800041ae:	ed0d                	bnez	a0,800041e8 <z_impl_k_sem_give+0x5a>
800041b0:	80006937          	lui	s2,0x80006
800041b4:	800065b7          	lui	a1,0x80006
800041b8:	80006537          	lui	a0,0x80006
800041bc:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800041c0:	04e00693          	li	a3,78
800041c4:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800041c8:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800041cc:	d6ffd0ef          	jal	ra,80001f3a <printk>
800041d0:	80006537          	lui	a0,0x80006
800041d4:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800041d8:	d63fd0ef          	jal	ra,80001f3a <printk>
800041dc:	04e00593          	li	a1,78
800041e0:	e5490513          	addi	a0,s2,-428
800041e4:	d75fd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800041e8:	52c40513          	addi	a0,s0,1324
800041ec:	2c55                	jal	800044a0 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
800041ee:	854e                	mv	a0,s3
800041f0:	997ff0ef          	jal	ra,80003b86 <z_unpend_first_thread>
800041f4:	892a                	mv	s2,a0
	if (thread != NULL) {
800041f6:	c515                	beqz	a0,80004222 <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800041f8:	00d54783          	lbu	a5,13(a0)
800041fc:	8bfd                	andi	a5,a5,31
800041fe:	e789                	bnez	a5,80004208 <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
80004200:	4d1c                	lw	a5,24(a0)
80004202:	e399                	bnez	a5,80004208 <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
80004204:	b20ff0ef          	jal	ra,80003524 <z_add_thread_to_ready_q>
80004208:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
8000420c:	52c40513          	addi	a0,s0,1324
}
80004210:	4462                	lw	s0,24(sp)
80004212:	40f2                	lw	ra,28(sp)
80004214:	4942                	lw	s2,16(sp)
80004216:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004218:	85a6                	mv	a1,s1
}
8000421a:	44d2                	lw	s1,20(sp)
8000421c:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
8000421e:	dbbfe06f          	j	80002fd8 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004222:	0089a703          	lw	a4,8(s3)
80004226:	00c9a783          	lw	a5,12(s3)
8000422a:	8f99                	sub	a5,a5,a4
8000422c:	00f037b3          	snez	a5,a5
80004230:	97ba                	add	a5,a5,a4
80004232:	00f9a423          	sw	a5,8(s3)
80004236:	bfd9                	j	8000420c <z_impl_k_sem_give+0x7e>

80004238 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004238:	800077b7          	lui	a5,0x80007
8000423c:	8a07a783          	lw	a5,-1888(a5) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
{
80004240:	1101                	addi	sp,sp,-32
80004242:	c84a                	sw	s2,16(sp)
80004244:	c64e                	sw	s3,12(sp)
80004246:	ce06                	sw	ra,28(sp)
80004248:	cc22                	sw	s0,24(sp)
8000424a:	ca26                	sw	s1,20(sp)
8000424c:	c452                	sw	s4,8(sp)
8000424e:	892a                	mv	s2,a0
80004250:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004252:	cf95                	beqz	a5,8000428e <z_impl_k_sem_take+0x56>
80004254:	cd8d                	beqz	a1,8000428e <z_impl_k_sem_take+0x56>
80004256:	80006437          	lui	s0,0x80006
8000425a:	800065b7          	lui	a1,0x80006
8000425e:	80006537          	lui	a0,0x80006
80004262:	26058593          	addi	a1,a1,608 # 80006260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006261>
80004266:	08c00693          	li	a3,140
8000426a:	1ec40613          	addi	a2,s0,492 # 800061ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061ed>
8000426e:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004272:	cc9fd0ef          	jal	ra,80001f3a <printk>
80004276:	80006537          	lui	a0,0x80006
8000427a:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
8000427e:	cbdfd0ef          	jal	ra,80001f3a <printk>
80004282:	08c00593          	li	a1,140
80004286:	1ec40513          	addi	a0,s0,492
8000428a:	ccffd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000428e:	4421                	li	s0,8
80004290:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004294:	800064b7          	lui	s1,0x80006
80004298:	52c48513          	addi	a0,s1,1324 # 8000652c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000652d>
	key = (mstatus & SOC_MSTATUS_IEN);
8000429c:	8821                	andi	s0,s0,8
8000429e:	22d9                	jal	80004464 <z_spin_lock_valid>
800042a0:	ed0d                	bnez	a0,800042da <z_impl_k_sem_take+0xa2>
800042a2:	80006a37          	lui	s4,0x80006
800042a6:	800065b7          	lui	a1,0x80006
800042aa:	80006537          	lui	a0,0x80006
800042ae:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800042b2:	04e00693          	li	a3,78
800042b6:	e54a0613          	addi	a2,s4,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800042ba:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800042be:	c7dfd0ef          	jal	ra,80001f3a <printk>
800042c2:	80006537          	lui	a0,0x80006
800042c6:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800042ca:	c71fd0ef          	jal	ra,80001f3a <printk>
800042ce:	04e00593          	li	a1,78
800042d2:	e54a0513          	addi	a0,s4,-428
800042d6:	c83fd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800042da:	52c48513          	addi	a0,s1,1324
800042de:	22c9                	jal	800044a0 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
800042e0:	00892783          	lw	a5,8(s2)
800042e4:	cfb9                	beqz	a5,80004342 <z_impl_k_sem_take+0x10a>
		sem->count--;
800042e6:	17fd                	addi	a5,a5,-1
800042e8:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800042ec:	52c48513          	addi	a0,s1,1324
800042f0:	2279                	jal	8000447e <z_spin_unlock_valid>
800042f2:	ed0d                	bnez	a0,8000432c <z_impl_k_sem_take+0xf4>
800042f4:	800064b7          	lui	s1,0x80006
800042f8:	800065b7          	lui	a1,0x80006
800042fc:	80006537          	lui	a0,0x80006
80004300:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004304:	06100693          	li	a3,97
80004308:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
8000430c:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004310:	c2bfd0ef          	jal	ra,80001f3a <printk>
80004314:	80006537          	lui	a0,0x80006
80004318:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
8000431c:	c1ffd0ef          	jal	ra,80001f3a <printk>
80004320:	06100593          	li	a1,97
80004324:	e5448513          	addi	a0,s1,-428
80004328:	c31fd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000432c:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80004330:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80004332:	40f2                	lw	ra,28(sp)
80004334:	4462                	lw	s0,24(sp)
80004336:	44d2                	lw	s1,20(sp)
80004338:	4942                	lw	s2,16(sp)
8000433a:	49b2                	lw	s3,12(sp)
8000433c:	4a22                	lw	s4,8(sp)
8000433e:	6105                	addi	sp,sp,32
80004340:	8082                	ret
	if (timeout == K_NO_WAIT) {
80004342:	04099663          	bnez	s3,8000438e <z_impl_k_sem_take+0x156>
80004346:	52c48513          	addi	a0,s1,1324
8000434a:	2a15                	jal	8000447e <z_spin_unlock_valid>
8000434c:	ed0d                	bnez	a0,80004386 <z_impl_k_sem_take+0x14e>
8000434e:	800064b7          	lui	s1,0x80006
80004352:	800065b7          	lui	a1,0x80006
80004356:	80006537          	lui	a0,0x80006
8000435a:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
8000435e:	06100693          	li	a3,97
80004362:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004366:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000436a:	bd1fd0ef          	jal	ra,80001f3a <printk>
8000436e:	80006537          	lui	a0,0x80006
80004372:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004376:	bc5fd0ef          	jal	ra,80001f3a <printk>
8000437a:	06100593          	li	a1,97
8000437e:	e5448513          	addi	a0,s1,-428
80004382:	bd7fd0ef          	jal	ra,80001f58 <assert_post_action>
80004386:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
8000438a:	5541                	li	a0,-16
8000438c:	b75d                	j	80004332 <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000438e:	85a2                	mv	a1,s0
}
80004390:	4462                	lw	s0,24(sp)
80004392:	40f2                	lw	ra,28(sp)
80004394:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004396:	86ce                	mv	a3,s3
80004398:	864a                	mv	a2,s2
}
8000439a:	49b2                	lw	s3,12(sp)
8000439c:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000439e:	52c48513          	addi	a0,s1,1324
}
800043a2:	44d2                	lw	s1,20(sp)
800043a4:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800043a6:	f76ff06f          	j	80003b1c <z_pend_curr>

800043aa <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800043aa:	00d54783          	lbu	a5,13(a0)
800043ae:	8bfd                	andi	a5,a5,31
800043b0:	e789                	bnez	a5,800043ba <z_is_thread_ready+0x10>
800043b2:	4d08                	lw	a0,24(a0)
800043b4:	00153513          	seqz	a0,a0
800043b8:	8082                	ret
800043ba:	4501                	li	a0,0
}
800043bc:	8082                	ret

800043be <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800043be:	800077b7          	lui	a5,0x80007
800043c2:	8a07a503          	lw	a0,-1888(a5) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
}
800043c6:	00a03533          	snez	a0,a0
800043ca:	8082                	ret

800043cc <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800043cc:	800077b7          	lui	a5,0x80007
800043d0:	8a87a783          	lw	a5,-1880(a5) # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
800043d4:	00c7c503          	lbu	a0,12(a5)
}
800043d8:	8905                	andi	a0,a0,1
800043da:	8082                	ret

800043dc <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800043dc:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800043de:	5302                	lw	t1,32(sp)
{
800043e0:	cc22                	sw	s0,24(sp)
800043e2:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800043e4:	c01a                	sw	t1,0(sp)
{
800043e6:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800043e8:	8cafd0ef          	jal	ra,800014b2 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
800043ec:	800077b7          	lui	a5,0x80007
800043f0:	8a87a783          	lw	a5,-1880(a5) # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
	sys_trace_thread_create(new_thread);
}
800043f4:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
800043f6:	57bc                	lw	a5,104(a5)
800043f8:	d43c                	sw	a5,104(s0)
}
800043fa:	4462                	lw	s0,24(sp)
800043fc:	6105                	addi	sp,sp,32
800043fe:	8082                	ret

80004400 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004400:	513c                	lw	a5,96(a0)
{
80004402:	1141                	addi	sp,sp,-16
80004404:	c422                	sw	s0,8(sp)
80004406:	c606                	sw	ra,12(sp)
80004408:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
8000440a:	c391                	beqz	a5,8000440e <z_thread_single_abort+0xe>
		thread->fn_abort();
8000440c:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
8000440e:	8522                	mv	a0,s0
80004410:	f9bff0ef          	jal	ra,800043aa <z_is_thread_ready>
80004414:	cd11                	beqz	a0,80004430 <z_thread_single_abort+0x30>
		z_remove_thread_from_ready_q(thread);
80004416:	8522                	mv	a0,s0
80004418:	d22ff0ef          	jal	ra,8000393a <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
8000441c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004420:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004422:	0087e793          	ori	a5,a5,8
80004426:	00f406a3          	sb	a5,13(s0)
}
8000442a:	4422                	lw	s0,8(sp)
8000442c:	0141                	addi	sp,sp,16
8000442e:	8082                	ret
		if (z_is_thread_pending(thread)) {
80004430:	00d44783          	lbu	a5,13(s0)
80004434:	8b89                	andi	a5,a5,2
80004436:	c781                	beqz	a5,8000443e <z_thread_single_abort+0x3e>
			z_unpend_thread_no_timeout(thread);
80004438:	8522                	mv	a0,s0
8000443a:	acffe0ef          	jal	ra,80002f08 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
8000443e:	4c1c                	lw	a5,24(s0)
80004440:	dff1                	beqz	a5,8000441c <z_thread_single_abort+0x1c>
	return z_abort_timeout(&thread->base.timeout);
80004442:	01840513          	addi	a0,s0,24
80004446:	2b6d                	jal	80004a00 <z_abort_timeout>
80004448:	bfd1                	j	8000441c <z_thread_single_abort+0x1c>

8000444a <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
8000444a:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
8000444e:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004452:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004456:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
8000445a:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
8000445e:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004462:	8082                	ret

80004464 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004464:	4108                	lw	a0,0(a0)
80004466:	c911                	beqz	a0,8000447a <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004468:	800077b7          	lui	a5,0x80007
8000446c:	8b47c783          	lbu	a5,-1868(a5) # 800068b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068b5>
80004470:	890d                	andi	a0,a0,3
80004472:	8d1d                	sub	a0,a0,a5
80004474:	00a03533          	snez	a0,a0
80004478:	8082                	ret
			return false;
		}
	}
	return true;
8000447a:	4505                	li	a0,1
}
8000447c:	8082                	ret

8000447e <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
8000447e:	800077b7          	lui	a5,0x80007
80004482:	8a078793          	addi	a5,a5,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
80004486:	0147c703          	lbu	a4,20(a5)
8000448a:	479c                	lw	a5,8(a5)
8000448c:	8fd9                	or	a5,a5,a4
8000448e:	4118                	lw	a4,0(a0)
80004490:	00f71663          	bne	a4,a5,8000449c <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
80004494:	00052023          	sw	zero,0(a0)
	return true;
80004498:	4505                	li	a0,1
8000449a:	8082                	ret
		return false;
8000449c:	4501                	li	a0,0
}
8000449e:	8082                	ret

800044a0 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
800044a0:	800077b7          	lui	a5,0x80007
800044a4:	8a078793          	addi	a5,a5,-1888 # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
800044a8:	0147c703          	lbu	a4,20(a5)
800044ac:	479c                	lw	a5,8(a5)
800044ae:	8fd9                	or	a5,a5,a4
800044b0:	c11c                	sw	a5,0(a0)
}
800044b2:	8082                	ret

800044b4 <z_impl_k_thread_start>:
{
800044b4:	1101                	addi	sp,sp,-32
800044b6:	cc22                	sw	s0,24(sp)
800044b8:	c84a                	sw	s2,16(sp)
800044ba:	ce06                	sw	ra,28(sp)
800044bc:	ca26                	sw	s1,20(sp)
800044be:	c64e                	sw	s3,12(sp)
800044c0:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800044c2:	4421                	li	s0,8
800044c4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044c8:	800064b7          	lui	s1,0x80006
800044cc:	53048513          	addi	a0,s1,1328 # 80006530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006531>
	key = (mstatus & SOC_MSTATUS_IEN);
800044d0:	8821                	andi	s0,s0,8
800044d2:	f93ff0ef          	jal	ra,80004464 <z_spin_lock_valid>
800044d6:	ed0d                	bnez	a0,80004510 <z_impl_k_thread_start+0x5c>
800044d8:	800069b7          	lui	s3,0x80006
800044dc:	800065b7          	lui	a1,0x80006
800044e0:	80006537          	lui	a0,0x80006
800044e4:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800044e8:	04e00693          	li	a3,78
800044ec:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800044f0:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800044f4:	a47fd0ef          	jal	ra,80001f3a <printk>
800044f8:	80006537          	lui	a0,0x80006
800044fc:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80004500:	a3bfd0ef          	jal	ra,80001f3a <printk>
80004504:	04e00593          	li	a1,78
80004508:	e5498513          	addi	a0,s3,-428
8000450c:	a4dfd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80004510:	53048513          	addi	a0,s1,1328
80004514:	f8dff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004518:	00d94783          	lbu	a5,13(s2)
8000451c:	0047f713          	andi	a4,a5,4
80004520:	eb39                	bnez	a4,80004576 <z_impl_k_thread_start+0xc2>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004522:	53048513          	addi	a0,s1,1328
80004526:	f59ff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
8000452a:	ed0d                	bnez	a0,80004564 <z_impl_k_thread_start+0xb0>
8000452c:	800064b7          	lui	s1,0x80006
80004530:	800065b7          	lui	a1,0x80006
80004534:	80006537          	lui	a0,0x80006
80004538:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
8000453c:	06100693          	li	a3,97
80004540:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004544:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004548:	9f3fd0ef          	jal	ra,80001f3a <printk>
8000454c:	80006537          	lui	a0,0x80006
80004550:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004554:	9e7fd0ef          	jal	ra,80001f3a <printk>
80004558:	06100593          	li	a1,97
8000455c:	e5448513          	addi	a0,s1,-428
80004560:	9f9fd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004564:	30042473          	csrrs	s0,mstatus,s0
}
80004568:	40f2                	lw	ra,28(sp)
8000456a:	4462                	lw	s0,24(sp)
8000456c:	44d2                	lw	s1,20(sp)
8000456e:	4942                	lw	s2,16(sp)
80004570:	49b2                	lw	s3,12(sp)
80004572:	6105                	addi	sp,sp,32
80004574:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004576:	9bed                	andi	a5,a5,-5
80004578:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
8000457c:	854a                	mv	a0,s2
8000457e:	e2dff0ef          	jal	ra,800043aa <z_is_thread_ready>
80004582:	c501                	beqz	a0,8000458a <z_impl_k_thread_start+0xd6>
		z_add_thread_to_ready_q(thread);
80004584:	854a                	mv	a0,s2
80004586:	f9ffe0ef          	jal	ra,80003524 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
8000458a:	85a2                	mv	a1,s0
}
8000458c:	4462                	lw	s0,24(sp)
8000458e:	40f2                	lw	ra,28(sp)
80004590:	4942                	lw	s2,16(sp)
80004592:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004594:	53048513          	addi	a0,s1,1328
}
80004598:	44d2                	lw	s1,20(sp)
8000459a:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
8000459c:	a3dfe06f          	j	80002fd8 <z_reschedule>

800045a0 <schedule_new_thread>:
	if (delay == 0) {
800045a0:	e199                	bnez	a1,800045a6 <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
800045a2:	f13ff06f          	j	800044b4 <z_impl_k_thread_start>
{
800045a6:	1141                	addi	sp,sp,-16
800045a8:	c422                	sw	s0,8(sp)
800045aa:	842a                	mv	s0,a0
800045ac:	852e                	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800045ae:	0525                	addi	a0,a0,9
800045b0:	45a9                	li	a1,10
800045b2:	c606                	sw	ra,12(sp)
800045b4:	b2cfc0ef          	jal	ra,800008e0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800045b8:	00150613          	addi	a2,a0,1
800045bc:	01840513          	addi	a0,s0,24
}
800045c0:	4422                	lw	s0,8(sp)
800045c2:	40b2                	lw	ra,12(sp)
800045c4:	800035b7          	lui	a1,0x80003
800045c8:	66e58593          	addi	a1,a1,1646 # 8000366e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000366f>
800045cc:	0141                	addi	sp,sp,16
800045ce:	a4ad                	j	80004838 <z_add_timeout>

800045d0 <z_impl_k_thread_create>:
{
800045d0:	7139                	addi	sp,sp,-64
800045d2:	d256                	sw	s5,36(sp)
800045d4:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800045d6:	800076b7          	lui	a3,0x80007
800045da:	8a06a683          	lw	a3,-1888(a3) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
{
800045de:	dc22                	sw	s0,56(sp)
800045e0:	da26                	sw	s1,52(sp)
800045e2:	d64e                	sw	s3,44(sp)
800045e4:	d452                	sw	s4,40(sp)
800045e6:	de06                	sw	ra,60(sp)
800045e8:	d84a                	sw	s2,48(sp)
800045ea:	842a                	mv	s0,a0
800045ec:	89ae                	mv	s3,a1
800045ee:	8a32                	mv	s4,a2
800045f0:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800045f2:	c6a9                	beqz	a3,8000463c <z_impl_k_thread_create+0x6c>
800045f4:	80006937          	lui	s2,0x80006
800045f8:	800065b7          	lui	a1,0x80006
800045fc:	80006537          	lui	a0,0x80006
80004600:	1b200693          	li	a3,434
80004604:	29490613          	addi	a2,s2,660 # 80006294 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006295>
80004608:	0d858593          	addi	a1,a1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
8000460c:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004610:	ce46                	sw	a7,28(sp)
80004612:	cc42                	sw	a6,24(sp)
80004614:	ca3e                	sw	a5,20(sp)
80004616:	c83a                	sw	a4,16(sp)
80004618:	923fd0ef          	jal	ra,80001f3a <printk>
8000461c:	80006537          	lui	a0,0x80006
80004620:	2a850513          	addi	a0,a0,680 # 800062a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a9>
80004624:	917fd0ef          	jal	ra,80001f3a <printk>
80004628:	1b200593          	li	a1,434
8000462c:	29490513          	addi	a0,s2,660
80004630:	929fd0ef          	jal	ra,80001f58 <assert_post_action>
80004634:	48f2                	lw	a7,28(sp)
80004636:	4862                	lw	a6,24(sp)
80004638:	47d2                	lw	a5,20(sp)
8000463a:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000463c:	4686                	lw	a3,64(sp)
8000463e:	c202                	sw	zero,4(sp)
80004640:	8652                	mv	a2,s4
80004642:	c036                	sw	a3,0(sp)
80004644:	85ce                	mv	a1,s3
80004646:	86d6                	mv	a3,s5
80004648:	8522                	mv	a0,s0
8000464a:	d93ff0ef          	jal	ra,800043dc <z_setup_new_thread>
	if (delay != K_FOREVER) {
8000464e:	57fd                	li	a5,-1
80004650:	00f48663          	beq	s1,a5,8000465c <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
80004654:	85a6                	mv	a1,s1
80004656:	8522                	mv	a0,s0
80004658:	f49ff0ef          	jal	ra,800045a0 <schedule_new_thread>
}
8000465c:	8522                	mv	a0,s0
8000465e:	50f2                	lw	ra,60(sp)
80004660:	5462                	lw	s0,56(sp)
80004662:	54d2                	lw	s1,52(sp)
80004664:	5942                	lw	s2,48(sp)
80004666:	59b2                	lw	s3,44(sp)
80004668:	5a22                	lw	s4,40(sp)
8000466a:	5a92                	lw	s5,36(sp)
8000466c:	6121                	addi	sp,sp,64
8000466e:	8082                	ret

80004670 <z_init_static_threads>:
{
80004670:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004672:	800067b7          	lui	a5,0x80006
{
80004676:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004678:	80006937          	lui	s2,0x80006
{
8000467c:	cc22                	sw	s0,24(sp)
8000467e:	ca26                	sw	s1,20(sp)
80004680:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004682:	4bc78413          	addi	s0,a5,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004686:	4bc78493          	addi	s1,a5,1212
8000468a:	4bc90913          	addi	s2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000468e:	01246f63          	bltu	s0,s2,800046ac <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
80004692:	8426                	mv	s0,s1
	k_sched_lock();
80004694:	a15fe0ef          	jal	ra,800030a8 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004698:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
8000469a:	03246e63          	bltu	s0,s2,800046d6 <z_init_static_threads+0x66>
}
8000469e:	4462                	lw	s0,24(sp)
800046a0:	40f2                	lw	ra,28(sp)
800046a2:	44d2                	lw	s1,20(sp)
800046a4:	4942                	lw	s2,16(sp)
800046a6:	6105                	addi	sp,sp,32
	k_sched_unlock();
800046a8:	d27fe06f          	j	800033ce <k_sched_unlock>
		z_setup_new_thread(
800046ac:	545c                	lw	a5,44(s0)
800046ae:	c23e                	sw	a5,4(sp)
800046b0:	501c                	lw	a5,32(s0)
800046b2:	c03e                	sw	a5,0(sp)
800046b4:	485c                	lw	a5,20(s0)
800046b6:	01c42883          	lw	a7,28(s0)
800046ba:	01842803          	lw	a6,24(s0)
800046be:	4818                	lw	a4,16(s0)
800046c0:	4454                	lw	a3,12(s0)
800046c2:	4410                	lw	a2,8(s0)
800046c4:	404c                	lw	a1,4(s0)
800046c6:	4008                	lw	a0,0(s0)
800046c8:	d15ff0ef          	jal	ra,800043dc <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
800046cc:	401c                	lw	a5,0(s0)
800046ce:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
800046d0:	03040413          	addi	s0,s0,48
800046d4:	bf6d                	j	8000468e <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
800046d6:	504c                	lw	a1,36(s0)
800046d8:	00958563          	beq	a1,s1,800046e2 <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
800046dc:	4008                	lw	a0,0(s0)
800046de:	ec3ff0ef          	jal	ra,800045a0 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
800046e2:	03040413          	addi	s0,s0,48
800046e6:	bf55                	j	8000469a <z_init_static_threads+0x2a>

800046e8 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
800046e8:	1101                	addi	sp,sp,-32
800046ea:	cc22                	sw	s0,24(sp)
800046ec:	ca26                	sw	s1,20(sp)
800046ee:	ce06                	sw	ra,28(sp)
800046f0:	c84a                	sw	s2,16(sp)
800046f2:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
800046f4:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800046f6:	4421                	li	s0,8
800046f8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800046fc:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800046fe:	8821                	andi	s0,s0,8
80004700:	d65ff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80004704:	ed0d                	bnez	a0,8000473e <z_impl_k_thread_abort+0x56>
80004706:	80006937          	lui	s2,0x80006
8000470a:	800065b7          	lui	a1,0x80006
8000470e:	80006537          	lui	a0,0x80006
80004712:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80004716:	04e00693          	li	a3,78
8000471a:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
8000471e:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004722:	819fd0ef          	jal	ra,80001f3a <printk>
80004726:	80006537          	lui	a0,0x80006
8000472a:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
8000472e:	80dfd0ef          	jal	ra,80001f3a <printk>
80004732:	04e00593          	li	a1,78
80004736:	e5490513          	addi	a0,s2,-428
8000473a:	81ffd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
8000473e:	0068                	addi	a0,sp,12
80004740:	d61ff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004744:	00c4c783          	lbu	a5,12(s1)
80004748:	8b85                	andi	a5,a5,1
8000474a:	cf8d                	beqz	a5,80004784 <z_impl_k_thread_abort+0x9c>
8000474c:	80006937          	lui	s2,0x80006
80004750:	800065b7          	lui	a1,0x80006
80004754:	80006537          	lui	a0,0x80006
80004758:	2e858593          	addi	a1,a1,744 # 800062e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e9>
8000475c:	02900693          	li	a3,41
80004760:	2d090613          	addi	a2,s2,720 # 800062d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d1>
80004764:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004768:	fd2fd0ef          	jal	ra,80001f3a <printk>
8000476c:	80006537          	lui	a0,0x80006
80004770:	31c50513          	addi	a0,a0,796 # 8000631c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000631d>
80004774:	fc6fd0ef          	jal	ra,80001f3a <printk>
80004778:	02900593          	li	a1,41
8000477c:	2d090513          	addi	a0,s2,720
80004780:	fd8fd0ef          	jal	ra,80001f58 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004784:	8526                	mv	a0,s1
80004786:	c7bff0ef          	jal	ra,80004400 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
8000478a:	85a2                	mv	a1,s0
8000478c:	0068                	addi	a0,sp,12
8000478e:	84bfe0ef          	jal	ra,80002fd8 <z_reschedule>
}
80004792:	40f2                	lw	ra,28(sp)
80004794:	4462                	lw	s0,24(sp)
80004796:	44d2                	lw	s1,20(sp)
80004798:	4942                	lw	s2,16(sp)
8000479a:	6105                	addi	sp,sp,32
8000479c:	8082                	ret

8000479e <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
8000479e:	800067b7          	lui	a5,0x80006
800047a2:	5347a783          	lw	a5,1332(a5) # 80006534 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006535>
800047a6:	e399                	bnez	a5,800047ac <elapsed+0xe>
800047a8:	b0dfd06f          	j	800022b4 <z_clock_elapsed>
}
800047ac:	4501                	li	a0,0
800047ae:	8082                	ret

800047b0 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
800047b0:	411c                	lw	a5,0(a0)
800047b2:	cd01                	beqz	a0,800047ca <remove_timeout+0x1a>
800047b4:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
800047b8:	48072703          	lw	a4,1152(a4) # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
800047bc:	00e50763          	beq	a0,a4,800047ca <remove_timeout+0x1a>
	if (next(t) != NULL) {
800047c0:	c789                	beqz	a5,800047ca <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
800047c2:	4798                	lw	a4,8(a5)
800047c4:	4514                	lw	a3,8(a0)
800047c6:	9736                	add	a4,a4,a3
800047c8:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
800047ca:	4158                	lw	a4,4(a0)
800047cc:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
800047ce:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
800047d0:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800047d4:	00052223          	sw	zero,4(a0)
}
800047d8:	8082                	ret

800047da <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800047da:	800067b7          	lui	a5,0x80006
800047de:	5407c783          	lbu	a5,1344(a5) # 80006540 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006541>
{
800047e2:	1141                	addi	sp,sp,-16
800047e4:	c606                	sw	ra,12(sp)
800047e6:	c422                	sw	s0,8(sp)
800047e8:	c226                	sw	s1,4(sp)
800047ea:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800047ec:	e789                	bnez	a5,800047f6 <next_timeout+0x1c>
800047ee:	80000537          	lui	a0,0x80000
800047f2:	fff54513          	not	a0,a0
	return list->head == list;
800047f6:	800067b7          	lui	a5,0x80006
800047fa:	47c78793          	addi	a5,a5,1148 # 8000647c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000647d>
800047fe:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004800:	00f40f63          	beq	s0,a5,8000481e <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004804:	cc09                	beqz	s0,8000481e <next_timeout+0x44>
80004806:	4404                	lw	s1,8(s0)
80004808:	f97ff0ef          	jal	ra,8000479e <elapsed>
8000480c:	8c89                	sub	s1,s1,a0
8000480e:	4501                	li	a0,0
80004810:	0004c763          	bltz	s1,8000481e <next_timeout+0x44>
80004814:	4400                	lw	s0,8(s0)
80004816:	f89ff0ef          	jal	ra,8000479e <elapsed>
8000481a:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
8000481e:	800077b7          	lui	a5,0x80007
80004822:	8b07a783          	lw	a5,-1872(a5) # 800068b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068b1>
80004826:	c781                	beqz	a5,8000482e <next_timeout+0x54>
80004828:	00a7d363          	bge	a5,a0,8000482e <next_timeout+0x54>
8000482c:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
8000482e:	40b2                	lw	ra,12(sp)
80004830:	4422                	lw	s0,8(sp)
80004832:	4492                	lw	s1,4(sp)
80004834:	0141                	addi	sp,sp,16
80004836:	8082                	ret

80004838 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004838:	411c                	lw	a5,0(a0)
{
8000483a:	7179                	addi	sp,sp,-48
8000483c:	d422                	sw	s0,40(sp)
8000483e:	d226                	sw	s1,36(sp)
80004840:	ce4e                	sw	s3,28(sp)
80004842:	d606                	sw	ra,44(sp)
80004844:	d04a                	sw	s2,32(sp)
80004846:	cc52                	sw	s4,24(sp)
80004848:	ca56                	sw	s5,20(sp)
8000484a:	c85a                	sw	s6,16(sp)
8000484c:	c65e                	sw	s7,12(sp)
8000484e:	c462                	sw	s8,8(sp)
80004850:	842a                	mv	s0,a0
80004852:	89ae                	mv	s3,a1
80004854:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004856:	cf8d                	beqz	a5,80004890 <z_add_timeout+0x58>
80004858:	80006937          	lui	s2,0x80006
8000485c:	800065b7          	lui	a1,0x80006
80004860:	80006537          	lui	a0,0x80006
80004864:	34c58593          	addi	a1,a1,844 # 8000634c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000634d>
80004868:	04d00693          	li	a3,77
8000486c:	33890613          	addi	a2,s2,824 # 80006338 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006339>
80004870:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004874:	ec6fd0ef          	jal	ra,80001f3a <printk>
80004878:	80006537          	lui	a0,0x80006
8000487c:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
80004880:	ebafd0ef          	jal	ra,80001f3a <printk>
80004884:	04d00593          	li	a1,77
80004888:	33890513          	addi	a0,s2,824
8000488c:	eccfd0ef          	jal	ra,80001f58 <assert_post_action>
	to->fn = fn;
80004890:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004894:	00904363          	bgtz	s1,8000489a <z_add_timeout+0x62>
80004898:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000489a:	49a1                	li	s3,8
8000489c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800048a0:	80006a37          	lui	s4,0x80006
800048a4:	538a0513          	addi	a0,s4,1336 # 80006538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006539>
	key = (mstatus & SOC_MSTATUS_IEN);
800048a8:	0089f993          	andi	s3,s3,8
800048ac:	bb9ff0ef          	jal	ra,80004464 <z_spin_lock_valid>
800048b0:	ed0d                	bnez	a0,800048ea <z_add_timeout+0xb2>
800048b2:	80006937          	lui	s2,0x80006
800048b6:	800065b7          	lui	a1,0x80006
800048ba:	80006537          	lui	a0,0x80006
800048be:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
800048c2:	04e00693          	li	a3,78
800048c6:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800048ca:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800048ce:	e6cfd0ef          	jal	ra,80001f3a <printk>
800048d2:	80006537          	lui	a0,0x80006
800048d6:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800048da:	e60fd0ef          	jal	ra,80001f3a <printk>
800048de:	04e00593          	li	a1,78
800048e2:	e5490513          	addi	a0,s2,-428
800048e6:	e72fd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
800048ea:	538a0513          	addi	a0,s4,1336
800048ee:	bb3ff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
800048f2:	eadff0ef          	jal	ra,8000479e <elapsed>
800048f6:	9526                	add	a0,a0,s1
	return list->head == list;
800048f8:	800064b7          	lui	s1,0x80006
800048fc:	47c4a903          	lw	s2,1148(s1) # 8000647c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000647d>
80004900:	c408                	sw	a0,8(s0)
80004902:	47c48493          	addi	s1,s1,1148
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004906:	00990c63          	beq	s2,s1,8000491e <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
8000490a:	80006ab7          	lui	s5,0x80006
8000490e:	80006b37          	lui	s6,0x80006
80004912:	80006bb7          	lui	s7,0x80006
80004916:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
8000491a:	00091963          	bnez	s2,8000492c <z_add_timeout+0xf4>
	node->prev = list->tail;
8000491e:	40dc                	lw	a5,4(s1)
	node->next = list;
80004920:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80004922:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80004924:	40dc                	lw	a5,4(s1)
80004926:	c380                	sw	s0,0(a5)
	list->tail = node;
80004928:	c0c0                	sw	s0,4(s1)
8000492a:	a891                	j	8000497e <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
8000492c:	00892783          	lw	a5,8(s2)
80004930:	0207d663          	bgez	a5,8000495c <z_add_timeout+0x124>
80004934:	36cb0593          	addi	a1,s6,876 # 8000636c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000636d>
80004938:	05600693          	li	a3,86
8000493c:	338a8613          	addi	a2,s5,824 # 80006338 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006339>
80004940:	d88b8513          	addi	a0,s7,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004944:	df6fd0ef          	jal	ra,80001f3a <printk>
80004948:	e0cc0513          	addi	a0,s8,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
8000494c:	deefd0ef          	jal	ra,80001f3a <printk>
80004950:	05600593          	li	a1,86
80004954:	338a8513          	addi	a0,s5,824
80004958:	e00fd0ef          	jal	ra,80001f58 <assert_post_action>

			if (t->dticks > to->dticks) {
8000495c:	00892703          	lw	a4,8(s2)
80004960:	441c                	lw	a5,8(s0)
80004962:	08e7d763          	bge	a5,a4,800049f0 <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
80004966:	40f707b3          	sub	a5,a4,a5
8000496a:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
8000496e:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004972:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004976:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
80004978:	c380                	sw	s0,0(a5)
	successor->prev = node;
8000497a:	00892223          	sw	s0,4(s2)
	return list->head == list;
8000497e:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004980:	00978963          	beq	a5,s1,80004992 <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004984:	00f41763          	bne	s0,a5,80004992 <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
80004988:	e53ff0ef          	jal	ra,800047da <next_timeout>
8000498c:	4581                	li	a1,0
8000498e:	fdafd0ef          	jal	ra,80002168 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004992:	538a0513          	addi	a0,s4,1336
80004996:	ae9ff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
8000499a:	ed0d                	bnez	a0,800049d4 <z_add_timeout+0x19c>
8000499c:	80006437          	lui	s0,0x80006
800049a0:	800065b7          	lui	a1,0x80006
800049a4:	80006537          	lui	a0,0x80006
800049a8:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800049ac:	06100693          	li	a3,97
800049b0:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800049b4:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800049b8:	d82fd0ef          	jal	ra,80001f3a <printk>
800049bc:	80006537          	lui	a0,0x80006
800049c0:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
800049c4:	d76fd0ef          	jal	ra,80001f3a <printk>
800049c8:	06100593          	li	a1,97
800049cc:	e5440513          	addi	a0,s0,-428
800049d0:	d88fd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049d4:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
800049d8:	50b2                	lw	ra,44(sp)
800049da:	5422                	lw	s0,40(sp)
800049dc:	5492                	lw	s1,36(sp)
800049de:	5902                	lw	s2,32(sp)
800049e0:	49f2                	lw	s3,28(sp)
800049e2:	4a62                	lw	s4,24(sp)
800049e4:	4ad2                	lw	s5,20(sp)
800049e6:	4b42                	lw	s6,16(sp)
800049e8:	4bb2                	lw	s7,12(sp)
800049ea:	4c22                	lw	s8,8(sp)
800049ec:	6145                	addi	sp,sp,48
800049ee:	8082                	ret
			to->dticks -= t->dticks;
800049f0:	8f99                	sub	a5,a5,a4
800049f2:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
800049f4:	40dc                	lw	a5,4(s1)
800049f6:	f32784e3          	beq	a5,s2,8000491e <z_add_timeout+0xe6>
800049fa:	00092903          	lw	s2,0(s2)
800049fe:	bf31                	j	8000491a <z_add_timeout+0xe2>

80004a00 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004a00:	1101                	addi	sp,sp,-32
80004a02:	cc22                	sw	s0,24(sp)
80004a04:	c64e                	sw	s3,12(sp)
80004a06:	ce06                	sw	ra,28(sp)
80004a08:	ca26                	sw	s1,20(sp)
80004a0a:	c84a                	sw	s2,16(sp)
80004a0c:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004a0e:	4421                	li	s0,8
80004a10:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004a14:	800064b7          	lui	s1,0x80006
80004a18:	53848513          	addi	a0,s1,1336 # 80006538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006539>
	key = (mstatus & SOC_MSTATUS_IEN);
80004a1c:	8821                	andi	s0,s0,8
80004a1e:	a47ff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80004a22:	ed0d                	bnez	a0,80004a5c <z_abort_timeout+0x5c>
80004a24:	80006937          	lui	s2,0x80006
80004a28:	800065b7          	lui	a1,0x80006
80004a2c:	80006537          	lui	a0,0x80006
80004a30:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80004a34:	04e00693          	li	a3,78
80004a38:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004a3c:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004a40:	cfafd0ef          	jal	ra,80001f3a <printk>
80004a44:	80006537          	lui	a0,0x80006
80004a48:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80004a4c:	ceefd0ef          	jal	ra,80001f3a <printk>
80004a50:	04e00593          	li	a1,78
80004a54:	e5490513          	addi	a0,s2,-428
80004a58:	d00fd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80004a5c:	53848513          	addi	a0,s1,1336
80004a60:	a41ff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004a64:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80004a68:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80004a6a:	c789                	beqz	a5,80004a74 <z_abort_timeout+0x74>
			remove_timeout(to);
80004a6c:	854e                	mv	a0,s3
80004a6e:	d43ff0ef          	jal	ra,800047b0 <remove_timeout>
			ret = 0;
80004a72:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004a74:	53848513          	addi	a0,s1,1336
80004a78:	a07ff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
80004a7c:	ed0d                	bnez	a0,80004ab6 <z_abort_timeout+0xb6>
80004a7e:	800064b7          	lui	s1,0x80006
80004a82:	800065b7          	lui	a1,0x80006
80004a86:	80006537          	lui	a0,0x80006
80004a8a:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004a8e:	06100693          	li	a3,97
80004a92:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004a96:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004a9a:	ca0fd0ef          	jal	ra,80001f3a <printk>
80004a9e:	80006537          	lui	a0,0x80006
80004aa2:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004aa6:	c94fd0ef          	jal	ra,80001f3a <printk>
80004aaa:	06100593          	li	a1,97
80004aae:	e5448513          	addi	a0,s1,-428
80004ab2:	ca6fd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004ab6:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004aba:	40f2                	lw	ra,28(sp)
80004abc:	4462                	lw	s0,24(sp)
80004abe:	854a                	mv	a0,s2
80004ac0:	44d2                	lw	s1,20(sp)
80004ac2:	4942                	lw	s2,16(sp)
80004ac4:	49b2                	lw	s3,12(sp)
80004ac6:	6105                	addi	sp,sp,32
80004ac8:	8082                	ret

80004aca <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004aca:	1141                	addi	sp,sp,-16
80004acc:	c422                	sw	s0,8(sp)
80004ace:	c606                	sw	ra,12(sp)
80004ad0:	c226                	sw	s1,4(sp)
80004ad2:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004ad4:	4421                	li	s0,8
80004ad6:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ada:	800064b7          	lui	s1,0x80006
80004ade:	53848513          	addi	a0,s1,1336 # 80006538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006539>
	key = (mstatus & SOC_MSTATUS_IEN);
80004ae2:	8821                	andi	s0,s0,8
80004ae4:	981ff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80004ae8:	ed0d                	bnez	a0,80004b22 <z_get_next_timeout_expiry+0x58>
80004aea:	80006937          	lui	s2,0x80006
80004aee:	800065b7          	lui	a1,0x80006
80004af2:	80006537          	lui	a0,0x80006
80004af6:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80004afa:	04e00693          	li	a3,78
80004afe:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004b02:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004b06:	c34fd0ef          	jal	ra,80001f3a <printk>
80004b0a:	80006537          	lui	a0,0x80006
80004b0e:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80004b12:	c28fd0ef          	jal	ra,80001f3a <printk>
80004b16:	04e00593          	li	a1,78
80004b1a:	e5490513          	addi	a0,s2,-428
80004b1e:	c3afd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80004b22:	53848513          	addi	a0,s1,1336
80004b26:	97bff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004b2a:	cb1ff0ef          	jal	ra,800047da <next_timeout>
80004b2e:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004b30:	53848513          	addi	a0,s1,1336
80004b34:	94bff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
80004b38:	ed0d                	bnez	a0,80004b72 <z_get_next_timeout_expiry+0xa8>
80004b3a:	800064b7          	lui	s1,0x80006
80004b3e:	800065b7          	lui	a1,0x80006
80004b42:	80006537          	lui	a0,0x80006
80004b46:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004b4a:	06100693          	li	a3,97
80004b4e:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004b52:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004b56:	be4fd0ef          	jal	ra,80001f3a <printk>
80004b5a:	80006537          	lui	a0,0x80006
80004b5e:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004b62:	bd8fd0ef          	jal	ra,80001f3a <printk>
80004b66:	06100593          	li	a1,97
80004b6a:	e5448513          	addi	a0,s1,-428
80004b6e:	beafd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004b72:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80004b76:	40b2                	lw	ra,12(sp)
80004b78:	4422                	lw	s0,8(sp)
80004b7a:	854a                	mv	a0,s2
80004b7c:	4492                	lw	s1,4(sp)
80004b7e:	4902                	lw	s2,0(sp)
80004b80:	0141                	addi	sp,sp,16
80004b82:	8082                	ret

80004b84 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80004b84:	1101                	addi	sp,sp,-32
80004b86:	cc22                	sw	s0,24(sp)
80004b88:	c84a                	sw	s2,16(sp)
80004b8a:	c452                	sw	s4,8(sp)
80004b8c:	ce06                	sw	ra,28(sp)
80004b8e:	ca26                	sw	s1,20(sp)
80004b90:	c64e                	sw	s3,12(sp)
80004b92:	892a                	mv	s2,a0
80004b94:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b96:	4421                	li	s0,8
80004b98:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b9c:	800064b7          	lui	s1,0x80006
80004ba0:	53848513          	addi	a0,s1,1336 # 80006538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006539>
	key = (mstatus & SOC_MSTATUS_IEN);
80004ba4:	8821                	andi	s0,s0,8
80004ba6:	8bfff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80004baa:	ed0d                	bnez	a0,80004be4 <z_set_timeout_expiry+0x60>
80004bac:	800069b7          	lui	s3,0x80006
80004bb0:	800065b7          	lui	a1,0x80006
80004bb4:	80006537          	lui	a0,0x80006
80004bb8:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80004bbc:	04e00693          	li	a3,78
80004bc0:	e5498613          	addi	a2,s3,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004bc4:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004bc8:	b72fd0ef          	jal	ra,80001f3a <printk>
80004bcc:	80006537          	lui	a0,0x80006
80004bd0:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80004bd4:	b66fd0ef          	jal	ra,80001f3a <printk>
80004bd8:	04e00593          	li	a1,78
80004bdc:	e5498513          	addi	a0,s3,-428
80004be0:	b78fd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80004be4:	53848513          	addi	a0,s1,1336
80004be8:	8b9ff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004bec:	befff0ef          	jal	ra,800047da <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004bf0:	00a95963          	bge	s2,a0,80004c02 <z_set_timeout_expiry+0x7e>
80004bf4:	4785                	li	a5,1
80004bf6:	00a7d663          	bge	a5,a0,80004c02 <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
80004bfa:	85d2                	mv	a1,s4
80004bfc:	854a                	mv	a0,s2
80004bfe:	d6afd0ef          	jal	ra,80002168 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004c02:	53848513          	addi	a0,s1,1336
80004c06:	879ff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
80004c0a:	ed0d                	bnez	a0,80004c44 <z_set_timeout_expiry+0xc0>
80004c0c:	800064b7          	lui	s1,0x80006
80004c10:	800065b7          	lui	a1,0x80006
80004c14:	80006537          	lui	a0,0x80006
80004c18:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004c1c:	06100693          	li	a3,97
80004c20:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004c24:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004c28:	b12fd0ef          	jal	ra,80001f3a <printk>
80004c2c:	80006537          	lui	a0,0x80006
80004c30:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004c34:	b06fd0ef          	jal	ra,80001f3a <printk>
80004c38:	06100593          	li	a1,97
80004c3c:	e5448513          	addi	a0,s1,-428
80004c40:	b18fd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c44:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80004c48:	40f2                	lw	ra,28(sp)
80004c4a:	4462                	lw	s0,24(sp)
80004c4c:	44d2                	lw	s1,20(sp)
80004c4e:	4942                	lw	s2,16(sp)
80004c50:	49b2                	lw	s3,12(sp)
80004c52:	4a22                	lw	s4,8(sp)
80004c54:	6105                	addi	sp,sp,32
80004c56:	8082                	ret

80004c58 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80004c58:	7179                	addi	sp,sp,-48
80004c5a:	d422                	sw	s0,40(sp)
80004c5c:	cc52                	sw	s4,24(sp)
80004c5e:	d606                	sw	ra,44(sp)
80004c60:	d226                	sw	s1,36(sp)
80004c62:	d04a                	sw	s2,32(sp)
80004c64:	ce4e                	sw	s3,28(sp)
80004c66:	ca56                	sw	s5,20(sp)
80004c68:	c85a                	sw	s6,16(sp)
80004c6a:	c65e                	sw	s7,12(sp)
80004c6c:	c462                	sw	s8,8(sp)
80004c6e:	c266                	sw	s9,4(sp)
80004c70:	c06a                	sw	s10,0(sp)
80004c72:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004c74:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80004c76:	c67fe0ef          	jal	ra,800038dc <z_time_slice>
80004c7a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004c7e:	80006937          	lui	s2,0x80006
80004c82:	53890513          	addi	a0,s2,1336 # 80006538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006539>
	key = (mstatus & SOC_MSTATUS_IEN);
80004c86:	8821                	andi	s0,s0,8
80004c88:	fdcff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80004c8c:	ed0d                	bnez	a0,80004cc6 <z_clock_announce+0x6e>
80004c8e:	800064b7          	lui	s1,0x80006
80004c92:	800065b7          	lui	a1,0x80006
80004c96:	80006537          	lui	a0,0x80006
80004c9a:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80004c9e:	04e00693          	li	a3,78
80004ca2:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004ca6:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004caa:	a90fd0ef          	jal	ra,80001f3a <printk>
80004cae:	80006537          	lui	a0,0x80006
80004cb2:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80004cb6:	a84fd0ef          	jal	ra,80001f3a <printk>
80004cba:	04e00593          	li	a1,78
80004cbe:	e5448513          	addi	a0,s1,-428
80004cc2:	a96fd0ef          	jal	ra,80001f58 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80004cc6:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
80004cca:	53890513          	addi	a0,s2,1336
80004cce:	fd2ff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
80004cd2:	800064b7          	lui	s1,0x80006
80004cd6:	5349aa23          	sw	s4,1332(s3) # 80006534 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006535>
	return list->head == list;
80004cda:	80006a37          	lui	s4,0x80006
80004cde:	53498993          	addi	s3,s3,1332
80004ce2:	47ca0a13          	addi	s4,s4,1148 # 8000647c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000647d>
80004ce6:	50048493          	addi	s1,s1,1280 # 80006500 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006501>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004cea:	80006ab7          	lui	s5,0x80006
80004cee:	80006bb7          	lui	s7,0x80006
80004cf2:	80006b37          	lui	s6,0x80006
80004cf6:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004cfa:	80006cb7          	lui	s9,0x80006
80004cfe:	000a2d03          	lw	s10,0(s4)
80004d02:	0009a783          	lw	a5,0(s3)
80004d06:	4094                	lw	a3,0(s1)
80004d08:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004d0a:	014d0b63          	beq	s10,s4,80004d20 <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80004d0e:	000d0963          	beqz	s10,80004d20 <z_clock_announce+0xc8>
80004d12:	008d2703          	lw	a4,8(s10)
80004d16:	08e7d663          	bge	a5,a4,80004da2 <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80004d1a:	8f1d                	sub	a4,a4,a5
80004d1c:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80004d20:	96be                	add	a3,a3,a5
80004d22:	41f7d713          	srai	a4,a5,0x1f
80004d26:	972a                	add	a4,a4,a0
80004d28:	00f6b7b3          	sltu	a5,a3,a5
80004d2c:	97ba                	add	a5,a5,a4
80004d2e:	c094                	sw	a3,0(s1)
80004d30:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
80004d32:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80004d36:	aa5ff0ef          	jal	ra,800047da <next_timeout>
80004d3a:	4581                	li	a1,0
80004d3c:	c2cfd0ef          	jal	ra,80002168 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d40:	53890513          	addi	a0,s2,1336
80004d44:	f3aff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
80004d48:	ed0d                	bnez	a0,80004d82 <z_clock_announce+0x12a>
80004d4a:	800064b7          	lui	s1,0x80006
80004d4e:	800065b7          	lui	a1,0x80006
80004d52:	80006537          	lui	a0,0x80006
80004d56:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004d5a:	06100693          	li	a3,97
80004d5e:	e5448613          	addi	a2,s1,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004d62:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004d66:	9d4fd0ef          	jal	ra,80001f3a <printk>
80004d6a:	80006537          	lui	a0,0x80006
80004d6e:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004d72:	9c8fd0ef          	jal	ra,80001f3a <printk>
80004d76:	06100593          	li	a1,97
80004d7a:	e5448513          	addi	a0,s1,-428
80004d7e:	9dafd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004d82:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80004d86:	50b2                	lw	ra,44(sp)
80004d88:	5422                	lw	s0,40(sp)
80004d8a:	5492                	lw	s1,36(sp)
80004d8c:	5902                	lw	s2,32(sp)
80004d8e:	49f2                	lw	s3,28(sp)
80004d90:	4a62                	lw	s4,24(sp)
80004d92:	4ad2                	lw	s5,20(sp)
80004d94:	4b42                	lw	s6,16(sp)
80004d96:	4bb2                	lw	s7,12(sp)
80004d98:	4c22                	lw	s8,8(sp)
80004d9a:	4c92                	lw	s9,4(sp)
80004d9c:	4d02                	lw	s10,0(sp)
80004d9e:	6145                	addi	sp,sp,48
80004da0:	8082                	ret
		curr_tick += dt;
80004da2:	96ba                	add	a3,a3,a4
80004da4:	41f75593          	srai	a1,a4,0x1f
80004da8:	95aa                	add	a1,a1,a0
80004daa:	00e6b633          	sltu	a2,a3,a4
80004dae:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
80004db0:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
80004db2:	856a                	mv	a0,s10
		t->dticks = 0;
80004db4:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80004db8:	c094                	sw	a3,0(s1)
80004dba:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
80004dbc:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80004dc0:	9f1ff0ef          	jal	ra,800047b0 <remove_timeout>
80004dc4:	53890513          	addi	a0,s2,1336
80004dc8:	eb6ff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
80004dcc:	e50d                	bnez	a0,80004df6 <z_clock_announce+0x19e>
80004dce:	e9cb8593          	addi	a1,s7,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004dd2:	06100693          	li	a3,97
80004dd6:	e54a8613          	addi	a2,s5,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004dda:	d88b0513          	addi	a0,s6,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004dde:	95cfd0ef          	jal	ra,80001f3a <printk>
80004de2:	eb4c0513          	addi	a0,s8,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004de6:	954fd0ef          	jal	ra,80001f3a <printk>
80004dea:	06100593          	li	a1,97
80004dee:	e54a8513          	addi	a0,s5,-428
80004df2:	966fd0ef          	jal	ra,80001f58 <assert_post_action>
80004df6:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80004dfa:	00cd2783          	lw	a5,12(s10)
80004dfe:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e00:	4421                	li	s0,8
80004e02:	9782                	jalr	a5
80004e04:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e08:	53890513          	addi	a0,s2,1336
	key = (mstatus & SOC_MSTATUS_IEN);
80004e0c:	8821                	andi	s0,s0,8
80004e0e:	e56ff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80004e12:	e51d                	bnez	a0,80004e40 <z_clock_announce+0x1e8>
80004e14:	e6cc8593          	addi	a1,s9,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80004e18:	04e00693          	li	a3,78
80004e1c:	e54a8613          	addi	a2,s5,-428
80004e20:	d88b0513          	addi	a0,s6,-632
80004e24:	916fd0ef          	jal	ra,80001f3a <printk>
80004e28:	80006537          	lui	a0,0x80006
80004e2c:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80004e30:	90afd0ef          	jal	ra,80001f3a <printk>
80004e34:	04e00593          	li	a1,78
80004e38:	e54a8513          	addi	a0,s5,-428
80004e3c:	91cfd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80004e40:	53890513          	addi	a0,s2,1336
80004e44:	e5cff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	return k;
80004e48:	bd5d                	j	80004cfe <z_clock_announce+0xa6>

80004e4a <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80004e4a:	1101                	addi	sp,sp,-32
80004e4c:	ca26                	sw	s1,20(sp)
80004e4e:	ce06                	sw	ra,28(sp)
80004e50:	cc22                	sw	s0,24(sp)
80004e52:	c84a                	sw	s2,16(sp)
80004e54:	c64e                	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e56:	44a1                	li	s1,8
80004e58:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e5c:	80006937          	lui	s2,0x80006
80004e60:	53890513          	addi	a0,s2,1336 # 80006538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006539>
	key = (mstatus & SOC_MSTATUS_IEN);
80004e64:	88a1                	andi	s1,s1,8
80004e66:	dfeff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80004e6a:	ed0d                	bnez	a0,80004ea4 <z_tick_get+0x5a>
80004e6c:	80006437          	lui	s0,0x80006
80004e70:	800065b7          	lui	a1,0x80006
80004e74:	80006537          	lui	a0,0x80006
80004e78:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80004e7c:	04e00693          	li	a3,78
80004e80:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004e84:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004e88:	8b2fd0ef          	jal	ra,80001f3a <printk>
80004e8c:	80006537          	lui	a0,0x80006
80004e90:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80004e94:	8a6fd0ef          	jal	ra,80001f3a <printk>
80004e98:	04e00593          	li	a1,78
80004e9c:	e5440513          	addi	a0,s0,-428
80004ea0:	8b8fd0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ea4:	53890513          	addi	a0,s2,1336
80004ea8:	df8ff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80004eac:	c08fd0ef          	jal	ra,800022b4 <z_clock_elapsed>
80004eb0:	800067b7          	lui	a5,0x80006
80004eb4:	50078793          	addi	a5,a5,1280 # 80006500 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006501>
80004eb8:	0007a983          	lw	s3,0(a5)
80004ebc:	43c0                	lw	s0,4(a5)
80004ebe:	99aa                	add	s3,s3,a0
80004ec0:	00a9b533          	sltu	a0,s3,a0
80004ec4:	942a                	add	s0,s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ec6:	53890513          	addi	a0,s2,1336
80004eca:	db4ff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
80004ece:	ed0d                	bnez	a0,80004f08 <z_tick_get+0xbe>
80004ed0:	80006937          	lui	s2,0x80006
80004ed4:	800065b7          	lui	a1,0x80006
80004ed8:	80006537          	lui	a0,0x80006
80004edc:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80004ee0:	06100693          	li	a3,97
80004ee4:	e5490613          	addi	a2,s2,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80004ee8:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80004eec:	84efd0ef          	jal	ra,80001f3a <printk>
80004ef0:	80006537          	lui	a0,0x80006
80004ef4:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80004ef8:	842fd0ef          	jal	ra,80001f3a <printk>
80004efc:	06100593          	li	a1,97
80004f00:	e5490513          	addi	a0,s2,-428
80004f04:	854fd0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004f08:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80004f0c:	85a2                	mv	a1,s0
80004f0e:	40f2                	lw	ra,28(sp)
80004f10:	4462                	lw	s0,24(sp)
80004f12:	854e                	mv	a0,s3
80004f14:	44d2                	lw	s1,20(sp)
80004f16:	4942                	lw	s2,16(sp)
80004f18:	49b2                	lw	s3,12(sp)
80004f1a:	6105                	addi	sp,sp,32
80004f1c:	8082                	ret

80004f1e <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80004f1e:	1141                	addi	sp,sp,-16
80004f20:	c606                	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80004f22:	f29ff0ef          	jal	ra,80004e4a <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80004f26:	40b2                	lw	ra,12(sp)
80004f28:	0141                	addi	sp,sp,16
80004f2a:	8082                	ret

80004f2c <z_impl_k_uptime_get_32>:

u32_t z_impl_k_uptime_get_32(void)
{
80004f2c:	1141                	addi	sp,sp,-16
80004f2e:	c606                	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get_32());
80004f30:	fefff0ef          	jal	ra,80004f1e <z_tick_get_32>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80004f34:	3e800613          	li	a2,1000
80004f38:	4681                	li	a3,0
80004f3a:	4581                	li	a1,0
80004f3c:	915fb0ef          	jal	ra,80000850 <__muldi3>
80004f40:	06400613          	li	a2,100
80004f44:	4681                	li	a3,0
80004f46:	b12fb0ef          	jal	ra,80000258 <__udivdi3>
}
80004f4a:	40b2                	lw	ra,12(sp)
80004f4c:	0141                	addi	sp,sp,16
80004f4e:	8082                	ret

80004f50 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80004f50:	1141                	addi	sp,sp,-16
80004f52:	c422                	sw	s0,8(sp)
80004f54:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004f56:	80006437          	lui	s0,0x80006
80004f5a:	800064b7          	lui	s1,0x80006
{
80004f5e:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004f60:	4bc40413          	addi	s0,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004f64:	4bc48493          	addi	s1,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004f68:	00946863          	bltu	s0,s1,80004f78 <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
80004f6c:	40b2                	lw	ra,12(sp)
80004f6e:	4422                	lw	s0,8(sp)
80004f70:	4492                	lw	s1,4(sp)
80004f72:	4501                	li	a0,0
80004f74:	0141                	addi	sp,sp,16
80004f76:	8082                	ret
80004f78:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80004f7c:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80004f7e:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80004f80:	cc1c                	sw	a5,24(s0)
80004f82:	e70fc0ef          	jal	ra,800015f2 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004f86:	0471                	addi	s0,s0,28
80004f88:	b7c5                	j	80004f68 <init_static_pools+0x18>

80004f8a <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80004f8a:	800077b7          	lui	a5,0x80007
80004f8e:	8a07a783          	lw	a5,-1888(a5) # 800068a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a1>
{
80004f92:	715d                	addi	sp,sp,-80
80004f94:	c4a2                	sw	s0,72(sp)
80004f96:	c2a6                	sw	s1,68(sp)
80004f98:	de4e                	sw	s3,60(sp)
80004f9a:	d85a                	sw	s6,48(sp)
80004f9c:	c686                	sw	ra,76(sp)
80004f9e:	c0ca                	sw	s2,64(sp)
80004fa0:	dc52                	sw	s4,56(sp)
80004fa2:	da56                	sw	s5,52(sp)
80004fa4:	d65e                	sw	s7,44(sp)
80004fa6:	d462                	sw	s8,40(sp)
80004fa8:	d266                	sw	s9,36(sp)
80004faa:	d06a                	sw	s10,32(sp)
80004fac:	ce6e                	sw	s11,28(sp)
80004fae:	89aa                	mv	s3,a0
80004fb0:	84ae                	mv	s1,a1
80004fb2:	8b32                	mv	s6,a2
80004fb4:	8436                	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80004fb6:	10078063          	beqz	a5,800050b6 <k_mem_pool_alloc+0x12c>
80004fba:	e2f1                	bnez	a3,8000507e <k_mem_pool_alloc+0xf4>
	s64_t end = 0;
80004fbc:	4901                	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80004fbe:	80006537          	lui	a0,0x80006
80004fc2:	4bc50513          	addi	a0,a0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004fc6:	40a98533          	sub	a0,s3,a0
80004fca:	b6db75b7          	lui	a1,0xb6db7
80004fce:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
80004fd2:	8509                	srai	a0,a0,0x2
80004fd4:	859fb0ef          	jal	ra,8000082c <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80004fd8:	7a7d                	lui	s4,0xfffff
		block->id.block = block_num;
80004fda:	6a85                	lui	s5,0x1
		block->id.pool = pool_id(p);
80004fdc:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80004fe0:	5bd5                	li	s7,-11
			ret = -ENOMEM;
80004fe2:	5cd1                	li	s9,-12
		block->id.level = level_num;
80004fe4:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80004fe8:	1afd                	addi	s5,s5,-1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004fea:	4d21                	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80004fec:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80004ff0:	8726                	mv	a4,s1
80004ff2:	0074                	addi	a3,sp,12
80004ff4:	0030                	addi	a2,sp,8
80004ff6:	85da                	mv	a1,s6
80004ff8:	854e                	mv	a0,s3
80004ffa:	ec0fc0ef          	jal	ra,800016ba <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80004ffe:	01751c63          	bne	a0,s7,80005016 <k_mem_pool_alloc+0x8c>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80005002:	8726                	mv	a4,s1
80005004:	0074                	addi	a3,sp,12
80005006:	0030                	addi	a2,sp,8
80005008:	85da                	mv	a1,s6
8000500a:	854e                	mv	a0,s3
8000500c:	eaefc0ef          	jal	ra,800016ba <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80005010:	01751363          	bne	a0,s7,80005016 <k_mem_pool_alloc+0x8c>
			ret = -ENOMEM;
80005014:	5551                	li	a0,-12
		block->id.level = level_num;
80005016:	47a2                	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80005018:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
8000501c:	8bbd                	andi	a5,a5,15
8000501e:	00879713          	slli	a4,a5,0x8
80005022:	40dc                	lw	a5,4(s1)
80005024:	0147f7b3          	and	a5,a5,s4
80005028:	8fd9                	or	a5,a5,a4
		block->id.block = block_num;
8000502a:	4732                	lw	a4,12(sp)
8000502c:	0157f7b3          	and	a5,a5,s5
80005030:	0732                	slli	a4,a4,0xc
80005032:	8fd9                	or	a5,a5,a4
80005034:	c0dc                	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
80005036:	c50d                	beqz	a0,80005060 <k_mem_pool_alloc+0xd6>
80005038:	c405                	beqz	s0,80005060 <k_mem_pool_alloc+0xd6>
8000503a:	03951363          	bne	a0,s9,80005060 <k_mem_pool_alloc+0xd6>
8000503e:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80005042:	8622                	mv	a2,s0
80005044:	85ee                	mv	a1,s11
80005046:	8921                	andi	a0,a0,8
80005048:	ab5fe0ef          	jal	ra,80003afc <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
8000504c:	57fd                	li	a5,-1
8000504e:	faf401e3          	beq	s0,a5,80004ff0 <k_mem_pool_alloc+0x66>
			timeout = end - z_tick_get();
80005052:	df9ff0ef          	jal	ra,80004e4a <z_tick_get>
80005056:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
8000505a:	f8045be3          	bgez	s0,80004ff0 <k_mem_pool_alloc+0x66>
				break;
			}
		}
	}

	return -EAGAIN;
8000505e:	5555                	li	a0,-11
}
80005060:	40b6                	lw	ra,76(sp)
80005062:	4426                	lw	s0,72(sp)
80005064:	4496                	lw	s1,68(sp)
80005066:	4906                	lw	s2,64(sp)
80005068:	59f2                	lw	s3,60(sp)
8000506a:	5a62                	lw	s4,56(sp)
8000506c:	5ad2                	lw	s5,52(sp)
8000506e:	5b42                	lw	s6,48(sp)
80005070:	5bb2                	lw	s7,44(sp)
80005072:	5c22                	lw	s8,40(sp)
80005074:	5c92                	lw	s9,36(sp)
80005076:	5d02                	lw	s10,32(sp)
80005078:	4df2                	lw	s11,28(sp)
8000507a:	6161                	addi	sp,sp,80
8000507c:	8082                	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
8000507e:	80006937          	lui	s2,0x80006
80005082:	800065b7          	lui	a1,0x80006
80005086:	80006537          	lui	a0,0x80006
8000508a:	39058593          	addi	a1,a1,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
8000508e:	03900693          	li	a3,57
80005092:	37c90613          	addi	a2,s2,892 # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
80005096:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
8000509a:	ea1fc0ef          	jal	ra,80001f3a <printk>
8000509e:	80006537          	lui	a0,0x80006
800050a2:	e0c50513          	addi	a0,a0,-500 # 80005e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e0d>
800050a6:	e95fc0ef          	jal	ra,80001f3a <printk>
800050aa:	03900593          	li	a1,57
800050ae:	37c90513          	addi	a0,s2,892
800050b2:	ea7fc0ef          	jal	ra,80001f58 <assert_post_action>
	if (timeout > 0) {
800050b6:	f08053e3          	blez	s0,80004fbc <k_mem_pool_alloc+0x32>
		end = z_tick_get() + z_ms_to_ticks(timeout);
800050ba:	d91ff0ef          	jal	ra,80004e4a <z_tick_get>
800050be:	892a                	mv	s2,a0
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800050c0:	45a9                	li	a1,10
800050c2:	00940513          	addi	a0,s0,9
800050c6:	81bfb0ef          	jal	ra,800008e0 <__divsi3>
800050ca:	992a                	add	s2,s2,a0
800050cc:	bdcd                	j	80004fbe <k_mem_pool_alloc+0x34>

800050ce <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800050ce:	00054783          	lbu	a5,0(a0)
{
800050d2:	1101                	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800050d4:	4110                	lw	a2,0(a0)
{
800050d6:	cc22                	sw	s0,24(sp)
800050d8:	00379413          	slli	s0,a5,0x3
800050dc:	c84a                	sw	s2,16(sp)
800050de:	8c1d                	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800050e0:	80006937          	lui	s2,0x80006
800050e4:	040a                	slli	s0,s0,0x2
800050e6:	00865593          	srli	a1,a2,0x8
800050ea:	4bc90513          	addi	a0,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800050ee:	8231                	srli	a2,a2,0xc
800050f0:	89bd                	andi	a1,a1,15
800050f2:	9522                	add	a0,a0,s0
{
800050f4:	ce06                	sw	ra,28(sp)
800050f6:	ca26                	sw	s1,20(sp)
800050f8:	c64e                	sw	s3,12(sp)
800050fa:	c452                	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800050fc:	fcefc0ef          	jal	ra,800018ca <z_sys_mem_pool_block_free>
80005100:	45a1                	li	a1,8
80005102:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005106:	800064b7          	lui	s1,0x80006
8000510a:	53c48513          	addi	a0,s1,1340 # 8000653c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000653d>
	key = (mstatus & SOC_MSTATUS_IEN);
8000510e:	0085f993          	andi	s3,a1,8
80005112:	b52ff0ef          	jal	ra,80004464 <z_spin_lock_valid>
80005116:	4bc90913          	addi	s2,s2,1212
8000511a:	ed0d                	bnez	a0,80005154 <k_mem_pool_free_id+0x86>
8000511c:	80006a37          	lui	s4,0x80006
80005120:	800065b7          	lui	a1,0x80006
80005124:	80006537          	lui	a0,0x80006
80005128:	e6c58593          	addi	a1,a1,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
8000512c:	04e00693          	li	a3,78
80005130:	e54a0613          	addi	a2,s4,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80005134:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
80005138:	e03fc0ef          	jal	ra,80001f3a <printk>
8000513c:	80006537          	lui	a0,0x80006
80005140:	e8450513          	addi	a0,a0,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
80005144:	df7fc0ef          	jal	ra,80001f3a <printk>
80005148:	04e00593          	li	a1,78
8000514c:	e54a0513          	addi	a0,s4,-428
80005150:	e09fc0ef          	jal	ra,80001f58 <assert_post_action>
	z_spin_lock_set_owner(l);
80005154:	53c48513          	addi	a0,s1,1340
80005158:	b48ff0ef          	jal	ra,800044a0 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
8000515c:	01440513          	addi	a0,s0,20
80005160:	954a                	add	a0,a0,s2
80005162:	ba9fe0ef          	jal	ra,80003d0a <z_unpend_all>

	if (need_sched != 0) {
80005166:	cd09                	beqz	a0,80005180 <k_mem_pool_free_id+0xb2>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
80005168:	4462                	lw	s0,24(sp)
8000516a:	40f2                	lw	ra,28(sp)
8000516c:	4942                	lw	s2,16(sp)
8000516e:	4a22                	lw	s4,8(sp)
		z_reschedule(&lock, key);
80005170:	85ce                	mv	a1,s3
80005172:	53c48513          	addi	a0,s1,1340
}
80005176:	49b2                	lw	s3,12(sp)
80005178:	44d2                	lw	s1,20(sp)
8000517a:	6105                	addi	sp,sp,32
		z_reschedule(&lock, key);
8000517c:	e5dfd06f          	j	80002fd8 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005180:	53c48513          	addi	a0,s1,1340
80005184:	afaff0ef          	jal	ra,8000447e <z_spin_unlock_valid>
80005188:	ed0d                	bnez	a0,800051c2 <k_mem_pool_free_id+0xf4>
8000518a:	80006437          	lui	s0,0x80006
8000518e:	800065b7          	lui	a1,0x80006
80005192:	80006537          	lui	a0,0x80006
80005196:	e9c58593          	addi	a1,a1,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
8000519a:	06100693          	li	a3,97
8000519e:	e5440613          	addi	a2,s0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
800051a2:	d8850513          	addi	a0,a0,-632 # 80005d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d89>
800051a6:	d95fc0ef          	jal	ra,80001f3a <printk>
800051aa:	80006537          	lui	a0,0x80006
800051ae:	eb450513          	addi	a0,a0,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
800051b2:	d89fc0ef          	jal	ra,80001f3a <printk>
800051b6:	06100593          	li	a1,97
800051ba:	e5440513          	addi	a0,s0,-428
800051be:	d9bfc0ef          	jal	ra,80001f58 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800051c2:	3009a5f3          	csrrs	a1,mstatus,s3
}
800051c6:	40f2                	lw	ra,28(sp)
800051c8:	4462                	lw	s0,24(sp)
800051ca:	44d2                	lw	s1,20(sp)
800051cc:	4942                	lw	s2,16(sp)
800051ce:	49b2                	lw	s3,12(sp)
800051d0:	4a22                	lw	s4,8(sp)
800051d2:	6105                	addi	sp,sp,32
800051d4:	8082                	ret

800051d6 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
800051d6:	00458613          	addi	a2,a1,4
800051da:	00b67863          	bgeu	a2,a1,800051ea <k_mem_pool_malloc+0x14>
				   &size)) {
		return NULL;
800051de:	4501                	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
800051e0:	8082                	ret
		return NULL;
800051e2:	4501                	li	a0,0
}
800051e4:	40f2                	lw	ra,28(sp)
800051e6:	6105                	addi	sp,sp,32
800051e8:	8082                	ret
{
800051ea:	1101                	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
800051ec:	4681                	li	a3,0
800051ee:	002c                	addi	a1,sp,8
{
800051f0:	ce06                	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
800051f2:	d99ff0ef          	jal	ra,80004f8a <k_mem_pool_alloc>
800051f6:	f575                	bnez	a0,800051e2 <k_mem_pool_malloc+0xc>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
800051f8:	4522                	lw	a0,8(sp)
800051fa:	4611                	li	a2,4
800051fc:	006c                	addi	a1,sp,12
800051fe:	99cfd0ef          	jal	ra,8000239a <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80005202:	4522                	lw	a0,8(sp)
80005204:	0511                	addi	a0,a0,4
80005206:	bff9                	j	800051e4 <k_mem_pool_malloc+0xe>

80005208 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80005208:	c501                	beqz	a0,80005210 <k_free+0x8>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
8000520a:	1571                	addi	a0,a0,-4
8000520c:	ec3ff06f          	j	800050ce <k_mem_pool_free_id>
	}
}
80005210:	8082                	ret

80005212 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80005212:	800077b7          	lui	a5,0x80007
80005216:	8a87a783          	lw	a5,-1880(a5) # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
{
8000521a:	85aa                	mv	a1,a0
	if (_current->resource_pool != NULL) {
8000521c:	57a8                	lw	a0,104(a5)
8000521e:	c119                	beqz	a0,80005224 <z_thread_malloc+0x12>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80005220:	fb7ff06f          	j	800051d6 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
80005224:	4501                	li	a0,0
80005226:	8082                	ret

80005228 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005228:	8082                	ret
