
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	4a10006f          	j	80000cac <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	3490006f          	j	80000be4 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00006397          	auipc	t2,0x6
800000b8:	58838393          	addi	t2,t2,1416 # 8000663c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	3910006f          	j	80000c70 <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00005297          	auipc	t0,0x5
800000fc:	36828293          	addi	t0,t0,872 # 80005460 <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00006317          	auipc	t1,0x6
80000118:	52830313          	addi	t1,t1,1320 # 8000663c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00006297          	auipc	t0,0x6
80000140:	50028293          	addi	t0,t0,1280 # 8000663c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00006397          	auipc	t2,0x6
80000180:	11838393          	addi	t2,t2,280 # 80006294 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00006297          	auipc	t0,0x6
80000230:	41028293          	addi	t0,t0,1040 # 8000663c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	00058793          	mv	a5,a1
800002b4:	00060813          	mv	a6,a2
800002b8:	00068713          	mv	a4,a3
800002bc:	00050313          	mv	t1,a0
800002c0:	28069663          	bnez	a3,8000054c <__udivdi3+0x29c>
800002c4:	00005897          	auipc	a7,0x5
800002c8:	32888893          	addi	a7,a7,808 # 800055ec <__devconfig_end>
800002cc:	0ec5f663          	bgeu	a1,a2,800003b8 <__udivdi3+0x108>
800002d0:	00010737          	lui	a4,0x10
800002d4:	0ce67863          	bgeu	a2,a4,800003a4 <__udivdi3+0xf4>
800002d8:	0ff00713          	li	a4,255
800002dc:	00c73733          	sltu	a4,a4,a2
800002e0:	00371713          	slli	a4,a4,0x3
800002e4:	00e656b3          	srl	a3,a2,a4
800002e8:	00d888b3          	add	a7,a7,a3
800002ec:	0008c683          	lbu	a3,0(a7)
800002f0:	00e68733          	add	a4,a3,a4
800002f4:	02000693          	li	a3,32
800002f8:	40e686b3          	sub	a3,a3,a4
800002fc:	00068c63          	beqz	a3,80000314 <__udivdi3+0x64>
80000300:	00d797b3          	sll	a5,a5,a3
80000304:	00e55733          	srl	a4,a0,a4
80000308:	00d61833          	sll	a6,a2,a3
8000030c:	00f765b3          	or	a1,a4,a5
80000310:	00d51333          	sll	t1,a0,a3
80000314:	01085513          	srli	a0,a6,0x10
80000318:	02a5f733          	remu	a4,a1,a0
8000031c:	01081613          	slli	a2,a6,0x10
80000320:	01065613          	srli	a2,a2,0x10
80000324:	01035693          	srli	a3,t1,0x10
80000328:	02a5d5b3          	divu	a1,a1,a0
8000032c:	01071713          	slli	a4,a4,0x10
80000330:	00d766b3          	or	a3,a4,a3
80000334:	02b607b3          	mul	a5,a2,a1
80000338:	00058713          	mv	a4,a1
8000033c:	00f6fe63          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000340:	010686b3          	add	a3,a3,a6
80000344:	fff58713          	addi	a4,a1,-1
80000348:	0106e863          	bltu	a3,a6,80000358 <__udivdi3+0xa8>
8000034c:	00f6f663          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000350:	ffe58713          	addi	a4,a1,-2
80000354:	010686b3          	add	a3,a3,a6
80000358:	40f686b3          	sub	a3,a3,a5
8000035c:	02a6f7b3          	remu	a5,a3,a0
80000360:	01031313          	slli	t1,t1,0x10
80000364:	01035313          	srli	t1,t1,0x10
80000368:	02a6d6b3          	divu	a3,a3,a0
8000036c:	01079793          	slli	a5,a5,0x10
80000370:	0067e333          	or	t1,a5,t1
80000374:	02d605b3          	mul	a1,a2,a3
80000378:	00068513          	mv	a0,a3
8000037c:	00b37c63          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000380:	00680333          	add	t1,a6,t1
80000384:	fff68513          	addi	a0,a3,-1
80000388:	01036663          	bltu	t1,a6,80000394 <__udivdi3+0xe4>
8000038c:	00b37463          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000390:	ffe68513          	addi	a0,a3,-2
80000394:	01071713          	slli	a4,a4,0x10
80000398:	00a76733          	or	a4,a4,a0
8000039c:	00000593          	li	a1,0
800003a0:	0e40006f          	j	80000484 <__udivdi3+0x1d4>
800003a4:	010006b7          	lui	a3,0x1000
800003a8:	01000713          	li	a4,16
800003ac:	f2d66ce3          	bltu	a2,a3,800002e4 <__udivdi3+0x34>
800003b0:	01800713          	li	a4,24
800003b4:	f31ff06f          	j	800002e4 <__udivdi3+0x34>
800003b8:	00061663          	bnez	a2,800003c4 <__udivdi3+0x114>
800003bc:	00100693          	li	a3,1
800003c0:	02c6d833          	divu	a6,a3,a2
800003c4:	000106b7          	lui	a3,0x10
800003c8:	0cd87263          	bgeu	a6,a3,8000048c <__udivdi3+0x1dc>
800003cc:	0ff00693          	li	a3,255
800003d0:	0106f463          	bgeu	a3,a6,800003d8 <__udivdi3+0x128>
800003d4:	00800713          	li	a4,8
800003d8:	00e856b3          	srl	a3,a6,a4
800003dc:	00d888b3          	add	a7,a7,a3
800003e0:	0008c683          	lbu	a3,0(a7)
800003e4:	00e686b3          	add	a3,a3,a4
800003e8:	02000713          	li	a4,32
800003ec:	40d70733          	sub	a4,a4,a3
800003f0:	0a071863          	bnez	a4,800004a0 <__udivdi3+0x1f0>
800003f4:	410787b3          	sub	a5,a5,a6
800003f8:	00100593          	li	a1,1
800003fc:	01085613          	srli	a2,a6,0x10
80000400:	01081893          	slli	a7,a6,0x10
80000404:	0108d893          	srli	a7,a7,0x10
80000408:	01035693          	srli	a3,t1,0x10
8000040c:	02c7f733          	remu	a4,a5,a2
80000410:	02c7d7b3          	divu	a5,a5,a2
80000414:	01071713          	slli	a4,a4,0x10
80000418:	00d766b3          	or	a3,a4,a3
8000041c:	02f88533          	mul	a0,a7,a5
80000420:	00078713          	mv	a4,a5
80000424:	00a6fe63          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000428:	010686b3          	add	a3,a3,a6
8000042c:	fff78713          	addi	a4,a5,-1
80000430:	0106e863          	bltu	a3,a6,80000440 <__udivdi3+0x190>
80000434:	00a6f663          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000438:	ffe78713          	addi	a4,a5,-2
8000043c:	010686b3          	add	a3,a3,a6
80000440:	40a686b3          	sub	a3,a3,a0
80000444:	02c6f7b3          	remu	a5,a3,a2
80000448:	01031313          	slli	t1,t1,0x10
8000044c:	01035313          	srli	t1,t1,0x10
80000450:	02c6d6b3          	divu	a3,a3,a2
80000454:	01079793          	slli	a5,a5,0x10
80000458:	0067e333          	or	t1,a5,t1
8000045c:	02d888b3          	mul	a7,a7,a3
80000460:	00068513          	mv	a0,a3
80000464:	01137c63          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000468:	00680333          	add	t1,a6,t1
8000046c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000470:	01036663          	bltu	t1,a6,8000047c <__udivdi3+0x1cc>
80000474:	01137463          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000478:	ffe68513          	addi	a0,a3,-2
8000047c:	01071713          	slli	a4,a4,0x10
80000480:	00a76733          	or	a4,a4,a0
80000484:	00070513          	mv	a0,a4
80000488:	00008067          	ret
8000048c:	010006b7          	lui	a3,0x1000
80000490:	01000713          	li	a4,16
80000494:	f4d862e3          	bltu	a6,a3,800003d8 <__udivdi3+0x128>
80000498:	01800713          	li	a4,24
8000049c:	f3dff06f          	j	800003d8 <__udivdi3+0x128>
800004a0:	00e81833          	sll	a6,a6,a4
800004a4:	00d7d5b3          	srl	a1,a5,a3
800004a8:	00e51333          	sll	t1,a0,a4
800004ac:	00d556b3          	srl	a3,a0,a3
800004b0:	01085513          	srli	a0,a6,0x10
800004b4:	00e797b3          	sll	a5,a5,a4
800004b8:	02a5f733          	remu	a4,a1,a0
800004bc:	00f6e8b3          	or	a7,a3,a5
800004c0:	01081793          	slli	a5,a6,0x10
800004c4:	0107d793          	srli	a5,a5,0x10
800004c8:	0108d613          	srli	a2,a7,0x10
800004cc:	02a5d5b3          	divu	a1,a1,a0
800004d0:	01071713          	slli	a4,a4,0x10
800004d4:	00c76733          	or	a4,a4,a2
800004d8:	02b786b3          	mul	a3,a5,a1
800004dc:	00058613          	mv	a2,a1
800004e0:	00d77e63          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004e4:	01070733          	add	a4,a4,a6
800004e8:	fff58613          	addi	a2,a1,-1
800004ec:	01076863          	bltu	a4,a6,800004fc <__udivdi3+0x24c>
800004f0:	00d77663          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004f4:	ffe58613          	addi	a2,a1,-2
800004f8:	01070733          	add	a4,a4,a6
800004fc:	40d706b3          	sub	a3,a4,a3
80000500:	02a6f733          	remu	a4,a3,a0
80000504:	01089893          	slli	a7,a7,0x10
80000508:	0108d893          	srli	a7,a7,0x10
8000050c:	02a6d6b3          	divu	a3,a3,a0
80000510:	01071713          	slli	a4,a4,0x10
80000514:	02d785b3          	mul	a1,a5,a3
80000518:	011767b3          	or	a5,a4,a7
8000051c:	00068713          	mv	a4,a3
80000520:	00b7fe63          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000524:	010787b3          	add	a5,a5,a6
80000528:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000052c:	0107e863          	bltu	a5,a6,8000053c <__udivdi3+0x28c>
80000530:	00b7f663          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000534:	ffe68713          	addi	a4,a3,-2
80000538:	010787b3          	add	a5,a5,a6
8000053c:	40b787b3          	sub	a5,a5,a1
80000540:	01061593          	slli	a1,a2,0x10
80000544:	00e5e5b3          	or	a1,a1,a4
80000548:	eb5ff06f          	j	800003fc <__udivdi3+0x14c>
8000054c:	18d5e663          	bltu	a1,a3,800006d8 <__udivdi3+0x428>
80000550:	00010737          	lui	a4,0x10
80000554:	04e6f463          	bgeu	a3,a4,8000059c <__udivdi3+0x2ec>
80000558:	0ff00813          	li	a6,255
8000055c:	00d83733          	sltu	a4,a6,a3
80000560:	00371713          	slli	a4,a4,0x3
80000564:	00e6d833          	srl	a6,a3,a4
80000568:	00005597          	auipc	a1,0x5
8000056c:	08458593          	addi	a1,a1,132 # 800055ec <__devconfig_end>
80000570:	010585b3          	add	a1,a1,a6
80000574:	0005c803          	lbu	a6,0(a1)
80000578:	02000593          	li	a1,32
8000057c:	00e80833          	add	a6,a6,a4
80000580:	410585b3          	sub	a1,a1,a6
80000584:	02059663          	bnez	a1,800005b0 <__udivdi3+0x300>
80000588:	00100713          	li	a4,1
8000058c:	eef6ece3          	bltu	a3,a5,80000484 <__udivdi3+0x1d4>
80000590:	00c53533          	sltu	a0,a0,a2
80000594:	00154713          	xori	a4,a0,1
80000598:	eedff06f          	j	80000484 <__udivdi3+0x1d4>
8000059c:	010005b7          	lui	a1,0x1000
800005a0:	01000713          	li	a4,16
800005a4:	fcb6e0e3          	bltu	a3,a1,80000564 <__udivdi3+0x2b4>
800005a8:	01800713          	li	a4,24
800005ac:	fb9ff06f          	j	80000564 <__udivdi3+0x2b4>
800005b0:	01065733          	srl	a4,a2,a6
800005b4:	00b696b3          	sll	a3,a3,a1
800005b8:	00d766b3          	or	a3,a4,a3
800005bc:	0106de93          	srli	t4,a3,0x10
800005c0:	0107d733          	srl	a4,a5,a6
800005c4:	03d778b3          	remu	a7,a4,t4
800005c8:	00b797b3          	sll	a5,a5,a1
800005cc:	01055833          	srl	a6,a0,a6
800005d0:	00f86333          	or	t1,a6,a5
800005d4:	01069793          	slli	a5,a3,0x10
800005d8:	0107d793          	srli	a5,a5,0x10
800005dc:	01035813          	srli	a6,t1,0x10
800005e0:	00b61633          	sll	a2,a2,a1
800005e4:	03d75733          	divu	a4,a4,t4
800005e8:	01089893          	slli	a7,a7,0x10
800005ec:	0108e833          	or	a6,a7,a6
800005f0:	02e78f33          	mul	t5,a5,a4
800005f4:	00070e13          	mv	t3,a4
800005f8:	01e87e63          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
800005fc:	00d80833          	add	a6,a6,a3
80000600:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000604:	00d86863          	bltu	a6,a3,80000614 <__udivdi3+0x364>
80000608:	01e87663          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
8000060c:	ffe70e13          	addi	t3,a4,-2
80000610:	00d80833          	add	a6,a6,a3
80000614:	41e80833          	sub	a6,a6,t5
80000618:	03d878b3          	remu	a7,a6,t4
8000061c:	03d85833          	divu	a6,a6,t4
80000620:	01089893          	slli	a7,a7,0x10
80000624:	03078eb3          	mul	t4,a5,a6
80000628:	01031793          	slli	a5,t1,0x10
8000062c:	0107d793          	srli	a5,a5,0x10
80000630:	00f8e7b3          	or	a5,a7,a5
80000634:	00080713          	mv	a4,a6
80000638:	01d7fe63          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000063c:	00d787b3          	add	a5,a5,a3
80000640:	fff80713          	addi	a4,a6,-1
80000644:	00d7e863          	bltu	a5,a3,80000654 <__udivdi3+0x3a4>
80000648:	01d7f663          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000064c:	ffe80713          	addi	a4,a6,-2
80000650:	00d787b3          	add	a5,a5,a3
80000654:	010e1e13          	slli	t3,t3,0x10
80000658:	41d787b3          	sub	a5,a5,t4
8000065c:	00010eb7          	lui	t4,0x10
80000660:	00ee6733          	or	a4,t3,a4
80000664:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000668:	01077333          	and	t1,a4,a6
8000066c:	01075893          	srli	a7,a4,0x10
80000670:	01067833          	and	a6,a2,a6
80000674:	01065613          	srli	a2,a2,0x10
80000678:	03030e33          	mul	t3,t1,a6
8000067c:	03088833          	mul	a6,a7,a6
80000680:	010e5693          	srli	a3,t3,0x10
80000684:	02c30333          	mul	t1,t1,a2
80000688:	01030333          	add	t1,t1,a6
8000068c:	006686b3          	add	a3,a3,t1
80000690:	02c888b3          	mul	a7,a7,a2
80000694:	0106f463          	bgeu	a3,a6,8000069c <__udivdi3+0x3ec>
80000698:	01d888b3          	add	a7,a7,t4
8000069c:	0106d613          	srli	a2,a3,0x10
800006a0:	011608b3          	add	a7,a2,a7
800006a4:	0317e663          	bltu	a5,a7,800006d0 <__udivdi3+0x420>
800006a8:	cf179ae3          	bne	a5,a7,8000039c <__udivdi3+0xec>
800006ac:	000107b7          	lui	a5,0x10
800006b0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006b4:	00f6f6b3          	and	a3,a3,a5
800006b8:	01069693          	slli	a3,a3,0x10
800006bc:	00fe7e33          	and	t3,t3,a5
800006c0:	00b51533          	sll	a0,a0,a1
800006c4:	01c686b3          	add	a3,a3,t3
800006c8:	00000593          	li	a1,0
800006cc:	dad57ce3          	bgeu	a0,a3,80000484 <__udivdi3+0x1d4>
800006d0:	fff70713          	addi	a4,a4,-1
800006d4:	cc9ff06f          	j	8000039c <__udivdi3+0xec>
800006d8:	00000593          	li	a1,0
800006dc:	00000713          	li	a4,0
800006e0:	da5ff06f          	j	80000484 <__udivdi3+0x1d4>

800006e4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006e4:	00008067          	ret

800006e8 <z_zassert.constprop.3>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
800006e8:	fd010113          	addi	sp,sp,-48
800006ec:	00112e23          	sw	ra,28(sp)
800006f0:	03012423          	sw	a6,40(sp)
800006f4:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
800006f8:	04051863          	bnez	a0,80000748 <z_zassert.constprop.3+0x60>
800006fc:	00068613          	mv	a2,a3
80000700:	00058713          	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000704:	800056b7          	lui	a3,0x80005
80000708:	800055b7          	lui	a1,0x80005
8000070c:	80006537          	lui	a0,0x80006
		va_start(vargs, msg);
80000710:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000714:	6ec68693          	addi	a3,a3,1772 # 800056ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056ed>
80000718:	7f858593          	addi	a1,a1,2040 # 800057f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057f9>
8000071c:	82450513          	addi	a0,a0,-2012 # 80005824 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005825>
		va_start(vargs, msg);
80000720:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000724:	1b4010ef          	jal	ra,800018d8 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000728:	00c12583          	lw	a1,12(sp)
8000072c:	80006537          	lui	a0,0x80006
80000730:	8a050513          	addi	a0,a0,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
80000734:	174010ef          	jal	ra,800018a8 <vprintk>
		printk("\n");
80000738:	80006537          	lui	a0,0x80006
8000073c:	9a050513          	addi	a0,a0,-1632 # 800059a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059a1>
80000740:	198010ef          	jal	ra,800018d8 <printk>
		va_end(vargs);
		ztest_test_fail();
80000744:	0fd010ef          	jal	ra,80002040 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000748:	01c12083          	lw	ra,28(sp)
8000074c:	03010113          	addi	sp,sp,48
80000750:	00008067          	ret

80000754 <test_send>:

	k_sem_init(&sync_sema, 0, 1);
}

void test_send(void *p1, void *p2, void *p3)
{
80000754:	fc010113          	addi	sp,sp,-64
80000758:	02812c23          	sw	s0,56(sp)
	(void)memset(&mmsg, 0, sizeof(mmsg));
8000075c:	02c00613          	li	a2,44
{
80000760:	00050413          	mv	s0,a0
	(void)memset(&mmsg, 0, sizeof(mmsg));
80000764:	00000593          	li	a1,0
80000768:	00410513          	addi	a0,sp,4
{
8000076c:	02112e23          	sw	ra,60(sp)
	(void)memset(&mmsg, 0, sizeof(mmsg));
80000770:	7a8010ef          	jal	ra,80001f18 <memset>
	switch (info_type) {
80000774:	800067b7          	lui	a5,0x80006
80000778:	3507a783          	lw	a5,848(a5) # 80006350 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006351>
8000077c:	02079063          	bnez	a5,8000079c <test_send+0x48>
			k_mbox_put(pmbox, &mmsg, K_NO_WAIT);
80000780:	00000613          	li	a2,0
80000784:	00410593          	addi	a1,sp,4
80000788:	00040513          	mv	a0,s0
		mmsg.info = PUT_GET_NULL;
8000078c:	00012623          	sw	zero,12(sp)
		mmsg.size = 0;
80000790:	00012423          	sw	zero,8(sp)
		mmsg.tx_data = NULL;
80000794:	00012823          	sw	zero,16(sp)
			k_mbox_put(pmbox, &mmsg, K_NO_WAIT);
80000798:	27c020ef          	jal	ra,80002a14 <k_mbox_put>
	msg_sender((struct k_mbox *)p1, K_NO_WAIT);
}
8000079c:	03c12083          	lw	ra,60(sp)
800007a0:	03812403          	lw	s0,56(sp)
800007a4:	04010113          	addi	sp,sp,64
800007a8:	00008067          	ret

800007ac <test_send_un>:
	msg_receiver(&mbox, K_ANY, 2);
	k_thread_abort(tid);
}

void test_send_un(void *p1, void *p2, void *p3)
{
800007ac:	fc010113          	addi	sp,sp,-64
800007b0:	02812c23          	sw	s0,56(sp)
800007b4:	00050413          	mv	s0,a0
	TC_PRINT("Sender UNLIMITED\n");
800007b8:	80005537          	lui	a0,0x80005
800007bc:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
{
800007c0:	02112e23          	sw	ra,60(sp)
	TC_PRINT("Sender UNLIMITED\n");
800007c4:	114010ef          	jal	ra,800018d8 <printk>
	(void)memset(&mmsg, 0, sizeof(mmsg));
800007c8:	02c00613          	li	a2,44
800007cc:	00000593          	li	a1,0
800007d0:	00410513          	addi	a0,sp,4
800007d4:	744010ef          	jal	ra,80001f18 <memset>
	switch (info_type) {
800007d8:	800067b7          	lui	a5,0x80006
800007dc:	3507a783          	lw	a5,848(a5) # 80006350 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006351>
800007e0:	02079063          	bnez	a5,80000800 <test_send_un+0x54>
			k_mbox_put(pmbox, &mmsg, K_FOREVER);
800007e4:	fff00613          	li	a2,-1
800007e8:	00410593          	addi	a1,sp,4
800007ec:	00040513          	mv	a0,s0
		mmsg.info = PUT_GET_NULL;
800007f0:	00012623          	sw	zero,12(sp)
		mmsg.size = 0;
800007f4:	00012423          	sw	zero,8(sp)
		mmsg.tx_data = NULL;
800007f8:	00012823          	sw	zero,16(sp)
			k_mbox_put(pmbox, &mmsg, K_FOREVER);
800007fc:	218020ef          	jal	ra,80002a14 <k_mbox_put>
	msg_sender((struct k_mbox *)p1, K_FOREVER);
}
80000800:	03c12083          	lw	ra,60(sp)
80000804:	03812403          	lw	s0,56(sp)
80000808:	04010113          	addi	sp,sp,64
8000080c:	00008067          	ret

80000810 <msg_receiver_unlimited>:

/* Receive message from thread tid1 */
void msg_receiver_unlimited(void)
{
80000810:	f7010113          	addi	sp,sp,-144
80000814:	08812423          	sw	s0,136(sp)
	info_type = PUT_GET_NULL;
80000818:	80006437          	lui	s0,0x80006
{
8000081c:	08112623          	sw	ra,140(sp)
80000820:	08912223          	sw	s1,132(sp)
	info_type = PUT_GET_NULL;
80000824:	35040413          	addi	s0,s0,848 # 80006350 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006351>
80000828:	00042023          	sw	zero,0(s0)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000082c:	181030ef          	jal	ra,800041ac <z_impl_k_current_get>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000830:	800064b7          	lui	s1,0x80006
80000834:	800006b7          	lui	a3,0x80000
80000838:	800065b7          	lui	a1,0x80006
8000083c:	80006537          	lui	a0,0x80006
80000840:	00000793          	li	a5,0
80000844:	44848713          	addi	a4,s1,1096 # 80006448 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006449>
80000848:	00012223          	sw	zero,4(sp)
8000084c:	00012023          	sw	zero,0(sp)
80000850:	00000893          	li	a7,0
80000854:	00000813          	li	a6,0
80000858:	7ac68693          	addi	a3,a3,1964 # 800007ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800007ad>
8000085c:	20000613          	li	a2,512
80000860:	67058593          	addi	a1,a1,1648 # 80006670 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006671>
80000864:	46c50513          	addi	a0,a0,1132 # 8000646c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000646d>
80000868:	12c040ef          	jal	ra,80004994 <z_impl_k_thread_create>
	switch (info_type) {
8000086c:	00042703          	lw	a4,0(s0)

	receiver_tid = k_current_get();
	tid1 = k_thread_create(&tdata, tstack, STACK_SIZE,
80000870:	800067b7          	lui	a5,0x80006
80000874:	34a7ac23          	sw	a0,856(a5) # 80006358 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006359>
	switch (info_type) {
80000878:	35878413          	addi	s0,a5,856
8000087c:	04071863          	bnez	a4,800008cc <msg_receiver_unlimited+0xbc>
		mmsg.size = sizeof(rxdata);
80000880:	04000793          	li	a5,64
		mmsg.rx_source_thread = thd_id;
80000884:	02a12823          	sw	a0,48(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000888:	fff00693          	li	a3,-1
8000088c:	04010613          	addi	a2,sp,64
80000890:	01410593          	addi	a1,sp,20
80000894:	44848513          	addi	a0,s1,1096
		mmsg.size = sizeof(rxdata);
80000898:	00f12c23          	sw	a5,24(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
8000089c:	1d0020ef          	jal	ra,80002a6c <k_mbox_get>
800008a0:	800067b7          	lui	a5,0x80006
800008a4:	80005737          	lui	a4,0x80005
800008a8:	80005637          	lui	a2,0x80005
800008ac:	800055b7          	lui	a1,0x80005
800008b0:	8a078793          	addi	a5,a5,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
800008b4:	6ec70713          	addi	a4,a4,1772 # 800056ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056ed>
800008b8:	04300693          	li	a3,67
800008bc:	7f860613          	addi	a2,a2,2040 # 800057f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057f9>
800008c0:	6fc58593          	addi	a1,a1,1788 # 800056fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056fd>
800008c4:	00153513          	seqz	a0,a0
800008c8:	e21ff0ef          	jal	ra,800006e8 <z_zassert.constprop.3>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800008cc:	00042503          	lw	a0,0(s0)
800008d0:	268040ef          	jal	ra,80004b38 <z_impl_k_thread_abort>
			      test_send_un, &mbox, NULL, NULL,
			      K_PRIO_PREEMPT(0), 0, K_NO_WAIT);

	msg_receiver(&mbox, tid1, K_FOREVER);
	k_thread_abort(tid1);
}
800008d4:	08c12083          	lw	ra,140(sp)
800008d8:	08812403          	lw	s0,136(sp)
800008dc:	08412483          	lw	s1,132(sp)
800008e0:	09010113          	addi	sp,sp,144
800008e4:	00008067          	ret

800008e8 <test_msg_receiver>:
{
800008e8:	f6010113          	addi	sp,sp,-160
800008ec:	08812c23          	sw	s0,152(sp)
800008f0:	08912a23          	sw	s1,148(sp)
	info_type = PUT_GET_NULL;
800008f4:	80006437          	lui	s0,0x80006
			zassert_false(k_mbox_get(pmbox, &mmsg,
800008f8:	800064b7          	lui	s1,0x80006
{
800008fc:	08112e23          	sw	ra,156(sp)
80000900:	09212823          	sw	s2,144(sp)
80000904:	09312623          	sw	s3,140(sp)
80000908:	09412423          	sw	s4,136(sp)
8000090c:	09512223          	sw	s5,132(sp)
	info_type = PUT_GET_NULL;
80000910:	35040413          	addi	s0,s0,848 # 80006350 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006351>
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000914:	00000693          	li	a3,0
80000918:	04010613          	addi	a2,sp,64
8000091c:	01410593          	addi	a1,sp,20
		mmsg.size = sizeof(rxdata);
80000920:	04000a93          	li	s5,64
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000924:	44848513          	addi	a0,s1,1096 # 80006448 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006449>
	info_type = PUT_GET_NULL;
80000928:	00042023          	sw	zero,0(s0)
		mmsg.size = sizeof(rxdata);
8000092c:	01512c23          	sw	s5,24(sp)
		mmsg.rx_source_thread = thd_id;
80000930:	02012823          	sw	zero,48(sp)
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000934:	138020ef          	jal	ra,80002a6c <k_mbox_get>
80000938:	800059b7          	lui	s3,0x80005
8000093c:	80006a37          	lui	s4,0x80006
80000940:	80005937          	lui	s2,0x80005
80000944:	800055b7          	lui	a1,0x80005
80000948:	8a0a0793          	addi	a5,s4,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
8000094c:	6ec98713          	addi	a4,s3,1772 # 800056ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056ed>
80000950:	04600693          	li	a3,70
80000954:	7f890613          	addi	a2,s2,2040 # 800057f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057f9>
80000958:	77058593          	addi	a1,a1,1904 # 80005770 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005771>
8000095c:	00a03533          	snez	a0,a0
80000960:	d89ff0ef          	jal	ra,800006e8 <z_zassert.constprop.3>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000964:	800006b7          	lui	a3,0x80000
80000968:	800065b7          	lui	a1,0x80006
8000096c:	80006537          	lui	a0,0x80006
80000970:	00000793          	li	a5,0
80000974:	44848713          	addi	a4,s1,1096
80000978:	00012223          	sw	zero,4(sp)
8000097c:	00012023          	sw	zero,0(sp)
80000980:	00000893          	li	a7,0
80000984:	00000813          	li	a6,0
80000988:	75468693          	addi	a3,a3,1876 # 80000754 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000755>
8000098c:	20000613          	li	a2,512
80000990:	67058593          	addi	a1,a1,1648 # 80006670 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006671>
80000994:	46c50513          	addi	a0,a0,1132 # 8000646c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000646d>
80000998:	7fd030ef          	jal	ra,80004994 <z_impl_k_thread_create>
	switch (info_type) {
8000099c:	00042703          	lw	a4,0(s0)
	tid = k_thread_create(&tdata, tstack, STACK_SIZE,
800009a0:	800067b7          	lui	a5,0x80006
800009a4:	34a7aa23          	sw	a0,852(a5) # 80006354 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006355>
	switch (info_type) {
800009a8:	35478413          	addi	s0,a5,852
800009ac:	04071063          	bnez	a4,800009ec <test_msg_receiver+0x104>
			zassert_true(k_mbox_get(pmbox, &mmsg,
800009b0:	00200693          	li	a3,2
800009b4:	04010613          	addi	a2,sp,64
800009b8:	01410593          	addi	a1,sp,20
800009bc:	44848513          	addi	a0,s1,1096
		mmsg.size = sizeof(rxdata);
800009c0:	01512c23          	sw	s5,24(sp)
		mmsg.rx_source_thread = thd_id;
800009c4:	02012823          	sw	zero,48(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
800009c8:	0a4020ef          	jal	ra,80002a6c <k_mbox_get>
800009cc:	800055b7          	lui	a1,0x80005
800009d0:	8a0a0793          	addi	a5,s4,-1888
800009d4:	6ec98713          	addi	a4,s3,1772
800009d8:	04900693          	li	a3,73
800009dc:	7f890613          	addi	a2,s2,2040
800009e0:	7ac58593          	addi	a1,a1,1964 # 800057ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057ad>
800009e4:	00153513          	seqz	a0,a0
800009e8:	d01ff0ef          	jal	ra,800006e8 <z_zassert.constprop.3>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800009ec:	00042503          	lw	a0,0(s0)
800009f0:	148040ef          	jal	ra,80004b38 <z_impl_k_thread_abort>
}
800009f4:	09c12083          	lw	ra,156(sp)
800009f8:	09812403          	lw	s0,152(sp)
800009fc:	09412483          	lw	s1,148(sp)
80000a00:	09012903          	lw	s2,144(sp)
80000a04:	08c12983          	lw	s3,140(sp)
80000a08:	08812a03          	lw	s4,136(sp)
80000a0c:	08412a83          	lw	s5,132(sp)
80000a10:	0a010113          	addi	sp,sp,160
80000a14:	00008067          	ret

80000a18 <test_main>:
	k_mbox_init(&mbox);
80000a18:	80006537          	lui	a0,0x80006

/*test case main entry*/
void test_main(void)
{
80000a1c:	ff010113          	addi	sp,sp,-16
	k_mbox_init(&mbox);
80000a20:	44850513          	addi	a0,a0,1096 # 80006448 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006449>
{
80000a24:	00112623          	sw	ra,12(sp)
	k_mbox_init(&mbox);
80000a28:	7d1010ef          	jal	ra,800029f8 <k_mbox_init>

K_SYSCALL_DECLARE2(K_SYSCALL_K_MUTEX_LOCK, k_mutex_lock, int, struct k_mutex *, mutex, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000a2c:	80006537          	lui	a0,0x80006
80000a30:	00000593          	li	a1,0
80000a34:	45c50513          	addi	a0,a0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
80000a38:	00100613          	li	a2,1
80000a3c:	77c030ef          	jal	ra,800041b8 <z_impl_k_sem_init>
	test_mbox_init();
	ztest_test_suite(test_mbox,
			 ztest_unit_test(test_msg_receiver),
			 ztest_unit_test(msg_receiver_unlimited));
	ztest_run_test_suite(test_mbox);
}
80000a40:	00c12083          	lw	ra,12(sp)
	ztest_run_test_suite(test_mbox);
80000a44:	800065b7          	lui	a1,0x80006
80000a48:	80005537          	lui	a0,0x80005
80000a4c:	24458593          	addi	a1,a1,580 # 80006244 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006245>
80000a50:	76450513          	addi	a0,a0,1892 # 80005764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005765>
}
80000a54:	01010113          	addi	sp,sp,16
	ztest_run_test_suite(test_mbox);
80000a58:	6180106f          	j	80002070 <z_ztest_run_test_suite>

80000a5c <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000a5c:	ff010113          	addi	sp,sp,-16
80000a60:	00112623          	sw	ra,12(sp)
80000a64:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000a68:	00600793          	li	a5,6
80000a6c:	02f50463          	beq	a0,a5,80000a94 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000a70:	471030ef          	jal	ra,800046e0 <k_is_in_isr>
80000a74:	02050463          	beqz	a0,80000a9c <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000a78:	469030ef          	jal	ra,800046e0 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000a7c:	04051663          	bnez	a0,80000ac8 <z_SysFatalErrorHandler+0x6c>
80000a80:	800065b7          	lui	a1,0x80006
80000a84:	afc58593          	addi	a1,a1,-1284 # 80005afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005afd>
80000a88:	80006537          	lui	a0,0x80006
80000a8c:	b1050513          	addi	a0,a0,-1264 # 80005b10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b11>
80000a90:	649000ef          	jal	ra,800018d8 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000a94:	6b5000ef          	jal	ra,80001948 <k_cpu_idle>
80000a98:	ffdff06f          	j	80000a94 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000a9c:	455030ef          	jal	ra,800046f0 <z_is_thread_essential>
80000aa0:	fc051ce3          	bnez	a0,80000a78 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000aa4:	80006437          	lui	s0,0x80006
80000aa8:	63c40413          	addi	s0,s0,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80000aac:	00842583          	lw	a1,8(s0)
80000ab0:	80006537          	lui	a0,0x80006
80000ab4:	b3050513          	addi	a0,a0,-1232 # 80005b30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b31>
80000ab8:	621000ef          	jal	ra,800018d8 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000abc:	00842503          	lw	a0,8(s0)
80000ac0:	078040ef          	jal	ra,80004b38 <z_impl_k_thread_abort>
80000ac4:	fd1ff06f          	j	80000a94 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000ac8:	800065b7          	lui	a1,0x80006
80000acc:	af858593          	addi	a1,a1,-1288 # 80005af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af9>
80000ad0:	fb9ff06f          	j	80000a88 <z_SysFatalErrorHandler+0x2c>

80000ad4 <z_NanoFatalErrorHandler>:
{
80000ad4:	fb010113          	addi	sp,sp,-80
80000ad8:	04812423          	sw	s0,72(sp)
80000adc:	04912223          	sw	s1,68(sp)
80000ae0:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000ae4:	00600793          	li	a5,6
{
80000ae8:	00050493          	mv	s1,a0
80000aec:	00058413          	mv	s0,a1
	switch (reason) {
80000af0:	0ea7e063          	bltu	a5,a0,80000bd0 <z_NanoFatalErrorHandler+0xfc>
80000af4:	80006737          	lui	a4,0x80006
80000af8:	00251793          	slli	a5,a0,0x2
80000afc:	84c70713          	addi	a4,a4,-1972 # 8000584c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000584d>
80000b00:	00e787b3          	add	a5,a5,a4
80000b04:	0007a783          	lw	a5,0(a5)
80000b08:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000b0c:	80006537          	lui	a0,0x80006
80000b10:	97c50513          	addi	a0,a0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
		printk("***** Kernel OOPS! *****\n");
80000b14:	5c5000ef          	jal	ra,800018d8 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000b18:	694030ef          	jal	ra,800041ac <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000b1c:	04442783          	lw	a5,68(s0)
80000b20:	01042883          	lw	a7,16(s0)
80000b24:	00c42803          	lw	a6,12(s0)
80000b28:	02f12823          	sw	a5,48(sp)
80000b2c:	04042783          	lw	a5,64(s0)
80000b30:	00442703          	lw	a4,4(s0)
80000b34:	00042683          	lw	a3,0(s0)
80000b38:	02f12623          	sw	a5,44(sp)
80000b3c:	03c42783          	lw	a5,60(s0)
80000b40:	04842603          	lw	a2,72(s0)
80000b44:	00050593          	mv	a1,a0
80000b48:	02f12423          	sw	a5,40(sp)
80000b4c:	03842783          	lw	a5,56(s0)
80000b50:	80006537          	lui	a0,0x80006
80000b54:	a0050513          	addi	a0,a0,-1536 # 80005a00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a01>
80000b58:	02f12223          	sw	a5,36(sp)
80000b5c:	03442783          	lw	a5,52(s0)
80000b60:	02f12023          	sw	a5,32(sp)
80000b64:	03042783          	lw	a5,48(s0)
80000b68:	00f12e23          	sw	a5,28(sp)
80000b6c:	02c42783          	lw	a5,44(s0)
80000b70:	00f12c23          	sw	a5,24(sp)
80000b74:	02842783          	lw	a5,40(s0)
80000b78:	00f12a23          	sw	a5,20(sp)
80000b7c:	02442783          	lw	a5,36(s0)
80000b80:	00f12823          	sw	a5,16(sp)
80000b84:	02042783          	lw	a5,32(s0)
80000b88:	00f12623          	sw	a5,12(sp)
80000b8c:	01c42783          	lw	a5,28(s0)
80000b90:	00f12423          	sw	a5,8(sp)
80000b94:	01842783          	lw	a5,24(s0)
80000b98:	00f12223          	sw	a5,4(sp)
80000b9c:	01442783          	lw	a5,20(s0)
80000ba0:	00f12023          	sw	a5,0(sp)
80000ba4:	00842783          	lw	a5,8(s0)
80000ba8:	531000ef          	jal	ra,800018d8 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000bac:	00040593          	mv	a1,s0
80000bb0:	00048513          	mv	a0,s1
80000bb4:	ea9ff0ef          	jal	ra,80000a5c <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000bb8:	80006537          	lui	a0,0x80006
80000bbc:	9a450513          	addi	a0,a0,-1628 # 800059a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059a5>
80000bc0:	f55ff06f          	j	80000b14 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000bc4:	80006537          	lui	a0,0x80006
80000bc8:	9c050513          	addi	a0,a0,-1600 # 800059c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c1>
80000bcc:	f49ff06f          	j	80000b14 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000bd0:	80006537          	lui	a0,0x80006
80000bd4:	00048593          	mv	a1,s1
80000bd8:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80000bdc:	4fd000ef          	jal	ra,800018d8 <printk>
		break;
80000be0:	f39ff06f          	j	80000b18 <z_NanoFatalErrorHandler+0x44>

80000be4 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000be4:	ff010113          	addi	sp,sp,-16
80000be8:	00812423          	sw	s0,8(sp)
80000bec:	00112623          	sw	ra,12(sp)
80000bf0:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000bf4:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000bf8:	00161613          	slli	a2,a2,0x1
80000bfc:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000c00:	00500793          	li	a5,5
80000c04:	02c7e863          	bltu	a5,a2,80000c34 <_Fault+0x50>
80000c08:	80006737          	lui	a4,0x80006
80000c0c:	00261793          	slli	a5,a2,0x2
80000c10:	86870713          	addi	a4,a4,-1944 # 80005868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005869>
80000c14:	00f707b3          	add	a5,a4,a5
80000c18:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000c1c:	80006537          	lui	a0,0x80006
80000c20:	88850513          	addi	a0,a0,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
80000c24:	4b5000ef          	jal	ra,800018d8 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000c28:	00040593          	mv	a1,s0
80000c2c:	00000513          	li	a0,0
80000c30:	ea5ff0ef          	jal	ra,80000ad4 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000c34:	800065b7          	lui	a1,0x80006
80000c38:	88058593          	addi	a1,a1,-1920 # 80005880 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005881>
80000c3c:	fe1ff06f          	j	80000c1c <_Fault+0x38>

80000c40 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000c40:	ff010113          	addi	sp,sp,-16
80000c44:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000c48:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000c4c:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80000c50:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000c54:	0015d593          	srli	a1,a1,0x1
80000c58:	b5850513          	addi	a0,a0,-1192 # 80005b58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b59>
80000c5c:	47d000ef          	jal	ra,800018d8 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000c60:	800065b7          	lui	a1,0x80006
80000c64:	8a458593          	addi	a1,a1,-1884 # 800058a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a5>
80000c68:	00400513          	li	a0,4
80000c6c:	e69ff0ef          	jal	ra,80000ad4 <z_NanoFatalErrorHandler>

80000c70 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000c70:	800067b7          	lui	a5,0x80006
80000c74:	35c78793          	addi	a5,a5,860 # 8000635c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000635d>
80000c78:	0007a703          	lw	a4,0(a5)
80000c7c:	00070c63          	beqz	a4,80000c94 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80000c80:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000c84:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000c88:	800067b7          	lui	a5,0x80006
80000c8c:	3607a503          	lw	a0,864(a5) # 80006360 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006361>
80000c90:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80000c94:	00008067          	ret

80000c98 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000c98:	ff010113          	addi	sp,sp,-16
80000c9c:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80000ca0:	784010ef          	jal	ra,80002424 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000ca4:	4c5000ef          	jal	ra,80001968 <soc_interrupt_init>
#endif
	z_cstart();
80000ca8:	7e8010ef          	jal	ra,80002490 <z_cstart>

80000cac <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000cac:	00006117          	auipc	sp,0x6
80000cb0:	3c410113          	addi	sp,sp,964 # 80007070 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80000cb4:	000012b7          	lui	t0,0x1
80000cb8:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000cbc:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000cc0:	fd9ff0ef          	jal	ra,80000c98 <_PrepC>

80000cc4 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000cc4:	5c00006f          	j	80001284 <z_thread_entry>

80000cc8 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000cc8:	fd010113          	addi	sp,sp,-48
80000ccc:	02812423          	sw	s0,40(sp)
80000cd0:	02912223          	sw	s1,36(sp)
80000cd4:	03212023          	sw	s2,32(sp)
80000cd8:	01312e23          	sw	s3,28(sp)
80000cdc:	01412c23          	sw	s4,24(sp)
80000ce0:	01512a23          	sw	s5,20(sp)
80000ce4:	01612823          	sw	s6,16(sp)
80000ce8:	01712623          	sw	s7,12(sp)
80000cec:	00078b13          	mv	s6,a5
80000cf0:	02112623          	sw	ra,44(sp)
80000cf4:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000cf8:	00f00793          	li	a5,15
{
80000cfc:	00050493          	mv	s1,a0
80000d00:	00058413          	mv	s0,a1
80000d04:	00060993          	mv	s3,a2
80000d08:	00068a13          	mv	s4,a3
80000d0c:	00070b93          	mv	s7,a4
80000d10:	00080a93          	mv	s5,a6
80000d14:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000d18:	08f89a63          	bne	a7,a5,80000dac <z_new_thread+0xe4>
80000d1c:	800027b7          	lui	a5,0x80002
80000d20:	3ec78793          	addi	a5,a5,1004 # 800023ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800023ed>
80000d24:	08f69a63          	bne	a3,a5,80000db8 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000d28:	03012683          	lw	a3,48(sp)
80000d2c:	00090593          	mv	a1,s2
80000d30:	00048513          	mv	a0,s1
80000d34:	00400613          	li	a2,4
80000d38:	27d030ef          	jal	ra,800047b4 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000d3c:	fb098593          	addi	a1,s3,-80
80000d40:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000d44:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000d48:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000d4c:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000d50:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000d54:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000d58:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000d5c:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000d60:	02c12083          	lw	ra,44(sp)
80000d64:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000d68:	cc478793          	addi	a5,a5,-828 # 80000cc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000cc5>
	stack_init->a0 = (u32_t)thread_func;
80000d6c:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000d70:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000d74:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000d78:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000d7c:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000d80:	02b4a423          	sw	a1,40(s1)
}
80000d84:	02012903          	lw	s2,32(sp)
80000d88:	02412483          	lw	s1,36(sp)
80000d8c:	01c12983          	lw	s3,28(sp)
80000d90:	01812a03          	lw	s4,24(sp)
80000d94:	01412a83          	lw	s5,20(sp)
80000d98:	01012b03          	lw	s6,16(sp)
80000d9c:	00c12b83          	lw	s7,12(sp)
80000da0:	00812c03          	lw	s8,8(sp)
80000da4:	03010113          	addi	sp,sp,48
80000da8:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000dac:	01088693          	addi	a3,a7,16
80000db0:	01e00793          	li	a5,30
80000db4:	f6d7fae3          	bgeu	a5,a3,80000d28 <z_new_thread+0x60>
80000db8:	80006c37          	lui	s8,0x80006
80000dbc:	800065b7          	lui	a1,0x80006
80000dc0:	80006537          	lui	a0,0x80006
80000dc4:	b80c0613          	addi	a2,s8,-1152 # 80005b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b81>
80000dc8:	01800693          	li	a3,24
80000dcc:	ba058593          	addi	a1,a1,-1120 # 80005ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ba1>
80000dd0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80000dd4:	305000ef          	jal	ra,800018d8 <printk>
80000dd8:	80006537          	lui	a0,0x80006
80000ddc:	00090593          	mv	a1,s2
80000de0:	ff000693          	li	a3,-16
80000de4:	00e00613          	li	a2,14
80000de8:	c4c50513          	addi	a0,a0,-948 # 80005c4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c4d>
80000dec:	2ed000ef          	jal	ra,800018d8 <printk>
80000df0:	01800593          	li	a1,24
80000df4:	b80c0513          	addi	a0,s8,-1152
80000df8:	31d000ef          	jal	ra,80001914 <assert_post_action>
80000dfc:	f2dff06f          	j	80000d28 <z_new_thread+0x60>

80000e00 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000e00:	00c00793          	li	a5,12
80000e04:	02f58733          	mul	a4,a1,a5
80000e08:	00c52783          	lw	a5,12(a0)
80000e0c:	00e787b3          	add	a5,a5,a4
80000e10:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000e14:	00b75463          	bge	a4,a1,80000e1c <get_bit_ptr+0x1c>
80000e18:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000e1c:	02000713          	li	a4,32
80000e20:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
80000e24:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
80000e28:	00271713          	slli	a4,a4,0x2
80000e2c:	00e787b3          	add	a5,a5,a4
80000e30:	00f6a023          	sw	a5,0(a3)
}
80000e34:	00008067          	ret

80000e38 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000e38:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000e3c:	00c10693          	addi	a3,sp,12
{
80000e40:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000e44:	fbdff0ef          	jal	ra,80000e00 <get_bit_ptr>

	*word |= (1<<bit);
80000e48:	00c12703          	lw	a4,12(sp)
80000e4c:	00100793          	li	a5,1
80000e50:	00a79533          	sll	a0,a5,a0
80000e54:	00072783          	lw	a5,0(a4)
}
80000e58:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80000e5c:	00a7e7b3          	or	a5,a5,a0
80000e60:	00f72023          	sw	a5,0(a4)
}
80000e64:	02010113          	addi	sp,sp,32
80000e68:	00008067          	ret

80000e6c <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000e6c:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000e70:	00c10693          	addi	a3,sp,12
{
80000e74:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000e78:	f89ff0ef          	jal	ra,80000e00 <get_bit_ptr>

	*word &= ~(1<<bit);
80000e7c:	00c12703          	lw	a4,12(sp)
80000e80:	00100793          	li	a5,1
80000e84:	00a79533          	sll	a0,a5,a0
80000e88:	00072783          	lw	a5,0(a4)
}
80000e8c:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80000e90:	fff54513          	not	a0,a0
80000e94:	00a7f533          	and	a0,a5,a0
80000e98:	00a72023          	sw	a0,0(a4)
}
80000e9c:	02010113          	addi	sp,sp,32
80000ea0:	00008067          	ret

80000ea4 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000ea4:	00452783          	lw	a5,4(a0)
80000ea8:	00855803          	lhu	a6,8(a0)
{
80000eac:	ff010113          	addi	sp,sp,-16
80000eb0:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000eb4:	02f80833          	mul	a6,a6,a5
{
80000eb8:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000ebc:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80000ec0:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80000ec4:	fff00713          	li	a4,-1
{
80000ec8:	00112623          	sw	ra,12(sp)
80000ecc:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
80000ed0:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80000ed4:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
80000ed8:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000edc:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
80000ee0:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80000ee4:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
80000ee8:	0315c263          	blt	a1,a7,80000f0c <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80000eec:	00000493          	li	s1,0
80000ef0:	00845783          	lhu	a5,8(s0)
80000ef4:	06f4c463          	blt	s1,a5,80000f5c <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80000ef8:	00c12083          	lw	ra,12(sp)
80000efc:	00812403          	lw	s0,8(sp)
80000f00:	00412483          	lw	s1,4(sp)
80000f04:	01010113          	addi	sp,sp,16
80000f08:	00008067          	ret
		int nblocks = buflen / sz;
80000f0c:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
80000f10:	00c42603          	lw	a2,12(s0)
80000f14:	026586b3          	mul	a3,a1,t1
80000f18:	00d606b3          	add	a3,a2,a3
80000f1c:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80000f20:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
80000f24:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
80000f28:	00ee4e63          	blt	t3,a4,80000f44 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
80000f2c:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
80000f30:	0027d793          	srli	a5,a5,0x2
80000f34:	00378793          	addi	a5,a5,3
80000f38:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
80000f3c:	00158593          	addi	a1,a1,1
80000f40:	fa9ff06f          	j	80000ee8 <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
80000f44:	01f70713          	addi	a4,a4,31
80000f48:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80000f4c:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
80000f50:	00271713          	slli	a4,a4,0x2
80000f54:	00e50533          	add	a0,a0,a4
80000f58:	fd9ff06f          	j	80000f30 <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80000f5c:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
80000f60:	00048613          	mv	a2,s1
80000f64:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80000f68:	02f48733          	mul	a4,s1,a5
80000f6c:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80000f70:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
80000f74:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
80000f78:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
80000f7c:	00c42703          	lw	a4,12(s0)
80000f80:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80000f84:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
80000f88:	00872683          	lw	a3,8(a4)
80000f8c:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
80000f90:	00872683          	lw	a3,8(a4)
80000f94:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
80000f98:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
80000f9c:	e9dff0ef          	jal	ra,80000e38 <set_free_bit>
80000fa0:	f51ff06f          	j	80000ef0 <z_sys_mem_pool_base_init+0x4c>

80000fa4 <z_sys_mem_pool_block_free>:
	return 0;
}

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80000fa4:	fa010113          	addi	sp,sp,-96
80000fa8:	04812c23          	sw	s0,88(sp)
80000fac:	05312623          	sw	s3,76(sp)
80000fb0:	03712e23          	sw	s7,60(sp)
80000fb4:	04112e23          	sw	ra,92(sp)
80000fb8:	04912a23          	sw	s1,84(sp)
80000fbc:	05212823          	sw	s2,80(sp)
80000fc0:	05412423          	sw	s4,72(sp)
80000fc4:	05512223          	sw	s5,68(sp)
80000fc8:	05612023          	sw	s6,64(sp)
80000fcc:	03812c23          	sw	s8,56(sp)
80000fd0:	03912a23          	sw	s9,52(sp)
80000fd4:	03a12823          	sw	s10,48(sp)
80000fd8:	03b12623          	sw	s11,44(sp)
80000fdc:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000fe0:	00a54683          	lbu	a3,10(a0)
{
80000fe4:	00050b93          	mv	s7,a0
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 1; i <= level; i++) {
80000fe8:	00100813          	li	a6,1
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000fec:	00269693          	slli	a3,a3,0x2
80000ff0:	00f68693          	addi	a3,a3,15
80000ff4:	7f06f693          	andi	a3,a3,2032
80000ff8:	40d10133          	sub	sp,sp,a3
	lsizes[0] = _ALIGN4(p->max_sz);
80000ffc:	00452683          	lw	a3,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001000:	00010993          	mv	s3,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001004:	00098513          	mv	a0,s3
80001008:	00368693          	addi	a3,a3,3
8000100c:	ffc6f693          	andi	a3,a3,-4
80001010:	00d9a023          	sw	a3,0(s3)
	for (i = 1; i <= level; i++) {
80001014:	00450513          	addi	a0,a0,4
80001018:	0d05f463          	bgeu	a1,a6,800010e0 <z_sys_mem_pool_block_free+0x13c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000101c:	010bc683          	lbu	a3,16(s7)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001020:	00058c13          	mv	s8,a1
80001024:	00060913          	mv	s2,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001028:	0016f693          	andi	a3,a3,1
		return 0;
8000102c:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001030:	00068863          	beqz	a3,80001040 <z_sys_mem_pool_block_free+0x9c>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80001034:	00800493          	li	s1,8
80001038:	3004b4f3          	csrrc	s1,mstatus,s1
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
8000103c:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80001040:	80006ab7          	lui	s5,0x80006
		sys_dlist_append(&p->levels[level].free_list, block);
80001044:	00c00d13          	li	s10,12
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001048:	00800d93          	li	s11,8
	while (level >= 0) {
8000104c:	0a0c5863          	bgez	s8,800010fc <z_sys_mem_pool_block_free+0x158>
	__ASSERT(0, "out of levels");
80001050:	800064b7          	lui	s1,0x80006
80001054:	800065b7          	lui	a1,0x80006
80001058:	80006537          	lui	a0,0x80006
8000105c:	c8048613          	addi	a2,s1,-896 # 80005c80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c81>
80001060:	0c000693          	li	a3,192
80001064:	ce858593          	addi	a1,a1,-792 # 80005ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ce9>
80001068:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000106c:	06d000ef          	jal	ra,800018d8 <printk>
80001070:	80006537          	lui	a0,0x80006
80001074:	cb450513          	addi	a0,a0,-844 # 80005cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb5>
80001078:	061000ef          	jal	ra,800018d8 <printk>
8000107c:	c8048513          	addi	a0,s1,-896
80001080:	0c000593          	li	a1,192
80001084:	091000ef          	jal	ra,80001914 <assert_post_action>
	return -1;
80001088:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000108c:	010bc783          	lbu	a5,16(s7)
80001090:	0017f793          	andi	a5,a5,1
80001094:	00078663          	beqz	a5,800010a0 <z_sys_mem_pool_block_free+0xfc>
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001098:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000109c:	3004a4f3          	csrrs	s1,mstatus,s1
}
800010a0:	fa040113          	addi	sp,s0,-96
800010a4:	05c12083          	lw	ra,92(sp)
800010a8:	05812403          	lw	s0,88(sp)
800010ac:	05412483          	lw	s1,84(sp)
800010b0:	05012903          	lw	s2,80(sp)
800010b4:	04c12983          	lw	s3,76(sp)
800010b8:	04812a03          	lw	s4,72(sp)
800010bc:	04412a83          	lw	s5,68(sp)
800010c0:	04012b03          	lw	s6,64(sp)
800010c4:	03c12b83          	lw	s7,60(sp)
800010c8:	03812c03          	lw	s8,56(sp)
800010cc:	03412c83          	lw	s9,52(sp)
800010d0:	03012d03          	lw	s10,48(sp)
800010d4:	02c12d83          	lw	s11,44(sp)
800010d8:	06010113          	addi	sp,sp,96
800010dc:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800010e0:	ffc52683          	lw	a3,-4(a0)
	for (i = 1; i <= level; i++) {
800010e4:	00180813          	addi	a6,a6,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800010e8:	0026d693          	srli	a3,a3,0x2
800010ec:	00368693          	addi	a3,a3,3
800010f0:	ffc6f693          	andi	a3,a3,-4
800010f4:	00d52023          	sw	a3,0(a0)
800010f8:	f1dff06f          	j	80001014 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
800010fc:	002c1693          	slli	a3,s8,0x2
80001100:	00d986b3          	add	a3,s3,a3
80001104:	0006aa03          	lw	s4,0(a3)
	return p->n_max * p->max_sz;
80001108:	008bd603          	lhu	a2,8(s7)
8000110c:	004ba583          	lw	a1,4(s7)
	return (u8_t *)p->buf + lsz * block;
80001110:	034906b3          	mul	a3,s2,s4
		void *block = block_ptr(p, lsz, bn);
80001114:	000ba803          	lw	a6,0(s7)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001118:	fffa0b13          	addi	s6,s4,-1
	return p->n_max * p->max_sz;
8000111c:	02b60633          	mul	a2,a2,a1
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001120:	00d80cb3          	add	s9,a6,a3
80001124:	00db06b3          	add	a3,s6,a3
		__ASSERT(block_fits(p, block, lsz), "");
80001128:	02c6ec63          	bltu	a3,a2,80001160 <z_sys_mem_pool_block_free+0x1bc>
8000112c:	800067b7          	lui	a5,0x80006
80001130:	c9478593          	addi	a1,a5,-876 # 80005c94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c95>
80001134:	800067b7          	lui	a5,0x80006
80001138:	c2c78513          	addi	a0,a5,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000113c:	0a400693          	li	a3,164
80001140:	c80a8613          	addi	a2,s5,-896 # 80005c80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c81>
80001144:	794000ef          	jal	ra,800018d8 <printk>
80001148:	800067b7          	lui	a5,0x80006
8000114c:	cb078513          	addi	a0,a5,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
80001150:	788000ef          	jal	ra,800018d8 <printk>
80001154:	0a400593          	li	a1,164
80001158:	c80a8513          	addi	a0,s5,-896
8000115c:	7b8000ef          	jal	ra,80001914 <assert_post_action>
		set_free_bit(p, level, bn);
80001160:	00090613          	mv	a2,s2
80001164:	000c0593          	mv	a1,s8
80001168:	000b8513          	mv	a0,s7
8000116c:	ccdff0ef          	jal	ra,80000e38 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80001170:	03ac06b3          	mul	a3,s8,s10
80001174:	00cba603          	lw	a2,12(s7)
80001178:	00d606b3          	add	a3,a2,a3
8000117c:	00468613          	addi	a2,a3,4
	node->next = list;
80001180:	00cca023          	sw	a2,0(s9)
	node->prev = list->tail;
80001184:	0086a603          	lw	a2,8(a3)
80001188:	00cca223          	sw	a2,4(s9)
	list->tail->next = node;
8000118c:	0086a603          	lw	a2,8(a3)
80001190:	01962023          	sw	s9,0(a2)
	list->tail = node;
80001194:	0196a423          	sw	s9,8(a3)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001198:	010bc683          	lbu	a3,16(s7)
8000119c:	0016f693          	andi	a3,a3,1
800011a0:	0c069463          	bnez	a3,80001268 <z_sys_mem_pool_block_free+0x2c4>
		return 0;
800011a4:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800011a8:	ee0c02e3          	beqz	s8,8000108c <z_sys_mem_pool_block_free+0xe8>
	int bit = get_bit_ptr(p, level, bn, &word);
800011ac:	fbc40693          	addi	a3,s0,-68
800011b0:	00090613          	mv	a2,s2
800011b4:	000c0593          	mv	a1,s8
800011b8:	000b8513          	mv	a0,s7
800011bc:	c45ff0ef          	jal	ra,80000e00 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
800011c0:	00400693          	li	a3,4
800011c4:	02d546b3          	div	a3,a0,a3
800011c8:	fbc42603          	lw	a2,-68(s0)
800011cc:	00062503          	lw	a0,0(a2)
800011d0:	00269693          	slli	a3,a3,0x2
800011d4:	00d55533          	srl	a0,a0,a3
800011d8:	00f57513          	andi	a0,a0,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800011dc:	00f00693          	li	a3,15
800011e0:	ead516e3          	bne	a0,a3,8000108c <z_sys_mem_pool_block_free+0xe8>
		for (i = 0; i < 4; i++) {
800011e4:	00000813          	li	a6,0
			int b = (bn & ~3) + i;
800011e8:	ffc97e13          	andi	t3,s2,-4
		for (i = 0; i < 4; i++) {
800011ec:	00400313          	li	t1,4
	return p->n_max * p->max_sz;
800011f0:	008bd583          	lhu	a1,8(s7)
800011f4:	004ba503          	lw	a0,4(s7)
			int b = (bn & ~3) + i;
800011f8:	010e0633          	add	a2,t3,a6
	return (u8_t *)p->buf + lsz * block;
800011fc:	034608b3          	mul	a7,a2,s4
	return p->n_max * p->max_sz;
80001200:	02a585b3          	mul	a1,a1,a0
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001204:	016886b3          	add	a3,a7,s6
80001208:	04b6f663          	bgeu	a3,a1,80001254 <z_sys_mem_pool_block_free+0x2b0>
				clear_free_bit(p, level, b);
8000120c:	000c0593          	mv	a1,s8
80001210:	000b8513          	mv	a0,s7
80001214:	fbc42223          	sw	t3,-92(s0)
80001218:	fb042423          	sw	a6,-88(s0)
8000121c:	fb142623          	sw	a7,-84(s0)
80001220:	c4dff0ef          	jal	ra,80000e6c <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001224:	000ba683          	lw	a3,0(s7)
80001228:	fac42883          	lw	a7,-84(s0)
	node->prev = NULL;
8000122c:	fa442e03          	lw	t3,-92(s0)
80001230:	fa842803          	lw	a6,-88(s0)
80001234:	011686b3          	add	a3,a3,a7
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80001238:	0046a583          	lw	a1,4(a3)
8000123c:	0006a603          	lw	a2,0(a3)
	node->prev = NULL;
80001240:	00400313          	li	t1,4
	node->prev->next = node->next;
80001244:	00c5a023          	sw	a2,0(a1)
	node->next->prev = node->prev;
80001248:	00b62223          	sw	a1,4(a2)
	node->next = NULL;
8000124c:	0006a023          	sw	zero,0(a3)
	node->prev = NULL;
80001250:	0006a223          	sw	zero,4(a3)
		for (i = 0; i < 4; i++) {
80001254:	00180813          	addi	a6,a6,1
80001258:	f8681ce3          	bne	a6,t1,800011f0 <z_sys_mem_pool_block_free+0x24c>
		level = level - 1;
8000125c:	fffc0c13          	addi	s8,s8,-1
		bn = bn / 4;
80001260:	03094933          	div	s2,s2,a6
80001264:	de9ff06f          	j	8000104c <z_sys_mem_pool_block_free+0xa8>
80001268:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000126c:	010bc683          	lbu	a3,16(s7)
80001270:	0016f693          	andi	a3,a3,1
80001274:	f20688e3          	beqz	a3,800011a4 <z_sys_mem_pool_block_free+0x200>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001278:	300db4f3          	csrrc	s1,mstatus,s11
	key = (mstatus & SOC_MSTATUS_IEN);
8000127c:	0084f493          	andi	s1,s1,8
80001280:	f29ff06f          	j	800011a8 <z_sys_mem_pool_block_free+0x204>

80001284 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001284:	ff010113          	addi	sp,sp,-16
80001288:	00050793          	mv	a5,a0
8000128c:	00058513          	mv	a0,a1
80001290:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001294:	00068613          	mv	a2,a3
{
80001298:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
8000129c:	000780e7          	jalr	a5
800012a0:	70d020ef          	jal	ra,800041ac <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800012a4:	095030ef          	jal	ra,80004b38 <z_impl_k_thread_abort>

800012a8 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
800012a8:	00000513          	li	a0,0
800012ac:	00008067          	ret

800012b0 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
800012b0:	ff010113          	addi	sp,sp,-16
800012b4:	00812423          	sw	s0,8(sp)
800012b8:	00050413          	mv	s0,a0
	out('E', ctx);
800012bc:	04500513          	li	a0,69
{
800012c0:	00112623          	sw	ra,12(sp)
800012c4:	00912223          	sw	s1,4(sp)
800012c8:	00058493          	mv	s1,a1
	out('E', ctx);
800012cc:	000400e7          	jalr	s0
	out('R', ctx);
800012d0:	00048593          	mv	a1,s1
800012d4:	05200513          	li	a0,82
800012d8:	000400e7          	jalr	s0
	out('R', ctx);
800012dc:	00040313          	mv	t1,s0
}
800012e0:	00812403          	lw	s0,8(sp)
800012e4:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
800012e8:	00048593          	mv	a1,s1
}
800012ec:	00412483          	lw	s1,4(sp)
	out('R', ctx);
800012f0:	05200513          	li	a0,82
}
800012f4:	01010113          	addi	sp,sp,16
	out('R', ctx);
800012f8:	00030067          	jr	t1

800012fc <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800012fc:	0005a783          	lw	a5,0(a1)
80001300:	00178793          	addi	a5,a5,1
80001304:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001308:	800067b7          	lui	a5,0x80006
8000130c:	2807a303          	lw	t1,640(a5) # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
80001310:	00030067          	jr	t1

80001314 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001314:	fb010113          	addi	sp,sp,-80
80001318:	04812423          	sw	s0,72(sp)
8000131c:	03312e23          	sw	s3,60(sp)
80001320:	03412c23          	sw	s4,56(sp)
80001324:	03512a23          	sw	s5,52(sp)
80001328:	03612823          	sw	s6,48(sp)
8000132c:	04112623          	sw	ra,76(sp)
80001330:	04912223          	sw	s1,68(sp)
80001334:	05212023          	sw	s2,64(sp)
80001338:	03712623          	sw	s7,44(sp)
8000133c:	03812423          	sw	s8,40(sp)
80001340:	03912223          	sw	s9,36(sp)
80001344:	03a12023          	sw	s10,32(sp)
80001348:	01b12e23          	sw	s11,28(sp)
8000134c:	00050a13          	mv	s4,a0
80001350:	00058a93          	mv	s5,a1
80001354:	00060993          	mv	s3,a2
80001358:	00068b13          	mv	s6,a3
8000135c:	00100413          	li	s0,1
80001360:	00e05463          	blez	a4,80001368 <_printk_dec_ulong+0x54>
80001364:	00070413          	mv	s0,a4
80001368:	00100793          	li	a5,1
8000136c:	02000c13          	li	s8,32
80001370:	00fb1463          	bne	s6,a5,80001378 <_printk_dec_ulong+0x64>
80001374:	03000c13          	li	s8,48
80001378:	3b9ad4b7          	lui	s1,0x3b9ad
8000137c:	00100913          	li	s2,1
80001380:	00a00c93          	li	s9,10
80001384:	00000713          	li	a4,0
80001388:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
8000138c:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
80001390:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
80001394:	00148b93          	addi	s7,s1,1
80001398:	00071463          	bnez	a4,800013a0 <_printk_dec_ulong+0x8c>
8000139c:	0934f263          	bgeu	s1,s3,80001420 <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
800013a0:	0379d533          	divu	a0,s3,s7
800013a4:	000a8593          	mv	a1,s5
			digits++;
800013a8:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
800013ac:	03050513          	addi	a0,a0,48
800013b0:	000a00e7          	jalr	s4
			found_largest_digit = 1;
800013b4:	00100713          	li	a4,1
		remaining--;
800013b8:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
800013bc:	00100793          	li	a5,1
		remainder %= (pos + 1);
800013c0:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
800013c4:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
800013c8:	fcfc96e3          	bne	s9,a5,80001394 <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
800013cc:	000a8593          	mv	a1,s5
800013d0:	03098513          	addi	a0,s3,48
800013d4:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
800013d8:	00300793          	li	a5,3
		remaining = min_width - digits;
800013dc:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
800013e0:	06fb0a63          	beq	s6,a5,80001454 <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
800013e4:	04c12083          	lw	ra,76(sp)
800013e8:	04812403          	lw	s0,72(sp)
800013ec:	04412483          	lw	s1,68(sp)
800013f0:	04012903          	lw	s2,64(sp)
800013f4:	03c12983          	lw	s3,60(sp)
800013f8:	03812a03          	lw	s4,56(sp)
800013fc:	03412a83          	lw	s5,52(sp)
80001400:	03012b03          	lw	s6,48(sp)
80001404:	02c12b83          	lw	s7,44(sp)
80001408:	02812c03          	lw	s8,40(sp)
8000140c:	02412c83          	lw	s9,36(sp)
80001410:	02012d03          	lw	s10,32(sp)
80001414:	01c12d83          	lw	s11,28(sp)
80001418:	05010113          	addi	sp,sp,80
8000141c:	00008067          	ret
		} else if (remaining <= min_width
80001420:	f9944ce3          	blt	s0,s9,800013b8 <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
80001424:	f96deae3          	bltu	s11,s6,800013b8 <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001428:	000a8593          	mv	a1,s5
8000142c:	000c0513          	mv	a0,s8
80001430:	00e12623          	sw	a4,12(sp)
80001434:	000a00e7          	jalr	s4
			digits++;
80001438:	00190913          	addi	s2,s2,1
8000143c:	00c12703          	lw	a4,12(sp)
80001440:	f79ff06f          	j	800013b8 <_printk_dec_ulong+0xa4>
			out(' ', ctx);
80001444:	000a8593          	mv	a1,s5
80001448:	02000513          	li	a0,32
8000144c:	000a00e7          	jalr	s4
80001450:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80001454:	fe8048e3          	bgtz	s0,80001444 <_printk_dec_ulong+0x130>
80001458:	f8dff06f          	j	800013e4 <_printk_dec_ulong+0xd0>

8000145c <__printk_hook_install>:
	_char_out = fn;
8000145c:	800067b7          	lui	a5,0x80006
80001460:	28a7a023          	sw	a0,640(a5) # 80006280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006281>
}
80001464:	00008067          	ret

80001468 <z_vprintk>:
{
80001468:	fb010113          	addi	sp,sp,-80
8000146c:	04812423          	sw	s0,72(sp)
80001470:	04912223          	sw	s1,68(sp)
80001474:	05212023          	sw	s2,64(sp)
80001478:	03312e23          	sw	s3,60(sp)
8000147c:	03412c23          	sw	s4,56(sp)
80001480:	03512a23          	sw	s5,52(sp)
80001484:	03912223          	sw	s9,36(sp)
80001488:	03a12023          	sw	s10,32(sp)
8000148c:	01b12e23          	sw	s11,28(sp)
80001490:	04112623          	sw	ra,76(sp)
80001494:	03612823          	sw	s6,48(sp)
80001498:	03712623          	sw	s7,44(sp)
8000149c:	03812423          	sw	s8,40(sp)
800014a0:	00050413          	mv	s0,a0
800014a4:	00058493          	mv	s1,a1
800014a8:	00060a93          	mv	s5,a2
800014ac:	00068d13          	mv	s10,a3
	int long_ctr = 0;
800014b0:	00000a13          	li	s4,0
	int min_width = -1;
800014b4:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
800014b8:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800014bc:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
800014c0:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800014c4:	000ac503          	lbu	a0,0(s5)
800014c8:	04051063          	bnez	a0,80001508 <z_vprintk+0xa0>
}
800014cc:	04c12083          	lw	ra,76(sp)
800014d0:	04812403          	lw	s0,72(sp)
800014d4:	04412483          	lw	s1,68(sp)
800014d8:	04012903          	lw	s2,64(sp)
800014dc:	03c12983          	lw	s3,60(sp)
800014e0:	03812a03          	lw	s4,56(sp)
800014e4:	03412a83          	lw	s5,52(sp)
800014e8:	03012b03          	lw	s6,48(sp)
800014ec:	02c12b83          	lw	s7,44(sp)
800014f0:	02812c03          	lw	s8,40(sp)
800014f4:	02412c83          	lw	s9,36(sp)
800014f8:	02012d03          	lw	s10,32(sp)
800014fc:	01c12d83          	lw	s11,28(sp)
80001500:	05010113          	addi	sp,sp,80
80001504:	00008067          	ret
		if (!might_format) {
80001508:	000c9e63          	bnez	s9,80001524 <z_vprintk+0xbc>
			if (*fmt != '%') {
8000150c:	02500693          	li	a3,37
80001510:	36d50a63          	beq	a0,a3,80001884 <z_vprintk+0x41c>
				out((int)*fmt, ctx);
80001514:	00048593          	mv	a1,s1
80001518:	000400e7          	jalr	s0
		++fmt;
8000151c:	001a8a93          	addi	s5,s5,1
80001520:	fa5ff06f          	j	800014c4 <z_vprintk+0x5c>
			switch (*fmt) {
80001524:	06400693          	li	a3,100
80001528:	10d50e63          	beq	a0,a3,80001644 <z_vprintk+0x1dc>
8000152c:	06a6e263          	bltu	a3,a0,80001590 <z_vprintk+0x128>
80001530:	03900693          	li	a3,57
80001534:	02a6ea63          	bltu	a3,a0,80001568 <z_vprintk+0x100>
80001538:	03100693          	li	a3,49
8000153c:	0ed57463          	bgeu	a0,a3,80001624 <z_vprintk+0x1bc>
80001540:	02d00693          	li	a3,45
80001544:	34d50a63          	beq	a0,a3,80001898 <z_vprintk+0x430>
80001548:	03000793          	li	a5,48
8000154c:	0cf50063          	beq	a0,a5,8000160c <z_vprintk+0x1a4>
80001550:	02500713          	li	a4,37
80001554:	02e51263          	bne	a0,a4,80001578 <z_vprintk+0x110>
				out((int)'%', ctx);
80001558:	00048593          	mv	a1,s1
8000155c:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001560:	000400e7          	jalr	s0
				break;
80001564:	15c0006f          	j	800016c0 <z_vprintk+0x258>
80001568:	05800693          	li	a3,88
8000156c:	1ad50e63          	beq	a0,a3,80001728 <z_vprintk+0x2c0>
80001570:	06300713          	li	a4,99
80001574:	2ee50e63          	beq	a0,a4,80001870 <z_vprintk+0x408>
				out((int)'%', ctx);
80001578:	00048593          	mv	a1,s1
8000157c:	02500513          	li	a0,37
80001580:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001584:	00048593          	mv	a1,s1
80001588:	000ac503          	lbu	a0,0(s5)
8000158c:	fd5ff06f          	j	80001560 <z_vprintk+0xf8>
80001590:	07000693          	li	a3,112
80001594:	16d50a63          	beq	a0,a3,80001708 <z_vprintk+0x2a0>
80001598:	02a6e063          	bltu	a3,a0,800015b8 <z_vprintk+0x150>
8000159c:	06900693          	li	a3,105
800015a0:	0ad50263          	beq	a0,a3,80001644 <z_vprintk+0x1dc>
800015a4:	06c00693          	li	a3,108
800015a8:	08d50a63          	beq	a0,a3,8000163c <z_vprintk+0x1d4>
800015ac:	06800693          	li	a3,104
800015b0:	f6d506e3          	beq	a0,a3,8000151c <z_vprintk+0xb4>
800015b4:	fc5ff06f          	j	80001578 <z_vprintk+0x110>
800015b8:	07500693          	li	a3,117
800015bc:	10d50663          	beq	a0,a3,800016c8 <z_vprintk+0x260>
800015c0:	02a6ee63          	bltu	a3,a0,800015fc <z_vprintk+0x194>
800015c4:	07300713          	li	a4,115
800015c8:	fae518e3          	bne	a0,a4,80001578 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
800015cc:	000d2c03          	lw	s8,0(s10)
800015d0:	004d0b13          	addi	s6,s10,4
800015d4:	000c0b93          	mv	s7,s8
				while (*s)
800015d8:	000bc503          	lbu	a0,0(s7)
800015dc:	26051863          	bnez	a0,8000184c <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
800015e0:	00300793          	li	a5,3
800015e4:	00f99863          	bne	s3,a5,800015f4 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
800015e8:	418b8bb3          	sub	s7,s7,s8
800015ec:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800015f0:	27704663          	bgtz	s7,8000185c <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
800015f4:	000b0d13          	mv	s10,s6
800015f8:	0c80006f          	j	800016c0 <z_vprintk+0x258>
800015fc:	07800693          	li	a3,120
80001600:	12d50463          	beq	a0,a3,80001728 <z_vprintk+0x2c0>
80001604:	07a00693          	li	a3,122
80001608:	fa9ff06f          	j	800015b0 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
8000160c:	00095e63          	bgez	s2,80001628 <z_vprintk+0x1c0>
80001610:	28098863          	beqz	s3,800018a0 <z_vprintk+0x438>
					min_width = *fmt - '0';
80001614:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001618:	f00992e3          	bnez	s3,8000151c <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
8000161c:	00200993          	li	s3,2
80001620:	efdff06f          	j	8000151c <z_vprintk+0xb4>
				if (min_width < 0) {
80001624:	fe0948e3          	bltz	s2,80001614 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001628:	00a00693          	li	a3,10
8000162c:	02d90933          	mul	s2,s2,a3
80001630:	fd090913          	addi	s2,s2,-48
80001634:	01250933          	add	s2,a0,s2
80001638:	fe1ff06f          	j	80001618 <z_vprintk+0x1b0>
				long_ctr++;
8000163c:	001a0a13          	addi	s4,s4,1
80001640:	eddff06f          	j	8000151c <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001644:	040a1263          	bnez	s4,80001688 <z_vprintk+0x220>
					long ld = va_arg(ap, long);
80001648:	000d2603          	lw	a2,0(s10)
8000164c:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001650:	02065063          	bgez	a2,80001670 <z_vprintk+0x208>
					out((int)'-', ctx);
80001654:	00048593          	mv	a1,s1
80001658:	02d00513          	li	a0,45
8000165c:	00c12023          	sw	a2,0(sp)
80001660:	000400e7          	jalr	s0
					d = -d;
80001664:	00012603          	lw	a2,0(sp)
					min_width--;
80001668:	fff90913          	addi	s2,s2,-1
					d = -d;
8000166c:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001670:	00090713          	mv	a4,s2
80001674:	00098693          	mv	a3,s3
80001678:	00048593          	mv	a1,s1
8000167c:	00040513          	mv	a0,s0
80001680:	c95ff0ef          	jal	ra,80001314 <_printk_dec_ulong>
				break;
80001684:	03c0006f          	j	800016c0 <z_vprintk+0x258>
				} else if (long_ctr == 1) {
80001688:	00100713          	li	a4,1
8000168c:	faea0ee3          	beq	s4,a4,80001648 <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
80001690:	007d0793          	addi	a5,s10,7
80001694:	ff87f713          	andi	a4,a5,-8
80001698:	00072603          	lw	a2,0(a4)
8000169c:	00472683          	lw	a3,4(a4)
800016a0:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
800016a4:	01b60733          	add	a4,a2,s11
800016a8:	00c73733          	sltu	a4,a4,a2
800016ac:	00d70733          	add	a4,a4,a3
800016b0:	fa0700e3          	beqz	a4,80001650 <z_vprintk+0x1e8>
						print_err(out, ctx);
800016b4:	00048593          	mv	a1,s1
800016b8:	00040513          	mv	a0,s0
800016bc:	bf5ff0ef          	jal	ra,800012b0 <print_err>
			might_format = 0;
800016c0:	00000c93          	li	s9,0
800016c4:	e59ff06f          	j	8000151c <z_vprintk+0xb4>
				if (long_ctr == 0) {
800016c8:	000a1863          	bnez	s4,800016d8 <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
800016cc:	000d2603          	lw	a2,0(s10)
800016d0:	004d0d13          	addi	s10,s10,4
800016d4:	f9dff06f          	j	80001670 <z_vprintk+0x208>
				} else if (long_ctr == 1) {
800016d8:	00100713          	li	a4,1
800016dc:	feea08e3          	beq	s4,a4,800016cc <z_vprintk+0x264>
					unsigned long long llu =
800016e0:	007d0793          	addi	a5,s10,7
800016e4:	ff87f713          	andi	a4,a5,-8
800016e8:	00870d13          	addi	s10,a4,8
800016ec:	00072603          	lw	a2,0(a4)
800016f0:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
800016f4:	fc0710e3          	bnez	a4,800016b4 <z_vprintk+0x24c>
800016f8:	800007b7          	lui	a5,0x80000
800016fc:	fff7c793          	not	a5,a5
80001700:	f6c7f8e3          	bgeu	a5,a2,80001670 <z_vprintk+0x208>
80001704:	fb1ff06f          	j	800016b4 <z_vprintk+0x24c>
				  out('0', ctx);
80001708:	00048593          	mv	a1,s1
8000170c:	03000513          	li	a0,48
80001710:	000400e7          	jalr	s0
				  out('x', ctx);
80001714:	00048593          	mv	a1,s1
80001718:	07800513          	li	a0,120
8000171c:	000400e7          	jalr	s0
				  min_width = 8;
80001720:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001724:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001728:	00100693          	li	a3,1
8000172c:	0b46c263          	blt	a3,s4,800017d0 <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
80001730:	000d2783          	lw	a5,0(s10)
80001734:	00012423          	sw	zero,8(sp)
80001738:	004d0d13          	addi	s10,s10,4
8000173c:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001740:	01000c13          	li	s8,16
	int digits = 0;
80001744:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001748:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
8000174c:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001750:	00412503          	lw	a0,4(sp)
80001754:	00812583          	lw	a1,8(sp)
80001758:	fff88b13          	addi	s6,a7,-1
8000175c:	002b1613          	slli	a2,s6,0x2
80001760:	01112623          	sw	a7,12(sp)
80001764:	b15fe0ef          	jal	ra,80000278 <__lshrdi3>
80001768:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
8000176c:	08051863          	bnez	a0,800017fc <z_vprintk+0x394>
80001770:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001774:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001778:	00079863          	bnez	a5,80001788 <z_vprintk+0x320>
8000177c:	00c12883          	lw	a7,12(sp)
80001780:	00100793          	li	a5,1
80001784:	08f89663          	bne	a7,a5,80001810 <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
80001788:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
8000178c:	01851513          	slli	a0,a0,0x18
80001790:	00048593          	mv	a1,s1
80001794:	41855513          	srai	a0,a0,0x18
80001798:	000400e7          	jalr	s0
			digits++;
8000179c:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
800017a0:	040b1863          	bnez	s6,800017f0 <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
800017a4:	00300693          	li	a3,3
			might_format = 0;
800017a8:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800017ac:	d6d998e3          	bne	s3,a3,8000151c <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
800017b0:	00191713          	slli	a4,s2,0x1
800017b4:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800017b8:	f17054e3          	blez	s7,800016c0 <z_vprintk+0x258>
			out(' ', ctx);
800017bc:	00048593          	mv	a1,s1
800017c0:	02000513          	li	a0,32
800017c4:	000400e7          	jalr	s0
800017c8:	fffb8b93          	addi	s7,s7,-1
800017cc:	fedff06f          	j	800017b8 <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
800017d0:	007d0793          	addi	a5,s10,7
800017d4:	ff87f693          	andi	a3,a5,-8
800017d8:	0006a783          	lw	a5,0(a3)
800017dc:	00868d13          	addi	s10,a3,8
800017e0:	00f12223          	sw	a5,4(sp)
800017e4:	0046a783          	lw	a5,4(a3)
800017e8:	00f12423          	sw	a5,8(sp)
800017ec:	f55ff06f          	j	80001740 <z_vprintk+0x2d8>
			found_largest_digit = 1;
800017f0:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800017f4:	000b0893          	mv	a7,s6
800017f8:	f59ff06f          	j	80001750 <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
800017fc:	00900793          	li	a5,9
80001800:	05700693          	li	a3,87
80001804:	f8a7e2e3          	bltu	a5,a0,80001788 <z_vprintk+0x320>
80001808:	03000693          	li	a3,48
8000180c:	f7dff06f          	j	80001788 <z_vprintk+0x320>
		if (remaining-- <= min_width) {
80001810:	fffc0793          	addi	a5,s8,-1
80001814:	00f12623          	sw	a5,12(sp)
80001818:	01894c63          	blt	s2,s8,80001830 <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
8000181c:	00100793          	li	a5,1
80001820:	00f99c63          	bne	s3,a5,80001838 <z_vprintk+0x3d0>
				out('0', ctx);
80001824:	00048593          	mv	a1,s1
80001828:	03000513          	li	a0,48
				out(' ', ctx);
8000182c:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80001830:	00c12c03          	lw	s8,12(sp)
80001834:	fc1ff06f          	j	800017f4 <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
80001838:	00200793          	li	a5,2
8000183c:	fef99ae3          	bne	s3,a5,80001830 <z_vprintk+0x3c8>
				out(' ', ctx);
80001840:	00048593          	mv	a1,s1
80001844:	02000513          	li	a0,32
80001848:	fe5ff06f          	j	8000182c <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
8000184c:	00048593          	mv	a1,s1
80001850:	001b8b93          	addi	s7,s7,1
80001854:	000400e7          	jalr	s0
80001858:	d81ff06f          	j	800015d8 <z_vprintk+0x170>
						out(' ', ctx);
8000185c:	00048593          	mv	a1,s1
80001860:	02000513          	li	a0,32
80001864:	000400e7          	jalr	s0
80001868:	fffb8b93          	addi	s7,s7,-1
8000186c:	d85ff06f          	j	800015f0 <z_vprintk+0x188>
				out(c, ctx);
80001870:	000d2503          	lw	a0,0(s10)
80001874:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80001878:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
8000187c:	000400e7          	jalr	s0
				break;
80001880:	d75ff06f          	j	800015f4 <z_vprintk+0x18c>
				long_ctr = 0;
80001884:	00000a13          	li	s4,0
				min_width = -1;
80001888:	fff00913          	li	s2,-1
				padding = PAD_NONE;
8000188c:	00000993          	li	s3,0
				might_format = 1;
80001890:	00100c93          	li	s9,1
80001894:	c89ff06f          	j	8000151c <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80001898:	00300993          	li	s3,3
8000189c:	c81ff06f          	j	8000151c <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
800018a0:	00100993          	li	s3,1
800018a4:	c79ff06f          	j	8000151c <z_vprintk+0xb4>

800018a8 <vprintk>:
{
800018a8:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
800018ac:	00050613          	mv	a2,a0
800018b0:	80001537          	lui	a0,0x80001
800018b4:	00058693          	mv	a3,a1
800018b8:	2fc50513          	addi	a0,a0,764 # 800012fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800012fd>
800018bc:	00c10593          	addi	a1,sp,12
{
800018c0:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800018c4:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
800018c8:	ba1ff0ef          	jal	ra,80001468 <z_vprintk>
}
800018cc:	01c12083          	lw	ra,28(sp)
800018d0:	02010113          	addi	sp,sp,32
800018d4:	00008067          	ret

800018d8 <printk>:
{
800018d8:	fc010113          	addi	sp,sp,-64
800018dc:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
800018e0:	02410593          	addi	a1,sp,36
{
800018e4:	00112e23          	sw	ra,28(sp)
800018e8:	02c12423          	sw	a2,40(sp)
800018ec:	02d12623          	sw	a3,44(sp)
800018f0:	02e12823          	sw	a4,48(sp)
800018f4:	02f12a23          	sw	a5,52(sp)
800018f8:	03012c23          	sw	a6,56(sp)
800018fc:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80001900:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001904:	fa5ff0ef          	jal	ra,800018a8 <vprintk>
}
80001908:	01c12083          	lw	ra,28(sp)
8000190c:	04010113          	addi	sp,sp,64
80001910:	00008067          	ret

80001914 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001914:	800065b7          	lui	a1,0x80006
80001918:	80006537          	lui	a0,0x80006
{
8000191c:	ff010113          	addi	sp,sp,-16
  k_panic();
80001920:	cc458593          	addi	a1,a1,-828 # 80005cc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cc5>
80001924:	cd850513          	addi	a0,a0,-808 # 80005cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd9>
80001928:	01e00613          	li	a2,30
{
8000192c:	00112623          	sw	ra,12(sp)
  k_panic();
80001930:	fa9ff0ef          	jal	ra,800018d8 <printk>
80001934:	800065b7          	lui	a1,0x80006
80001938:	8a458593          	addi	a1,a1,-1884 # 800058a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a5>
8000193c:	00600513          	li	a0,6
80001940:	994ff0ef          	jal	ra,80000ad4 <z_NanoFatalErrorHandler>

80001944 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001944:	00008067          	ret

80001948 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001948:	00800793          	li	a5,8
8000194c:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001950:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001954:	00008067          	ret

80001958 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001958:	00100793          	li	a5,1
8000195c:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001960:	30452573          	csrrs	a0,mie,a0
}
80001964:	00008067          	ret

80001968 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001968:	00800793          	li	a5,8
8000196c:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001970:	30405073          	csrwi	mie,0
80001974:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001978:	00008067          	ret

8000197c <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
8000197c:	ff010113          	addi	sp,sp,-16
80001980:	00812423          	sw	s0,8(sp)
80001984:	00912223          	sw	s1,4(sp)
80001988:	80006437          	lui	s0,0x80006
8000198c:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001990:	00a00793          	li	a5,10
{
80001994:	00050493          	mv	s1,a0
80001998:	36440413          	addi	s0,s0,868 # 80006364 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006365>
	if ('\n' == c) {
8000199c:	00f51c63          	bne	a0,a5,800019b4 <console_out+0x38>
800019a0:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
800019a4:	00d00593          	li	a1,13
800019a8:	00452783          	lw	a5,4(a0)
800019ac:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
800019b0:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
800019b4:	00042503          	lw	a0,0(s0)
800019b8:	0ff4f593          	andi	a1,s1,255
800019bc:	00452783          	lw	a5,4(a0)
800019c0:	0047a783          	lw	a5,4(a5)
800019c4:	000780e7          	jalr	a5

	return c;
}
800019c8:	00c12083          	lw	ra,12(sp)
800019cc:	00812403          	lw	s0,8(sp)
800019d0:	00048513          	mv	a0,s1
800019d4:	00412483          	lw	s1,4(sp)
800019d8:	01010113          	addi	sp,sp,16
800019dc:	00008067          	ret

800019e0 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
800019e0:	ff010113          	addi	sp,sp,-16
800019e4:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
800019e8:	80002437          	lui	s0,0x80002
800019ec:	97c40513          	addi	a0,s0,-1668 # 8000197c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000197d>
{
800019f0:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
800019f4:	5b4000ef          	jal	ra,80001fa8 <__stdout_hook_install>
	__printk_hook_install(console_out);
800019f8:	97c40513          	addi	a0,s0,-1668
}
800019fc:	00812403          	lw	s0,8(sp)
80001a00:	00c12083          	lw	ra,12(sp)
80001a04:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001a08:	a55ff06f          	j	8000145c <__printk_hook_install>

80001a0c <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001a0c:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001a10:	ff010113          	addi	sp,sp,-16
80001a14:	ce450513          	addi	a0,a0,-796 # 80005ce4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ce5>
80001a18:	00112623          	sw	ra,12(sp)
80001a1c:	135000ef          	jal	ra,80002350 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001a20:	800067b7          	lui	a5,0x80006
80001a24:	36a7a223          	sw	a0,868(a5) # 80006364 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006365>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001a28:	fb9ff0ef          	jal	ra,800019e0 <uart_console_hook_install>

	return 0;
}
80001a2c:	00c12083          	lw	ra,12(sp)
80001a30:	00000513          	li	a0,0
80001a34:	01010113          	addi	sp,sp,16
80001a38:	00008067          	ret

80001a3c <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001a3c:	f01007b7          	lui	a5,0xf0100
80001a40:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001a44:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001a48:	f447a583          	lw	a1,-188(a5)
80001a4c:	fee59ae3          	bne	a1,a4,80001a40 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001a50:	00008067          	ret

80001a54 <timer_isr>:

static void timer_isr(void *arg)
{
80001a54:	fe010113          	addi	sp,sp,-32
80001a58:	00812c23          	sw	s0,24(sp)
80001a5c:	00112e23          	sw	ra,28(sp)
80001a60:	00912a23          	sw	s1,20(sp)
80001a64:	01212823          	sw	s2,16(sp)
80001a68:	01312623          	sw	s3,12(sp)
80001a6c:	01412423          	sw	s4,8(sp)
80001a70:	01512223          	sw	s5,4(sp)
80001a74:	00800413          	li	s0,8
80001a78:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001a7c:	80006937          	lui	s2,0x80006
80001a80:	36890513          	addi	a0,s2,872 # 80006368 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006369>
	key = (mstatus & SOC_MSTATUS_IEN);
80001a84:	00847413          	andi	s0,s0,8
80001a88:	549020ef          	jal	ra,800047d0 <z_spin_lock_valid>
80001a8c:	02051e63          	bnez	a0,80001ac8 <timer_isr+0x74>
80001a90:	800064b7          	lui	s1,0x80006
80001a94:	800065b7          	lui	a1,0x80006
80001a98:	80006537          	lui	a0,0x80006
80001a9c:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80001aa0:	04e00693          	li	a3,78
80001aa4:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80001aa8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80001aac:	e2dff0ef          	jal	ra,800018d8 <printk>
80001ab0:	80006537          	lui	a0,0x80006
80001ab4:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80001ab8:	e21ff0ef          	jal	ra,800018d8 <printk>
80001abc:	04e00593          	li	a1,78
80001ac0:	cf848513          	addi	a0,s1,-776
80001ac4:	e51ff0ef          	jal	ra,80001914 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001ac8:	36890513          	addi	a0,s2,872
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001acc:	800064b7          	lui	s1,0x80006
80001ad0:	559020ef          	jal	ra,80004828 <z_spin_lock_set_owner>
80001ad4:	34048493          	addi	s1,s1,832 # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
	u64_t now = mtime();
80001ad8:	f65ff0ef          	jal	ra,80001a3c <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001adc:	0004a983          	lw	s3,0(s1)
80001ae0:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001ae4:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001ae8:	41350533          	sub	a0,a0,s3
80001aec:	00a73733          	sltu	a4,a4,a0
80001af0:	415585b3          	sub	a1,a1,s5
80001af4:	0001d637          	lui	a2,0x1d
80001af8:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001afc:	00000693          	li	a3,0
80001b00:	40e585b3          	sub	a1,a1,a4
80001b04:	facfe0ef          	jal	ra,800002b0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
80001b08:	0001d7b7          	lui	a5,0x1d
80001b0c:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001b10:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001b14:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001b18:	36890513          	addi	a0,s2,872
	last_count += dticks * CYC_PER_TICK;
80001b1c:	013789b3          	add	s3,a5,s3
80001b20:	00f9b7b3          	sltu	a5,s3,a5
80001b24:	015787b3          	add	a5,a5,s5
80001b28:	0134a023          	sw	s3,0(s1)
80001b2c:	00f4a223          	sw	a5,4(s1)
80001b30:	4c9020ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80001b34:	02051e63          	bnez	a0,80001b70 <timer_isr+0x11c>
80001b38:	800064b7          	lui	s1,0x80006
80001b3c:	800065b7          	lui	a1,0x80006
80001b40:	80006537          	lui	a0,0x80006
80001b44:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80001b48:	06100693          	li	a3,97
80001b4c:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80001b50:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80001b54:	d85ff0ef          	jal	ra,800018d8 <printk>
80001b58:	80006537          	lui	a0,0x80006
80001b5c:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80001b60:	d79ff0ef          	jal	ra,800018d8 <printk>
80001b64:	06100593          	li	a1,97
80001b68:	cf848513          	addi	a0,s1,-776
80001b6c:	da9ff0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001b70:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001b74:	01812403          	lw	s0,24(sp)
80001b78:	01c12083          	lw	ra,28(sp)
80001b7c:	01412483          	lw	s1,20(sp)
80001b80:	01012903          	lw	s2,16(sp)
80001b84:	00c12983          	lw	s3,12(sp)
80001b88:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001b8c:	000a0513          	mv	a0,s4
}
80001b90:	00812a03          	lw	s4,8(sp)
80001b94:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001b98:	6640306f          	j	800051fc <z_clock_announce>

80001b9c <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001b9c:	ff010113          	addi	sp,sp,-16
80001ba0:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001ba4:	e99ff0ef          	jal	ra,80001a3c <mtime>
80001ba8:	0001d7b7          	lui	a5,0x1d
80001bac:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001bb0:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001bb4:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80001bb8:	fff00693          	li	a3,-1
80001bbc:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001bc0:	00a7b533          	sltu	a0,a5,a0
80001bc4:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80001bc8:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001bcc:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001bd0:	00700513          	li	a0,7
80001bd4:	d85ff0ef          	jal	ra,80001958 <z_arch_irq_enable>
	return 0;
}
80001bd8:	00c12083          	lw	ra,12(sp)
80001bdc:	00000513          	li	a0,0
80001be0:	01010113          	addi	sp,sp,16
80001be4:	00008067          	ret

80001be8 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001be8:	16059c63          	bnez	a1,80001d60 <z_clock_set_timeout+0x178>
{
80001bec:	fe010113          	addi	sp,sp,-32
80001bf0:	00112e23          	sw	ra,28(sp)
80001bf4:	00812c23          	sw	s0,24(sp)
80001bf8:	00912a23          	sw	s1,20(sp)
80001bfc:	01212823          	sw	s2,16(sp)
80001c00:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001c04:	fff00793          	li	a5,-1
80001c08:	00f51663          	bne	a0,a5,80001c14 <z_clock_set_timeout+0x2c>
80001c0c:	00009537          	lui	a0,0x9
80001c10:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001c14:	000097b7          	lui	a5,0x9
80001c18:	fff50413          	addi	s0,a0,-1
80001c1c:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001c20:	1287da63          	bge	a5,s0,80001d54 <z_clock_set_timeout+0x16c>
80001c24:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001c28:	00800493          	li	s1,8
80001c2c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001c30:	80006937          	lui	s2,0x80006
80001c34:	36890513          	addi	a0,s2,872 # 80006368 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006369>
	key = (mstatus & SOC_MSTATUS_IEN);
80001c38:	0084f493          	andi	s1,s1,8
80001c3c:	395020ef          	jal	ra,800047d0 <z_spin_lock_valid>
80001c40:	02051e63          	bnez	a0,80001c7c <z_clock_set_timeout+0x94>
80001c44:	800069b7          	lui	s3,0x80006
80001c48:	800065b7          	lui	a1,0x80006
80001c4c:	80006537          	lui	a0,0x80006
80001c50:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80001c54:	04e00693          	li	a3,78
80001c58:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80001c5c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80001c60:	c79ff0ef          	jal	ra,800018d8 <printk>
80001c64:	80006537          	lui	a0,0x80006
80001c68:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80001c6c:	c6dff0ef          	jal	ra,800018d8 <printk>
80001c70:	04e00593          	li	a1,78
80001c74:	cf898513          	addi	a0,s3,-776
80001c78:	c9dff0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80001c7c:	36890513          	addi	a0,s2,872
80001c80:	3a9020ef          	jal	ra,80004828 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001c84:	db9ff0ef          	jal	ra,80001a3c <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
80001c88:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001c8c:	800067b7          	lui	a5,0x80006
	u32_t cyc = ticks * CYC_PER_TICK;
80001c90:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001c94:	34078793          	addi	a5,a5,832 # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
80001c98:	0007a703          	lw	a4,0(a5)
80001c9c:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001ca0:	02c407b3          	mul	a5,s0,a2
80001ca4:	4bf68693          	addi	a3,a3,1215
80001ca8:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001cac:	3e700693          	li	a3,999
80001cb0:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001cb4:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001cb8:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001cbc:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001cc0:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001cc4:	00f50533          	add	a0,a0,a5
80001cc8:	00a6c463          	blt	a3,a0,80001cd0 <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
80001ccc:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
80001cd0:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80001cd4:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
80001cd8:	fff00613          	li	a2,-1
80001cdc:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80001ce0:	00f737b3          	sltu	a5,a4,a5
80001ce4:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
80001ce8:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
80001cec:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001cf0:	36890513          	addi	a0,s2,872
80001cf4:	305020ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80001cf8:	02051e63          	bnez	a0,80001d34 <z_clock_set_timeout+0x14c>
80001cfc:	80006437          	lui	s0,0x80006
80001d00:	800065b7          	lui	a1,0x80006
80001d04:	80006537          	lui	a0,0x80006
80001d08:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80001d0c:	06100693          	li	a3,97
80001d10:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80001d14:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80001d18:	bc1ff0ef          	jal	ra,800018d8 <printk>
80001d1c:	80006537          	lui	a0,0x80006
80001d20:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80001d24:	bb5ff0ef          	jal	ra,800018d8 <printk>
80001d28:	06100593          	li	a1,97
80001d2c:	cf840513          	addi	a0,s0,-776
80001d30:	be5ff0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001d34:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
80001d38:	01c12083          	lw	ra,28(sp)
80001d3c:	01812403          	lw	s0,24(sp)
80001d40:	01412483          	lw	s1,20(sp)
80001d44:	01012903          	lw	s2,16(sp)
80001d48:	00c12983          	lw	s3,12(sp)
80001d4c:	02010113          	addi	sp,sp,32
80001d50:	00008067          	ret
80001d54:	ec045ae3          	bgez	s0,80001c28 <z_clock_set_timeout+0x40>
80001d58:	00000413          	li	s0,0
80001d5c:	ecdff06f          	j	80001c28 <z_clock_set_timeout+0x40>
80001d60:	00008067          	ret

80001d64 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001d64:	ff010113          	addi	sp,sp,-16
80001d68:	00812423          	sw	s0,8(sp)
80001d6c:	00112623          	sw	ra,12(sp)
80001d70:	00912223          	sw	s1,4(sp)
80001d74:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d78:	00800413          	li	s0,8
80001d7c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001d80:	80006937          	lui	s2,0x80006
80001d84:	36890513          	addi	a0,s2,872 # 80006368 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006369>
	key = (mstatus & SOC_MSTATUS_IEN);
80001d88:	00847413          	andi	s0,s0,8
80001d8c:	245020ef          	jal	ra,800047d0 <z_spin_lock_valid>
80001d90:	02051e63          	bnez	a0,80001dcc <z_clock_elapsed+0x68>
80001d94:	800064b7          	lui	s1,0x80006
80001d98:	800065b7          	lui	a1,0x80006
80001d9c:	80006537          	lui	a0,0x80006
80001da0:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80001da4:	04e00693          	li	a3,78
80001da8:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80001dac:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80001db0:	b29ff0ef          	jal	ra,800018d8 <printk>
80001db4:	80006537          	lui	a0,0x80006
80001db8:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80001dbc:	b1dff0ef          	jal	ra,800018d8 <printk>
80001dc0:	04e00593          	li	a1,78
80001dc4:	cf848513          	addi	a0,s1,-776
80001dc8:	b4dff0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80001dcc:	36890513          	addi	a0,s2,872
80001dd0:	259020ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80001dd4:	c69ff0ef          	jal	ra,80001a3c <mtime>
80001dd8:	800067b7          	lui	a5,0x80006
80001ddc:	3407a483          	lw	s1,832(a5) # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
80001de0:	409504b3          	sub	s1,a0,s1
80001de4:	0001d537          	lui	a0,0x1d
80001de8:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001dec:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001df0:	36890513          	addi	a0,s2,872
80001df4:	205020ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80001df8:	02051e63          	bnez	a0,80001e34 <z_clock_elapsed+0xd0>
80001dfc:	80006937          	lui	s2,0x80006
80001e00:	800065b7          	lui	a1,0x80006
80001e04:	80006537          	lui	a0,0x80006
80001e08:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80001e0c:	06100693          	li	a3,97
80001e10:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80001e14:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80001e18:	ac1ff0ef          	jal	ra,800018d8 <printk>
80001e1c:	80006537          	lui	a0,0x80006
80001e20:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80001e24:	ab5ff0ef          	jal	ra,800018d8 <printk>
80001e28:	06100593          	li	a1,97
80001e2c:	cf890513          	addi	a0,s2,-776
80001e30:	ae5ff0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001e34:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80001e38:	00c12083          	lw	ra,12(sp)
80001e3c:	00812403          	lw	s0,8(sp)
80001e40:	00048513          	mv	a0,s1
80001e44:	00012903          	lw	s2,0(sp)
80001e48:	00412483          	lw	s1,4(sp)
80001e4c:	01010113          	addi	sp,sp,16
80001e50:	00008067          	ret

80001e54 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80001e54:	00054783          	lbu	a5,0(a0)
80001e58:	0005c703          	lbu	a4,0(a1)
80001e5c:	00e79463          	bne	a5,a4,80001e64 <strcmp+0x10>
80001e60:	00079663          	bnez	a5,80001e6c <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80001e64:	40e78533          	sub	a0,a5,a4
80001e68:	00008067          	ret
		s1++;
80001e6c:	00150513          	addi	a0,a0,1
		s2++;
80001e70:	00158593          	addi	a1,a1,1
80001e74:	fe1ff06f          	j	80001e54 <strcmp>

80001e78 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80001e78:	00b547b3          	xor	a5,a0,a1
80001e7c:	0037f793          	andi	a5,a5,3
80001e80:	06078063          	beqz	a5,80001ee0 <memcpy+0x68>
	unsigned char *d_byte = (unsigned char *)d;
80001e84:	00050793          	mv	a5,a0
80001e88:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80001e8c:	06e61a63          	bne	a2,a4,80001f00 <memcpy+0x88>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80001e90:	00008067          	ret
			if (n == 0) {
80001e94:	fe060ee3          	beqz	a2,80001e90 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80001e98:	00158593          	addi	a1,a1,1
80001e9c:	fff5c703          	lbu	a4,-1(a1)
80001ea0:	00178793          	addi	a5,a5,1
			n--;
80001ea4:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80001ea8:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80001eac:	0037f713          	andi	a4,a5,3
80001eb0:	fe0712e3          	bnez	a4,80001e94 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
80001eb4:	00300693          	li	a3,3
80001eb8:	40e60833          	sub	a6,a2,a4
80001ebc:	0306e663          	bltu	a3,a6,80001ee8 <memcpy+0x70>
80001ec0:	00265713          	srli	a4,a2,0x2
80001ec4:	ffc00693          	li	a3,-4
80001ec8:	02d706b3          	mul	a3,a4,a3
80001ecc:	00271713          	slli	a4,a4,0x2
80001ed0:	00e787b3          	add	a5,a5,a4
80001ed4:	00e585b3          	add	a1,a1,a4
80001ed8:	00d60633          	add	a2,a2,a3
80001edc:	fadff06f          	j	80001e88 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
80001ee0:	00050793          	mv	a5,a0
80001ee4:	fc9ff06f          	j	80001eac <memcpy+0x34>
			*(d_word++) = *(s_word++);
80001ee8:	00e588b3          	add	a7,a1,a4
80001eec:	0008a883          	lw	a7,0(a7)
80001ef0:	00e78833          	add	a6,a5,a4
80001ef4:	00470713          	addi	a4,a4,4
80001ef8:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80001efc:	fbdff06f          	j	80001eb8 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
80001f00:	00e58833          	add	a6,a1,a4
80001f04:	00084803          	lbu	a6,0(a6)
80001f08:	00e786b3          	add	a3,a5,a4
80001f0c:	00170713          	addi	a4,a4,1
80001f10:	01068023          	sb	a6,0(a3)
		n--;
80001f14:	f79ff06f          	j	80001e8c <memcpy+0x14>

80001f18 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80001f18:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80001f1c:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80001f20:	0037f713          	andi	a4,a5,3
80001f24:	04071863          	bnez	a4,80001f74 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80001f28:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80001f2c:	00859713          	slli	a4,a1,0x8
80001f30:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80001f34:	01059713          	slli	a4,a1,0x10
80001f38:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80001f3c:	00c78333          	add	t1,a5,a2
80001f40:	00078713          	mv	a4,a5
80001f44:	00300813          	li	a6,3
80001f48:	40e308b3          	sub	a7,t1,a4
80001f4c:	03186e63          	bltu	a6,a7,80001f88 <memset+0x70>
80001f50:	00265713          	srli	a4,a2,0x2
80001f54:	00271593          	slli	a1,a4,0x2
80001f58:	00b787b3          	add	a5,a5,a1
80001f5c:	ffc00593          	li	a1,-4
80001f60:	02b70733          	mul	a4,a4,a1
80001f64:	00c70733          	add	a4,a4,a2
80001f68:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80001f6c:	02e79463          	bne	a5,a4,80001f94 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80001f70:	00008067          	ret
		if (n == 0) {
80001f74:	fe060ee3          	beqz	a2,80001f70 <memset+0x58>
		*(d_byte++) = c_byte;
80001f78:	00178793          	addi	a5,a5,1
80001f7c:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001f80:	fff60613          	addi	a2,a2,-1
80001f84:	f9dff06f          	j	80001f20 <memset+0x8>
		*(d_word++) = c_word;
80001f88:	00470713          	addi	a4,a4,4
80001f8c:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80001f90:	fb9ff06f          	j	80001f48 <memset+0x30>
		*(d_byte++) = c_byte;
80001f94:	00178793          	addi	a5,a5,1
80001f98:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001f9c:	fd1ff06f          	j	80001f6c <memset+0x54>

80001fa0 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80001fa0:	fff00513          	li	a0,-1
80001fa4:	00008067          	ret

80001fa8 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80001fa8:	800067b7          	lui	a5,0x80006
80001fac:	28a7a223          	sw	a0,644(a5) # 80006284 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006285>
}
80001fb0:	00008067          	ret

80001fb4 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80001fb4:	fe010113          	addi	sp,sp,-32
80001fb8:	00812c23          	sw	s0,24(sp)
	test->setup();
80001fbc:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80001fc0:	80006437          	lui	s0,0x80006
{
80001fc4:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80001fc8:	28840413          	addi	s0,s0,648 # 80006288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006289>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80001fcc:	800064b7          	lui	s1,0x80006
{
80001fd0:	00112e23          	sw	ra,28(sp)
80001fd4:	01212823          	sw	s2,16(sp)
80001fd8:	01312623          	sw	s3,12(sp)
	test_result = 1;
80001fdc:	36c48493          	addi	s1,s1,876 # 8000636c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000636d>
80001fe0:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80001fe4:	00042023          	sw	zero,0(s0)
{
80001fe8:	00050913          	mv	s2,a0
	test_result = 1;
80001fec:	0134a023          	sw	s3,0(s1)
	test->setup();
80001ff0:	000780e7          	jalr	a5
	test->test();
80001ff4:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80001ff8:	01342023          	sw	s3,0(s0)
	test->test();
80001ffc:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002000:	00200793          	li	a5,2
80002004:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002008:	00c92783          	lw	a5,12(s2)
8000200c:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002010:	00300793          	li	a5,3
80002014:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002018:	01812403          	lw	s0,24(sp)
	test_result = 0;
8000201c:	0004a023          	sw	zero,0(s1)
}
80002020:	01c12083          	lw	ra,28(sp)
80002024:	01412483          	lw	s1,20(sp)
80002028:	01012903          	lw	s2,16(sp)
8000202c:	00c12983          	lw	s3,12(sp)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002030:	80006537          	lui	a0,0x80006
80002034:	4dc50513          	addi	a0,a0,1244 # 800064dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064dd>
80002038:	02010113          	addi	sp,sp,32
8000203c:	2440206f          	j	80004280 <z_impl_k_sem_give>

80002040 <ztest_test_fail>:
80002040:	80006537          	lui	a0,0x80006
{
80002044:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002048:	800067b7          	lui	a5,0x80006
8000204c:	fff00713          	li	a4,-1
80002050:	4dc50513          	addi	a0,a0,1244 # 800064dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064dd>
{
80002054:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002058:	36e7a623          	sw	a4,876(a5) # 8000636c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000636d>
8000205c:	224020ef          	jal	ra,80004280 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002060:	14c020ef          	jal	ra,800041ac <z_impl_k_current_get>
}
80002064:	00c12083          	lw	ra,12(sp)
80002068:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000206c:	2cd0206f          	j	80004b38 <z_impl_k_thread_abort>

80002070 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002070:	fa010113          	addi	sp,sp,-96
80002074:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002078:	800064b7          	lui	s1,0x80006
8000207c:	3704a783          	lw	a5,880(s1) # 80006370 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006371>
{
80002080:	04112e23          	sw	ra,92(sp)
80002084:	04812c23          	sw	s0,88(sp)
80002088:	05212823          	sw	s2,80(sp)
8000208c:	05312623          	sw	s3,76(sp)
80002090:	05412423          	sw	s4,72(sp)
80002094:	05512223          	sw	s5,68(sp)
80002098:	05612023          	sw	s6,64(sp)
8000209c:	03712e23          	sw	s7,60(sp)
800020a0:	03812c23          	sw	s8,56(sp)
800020a4:	03912a23          	sw	s9,52(sp)
800020a8:	03a12823          	sw	s10,48(sp)
800020ac:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
800020b0:	0807c463          	bltz	a5,80002138 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
800020b4:	80006437          	lui	s0,0x80006
800020b8:	00100613          	li	a2,1
800020bc:	00050993          	mv	s3,a0
800020c0:	00058c13          	mv	s8,a1
800020c4:	4dc40513          	addi	a0,s0,1244 # 800064dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064dd>
800020c8:	00000593          	li	a1,0
800020cc:	0ec020ef          	jal	ra,800041b8 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800020d0:	80006537          	lui	a0,0x80006
800020d4:	00098593          	mv	a1,s3
800020d8:	db450513          	addi	a0,a0,-588 # 80005db4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005db5>
800020dc:	ffcff0ef          	jal	ra,800018d8 <printk>
	PRINT_LINE;
800020e0:	80006937          	lui	s2,0x80006
800020e4:	dcc90513          	addi	a0,s2,-564 # 80005dcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dcd>
		Z_TC_END_RESULT(ret, test->name);
800020e8:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
800020ec:	fecff0ef          	jal	ra,800018d8 <printk>
800020f0:	37048493          	addi	s1,s1,880
	int fail = 0;
800020f4:	00000a13          	li	s4,0
800020f8:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800020fc:	80007cb7          	lui	s9,0x80007
80002100:	80006b37          	lui	s6,0x80006
80002104:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80002108:	80006db7          	lui	s11,0x80006
8000210c:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
80002110:	d6ca8a93          	addi	s5,s5,-660 # 80005d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d6d>
	while (suite->test) {
80002114:	004c2783          	lw	a5,4(s8)
80002118:	04079e63          	bnez	a5,80002174 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
8000211c:	00098593          	mv	a1,s3
	if (fail) {
80002120:	100a0663          	beqz	s4,8000222c <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002124:	80006537          	lui	a0,0x80006
80002128:	e3c50513          	addi	a0,a0,-452 # 80005e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e3d>
8000212c:	facff0ef          	jal	ra,800018d8 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002130:	00100793          	li	a5,1
80002134:	00f4a023          	sw	a5,0(s1)
}
80002138:	05c12083          	lw	ra,92(sp)
8000213c:	05812403          	lw	s0,88(sp)
80002140:	05412483          	lw	s1,84(sp)
80002144:	05012903          	lw	s2,80(sp)
80002148:	04c12983          	lw	s3,76(sp)
8000214c:	04812a03          	lw	s4,72(sp)
80002150:	04412a83          	lw	s5,68(sp)
80002154:	04012b03          	lw	s6,64(sp)
80002158:	03c12b83          	lw	s7,60(sp)
8000215c:	03812c03          	lw	s8,56(sp)
80002160:	03412c83          	lw	s9,52(sp)
80002164:	03012d03          	lw	s10,48(sp)
80002168:	02c12d83          	lw	s11,44(sp)
8000216c:	06010113          	addi	sp,sp,96
80002170:	00008067          	ret
	TC_START(test->name);
80002174:	000c2583          	lw	a1,0(s8)
80002178:	800067b7          	lui	a5,0x80006
8000217c:	e1478513          	addi	a0,a5,-492 # 80005e14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e15>
80002180:	f58ff0ef          	jal	ra,800018d8 <printk>
80002184:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002188:	010c2783          	lw	a5,16(s8)
8000218c:	000c0713          	mv	a4,s8
80002190:	40000613          	li	a2,1024
80002194:	0087e793          	ori	a5,a5,8
80002198:	fff00893          	li	a7,-1
8000219c:	00000813          	li	a6,0
800021a0:	fb4d0693          	addi	a3,s10,-76 # 80001fb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001fb5>
800021a4:	00f12023          	sw	a5,0(sp)
800021a8:	870c8593          	addi	a1,s9,-1936 # 80006870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006871>
800021ac:	00000793          	li	a5,0
800021b0:	4ecb0513          	addi	a0,s6,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800021b4:	7e0020ef          	jal	ra,80004994 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800021b8:	01c12783          	lw	a5,28(sp)
800021bc:	fff00593          	li	a1,-1
800021c0:	4dc78513          	addi	a0,a5,1244
800021c4:	1a0020ef          	jal	ra,80004364 <z_impl_k_sem_take>
	if (test_result == -1) {
800021c8:	36cd8793          	addi	a5,s11,876 # 8000636c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000636d>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800021cc:	4ecb0513          	addi	a0,s6,1260
800021d0:	0007a403          	lw	s0,0(a5)
800021d4:	165020ef          	jal	ra,80004b38 <z_impl_k_thread_abort>
	if (test_result == -2) {
800021d8:	800067b7          	lui	a5,0x80006
800021dc:	36c78793          	addi	a5,a5,876 # 8000636c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000636d>
800021e0:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
800021e4:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
800021e8:	ffe00793          	li	a5,-2
	if (test_result == -1) {
800021ec:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800021f0:	000c2603          	lw	a2,0(s8)
800021f4:	02f71463          	bne	a4,a5,8000221c <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800021f8:	800065b7          	lui	a1,0x80006
800021fc:	e2858593          	addi	a1,a1,-472 # 80005e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e29>
		Z_TC_END_RESULT(ret, test->name);
80002200:	e30b8513          	addi	a0,s7,-464 # 80005e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e31>
80002204:	ed4ff0ef          	jal	ra,800018d8 <printk>
80002208:	dcc90513          	addi	a0,s2,-564
8000220c:	eccff0ef          	jal	ra,800018d8 <printk>
		fail += run_test(suite);
80002210:	008a0a33          	add	s4,s4,s0
		suite++;
80002214:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002218:	efdff06f          	j	80002114 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
8000221c:	00241793          	slli	a5,s0,0x2
80002220:	00fa87b3          	add	a5,s5,a5
80002224:	0007a583          	lw	a1,0(a5)
80002228:	fd9ff06f          	j	80002200 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
8000222c:	80006537          	lui	a0,0x80006
80002230:	e5450513          	addi	a0,a0,-428 # 80005e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e55>
80002234:	ea4ff0ef          	jal	ra,800018d8 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002238:	0004a783          	lw	a5,0(s1)
8000223c:	00f037b3          	snez	a5,a5
80002240:	ef5ff06f          	j	80002134 <z_ztest_run_test_suite+0xc4>

80002244 <end_report>:

void end_report(void)
{
	if (test_status) {
80002244:	800067b7          	lui	a5,0x80006
80002248:	3707a783          	lw	a5,880(a5) # 80006370 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006371>
{
8000224c:	ff010113          	addi	sp,sp,-16
80002250:	00812423          	sw	s0,8(sp)
80002254:	80006537          	lui	a0,0x80006
80002258:	00112623          	sw	ra,12(sp)
8000225c:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
80002260:	dcc50513          	addi	a0,a0,-564 # 80005dcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dcd>
	if (test_status) {
80002264:	02078263          	beqz	a5,80002288 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002268:	e70ff0ef          	jal	ra,800018d8 <printk>
8000226c:	800065b7          	lui	a1,0x80006
80002270:	d7858593          	addi	a1,a1,-648 # 80005d78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d79>
	} else {
		TC_END_REPORT(TC_PASS);
80002274:	d8040513          	addi	a0,s0,-640 # 80005d80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d81>
	}
}
80002278:	00812403          	lw	s0,8(sp)
8000227c:	00c12083          	lw	ra,12(sp)
80002280:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002284:	e54ff06f          	j	800018d8 <printk>
80002288:	e50ff0ef          	jal	ra,800018d8 <printk>
8000228c:	800065b7          	lui	a1,0x80006
80002290:	d9858593          	addi	a1,a1,-616 # 80005d98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d99>
80002294:	fe1ff06f          	j	80002274 <end_report+0x30>

80002298 <main>:

	return test_status;
}
#else
void main(void)
{
80002298:	ff010113          	addi	sp,sp,-16
8000229c:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
800022a0:	f78fe0ef          	jal	ra,80000a18 <test_main>
	end_report();
}
800022a4:	00c12083          	lw	ra,12(sp)
800022a8:	01010113          	addi	sp,sp,16
	end_report();
800022ac:	f99ff06f          	j	80002244 <end_report>

800022b0 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
800022b0:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
800022b4:	00012623          	sw	zero,12(sp)
    i++;
800022b8:	00c12783          	lw	a5,12(sp)
800022bc:	00178793          	addi	a5,a5,1
800022c0:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
800022c4:	f00107b7          	lui	a5,0xf0010
800022c8:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
800022cc:	01010113          	addi	sp,sp,16
800022d0:	00008067          	ret

800022d4 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800022d4:	fff00513          	li	a0,-1
800022d8:	00008067          	ret

800022dc <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
800022dc:	00000513          	li	a0,0
800022e0:	00008067          	ret

800022e4 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800022e4:	00251713          	slli	a4,a0,0x2
800022e8:	800067b7          	lui	a5,0x80006
800022ec:	00150513          	addi	a0,a0,1
800022f0:	e8478793          	addi	a5,a5,-380 # 80005e84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e85>
800022f4:	00251513          	slli	a0,a0,0x2
{
800022f8:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800022fc:	00e78733          	add	a4,a5,a4
80002300:	00a787b3          	add	a5,a5,a0
{
80002304:	00812423          	sw	s0,8(sp)
80002308:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
8000230c:	00072403          	lw	s0,0(a4)
80002310:	0007a483          	lw	s1,0(a5)
{
80002314:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002318:	00946c63          	bltu	s0,s1,80002330 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
8000231c:	00c12083          	lw	ra,12(sp)
80002320:	00812403          	lw	s0,8(sp)
80002324:	00412483          	lw	s1,4(sp)
80002328:	01010113          	addi	sp,sp,16
8000232c:	00008067          	ret
		retval = device_conf->init(info);
80002330:	00042783          	lw	a5,0(s0)
80002334:	00040513          	mv	a0,s0
80002338:	0047a783          	lw	a5,4(a5)
8000233c:	000780e7          	jalr	a5
		if (retval != 0) {
80002340:	00050463          	beqz	a0,80002348 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002344:	00042223          	sw	zero,4(s0)
								info++) {
80002348:	00c40413          	addi	s0,s0,12
8000234c:	fcdff06f          	j	80002318 <z_sys_device_do_config_level+0x34>

80002350 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002350:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002354:	800067b7          	lui	a5,0x80006
{
80002358:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
8000235c:	800064b7          	lui	s1,0x80006
{
80002360:	00812423          	sw	s0,8(sp)
80002364:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002368:	29c78413          	addi	s0,a5,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
{
8000236c:	01212023          	sw	s2,0(sp)
80002370:	29c78793          	addi	a5,a5,668
80002374:	2d848493          	addi	s1,s1,728 # 800062d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d9>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002378:	00941c63          	bne	s0,s1,80002390 <z_impl_device_get_binding+0x40>
8000237c:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002380:	00078413          	mv	s0,a5
80002384:	02941463          	bne	s0,s1,800023ac <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002388:	00000413          	li	s0,0
8000238c:	0440006f          	j	800023d0 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80002390:	00442703          	lw	a4,4(s0)
80002394:	00070863          	beqz	a4,800023a4 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002398:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
8000239c:	00072703          	lw	a4,0(a4)
800023a0:	02a70863          	beq	a4,a0,800023d0 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
800023a4:	00c40413          	addi	s0,s0,12
800023a8:	fd1ff06f          	j	80002378 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
800023ac:	00442783          	lw	a5,4(s0)
800023b0:	00079663          	bnez	a5,800023bc <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
800023b4:	00c40413          	addi	s0,s0,12
800023b8:	fcdff06f          	j	80002384 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
800023bc:	00042783          	lw	a5,0(s0)
800023c0:	00090513          	mv	a0,s2
800023c4:	0007a583          	lw	a1,0(a5)
800023c8:	a8dff0ef          	jal	ra,80001e54 <strcmp>
800023cc:	fe0514e3          	bnez	a0,800023b4 <z_impl_device_get_binding+0x64>
}
800023d0:	00040513          	mv	a0,s0
800023d4:	00c12083          	lw	ra,12(sp)
800023d8:	00812403          	lw	s0,8(sp)
800023dc:	00412483          	lw	s1,4(sp)
800023e0:	00012903          	lw	s2,0(sp)
800023e4:	01010113          	addi	sp,sp,16
800023e8:	00008067          	ret

800023ec <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
800023ec:	ff010113          	addi	sp,sp,-16
800023f0:	00812423          	sw	s0,8(sp)
800023f4:	00912223          	sw	s1,4(sp)
800023f8:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800023fc:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002400:	00200493          	li	s1,2
80002404:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80002408:	415020ef          	jal	ra,8000501c <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
8000240c:	00a4c463          	blt	s1,a0,80002414 <idle+0x28>
80002410:	00100513          	li	a0,1
80002414:	00100593          	li	a1,1
80002418:	4e1020ef          	jal	ra,800050f8 <z_set_timeout_expiry>
	k_cpu_idle();
8000241c:	d2cff0ef          	jal	ra,80001948 <k_cpu_idle>
80002420:	fe5ff06f          	j	80002404 <idle+0x18>

80002424 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002424:	80006537          	lui	a0,0x80006
80002428:	800067b7          	lui	a5,0x80006
8000242c:	34050613          	addi	a2,a0,832 # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
80002430:	66878793          	addi	a5,a5,1640 # 80006668 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006669>
80002434:	40c78633          	sub	a2,a5,a2
80002438:	00000593          	li	a1,0
8000243c:	34050513          	addi	a0,a0,832
80002440:	ad9ff06f          	j	80001f18 <memset>

80002444 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002444:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002448:	00200513          	li	a0,2
{
8000244c:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002450:	e95ff0ef          	jal	ra,800022e4 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002454:	80006537          	lui	a0,0x80006
80002458:	e9850513          	addi	a0,a0,-360 # 80005e98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e99>
8000245c:	c7cff0ef          	jal	ra,800018d8 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002460:	00300513          	li	a0,3
80002464:	e81ff0ef          	jal	ra,800022e4 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002468:	620020ef          	jal	ra,80004a88 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
8000246c:	e2dff0ef          	jal	ra,80002298 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002470:	800067b7          	lui	a5,0x80006
80002474:	5cc78793          	addi	a5,a5,1484 # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
80002478:	00c7c703          	lbu	a4,12(a5)
8000247c:	ffe77713          	andi	a4,a4,-2
80002480:	00e78623          	sb	a4,12(a5)
}
80002484:	00c12083          	lw	ra,12(sp)
80002488:	01010113          	addi	sp,sp,16
8000248c:	00008067          	ret

80002490 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002490:	f6010113          	addi	sp,sp,-160
80002494:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002498:	800087b7          	lui	a5,0x80008
8000249c:	80006437          	lui	s0,0x80006
800024a0:	09312623          	sw	s3,140(sp)
800024a4:	87078793          	addi	a5,a5,-1936 # 80007870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007871>
800024a8:	63c40993          	addi	s3,s0,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
800024ac:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800024b0:	01010793          	addi	a5,sp,16
800024b4:	07000613          	li	a2,112
800024b8:	00000593          	li	a1,0
800024bc:	00078513          	mv	a0,a5
{
800024c0:	08112e23          	sw	ra,156(sp)
800024c4:	08912a23          	sw	s1,148(sp)
800024c8:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800024cc:	a4dff0ef          	jal	ra,80001f18 <memset>
800024d0:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800024d4:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800024d8:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
800024dc:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800024e0:	e05ff0ef          	jal	ra,800022e4 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
800024e4:	00100513          	li	a0,1
800024e8:	dfdff0ef          	jal	ra,800022e4 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
800024ec:	10100793          	li	a5,257
800024f0:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800024f4:	499010ef          	jal	ra,8000418c <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800024f8:	800067b7          	lui	a5,0x80006
800024fc:	edc78793          	addi	a5,a5,-292 # 80005edc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005edd>
	_kernel.ready_q.cache = _main_thread;
80002500:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
80002504:	00f12223          	sw	a5,4(sp)
80002508:	800026b7          	lui	a3,0x80002
8000250c:	00100793          	li	a5,1
80002510:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002514:	5cc90493          	addi	s1,s2,1484 # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
	z_setup_new_thread(_main_thread, _main_stack,
80002518:	00f12023          	sw	a5,0(sp)
8000251c:	00000713          	li	a4,0
80002520:	00000793          	li	a5,0
80002524:	00000893          	li	a7,0
80002528:	00000813          	li	a6,0
8000252c:	44468693          	addi	a3,a3,1092 # 80002444 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002445>
80002530:	20000613          	li	a2,512
80002534:	c7058593          	addi	a1,a1,-912 # 80006c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c71>
80002538:	5cc90513          	addi	a0,s2,1484
	_kernel.ready_q.cache = _main_thread;
8000253c:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002540:	1c4020ef          	jal	ra,80004704 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002544:	00d4c783          	lbu	a5,13(s1)
80002548:	63c40413          	addi	s0,s0,1596
8000254c:	ffb7f713          	andi	a4,a5,-5
80002550:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002554:	01b7f793          	andi	a5,a5,27
80002558:	00079a63          	bnez	a5,8000256c <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
8000255c:	0184a783          	lw	a5,24(s1)
80002560:	00079663          	bnez	a5,8000256c <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002564:	5cc90513          	addi	a0,s2,1484
80002568:	1a4010ef          	jal	ra,8000370c <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
8000256c:	800067b7          	lui	a5,0x80006
80002570:	ee478793          	addi	a5,a5,-284 # 80005ee4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee5>
80002574:	00f12223          	sw	a5,4(sp)
80002578:	80006537          	lui	a0,0x80006
8000257c:	00100793          	li	a5,1
80002580:	800026b7          	lui	a3,0x80002
80002584:	800075b7          	lui	a1,0x80007
80002588:	55c50493          	addi	s1,a0,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
8000258c:	00f12023          	sw	a5,0(sp)
80002590:	00f00893          	li	a7,15
80002594:	00000813          	li	a6,0
80002598:	00000793          	li	a5,0
8000259c:	00000713          	li	a4,0
800025a0:	3ec68693          	addi	a3,a3,1004 # 800023ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800023ed>
800025a4:	20000613          	li	a2,512
800025a8:	e7058593          	addi	a1,a1,-400 # 80006e70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e71>
800025ac:	55c50513          	addi	a0,a0,1372
800025b0:	154020ef          	jal	ra,80004704 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800025b4:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800025b8:	00942623          	sw	s1,12(s0)
800025bc:	00800513          	li	a0,8
800025c0:	ffb7f793          	andi	a5,a5,-5
800025c4:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800025c8:	800067b7          	lui	a5,0x80006
800025cc:	65478793          	addi	a5,a5,1620 # 80006654 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006655>
800025d0:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800025d4:	00f42e23          	sw	a5,28(s0)
800025d8:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800025dc:	00857513          	andi	a0,a0,8
800025e0:	c49fd0ef          	jal	ra,80000228 <__swap>

800025e4 <mbox_message_match>:
static int mbox_message_match(struct k_mbox_msg *tx_msg,
			       struct k_mbox_msg *rx_msg)
{
	u32_t temp_info;

	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
800025e4:	02052703          	lw	a4,32(a0)
{
800025e8:	00050793          	mv	a5,a0
	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
800025ec:	00070863          	beqz	a4,800025fc <mbox_message_match+0x18>
800025f0:	0205a683          	lw	a3,32(a1)
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;

		return 0;
	}

	return -1;
800025f4:	fff00513          	li	a0,-1
	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
800025f8:	06d71863          	bne	a4,a3,80002668 <mbox_message_match+0x84>
	    ((rx_msg->rx_source_thread == (k_tid_t)K_ANY) ||
800025fc:	01c5a683          	lw	a3,28(a1)
80002600:	01c7a703          	lw	a4,28(a5)
	     (tx_msg->tx_target_thread == rx_msg->tx_target_thread)) &&
80002604:	00068663          	beqz	a3,80002610 <mbox_message_match+0x2c>
	return -1;
80002608:	fff00513          	li	a0,-1
	    ((rx_msg->rx_source_thread == (k_tid_t)K_ANY) ||
8000260c:	04e69e63          	bne	a3,a4,80002668 <mbox_message_match+0x84>
		rx_msg->rx_source_thread = tx_msg->rx_source_thread;
80002610:	00e5ae23          	sw	a4,28(a1)
		tx_msg->tx_target_thread = rx_msg->tx_target_thread;
80002614:	0205a703          	lw	a4,32(a1)
		rx_msg->info = tx_msg->info;
80002618:	0087a683          	lw	a3,8(a5)
		tx_msg->tx_target_thread = rx_msg->tx_target_thread;
8000261c:	02e7a023          	sw	a4,32(a5)
		temp_info = rx_msg->info;
80002620:	0085a703          	lw	a4,8(a1)
		rx_msg->info = tx_msg->info;
80002624:	00d5a423          	sw	a3,8(a1)
		if (rx_msg->size > tx_msg->size) {
80002628:	0045a683          	lw	a3,4(a1)
		tx_msg->info = temp_info;
8000262c:	00e7a423          	sw	a4,8(a5)
		if (rx_msg->size > tx_msg->size) {
80002630:	0047a703          	lw	a4,4(a5)
80002634:	00d77463          	bgeu	a4,a3,8000263c <mbox_message_match+0x58>
			rx_msg->size = tx_msg->size;
80002638:	00e5a223          	sw	a4,4(a1)
		rx_msg->tx_block = tx_msg->tx_block;
8000263c:	0147a703          	lw	a4,20(a5)
		rx_msg->tx_data = tx_msg->tx_data;
80002640:	00c7a683          	lw	a3,12(a5)
		rx_msg->tx_block = tx_msg->tx_block;
80002644:	00e5aa23          	sw	a4,20(a1)
80002648:	0187a603          	lw	a2,24(a5)
		rx_msg->tx_data = tx_msg->tx_data;
8000264c:	00d5a623          	sw	a3,12(a1)
		rx_msg->tx_block = tx_msg->tx_block;
80002650:	00c5ac23          	sw	a2,24(a1)
		if (rx_msg->tx_data != NULL) {
80002654:	00068c63          	beqz	a3,8000266c <mbox_message_match+0x88>
			rx_msg->tx_block.data = NULL;
80002658:	0005aa23          	sw	zero,20(a1)
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;
8000265c:	0247a783          	lw	a5,36(a5)
		return 0;
80002660:	00000513          	li	a0,0
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;
80002664:	02f5a223          	sw	a5,36(a1)
}
80002668:	00008067          	ret
		} else if (rx_msg->tx_block.data != NULL) {
8000266c:	fe0708e3          	beqz	a4,8000265c <mbox_message_match+0x78>
			rx_msg->tx_data = rx_msg->tx_block.data;
80002670:	00e5a623          	sw	a4,12(a1)
80002674:	fe9ff06f          	j	8000265c <mbox_message_match+0x78>

80002678 <init_mbox_module>:
{
80002678:	ff010113          	addi	sp,sp,-16
8000267c:	00812423          	sw	s0,8(sp)
80002680:	80008437          	lui	s0,0x80008
80002684:	89840413          	addi	s0,s0,-1896 # 80007898 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007899>
80002688:	00912223          	sw	s1,4(sp)
8000268c:	01212023          	sw	s2,0(sp)
80002690:	00112623          	sw	ra,12(sp)
80002694:	34840493          	addi	s1,s0,840
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_STACK_PUSH, k_stack_push, struct k_stack *, stack, u32_t, data)
80002698:	80006937          	lui	s2,0x80006
		z_init_thread_base(&async_msg[i].thread, 0, _THREAD_DUMMY, 0);
8000269c:	00040513          	mv	a0,s0
800026a0:	00000693          	li	a3,0
800026a4:	00100613          	li	a2,1
800026a8:	00000593          	li	a1,0
800026ac:	108020ef          	jal	ra,800047b4 <z_init_thread_base>
800026b0:	00040593          	mv	a1,s0
800026b4:	32490513          	addi	a0,s2,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
800026b8:	05440413          	addi	s0,s0,84
800026bc:	671010ef          	jal	ra,8000452c <z_impl_k_stack_push>
	for (i = 0; i < CONFIG_NUM_MBOX_ASYNC_MSGS; i++) {
800026c0:	fc941ee3          	bne	s0,s1,8000269c <init_mbox_module+0x24>
}
800026c4:	00c12083          	lw	ra,12(sp)
800026c8:	00812403          	lw	s0,8(sp)
800026cc:	00412483          	lw	s1,4(sp)
800026d0:	00012903          	lw	s2,0(sp)
800026d4:	00000513          	li	a0,0
800026d8:	01010113          	addi	sp,sp,16
800026dc:	00008067          	ret

800026e0 <mbox_message_put>:
	struct k_thread *receiving_thread;
	struct k_mbox_msg *rx_msg;
	k_spinlock_key_t key;

	/* save sender id so it can be used during message matching */
	tx_msg->rx_source_thread = _current;
800026e0:	800067b7          	lui	a5,0x80006
{
800026e4:	fd010113          	addi	sp,sp,-48
	tx_msg->rx_source_thread = _current;
800026e8:	6447a783          	lw	a5,1604(a5) # 80006644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006645>
{
800026ec:	01512a23          	sw	s5,20(sp)

	/* finish readying sending thread (actual or dummy) for send */
	sending_thread = tx_msg->_syncing_thread;
800026f0:	0245aa83          	lw	s5,36(a1)
{
800026f4:	02912223          	sw	s1,36(sp)
800026f8:	03212023          	sw	s2,32(sp)
800026fc:	01312e23          	sw	s3,28(sp)
80002700:	01612823          	sw	s6,16(sp)
80002704:	01712623          	sw	s7,12(sp)
80002708:	02112623          	sw	ra,44(sp)
8000270c:	02812423          	sw	s0,40(sp)
80002710:	01412c23          	sw	s4,24(sp)
	tx_msg->rx_source_thread = _current;
80002714:	00f5ae23          	sw	a5,28(a1)
{
80002718:	00050993          	mv	s3,a0
8000271c:	00058b13          	mv	s6,a1
80002720:	00060b93          	mv	s7,a2
	sending_thread->base.swap_data = tx_msg;
80002724:	00baaa23          	sw	a1,20(s5)

	/* search mailbox's rx queue for a compatible receiver */
	key = k_spin_lock(&mbox->lock);
80002728:	01050913          	addi	s2,a0,16
8000272c:	00800493          	li	s1,8
80002730:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002734:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002738:	0084f493          	andi	s1,s1,8
8000273c:	094020ef          	jal	ra,800047d0 <z_spin_lock_valid>
80002740:	02051e63          	bnez	a0,8000277c <mbox_message_put+0x9c>
80002744:	80006437          	lui	s0,0x80006
80002748:	800065b7          	lui	a1,0x80006
8000274c:	80006537          	lui	a0,0x80006
80002750:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80002754:	04e00693          	li	a3,78
80002758:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000275c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002760:	978ff0ef          	jal	ra,800018d8 <printk>
80002764:	80006537          	lui	a0,0x80006
80002768:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
8000276c:	96cff0ef          	jal	ra,800018d8 <printk>
80002770:	04e00593          	li	a1,78
80002774:	cf840513          	addi	a0,s0,-776
80002778:	99cff0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
8000277c:	00090513          	mv	a0,s2
80002780:	0a8020ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	return list->head == list;
80002784:	0089a403          	lw	s0,8(s3)

	_WAIT_Q_FOR_EACH(&mbox->rx_msg_queue, receiving_thread) {
80002788:	00898793          	addi	a5,s3,8
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000278c:	0af41063          	bne	s0,a5,8000282c <mbox_message_put+0x14c>

		}
	}

	/* didn't find a matching receiver: don't wait for one */
	if (timeout == K_NO_WAIT) {
80002790:	120b9263          	bnez	s7,800028b4 <mbox_message_put+0x1d4>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002794:	00090513          	mv	a0,s2
80002798:	060020ef          	jal	ra,800047f8 <z_spin_unlock_valid>
8000279c:	02051e63          	bnez	a0,800027d8 <mbox_message_put+0xf8>
800027a0:	80006437          	lui	s0,0x80006
800027a4:	800065b7          	lui	a1,0x80006
800027a8:	80006537          	lui	a0,0x80006
800027ac:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800027b0:	06100693          	li	a3,97
800027b4:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800027b8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800027bc:	91cff0ef          	jal	ra,800018d8 <printk>
800027c0:	80006537          	lui	a0,0x80006
800027c4:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800027c8:	910ff0ef          	jal	ra,800018d8 <printk>
800027cc:	06100593          	li	a1,97
800027d0:	cf840513          	addi	a0,s0,-776
800027d4:	940ff0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800027d8:	3004a4f3          	csrrs	s1,mstatus,s1
		k_spin_unlock(&mbox->lock, key);
		return -ENOMSG;
800027dc:	fb000a13          	li	s4,-80
800027e0:	0a40006f          	j	80002884 <mbox_message_put+0x1a4>
			return z_pend_curr(&mbox->lock, key, NULL, K_FOREVER);
800027e4:	fff00693          	li	a3,-1
800027e8:	00000613          	li	a2,0
	}
#endif

	/* synchronous send: sender waits on tx queue for receiver or timeout */
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
}
800027ec:	02812403          	lw	s0,40(sp)
800027f0:	02c12083          	lw	ra,44(sp)
800027f4:	01c12983          	lw	s3,28(sp)
800027f8:	01812a03          	lw	s4,24(sp)
800027fc:	01412a83          	lw	s5,20(sp)
80002800:	01012b03          	lw	s6,16(sp)
80002804:	00c12b83          	lw	s7,12(sp)
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
80002808:	00048593          	mv	a1,s1
8000280c:	00090513          	mv	a0,s2
}
80002810:	02412483          	lw	s1,36(sp)
80002814:	02012903          	lw	s2,32(sp)
80002818:	03010113          	addi	sp,sp,48
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
8000281c:	6c80106f          	j	80003ee4 <z_pend_curr>
	return (node == list->tail) ? NULL : node->next;
80002820:	00c9a783          	lw	a5,12(s3)
80002824:	f6f406e3          	beq	s0,a5,80002790 <mbox_message_put+0xb0>
80002828:	00042403          	lw	s0,0(s0)
	_WAIT_Q_FOR_EACH(&mbox->rx_msg_queue, receiving_thread) {
8000282c:	f60402e3          	beqz	s0,80002790 <mbox_message_put+0xb0>
		if (mbox_message_match(tx_msg, rx_msg) == 0) {
80002830:	01442583          	lw	a1,20(s0)
80002834:	000b0513          	mv	a0,s6
80002838:	dadff0ef          	jal	ra,800025e4 <mbox_message_match>
8000283c:	00050a13          	mv	s4,a0
80002840:	fe0510e3          	bnez	a0,80002820 <mbox_message_put+0x140>
			z_unpend_thread(receiving_thread);
80002844:	00040513          	mv	a0,s0
80002848:	369000ef          	jal	ra,800033b0 <z_unpend_thread>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000284c:	00d44783          	lbu	a5,13(s0)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80002850:	06042623          	sw	zero,108(s0)
80002854:	01f7f793          	andi	a5,a5,31
80002858:	00079a63          	bnez	a5,8000286c <mbox_message_put+0x18c>
	if (z_is_thread_ready(thread)) {
8000285c:	01842783          	lw	a5,24(s0)
80002860:	00079663          	bnez	a5,8000286c <mbox_message_put+0x18c>
		z_add_thread_to_ready_q(thread);
80002864:	00040513          	mv	a0,s0
80002868:	6a5000ef          	jal	ra,8000370c <z_add_thread_to_ready_q>
			if ((sending_thread->base.thread_state & _THREAD_DUMMY)
8000286c:	00dac783          	lbu	a5,13(s5)
80002870:	0017f793          	andi	a5,a5,1
80002874:	f60788e3          	beqz	a5,800027e4 <mbox_message_put+0x104>
				z_reschedule(&mbox->lock, key);
80002878:	00048593          	mv	a1,s1
8000287c:	00090513          	mv	a0,s2
80002880:	041000ef          	jal	ra,800030c0 <z_reschedule>
}
80002884:	02c12083          	lw	ra,44(sp)
80002888:	02812403          	lw	s0,40(sp)
8000288c:	000a0513          	mv	a0,s4
80002890:	02412483          	lw	s1,36(sp)
80002894:	02012903          	lw	s2,32(sp)
80002898:	01c12983          	lw	s3,28(sp)
8000289c:	01812a03          	lw	s4,24(sp)
800028a0:	01412a83          	lw	s5,20(sp)
800028a4:	01012b03          	lw	s6,16(sp)
800028a8:	00c12b83          	lw	s7,12(sp)
800028ac:	03010113          	addi	sp,sp,48
800028b0:	00008067          	ret
	if ((sending_thread->base.thread_state & _THREAD_DUMMY) != 0U) {
800028b4:	00dac783          	lbu	a5,13(s5)
800028b8:	0017f793          	andi	a5,a5,1
800028bc:	06078263          	beqz	a5,80002920 <mbox_message_put+0x240>
		z_pend_thread(sending_thread, &mbox->tx_msg_queue, K_FOREVER);
800028c0:	000a8513          	mv	a0,s5
800028c4:	fff00613          	li	a2,-1
800028c8:	00098593          	mv	a1,s3
800028cc:	588010ef          	jal	ra,80003e54 <z_pend_thread>
800028d0:	00090513          	mv	a0,s2
800028d4:	725010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800028d8:	02051e63          	bnez	a0,80002914 <mbox_message_put+0x234>
800028dc:	80006437          	lui	s0,0x80006
800028e0:	800065b7          	lui	a1,0x80006
800028e4:	80006537          	lui	a0,0x80006
800028e8:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800028ec:	06100693          	li	a3,97
800028f0:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800028f4:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800028f8:	fe1fe0ef          	jal	ra,800018d8 <printk>
800028fc:	80006537          	lui	a0,0x80006
80002900:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80002904:	fd5fe0ef          	jal	ra,800018d8 <printk>
80002908:	06100593          	li	a1,97
8000290c:	cf840513          	addi	a0,s0,-776
80002910:	804ff0ef          	jal	ra,80001914 <assert_post_action>
80002914:	3004a4f3          	csrrs	s1,mstatus,s1
		return 0;
80002918:	00000a13          	li	s4,0
8000291c:	f69ff06f          	j	80002884 <mbox_message_put+0x1a4>
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
80002920:	000b8693          	mv	a3,s7
80002924:	00098613          	mv	a2,s3
80002928:	ec5ff06f          	j	800027ec <mbox_message_put+0x10c>

8000292c <mbox_message_dispose>:
	if (rx_msg->_syncing_thread == NULL) {
8000292c:	02452783          	lw	a5,36(a0)
80002930:	0c078263          	beqz	a5,800029f4 <mbox_message_dispose+0xc8>
	if (rx_msg->tx_block.data != NULL) {
80002934:	01452783          	lw	a5,20(a0)
{
80002938:	ff010113          	addi	sp,sp,-16
8000293c:	00812423          	sw	s0,8(sp)
80002940:	00112623          	sw	ra,12(sp)
80002944:	00050413          	mv	s0,a0
	if (rx_msg->tx_block.data != NULL) {
80002948:	00078863          	beqz	a5,80002958 <mbox_message_dispose+0x2c>
		k_mem_pool_free(&rx_msg->tx_block);
8000294c:	01450513          	addi	a0,a0,20
80002950:	4a8000ef          	jal	ra,80002df8 <k_mem_pool_free>
		rx_msg->tx_block.data = NULL;
80002954:	00042a23          	sw	zero,20(s0)
	sending_thread = rx_msg->_syncing_thread;
80002958:	02442583          	lw	a1,36(s0)
	tx_msg->size = rx_msg->size;
8000295c:	00442783          	lw	a5,4(s0)
	rx_msg->_syncing_thread = NULL;
80002960:	02042223          	sw	zero,36(s0)
	tx_msg = (struct k_mbox_msg *)sending_thread->base.swap_data;
80002964:	0145a703          	lw	a4,20(a1)
	tx_msg->size = rx_msg->size;
80002968:	00f72223          	sw	a5,4(a4)
	if ((sending_thread->base.thread_state & _THREAD_DUMMY) != 0U) {
8000296c:	00d5c783          	lbu	a5,13(a1)
80002970:	0017f793          	andi	a5,a5,1
80002974:	02078663          	beqz	a5,800029a0 <mbox_message_dispose+0x74>
		struct k_sem *async_sem = tx_msg->_async_sem;
80002978:	02872403          	lw	s0,40(a4)
8000297c:	80006537          	lui	a0,0x80006
80002980:	32450513          	addi	a0,a0,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
80002984:	3a9010ef          	jal	ra,8000452c <z_impl_k_stack_push>
		if (async_sem != NULL) {
80002988:	04040e63          	beqz	s0,800029e4 <mbox_message_dispose+0xb8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
8000298c:	00040513          	mv	a0,s0
}
80002990:	00812403          	lw	s0,8(sp)
80002994:	00c12083          	lw	ra,12(sp)
80002998:	01010113          	addi	sp,sp,16
8000299c:	0e50106f          	j	80004280 <z_impl_k_sem_give>
800029a0:	00d5c783          	lbu	a5,13(a1)
800029a4:	0605a623          	sw	zero,108(a1)
	thread->base.thread_state &= ~_THREAD_PENDING;
800029a8:	ffd7f713          	andi	a4,a5,-3
800029ac:	00e586a3          	sb	a4,13(a1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800029b0:	01d7f793          	andi	a5,a5,29
800029b4:	00079a63          	bnez	a5,800029c8 <mbox_message_dispose+0x9c>
	if (z_is_thread_ready(thread)) {
800029b8:	0185a783          	lw	a5,24(a1)
800029bc:	00079663          	bnez	a5,800029c8 <mbox_message_dispose+0x9c>
		z_add_thread_to_ready_q(thread);
800029c0:	00058513          	mv	a0,a1
800029c4:	549000ef          	jal	ra,8000370c <z_add_thread_to_ready_q>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800029c8:	00800513          	li	a0,8
800029cc:	30053573          	csrrc	a0,mstatus,a0
800029d0:	00812403          	lw	s0,8(sp)
800029d4:	00c12083          	lw	ra,12(sp)
	(void) z_reschedule_irqlock(z_arch_irq_lock());
800029d8:	00857513          	andi	a0,a0,8
800029dc:	01010113          	addi	sp,sp,16
800029e0:	7b40006f          	j	80003194 <z_reschedule_irqlock>
800029e4:	00c12083          	lw	ra,12(sp)
800029e8:	00812403          	lw	s0,8(sp)
800029ec:	01010113          	addi	sp,sp,16
800029f0:	00008067          	ret
800029f4:	00008067          	ret

800029f8 <k_mbox_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
800029f8:	00850793          	addi	a5,a0,8
	list->head = (sys_dnode_t *)list;
800029fc:	00a52023          	sw	a0,0(a0)
	list->tail = (sys_dnode_t *)list;
80002a00:	00a52223          	sw	a0,4(a0)
	list->head = (sys_dnode_t *)list;
80002a04:	00f52423          	sw	a5,8(a0)
	list->tail = (sys_dnode_t *)list;
80002a08:	00f52623          	sw	a5,12(a0)
	mbox_ptr->lock = (struct k_spinlock) {};
80002a0c:	00052823          	sw	zero,16(a0)
}
80002a10:	00008067          	ret

80002a14 <k_mbox_put>:

int k_mbox_put(struct k_mbox *mbox, struct k_mbox_msg *tx_msg, s32_t timeout)
{
	/* configure things for a synchronous send, then send the message */
	tx_msg->_syncing_thread = _current;
80002a14:	800067b7          	lui	a5,0x80006
80002a18:	6447a783          	lw	a5,1604(a5) # 80006644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006645>
80002a1c:	02f5a223          	sw	a5,36(a1)

	return mbox_message_put(mbox, tx_msg, timeout);
80002a20:	cc1ff06f          	j	800026e0 <mbox_message_put>

80002a24 <k_mbox_data_get>:
	(void)mbox_message_put(mbox, &async->tx_msg, K_FOREVER);
}
#endif

void k_mbox_data_get(struct k_mbox_msg *rx_msg, void *buffer)
{
80002a24:	ff010113          	addi	sp,sp,-16
80002a28:	00812423          	sw	s0,8(sp)
80002a2c:	00112623          	sw	ra,12(sp)
80002a30:	00050413          	mv	s0,a0
	/* handle case where data is to be discarded */
	if (buffer == NULL) {
80002a34:	00059c63          	bnez	a1,80002a4c <k_mbox_data_get+0x28>
		rx_msg->size = 0;
80002a38:	00052223          	sw	zero,4(a0)
	/* copy message data to buffer, then dispose of message */
	if ((rx_msg->tx_data != NULL) && (rx_msg->size > 0)) {
		(void)memcpy(buffer, rx_msg->tx_data, rx_msg->size);
	}
	mbox_message_dispose(rx_msg);
}
80002a3c:	00812403          	lw	s0,8(sp)
80002a40:	00c12083          	lw	ra,12(sp)
80002a44:	01010113          	addi	sp,sp,16
	mbox_message_dispose(rx_msg);
80002a48:	ee5ff06f          	j	8000292c <mbox_message_dispose>
80002a4c:	00058513          	mv	a0,a1
	if ((rx_msg->tx_data != NULL) && (rx_msg->size > 0)) {
80002a50:	00c42583          	lw	a1,12(s0)
80002a54:	00058863          	beqz	a1,80002a64 <k_mbox_data_get+0x40>
80002a58:	00442603          	lw	a2,4(s0)
80002a5c:	00060463          	beqz	a2,80002a64 <k_mbox_data_get+0x40>
		(void)memcpy(buffer, rx_msg->tx_data, rx_msg->size);
80002a60:	c18ff0ef          	jal	ra,80001e78 <memcpy>
	mbox_message_dispose(rx_msg);
80002a64:	00040513          	mv	a0,s0
80002a68:	fd5ff06f          	j	80002a3c <k_mbox_data_get+0x18>

80002a6c <k_mbox_get>:
	return 0;
}

int k_mbox_get(struct k_mbox *mbox, struct k_mbox_msg *rx_msg, void *buffer,
	       s32_t timeout)
{
80002a6c:	fd010113          	addi	sp,sp,-48
80002a70:	01612823          	sw	s6,16(sp)
	struct k_mbox_msg *tx_msg;
	k_spinlock_key_t key;
	int result;

	/* save receiver id so it can be used during message matching */
	rx_msg->tx_target_thread = _current;
80002a74:	80006b37          	lui	s6,0x80006
80002a78:	63cb0793          	addi	a5,s6,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80002a7c:	0087a783          	lw	a5,8(a5)
{
80002a80:	02812423          	sw	s0,40(sp)
80002a84:	03212023          	sw	s2,32(sp)
80002a88:	01312e23          	sw	s3,28(sp)
80002a8c:	01412c23          	sw	s4,24(sp)
80002a90:	01512a23          	sw	s5,20(sp)
80002a94:	01712623          	sw	s7,12(sp)
80002a98:	02112623          	sw	ra,44(sp)
80002a9c:	02912223          	sw	s1,36(sp)
80002aa0:	00050a13          	mv	s4,a0
80002aa4:	00058913          	mv	s2,a1
80002aa8:	00060a93          	mv	s5,a2
80002aac:	00068b93          	mv	s7,a3
	rx_msg->tx_target_thread = _current;
80002ab0:	02f5a023          	sw	a5,32(a1)

	/* search mailbox's tx queue for a compatible sender */
	key = k_spin_lock(&mbox->lock);
80002ab4:	01050993          	addi	s3,a0,16
80002ab8:	00800413          	li	s0,8
80002abc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002ac0:	00098513          	mv	a0,s3
80002ac4:	50d010ef          	jal	ra,800047d0 <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ac8:	00847413          	andi	s0,s0,8
80002acc:	63cb0b13          	addi	s6,s6,1596
80002ad0:	02051e63          	bnez	a0,80002b0c <k_mbox_get+0xa0>
80002ad4:	800064b7          	lui	s1,0x80006
80002ad8:	800065b7          	lui	a1,0x80006
80002adc:	80006537          	lui	a0,0x80006
80002ae0:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80002ae4:	04e00693          	li	a3,78
80002ae8:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80002aec:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002af0:	de9fe0ef          	jal	ra,800018d8 <printk>
80002af4:	80006537          	lui	a0,0x80006
80002af8:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80002afc:	dddfe0ef          	jal	ra,800018d8 <printk>
80002b00:	04e00593          	li	a1,78
80002b04:	cf848513          	addi	a0,s1,-776
80002b08:	e0dfe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80002b0c:	00098513          	mv	a0,s3
80002b10:	519010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	return list->head == list;
80002b14:	000a2483          	lw	s1,0(s4)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002b18:	069a1c63          	bne	s4,s1,80002b90 <k_mbox_get+0x124>
		}
	}

	/* didn't find a matching sender */

	if (timeout == K_NO_WAIT) {
80002b1c:	100b9c63          	bnez	s7,80002c34 <k_mbox_get+0x1c8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b20:	00098513          	mv	a0,s3
80002b24:	4d5010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80002b28:	02051e63          	bnez	a0,80002b64 <k_mbox_get+0xf8>
80002b2c:	800064b7          	lui	s1,0x80006
80002b30:	800065b7          	lui	a1,0x80006
80002b34:	80006537          	lui	a0,0x80006
80002b38:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002b3c:	06100693          	li	a3,97
80002b40:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80002b44:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002b48:	d91fe0ef          	jal	ra,800018d8 <printk>
80002b4c:	80006537          	lui	a0,0x80006
80002b50:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80002b54:	d85fe0ef          	jal	ra,800018d8 <printk>
80002b58:	06100593          	li	a1,97
80002b5c:	cf848513          	addi	a0,s1,-776
80002b60:	db5fe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b64:	30042473          	csrrs	s0,mstatus,s0
		/* don't wait for a matching sender to appear */
		k_spin_unlock(&mbox->lock, key);
		return -ENOMSG;
80002b68:	fb000513          	li	a0,-80
80002b6c:	09c0006f          	j	80002c08 <k_mbox_get+0x19c>
	} else if (rx_msg->size == 0) {
80002b70:	00492783          	lw	a5,4(s2)
80002b74:	08079863          	bnez	a5,80002c04 <k_mbox_get+0x198>
		mbox_message_dispose(rx_msg);
80002b78:	00090513          	mv	a0,s2
80002b7c:	db1ff0ef          	jal	ra,8000292c <mbox_message_dispose>
80002b80:	0840006f          	j	80002c04 <k_mbox_get+0x198>
	return (node == list->tail) ? NULL : node->next;
80002b84:	004a2783          	lw	a5,4(s4)
80002b88:	f8f48ae3          	beq	s1,a5,80002b1c <k_mbox_get+0xb0>
80002b8c:	0004a483          	lw	s1,0(s1)
	_WAIT_Q_FOR_EACH(&mbox->tx_msg_queue, sending_thread) {
80002b90:	f80486e3          	beqz	s1,80002b1c <k_mbox_get+0xb0>
		if (mbox_message_match(tx_msg, rx_msg) == 0) {
80002b94:	0144a503          	lw	a0,20(s1)
80002b98:	00090593          	mv	a1,s2
80002b9c:	a49ff0ef          	jal	ra,800025e4 <mbox_message_match>
80002ba0:	fe0512e3          	bnez	a0,80002b84 <k_mbox_get+0x118>
			z_unpend_thread(sending_thread);
80002ba4:	00048513          	mv	a0,s1
80002ba8:	009000ef          	jal	ra,800033b0 <z_unpend_thread>
80002bac:	00098513          	mv	a0,s3
80002bb0:	449010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80002bb4:	02051e63          	bnez	a0,80002bf0 <k_mbox_get+0x184>
80002bb8:	800064b7          	lui	s1,0x80006
80002bbc:	800065b7          	lui	a1,0x80006
80002bc0:	80006537          	lui	a0,0x80006
80002bc4:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002bc8:	06100693          	li	a3,97
80002bcc:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80002bd0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002bd4:	d05fe0ef          	jal	ra,800018d8 <printk>
80002bd8:	80006537          	lui	a0,0x80006
80002bdc:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80002be0:	cf9fe0ef          	jal	ra,800018d8 <printk>
80002be4:	06100593          	li	a1,97
80002be8:	cf848513          	addi	a0,s1,-776
80002bec:	d29fe0ef          	jal	ra,80001914 <assert_post_action>
80002bf0:	30042473          	csrrs	s0,mstatus,s0
	if (buffer != NULL) {
80002bf4:	f60a8ee3          	beqz	s5,80002b70 <k_mbox_get+0x104>
		k_mbox_data_get(rx_msg, buffer);
80002bf8:	000a8593          	mv	a1,s5
80002bfc:	00090513          	mv	a0,s2
80002c00:	e25ff0ef          	jal	ra,80002a24 <k_mbox_data_get>
			return mbox_message_data_check(rx_msg, buffer);
80002c04:	00000513          	li	a0,0
	if (result == 0) {
		result = mbox_message_data_check(rx_msg, buffer);
	}

	return result;
}
80002c08:	02c12083          	lw	ra,44(sp)
80002c0c:	02812403          	lw	s0,40(sp)
80002c10:	02412483          	lw	s1,36(sp)
80002c14:	02012903          	lw	s2,32(sp)
80002c18:	01c12983          	lw	s3,28(sp)
80002c1c:	01812a03          	lw	s4,24(sp)
80002c20:	01412a83          	lw	s5,20(sp)
80002c24:	01012b03          	lw	s6,16(sp)
80002c28:	00c12b83          	lw	s7,12(sp)
80002c2c:	03010113          	addi	sp,sp,48
80002c30:	00008067          	ret
	_current->base.swap_data = rx_msg;
80002c34:	008b2783          	lw	a5,8(s6)
	result = z_pend_curr(&mbox->lock, key, &mbox->rx_msg_queue, timeout);
80002c38:	000b8693          	mv	a3,s7
80002c3c:	008a0613          	addi	a2,s4,8
	_current->base.swap_data = rx_msg;
80002c40:	0127aa23          	sw	s2,20(a5)
	result = z_pend_curr(&mbox->lock, key, &mbox->rx_msg_queue, timeout);
80002c44:	00040593          	mv	a1,s0
80002c48:	00098513          	mv	a0,s3
80002c4c:	298010ef          	jal	ra,80003ee4 <z_pend_curr>
	if (result == 0) {
80002c50:	fa051ce3          	bnez	a0,80002c08 <k_mbox_get+0x19c>
80002c54:	fa1ff06f          	j	80002bf4 <k_mbox_get+0x188>

80002c58 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80002c58:	ff010113          	addi	sp,sp,-16
80002c5c:	00812423          	sw	s0,8(sp)
80002c60:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002c64:	80006437          	lui	s0,0x80006
80002c68:	800064b7          	lui	s1,0x80006
{
80002c6c:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002c70:	2d840413          	addi	s0,s0,728 # 800062d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d9>
80002c74:	31048493          	addi	s1,s1,784 # 80006310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006311>
80002c78:	00946e63          	bltu	s0,s1,80002c94 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80002c7c:	00c12083          	lw	ra,12(sp)
80002c80:	00812403          	lw	s0,8(sp)
80002c84:	00412483          	lw	s1,4(sp)
80002c88:	00000513          	li	a0,0
80002c8c:	01010113          	addi	sp,sp,16
80002c90:	00008067          	ret
80002c94:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80002c98:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80002c9c:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80002ca0:	00f42c23          	sw	a5,24(s0)
80002ca4:	a00fe0ef          	jal	ra,80000ea4 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002ca8:	01c40413          	addi	s0,s0,28
80002cac:	fcdff06f          	j	80002c78 <init_static_pools+0x20>

80002cb0 <k_mem_pool_free_id>:

	return -EAGAIN;
}

void k_mem_pool_free_id(struct k_mem_block_id *id)
{
80002cb0:	fe010113          	addi	sp,sp,-32
80002cb4:	01212823          	sw	s2,16(sp)
80002cb8:	00054903          	lbu	s2,0(a0)
80002cbc:	01c00793          	li	a5,28
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002cc0:	00052603          	lw	a2,0(a0)
80002cc4:	02f90933          	mul	s2,s2,a5
{
80002cc8:	01312623          	sw	s3,12(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002ccc:	800069b7          	lui	s3,0x80006
80002cd0:	00865593          	srli	a1,a2,0x8
80002cd4:	2d898513          	addi	a0,s3,728 # 800062d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d9>
80002cd8:	00c65613          	srli	a2,a2,0xc
80002cdc:	00f5f593          	andi	a1,a1,15
{
80002ce0:	00812c23          	sw	s0,24(sp)
80002ce4:	00112e23          	sw	ra,28(sp)
80002ce8:	00912a23          	sw	s1,20(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002cec:	01250533          	add	a0,a0,s2
{
80002cf0:	01412423          	sw	s4,8(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002cf4:	00800413          	li	s0,8
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002cf8:	aacfe0ef          	jal	ra,80000fa4 <z_sys_mem_pool_block_free>
80002cfc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d00:	800064b7          	lui	s1,0x80006
80002d04:	37448513          	addi	a0,s1,884 # 80006374 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006375>
80002d08:	2c9010ef          	jal	ra,800047d0 <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
80002d0c:	00847413          	andi	s0,s0,8
80002d10:	2d898993          	addi	s3,s3,728
80002d14:	02051e63          	bnez	a0,80002d50 <k_mem_pool_free_id+0xa0>
80002d18:	80006a37          	lui	s4,0x80006
80002d1c:	800065b7          	lui	a1,0x80006
80002d20:	80006537          	lui	a0,0x80006
80002d24:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80002d28:	04e00693          	li	a3,78
80002d2c:	cf8a0613          	addi	a2,s4,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80002d30:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002d34:	ba5fe0ef          	jal	ra,800018d8 <printk>
80002d38:	80006537          	lui	a0,0x80006
80002d3c:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80002d40:	b99fe0ef          	jal	ra,800018d8 <printk>
80002d44:	04e00593          	li	a1,78
80002d48:	cf8a0513          	addi	a0,s4,-776
80002d4c:	bc9fe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80002d50:	37448513          	addi	a0,s1,884
80002d54:	2d5010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80002d58:	01490513          	addi	a0,s2,20
80002d5c:	00a98533          	add	a0,s3,a0
80002d60:	3c4010ef          	jal	ra,80004124 <z_unpend_all>

	if (need_sched != 0) {
80002d64:	02050663          	beqz	a0,80002d90 <k_mem_pool_free_id+0xe0>
		z_reschedule(&lock, key);
80002d68:	00040593          	mv	a1,s0
	} else {
		k_spin_unlock(&lock, key);
	}
}
80002d6c:	01812403          	lw	s0,24(sp)
80002d70:	01c12083          	lw	ra,28(sp)
80002d74:	01012903          	lw	s2,16(sp)
80002d78:	00c12983          	lw	s3,12(sp)
80002d7c:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80002d80:	37448513          	addi	a0,s1,884
}
80002d84:	01412483          	lw	s1,20(sp)
80002d88:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80002d8c:	3340006f          	j	800030c0 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002d90:	37448513          	addi	a0,s1,884
80002d94:	265010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80002d98:	02051e63          	bnez	a0,80002dd4 <k_mem_pool_free_id+0x124>
80002d9c:	800064b7          	lui	s1,0x80006
80002da0:	800065b7          	lui	a1,0x80006
80002da4:	80006537          	lui	a0,0x80006
80002da8:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002dac:	06100693          	li	a3,97
80002db0:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80002db4:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002db8:	b21fe0ef          	jal	ra,800018d8 <printk>
80002dbc:	80006537          	lui	a0,0x80006
80002dc0:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80002dc4:	b15fe0ef          	jal	ra,800018d8 <printk>
80002dc8:	06100593          	li	a1,97
80002dcc:	cf848513          	addi	a0,s1,-776
80002dd0:	b45fe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002dd4:	30042473          	csrrs	s0,mstatus,s0
}
80002dd8:	01c12083          	lw	ra,28(sp)
80002ddc:	01812403          	lw	s0,24(sp)
80002de0:	01412483          	lw	s1,20(sp)
80002de4:	01012903          	lw	s2,16(sp)
80002de8:	00c12983          	lw	s3,12(sp)
80002dec:	00812a03          	lw	s4,8(sp)
80002df0:	02010113          	addi	sp,sp,32
80002df4:	00008067          	ret

80002df8 <k_mem_pool_free>:

void k_mem_pool_free(struct k_mem_block *block)
{
	k_mem_pool_free_id(&block->id);
80002df8:	00450513          	addi	a0,a0,4
80002dfc:	eb5ff06f          	j	80002cb0 <k_mem_pool_free_id>

80002e00 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002e00:	00d54783          	lbu	a5,13(a0)
80002e04:	01f7f793          	andi	a5,a5,31
80002e08:	00079863          	bnez	a5,80002e18 <z_is_thread_ready+0x18>
80002e0c:	01852503          	lw	a0,24(a0)
80002e10:	00153513          	seqz	a0,a0
80002e14:	00008067          	ret
80002e18:	00000513          	li	a0,0
}
80002e1c:	00008067          	ret

80002e20 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002e20:	ff010113          	addi	sp,sp,-16
80002e24:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002e28:	f3dfe0ef          	jal	ra,80001d64 <z_clock_elapsed>
80002e2c:	800067b7          	lui	a5,0x80006
80002e30:	3807a783          	lw	a5,896(a5) # 80006380 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006381>

	z_set_timeout_expiry(slice_time, false);
}
80002e34:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002e38:	80006737          	lui	a4,0x80006
80002e3c:	00a78533          	add	a0,a5,a0
80002e40:	64a72623          	sw	a0,1612(a4) # 8000664c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000664d>
	z_set_timeout_expiry(slice_time, false);
80002e44:	00000593          	li	a1,0
80002e48:	00078513          	mv	a0,a5
}
80002e4c:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002e50:	2a80206f          	j	800050f8 <z_set_timeout_expiry>

80002e54 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002e54:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002e58:	ff010113          	addi	sp,sp,-16
80002e5c:	00812423          	sw	s0,8(sp)
80002e60:	00112623          	sw	ra,12(sp)
80002e64:	00912223          	sw	s1,4(sp)
80002e68:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002e6c:	02079863          	bnez	a5,80002e9c <pended_on.isra.15+0x48>
80002e70:	800064b7          	lui	s1,0x80006
80002e74:	800065b7          	lui	a1,0x80006
80002e78:	80006537          	lui	a0,0x80006
80002e7c:	fc458593          	addi	a1,a1,-60 # 80005fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fc5>
80002e80:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002e84:	18300693          	li	a3,387
80002e88:	fb048613          	addi	a2,s1,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80002e8c:	a4dfe0ef          	jal	ra,800018d8 <printk>
80002e90:	18300593          	li	a1,387
80002e94:	fb048513          	addi	a0,s1,-80
80002e98:	a7dfe0ef          	jal	ra,80001914 <assert_post_action>

	return thread->base.pended_on;
}
80002e9c:	00042503          	lw	a0,0(s0)
80002ea0:	00c12083          	lw	ra,12(sp)
80002ea4:	00812403          	lw	s0,8(sp)
80002ea8:	00412483          	lw	s1,4(sp)
80002eac:	01010113          	addi	sp,sp,16
80002eb0:	00008067          	ret

80002eb4 <k_sched_time_slice_set>:
{
80002eb4:	fe010113          	addi	sp,sp,-32
80002eb8:	00812c23          	sw	s0,24(sp)
80002ebc:	01212823          	sw	s2,16(sp)
80002ec0:	01412423          	sw	s4,8(sp)
80002ec4:	00112e23          	sw	ra,28(sp)
80002ec8:	00912a23          	sw	s1,20(sp)
80002ecc:	01312623          	sw	s3,12(sp)
80002ed0:	00050913          	mv	s2,a0
80002ed4:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002ed8:	00800413          	li	s0,8
80002edc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002ee0:	800064b7          	lui	s1,0x80006
80002ee4:	37848513          	addi	a0,s1,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ee8:	00847413          	andi	s0,s0,8
80002eec:	0e5010ef          	jal	ra,800047d0 <z_spin_lock_valid>
80002ef0:	02051e63          	bnez	a0,80002f2c <k_sched_time_slice_set+0x78>
80002ef4:	800069b7          	lui	s3,0x80006
80002ef8:	800065b7          	lui	a1,0x80006
80002efc:	80006537          	lui	a0,0x80006
80002f00:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80002f04:	04e00693          	li	a3,78
80002f08:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80002f0c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002f10:	9c9fe0ef          	jal	ra,800018d8 <printk>
80002f14:	80006537          	lui	a0,0x80006
80002f18:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80002f1c:	9bdfe0ef          	jal	ra,800018d8 <printk>
80002f20:	04e00593          	li	a1,78
80002f24:	cf898513          	addi	a0,s3,-776
80002f28:	9edfe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80002f2c:	37848513          	addi	a0,s1,888
80002f30:	0f9010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002f34:	800067b7          	lui	a5,0x80006
80002f38:	6407a623          	sw	zero,1612(a5) # 8000664c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000664d>
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002f3c:	00990913          	addi	s2,s2,9
80002f40:	00a00793          	li	a5,10
80002f44:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
80002f48:	800067b7          	lui	a5,0x80006
80002f4c:	3927a023          	sw	s2,896(a5) # 80006380 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006381>
		slice_max_prio = prio;
80002f50:	800067b7          	lui	a5,0x80006
80002f54:	3747ae23          	sw	s4,892(a5) # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
		reset_time_slice();
80002f58:	ec9ff0ef          	jal	ra,80002e20 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002f5c:	37848513          	addi	a0,s1,888
80002f60:	099010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80002f64:	02051e63          	bnez	a0,80002fa0 <k_sched_time_slice_set+0xec>
80002f68:	800064b7          	lui	s1,0x80006
80002f6c:	800065b7          	lui	a1,0x80006
80002f70:	80006537          	lui	a0,0x80006
80002f74:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80002f78:	06100693          	li	a3,97
80002f7c:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80002f80:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80002f84:	955fe0ef          	jal	ra,800018d8 <printk>
80002f88:	80006537          	lui	a0,0x80006
80002f8c:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80002f90:	949fe0ef          	jal	ra,800018d8 <printk>
80002f94:	06100593          	li	a1,97
80002f98:	cf848513          	addi	a0,s1,-776
80002f9c:	979fe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002fa0:	30042473          	csrrs	s0,mstatus,s0
}
80002fa4:	01c12083          	lw	ra,28(sp)
80002fa8:	01812403          	lw	s0,24(sp)
80002fac:	01412483          	lw	s1,20(sp)
80002fb0:	01012903          	lw	s2,16(sp)
80002fb4:	00c12983          	lw	s3,12(sp)
80002fb8:	00812a03          	lw	s4,8(sp)
80002fbc:	02010113          	addi	sp,sp,32
80002fc0:	00008067          	ret

80002fc4 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002fc4:	fe010113          	addi	sp,sp,-32
80002fc8:	00812c23          	sw	s0,24(sp)
80002fcc:	01212823          	sw	s2,16(sp)
80002fd0:	00112e23          	sw	ra,28(sp)
80002fd4:	00912a23          	sw	s1,20(sp)
80002fd8:	01312623          	sw	s3,12(sp)
80002fdc:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002fe0:	00800413          	li	s0,8
80002fe4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fe8:	800064b7          	lui	s1,0x80006
80002fec:	37848513          	addi	a0,s1,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ff0:	00847413          	andi	s0,s0,8
80002ff4:	7dc010ef          	jal	ra,800047d0 <z_spin_lock_valid>
80002ff8:	02051e63          	bnez	a0,80003034 <z_unpend_thread_no_timeout+0x70>
80002ffc:	800069b7          	lui	s3,0x80006
80003000:	800065b7          	lui	a1,0x80006
80003004:	80006537          	lui	a0,0x80006
80003008:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
8000300c:	04e00693          	li	a3,78
80003010:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003014:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003018:	8c1fe0ef          	jal	ra,800018d8 <printk>
8000301c:	80006537          	lui	a0,0x80006
80003020:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80003024:	8b5fe0ef          	jal	ra,800018d8 <printk>
80003028:	04e00593          	li	a1,78
8000302c:	cf898513          	addi	a0,s3,-776
80003030:	8e5fe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80003034:	37848513          	addi	a0,s1,888
80003038:	7f0010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000303c:	00890513          	addi	a0,s2,8
80003040:	e15ff0ef          	jal	ra,80002e54 <pended_on.isra.15>
80003044:	00090593          	mv	a1,s2
80003048:	2f0000ef          	jal	ra,80003338 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000304c:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003050:	37848513          	addi	a0,s1,888
80003054:	ffd7f793          	andi	a5,a5,-3
80003058:	00f906a3          	sb	a5,13(s2)
8000305c:	79c010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80003060:	02051e63          	bnez	a0,8000309c <z_unpend_thread_no_timeout+0xd8>
80003064:	800064b7          	lui	s1,0x80006
80003068:	800065b7          	lui	a1,0x80006
8000306c:	80006537          	lui	a0,0x80006
80003070:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003074:	06100693          	li	a3,97
80003078:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000307c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003080:	859fe0ef          	jal	ra,800018d8 <printk>
80003084:	80006537          	lui	a0,0x80006
80003088:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
8000308c:	84dfe0ef          	jal	ra,800018d8 <printk>
80003090:	06100593          	li	a1,97
80003094:	cf848513          	addi	a0,s1,-776
80003098:	87dfe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000309c:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
800030a0:	01c12083          	lw	ra,28(sp)
800030a4:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
800030a8:	00092423          	sw	zero,8(s2)
}
800030ac:	01412483          	lw	s1,20(sp)
800030b0:	01012903          	lw	s2,16(sp)
800030b4:	00c12983          	lw	s3,12(sp)
800030b8:	02010113          	addi	sp,sp,32
800030bc:	00008067          	ret

800030c0 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
800030c0:	800067b7          	lui	a5,0x80006
800030c4:	63c7a783          	lw	a5,1596(a5) # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
{
800030c8:	ff010113          	addi	sp,sp,-16
800030cc:	00812423          	sw	s0,8(sp)
800030d0:	00112623          	sw	ra,12(sp)
800030d4:	00912223          	sw	s1,4(sp)
800030d8:	00058413          	mv	s0,a1
	if (resched()) {
800030dc:	04079e63          	bnez	a5,80003138 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800030e0:	718010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800030e4:	02051e63          	bnez	a0,80003120 <z_reschedule+0x60>
800030e8:	800064b7          	lui	s1,0x80006
800030ec:	800065b7          	lui	a1,0x80006
800030f0:	80006537          	lui	a0,0x80006
800030f4:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800030f8:	07800693          	li	a3,120
800030fc:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003100:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003104:	fd4fe0ef          	jal	ra,800018d8 <printk>
80003108:	80006537          	lui	a0,0x80006
8000310c:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003110:	fc8fe0ef          	jal	ra,800018d8 <printk>
80003114:	07800593          	li	a1,120
80003118:	cf848513          	addi	a0,s1,-776
8000311c:	ff8fe0ef          	jal	ra,80001914 <assert_post_action>
80003120:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80003124:	00812403          	lw	s0,8(sp)
80003128:	00c12083          	lw	ra,12(sp)
8000312c:	00412483          	lw	s1,4(sp)
80003130:	01010113          	addi	sp,sp,16
80003134:	8f4fd06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003138:	6c0010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
8000313c:	02051e63          	bnez	a0,80003178 <z_reschedule+0xb8>
80003140:	800064b7          	lui	s1,0x80006
80003144:	800065b7          	lui	a1,0x80006
80003148:	80006537          	lui	a0,0x80006
8000314c:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003150:	06100693          	li	a3,97
80003154:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003158:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000315c:	f7cfe0ef          	jal	ra,800018d8 <printk>
80003160:	80006537          	lui	a0,0x80006
80003164:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003168:	f70fe0ef          	jal	ra,800018d8 <printk>
8000316c:	06100593          	li	a1,97
80003170:	cf848513          	addi	a0,s1,-776
80003174:	fa0fe0ef          	jal	ra,80001914 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003178:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000317c:	30042473          	csrrs	s0,mstatus,s0
80003180:	00c12083          	lw	ra,12(sp)
80003184:	00812403          	lw	s0,8(sp)
80003188:	00412483          	lw	s1,4(sp)
8000318c:	01010113          	addi	sp,sp,16
80003190:	00008067          	ret

80003194 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003194:	80006737          	lui	a4,0x80006
80003198:	63c72703          	lw	a4,1596(a4) # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
8000319c:	00071463          	bnez	a4,800031a4 <z_reschedule_irqlock+0x10>
800031a0:	888fd06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
800031a4:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800031a8:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
800031ac:	00008067          	ret

800031b0 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800031b0:	00800513          	li	a0,8
800031b4:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
800031b8:	00857513          	andi	a0,a0,8
800031bc:	fd9ff06f          	j	80003194 <z_reschedule_irqlock>

800031c0 <k_sched_lock>:

void k_sched_lock(void)
{
800031c0:	fe010113          	addi	sp,sp,-32
800031c4:	00812c23          	sw	s0,24(sp)
800031c8:	00112e23          	sw	ra,28(sp)
800031cc:	00912a23          	sw	s1,20(sp)
800031d0:	01212823          	sw	s2,16(sp)
800031d4:	01312623          	sw	s3,12(sp)
800031d8:	00800413          	li	s0,8
800031dc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800031e0:	800064b7          	lui	s1,0x80006
800031e4:	37848513          	addi	a0,s1,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
800031e8:	00847413          	andi	s0,s0,8
800031ec:	5e4010ef          	jal	ra,800047d0 <z_spin_lock_valid>
800031f0:	02051e63          	bnez	a0,8000322c <k_sched_lock+0x6c>
800031f4:	80006937          	lui	s2,0x80006
800031f8:	800065b7          	lui	a1,0x80006
800031fc:	80006537          	lui	a0,0x80006
80003200:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80003204:	04e00693          	li	a3,78
80003208:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000320c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003210:	ec8fe0ef          	jal	ra,800018d8 <printk>
80003214:	80006537          	lui	a0,0x80006
80003218:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
8000321c:	ebcfe0ef          	jal	ra,800018d8 <printk>
80003220:	04e00593          	li	a1,78
80003224:	cf890513          	addi	a0,s2,-776
80003228:	eecfe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
8000322c:	37848513          	addi	a0,s1,888
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80003230:	80006937          	lui	s2,0x80006
80003234:	5f4010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
80003238:	63c92783          	lw	a5,1596(s2) # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
8000323c:	63c90913          	addi	s2,s2,1596
80003240:	02078e63          	beqz	a5,8000327c <k_sched_lock+0xbc>
80003244:	800069b7          	lui	s3,0x80006
80003248:	800065b7          	lui	a1,0x80006
8000324c:	80006537          	lui	a0,0x80006
80003250:	f4858593          	addi	a1,a1,-184 # 80005f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f49>
80003254:	10000693          	li	a3,256
80003258:	f2c98613          	addi	a2,s3,-212 # 80005f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f2d>
8000325c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003260:	e78fe0ef          	jal	ra,800018d8 <printk>
80003264:	80006537          	lui	a0,0x80006
80003268:	cb050513          	addi	a0,a0,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
8000326c:	e6cfe0ef          	jal	ra,800018d8 <printk>
80003270:	10000593          	li	a1,256
80003274:	f2c98513          	addi	a0,s3,-212
80003278:	e9cfe0ef          	jal	ra,80001914 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
8000327c:	00892783          	lw	a5,8(s2)
80003280:	00f7c703          	lbu	a4,15(a5)
80003284:	00100793          	li	a5,1
80003288:	02f71e63          	bne	a4,a5,800032c4 <k_sched_lock+0x104>
8000328c:	800069b7          	lui	s3,0x80006
80003290:	800065b7          	lui	a1,0x80006
80003294:	80006537          	lui	a0,0x80006
80003298:	f6058593          	addi	a1,a1,-160 # 80005f60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f61>
8000329c:	10100693          	li	a3,257
800032a0:	f2c98613          	addi	a2,s3,-212 # 80005f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f2d>
800032a4:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800032a8:	e30fe0ef          	jal	ra,800018d8 <printk>
800032ac:	80006537          	lui	a0,0x80006
800032b0:	cb050513          	addi	a0,a0,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
800032b4:	e24fe0ef          	jal	ra,800018d8 <printk>
800032b8:	10100593          	li	a1,257
800032bc:	f2c98513          	addi	a0,s3,-212
800032c0:	e54fe0ef          	jal	ra,80001914 <assert_post_action>

	--_current->base.sched_locked;
800032c4:	00892703          	lw	a4,8(s2)
800032c8:	00f74783          	lbu	a5,15(a4)
800032cc:	fff78793          	addi	a5,a5,-1
800032d0:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800032d4:	37848513          	addi	a0,s1,888
800032d8:	520010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800032dc:	02051e63          	bnez	a0,80003318 <k_sched_lock+0x158>
800032e0:	800064b7          	lui	s1,0x80006
800032e4:	800065b7          	lui	a1,0x80006
800032e8:	80006537          	lui	a0,0x80006
800032ec:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800032f0:	06100693          	li	a3,97
800032f4:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800032f8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800032fc:	ddcfe0ef          	jal	ra,800018d8 <printk>
80003300:	80006537          	lui	a0,0x80006
80003304:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003308:	dd0fe0ef          	jal	ra,800018d8 <printk>
8000330c:	06100593          	li	a1,97
80003310:	cf848513          	addi	a0,s1,-776
80003314:	e00fe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003318:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
8000331c:	01c12083          	lw	ra,28(sp)
80003320:	01812403          	lw	s0,24(sp)
80003324:	01412483          	lw	s1,20(sp)
80003328:	01012903          	lw	s2,16(sp)
8000332c:	00c12983          	lw	s3,12(sp)
80003330:	02010113          	addi	sp,sp,32
80003334:	00008067          	ret

80003338 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80003338:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
8000333c:	2987a783          	lw	a5,664(a5) # 80006298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006299>
{
80003340:	ff010113          	addi	sp,sp,-16
80003344:	00812423          	sw	s0,8(sp)
80003348:	00112623          	sw	ra,12(sp)
8000334c:	00912223          	sw	s1,4(sp)
80003350:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80003354:	02f59863          	bne	a1,a5,80003384 <z_priq_dumb_remove+0x4c>
80003358:	800064b7          	lui	s1,0x80006
8000335c:	800065b7          	lui	a1,0x80006
80003360:	80006537          	lui	a0,0x80006
80003364:	03458593          	addi	a1,a1,52 # 80006034 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006035>
80003368:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000336c:	28c00693          	li	a3,652
80003370:	fb048613          	addi	a2,s1,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80003374:	d64fe0ef          	jal	ra,800018d8 <printk>
80003378:	28c00593          	li	a1,652
8000337c:	fb048513          	addi	a0,s1,-80
80003380:	d94fe0ef          	jal	ra,80001914 <assert_post_action>
	node->prev->next = node->next;
80003384:	00442703          	lw	a4,4(s0)
80003388:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
8000338c:	00c12083          	lw	ra,12(sp)
80003390:	00412483          	lw	s1,4(sp)
80003394:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003398:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
8000339c:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
800033a0:	00042223          	sw	zero,4(s0)
800033a4:	00812403          	lw	s0,8(sp)
800033a8:	01010113          	addi	sp,sp,16
800033ac:	00008067          	ret

800033b0 <z_unpend_thread>:
{
800033b0:	fe010113          	addi	sp,sp,-32
800033b4:	00812c23          	sw	s0,24(sp)
800033b8:	00912a23          	sw	s1,20(sp)
800033bc:	00112e23          	sw	ra,28(sp)
800033c0:	01212823          	sw	s2,16(sp)
800033c4:	01312623          	sw	s3,12(sp)
800033c8:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033cc:	00800493          	li	s1,8
800033d0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033d4:	80006937          	lui	s2,0x80006
800033d8:	37890513          	addi	a0,s2,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
800033dc:	0084f493          	andi	s1,s1,8
800033e0:	3f0010ef          	jal	ra,800047d0 <z_spin_lock_valid>
800033e4:	02051e63          	bnez	a0,80003420 <z_unpend_thread+0x70>
800033e8:	800069b7          	lui	s3,0x80006
800033ec:	800065b7          	lui	a1,0x80006
800033f0:	80006537          	lui	a0,0x80006
800033f4:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
800033f8:	04e00693          	li	a3,78
800033fc:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003400:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003404:	cd4fe0ef          	jal	ra,800018d8 <printk>
80003408:	80006537          	lui	a0,0x80006
8000340c:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80003410:	cc8fe0ef          	jal	ra,800018d8 <printk>
80003414:	04e00593          	li	a1,78
80003418:	cf898513          	addi	a0,s3,-776
8000341c:	cf8fe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80003420:	37890513          	addi	a0,s2,888
80003424:	404010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003428:	00840513          	addi	a0,s0,8
8000342c:	a29ff0ef          	jal	ra,80002e54 <pended_on.isra.15>
80003430:	00040593          	mv	a1,s0
80003434:	f05ff0ef          	jal	ra,80003338 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003438:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000343c:	37890513          	addi	a0,s2,888
80003440:	ffd7f793          	andi	a5,a5,-3
80003444:	00f406a3          	sb	a5,13(s0)
80003448:	3b0010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
8000344c:	02051e63          	bnez	a0,80003488 <z_unpend_thread+0xd8>
80003450:	80006937          	lui	s2,0x80006
80003454:	800065b7          	lui	a1,0x80006
80003458:	80006537          	lui	a0,0x80006
8000345c:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003460:	06100693          	li	a3,97
80003464:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003468:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000346c:	c6cfe0ef          	jal	ra,800018d8 <printk>
80003470:	80006537          	lui	a0,0x80006
80003474:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003478:	c60fe0ef          	jal	ra,800018d8 <printk>
8000347c:	06100593          	li	a1,97
80003480:	cf890513          	addi	a0,s2,-776
80003484:	c90fe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003488:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000348c:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003490:	01840513          	addi	a0,s0,24
}
80003494:	01812403          	lw	s0,24(sp)
80003498:	01c12083          	lw	ra,28(sp)
8000349c:	01412483          	lw	s1,20(sp)
800034a0:	01012903          	lw	s2,16(sp)
800034a4:	00c12983          	lw	s3,12(sp)
800034a8:	02010113          	addi	sp,sp,32
800034ac:	2790106f          	j	80004f24 <z_abort_timeout>

800034b0 <z_priq_dumb_best>:
	return list->head == list;
800034b0:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800034b4:	00f51463          	bne	a0,a5,800034bc <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
800034b8:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
800034bc:	00078513          	mv	a0,a5
800034c0:	00008067          	ret

800034c4 <update_cache>:
{
800034c4:	ff010113          	addi	sp,sp,-16
800034c8:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800034cc:	80006437          	lui	s0,0x80006
{
800034d0:	01212023          	sw	s2,0(sp)
800034d4:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800034d8:	63c40513          	addi	a0,s0,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
800034dc:	02450513          	addi	a0,a0,36
{
800034e0:	00912223          	sw	s1,4(sp)
800034e4:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800034e8:	fc9ff0ef          	jal	ra,800034b0 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
800034ec:	63c40413          	addi	s0,s0,1596
800034f0:	00050493          	mv	s1,a0
800034f4:	00051463          	bnez	a0,800034fc <update_cache+0x38>
800034f8:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
800034fc:	06091e63          	bnez	s2,80003578 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80003500:	00842783          	lw	a5,8(s0)
80003504:	02079e63          	bnez	a5,80003540 <update_cache+0x7c>
80003508:	80006937          	lui	s2,0x80006
8000350c:	800065b7          	lui	a1,0x80006
80003510:	80006537          	lui	a0,0x80006
80003514:	fdc58593          	addi	a1,a1,-36 # 80005fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fdd>
80003518:	07f00693          	li	a3,127
8000351c:	fb090613          	addi	a2,s2,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80003520:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003524:	bb4fe0ef          	jal	ra,800018d8 <printk>
80003528:	80006537          	lui	a0,0x80006
8000352c:	cb050513          	addi	a0,a0,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
80003530:	ba8fe0ef          	jal	ra,800018d8 <printk>
80003534:	07f00593          	li	a1,127
80003538:	fb090513          	addi	a0,s2,-80
8000353c:	bd8fe0ef          	jal	ra,80001914 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003540:	00842783          	lw	a5,8(s0)
80003544:	00d7c703          	lbu	a4,13(a5)
80003548:	01f77713          	andi	a4,a4,31
8000354c:	02071663          	bnez	a4,80003578 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80003550:	00e7d683          	lhu	a3,14(a5)
80003554:	07f00713          	li	a4,127
80003558:	02d77063          	bgeu	a4,a3,80003578 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
8000355c:	02f42023          	sw	a5,32(s0)
}
80003560:	00c12083          	lw	ra,12(sp)
80003564:	00812403          	lw	s0,8(sp)
80003568:	00412483          	lw	s1,4(sp)
8000356c:	00012903          	lw	s2,0(sp)
80003570:	01010113          	addi	sp,sp,16
80003574:	00008067          	ret
		if (th != _current) {
80003578:	00842783          	lw	a5,8(s0)
8000357c:	00978463          	beq	a5,s1,80003584 <update_cache+0xc0>
			reset_time_slice();
80003580:	8a1ff0ef          	jal	ra,80002e20 <reset_time_slice>
		_kernel.ready_q.cache = th;
80003584:	02942023          	sw	s1,32(s0)
}
80003588:	fd9ff06f          	j	80003560 <update_cache+0x9c>

8000358c <k_sched_unlock>:
{
8000358c:	fe010113          	addi	sp,sp,-32
80003590:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003594:	80006937          	lui	s2,0x80006
80003598:	63c90793          	addi	a5,s2,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
8000359c:	0087a783          	lw	a5,8(a5)
{
800035a0:	00112e23          	sw	ra,28(sp)
800035a4:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800035a8:	00f7c783          	lbu	a5,15(a5)
{
800035ac:	00912a23          	sw	s1,20(sp)
800035b0:	01312623          	sw	s3,12(sp)
800035b4:	63c90913          	addi	s2,s2,1596
	__ASSERT(_current->base.sched_locked != 0, "");
800035b8:	02079e63          	bnez	a5,800035f4 <k_sched_unlock+0x68>
800035bc:	80006437          	lui	s0,0x80006
800035c0:	800065b7          	lui	a1,0x80006
800035c4:	80006537          	lui	a0,0x80006
800035c8:	f8858593          	addi	a1,a1,-120 # 80005f88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f89>
800035cc:	22100693          	li	a3,545
800035d0:	fb040613          	addi	a2,s0,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
800035d4:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800035d8:	b00fe0ef          	jal	ra,800018d8 <printk>
800035dc:	80006537          	lui	a0,0x80006
800035e0:	cb050513          	addi	a0,a0,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
800035e4:	af4fe0ef          	jal	ra,800018d8 <printk>
800035e8:	22100593          	li	a1,545
800035ec:	fb040513          	addi	a0,s0,-80
800035f0:	b24fe0ef          	jal	ra,80001914 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800035f4:	00092783          	lw	a5,0(s2)
800035f8:	02078e63          	beqz	a5,80003634 <k_sched_unlock+0xa8>
800035fc:	80006437          	lui	s0,0x80006
80003600:	800065b7          	lui	a1,0x80006
80003604:	80006537          	lui	a0,0x80006
80003608:	f4858593          	addi	a1,a1,-184 # 80005f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f49>
8000360c:	22200693          	li	a3,546
80003610:	fb040613          	addi	a2,s0,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80003614:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003618:	ac0fe0ef          	jal	ra,800018d8 <printk>
8000361c:	80006537          	lui	a0,0x80006
80003620:	cb050513          	addi	a0,a0,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
80003624:	ab4fe0ef          	jal	ra,800018d8 <printk>
80003628:	22200593          	li	a1,546
8000362c:	fb040513          	addi	a0,s0,-80
80003630:	ae4fe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003634:	00800413          	li	s0,8
80003638:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000363c:	800064b7          	lui	s1,0x80006
80003640:	37848513          	addi	a0,s1,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
80003644:	00847413          	andi	s0,s0,8
80003648:	188010ef          	jal	ra,800047d0 <z_spin_lock_valid>
8000364c:	02051e63          	bnez	a0,80003688 <k_sched_unlock+0xfc>
80003650:	800069b7          	lui	s3,0x80006
80003654:	800065b7          	lui	a1,0x80006
80003658:	80006537          	lui	a0,0x80006
8000365c:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80003660:	04e00693          	li	a3,78
80003664:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003668:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000366c:	a6cfe0ef          	jal	ra,800018d8 <printk>
80003670:	80006537          	lui	a0,0x80006
80003674:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80003678:	a60fe0ef          	jal	ra,800018d8 <printk>
8000367c:	04e00593          	li	a1,78
80003680:	cf898513          	addi	a0,s3,-776
80003684:	a90fe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80003688:	37848513          	addi	a0,s1,888
8000368c:	19c010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80003690:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003694:	00100513          	li	a0,1
		++_current->base.sched_locked;
80003698:	00f74783          	lbu	a5,15(a4)
8000369c:	00178793          	addi	a5,a5,1
800036a0:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
800036a4:	e21ff0ef          	jal	ra,800034c4 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036a8:	37848513          	addi	a0,s1,888
800036ac:	14c010ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800036b0:	02051e63          	bnez	a0,800036ec <k_sched_unlock+0x160>
800036b4:	800064b7          	lui	s1,0x80006
800036b8:	800065b7          	lui	a1,0x80006
800036bc:	80006537          	lui	a0,0x80006
800036c0:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800036c4:	06100693          	li	a3,97
800036c8:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800036cc:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800036d0:	a08fe0ef          	jal	ra,800018d8 <printk>
800036d4:	80006537          	lui	a0,0x80006
800036d8:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800036dc:	9fcfe0ef          	jal	ra,800018d8 <printk>
800036e0:	06100593          	li	a1,97
800036e4:	cf848513          	addi	a0,s1,-776
800036e8:	a2cfe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800036ec:	30042473          	csrrs	s0,mstatus,s0
}
800036f0:	01812403          	lw	s0,24(sp)
800036f4:	01c12083          	lw	ra,28(sp)
800036f8:	01412483          	lw	s1,20(sp)
800036fc:	01012903          	lw	s2,16(sp)
80003700:	00c12983          	lw	s3,12(sp)
80003704:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80003708:	aa9ff06f          	j	800031b0 <z_reschedule_unlocked>

8000370c <z_add_thread_to_ready_q>:
{
8000370c:	fe010113          	addi	sp,sp,-32
80003710:	00812c23          	sw	s0,24(sp)
80003714:	00912a23          	sw	s1,20(sp)
80003718:	00112e23          	sw	ra,28(sp)
8000371c:	01212823          	sw	s2,16(sp)
80003720:	01312623          	sw	s3,12(sp)
80003724:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003728:	00800493          	li	s1,8
8000372c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003730:	80006937          	lui	s2,0x80006
80003734:	37890513          	addi	a0,s2,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
80003738:	0084f493          	andi	s1,s1,8
8000373c:	094010ef          	jal	ra,800047d0 <z_spin_lock_valid>
80003740:	02051e63          	bnez	a0,8000377c <z_add_thread_to_ready_q+0x70>
80003744:	800069b7          	lui	s3,0x80006
80003748:	800065b7          	lui	a1,0x80006
8000374c:	80006537          	lui	a0,0x80006
80003750:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80003754:	04e00693          	li	a3,78
80003758:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000375c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003760:	978fe0ef          	jal	ra,800018d8 <printk>
80003764:	80006537          	lui	a0,0x80006
80003768:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
8000376c:	96cfe0ef          	jal	ra,800018d8 <printk>
80003770:	04e00593          	li	a1,78
80003774:	cf898513          	addi	a0,s3,-776
80003778:	99cfe0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
8000377c:	37890513          	addi	a0,s2,888
80003780:	0a8010ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003784:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003788:	2987a783          	lw	a5,664(a5) # 80006298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006299>
8000378c:	02f41863          	bne	s0,a5,800037bc <z_add_thread_to_ready_q+0xb0>
80003790:	800069b7          	lui	s3,0x80006
80003794:	800065b7          	lui	a1,0x80006
80003798:	80006537          	lui	a0,0x80006
8000379c:	03458593          	addi	a1,a1,52 # 80006034 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006035>
800037a0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800037a4:	27600693          	li	a3,630
800037a8:	fb098613          	addi	a2,s3,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
800037ac:	92cfe0ef          	jal	ra,800018d8 <printk>
800037b0:	27600593          	li	a1,630
800037b4:	fb098513          	addi	a0,s3,-80
800037b8:	95cfe0ef          	jal	ra,80001914 <assert_post_action>
	return list->head == list;
800037bc:	80006737          	lui	a4,0x80006
800037c0:	63c70693          	addi	a3,a4,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
800037c4:	0246a783          	lw	a5,36(a3)
800037c8:	0286a603          	lw	a2,40(a3)
800037cc:	800066b7          	lui	a3,0x80006
800037d0:	66068693          	addi	a3,a3,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800037d4:	63c70713          	addi	a4,a4,1596
	return sys_dlist_is_empty(list) ? NULL : list->head;
800037d8:	0ad78663          	beq	a5,a3,80003884 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800037dc:	0a078463          	beqz	a5,80003884 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
800037e0:	00e40583          	lb	a1,14(s0)
800037e4:	00e78503          	lb	a0,14(a5)
800037e8:	08a5d863          	bge	a1,a0,80003878 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
800037ec:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800037f0:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800037f4:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800037f8:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800037fc:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003800:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80003804:	00000513          	li	a0,0
80003808:	0407e793          	ori	a5,a5,64
8000380c:	00f406a3          	sb	a5,13(s0)
80003810:	cb5ff0ef          	jal	ra,800034c4 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003814:	37890513          	addi	a0,s2,888
80003818:	7e1000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
8000381c:	02051e63          	bnez	a0,80003858 <z_add_thread_to_ready_q+0x14c>
80003820:	80006437          	lui	s0,0x80006
80003824:	800065b7          	lui	a1,0x80006
80003828:	80006537          	lui	a0,0x80006
8000382c:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003830:	06100693          	li	a3,97
80003834:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003838:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000383c:	89cfe0ef          	jal	ra,800018d8 <printk>
80003840:	80006537          	lui	a0,0x80006
80003844:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003848:	890fe0ef          	jal	ra,800018d8 <printk>
8000384c:	06100593          	li	a1,97
80003850:	cf840513          	addi	a0,s0,-776
80003854:	8c0fe0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003858:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000385c:	01c12083          	lw	ra,28(sp)
80003860:	01812403          	lw	s0,24(sp)
80003864:	01412483          	lw	s1,20(sp)
80003868:	01012903          	lw	s2,16(sp)
8000386c:	00c12983          	lw	s3,12(sp)
80003870:	02010113          	addi	sp,sp,32
80003874:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003878:	00f60663          	beq	a2,a5,80003884 <z_add_thread_to_ready_q+0x178>
8000387c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003880:	f60792e3          	bnez	a5,800037e4 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003884:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003888:	02872783          	lw	a5,40(a4)
	node->next = list;
8000388c:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80003890:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003894:	02872423          	sw	s0,40(a4)
80003898:	f69ff06f          	j	80003800 <z_add_thread_to_ready_q+0xf4>

8000389c <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
8000389c:	ff052783          	lw	a5,-16(a0)
{
800038a0:	fe010113          	addi	sp,sp,-32
800038a4:	00812c23          	sw	s0,24(sp)
800038a8:	01312623          	sw	s3,12(sp)
800038ac:	00112e23          	sw	ra,28(sp)
800038b0:	00912a23          	sw	s1,20(sp)
800038b4:	01212823          	sw	s2,16(sp)
800038b8:	01412423          	sw	s4,8(sp)
800038bc:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
800038c0:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
800038c4:	0c078463          	beqz	a5,8000398c <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800038c8:	00800493          	li	s1,8
800038cc:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800038d0:	80006937          	lui	s2,0x80006
800038d4:	37890513          	addi	a0,s2,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
800038d8:	0084f493          	andi	s1,s1,8
800038dc:	6f5000ef          	jal	ra,800047d0 <z_spin_lock_valid>
800038e0:	02051e63          	bnez	a0,8000391c <z_thread_timeout+0x80>
800038e4:	80006a37          	lui	s4,0x80006
800038e8:	800065b7          	lui	a1,0x80006
800038ec:	80006537          	lui	a0,0x80006
800038f0:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
800038f4:	04e00693          	li	a3,78
800038f8:	cf8a0613          	addi	a2,s4,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800038fc:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003900:	fd9fd0ef          	jal	ra,800018d8 <printk>
80003904:	80006537          	lui	a0,0x80006
80003908:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
8000390c:	fcdfd0ef          	jal	ra,800018d8 <printk>
80003910:	04e00593          	li	a1,78
80003914:	cf8a0513          	addi	a0,s4,-776
80003918:	ffdfd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
8000391c:	37890513          	addi	a0,s2,888
80003920:	709000ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003924:	ff040513          	addi	a0,s0,-16
80003928:	d2cff0ef          	jal	ra,80002e54 <pended_on.isra.15>
8000392c:	00098593          	mv	a1,s3
80003930:	a09ff0ef          	jal	ra,80003338 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003934:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003938:	37890513          	addi	a0,s2,888
8000393c:	ffd7f793          	andi	a5,a5,-3
80003940:	fef40aa3          	sb	a5,-11(s0)
80003944:	6b5000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80003948:	02051e63          	bnez	a0,80003984 <z_thread_timeout+0xe8>
8000394c:	80006937          	lui	s2,0x80006
80003950:	800065b7          	lui	a1,0x80006
80003954:	80006537          	lui	a0,0x80006
80003958:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
8000395c:	06100693          	li	a3,97
80003960:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003964:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003968:	f71fd0ef          	jal	ra,800018d8 <printk>
8000396c:	80006537          	lui	a0,0x80006
80003970:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003974:	f65fd0ef          	jal	ra,800018d8 <printk>
80003978:	06100593          	li	a1,97
8000397c:	cf890513          	addi	a0,s2,-776
80003980:	f95fd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003984:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003988:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
8000398c:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003990:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003994:	feb7f793          	andi	a5,a5,-21
80003998:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
8000399c:	c64ff0ef          	jal	ra,80002e00 <z_is_thread_ready>
800039a0:	02050463          	beqz	a0,800039c8 <z_thread_timeout+0x12c>
}
800039a4:	01812403          	lw	s0,24(sp)
800039a8:	01c12083          	lw	ra,28(sp)
800039ac:	01412483          	lw	s1,20(sp)
800039b0:	01012903          	lw	s2,16(sp)
800039b4:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
800039b8:	00098513          	mv	a0,s3
800039bc:	00c12983          	lw	s3,12(sp)
800039c0:	02010113          	addi	sp,sp,32
800039c4:	d49ff06f          	j	8000370c <z_add_thread_to_ready_q>
800039c8:	01c12083          	lw	ra,28(sp)
800039cc:	01812403          	lw	s0,24(sp)
800039d0:	01412483          	lw	s1,20(sp)
800039d4:	01012903          	lw	s2,16(sp)
800039d8:	00c12983          	lw	s3,12(sp)
800039dc:	00812a03          	lw	s4,8(sp)
800039e0:	02010113          	addi	sp,sp,32
800039e4:	00008067          	ret

800039e8 <z_move_thread_to_end_of_prio_q>:
{
800039e8:	fe010113          	addi	sp,sp,-32
800039ec:	00812c23          	sw	s0,24(sp)
800039f0:	01212823          	sw	s2,16(sp)
800039f4:	00112e23          	sw	ra,28(sp)
800039f8:	00912a23          	sw	s1,20(sp)
800039fc:	01312623          	sw	s3,12(sp)
80003a00:	01412423          	sw	s4,8(sp)
80003a04:	01512223          	sw	s5,4(sp)
80003a08:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a0c:	00800913          	li	s2,8
80003a10:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a14:	800069b7          	lui	s3,0x80006
80003a18:	37898513          	addi	a0,s3,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a1c:	00897913          	andi	s2,s2,8
80003a20:	5b1000ef          	jal	ra,800047d0 <z_spin_lock_valid>
80003a24:	02051e63          	bnez	a0,80003a60 <z_move_thread_to_end_of_prio_q+0x78>
80003a28:	800064b7          	lui	s1,0x80006
80003a2c:	800065b7          	lui	a1,0x80006
80003a30:	80006537          	lui	a0,0x80006
80003a34:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80003a38:	04e00693          	li	a3,78
80003a3c:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003a40:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003a44:	e95fd0ef          	jal	ra,800018d8 <printk>
80003a48:	80006537          	lui	a0,0x80006
80003a4c:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80003a50:	e89fd0ef          	jal	ra,800018d8 <printk>
80003a54:	04e00593          	li	a1,78
80003a58:	cf848513          	addi	a0,s1,-776
80003a5c:	eb9fd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80003a60:	37898513          	addi	a0,s3,888
80003a64:	5c5000ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003a68:	800064b7          	lui	s1,0x80006
80003a6c:	63c48513          	addi	a0,s1,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80003a70:	00040593          	mv	a1,s0
80003a74:	02450513          	addi	a0,a0,36
80003a78:	8c1ff0ef          	jal	ra,80003338 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003a7c:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003a80:	2987a783          	lw	a5,664(a5) # 80006298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006299>
80003a84:	80006a37          	lui	s4,0x80006
80003a88:	63c48493          	addi	s1,s1,1596
80003a8c:	660a0a13          	addi	s4,s4,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80003a90:	02f41863          	bne	s0,a5,80003ac0 <z_move_thread_to_end_of_prio_q+0xd8>
80003a94:	80006ab7          	lui	s5,0x80006
80003a98:	800065b7          	lui	a1,0x80006
80003a9c:	80006537          	lui	a0,0x80006
80003aa0:	03458593          	addi	a1,a1,52 # 80006034 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006035>
80003aa4:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003aa8:	27600693          	li	a3,630
80003aac:	fb0a8613          	addi	a2,s5,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80003ab0:	e29fd0ef          	jal	ra,800018d8 <printk>
80003ab4:	27600593          	li	a1,630
80003ab8:	fb0a8513          	addi	a0,s5,-80
80003abc:	e59fd0ef          	jal	ra,80001914 <assert_post_action>
	return list->head == list;
80003ac0:	0244a783          	lw	a5,36(s1)
80003ac4:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003ac8:	0b478e63          	beq	a5,s4,80003b84 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003acc:	0a078c63          	beqz	a5,80003b84 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003ad0:	00e40683          	lb	a3,14(s0)
80003ad4:	00e78603          	lb	a2,14(a5)
80003ad8:	0ac6d063          	bge	a3,a2,80003b78 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003adc:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003ae0:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003ae4:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003ae8:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003aec:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003af0:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003af4:	0084a503          	lw	a0,8(s1)
80003af8:	0407e793          	ori	a5,a5,64
80003afc:	40850533          	sub	a0,a0,s0
80003b00:	00153513          	seqz	a0,a0
80003b04:	00f406a3          	sb	a5,13(s0)
80003b08:	9bdff0ef          	jal	ra,800034c4 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b0c:	37898513          	addi	a0,s3,888
80003b10:	4e9000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80003b14:	02051e63          	bnez	a0,80003b50 <z_move_thread_to_end_of_prio_q+0x168>
80003b18:	80006437          	lui	s0,0x80006
80003b1c:	800065b7          	lui	a1,0x80006
80003b20:	80006537          	lui	a0,0x80006
80003b24:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003b28:	06100693          	li	a3,97
80003b2c:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003b30:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003b34:	da5fd0ef          	jal	ra,800018d8 <printk>
80003b38:	80006537          	lui	a0,0x80006
80003b3c:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003b40:	d99fd0ef          	jal	ra,800018d8 <printk>
80003b44:	06100593          	li	a1,97
80003b48:	cf840513          	addi	a0,s0,-776
80003b4c:	dc9fd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003b50:	30092973          	csrrs	s2,mstatus,s2
}
80003b54:	01c12083          	lw	ra,28(sp)
80003b58:	01812403          	lw	s0,24(sp)
80003b5c:	01412483          	lw	s1,20(sp)
80003b60:	01012903          	lw	s2,16(sp)
80003b64:	00c12983          	lw	s3,12(sp)
80003b68:	00812a03          	lw	s4,8(sp)
80003b6c:	00412a83          	lw	s5,4(sp)
80003b70:	02010113          	addi	sp,sp,32
80003b74:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003b78:	00e78663          	beq	a5,a4,80003b84 <z_move_thread_to_end_of_prio_q+0x19c>
80003b7c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003b80:	f4079ae3          	bnez	a5,80003ad4 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003b84:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003b88:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003b8c:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003b90:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003b94:	0284a423          	sw	s0,40(s1)
80003b98:	f59ff06f          	j	80003af0 <z_move_thread_to_end_of_prio_q+0x108>

80003b9c <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003b9c:	800067b7          	lui	a5,0x80006
80003ba0:	3807a783          	lw	a5,896(a5) # 80006380 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006381>
80003ba4:	06078663          	beqz	a5,80003c10 <z_time_slice+0x74>
80003ba8:	800067b7          	lui	a5,0x80006
80003bac:	63c78793          	addi	a5,a5,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80003bb0:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003bb4:	07f00693          	li	a3,127
80003bb8:	00e75603          	lhu	a2,14(a4)
80003bbc:	04c6ea63          	bltu	a3,a2,80003c10 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003bc0:	800066b7          	lui	a3,0x80006
80003bc4:	00e70603          	lb	a2,14(a4)
80003bc8:	37c6a683          	lw	a3,892(a3) # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
80003bcc:	04d64263          	blt	a2,a3,80003c10 <z_time_slice+0x74>
	return thread == _idle_thread;
80003bd0:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
80003bd4:	2986a683          	lw	a3,664(a3) # 80006298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006299>
80003bd8:	02d70c63          	beq	a4,a3,80003c10 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80003bdc:	01872683          	lw	a3,24(a4)
80003be0:	02069863          	bnez	a3,80003c10 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003be4:	0107a683          	lw	a3,16(a5)
80003be8:	02d54063          	blt	a0,a3,80003c08 <z_time_slice+0x6c>
{
80003bec:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003bf0:	00070513          	mv	a0,a4
{
80003bf4:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003bf8:	df1ff0ef          	jal	ra,800039e8 <z_move_thread_to_end_of_prio_q>
}
80003bfc:	00c12083          	lw	ra,12(sp)
80003c00:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003c04:	a1cff06f          	j	80002e20 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003c08:	40a686b3          	sub	a3,a3,a0
80003c0c:	00d7a823          	sw	a3,16(a5)
80003c10:	00008067          	ret

80003c14 <z_remove_thread_from_ready_q>:
{
80003c14:	fe010113          	addi	sp,sp,-32
80003c18:	00812c23          	sw	s0,24(sp)
80003c1c:	01312623          	sw	s3,12(sp)
80003c20:	00112e23          	sw	ra,28(sp)
80003c24:	00912a23          	sw	s1,20(sp)
80003c28:	01212823          	sw	s2,16(sp)
80003c2c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c30:	00800413          	li	s0,8
80003c34:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c38:	800064b7          	lui	s1,0x80006
80003c3c:	37848513          	addi	a0,s1,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c40:	00847413          	andi	s0,s0,8
80003c44:	38d000ef          	jal	ra,800047d0 <z_spin_lock_valid>
80003c48:	02051e63          	bnez	a0,80003c84 <z_remove_thread_from_ready_q+0x70>
80003c4c:	80006937          	lui	s2,0x80006
80003c50:	800065b7          	lui	a1,0x80006
80003c54:	80006537          	lui	a0,0x80006
80003c58:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80003c5c:	04e00693          	li	a3,78
80003c60:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003c64:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003c68:	c71fd0ef          	jal	ra,800018d8 <printk>
80003c6c:	80006537          	lui	a0,0x80006
80003c70:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80003c74:	c65fd0ef          	jal	ra,800018d8 <printk>
80003c78:	04e00593          	li	a1,78
80003c7c:	cf890513          	addi	a0,s2,-776
80003c80:	c95fd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c84:	37848513          	addi	a0,s1,888
80003c88:	3a1000ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003c8c:	00d9c783          	lbu	a5,13(s3)
80003c90:	80006937          	lui	s2,0x80006
80003c94:	63c90913          	addi	s2,s2,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80003c98:	0407f793          	andi	a5,a5,64
80003c9c:	00078e63          	beqz	a5,80003cb8 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003ca0:	00098593          	mv	a1,s3
80003ca4:	02490513          	addi	a0,s2,36
80003ca8:	e90ff0ef          	jal	ra,80003338 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003cac:	00d9c783          	lbu	a5,13(s3)
80003cb0:	fbf7f793          	andi	a5,a5,-65
80003cb4:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003cb8:	00892503          	lw	a0,8(s2)
80003cbc:	41350533          	sub	a0,a0,s3
80003cc0:	00153513          	seqz	a0,a0
80003cc4:	801ff0ef          	jal	ra,800034c4 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003cc8:	37848513          	addi	a0,s1,888
80003ccc:	32d000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80003cd0:	02051e63          	bnez	a0,80003d0c <z_remove_thread_from_ready_q+0xf8>
80003cd4:	800064b7          	lui	s1,0x80006
80003cd8:	800065b7          	lui	a1,0x80006
80003cdc:	80006537          	lui	a0,0x80006
80003ce0:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003ce4:	06100693          	li	a3,97
80003ce8:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003cec:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003cf0:	be9fd0ef          	jal	ra,800018d8 <printk>
80003cf4:	80006537          	lui	a0,0x80006
80003cf8:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003cfc:	bddfd0ef          	jal	ra,800018d8 <printk>
80003d00:	06100593          	li	a1,97
80003d04:	cf848513          	addi	a0,s1,-776
80003d08:	c0dfd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003d0c:	30042473          	csrrs	s0,mstatus,s0
}
80003d10:	01c12083          	lw	ra,28(sp)
80003d14:	01812403          	lw	s0,24(sp)
80003d18:	01412483          	lw	s1,20(sp)
80003d1c:	01012903          	lw	s2,16(sp)
80003d20:	00c12983          	lw	s3,12(sp)
80003d24:	02010113          	addi	sp,sp,32
80003d28:	00008067          	ret

80003d2c <pend>:
{
80003d2c:	fe010113          	addi	sp,sp,-32
80003d30:	00812c23          	sw	s0,24(sp)
80003d34:	00912a23          	sw	s1,20(sp)
80003d38:	00050413          	mv	s0,a0
80003d3c:	01212823          	sw	s2,16(sp)
80003d40:	00112e23          	sw	ra,28(sp)
80003d44:	01312623          	sw	s3,12(sp)
80003d48:	00058493          	mv	s1,a1
80003d4c:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003d50:	ec5ff0ef          	jal	ra,80003c14 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003d54:	00d44783          	lbu	a5,13(s0)
80003d58:	0027e793          	ori	a5,a5,2
80003d5c:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003d60:	06048663          	beqz	s1,80003dcc <pend+0xa0>
	return thread == _idle_thread;
80003d64:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003d68:	2987a783          	lw	a5,664(a5) # 80006298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006299>
		thread->base.pended_on = wait_q;
80003d6c:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003d70:	02f41863          	bne	s0,a5,80003da0 <pend+0x74>
80003d74:	800069b7          	lui	s3,0x80006
80003d78:	800065b7          	lui	a1,0x80006
80003d7c:	80006537          	lui	a0,0x80006
80003d80:	03458593          	addi	a1,a1,52 # 80006034 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006035>
80003d84:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003d88:	27600693          	li	a3,630
80003d8c:	fb098613          	addi	a2,s3,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80003d90:	b49fd0ef          	jal	ra,800018d8 <printk>
80003d94:	27600593          	li	a1,630
80003d98:	fb098513          	addi	a0,s3,-80
80003d9c:	b79fd0ef          	jal	ra,80001914 <assert_post_action>
	return list->head == list;
80003da0:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003da4:	06f48c63          	beq	s1,a5,80003e1c <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003da8:	06078a63          	beqz	a5,80003e1c <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80003dac:	00e40703          	lb	a4,14(s0)
80003db0:	00e78683          	lb	a3,14(a5)
80003db4:	04d75c63          	bge	a4,a3,80003e0c <pend+0xe0>
	node->prev = successor->prev;
80003db8:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003dbc:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003dc0:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003dc4:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003dc8:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003dcc:	fff00793          	li	a5,-1
80003dd0:	06f90463          	beq	s2,a5,80003e38 <pend+0x10c>
80003dd4:	00990913          	addi	s2,s2,9
80003dd8:	00a00613          	li	a2,10
80003ddc:	02c94633          	div	a2,s2,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003de0:	01840513          	addi	a0,s0,24
}
80003de4:	01812403          	lw	s0,24(sp)
80003de8:	01c12083          	lw	ra,28(sp)
80003dec:	01412483          	lw	s1,20(sp)
80003df0:	01012903          	lw	s2,16(sp)
80003df4:	00c12983          	lw	s3,12(sp)
80003df8:	800045b7          	lui	a1,0x80004
80003dfc:	89c58593          	addi	a1,a1,-1892 # 8000389c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000389d>
80003e00:	02010113          	addi	sp,sp,32
80003e04:	00160613          	addi	a2,a2,1
80003e08:	6f10006f          	j	80004cf8 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003e0c:	0044a683          	lw	a3,4(s1)
80003e10:	00d78663          	beq	a5,a3,80003e1c <pend+0xf0>
80003e14:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003e18:	f8079ce3          	bnez	a5,80003db0 <pend+0x84>
	node->prev = list->tail;
80003e1c:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003e20:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003e24:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003e28:	0044a783          	lw	a5,4(s1)
80003e2c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003e30:	0084a223          	sw	s0,4(s1)
80003e34:	f99ff06f          	j	80003dcc <pend+0xa0>
}
80003e38:	01c12083          	lw	ra,28(sp)
80003e3c:	01812403          	lw	s0,24(sp)
80003e40:	01412483          	lw	s1,20(sp)
80003e44:	01012903          	lw	s2,16(sp)
80003e48:	00c12983          	lw	s3,12(sp)
80003e4c:	02010113          	addi	sp,sp,32
80003e50:	00008067          	ret

80003e54 <z_pend_thread>:
	__ASSERT_NO_MSG(thread == _current || is_thread_dummy(thread));
80003e54:	800067b7          	lui	a5,0x80006
80003e58:	6447a783          	lw	a5,1604(a5) # 80006644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006645>
{
80003e5c:	fe010113          	addi	sp,sp,-32
80003e60:	00812c23          	sw	s0,24(sp)
80003e64:	01212823          	sw	s2,16(sp)
80003e68:	01312623          	sw	s3,12(sp)
80003e6c:	00112e23          	sw	ra,28(sp)
80003e70:	00912a23          	sw	s1,20(sp)
80003e74:	00050413          	mv	s0,a0
80003e78:	00058913          	mv	s2,a1
80003e7c:	00060993          	mv	s3,a2
	__ASSERT_NO_MSG(thread == _current || is_thread_dummy(thread));
80003e80:	02a78e63          	beq	a5,a0,80003ebc <z_pend_thread+0x68>
80003e84:	00d54783          	lbu	a5,13(a0)
80003e88:	0017f793          	andi	a5,a5,1
80003e8c:	02079863          	bnez	a5,80003ebc <z_pend_thread+0x68>
80003e90:	800064b7          	lui	s1,0x80006
80003e94:	800065b7          	lui	a1,0x80006
80003e98:	80006537          	lui	a0,0x80006
80003e9c:	ffc58593          	addi	a1,a1,-4 # 80005ffc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ffd>
80003ea0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003ea4:	17d00693          	li	a3,381
80003ea8:	fb048613          	addi	a2,s1,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80003eac:	a2dfd0ef          	jal	ra,800018d8 <printk>
80003eb0:	17d00593          	li	a1,381
80003eb4:	fb048513          	addi	a0,s1,-80
80003eb8:	a5dfd0ef          	jal	ra,80001914 <assert_post_action>
	pend(thread, wait_q, timeout);
80003ebc:	00040513          	mv	a0,s0
}
80003ec0:	01812403          	lw	s0,24(sp)
80003ec4:	01c12083          	lw	ra,28(sp)
80003ec8:	01412483          	lw	s1,20(sp)
	pend(thread, wait_q, timeout);
80003ecc:	00098613          	mv	a2,s3
80003ed0:	00090593          	mv	a1,s2
}
80003ed4:	00c12983          	lw	s3,12(sp)
80003ed8:	01012903          	lw	s2,16(sp)
80003edc:	02010113          	addi	sp,sp,32
	pend(thread, wait_q, timeout);
80003ee0:	e4dff06f          	j	80003d2c <pend>

80003ee4 <z_pend_curr>:
{
80003ee4:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003ee8:	800067b7          	lui	a5,0x80006
{
80003eec:	00812423          	sw	s0,8(sp)
80003ef0:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003ef4:	6447a503          	lw	a0,1604(a5) # 80006644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006645>
{
80003ef8:	00912223          	sw	s1,4(sp)
80003efc:	00058493          	mv	s1,a1
80003f00:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003f04:	00068613          	mv	a2,a3
{
80003f08:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003f0c:	e21ff0ef          	jal	ra,80003d2c <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f10:	00040513          	mv	a0,s0
80003f14:	0e5000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80003f18:	02051e63          	bnez	a0,80003f54 <z_pend_curr+0x70>
80003f1c:	80006437          	lui	s0,0x80006
80003f20:	800065b7          	lui	a1,0x80006
80003f24:	80006537          	lui	a0,0x80006
80003f28:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80003f2c:	07800693          	li	a3,120
80003f30:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003f34:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003f38:	9a1fd0ef          	jal	ra,800018d8 <printk>
80003f3c:	80006537          	lui	a0,0x80006
80003f40:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80003f44:	995fd0ef          	jal	ra,800018d8 <printk>
80003f48:	07800593          	li	a1,120
80003f4c:	cf840513          	addi	a0,s0,-776
80003f50:	9c5fd0ef          	jal	ra,80001914 <assert_post_action>
}
80003f54:	00812403          	lw	s0,8(sp)
80003f58:	00c12083          	lw	ra,12(sp)
80003f5c:	00048513          	mv	a0,s1
80003f60:	00412483          	lw	s1,4(sp)
80003f64:	01010113          	addi	sp,sp,16
80003f68:	ac0fc06f          	j	80000228 <__swap>

80003f6c <z_unpend_first_thread>:
{
80003f6c:	fe010113          	addi	sp,sp,-32
80003f70:	01212823          	sw	s2,16(sp)
80003f74:	01312623          	sw	s3,12(sp)
80003f78:	00112e23          	sw	ra,28(sp)
80003f7c:	00812c23          	sw	s0,24(sp)
80003f80:	00912a23          	sw	s1,20(sp)
80003f84:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f88:	00800913          	li	s2,8
80003f8c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f90:	800064b7          	lui	s1,0x80006
80003f94:	37848513          	addi	a0,s1,888 # 80006378 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006379>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f98:	00897913          	andi	s2,s2,8
80003f9c:	035000ef          	jal	ra,800047d0 <z_spin_lock_valid>
80003fa0:	02051e63          	bnez	a0,80003fdc <z_unpend_first_thread+0x70>
80003fa4:	80006437          	lui	s0,0x80006
80003fa8:	800065b7          	lui	a1,0x80006
80003fac:	80006537          	lui	a0,0x80006
80003fb0:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80003fb4:	04e00693          	li	a3,78
80003fb8:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80003fbc:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80003fc0:	919fd0ef          	jal	ra,800018d8 <printk>
80003fc4:	80006537          	lui	a0,0x80006
80003fc8:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80003fcc:	90dfd0ef          	jal	ra,800018d8 <printk>
80003fd0:	04e00593          	li	a1,78
80003fd4:	cf840513          	addi	a0,s0,-776
80003fd8:	93dfd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80003fdc:	37848513          	addi	a0,s1,888
80003fe0:	049000ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003fe4:	00098513          	mv	a0,s3
80003fe8:	cc8ff0ef          	jal	ra,800034b0 <z_priq_dumb_best>
80003fec:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ff0:	37848513          	addi	a0,s1,888
80003ff4:	005000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80003ff8:	02051e63          	bnez	a0,80004034 <z_unpend_first_thread+0xc8>
80003ffc:	800069b7          	lui	s3,0x80006
80004000:	800065b7          	lui	a1,0x80006
80004004:	80006537          	lui	a0,0x80006
80004008:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
8000400c:	06100693          	li	a3,97
80004010:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004014:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004018:	8c1fd0ef          	jal	ra,800018d8 <printk>
8000401c:	80006537          	lui	a0,0x80006
80004020:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80004024:	8b5fd0ef          	jal	ra,800018d8 <printk>
80004028:	06100593          	li	a1,97
8000402c:	cf898513          	addi	a0,s3,-776
80004030:	8e5fd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004034:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004038:	0c040663          	beqz	s0,80004104 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000403c:	00800913          	li	s2,8
80004040:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004044:	37848513          	addi	a0,s1,888
	key = (mstatus & SOC_MSTATUS_IEN);
80004048:	00897913          	andi	s2,s2,8
8000404c:	784000ef          	jal	ra,800047d0 <z_spin_lock_valid>
80004050:	02051e63          	bnez	a0,8000408c <z_unpend_first_thread+0x120>
80004054:	800069b7          	lui	s3,0x80006
80004058:	800065b7          	lui	a1,0x80006
8000405c:	80006537          	lui	a0,0x80006
80004060:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80004064:	04e00693          	li	a3,78
80004068:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000406c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004070:	869fd0ef          	jal	ra,800018d8 <printk>
80004074:	80006537          	lui	a0,0x80006
80004078:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
8000407c:	85dfd0ef          	jal	ra,800018d8 <printk>
80004080:	04e00593          	li	a1,78
80004084:	cf898513          	addi	a0,s3,-776
80004088:	88dfd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
8000408c:	37848513          	addi	a0,s1,888
80004090:	798000ef          	jal	ra,80004828 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004094:	00840513          	addi	a0,s0,8
80004098:	dbdfe0ef          	jal	ra,80002e54 <pended_on.isra.15>
8000409c:	00040593          	mv	a1,s0
800040a0:	a98ff0ef          	jal	ra,80003338 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800040a4:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800040a8:	37848513          	addi	a0,s1,888
800040ac:	ffd7f793          	andi	a5,a5,-3
800040b0:	00f406a3          	sb	a5,13(s0)
800040b4:	744000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800040b8:	02051e63          	bnez	a0,800040f4 <z_unpend_first_thread+0x188>
800040bc:	800064b7          	lui	s1,0x80006
800040c0:	800065b7          	lui	a1,0x80006
800040c4:	80006537          	lui	a0,0x80006
800040c8:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800040cc:	06100693          	li	a3,97
800040d0:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800040d4:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800040d8:	801fd0ef          	jal	ra,800018d8 <printk>
800040dc:	80006537          	lui	a0,0x80006
800040e0:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800040e4:	ff4fd0ef          	jal	ra,800018d8 <printk>
800040e8:	06100593          	li	a1,97
800040ec:	cf848513          	addi	a0,s1,-776
800040f0:	825fd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800040f4:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
800040f8:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
800040fc:	01840513          	addi	a0,s0,24
80004100:	625000ef          	jal	ra,80004f24 <z_abort_timeout>
}
80004104:	00040513          	mv	a0,s0
80004108:	01c12083          	lw	ra,28(sp)
8000410c:	01812403          	lw	s0,24(sp)
80004110:	01412483          	lw	s1,20(sp)
80004114:	01012903          	lw	s2,16(sp)
80004118:	00c12983          	lw	s3,12(sp)
8000411c:	02010113          	addi	sp,sp,32
80004120:	00008067          	ret

80004124 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80004124:	ff010113          	addi	sp,sp,-16
80004128:	00912223          	sw	s1,4(sp)
8000412c:	01212023          	sw	s2,0(sp)
80004130:	00112623          	sw	ra,12(sp)
80004134:	00812423          	sw	s0,8(sp)
80004138:	00050913          	mv	s2,a0
	int need_sched = 0;
8000413c:	00000493          	li	s1,0
	return list->head == list;
80004140:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004144:	00890463          	beq	s2,s0,8000414c <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80004148:	02041063          	bnez	s0,80004168 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
8000414c:	00c12083          	lw	ra,12(sp)
80004150:	00812403          	lw	s0,8(sp)
80004154:	00048513          	mv	a0,s1
80004158:	00012903          	lw	s2,0(sp)
8000415c:	00412483          	lw	s1,4(sp)
80004160:	01010113          	addi	sp,sp,16
80004164:	00008067          	ret
		z_unpend_thread(th);
80004168:	00040513          	mv	a0,s0
8000416c:	a44ff0ef          	jal	ra,800033b0 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80004170:	00040513          	mv	a0,s0
80004174:	c8dfe0ef          	jal	ra,80002e00 <z_is_thread_ready>
		need_sched = 1;
80004178:	00100493          	li	s1,1
8000417c:	fc0502e3          	beqz	a0,80004140 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80004180:	00040513          	mv	a0,s0
80004184:	d88ff0ef          	jal	ra,8000370c <z_add_thread_to_ready_q>
80004188:	fb9ff06f          	j	80004140 <z_unpend_all+0x1c>

8000418c <z_sched_init>:
	list->head = (sys_dnode_t *)list;
8000418c:	800067b7          	lui	a5,0x80006
80004190:	63c78793          	addi	a5,a5,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80004194:	02478713          	addi	a4,a5,36
80004198:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
8000419c:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
800041a0:	00000593          	li	a1,0
800041a4:	00000513          	li	a0,0
800041a8:	d0dfe06f          	j	80002eb4 <k_sched_time_slice_set>

800041ac <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800041ac:	800067b7          	lui	a5,0x80006
800041b0:	6447a503          	lw	a0,1604(a5) # 80006644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006645>
800041b4:	00008067          	ret

800041b8 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800041b8:	fe010113          	addi	sp,sp,-32
800041bc:	00812c23          	sw	s0,24(sp)
800041c0:	00912a23          	sw	s1,20(sp)
800041c4:	01212823          	sw	s2,16(sp)
800041c8:	00112e23          	sw	ra,28(sp)
800041cc:	01312623          	sw	s3,12(sp)
800041d0:	00050413          	mv	s0,a0
800041d4:	00058913          	mv	s2,a1
800041d8:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
800041dc:	02061e63          	bnez	a2,80004218 <z_impl_k_sem_init+0x60>
800041e0:	800069b7          	lui	s3,0x80006
800041e4:	800065b7          	lui	a1,0x80006
800041e8:	80006537          	lui	a0,0x80006
800041ec:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800041f0:	04600693          	li	a3,70
800041f4:	04898613          	addi	a2,s3,72 # 80006048 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006049>
800041f8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800041fc:	edcfd0ef          	jal	ra,800018d8 <printk>
80004200:	80006537          	lui	a0,0x80006
80004204:	06450513          	addi	a0,a0,100 # 80006064 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006065>
80004208:	ed0fd0ef          	jal	ra,800018d8 <printk>
8000420c:	04600593          	li	a1,70
80004210:	04898513          	addi	a0,s3,72
80004214:	f00fd0ef          	jal	ra,80001914 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80004218:	0324fe63          	bgeu	s1,s2,80004254 <z_impl_k_sem_init+0x9c>
8000421c:	800069b7          	lui	s3,0x80006
80004220:	800065b7          	lui	a1,0x80006
80004224:	80006537          	lui	a0,0x80006
80004228:	07c58593          	addi	a1,a1,124 # 8000607c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000607d>
8000422c:	04700693          	li	a3,71
80004230:	04898613          	addi	a2,s3,72 # 80006048 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006049>
80004234:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004238:	ea0fd0ef          	jal	ra,800018d8 <printk>
8000423c:	80006537          	lui	a0,0x80006
80004240:	09450513          	addi	a0,a0,148 # 80006094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006095>
80004244:	e94fd0ef          	jal	ra,800018d8 <printk>
80004248:	04700593          	li	a1,71
8000424c:	04898513          	addi	a0,s3,72
80004250:	ec4fd0ef          	jal	ra,80001914 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80004254:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80004258:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
8000425c:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80004260:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80004264:	01c12083          	lw	ra,28(sp)
80004268:	01812403          	lw	s0,24(sp)
8000426c:	01412483          	lw	s1,20(sp)
80004270:	01012903          	lw	s2,16(sp)
80004274:	00c12983          	lw	s3,12(sp)
80004278:	02010113          	addi	sp,sp,32
8000427c:	00008067          	ret

80004280 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80004280:	fe010113          	addi	sp,sp,-32
80004284:	00912a23          	sw	s1,20(sp)
80004288:	01312623          	sw	s3,12(sp)
8000428c:	00112e23          	sw	ra,28(sp)
80004290:	00812c23          	sw	s0,24(sp)
80004294:	01212823          	sw	s2,16(sp)
80004298:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000429c:	00800493          	li	s1,8
800042a0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800042a4:	80006437          	lui	s0,0x80006
800042a8:	38440513          	addi	a0,s0,900 # 80006384 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006385>
	key = (mstatus & SOC_MSTATUS_IEN);
800042ac:	0084f493          	andi	s1,s1,8
800042b0:	520000ef          	jal	ra,800047d0 <z_spin_lock_valid>
800042b4:	02051e63          	bnez	a0,800042f0 <z_impl_k_sem_give+0x70>
800042b8:	80006937          	lui	s2,0x80006
800042bc:	800065b7          	lui	a1,0x80006
800042c0:	80006537          	lui	a0,0x80006
800042c4:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
800042c8:	04e00693          	li	a3,78
800042cc:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800042d0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800042d4:	e04fd0ef          	jal	ra,800018d8 <printk>
800042d8:	80006537          	lui	a0,0x80006
800042dc:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
800042e0:	df8fd0ef          	jal	ra,800018d8 <printk>
800042e4:	04e00593          	li	a1,78
800042e8:	cf890513          	addi	a0,s2,-776
800042ec:	e28fd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
800042f0:	38440513          	addi	a0,s0,900
800042f4:	534000ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
800042f8:	00098513          	mv	a0,s3
800042fc:	c71ff0ef          	jal	ra,80003f6c <z_unpend_first_thread>
80004300:	00050913          	mv	s2,a0
	if (thread != NULL) {
80004304:	04050263          	beqz	a0,80004348 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004308:	00d54783          	lbu	a5,13(a0)
8000430c:	01f7f793          	andi	a5,a5,31
80004310:	00079863          	bnez	a5,80004320 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80004314:	01852783          	lw	a5,24(a0)
80004318:	00079463          	bnez	a5,80004320 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
8000431c:	bf0ff0ef          	jal	ra,8000370c <z_add_thread_to_ready_q>
80004320:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80004324:	38440513          	addi	a0,s0,900
}
80004328:	01812403          	lw	s0,24(sp)
8000432c:	01c12083          	lw	ra,28(sp)
80004330:	01012903          	lw	s2,16(sp)
80004334:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004338:	00048593          	mv	a1,s1
}
8000433c:	01412483          	lw	s1,20(sp)
80004340:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004344:	d7dfe06f          	j	800030c0 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004348:	0089a703          	lw	a4,8(s3)
8000434c:	00c9a783          	lw	a5,12(s3)
80004350:	40e787b3          	sub	a5,a5,a4
80004354:	00f037b3          	snez	a5,a5
80004358:	00e787b3          	add	a5,a5,a4
8000435c:	00f9a423          	sw	a5,8(s3)
80004360:	fc5ff06f          	j	80004324 <z_impl_k_sem_give+0xa4>

80004364 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004364:	800067b7          	lui	a5,0x80006
80004368:	63c7a783          	lw	a5,1596(a5) # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
{
8000436c:	fe010113          	addi	sp,sp,-32
80004370:	01212823          	sw	s2,16(sp)
80004374:	01312623          	sw	s3,12(sp)
80004378:	00112e23          	sw	ra,28(sp)
8000437c:	00812c23          	sw	s0,24(sp)
80004380:	00912a23          	sw	s1,20(sp)
80004384:	01412423          	sw	s4,8(sp)
80004388:	00050913          	mv	s2,a0
8000438c:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004390:	04078063          	beqz	a5,800043d0 <z_impl_k_sem_take+0x6c>
80004394:	02058e63          	beqz	a1,800043d0 <z_impl_k_sem_take+0x6c>
80004398:	80006437          	lui	s0,0x80006
8000439c:	800065b7          	lui	a1,0x80006
800043a0:	80006537          	lui	a0,0x80006
800043a4:	0bc58593          	addi	a1,a1,188 # 800060bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060bd>
800043a8:	08c00693          	li	a3,140
800043ac:	04840613          	addi	a2,s0,72 # 80006048 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006049>
800043b0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800043b4:	d24fd0ef          	jal	ra,800018d8 <printk>
800043b8:	80006537          	lui	a0,0x80006
800043bc:	cb050513          	addi	a0,a0,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
800043c0:	d18fd0ef          	jal	ra,800018d8 <printk>
800043c4:	08c00593          	li	a1,140
800043c8:	04840513          	addi	a0,s0,72
800043cc:	d48fd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800043d0:	00800413          	li	s0,8
800043d4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800043d8:	800064b7          	lui	s1,0x80006
800043dc:	38448513          	addi	a0,s1,900 # 80006384 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006385>
	key = (mstatus & SOC_MSTATUS_IEN);
800043e0:	00847413          	andi	s0,s0,8
800043e4:	3ec000ef          	jal	ra,800047d0 <z_spin_lock_valid>
800043e8:	02051e63          	bnez	a0,80004424 <z_impl_k_sem_take+0xc0>
800043ec:	80006a37          	lui	s4,0x80006
800043f0:	800065b7          	lui	a1,0x80006
800043f4:	80006537          	lui	a0,0x80006
800043f8:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
800043fc:	04e00693          	li	a3,78
80004400:	cf8a0613          	addi	a2,s4,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004404:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004408:	cd0fd0ef          	jal	ra,800018d8 <printk>
8000440c:	80006537          	lui	a0,0x80006
80004410:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80004414:	cc4fd0ef          	jal	ra,800018d8 <printk>
80004418:	04e00593          	li	a1,78
8000441c:	cf8a0513          	addi	a0,s4,-776
80004420:	cf4fd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80004424:	38448513          	addi	a0,s1,900
80004428:	400000ef          	jal	ra,80004828 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
8000442c:	00892783          	lw	a5,8(s2)
80004430:	06078c63          	beqz	a5,800044a8 <z_impl_k_sem_take+0x144>
		sem->count--;
80004434:	fff78793          	addi	a5,a5,-1
80004438:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000443c:	38448513          	addi	a0,s1,900
80004440:	3b8000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80004444:	02051e63          	bnez	a0,80004480 <z_impl_k_sem_take+0x11c>
80004448:	800064b7          	lui	s1,0x80006
8000444c:	800065b7          	lui	a1,0x80006
80004450:	80006537          	lui	a0,0x80006
80004454:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80004458:	06100693          	li	a3,97
8000445c:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004460:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004464:	c74fd0ef          	jal	ra,800018d8 <printk>
80004468:	80006537          	lui	a0,0x80006
8000446c:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80004470:	c68fd0ef          	jal	ra,800018d8 <printk>
80004474:	06100593          	li	a1,97
80004478:	cf848513          	addi	a0,s1,-776
8000447c:	c98fd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004480:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80004484:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80004488:	01c12083          	lw	ra,28(sp)
8000448c:	01812403          	lw	s0,24(sp)
80004490:	01412483          	lw	s1,20(sp)
80004494:	01012903          	lw	s2,16(sp)
80004498:	00c12983          	lw	s3,12(sp)
8000449c:	00812a03          	lw	s4,8(sp)
800044a0:	02010113          	addi	sp,sp,32
800044a4:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800044a8:	04099a63          	bnez	s3,800044fc <z_impl_k_sem_take+0x198>
800044ac:	38448513          	addi	a0,s1,900
800044b0:	348000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800044b4:	02051e63          	bnez	a0,800044f0 <z_impl_k_sem_take+0x18c>
800044b8:	800064b7          	lui	s1,0x80006
800044bc:	800065b7          	lui	a1,0x80006
800044c0:	80006537          	lui	a0,0x80006
800044c4:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800044c8:	06100693          	li	a3,97
800044cc:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800044d0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800044d4:	c04fd0ef          	jal	ra,800018d8 <printk>
800044d8:	80006537          	lui	a0,0x80006
800044dc:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800044e0:	bf8fd0ef          	jal	ra,800018d8 <printk>
800044e4:	06100593          	li	a1,97
800044e8:	cf848513          	addi	a0,s1,-776
800044ec:	c28fd0ef          	jal	ra,80001914 <assert_post_action>
800044f0:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800044f4:	ff000513          	li	a0,-16
800044f8:	f91ff06f          	j	80004488 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800044fc:	00040593          	mv	a1,s0
}
80004500:	01812403          	lw	s0,24(sp)
80004504:	01c12083          	lw	ra,28(sp)
80004508:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000450c:	00098693          	mv	a3,s3
80004510:	00090613          	mv	a2,s2
}
80004514:	00c12983          	lw	s3,12(sp)
80004518:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000451c:	38448513          	addi	a0,s1,900
}
80004520:	01412483          	lw	s1,20(sp)
80004524:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004528:	9bdff06f          	j	80003ee4 <z_pend_curr>

8000452c <z_impl_k_stack_push>:
void z_impl_k_stack_push(struct k_stack *stack, u32_t data)
{
	struct k_thread *first_pending_thread;
	k_spinlock_key_t key;

	__ASSERT(stack->next != stack->top, "stack is full");
8000452c:	01052703          	lw	a4,16(a0)
80004530:	01452783          	lw	a5,20(a0)
{
80004534:	fe010113          	addi	sp,sp,-32
80004538:	00912a23          	sw	s1,20(sp)
8000453c:	01412423          	sw	s4,8(sp)
80004540:	00112e23          	sw	ra,28(sp)
80004544:	00812c23          	sw	s0,24(sp)
80004548:	01212823          	sw	s2,16(sp)
8000454c:	01312623          	sw	s3,12(sp)
80004550:	00050493          	mv	s1,a0
80004554:	00058a13          	mv	s4,a1
	__ASSERT(stack->next != stack->top, "stack is full");
80004558:	02f71e63          	bne	a4,a5,80004594 <z_impl_k_stack_push+0x68>
8000455c:	80006437          	lui	s0,0x80006
80004560:	800065b7          	lui	a1,0x80006
80004564:	80006537          	lui	a0,0x80006
80004568:	13058593          	addi	a1,a1,304 # 80006130 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006131>
8000456c:	06800693          	li	a3,104
80004570:	0f040613          	addi	a2,s0,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
80004574:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004578:	b60fd0ef          	jal	ra,800018d8 <printk>
8000457c:	80006537          	lui	a0,0x80006
80004580:	14c50513          	addi	a0,a0,332 # 8000614c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000614d>
80004584:	b54fd0ef          	jal	ra,800018d8 <printk>
80004588:	06800593          	li	a1,104
8000458c:	0f040513          	addi	a0,s0,240
80004590:	b84fd0ef          	jal	ra,80001914 <assert_post_action>

	key = k_spin_lock(&stack->lock);
80004594:	00848993          	addi	s3,s1,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004598:	00800413          	li	s0,8
8000459c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045a0:	00098513          	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
800045a4:	00847413          	andi	s0,s0,8
800045a8:	228000ef          	jal	ra,800047d0 <z_spin_lock_valid>
800045ac:	02051e63          	bnez	a0,800045e8 <z_impl_k_stack_push+0xbc>
800045b0:	80006937          	lui	s2,0x80006
800045b4:	800065b7          	lui	a1,0x80006
800045b8:	80006537          	lui	a0,0x80006
800045bc:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
800045c0:	04e00693          	li	a3,78
800045c4:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800045c8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800045cc:	b0cfd0ef          	jal	ra,800018d8 <printk>
800045d0:	80006537          	lui	a0,0x80006
800045d4:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
800045d8:	b00fd0ef          	jal	ra,800018d8 <printk>
800045dc:	04e00593          	li	a1,78
800045e0:	cf890513          	addi	a0,s2,-776
800045e4:	b30fd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
800045e8:	00098513          	mv	a0,s3
800045ec:	23c000ef          	jal	ra,80004828 <z_spin_lock_set_owner>

	first_pending_thread = z_unpend_first_thread(&stack->wait_q);
800045f0:	00048513          	mv	a0,s1
800045f4:	979ff0ef          	jal	ra,80003f6c <z_unpend_first_thread>
800045f8:	00050913          	mv	s2,a0

	if (first_pending_thread != NULL) {
800045fc:	04050663          	beqz	a0,80004648 <z_impl_k_stack_push+0x11c>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004600:	00d54783          	lbu	a5,13(a0)
80004604:	01f7f793          	andi	a5,a5,31
80004608:	00079863          	bnez	a5,80004618 <z_impl_k_stack_push+0xec>
	if (z_is_thread_ready(thread)) {
8000460c:	01852783          	lw	a5,24(a0)
80004610:	00079463          	bnez	a5,80004618 <z_impl_k_stack_push+0xec>
		z_add_thread_to_ready_q(thread);
80004614:	8f8ff0ef          	jal	ra,8000370c <z_add_thread_to_ready_q>
		z_ready_thread(first_pending_thread);

		z_set_thread_return_value_with_data(first_pending_thread,
						   0, (void *)data);
		z_reschedule(&stack->lock, key);
80004618:	00040593          	mv	a1,s0
		*(stack->next) = data;
		stack->next++;
		k_spin_unlock(&stack->lock, key);
	}

}
8000461c:	01812403          	lw	s0,24(sp)
	thread->base.swap_data = data;
80004620:	01492a23          	sw	s4,20(s2)
80004624:	06092623          	sw	zero,108(s2)
80004628:	01c12083          	lw	ra,28(sp)
8000462c:	01412483          	lw	s1,20(sp)
80004630:	01012903          	lw	s2,16(sp)
80004634:	00812a03          	lw	s4,8(sp)
		z_reschedule(&stack->lock, key);
80004638:	00098513          	mv	a0,s3
}
8000463c:	00c12983          	lw	s3,12(sp)
80004640:	02010113          	addi	sp,sp,32
		z_reschedule(&stack->lock, key);
80004644:	a7dfe06f          	j	800030c0 <z_reschedule>
		*(stack->next) = data;
80004648:	0104a783          	lw	a5,16(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000464c:	00098513          	mv	a0,s3
80004650:	0147a023          	sw	s4,0(a5)
		stack->next++;
80004654:	00478793          	addi	a5,a5,4
80004658:	00f4a823          	sw	a5,16(s1)
8000465c:	19c000ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80004660:	02051e63          	bnez	a0,8000469c <z_impl_k_stack_push+0x170>
80004664:	800064b7          	lui	s1,0x80006
80004668:	800065b7          	lui	a1,0x80006
8000466c:	80006537          	lui	a0,0x80006
80004670:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80004674:	06100693          	li	a3,97
80004678:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000467c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004680:	a58fd0ef          	jal	ra,800018d8 <printk>
80004684:	80006537          	lui	a0,0x80006
80004688:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
8000468c:	a4cfd0ef          	jal	ra,800018d8 <printk>
80004690:	06100593          	li	a1,97
80004694:	cf848513          	addi	a0,s1,-776
80004698:	a7cfd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000469c:	30042473          	csrrs	s0,mstatus,s0
}
800046a0:	01c12083          	lw	ra,28(sp)
800046a4:	01812403          	lw	s0,24(sp)
800046a8:	01412483          	lw	s1,20(sp)
800046ac:	01012903          	lw	s2,16(sp)
800046b0:	00c12983          	lw	s3,12(sp)
800046b4:	00812a03          	lw	s4,8(sp)
800046b8:	02010113          	addi	sp,sp,32
800046bc:	00008067          	ret

800046c0 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800046c0:	00d54783          	lbu	a5,13(a0)
800046c4:	01f7f793          	andi	a5,a5,31
800046c8:	00079863          	bnez	a5,800046d8 <z_is_thread_ready+0x18>
800046cc:	01852503          	lw	a0,24(a0)
800046d0:	00153513          	seqz	a0,a0
800046d4:	00008067          	ret
800046d8:	00000513          	li	a0,0
}
800046dc:	00008067          	ret

800046e0 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800046e0:	800067b7          	lui	a5,0x80006
800046e4:	63c7a503          	lw	a0,1596(a5) # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
}
800046e8:	00a03533          	snez	a0,a0
800046ec:	00008067          	ret

800046f0 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800046f0:	800067b7          	lui	a5,0x80006
800046f4:	6447a783          	lw	a5,1604(a5) # 80006644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006645>
800046f8:	00c7c503          	lbu	a0,12(a5)
}
800046fc:	00157513          	andi	a0,a0,1
80004700:	00008067          	ret

80004704 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004704:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004708:	02012303          	lw	t1,32(sp)
{
8000470c:	00812c23          	sw	s0,24(sp)
80004710:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004714:	00612023          	sw	t1,0(sp)
{
80004718:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000471c:	dacfc0ef          	jal	ra,80000cc8 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004720:	800067b7          	lui	a5,0x80006
80004724:	6447a783          	lw	a5,1604(a5) # 80006644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006645>
	sys_trace_thread_create(new_thread);
}
80004728:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
8000472c:	0687a783          	lw	a5,104(a5)
80004730:	06f42423          	sw	a5,104(s0)
}
80004734:	01812403          	lw	s0,24(sp)
80004738:	02010113          	addi	sp,sp,32
8000473c:	00008067          	ret

80004740 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004740:	06052783          	lw	a5,96(a0)
{
80004744:	ff010113          	addi	sp,sp,-16
80004748:	00812423          	sw	s0,8(sp)
8000474c:	00112623          	sw	ra,12(sp)
80004750:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004754:	00078463          	beqz	a5,8000475c <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004758:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
8000475c:	00040513          	mv	a0,s0
80004760:	f61ff0ef          	jal	ra,800046c0 <z_is_thread_ready>
80004764:	02050463          	beqz	a0,8000478c <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004768:	00040513          	mv	a0,s0
8000476c:	ca8ff0ef          	jal	ra,80003c14 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004770:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004774:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004778:	0087e793          	ori	a5,a5,8
8000477c:	00f406a3          	sb	a5,13(s0)
}
80004780:	00812403          	lw	s0,8(sp)
80004784:	01010113          	addi	sp,sp,16
80004788:	00008067          	ret
		if (z_is_thread_pending(thread)) {
8000478c:	00d44783          	lbu	a5,13(s0)
80004790:	0027f793          	andi	a5,a5,2
80004794:	00078663          	beqz	a5,800047a0 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004798:	00040513          	mv	a0,s0
8000479c:	829fe0ef          	jal	ra,80002fc4 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
800047a0:	01842783          	lw	a5,24(s0)
800047a4:	fc0786e3          	beqz	a5,80004770 <z_thread_single_abort+0x30>
800047a8:	01840513          	addi	a0,s0,24
800047ac:	778000ef          	jal	ra,80004f24 <z_abort_timeout>
800047b0:	fc1ff06f          	j	80004770 <z_thread_single_abort+0x30>

800047b4 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800047b4:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800047b8:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800047bc:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
800047c0:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800047c4:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800047c8:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800047cc:	00008067          	ret

800047d0 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800047d0:	00052503          	lw	a0,0(a0)
800047d4:	00050e63          	beqz	a0,800047f0 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800047d8:	800067b7          	lui	a5,0x80006
800047dc:	6507c783          	lbu	a5,1616(a5) # 80006650 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006651>
800047e0:	00357513          	andi	a0,a0,3
800047e4:	40f50533          	sub	a0,a0,a5
800047e8:	00a03533          	snez	a0,a0
800047ec:	00008067          	ret
			return false;
		}
	}
	return true;
800047f0:	00100513          	li	a0,1
}
800047f4:	00008067          	ret

800047f8 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800047f8:	800067b7          	lui	a5,0x80006
800047fc:	63c78793          	addi	a5,a5,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80004800:	0147c703          	lbu	a4,20(a5)
80004804:	0087a783          	lw	a5,8(a5)
80004808:	00e7e7b3          	or	a5,a5,a4
8000480c:	00052703          	lw	a4,0(a0)
80004810:	00f71863          	bne	a4,a5,80004820 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004814:	00052023          	sw	zero,0(a0)
	return true;
80004818:	00100513          	li	a0,1
8000481c:	00008067          	ret
		return false;
80004820:	00000513          	li	a0,0
}
80004824:	00008067          	ret

80004828 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004828:	800067b7          	lui	a5,0x80006
8000482c:	63c78793          	addi	a5,a5,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
80004830:	0147c703          	lbu	a4,20(a5)
80004834:	0087a783          	lw	a5,8(a5)
80004838:	00e7e7b3          	or	a5,a5,a4
8000483c:	00f52023          	sw	a5,0(a0)
}
80004840:	00008067          	ret

80004844 <z_impl_k_thread_start>:
{
80004844:	fe010113          	addi	sp,sp,-32
80004848:	00812c23          	sw	s0,24(sp)
8000484c:	01212823          	sw	s2,16(sp)
80004850:	00112e23          	sw	ra,28(sp)
80004854:	00912a23          	sw	s1,20(sp)
80004858:	01312623          	sw	s3,12(sp)
8000485c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004860:	00800413          	li	s0,8
80004864:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004868:	800064b7          	lui	s1,0x80006
8000486c:	38848513          	addi	a0,s1,904 # 80006388 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006389>
	key = (mstatus & SOC_MSTATUS_IEN);
80004870:	00847413          	andi	s0,s0,8
80004874:	f5dff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80004878:	02051e63          	bnez	a0,800048b4 <z_impl_k_thread_start+0x70>
8000487c:	800069b7          	lui	s3,0x80006
80004880:	800065b7          	lui	a1,0x80006
80004884:	80006537          	lui	a0,0x80006
80004888:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
8000488c:	04e00693          	li	a3,78
80004890:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004894:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004898:	840fd0ef          	jal	ra,800018d8 <printk>
8000489c:	80006537          	lui	a0,0x80006
800048a0:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
800048a4:	834fd0ef          	jal	ra,800018d8 <printk>
800048a8:	04e00593          	li	a1,78
800048ac:	cf898513          	addi	a0,s3,-776
800048b0:	864fd0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
800048b4:	38848513          	addi	a0,s1,904
800048b8:	f71ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
800048bc:	00d94783          	lbu	a5,13(s2)
800048c0:	0047f713          	andi	a4,a5,4
800048c4:	06071463          	bnez	a4,8000492c <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800048c8:	38848513          	addi	a0,s1,904
800048cc:	f2dff0ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800048d0:	02051e63          	bnez	a0,8000490c <z_impl_k_thread_start+0xc8>
800048d4:	800064b7          	lui	s1,0x80006
800048d8:	800065b7          	lui	a1,0x80006
800048dc:	80006537          	lui	a0,0x80006
800048e0:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800048e4:	06100693          	li	a3,97
800048e8:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800048ec:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800048f0:	fe9fc0ef          	jal	ra,800018d8 <printk>
800048f4:	80006537          	lui	a0,0x80006
800048f8:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800048fc:	fddfc0ef          	jal	ra,800018d8 <printk>
80004900:	06100593          	li	a1,97
80004904:	cf848513          	addi	a0,s1,-776
80004908:	80cfd0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000490c:	30042473          	csrrs	s0,mstatus,s0
}
80004910:	01c12083          	lw	ra,28(sp)
80004914:	01812403          	lw	s0,24(sp)
80004918:	01412483          	lw	s1,20(sp)
8000491c:	01012903          	lw	s2,16(sp)
80004920:	00c12983          	lw	s3,12(sp)
80004924:	02010113          	addi	sp,sp,32
80004928:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
8000492c:	ffb7f793          	andi	a5,a5,-5
80004930:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004934:	00090513          	mv	a0,s2
80004938:	d89ff0ef          	jal	ra,800046c0 <z_is_thread_ready>
8000493c:	00050663          	beqz	a0,80004948 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004940:	00090513          	mv	a0,s2
80004944:	dc9fe0ef          	jal	ra,8000370c <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004948:	00040593          	mv	a1,s0
}
8000494c:	01812403          	lw	s0,24(sp)
80004950:	01c12083          	lw	ra,28(sp)
80004954:	01012903          	lw	s2,16(sp)
80004958:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
8000495c:	38848513          	addi	a0,s1,904
}
80004960:	01412483          	lw	s1,20(sp)
80004964:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004968:	f58fe06f          	j	800030c0 <z_reschedule>

8000496c <schedule_new_thread>:
	if (delay == 0) {
8000496c:	00059463          	bnez	a1,80004974 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004970:	ed5ff06f          	j	80004844 <z_impl_k_thread_start>
80004974:	00958593          	addi	a1,a1,9
80004978:	00a00613          	li	a2,10
8000497c:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004980:	800045b7          	lui	a1,0x80004
80004984:	89c58593          	addi	a1,a1,-1892 # 8000389c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000389d>
80004988:	01850513          	addi	a0,a0,24
8000498c:	00160613          	addi	a2,a2,1
80004990:	3680006f          	j	80004cf8 <z_add_timeout>

80004994 <z_impl_k_thread_create>:
{
80004994:	fc010113          	addi	sp,sp,-64
80004998:	03512223          	sw	s5,36(sp)
8000499c:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800049a0:	800066b7          	lui	a3,0x80006
800049a4:	63c6a683          	lw	a3,1596(a3) # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
{
800049a8:	02812c23          	sw	s0,56(sp)
800049ac:	02912a23          	sw	s1,52(sp)
800049b0:	03312623          	sw	s3,44(sp)
800049b4:	03412423          	sw	s4,40(sp)
800049b8:	02112e23          	sw	ra,60(sp)
800049bc:	03212823          	sw	s2,48(sp)
800049c0:	00050413          	mv	s0,a0
800049c4:	00058993          	mv	s3,a1
800049c8:	00060a13          	mv	s4,a2
800049cc:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800049d0:	04068e63          	beqz	a3,80004a2c <z_impl_k_thread_create+0x98>
800049d4:	80006937          	lui	s2,0x80006
800049d8:	800065b7          	lui	a1,0x80006
800049dc:	80006537          	lui	a0,0x80006
800049e0:	1b200693          	li	a3,434
800049e4:	15c90613          	addi	a2,s2,348 # 8000615c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000615d>
800049e8:	f4858593          	addi	a1,a1,-184 # 80005f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f49>
800049ec:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800049f0:	01112e23          	sw	a7,28(sp)
800049f4:	01012c23          	sw	a6,24(sp)
800049f8:	00f12a23          	sw	a5,20(sp)
800049fc:	00e12823          	sw	a4,16(sp)
80004a00:	ed9fc0ef          	jal	ra,800018d8 <printk>
80004a04:	80006537          	lui	a0,0x80006
80004a08:	17050513          	addi	a0,a0,368 # 80006170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006171>
80004a0c:	ecdfc0ef          	jal	ra,800018d8 <printk>
80004a10:	1b200593          	li	a1,434
80004a14:	15c90513          	addi	a0,s2,348
80004a18:	efdfc0ef          	jal	ra,80001914 <assert_post_action>
80004a1c:	01c12883          	lw	a7,28(sp)
80004a20:	01812803          	lw	a6,24(sp)
80004a24:	01412783          	lw	a5,20(sp)
80004a28:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a2c:	04012683          	lw	a3,64(sp)
80004a30:	00012223          	sw	zero,4(sp)
80004a34:	000a0613          	mv	a2,s4
80004a38:	00d12023          	sw	a3,0(sp)
80004a3c:	00098593          	mv	a1,s3
80004a40:	000a8693          	mv	a3,s5
80004a44:	00040513          	mv	a0,s0
80004a48:	cbdff0ef          	jal	ra,80004704 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004a4c:	fff00793          	li	a5,-1
80004a50:	00f48863          	beq	s1,a5,80004a60 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004a54:	00048593          	mv	a1,s1
80004a58:	00040513          	mv	a0,s0
80004a5c:	f11ff0ef          	jal	ra,8000496c <schedule_new_thread>
}
80004a60:	00040513          	mv	a0,s0
80004a64:	03c12083          	lw	ra,60(sp)
80004a68:	03812403          	lw	s0,56(sp)
80004a6c:	03412483          	lw	s1,52(sp)
80004a70:	03012903          	lw	s2,48(sp)
80004a74:	02c12983          	lw	s3,44(sp)
80004a78:	02812a03          	lw	s4,40(sp)
80004a7c:	02412a83          	lw	s5,36(sp)
80004a80:	04010113          	addi	sp,sp,64
80004a84:	00008067          	ret

80004a88 <z_init_static_threads>:
{
80004a88:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004a8c:	800067b7          	lui	a5,0x80006
{
80004a90:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004a94:	80006937          	lui	s2,0x80006
{
80004a98:	00812c23          	sw	s0,24(sp)
80004a9c:	00912a23          	sw	s1,20(sp)
80004aa0:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004aa4:	2d878413          	addi	s0,a5,728 # 800062d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d9>
80004aa8:	2d878493          	addi	s1,a5,728
80004aac:	2d890913          	addi	s2,s2,728 # 800062d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d9>
80004ab0:	03246663          	bltu	s0,s2,80004adc <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004ab4:	00048413          	mv	s0,s1
	k_sched_lock();
80004ab8:	f08fe0ef          	jal	ra,800031c0 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004abc:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004ac0:	07246063          	bltu	s0,s2,80004b20 <z_init_static_threads+0x98>
}
80004ac4:	01812403          	lw	s0,24(sp)
80004ac8:	01c12083          	lw	ra,28(sp)
80004acc:	01412483          	lw	s1,20(sp)
80004ad0:	01012903          	lw	s2,16(sp)
80004ad4:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004ad8:	ab5fe06f          	j	8000358c <k_sched_unlock>
		z_setup_new_thread(
80004adc:	02c42783          	lw	a5,44(s0)
80004ae0:	00f12223          	sw	a5,4(sp)
80004ae4:	02042783          	lw	a5,32(s0)
80004ae8:	00f12023          	sw	a5,0(sp)
80004aec:	01442783          	lw	a5,20(s0)
80004af0:	01c42883          	lw	a7,28(s0)
80004af4:	01842803          	lw	a6,24(s0)
80004af8:	01042703          	lw	a4,16(s0)
80004afc:	00c42683          	lw	a3,12(s0)
80004b00:	00842603          	lw	a2,8(s0)
80004b04:	00442583          	lw	a1,4(s0)
80004b08:	00042503          	lw	a0,0(s0)
80004b0c:	bf9ff0ef          	jal	ra,80004704 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004b10:	00042783          	lw	a5,0(s0)
80004b14:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004b18:	03040413          	addi	s0,s0,48
80004b1c:	f95ff06f          	j	80004ab0 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004b20:	02442583          	lw	a1,36(s0)
80004b24:	00958663          	beq	a1,s1,80004b30 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004b28:	00042503          	lw	a0,0(s0)
80004b2c:	e41ff0ef          	jal	ra,8000496c <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004b30:	03040413          	addi	s0,s0,48
80004b34:	f8dff06f          	j	80004ac0 <z_init_static_threads+0x38>

80004b38 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004b38:	fe010113          	addi	sp,sp,-32
80004b3c:	00812c23          	sw	s0,24(sp)
80004b40:	00912a23          	sw	s1,20(sp)
80004b44:	00112e23          	sw	ra,28(sp)
80004b48:	01212823          	sw	s2,16(sp)
80004b4c:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004b50:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b54:	00800413          	li	s0,8
80004b58:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b5c:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004b60:	00847413          	andi	s0,s0,8
80004b64:	c6dff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80004b68:	02051e63          	bnez	a0,80004ba4 <z_impl_k_thread_abort+0x6c>
80004b6c:	80006937          	lui	s2,0x80006
80004b70:	800065b7          	lui	a1,0x80006
80004b74:	80006537          	lui	a0,0x80006
80004b78:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80004b7c:	04e00693          	li	a3,78
80004b80:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004b84:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004b88:	d51fc0ef          	jal	ra,800018d8 <printk>
80004b8c:	80006537          	lui	a0,0x80006
80004b90:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80004b94:	d45fc0ef          	jal	ra,800018d8 <printk>
80004b98:	04e00593          	li	a1,78
80004b9c:	cf890513          	addi	a0,s2,-776
80004ba0:	d75fc0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ba4:	00c10513          	addi	a0,sp,12
80004ba8:	c81ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004bac:	00c4c783          	lbu	a5,12(s1)
80004bb0:	0017f793          	andi	a5,a5,1
80004bb4:	02078e63          	beqz	a5,80004bf0 <z_impl_k_thread_abort+0xb8>
80004bb8:	80006937          	lui	s2,0x80006
80004bbc:	800065b7          	lui	a1,0x80006
80004bc0:	80006537          	lui	a0,0x80006
80004bc4:	1b058593          	addi	a1,a1,432 # 800061b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061b1>
80004bc8:	02900693          	li	a3,41
80004bcc:	19890613          	addi	a2,s2,408 # 80006198 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006199>
80004bd0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004bd4:	d05fc0ef          	jal	ra,800018d8 <printk>
80004bd8:	80006537          	lui	a0,0x80006
80004bdc:	1e450513          	addi	a0,a0,484 # 800061e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061e5>
80004be0:	cf9fc0ef          	jal	ra,800018d8 <printk>
80004be4:	02900593          	li	a1,41
80004be8:	19890513          	addi	a0,s2,408
80004bec:	d29fc0ef          	jal	ra,80001914 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004bf0:	00048513          	mv	a0,s1
80004bf4:	b4dff0ef          	jal	ra,80004740 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004bf8:	00040593          	mv	a1,s0
80004bfc:	00c10513          	addi	a0,sp,12
80004c00:	cc0fe0ef          	jal	ra,800030c0 <z_reschedule>
}
80004c04:	01c12083          	lw	ra,28(sp)
80004c08:	01812403          	lw	s0,24(sp)
80004c0c:	01412483          	lw	s1,20(sp)
80004c10:	01012903          	lw	s2,16(sp)
80004c14:	02010113          	addi	sp,sp,32
80004c18:	00008067          	ret

80004c1c <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004c1c:	800067b7          	lui	a5,0x80006
80004c20:	38c7a783          	lw	a5,908(a5) # 8000638c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000638d>
80004c24:	00079463          	bnez	a5,80004c2c <elapsed+0x10>
80004c28:	93cfd06f          	j	80001d64 <z_clock_elapsed>
}
80004c2c:	00000513          	li	a0,0
80004c30:	00008067          	ret

80004c34 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004c34:	00052783          	lw	a5,0(a0)
80004c38:	02050263          	beqz	a0,80004c5c <remove_timeout+0x28>
80004c3c:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
80004c40:	29072703          	lw	a4,656(a4) # 80006290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006291>
80004c44:	00e50c63          	beq	a0,a4,80004c5c <remove_timeout+0x28>
	if (next(t) != NULL) {
80004c48:	00078a63          	beqz	a5,80004c5c <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80004c4c:	0087a703          	lw	a4,8(a5)
80004c50:	00852683          	lw	a3,8(a0)
80004c54:	00d70733          	add	a4,a4,a3
80004c58:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80004c5c:	00452703          	lw	a4,4(a0)
80004c60:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004c64:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004c68:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004c6c:	00052223          	sw	zero,4(a0)
}
80004c70:	00008067          	ret

80004c74 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004c74:	800067b7          	lui	a5,0x80006
80004c78:	3947c783          	lbu	a5,916(a5) # 80006394 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006395>
{
80004c7c:	ff010113          	addi	sp,sp,-16
80004c80:	00112623          	sw	ra,12(sp)
80004c84:	00812423          	sw	s0,8(sp)
80004c88:	00912223          	sw	s1,4(sp)
80004c8c:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004c90:	00079663          	bnez	a5,80004c9c <next_timeout+0x28>
80004c94:	80000537          	lui	a0,0x80000
80004c98:	fff54513          	not	a0,a0
	return list->head == list;
80004c9c:	800067b7          	lui	a5,0x80006
80004ca0:	28c78793          	addi	a5,a5,652 # 8000628c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000628d>
80004ca4:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004ca8:	02f40463          	beq	s0,a5,80004cd0 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004cac:	02040263          	beqz	s0,80004cd0 <next_timeout+0x5c>
80004cb0:	00842483          	lw	s1,8(s0)
80004cb4:	f69ff0ef          	jal	ra,80004c1c <elapsed>
80004cb8:	40a484b3          	sub	s1,s1,a0
80004cbc:	00000513          	li	a0,0
80004cc0:	0004c863          	bltz	s1,80004cd0 <next_timeout+0x5c>
80004cc4:	00842403          	lw	s0,8(s0)
80004cc8:	f55ff0ef          	jal	ra,80004c1c <elapsed>
80004ccc:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004cd0:	800067b7          	lui	a5,0x80006
80004cd4:	64c7a783          	lw	a5,1612(a5) # 8000664c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000664d>
80004cd8:	00078663          	beqz	a5,80004ce4 <next_timeout+0x70>
80004cdc:	00a7d463          	bge	a5,a0,80004ce4 <next_timeout+0x70>
80004ce0:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004ce4:	00c12083          	lw	ra,12(sp)
80004ce8:	00812403          	lw	s0,8(sp)
80004cec:	00412483          	lw	s1,4(sp)
80004cf0:	01010113          	addi	sp,sp,16
80004cf4:	00008067          	ret

80004cf8 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004cf8:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004cfc:	fd010113          	addi	sp,sp,-48
80004d00:	02812423          	sw	s0,40(sp)
80004d04:	02912223          	sw	s1,36(sp)
80004d08:	01312e23          	sw	s3,28(sp)
80004d0c:	02112623          	sw	ra,44(sp)
80004d10:	03212023          	sw	s2,32(sp)
80004d14:	01412c23          	sw	s4,24(sp)
80004d18:	01512a23          	sw	s5,20(sp)
80004d1c:	01612823          	sw	s6,16(sp)
80004d20:	01712623          	sw	s7,12(sp)
80004d24:	01812423          	sw	s8,8(sp)
80004d28:	00050413          	mv	s0,a0
80004d2c:	00058993          	mv	s3,a1
80004d30:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004d34:	02078e63          	beqz	a5,80004d70 <z_add_timeout+0x78>
80004d38:	80006937          	lui	s2,0x80006
80004d3c:	800065b7          	lui	a1,0x80006
80004d40:	80006537          	lui	a0,0x80006
80004d44:	21458593          	addi	a1,a1,532 # 80006214 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006215>
80004d48:	04d00693          	li	a3,77
80004d4c:	20090613          	addi	a2,s2,512 # 80006200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006201>
80004d50:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004d54:	b85fc0ef          	jal	ra,800018d8 <printk>
80004d58:	80006537          	lui	a0,0x80006
80004d5c:	cb050513          	addi	a0,a0,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
80004d60:	b79fc0ef          	jal	ra,800018d8 <printk>
80004d64:	04d00593          	li	a1,77
80004d68:	20090513          	addi	a0,s2,512
80004d6c:	ba9fc0ef          	jal	ra,80001914 <assert_post_action>
	to->fn = fn;
80004d70:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004d74:	00904463          	bgtz	s1,80004d7c <z_add_timeout+0x84>
80004d78:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004d7c:	00800993          	li	s3,8
80004d80:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004d84:	80006a37          	lui	s4,0x80006
80004d88:	390a0513          	addi	a0,s4,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
	key = (mstatus & SOC_MSTATUS_IEN);
80004d8c:	0089f993          	andi	s3,s3,8
80004d90:	a41ff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80004d94:	02051e63          	bnez	a0,80004dd0 <z_add_timeout+0xd8>
80004d98:	80006937          	lui	s2,0x80006
80004d9c:	800065b7          	lui	a1,0x80006
80004da0:	80006537          	lui	a0,0x80006
80004da4:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80004da8:	04e00693          	li	a3,78
80004dac:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004db0:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004db4:	b25fc0ef          	jal	ra,800018d8 <printk>
80004db8:	80006537          	lui	a0,0x80006
80004dbc:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80004dc0:	b19fc0ef          	jal	ra,800018d8 <printk>
80004dc4:	04e00593          	li	a1,78
80004dc8:	cf890513          	addi	a0,s2,-776
80004dcc:	b49fc0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80004dd0:	390a0513          	addi	a0,s4,912
80004dd4:	a55ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80004dd8:	e45ff0ef          	jal	ra,80004c1c <elapsed>
80004ddc:	00950533          	add	a0,a0,s1
	return list->head == list;
80004de0:	800064b7          	lui	s1,0x80006
80004de4:	28c4a903          	lw	s2,652(s1) # 8000628c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000628d>
80004de8:	00a42423          	sw	a0,8(s0)
80004dec:	28c48493          	addi	s1,s1,652
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004df0:	00990c63          	beq	s2,s1,80004e08 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80004df4:	80006ab7          	lui	s5,0x80006
80004df8:	80006b37          	lui	s6,0x80006
80004dfc:	80006bb7          	lui	s7,0x80006
80004e00:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
80004e04:	02091063          	bnez	s2,80004e24 <z_add_timeout+0x12c>
	node->prev = list->tail;
80004e08:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004e0c:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004e10:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004e14:	0044a783          	lw	a5,4(s1)
80004e18:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004e1c:	0084a223          	sw	s0,4(s1)
80004e20:	05c0006f          	j	80004e7c <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80004e24:	00892783          	lw	a5,8(s2)
80004e28:	0207d663          	bgez	a5,80004e54 <z_add_timeout+0x15c>
80004e2c:	234b0593          	addi	a1,s6,564 # 80006234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006235>
80004e30:	05600693          	li	a3,86
80004e34:	200a8613          	addi	a2,s5,512 # 80006200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006201>
80004e38:	c2cb8513          	addi	a0,s7,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004e3c:	a9dfc0ef          	jal	ra,800018d8 <printk>
80004e40:	cb0c0513          	addi	a0,s8,-848 # 80005cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb1>
80004e44:	a95fc0ef          	jal	ra,800018d8 <printk>
80004e48:	05600593          	li	a1,86
80004e4c:	200a8513          	addi	a0,s5,512
80004e50:	ac5fc0ef          	jal	ra,80001914 <assert_post_action>

			if (t->dticks > to->dticks) {
80004e54:	00892703          	lw	a4,8(s2)
80004e58:	00842783          	lw	a5,8(s0)
80004e5c:	0ae7d863          	bge	a5,a4,80004f0c <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80004e60:	40f707b3          	sub	a5,a4,a5
80004e64:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004e68:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004e6c:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004e70:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80004e74:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80004e78:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004e7c:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004e80:	00978a63          	beq	a5,s1,80004e94 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004e84:	00f41863          	bne	s0,a5,80004e94 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80004e88:	dedff0ef          	jal	ra,80004c74 <next_timeout>
80004e8c:	00000593          	li	a1,0
80004e90:	d59fc0ef          	jal	ra,80001be8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004e94:	390a0513          	addi	a0,s4,912
80004e98:	961ff0ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80004e9c:	02051e63          	bnez	a0,80004ed8 <z_add_timeout+0x1e0>
80004ea0:	80006437          	lui	s0,0x80006
80004ea4:	800065b7          	lui	a1,0x80006
80004ea8:	80006537          	lui	a0,0x80006
80004eac:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80004eb0:	06100693          	li	a3,97
80004eb4:	cf840613          	addi	a2,s0,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004eb8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004ebc:	a1dfc0ef          	jal	ra,800018d8 <printk>
80004ec0:	80006537          	lui	a0,0x80006
80004ec4:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80004ec8:	a11fc0ef          	jal	ra,800018d8 <printk>
80004ecc:	06100593          	li	a1,97
80004ed0:	cf840513          	addi	a0,s0,-776
80004ed4:	a41fc0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004ed8:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80004edc:	02c12083          	lw	ra,44(sp)
80004ee0:	02812403          	lw	s0,40(sp)
80004ee4:	02412483          	lw	s1,36(sp)
80004ee8:	02012903          	lw	s2,32(sp)
80004eec:	01c12983          	lw	s3,28(sp)
80004ef0:	01812a03          	lw	s4,24(sp)
80004ef4:	01412a83          	lw	s5,20(sp)
80004ef8:	01012b03          	lw	s6,16(sp)
80004efc:	00c12b83          	lw	s7,12(sp)
80004f00:	00812c03          	lw	s8,8(sp)
80004f04:	03010113          	addi	sp,sp,48
80004f08:	00008067          	ret
			to->dticks -= t->dticks;
80004f0c:	40e787b3          	sub	a5,a5,a4
80004f10:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004f14:	0044a783          	lw	a5,4(s1)
80004f18:	ef2788e3          	beq	a5,s2,80004e08 <z_add_timeout+0x110>
80004f1c:	00092903          	lw	s2,0(s2)
80004f20:	ee5ff06f          	j	80004e04 <z_add_timeout+0x10c>

80004f24 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004f24:	fe010113          	addi	sp,sp,-32
80004f28:	00812c23          	sw	s0,24(sp)
80004f2c:	01312623          	sw	s3,12(sp)
80004f30:	00112e23          	sw	ra,28(sp)
80004f34:	00912a23          	sw	s1,20(sp)
80004f38:	01212823          	sw	s2,16(sp)
80004f3c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004f40:	00800413          	li	s0,8
80004f44:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004f48:	800064b7          	lui	s1,0x80006
80004f4c:	39048513          	addi	a0,s1,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
	key = (mstatus & SOC_MSTATUS_IEN);
80004f50:	00847413          	andi	s0,s0,8
80004f54:	87dff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80004f58:	02051e63          	bnez	a0,80004f94 <z_abort_timeout+0x70>
80004f5c:	80006937          	lui	s2,0x80006
80004f60:	800065b7          	lui	a1,0x80006
80004f64:	80006537          	lui	a0,0x80006
80004f68:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80004f6c:	04e00693          	li	a3,78
80004f70:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004f74:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004f78:	961fc0ef          	jal	ra,800018d8 <printk>
80004f7c:	80006537          	lui	a0,0x80006
80004f80:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80004f84:	955fc0ef          	jal	ra,800018d8 <printk>
80004f88:	04e00593          	li	a1,78
80004f8c:	cf890513          	addi	a0,s2,-776
80004f90:	985fc0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80004f94:	39048513          	addi	a0,s1,912
80004f98:	891ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004f9c:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80004fa0:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80004fa4:	00078863          	beqz	a5,80004fb4 <z_abort_timeout+0x90>
			remove_timeout(to);
80004fa8:	00098513          	mv	a0,s3
80004fac:	c89ff0ef          	jal	ra,80004c34 <remove_timeout>
			ret = 0;
80004fb0:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004fb4:	39048513          	addi	a0,s1,912
80004fb8:	841ff0ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80004fbc:	02051e63          	bnez	a0,80004ff8 <z_abort_timeout+0xd4>
80004fc0:	800064b7          	lui	s1,0x80006
80004fc4:	800065b7          	lui	a1,0x80006
80004fc8:	80006537          	lui	a0,0x80006
80004fcc:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80004fd0:	06100693          	li	a3,97
80004fd4:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80004fd8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80004fdc:	8fdfc0ef          	jal	ra,800018d8 <printk>
80004fe0:	80006537          	lui	a0,0x80006
80004fe4:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
80004fe8:	8f1fc0ef          	jal	ra,800018d8 <printk>
80004fec:	06100593          	li	a1,97
80004ff0:	cf848513          	addi	a0,s1,-776
80004ff4:	921fc0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004ff8:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004ffc:	01c12083          	lw	ra,28(sp)
80005000:	01812403          	lw	s0,24(sp)
80005004:	00090513          	mv	a0,s2
80005008:	01412483          	lw	s1,20(sp)
8000500c:	01012903          	lw	s2,16(sp)
80005010:	00c12983          	lw	s3,12(sp)
80005014:	02010113          	addi	sp,sp,32
80005018:	00008067          	ret

8000501c <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
8000501c:	ff010113          	addi	sp,sp,-16
80005020:	00812423          	sw	s0,8(sp)
80005024:	00112623          	sw	ra,12(sp)
80005028:	00912223          	sw	s1,4(sp)
8000502c:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005030:	00800413          	li	s0,8
80005034:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005038:	800064b7          	lui	s1,0x80006
8000503c:	39048513          	addi	a0,s1,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
	key = (mstatus & SOC_MSTATUS_IEN);
80005040:	00847413          	andi	s0,s0,8
80005044:	f8cff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80005048:	02051e63          	bnez	a0,80005084 <z_get_next_timeout_expiry+0x68>
8000504c:	80006937          	lui	s2,0x80006
80005050:	800065b7          	lui	a1,0x80006
80005054:	80006537          	lui	a0,0x80006
80005058:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
8000505c:	04e00693          	li	a3,78
80005060:	cf890613          	addi	a2,s2,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80005064:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80005068:	871fc0ef          	jal	ra,800018d8 <printk>
8000506c:	80006537          	lui	a0,0x80006
80005070:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80005074:	865fc0ef          	jal	ra,800018d8 <printk>
80005078:	04e00593          	li	a1,78
8000507c:	cf890513          	addi	a0,s2,-776
80005080:	895fc0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80005084:	39048513          	addi	a0,s1,912
80005088:	fa0ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
8000508c:	be9ff0ef          	jal	ra,80004c74 <next_timeout>
80005090:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005094:	39048513          	addi	a0,s1,912
80005098:	f60ff0ef          	jal	ra,800047f8 <z_spin_unlock_valid>
8000509c:	02051e63          	bnez	a0,800050d8 <z_get_next_timeout_expiry+0xbc>
800050a0:	800064b7          	lui	s1,0x80006
800050a4:	800065b7          	lui	a1,0x80006
800050a8:	80006537          	lui	a0,0x80006
800050ac:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800050b0:	06100693          	li	a3,97
800050b4:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800050b8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800050bc:	81dfc0ef          	jal	ra,800018d8 <printk>
800050c0:	80006537          	lui	a0,0x80006
800050c4:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800050c8:	811fc0ef          	jal	ra,800018d8 <printk>
800050cc:	06100593          	li	a1,97
800050d0:	cf848513          	addi	a0,s1,-776
800050d4:	841fc0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800050d8:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800050dc:	00c12083          	lw	ra,12(sp)
800050e0:	00812403          	lw	s0,8(sp)
800050e4:	00090513          	mv	a0,s2
800050e8:	00412483          	lw	s1,4(sp)
800050ec:	00012903          	lw	s2,0(sp)
800050f0:	01010113          	addi	sp,sp,16
800050f4:	00008067          	ret

800050f8 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
800050f8:	fe010113          	addi	sp,sp,-32
800050fc:	00812c23          	sw	s0,24(sp)
80005100:	01212823          	sw	s2,16(sp)
80005104:	01412423          	sw	s4,8(sp)
80005108:	00112e23          	sw	ra,28(sp)
8000510c:	00912a23          	sw	s1,20(sp)
80005110:	01312623          	sw	s3,12(sp)
80005114:	00050913          	mv	s2,a0
80005118:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000511c:	00800413          	li	s0,8
80005120:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005124:	800064b7          	lui	s1,0x80006
80005128:	39048513          	addi	a0,s1,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
	key = (mstatus & SOC_MSTATUS_IEN);
8000512c:	00847413          	andi	s0,s0,8
80005130:	ea0ff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80005134:	02051e63          	bnez	a0,80005170 <z_set_timeout_expiry+0x78>
80005138:	800069b7          	lui	s3,0x80006
8000513c:	800065b7          	lui	a1,0x80006
80005140:	80006537          	lui	a0,0x80006
80005144:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80005148:	04e00693          	li	a3,78
8000514c:	cf898613          	addi	a2,s3,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
80005150:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80005154:	f84fc0ef          	jal	ra,800018d8 <printk>
80005158:	80006537          	lui	a0,0x80006
8000515c:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80005160:	f78fc0ef          	jal	ra,800018d8 <printk>
80005164:	04e00593          	li	a1,78
80005168:	cf898513          	addi	a0,s3,-776
8000516c:	fa8fc0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80005170:	39048513          	addi	a0,s1,912
80005174:	eb4ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80005178:	afdff0ef          	jal	ra,80004c74 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
8000517c:	00a95c63          	bge	s2,a0,80005194 <z_set_timeout_expiry+0x9c>
80005180:	00100793          	li	a5,1
80005184:	00a7d863          	bge	a5,a0,80005194 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80005188:	000a0593          	mv	a1,s4
8000518c:	00090513          	mv	a0,s2
80005190:	a59fc0ef          	jal	ra,80001be8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005194:	39048513          	addi	a0,s1,912
80005198:	e60ff0ef          	jal	ra,800047f8 <z_spin_unlock_valid>
8000519c:	02051e63          	bnez	a0,800051d8 <z_set_timeout_expiry+0xe0>
800051a0:	800064b7          	lui	s1,0x80006
800051a4:	800065b7          	lui	a1,0x80006
800051a8:	80006537          	lui	a0,0x80006
800051ac:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800051b0:	06100693          	li	a3,97
800051b4:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800051b8:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800051bc:	f1cfc0ef          	jal	ra,800018d8 <printk>
800051c0:	80006537          	lui	a0,0x80006
800051c4:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800051c8:	f10fc0ef          	jal	ra,800018d8 <printk>
800051cc:	06100593          	li	a1,97
800051d0:	cf848513          	addi	a0,s1,-776
800051d4:	f40fc0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800051d8:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800051dc:	01c12083          	lw	ra,28(sp)
800051e0:	01812403          	lw	s0,24(sp)
800051e4:	01412483          	lw	s1,20(sp)
800051e8:	01012903          	lw	s2,16(sp)
800051ec:	00c12983          	lw	s3,12(sp)
800051f0:	00812a03          	lw	s4,8(sp)
800051f4:	02010113          	addi	sp,sp,32
800051f8:	00008067          	ret

800051fc <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
800051fc:	fd010113          	addi	sp,sp,-48
80005200:	02812423          	sw	s0,40(sp)
80005204:	01412c23          	sw	s4,24(sp)
80005208:	02112623          	sw	ra,44(sp)
8000520c:	02912223          	sw	s1,36(sp)
80005210:	03212023          	sw	s2,32(sp)
80005214:	01312e23          	sw	s3,28(sp)
80005218:	01512a23          	sw	s5,20(sp)
8000521c:	01612823          	sw	s6,16(sp)
80005220:	01712623          	sw	s7,12(sp)
80005224:	01812423          	sw	s8,8(sp)
80005228:	01912223          	sw	s9,4(sp)
8000522c:	01a12023          	sw	s10,0(sp)
80005230:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005234:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80005238:	965fe0ef          	jal	ra,80003b9c <z_time_slice>
8000523c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005240:	80006937          	lui	s2,0x80006
80005244:	39090513          	addi	a0,s2,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
	key = (mstatus & SOC_MSTATUS_IEN);
80005248:	00847413          	andi	s0,s0,8
8000524c:	d84ff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80005250:	02051e63          	bnez	a0,8000528c <z_clock_announce+0x90>
80005254:	800064b7          	lui	s1,0x80006
80005258:	800065b7          	lui	a1,0x80006
8000525c:	80006537          	lui	a0,0x80006
80005260:	d1058593          	addi	a1,a1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80005264:	04e00693          	li	a3,78
80005268:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000526c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80005270:	e68fc0ef          	jal	ra,800018d8 <printk>
80005274:	80006537          	lui	a0,0x80006
80005278:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
8000527c:	e5cfc0ef          	jal	ra,800018d8 <printk>
80005280:	04e00593          	li	a1,78
80005284:	cf848513          	addi	a0,s1,-776
80005288:	e8cfc0ef          	jal	ra,80001914 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
8000528c:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
80005290:	39090513          	addi	a0,s2,912
80005294:	d94ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>
80005298:	800064b7          	lui	s1,0x80006
8000529c:	3949a623          	sw	s4,908(s3) # 8000638c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000638d>
	return list->head == list;
800052a0:	80006a37          	lui	s4,0x80006
800052a4:	38c98993          	addi	s3,s3,908
800052a8:	28ca0a13          	addi	s4,s4,652 # 8000628c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000628d>
800052ac:	34848493          	addi	s1,s1,840 # 80006348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006349>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800052b0:	80006ab7          	lui	s5,0x80006
800052b4:	80006bb7          	lui	s7,0x80006
800052b8:	80006b37          	lui	s6,0x80006
800052bc:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800052c0:	80006cb7          	lui	s9,0x80006
800052c4:	000a2d03          	lw	s10,0(s4)
800052c8:	0009a783          	lw	a5,0(s3)
800052cc:	0004a683          	lw	a3,0(s1)
800052d0:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800052d4:	014d0c63          	beq	s10,s4,800052ec <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
800052d8:	000d0a63          	beqz	s10,800052ec <z_clock_announce+0xf0>
800052dc:	008d2703          	lw	a4,8(s10)
800052e0:	0ae7dc63          	bge	a5,a4,80005398 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
800052e4:	40f70733          	sub	a4,a4,a5
800052e8:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
800052ec:	00d786b3          	add	a3,a5,a3
800052f0:	41f7d713          	srai	a4,a5,0x1f
800052f4:	00a70733          	add	a4,a4,a0
800052f8:	00f6b7b3          	sltu	a5,a3,a5
800052fc:	00e787b3          	add	a5,a5,a4
80005300:	00d4a023          	sw	a3,0(s1)
80005304:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005308:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
8000530c:	969ff0ef          	jal	ra,80004c74 <next_timeout>
80005310:	00000593          	li	a1,0
80005314:	8d5fc0ef          	jal	ra,80001be8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005318:	39090513          	addi	a0,s2,912
8000531c:	cdcff0ef          	jal	ra,800047f8 <z_spin_unlock_valid>
80005320:	02051e63          	bnez	a0,8000535c <z_clock_announce+0x160>
80005324:	800064b7          	lui	s1,0x80006
80005328:	800065b7          	lui	a1,0x80006
8000532c:	80006537          	lui	a0,0x80006
80005330:	d4058593          	addi	a1,a1,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80005334:	06100693          	li	a3,97
80005338:	cf848613          	addi	a2,s1,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
8000533c:	c2c50513          	addi	a0,a0,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
80005340:	d98fc0ef          	jal	ra,800018d8 <printk>
80005344:	80006537          	lui	a0,0x80006
80005348:	d5850513          	addi	a0,a0,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
8000534c:	d8cfc0ef          	jal	ra,800018d8 <printk>
80005350:	06100593          	li	a1,97
80005354:	cf848513          	addi	a0,s1,-776
80005358:	dbcfc0ef          	jal	ra,80001914 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000535c:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80005360:	02c12083          	lw	ra,44(sp)
80005364:	02812403          	lw	s0,40(sp)
80005368:	02412483          	lw	s1,36(sp)
8000536c:	02012903          	lw	s2,32(sp)
80005370:	01c12983          	lw	s3,28(sp)
80005374:	01812a03          	lw	s4,24(sp)
80005378:	01412a83          	lw	s5,20(sp)
8000537c:	01012b03          	lw	s6,16(sp)
80005380:	00c12b83          	lw	s7,12(sp)
80005384:	00812c03          	lw	s8,8(sp)
80005388:	00412c83          	lw	s9,4(sp)
8000538c:	00012d03          	lw	s10,0(sp)
80005390:	03010113          	addi	sp,sp,48
80005394:	00008067          	ret
		curr_tick += dt;
80005398:	00d706b3          	add	a3,a4,a3
8000539c:	41f75593          	srai	a1,a4,0x1f
800053a0:	00a585b3          	add	a1,a1,a0
800053a4:	00e6b633          	sltu	a2,a3,a4
800053a8:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
800053ac:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
800053b0:	000d0513          	mv	a0,s10
		t->dticks = 0;
800053b4:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
800053b8:	00d4a023          	sw	a3,0(s1)
800053bc:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
800053c0:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
800053c4:	871ff0ef          	jal	ra,80004c34 <remove_timeout>
800053c8:	39090513          	addi	a0,s2,912
800053cc:	c2cff0ef          	jal	ra,800047f8 <z_spin_unlock_valid>
800053d0:	02051663          	bnez	a0,800053fc <z_clock_announce+0x200>
800053d4:	d40b8593          	addi	a1,s7,-704 # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
800053d8:	06100693          	li	a3,97
800053dc:	cf8a8613          	addi	a2,s5,-776 # 80005cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cf9>
800053e0:	c2cb0513          	addi	a0,s6,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
800053e4:	cf4fc0ef          	jal	ra,800018d8 <printk>
800053e8:	d58c0513          	addi	a0,s8,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
800053ec:	cecfc0ef          	jal	ra,800018d8 <printk>
800053f0:	06100593          	li	a1,97
800053f4:	cf8a8513          	addi	a0,s5,-776
800053f8:	d1cfc0ef          	jal	ra,80001914 <assert_post_action>
800053fc:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80005400:	00cd2783          	lw	a5,12(s10)
80005404:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005408:	00800413          	li	s0,8
8000540c:	000780e7          	jalr	a5
80005410:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005414:	39090513          	addi	a0,s2,912
	key = (mstatus & SOC_MSTATUS_IEN);
80005418:	00847413          	andi	s0,s0,8
8000541c:	bb4ff0ef          	jal	ra,800047d0 <z_spin_lock_valid>
80005420:	02051863          	bnez	a0,80005450 <z_clock_announce+0x254>
80005424:	d10c8593          	addi	a1,s9,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
80005428:	04e00693          	li	a3,78
8000542c:	cf8a8613          	addi	a2,s5,-776
80005430:	c2cb0513          	addi	a0,s6,-980
80005434:	ca4fc0ef          	jal	ra,800018d8 <printk>
80005438:	80006537          	lui	a0,0x80006
8000543c:	d2850513          	addi	a0,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80005440:	c98fc0ef          	jal	ra,800018d8 <printk>
80005444:	04e00593          	li	a1,78
80005448:	cf8a8513          	addi	a0,s5,-776
8000544c:	cc8fc0ef          	jal	ra,80001914 <assert_post_action>
	z_spin_lock_set_owner(l);
80005450:	39090513          	addi	a0,s2,912
80005454:	bd4ff0ef          	jal	ra,80004828 <z_spin_lock_set_owner>
	return k;
80005458:	e6dff06f          	j	800052c4 <z_clock_announce+0xc8>

8000545c <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
8000545c:	00008067          	ret
