
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	14d0106f          	j	80001958 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	7f40106f          	j	80001890 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00007397          	auipc	t2,0x7
800000b8:	44838393          	addi	t2,t2,1096 # 800074fc <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	03d0106f          	j	8000191c <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00006297          	auipc	t0,0x6
800000fc:	db428293          	addi	t0,t0,-588 # 80005eac <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00007317          	auipc	t1,0x7
80000118:	3e830313          	addi	t1,t1,1000 # 800074fc <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00007297          	auipc	t0,0x7
80000140:	3c028293          	addi	t0,t0,960 # 800074fc <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00007397          	auipc	t2,0x7
80000180:	ffc38393          	addi	t2,t2,-4 # 80007178 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00007297          	auipc	t0,0x7
80000230:	2d028293          	addi	t0,t0,720 # 800074fc <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	00058793          	mv	a5,a1
800002b4:	00060813          	mv	a6,a2
800002b8:	00068713          	mv	a4,a3
800002bc:	00050313          	mv	t1,a0
800002c0:	28069663          	bnez	a3,8000054c <__udivdi3+0x29c>
800002c4:	00006897          	auipc	a7,0x6
800002c8:	d6888893          	addi	a7,a7,-664 # 8000602c <__devconfig_end>
800002cc:	0ec5f663          	bgeu	a1,a2,800003b8 <__udivdi3+0x108>
800002d0:	00010737          	lui	a4,0x10
800002d4:	0ce67863          	bgeu	a2,a4,800003a4 <__udivdi3+0xf4>
800002d8:	0ff00713          	li	a4,255
800002dc:	00c73733          	sltu	a4,a4,a2
800002e0:	00371713          	slli	a4,a4,0x3
800002e4:	00e656b3          	srl	a3,a2,a4
800002e8:	00d888b3          	add	a7,a7,a3
800002ec:	0008c683          	lbu	a3,0(a7)
800002f0:	00e68733          	add	a4,a3,a4
800002f4:	02000693          	li	a3,32
800002f8:	40e686b3          	sub	a3,a3,a4
800002fc:	00068c63          	beqz	a3,80000314 <__udivdi3+0x64>
80000300:	00d797b3          	sll	a5,a5,a3
80000304:	00e55733          	srl	a4,a0,a4
80000308:	00d61833          	sll	a6,a2,a3
8000030c:	00f765b3          	or	a1,a4,a5
80000310:	00d51333          	sll	t1,a0,a3
80000314:	01085513          	srli	a0,a6,0x10
80000318:	02a5f733          	remu	a4,a1,a0
8000031c:	01081613          	slli	a2,a6,0x10
80000320:	01065613          	srli	a2,a2,0x10
80000324:	01035693          	srli	a3,t1,0x10
80000328:	02a5d5b3          	divu	a1,a1,a0
8000032c:	01071713          	slli	a4,a4,0x10
80000330:	00d766b3          	or	a3,a4,a3
80000334:	02b607b3          	mul	a5,a2,a1
80000338:	00058713          	mv	a4,a1
8000033c:	00f6fe63          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000340:	010686b3          	add	a3,a3,a6
80000344:	fff58713          	addi	a4,a1,-1
80000348:	0106e863          	bltu	a3,a6,80000358 <__udivdi3+0xa8>
8000034c:	00f6f663          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000350:	ffe58713          	addi	a4,a1,-2
80000354:	010686b3          	add	a3,a3,a6
80000358:	40f686b3          	sub	a3,a3,a5
8000035c:	02a6f7b3          	remu	a5,a3,a0
80000360:	01031313          	slli	t1,t1,0x10
80000364:	01035313          	srli	t1,t1,0x10
80000368:	02a6d6b3          	divu	a3,a3,a0
8000036c:	01079793          	slli	a5,a5,0x10
80000370:	0067e333          	or	t1,a5,t1
80000374:	02d605b3          	mul	a1,a2,a3
80000378:	00068513          	mv	a0,a3
8000037c:	00b37c63          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000380:	00680333          	add	t1,a6,t1
80000384:	fff68513          	addi	a0,a3,-1
80000388:	01036663          	bltu	t1,a6,80000394 <__udivdi3+0xe4>
8000038c:	00b37463          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000390:	ffe68513          	addi	a0,a3,-2
80000394:	01071713          	slli	a4,a4,0x10
80000398:	00a76733          	or	a4,a4,a0
8000039c:	00000593          	li	a1,0
800003a0:	0e40006f          	j	80000484 <__udivdi3+0x1d4>
800003a4:	010006b7          	lui	a3,0x1000
800003a8:	01000713          	li	a4,16
800003ac:	f2d66ce3          	bltu	a2,a3,800002e4 <__udivdi3+0x34>
800003b0:	01800713          	li	a4,24
800003b4:	f31ff06f          	j	800002e4 <__udivdi3+0x34>
800003b8:	00061663          	bnez	a2,800003c4 <__udivdi3+0x114>
800003bc:	00100693          	li	a3,1
800003c0:	02c6d833          	divu	a6,a3,a2
800003c4:	000106b7          	lui	a3,0x10
800003c8:	0cd87263          	bgeu	a6,a3,8000048c <__udivdi3+0x1dc>
800003cc:	0ff00693          	li	a3,255
800003d0:	0106f463          	bgeu	a3,a6,800003d8 <__udivdi3+0x128>
800003d4:	00800713          	li	a4,8
800003d8:	00e856b3          	srl	a3,a6,a4
800003dc:	00d888b3          	add	a7,a7,a3
800003e0:	0008c683          	lbu	a3,0(a7)
800003e4:	00e686b3          	add	a3,a3,a4
800003e8:	02000713          	li	a4,32
800003ec:	40d70733          	sub	a4,a4,a3
800003f0:	0a071863          	bnez	a4,800004a0 <__udivdi3+0x1f0>
800003f4:	410787b3          	sub	a5,a5,a6
800003f8:	00100593          	li	a1,1
800003fc:	01085613          	srli	a2,a6,0x10
80000400:	01081893          	slli	a7,a6,0x10
80000404:	0108d893          	srli	a7,a7,0x10
80000408:	01035693          	srli	a3,t1,0x10
8000040c:	02c7f733          	remu	a4,a5,a2
80000410:	02c7d7b3          	divu	a5,a5,a2
80000414:	01071713          	slli	a4,a4,0x10
80000418:	00d766b3          	or	a3,a4,a3
8000041c:	02f88533          	mul	a0,a7,a5
80000420:	00078713          	mv	a4,a5
80000424:	00a6fe63          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000428:	010686b3          	add	a3,a3,a6
8000042c:	fff78713          	addi	a4,a5,-1
80000430:	0106e863          	bltu	a3,a6,80000440 <__udivdi3+0x190>
80000434:	00a6f663          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000438:	ffe78713          	addi	a4,a5,-2
8000043c:	010686b3          	add	a3,a3,a6
80000440:	40a686b3          	sub	a3,a3,a0
80000444:	02c6f7b3          	remu	a5,a3,a2
80000448:	01031313          	slli	t1,t1,0x10
8000044c:	01035313          	srli	t1,t1,0x10
80000450:	02c6d6b3          	divu	a3,a3,a2
80000454:	01079793          	slli	a5,a5,0x10
80000458:	0067e333          	or	t1,a5,t1
8000045c:	02d888b3          	mul	a7,a7,a3
80000460:	00068513          	mv	a0,a3
80000464:	01137c63          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000468:	00680333          	add	t1,a6,t1
8000046c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000470:	01036663          	bltu	t1,a6,8000047c <__udivdi3+0x1cc>
80000474:	01137463          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000478:	ffe68513          	addi	a0,a3,-2
8000047c:	01071713          	slli	a4,a4,0x10
80000480:	00a76733          	or	a4,a4,a0
80000484:	00070513          	mv	a0,a4
80000488:	00008067          	ret
8000048c:	010006b7          	lui	a3,0x1000
80000490:	01000713          	li	a4,16
80000494:	f4d862e3          	bltu	a6,a3,800003d8 <__udivdi3+0x128>
80000498:	01800713          	li	a4,24
8000049c:	f3dff06f          	j	800003d8 <__udivdi3+0x128>
800004a0:	00e81833          	sll	a6,a6,a4
800004a4:	00d7d5b3          	srl	a1,a5,a3
800004a8:	00e51333          	sll	t1,a0,a4
800004ac:	00d556b3          	srl	a3,a0,a3
800004b0:	01085513          	srli	a0,a6,0x10
800004b4:	00e797b3          	sll	a5,a5,a4
800004b8:	02a5f733          	remu	a4,a1,a0
800004bc:	00f6e8b3          	or	a7,a3,a5
800004c0:	01081793          	slli	a5,a6,0x10
800004c4:	0107d793          	srli	a5,a5,0x10
800004c8:	0108d613          	srli	a2,a7,0x10
800004cc:	02a5d5b3          	divu	a1,a1,a0
800004d0:	01071713          	slli	a4,a4,0x10
800004d4:	00c76733          	or	a4,a4,a2
800004d8:	02b786b3          	mul	a3,a5,a1
800004dc:	00058613          	mv	a2,a1
800004e0:	00d77e63          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004e4:	01070733          	add	a4,a4,a6
800004e8:	fff58613          	addi	a2,a1,-1
800004ec:	01076863          	bltu	a4,a6,800004fc <__udivdi3+0x24c>
800004f0:	00d77663          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004f4:	ffe58613          	addi	a2,a1,-2
800004f8:	01070733          	add	a4,a4,a6
800004fc:	40d706b3          	sub	a3,a4,a3
80000500:	02a6f733          	remu	a4,a3,a0
80000504:	01089893          	slli	a7,a7,0x10
80000508:	0108d893          	srli	a7,a7,0x10
8000050c:	02a6d6b3          	divu	a3,a3,a0
80000510:	01071713          	slli	a4,a4,0x10
80000514:	02d785b3          	mul	a1,a5,a3
80000518:	011767b3          	or	a5,a4,a7
8000051c:	00068713          	mv	a4,a3
80000520:	00b7fe63          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000524:	010787b3          	add	a5,a5,a6
80000528:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000052c:	0107e863          	bltu	a5,a6,8000053c <__udivdi3+0x28c>
80000530:	00b7f663          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000534:	ffe68713          	addi	a4,a3,-2
80000538:	010787b3          	add	a5,a5,a6
8000053c:	40b787b3          	sub	a5,a5,a1
80000540:	01061593          	slli	a1,a2,0x10
80000544:	00e5e5b3          	or	a1,a1,a4
80000548:	eb5ff06f          	j	800003fc <__udivdi3+0x14c>
8000054c:	18d5e663          	bltu	a1,a3,800006d8 <__udivdi3+0x428>
80000550:	00010737          	lui	a4,0x10
80000554:	04e6f463          	bgeu	a3,a4,8000059c <__udivdi3+0x2ec>
80000558:	0ff00813          	li	a6,255
8000055c:	00d83733          	sltu	a4,a6,a3
80000560:	00371713          	slli	a4,a4,0x3
80000564:	00e6d833          	srl	a6,a3,a4
80000568:	00006597          	auipc	a1,0x6
8000056c:	ac458593          	addi	a1,a1,-1340 # 8000602c <__devconfig_end>
80000570:	010585b3          	add	a1,a1,a6
80000574:	0005c803          	lbu	a6,0(a1)
80000578:	02000593          	li	a1,32
8000057c:	00e80833          	add	a6,a6,a4
80000580:	410585b3          	sub	a1,a1,a6
80000584:	02059663          	bnez	a1,800005b0 <__udivdi3+0x300>
80000588:	00100713          	li	a4,1
8000058c:	eef6ece3          	bltu	a3,a5,80000484 <__udivdi3+0x1d4>
80000590:	00c53533          	sltu	a0,a0,a2
80000594:	00154713          	xori	a4,a0,1
80000598:	eedff06f          	j	80000484 <__udivdi3+0x1d4>
8000059c:	010005b7          	lui	a1,0x1000
800005a0:	01000713          	li	a4,16
800005a4:	fcb6e0e3          	bltu	a3,a1,80000564 <__udivdi3+0x2b4>
800005a8:	01800713          	li	a4,24
800005ac:	fb9ff06f          	j	80000564 <__udivdi3+0x2b4>
800005b0:	01065733          	srl	a4,a2,a6
800005b4:	00b696b3          	sll	a3,a3,a1
800005b8:	00d766b3          	or	a3,a4,a3
800005bc:	0106de93          	srli	t4,a3,0x10
800005c0:	0107d733          	srl	a4,a5,a6
800005c4:	03d778b3          	remu	a7,a4,t4
800005c8:	00b797b3          	sll	a5,a5,a1
800005cc:	01055833          	srl	a6,a0,a6
800005d0:	00f86333          	or	t1,a6,a5
800005d4:	01069793          	slli	a5,a3,0x10
800005d8:	0107d793          	srli	a5,a5,0x10
800005dc:	01035813          	srli	a6,t1,0x10
800005e0:	00b61633          	sll	a2,a2,a1
800005e4:	03d75733          	divu	a4,a4,t4
800005e8:	01089893          	slli	a7,a7,0x10
800005ec:	0108e833          	or	a6,a7,a6
800005f0:	02e78f33          	mul	t5,a5,a4
800005f4:	00070e13          	mv	t3,a4
800005f8:	01e87e63          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
800005fc:	00d80833          	add	a6,a6,a3
80000600:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000604:	00d86863          	bltu	a6,a3,80000614 <__udivdi3+0x364>
80000608:	01e87663          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
8000060c:	ffe70e13          	addi	t3,a4,-2
80000610:	00d80833          	add	a6,a6,a3
80000614:	41e80833          	sub	a6,a6,t5
80000618:	03d878b3          	remu	a7,a6,t4
8000061c:	03d85833          	divu	a6,a6,t4
80000620:	01089893          	slli	a7,a7,0x10
80000624:	03078eb3          	mul	t4,a5,a6
80000628:	01031793          	slli	a5,t1,0x10
8000062c:	0107d793          	srli	a5,a5,0x10
80000630:	00f8e7b3          	or	a5,a7,a5
80000634:	00080713          	mv	a4,a6
80000638:	01d7fe63          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000063c:	00d787b3          	add	a5,a5,a3
80000640:	fff80713          	addi	a4,a6,-1
80000644:	00d7e863          	bltu	a5,a3,80000654 <__udivdi3+0x3a4>
80000648:	01d7f663          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000064c:	ffe80713          	addi	a4,a6,-2
80000650:	00d787b3          	add	a5,a5,a3
80000654:	010e1e13          	slli	t3,t3,0x10
80000658:	41d787b3          	sub	a5,a5,t4
8000065c:	00010eb7          	lui	t4,0x10
80000660:	00ee6733          	or	a4,t3,a4
80000664:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000668:	01077333          	and	t1,a4,a6
8000066c:	01075893          	srli	a7,a4,0x10
80000670:	01067833          	and	a6,a2,a6
80000674:	01065613          	srli	a2,a2,0x10
80000678:	03030e33          	mul	t3,t1,a6
8000067c:	03088833          	mul	a6,a7,a6
80000680:	010e5693          	srli	a3,t3,0x10
80000684:	02c30333          	mul	t1,t1,a2
80000688:	01030333          	add	t1,t1,a6
8000068c:	006686b3          	add	a3,a3,t1
80000690:	02c888b3          	mul	a7,a7,a2
80000694:	0106f463          	bgeu	a3,a6,8000069c <__udivdi3+0x3ec>
80000698:	01d888b3          	add	a7,a7,t4
8000069c:	0106d613          	srli	a2,a3,0x10
800006a0:	011608b3          	add	a7,a2,a7
800006a4:	0317e663          	bltu	a5,a7,800006d0 <__udivdi3+0x420>
800006a8:	cf179ae3          	bne	a5,a7,8000039c <__udivdi3+0xec>
800006ac:	000107b7          	lui	a5,0x10
800006b0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006b4:	00f6f6b3          	and	a3,a3,a5
800006b8:	01069693          	slli	a3,a3,0x10
800006bc:	00fe7e33          	and	t3,t3,a5
800006c0:	00b51533          	sll	a0,a0,a1
800006c4:	01c686b3          	add	a3,a3,t3
800006c8:	00000593          	li	a1,0
800006cc:	dad57ce3          	bgeu	a0,a3,80000484 <__udivdi3+0x1d4>
800006d0:	fff70713          	addi	a4,a4,-1
800006d4:	cc9ff06f          	j	8000039c <__udivdi3+0xec>
800006d8:	00000593          	li	a1,0
800006dc:	00000713          	li	a4,0
800006e0:	da5ff06f          	j	80000484 <__udivdi3+0x1d4>

800006e4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006e4:	00008067          	ret

800006e8 <init_timer_data>:
		}				 \
	} while (0)

static void init_timer_data(void)
{
	tdata.expire_cnt = 0;
800006e8:	800077b7          	lui	a5,0x80007
800006ec:	32078793          	addi	a5,a5,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
800006f0:	0007a023          	sw	zero,0(a5)
	tdata.stop_cnt = 0;
800006f4:	0007a223          	sw	zero,4(a5)
}
800006f8:	00008067          	ret

800006fc <duration_stop>:
	}
}

static void duration_stop(struct k_timer *timer)
{
	tdata.stop_cnt++;
800006fc:	800077b7          	lui	a5,0x80007
80000700:	32078793          	addi	a5,a5,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
80000704:	0047a703          	lw	a4,4(a5)
80000708:	00170713          	addi	a4,a4,1
8000070c:	00e7a223          	sw	a4,4(a5)
}
80000710:	00008067          	ret

80000714 <period0_expire>:

static void period0_expire(struct k_timer *timer)
{
	tdata.expire_cnt++;
80000714:	800077b7          	lui	a5,0x80007
80000718:	32078793          	addi	a5,a5,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
8000071c:	0007a703          	lw	a4,0(a5)
80000720:	00170713          	addi	a4,a4,1
80000724:	00e7a023          	sw	a4,0(a5)
}
80000728:	00008067          	ret

8000072c <user_data_timer_handler>:

static int user_data_correct[5] = { 0, 0, 0, 0, 0 };

static void user_data_timer_handler(struct k_timer *timer)
{
	int timer_num = timer == user_data_timer[0] ? 0 :
8000072c:	800077b7          	lui	a5,0x80007
80000730:	1dc78793          	addi	a5,a5,476 # 800071dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071dd>
80000734:	06f50663          	beq	a0,a5,800007a0 <user_data_timer_handler+0x74>
			timer == user_data_timer[1] ? 1 :
80000738:	800077b7          	lui	a5,0x80007
8000073c:	20878793          	addi	a5,a5,520 # 80007208 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007209>
80000740:	06f50463          	beq	a0,a5,800007a8 <user_data_timer_handler+0x7c>
			timer == user_data_timer[2] ? 2 :
80000744:	800077b7          	lui	a5,0x80007
80000748:	23478793          	addi	a5,a5,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
8000074c:	06f50263          	beq	a0,a5,800007b0 <user_data_timer_handler+0x84>
			timer == user_data_timer[3] ? 3 :
80000750:	800077b7          	lui	a5,0x80007
80000754:	26078793          	addi	a5,a5,608 # 80007260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007261>
80000758:	06f50063          	beq	a0,a5,800007b8 <user_data_timer_handler+0x8c>
			timer == user_data_timer[4] ? 4 : -1;
8000075c:	800077b7          	lui	a5,0x80007
80000760:	28c78793          	addi	a5,a5,652 # 8000728c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000728d>
80000764:	02f51c63          	bne	a0,a5,8000079c <user_data_timer_handler+0x70>
80000768:	00400793          	li	a5,4
	if (timer_num == -1) {
		return;
	}

	intptr_t data_retrieved = (intptr_t)k_timer_user_data_get(timer);
	user_data_correct[timer_num] = user_data[timer_num] == data_retrieved;
8000076c:	800066b7          	lui	a3,0x80006
80000770:	00279793          	slli	a5,a5,0x2
80000774:	80007737          	lui	a4,0x80007
80000778:	68068693          	addi	a3,a3,1664 # 80006680 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006681>
8000077c:	00f686b3          	add	a3,a3,a5
80000780:	38870713          	addi	a4,a4,904 # 80007388 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007389>
80000784:	00f70733          	add	a4,a4,a5
80000788:	0006a683          	lw	a3,0(a3)
8000078c:	02852783          	lw	a5,40(a0)
80000790:	40d787b3          	sub	a5,a5,a3
80000794:	0017b793          	seqz	a5,a5
80000798:	00f72023          	sw	a5,0(a4)
}
8000079c:	00008067          	ret
	int timer_num = timer == user_data_timer[0] ? 0 :
800007a0:	00000793          	li	a5,0
800007a4:	fc9ff06f          	j	8000076c <user_data_timer_handler+0x40>
			timer == user_data_timer[1] ? 1 :
800007a8:	00100793          	li	a5,1
800007ac:	fc1ff06f          	j	8000076c <user_data_timer_handler+0x40>
			timer == user_data_timer[2] ? 2 :
800007b0:	00200793          	li	a5,2
800007b4:	fb9ff06f          	j	8000076c <user_data_timer_handler+0x40>
			timer == user_data_timer[3] ? 3 :
800007b8:	00300793          	li	a5,3
800007bc:	fb1ff06f          	j	8000076c <user_data_timer_handler+0x40>

800007c0 <z_impl_k_timer_remaining_get>:
 * @return Remaining time (in milliseconds).
 */
__syscall u32_t k_timer_remaining_get(struct k_timer *timer);

static inline u32_t z_impl_k_timer_remaining_get(struct k_timer *timer)
{
800007c0:	ff010113          	addi	sp,sp,-16
800007c4:	00112623          	sw	ra,12(sp)
	const s32_t ticks = z_timeout_remaining(&timer->timeout);
800007c8:	335040ef          	jal	ra,800052fc <z_timeout_remaining>
	return (ticks > 0) ? (u32_t)__ticks_to_ms(ticks) : 0U;
800007cc:	02a05463          	blez	a0,800007f4 <z_impl_k_timer_remaining_get+0x34>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800007d0:	3e800793          	li	a5,1000
800007d4:	02f515b3          	mulh	a1,a0,a5
800007d8:	06400613          	li	a2,100
800007dc:	00000693          	li	a3,0
800007e0:	02f50533          	mul	a0,a0,a5
800007e4:	acdff0ef          	jal	ra,800002b0 <__udivdi3>
}
800007e8:	00c12083          	lw	ra,12(sp)
800007ec:	01010113          	addi	sp,sp,16
800007f0:	00008067          	ret
	return (ticks > 0) ? (u32_t)__ticks_to_ms(ticks) : 0U;
800007f4:	00000513          	li	a0,0
800007f8:	ff1ff06f          	j	800007e8 <z_impl_k_timer_remaining_get+0x28>

800007fc <z_zassert.constprop.6>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
800007fc:	fd010113          	addi	sp,sp,-48
80000800:	00112e23          	sw	ra,28(sp)
80000804:	03012423          	sw	a6,40(sp)
80000808:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
8000080c:	04051663          	bnez	a0,80000858 <z_zassert.constprop.6+0x5c>
80000810:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000814:	80006537          	lui	a0,0x80006
80000818:	00070693          	mv	a3,a4
8000081c:	00058713          	mv	a4,a1
80000820:	800065b7          	lui	a1,0x80006
		va_start(vargs, msg);
80000824:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000828:	6a858593          	addi	a1,a1,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
8000082c:	6d450513          	addi	a0,a0,1748 # 800066d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d5>
		va_start(vargs, msg);
80000830:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000834:	239010ef          	jal	ra,8000226c <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000838:	00c12583          	lw	a1,12(sp)
8000083c:	80006537          	lui	a0,0x80006
80000840:	75050513          	addi	a0,a0,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000844:	1f9010ef          	jal	ra,8000223c <vprintk>
		printk("\n");
80000848:	80007537          	lui	a0,0x80007
8000084c:	08450513          	addi	a0,a0,132 # 80007084 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007085>
80000850:	21d010ef          	jal	ra,8000226c <printk>
		va_end(vargs);
		ztest_test_fail();
80000854:	0f8020ef          	jal	ra,8000294c <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000858:	01c12083          	lw	ra,28(sp)
8000085c:	03010113          	addi	sp,sp,48
80000860:	00008067          	ret

80000864 <test_timer_user_data>:
 *
 * @see K_TIMER_DEFINE(), k_timer_user_data_set(), k_timer_start(),
 * k_timer_user_data_get(), k_timer_stop()
 */
void test_timer_user_data(void)
{
80000864:	fd010113          	addi	sp,sp,-48
80000868:	02812423          	sw	s0,40(sp)
8000086c:	03212023          	sw	s2,32(sp)
80000870:	01412c23          	sw	s4,24(sp)
80000874:	01512a23          	sw	s5,20(sp)
	int ii;

	for (ii = 0; ii < 5; ii++) {
		intptr_t check;

		k_timer_user_data_set(user_data_timer[ii],
80000878:	80006437          	lui	s0,0x80006
				      (void *)user_data[ii]);
8000087c:	80006937          	lui	s2,0x80006
		check = (intptr_t)k_timer_user_data_get(user_data_timer[ii]);

		zassert_true(check == user_data[ii], NULL);
80000880:	80006a37          	lui	s4,0x80006
80000884:	80006ab7          	lui	s5,0x80006
{
80000888:	02912223          	sw	s1,36(sp)
8000088c:	01312e23          	sw	s3,28(sp)
80000890:	01612823          	sw	s6,16(sp)
80000894:	01712623          	sw	s7,12(sp)
80000898:	02112623          	sw	ra,44(sp)
8000089c:	00000493          	li	s1,0
		k_timer_user_data_set(user_data_timer[ii],
800008a0:	69440413          	addi	s0,s0,1684 # 80006694 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006695>
				      (void *)user_data[ii]);
800008a4:	68090913          	addi	s2,s2,1664 # 80006680 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006681>
		zassert_true(check == user_data[ii], NULL);
800008a8:	800069b7          	lui	s3,0x80006
800008ac:	000a0b13          	mv	s6,s4
800008b0:	000a8b93          	mv	s7,s5
		k_timer_user_data_set(user_data_timer[ii],
800008b4:	009407b3          	add	a5,s0,s1
				      (void *)user_data[ii]);
800008b8:	00990733          	add	a4,s2,s1
		k_timer_user_data_set(user_data_timer[ii],
800008bc:	0007a783          	lw	a5,0(a5)
 * @internal
 */
static inline void z_impl_k_timer_user_data_set(struct k_timer *timer,
					       void *user_data)
{
	timer->user_data = user_data;
800008c0:	00072703          	lw	a4,0(a4)
		zassert_true(check == user_data[ii], NULL);
800008c4:	800065b7          	lui	a1,0x80006
800008c8:	1d500693          	li	a3,469
800008cc:	02e7a423          	sw	a4,40(a5)
800008d0:	6a898613          	addi	a2,s3,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800008d4:	750a8793          	addi	a5,s5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
800008d8:	220a0713          	addi	a4,s4,544 # 80006220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006221>
800008dc:	64058593          	addi	a1,a1,1600 # 80006640 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006641>
800008e0:	00100513          	li	a0,1
800008e4:	f19ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
800008e8:	00448493          	addi	s1,s1,4
	for (ii = 0; ii < 5; ii++) {
800008ec:	01400793          	li	a5,20
800008f0:	fcf492e3          	bne	s1,a5,800008b4 <test_timer_user_data+0x50>
800008f4:	03200493          	li	s1,50
	}

	for (ii = 0; ii < 5; ii++) {
800008f8:	12c00913          	li	s2,300

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_NAME_SET, k_thread_name_set, k_tid_t, thread_id, const char *, value)

K_SYSCALL_DECLARE1(K_SYSCALL_K_THREAD_NAME_GET, k_thread_name_get, const char *, k_tid_t, thread_id)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800008fc:	00042503          	lw	a0,0(s0)
80000900:	00048593          	mv	a1,s1
80000904:	00000613          	li	a2,0
80000908:	03248493          	addi	s1,s1,50
8000090c:	164050ef          	jal	ra,80005a70 <z_impl_k_timer_start>
80000910:	00440413          	addi	s0,s0,4
80000914:	ff2494e3          	bne	s1,s2,800008fc <test_timer_user_data+0x98>
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000918:	12c00513          	li	a0,300
8000091c:	26d030ef          	jal	ra,80004388 <z_impl_k_sleep>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000920:	80007537          	lui	a0,0x80007
80000924:	1dc50513          	addi	a0,a0,476 # 800071dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071dd>
80000928:	210050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
8000092c:	80007537          	lui	a0,0x80007
80000930:	20850513          	addi	a0,a0,520 # 80007208 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007209>
80000934:	204050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000938:	80007537          	lui	a0,0x80007
8000093c:	23450513          	addi	a0,a0,564 # 80007234 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007235>
80000940:	1f8050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000944:	80007537          	lui	a0,0x80007
80000948:	26050513          	addi	a0,a0,608 # 80007260 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007261>
8000094c:	1ec050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000950:	80007537          	lui	a0,0x80007
80000954:	80007437          	lui	s0,0x80007
80000958:	28c50513          	addi	a0,a0,652 # 8000728c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000728d>
8000095c:	38840413          	addi	s0,s0,904 # 80007388 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007389>
80000960:	1d8050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000964:	01440493          	addi	s1,s0,20
	for (ii = 0; ii < 5; ii++) {
		k_timer_stop(user_data_timer[ii]);
	}

	for (ii = 0; ii < 5; ii++) {
		zassert_true(user_data_correct[ii], NULL);
80000968:	80006937          	lui	s2,0x80006
8000096c:	00042503          	lw	a0,0(s0)
80000970:	750b8793          	addi	a5,s7,1872
80000974:	220b0713          	addi	a4,s6,544
80000978:	1e300693          	li	a3,483
8000097c:	6a898613          	addi	a2,s3,1704
80000980:	66090593          	addi	a1,s2,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80000984:	00440413          	addi	s0,s0,4
80000988:	e75ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	for (ii = 0; ii < 5; ii++) {
8000098c:	fe8490e3          	bne	s1,s0,8000096c <test_timer_user_data+0x108>
	}
}
80000990:	02c12083          	lw	ra,44(sp)
80000994:	02812403          	lw	s0,40(sp)
80000998:	02412483          	lw	s1,36(sp)
8000099c:	02012903          	lw	s2,32(sp)
800009a0:	01c12983          	lw	s3,28(sp)
800009a4:	01812a03          	lw	s4,24(sp)
800009a8:	01412a83          	lw	s5,20(sp)
800009ac:	01012b03          	lw	s6,16(sp)
800009b0:	00c12b83          	lw	s7,12(sp)
800009b4:	03010113          	addi	sp,sp,48
800009b8:	00008067          	ret

800009bc <test_timer_remaining_get>:
 * @see k_timer_init(), k_timer_start(), k_timer_stop(),
 * k_timer_remaining_get()
 */

void test_timer_remaining_get(void)
{
800009bc:	ff010113          	addi	sp,sp,-16
800009c0:	00112623          	sw	ra,12(sp)
800009c4:	00812423          	sw	s0,8(sp)
800009c8:	00912223          	sw	s1,4(sp)
	u32_t remaining;

	init_timer_data();
	k_timer_init(&timer, NULL, NULL);
800009cc:	80007437          	lui	s0,0x80007
	init_timer_data();
800009d0:	d19ff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
800009d4:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
800009d8:	00000613          	li	a2,0
800009dc:	00000593          	li	a1,0
800009e0:	068050ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800009e4:	00000613          	li	a2,0
800009e8:	06400593          	li	a1,100
800009ec:	35c40513          	addi	a0,s0,860
800009f0:	080050ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800009f4:	0000c537          	lui	a0,0xc
800009f8:	35050513          	addi	a0,a0,848 # c350 <CONFIG_ISR_STACK_SIZE+0xbb50>
800009fc:	78d030ef          	jal	ra,80004988 <z_impl_k_busy_wait>

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000a00:	35c40513          	addi	a0,s0,860
80000a04:	dbdff0ef          	jal	ra,800007c0 <z_impl_k_timer_remaining_get>
80000a08:	00050493          	mv	s1,a0
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000a0c:	35c40513          	addi	a0,s0,860
80000a10:	128050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
	k_timer_start(&timer, DURATION, 0);
	busy_wait_ms(DURATION / 2);
	remaining = k_timer_remaining_get(&timer);
	k_timer_stop(&timer);
	zassert_true(remaining <= (DURATION / 2), NULL);
}
80000a14:	00812403          	lw	s0,8(sp)
80000a18:	00c12083          	lw	ra,12(sp)
	zassert_true(remaining <= (DURATION / 2), NULL);
80000a1c:	0334b513          	sltiu	a0,s1,51
}
80000a20:	00412483          	lw	s1,4(sp)
	zassert_true(remaining <= (DURATION / 2), NULL);
80000a24:	800067b7          	lui	a5,0x80006
80000a28:	80006737          	lui	a4,0x80006
80000a2c:	80006637          	lui	a2,0x80006
80000a30:	800065b7          	lui	a1,0x80006
80000a34:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000a38:	23870713          	addi	a4,a4,568 # 80006238 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006239>
80000a3c:	20000693          	li	a3,512
80000a40:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000a44:	51858593          	addi	a1,a1,1304 # 80006518 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006519>
}
80000a48:	01010113          	addi	sp,sp,16
	zassert_true(remaining <= (DURATION / 2), NULL);
80000a4c:	db1ff06f          	j	800007fc <z_zassert.constprop.6>

80000a50 <status_expire>:
{
80000a50:	ff010113          	addi	sp,sp,-16
80000a54:	00812423          	sw	s0,8(sp)
80000a58:	00112623          	sw	ra,12(sp)
80000a5c:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000a60:	160050ef          	jal	ra,80005bc0 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(timer) == 1, timer);
80000a64:	00100793          	li	a5,1
80000a68:	04f50263          	beq	a0,a5,80000aac <status_expire+0x5c>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000a6c:	00040513          	mv	a0,s0
80000a70:	0c8050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000a74:	00040513          	mv	a0,s0
80000a78:	148050ef          	jal	ra,80005bc0 <z_impl_k_timer_status_get>
80000a7c:	fff50513          	addi	a0,a0,-1
80000a80:	800067b7          	lui	a5,0x80006
80000a84:	80006737          	lui	a4,0x80006
80000a88:	80006637          	lui	a2,0x80006
80000a8c:	800065b7          	lui	a1,0x80006
80000a90:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000a94:	13c70713          	addi	a4,a4,316 # 8000613c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000613d>
80000a98:	04b00693          	li	a3,75
80000a9c:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000aa0:	2b858593          	addi	a1,a1,696 # 800062b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062b9>
80000aa4:	00153513          	seqz	a0,a0
80000aa8:	d55ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000aac:	00040513          	mv	a0,s0
80000ab0:	d11ff0ef          	jal	ra,800007c0 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(timer) >= PERIOD, timer);
80000ab4:	03100793          	li	a5,49
80000ab8:	04a7e263          	bltu	a5,a0,80000afc <status_expire+0xac>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000abc:	00040513          	mv	a0,s0
80000ac0:	078050ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000ac4:	00040513          	mv	a0,s0
80000ac8:	cf9ff0ef          	jal	ra,800007c0 <z_impl_k_timer_remaining_get>
80000acc:	03253513          	sltiu	a0,a0,50
80000ad0:	800067b7          	lui	a5,0x80006
80000ad4:	80006737          	lui	a4,0x80006
80000ad8:	80006637          	lui	a2,0x80006
80000adc:	800065b7          	lui	a1,0x80006
80000ae0:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000ae4:	13c70713          	addi	a4,a4,316 # 8000613c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000613d>
80000ae8:	04d00693          	li	a3,77
80000aec:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000af0:	2e058593          	addi	a1,a1,736 # 800062e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e1>
80000af4:	00154513          	xori	a0,a0,1
80000af8:	d05ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
80000afc:	800077b7          	lui	a5,0x80007
80000b00:	3207a703          	lw	a4,800(a5) # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
80000b04:	00300793          	li	a5,3
80000b08:	00e7dc63          	bge	a5,a4,80000b20 <status_expire+0xd0>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000b0c:	00040513          	mv	a0,s0
}
80000b10:	00812403          	lw	s0,8(sp)
80000b14:	00c12083          	lw	ra,12(sp)
80000b18:	01010113          	addi	sp,sp,16
80000b1c:	01c0506f          	j	80005b38 <z_impl_k_timer_stop>
80000b20:	00c12083          	lw	ra,12(sp)
80000b24:	00812403          	lw	s0,8(sp)
80000b28:	01010113          	addi	sp,sp,16
80000b2c:	00008067          	ret

80000b30 <status_stop>:
{
80000b30:	ff010113          	addi	sp,sp,-16
80000b34:	00812423          	sw	s0,8(sp)
80000b38:	00112623          	sw	ra,12(sp)
80000b3c:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000b40:	c81ff0ef          	jal	ra,800007c0 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000b44:	04050663          	beqz	a0,80000b90 <status_stop+0x60>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000b48:	00040513          	mv	a0,s0
80000b4c:	7ed040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000b50:	00040513          	mv	a0,s0
80000b54:	c6dff0ef          	jal	ra,800007c0 <z_impl_k_timer_remaining_get>
}
80000b58:	00812403          	lw	s0,8(sp)
80000b5c:	00c12083          	lw	ra,12(sp)
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000b60:	800067b7          	lui	a5,0x80006
80000b64:	80006737          	lui	a4,0x80006
80000b68:	80006637          	lui	a2,0x80006
80000b6c:	800065b7          	lui	a1,0x80006
80000b70:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000b74:	14c70713          	addi	a4,a4,332 # 8000614c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000614d>
80000b78:	05c00693          	li	a3,92
80000b7c:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000b80:	30c58593          	addi	a1,a1,780 # 8000630c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000630d>
80000b84:	00153513          	seqz	a0,a0
}
80000b88:	01010113          	addi	sp,sp,16
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000b8c:	c71ff06f          	j	800007fc <z_zassert.constprop.6>
}
80000b90:	00c12083          	lw	ra,12(sp)
80000b94:	00812403          	lw	s0,8(sp)
80000b98:	01010113          	addi	sp,sp,16
80000b9c:	00008067          	ret

80000ba0 <test_timer_status_get>:
{
80000ba0:	ff010113          	addi	sp,sp,-16
80000ba4:	00112623          	sw	ra,12(sp)
80000ba8:	00812423          	sw	s0,8(sp)
	init_timer_data();
80000bac:	b3dff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, status_expire, status_stop);
80000bb0:	80007437          	lui	s0,0x80007
80000bb4:	80001637          	lui	a2,0x80001
80000bb8:	800015b7          	lui	a1,0x80001
80000bbc:	b3060613          	addi	a2,a2,-1232 # 80000b30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b31>
80000bc0:	a5058593          	addi	a1,a1,-1456 # 80000a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a51>
80000bc4:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
80000bc8:	681040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000bcc:	35c40513          	addi	a0,s0,860
80000bd0:	03200613          	li	a2,50
80000bd4:	06400593          	li	a1,100
80000bd8:	699040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000bdc:	35c40513          	addi	a0,s0,860
80000be0:	7e1040ef          	jal	ra,80005bc0 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(&timer) == 0, &timer);
80000be4:	04050063          	beqz	a0,80000c24 <test_timer_status_get+0x84>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000be8:	35c40513          	addi	a0,s0,860
80000bec:	74d040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000bf0:	35c40513          	addi	a0,s0,860
80000bf4:	7cd040ef          	jal	ra,80005bc0 <z_impl_k_timer_status_get>
80000bf8:	800067b7          	lui	a5,0x80006
80000bfc:	80006737          	lui	a4,0x80006
80000c00:	80006637          	lui	a2,0x80006
80000c04:	800065b7          	lui	a1,0x80006
80000c08:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000c0c:	1bc70713          	addi	a4,a4,444 # 800061bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061bd>
80000c10:	11f00693          	li	a3,287
80000c14:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000c18:	54058593          	addi	a1,a1,1344 # 80006540 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006541>
80000c1c:	00153513          	seqz	a0,a0
80000c20:	bddff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000c24:	35c40513          	addi	a0,s0,860
80000c28:	b99ff0ef          	jal	ra,800007c0 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(&timer) >= DURATION / 2, &timer);
80000c2c:	03100793          	li	a5,49
80000c30:	04a7e263          	bltu	a5,a0,80000c74 <test_timer_status_get+0xd4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000c34:	35c40513          	addi	a0,s0,860
80000c38:	701040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000c3c:	35c40513          	addi	a0,s0,860
80000c40:	b81ff0ef          	jal	ra,800007c0 <z_impl_k_timer_remaining_get>
80000c44:	03253513          	sltiu	a0,a0,50
80000c48:	800067b7          	lui	a5,0x80006
80000c4c:	80006737          	lui	a4,0x80006
80000c50:	80006637          	lui	a2,0x80006
80000c54:	800065b7          	lui	a1,0x80006
80000c58:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000c5c:	1bc70713          	addi	a4,a4,444 # 800061bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061bd>
80000c60:	12100693          	li	a3,289
80000c64:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000c68:	56c58593          	addi	a1,a1,1388 # 8000656c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000656d>
80000c6c:	00154513          	xori	a0,a0,1
80000c70:	b8dff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000c74:	35c40513          	addi	a0,s0,860
}
80000c78:	00812403          	lw	s0,8(sp)
80000c7c:	00c12083          	lw	ra,12(sp)
80000c80:	01010113          	addi	sp,sp,16
80000c84:	6b50406f          	j	80005b38 <z_impl_k_timer_stop>

80000c88 <test_timer_status_get_anytime>:
{
80000c88:	ff010113          	addi	sp,sp,-16
80000c8c:	00112623          	sw	ra,12(sp)
80000c90:	00812423          	sw	s0,8(sp)
	init_timer_data();
80000c94:	a55ff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
80000c98:	80007437          	lui	s0,0x80007
80000c9c:	00000613          	li	a2,0
80000ca0:	00000593          	li	a1,0
80000ca4:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
80000ca8:	5a1040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000cac:	03200613          	li	a2,50
80000cb0:	06400593          	li	a1,100
80000cb4:	35c40513          	addi	a0,s0,860
80000cb8:	5b9040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000cbc:	00043537          	lui	a0,0x43
80000cc0:	23850513          	addi	a0,a0,568 # 43238 <CONFIG_RISCV_RAM_SIZE+0x3238>
80000cc4:	4c5030ef          	jal	ra,80004988 <z_impl_k_busy_wait>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000cc8:	35c40513          	addi	a0,s0,860
80000ccc:	6f5040ef          	jal	ra,80005bc0 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(&timer) == EXPIRE_TIMES, &timer);
80000cd0:	00400793          	li	a5,4
80000cd4:	04f50263          	beq	a0,a5,80000d18 <test_timer_status_get_anytime+0x90>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000cd8:	35c40513          	addi	a0,s0,860
80000cdc:	65d040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000ce0:	35c40513          	addi	a0,s0,860
80000ce4:	6dd040ef          	jal	ra,80005bc0 <z_impl_k_timer_status_get>
80000ce8:	ffc50513          	addi	a0,a0,-4
80000cec:	800067b7          	lui	a5,0x80006
80000cf0:	80006737          	lui	a4,0x80006
80000cf4:	80006637          	lui	a2,0x80006
80000cf8:	800065b7          	lui	a1,0x80006
80000cfc:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000d00:	1d470713          	addi	a4,a4,468 # 800061d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d5>
80000d04:	13e00693          	li	a3,318
80000d08:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000d0c:	5a058593          	addi	a1,a1,1440 # 800065a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065a1>
80000d10:	00153513          	seqz	a0,a0
80000d14:	ae9ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000d18:	35c40513          	addi	a0,s0,860
}
80000d1c:	00812403          	lw	s0,8(sp)
80000d20:	00c12083          	lw	ra,12(sp)
80000d24:	01010113          	addi	sp,sp,16
80000d28:	6110406f          	j	80005b38 <z_impl_k_timer_stop>

80000d2c <test_timer_status_sync>:
{
80000d2c:	fd010113          	addi	sp,sp,-48
80000d30:	02112623          	sw	ra,44(sp)
80000d34:	02812423          	sw	s0,40(sp)
80000d38:	02912223          	sw	s1,36(sp)
80000d3c:	03212023          	sw	s2,32(sp)
80000d40:	01312e23          	sw	s3,28(sp)
80000d44:	01412c23          	sw	s4,24(sp)
80000d48:	01512a23          	sw	s5,20(sp)
80000d4c:	01612823          	sw	s6,16(sp)
80000d50:	01712623          	sw	s7,12(sp)
80000d54:	01812423          	sw	s8,8(sp)
80000d58:	01912223          	sw	s9,4(sp)
80000d5c:	01a12023          	sw	s10,0(sp)
	init_timer_data();
80000d60:	989ff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, duration_expire, duration_stop);
80000d64:	80007437          	lui	s0,0x80007
80000d68:	80000637          	lui	a2,0x80000
80000d6c:	800015b7          	lui	a1,0x80001
80000d70:	6fc60613          	addi	a2,a2,1788 # 800006fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800006fd>
80000d74:	53c58593          	addi	a1,a1,1340 # 8000153c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000153d>
80000d78:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
80000d7c:	4cd040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000d80:	03200613          	li	a2,50
80000d84:	06400593          	li	a1,100
80000d88:	35c40513          	addi	a0,s0,860
80000d8c:	4e5040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
	for (int i = 0; i < EXPIRE_TIMES; i++) {
80000d90:	00000493          	li	s1,0
		TIMER_ASSERT(tdata.expire_cnt == i, &timer);
80000d94:	80007ab7          	lui	s5,0x80007
80000d98:	80006937          	lui	s2,0x80006
80000d9c:	800069b7          	lui	s3,0x80006
80000da0:	80006a37          	lui	s4,0x80006
80000da4:	80006bb7          	lui	s7,0x80006
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80000da8:	00100b13          	li	s6,1
80000dac:	80006c37          	lui	s8,0x80006
		TIMER_ASSERT(tdata.expire_cnt == (i + 1), &timer);
80000db0:	80006cb7          	lui	s9,0x80006
		TIMER_ASSERT(tdata.expire_cnt == i, &timer);
80000db4:	320aa783          	lw	a5,800(s5) # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
80000db8:	320a8d13          	addi	s10,s5,800
80000dbc:	02978863          	beq	a5,s1,80000dec <test_timer_status_sync+0xc0>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000dc0:	35c40513          	addi	a0,s0,860
80000dc4:	575040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000dc8:	000d2503          	lw	a0,0(s10)
80000dcc:	75098793          	addi	a5,s3,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000dd0:	1f490713          	addi	a4,s2,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80000dd4:	40950533          	sub	a0,a0,s1
80000dd8:	15c00693          	li	a3,348
80000ddc:	6a8a0613          	addi	a2,s4,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000de0:	5ccb8593          	addi	a1,s7,1484 # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
80000de4:	00153513          	seqz	a0,a0
80000de8:	a15ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80000dec:	35c40513          	addi	a0,s0,860
80000df0:	6b9040ef          	jal	ra,80005ca8 <z_impl_k_timer_status_sync>
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80000df4:	03650a63          	beq	a0,s6,80000e28 <test_timer_status_sync+0xfc>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000df8:	35c40513          	addi	a0,s0,860
80000dfc:	53d040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80000e00:	35c40513          	addi	a0,s0,860
80000e04:	6a5040ef          	jal	ra,80005ca8 <z_impl_k_timer_status_sync>
80000e08:	fff50513          	addi	a0,a0,-1
80000e0c:	75098793          	addi	a5,s3,1872
80000e10:	1f490713          	addi	a4,s2,500
80000e14:	15e00693          	li	a3,350
80000e18:	6a8a0613          	addi	a2,s4,1704
80000e1c:	5ecc0593          	addi	a1,s8,1516 # 800065ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065ed>
80000e20:	00153513          	seqz	a0,a0
80000e24:	9d9ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
		TIMER_ASSERT(tdata.expire_cnt == (i + 1), &timer);
80000e28:	000d2783          	lw	a5,0(s10)
80000e2c:	00148493          	addi	s1,s1,1
80000e30:	02978863          	beq	a5,s1,80000e60 <test_timer_status_sync+0x134>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000e34:	35c40513          	addi	a0,s0,860
80000e38:	501040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000e3c:	000d2503          	lw	a0,0(s10)
80000e40:	75098793          	addi	a5,s3,1872
80000e44:	1f490713          	addi	a4,s2,500
80000e48:	40950533          	sub	a0,a0,s1
80000e4c:	16000693          	li	a3,352
80000e50:	6a8a0613          	addi	a2,s4,1704
80000e54:	618c8593          	addi	a1,s9,1560 # 80006618 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006619>
80000e58:	00153513          	seqz	a0,a0
80000e5c:	9a1ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	for (int i = 0; i < EXPIRE_TIMES; i++) {
80000e60:	00400793          	li	a5,4
80000e64:	f4f498e3          	bne	s1,a5,80000db4 <test_timer_status_sync+0x88>
80000e68:	35c40513          	addi	a0,s0,860
}
80000e6c:	02812403          	lw	s0,40(sp)
80000e70:	02c12083          	lw	ra,44(sp)
80000e74:	02412483          	lw	s1,36(sp)
80000e78:	02012903          	lw	s2,32(sp)
80000e7c:	01c12983          	lw	s3,28(sp)
80000e80:	01812a03          	lw	s4,24(sp)
80000e84:	01412a83          	lw	s5,20(sp)
80000e88:	01012b03          	lw	s6,16(sp)
80000e8c:	00c12b83          	lw	s7,12(sp)
80000e90:	00812c03          	lw	s8,8(sp)
80000e94:	00412c83          	lw	s9,4(sp)
80000e98:	00012d03          	lw	s10,0(sp)
80000e9c:	03010113          	addi	sp,sp,48
80000ea0:	4990406f          	j	80005b38 <z_impl_k_timer_stop>

80000ea4 <test_timer_k_define>:
{
80000ea4:	ff010113          	addi	sp,sp,-16
80000ea8:	00112623          	sw	ra,12(sp)
80000eac:	00812423          	sw	s0,8(sp)
80000eb0:	00912223          	sw	s1,4(sp)
80000eb4:	01212023          	sw	s2,0(sp)
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000eb8:	80007437          	lui	s0,0x80007
	init_timer_data();
80000ebc:	82dff0ef          	jal	ra,800006e8 <init_timer_data>
80000ec0:	03200613          	li	a2,50
80000ec4:	06400593          	li	a1,100
80000ec8:	1b040513          	addi	a0,s0,432 # 800071b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071b1>
80000ecc:	3a5040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
80000ed0:	800074b7          	lui	s1,0x80007

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_TIMER_USER_DATA_SET, k_timer_user_data_set, struct k_timer *, timer, void *, user_data)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000ed4:	2ad040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
80000ed8:	32048913          	addi	s2,s1,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
80000edc:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000ee0:	0004f537          	lui	a0,0x4f
80000ee4:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
80000ee8:	00b92623          	sw	a1,12(s2)
80000eec:	29d030ef          	jal	ra,80004988 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &ktimer);
80000ef0:	00092703          	lw	a4,0(s2)
80000ef4:	00400793          	li	a5,4
80000ef8:	32048493          	addi	s1,s1,800
80000efc:	04f70063          	beq	a4,a5,80000f3c <test_timer_k_define+0x98>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000f00:	1b040513          	addi	a0,s0,432
80000f04:	435040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000f08:	0004a503          	lw	a0,0(s1)
80000f0c:	800067b7          	lui	a5,0x80006
80000f10:	80006737          	lui	a4,0x80006
80000f14:	ffc50513          	addi	a0,a0,-4
80000f18:	80006637          	lui	a2,0x80006
80000f1c:	800065b7          	lui	a1,0x80006
80000f20:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000f24:	20c70713          	addi	a4,a4,524 # 8000620c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000620d>
80000f28:	17f00693          	li	a3,383
80000f2c:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000f30:	46058593          	addi	a1,a1,1120 # 80006460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006461>
80000f34:	00153513          	seqz	a0,a0
80000f38:	8c5ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &ktimer);
80000f3c:	0044a703          	lw	a4,4(s1)
80000f40:	00100793          	li	a5,1
80000f44:	04f70063          	beq	a4,a5,80000f84 <test_timer_k_define+0xe0>
80000f48:	1b040513          	addi	a0,s0,432
80000f4c:	3ed040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000f50:	0044a503          	lw	a0,4(s1)
80000f54:	800067b7          	lui	a5,0x80006
80000f58:	80006737          	lui	a4,0x80006
80000f5c:	fff50513          	addi	a0,a0,-1
80000f60:	80006637          	lui	a2,0x80006
80000f64:	800065b7          	lui	a1,0x80006
80000f68:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80000f6c:	20c70713          	addi	a4,a4,524 # 8000620c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000620d>
80000f70:	18000693          	li	a3,384
80000f74:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000f78:	48058593          	addi	a1,a1,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
80000f7c:	00153513          	seqz	a0,a0
80000f80:	87dff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
80000f84:	1b040513          	addi	a0,s0,432
80000f88:	3b1040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
	init_timer_data();
80000f8c:	f5cff0ef          	jal	ra,800006e8 <init_timer_data>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000f90:	03200613          	li	a2,50
80000f94:	06400593          	li	a1,100
80000f98:	1b040513          	addi	a0,s0,432
80000f9c:	2d5040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000fa0:	0000c537          	lui	a0,0xc
80000fa4:	35050513          	addi	a0,a0,848 # c350 <CONFIG_ISR_STACK_SIZE+0xbb50>
80000fa8:	1e1030ef          	jal	ra,80004988 <z_impl_k_busy_wait>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000fac:	03200613          	li	a2,50
80000fb0:	06400593          	li	a1,100
80000fb4:	1b040513          	addi	a0,s0,432
80000fb8:	2b9040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000fbc:	1c5040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
	tdata.timestamp = k_uptime_get();
80000fc0:	00a4a423          	sw	a0,8(s1)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000fc4:	0004f537          	lui	a0,0x4f
80000fc8:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
80000fcc:	00b4a623          	sw	a1,12(s1)
80000fd0:	1b9030ef          	jal	ra,80004988 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &ktimer);
80000fd4:	0004a703          	lw	a4,0(s1)
80000fd8:	00400793          	li	a5,4
80000fdc:	04f70063          	beq	a4,a5,8000101c <test_timer_k_define+0x178>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000fe0:	1b040513          	addi	a0,s0,432
80000fe4:	355040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80000fe8:	0004a503          	lw	a0,0(s1)
80000fec:	800067b7          	lui	a5,0x80006
80000ff0:	80006737          	lui	a4,0x80006
80000ff4:	ffc50513          	addi	a0,a0,-4
80000ff8:	80006637          	lui	a2,0x80006
80000ffc:	800065b7          	lui	a1,0x80006
80001000:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80001004:	20c70713          	addi	a4,a4,524 # 8000620c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000620d>
80001008:	19300693          	li	a3,403
8000100c:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001010:	46058593          	addi	a1,a1,1120 # 80006460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006461>
80001014:	00153513          	seqz	a0,a0
80001018:	fe4ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &ktimer);
8000101c:	0044a703          	lw	a4,4(s1)
80001020:	00100793          	li	a5,1
80001024:	04f70063          	beq	a4,a5,80001064 <test_timer_k_define+0x1c0>
80001028:	1b040513          	addi	a0,s0,432
8000102c:	30d040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80001030:	0044a503          	lw	a0,4(s1)
80001034:	800067b7          	lui	a5,0x80006
80001038:	80006737          	lui	a4,0x80006
8000103c:	fff50513          	addi	a0,a0,-1
80001040:	80006637          	lui	a2,0x80006
80001044:	800065b7          	lui	a1,0x80006
80001048:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
8000104c:	20c70713          	addi	a4,a4,524 # 8000620c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000620d>
80001050:	19400693          	li	a3,404
80001054:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001058:	48058593          	addi	a1,a1,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
8000105c:	00153513          	seqz	a0,a0
80001060:	f9cff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
80001064:	1b040513          	addi	a0,s0,432
}
80001068:	00812403          	lw	s0,8(sp)
8000106c:	00c12083          	lw	ra,12(sp)
80001070:	00412483          	lw	s1,4(sp)
80001074:	00012903          	lw	s2,0(sp)
80001078:	01010113          	addi	sp,sp,16
8000107c:	2bd0406f          	j	80005b38 <z_impl_k_timer_stop>

80001080 <test_timer_expirefn_null>:
{
80001080:	ff010113          	addi	sp,sp,-16
80001084:	00112623          	sw	ra,12(sp)
80001088:	00812423          	sw	s0,8(sp)
8000108c:	00912223          	sw	s1,4(sp)
	init_timer_data();
80001090:	e58ff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, NULL, duration_stop);
80001094:	80007437          	lui	s0,0x80007
80001098:	80000637          	lui	a2,0x80000
8000109c:	6fc60613          	addi	a2,a2,1788 # 800006fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800006fd>
800010a0:	00000593          	li	a1,0
800010a4:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
800010a8:	1a1040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800010ac:	03200613          	li	a2,50
800010b0:	06400593          	li	a1,100
800010b4:	35c40513          	addi	a0,s0,860
800010b8:	1b9040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800010bc:	0004f537          	lui	a0,0x4f
800010c0:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800010c4:	0c5030ef          	jal	ra,80004988 <z_impl_k_busy_wait>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800010c8:	35c40513          	addi	a0,s0,860
	TIMER_ASSERT(tdata.expire_cnt == 0, &timer);
800010cc:	800074b7          	lui	s1,0x80007
800010d0:	269040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
800010d4:	3204a783          	lw	a5,800(s1) # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
800010d8:	32048493          	addi	s1,s1,800
800010dc:	02078e63          	beqz	a5,80001118 <test_timer_expirefn_null+0x98>
800010e0:	35c40513          	addi	a0,s0,860
800010e4:	255040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
800010e8:	0004a503          	lw	a0,0(s1)
800010ec:	800067b7          	lui	a5,0x80006
800010f0:	80006737          	lui	a4,0x80006
800010f4:	80006637          	lui	a2,0x80006
800010f8:	800065b7          	lui	a1,0x80006
800010fc:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80001100:	18870713          	addi	a4,a4,392 # 80006188 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006189>
80001104:	0bf00693          	li	a3,191
80001108:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
8000110c:	44058593          	addi	a1,a1,1088 # 80006440 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006441>
80001110:	00153513          	seqz	a0,a0
80001114:	ee8ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &timer);
80001118:	0044a703          	lw	a4,4(s1)
8000111c:	00100793          	li	a5,1
80001120:	04f70063          	beq	a4,a5,80001160 <test_timer_expirefn_null+0xe0>
80001124:	35c40513          	addi	a0,s0,860
80001128:	211040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
8000112c:	0044a503          	lw	a0,4(s1)
80001130:	800067b7          	lui	a5,0x80006
80001134:	80006737          	lui	a4,0x80006
80001138:	fff50513          	addi	a0,a0,-1
8000113c:	80006637          	lui	a2,0x80006
80001140:	800065b7          	lui	a1,0x80006
80001144:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80001148:	18870713          	addi	a4,a4,392 # 80006188 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006189>
8000114c:	0c100693          	li	a3,193
80001150:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001154:	48058593          	addi	a1,a1,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
80001158:	00153513          	seqz	a0,a0
8000115c:	ea0ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
80001160:	35c40513          	addi	a0,s0,860
}
80001164:	00812403          	lw	s0,8(sp)
80001168:	00c12083          	lw	ra,12(sp)
8000116c:	00412483          	lw	s1,4(sp)
80001170:	01010113          	addi	sp,sp,16
80001174:	1c50406f          	j	80005b38 <z_impl_k_timer_stop>

80001178 <test_timer_period_0>:
{
80001178:	ff010113          	addi	sp,sp,-16
8000117c:	00112623          	sw	ra,12(sp)
80001180:	00812423          	sw	s0,8(sp)
80001184:	00912223          	sw	s1,4(sp)
80001188:	01212023          	sw	s2,0(sp)
	init_timer_data();
8000118c:	d5cff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, period0_expire, NULL);
80001190:	80007437          	lui	s0,0x80007
80001194:	800005b7          	lui	a1,0x80000
80001198:	00000613          	li	a2,0
8000119c:	71458593          	addi	a1,a1,1812 # 80000714 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000715>
800011a0:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
800011a4:	0a5040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800011a8:	00000613          	li	a2,0
800011ac:	06400593          	li	a1,100
800011b0:	35c40513          	addi	a0,s0,860
800011b4:	0bd040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
800011b8:	800074b7          	lui	s1,0x80007
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800011bc:	7c4040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
800011c0:	32048913          	addi	s2,s1,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
800011c4:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800011c8:	00019537          	lui	a0,0x19
800011cc:	a8850513          	addi	a0,a0,-1400 # 18a88 <CONFIG_ISR_STACK_SIZE+0x18288>
800011d0:	00b92623          	sw	a1,12(s2)
800011d4:	7b4030ef          	jal	ra,80004988 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == 1, &timer);
800011d8:	00092703          	lw	a4,0(s2)
800011dc:	00100793          	li	a5,1
800011e0:	32048493          	addi	s1,s1,800
800011e4:	04f70063          	beq	a4,a5,80001224 <test_timer_period_0+0xac>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800011e8:	35c40513          	addi	a0,s0,860
800011ec:	14d040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
800011f0:	0004a503          	lw	a0,0(s1)
800011f4:	800067b7          	lui	a5,0x80006
800011f8:	80006737          	lui	a4,0x80006
800011fc:	fff50513          	addi	a0,a0,-1
80001200:	80006637          	lui	a2,0x80006
80001204:	800065b7          	lui	a1,0x80006
80001208:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
8000120c:	17470713          	addi	a4,a4,372 # 80006174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006175>
80001210:	09f00693          	li	a3,159
80001214:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001218:	4a058593          	addi	a1,a1,1184 # 800064a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064a1>
8000121c:	00153513          	seqz	a0,a0
80001220:	ddcff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 0, &timer);
80001224:	0044a783          	lw	a5,4(s1)
80001228:	02078e63          	beqz	a5,80001264 <test_timer_period_0+0xec>
8000122c:	35c40513          	addi	a0,s0,860
80001230:	109040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80001234:	0044a503          	lw	a0,4(s1)
80001238:	800067b7          	lui	a5,0x80006
8000123c:	80006737          	lui	a4,0x80006
80001240:	80006637          	lui	a2,0x80006
80001244:	800065b7          	lui	a1,0x80006
80001248:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
8000124c:	17470713          	addi	a4,a4,372 # 80006174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006175>
80001250:	0a000693          	li	a3,160
80001254:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001258:	4c058593          	addi	a1,a1,1216 # 800064c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064c1>
8000125c:	00153513          	seqz	a0,a0
80001260:	d9cff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
80001264:	35c40513          	addi	a0,s0,860
}
80001268:	00812403          	lw	s0,8(sp)
8000126c:	00c12083          	lw	ra,12(sp)
80001270:	00412483          	lw	s1,4(sp)
80001274:	00012903          	lw	s2,0(sp)
80001278:	01010113          	addi	sp,sp,16
8000127c:	0bd0406f          	j	80005b38 <z_impl_k_timer_stop>

80001280 <test_timer_duration_period>:
{
80001280:	ff010113          	addi	sp,sp,-16
80001284:	00112623          	sw	ra,12(sp)
80001288:	00812423          	sw	s0,8(sp)
8000128c:	00912223          	sw	s1,4(sp)
80001290:	01212023          	sw	s2,0(sp)
	init_timer_data();
80001294:	c54ff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, duration_expire, duration_stop);
80001298:	80007437          	lui	s0,0x80007
8000129c:	80000637          	lui	a2,0x80000
800012a0:	800015b7          	lui	a1,0x80001
800012a4:	6fc60613          	addi	a2,a2,1788 # 800006fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800006fd>
800012a8:	53c58593          	addi	a1,a1,1340 # 8000153c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000153d>
800012ac:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
800012b0:	798040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800012b4:	03200613          	li	a2,50
800012b8:	06400593          	li	a1,100
800012bc:	35c40513          	addi	a0,s0,860
800012c0:	7b0040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
800012c4:	800074b7          	lui	s1,0x80007
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800012c8:	6b8040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
800012cc:	32048913          	addi	s2,s1,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
800012d0:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800012d4:	0004f537          	lui	a0,0x4f
800012d8:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800012dc:	00b92623          	sw	a1,12(s2)
800012e0:	6a8030ef          	jal	ra,80004988 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &timer);
800012e4:	00092703          	lw	a4,0(s2)
800012e8:	00400793          	li	a5,4
800012ec:	32048493          	addi	s1,s1,800
800012f0:	04f70063          	beq	a4,a5,80001330 <test_timer_duration_period+0xb0>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800012f4:	35c40513          	addi	a0,s0,860
800012f8:	041040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
800012fc:	0004a503          	lw	a0,0(s1)
80001300:	800067b7          	lui	a5,0x80006
80001304:	80006737          	lui	a4,0x80006
80001308:	ffc50513          	addi	a0,a0,-4
8000130c:	80006637          	lui	a2,0x80006
80001310:	800065b7          	lui	a1,0x80006
80001314:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80001318:	15870713          	addi	a4,a4,344 # 80006158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006159>
8000131c:	07f00693          	li	a3,127
80001320:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001324:	46058593          	addi	a1,a1,1120 # 80006460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006461>
80001328:	00153513          	seqz	a0,a0
8000132c:	cd0ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &timer);
80001330:	0044a703          	lw	a4,4(s1)
80001334:	00100793          	li	a5,1
80001338:	04f70063          	beq	a4,a5,80001378 <test_timer_duration_period+0xf8>
8000133c:	35c40513          	addi	a0,s0,860
80001340:	7f8040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
80001344:	0044a503          	lw	a0,4(s1)
80001348:	800067b7          	lui	a5,0x80006
8000134c:	80006737          	lui	a4,0x80006
80001350:	fff50513          	addi	a0,a0,-1
80001354:	80006637          	lui	a2,0x80006
80001358:	800065b7          	lui	a1,0x80006
8000135c:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80001360:	15870713          	addi	a4,a4,344 # 80006158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006159>
80001364:	08000693          	li	a3,128
80001368:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
8000136c:	48058593          	addi	a1,a1,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
80001370:	00153513          	seqz	a0,a0
80001374:	c88ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
80001378:	35c40513          	addi	a0,s0,860
}
8000137c:	00812403          	lw	s0,8(sp)
80001380:	00c12083          	lw	ra,12(sp)
80001384:	00412483          	lw	s1,4(sp)
80001388:	00012903          	lw	s2,0(sp)
8000138c:	01010113          	addi	sp,sp,16
80001390:	7a80406f          	j	80005b38 <z_impl_k_timer_stop>

80001394 <test_timer_periodicity>:
{
80001394:	fd010113          	addi	sp,sp,-48
80001398:	02812423          	sw	s0,40(sp)
	k_timer_init(&sync_timer, NULL, NULL);
8000139c:	80007437          	lui	s0,0x80007
800013a0:	33040513          	addi	a0,s0,816 # 80007330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007331>
800013a4:	00000613          	li	a2,0
800013a8:	00000593          	li	a1,0
{
800013ac:	02112623          	sw	ra,44(sp)
800013b0:	02912223          	sw	s1,36(sp)
800013b4:	03212023          	sw	s2,32(sp)
800013b8:	01312e23          	sw	s3,28(sp)
800013bc:	01412c23          	sw	s4,24(sp)
800013c0:	01512a23          	sw	s5,20(sp)
800013c4:	01612823          	sw	s6,16(sp)
800013c8:	01712623          	sw	s7,12(sp)
800013cc:	01812423          	sw	s8,8(sp)
800013d0:	01912223          	sw	s9,4(sp)
	k_timer_init(&sync_timer, NULL, NULL);
800013d4:	674040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800013d8:	00100613          	li	a2,1
800013dc:	00000593          	li	a1,0
800013e0:	33040513          	addi	a0,s0,816
800013e4:	68c040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
800013e8:	33040513          	addi	a0,s0,816
800013ec:	0bd040ef          	jal	ra,80005ca8 <z_impl_k_timer_status_sync>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800013f0:	33040513          	addi	a0,s0,816
800013f4:	744040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
	k_timer_init(&timer, NULL, NULL);
800013f8:	80007437          	lui	s0,0x80007
	init_timer_data();
800013fc:	aecff0ef          	jal	ra,800006e8 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
80001400:	00000613          	li	a2,0
80001404:	00000593          	li	a1,0
80001408:	35c40513          	addi	a0,s0,860 # 8000735c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000735d>
8000140c:	63c040ef          	jal	ra,80005a48 <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80001410:	03200613          	li	a2,50
80001414:	00000593          	li	a1,0
80001418:	35c40513          	addi	a0,s0,860
8000141c:	654040ef          	jal	ra,80005a70 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80001420:	35c40513          	addi	a0,s0,860
80001424:	085040ef          	jal	ra,80005ca8 <z_impl_k_timer_status_sync>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001428:	558040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
	tdata.timestamp = k_uptime_get();
8000142c:	800074b7          	lui	s1,0x80007
80001430:	32048793          	addi	a5,s1,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
80001434:	00a7a423          	sw	a0,8(a5)
80001438:	00b7a623          	sw	a1,12(a5)
8000143c:	00400913          	li	s2,4
80001440:	32048493          	addi	s1,s1,800
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80001444:	00100993          	li	s3,1
80001448:	80006ab7          	lui	s5,0x80006
8000144c:	80006b37          	lui	s6,0x80006
80001450:	80006bb7          	lui	s7,0x80006
80001454:	80006c37          	lui	s8,0x80006
80001458:	fce00a13          	li	s4,-50
		TIMER_ASSERT(WITHIN_ERROR(delta, PERIOD, 1), &timer);
8000145c:	80006cb7          	lui	s9,0x80006
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80001460:	35c40513          	addi	a0,s0,860
80001464:	045040ef          	jal	ra,80005ca8 <z_impl_k_timer_status_sync>
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80001468:	03350a63          	beq	a0,s3,8000149c <test_timer_periodicity+0x108>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
8000146c:	35c40513          	addi	a0,s0,860
80001470:	6c8040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80001474:	35c40513          	addi	a0,s0,860
80001478:	031040ef          	jal	ra,80005ca8 <z_impl_k_timer_status_sync>
8000147c:	fff50513          	addi	a0,a0,-1
80001480:	750b0793          	addi	a5,s6,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80001484:	1a4a8713          	addi	a4,s5,420 # 800061a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061a5>
80001488:	0fc00693          	li	a3,252
8000148c:	6a8b8613          	addi	a2,s7,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001490:	5ecc0593          	addi	a1,s8,1516 # 800065ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065ed>
80001494:	00153513          	seqz	a0,a0
80001498:	b64ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
8000149c:	4e4040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
static inline s64_t k_uptime_delta(s64_t *reftime)
{
	s64_t uptime, delta;

	uptime = k_uptime_get();
	delta = uptime - *reftime;
800014a0:	0084a783          	lw	a5,8(s1)
800014a4:	00c4a703          	lw	a4,12(s1)
	*reftime = uptime;
800014a8:	00a4a423          	sw	a0,8(s1)
800014ac:	40fa07b3          	sub	a5,s4,a5
800014b0:	00fa36b3          	sltu	a3,s4,a5
800014b4:	fff74713          	not	a4,a4
800014b8:	40d70733          	sub	a4,a4,a3
		TIMER_ASSERT(WITHIN_ERROR(delta, PERIOD, 1), &timer);
800014bc:	00f507b3          	add	a5,a0,a5
800014c0:	00b4a623          	sw	a1,12(s1)
800014c4:	00a7b533          	sltu	a0,a5,a0
800014c8:	00e585b3          	add	a1,a1,a4
800014cc:	00b50533          	add	a0,a0,a1
800014d0:	00051463          	bnez	a0,800014d8 <test_timer_periodicity+0x144>
800014d4:	02f9f463          	bgeu	s3,a5,800014fc <test_timer_periodicity+0x168>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800014d8:	35c40513          	addi	a0,s0,860
800014dc:	65c040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
800014e0:	750b0793          	addi	a5,s6,1872
800014e4:	1a4a8713          	addi	a4,s5,420
800014e8:	10300693          	li	a3,259
800014ec:	6a8b8613          	addi	a2,s7,1704
800014f0:	4e0c8593          	addi	a1,s9,1248 # 800064e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064e1>
800014f4:	00000513          	li	a0,0
800014f8:	b04ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
800014fc:	fff90913          	addi	s2,s2,-1
	for (int i = 0; i < EXPIRE_TIMES; i++) {
80001500:	f60910e3          	bnez	s2,80001460 <test_timer_periodicity+0xcc>
80001504:	35c40513          	addi	a0,s0,860
}
80001508:	02812403          	lw	s0,40(sp)
8000150c:	02c12083          	lw	ra,44(sp)
80001510:	02412483          	lw	s1,36(sp)
80001514:	02012903          	lw	s2,32(sp)
80001518:	01c12983          	lw	s3,28(sp)
8000151c:	01812a03          	lw	s4,24(sp)
80001520:	01412a83          	lw	s5,20(sp)
80001524:	01012b03          	lw	s6,16(sp)
80001528:	00c12b83          	lw	s7,12(sp)
8000152c:	00812c03          	lw	s8,8(sp)
80001530:	00412c83          	lw	s9,4(sp)
80001534:	03010113          	addi	sp,sp,48
80001538:	6000406f          	j	80005b38 <z_impl_k_timer_stop>

8000153c <duration_expire>:
{
8000153c:	ff010113          	addi	sp,sp,-16
80001540:	00812423          	sw	s0,8(sp)
	tdata.expire_cnt++;
80001544:	80007437          	lui	s0,0x80007
80001548:	32040713          	addi	a4,s0,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
8000154c:	00072783          	lw	a5,0(a4)
{
80001550:	00912223          	sw	s1,4(sp)
80001554:	00112623          	sw	ra,12(sp)
	tdata.expire_cnt++;
80001558:	00178793          	addi	a5,a5,1
8000155c:	00f72023          	sw	a5,0(a4)
	if (tdata.expire_cnt == 1) {
80001560:	00100713          	li	a4,1
{
80001564:	00050493          	mv	s1,a0
80001568:	32040413          	addi	s0,s0,800
	if (tdata.expire_cnt == 1) {
8000156c:	0ce79a63          	bne	a5,a4,80001640 <duration_expire+0x104>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001570:	410040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001574:	00842703          	lw	a4,8(s0)
80001578:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
8000157c:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
80001580:	40e50733          	sub	a4,a0,a4
80001584:	00e536b3          	sltu	a3,a0,a4
80001588:	40f587b3          	sub	a5,a1,a5
8000158c:	40d787b3          	sub	a5,a5,a3
	*reftime = uptime;
80001590:	00b42623          	sw	a1,12(s0)
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= DURATION,
80001594:	06f04e63          	bgtz	a5,80001610 <duration_expire+0xd4>
80001598:	00079663          	bnez	a5,800015a4 <duration_expire+0x68>
8000159c:	06300793          	li	a5,99
800015a0:	06e7e863          	bltu	a5,a4,80001610 <duration_expire+0xd4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800015a4:	00048513          	mv	a0,s1
800015a8:	590040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800015ac:	3d4040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
800015b0:	00842683          	lw	a3,8(s0)
800015b4:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
800015b8:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
800015bc:	40d506b3          	sub	a3,a0,a3
800015c0:	00d53733          	sltu	a4,a0,a3
800015c4:	40f587b3          	sub	a5,a1,a5
800015c8:	40e787b3          	sub	a5,a5,a4
	*reftime = uptime;
800015cc:	00b42623          	sw	a1,12(s0)
800015d0:	80006737          	lui	a4,0x80006
800015d4:	00100513          	li	a0,1
800015d8:	00f04a63          	bgtz	a5,800015ec <duration_expire+0xb0>
800015dc:	00079663          	bnez	a5,800015e8 <duration_expire+0xac>
800015e0:	06300793          	li	a5,99
800015e4:	00d7e463          	bltu	a5,a3,800015ec <duration_expire+0xb0>
800015e8:	00000513          	li	a0,0
800015ec:	800067b7          	lui	a5,0x80006
800015f0:	80006637          	lui	a2,0x80006
800015f4:	800065b7          	lui	a1,0x80006
800015f8:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
800015fc:	12c70713          	addi	a4,a4,300 # 8000612c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000612d>
80001600:	03300693          	li	a3,51
80001604:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80001608:	25458593          	addi	a1,a1,596 # 80006254 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006255>
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= PERIOD, timer);
8000160c:	9f0ff0ef          	jal	ra,800007fc <z_zassert.constprop.6>
80001610:	370040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
80001614:	00042703          	lw	a4,0(s0)
	tdata.timestamp = k_uptime_get();
80001618:	00a42423          	sw	a0,8(s0)
8000161c:	00b42623          	sw	a1,12(s0)
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
80001620:	00300793          	li	a5,3
80001624:	0ae7de63          	bge	a5,a4,800016e0 <duration_expire+0x1a4>
}
80001628:	00812403          	lw	s0,8(sp)
8000162c:	00c12083          	lw	ra,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001630:	00048513          	mv	a0,s1
80001634:	00412483          	lw	s1,4(sp)
80001638:	01010113          	addi	sp,sp,16
8000163c:	4fc0406f          	j	80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001640:	340040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001644:	00842703          	lw	a4,8(s0)
80001648:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
8000164c:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
80001650:	40e50733          	sub	a4,a0,a4
80001654:	00e536b3          	sltu	a3,a0,a4
80001658:	40f587b3          	sub	a5,a1,a5
8000165c:	40d787b3          	sub	a5,a5,a3
	*reftime = uptime;
80001660:	00b42623          	sw	a1,12(s0)
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= PERIOD, timer);
80001664:	faf046e3          	bgtz	a5,80001610 <duration_expire+0xd4>
80001668:	00079663          	bnez	a5,80001674 <duration_expire+0x138>
8000166c:	03100793          	li	a5,49
80001670:	fae7e0e3          	bltu	a5,a4,80001610 <duration_expire+0xd4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001674:	00048513          	mv	a0,s1
80001678:	4c0040ef          	jal	ra,80005b38 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
8000167c:	304040ef          	jal	ra,80005980 <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001680:	00842683          	lw	a3,8(s0)
80001684:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
80001688:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
8000168c:	40d506b3          	sub	a3,a0,a3
80001690:	00d53733          	sltu	a4,a0,a3
80001694:	40f587b3          	sub	a5,a1,a5
80001698:	40e787b3          	sub	a5,a5,a4
	*reftime = uptime;
8000169c:	00b42623          	sw	a1,12(s0)
800016a0:	80006737          	lui	a4,0x80006
800016a4:	00100513          	li	a0,1
800016a8:	00f04a63          	bgtz	a5,800016bc <duration_expire+0x180>
800016ac:	00079663          	bnez	a5,800016b8 <duration_expire+0x17c>
800016b0:	03100793          	li	a5,49
800016b4:	00d7e463          	bltu	a5,a3,800016bc <duration_expire+0x180>
800016b8:	00000513          	li	a0,0
800016bc:	800067b7          	lui	a5,0x80006
800016c0:	80006637          	lui	a2,0x80006
800016c4:	800065b7          	lui	a1,0x80006
800016c8:	75078793          	addi	a5,a5,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
800016cc:	12c70713          	addi	a4,a4,300 # 8000612c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000612d>
800016d0:	03500693          	li	a3,53
800016d4:	6a860613          	addi	a2,a2,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800016d8:	28858593          	addi	a1,a1,648 # 80006288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006289>
800016dc:	f31ff06f          	j	8000160c <duration_expire+0xd0>
}
800016e0:	00c12083          	lw	ra,12(sp)
800016e4:	00812403          	lw	s0,8(sp)
800016e8:	00412483          	lw	s1,4(sp)
800016ec:	01010113          	addi	sp,sp,16
800016f0:	00008067          	ret

800016f4 <test_main>:
			 ztest_unit_test(test_timer_status_get_anytime),
			 ztest_unit_test(test_timer_status_sync),
			 ztest_unit_test(test_timer_k_define),
			 ztest_unit_test(test_timer_user_data),
			 ztest_unit_test(test_timer_remaining_get));
	ztest_run_test_suite(timer_api);
800016f4:	800075b7          	lui	a1,0x80007
800016f8:	80006537          	lui	a0,0x80006
800016fc:	08858593          	addi	a1,a1,136 # 80007088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007089>
80001700:	43450513          	addi	a0,a0,1076 # 80006434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006435>
80001704:	2780106f          	j	8000297c <z_ztest_run_test_suite>

80001708 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80001708:	ff010113          	addi	sp,sp,-16
8000170c:	00112623          	sw	ra,12(sp)
80001710:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80001714:	00600793          	li	a5,6
80001718:	02f50463          	beq	a0,a5,80001740 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
8000171c:	248030ef          	jal	ra,80004964 <k_is_in_isr>
80001720:	02050463          	beqz	a0,80001748 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80001724:	240030ef          	jal	ra,80004964 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80001728:	04051663          	bnez	a0,80001774 <z_SysFatalErrorHandler+0x6c>
8000172c:	800075b7          	lui	a1,0x80007
80001730:	9ac58593          	addi	a1,a1,-1620 # 800069ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069ad>
80001734:	80007537          	lui	a0,0x80007
80001738:	9c050513          	addi	a0,a0,-1600 # 800069c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069c1>
8000173c:	331000ef          	jal	ra,8000226c <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80001740:	39d000ef          	jal	ra,800022dc <k_cpu_idle>
80001744:	ffdff06f          	j	80001740 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80001748:	22c030ef          	jal	ra,80004974 <z_is_thread_essential>
8000174c:	fc051ce3          	bnez	a0,80001724 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80001750:	80007437          	lui	s0,0x80007
80001754:	4fc40413          	addi	s0,s0,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80001758:	00842583          	lw	a1,8(s0)
8000175c:	80007537          	lui	a0,0x80007
80001760:	9e050513          	addi	a0,a0,-1568 # 800069e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e1>
80001764:	309000ef          	jal	ra,8000226c <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001768:	00842503          	lw	a0,8(s0)
8000176c:	6ac030ef          	jal	ra,80004e18 <z_impl_k_thread_abort>
80001770:	fd1ff06f          	j	80001740 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80001774:	800075b7          	lui	a1,0x80007
80001778:	9a858593          	addi	a1,a1,-1624 # 800069a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a9>
8000177c:	fb9ff06f          	j	80001734 <z_SysFatalErrorHandler+0x2c>

80001780 <z_NanoFatalErrorHandler>:
{
80001780:	fb010113          	addi	sp,sp,-80
80001784:	04812423          	sw	s0,72(sp)
80001788:	04912223          	sw	s1,68(sp)
8000178c:	04112623          	sw	ra,76(sp)
	switch (reason) {
80001790:	00600793          	li	a5,6
{
80001794:	00050493          	mv	s1,a0
80001798:	00058413          	mv	s0,a1
	switch (reason) {
8000179c:	0ea7e063          	bltu	a5,a0,8000187c <z_NanoFatalErrorHandler+0xfc>
800017a0:	80006737          	lui	a4,0x80006
800017a4:	00251793          	slli	a5,a0,0x2
800017a8:	6fc70713          	addi	a4,a4,1788 # 800066fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066fd>
800017ac:	00e787b3          	add	a5,a5,a4
800017b0:	0007a783          	lw	a5,0(a5)
800017b4:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
800017b8:	80007537          	lui	a0,0x80007
800017bc:	82c50513          	addi	a0,a0,-2004 # 8000682c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000682d>
		printk("***** Kernel OOPS! *****\n");
800017c0:	2ad000ef          	jal	ra,8000226c <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800017c4:	601020ef          	jal	ra,800045c4 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
800017c8:	04442783          	lw	a5,68(s0)
800017cc:	01042883          	lw	a7,16(s0)
800017d0:	00c42803          	lw	a6,12(s0)
800017d4:	02f12823          	sw	a5,48(sp)
800017d8:	04042783          	lw	a5,64(s0)
800017dc:	00442703          	lw	a4,4(s0)
800017e0:	00042683          	lw	a3,0(s0)
800017e4:	02f12623          	sw	a5,44(sp)
800017e8:	03c42783          	lw	a5,60(s0)
800017ec:	04842603          	lw	a2,72(s0)
800017f0:	00050593          	mv	a1,a0
800017f4:	02f12423          	sw	a5,40(sp)
800017f8:	03842783          	lw	a5,56(s0)
800017fc:	80007537          	lui	a0,0x80007
80001800:	8b050513          	addi	a0,a0,-1872 # 800068b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068b1>
80001804:	02f12223          	sw	a5,36(sp)
80001808:	03442783          	lw	a5,52(s0)
8000180c:	02f12023          	sw	a5,32(sp)
80001810:	03042783          	lw	a5,48(s0)
80001814:	00f12e23          	sw	a5,28(sp)
80001818:	02c42783          	lw	a5,44(s0)
8000181c:	00f12c23          	sw	a5,24(sp)
80001820:	02842783          	lw	a5,40(s0)
80001824:	00f12a23          	sw	a5,20(sp)
80001828:	02442783          	lw	a5,36(s0)
8000182c:	00f12823          	sw	a5,16(sp)
80001830:	02042783          	lw	a5,32(s0)
80001834:	00f12623          	sw	a5,12(sp)
80001838:	01c42783          	lw	a5,28(s0)
8000183c:	00f12423          	sw	a5,8(sp)
80001840:	01842783          	lw	a5,24(s0)
80001844:	00f12223          	sw	a5,4(sp)
80001848:	01442783          	lw	a5,20(s0)
8000184c:	00f12023          	sw	a5,0(sp)
80001850:	00842783          	lw	a5,8(s0)
80001854:	219000ef          	jal	ra,8000226c <printk>
	z_SysFatalErrorHandler(reason, esf);
80001858:	00040593          	mv	a1,s0
8000185c:	00048513          	mv	a0,s1
80001860:	ea9ff0ef          	jal	ra,80001708 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80001864:	80007537          	lui	a0,0x80007
80001868:	85450513          	addi	a0,a0,-1964 # 80006854 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006855>
8000186c:	f55ff06f          	j	800017c0 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80001870:	80007537          	lui	a0,0x80007
80001874:	87050513          	addi	a0,a0,-1936 # 80006870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006871>
80001878:	f49ff06f          	j	800017c0 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
8000187c:	80007537          	lui	a0,0x80007
80001880:	00048593          	mv	a1,s1
80001884:	88c50513          	addi	a0,a0,-1908 # 8000688c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000688d>
80001888:	1e5000ef          	jal	ra,8000226c <printk>
		break;
8000188c:	f39ff06f          	j	800017c4 <z_NanoFatalErrorHandler+0x44>

80001890 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80001890:	ff010113          	addi	sp,sp,-16
80001894:	00812423          	sw	s0,8(sp)
80001898:	00112623          	sw	ra,12(sp)
8000189c:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
800018a0:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
800018a4:	00161613          	slli	a2,a2,0x1
800018a8:	00165613          	srli	a2,a2,0x1
	switch (cause) {
800018ac:	00500793          	li	a5,5
800018b0:	02c7e863          	bltu	a5,a2,800018e0 <_Fault+0x50>
800018b4:	80006737          	lui	a4,0x80006
800018b8:	00261793          	slli	a5,a2,0x2
800018bc:	71870713          	addi	a4,a4,1816 # 80006718 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006719>
800018c0:	00f707b3          	add	a5,a4,a5
800018c4:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
800018c8:	80006537          	lui	a0,0x80006
800018cc:	73850513          	addi	a0,a0,1848 # 80006738 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006739>
800018d0:	19d000ef          	jal	ra,8000226c <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
800018d4:	00040593          	mv	a1,s0
800018d8:	00000513          	li	a0,0
800018dc:	ea5ff0ef          	jal	ra,80001780 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
800018e0:	800065b7          	lui	a1,0x80006
800018e4:	73058593          	addi	a1,a1,1840 # 80006730 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006731>
800018e8:	fe1ff06f          	j	800018c8 <_Fault+0x38>

800018ec <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
800018ec:	ff010113          	addi	sp,sp,-16
800018f0:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
800018f4:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
800018f8:	80007537          	lui	a0,0x80007
	mcause &= SOC_MCAUSE_EXP_MASK;
800018fc:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001900:	0015d593          	srli	a1,a1,0x1
80001904:	a0850513          	addi	a0,a0,-1528 # 80006a08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a09>
80001908:	165000ef          	jal	ra,8000226c <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
8000190c:	800065b7          	lui	a1,0x80006
80001910:	75458593          	addi	a1,a1,1876 # 80006754 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006755>
80001914:	00400513          	li	a0,4
80001918:	e69ff0ef          	jal	ra,80001780 <z_NanoFatalErrorHandler>

8000191c <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
8000191c:	800077b7          	lui	a5,0x80007
80001920:	2e078793          	addi	a5,a5,736 # 800072e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072e1>
80001924:	0007a703          	lw	a4,0(a5)
80001928:	00070c63          	beqz	a4,80001940 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
8000192c:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80001930:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80001934:	800077b7          	lui	a5,0x80007
80001938:	2e47a503          	lw	a0,740(a5) # 800072e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072e5>
8000193c:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80001940:	00008067          	ret

80001944 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80001944:	ff010113          	addi	sp,sp,-16
80001948:	00112623          	sw	ra,12(sp)
	z_bss_zero();
8000194c:	3e4010ef          	jal	ra,80002d30 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001950:	1ad000ef          	jal	ra,800022fc <soc_interrupt_init>
#endif
	z_cstart();
80001954:	448010ef          	jal	ra,80002d9c <z_cstart>

80001958 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80001958:	00006117          	auipc	sp,0x6
8000195c:	3d810113          	addi	sp,sp,984 # 80007d30 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80001960:	000012b7          	lui	t0,0x1
80001964:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80001968:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
8000196c:	fd9ff0ef          	jal	ra,80001944 <_PrepC>

80001970 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80001970:	2a80006f          	j	80001c18 <z_thread_entry>

80001974 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001974:	fd010113          	addi	sp,sp,-48
80001978:	02812423          	sw	s0,40(sp)
8000197c:	02912223          	sw	s1,36(sp)
80001980:	03212023          	sw	s2,32(sp)
80001984:	01312e23          	sw	s3,28(sp)
80001988:	01412c23          	sw	s4,24(sp)
8000198c:	01512a23          	sw	s5,20(sp)
80001990:	01612823          	sw	s6,16(sp)
80001994:	01712623          	sw	s7,12(sp)
80001998:	00078b13          	mv	s6,a5
8000199c:	02112623          	sw	ra,44(sp)
800019a0:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800019a4:	00f00793          	li	a5,15
{
800019a8:	00050493          	mv	s1,a0
800019ac:	00058413          	mv	s0,a1
800019b0:	00060993          	mv	s3,a2
800019b4:	00068a13          	mv	s4,a3
800019b8:	00070b93          	mv	s7,a4
800019bc:	00080a93          	mv	s5,a6
800019c0:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800019c4:	08f89a63          	bne	a7,a5,80001a58 <z_new_thread+0xe4>
800019c8:	800037b7          	lui	a5,0x80003
800019cc:	cf878793          	addi	a5,a5,-776 # 80002cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002cf9>
800019d0:	08f69a63          	bne	a3,a5,80001a64 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
800019d4:	03012683          	lw	a3,48(sp)
800019d8:	00090593          	mv	a1,s2
800019dc:	00048513          	mv	a0,s1
800019e0:	00400613          	li	a2,4
800019e4:	0b0030ef          	jal	ra,80004a94 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
800019e8:	fb098593          	addi	a1,s3,-80
800019ec:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
800019f0:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
800019f4:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
800019f8:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
800019fc:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001a00:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80001a04:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001a08:	800027b7          	lui	a5,0x80002

	thread->callee_saved.sp = (u32_t)stack_init;
}
80001a0c:	02c12083          	lw	ra,44(sp)
80001a10:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001a14:	97078793          	addi	a5,a5,-1680 # 80001970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001971>
	stack_init->a0 = (u32_t)thread_func;
80001a18:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80001a1c:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80001a20:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80001a24:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001a28:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80001a2c:	02b4a423          	sw	a1,40(s1)
}
80001a30:	02012903          	lw	s2,32(sp)
80001a34:	02412483          	lw	s1,36(sp)
80001a38:	01c12983          	lw	s3,28(sp)
80001a3c:	01812a03          	lw	s4,24(sp)
80001a40:	01412a83          	lw	s5,20(sp)
80001a44:	01012b03          	lw	s6,16(sp)
80001a48:	00c12b83          	lw	s7,12(sp)
80001a4c:	00812c03          	lw	s8,8(sp)
80001a50:	03010113          	addi	sp,sp,48
80001a54:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001a58:	01088693          	addi	a3,a7,16
80001a5c:	01e00793          	li	a5,30
80001a60:	f6d7fae3          	bgeu	a5,a3,800019d4 <z_new_thread+0x60>
80001a64:	80007c37          	lui	s8,0x80007
80001a68:	800075b7          	lui	a1,0x80007
80001a6c:	80007537          	lui	a0,0x80007
80001a70:	a30c0613          	addi	a2,s8,-1488 # 80006a30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a31>
80001a74:	01800693          	li	a3,24
80001a78:	a5058593          	addi	a1,a1,-1456 # 80006a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a51>
80001a7c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80001a80:	7ec000ef          	jal	ra,8000226c <printk>
80001a84:	80007537          	lui	a0,0x80007
80001a88:	00090593          	mv	a1,s2
80001a8c:	ff000693          	li	a3,-16
80001a90:	00e00613          	li	a2,14
80001a94:	afc50513          	addi	a0,a0,-1284 # 80006afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006afd>
80001a98:	7d4000ef          	jal	ra,8000226c <printk>
80001a9c:	01800593          	li	a1,24
80001aa0:	a30c0513          	addi	a0,s8,-1488
80001aa4:	005000ef          	jal	ra,800022a8 <assert_post_action>
80001aa8:	f2dff06f          	j	800019d4 <z_new_thread+0x60>

80001aac <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001aac:	00c00793          	li	a5,12
80001ab0:	02f58733          	mul	a4,a1,a5
80001ab4:	00c52783          	lw	a5,12(a0)
80001ab8:	00e787b3          	add	a5,a5,a4
80001abc:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001ac0:	00b75463          	bge	a4,a1,80001ac8 <get_bit_ptr+0x1c>
80001ac4:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001ac8:	02000713          	li	a4,32
80001acc:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
80001ad0:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
80001ad4:	00271713          	slli	a4,a4,0x2
80001ad8:	00e787b3          	add	a5,a5,a4
80001adc:	00f6a023          	sw	a5,0(a3)
}
80001ae0:	00008067          	ret

80001ae4 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001ae4:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001ae8:	00c10693          	addi	a3,sp,12
{
80001aec:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001af0:	fbdff0ef          	jal	ra,80001aac <get_bit_ptr>

	*word |= (1<<bit);
80001af4:	00c12703          	lw	a4,12(sp)
80001af8:	00100793          	li	a5,1
80001afc:	00a79533          	sll	a0,a5,a0
80001b00:	00072783          	lw	a5,0(a4)
}
80001b04:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001b08:	00a7e7b3          	or	a5,a5,a0
80001b0c:	00f72023          	sw	a5,0(a4)
}
80001b10:	02010113          	addi	sp,sp,32
80001b14:	00008067          	ret

80001b18 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001b18:	00452783          	lw	a5,4(a0)
80001b1c:	00855803          	lhu	a6,8(a0)
{
80001b20:	ff010113          	addi	sp,sp,-16
80001b24:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001b28:	02f80833          	mul	a6,a6,a5
{
80001b2c:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001b30:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001b34:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80001b38:	fff00713          	li	a4,-1
{
80001b3c:	00112623          	sw	ra,12(sp)
80001b40:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
80001b44:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001b48:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
80001b4c:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001b50:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
80001b54:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80001b58:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
80001b5c:	0315c263          	blt	a1,a7,80001b80 <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001b60:	00000493          	li	s1,0
80001b64:	00845783          	lhu	a5,8(s0)
80001b68:	06f4c463          	blt	s1,a5,80001bd0 <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001b6c:	00c12083          	lw	ra,12(sp)
80001b70:	00812403          	lw	s0,8(sp)
80001b74:	00412483          	lw	s1,4(sp)
80001b78:	01010113          	addi	sp,sp,16
80001b7c:	00008067          	ret
		int nblocks = buflen / sz;
80001b80:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
80001b84:	00c42603          	lw	a2,12(s0)
80001b88:	026586b3          	mul	a3,a1,t1
80001b8c:	00d606b3          	add	a3,a2,a3
80001b90:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001b94:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
80001b98:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
80001b9c:	00ee4e63          	blt	t3,a4,80001bb8 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
80001ba0:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
80001ba4:	0027d793          	srli	a5,a5,0x2
80001ba8:	00378793          	addi	a5,a5,3
80001bac:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
80001bb0:	00158593          	addi	a1,a1,1
80001bb4:	fa9ff06f          	j	80001b5c <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
80001bb8:	01f70713          	addi	a4,a4,31
80001bbc:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80001bc0:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
80001bc4:	00271713          	slli	a4,a4,0x2
80001bc8:	00e50533          	add	a0,a0,a4
80001bcc:	fd9ff06f          	j	80001ba4 <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80001bd0:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
80001bd4:	00048613          	mv	a2,s1
80001bd8:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001bdc:	02f48733          	mul	a4,s1,a5
80001be0:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001be4:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
80001be8:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
80001bec:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
80001bf0:	00c42703          	lw	a4,12(s0)
80001bf4:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001bf8:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
80001bfc:	00872683          	lw	a3,8(a4)
80001c00:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
80001c04:	00872683          	lw	a3,8(a4)
80001c08:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
80001c0c:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
80001c10:	ed5ff0ef          	jal	ra,80001ae4 <set_free_bit>
80001c14:	f51ff06f          	j	80001b64 <z_sys_mem_pool_base_init+0x4c>

80001c18 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001c18:	ff010113          	addi	sp,sp,-16
80001c1c:	00050793          	mv	a5,a0
80001c20:	00058513          	mv	a0,a1
80001c24:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001c28:	00068613          	mv	a2,a3
{
80001c2c:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001c30:	000780e7          	jalr	a5
80001c34:	191020ef          	jal	ra,800045c4 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001c38:	1e0030ef          	jal	ra,80004e18 <z_impl_k_thread_abort>

80001c3c <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001c3c:	00000513          	li	a0,0
80001c40:	00008067          	ret

80001c44 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001c44:	ff010113          	addi	sp,sp,-16
80001c48:	00812423          	sw	s0,8(sp)
80001c4c:	00050413          	mv	s0,a0
	out('E', ctx);
80001c50:	04500513          	li	a0,69
{
80001c54:	00112623          	sw	ra,12(sp)
80001c58:	00912223          	sw	s1,4(sp)
80001c5c:	00058493          	mv	s1,a1
	out('E', ctx);
80001c60:	000400e7          	jalr	s0
	out('R', ctx);
80001c64:	00048593          	mv	a1,s1
80001c68:	05200513          	li	a0,82
80001c6c:	000400e7          	jalr	s0
	out('R', ctx);
80001c70:	00040313          	mv	t1,s0
}
80001c74:	00812403          	lw	s0,8(sp)
80001c78:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001c7c:	00048593          	mv	a1,s1
}
80001c80:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80001c84:	05200513          	li	a0,82
}
80001c88:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001c8c:	00030067          	jr	t1

80001c90 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001c90:	0005a783          	lw	a5,0(a1)
80001c94:	00178793          	addi	a5,a5,1
80001c98:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001c9c:	800077b7          	lui	a5,0x80007
80001ca0:	1647a303          	lw	t1,356(a5) # 80007164 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007165>
80001ca4:	00030067          	jr	t1

80001ca8 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001ca8:	fb010113          	addi	sp,sp,-80
80001cac:	04812423          	sw	s0,72(sp)
80001cb0:	03312e23          	sw	s3,60(sp)
80001cb4:	03412c23          	sw	s4,56(sp)
80001cb8:	03512a23          	sw	s5,52(sp)
80001cbc:	03612823          	sw	s6,48(sp)
80001cc0:	04112623          	sw	ra,76(sp)
80001cc4:	04912223          	sw	s1,68(sp)
80001cc8:	05212023          	sw	s2,64(sp)
80001ccc:	03712623          	sw	s7,44(sp)
80001cd0:	03812423          	sw	s8,40(sp)
80001cd4:	03912223          	sw	s9,36(sp)
80001cd8:	03a12023          	sw	s10,32(sp)
80001cdc:	01b12e23          	sw	s11,28(sp)
80001ce0:	00050a13          	mv	s4,a0
80001ce4:	00058a93          	mv	s5,a1
80001ce8:	00060993          	mv	s3,a2
80001cec:	00068b13          	mv	s6,a3
80001cf0:	00100413          	li	s0,1
80001cf4:	00e05463          	blez	a4,80001cfc <_printk_dec_ulong+0x54>
80001cf8:	00070413          	mv	s0,a4
80001cfc:	00100793          	li	a5,1
80001d00:	02000c13          	li	s8,32
80001d04:	00fb1463          	bne	s6,a5,80001d0c <_printk_dec_ulong+0x64>
80001d08:	03000c13          	li	s8,48
80001d0c:	3b9ad4b7          	lui	s1,0x3b9ad
80001d10:	00100913          	li	s2,1
80001d14:	00a00c93          	li	s9,10
80001d18:	00000713          	li	a4,0
80001d1c:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001d20:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
80001d24:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
80001d28:	00148b93          	addi	s7,s1,1
80001d2c:	00071463          	bnez	a4,80001d34 <_printk_dec_ulong+0x8c>
80001d30:	0934f263          	bgeu	s1,s3,80001db4 <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001d34:	0379d533          	divu	a0,s3,s7
80001d38:	000a8593          	mv	a1,s5
			digits++;
80001d3c:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001d40:	03050513          	addi	a0,a0,48
80001d44:	000a00e7          	jalr	s4
			found_largest_digit = 1;
80001d48:	00100713          	li	a4,1
		remaining--;
80001d4c:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
80001d50:	00100793          	li	a5,1
		remainder %= (pos + 1);
80001d54:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
80001d58:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
80001d5c:	fcfc96e3          	bne	s9,a5,80001d28 <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
80001d60:	000a8593          	mv	a1,s5
80001d64:	03098513          	addi	a0,s3,48
80001d68:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
80001d6c:	00300793          	li	a5,3
		remaining = min_width - digits;
80001d70:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001d74:	06fb0a63          	beq	s6,a5,80001de8 <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001d78:	04c12083          	lw	ra,76(sp)
80001d7c:	04812403          	lw	s0,72(sp)
80001d80:	04412483          	lw	s1,68(sp)
80001d84:	04012903          	lw	s2,64(sp)
80001d88:	03c12983          	lw	s3,60(sp)
80001d8c:	03812a03          	lw	s4,56(sp)
80001d90:	03412a83          	lw	s5,52(sp)
80001d94:	03012b03          	lw	s6,48(sp)
80001d98:	02c12b83          	lw	s7,44(sp)
80001d9c:	02812c03          	lw	s8,40(sp)
80001da0:	02412c83          	lw	s9,36(sp)
80001da4:	02012d03          	lw	s10,32(sp)
80001da8:	01c12d83          	lw	s11,28(sp)
80001dac:	05010113          	addi	sp,sp,80
80001db0:	00008067          	ret
		} else if (remaining <= min_width
80001db4:	f9944ce3          	blt	s0,s9,80001d4c <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
80001db8:	f96deae3          	bltu	s11,s6,80001d4c <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001dbc:	000a8593          	mv	a1,s5
80001dc0:	000c0513          	mv	a0,s8
80001dc4:	00e12623          	sw	a4,12(sp)
80001dc8:	000a00e7          	jalr	s4
			digits++;
80001dcc:	00190913          	addi	s2,s2,1
80001dd0:	00c12703          	lw	a4,12(sp)
80001dd4:	f79ff06f          	j	80001d4c <_printk_dec_ulong+0xa4>
			out(' ', ctx);
80001dd8:	000a8593          	mv	a1,s5
80001ddc:	02000513          	li	a0,32
80001de0:	000a00e7          	jalr	s4
80001de4:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80001de8:	fe8048e3          	bgtz	s0,80001dd8 <_printk_dec_ulong+0x130>
80001dec:	f8dff06f          	j	80001d78 <_printk_dec_ulong+0xd0>

80001df0 <__printk_hook_install>:
	_char_out = fn;
80001df0:	800077b7          	lui	a5,0x80007
80001df4:	16a7a223          	sw	a0,356(a5) # 80007164 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007165>
}
80001df8:	00008067          	ret

80001dfc <z_vprintk>:
{
80001dfc:	fb010113          	addi	sp,sp,-80
80001e00:	04812423          	sw	s0,72(sp)
80001e04:	04912223          	sw	s1,68(sp)
80001e08:	05212023          	sw	s2,64(sp)
80001e0c:	03312e23          	sw	s3,60(sp)
80001e10:	03412c23          	sw	s4,56(sp)
80001e14:	03512a23          	sw	s5,52(sp)
80001e18:	03912223          	sw	s9,36(sp)
80001e1c:	03a12023          	sw	s10,32(sp)
80001e20:	01b12e23          	sw	s11,28(sp)
80001e24:	04112623          	sw	ra,76(sp)
80001e28:	03612823          	sw	s6,48(sp)
80001e2c:	03712623          	sw	s7,44(sp)
80001e30:	03812423          	sw	s8,40(sp)
80001e34:	00050413          	mv	s0,a0
80001e38:	00058493          	mv	s1,a1
80001e3c:	00060a93          	mv	s5,a2
80001e40:	00068d13          	mv	s10,a3
	int long_ctr = 0;
80001e44:	00000a13          	li	s4,0
	int min_width = -1;
80001e48:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001e4c:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001e50:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
80001e54:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001e58:	000ac503          	lbu	a0,0(s5)
80001e5c:	04051063          	bnez	a0,80001e9c <z_vprintk+0xa0>
}
80001e60:	04c12083          	lw	ra,76(sp)
80001e64:	04812403          	lw	s0,72(sp)
80001e68:	04412483          	lw	s1,68(sp)
80001e6c:	04012903          	lw	s2,64(sp)
80001e70:	03c12983          	lw	s3,60(sp)
80001e74:	03812a03          	lw	s4,56(sp)
80001e78:	03412a83          	lw	s5,52(sp)
80001e7c:	03012b03          	lw	s6,48(sp)
80001e80:	02c12b83          	lw	s7,44(sp)
80001e84:	02812c03          	lw	s8,40(sp)
80001e88:	02412c83          	lw	s9,36(sp)
80001e8c:	02012d03          	lw	s10,32(sp)
80001e90:	01c12d83          	lw	s11,28(sp)
80001e94:	05010113          	addi	sp,sp,80
80001e98:	00008067          	ret
		if (!might_format) {
80001e9c:	000c9e63          	bnez	s9,80001eb8 <z_vprintk+0xbc>
			if (*fmt != '%') {
80001ea0:	02500693          	li	a3,37
80001ea4:	36d50a63          	beq	a0,a3,80002218 <z_vprintk+0x41c>
				out((int)*fmt, ctx);
80001ea8:	00048593          	mv	a1,s1
80001eac:	000400e7          	jalr	s0
		++fmt;
80001eb0:	001a8a93          	addi	s5,s5,1
80001eb4:	fa5ff06f          	j	80001e58 <z_vprintk+0x5c>
			switch (*fmt) {
80001eb8:	06400693          	li	a3,100
80001ebc:	10d50e63          	beq	a0,a3,80001fd8 <z_vprintk+0x1dc>
80001ec0:	06a6e263          	bltu	a3,a0,80001f24 <z_vprintk+0x128>
80001ec4:	03900693          	li	a3,57
80001ec8:	02a6ea63          	bltu	a3,a0,80001efc <z_vprintk+0x100>
80001ecc:	03100693          	li	a3,49
80001ed0:	0ed57463          	bgeu	a0,a3,80001fb8 <z_vprintk+0x1bc>
80001ed4:	02d00693          	li	a3,45
80001ed8:	34d50a63          	beq	a0,a3,8000222c <z_vprintk+0x430>
80001edc:	03000793          	li	a5,48
80001ee0:	0cf50063          	beq	a0,a5,80001fa0 <z_vprintk+0x1a4>
80001ee4:	02500713          	li	a4,37
80001ee8:	02e51263          	bne	a0,a4,80001f0c <z_vprintk+0x110>
				out((int)'%', ctx);
80001eec:	00048593          	mv	a1,s1
80001ef0:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001ef4:	000400e7          	jalr	s0
				break;
80001ef8:	15c0006f          	j	80002054 <z_vprintk+0x258>
80001efc:	05800693          	li	a3,88
80001f00:	1ad50e63          	beq	a0,a3,800020bc <z_vprintk+0x2c0>
80001f04:	06300713          	li	a4,99
80001f08:	2ee50e63          	beq	a0,a4,80002204 <z_vprintk+0x408>
				out((int)'%', ctx);
80001f0c:	00048593          	mv	a1,s1
80001f10:	02500513          	li	a0,37
80001f14:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001f18:	00048593          	mv	a1,s1
80001f1c:	000ac503          	lbu	a0,0(s5)
80001f20:	fd5ff06f          	j	80001ef4 <z_vprintk+0xf8>
80001f24:	07000693          	li	a3,112
80001f28:	16d50a63          	beq	a0,a3,8000209c <z_vprintk+0x2a0>
80001f2c:	02a6e063          	bltu	a3,a0,80001f4c <z_vprintk+0x150>
80001f30:	06900693          	li	a3,105
80001f34:	0ad50263          	beq	a0,a3,80001fd8 <z_vprintk+0x1dc>
80001f38:	06c00693          	li	a3,108
80001f3c:	08d50a63          	beq	a0,a3,80001fd0 <z_vprintk+0x1d4>
80001f40:	06800693          	li	a3,104
80001f44:	f6d506e3          	beq	a0,a3,80001eb0 <z_vprintk+0xb4>
80001f48:	fc5ff06f          	j	80001f0c <z_vprintk+0x110>
80001f4c:	07500693          	li	a3,117
80001f50:	10d50663          	beq	a0,a3,8000205c <z_vprintk+0x260>
80001f54:	02a6ee63          	bltu	a3,a0,80001f90 <z_vprintk+0x194>
80001f58:	07300713          	li	a4,115
80001f5c:	fae518e3          	bne	a0,a4,80001f0c <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001f60:	000d2c03          	lw	s8,0(s10)
80001f64:	004d0b13          	addi	s6,s10,4
80001f68:	000c0b93          	mv	s7,s8
				while (*s)
80001f6c:	000bc503          	lbu	a0,0(s7)
80001f70:	26051863          	bnez	a0,800021e0 <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
80001f74:	00300793          	li	a5,3
80001f78:	00f99863          	bne	s3,a5,80001f88 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80001f7c:	418b8bb3          	sub	s7,s7,s8
80001f80:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001f84:	27704663          	bgtz	s7,800021f0 <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
80001f88:	000b0d13          	mv	s10,s6
80001f8c:	0c80006f          	j	80002054 <z_vprintk+0x258>
80001f90:	07800693          	li	a3,120
80001f94:	12d50463          	beq	a0,a3,800020bc <z_vprintk+0x2c0>
80001f98:	07a00693          	li	a3,122
80001f9c:	fa9ff06f          	j	80001f44 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001fa0:	00095e63          	bgez	s2,80001fbc <z_vprintk+0x1c0>
80001fa4:	28098863          	beqz	s3,80002234 <z_vprintk+0x438>
					min_width = *fmt - '0';
80001fa8:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001fac:	f00992e3          	bnez	s3,80001eb0 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001fb0:	00200993          	li	s3,2
80001fb4:	efdff06f          	j	80001eb0 <z_vprintk+0xb4>
				if (min_width < 0) {
80001fb8:	fe0948e3          	bltz	s2,80001fa8 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001fbc:	00a00693          	li	a3,10
80001fc0:	02d90933          	mul	s2,s2,a3
80001fc4:	fd090913          	addi	s2,s2,-48
80001fc8:	01250933          	add	s2,a0,s2
80001fcc:	fe1ff06f          	j	80001fac <z_vprintk+0x1b0>
				long_ctr++;
80001fd0:	001a0a13          	addi	s4,s4,1
80001fd4:	eddff06f          	j	80001eb0 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001fd8:	040a1263          	bnez	s4,8000201c <z_vprintk+0x220>
					long ld = va_arg(ap, long);
80001fdc:	000d2603          	lw	a2,0(s10)
80001fe0:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001fe4:	02065063          	bgez	a2,80002004 <z_vprintk+0x208>
					out((int)'-', ctx);
80001fe8:	00048593          	mv	a1,s1
80001fec:	02d00513          	li	a0,45
80001ff0:	00c12023          	sw	a2,0(sp)
80001ff4:	000400e7          	jalr	s0
					d = -d;
80001ff8:	00012603          	lw	a2,0(sp)
					min_width--;
80001ffc:	fff90913          	addi	s2,s2,-1
					d = -d;
80002000:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80002004:	00090713          	mv	a4,s2
80002008:	00098693          	mv	a3,s3
8000200c:	00048593          	mv	a1,s1
80002010:	00040513          	mv	a0,s0
80002014:	c95ff0ef          	jal	ra,80001ca8 <_printk_dec_ulong>
				break;
80002018:	03c0006f          	j	80002054 <z_vprintk+0x258>
				} else if (long_ctr == 1) {
8000201c:	00100713          	li	a4,1
80002020:	faea0ee3          	beq	s4,a4,80001fdc <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
80002024:	007d0793          	addi	a5,s10,7
80002028:	ff87f713          	andi	a4,a5,-8
8000202c:	00072603          	lw	a2,0(a4)
80002030:	00472683          	lw	a3,4(a4)
80002034:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80002038:	01b60733          	add	a4,a2,s11
8000203c:	00c73733          	sltu	a4,a4,a2
80002040:	00d70733          	add	a4,a4,a3
80002044:	fa0700e3          	beqz	a4,80001fe4 <z_vprintk+0x1e8>
						print_err(out, ctx);
80002048:	00048593          	mv	a1,s1
8000204c:	00040513          	mv	a0,s0
80002050:	bf5ff0ef          	jal	ra,80001c44 <print_err>
			might_format = 0;
80002054:	00000c93          	li	s9,0
80002058:	e59ff06f          	j	80001eb0 <z_vprintk+0xb4>
				if (long_ctr == 0) {
8000205c:	000a1863          	bnez	s4,8000206c <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
80002060:	000d2603          	lw	a2,0(s10)
80002064:	004d0d13          	addi	s10,s10,4
80002068:	f9dff06f          	j	80002004 <z_vprintk+0x208>
				} else if (long_ctr == 1) {
8000206c:	00100713          	li	a4,1
80002070:	feea08e3          	beq	s4,a4,80002060 <z_vprintk+0x264>
					unsigned long long llu =
80002074:	007d0793          	addi	a5,s10,7
80002078:	ff87f713          	andi	a4,a5,-8
8000207c:	00870d13          	addi	s10,a4,8
80002080:	00072603          	lw	a2,0(a4)
80002084:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80002088:	fc0710e3          	bnez	a4,80002048 <z_vprintk+0x24c>
8000208c:	800007b7          	lui	a5,0x80000
80002090:	fff7c793          	not	a5,a5
80002094:	f6c7f8e3          	bgeu	a5,a2,80002004 <z_vprintk+0x208>
80002098:	fb1ff06f          	j	80002048 <z_vprintk+0x24c>
				  out('0', ctx);
8000209c:	00048593          	mv	a1,s1
800020a0:	03000513          	li	a0,48
800020a4:	000400e7          	jalr	s0
				  out('x', ctx);
800020a8:	00048593          	mv	a1,s1
800020ac:	07800513          	li	a0,120
800020b0:	000400e7          	jalr	s0
				  min_width = 8;
800020b4:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
800020b8:	00100993          	li	s3,1
				if (long_ctr < 2) {
800020bc:	00100693          	li	a3,1
800020c0:	0b46c263          	blt	a3,s4,80002164 <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
800020c4:	000d2783          	lw	a5,0(s10)
800020c8:	00012423          	sw	zero,8(sp)
800020cc:	004d0d13          	addi	s10,s10,4
800020d0:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
800020d4:	01000c13          	li	s8,16
	int digits = 0;
800020d8:	00000b93          	li	s7,0
	int found_largest_digit = 0;
800020dc:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800020e0:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800020e4:	00412503          	lw	a0,4(sp)
800020e8:	00812583          	lw	a1,8(sp)
800020ec:	fff88b13          	addi	s6,a7,-1
800020f0:	002b1613          	slli	a2,s6,0x2
800020f4:	01112623          	sw	a7,12(sp)
800020f8:	980fe0ef          	jal	ra,80000278 <__lshrdi3>
800020fc:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002100:	08051863          	bnez	a0,80002190 <z_vprintk+0x394>
80002104:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80002108:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
8000210c:	00079863          	bnez	a5,8000211c <z_vprintk+0x320>
80002110:	00c12883          	lw	a7,12(sp)
80002114:	00100793          	li	a5,1
80002118:	08f89663          	bne	a7,a5,800021a4 <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
8000211c:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80002120:	01851513          	slli	a0,a0,0x18
80002124:	00048593          	mv	a1,s1
80002128:	41855513          	srai	a0,a0,0x18
8000212c:	000400e7          	jalr	s0
			digits++;
80002130:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80002134:	040b1863          	bnez	s6,80002184 <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
80002138:	00300693          	li	a3,3
			might_format = 0;
8000213c:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80002140:	d6d998e3          	bne	s3,a3,80001eb0 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80002144:	00191713          	slli	a4,s2,0x1
80002148:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
8000214c:	f17054e3          	blez	s7,80002054 <z_vprintk+0x258>
			out(' ', ctx);
80002150:	00048593          	mv	a1,s1
80002154:	02000513          	li	a0,32
80002158:	000400e7          	jalr	s0
8000215c:	fffb8b93          	addi	s7,s7,-1
80002160:	fedff06f          	j	8000214c <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
80002164:	007d0793          	addi	a5,s10,7
80002168:	ff87f693          	andi	a3,a5,-8
8000216c:	0006a783          	lw	a5,0(a3)
80002170:	00868d13          	addi	s10,a3,8
80002174:	00f12223          	sw	a5,4(sp)
80002178:	0046a783          	lw	a5,4(a3)
8000217c:	00f12423          	sw	a5,8(sp)
80002180:	f55ff06f          	j	800020d4 <z_vprintk+0x2d8>
			found_largest_digit = 1;
80002184:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80002188:	000b0893          	mv	a7,s6
8000218c:	f59ff06f          	j	800020e4 <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
80002190:	00900793          	li	a5,9
80002194:	05700693          	li	a3,87
80002198:	f8a7e2e3          	bltu	a5,a0,8000211c <z_vprintk+0x320>
8000219c:	03000693          	li	a3,48
800021a0:	f7dff06f          	j	8000211c <z_vprintk+0x320>
		if (remaining-- <= min_width) {
800021a4:	fffc0793          	addi	a5,s8,-1
800021a8:	00f12623          	sw	a5,12(sp)
800021ac:	01894c63          	blt	s2,s8,800021c4 <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
800021b0:	00100793          	li	a5,1
800021b4:	00f99c63          	bne	s3,a5,800021cc <z_vprintk+0x3d0>
				out('0', ctx);
800021b8:	00048593          	mv	a1,s1
800021bc:	03000513          	li	a0,48
				out(' ', ctx);
800021c0:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
800021c4:	00c12c03          	lw	s8,12(sp)
800021c8:	fc1ff06f          	j	80002188 <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
800021cc:	00200793          	li	a5,2
800021d0:	fef99ae3          	bne	s3,a5,800021c4 <z_vprintk+0x3c8>
				out(' ', ctx);
800021d4:	00048593          	mv	a1,s1
800021d8:	02000513          	li	a0,32
800021dc:	fe5ff06f          	j	800021c0 <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
800021e0:	00048593          	mv	a1,s1
800021e4:	001b8b93          	addi	s7,s7,1
800021e8:	000400e7          	jalr	s0
800021ec:	d81ff06f          	j	80001f6c <z_vprintk+0x170>
						out(' ', ctx);
800021f0:	00048593          	mv	a1,s1
800021f4:	02000513          	li	a0,32
800021f8:	000400e7          	jalr	s0
800021fc:	fffb8b93          	addi	s7,s7,-1
80002200:	d85ff06f          	j	80001f84 <z_vprintk+0x188>
				out(c, ctx);
80002204:	000d2503          	lw	a0,0(s10)
80002208:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
8000220c:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80002210:	000400e7          	jalr	s0
				break;
80002214:	d75ff06f          	j	80001f88 <z_vprintk+0x18c>
				long_ctr = 0;
80002218:	00000a13          	li	s4,0
				min_width = -1;
8000221c:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80002220:	00000993          	li	s3,0
				might_format = 1;
80002224:	00100c93          	li	s9,1
80002228:	c89ff06f          	j	80001eb0 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
8000222c:	00300993          	li	s3,3
80002230:	c81ff06f          	j	80001eb0 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80002234:	00100993          	li	s3,1
80002238:	c79ff06f          	j	80001eb0 <z_vprintk+0xb4>

8000223c <vprintk>:
{
8000223c:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80002240:	00050613          	mv	a2,a0
80002244:	80002537          	lui	a0,0x80002
80002248:	00058693          	mv	a3,a1
8000224c:	c9050513          	addi	a0,a0,-880 # 80001c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001c91>
80002250:	00c10593          	addi	a1,sp,12
{
80002254:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80002258:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
8000225c:	ba1ff0ef          	jal	ra,80001dfc <z_vprintk>
}
80002260:	01c12083          	lw	ra,28(sp)
80002264:	02010113          	addi	sp,sp,32
80002268:	00008067          	ret

8000226c <printk>:
{
8000226c:	fc010113          	addi	sp,sp,-64
80002270:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80002274:	02410593          	addi	a1,sp,36
{
80002278:	00112e23          	sw	ra,28(sp)
8000227c:	02c12423          	sw	a2,40(sp)
80002280:	02d12623          	sw	a3,44(sp)
80002284:	02e12823          	sw	a4,48(sp)
80002288:	02f12a23          	sw	a5,52(sp)
8000228c:	03012c23          	sw	a6,56(sp)
80002290:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80002294:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80002298:	fa5ff0ef          	jal	ra,8000223c <vprintk>
}
8000229c:	01c12083          	lw	ra,28(sp)
800022a0:	04010113          	addi	sp,sp,64
800022a4:	00008067          	ret

800022a8 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800022a8:	800075b7          	lui	a1,0x80007
800022ac:	80007537          	lui	a0,0x80007
{
800022b0:	ff010113          	addi	sp,sp,-16
  k_panic();
800022b4:	b3058593          	addi	a1,a1,-1232 # 80006b30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b31>
800022b8:	b4450513          	addi	a0,a0,-1212 # 80006b44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b45>
800022bc:	01e00613          	li	a2,30
{
800022c0:	00112623          	sw	ra,12(sp)
  k_panic();
800022c4:	fa9ff0ef          	jal	ra,8000226c <printk>
800022c8:	800065b7          	lui	a1,0x80006
800022cc:	75458593          	addi	a1,a1,1876 # 80006754 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006755>
800022d0:	00600513          	li	a0,6
800022d4:	cacff0ef          	jal	ra,80001780 <z_NanoFatalErrorHandler>

800022d8 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800022d8:	00008067          	ret

800022dc <k_cpu_idle>:
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
800022dc:	00800793          	li	a5,8
800022e0:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800022e4:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
800022e8:	00008067          	ret

800022ec <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
800022ec:	00100793          	li	a5,1
800022f0:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
800022f4:	30452573          	csrrs	a0,mie,a0
}
800022f8:	00008067          	ret

800022fc <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800022fc:	00800793          	li	a5,8
80002300:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80002304:	30405073          	csrwi	mie,0
80002308:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
8000230c:	00008067          	ret

80002310 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002310:	ff010113          	addi	sp,sp,-16
80002314:	00812423          	sw	s0,8(sp)
80002318:	00912223          	sw	s1,4(sp)
8000231c:	80007437          	lui	s0,0x80007
80002320:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80002324:	00a00793          	li	a5,10
{
80002328:	00050493          	mv	s1,a0
8000232c:	2e840413          	addi	s0,s0,744 # 800072e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072e9>
	if ('\n' == c) {
80002330:	00f51c63          	bne	a0,a5,80002348 <console_out+0x38>
80002334:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80002338:	00d00593          	li	a1,13
8000233c:	00452783          	lw	a5,4(a0)
80002340:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80002344:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80002348:	00042503          	lw	a0,0(s0)
8000234c:	0ff4f593          	andi	a1,s1,255
80002350:	00452783          	lw	a5,4(a0)
80002354:	0047a783          	lw	a5,4(a5)
80002358:	000780e7          	jalr	a5

	return c;
}
8000235c:	00c12083          	lw	ra,12(sp)
80002360:	00812403          	lw	s0,8(sp)
80002364:	00048513          	mv	a0,s1
80002368:	00412483          	lw	s1,4(sp)
8000236c:	01010113          	addi	sp,sp,16
80002370:	00008067          	ret

80002374 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80002374:	ff010113          	addi	sp,sp,-16
80002378:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
8000237c:	80002437          	lui	s0,0x80002
80002380:	31040513          	addi	a0,s0,784 # 80002310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002311>
{
80002384:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80002388:	52c000ef          	jal	ra,800028b4 <__stdout_hook_install>
	__printk_hook_install(console_out);
8000238c:	31040513          	addi	a0,s0,784
}
80002390:	00812403          	lw	s0,8(sp)
80002394:	00c12083          	lw	ra,12(sp)
80002398:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
8000239c:	a55ff06f          	j	80001df0 <__printk_hook_install>

800023a0 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
800023a0:	80007537          	lui	a0,0x80007
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
800023a4:	ff010113          	addi	sp,sp,-16
800023a8:	b5050513          	addi	a0,a0,-1200 # 80006b50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b51>
800023ac:	00112623          	sw	ra,12(sp)
800023b0:	0ad000ef          	jal	ra,80002c5c <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
800023b4:	800077b7          	lui	a5,0x80007
800023b8:	2ea7a423          	sw	a0,744(a5) # 800072e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072e9>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
800023bc:	fb9ff0ef          	jal	ra,80002374 <uart_console_hook_install>

	return 0;
}
800023c0:	00c12083          	lw	ra,12(sp)
800023c4:	00000513          	li	a0,0
800023c8:	01010113          	addi	sp,sp,16
800023cc:	00008067          	ret

800023d0 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
800023d0:	f01007b7          	lui	a5,0xf0100
800023d4:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
800023d8:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800023dc:	f447a583          	lw	a1,-188(a5)
800023e0:	fee59ae3          	bne	a1,a4,800023d4 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800023e4:	00008067          	ret

800023e8 <timer_isr>:

static void timer_isr(void *arg)
{
800023e8:	fe010113          	addi	sp,sp,-32
800023ec:	00812c23          	sw	s0,24(sp)
800023f0:	00112e23          	sw	ra,28(sp)
800023f4:	00912a23          	sw	s1,20(sp)
800023f8:	01212823          	sw	s2,16(sp)
800023fc:	01312623          	sw	s3,12(sp)
80002400:	01412423          	sw	s4,8(sp)
80002404:	01512223          	sw	s5,4(sp)
80002408:	00800413          	li	s0,8
8000240c:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002410:	80007937          	lui	s2,0x80007
80002414:	2ec90513          	addi	a0,s2,748 # 800072ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80002418:	00847413          	andi	s0,s0,8
8000241c:	694020ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80002420:	02051e63          	bnez	a0,8000245c <timer_isr+0x74>
80002424:	800074b7          	lui	s1,0x80007
80002428:	800075b7          	lui	a1,0x80007
8000242c:	80007537          	lui	a0,0x80007
80002430:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80002434:	04e00693          	li	a3,78
80002438:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
8000243c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80002440:	e2dff0ef          	jal	ra,8000226c <printk>
80002444:	80007537          	lui	a0,0x80007
80002448:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
8000244c:	e21ff0ef          	jal	ra,8000226c <printk>
80002450:	04e00593          	li	a1,78
80002454:	b6448513          	addi	a0,s1,-1180
80002458:	e51ff0ef          	jal	ra,800022a8 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
8000245c:	2ec90513          	addi	a0,s2,748
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002460:	800074b7          	lui	s1,0x80007
80002464:	6a4020ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
80002468:	2d048493          	addi	s1,s1,720 # 800072d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d1>
	u64_t now = mtime();
8000246c:	f65ff0ef          	jal	ra,800023d0 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002470:	0004a983          	lw	s3,0(s1)
80002474:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80002478:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
8000247c:	41350533          	sub	a0,a0,s3
80002480:	00a73733          	sltu	a4,a4,a0
80002484:	415585b3          	sub	a1,a1,s5
80002488:	0001d637          	lui	a2,0x1d
8000248c:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002490:	00000693          	li	a3,0
80002494:	40e585b3          	sub	a1,a1,a4
80002498:	e19fd0ef          	jal	ra,800002b0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
8000249c:	0001d7b7          	lui	a5,0x1d
800024a0:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800024a4:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800024a8:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024ac:	2ec90513          	addi	a0,s2,748
	last_count += dticks * CYC_PER_TICK;
800024b0:	013789b3          	add	s3,a5,s3
800024b4:	00f9b7b3          	sltu	a5,s3,a5
800024b8:	015787b3          	add	a5,a5,s5
800024bc:	0134a023          	sw	s3,0(s1)
800024c0:	00f4a223          	sw	a5,4(s1)
800024c4:	614020ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800024c8:	02051e63          	bnez	a0,80002504 <timer_isr+0x11c>
800024cc:	800074b7          	lui	s1,0x80007
800024d0:	800075b7          	lui	a1,0x80007
800024d4:	80007537          	lui	a0,0x80007
800024d8:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800024dc:	06100693          	li	a3,97
800024e0:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800024e4:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800024e8:	d85ff0ef          	jal	ra,8000226c <printk>
800024ec:	80007537          	lui	a0,0x80007
800024f0:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800024f4:	d79ff0ef          	jal	ra,8000226c <printk>
800024f8:	06100593          	li	a1,97
800024fc:	b6448513          	addi	a0,s1,-1180
80002500:	da9ff0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002504:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002508:	01812403          	lw	s0,24(sp)
8000250c:	01c12083          	lw	ra,28(sp)
80002510:	01412483          	lw	s1,20(sp)
80002514:	01012903          	lw	s2,16(sp)
80002518:	00c12983          	lw	s3,12(sp)
8000251c:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002520:	000a0513          	mv	a0,s4
}
80002524:	00812a03          	lw	s4,8(sp)
80002528:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
8000252c:	0dc0306f          	j	80005608 <z_clock_announce>

80002530 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002530:	ff010113          	addi	sp,sp,-16
80002534:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002538:	e99ff0ef          	jal	ra,800023d0 <mtime>
8000253c:	0001d7b7          	lui	a5,0x1d
80002540:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80002544:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002548:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
8000254c:	fff00693          	li	a3,-1
80002550:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002554:	00a7b533          	sltu	a0,a5,a0
80002558:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
8000255c:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002560:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80002564:	00700513          	li	a0,7
80002568:	d85ff0ef          	jal	ra,800022ec <z_arch_irq_enable>
	return 0;
}
8000256c:	00c12083          	lw	ra,12(sp)
80002570:	00000513          	li	a0,0
80002574:	01010113          	addi	sp,sp,16
80002578:	00008067          	ret

8000257c <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
8000257c:	16059c63          	bnez	a1,800026f4 <z_clock_set_timeout+0x178>
{
80002580:	fe010113          	addi	sp,sp,-32
80002584:	00112e23          	sw	ra,28(sp)
80002588:	00812c23          	sw	s0,24(sp)
8000258c:	00912a23          	sw	s1,20(sp)
80002590:	01212823          	sw	s2,16(sp)
80002594:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80002598:	fff00793          	li	a5,-1
8000259c:	00f51663          	bne	a0,a5,800025a8 <z_clock_set_timeout+0x2c>
800025a0:	00009537          	lui	a0,0x9
800025a4:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
800025a8:	000097b7          	lui	a5,0x9
800025ac:	fff50413          	addi	s0,a0,-1
800025b0:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
800025b4:	1287da63          	bge	a5,s0,800026e8 <z_clock_set_timeout+0x16c>
800025b8:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
800025bc:	00800493          	li	s1,8
800025c0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800025c4:	80007937          	lui	s2,0x80007
800025c8:	2ec90513          	addi	a0,s2,748 # 800072ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800025cc:	0084f493          	andi	s1,s1,8
800025d0:	4e0020ef          	jal	ra,80004ab0 <z_spin_lock_valid>
800025d4:	02051e63          	bnez	a0,80002610 <z_clock_set_timeout+0x94>
800025d8:	800079b7          	lui	s3,0x80007
800025dc:	800075b7          	lui	a1,0x80007
800025e0:	80007537          	lui	a0,0x80007
800025e4:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800025e8:	04e00693          	li	a3,78
800025ec:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800025f0:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800025f4:	c79ff0ef          	jal	ra,8000226c <printk>
800025f8:	80007537          	lui	a0,0x80007
800025fc:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80002600:	c6dff0ef          	jal	ra,8000226c <printk>
80002604:	04e00593          	li	a1,78
80002608:	b6498513          	addi	a0,s3,-1180
8000260c:	c9dff0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002610:	2ec90513          	addi	a0,s2,748
80002614:	4f4020ef          	jal	ra,80004b08 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002618:	db9ff0ef          	jal	ra,800023d0 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
8000261c:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002620:	800077b7          	lui	a5,0x80007
	u32_t cyc = ticks * CYC_PER_TICK;
80002624:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002628:	2d078793          	addi	a5,a5,720 # 800072d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d1>
8000262c:	0007a703          	lw	a4,0(a5)
80002630:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002634:	02c407b3          	mul	a5,s0,a2
80002638:	4bf68693          	addi	a3,a3,1215
8000263c:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002640:	3e700693          	li	a3,999
80002644:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002648:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
8000264c:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002650:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002654:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002658:	00f50533          	add	a0,a0,a5
8000265c:	00a6c463          	blt	a3,a0,80002664 <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
80002660:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
80002664:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002668:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
8000266c:	fff00613          	li	a2,-1
80002670:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002674:	00f737b3          	sltu	a5,a4,a5
80002678:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
8000267c:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
80002680:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002684:	2ec90513          	addi	a0,s2,748
80002688:	450020ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000268c:	02051e63          	bnez	a0,800026c8 <z_clock_set_timeout+0x14c>
80002690:	80007437          	lui	s0,0x80007
80002694:	800075b7          	lui	a1,0x80007
80002698:	80007537          	lui	a0,0x80007
8000269c:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800026a0:	06100693          	li	a3,97
800026a4:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800026a8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800026ac:	bc1ff0ef          	jal	ra,8000226c <printk>
800026b0:	80007537          	lui	a0,0x80007
800026b4:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800026b8:	bb5ff0ef          	jal	ra,8000226c <printk>
800026bc:	06100593          	li	a1,97
800026c0:	b6440513          	addi	a0,s0,-1180
800026c4:	be5ff0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800026c8:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
800026cc:	01c12083          	lw	ra,28(sp)
800026d0:	01812403          	lw	s0,24(sp)
800026d4:	01412483          	lw	s1,20(sp)
800026d8:	01012903          	lw	s2,16(sp)
800026dc:	00c12983          	lw	s3,12(sp)
800026e0:	02010113          	addi	sp,sp,32
800026e4:	00008067          	ret
800026e8:	ec045ae3          	bgez	s0,800025bc <z_clock_set_timeout+0x40>
800026ec:	00000413          	li	s0,0
800026f0:	ecdff06f          	j	800025bc <z_clock_set_timeout+0x40>
800026f4:	00008067          	ret

800026f8 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
800026f8:	ff010113          	addi	sp,sp,-16
800026fc:	00812423          	sw	s0,8(sp)
80002700:	00112623          	sw	ra,12(sp)
80002704:	00912223          	sw	s1,4(sp)
80002708:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000270c:	00800413          	li	s0,8
80002710:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002714:	80007937          	lui	s2,0x80007
80002718:	2ec90513          	addi	a0,s2,748 # 800072ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072ed>
	key = (mstatus & SOC_MSTATUS_IEN);
8000271c:	00847413          	andi	s0,s0,8
80002720:	390020ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80002724:	02051e63          	bnez	a0,80002760 <z_clock_elapsed+0x68>
80002728:	800074b7          	lui	s1,0x80007
8000272c:	800075b7          	lui	a1,0x80007
80002730:	80007537          	lui	a0,0x80007
80002734:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80002738:	04e00693          	li	a3,78
8000273c:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80002740:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80002744:	b29ff0ef          	jal	ra,8000226c <printk>
80002748:	80007537          	lui	a0,0x80007
8000274c:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80002750:	b1dff0ef          	jal	ra,8000226c <printk>
80002754:	04e00593          	li	a1,78
80002758:	b6448513          	addi	a0,s1,-1180
8000275c:	b4dff0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002760:	2ec90513          	addi	a0,s2,748
80002764:	3a4020ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002768:	c69ff0ef          	jal	ra,800023d0 <mtime>
8000276c:	800077b7          	lui	a5,0x80007
80002770:	2d07a483          	lw	s1,720(a5) # 800072d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d1>
80002774:	409504b3          	sub	s1,a0,s1
80002778:	0001d537          	lui	a0,0x1d
8000277c:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002780:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002784:	2ec90513          	addi	a0,s2,748
80002788:	350020ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000278c:	02051e63          	bnez	a0,800027c8 <z_clock_elapsed+0xd0>
80002790:	80007937          	lui	s2,0x80007
80002794:	800075b7          	lui	a1,0x80007
80002798:	80007537          	lui	a0,0x80007
8000279c:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800027a0:	06100693          	li	a3,97
800027a4:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800027a8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800027ac:	ac1ff0ef          	jal	ra,8000226c <printk>
800027b0:	80007537          	lui	a0,0x80007
800027b4:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800027b8:	ab5ff0ef          	jal	ra,8000226c <printk>
800027bc:	06100593          	li	a1,97
800027c0:	b6490513          	addi	a0,s2,-1180
800027c4:	ae5ff0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800027c8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
800027cc:	00c12083          	lw	ra,12(sp)
800027d0:	00812403          	lw	s0,8(sp)
800027d4:	00048513          	mv	a0,s1
800027d8:	00012903          	lw	s2,0(sp)
800027dc:	00412483          	lw	s1,4(sp)
800027e0:	01010113          	addi	sp,sp,16
800027e4:	00008067          	ret

800027e8 <z_timer_cycle_get_32>:

u32_t z_timer_cycle_get_32(void)
{
800027e8:	ff010113          	addi	sp,sp,-16
800027ec:	00112623          	sw	ra,12(sp)
	return (u32_t)mtime();
800027f0:	be1ff0ef          	jal	ra,800023d0 <mtime>
}
800027f4:	00c12083          	lw	ra,12(sp)
800027f8:	01010113          	addi	sp,sp,16
800027fc:	00008067          	ret

80002800 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002800:	00054783          	lbu	a5,0(a0)
80002804:	0005c703          	lbu	a4,0(a1)
80002808:	00e79463          	bne	a5,a4,80002810 <strcmp+0x10>
8000280c:	00079663          	bnez	a5,80002818 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002810:	40e78533          	sub	a0,a5,a4
80002814:	00008067          	ret
		s1++;
80002818:	00150513          	addi	a0,a0,1
		s2++;
8000281c:	00158593          	addi	a1,a1,1
80002820:	fe1ff06f          	j	80002800 <strcmp>

80002824 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002824:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002828:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
8000282c:	0037f713          	andi	a4,a5,3
80002830:	04071863          	bnez	a4,80002880 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002834:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002838:	00859713          	slli	a4,a1,0x8
8000283c:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002840:	01059713          	slli	a4,a1,0x10
80002844:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002848:	00c78333          	add	t1,a5,a2
8000284c:	00078713          	mv	a4,a5
80002850:	00300813          	li	a6,3
80002854:	40e308b3          	sub	a7,t1,a4
80002858:	03186e63          	bltu	a6,a7,80002894 <memset+0x70>
8000285c:	00265713          	srli	a4,a2,0x2
80002860:	00271593          	slli	a1,a4,0x2
80002864:	00b787b3          	add	a5,a5,a1
80002868:	ffc00593          	li	a1,-4
8000286c:	02b70733          	mul	a4,a4,a1
80002870:	00c70733          	add	a4,a4,a2
80002874:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002878:	02e79463          	bne	a5,a4,800028a0 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
8000287c:	00008067          	ret
		if (n == 0) {
80002880:	fe060ee3          	beqz	a2,8000287c <memset+0x58>
		*(d_byte++) = c_byte;
80002884:	00178793          	addi	a5,a5,1
80002888:	fed78fa3          	sb	a3,-1(a5)
		n--;
8000288c:	fff60613          	addi	a2,a2,-1
80002890:	f9dff06f          	j	8000282c <memset+0x8>
		*(d_word++) = c_word;
80002894:	00470713          	addi	a4,a4,4
80002898:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
8000289c:	fb9ff06f          	j	80002854 <memset+0x30>
		*(d_byte++) = c_byte;
800028a0:	00178793          	addi	a5,a5,1
800028a4:	fed78fa3          	sb	a3,-1(a5)
		n--;
800028a8:	fd1ff06f          	j	80002878 <memset+0x54>

800028ac <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
800028ac:	fff00513          	li	a0,-1
800028b0:	00008067          	ret

800028b4 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
800028b4:	800077b7          	lui	a5,0x80007
800028b8:	16a7a423          	sw	a0,360(a5) # 80007168 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007169>
}
800028bc:	00008067          	ret

800028c0 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
800028c0:	fe010113          	addi	sp,sp,-32
800028c4:	00812c23          	sw	s0,24(sp)
	test->setup();
800028c8:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
800028cc:	80007437          	lui	s0,0x80007
{
800028d0:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
800028d4:	16c40413          	addi	s0,s0,364 # 8000716c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000716d>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
800028d8:	800074b7          	lui	s1,0x80007
{
800028dc:	00112e23          	sw	ra,28(sp)
800028e0:	01212823          	sw	s2,16(sp)
800028e4:	01312623          	sw	s3,12(sp)
	test_result = 1;
800028e8:	2f048493          	addi	s1,s1,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800028ec:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
800028f0:	00042023          	sw	zero,0(s0)
{
800028f4:	00050913          	mv	s2,a0
	test_result = 1;
800028f8:	0134a023          	sw	s3,0(s1)
	test->setup();
800028fc:	000780e7          	jalr	a5
	test->test();
80002900:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002904:	01342023          	sw	s3,0(s0)
	test->test();
80002908:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
8000290c:	00200793          	li	a5,2
80002910:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002914:	00c92783          	lw	a5,12(s2)
80002918:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
8000291c:	00300793          	li	a5,3
80002920:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002924:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002928:	0004a023          	sw	zero,0(s1)
}
8000292c:	01c12083          	lw	ra,28(sp)
80002930:	01412483          	lw	s1,20(sp)
80002934:	01012903          	lw	s2,16(sp)
80002938:	00c12983          	lw	s3,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
8000293c:	80007537          	lui	a0,0x80007
80002940:	39c50513          	addi	a0,a0,924 # 8000739c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000739d>
80002944:	02010113          	addi	sp,sp,32
80002948:	5510106f          	j	80004698 <z_impl_k_sem_give>

8000294c <ztest_test_fail>:
8000294c:	80007537          	lui	a0,0x80007
{
80002950:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002954:	800077b7          	lui	a5,0x80007
80002958:	fff00713          	li	a4,-1
8000295c:	39c50513          	addi	a0,a0,924 # 8000739c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000739d>
{
80002960:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002964:	2ee7a823          	sw	a4,752(a5) # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80002968:	531010ef          	jal	ra,80004698 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000296c:	459010ef          	jal	ra,800045c4 <z_impl_k_current_get>
}
80002970:	00c12083          	lw	ra,12(sp)
80002974:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002978:	4a00206f          	j	80004e18 <z_impl_k_thread_abort>

8000297c <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
8000297c:	fa010113          	addi	sp,sp,-96
80002980:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002984:	800074b7          	lui	s1,0x80007
80002988:	2f44a783          	lw	a5,756(s1) # 800072f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f5>
{
8000298c:	04112e23          	sw	ra,92(sp)
80002990:	04812c23          	sw	s0,88(sp)
80002994:	05212823          	sw	s2,80(sp)
80002998:	05312623          	sw	s3,76(sp)
8000299c:	05412423          	sw	s4,72(sp)
800029a0:	05512223          	sw	s5,68(sp)
800029a4:	05612023          	sw	s6,64(sp)
800029a8:	03712e23          	sw	s7,60(sp)
800029ac:	03812c23          	sw	s8,56(sp)
800029b0:	03912a23          	sw	s9,52(sp)
800029b4:	03a12823          	sw	s10,48(sp)
800029b8:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
800029bc:	0807c463          	bltz	a5,80002a44 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
800029c0:	80007437          	lui	s0,0x80007
800029c4:	00100613          	li	a2,1
800029c8:	00050993          	mv	s3,a0
800029cc:	00058c13          	mv	s8,a1
800029d0:	39c40513          	addi	a0,s0,924 # 8000739c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000739d>
800029d4:	00000593          	li	a1,0
800029d8:	3f9010ef          	jal	ra,800045d0 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800029dc:	80007537          	lui	a0,0x80007
800029e0:	00098593          	mv	a1,s3
800029e4:	c2050513          	addi	a0,a0,-992 # 80006c20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c21>
800029e8:	885ff0ef          	jal	ra,8000226c <printk>
	PRINT_LINE;
800029ec:	80007937          	lui	s2,0x80007
800029f0:	c3890513          	addi	a0,s2,-968 # 80006c38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c39>
		Z_TC_END_RESULT(ret, test->name);
800029f4:	80007ab7          	lui	s5,0x80007
	PRINT_LINE;
800029f8:	875ff0ef          	jal	ra,8000226c <printk>
800029fc:	2f448493          	addi	s1,s1,756
	int fail = 0;
80002a00:	00000a13          	li	s4,0
80002a04:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002a08:	80007cb7          	lui	s9,0x80007
80002a0c:	80007b37          	lui	s6,0x80007
80002a10:	80003d37          	lui	s10,0x80003
	if (test_result == -1) {
80002a14:	80007db7          	lui	s11,0x80007
80002a18:	80007bb7          	lui	s7,0x80007
		Z_TC_END_RESULT(ret, test->name);
80002a1c:	bd8a8a93          	addi	s5,s5,-1064 # 80006bd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bd9>
	while (suite->test) {
80002a20:	004c2783          	lw	a5,4(s8)
80002a24:	04079e63          	bnez	a5,80002a80 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002a28:	00098593          	mv	a1,s3
	if (fail) {
80002a2c:	100a0663          	beqz	s4,80002b38 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002a30:	80007537          	lui	a0,0x80007
80002a34:	ca850513          	addi	a0,a0,-856 # 80006ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca9>
80002a38:	835ff0ef          	jal	ra,8000226c <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002a3c:	00100793          	li	a5,1
80002a40:	00f4a023          	sw	a5,0(s1)
}
80002a44:	05c12083          	lw	ra,92(sp)
80002a48:	05812403          	lw	s0,88(sp)
80002a4c:	05412483          	lw	s1,84(sp)
80002a50:	05012903          	lw	s2,80(sp)
80002a54:	04c12983          	lw	s3,76(sp)
80002a58:	04812a03          	lw	s4,72(sp)
80002a5c:	04412a83          	lw	s5,68(sp)
80002a60:	04012b03          	lw	s6,64(sp)
80002a64:	03c12b83          	lw	s7,60(sp)
80002a68:	03812c03          	lw	s8,56(sp)
80002a6c:	03412c83          	lw	s9,52(sp)
80002a70:	03012d03          	lw	s10,48(sp)
80002a74:	02c12d83          	lw	s11,44(sp)
80002a78:	06010113          	addi	sp,sp,96
80002a7c:	00008067          	ret
	TC_START(test->name);
80002a80:	000c2583          	lw	a1,0(s8)
80002a84:	800077b7          	lui	a5,0x80007
80002a88:	c8078513          	addi	a0,a5,-896 # 80006c80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c81>
80002a8c:	fe0ff0ef          	jal	ra,8000226c <printk>
80002a90:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002a94:	010c2783          	lw	a5,16(s8)
80002a98:	000c0713          	mv	a4,s8
80002a9c:	40000613          	li	a2,1024
80002aa0:	0087e793          	ori	a5,a5,8
80002aa4:	fff00893          	li	a7,-1
80002aa8:	00000813          	li	a6,0
80002aac:	8c0d0693          	addi	a3,s10,-1856 # 800028c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800028c1>
80002ab0:	00f12023          	sw	a5,0(sp)
80002ab4:	530c8593          	addi	a1,s9,1328 # 80007530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007531>
80002ab8:	00000793          	li	a5,0
80002abc:	3acb0513          	addi	a0,s6,940 # 800073ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073ad>
80002ac0:	1b4020ef          	jal	ra,80004c74 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002ac4:	01c12783          	lw	a5,28(sp)
80002ac8:	fff00593          	li	a1,-1
80002acc:	39c78513          	addi	a0,a5,924
80002ad0:	4ad010ef          	jal	ra,8000477c <z_impl_k_sem_take>
	if (test_result == -1) {
80002ad4:	2f0d8793          	addi	a5,s11,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002ad8:	3acb0513          	addi	a0,s6,940
80002adc:	0007a403          	lw	s0,0(a5)
80002ae0:	338020ef          	jal	ra,80004e18 <z_impl_k_thread_abort>
	if (test_result == -2) {
80002ae4:	800077b7          	lui	a5,0x80007
80002ae8:	2f078793          	addi	a5,a5,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80002aec:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002af0:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80002af4:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002af8:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80002afc:	000c2603          	lw	a2,0(s8)
80002b00:	02f71463          	bne	a4,a5,80002b28 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002b04:	800075b7          	lui	a1,0x80007
80002b08:	c9458593          	addi	a1,a1,-876 # 80006c94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c95>
		Z_TC_END_RESULT(ret, test->name);
80002b0c:	c9cb8513          	addi	a0,s7,-868 # 80006c9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c9d>
80002b10:	f5cff0ef          	jal	ra,8000226c <printk>
80002b14:	c3890513          	addi	a0,s2,-968
80002b18:	f54ff0ef          	jal	ra,8000226c <printk>
		fail += run_test(suite);
80002b1c:	008a0a33          	add	s4,s4,s0
		suite++;
80002b20:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002b24:	efdff06f          	j	80002a20 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80002b28:	00241793          	slli	a5,s0,0x2
80002b2c:	00fa87b3          	add	a5,s5,a5
80002b30:	0007a583          	lw	a1,0(a5)
80002b34:	fd9ff06f          	j	80002b0c <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80002b38:	80007537          	lui	a0,0x80007
80002b3c:	cc050513          	addi	a0,a0,-832 # 80006cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cc1>
80002b40:	f2cff0ef          	jal	ra,8000226c <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002b44:	0004a783          	lw	a5,0(s1)
80002b48:	00f037b3          	snez	a5,a5
80002b4c:	ef5ff06f          	j	80002a40 <z_ztest_run_test_suite+0xc4>

80002b50 <end_report>:

void end_report(void)
{
	if (test_status) {
80002b50:	800077b7          	lui	a5,0x80007
80002b54:	2f47a783          	lw	a5,756(a5) # 800072f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f5>
{
80002b58:	ff010113          	addi	sp,sp,-16
80002b5c:	00812423          	sw	s0,8(sp)
80002b60:	80007537          	lui	a0,0x80007
80002b64:	00112623          	sw	ra,12(sp)
80002b68:	80007437          	lui	s0,0x80007
		TC_END_REPORT(TC_FAIL);
80002b6c:	c3850513          	addi	a0,a0,-968 # 80006c38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c39>
	if (test_status) {
80002b70:	02078263          	beqz	a5,80002b94 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002b74:	ef8ff0ef          	jal	ra,8000226c <printk>
80002b78:	800075b7          	lui	a1,0x80007
80002b7c:	be458593          	addi	a1,a1,-1052 # 80006be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be5>
	} else {
		TC_END_REPORT(TC_PASS);
80002b80:	bec40513          	addi	a0,s0,-1044 # 80006bec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bed>
	}
}
80002b84:	00812403          	lw	s0,8(sp)
80002b88:	00c12083          	lw	ra,12(sp)
80002b8c:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002b90:	edcff06f          	j	8000226c <printk>
80002b94:	ed8ff0ef          	jal	ra,8000226c <printk>
80002b98:	800075b7          	lui	a1,0x80007
80002b9c:	c0458593          	addi	a1,a1,-1020 # 80006c04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c05>
80002ba0:	fe1ff06f          	j	80002b80 <end_report+0x30>

80002ba4 <main>:

	return test_status;
}
#else
void main(void)
{
80002ba4:	ff010113          	addi	sp,sp,-16
80002ba8:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002bac:	b49fe0ef          	jal	ra,800016f4 <test_main>
	end_report();
}
80002bb0:	00c12083          	lw	ra,12(sp)
80002bb4:	01010113          	addi	sp,sp,16
	end_report();
80002bb8:	f99ff06f          	j	80002b50 <end_report>

80002bbc <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002bbc:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002bc0:	00012623          	sw	zero,12(sp)
    i++;
80002bc4:	00c12783          	lw	a5,12(sp)
80002bc8:	00178793          	addi	a5,a5,1
80002bcc:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002bd0:	f00107b7          	lui	a5,0xf0010
80002bd4:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002bd8:	01010113          	addi	sp,sp,16
80002bdc:	00008067          	ret

80002be0 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002be0:	fff00513          	li	a0,-1
80002be4:	00008067          	ret

80002be8 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002be8:	00000513          	li	a0,0
80002bec:	00008067          	ret

80002bf0 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002bf0:	00251713          	slli	a4,a0,0x2
80002bf4:	800077b7          	lui	a5,0x80007
80002bf8:	00150513          	addi	a0,a0,1
80002bfc:	cf078793          	addi	a5,a5,-784 # 80006cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf1>
80002c00:	00251513          	slli	a0,a0,0x2
{
80002c04:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002c08:	00e78733          	add	a4,a5,a4
80002c0c:	00a787b3          	add	a5,a5,a0
{
80002c10:	00812423          	sw	s0,8(sp)
80002c14:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002c18:	00072403          	lw	s0,0(a4)
80002c1c:	0007a483          	lw	s1,0(a5)
{
80002c20:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002c24:	00946c63          	bltu	s0,s1,80002c3c <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002c28:	00c12083          	lw	ra,12(sp)
80002c2c:	00812403          	lw	s0,8(sp)
80002c30:	00412483          	lw	s1,4(sp)
80002c34:	01010113          	addi	sp,sp,16
80002c38:	00008067          	ret
		retval = device_conf->init(info);
80002c3c:	00042783          	lw	a5,0(s0)
80002c40:	00040513          	mv	a0,s0
80002c44:	0047a783          	lw	a5,4(a5)
80002c48:	000780e7          	jalr	a5
		if (retval != 0) {
80002c4c:	00050463          	beqz	a0,80002c54 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002c50:	00042223          	sw	zero,4(s0)
								info++) {
80002c54:	00c40413          	addi	s0,s0,12
80002c58:	fcdff06f          	j	80002c24 <z_sys_device_do_config_level+0x34>

80002c5c <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002c5c:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c60:	800077b7          	lui	a5,0x80007
{
80002c64:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c68:	800074b7          	lui	s1,0x80007
{
80002c6c:	00812423          	sw	s0,8(sp)
80002c70:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c74:	18078413          	addi	s0,a5,384 # 80007180 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007181>
{
80002c78:	01212023          	sw	s2,0(sp)
80002c7c:	18078793          	addi	a5,a5,384
80002c80:	1b048493          	addi	s1,s1,432 # 800071b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071b1>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c84:	00941c63          	bne	s0,s1,80002c9c <z_impl_device_get_binding+0x40>
80002c88:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002c8c:	00078413          	mv	s0,a5
80002c90:	02941463          	bne	s0,s1,80002cb8 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002c94:	00000413          	li	s0,0
80002c98:	0440006f          	j	80002cdc <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80002c9c:	00442703          	lw	a4,4(s0)
80002ca0:	00070863          	beqz	a4,80002cb0 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002ca4:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002ca8:	00072703          	lw	a4,0(a4)
80002cac:	02a70863          	beq	a4,a0,80002cdc <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002cb0:	00c40413          	addi	s0,s0,12
80002cb4:	fd1ff06f          	j	80002c84 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002cb8:	00442783          	lw	a5,4(s0)
80002cbc:	00079663          	bnez	a5,80002cc8 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002cc0:	00c40413          	addi	s0,s0,12
80002cc4:	fcdff06f          	j	80002c90 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002cc8:	00042783          	lw	a5,0(s0)
80002ccc:	00090513          	mv	a0,s2
80002cd0:	0007a583          	lw	a1,0(a5)
80002cd4:	b2dff0ef          	jal	ra,80002800 <strcmp>
80002cd8:	fe0514e3          	bnez	a0,80002cc0 <z_impl_device_get_binding+0x64>
}
80002cdc:	00040513          	mv	a0,s0
80002ce0:	00c12083          	lw	ra,12(sp)
80002ce4:	00812403          	lw	s0,8(sp)
80002ce8:	00412483          	lw	s1,4(sp)
80002cec:	00012903          	lw	s2,0(sp)
80002cf0:	01010113          	addi	sp,sp,16
80002cf4:	00008067          	ret

80002cf8 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002cf8:	ff010113          	addi	sp,sp,-16
80002cfc:	00812423          	sw	s0,8(sp)
80002d00:	00912223          	sw	s1,4(sp)
80002d04:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d08:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002d0c:	00200493          	li	s1,2
80002d10:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80002d14:	714020ef          	jal	ra,80005428 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002d18:	00a4c463          	blt	s1,a0,80002d20 <idle+0x28>
80002d1c:	00100513          	li	a0,1
80002d20:	00100593          	li	a1,1
80002d24:	7e0020ef          	jal	ra,80005504 <z_set_timeout_expiry>
	k_cpu_idle();
80002d28:	db4ff0ef          	jal	ra,800022dc <k_cpu_idle>
80002d2c:	fe5ff06f          	j	80002d10 <idle+0x18>

80002d30 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002d30:	80007537          	lui	a0,0x80007
80002d34:	800077b7          	lui	a5,0x80007
80002d38:	2d050613          	addi	a2,a0,720 # 800072d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d1>
80002d3c:	52878793          	addi	a5,a5,1320 # 80007528 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007529>
80002d40:	40c78633          	sub	a2,a5,a2
80002d44:	00000593          	li	a1,0
80002d48:	2d050513          	addi	a0,a0,720
80002d4c:	ad9ff06f          	j	80002824 <memset>

80002d50 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002d50:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002d54:	00200513          	li	a0,2
{
80002d58:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002d5c:	e95ff0ef          	jal	ra,80002bf0 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002d60:	80007537          	lui	a0,0x80007
80002d64:	d0450513          	addi	a0,a0,-764 # 80006d04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d05>
80002d68:	d04ff0ef          	jal	ra,8000226c <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002d6c:	00300513          	li	a0,3
80002d70:	e81ff0ef          	jal	ra,80002bf0 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002d74:	7f5010ef          	jal	ra,80004d68 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002d78:	e2dff0ef          	jal	ra,80002ba4 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002d7c:	800077b7          	lui	a5,0x80007
80002d80:	48c78793          	addi	a5,a5,1164 # 8000748c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000748d>
80002d84:	00c7c703          	lbu	a4,12(a5)
80002d88:	ffe77713          	andi	a4,a4,-2
80002d8c:	00e78623          	sb	a4,12(a5)
}
80002d90:	00c12083          	lw	ra,12(sp)
80002d94:	01010113          	addi	sp,sp,16
80002d98:	00008067          	ret

80002d9c <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002d9c:	f6010113          	addi	sp,sp,-160
80002da0:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002da4:	800087b7          	lui	a5,0x80008
80002da8:	80007437          	lui	s0,0x80007
80002dac:	09312623          	sw	s3,140(sp)
80002db0:	53078793          	addi	a5,a5,1328 # 80008530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008531>
80002db4:	4fc40993          	addi	s3,s0,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80002db8:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80002dbc:	01010793          	addi	a5,sp,16
80002dc0:	07000613          	li	a2,112
80002dc4:	00000593          	li	a1,0
80002dc8:	00078513          	mv	a0,a5
{
80002dcc:	08112e23          	sw	ra,156(sp)
80002dd0:	08912a23          	sw	s1,148(sp)
80002dd4:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002dd8:	a4dff0ef          	jal	ra,80002824 <memset>
80002ddc:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002de0:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002de4:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002de8:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002dec:	e05ff0ef          	jal	ra,80002bf0 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002df0:	00100513          	li	a0,1
80002df4:	dfdff0ef          	jal	ra,80002bf0 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002df8:	10100793          	li	a5,257
80002dfc:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002e00:	370010ef          	jal	ra,80004170 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002e04:	800077b7          	lui	a5,0x80007
80002e08:	d4878793          	addi	a5,a5,-696 # 80006d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d49>
	_kernel.ready_q.cache = _main_thread;
80002e0c:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
80002e10:	00f12223          	sw	a5,4(sp)
80002e14:	800036b7          	lui	a3,0x80003
80002e18:	00100793          	li	a5,1
80002e1c:	800085b7          	lui	a1,0x80008
	_kernel.ready_q.cache = _main_thread;
80002e20:	48c90493          	addi	s1,s2,1164 # 8000748c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000748d>
	z_setup_new_thread(_main_thread, _main_stack,
80002e24:	00f12023          	sw	a5,0(sp)
80002e28:	00000713          	li	a4,0
80002e2c:	00000793          	li	a5,0
80002e30:	00000893          	li	a7,0
80002e34:	00000813          	li	a6,0
80002e38:	d5068693          	addi	a3,a3,-688 # 80002d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002d51>
80002e3c:	20000613          	li	a2,512
80002e40:	93058593          	addi	a1,a1,-1744 # 80007930 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007931>
80002e44:	48c90513          	addi	a0,s2,1164
	_kernel.ready_q.cache = _main_thread;
80002e48:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002e4c:	399010ef          	jal	ra,800049e4 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002e50:	00d4c783          	lbu	a5,13(s1)
80002e54:	4fc40413          	addi	s0,s0,1276
80002e58:	ffb7f713          	andi	a4,a5,-5
80002e5c:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002e60:	01b7f793          	andi	a5,a5,27
80002e64:	00079a63          	bnez	a5,80002e78 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002e68:	0184a783          	lw	a5,24(s1)
80002e6c:	00079663          	bnez	a5,80002e78 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002e70:	48c90513          	addi	a0,s2,1164
80002e74:	175000ef          	jal	ra,800037e8 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002e78:	800077b7          	lui	a5,0x80007
80002e7c:	d5078793          	addi	a5,a5,-688 # 80006d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d51>
80002e80:	00f12223          	sw	a5,4(sp)
80002e84:	80007537          	lui	a0,0x80007
80002e88:	00100793          	li	a5,1
80002e8c:	800036b7          	lui	a3,0x80003
80002e90:	800085b7          	lui	a1,0x80008
80002e94:	41c50493          	addi	s1,a0,1052 # 8000741c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000741d>
80002e98:	00f12023          	sw	a5,0(sp)
80002e9c:	00f00893          	li	a7,15
80002ea0:	00000813          	li	a6,0
80002ea4:	00000793          	li	a5,0
80002ea8:	00000713          	li	a4,0
80002eac:	cf868693          	addi	a3,a3,-776 # 80002cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002cf9>
80002eb0:	20000613          	li	a2,512
80002eb4:	b3058593          	addi	a1,a1,-1232 # 80007b30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b31>
80002eb8:	41c50513          	addi	a0,a0,1052
80002ebc:	329010ef          	jal	ra,800049e4 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002ec0:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002ec4:	00942623          	sw	s1,12(s0)
80002ec8:	00800513          	li	a0,8
80002ecc:	ffb7f793          	andi	a5,a5,-5
80002ed0:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002ed4:	800077b7          	lui	a5,0x80007
80002ed8:	51478793          	addi	a5,a5,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80002edc:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002ee0:	00f42e23          	sw	a5,28(s0)
80002ee4:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002ee8:	00857513          	andi	a0,a0,8
80002eec:	b3cfd0ef          	jal	ra,80000228 <__swap>

80002ef0 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002ef0:	00d54783          	lbu	a5,13(a0)
80002ef4:	01f7f793          	andi	a5,a5,31
80002ef8:	00079863          	bnez	a5,80002f08 <z_is_thread_ready+0x18>
80002efc:	01852503          	lw	a0,24(a0)
80002f00:	00153513          	seqz	a0,a0
80002f04:	00008067          	ret
80002f08:	00000513          	li	a0,0
}
80002f0c:	00008067          	ret

80002f10 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002f10:	ff010113          	addi	sp,sp,-16
80002f14:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002f18:	fe0ff0ef          	jal	ra,800026f8 <z_clock_elapsed>
80002f1c:	800077b7          	lui	a5,0x80007
80002f20:	3007a783          	lw	a5,768(a5) # 80007300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007301>

	z_set_timeout_expiry(slice_time, false);
}
80002f24:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002f28:	80007737          	lui	a4,0x80007
80002f2c:	00a78533          	add	a0,a5,a0
80002f30:	50a72623          	sw	a0,1292(a4) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
	z_set_timeout_expiry(slice_time, false);
80002f34:	00000593          	li	a1,0
80002f38:	00078513          	mv	a0,a5
}
80002f3c:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002f40:	5c40206f          	j	80005504 <z_set_timeout_expiry>

80002f44 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002f44:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002f48:	ff010113          	addi	sp,sp,-16
80002f4c:	00812423          	sw	s0,8(sp)
80002f50:	00112623          	sw	ra,12(sp)
80002f54:	00912223          	sw	s1,4(sp)
80002f58:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002f5c:	02079863          	bnez	a5,80002f8c <pended_on.isra.15+0x48>
80002f60:	800074b7          	lui	s1,0x80007
80002f64:	800075b7          	lui	a1,0x80007
80002f68:	80007537          	lui	a0,0x80007
80002f6c:	df458593          	addi	a1,a1,-524 # 80006df4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006df5>
80002f70:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80002f74:	18300693          	li	a3,387
80002f78:	de048613          	addi	a2,s1,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80002f7c:	af0ff0ef          	jal	ra,8000226c <printk>
80002f80:	18300593          	li	a1,387
80002f84:	de048513          	addi	a0,s1,-544
80002f88:	b20ff0ef          	jal	ra,800022a8 <assert_post_action>

	return thread->base.pended_on;
}
80002f8c:	00042503          	lw	a0,0(s0)
80002f90:	00c12083          	lw	ra,12(sp)
80002f94:	00812403          	lw	s0,8(sp)
80002f98:	00412483          	lw	s1,4(sp)
80002f9c:	01010113          	addi	sp,sp,16
80002fa0:	00008067          	ret

80002fa4 <k_sched_time_slice_set>:
{
80002fa4:	fe010113          	addi	sp,sp,-32
80002fa8:	00812c23          	sw	s0,24(sp)
80002fac:	01212823          	sw	s2,16(sp)
80002fb0:	01412423          	sw	s4,8(sp)
80002fb4:	00112e23          	sw	ra,28(sp)
80002fb8:	00912a23          	sw	s1,20(sp)
80002fbc:	01312623          	sw	s3,12(sp)
80002fc0:	00050913          	mv	s2,a0
80002fc4:	00058a13          	mv	s4,a1
80002fc8:	00800413          	li	s0,8
80002fcc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fd0:	800074b7          	lui	s1,0x80007
80002fd4:	2f848513          	addi	a0,s1,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80002fd8:	00847413          	andi	s0,s0,8
80002fdc:	2d5010ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80002fe0:	02051e63          	bnez	a0,8000301c <k_sched_time_slice_set+0x78>
80002fe4:	800079b7          	lui	s3,0x80007
80002fe8:	800075b7          	lui	a1,0x80007
80002fec:	80007537          	lui	a0,0x80007
80002ff0:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80002ff4:	04e00693          	li	a3,78
80002ff8:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80002ffc:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003000:	a6cff0ef          	jal	ra,8000226c <printk>
80003004:	80007537          	lui	a0,0x80007
80003008:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
8000300c:	a60ff0ef          	jal	ra,8000226c <printk>
80003010:	04e00593          	li	a1,78
80003014:	b6498513          	addi	a0,s3,-1180
80003018:	a90ff0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000301c:	2f848513          	addi	a0,s1,760
80003020:	2e9010ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80003024:	800077b7          	lui	a5,0x80007
80003028:	5007a623          	sw	zero,1292(a5) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
8000302c:	00990913          	addi	s2,s2,9
80003030:	00a00793          	li	a5,10
80003034:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
80003038:	800077b7          	lui	a5,0x80007
8000303c:	3127a023          	sw	s2,768(a5) # 80007300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007301>
		slice_max_prio = prio;
80003040:	800077b7          	lui	a5,0x80007
80003044:	2f47ae23          	sw	s4,764(a5) # 800072fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072fd>
		reset_time_slice();
80003048:	ec9ff0ef          	jal	ra,80002f10 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000304c:	2f848513          	addi	a0,s1,760
80003050:	289010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80003054:	02051e63          	bnez	a0,80003090 <k_sched_time_slice_set+0xec>
80003058:	800074b7          	lui	s1,0x80007
8000305c:	800075b7          	lui	a1,0x80007
80003060:	80007537          	lui	a0,0x80007
80003064:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80003068:	06100693          	li	a3,97
8000306c:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003070:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003074:	9f8ff0ef          	jal	ra,8000226c <printk>
80003078:	80007537          	lui	a0,0x80007
8000307c:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003080:	9ecff0ef          	jal	ra,8000226c <printk>
80003084:	06100593          	li	a1,97
80003088:	b6448513          	addi	a0,s1,-1180
8000308c:	a1cff0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003090:	30042473          	csrrs	s0,mstatus,s0
}
80003094:	01c12083          	lw	ra,28(sp)
80003098:	01812403          	lw	s0,24(sp)
8000309c:	01412483          	lw	s1,20(sp)
800030a0:	01012903          	lw	s2,16(sp)
800030a4:	00c12983          	lw	s3,12(sp)
800030a8:	00812a03          	lw	s4,8(sp)
800030ac:	02010113          	addi	sp,sp,32
800030b0:	00008067          	ret

800030b4 <z_find_first_thread_to_unpend>:

ALWAYS_INLINE struct k_thread *z_find_first_thread_to_unpend(_wait_q_t *wait_q,
						     struct k_thread *from)
{
800030b4:	fe010113          	addi	sp,sp,-32
800030b8:	00812c23          	sw	s0,24(sp)
800030bc:	01312623          	sw	s3,12(sp)
800030c0:	00112e23          	sw	ra,28(sp)
800030c4:	00912a23          	sw	s1,20(sp)
800030c8:	01212823          	sw	s2,16(sp)
800030cc:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800030d0:	00800413          	li	s0,8
800030d4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800030d8:	800074b7          	lui	s1,0x80007
800030dc:	2f848513          	addi	a0,s1,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
800030e0:	00847413          	andi	s0,s0,8
800030e4:	1cd010ef          	jal	ra,80004ab0 <z_spin_lock_valid>
800030e8:	02051e63          	bnez	a0,80003124 <z_find_first_thread_to_unpend+0x70>
800030ec:	80007937          	lui	s2,0x80007
800030f0:	800075b7          	lui	a1,0x80007
800030f4:	80007537          	lui	a0,0x80007
800030f8:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800030fc:	04e00693          	li	a3,78
80003100:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003104:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003108:	964ff0ef          	jal	ra,8000226c <printk>
8000310c:	80007537          	lui	a0,0x80007
80003110:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80003114:	958ff0ef          	jal	ra,8000226c <printk>
80003118:	04e00593          	li	a1,78
8000311c:	b6490513          	addi	a0,s2,-1180
80003120:	988ff0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003124:	2f848513          	addi	a0,s1,760
80003128:	1e1010ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	ARG_UNUSED(from);

	struct k_thread *ret = NULL;

	LOCKED(&sched_spinlock) {
		ret = _priq_wait_best(&wait_q->waitq);
8000312c:	00098513          	mv	a0,s3
80003130:	45c000ef          	jal	ra,8000358c <z_priq_dumb_best>
80003134:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003138:	2f848513          	addi	a0,s1,760
8000313c:	19d010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80003140:	02051e63          	bnez	a0,8000317c <z_find_first_thread_to_unpend+0xc8>
80003144:	800074b7          	lui	s1,0x80007
80003148:	800075b7          	lui	a1,0x80007
8000314c:	80007537          	lui	a0,0x80007
80003150:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80003154:	06100693          	li	a3,97
80003158:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
8000315c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003160:	90cff0ef          	jal	ra,8000226c <printk>
80003164:	80007537          	lui	a0,0x80007
80003168:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
8000316c:	900ff0ef          	jal	ra,8000226c <printk>
80003170:	06100593          	li	a1,97
80003174:	b6448513          	addi	a0,s1,-1180
80003178:	930ff0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000317c:	30042473          	csrrs	s0,mstatus,s0
	}

	return ret;
}
80003180:	01c12083          	lw	ra,28(sp)
80003184:	01812403          	lw	s0,24(sp)
80003188:	00090513          	mv	a0,s2
8000318c:	01412483          	lw	s1,20(sp)
80003190:	01012903          	lw	s2,16(sp)
80003194:	00c12983          	lw	s3,12(sp)
80003198:	02010113          	addi	sp,sp,32
8000319c:	00008067          	ret

800031a0 <z_unpend_thread_no_timeout>:

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
800031a0:	fe010113          	addi	sp,sp,-32
800031a4:	00812c23          	sw	s0,24(sp)
800031a8:	01212823          	sw	s2,16(sp)
800031ac:	00112e23          	sw	ra,28(sp)
800031b0:	00912a23          	sw	s1,20(sp)
800031b4:	01312623          	sw	s3,12(sp)
800031b8:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800031bc:	00800413          	li	s0,8
800031c0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800031c4:	800074b7          	lui	s1,0x80007
800031c8:	2f848513          	addi	a0,s1,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
800031cc:	00847413          	andi	s0,s0,8
800031d0:	0e1010ef          	jal	ra,80004ab0 <z_spin_lock_valid>
800031d4:	02051e63          	bnez	a0,80003210 <z_unpend_thread_no_timeout+0x70>
800031d8:	800079b7          	lui	s3,0x80007
800031dc:	800075b7          	lui	a1,0x80007
800031e0:	80007537          	lui	a0,0x80007
800031e4:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800031e8:	04e00693          	li	a3,78
800031ec:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800031f0:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800031f4:	878ff0ef          	jal	ra,8000226c <printk>
800031f8:	80007537          	lui	a0,0x80007
800031fc:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80003200:	86cff0ef          	jal	ra,8000226c <printk>
80003204:	04e00593          	li	a1,78
80003208:	b6498513          	addi	a0,s3,-1180
8000320c:	89cff0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003210:	2f848513          	addi	a0,s1,760
80003214:	0f5010ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003218:	00890513          	addi	a0,s2,8
8000321c:	d29ff0ef          	jal	ra,80002f44 <pended_on.isra.15>
80003220:	00090593          	mv	a1,s2
80003224:	2f0000ef          	jal	ra,80003514 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003228:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000322c:	2f848513          	addi	a0,s1,760
80003230:	ffd7f793          	andi	a5,a5,-3
80003234:	00f906a3          	sb	a5,13(s2)
80003238:	0a1010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000323c:	02051e63          	bnez	a0,80003278 <z_unpend_thread_no_timeout+0xd8>
80003240:	800074b7          	lui	s1,0x80007
80003244:	800075b7          	lui	a1,0x80007
80003248:	80007537          	lui	a0,0x80007
8000324c:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80003250:	06100693          	li	a3,97
80003254:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003258:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000325c:	810ff0ef          	jal	ra,8000226c <printk>
80003260:	80007537          	lui	a0,0x80007
80003264:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003268:	804ff0ef          	jal	ra,8000226c <printk>
8000326c:	06100593          	li	a1,97
80003270:	b6448513          	addi	a0,s1,-1180
80003274:	834ff0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003278:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
8000327c:	01c12083          	lw	ra,28(sp)
80003280:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003284:	00092423          	sw	zero,8(s2)
}
80003288:	01412483          	lw	s1,20(sp)
8000328c:	01012903          	lw	s2,16(sp)
80003290:	00c12983          	lw	s3,12(sp)
80003294:	02010113          	addi	sp,sp,32
80003298:	00008067          	ret

8000329c <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
8000329c:	800077b7          	lui	a5,0x80007
800032a0:	4fc7a783          	lw	a5,1276(a5) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
{
800032a4:	ff010113          	addi	sp,sp,-16
800032a8:	00812423          	sw	s0,8(sp)
800032ac:	00112623          	sw	ra,12(sp)
800032b0:	00912223          	sw	s1,4(sp)
800032b4:	00058413          	mv	s0,a1
	if (resched()) {
800032b8:	04079e63          	bnez	a5,80003314 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800032bc:	01d010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800032c0:	02051e63          	bnez	a0,800032fc <z_reschedule+0x60>
800032c4:	800074b7          	lui	s1,0x80007
800032c8:	800075b7          	lui	a1,0x80007
800032cc:	80007537          	lui	a0,0x80007
800032d0:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800032d4:	07800693          	li	a3,120
800032d8:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800032dc:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800032e0:	f8dfe0ef          	jal	ra,8000226c <printk>
800032e4:	80007537          	lui	a0,0x80007
800032e8:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800032ec:	f81fe0ef          	jal	ra,8000226c <printk>
800032f0:	07800593          	li	a1,120
800032f4:	b6448513          	addi	a0,s1,-1180
800032f8:	fb1fe0ef          	jal	ra,800022a8 <assert_post_action>
800032fc:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80003300:	00812403          	lw	s0,8(sp)
80003304:	00c12083          	lw	ra,12(sp)
80003308:	00412483          	lw	s1,4(sp)
8000330c:	01010113          	addi	sp,sp,16
80003310:	f19fc06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003314:	7c4010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80003318:	02051e63          	bnez	a0,80003354 <z_reschedule+0xb8>
8000331c:	800074b7          	lui	s1,0x80007
80003320:	800075b7          	lui	a1,0x80007
80003324:	80007537          	lui	a0,0x80007
80003328:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
8000332c:	06100693          	li	a3,97
80003330:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003334:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003338:	f35fe0ef          	jal	ra,8000226c <printk>
8000333c:	80007537          	lui	a0,0x80007
80003340:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003344:	f29fe0ef          	jal	ra,8000226c <printk>
80003348:	06100593          	li	a1,97
8000334c:	b6448513          	addi	a0,s1,-1180
80003350:	f59fe0ef          	jal	ra,800022a8 <assert_post_action>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80003354:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003358:	30042473          	csrrs	s0,mstatus,s0
8000335c:	00c12083          	lw	ra,12(sp)
80003360:	00812403          	lw	s0,8(sp)
80003364:	00412483          	lw	s1,4(sp)
80003368:	01010113          	addi	sp,sp,16
8000336c:	00008067          	ret

80003370 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003370:	80007737          	lui	a4,0x80007
80003374:	4fc72703          	lw	a4,1276(a4) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80003378:	00071463          	bnez	a4,80003380 <z_reschedule_irqlock+0x10>
8000337c:	eadfc06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003380:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003384:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80003388:	00008067          	ret

8000338c <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000338c:	00800513          	li	a0,8
80003390:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003394:	00857513          	andi	a0,a0,8
80003398:	fd9ff06f          	j	80003370 <z_reschedule_irqlock>

8000339c <k_sched_lock>:

void k_sched_lock(void)
{
8000339c:	fe010113          	addi	sp,sp,-32
800033a0:	00812c23          	sw	s0,24(sp)
800033a4:	00112e23          	sw	ra,28(sp)
800033a8:	00912a23          	sw	s1,20(sp)
800033ac:	01212823          	sw	s2,16(sp)
800033b0:	01312623          	sw	s3,12(sp)
800033b4:	00800413          	li	s0,8
800033b8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033bc:	800074b7          	lui	s1,0x80007
800033c0:	2f848513          	addi	a0,s1,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
800033c4:	00847413          	andi	s0,s0,8
800033c8:	6e8010ef          	jal	ra,80004ab0 <z_spin_lock_valid>
800033cc:	02051e63          	bnez	a0,80003408 <k_sched_lock+0x6c>
800033d0:	80007937          	lui	s2,0x80007
800033d4:	800075b7          	lui	a1,0x80007
800033d8:	80007537          	lui	a0,0x80007
800033dc:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800033e0:	04e00693          	li	a3,78
800033e4:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800033e8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800033ec:	e81fe0ef          	jal	ra,8000226c <printk>
800033f0:	80007537          	lui	a0,0x80007
800033f4:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
800033f8:	e75fe0ef          	jal	ra,8000226c <printk>
800033fc:	04e00593          	li	a1,78
80003400:	b6490513          	addi	a0,s2,-1180
80003404:	ea5fe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003408:	2f848513          	addi	a0,s1,760
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
8000340c:	80007937          	lui	s2,0x80007
80003410:	6f8010ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
80003414:	4fc92783          	lw	a5,1276(s2) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80003418:	4fc90913          	addi	s2,s2,1276
8000341c:	02078e63          	beqz	a5,80003458 <k_sched_lock+0xbc>
80003420:	800079b7          	lui	s3,0x80007
80003424:	800075b7          	lui	a1,0x80007
80003428:	80007537          	lui	a0,0x80007
8000342c:	d7458593          	addi	a1,a1,-652 # 80006d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d75>
80003430:	10000693          	li	a3,256
80003434:	d5898613          	addi	a2,s3,-680 # 80006d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d59>
80003438:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000343c:	e31fe0ef          	jal	ra,8000226c <printk>
80003440:	80007537          	lui	a0,0x80007
80003444:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80003448:	e25fe0ef          	jal	ra,8000226c <printk>
8000344c:	10000593          	li	a1,256
80003450:	d5898513          	addi	a0,s3,-680
80003454:	e55fe0ef          	jal	ra,800022a8 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80003458:	00892783          	lw	a5,8(s2)
8000345c:	00f7c703          	lbu	a4,15(a5)
80003460:	00100793          	li	a5,1
80003464:	02f71e63          	bne	a4,a5,800034a0 <k_sched_lock+0x104>
80003468:	800079b7          	lui	s3,0x80007
8000346c:	800075b7          	lui	a1,0x80007
80003470:	80007537          	lui	a0,0x80007
80003474:	d9058593          	addi	a1,a1,-624 # 80006d90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d91>
80003478:	10100693          	li	a3,257
8000347c:	d5898613          	addi	a2,s3,-680 # 80006d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d59>
80003480:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003484:	de9fe0ef          	jal	ra,8000226c <printk>
80003488:	80007537          	lui	a0,0x80007
8000348c:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80003490:	dddfe0ef          	jal	ra,8000226c <printk>
80003494:	10100593          	li	a1,257
80003498:	d5898513          	addi	a0,s3,-680
8000349c:	e0dfe0ef          	jal	ra,800022a8 <assert_post_action>

	--_current->base.sched_locked;
800034a0:	00892703          	lw	a4,8(s2)
800034a4:	00f74783          	lbu	a5,15(a4)
800034a8:	fff78793          	addi	a5,a5,-1
800034ac:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800034b0:	2f848513          	addi	a0,s1,760
800034b4:	624010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800034b8:	02051e63          	bnez	a0,800034f4 <k_sched_lock+0x158>
800034bc:	800074b7          	lui	s1,0x80007
800034c0:	800075b7          	lui	a1,0x80007
800034c4:	80007537          	lui	a0,0x80007
800034c8:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800034cc:	06100693          	li	a3,97
800034d0:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800034d4:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800034d8:	d95fe0ef          	jal	ra,8000226c <printk>
800034dc:	80007537          	lui	a0,0x80007
800034e0:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800034e4:	d89fe0ef          	jal	ra,8000226c <printk>
800034e8:	06100593          	li	a1,97
800034ec:	b6448513          	addi	a0,s1,-1180
800034f0:	db9fe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800034f4:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800034f8:	01c12083          	lw	ra,28(sp)
800034fc:	01812403          	lw	s0,24(sp)
80003500:	01412483          	lw	s1,20(sp)
80003504:	01012903          	lw	s2,16(sp)
80003508:	00c12983          	lw	s3,12(sp)
8000350c:	02010113          	addi	sp,sp,32
80003510:	00008067          	ret

80003514 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80003514:	800077b7          	lui	a5,0x80007
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80003518:	17c7a783          	lw	a5,380(a5) # 8000717c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000717d>
{
8000351c:	ff010113          	addi	sp,sp,-16
80003520:	00812423          	sw	s0,8(sp)
80003524:	00112623          	sw	ra,12(sp)
80003528:	00912223          	sw	s1,4(sp)
8000352c:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80003530:	02f59863          	bne	a1,a5,80003560 <z_priq_dumb_remove+0x4c>
80003534:	800074b7          	lui	s1,0x80007
80003538:	800075b7          	lui	a1,0x80007
8000353c:	80007537          	lui	a0,0x80007
80003540:	e7858593          	addi	a1,a1,-392 # 80006e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e79>
80003544:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003548:	28c00693          	li	a3,652
8000354c:	de048613          	addi	a2,s1,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80003550:	d1dfe0ef          	jal	ra,8000226c <printk>
80003554:	28c00593          	li	a1,652
80003558:	de048513          	addi	a0,s1,-544
8000355c:	d4dfe0ef          	jal	ra,800022a8 <assert_post_action>
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80003560:	00442703          	lw	a4,4(s0)
80003564:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80003568:	00c12083          	lw	ra,12(sp)
8000356c:	00412483          	lw	s1,4(sp)
80003570:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003574:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80003578:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
8000357c:	00042223          	sw	zero,4(s0)
80003580:	00812403          	lw	s0,8(sp)
80003584:	01010113          	addi	sp,sp,16
80003588:	00008067          	ret

8000358c <z_priq_dumb_best>:
	return list->head == list;
8000358c:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003590:	00f51463          	bne	a0,a5,80003598 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003594:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80003598:	00078513          	mv	a0,a5
8000359c:	00008067          	ret

800035a0 <update_cache>:
{
800035a0:	ff010113          	addi	sp,sp,-16
800035a4:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800035a8:	80007437          	lui	s0,0x80007
{
800035ac:	01212023          	sw	s2,0(sp)
800035b0:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800035b4:	4fc40513          	addi	a0,s0,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
800035b8:	02450513          	addi	a0,a0,36
{
800035bc:	00912223          	sw	s1,4(sp)
800035c0:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800035c4:	fc9ff0ef          	jal	ra,8000358c <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
800035c8:	4fc40413          	addi	s0,s0,1276
800035cc:	00050493          	mv	s1,a0
800035d0:	00051463          	bnez	a0,800035d8 <update_cache+0x38>
800035d4:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
800035d8:	06091e63          	bnez	s2,80003654 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
800035dc:	00842783          	lw	a5,8(s0)
800035e0:	02079e63          	bnez	a5,8000361c <update_cache+0x7c>
800035e4:	80007937          	lui	s2,0x80007
800035e8:	800075b7          	lui	a1,0x80007
800035ec:	80007537          	lui	a0,0x80007
800035f0:	e0c58593          	addi	a1,a1,-500 # 80006e0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e0d>
800035f4:	07f00693          	li	a3,127
800035f8:	de090613          	addi	a2,s2,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
800035fc:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003600:	c6dfe0ef          	jal	ra,8000226c <printk>
80003604:	80007537          	lui	a0,0x80007
80003608:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
8000360c:	c61fe0ef          	jal	ra,8000226c <printk>
80003610:	07f00593          	li	a1,127
80003614:	de090513          	addi	a0,s2,-544
80003618:	c91fe0ef          	jal	ra,800022a8 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
8000361c:	00842783          	lw	a5,8(s0)
80003620:	00d7c703          	lbu	a4,13(a5)
80003624:	01f77713          	andi	a4,a4,31
80003628:	02071663          	bnez	a4,80003654 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
8000362c:	00e7d683          	lhu	a3,14(a5)
80003630:	07f00713          	li	a4,127
80003634:	02d77063          	bgeu	a4,a3,80003654 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80003638:	02f42023          	sw	a5,32(s0)
}
8000363c:	00c12083          	lw	ra,12(sp)
80003640:	00812403          	lw	s0,8(sp)
80003644:	00412483          	lw	s1,4(sp)
80003648:	00012903          	lw	s2,0(sp)
8000364c:	01010113          	addi	sp,sp,16
80003650:	00008067          	ret
		if (th != _current) {
80003654:	00842783          	lw	a5,8(s0)
80003658:	00978463          	beq	a5,s1,80003660 <update_cache+0xc0>
			reset_time_slice();
8000365c:	8b5ff0ef          	jal	ra,80002f10 <reset_time_slice>
		_kernel.ready_q.cache = th;
80003660:	02942023          	sw	s1,32(s0)
}
80003664:	fd9ff06f          	j	8000363c <update_cache+0x9c>

80003668 <k_sched_unlock>:
{
80003668:	fe010113          	addi	sp,sp,-32
8000366c:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003670:	80007937          	lui	s2,0x80007
80003674:	4fc90793          	addi	a5,s2,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80003678:	0087a783          	lw	a5,8(a5)
{
8000367c:	00112e23          	sw	ra,28(sp)
80003680:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003684:	00f7c783          	lbu	a5,15(a5)
{
80003688:	00912a23          	sw	s1,20(sp)
8000368c:	01312623          	sw	s3,12(sp)
80003690:	4fc90913          	addi	s2,s2,1276
	__ASSERT(_current->base.sched_locked != 0, "");
80003694:	02079e63          	bnez	a5,800036d0 <k_sched_unlock+0x68>
80003698:	80007437          	lui	s0,0x80007
8000369c:	800075b7          	lui	a1,0x80007
800036a0:	80007537          	lui	a0,0x80007
800036a4:	db858593          	addi	a1,a1,-584 # 80006db8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006db9>
800036a8:	22100693          	li	a3,545
800036ac:	de040613          	addi	a2,s0,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
800036b0:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800036b4:	bb9fe0ef          	jal	ra,8000226c <printk>
800036b8:	80007537          	lui	a0,0x80007
800036bc:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
800036c0:	badfe0ef          	jal	ra,8000226c <printk>
800036c4:	22100593          	li	a1,545
800036c8:	de040513          	addi	a0,s0,-544
800036cc:	bddfe0ef          	jal	ra,800022a8 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800036d0:	00092783          	lw	a5,0(s2)
800036d4:	02078e63          	beqz	a5,80003710 <k_sched_unlock+0xa8>
800036d8:	80007437          	lui	s0,0x80007
800036dc:	800075b7          	lui	a1,0x80007
800036e0:	80007537          	lui	a0,0x80007
800036e4:	d7458593          	addi	a1,a1,-652 # 80006d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d75>
800036e8:	22200693          	li	a3,546
800036ec:	de040613          	addi	a2,s0,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
800036f0:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800036f4:	b79fe0ef          	jal	ra,8000226c <printk>
800036f8:	80007537          	lui	a0,0x80007
800036fc:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80003700:	b6dfe0ef          	jal	ra,8000226c <printk>
80003704:	22200593          	li	a1,546
80003708:	de040513          	addi	a0,s0,-544
8000370c:	b9dfe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003710:	00800413          	li	s0,8
80003714:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003718:	800074b7          	lui	s1,0x80007
8000371c:	2f848513          	addi	a0,s1,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003720:	00847413          	andi	s0,s0,8
80003724:	38c010ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80003728:	02051e63          	bnez	a0,80003764 <k_sched_unlock+0xfc>
8000372c:	800079b7          	lui	s3,0x80007
80003730:	800075b7          	lui	a1,0x80007
80003734:	80007537          	lui	a0,0x80007
80003738:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
8000373c:	04e00693          	li	a3,78
80003740:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003744:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003748:	b25fe0ef          	jal	ra,8000226c <printk>
8000374c:	80007537          	lui	a0,0x80007
80003750:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80003754:	b19fe0ef          	jal	ra,8000226c <printk>
80003758:	04e00593          	li	a1,78
8000375c:	b6498513          	addi	a0,s3,-1180
80003760:	b49fe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003764:	2f848513          	addi	a0,s1,760
80003768:	3a0010ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
8000376c:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003770:	00100513          	li	a0,1
		++_current->base.sched_locked;
80003774:	00f74783          	lbu	a5,15(a4)
80003778:	00178793          	addi	a5,a5,1
8000377c:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80003780:	e21ff0ef          	jal	ra,800035a0 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003784:	2f848513          	addi	a0,s1,760
80003788:	350010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000378c:	02051e63          	bnez	a0,800037c8 <k_sched_unlock+0x160>
80003790:	800074b7          	lui	s1,0x80007
80003794:	800075b7          	lui	a1,0x80007
80003798:	80007537          	lui	a0,0x80007
8000379c:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800037a0:	06100693          	li	a3,97
800037a4:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800037a8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800037ac:	ac1fe0ef          	jal	ra,8000226c <printk>
800037b0:	80007537          	lui	a0,0x80007
800037b4:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800037b8:	ab5fe0ef          	jal	ra,8000226c <printk>
800037bc:	06100593          	li	a1,97
800037c0:	b6448513          	addi	a0,s1,-1180
800037c4:	ae5fe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037c8:	30042473          	csrrs	s0,mstatus,s0
}
800037cc:	01812403          	lw	s0,24(sp)
800037d0:	01c12083          	lw	ra,28(sp)
800037d4:	01412483          	lw	s1,20(sp)
800037d8:	01012903          	lw	s2,16(sp)
800037dc:	00c12983          	lw	s3,12(sp)
800037e0:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
800037e4:	ba9ff06f          	j	8000338c <z_reschedule_unlocked>

800037e8 <z_add_thread_to_ready_q>:
{
800037e8:	fe010113          	addi	sp,sp,-32
800037ec:	00812c23          	sw	s0,24(sp)
800037f0:	00912a23          	sw	s1,20(sp)
800037f4:	00112e23          	sw	ra,28(sp)
800037f8:	01212823          	sw	s2,16(sp)
800037fc:	01312623          	sw	s3,12(sp)
80003800:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003804:	00800493          	li	s1,8
80003808:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000380c:	80007937          	lui	s2,0x80007
80003810:	2f890513          	addi	a0,s2,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003814:	0084f493          	andi	s1,s1,8
80003818:	298010ef          	jal	ra,80004ab0 <z_spin_lock_valid>
8000381c:	02051e63          	bnez	a0,80003858 <z_add_thread_to_ready_q+0x70>
80003820:	800079b7          	lui	s3,0x80007
80003824:	800075b7          	lui	a1,0x80007
80003828:	80007537          	lui	a0,0x80007
8000382c:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80003830:	04e00693          	li	a3,78
80003834:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003838:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000383c:	a31fe0ef          	jal	ra,8000226c <printk>
80003840:	80007537          	lui	a0,0x80007
80003844:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80003848:	a25fe0ef          	jal	ra,8000226c <printk>
8000384c:	04e00593          	li	a1,78
80003850:	b6498513          	addi	a0,s3,-1180
80003854:	a55fe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003858:	2f890513          	addi	a0,s2,760
8000385c:	2ac010ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003860:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003864:	17c7a783          	lw	a5,380(a5) # 8000717c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000717d>
80003868:	02f41863          	bne	s0,a5,80003898 <z_add_thread_to_ready_q+0xb0>
8000386c:	800079b7          	lui	s3,0x80007
80003870:	800075b7          	lui	a1,0x80007
80003874:	80007537          	lui	a0,0x80007
80003878:	e7858593          	addi	a1,a1,-392 # 80006e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e79>
8000387c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003880:	27600693          	li	a3,630
80003884:	de098613          	addi	a2,s3,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80003888:	9e5fe0ef          	jal	ra,8000226c <printk>
8000388c:	27600593          	li	a1,630
80003890:	de098513          	addi	a0,s3,-544
80003894:	a15fe0ef          	jal	ra,800022a8 <assert_post_action>
	return list->head == list;
80003898:	80007737          	lui	a4,0x80007
8000389c:	4fc70693          	addi	a3,a4,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
800038a0:	0246a783          	lw	a5,36(a3)
800038a4:	0286a603          	lw	a2,40(a3)
800038a8:	800076b7          	lui	a3,0x80007
800038ac:	52068693          	addi	a3,a3,1312 # 80007520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007521>
800038b0:	4fc70713          	addi	a4,a4,1276
	return sys_dlist_is_empty(list) ? NULL : list->head;
800038b4:	0ad78663          	beq	a5,a3,80003960 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800038b8:	0a078463          	beqz	a5,80003960 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
800038bc:	00e40583          	lb	a1,14(s0)
800038c0:	00e78503          	lb	a0,14(a5)
800038c4:	08a5d863          	bge	a1,a0,80003954 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
800038c8:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800038cc:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800038d0:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800038d4:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800038d8:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
800038dc:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
800038e0:	00000513          	li	a0,0
800038e4:	0407e793          	ori	a5,a5,64
800038e8:	00f406a3          	sb	a5,13(s0)
800038ec:	cb5ff0ef          	jal	ra,800035a0 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800038f0:	2f890513          	addi	a0,s2,760
800038f4:	1e4010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800038f8:	02051e63          	bnez	a0,80003934 <z_add_thread_to_ready_q+0x14c>
800038fc:	80007437          	lui	s0,0x80007
80003900:	800075b7          	lui	a1,0x80007
80003904:	80007537          	lui	a0,0x80007
80003908:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
8000390c:	06100693          	li	a3,97
80003910:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003914:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003918:	955fe0ef          	jal	ra,8000226c <printk>
8000391c:	80007537          	lui	a0,0x80007
80003920:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003924:	949fe0ef          	jal	ra,8000226c <printk>
80003928:	06100593          	li	a1,97
8000392c:	b6440513          	addi	a0,s0,-1180
80003930:	979fe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003934:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003938:	01c12083          	lw	ra,28(sp)
8000393c:	01812403          	lw	s0,24(sp)
80003940:	01412483          	lw	s1,20(sp)
80003944:	01012903          	lw	s2,16(sp)
80003948:	00c12983          	lw	s3,12(sp)
8000394c:	02010113          	addi	sp,sp,32
80003950:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003954:	00f60663          	beq	a2,a5,80003960 <z_add_thread_to_ready_q+0x178>
80003958:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000395c:	f60792e3          	bnez	a5,800038c0 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003960:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003964:	02872783          	lw	a5,40(a4)
	node->next = list;
80003968:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
8000396c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003970:	02872423          	sw	s0,40(a4)
80003974:	f69ff06f          	j	800038dc <z_add_thread_to_ready_q+0xf4>

80003978 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003978:	ff052783          	lw	a5,-16(a0)
{
8000397c:	fe010113          	addi	sp,sp,-32
80003980:	00812c23          	sw	s0,24(sp)
80003984:	01312623          	sw	s3,12(sp)
80003988:	00112e23          	sw	ra,28(sp)
8000398c:	00912a23          	sw	s1,20(sp)
80003990:	01212823          	sw	s2,16(sp)
80003994:	01412423          	sw	s4,8(sp)
80003998:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
8000399c:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
800039a0:	0c078463          	beqz	a5,80003a68 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800039a4:	00800493          	li	s1,8
800039a8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800039ac:	80007937          	lui	s2,0x80007
800039b0:	2f890513          	addi	a0,s2,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
800039b4:	0084f493          	andi	s1,s1,8
800039b8:	0f8010ef          	jal	ra,80004ab0 <z_spin_lock_valid>
800039bc:	02051e63          	bnez	a0,800039f8 <z_thread_timeout+0x80>
800039c0:	80007a37          	lui	s4,0x80007
800039c4:	800075b7          	lui	a1,0x80007
800039c8:	80007537          	lui	a0,0x80007
800039cc:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800039d0:	04e00693          	li	a3,78
800039d4:	b64a0613          	addi	a2,s4,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800039d8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800039dc:	891fe0ef          	jal	ra,8000226c <printk>
800039e0:	80007537          	lui	a0,0x80007
800039e4:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
800039e8:	885fe0ef          	jal	ra,8000226c <printk>
800039ec:	04e00593          	li	a1,78
800039f0:	b64a0513          	addi	a0,s4,-1180
800039f4:	8b5fe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800039f8:	2f890513          	addi	a0,s2,760
800039fc:	10c010ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003a00:	ff040513          	addi	a0,s0,-16
80003a04:	d40ff0ef          	jal	ra,80002f44 <pended_on.isra.15>
80003a08:	00098593          	mv	a1,s3
80003a0c:	b09ff0ef          	jal	ra,80003514 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003a10:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a14:	2f890513          	addi	a0,s2,760
80003a18:	ffd7f793          	andi	a5,a5,-3
80003a1c:	fef40aa3          	sb	a5,-11(s0)
80003a20:	0b8010ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80003a24:	02051e63          	bnez	a0,80003a60 <z_thread_timeout+0xe8>
80003a28:	80007937          	lui	s2,0x80007
80003a2c:	800075b7          	lui	a1,0x80007
80003a30:	80007537          	lui	a0,0x80007
80003a34:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80003a38:	06100693          	li	a3,97
80003a3c:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003a40:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003a44:	829fe0ef          	jal	ra,8000226c <printk>
80003a48:	80007537          	lui	a0,0x80007
80003a4c:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003a50:	81dfe0ef          	jal	ra,8000226c <printk>
80003a54:	06100593          	li	a1,97
80003a58:	b6490513          	addi	a0,s2,-1180
80003a5c:	84dfe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003a60:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003a64:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003a68:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003a6c:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003a70:	feb7f793          	andi	a5,a5,-21
80003a74:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003a78:	c78ff0ef          	jal	ra,80002ef0 <z_is_thread_ready>
80003a7c:	02050463          	beqz	a0,80003aa4 <z_thread_timeout+0x12c>
}
80003a80:	01812403          	lw	s0,24(sp)
80003a84:	01c12083          	lw	ra,28(sp)
80003a88:	01412483          	lw	s1,20(sp)
80003a8c:	01012903          	lw	s2,16(sp)
80003a90:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003a94:	00098513          	mv	a0,s3
80003a98:	00c12983          	lw	s3,12(sp)
80003a9c:	02010113          	addi	sp,sp,32
80003aa0:	d49ff06f          	j	800037e8 <z_add_thread_to_ready_q>
80003aa4:	01c12083          	lw	ra,28(sp)
80003aa8:	01812403          	lw	s0,24(sp)
80003aac:	01412483          	lw	s1,20(sp)
80003ab0:	01012903          	lw	s2,16(sp)
80003ab4:	00c12983          	lw	s3,12(sp)
80003ab8:	00812a03          	lw	s4,8(sp)
80003abc:	02010113          	addi	sp,sp,32
80003ac0:	00008067          	ret

80003ac4 <z_move_thread_to_end_of_prio_q>:
{
80003ac4:	fe010113          	addi	sp,sp,-32
80003ac8:	00812c23          	sw	s0,24(sp)
80003acc:	01212823          	sw	s2,16(sp)
80003ad0:	00112e23          	sw	ra,28(sp)
80003ad4:	00912a23          	sw	s1,20(sp)
80003ad8:	01312623          	sw	s3,12(sp)
80003adc:	01412423          	sw	s4,8(sp)
80003ae0:	01512223          	sw	s5,4(sp)
80003ae4:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ae8:	00800913          	li	s2,8
80003aec:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003af0:	800079b7          	lui	s3,0x80007
80003af4:	2f898513          	addi	a0,s3,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003af8:	00897913          	andi	s2,s2,8
80003afc:	7b5000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80003b00:	02051e63          	bnez	a0,80003b3c <z_move_thread_to_end_of_prio_q+0x78>
80003b04:	800074b7          	lui	s1,0x80007
80003b08:	800075b7          	lui	a1,0x80007
80003b0c:	80007537          	lui	a0,0x80007
80003b10:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80003b14:	04e00693          	li	a3,78
80003b18:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003b1c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003b20:	f4cfe0ef          	jal	ra,8000226c <printk>
80003b24:	80007537          	lui	a0,0x80007
80003b28:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80003b2c:	f40fe0ef          	jal	ra,8000226c <printk>
80003b30:	04e00593          	li	a1,78
80003b34:	b6448513          	addi	a0,s1,-1180
80003b38:	f70fe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b3c:	2f898513          	addi	a0,s3,760
80003b40:	7c9000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003b44:	800074b7          	lui	s1,0x80007
80003b48:	4fc48513          	addi	a0,s1,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80003b4c:	00040593          	mv	a1,s0
80003b50:	02450513          	addi	a0,a0,36
80003b54:	9c1ff0ef          	jal	ra,80003514 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003b58:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003b5c:	17c7a783          	lw	a5,380(a5) # 8000717c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000717d>
80003b60:	80007a37          	lui	s4,0x80007
80003b64:	4fc48493          	addi	s1,s1,1276
80003b68:	520a0a13          	addi	s4,s4,1312 # 80007520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007521>
80003b6c:	02f41863          	bne	s0,a5,80003b9c <z_move_thread_to_end_of_prio_q+0xd8>
80003b70:	80007ab7          	lui	s5,0x80007
80003b74:	800075b7          	lui	a1,0x80007
80003b78:	80007537          	lui	a0,0x80007
80003b7c:	e7858593          	addi	a1,a1,-392 # 80006e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e79>
80003b80:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003b84:	27600693          	li	a3,630
80003b88:	de0a8613          	addi	a2,s5,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80003b8c:	ee0fe0ef          	jal	ra,8000226c <printk>
80003b90:	27600593          	li	a1,630
80003b94:	de0a8513          	addi	a0,s5,-544
80003b98:	f10fe0ef          	jal	ra,800022a8 <assert_post_action>
	return list->head == list;
80003b9c:	0244a783          	lw	a5,36(s1)
80003ba0:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003ba4:	0b478e63          	beq	a5,s4,80003c60 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ba8:	0a078c63          	beqz	a5,80003c60 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003bac:	00e40683          	lb	a3,14(s0)
80003bb0:	00e78603          	lb	a2,14(a5)
80003bb4:	0ac6d063          	bge	a3,a2,80003c54 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003bb8:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003bbc:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003bc0:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003bc4:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003bc8:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003bcc:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003bd0:	0084a503          	lw	a0,8(s1)
80003bd4:	0407e793          	ori	a5,a5,64
80003bd8:	40850533          	sub	a0,a0,s0
80003bdc:	00153513          	seqz	a0,a0
80003be0:	00f406a3          	sb	a5,13(s0)
80003be4:	9bdff0ef          	jal	ra,800035a0 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003be8:	2f898513          	addi	a0,s3,760
80003bec:	6ed000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80003bf0:	02051e63          	bnez	a0,80003c2c <z_move_thread_to_end_of_prio_q+0x168>
80003bf4:	80007437          	lui	s0,0x80007
80003bf8:	800075b7          	lui	a1,0x80007
80003bfc:	80007537          	lui	a0,0x80007
80003c00:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80003c04:	06100693          	li	a3,97
80003c08:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003c0c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003c10:	e5cfe0ef          	jal	ra,8000226c <printk>
80003c14:	80007537          	lui	a0,0x80007
80003c18:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003c1c:	e50fe0ef          	jal	ra,8000226c <printk>
80003c20:	06100593          	li	a1,97
80003c24:	b6440513          	addi	a0,s0,-1180
80003c28:	e80fe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c2c:	30092973          	csrrs	s2,mstatus,s2
}
80003c30:	01c12083          	lw	ra,28(sp)
80003c34:	01812403          	lw	s0,24(sp)
80003c38:	01412483          	lw	s1,20(sp)
80003c3c:	01012903          	lw	s2,16(sp)
80003c40:	00c12983          	lw	s3,12(sp)
80003c44:	00812a03          	lw	s4,8(sp)
80003c48:	00412a83          	lw	s5,4(sp)
80003c4c:	02010113          	addi	sp,sp,32
80003c50:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003c54:	00e78663          	beq	a5,a4,80003c60 <z_move_thread_to_end_of_prio_q+0x19c>
80003c58:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003c5c:	f4079ae3          	bnez	a5,80003bb0 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003c60:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003c64:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003c68:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003c6c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003c70:	0284a423          	sw	s0,40(s1)
80003c74:	f59ff06f          	j	80003bcc <z_move_thread_to_end_of_prio_q+0x108>

80003c78 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003c78:	800077b7          	lui	a5,0x80007
80003c7c:	3007a783          	lw	a5,768(a5) # 80007300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007301>
80003c80:	06078663          	beqz	a5,80003cec <z_time_slice+0x74>
80003c84:	800077b7          	lui	a5,0x80007
80003c88:	4fc78793          	addi	a5,a5,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80003c8c:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003c90:	07f00693          	li	a3,127
80003c94:	00e75603          	lhu	a2,14(a4)
80003c98:	04c6ea63          	bltu	a3,a2,80003cec <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003c9c:	800076b7          	lui	a3,0x80007
80003ca0:	00e70603          	lb	a2,14(a4)
80003ca4:	2fc6a683          	lw	a3,764(a3) # 800072fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072fd>
80003ca8:	04d64263          	blt	a2,a3,80003cec <z_time_slice+0x74>
	return thread == _idle_thread;
80003cac:	800076b7          	lui	a3,0x80007
		&& !is_idle(t)
80003cb0:	17c6a683          	lw	a3,380(a3) # 8000717c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000717d>
80003cb4:	02d70c63          	beq	a4,a3,80003cec <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80003cb8:	01872683          	lw	a3,24(a4)
80003cbc:	02069863          	bnez	a3,80003cec <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003cc0:	0107a683          	lw	a3,16(a5)
80003cc4:	02d54063          	blt	a0,a3,80003ce4 <z_time_slice+0x6c>
{
80003cc8:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003ccc:	00070513          	mv	a0,a4
{
80003cd0:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003cd4:	df1ff0ef          	jal	ra,80003ac4 <z_move_thread_to_end_of_prio_q>
}
80003cd8:	00c12083          	lw	ra,12(sp)
80003cdc:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003ce0:	a30ff06f          	j	80002f10 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003ce4:	40a686b3          	sub	a3,a3,a0
80003ce8:	00d7a823          	sw	a3,16(a5)
80003cec:	00008067          	ret

80003cf0 <z_remove_thread_from_ready_q>:
{
80003cf0:	fe010113          	addi	sp,sp,-32
80003cf4:	00812c23          	sw	s0,24(sp)
80003cf8:	01312623          	sw	s3,12(sp)
80003cfc:	00112e23          	sw	ra,28(sp)
80003d00:	00912a23          	sw	s1,20(sp)
80003d04:	01212823          	sw	s2,16(sp)
80003d08:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d0c:	00800413          	li	s0,8
80003d10:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d14:	800074b7          	lui	s1,0x80007
80003d18:	2f848513          	addi	a0,s1,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d1c:	00847413          	andi	s0,s0,8
80003d20:	591000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80003d24:	02051e63          	bnez	a0,80003d60 <z_remove_thread_from_ready_q+0x70>
80003d28:	80007937          	lui	s2,0x80007
80003d2c:	800075b7          	lui	a1,0x80007
80003d30:	80007537          	lui	a0,0x80007
80003d34:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80003d38:	04e00693          	li	a3,78
80003d3c:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003d40:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003d44:	d28fe0ef          	jal	ra,8000226c <printk>
80003d48:	80007537          	lui	a0,0x80007
80003d4c:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80003d50:	d1cfe0ef          	jal	ra,8000226c <printk>
80003d54:	04e00593          	li	a1,78
80003d58:	b6490513          	addi	a0,s2,-1180
80003d5c:	d4cfe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d60:	2f848513          	addi	a0,s1,760
80003d64:	5a5000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003d68:	00d9c783          	lbu	a5,13(s3)
80003d6c:	80007937          	lui	s2,0x80007
80003d70:	4fc90913          	addi	s2,s2,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80003d74:	0407f793          	andi	a5,a5,64
80003d78:	00078e63          	beqz	a5,80003d94 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003d7c:	00098593          	mv	a1,s3
80003d80:	02490513          	addi	a0,s2,36
80003d84:	f90ff0ef          	jal	ra,80003514 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003d88:	00d9c783          	lbu	a5,13(s3)
80003d8c:	fbf7f793          	andi	a5,a5,-65
80003d90:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003d94:	00892503          	lw	a0,8(s2)
80003d98:	41350533          	sub	a0,a0,s3
80003d9c:	00153513          	seqz	a0,a0
80003da0:	801ff0ef          	jal	ra,800035a0 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003da4:	2f848513          	addi	a0,s1,760
80003da8:	531000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80003dac:	02051e63          	bnez	a0,80003de8 <z_remove_thread_from_ready_q+0xf8>
80003db0:	800074b7          	lui	s1,0x80007
80003db4:	800075b7          	lui	a1,0x80007
80003db8:	80007537          	lui	a0,0x80007
80003dbc:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80003dc0:	06100693          	li	a3,97
80003dc4:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003dc8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003dcc:	ca0fe0ef          	jal	ra,8000226c <printk>
80003dd0:	80007537          	lui	a0,0x80007
80003dd4:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003dd8:	c94fe0ef          	jal	ra,8000226c <printk>
80003ddc:	06100593          	li	a1,97
80003de0:	b6448513          	addi	a0,s1,-1180
80003de4:	cc4fe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003de8:	30042473          	csrrs	s0,mstatus,s0
}
80003dec:	01c12083          	lw	ra,28(sp)
80003df0:	01812403          	lw	s0,24(sp)
80003df4:	01412483          	lw	s1,20(sp)
80003df8:	01012903          	lw	s2,16(sp)
80003dfc:	00c12983          	lw	s3,12(sp)
80003e00:	02010113          	addi	sp,sp,32
80003e04:	00008067          	ret

80003e08 <pend>:
{
80003e08:	fe010113          	addi	sp,sp,-32
80003e0c:	00812c23          	sw	s0,24(sp)
80003e10:	00912a23          	sw	s1,20(sp)
80003e14:	00050413          	mv	s0,a0
80003e18:	01212823          	sw	s2,16(sp)
80003e1c:	00112e23          	sw	ra,28(sp)
80003e20:	01312623          	sw	s3,12(sp)
80003e24:	00058493          	mv	s1,a1
80003e28:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003e2c:	ec5ff0ef          	jal	ra,80003cf0 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003e30:	00d44783          	lbu	a5,13(s0)
80003e34:	0027e793          	ori	a5,a5,2
80003e38:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003e3c:	06048663          	beqz	s1,80003ea8 <pend+0xa0>
	return thread == _idle_thread;
80003e40:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003e44:	17c7a783          	lw	a5,380(a5) # 8000717c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000717d>
		thread->base.pended_on = wait_q;
80003e48:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003e4c:	02f41863          	bne	s0,a5,80003e7c <pend+0x74>
80003e50:	800079b7          	lui	s3,0x80007
80003e54:	800075b7          	lui	a1,0x80007
80003e58:	80007537          	lui	a0,0x80007
80003e5c:	e7858593          	addi	a1,a1,-392 # 80006e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e79>
80003e60:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003e64:	27600693          	li	a3,630
80003e68:	de098613          	addi	a2,s3,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80003e6c:	c00fe0ef          	jal	ra,8000226c <printk>
80003e70:	27600593          	li	a1,630
80003e74:	de098513          	addi	a0,s3,-544
80003e78:	c30fe0ef          	jal	ra,800022a8 <assert_post_action>
	return list->head == list;
80003e7c:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e80:	06f48c63          	beq	s1,a5,80003ef8 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003e84:	06078a63          	beqz	a5,80003ef8 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80003e88:	00e40703          	lb	a4,14(s0)
80003e8c:	00e78683          	lb	a3,14(a5)
80003e90:	04d75c63          	bge	a4,a3,80003ee8 <pend+0xe0>
	node->prev = successor->prev;
80003e94:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003e98:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003e9c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003ea0:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003ea4:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003ea8:	fff00793          	li	a5,-1
80003eac:	06f90463          	beq	s2,a5,80003f14 <pend+0x10c>
80003eb0:	00990913          	addi	s2,s2,9
80003eb4:	00a00613          	li	a2,10
80003eb8:	02c94633          	div	a2,s2,a2

extern void z_thread_timeout(struct _timeout *to);

static inline void z_add_thread_timeout(struct k_thread *th, s32_t ticks)
{
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003ebc:	01840513          	addi	a0,s0,24
}
80003ec0:	01812403          	lw	s0,24(sp)
80003ec4:	01c12083          	lw	ra,28(sp)
80003ec8:	01412483          	lw	s1,20(sp)
80003ecc:	01012903          	lw	s2,16(sp)
80003ed0:	00c12983          	lw	s3,12(sp)
80003ed4:	800045b7          	lui	a1,0x80004
80003ed8:	97858593          	addi	a1,a1,-1672 # 80003978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003979>
80003edc:	02010113          	addi	sp,sp,32
80003ee0:	00160613          	addi	a2,a2,1
80003ee4:	0f40106f          	j	80004fd8 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003ee8:	0044a683          	lw	a3,4(s1)
80003eec:	00d78663          	beq	a5,a3,80003ef8 <pend+0xf0>
80003ef0:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ef4:	f8079ce3          	bnez	a5,80003e8c <pend+0x84>
	node->prev = list->tail;
80003ef8:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003efc:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003f00:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003f04:	0044a783          	lw	a5,4(s1)
80003f08:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003f0c:	0084a223          	sw	s0,4(s1)
80003f10:	f99ff06f          	j	80003ea8 <pend+0xa0>
}
80003f14:	01c12083          	lw	ra,28(sp)
80003f18:	01812403          	lw	s0,24(sp)
80003f1c:	01412483          	lw	s1,20(sp)
80003f20:	01012903          	lw	s2,16(sp)
80003f24:	00c12983          	lw	s3,12(sp)
80003f28:	02010113          	addi	sp,sp,32
80003f2c:	00008067          	ret

80003f30 <z_pend_curr>:
{
80003f30:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003f34:	800077b7          	lui	a5,0x80007
{
80003f38:	00812423          	sw	s0,8(sp)
80003f3c:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003f40:	5047a503          	lw	a0,1284(a5) # 80007504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007505>
{
80003f44:	00912223          	sw	s1,4(sp)
80003f48:	00058493          	mv	s1,a1
80003f4c:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003f50:	00068613          	mv	a2,a3
{
80003f54:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003f58:	eb1ff0ef          	jal	ra,80003e08 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f5c:	00040513          	mv	a0,s0
80003f60:	379000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80003f64:	02051e63          	bnez	a0,80003fa0 <z_pend_curr+0x70>
80003f68:	80007437          	lui	s0,0x80007
80003f6c:	800075b7          	lui	a1,0x80007
80003f70:	80007537          	lui	a0,0x80007
80003f74:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80003f78:	07800693          	li	a3,120
80003f7c:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80003f80:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80003f84:	ae8fe0ef          	jal	ra,8000226c <printk>
80003f88:	80007537          	lui	a0,0x80007
80003f8c:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80003f90:	adcfe0ef          	jal	ra,8000226c <printk>
80003f94:	07800593          	li	a1,120
80003f98:	b6440513          	addi	a0,s0,-1180
80003f9c:	b0cfe0ef          	jal	ra,800022a8 <assert_post_action>
}
80003fa0:	00812403          	lw	s0,8(sp)
80003fa4:	00c12083          	lw	ra,12(sp)
80003fa8:	00048513          	mv	a0,s1
80003fac:	00412483          	lw	s1,4(sp)
80003fb0:	01010113          	addi	sp,sp,16
80003fb4:	a74fc06f          	j	80000228 <__swap>

80003fb8 <z_unpend_first_thread>:
{
80003fb8:	fe010113          	addi	sp,sp,-32
80003fbc:	01212823          	sw	s2,16(sp)
80003fc0:	01312623          	sw	s3,12(sp)
80003fc4:	00112e23          	sw	ra,28(sp)
80003fc8:	00812c23          	sw	s0,24(sp)
80003fcc:	00912a23          	sw	s1,20(sp)
80003fd0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003fd4:	00800913          	li	s2,8
80003fd8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003fdc:	800074b7          	lui	s1,0x80007
80003fe0:	2f848513          	addi	a0,s1,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003fe4:	00897913          	andi	s2,s2,8
80003fe8:	2c9000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80003fec:	02051e63          	bnez	a0,80004028 <z_unpend_first_thread+0x70>
80003ff0:	80007437          	lui	s0,0x80007
80003ff4:	800075b7          	lui	a1,0x80007
80003ff8:	80007537          	lui	a0,0x80007
80003ffc:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80004000:	04e00693          	li	a3,78
80004004:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004008:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000400c:	a60fe0ef          	jal	ra,8000226c <printk>
80004010:	80007537          	lui	a0,0x80007
80004014:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80004018:	a54fe0ef          	jal	ra,8000226c <printk>
8000401c:	04e00593          	li	a1,78
80004020:	b6440513          	addi	a0,s0,-1180
80004024:	a84fe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004028:	2f848513          	addi	a0,s1,760
8000402c:	2dd000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80004030:	00098513          	mv	a0,s3
80004034:	d58ff0ef          	jal	ra,8000358c <z_priq_dumb_best>
80004038:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000403c:	2f848513          	addi	a0,s1,760
80004040:	299000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80004044:	02051e63          	bnez	a0,80004080 <z_unpend_first_thread+0xc8>
80004048:	800079b7          	lui	s3,0x80007
8000404c:	800075b7          	lui	a1,0x80007
80004050:	80007537          	lui	a0,0x80007
80004054:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80004058:	06100693          	li	a3,97
8000405c:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004060:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004064:	a08fe0ef          	jal	ra,8000226c <printk>
80004068:	80007537          	lui	a0,0x80007
8000406c:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80004070:	9fcfe0ef          	jal	ra,8000226c <printk>
80004074:	06100593          	li	a1,97
80004078:	b6498513          	addi	a0,s3,-1180
8000407c:	a2cfe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004080:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004084:	0c040663          	beqz	s0,80004150 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004088:	00800913          	li	s2,8
8000408c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004090:	2f848513          	addi	a0,s1,760
	key = (mstatus & SOC_MSTATUS_IEN);
80004094:	00897913          	andi	s2,s2,8
80004098:	219000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
8000409c:	02051e63          	bnez	a0,800040d8 <z_unpend_first_thread+0x120>
800040a0:	800079b7          	lui	s3,0x80007
800040a4:	800075b7          	lui	a1,0x80007
800040a8:	80007537          	lui	a0,0x80007
800040ac:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800040b0:	04e00693          	li	a3,78
800040b4:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800040b8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800040bc:	9b0fe0ef          	jal	ra,8000226c <printk>
800040c0:	80007537          	lui	a0,0x80007
800040c4:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
800040c8:	9a4fe0ef          	jal	ra,8000226c <printk>
800040cc:	04e00593          	li	a1,78
800040d0:	b6498513          	addi	a0,s3,-1180
800040d4:	9d4fe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800040d8:	2f848513          	addi	a0,s1,760
800040dc:	22d000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800040e0:	00840513          	addi	a0,s0,8
800040e4:	e61fe0ef          	jal	ra,80002f44 <pended_on.isra.15>
800040e8:	00040593          	mv	a1,s0
800040ec:	c28ff0ef          	jal	ra,80003514 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800040f0:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800040f4:	2f848513          	addi	a0,s1,760
800040f8:	ffd7f793          	andi	a5,a5,-3
800040fc:	00f406a3          	sb	a5,13(s0)
80004100:	1d9000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80004104:	02051e63          	bnez	a0,80004140 <z_unpend_first_thread+0x188>
80004108:	800074b7          	lui	s1,0x80007
8000410c:	800075b7          	lui	a1,0x80007
80004110:	80007537          	lui	a0,0x80007
80004114:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80004118:	06100693          	li	a3,97
8000411c:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004120:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004124:	948fe0ef          	jal	ra,8000226c <printk>
80004128:	80007537          	lui	a0,0x80007
8000412c:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80004130:	93cfe0ef          	jal	ra,8000226c <printk>
80004134:	06100593          	li	a1,97
80004138:	b6448513          	addi	a0,s1,-1180
8000413c:	96cfe0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004140:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80004144:	00042423          	sw	zero,8(s0)
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80004148:	01840513          	addi	a0,s0,24
8000414c:	0b8010ef          	jal	ra,80005204 <z_abort_timeout>
}
80004150:	00040513          	mv	a0,s0
80004154:	01c12083          	lw	ra,28(sp)
80004158:	01812403          	lw	s0,24(sp)
8000415c:	01412483          	lw	s1,20(sp)
80004160:	01012903          	lw	s2,16(sp)
80004164:	00c12983          	lw	s3,12(sp)
80004168:	02010113          	addi	sp,sp,32
8000416c:	00008067          	ret

80004170 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80004170:	800077b7          	lui	a5,0x80007
80004174:	4fc78793          	addi	a5,a5,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80004178:	02478713          	addi	a4,a5,36
8000417c:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004180:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004184:	00000593          	li	a1,0
80004188:	00000513          	li	a0,0
8000418c:	e19fe06f          	j	80002fa4 <k_sched_time_slice_set>

80004190 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80004190:	fe010113          	addi	sp,sp,-32
80004194:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80004198:	80007437          	lui	s0,0x80007
8000419c:	4fc42783          	lw	a5,1276(s0) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
{
800041a0:	00112e23          	sw	ra,28(sp)
800041a4:	00912a23          	sw	s1,20(sp)
800041a8:	01212823          	sw	s2,16(sp)
800041ac:	01312623          	sw	s3,12(sp)
800041b0:	01412423          	sw	s4,8(sp)
800041b4:	01512223          	sw	s5,4(sp)
800041b8:	4fc40413          	addi	s0,s0,1276
	__ASSERT(!z_is_in_isr(), "");
800041bc:	02078e63          	beqz	a5,800041f8 <z_impl_k_yield+0x68>
800041c0:	800074b7          	lui	s1,0x80007
800041c4:	800075b7          	lui	a1,0x80007
800041c8:	80007537          	lui	a0,0x80007
800041cc:	d7458593          	addi	a1,a1,-652 # 80006d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d75>
800041d0:	37e00693          	li	a3,894
800041d4:	de048613          	addi	a2,s1,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
800041d8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800041dc:	890fe0ef          	jal	ra,8000226c <printk>
800041e0:	80007537          	lui	a0,0x80007
800041e4:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
800041e8:	884fe0ef          	jal	ra,8000226c <printk>
800041ec:	37e00593          	li	a1,894
800041f0:	de048513          	addi	a0,s1,-544
800041f4:	8b4fe0ef          	jal	ra,800022a8 <assert_post_action>
	return thread == _idle_thread;
800041f8:	800077b7          	lui	a5,0x80007

	if (!is_idle(_current)) {
800041fc:	00842683          	lw	a3,8(s0)
80004200:	17c7a703          	lw	a4,380(a5) # 8000717c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000717d>
80004204:	00078a13          	mv	s4,a5
80004208:	12e68663          	beq	a3,a4,80004334 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000420c:	00800913          	li	s2,8
80004210:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004214:	800079b7          	lui	s3,0x80007
80004218:	2f898513          	addi	a0,s3,760 # 800072f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f9>
	key = (mstatus & SOC_MSTATUS_IEN);
8000421c:	00897913          	andi	s2,s2,8
80004220:	091000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80004224:	02051e63          	bnez	a0,80004260 <z_impl_k_yield+0xd0>
80004228:	800074b7          	lui	s1,0x80007
8000422c:	800075b7          	lui	a1,0x80007
80004230:	80007537          	lui	a0,0x80007
80004234:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80004238:	04e00693          	li	a3,78
8000423c:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004240:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004244:	828fe0ef          	jal	ra,8000226c <printk>
80004248:	80007537          	lui	a0,0x80007
8000424c:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80004250:	81cfe0ef          	jal	ra,8000226c <printk>
80004254:	04e00593          	li	a1,78
80004258:	b6448513          	addi	a0,s1,-1180
8000425c:	84cfe0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004260:	2f898513          	addi	a0,s3,760
80004264:	0a5000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80004268:	00842583          	lw	a1,8(s0)
8000426c:	02440513          	addi	a0,s0,36
80004270:	aa4ff0ef          	jal	ra,80003514 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80004274:	17ca2783          	lw	a5,380(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80004278:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
8000427c:	80007a37          	lui	s4,0x80007
80004280:	520a0a13          	addi	s4,s4,1312 # 80007520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007521>
	__ASSERT_NO_MSG(!is_idle(thread));
80004284:	02f49863          	bne	s1,a5,800042b4 <z_impl_k_yield+0x124>
80004288:	80007ab7          	lui	s5,0x80007
8000428c:	800075b7          	lui	a1,0x80007
80004290:	80007537          	lui	a0,0x80007
80004294:	e7858593          	addi	a1,a1,-392 # 80006e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e79>
80004298:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000429c:	27600693          	li	a3,630
800042a0:	de0a8613          	addi	a2,s5,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
800042a4:	fc9fd0ef          	jal	ra,8000226c <printk>
800042a8:	27600593          	li	a1,630
800042ac:	de0a8513          	addi	a0,s5,-544
800042b0:	ff9fd0ef          	jal	ra,800022a8 <assert_post_action>
	return list->head == list;
800042b4:	02442783          	lw	a5,36(s0)
800042b8:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800042bc:	0b478a63          	beq	a5,s4,80004370 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800042c0:	0a078863          	beqz	a5,80004370 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
800042c4:	00e48683          	lb	a3,14(s1)
800042c8:	00e78603          	lb	a2,14(a5)
800042cc:	08c6dc63          	bge	a3,a2,80004364 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
800042d0:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800042d4:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
800042d8:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
800042dc:	00972023          	sw	s1,0(a4)
	successor->prev = node;
800042e0:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
800042e4:	00100513          	li	a0,1
800042e8:	ab8ff0ef          	jal	ra,800035a0 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800042ec:	2f898513          	addi	a0,s3,760
800042f0:	7e8000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800042f4:	02051e63          	bnez	a0,80004330 <z_impl_k_yield+0x1a0>
800042f8:	80007437          	lui	s0,0x80007
800042fc:	800075b7          	lui	a1,0x80007
80004300:	80007537          	lui	a0,0x80007
80004304:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80004308:	06100693          	li	a3,97
8000430c:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004310:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004314:	f59fd0ef          	jal	ra,8000226c <printk>
80004318:	80007537          	lui	a0,0x80007
8000431c:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80004320:	f4dfd0ef          	jal	ra,8000226c <printk>
80004324:	06100593          	li	a1,97
80004328:	b6440513          	addi	a0,s0,-1180
8000432c:	f7dfd0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004330:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004334:	00800513          	li	a0,8
80004338:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
8000433c:	01812403          	lw	s0,24(sp)
80004340:	01c12083          	lw	ra,28(sp)
80004344:	01412483          	lw	s1,20(sp)
80004348:	01012903          	lw	s2,16(sp)
8000434c:	00c12983          	lw	s3,12(sp)
80004350:	00812a03          	lw	s4,8(sp)
80004354:	00412a83          	lw	s5,4(sp)
80004358:	00857513          	andi	a0,a0,8
8000435c:	02010113          	addi	sp,sp,32
80004360:	ec9fb06f          	j	80000228 <__swap>
	return (node == list->tail) ? NULL : node->next;
80004364:	00e78663          	beq	a5,a4,80004370 <z_impl_k_yield+0x1e0>
80004368:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000436c:	f4079ee3          	bnez	a5,800042c8 <z_impl_k_yield+0x138>
	node->prev = list->tail;
80004370:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80004374:	02842783          	lw	a5,40(s0)
	node->next = list;
80004378:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
8000437c:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80004380:	02942423          	sw	s1,40(s0)
80004384:	f61ff06f          	j	800042e4 <z_impl_k_yield+0x154>

80004388 <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
80004388:	fd010113          	addi	sp,sp,-48
8000438c:	02912223          	sw	s1,36(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80004390:	800074b7          	lui	s1,0x80007
80004394:	4fc4a783          	lw	a5,1276(s1) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
{
80004398:	02812423          	sw	s0,40(sp)
8000439c:	02112623          	sw	ra,44(sp)
800043a0:	03212023          	sw	s2,32(sp)
800043a4:	01312e23          	sw	s3,28(sp)
800043a8:	01412c23          	sw	s4,24(sp)
800043ac:	00050413          	mv	s0,a0
800043b0:	4fc48493          	addi	s1,s1,1276
	__ASSERT(!z_is_in_isr(), "");
800043b4:	02078e63          	beqz	a5,800043f0 <z_impl_k_sleep+0x68>
800043b8:	80007937          	lui	s2,0x80007
800043bc:	800075b7          	lui	a1,0x80007
800043c0:	80007537          	lui	a0,0x80007
800043c4:	d7458593          	addi	a1,a1,-652 # 80006d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d75>
800043c8:	39900693          	li	a3,921
800043cc:	de090613          	addi	a2,s2,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
800043d0:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800043d4:	e99fd0ef          	jal	ra,8000226c <printk>
800043d8:	80007537          	lui	a0,0x80007
800043dc:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
800043e0:	e8dfd0ef          	jal	ra,8000226c <printk>
800043e4:	39900593          	li	a1,921
800043e8:	de090513          	addi	a0,s2,-544
800043ec:	ebdfd0ef          	jal	ra,800022a8 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
800043f0:	fff00793          	li	a5,-1
800043f4:	1af41263          	bne	s0,a5,80004598 <z_impl_k_sleep+0x210>
800043f8:	80007937          	lui	s2,0x80007
800043fc:	800075b7          	lui	a1,0x80007
80004400:	80007537          	lui	a0,0x80007
80004404:	e2c58593          	addi	a1,a1,-468 # 80006e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e2d>
80004408:	39a00693          	li	a3,922
8000440c:	de090613          	addi	a2,s2,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80004410:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004414:	e59fd0ef          	jal	ra,8000226c <printk>
80004418:	80007537          	lui	a0,0x80007
8000441c:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80004420:	e4dfd0ef          	jal	ra,8000226c <printk>
80004424:	39a00593          	li	a1,922
80004428:	de090513          	addi	a0,s2,-544
8000442c:	e7dfd0ef          	jal	ra,800022a8 <assert_post_action>
80004430:	00a00793          	li	a5,10
80004434:	00940413          	addi	s0,s0,9
80004438:	02f44433          	div	s0,s0,a5
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
	expected_wakeup_time = ticks + z_tick_get_32();
8000443c:	52c010ef          	jal	ra,80005968 <z_tick_get_32>
80004440:	00800993          	li	s3,8

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
80004444:	00012623          	sw	zero,12(sp)
	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80004448:	00140413          	addi	s0,s0,1
	expected_wakeup_time = ticks + z_tick_get_32();
8000444c:	00a40933          	add	s2,s0,a0
80004450:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004454:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004458:	0089f993          	andi	s3,s3,8
8000445c:	654000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80004460:	02051e63          	bnez	a0,8000449c <z_impl_k_sleep+0x114>
80004464:	80007a37          	lui	s4,0x80007
80004468:	800075b7          	lui	a1,0x80007
8000446c:	80007537          	lui	a0,0x80007
80004470:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80004474:	04e00693          	li	a3,78
80004478:	b64a0613          	addi	a2,s4,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
8000447c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004480:	dedfd0ef          	jal	ra,8000226c <printk>
80004484:	80007537          	lui	a0,0x80007
80004488:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
8000448c:	de1fd0ef          	jal	ra,8000226c <printk>
80004490:	04e00593          	li	a1,78
80004494:	b64a0513          	addi	a0,s4,-1180
80004498:	e11fd0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000449c:	00c10513          	addi	a0,sp,12
800044a0:	668000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
800044a4:	0084a503          	lw	a0,8(s1)
800044a8:	849ff0ef          	jal	ra,80003cf0 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800044ac:	0084a503          	lw	a0,8(s1)
800044b0:	800045b7          	lui	a1,0x80004
800044b4:	00040613          	mv	a2,s0
800044b8:	01850513          	addi	a0,a0,24
800044bc:	97858593          	addi	a1,a1,-1672 # 80003978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003979>
800044c0:	319000ef          	jal	ra,80004fd8 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
800044c4:	0084a703          	lw	a4,8(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800044c8:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
800044cc:	00d74783          	lbu	a5,13(a4)
800044d0:	0107e793          	ori	a5,a5,16
800044d4:	00f706a3          	sb	a5,13(a4)
800044d8:	600000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800044dc:	02051e63          	bnez	a0,80004518 <z_impl_k_sleep+0x190>
800044e0:	80007437          	lui	s0,0x80007
800044e4:	800075b7          	lui	a1,0x80007
800044e8:	80007537          	lui	a0,0x80007
800044ec:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800044f0:	07800693          	li	a3,120
800044f4:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800044f8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800044fc:	d71fd0ef          	jal	ra,8000226c <printk>
80004500:	80007537          	lui	a0,0x80007
80004504:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80004508:	d65fd0ef          	jal	ra,8000226c <printk>
8000450c:	07800593          	li	a1,120
80004510:	b6440513          	addi	a0,s0,-1180
80004514:	d95fd0ef          	jal	ra,800022a8 <assert_post_action>
80004518:	00098513          	mv	a0,s3
8000451c:	d0dfb0ef          	jal	ra,80000228 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80004520:	0084a783          	lw	a5,8(s1)
80004524:	00d7c783          	lbu	a5,13(a5)
80004528:	0107f793          	andi	a5,a5,16
8000452c:	02078e63          	beqz	a5,80004568 <z_impl_k_sleep+0x1e0>
80004530:	80007437          	lui	s0,0x80007
80004534:	800075b7          	lui	a1,0x80007
80004538:	80007537          	lui	a0,0x80007
8000453c:	e4058593          	addi	a1,a1,-448 # 80006e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e41>
80004540:	3b700693          	li	a3,951
80004544:	de040613          	addi	a2,s0,-544 # 80006de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de1>
80004548:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000454c:	d21fd0ef          	jal	ra,8000226c <printk>
80004550:	80007537          	lui	a0,0x80007
80004554:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80004558:	d15fd0ef          	jal	ra,8000226c <printk>
8000455c:	3b700593          	li	a1,951
80004560:	de040513          	addi	a0,s0,-544
80004564:	d45fd0ef          	jal	ra,800022a8 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
80004568:	400010ef          	jal	ra,80005968 <z_tick_get_32>
8000456c:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80004570:	00000413          	li	s0,0
	if (ticks > 0) {
80004574:	02a05663          	blez	a0,800045a0 <z_impl_k_sleep+0x218>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80004578:	3e800793          	li	a5,1000
8000457c:	02f515b3          	mulh	a1,a0,a5
80004580:	06400613          	li	a2,100
80004584:	00000693          	li	a3,0
80004588:	02f50533          	mul	a0,a0,a5
8000458c:	d25fb0ef          	jal	ra,800002b0 <__udivdi3>
80004590:	00050413          	mv	s0,a0
		return __ticks_to_ms(ticks);
80004594:	00c0006f          	j	800045a0 <z_impl_k_sleep+0x218>
	if (duration == 0) {
80004598:	e8041ce3          	bnez	s0,80004430 <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
8000459c:	bf5ff0ef          	jal	ra,80004190 <z_impl_k_yield>
}
800045a0:	00040513          	mv	a0,s0
800045a4:	02c12083          	lw	ra,44(sp)
800045a8:	02812403          	lw	s0,40(sp)
800045ac:	02412483          	lw	s1,36(sp)
800045b0:	02012903          	lw	s2,32(sp)
800045b4:	01c12983          	lw	s3,28(sp)
800045b8:	01812a03          	lw	s4,24(sp)
800045bc:	03010113          	addi	sp,sp,48
800045c0:	00008067          	ret

800045c4 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800045c4:	800077b7          	lui	a5,0x80007
800045c8:	5047a503          	lw	a0,1284(a5) # 80007504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007505>
800045cc:	00008067          	ret

800045d0 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800045d0:	fe010113          	addi	sp,sp,-32
800045d4:	00812c23          	sw	s0,24(sp)
800045d8:	00912a23          	sw	s1,20(sp)
800045dc:	01212823          	sw	s2,16(sp)
800045e0:	00112e23          	sw	ra,28(sp)
800045e4:	01312623          	sw	s3,12(sp)
800045e8:	00050413          	mv	s0,a0
800045ec:	00058913          	mv	s2,a1
800045f0:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
800045f4:	02061e63          	bnez	a2,80004630 <z_impl_k_sem_init+0x60>
800045f8:	800079b7          	lui	s3,0x80007
800045fc:	800075b7          	lui	a1,0x80007
80004600:	80007537          	lui	a0,0x80007
80004604:	e9c58593          	addi	a1,a1,-356 # 80006e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e9d>
80004608:	04600693          	li	a3,70
8000460c:	e8c98613          	addi	a2,s3,-372 # 80006e8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e8d>
80004610:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004614:	c59fd0ef          	jal	ra,8000226c <printk>
80004618:	80007537          	lui	a0,0x80007
8000461c:	ea850513          	addi	a0,a0,-344 # 80006ea8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea9>
80004620:	c4dfd0ef          	jal	ra,8000226c <printk>
80004624:	04600593          	li	a1,70
80004628:	e8c98513          	addi	a0,s3,-372
8000462c:	c7dfd0ef          	jal	ra,800022a8 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80004630:	0324fe63          	bgeu	s1,s2,8000466c <z_impl_k_sem_init+0x9c>
80004634:	800079b7          	lui	s3,0x80007
80004638:	800075b7          	lui	a1,0x80007
8000463c:	80007537          	lui	a0,0x80007
80004640:	ec058593          	addi	a1,a1,-320 # 80006ec0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec1>
80004644:	04700693          	li	a3,71
80004648:	e8c98613          	addi	a2,s3,-372 # 80006e8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e8d>
8000464c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004650:	c1dfd0ef          	jal	ra,8000226c <printk>
80004654:	80007537          	lui	a0,0x80007
80004658:	ed850513          	addi	a0,a0,-296 # 80006ed8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed9>
8000465c:	c11fd0ef          	jal	ra,8000226c <printk>
80004660:	04700593          	li	a1,71
80004664:	e8c98513          	addi	a0,s3,-372
80004668:	c41fd0ef          	jal	ra,800022a8 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
8000466c:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80004670:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80004674:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80004678:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
8000467c:	01c12083          	lw	ra,28(sp)
80004680:	01812403          	lw	s0,24(sp)
80004684:	01412483          	lw	s1,20(sp)
80004688:	01012903          	lw	s2,16(sp)
8000468c:	00c12983          	lw	s3,12(sp)
80004690:	02010113          	addi	sp,sp,32
80004694:	00008067          	ret

80004698 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80004698:	fe010113          	addi	sp,sp,-32
8000469c:	00912a23          	sw	s1,20(sp)
800046a0:	01312623          	sw	s3,12(sp)
800046a4:	00112e23          	sw	ra,28(sp)
800046a8:	00812c23          	sw	s0,24(sp)
800046ac:	01212823          	sw	s2,16(sp)
800046b0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800046b4:	00800493          	li	s1,8
800046b8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800046bc:	80007437          	lui	s0,0x80007
800046c0:	30440513          	addi	a0,s0,772 # 80007304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007305>
	key = (mstatus & SOC_MSTATUS_IEN);
800046c4:	0084f493          	andi	s1,s1,8
800046c8:	3e8000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
800046cc:	02051e63          	bnez	a0,80004708 <z_impl_k_sem_give+0x70>
800046d0:	80007937          	lui	s2,0x80007
800046d4:	800075b7          	lui	a1,0x80007
800046d8:	80007537          	lui	a0,0x80007
800046dc:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800046e0:	04e00693          	li	a3,78
800046e4:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800046e8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800046ec:	b81fd0ef          	jal	ra,8000226c <printk>
800046f0:	80007537          	lui	a0,0x80007
800046f4:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
800046f8:	b75fd0ef          	jal	ra,8000226c <printk>
800046fc:	04e00593          	li	a1,78
80004700:	b6490513          	addi	a0,s2,-1180
80004704:	ba5fd0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004708:	30440513          	addi	a0,s0,772
8000470c:	3fc000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80004710:	00098513          	mv	a0,s3
80004714:	8a5ff0ef          	jal	ra,80003fb8 <z_unpend_first_thread>
80004718:	00050913          	mv	s2,a0
	if (thread != NULL) {
8000471c:	04050263          	beqz	a0,80004760 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004720:	00d54783          	lbu	a5,13(a0)
80004724:	01f7f793          	andi	a5,a5,31
80004728:	00079863          	bnez	a5,80004738 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
8000472c:	01852783          	lw	a5,24(a0)
80004730:	00079463          	bnez	a5,80004738 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80004734:	8b4ff0ef          	jal	ra,800037e8 <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80004738:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
8000473c:	30440513          	addi	a0,s0,772
}
80004740:	01812403          	lw	s0,24(sp)
80004744:	01c12083          	lw	ra,28(sp)
80004748:	01012903          	lw	s2,16(sp)
8000474c:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004750:	00048593          	mv	a1,s1
}
80004754:	01412483          	lw	s1,20(sp)
80004758:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
8000475c:	b41fe06f          	j	8000329c <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004760:	0089a703          	lw	a4,8(s3)
80004764:	00c9a783          	lw	a5,12(s3)
80004768:	40e787b3          	sub	a5,a5,a4
8000476c:	00f037b3          	snez	a5,a5
80004770:	00e787b3          	add	a5,a5,a4
80004774:	00f9a423          	sw	a5,8(s3)
80004778:	fc5ff06f          	j	8000473c <z_impl_k_sem_give+0xa4>

8000477c <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000477c:	800077b7          	lui	a5,0x80007
80004780:	4fc7a783          	lw	a5,1276(a5) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
{
80004784:	fe010113          	addi	sp,sp,-32
80004788:	01212823          	sw	s2,16(sp)
8000478c:	01312623          	sw	s3,12(sp)
80004790:	00112e23          	sw	ra,28(sp)
80004794:	00812c23          	sw	s0,24(sp)
80004798:	00912a23          	sw	s1,20(sp)
8000479c:	01412423          	sw	s4,8(sp)
800047a0:	00050913          	mv	s2,a0
800047a4:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800047a8:	04078063          	beqz	a5,800047e8 <z_impl_k_sem_take+0x6c>
800047ac:	02058e63          	beqz	a1,800047e8 <z_impl_k_sem_take+0x6c>
800047b0:	80007437          	lui	s0,0x80007
800047b4:	800075b7          	lui	a1,0x80007
800047b8:	80007537          	lui	a0,0x80007
800047bc:	f0058593          	addi	a1,a1,-256 # 80006f00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f01>
800047c0:	08c00693          	li	a3,140
800047c4:	e8c40613          	addi	a2,s0,-372 # 80006e8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e8d>
800047c8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800047cc:	aa1fd0ef          	jal	ra,8000226c <printk>
800047d0:	80007537          	lui	a0,0x80007
800047d4:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
800047d8:	a95fd0ef          	jal	ra,8000226c <printk>
800047dc:	08c00593          	li	a1,140
800047e0:	e8c40513          	addi	a0,s0,-372
800047e4:	ac5fd0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800047e8:	00800413          	li	s0,8
800047ec:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800047f0:	800074b7          	lui	s1,0x80007
800047f4:	30448513          	addi	a0,s1,772 # 80007304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007305>
	key = (mstatus & SOC_MSTATUS_IEN);
800047f8:	00847413          	andi	s0,s0,8
800047fc:	2b4000ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80004800:	02051e63          	bnez	a0,8000483c <z_impl_k_sem_take+0xc0>
80004804:	80007a37          	lui	s4,0x80007
80004808:	800075b7          	lui	a1,0x80007
8000480c:	80007537          	lui	a0,0x80007
80004810:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80004814:	04e00693          	li	a3,78
80004818:	b64a0613          	addi	a2,s4,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
8000481c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004820:	a4dfd0ef          	jal	ra,8000226c <printk>
80004824:	80007537          	lui	a0,0x80007
80004828:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
8000482c:	a41fd0ef          	jal	ra,8000226c <printk>
80004830:	04e00593          	li	a1,78
80004834:	b64a0513          	addi	a0,s4,-1180
80004838:	a71fd0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000483c:	30448513          	addi	a0,s1,772
80004840:	2c8000ef          	jal	ra,80004b08 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80004844:	00892783          	lw	a5,8(s2)
80004848:	06078c63          	beqz	a5,800048c0 <z_impl_k_sem_take+0x144>
		sem->count--;
8000484c:	fff78793          	addi	a5,a5,-1
80004850:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004854:	30448513          	addi	a0,s1,772
80004858:	280000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000485c:	02051e63          	bnez	a0,80004898 <z_impl_k_sem_take+0x11c>
80004860:	800074b7          	lui	s1,0x80007
80004864:	800075b7          	lui	a1,0x80007
80004868:	80007537          	lui	a0,0x80007
8000486c:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80004870:	06100693          	li	a3,97
80004874:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004878:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000487c:	9f1fd0ef          	jal	ra,8000226c <printk>
80004880:	80007537          	lui	a0,0x80007
80004884:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80004888:	9e5fd0ef          	jal	ra,8000226c <printk>
8000488c:	06100593          	li	a1,97
80004890:	b6448513          	addi	a0,s1,-1180
80004894:	a15fd0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004898:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
8000489c:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800048a0:	01c12083          	lw	ra,28(sp)
800048a4:	01812403          	lw	s0,24(sp)
800048a8:	01412483          	lw	s1,20(sp)
800048ac:	01012903          	lw	s2,16(sp)
800048b0:	00c12983          	lw	s3,12(sp)
800048b4:	00812a03          	lw	s4,8(sp)
800048b8:	02010113          	addi	sp,sp,32
800048bc:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800048c0:	04099a63          	bnez	s3,80004914 <z_impl_k_sem_take+0x198>
800048c4:	30448513          	addi	a0,s1,772
800048c8:	210000ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800048cc:	02051e63          	bnez	a0,80004908 <z_impl_k_sem_take+0x18c>
800048d0:	800074b7          	lui	s1,0x80007
800048d4:	800075b7          	lui	a1,0x80007
800048d8:	80007537          	lui	a0,0x80007
800048dc:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800048e0:	06100693          	li	a3,97
800048e4:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800048e8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800048ec:	981fd0ef          	jal	ra,8000226c <printk>
800048f0:	80007537          	lui	a0,0x80007
800048f4:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800048f8:	975fd0ef          	jal	ra,8000226c <printk>
800048fc:	06100593          	li	a1,97
80004900:	b6448513          	addi	a0,s1,-1180
80004904:	9a5fd0ef          	jal	ra,800022a8 <assert_post_action>
80004908:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
8000490c:	ff000513          	li	a0,-16
80004910:	f91ff06f          	j	800048a0 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004914:	00040593          	mv	a1,s0
}
80004918:	01812403          	lw	s0,24(sp)
8000491c:	01c12083          	lw	ra,28(sp)
80004920:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004924:	00098693          	mv	a3,s3
80004928:	00090613          	mv	a2,s2
}
8000492c:	00c12983          	lw	s3,12(sp)
80004930:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004934:	30448513          	addi	a0,s1,772
}
80004938:	01412483          	lw	s1,20(sp)
8000493c:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004940:	df0ff06f          	j	80003f30 <z_pend_curr>

80004944 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004944:	00d54783          	lbu	a5,13(a0)
80004948:	01f7f793          	andi	a5,a5,31
8000494c:	00079863          	bnez	a5,8000495c <z_is_thread_ready+0x18>
80004950:	01852503          	lw	a0,24(a0)
80004954:	00153513          	seqz	a0,a0
80004958:	00008067          	ret
8000495c:	00000513          	li	a0,0
}
80004960:	00008067          	ret

80004964 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80004964:	800077b7          	lui	a5,0x80007
80004968:	4fc7a503          	lw	a0,1276(a5) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
}
8000496c:	00a03533          	snez	a0,a0
80004970:	00008067          	ret

80004974 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80004974:	800077b7          	lui	a5,0x80007
80004978:	5047a783          	lw	a5,1284(a5) # 80007504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007505>
8000497c:	00c7c503          	lbu	a0,12(a5)
}
80004980:	00157513          	andi	a0,a0,1
80004984:	00008067          	ret

80004988 <z_impl_k_busy_wait>:
void z_impl_k_busy_wait(u32_t usec_to_wait)
{
#if !defined(CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT)
	/* use 64-bit math to prevent overflow when multiplying */
	u32_t cycles_to_wait = (u32_t)(
		(u64_t)usec_to_wait *
80004988:	00b727b7          	lui	a5,0xb72
8000498c:	b0078793          	addi	a5,a5,-1280 # b71b00 <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC>
80004990:	02f535b3          	mulhu	a1,a0,a5
		(u64_t)sys_clock_hw_cycles_per_sec() /
80004994:	000f4637          	lui	a2,0xf4
{
80004998:	ff010113          	addi	sp,sp,-16
		(u64_t)sys_clock_hw_cycles_per_sec() /
8000499c:	24060613          	addi	a2,a2,576 # f4240 <CONFIG_RISCV_RAM_SIZE+0xb4240>
800049a0:	00000693          	li	a3,0
{
800049a4:	00112623          	sw	ra,12(sp)
800049a8:	00812423          	sw	s0,8(sp)
800049ac:	00912223          	sw	s1,4(sp)
		(u64_t)sys_clock_hw_cycles_per_sec() /
800049b0:	02f50533          	mul	a0,a0,a5
800049b4:	8fdfb0ef          	jal	ra,800002b0 <__udivdi3>
800049b8:	00050413          	mv	s0,a0
		(u64_t)USEC_PER_SEC
	);
	u32_t start_cycles = k_cycle_get_32();
800049bc:	e2dfd0ef          	jal	ra,800027e8 <z_timer_cycle_get_32>
800049c0:	00050493          	mv	s1,a0

	for (;;) {
		u32_t current_cycles = k_cycle_get_32();
800049c4:	e25fd0ef          	jal	ra,800027e8 <z_timer_cycle_get_32>

		/* this handles the rollover on an unsigned 32-bit value */
		if ((current_cycles - start_cycles) >= cycles_to_wait) {
800049c8:	40950533          	sub	a0,a0,s1
800049cc:	fe856ce3          	bltu	a0,s0,800049c4 <z_impl_k_busy_wait+0x3c>
		}
	}
#else
	z_arch_busy_wait(usec_to_wait);
#endif /* CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT */
}
800049d0:	00c12083          	lw	ra,12(sp)
800049d4:	00812403          	lw	s0,8(sp)
800049d8:	00412483          	lw	s1,4(sp)
800049dc:	01010113          	addi	sp,sp,16
800049e0:	00008067          	ret

800049e4 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800049e4:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800049e8:	02012303          	lw	t1,32(sp)
{
800049ec:	00812c23          	sw	s0,24(sp)
800049f0:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800049f4:	00612023          	sw	t1,0(sp)
{
800049f8:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800049fc:	f79fc0ef          	jal	ra,80001974 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004a00:	800077b7          	lui	a5,0x80007
80004a04:	5047a783          	lw	a5,1284(a5) # 80007504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007505>
	sys_trace_thread_create(new_thread);
}
80004a08:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004a0c:	0687a783          	lw	a5,104(a5)
80004a10:	06f42423          	sw	a5,104(s0)
}
80004a14:	01812403          	lw	s0,24(sp)
80004a18:	02010113          	addi	sp,sp,32
80004a1c:	00008067          	ret

80004a20 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004a20:	06052783          	lw	a5,96(a0)
{
80004a24:	ff010113          	addi	sp,sp,-16
80004a28:	00812423          	sw	s0,8(sp)
80004a2c:	00112623          	sw	ra,12(sp)
80004a30:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004a34:	00078463          	beqz	a5,80004a3c <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004a38:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004a3c:	00040513          	mv	a0,s0
80004a40:	f05ff0ef          	jal	ra,80004944 <z_is_thread_ready>
80004a44:	02050463          	beqz	a0,80004a6c <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004a48:	00040513          	mv	a0,s0
80004a4c:	aa4ff0ef          	jal	ra,80003cf0 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004a50:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004a54:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004a58:	0087e793          	ori	a5,a5,8
80004a5c:	00f406a3          	sb	a5,13(s0)
}
80004a60:	00812403          	lw	s0,8(sp)
80004a64:	01010113          	addi	sp,sp,16
80004a68:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004a6c:	00d44783          	lbu	a5,13(s0)
80004a70:	0027f793          	andi	a5,a5,2
80004a74:	00078663          	beqz	a5,80004a80 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004a78:	00040513          	mv	a0,s0
80004a7c:	f24fe0ef          	jal	ra,800031a0 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80004a80:	01842783          	lw	a5,24(s0)
80004a84:	fc0786e3          	beqz	a5,80004a50 <z_thread_single_abort+0x30>
	return z_abort_timeout(&thread->base.timeout);
80004a88:	01840513          	addi	a0,s0,24
80004a8c:	778000ef          	jal	ra,80005204 <z_abort_timeout>
80004a90:	fc1ff06f          	j	80004a50 <z_thread_single_abort+0x30>

80004a94 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004a94:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80004a98:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004a9c:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004aa0:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004aa4:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80004aa8:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004aac:	00008067          	ret

80004ab0 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004ab0:	00052503          	lw	a0,0(a0)
80004ab4:	00050e63          	beqz	a0,80004ad0 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004ab8:	800077b7          	lui	a5,0x80007
80004abc:	5107c783          	lbu	a5,1296(a5) # 80007510 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007511>
80004ac0:	00357513          	andi	a0,a0,3
80004ac4:	40f50533          	sub	a0,a0,a5
80004ac8:	00a03533          	snez	a0,a0
80004acc:	00008067          	ret
			return false;
		}
	}
	return true;
80004ad0:	00100513          	li	a0,1
}
80004ad4:	00008067          	ret

80004ad8 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80004ad8:	800077b7          	lui	a5,0x80007
80004adc:	4fc78793          	addi	a5,a5,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80004ae0:	0147c703          	lbu	a4,20(a5)
80004ae4:	0087a783          	lw	a5,8(a5)
80004ae8:	00e7e7b3          	or	a5,a5,a4
80004aec:	00052703          	lw	a4,0(a0)
80004af0:	00f71863          	bne	a4,a5,80004b00 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004af4:	00052023          	sw	zero,0(a0)
	return true;
80004af8:	00100513          	li	a0,1
80004afc:	00008067          	ret
		return false;
80004b00:	00000513          	li	a0,0
}
80004b04:	00008067          	ret

80004b08 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004b08:	800077b7          	lui	a5,0x80007
80004b0c:	4fc78793          	addi	a5,a5,1276 # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
80004b10:	0147c703          	lbu	a4,20(a5)
80004b14:	0087a783          	lw	a5,8(a5)
80004b18:	00e7e7b3          	or	a5,a5,a4
80004b1c:	00f52023          	sw	a5,0(a0)
}
80004b20:	00008067          	ret

80004b24 <z_impl_k_thread_start>:
{
80004b24:	fe010113          	addi	sp,sp,-32
80004b28:	00812c23          	sw	s0,24(sp)
80004b2c:	01212823          	sw	s2,16(sp)
80004b30:	00112e23          	sw	ra,28(sp)
80004b34:	00912a23          	sw	s1,20(sp)
80004b38:	01312623          	sw	s3,12(sp)
80004b3c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b40:	00800413          	li	s0,8
80004b44:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b48:	800074b7          	lui	s1,0x80007
80004b4c:	30848513          	addi	a0,s1,776 # 80007308 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007309>
	key = (mstatus & SOC_MSTATUS_IEN);
80004b50:	00847413          	andi	s0,s0,8
80004b54:	f5dff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80004b58:	02051e63          	bnez	a0,80004b94 <z_impl_k_thread_start+0x70>
80004b5c:	800079b7          	lui	s3,0x80007
80004b60:	800075b7          	lui	a1,0x80007
80004b64:	80007537          	lui	a0,0x80007
80004b68:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80004b6c:	04e00693          	li	a3,78
80004b70:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004b74:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004b78:	ef4fd0ef          	jal	ra,8000226c <printk>
80004b7c:	80007537          	lui	a0,0x80007
80004b80:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80004b84:	ee8fd0ef          	jal	ra,8000226c <printk>
80004b88:	04e00593          	li	a1,78
80004b8c:	b6498513          	addi	a0,s3,-1180
80004b90:	f18fd0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004b94:	30848513          	addi	a0,s1,776
80004b98:	f71ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004b9c:	00d94783          	lbu	a5,13(s2)
80004ba0:	0047f713          	andi	a4,a5,4
80004ba4:	06071463          	bnez	a4,80004c0c <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ba8:	30848513          	addi	a0,s1,776
80004bac:	f2dff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80004bb0:	02051e63          	bnez	a0,80004bec <z_impl_k_thread_start+0xc8>
80004bb4:	800074b7          	lui	s1,0x80007
80004bb8:	800075b7          	lui	a1,0x80007
80004bbc:	80007537          	lui	a0,0x80007
80004bc0:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80004bc4:	06100693          	li	a3,97
80004bc8:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004bcc:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004bd0:	e9cfd0ef          	jal	ra,8000226c <printk>
80004bd4:	80007537          	lui	a0,0x80007
80004bd8:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80004bdc:	e90fd0ef          	jal	ra,8000226c <printk>
80004be0:	06100593          	li	a1,97
80004be4:	b6448513          	addi	a0,s1,-1180
80004be8:	ec0fd0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004bec:	30042473          	csrrs	s0,mstatus,s0
}
80004bf0:	01c12083          	lw	ra,28(sp)
80004bf4:	01812403          	lw	s0,24(sp)
80004bf8:	01412483          	lw	s1,20(sp)
80004bfc:	01012903          	lw	s2,16(sp)
80004c00:	00c12983          	lw	s3,12(sp)
80004c04:	02010113          	addi	sp,sp,32
80004c08:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004c0c:	ffb7f793          	andi	a5,a5,-5
80004c10:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004c14:	00090513          	mv	a0,s2
80004c18:	d2dff0ef          	jal	ra,80004944 <z_is_thread_ready>
80004c1c:	00050663          	beqz	a0,80004c28 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004c20:	00090513          	mv	a0,s2
80004c24:	bc5fe0ef          	jal	ra,800037e8 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004c28:	00040593          	mv	a1,s0
}
80004c2c:	01812403          	lw	s0,24(sp)
80004c30:	01c12083          	lw	ra,28(sp)
80004c34:	01012903          	lw	s2,16(sp)
80004c38:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004c3c:	30848513          	addi	a0,s1,776
}
80004c40:	01412483          	lw	s1,20(sp)
80004c44:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004c48:	e54fe06f          	j	8000329c <z_reschedule>

80004c4c <schedule_new_thread>:
	if (delay == 0) {
80004c4c:	00059463          	bnez	a1,80004c54 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004c50:	ed5ff06f          	j	80004b24 <z_impl_k_thread_start>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80004c54:	00958593          	addi	a1,a1,9
80004c58:	00a00613          	li	a2,10
80004c5c:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004c60:	800045b7          	lui	a1,0x80004
80004c64:	97858593          	addi	a1,a1,-1672 # 80003978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003979>
80004c68:	01850513          	addi	a0,a0,24
80004c6c:	00160613          	addi	a2,a2,1
80004c70:	3680006f          	j	80004fd8 <z_add_timeout>

80004c74 <z_impl_k_thread_create>:
{
80004c74:	fc010113          	addi	sp,sp,-64
80004c78:	03512223          	sw	s5,36(sp)
80004c7c:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004c80:	800076b7          	lui	a3,0x80007
80004c84:	4fc6a683          	lw	a3,1276(a3) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
{
80004c88:	02812c23          	sw	s0,56(sp)
80004c8c:	02912a23          	sw	s1,52(sp)
80004c90:	03312623          	sw	s3,44(sp)
80004c94:	03412423          	sw	s4,40(sp)
80004c98:	02112e23          	sw	ra,60(sp)
80004c9c:	03212823          	sw	s2,48(sp)
80004ca0:	00050413          	mv	s0,a0
80004ca4:	00058993          	mv	s3,a1
80004ca8:	00060a13          	mv	s4,a2
80004cac:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004cb0:	04068e63          	beqz	a3,80004d0c <z_impl_k_thread_create+0x98>
80004cb4:	80007937          	lui	s2,0x80007
80004cb8:	800075b7          	lui	a1,0x80007
80004cbc:	80007537          	lui	a0,0x80007
80004cc0:	1b200693          	li	a3,434
80004cc4:	f3490613          	addi	a2,s2,-204 # 80006f34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f35>
80004cc8:	d7458593          	addi	a1,a1,-652 # 80006d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d75>
80004ccc:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004cd0:	01112e23          	sw	a7,28(sp)
80004cd4:	01012c23          	sw	a6,24(sp)
80004cd8:	00f12a23          	sw	a5,20(sp)
80004cdc:	00e12823          	sw	a4,16(sp)
80004ce0:	d8cfd0ef          	jal	ra,8000226c <printk>
80004ce4:	80007537          	lui	a0,0x80007
80004ce8:	f4850513          	addi	a0,a0,-184 # 80006f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f49>
80004cec:	d80fd0ef          	jal	ra,8000226c <printk>
80004cf0:	1b200593          	li	a1,434
80004cf4:	f3490513          	addi	a0,s2,-204
80004cf8:	db0fd0ef          	jal	ra,800022a8 <assert_post_action>
80004cfc:	01c12883          	lw	a7,28(sp)
80004d00:	01812803          	lw	a6,24(sp)
80004d04:	01412783          	lw	a5,20(sp)
80004d08:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004d0c:	04012683          	lw	a3,64(sp)
80004d10:	00012223          	sw	zero,4(sp)
80004d14:	000a0613          	mv	a2,s4
80004d18:	00d12023          	sw	a3,0(sp)
80004d1c:	00098593          	mv	a1,s3
80004d20:	000a8693          	mv	a3,s5
80004d24:	00040513          	mv	a0,s0
80004d28:	cbdff0ef          	jal	ra,800049e4 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004d2c:	fff00793          	li	a5,-1
80004d30:	00f48863          	beq	s1,a5,80004d40 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004d34:	00048593          	mv	a1,s1
80004d38:	00040513          	mv	a0,s0
80004d3c:	f11ff0ef          	jal	ra,80004c4c <schedule_new_thread>
}
80004d40:	00040513          	mv	a0,s0
80004d44:	03c12083          	lw	ra,60(sp)
80004d48:	03812403          	lw	s0,56(sp)
80004d4c:	03412483          	lw	s1,52(sp)
80004d50:	03012903          	lw	s2,48(sp)
80004d54:	02c12983          	lw	s3,44(sp)
80004d58:	02812a03          	lw	s4,40(sp)
80004d5c:	02412a83          	lw	s5,36(sp)
80004d60:	04010113          	addi	sp,sp,64
80004d64:	00008067          	ret

80004d68 <z_init_static_threads>:
{
80004d68:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004d6c:	800077b7          	lui	a5,0x80007
{
80004d70:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004d74:	80007937          	lui	s2,0x80007
{
80004d78:	00812c23          	sw	s0,24(sp)
80004d7c:	00912a23          	sw	s1,20(sp)
80004d80:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004d84:	1b078413          	addi	s0,a5,432 # 800071b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071b1>
80004d88:	1b078493          	addi	s1,a5,432
80004d8c:	1b090913          	addi	s2,s2,432 # 800071b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071b1>
80004d90:	03246663          	bltu	s0,s2,80004dbc <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004d94:	00048413          	mv	s0,s1
	k_sched_lock();
80004d98:	e04fe0ef          	jal	ra,8000339c <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004d9c:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004da0:	07246063          	bltu	s0,s2,80004e00 <z_init_static_threads+0x98>
}
80004da4:	01812403          	lw	s0,24(sp)
80004da8:	01c12083          	lw	ra,28(sp)
80004dac:	01412483          	lw	s1,20(sp)
80004db0:	01012903          	lw	s2,16(sp)
80004db4:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004db8:	8b1fe06f          	j	80003668 <k_sched_unlock>
		z_setup_new_thread(
80004dbc:	02c42783          	lw	a5,44(s0)
80004dc0:	00f12223          	sw	a5,4(sp)
80004dc4:	02042783          	lw	a5,32(s0)
80004dc8:	00f12023          	sw	a5,0(sp)
80004dcc:	01442783          	lw	a5,20(s0)
80004dd0:	01c42883          	lw	a7,28(s0)
80004dd4:	01842803          	lw	a6,24(s0)
80004dd8:	01042703          	lw	a4,16(s0)
80004ddc:	00c42683          	lw	a3,12(s0)
80004de0:	00842603          	lw	a2,8(s0)
80004de4:	00442583          	lw	a1,4(s0)
80004de8:	00042503          	lw	a0,0(s0)
80004dec:	bf9ff0ef          	jal	ra,800049e4 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004df0:	00042783          	lw	a5,0(s0)
80004df4:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004df8:	03040413          	addi	s0,s0,48
80004dfc:	f95ff06f          	j	80004d90 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004e00:	02442583          	lw	a1,36(s0)
80004e04:	00958663          	beq	a1,s1,80004e10 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004e08:	00042503          	lw	a0,0(s0)
80004e0c:	e41ff0ef          	jal	ra,80004c4c <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004e10:	03040413          	addi	s0,s0,48
80004e14:	f8dff06f          	j	80004da0 <z_init_static_threads+0x38>

80004e18 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004e18:	fe010113          	addi	sp,sp,-32
80004e1c:	00812c23          	sw	s0,24(sp)
80004e20:	00912a23          	sw	s1,20(sp)
80004e24:	00112e23          	sw	ra,28(sp)
80004e28:	01212823          	sw	s2,16(sp)
80004e2c:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004e30:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e34:	00800413          	li	s0,8
80004e38:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e3c:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004e40:	00847413          	andi	s0,s0,8
80004e44:	c6dff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80004e48:	02051e63          	bnez	a0,80004e84 <z_impl_k_thread_abort+0x6c>
80004e4c:	80007937          	lui	s2,0x80007
80004e50:	800075b7          	lui	a1,0x80007
80004e54:	80007537          	lui	a0,0x80007
80004e58:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80004e5c:	04e00693          	li	a3,78
80004e60:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80004e64:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004e68:	c04fd0ef          	jal	ra,8000226c <printk>
80004e6c:	80007537          	lui	a0,0x80007
80004e70:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80004e74:	bf8fd0ef          	jal	ra,8000226c <printk>
80004e78:	04e00593          	li	a1,78
80004e7c:	b6490513          	addi	a0,s2,-1180
80004e80:	c28fd0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004e84:	00c10513          	addi	a0,sp,12
80004e88:	c81ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004e8c:	00c4c783          	lbu	a5,12(s1)
80004e90:	0017f793          	andi	a5,a5,1
80004e94:	02078e63          	beqz	a5,80004ed0 <z_impl_k_thread_abort+0xb8>
80004e98:	80007937          	lui	s2,0x80007
80004e9c:	800075b7          	lui	a1,0x80007
80004ea0:	80007537          	lui	a0,0x80007
80004ea4:	f8858593          	addi	a1,a1,-120 # 80006f88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f89>
80004ea8:	02900693          	li	a3,41
80004eac:	f7090613          	addi	a2,s2,-144 # 80006f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f71>
80004eb0:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80004eb4:	bb8fd0ef          	jal	ra,8000226c <printk>
80004eb8:	80007537          	lui	a0,0x80007
80004ebc:	fbc50513          	addi	a0,a0,-68 # 80006fbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fbd>
80004ec0:	bacfd0ef          	jal	ra,8000226c <printk>
80004ec4:	02900593          	li	a1,41
80004ec8:	f7090513          	addi	a0,s2,-144
80004ecc:	bdcfd0ef          	jal	ra,800022a8 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004ed0:	00048513          	mv	a0,s1
80004ed4:	b4dff0ef          	jal	ra,80004a20 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004ed8:	00040593          	mv	a1,s0
80004edc:	00c10513          	addi	a0,sp,12
80004ee0:	bbcfe0ef          	jal	ra,8000329c <z_reschedule>
}
80004ee4:	01c12083          	lw	ra,28(sp)
80004ee8:	01812403          	lw	s0,24(sp)
80004eec:	01412483          	lw	s1,20(sp)
80004ef0:	01012903          	lw	s2,16(sp)
80004ef4:	02010113          	addi	sp,sp,32
80004ef8:	00008067          	ret

80004efc <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004efc:	800077b7          	lui	a5,0x80007
80004f00:	30c7a783          	lw	a5,780(a5) # 8000730c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000730d>
80004f04:	00079463          	bnez	a5,80004f0c <elapsed+0x10>
80004f08:	ff0fd06f          	j	800026f8 <z_clock_elapsed>
}
80004f0c:	00000513          	li	a0,0
80004f10:	00008067          	ret

80004f14 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004f14:	00052783          	lw	a5,0(a0)
80004f18:	02050263          	beqz	a0,80004f3c <remove_timeout+0x28>
80004f1c:	80007737          	lui	a4,0x80007
	return (node == list->tail) ? NULL : node->next;
80004f20:	17472703          	lw	a4,372(a4) # 80007174 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007175>
80004f24:	00e50c63          	beq	a0,a4,80004f3c <remove_timeout+0x28>
	if (next(t) != NULL) {
80004f28:	00078a63          	beqz	a5,80004f3c <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80004f2c:	0087a703          	lw	a4,8(a5)
80004f30:	00852683          	lw	a3,8(a0)
80004f34:	00d70733          	add	a4,a4,a3
80004f38:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80004f3c:	00452703          	lw	a4,4(a0)
80004f40:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004f44:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004f48:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004f4c:	00052223          	sw	zero,4(a0)
}
80004f50:	00008067          	ret

80004f54 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004f54:	800077b7          	lui	a5,0x80007
80004f58:	3187c783          	lbu	a5,792(a5) # 80007318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007319>
{
80004f5c:	ff010113          	addi	sp,sp,-16
80004f60:	00112623          	sw	ra,12(sp)
80004f64:	00812423          	sw	s0,8(sp)
80004f68:	00912223          	sw	s1,4(sp)
80004f6c:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004f70:	00079663          	bnez	a5,80004f7c <next_timeout+0x28>
80004f74:	80000537          	lui	a0,0x80000
80004f78:	fff54513          	not	a0,a0
	return list->head == list;
80004f7c:	800077b7          	lui	a5,0x80007
80004f80:	17078793          	addi	a5,a5,368 # 80007170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007171>
80004f84:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004f88:	02f40463          	beq	s0,a5,80004fb0 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004f8c:	02040263          	beqz	s0,80004fb0 <next_timeout+0x5c>
80004f90:	00842483          	lw	s1,8(s0)
80004f94:	f69ff0ef          	jal	ra,80004efc <elapsed>
80004f98:	40a484b3          	sub	s1,s1,a0
80004f9c:	00000513          	li	a0,0
80004fa0:	0004c863          	bltz	s1,80004fb0 <next_timeout+0x5c>
80004fa4:	00842403          	lw	s0,8(s0)
80004fa8:	f55ff0ef          	jal	ra,80004efc <elapsed>
80004fac:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004fb0:	800077b7          	lui	a5,0x80007
80004fb4:	50c7a783          	lw	a5,1292(a5) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
80004fb8:	00078663          	beqz	a5,80004fc4 <next_timeout+0x70>
80004fbc:	00a7d463          	bge	a5,a0,80004fc4 <next_timeout+0x70>
80004fc0:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004fc4:	00c12083          	lw	ra,12(sp)
80004fc8:	00812403          	lw	s0,8(sp)
80004fcc:	00412483          	lw	s1,4(sp)
80004fd0:	01010113          	addi	sp,sp,16
80004fd4:	00008067          	ret

80004fd8 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004fd8:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004fdc:	fd010113          	addi	sp,sp,-48
80004fe0:	02812423          	sw	s0,40(sp)
80004fe4:	02912223          	sw	s1,36(sp)
80004fe8:	01312e23          	sw	s3,28(sp)
80004fec:	02112623          	sw	ra,44(sp)
80004ff0:	03212023          	sw	s2,32(sp)
80004ff4:	01412c23          	sw	s4,24(sp)
80004ff8:	01512a23          	sw	s5,20(sp)
80004ffc:	01612823          	sw	s6,16(sp)
80005000:	01712623          	sw	s7,12(sp)
80005004:	01812423          	sw	s8,8(sp)
80005008:	00050413          	mv	s0,a0
8000500c:	00058993          	mv	s3,a1
80005010:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005014:	02078e63          	beqz	a5,80005050 <z_add_timeout+0x78>
80005018:	80007937          	lui	s2,0x80007
8000501c:	800075b7          	lui	a1,0x80007
80005020:	80007537          	lui	a0,0x80007
80005024:	fec58593          	addi	a1,a1,-20 # 80006fec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fed>
80005028:	04d00693          	li	a3,77
8000502c:	fd890613          	addi	a2,s2,-40 # 80006fd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fd9>
80005030:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005034:	a38fd0ef          	jal	ra,8000226c <printk>
80005038:	80007537          	lui	a0,0x80007
8000503c:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80005040:	a2cfd0ef          	jal	ra,8000226c <printk>
80005044:	04d00593          	li	a1,77
80005048:	fd890513          	addi	a0,s2,-40
8000504c:	a5cfd0ef          	jal	ra,800022a8 <assert_post_action>
	to->fn = fn;
80005050:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80005054:	00904463          	bgtz	s1,8000505c <z_add_timeout+0x84>
80005058:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000505c:	00800993          	li	s3,8
80005060:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005064:	80007a37          	lui	s4,0x80007
80005068:	310a0513          	addi	a0,s4,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	key = (mstatus & SOC_MSTATUS_IEN);
8000506c:	0089f993          	andi	s3,s3,8
80005070:	a41ff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005074:	02051e63          	bnez	a0,800050b0 <z_add_timeout+0xd8>
80005078:	80007937          	lui	s2,0x80007
8000507c:	800075b7          	lui	a1,0x80007
80005080:	80007537          	lui	a0,0x80007
80005084:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005088:	04e00693          	li	a3,78
8000508c:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005090:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005094:	9d8fd0ef          	jal	ra,8000226c <printk>
80005098:	80007537          	lui	a0,0x80007
8000509c:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
800050a0:	9ccfd0ef          	jal	ra,8000226c <printk>
800050a4:	04e00593          	li	a1,78
800050a8:	b6490513          	addi	a0,s2,-1180
800050ac:	9fcfd0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800050b0:	310a0513          	addi	a0,s4,784
800050b4:	a55ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
800050b8:	e45ff0ef          	jal	ra,80004efc <elapsed>
800050bc:	00950533          	add	a0,a0,s1
	return list->head == list;
800050c0:	800074b7          	lui	s1,0x80007
800050c4:	1704a903          	lw	s2,368(s1) # 80007170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007171>
800050c8:	00a42423          	sw	a0,8(s0)
800050cc:	17048493          	addi	s1,s1,368
	return sys_dlist_is_empty(list) ? NULL : list->head;
800050d0:	00990c63          	beq	s2,s1,800050e8 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
800050d4:	80007ab7          	lui	s5,0x80007
800050d8:	80007b37          	lui	s6,0x80007
800050dc:	80007bb7          	lui	s7,0x80007
800050e0:	80007c37          	lui	s8,0x80007
		for (t = first(); t != NULL; t = next(t)) {
800050e4:	02091063          	bnez	s2,80005104 <z_add_timeout+0x12c>
	node->prev = list->tail;
800050e8:	0044a783          	lw	a5,4(s1)
	node->next = list;
800050ec:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800050f0:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800050f4:	0044a783          	lw	a5,4(s1)
800050f8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800050fc:	0084a223          	sw	s0,4(s1)
80005100:	05c0006f          	j	8000515c <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80005104:	00892783          	lw	a5,8(s2)
80005108:	0207d663          	bgez	a5,80005134 <z_add_timeout+0x15c>
8000510c:	00cb0593          	addi	a1,s6,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80005110:	05600693          	li	a3,86
80005114:	fd8a8613          	addi	a2,s5,-40 # 80006fd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fd9>
80005118:	adcb8513          	addi	a0,s7,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000511c:	950fd0ef          	jal	ra,8000226c <printk>
80005120:	d8cc0513          	addi	a0,s8,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80005124:	948fd0ef          	jal	ra,8000226c <printk>
80005128:	05600593          	li	a1,86
8000512c:	fd8a8513          	addi	a0,s5,-40
80005130:	978fd0ef          	jal	ra,800022a8 <assert_post_action>

			if (t->dticks > to->dticks) {
80005134:	00892703          	lw	a4,8(s2)
80005138:	00842783          	lw	a5,8(s0)
8000513c:	0ae7d863          	bge	a5,a4,800051ec <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80005140:	40f707b3          	sub	a5,a4,a5
80005144:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80005148:	00492783          	lw	a5,4(s2)
	node->next = successor;
8000514c:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80005150:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80005154:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80005158:	00892223          	sw	s0,4(s2)
	return list->head == list;
8000515c:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005160:	00978a63          	beq	a5,s1,80005174 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80005164:	00f41863          	bne	s0,a5,80005174 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80005168:	dedff0ef          	jal	ra,80004f54 <next_timeout>
8000516c:	00000593          	li	a1,0
80005170:	c0cfd0ef          	jal	ra,8000257c <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005174:	310a0513          	addi	a0,s4,784
80005178:	961ff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000517c:	02051e63          	bnez	a0,800051b8 <z_add_timeout+0x1e0>
80005180:	80007437          	lui	s0,0x80007
80005184:	800075b7          	lui	a1,0x80007
80005188:	80007537          	lui	a0,0x80007
8000518c:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80005190:	06100693          	li	a3,97
80005194:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005198:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000519c:	8d0fd0ef          	jal	ra,8000226c <printk>
800051a0:	80007537          	lui	a0,0x80007
800051a4:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800051a8:	8c4fd0ef          	jal	ra,8000226c <printk>
800051ac:	06100593          	li	a1,97
800051b0:	b6440513          	addi	a0,s0,-1180
800051b4:	8f4fd0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800051b8:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
800051bc:	02c12083          	lw	ra,44(sp)
800051c0:	02812403          	lw	s0,40(sp)
800051c4:	02412483          	lw	s1,36(sp)
800051c8:	02012903          	lw	s2,32(sp)
800051cc:	01c12983          	lw	s3,28(sp)
800051d0:	01812a03          	lw	s4,24(sp)
800051d4:	01412a83          	lw	s5,20(sp)
800051d8:	01012b03          	lw	s6,16(sp)
800051dc:	00c12b83          	lw	s7,12(sp)
800051e0:	00812c03          	lw	s8,8(sp)
800051e4:	03010113          	addi	sp,sp,48
800051e8:	00008067          	ret
			to->dticks -= t->dticks;
800051ec:	40e787b3          	sub	a5,a5,a4
800051f0:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
800051f4:	0044a783          	lw	a5,4(s1)
800051f8:	ef2788e3          	beq	a5,s2,800050e8 <z_add_timeout+0x110>
800051fc:	00092903          	lw	s2,0(s2)
80005200:	ee5ff06f          	j	800050e4 <z_add_timeout+0x10c>

80005204 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80005204:	fe010113          	addi	sp,sp,-32
80005208:	00812c23          	sw	s0,24(sp)
8000520c:	01312623          	sw	s3,12(sp)
80005210:	00112e23          	sw	ra,28(sp)
80005214:	00912a23          	sw	s1,20(sp)
80005218:	01212823          	sw	s2,16(sp)
8000521c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005220:	00800413          	li	s0,8
80005224:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005228:	800074b7          	lui	s1,0x80007
8000522c:	31048513          	addi	a0,s1,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	key = (mstatus & SOC_MSTATUS_IEN);
80005230:	00847413          	andi	s0,s0,8
80005234:	87dff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005238:	02051e63          	bnez	a0,80005274 <z_abort_timeout+0x70>
8000523c:	80007937          	lui	s2,0x80007
80005240:	800075b7          	lui	a1,0x80007
80005244:	80007537          	lui	a0,0x80007
80005248:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
8000524c:	04e00693          	li	a3,78
80005250:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005254:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005258:	814fd0ef          	jal	ra,8000226c <printk>
8000525c:	80007537          	lui	a0,0x80007
80005260:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80005264:	808fd0ef          	jal	ra,8000226c <printk>
80005268:	04e00593          	li	a1,78
8000526c:	b6490513          	addi	a0,s2,-1180
80005270:	838fd0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005274:	31048513          	addi	a0,s1,784
80005278:	891ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
8000527c:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80005280:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80005284:	00078863          	beqz	a5,80005294 <z_abort_timeout+0x90>
			remove_timeout(to);
80005288:	00098513          	mv	a0,s3
8000528c:	c89ff0ef          	jal	ra,80004f14 <remove_timeout>
			ret = 0;
80005290:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005294:	31048513          	addi	a0,s1,784
80005298:	841ff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000529c:	02051e63          	bnez	a0,800052d8 <z_abort_timeout+0xd4>
800052a0:	800074b7          	lui	s1,0x80007
800052a4:	800075b7          	lui	a1,0x80007
800052a8:	80007537          	lui	a0,0x80007
800052ac:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800052b0:	06100693          	li	a3,97
800052b4:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800052b8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800052bc:	fb1fc0ef          	jal	ra,8000226c <printk>
800052c0:	80007537          	lui	a0,0x80007
800052c4:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800052c8:	fa5fc0ef          	jal	ra,8000226c <printk>
800052cc:	06100593          	li	a1,97
800052d0:	b6448513          	addi	a0,s1,-1180
800052d4:	fd5fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800052d8:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
800052dc:	01c12083          	lw	ra,28(sp)
800052e0:	01812403          	lw	s0,24(sp)
800052e4:	00090513          	mv	a0,s2
800052e8:	01412483          	lw	s1,20(sp)
800052ec:	01012903          	lw	s2,16(sp)
800052f0:	00c12983          	lw	s3,12(sp)
800052f4:	02010113          	addi	sp,sp,32
800052f8:	00008067          	ret

800052fc <z_timeout_remaining>:

s32_t z_timeout_remaining(struct _timeout *timeout)
{
	s32_t ticks = 0;

	if (z_is_inactive_timeout(timeout)) {
800052fc:	00052783          	lw	a5,0(a0)
80005300:	12078063          	beqz	a5,80005420 <z_timeout_remaining+0x124>
{
80005304:	fe010113          	addi	sp,sp,-32
80005308:	00912a23          	sw	s1,20(sp)
8000530c:	01312623          	sw	s3,12(sp)
80005310:	00112e23          	sw	ra,28(sp)
80005314:	00812c23          	sw	s0,24(sp)
80005318:	01212823          	sw	s2,16(sp)
8000531c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005320:	00800493          	li	s1,8
80005324:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005328:	80007937          	lui	s2,0x80007
8000532c:	31090513          	addi	a0,s2,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	key = (mstatus & SOC_MSTATUS_IEN);
80005330:	0084f493          	andi	s1,s1,8
80005334:	f7cff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005338:	02051e63          	bnez	a0,80005374 <z_timeout_remaining+0x78>
8000533c:	80007437          	lui	s0,0x80007
80005340:	800075b7          	lui	a1,0x80007
80005344:	80007537          	lui	a0,0x80007
80005348:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
8000534c:	04e00693          	li	a3,78
80005350:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005354:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005358:	f15fc0ef          	jal	ra,8000226c <printk>
8000535c:	80007537          	lui	a0,0x80007
80005360:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80005364:	f09fc0ef          	jal	ra,8000226c <printk>
80005368:	04e00593          	li	a1,78
8000536c:	b6440513          	addi	a0,s0,-1180
80005370:	f39fc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005374:	31090513          	addi	a0,s2,784
80005378:	f90ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	return list->head == list;
8000537c:	80007737          	lui	a4,0x80007
80005380:	17070713          	addi	a4,a4,368 # 80007170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007171>
80005384:	00072783          	lw	a5,0(a4)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005388:	00000413          	li	s0,0
8000538c:	00e78663          	beq	a5,a4,80005398 <z_timeout_remaining+0x9c>
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80005390:	00472703          	lw	a4,4(a4)
		return 0;
	}

	LOCKED(&timeout_lock) {
		for (struct _timeout *t = first(); t != NULL; t = next(t)) {
80005394:	06079863          	bnez	a5,80005404 <z_timeout_remaining+0x108>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005398:	31090513          	addi	a0,s2,784
8000539c:	f3cff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800053a0:	02051e63          	bnez	a0,800053dc <z_timeout_remaining+0xe0>
800053a4:	80007937          	lui	s2,0x80007
800053a8:	800075b7          	lui	a1,0x80007
800053ac:	80007537          	lui	a0,0x80007
800053b0:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800053b4:	06100693          	li	a3,97
800053b8:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800053bc:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800053c0:	eadfc0ef          	jal	ra,8000226c <printk>
800053c4:	80007537          	lui	a0,0x80007
800053c8:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800053cc:	ea1fc0ef          	jal	ra,8000226c <printk>
800053d0:	06100593          	li	a1,97
800053d4:	b6490513          	addi	a0,s2,-1180
800053d8:	ed1fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800053dc:	3004a4f3          	csrrs	s1,mstatus,s1
				break;
			}
		}
	}

	return ticks - elapsed();
800053e0:	b1dff0ef          	jal	ra,80004efc <elapsed>
800053e4:	40a40533          	sub	a0,s0,a0
}
800053e8:	01c12083          	lw	ra,28(sp)
800053ec:	01812403          	lw	s0,24(sp)
800053f0:	01412483          	lw	s1,20(sp)
800053f4:	01012903          	lw	s2,16(sp)
800053f8:	00c12983          	lw	s3,12(sp)
800053fc:	02010113          	addi	sp,sp,32
80005400:	00008067          	ret
			ticks += t->dticks;
80005404:	0087a683          	lw	a3,8(a5)
80005408:	00d40433          	add	s0,s0,a3
			if (timeout == t) {
8000540c:	f93786e3          	beq	a5,s3,80005398 <z_timeout_remaining+0x9c>
80005410:	f80784e3          	beqz	a5,80005398 <z_timeout_remaining+0x9c>
	return (node == list->tail) ? NULL : node->next;
80005414:	f8e782e3          	beq	a5,a4,80005398 <z_timeout_remaining+0x9c>
80005418:	0007a783          	lw	a5,0(a5)
8000541c:	f79ff06f          	j	80005394 <z_timeout_remaining+0x98>
		return 0;
80005420:	00000513          	li	a0,0
}
80005424:	00008067          	ret

80005428 <z_get_next_timeout_expiry>:

s32_t z_get_next_timeout_expiry(void)
{
80005428:	ff010113          	addi	sp,sp,-16
8000542c:	00812423          	sw	s0,8(sp)
80005430:	00112623          	sw	ra,12(sp)
80005434:	00912223          	sw	s1,4(sp)
80005438:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000543c:	00800413          	li	s0,8
80005440:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005444:	800074b7          	lui	s1,0x80007
80005448:	31048513          	addi	a0,s1,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	key = (mstatus & SOC_MSTATUS_IEN);
8000544c:	00847413          	andi	s0,s0,8
80005450:	e60ff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005454:	02051e63          	bnez	a0,80005490 <z_get_next_timeout_expiry+0x68>
80005458:	80007937          	lui	s2,0x80007
8000545c:	800075b7          	lui	a1,0x80007
80005460:	80007537          	lui	a0,0x80007
80005464:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005468:	04e00693          	li	a3,78
8000546c:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005470:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005474:	df9fc0ef          	jal	ra,8000226c <printk>
80005478:	80007537          	lui	a0,0x80007
8000547c:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80005480:	dedfc0ef          	jal	ra,8000226c <printk>
80005484:	04e00593          	li	a1,78
80005488:	b6490513          	addi	a0,s2,-1180
8000548c:	e1dfc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005490:	31048513          	addi	a0,s1,784
80005494:	e74ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80005498:	abdff0ef          	jal	ra,80004f54 <next_timeout>
8000549c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800054a0:	31048513          	addi	a0,s1,784
800054a4:	e34ff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800054a8:	02051e63          	bnez	a0,800054e4 <z_get_next_timeout_expiry+0xbc>
800054ac:	800074b7          	lui	s1,0x80007
800054b0:	800075b7          	lui	a1,0x80007
800054b4:	80007537          	lui	a0,0x80007
800054b8:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800054bc:	06100693          	li	a3,97
800054c0:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800054c4:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800054c8:	da5fc0ef          	jal	ra,8000226c <printk>
800054cc:	80007537          	lui	a0,0x80007
800054d0:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800054d4:	d99fc0ef          	jal	ra,8000226c <printk>
800054d8:	06100593          	li	a1,97
800054dc:	b6448513          	addi	a0,s1,-1180
800054e0:	dc9fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800054e4:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800054e8:	00c12083          	lw	ra,12(sp)
800054ec:	00812403          	lw	s0,8(sp)
800054f0:	00090513          	mv	a0,s2
800054f4:	00412483          	lw	s1,4(sp)
800054f8:	00012903          	lw	s2,0(sp)
800054fc:	01010113          	addi	sp,sp,16
80005500:	00008067          	ret

80005504 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80005504:	fe010113          	addi	sp,sp,-32
80005508:	00812c23          	sw	s0,24(sp)
8000550c:	01212823          	sw	s2,16(sp)
80005510:	01412423          	sw	s4,8(sp)
80005514:	00112e23          	sw	ra,28(sp)
80005518:	00912a23          	sw	s1,20(sp)
8000551c:	01312623          	sw	s3,12(sp)
80005520:	00050913          	mv	s2,a0
80005524:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005528:	00800413          	li	s0,8
8000552c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005530:	800074b7          	lui	s1,0x80007
80005534:	31048513          	addi	a0,s1,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	key = (mstatus & SOC_MSTATUS_IEN);
80005538:	00847413          	andi	s0,s0,8
8000553c:	d74ff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005540:	02051e63          	bnez	a0,8000557c <z_set_timeout_expiry+0x78>
80005544:	800079b7          	lui	s3,0x80007
80005548:	800075b7          	lui	a1,0x80007
8000554c:	80007537          	lui	a0,0x80007
80005550:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005554:	04e00693          	li	a3,78
80005558:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
8000555c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005560:	d0dfc0ef          	jal	ra,8000226c <printk>
80005564:	80007537          	lui	a0,0x80007
80005568:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
8000556c:	d01fc0ef          	jal	ra,8000226c <printk>
80005570:	04e00593          	li	a1,78
80005574:	b6498513          	addi	a0,s3,-1180
80005578:	d31fc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000557c:	31048513          	addi	a0,s1,784
80005580:	d88ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80005584:	9d1ff0ef          	jal	ra,80004f54 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80005588:	00a95c63          	bge	s2,a0,800055a0 <z_set_timeout_expiry+0x9c>
8000558c:	00100793          	li	a5,1
80005590:	00a7d863          	bge	a5,a0,800055a0 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80005594:	000a0593          	mv	a1,s4
80005598:	00090513          	mv	a0,s2
8000559c:	fe1fc0ef          	jal	ra,8000257c <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800055a0:	31048513          	addi	a0,s1,784
800055a4:	d34ff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800055a8:	02051e63          	bnez	a0,800055e4 <z_set_timeout_expiry+0xe0>
800055ac:	800074b7          	lui	s1,0x80007
800055b0:	800075b7          	lui	a1,0x80007
800055b4:	80007537          	lui	a0,0x80007
800055b8:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800055bc:	06100693          	li	a3,97
800055c0:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800055c4:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800055c8:	ca5fc0ef          	jal	ra,8000226c <printk>
800055cc:	80007537          	lui	a0,0x80007
800055d0:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800055d4:	c99fc0ef          	jal	ra,8000226c <printk>
800055d8:	06100593          	li	a1,97
800055dc:	b6448513          	addi	a0,s1,-1180
800055e0:	cc9fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800055e4:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800055e8:	01c12083          	lw	ra,28(sp)
800055ec:	01812403          	lw	s0,24(sp)
800055f0:	01412483          	lw	s1,20(sp)
800055f4:	01012903          	lw	s2,16(sp)
800055f8:	00c12983          	lw	s3,12(sp)
800055fc:	00812a03          	lw	s4,8(sp)
80005600:	02010113          	addi	sp,sp,32
80005604:	00008067          	ret

80005608 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80005608:	fd010113          	addi	sp,sp,-48
8000560c:	02812423          	sw	s0,40(sp)
80005610:	01412c23          	sw	s4,24(sp)
80005614:	02112623          	sw	ra,44(sp)
80005618:	02912223          	sw	s1,36(sp)
8000561c:	03212023          	sw	s2,32(sp)
80005620:	01312e23          	sw	s3,28(sp)
80005624:	01512a23          	sw	s5,20(sp)
80005628:	01612823          	sw	s6,16(sp)
8000562c:	01712623          	sw	s7,12(sp)
80005630:	01812423          	sw	s8,8(sp)
80005634:	01912223          	sw	s9,4(sp)
80005638:	01a12023          	sw	s10,0(sp)
8000563c:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005640:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80005644:	e34fe0ef          	jal	ra,80003c78 <z_time_slice>
80005648:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000564c:	80007937          	lui	s2,0x80007
80005650:	31090513          	addi	a0,s2,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	key = (mstatus & SOC_MSTATUS_IEN);
80005654:	00847413          	andi	s0,s0,8
80005658:	c58ff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
8000565c:	02051e63          	bnez	a0,80005698 <z_clock_announce+0x90>
80005660:	800074b7          	lui	s1,0x80007
80005664:	800075b7          	lui	a1,0x80007
80005668:	80007537          	lui	a0,0x80007
8000566c:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005670:	04e00693          	li	a3,78
80005674:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005678:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000567c:	bf1fc0ef          	jal	ra,8000226c <printk>
80005680:	80007537          	lui	a0,0x80007
80005684:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80005688:	be5fc0ef          	jal	ra,8000226c <printk>
8000568c:	04e00593          	li	a1,78
80005690:	b6448513          	addi	a0,s1,-1180
80005694:	c15fc0ef          	jal	ra,800022a8 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80005698:	800079b7          	lui	s3,0x80007
	z_spin_lock_set_owner(l);
8000569c:	31090513          	addi	a0,s2,784
800056a0:	c68ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
800056a4:	800074b7          	lui	s1,0x80007
800056a8:	3149a623          	sw	s4,780(s3) # 8000730c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000730d>
	return list->head == list;
800056ac:	80007a37          	lui	s4,0x80007
800056b0:	30c98993          	addi	s3,s3,780
800056b4:	170a0a13          	addi	s4,s4,368 # 80007170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007171>
800056b8:	2d848493          	addi	s1,s1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800056bc:	80007ab7          	lui	s5,0x80007
800056c0:	80007bb7          	lui	s7,0x80007
800056c4:	80007b37          	lui	s6,0x80007
800056c8:	80007c37          	lui	s8,0x80007
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800056cc:	80007cb7          	lui	s9,0x80007
800056d0:	000a2d03          	lw	s10,0(s4)
800056d4:	0009a783          	lw	a5,0(s3)
800056d8:	0004a683          	lw	a3,0(s1)
800056dc:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800056e0:	014d0c63          	beq	s10,s4,800056f8 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
800056e4:	000d0a63          	beqz	s10,800056f8 <z_clock_announce+0xf0>
800056e8:	008d2703          	lw	a4,8(s10)
800056ec:	0ae7dc63          	bge	a5,a4,800057a4 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
800056f0:	40f70733          	sub	a4,a4,a5
800056f4:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
800056f8:	00d786b3          	add	a3,a5,a3
800056fc:	41f7d713          	srai	a4,a5,0x1f
80005700:	00a70733          	add	a4,a4,a0
80005704:	00f6b7b3          	sltu	a5,a3,a5
80005708:	00e787b3          	add	a5,a5,a4
8000570c:	00d4a023          	sw	a3,0(s1)
80005710:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005714:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80005718:	83dff0ef          	jal	ra,80004f54 <next_timeout>
8000571c:	00000593          	li	a1,0
80005720:	e5dfc0ef          	jal	ra,8000257c <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005724:	31090513          	addi	a0,s2,784
80005728:	bb0ff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
8000572c:	02051e63          	bnez	a0,80005768 <z_clock_announce+0x160>
80005730:	800074b7          	lui	s1,0x80007
80005734:	800075b7          	lui	a1,0x80007
80005738:	80007537          	lui	a0,0x80007
8000573c:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80005740:	06100693          	li	a3,97
80005744:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005748:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
8000574c:	b21fc0ef          	jal	ra,8000226c <printk>
80005750:	80007537          	lui	a0,0x80007
80005754:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80005758:	b15fc0ef          	jal	ra,8000226c <printk>
8000575c:	06100593          	li	a1,97
80005760:	b6448513          	addi	a0,s1,-1180
80005764:	b45fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005768:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
8000576c:	02c12083          	lw	ra,44(sp)
80005770:	02812403          	lw	s0,40(sp)
80005774:	02412483          	lw	s1,36(sp)
80005778:	02012903          	lw	s2,32(sp)
8000577c:	01c12983          	lw	s3,28(sp)
80005780:	01812a03          	lw	s4,24(sp)
80005784:	01412a83          	lw	s5,20(sp)
80005788:	01012b03          	lw	s6,16(sp)
8000578c:	00c12b83          	lw	s7,12(sp)
80005790:	00812c03          	lw	s8,8(sp)
80005794:	00412c83          	lw	s9,4(sp)
80005798:	00012d03          	lw	s10,0(sp)
8000579c:	03010113          	addi	sp,sp,48
800057a0:	00008067          	ret
		curr_tick += dt;
800057a4:	00d706b3          	add	a3,a4,a3
800057a8:	41f75593          	srai	a1,a4,0x1f
800057ac:	00a585b3          	add	a1,a1,a0
800057b0:	00e6b633          	sltu	a2,a3,a4
800057b4:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
800057b8:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
800057bc:	000d0513          	mv	a0,s10
		t->dticks = 0;
800057c0:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
800057c4:	00d4a023          	sw	a3,0(s1)
800057c8:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
800057cc:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
800057d0:	f44ff0ef          	jal	ra,80004f14 <remove_timeout>
800057d4:	31090513          	addi	a0,s2,784
800057d8:	b00ff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
800057dc:	02051663          	bnez	a0,80005808 <z_clock_announce+0x200>
800057e0:	bacb8593          	addi	a1,s7,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
800057e4:	06100693          	li	a3,97
800057e8:	b64a8613          	addi	a2,s5,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800057ec:	adcb0513          	addi	a0,s6,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800057f0:	a7dfc0ef          	jal	ra,8000226c <printk>
800057f4:	bc4c0513          	addi	a0,s8,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
800057f8:	a75fc0ef          	jal	ra,8000226c <printk>
800057fc:	06100593          	li	a1,97
80005800:	b64a8513          	addi	a0,s5,-1180
80005804:	aa5fc0ef          	jal	ra,800022a8 <assert_post_action>
80005808:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
8000580c:	00cd2783          	lw	a5,12(s10)
80005810:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005814:	00800413          	li	s0,8
80005818:	000780e7          	jalr	a5
8000581c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005820:	31090513          	addi	a0,s2,784
	key = (mstatus & SOC_MSTATUS_IEN);
80005824:	00847413          	andi	s0,s0,8
80005828:	a88ff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
8000582c:	02051863          	bnez	a0,8000585c <z_clock_announce+0x254>
80005830:	b7cc8593          	addi	a1,s9,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005834:	04e00693          	li	a3,78
80005838:	b64a8613          	addi	a2,s5,-1180
8000583c:	adcb0513          	addi	a0,s6,-1316
80005840:	a2dfc0ef          	jal	ra,8000226c <printk>
80005844:	80007537          	lui	a0,0x80007
80005848:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
8000584c:	a21fc0ef          	jal	ra,8000226c <printk>
80005850:	04e00593          	li	a1,78
80005854:	b64a8513          	addi	a0,s5,-1180
80005858:	a51fc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000585c:	31090513          	addi	a0,s2,784
80005860:	aa8ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	return k;
80005864:	e6dff06f          	j	800056d0 <z_clock_announce+0xc8>

80005868 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80005868:	fe010113          	addi	sp,sp,-32
8000586c:	00912a23          	sw	s1,20(sp)
80005870:	00112e23          	sw	ra,28(sp)
80005874:	00812c23          	sw	s0,24(sp)
80005878:	01212823          	sw	s2,16(sp)
8000587c:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005880:	00800493          	li	s1,8
80005884:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005888:	80007937          	lui	s2,0x80007
8000588c:	31090513          	addi	a0,s2,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	key = (mstatus & SOC_MSTATUS_IEN);
80005890:	0084f493          	andi	s1,s1,8
80005894:	a1cff0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005898:	02051e63          	bnez	a0,800058d4 <z_tick_get+0x6c>
8000589c:	80007437          	lui	s0,0x80007
800058a0:	800075b7          	lui	a1,0x80007
800058a4:	80007537          	lui	a0,0x80007
800058a8:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
800058ac:	04e00693          	li	a3,78
800058b0:	b6440613          	addi	a2,s0,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
800058b4:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
800058b8:	9b5fc0ef          	jal	ra,8000226c <printk>
800058bc:	80007537          	lui	a0,0x80007
800058c0:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
800058c4:	9a9fc0ef          	jal	ra,8000226c <printk>
800058c8:	04e00593          	li	a1,78
800058cc:	b6440513          	addi	a0,s0,-1180
800058d0:	9d9fc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800058d4:	31090513          	addi	a0,s2,784
800058d8:	a30ff0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
800058dc:	e1dfc0ef          	jal	ra,800026f8 <z_clock_elapsed>
800058e0:	800077b7          	lui	a5,0x80007
800058e4:	2d878793          	addi	a5,a5,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800058e8:	0007a983          	lw	s3,0(a5)
800058ec:	0047a403          	lw	s0,4(a5)
800058f0:	013509b3          	add	s3,a0,s3
800058f4:	00a9b533          	sltu	a0,s3,a0
800058f8:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800058fc:	31090513          	addi	a0,s2,784
80005900:	9d8ff0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80005904:	02051e63          	bnez	a0,80005940 <z_tick_get+0xd8>
80005908:	80007937          	lui	s2,0x80007
8000590c:	800075b7          	lui	a1,0x80007
80005910:	80007537          	lui	a0,0x80007
80005914:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80005918:	06100693          	li	a3,97
8000591c:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005920:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005924:	949fc0ef          	jal	ra,8000226c <printk>
80005928:	80007537          	lui	a0,0x80007
8000592c:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80005930:	93dfc0ef          	jal	ra,8000226c <printk>
80005934:	06100593          	li	a1,97
80005938:	b6490513          	addi	a0,s2,-1180
8000593c:	96dfc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005940:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80005944:	00040593          	mv	a1,s0
80005948:	01c12083          	lw	ra,28(sp)
8000594c:	01812403          	lw	s0,24(sp)
80005950:	00098513          	mv	a0,s3
80005954:	01412483          	lw	s1,20(sp)
80005958:	01012903          	lw	s2,16(sp)
8000595c:	00c12983          	lw	s3,12(sp)
80005960:	02010113          	addi	sp,sp,32
80005964:	00008067          	ret

80005968 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80005968:	ff010113          	addi	sp,sp,-16
8000596c:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80005970:	ef9ff0ef          	jal	ra,80005868 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80005974:	00c12083          	lw	ra,12(sp)
80005978:	01010113          	addi	sp,sp,16
8000597c:	00008067          	ret

80005980 <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
80005980:	ff010113          	addi	sp,sp,-16
80005984:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
80005988:	ee1ff0ef          	jal	ra,80005868 <z_tick_get>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000598c:	3e800793          	li	a5,1000
80005990:	02a7b733          	mulhu	a4,a5,a0
80005994:	06400613          	li	a2,100
80005998:	00000693          	li	a3,0
8000599c:	02b785b3          	mul	a1,a5,a1
800059a0:	02a78533          	mul	a0,a5,a0
800059a4:	00e585b3          	add	a1,a1,a4
800059a8:	909fa0ef          	jal	ra,800002b0 <__udivdi3>
}
800059ac:	00c12083          	lw	ra,12(sp)
800059b0:	01010113          	addi	sp,sp,16
800059b4:	00008067          	ret

800059b8 <z_timer_expiration_handler>:

	/*
	 * if the timer is periodic, start it again; don't add _TICK_ALIGN
	 * since we're already aligned to a tick boundary
	 */
	if (timer->period > 0) {
800059b8:	02052603          	lw	a2,32(a0)
{
800059bc:	ff010113          	addi	sp,sp,-16
800059c0:	00812423          	sw	s0,8(sp)
800059c4:	00112623          	sw	ra,12(sp)
800059c8:	00912223          	sw	s1,4(sp)
800059cc:	00050413          	mv	s0,a0
	if (timer->period > 0) {
800059d0:	00c05863          	blez	a2,800059e0 <z_timer_expiration_handler+0x28>
		z_add_timeout(&timer->timeout, z_timer_expiration_handler,
800059d4:	800065b7          	lui	a1,0x80006
800059d8:	9b858593          	addi	a1,a1,-1608 # 800059b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059b9>
800059dc:	dfcff0ef          	jal	ra,80004fd8 <z_add_timeout>
			     timer->period);
	}

	/* update timer's status */
	timer->status += 1U;
800059e0:	02442783          	lw	a5,36(s0)
800059e4:	00178793          	addi	a5,a5,1
800059e8:	02f42223          	sw	a5,36(s0)

	/* invoke timer expiry function */
	if (timer->expiry_fn != NULL) {
800059ec:	01842783          	lw	a5,24(s0)
800059f0:	00078663          	beqz	a5,800059fc <z_timer_expiration_handler+0x44>
		timer->expiry_fn(timer);
800059f4:	00040513          	mv	a0,s0
800059f8:	000780e7          	jalr	a5
	return list->head == list;
800059fc:	01042483          	lw	s1,16(s0)
	sys_dlist_init(&w->waitq);
}

static inline struct k_thread *z_waitq_head(_wait_q_t *w)
{
	return (void *)sys_dlist_peek_head(&w->waitq);
80005a00:	01040413          	addi	s0,s0,16
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005a04:	02848863          	beq	s1,s0,80005a34 <z_timer_expiration_handler+0x7c>
	}

	thread = z_waitq_head(&timer->wait_q);

	if (thread == NULL) {
80005a08:	02048663          	beqz	s1,80005a34 <z_timer_expiration_handler+0x7c>
	 * place a thread can be taken off this pend queue, and b) the
	 * only place a thread can be put on the pend queue is at
	 * thread level, which of course cannot interrupt the current
	 * context.
	 */
	z_unpend_thread_no_timeout(thread);
80005a0c:	00048513          	mv	a0,s1
80005a10:	f90fd0ef          	jal	ra,800031a0 <z_unpend_thread_no_timeout>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005a14:	00d4c783          	lbu	a5,13(s1)
80005a18:	01f7f793          	andi	a5,a5,31
80005a1c:	00079a63          	bnez	a5,80005a30 <z_timer_expiration_handler+0x78>
	if (z_is_thread_ready(thread)) {
80005a20:	0184a783          	lw	a5,24(s1)
80005a24:	00079663          	bnez	a5,80005a30 <z_timer_expiration_handler+0x78>
		z_add_thread_to_ready_q(thread);
80005a28:	00048513          	mv	a0,s1
80005a2c:	dbdfd0ef          	jal	ra,800037e8 <z_add_thread_to_ready_q>
80005a30:	0604a623          	sw	zero,108(s1)

	z_ready_thread(thread);

	z_set_thread_return_value(thread, 0);
}
80005a34:	00c12083          	lw	ra,12(sp)
80005a38:	00812403          	lw	s0,8(sp)
80005a3c:	00412483          	lw	s1,4(sp)
80005a40:	01010113          	addi	sp,sp,16
80005a44:	00008067          	ret

80005a48 <k_timer_init>:
	sys_dlist_init(&w->waitq);
80005a48:	01050793          	addi	a5,a0,16

void k_timer_init(struct k_timer *timer,
			 k_timer_expiry_t expiry_fn,
			 k_timer_stop_t stop_fn)
{
	timer->expiry_fn = expiry_fn;
80005a4c:	00b52c23          	sw	a1,24(a0)
	timer->stop_fn = stop_fn;
80005a50:	00c52e23          	sw	a2,28(a0)
	timer->status = 0U;
80005a54:	02052223          	sw	zero,36(a0)
	list->head = (sys_dnode_t *)list;
80005a58:	00f52823          	sw	a5,16(a0)
	list->tail = (sys_dnode_t *)list;
80005a5c:	00f52a23          	sw	a5,20(a0)
	node->next = NULL;
80005a60:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80005a64:	00052223          	sw	zero,4(a0)

	z_waitq_init(&timer->wait_q);
	z_init_timeout(&timer->timeout, z_timer_expiration_handler);
	SYS_TRACING_OBJ_INIT(k_timer, timer);

	timer->user_data = NULL;
80005a68:	02052423          	sw	zero,40(a0)

	z_object_init(timer);
}
80005a6c:	00008067          	ret

80005a70 <z_impl_k_timer_start>:


void z_impl_k_timer_start(struct k_timer *timer, s32_t duration, s32_t period)
{
80005a70:	fd010113          	addi	sp,sp,-48
80005a74:	02812423          	sw	s0,40(sp)
80005a78:	02912223          	sw	s1,36(sp)
80005a7c:	03212023          	sw	s2,32(sp)
80005a80:	02112623          	sw	ra,44(sp)
80005a84:	01312e23          	sw	s3,28(sp)
80005a88:	00050913          	mv	s2,a0
80005a8c:	00058413          	mv	s0,a1
80005a90:	00060493          	mv	s1,a2
	__ASSERT(duration >= 0 && period >= 0 &&
80005a94:	0005c863          	bltz	a1,80005aa4 <z_impl_k_timer_start+0x34>
80005a98:	00064663          	bltz	a2,80005aa4 <z_impl_k_timer_start+0x34>
80005a9c:	00c5e7b3          	or	a5,a1,a2
80005aa0:	02079e63          	bnez	a5,80005adc <z_impl_k_timer_start+0x6c>
80005aa4:	800079b7          	lui	s3,0x80007
80005aa8:	800075b7          	lui	a1,0x80007
80005aac:	80007537          	lui	a0,0x80007
80005ab0:	03058593          	addi	a1,a1,48 # 80007030 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007031>
80005ab4:	07300693          	li	a3,115
80005ab8:	01c98613          	addi	a2,s3,28 # 8000701c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000701d>
80005abc:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005ac0:	facfc0ef          	jal	ra,8000226c <printk>
80005ac4:	80007537          	lui	a0,0x80007
80005ac8:	07050513          	addi	a0,a0,112 # 80007070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007071>
80005acc:	fa0fc0ef          	jal	ra,8000226c <printk>
80005ad0:	07300593          	li	a1,115
80005ad4:	01c98513          	addi	a0,s3,28
80005ad8:	fd0fc0ef          	jal	ra,800022a8 <assert_post_action>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005adc:	00a00793          	li	a5,10
80005ae0:	00948493          	addi	s1,s1,9
80005ae4:	02f4c4b3          	div	s1,s1,a5
80005ae8:	00940413          	addi	s0,s0,9
	volatile s32_t period_in_ticks, duration_in_ticks;

	period_in_ticks = z_ms_to_ticks(period);
	duration_in_ticks = z_ms_to_ticks(duration);

	(void)z_abort_timeout(&timer->timeout);
80005aec:	00090513          	mv	a0,s2
80005af0:	02f44433          	div	s0,s0,a5
	period_in_ticks = z_ms_to_ticks(period);
80005af4:	00912423          	sw	s1,8(sp)
	duration_in_ticks = z_ms_to_ticks(duration);
80005af8:	00812623          	sw	s0,12(sp)
	(void)z_abort_timeout(&timer->timeout);
80005afc:	f08ff0ef          	jal	ra,80005204 <z_abort_timeout>
	timer->period = period_in_ticks;
80005b00:	00812783          	lw	a5,8(sp)
	timer->status = 0U;
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
		     duration_in_ticks);
}
80005b04:	02812403          	lw	s0,40(sp)
	timer->status = 0U;
80005b08:	02092223          	sw	zero,36(s2)
	timer->period = period_in_ticks;
80005b0c:	02f92023          	sw	a5,32(s2)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005b10:	00c12603          	lw	a2,12(sp)
}
80005b14:	02c12083          	lw	ra,44(sp)
80005b18:	02412483          	lw	s1,36(sp)
80005b1c:	01c12983          	lw	s3,28(sp)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005b20:	00090513          	mv	a0,s2
}
80005b24:	02012903          	lw	s2,32(sp)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005b28:	800065b7          	lui	a1,0x80006
80005b2c:	9b858593          	addi	a1,a1,-1608 # 800059b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059b9>
}
80005b30:	03010113          	addi	sp,sp,48
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005b34:	ca4ff06f          	j	80004fd8 <z_add_timeout>

80005b38 <z_impl_k_timer_stop>:
	return 0;
}
#endif

void z_impl_k_timer_stop(struct k_timer *timer)
{
80005b38:	ff010113          	addi	sp,sp,-16
80005b3c:	00812423          	sw	s0,8(sp)
80005b40:	00112623          	sw	ra,12(sp)
80005b44:	00050413          	mv	s0,a0
	int inactive = z_abort_timeout(&timer->timeout) != 0;
80005b48:	ebcff0ef          	jal	ra,80005204 <z_abort_timeout>

	if (inactive) {
80005b4c:	06051263          	bnez	a0,80005bb0 <z_impl_k_timer_stop+0x78>
		return;
	}

	if (timer->stop_fn != NULL) {
80005b50:	01c42783          	lw	a5,28(s0)
80005b54:	00078663          	beqz	a5,80005b60 <z_impl_k_timer_stop+0x28>
		timer->stop_fn(timer);
80005b58:	00040513          	mv	a0,s0
80005b5c:	000780e7          	jalr	a5
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);
80005b60:	01040513          	addi	a0,s0,16
80005b64:	00000593          	li	a1,0
80005b68:	d4cfd0ef          	jal	ra,800030b4 <z_find_first_thread_to_unpend>
80005b6c:	00050413          	mv	s0,a0
	if (thread != NULL) {
80005b70:	04050063          	beqz	a0,80005bb0 <z_impl_k_timer_stop+0x78>
		z_unpend_thread_no_timeout(thread);
80005b74:	e2cfd0ef          	jal	ra,800031a0 <z_unpend_thread_no_timeout>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005b78:	00d44783          	lbu	a5,13(s0)
80005b7c:	01f7f793          	andi	a5,a5,31
80005b80:	00079a63          	bnez	a5,80005b94 <z_impl_k_timer_stop+0x5c>
	if (z_is_thread_ready(thread)) {
80005b84:	01842783          	lw	a5,24(s0)
80005b88:	00079663          	bnez	a5,80005b94 <z_impl_k_timer_stop+0x5c>
		z_add_thread_to_ready_q(thread);
80005b8c:	00040513          	mv	a0,s0
80005b90:	c59fd0ef          	jal	ra,800037e8 <z_add_thread_to_ready_q>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005b94:	00800513          	li	a0,8
80005b98:	30053573          	csrrc	a0,mstatus,a0

	if (pending_thread != NULL) {
		z_ready_thread(pending_thread);
		z_reschedule_unlocked();
	}
}
80005b9c:	00812403          	lw	s0,8(sp)
80005ba0:	00c12083          	lw	ra,12(sp)
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80005ba4:	00857513          	andi	a0,a0,8
80005ba8:	01010113          	addi	sp,sp,16
80005bac:	fc4fd06f          	j	80003370 <z_reschedule_irqlock>
80005bb0:	00c12083          	lw	ra,12(sp)
80005bb4:	00812403          	lw	s0,8(sp)
80005bb8:	01010113          	addi	sp,sp,16
80005bbc:	00008067          	ret

80005bc0 <z_impl_k_timer_status_get>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_timer_stop, K_OBJ_TIMER, struct k_timer *);
#endif

u32_t z_impl_k_timer_status_get(struct k_timer *timer)
{
80005bc0:	fe010113          	addi	sp,sp,-32
80005bc4:	00812c23          	sw	s0,24(sp)
80005bc8:	01212823          	sw	s2,16(sp)
80005bcc:	00112e23          	sw	ra,28(sp)
80005bd0:	00912a23          	sw	s1,20(sp)
80005bd4:	01312623          	sw	s3,12(sp)
80005bd8:	00050913          	mv	s2,a0
80005bdc:	00800413          	li	s0,8
80005be0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005be4:	800074b7          	lui	s1,0x80007
80005be8:	31448513          	addi	a0,s1,788 # 80007314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007315>
	key = (mstatus & SOC_MSTATUS_IEN);
80005bec:	00847413          	andi	s0,s0,8
80005bf0:	ec1fe0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005bf4:	02051e63          	bnez	a0,80005c30 <z_impl_k_timer_status_get+0x70>
80005bf8:	800079b7          	lui	s3,0x80007
80005bfc:	800075b7          	lui	a1,0x80007
80005c00:	80007537          	lui	a0,0x80007
80005c04:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005c08:	04e00693          	li	a3,78
80005c0c:	b6498613          	addi	a2,s3,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005c10:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005c14:	e58fc0ef          	jal	ra,8000226c <printk>
80005c18:	80007537          	lui	a0,0x80007
80005c1c:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80005c20:	e4cfc0ef          	jal	ra,8000226c <printk>
80005c24:	04e00593          	li	a1,78
80005c28:	b6498513          	addi	a0,s3,-1180
80005c2c:	e7cfc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005c30:	31448513          	addi	a0,s1,788
80005c34:	ed5fe0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005c38:	31448513          	addi	a0,s1,788
	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t result = timer->status;
80005c3c:	02492983          	lw	s3,36(s2)

	timer->status = 0U;
80005c40:	02092223          	sw	zero,36(s2)
80005c44:	e95fe0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80005c48:	02051e63          	bnez	a0,80005c84 <z_impl_k_timer_status_get+0xc4>
80005c4c:	800074b7          	lui	s1,0x80007
80005c50:	800075b7          	lui	a1,0x80007
80005c54:	80007537          	lui	a0,0x80007
80005c58:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80005c5c:	06100693          	li	a3,97
80005c60:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005c64:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005c68:	e04fc0ef          	jal	ra,8000226c <printk>
80005c6c:	80007537          	lui	a0,0x80007
80005c70:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80005c74:	df8fc0ef          	jal	ra,8000226c <printk>
80005c78:	06100593          	li	a1,97
80005c7c:	b6448513          	addi	a0,s1,-1180
80005c80:	e28fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005c84:	30042473          	csrrs	s0,mstatus,s0
	k_spin_unlock(&lock, key);

	return result;
}
80005c88:	01c12083          	lw	ra,28(sp)
80005c8c:	01812403          	lw	s0,24(sp)
80005c90:	00098513          	mv	a0,s3
80005c94:	01412483          	lw	s1,20(sp)
80005c98:	01012903          	lw	s2,16(sp)
80005c9c:	00c12983          	lw	s3,12(sp)
80005ca0:	02010113          	addi	sp,sp,32
80005ca4:	00008067          	ret

80005ca8 <z_impl_k_timer_status_sync>:
Z_SYSCALL_HANDLER1_SIMPLE(k_timer_status_get, K_OBJ_TIMER, struct k_timer *);
#endif

u32_t z_impl_k_timer_status_sync(struct k_timer *timer)
{
	__ASSERT(!z_is_in_isr(), "");
80005ca8:	800077b7          	lui	a5,0x80007
80005cac:	4fc7a783          	lw	a5,1276(a5) # 800074fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074fd>
{
80005cb0:	fe010113          	addi	sp,sp,-32
80005cb4:	01312623          	sw	s3,12(sp)
80005cb8:	00112e23          	sw	ra,28(sp)
80005cbc:	00812c23          	sw	s0,24(sp)
80005cc0:	00912a23          	sw	s1,20(sp)
80005cc4:	01212823          	sw	s2,16(sp)
80005cc8:	00050993          	mv	s3,a0
	__ASSERT(!z_is_in_isr(), "");
80005ccc:	02078e63          	beqz	a5,80005d08 <z_impl_k_timer_status_sync+0x60>
80005cd0:	80007437          	lui	s0,0x80007
80005cd4:	800075b7          	lui	a1,0x80007
80005cd8:	80007537          	lui	a0,0x80007
80005cdc:	d7458593          	addi	a1,a1,-652 # 80006d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d75>
80005ce0:	0ba00693          	li	a3,186
80005ce4:	01c40613          	addi	a2,s0,28 # 8000701c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000701d>
80005ce8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005cec:	d80fc0ef          	jal	ra,8000226c <printk>
80005cf0:	80007537          	lui	a0,0x80007
80005cf4:	d8c50513          	addi	a0,a0,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
80005cf8:	d74fc0ef          	jal	ra,8000226c <printk>
80005cfc:	0ba00593          	li	a1,186
80005d00:	01c40513          	addi	a0,s0,28
80005d04:	da4fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005d08:	00800413          	li	s0,8
80005d0c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005d10:	800074b7          	lui	s1,0x80007
80005d14:	31448513          	addi	a0,s1,788 # 80007314 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007315>
	key = (mstatus & SOC_MSTATUS_IEN);
80005d18:	00847413          	andi	s0,s0,8
80005d1c:	d95fe0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005d20:	02051e63          	bnez	a0,80005d5c <z_impl_k_timer_status_sync+0xb4>
80005d24:	80007937          	lui	s2,0x80007
80005d28:	800075b7          	lui	a1,0x80007
80005d2c:	80007537          	lui	a0,0x80007
80005d30:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005d34:	04e00693          	li	a3,78
80005d38:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005d3c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005d40:	d2cfc0ef          	jal	ra,8000226c <printk>
80005d44:	80007537          	lui	a0,0x80007
80005d48:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80005d4c:	d20fc0ef          	jal	ra,8000226c <printk>
80005d50:	04e00593          	li	a1,78
80005d54:	b6490513          	addi	a0,s2,-1180
80005d58:	d50fc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005d5c:	31448513          	addi	a0,s1,788
80005d60:	da9fe0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t result = timer->status;
80005d64:	0249a903          	lw	s2,36(s3)

	if (result == 0U) {
80005d68:	06091e63          	bnez	s2,80005de4 <z_impl_k_timer_status_sync+0x13c>
		if (!z_is_inactive_timeout(&timer->timeout)) {
80005d6c:	0009a783          	lw	a5,0(s3)
80005d70:	06078a63          	beqz	a5,80005de4 <z_impl_k_timer_status_sync+0x13c>
			/* wait for timer to expire or stop */
			(void)z_pend_curr(&lock, key, &timer->wait_q, K_FOREVER);
80005d74:	00040593          	mv	a1,s0
80005d78:	fff00693          	li	a3,-1
80005d7c:	01098613          	addi	a2,s3,16
80005d80:	31448513          	addi	a0,s1,788
80005d84:	9acfe0ef          	jal	ra,80003f30 <z_pend_curr>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005d88:	00800413          	li	s0,8
80005d8c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005d90:	31448513          	addi	a0,s1,788
	key = (mstatus & SOC_MSTATUS_IEN);
80005d94:	00847413          	andi	s0,s0,8
80005d98:	d19fe0ef          	jal	ra,80004ab0 <z_spin_lock_valid>
80005d9c:	02051e63          	bnez	a0,80005dd8 <z_impl_k_timer_status_sync+0x130>
80005da0:	80007937          	lui	s2,0x80007
80005da4:	800075b7          	lui	a1,0x80007
80005da8:	80007537          	lui	a0,0x80007
80005dac:	b7c58593          	addi	a1,a1,-1156 # 80006b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b7d>
80005db0:	04e00693          	li	a3,78
80005db4:	b6490613          	addi	a2,s2,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005db8:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005dbc:	cb0fc0ef          	jal	ra,8000226c <printk>
80005dc0:	80007537          	lui	a0,0x80007
80005dc4:	b9450513          	addi	a0,a0,-1132 # 80006b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b95>
80005dc8:	ca4fc0ef          	jal	ra,8000226c <printk>
80005dcc:	04e00593          	li	a1,78
80005dd0:	b6490513          	addi	a0,s2,-1180
80005dd4:	cd4fc0ef          	jal	ra,800022a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005dd8:	31448513          	addi	a0,s1,788
80005ddc:	d2dfe0ef          	jal	ra,80004b08 <z_spin_lock_set_owner>

			/* get updated timer status */
			key = k_spin_lock(&lock);
			result = timer->status;
80005de0:	0249a903          	lw	s2,36(s3)
		}
	} else {
		/* timer has already expired at least once */
	}

	timer->status = 0U;
80005de4:	0209a223          	sw	zero,36(s3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005de8:	31448513          	addi	a0,s1,788
80005dec:	cedfe0ef          	jal	ra,80004ad8 <z_spin_unlock_valid>
80005df0:	02051e63          	bnez	a0,80005e2c <z_impl_k_timer_status_sync+0x184>
80005df4:	800074b7          	lui	s1,0x80007
80005df8:	800075b7          	lui	a1,0x80007
80005dfc:	80007537          	lui	a0,0x80007
80005e00:	bac58593          	addi	a1,a1,-1108 # 80006bac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bad>
80005e04:	06100693          	li	a3,97
80005e08:	b6448613          	addi	a2,s1,-1180 # 80006b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b65>
80005e0c:	adc50513          	addi	a0,a0,-1316 # 80006adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006add>
80005e10:	c5cfc0ef          	jal	ra,8000226c <printk>
80005e14:	80007537          	lui	a0,0x80007
80005e18:	bc450513          	addi	a0,a0,-1084 # 80006bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bc5>
80005e1c:	c50fc0ef          	jal	ra,8000226c <printk>
80005e20:	06100593          	li	a1,97
80005e24:	b6448513          	addi	a0,s1,-1180
80005e28:	c80fc0ef          	jal	ra,800022a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005e2c:	30042473          	csrrs	s0,mstatus,s0
	k_spin_unlock(&lock, key);

	return result;
}
80005e30:	01c12083          	lw	ra,28(sp)
80005e34:	01812403          	lw	s0,24(sp)
80005e38:	00090513          	mv	a0,s2
80005e3c:	01412483          	lw	s1,20(sp)
80005e40:	01012903          	lw	s2,16(sp)
80005e44:	00c12983          	lw	s3,12(sp)
80005e48:	02010113          	addi	sp,sp,32
80005e4c:	00008067          	ret

80005e50 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80005e50:	ff010113          	addi	sp,sp,-16
80005e54:	00812423          	sw	s0,8(sp)
80005e58:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005e5c:	80007437          	lui	s0,0x80007
80005e60:	800074b7          	lui	s1,0x80007
{
80005e64:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005e68:	2b840413          	addi	s0,s0,696 # 800072b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072b9>
80005e6c:	2b848493          	addi	s1,s1,696 # 800072b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072b9>
80005e70:	00946e63          	bltu	s0,s1,80005e8c <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80005e74:	00c12083          	lw	ra,12(sp)
80005e78:	00812403          	lw	s0,8(sp)
80005e7c:	00412483          	lw	s1,4(sp)
80005e80:	00000513          	li	a0,0
80005e84:	01010113          	addi	sp,sp,16
80005e88:	00008067          	ret
80005e8c:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80005e90:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80005e94:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80005e98:	00f42c23          	sw	a5,24(s0)
80005e9c:	c7dfb0ef          	jal	ra,80001b18 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005ea0:	01c40413          	addi	s0,s0,28
80005ea4:	fcdff06f          	j	80005e70 <init_static_pools+0x20>

80005ea8 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005ea8:	00008067          	ret
