"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateClientCode = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const util_1 = require("projen/lib/util");
/**
 * Generate client code by invoking the root generate script
 */
exports.generateClientCode = (options) => {
    util_1.exec(`./generate --spec-path ${options.specPath} --output-path ${options.outputPath} --package-name ${options.packageName} --language ${options.language}`, {
        cwd: path.resolve(__dirname, "..", "..", "..", "..", "scripts", "generators"),
    });
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvcHJvamVjdC9jb2RlZ2VuL2NvbXBvbmVudHMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7Ozs7Ozs7Ozs7Ozs7O3dIQWN3SDtBQUN4SCw2QkFBNkI7QUFDN0IsMENBQXVDO0FBeUJ2Qzs7R0FFRztBQUNVLFFBQUEsa0JBQWtCLEdBQUcsQ0FBQyxPQUFrQyxFQUFFLEVBQUU7SUFDdkUsV0FBSSxDQUNGLDBCQUEwQixPQUFPLENBQUMsUUFBUSxrQkFBa0IsT0FBTyxDQUFDLFVBQVUsbUJBQW1CLE9BQU8sQ0FBQyxXQUFXLGVBQWUsT0FBTyxDQUFDLFFBQVEsRUFBRSxFQUNySjtRQUNFLEdBQUcsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUNmLFNBQVMsRUFDVCxJQUFJLEVBQ0osSUFBSSxFQUNKLElBQUksRUFDSixJQUFJLEVBQ0osU0FBUyxFQUNULFlBQVksQ0FDYjtLQUNGLENBQ0YsQ0FBQztBQUNKLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblxuIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuXG4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuXG4gaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG5cbiBVbmxlc3MgcmVxdWlyZWQgYnkgYXBwbGljYWJsZSBsYXcgb3IgYWdyZWVkIHRvIGluIHdyaXRpbmcsIHNvZnR3YXJlXG4gZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9ucyBhbmRcbiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiAqL1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0IHsgZXhlYyB9IGZyb20gXCJwcm9qZW4vbGliL3V0aWxcIjtcbmltcG9ydCB7IENsaWVudExhbmd1YWdlIH0gZnJvbSBcIi4uLy4uL2xhbmd1YWdlc1wiO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGdlbmVyYXRpbmcgdGhlIGNsaWVudCBjb2RlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgR2VuZXJhdGVDbGllbnRDb2RlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgbGFuZ3VhZ2UgdG8gZ2VuZXJhdGUgdGhlIGNsaWVudCBpblxuICAgKi9cbiAgcmVhZG9ubHkgbGFuZ3VhZ2U6IENsaWVudExhbmd1YWdlO1xuICAvKipcbiAgICogVGhlIHBhdGggb2YgdGhlIE9wZW5BUEkgc3BlYyB0byBnZW5lcmF0ZSB0aGUgY2xpZW50IGZvclxuICAgKi9cbiAgcmVhZG9ubHkgc3BlY1BhdGg6IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBkaXJlY3RvcnkgaW4gd2hpY2ggdGhlIGdlbmVyYXRlZCBjb2RlIHNob3VsZCBiZSBvdXRwdXRcbiAgICovXG4gIHJlYWRvbmx5IG91dHB1dFBhdGg6IHN0cmluZztcbiAgLyoqXG4gICAqIE5hbWUgZm9yIHRoZSBnZW5lcmF0ZWQgY29kZSBwYWNrYWdlXG4gICAqL1xuICByZWFkb25seSBwYWNrYWdlTmFtZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIEdlbmVyYXRlIGNsaWVudCBjb2RlIGJ5IGludm9raW5nIHRoZSByb290IGdlbmVyYXRlIHNjcmlwdFxuICovXG5leHBvcnQgY29uc3QgZ2VuZXJhdGVDbGllbnRDb2RlID0gKG9wdGlvbnM6IEdlbmVyYXRlQ2xpZW50Q29kZU9wdGlvbnMpID0+IHtcbiAgZXhlYyhcbiAgICBgLi9nZW5lcmF0ZSAtLXNwZWMtcGF0aCAke29wdGlvbnMuc3BlY1BhdGh9IC0tb3V0cHV0LXBhdGggJHtvcHRpb25zLm91dHB1dFBhdGh9IC0tcGFja2FnZS1uYW1lICR7b3B0aW9ucy5wYWNrYWdlTmFtZX0gLS1sYW5ndWFnZSAke29wdGlvbnMubGFuZ3VhZ2V9YCxcbiAgICB7XG4gICAgICBjd2Q6IHBhdGgucmVzb2x2ZShcbiAgICAgICAgX19kaXJuYW1lLFxuICAgICAgICBcIi4uXCIsXG4gICAgICAgIFwiLi5cIixcbiAgICAgICAgXCIuLlwiLFxuICAgICAgICBcIi4uXCIsXG4gICAgICAgIFwic2NyaXB0c1wiLFxuICAgICAgICBcImdlbmVyYXRvcnNcIlxuICAgICAgKSxcbiAgICB9XG4gICk7XG59O1xuIl19