# Generated by Django 4.0 on 2021-12-28 10:20

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='DingDingMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=64, null=True, verbose_name='Title')),
                ('content', models.TextField(verbose_name='Content')),
                ('at_mobiles', models.JSONField(blank=True, null=True, verbose_name='At Mobiles')),
                ('msgtype', models.CharField(choices=[('text', 'Text'), ('link', 'Link'), ('markdown', 'Markdown'), ('actionCard', 'ActionCard')], default='markdown', max_length=32, verbose_name='Message Type')),
                ('is_at_all', models.BooleanField(default=False, verbose_name='At All')),
                ('extra', models.JSONField(blank=True, null=True, verbose_name='API Kwargs')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
            ],
            options={
                'verbose_name': 'DingDing Message',
                'db_table': 'dingding_message',
            },
        ),
        migrations.CreateModel(
            name='EmailMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(max_length=128, verbose_name='Subject')),
                ('content', models.TextField(blank=True, null=True, verbose_name='Content')),
                ('sender', models.EmailField(default='webmaster@localhost', max_length=254, verbose_name='Sender')),
                ('receivers', models.JSONField(verbose_name='Receivers')),
                ('cc', models.JSONField(blank=True, null=True, verbose_name='CC')),
                ('content_subtype', models.CharField(default='text', max_length=32, verbose_name='Content Subtype')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
            ],
            options={
                'verbose_name': 'Email Message',
                'db_table': 'email_message',
            },
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('code', models.CharField(max_length=4, unique=True, verbose_name='Template Code')),
                ('title', models.CharField(blank=True, max_length=64, null=True, verbose_name='Title')),
                ('text', models.TextField(verbose_name='Template Text')),
                ('kwargs', models.JSONField(blank=True, null=True, verbose_name='Kwargs')),
            ],
            options={
                'verbose_name': 'Template',
                'db_table': 'template',
            },
        ),
        migrations.CreateModel(
            name='WebsocketMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=64, null=True, verbose_name='Title')),
                ('content', models.TextField(blank=True, null=True, verbose_name='Content')),
                ('groups', models.JSONField(verbose_name='Receive Groups')),
                ('msgtype', models.CharField(default='notify', max_length=32, verbose_name='Message Type')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
            ],
            options={
                'verbose_name': 'Websocket Message',
                'db_table': 'websocket_message',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('has_read', models.BooleanField(default=False, verbose_name='Read Or Not')),
                ('push_state', models.CharField(choices=[('ready', 'Ready'), ('sucess', 'Sucess'), ('failed', 'Failed')], default='ready', max_length=16)),
                ('etag', models.TextField(blank=True, null=True, verbose_name='Etag')),
                ('object_id', models.PositiveIntegerField()),
                ('notified_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
                ('content_type', models.ForeignKey(limit_choices_to={'model__in': ('DingDingMessage', 'WebsocketMessage', 'EmailMessage')}, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype', verbose_name='Message Type')),
                ('to', models.ManyToManyField(to=settings.AUTH_USER_MODEL, verbose_name='Receivers')),
            ],
            options={
                'verbose_name': 'Notification',
                'db_table': 'notification',
            },
        ),
    ]
